#!/bin/bash
if [ $# -ne 2 ]; then
   cat <<EOF
   ./gethist dir  nev
   a file   $dir/data is assumed to contain $nev event data
   e.g,   dir: /tmp/dpm/pp10GeV
          nev: 1e5
   output will be made in $dir
   data format:
      h  ....  (header; diff code etc)
#      1    2    3  4   5  6   7   8    9     10
      code subc chg pt  y  eta  KE  Pz XfKE   XfPz
      ...
      ...
      h  ... header  
EOF
   exit
fi
   
dir=$1
nev=$2
file=$dir/data

if [ -1 -gt  0 ]; then
#  Pi+
#  Pz > 0
awk '$1==4 && $3==1 && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/pi+.hist
#  X<0.1
awk '$1==4 && $3==1 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pi+log.hist

#  Pi0
awk '$1==4 && $3==0 && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/pi0.hist
#  X<0.1
awk '$1==4 && $3==0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pi0log.hist


#  Pi-
awk '$1==4 && $3<0  && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/pi-.hist
#  X<0.1
awk '$1==4 && $3<0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pi-log.hist


#  Kch
#  Pz > 0
awk '$1==5 && $3!=0 && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/Kch.hist
#  X<0.1
awk '$1==5 && $3!=0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/Kchlog.hist


#  K0
#  Pz > 0
awk '$1==5 && $3==0 && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/K0.hist
#  X<0.1
awk '$1==5 && $3==0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/K0log.hist



#  p
#  Pz > 0
awk '$1==6 && $3==1 && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/p.hist
#  X<0.1
awk '$1==6 && $3==1 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/plog.hist



#  n
#  Pz > 0
awk '$1==6 && $3==0 && $2< 0 && $8 > 0 {print $9}' $file | histo 0 0.01 $nev > $dir/n.hist
#  X<0.1
awk '$1==6 && $3==0 && $2<0 &&  $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/nlog.hist



#  p+n
#  Pz > 0
awk '$1==6 && $2< 0 && $8 > 0 {print $9}' $file | histo 0. 0.01 $nev > $dir/pn.hist
#  X<0.1
awk '$1==6 && $2<0 &&  $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pnlog.hist



fi
#  pbar
#  Pz > 0
awk '$1==6 && $3<0  && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/pbar.hist
#  X<0.1
awk '$1==6 && $3<0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pbarlog.hist

#  nbar
#  Pz > 0
awk '$1==6 && $2==1 && $3==0  && $8 > 0 {print $9}' $file | histo 0.0 0.01 $nev > $dir/nbar.hist
#  X<0.1
awk '$1==6 && $2==1 && $3==0 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/nbarlog.hist





