      subroutine cminTime2WebSec(obsdetxyz, ldep,  depidx,  awebmin)
      implicit none

!              constants thru Cosmos
            real*8 pi,          !  3.14..
     *             sqrtpi,      !  sqrt(pi)
     *             Torad,       !  if multiplied to deg  --> radian
     *             Todeg,       !  1/Torad
     *             c,           !  light velocity m/sec
     *             Infty,       !  infinty
     *             Togpcm2,     !  kg/m2 *Togpcm2 --> g/cm2
     *             Tokgpm2,     !  g/cm2 *Tokgpm2    --> kg/m2
     *             Tom,         !  cm *Tom  --> m
     *             Tocm,        !  m*Tocm  --> cm
     *             Tokgpm3,     !  g/cm3 * Tokgpm3 -->  kg/m3
     *             Togpcm3,     !  kg/m3 * Togpcm3 --> g/cm3
     *	           Tonsec,      !  sec *Tonsec --> nsec 
     *             Bcr,         !  Tesla. m^2c^3/eh = 4.414x10^13G=4. x10^9
     *             SyncConvR    !  alpha(mc^2/Lc). GeV/m. conv. rate of synch.r
       real*8 Avogn,            ! Avogadro #. /mol
     *        A2deninv          ! mfp * n* xs = 1;  mfp in kg/m2
                                ! xs in mb.  1/n = A2deninv*A  


        parameter(pi = 3.141592653589793238d0, 
     *    sqrtpi = 1.772453850905516d0, Torad = pi/180.d0, 
     *    Todeg = 180.d0/pi, c=2.998d8, Infty=1.d50, Tom = 1.d-2,
     *    Tocm = 1.d0/Tom,
     *    Togpcm2 = 0.1d0, Tokgpm2 = 1.d0/Togpcm2,
     *	  Tokgpm3 = Tokgpm2/Tom, Togpcm3 = 1.d0/Tokgpm3,
     *    Tonsec = 1.d9, Bcr = 4.414d9, SyncConvR=9.657d6)
       parameter (Avogn=6.0221415d23, A2deninv = 1.d28/Avogn)
!       real(8),parameter:: alfa= 1.0d0/137.035999139d0
						      


  

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   Parameters   needed  for the Launcher.
!
!	(->	------------------------------------

         integer ErrorOut    !2 Error output logical  dev number.
         character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
         character*128  CutOffFile   !1  Geomagnetic cut-off file
         character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
         character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
         character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
                                    !   Cosmos/Data/DPM/atmos.inp is assumed.  
         character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
         logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
         integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
         integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
         integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
         integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
         logical       Hidden         !1  Make T, if hidden parameters are to be written.
         integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
         integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
         character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'
                                   ! Normally  this may be blank. Then, standard atmosphere
                                   ! is employed.  If another data with the same format
                                   ! atmosphere model is available, it can be specified.
                                   !  If ATMOSPHERE is set to 3 in Zcondc.h, and AtmosFile
                                   !  is blank, you have to set NRL_period (see, for period,
                                   !  Cosmos/Import/NRL/Util/ or manual for NRL atmosphere). 
                                   !  latitude and longitude information is also used.  
                                   ! If AtmosFile is given, it is assumed NRL format
                                   ! atmosphere data and it is used.
                                   ! For such NRL data, see also Cosmos/Import/NRL/Util/
        integer:: NRL_period       !2 see Cosmos/Import/NRL/Util or manual for NRL atmsophere
        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


!	<-)	-------------------------------------
         common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), NRL_period(4),
     *  Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************



!** MYEFIELD is not used now (Dec.3,2019).  Description below
! is obso.  To use cmyEfield.f, try  UseSpecIntF.sh
!  Effect of HowEfield is the same. 
!
!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)
! #undef MYEFIELD 
!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3
!   #define ATMOSPHERE 3

!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence

          union
              map

                  real*8 r(3)

              endmap
              map
                  real*8 x, y, z  !  x,y,z in m
              endmap          ! 'xyz'
              map 
                  real*8 lat,    ! latitude in deg.  + is to the north.
     *                  long,    ! longitude in deg. + is to the east.
     *                     h     ! height in m       
              endmap      !  'llh'
              map
                  real*8 theta,      ! polar angle
     *                   phi,        ! azimuthal angle
     *                   radius      ! radial distance
              endmap         !   'sph'
          endunion

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)

         union
              map

                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


              endmap          !   
              map
                 real(8):: F(3)
              endmap           ! same as x,y,z
              
              map
                  real*8 n,      ! north com.
     *                   e,      ! east comp.
     *                   d       ! down com.
              endmap             ! 'ned'   this is for geomag
              map
                  real*8 h,       ! horizontal comp.
     *                   v,       ! vertical comp.(down is +)
     *                   a        ! deflection angle (deg. east is +)

              endmap 
          endunion     

!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!          common variables used in tracking ptcls.
       integer ToInteract, ToBeObserved, Truncated, Dead,
     *         BorderL,  BorderH, AngleLimit
       parameter(ToInteract = 1, ToBeObserved = 2, Truncated = 3,
     *  BorderL = 4, BorderH =5,  Dead = 6, AngleLimit = 7)
       integer  BitPhotoElec, BitPhoton,
     *    BitElectron, BitPositron, BitProton,
     *    BitNeutron, BitAntiNuc, BitDecay,  BitOther, BitEconsv
       parameter( BitPhotoElec=1, BitPhoton=2, BitElectron=3, 
     *  BitPositron=3, BitProton=4, BitNeutron=5, BitAntiNuc=6,
     *  BitDecay=7, BitOther=8, BitEconsv=9  )

       integer MaxInte
       parameter(MaxInte = 6)  !  Max number of kinds of interactions a particle can
                               !  take. (such as brems, knockon, anihilation)
       type intinf      ! Interaction information
         sequence
           real*8  thickness   ! in kg/m2 set if decay is F
           real*8  length      ! in m, set if decay is T.  or eventually by cfixProc
           character*8 process ! process id string such as brems, pair
            logical decay       ! if decay, T, else F
       end type intinf
!          define array of intinf
       type(intinf) IntInfArray(MaxInte)
!
       type(track):: TrackBefMove  ! track before moved       	
       type(track):: MovedTrack      ! to contain track moved
       type(coord):: Offset        ! the primary is directed to 
!                                     deepest detector origin + Offset
!                                     (in 'xyz')
       type(track):: Zfirst ! to keep first interaction info. V7.0
!       real*8 Zfirst       ! to keep first interaction slant depth
       integer MoveStat    ! status code for moving a particle
       integer NumberOfInte ! Number of different kind of interactions 
                            ! considered for the current particle.
       integer ProcessNo   ! The process really happend is the
                            ! ProcessNo-th process in  IntInfArray.
         logical ObserveAS     ! made to be T, if AS is to be generated
        logical Upgoing     ! if primary is going upward, made to be t
        logical UseTbl       ! becomes T, 
                            ! if length <--> thickness conv. is by table
         real*8  EminAS      ! minimum energy of e for AS generation.
         real*8  EasWait     ! for AS generation, must wait until e 
                            ! energy becomes < EasWait
        real*8 EnergyLoss   !  energy loss 
        real*8 Upsilon      ! Upsilon value 
        real*8 Xai          ! Xai value B x Eg/m /2
        real*8 maxstep(0:50 +1) ! used to cut the path
                ! 1/5 of the depth step. this is necessary cond.
         real*8  KEmin         ! min kinetic energy to be tracked
        real*8  KEminCas      ! //          (for em-cascade)
        real*8  KEmin2        ! min kinetic energy to be tracked.  for skeleton/flesh use.
        real*8  KEminCas2     ! for skeleton/flesh use.
         real*8  Ethin(4)      ! Thin sampling threshold and max weight.  for e/g and hadrons/muons
         real*8 Beta  !  v/c for MovedTrack; given if TimeStrucrue=T.
        type(magfield):: Mag
         integer MaxPtcl
        logical FromEpics     !  to control muon iteraction (pair,brem,nuci)
                              !  must be made t, when Epics treats muon.
                              !  if Cosmos uses Epics, this must be made to
                              !  be t/f depending on Epics mode, or Cosmos mode




         parameter (

     *     MaxPtcl = 35000



     *         )   ! max # of ptcls producable in coll.
        type(ptcl):: Pwork(MaxPtcl)  ! working array to store ptcls.
         integer Nproduced   ! no. of ptcls produced and stored in Pwork.
        integer Nstacked    ! no. of ptcls stacked. If ThinSampling=F,
                            ! same as Nproduced.  Nstacked <= Nproduced
         real*8  MuonPolarization  ! muon polarization value.
        integer FirstColA, FirstColZ
        real(8)::FirstColXs
!
       common /Ztrackv/Pwork, IntInfArray, TrackBefMove,
     *  MovedTrack, Zfirst, Offset,
     *  Mag, MuonPolarization,  EminAS, EasWait,
     *  EnergyLoss,  KEmin, KEminCas, Beta, 
     *  KEmin2, KEminCas2, Ethin, Upsilon, Xai, 
     *  maxstep,
     *  ObserveAS, Nproduced, Nstacked,
     *  MoveStat,  NumberOfInte, ProcessNo, 
     *  Upgoing, UseTbl, FirstColXs,
     *  FromEpics, FirstColA, FirstColZ





       real*8 TargetMassN  ! Number weighted average target mass number.  fixed value
       real*8 TargetAtomicN   !The same for average Z of the target.   fixed value
       real*8 TargetZ2        ! <Z^2> of the target
!       integer TargetNucleonNo  !  target nucleon number at a collision. sampled at each collision
       real*8 TargetZ2_3rd  ! <Z>^(2/3).  Since <Z> is almost same as 7 or 8
!                    we simpley use this as <Z^2/3>
       real*8 TargetZ1_3rd  !  <Z>^(1/3).  same reason

!       integer TargetProtonNo  !  target proton number  //     //
!       real*8  TargetXs   ! inelastic xs for this target

       common /Zair/
     *  TargetMassN, TargetAtomicN, TargetZ2, TargetZ2_3rd,  
     *  TargetZ1_3rd
!     *, TargetXs, TargetNucleonNo, TargetProtonNo
!   last 3 moved to modXsecMedia 
          save /Zair/














!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!
!	(->	------------------------------------------

         integer Charge2heavyG	!2  charge of heavy $\rightarrow$  heavy group index conversion array.
        integer HeavyG2massN    !2  heavy group index $\rightarrow$     mass number conversion array.
         integer HeavyG2charge	!2  heavy group index $\rightarrow$     charge of heavy conversion array.
        integer HeavyG2code     !2  heavy group index $\rightarrow$     particle code conversion array.
        integer Code2massN      !2  particle code $\rightarrow$     mass number conversion array.
        integer Code2heavyG	!2  particle code $\rightarrow$     heavy group index conversion array.
        real*8  FragmentTbl	!2  tbl(i,j)=$<$Number$>$  of frag. j when a heavy of heavy group index i
                                !    breaks up at air.
        real*8  PtAvNonInteNuc  !2  $<$Pt$>$  of non interacting nucleons.
         real*8  PtAvFrag        !2  $<$Pt$>$  of heavy fragments.
         character*4 HeavyG2symbol !2   heavy group index $\rightarrow$  'Fe' etc conversion array.
          integer HowIntNuc       !2 If 0, the  number of interacting nucleons among a projectile heavy nucleus is 
                                 !  determined as the number of first collision of each interacting nucleon inside 
                                ! the  nucleus.  If 1, the number is determined as the total number of collisions 
                                !   including successive interactions. Default is 1. (There is uncertaninity in
                                !  interpretation of the formula; value 1 gives larger number of interacting
                                !  nucleons.)


 
!	<-)	--------------------------------------
        

         common /Zheavyc/
     *   PtAvNonInteNuc, PtAvFrag,
     *   FragmentTbl(maxHeavyG, maxHeavyG), 
     *	 Charge2heavyG(maxHeavyCharge),
     *   HeavyG2massN(maxHeavyG), HeavyG2charge(maxHeavyG),
     *   HeavyG2code(maxHeavyG), Code2massN(khvymax),
     *   Code2heavyG(khvymax), HowIntNuc
        common /Zheavycc/ HeavyG2symbol(maxHeavyG)



         

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!       Zobs.h     header file for observation sites definition
!
           integer maxNoOfSites, maxNoOfASSites, horizontal,
     *     perpendicular, notUsed, spherical
       parameter (

     *    maxNoOfSites = 50,




     *    maxNoOfASSites=50,



     *    notUsed = 0,           ! detector plane is not used
     *    horizontal = 1,        ! detector is horizontal
     *    perpendicular = 2,      ! detector is pependicular to 1ry.
     *    spherical = 3          ! detector is cocentric sphere as the earth
     *		      )


!       Zobsvp.h---parameters to be given by input.
!       This must be preceded by Zobs.h

!	(->	---------------------------------------------------

         real*8  HeightList  !1  Height of observation levels in m. This is  made from DepthList internally. 
                            ! I.e., this one is usually not an input. However, if the DepthList values are 
                            ! negative, this is used as input and corresponding DepthList is computed internally.
        real*8  DepthList   !1	Depth List of Observation level in kg/m$^2$. If $< 0$, HeightList has priority. 
                            !  (See HeightList)
        real*8  ASHeightList	!1  This is HeightList for Air Shower observ.  Used only if Generate contains
                            !  "as". See  HeightList.
        real*8  ASDepthList     !1  This is DepthList for AS observation.  Used only if Generate contains 
                            ! "as". See DepthList.
        real*8  LatitOfSite     !1  Latitude of the deepest observation level in degree.  East is positive.
        real*8  LongitOfSite    !1  Longitude of the deepest observation level in degree.  North is positive.

     	real*8  DtGMT           !1  Difference of the local time of the observation place from GMT (hour).
         real*8  YearOfGeomag    !1  Like 1999.5. Year when Geomagnetic field is to be calculated.
         integer ObsPlane        !1    How to observe particles. \newline
                                !    0$ \Rightarrow $ no detector plane is used for observation. BorderHeightL
                                !    and BorderHeightH are used to detect particles. This is for, say, neutrino
                                !    observation. See BorderHeight{L,H}. However, the primary is directed to
                                !    the deepest depth.  \newline
                                !    1,-1$ \Rightarrow $ detector at the observation place is horizontal. Note 
                                !    that the horizontal means not tangential plane, but rather a spherical surface \newline
                                !    2,-2$ \Rightarrow $ detector is perpendicular to the primary. \newline
                                !    3$ \Rightarrow $ spherical observation. See text. \newline
                                !    For ObsPlane={1,2}, the user observation routine will receive coordinate values in
                                !    the corresponding detector system. However, if it is 0, 3 or negative, Exyz values
                                !    are obtained.
        integer NoOfSites2    !2   No of Sites for particle observation; not to be touched; for skeleton/flesh use.
         real*8 XaxisFromSouth   !2 Angle between the horizontal detector X-axis and the south(deg). + is counter
                                ! clockwise.  If $|$XaxisFromSouth$| > 360$, it is computed so that the direction is
                                ! to the magnetic east at the deepest observation point. Default is 361.
!	<-)	--------------------------------------------

   

        common /Zobsc/
     *	 HeightList(maxNoOfSites),
     *   DepthList(maxNoOfSites),
     *   ASHeightList(maxNoOfASSites),
     *   ASDepthList(maxNoOfASSites),
     *   LatitOfSite, LongitOfSite, DtGMT,
     *   XaxisFromSouth, YearOfGeomag,
     *   ObsPlane, NoOfSites2


!           need Zcoord.h  Zobs.h  Zpos.h Zmagfield.h
         integer NoOfSites           ! No of particle observation sites
        integer NoOfASSites
!          
         real*8 CosLatitude          ! oos of Latitude of deepest obs. site
        real*8 SinLatitude          ! sin
        real*8 CosLongitude         ! cos of Longitude
        real*8 SinLongitude         ! sin of ..

        type(coord):: DetZaxis     ! detector's Z axis in 'xyz' system
        type(coord):: DetXaxis     !  //        X    // 
        type(coord):: DetYaxis     !  //        Y    // 

        type(coord):: Xprimary     ! primary system x axis in 'xyz'
        type(coord):: Yprimary     ! primary system y axis in 'xyz'
        type(coord):: Zprimary     ! primary system z axis in 'xyz'
                                    ! these are computed in cprimxyz in
                                    ! ciniTracking in ceventLoop
        real(8)::Txyz2prim(3,3)    ! matrix to transform vector in
                              ! E-xyz into primary system
                  ! vector must be given from the oriign of
                  ! the detecor
        real(8)::Tprim2xyz(3,3)  ! inverse of Txyz2prim
        real(8)::Txyz2det(3,3) ! xyz to detector system transform mat
        real(8)::Tdet2xyz(3,3) ! inverse of above
        type(coord):: PolarInjPos  ! polar angle of the injection point in xyz.

         type(magfield):: MagfieldNED     ! mag in 'ned' at deepest obs. site
        type(magfield):: MagfieldHVA     ! mag in 'hva' at //. both in T.
        type(magfield):: MagfieldXYZ     ! mag in 'xyz' at //. both in T.

         type site
           sequence
               type(position):: pos
               real*8  zpl           ! z value in 1ry system
               real*8  mu
               real*8  minitime
         end type site 
         type assite
           sequence
               type(position):: pos
               real*8  zpl 
               real*8  mu             ! Moliere Unit
               real*8  esize          ! electron size
               real*8  age            ! size weighted age
         end type assite

          type(site):: ObsSites(0:maxNoOfSites+1)
         type(assite):: ASObsSites(maxNoOfASSites)
!            to store Ne, age of a component shower for an electron
         real*8 CompASNe(maxNoOfASSites), CompASAge(maxNoOfASSites)

         common /Zobsvc/  ASObsSites,  ObsSites,
     *     MagfieldNED, MagfieldHVA, MagfieldXYZ, 
     *     CompASNe, CompASAge,
     *     DetZaxis, DetXaxis, DetYaxis,
     *     Xprimary, Yprimary, Zprimary,
     *     Txyz2det, Tdet2xyz, Txyz2prim, Tprim2xyz,
     *     PolarInjPos, 
     *     CosLatitude, SinLatitude, CosLongitude, SinLongitude,
     *     NoOfSites,    NoOfASSites

!   ###include  "Zmaxdef.h"
!   ###include  "Ztrack.h"
          integer Max_stack_size
          parameter (

     *    Max_stack_size = 50000



     *    )
          integer Stack_pos
      type(track):: Stack(Max_stack_size)
      common /Zstack/ Stack, Stack_pos

       integer nsites ! # of sites to be histogramed.
       real bin, rmin  !  rbin in log10.  rmin. for lateral in Moliere u.
       integer binw
       parameter (bin=0.1, rmin=0.01)
       parameter (nsites=3)  ! max number of histogram layers
       
       integer histdep(nsites)  !  histdep(j) = k >0 ==> at depth k, histograminng 
                                !  is tried.

!            These must be double.  because addition is done 1 by 1
!            and reach 10^7 or more.(at least  Ng, Ne, at E0
!            >10^16eV.)
       real*8  SumEloss(maxNoOfSites),
     *  Ng(maxNoOfSites), Ne(maxNoOfSites),
     *  Nmu(maxNoOfSites), Nhad(maxNoOfSites)



       logical tkarspec
       logical tkrtspec
       logical tkweb
       character*192 basefilename, basefilename2, filename

       integer fnoT, fnoL,  fnoB, fnoN
       integer nrbin, nfai
       parameter ( nrbin = 42, nfai=12, 
     *   fnoT=42, fnoL=43, fnoN=44, fnoB=45) 
       real*8  rbin(nrbin), 
     * webmin(nrbin,  nfai, MaxNoOfSites)
       real dErfai(nrbin, nfai, MaxNoOfSites)
       real dECent( MaxNoOfSites )
       real*8 dfai
       parameter ( dfai = 360.d0/nfai )


       common /Zprivatec/   Ng, Ne, Nmu, Nhad, SumEloss,
     *   rbin,   dErfai,
     *   histdep,  tkrtspec, tkarspec, tkweb

       common/ Zprivatec2/ basefilename


      integer ldep ! layer number of the observation depth
      integer depidx ! layer index for web array
      type(coord):: obsdetxyz  ! input. observation detector axis in E-xyz
!                        = ObsSites(loc).pos.xyz  where  loc is the
!          observation layer number. 
      
      real*8 awebmin(nrbin, nfai, MaxNoOfSites) ! output. to store min time (ns)
                                 ! for each web sector.
      real*8 r, hdr, Ra, rc
      type(track):: inci
      type(coord):: angle
      integer i, j, ii, jj
      real*8 faimin,  fai, R0, Rbot, rmu, cosz
      data faimin/-15.0d0/
      type(coord):: xyz, oxyz, effpos
      real*8  temp,  dtemp, leng
      integer it



      call cqIncident(inci, angle)  ! we may better to use the first
                     ! collision point but not so easy to get it
                     ! since this is called before collision
      
      effpos = inci%pos%xyz    ! default is 100 km

!!!      effpos.z = 20.d3  ! so we use 20km instead
!         assume  web sector is aligned so that incident direcion
!         is on fai=0 of the web sector. 
!         sinz cosf= dirx
!         sinz sinf= diry
!         cosz = dirz 
!          tanf = diry/dirx;  fai=atan2(diry,dirx)
!          L dirx =x L diry =y  L dirz = z
!          L = z/dirz =
!      cosz = inci.vec.coszenith ~ -angle.r(3)

!                 Top view
!                       / this is web sector fai=0       
!                      / 
!                     /
!                    /      so fai* = fai-fai0
!                   / should be used as azimuthal angle of
!                  /           ptcls.  Therefore  we use
!                 /  fai0      effpos  as below
!               ------------------------> mag east
!
!      L cosz = effpos.z
!      L sinz = effpos.x
!      effpos.y = 0.
!

      leng = effpos%z/(-angle%r(3))
      effpos%x = sqrt(1.d0-angle%r(3)**2)*leng
      effpos%y = 0.
!          convert it to xyz system
      call cdet2xyz(obsdetxyz, effpos,  effpos)

      xyz%z = 0.
      xyz%x = 0.
      xyz%y = 0.
      call cdet2xyz(obsdetxyz, xyz, oxyz)
!/////////////
!      write(0,*)  ' layer =', ldep
!      write(0,*)  ' obsdetxyx=',obsdetxyz.x,
!     *       obsdetxyz.y,   obsdetxyz.z
!      write(0,*) ' center =', oxyz.x, oxyz.y, oxyz.z
!      write(0,*) ' effposx,y,x=',effpos.x,
!     *effpos.y, effpos.z
!//////////////

      R0 = sqrt( (oxyz%x-effpos%x)**2 +
     *           (oxyz%y-effpos%y)**2 +
     *           (oxyz%z-effpos%z)**2 )
!////////////
!      write(0,*) ' R0=', R0
!///////////

      call cgetMoliereU( ObsSites(ldep)%pos%depth, cosz, rmu)
!//////////
!      write(0,*)  ' mu=', rmu
!///////////

      hdr = 10.**(bin/2.)

      do i = 1, nrbin
         rc = rbin(i) * rmu ! in m
         do j = 1, nfai
            Rbot = 10.d10
!               for all web sectors examine 4 corners
            do ii = 1, 2
!                rbin is the center of the web sector in r direction (log10 center).
              if(ii .eq.  1)  then
                 r = rc/hdr
              else
                 r = rc*hdr
              endif
              do jj = j, j+1
                 fai = faimin + (jj-1)*dfai
                 xyz%x = r*cos(fai*ToRad)
                 xyz%y = r*sin(fai*Torad)
                 call cdet2xyz(obsdetxyz, xyz, oxyz)
!                     *
!                    * ^
!                   *  ^
!                  *
!              R0 *     ^  Ra
!                *
!               *        
!              *         ^  
                 Ra = sqrt( (oxyz%x-effpos%x)**2 +
     *                 (oxyz%y-effpos%y)**2 +
     *                 (oxyz%z-effpos%z)**2 )
                  if( Ra-R0 .lt. Rbot ) Rbot = Ra-R0
               enddo
            enddo  ! for a given fai bi
!/////////////
!            if(i .gt. 20 .and. j. eq. 1) then
!               write(0,*) " ridx=",i, " Rbot=", Rbot
!            endif
!///////////
!/////////////
!            Rbot may not be real mininum if incident axis lies
!            on the sector. for safety  25 % correction.  in n sec
            temp = 0.35-0.1*(i/30.)
            dtemp =1.d9* ( Rbot - temp* abs(Rbot) )/c  ! ns

            awebmin(i,j,depidx) = dtemp   
!////////////////////
!            if(i .le. 3 .and. j .le. 2) then
!               write(0,*) 'i,j=',i,j, ' min t=', dtemp
!            endif
!///////////////
         enddo
      enddo


      end

