!! #define MACOSX


      module SoftenPiK
!         This part is common to Cosmos(modifyX) and Cosmos/Util/Gencol
!     Used to soften the x-distribution.     
      implicit none

!         The parameters are listed above the --------------- line
! mode=0)      don't do any cut/modification of X
! mode=1)      discard all pi/K with x>xth. 
!              However, if the incident is pi/K the highest
!              energy pi/K, resp, is untouched.
! mode=2)      discard only pi0 with x> xth
! mode=3)      soften pi/K/eta  spectrum; 
!              If their x is >  x>xth, this is applied.
!              (except for the leading pi/K when
!              incident is pi/K).
! mode=-3      probability of softening depends on the user's algorithm
!              The user must modify cJudegeSplit.
!    trial version method          
!              If we find a pi/K/eta with x>xth,
!              apply softening with the prob. of (x-xth)**a (a=0.1 default).
!              Softening is done by splitting  the particle into two by
!              calling csplitMeson.  The sum of two particle is made to
!              be the same as the original particle. However, momentum 
!              cannot be conserved: the two particle will have the same
!              Pt as the original one and 3 memeta are adjuested to 
!              satisfy P^2 + m^2 =E^2. Let the two particles' energy be
!              E1 and E2.  If E2>E1, we split E2 into two again.
!             (At present, if E1> E2, we don't  split E1). 
!              (so, x>xth pi/K/eta may split into two or three).
!            This method results in some unnatural small bump at x<xth.
!

      integer,save:: mode = 3      
      real(8),save:: xth = 0.05    ! over this x, we apply cut  or modification
      real(8),save:: pw = 0.5 ! softening is determined by
!                  if(  (x-xth)**pw  < u  ) cycle  
!                  call csplitMeson(pstore(i), E1, E2, icon)
!                  so if  pw in (x-xth)**pw is smaller, stronger softening
      real(8),save:: repeat = 2.5  ! apply the simple softenning repeat times
                !   for one event if the event has pi/K/eta with X> Xth. 
                !   the odd number is probabilistic. If negative,
                !   positive number is taken  and understood as poisson
                !   average.

      real(8),save:: E0th = 500.   !  500 GeV  over this we apply cut/mod.
                           !  if make this 10 TeV, effect after shower max
                           !  decreases even for  E1ry=10^19 eV.  
                           !  This is in lab. frame
      integer,save:: fwbw = 3    ! Used in Gencol; modification is applied to
                                 ! 1--> forward only 2--> backword only
                                 ! 3--> both ; However, 1 is used when
                     ! Cosmos output (in cms) is the target, irespectively of
                     ! fwbw.  
      logical,save:: special=.false.  ! This is used olny in modifyX of
                     !   Cosmos. but not used in Gencol.
                     !   In Cosomos, it is used to see the x-dist. of
                     !   pi, K, eta  at the first interaction; 
                     ! For that, make this  .ture. and 
                     ! ***set next in parm*** (don't forget to restore
                     ! them to the default if special=.false. is reset.)
                     !  =====================================
                     !  Generate="em" (don't use "em/as")
                     !  EminObs = 8*xxxx,
                     !  =====================================
                     !  where xxxx is a value (GeV) little bit smaller then
                     !  the 1ry  energy. E.g 0.99999e8 if primary is 10^17 eV.
                     !
                     ! output will look like
                     ! xd  4  1  12.3e-4 
                     ! xd  4  0  2.89e-1
                     !  where xd is id, next two are code and charge
                     !  last one is X. in lab. frame.
             ! For special=.false., i.e, to generate air showers,
             ! you should have
             !  =====================================
             !  Generate="em/as" 
             !  EminObs = 500e-6,
             !  =====================================
        
      logical,save:: leadingPiK=.true.  ! for Pi/K incident case,
                                ! treat highest energy Pi/K of the same
                                ! charge as leading Pi/K and don't 
                                ! apply the method here
                  ! If used in Cosmos and 
                  !  if make this f, effect increase a bit esp. at
                  !  after max.  
                  !  leadingPiK=T --> Xmax ==> 35 g/cm^2
                  !            =F     Xmax ==> 25 g/cm^2
      logical,save:: useXinCMS=.false.  !This is used only in Cosmos.
                !  In Cosmos, generated particle's E is in Lob. so 
                !  x= E/E0 is also in Lob.  If this is .false., softening by 
                !  csoftenPiK is applied to the Lab.X. 
                !  if this is .true.,  softening is performed after
                !  converting the energy into cms system, and then
                !   re-boosted to Lab.  
                !  
      real(8),save:: k1u=0.25    !   
      real(8),save:: xthl=1.d0
      real(8),save:: xthu=10.d0
      real(8),save:: rejpw=0.
      logical,save:: modified   ! not input. used in Cosmos
      real(8),save:: E0lab=1.e12   ! not input. current E0 in lab. 
                                ! frame. Used in Cosmos

!             next one is about 0.6 of maxn in Epics/Util/Gencol/Zprivate.h
!             but this  cannot inherit maxn
      integer,parameter::half=12000  
!--------------------------------------------------------------------

      contains

      subroutine cJudgeSplit(pj, x,  split) 
      implicit none
!         judge if this x should be split

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: pj    ! input. projectile. you may use this
      real(8),intent(in):: x  ! KE ratio
      logical,intent(out):: split  ! .true.  or .false.. if true, split meson

      real(8):: u

      if( mode == 3) then
         call rndc(u)   ! uniform rn in (0,1)
!          if pw in (x-xth)**pw is smaller, stronger softening
         split = (x-xth)**pw  > u  
      elseif(mode == -3 ) then
!            comment out next lines and supply your judgement
!         and fix split (.true. or .false.)
!         you may use xth, pw etc which are defined before "contains"
         write(0,*) ' you have to supply your owon code here'
         write(0,*) ' to judge if this particle should be '
         write(0,*) ' split or not' 
         write(0,*)
     *    ' Place is cJudgeSplit; first subroutine in  csoftenPiK'
         stop
      endif
         
      end     subroutine cJudgeSplit
      
      subroutine csoftenPiK(inciptcl, pstore, nin, nout)
!         inciptcl made a collsion and generated nin particles in pstore
!         particle information may be at CMS or Lab.
!     If we want to  make the x-dist. softer,
!      A) For Cosmos (air target),  we may use the Lab system
!         (for large X, the distribution would be the same 
!           as CMS)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   Parameters   needed  for the Launcher.
!
!	(->	------------------------------------

         integer ErrorOut    !2 Error output logical  dev number.
         character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
         character*128  CutOffFile   !1  Geomagnetic cut-off file
         character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
         character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
         character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
                                    !   Cosmos/Data/DPM/atmos.inp is assumed.  
         character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
         logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
         integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
         integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
         integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
         integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
         logical       Hidden         !1  Make T, if hidden parameters are to be written.
         integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
         integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
         character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'
                                   ! Normally  this may be blank. Then, standard atmosphere
                                   ! is employed.  If another data with the same format
                                   ! atmosphere model is available, it can be specified.
                                   !  If ATMOSPHERE is set to 3 in Zcondc.h, and AtmosFile
                                   !  is blank, you have to set NRL_period (see, for period,
                                   !  Cosmos/Import/NRL/Util/ or manual for NRL atmosphere). 
                                   !  latitude and longitude information is also used.  
                                   ! If AtmosFile is given, it is assumed NRL format
                                   ! atmosphere data and it is used.
                                   ! For such NRL data, see also Cosmos/Import/NRL/Util/
        integer:: NRL_period       !2 see Cosmos/Import/NRL/Util or manual for NRL atmsophere
        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


!	<-)	-------------------------------------
         common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), NRL_period(4),
     *  Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 

      type(ptcl):: inciptcl  ! input. incident ptcl at collision
!                  
      integer,intent(in)::nin ! # of ptcls in pstore 
      type(ptcl):: pstore(*)  ! input/output.   ptcls to be softened.
                           !     Softened ones are put here
      integer,intent(out)::nout ! # of ptcls re-stored in pstore 
      logical,save::first=.true.
      integer:: jcon, i
      integer:: nrepeat
      real(8):: u
      integer:: exist
      integer:: nnow
      
      if( first ) then
         call copenf(TempDev, 
     *       "$COSMOSTOP/UserHook/modifyX/softenparam%dat", jcon)
         if( jcon /= 0 ) then
            write(0,*) 'Data file for csoftenPiK could not be found'
            write(0,*) 'in $COSMOSTOP/Util/Data/softenpiK%dat'
            write(0,*) 'Forgot to set COSMOSTOP ?'
            stop
         else
            call creadSoftenPara(TempDev)
         endif
         call cwriteSoftenPara(0)
         first = .false.
      endif
      if( repeat < 0. ) then
         call kpoisn(-repeat, nrepeat)
      else
         call rndc(u)
         nrepeat = repeat
         if( u < repeat-nrepeat)  then
            nrepeat = nrepeat + 1
         endif
      endif

      nnow = nin
      xth = csoftenFixXth(E0lab)
      k1u = ck1u(E0lab)
      xthu =cxthu(E0lab)
      do i = 1, nrepeat
         call csoftenPiK0(inciptcl, pstore, nnow, nout, exist)
         if( exist == 0 ) exit 
         nnow = nout
      enddo
      do i = 1, 1
         call csoftenPiK1(inciptcl, pstore, nnow, nout, exist)
         if( exist == 0 ) exit 
         nnow = nout
      enddo
      end   subroutine csoftenPiK


      subroutine csoftenPiK0(inciptcl, pstore, nin, nout, exist)
!         inciptcl made a collision and generated nin particles in pstore
!         particle.  information may be at CMS or Lab.
!     If we want to  make the x-dist. softer,
!      A) For Cosmos (air target),  we may use the Lab system
!         (for large X, the distribution would be the same 
!           as CMS)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


      type(ptcl):: inciptcl  ! input. incident ptcl at collision
!                  
      integer,intent(in)::nin ! # of ptcls in pstore 
      type(ptcl):: pstore(*)  ! input/output.   ptcls to be softened.
                           !     Softened ones are put here
      integer,intent(out)::nout ! # of ptcls re-stored in pstore 
      integer,intent(out)::exist  ! # of particcls with X> Xth
! ----------------------------------------------
      type(ptcl):: work(2)
      logical  ok
      integer::maxi
      real(8)::maxE
      integer::i, j 
      real(8):: x, E0, Ex, u, u1, u2     
      real(8):: E1, E2
      real(8)::temp
      integer:: nc  ! counting # of ptcls in pstore
      integer:: nw, icon
      logical:: split 

      E0 = inciptcl%fm%p(4) - inciptcl%mass
      nout = nin
      exist = 0
      if( E0lab < E0th) return      !!!!!
      nc = nin
!            if pi/K is incident, regards the highest one as leading
!            and avoid to modify 
      if(leadingPiK .and. (inciptcl%code == kpion .or.
     *     inciptcl%code == kkaon ) ) then
!              find max energy ptcl index and E; eta cannot be incident
         call cgetmaxptcl(pstore, nc, inciptcl%code, inciptcl%charge,
     *        maxi, maxE)
      else
         maxi = 0
      endif

      do i = 1, nin
         x = (pstore(i)%fm%p(4)-pstore(i)%mass)/E0
         if( abs(mode) == 3 ) then
            if( i /= maxi ) then
!                softening
               if(x > xth ) then
!                  modify high X of pi/K/eta
                  if(pstore(i)%code == kpion .or.
     *                 pstore(i)%code == kkaon 
     *                 .or.   pstore(i)%code ==  keta ) then
                     nw = 0
                     exist = exist + 1
!                       judge to split this
                     call cJudgeSplit(inciptcl, x,  split)
                     if( .not. split ) cycle   

                     call csplitMeson(pstore(i), E1, E2, icon)
                     if(icon == 0) then
                        modified = .true.
                     ! split;  if impossilbe, do nothing
                        nw = nw + 1
                        work(nw) = pstore(i)
                        work(nw)%fm%p(4) = E1 + work(nw)%mass 
                        call cae2p(work(nw)) ! adjust momentum
                        nw = nw + 1
                        work(nw) = pstore(i)
                        work(nw)%fm%p(4) = E2 + work(nw)%mass 
                        call cae2p(work(nw))
!                       original one is replaced by E1
                        pstore(i) = work(1)
!                       others are appended to  pstore. 
                        do j = 2, nw ! altough always nw=2
                           nc = nc + 1
                           pstore(nc) = work(j)
                        enddo
                     endif
                  endif
               endif
            endif
         elseif( mode == 1 ) then
            if( i /= maxi ) then
!               discard all pi/K/eta with x>xth (except leanding)
               if(pstore(i)%code == kpion .or. pstore(i)%code == kkaon 
     *              .or.   pstore(i)%code ==  keta ) then
                  if( x > xth ) then
!                   to neglect, put mass as E
                     pstore(i)%fm%p(4) = pstore(i)%mass
                     pstore(i)%fm%p(1:3) = 0.
                     modified = .true.
                  endif
               endif
            endif
         elseif( mode == 2 ) then 
            if( i /= maxi) then
!              discard only pi0/eta
               if( ( pstore(i)%code == kpion .and.
     *              pstore(i)%charge  == 0 ) .or.
     *              pstore(i)%code == keta ) then
                  if(x> xth) then
                     pstore(i)%fm%p(4) = pstore(i)%mass
                     pstore(i)%fm%p(1:3) = 0.    ! put zero energy
                     modified = .true.
                  endif
               endif
            endif
         elseif( mode == 0 ) then
!               do nothing
         else
            write(0,*) ' mode err=',mode, ' in csoftenPiK0'
            stop
         endif
      enddo
      if(abs(mode) == 3) then
         nout = nc
      endif
      end subroutine csoftenPiK0


      subroutine csoftenPiK1(inciptcl, pstore, nin, nout, exist)
!         inciptcl made a collision and generated nin particles in pstore
!         particle.  information may be at CMS or Lab.
!     If we want to  make the x-dist. softer,
!      A) For Cosmos (air target),  we may use the Lab system
!         (for large X, the distribution would be the same 
!           as CMS)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


      type(ptcl):: inciptcl  ! input. incident ptcl at collision
!                  
      integer,intent(in)::nin ! # of ptcls in pstore 
      type(ptcl):: pstore(*)  ! input/output.   ptcls to be softened.
                           !     Softened ones are put here
      integer,intent(out)::nout ! # of ptcls re-stored in pstore 
      integer,intent(out)::exist  ! # of particcls with X> Xth
! ----------------------------------------------
      type(ptcl):: work(2)
      logical  ok
      integer::maxi
      real(8)::maxE
      integer::i, j 
      real(8):: x, E0, Ex, u, u1, u2     
      real(8):: E1, E2
      real(8)::temp
      integer:: nc  ! counting # of ptcls in pstore
      integer:: nw, icon
      logical:: split 

      real(8):: xcent, centval
      xcent = sqrt(xth/xthu*xth*xthl)
      centval =  crejK1(xcent)


      E0 = inciptcl%fm%p(4) - inciptcl%mass
      nout = nin
      exist = 0
      if( E0lab < E0th) return      !!!!!
      nc = nin
!            if pi/K is incident, regards the highest one as leading
!            and avoid to modify 
      if(leadingPiK .and. (inciptcl%code == kpion .or.
     *     inciptcl%code == kkaon ) ) then
!              find max energy ptcl index and E; eta cannot be incident
         call cgetmaxptcl(pstore, nc, inciptcl%code, inciptcl%charge,
     *        maxi, maxE)
      else
         maxi = 0
      endif

      do i = 1, nin
         x = (pstore(i)%fm%p(4)-pstore(i)%mass)/E0
         if( x > xth*xthl ) cycle
         if( abs(mode) == 3 ) then
            if( i /= maxi ) then
!                softening
               if(x > xth/xthu) then
!                  modify high X of pi/K/eta
                  if(pstore(i)%code == kpion .or.
     *                 pstore(i)%code == kkaon 
     *                 .or.   pstore(i)%code ==  keta ) then
                     nw = 0
                     exist = exist + 1
!                       judge to split this
!!                     call cJudgeSplit(inciptcl, x,  split)
                     call rndc(u)
                     temp = crejK1(x)
!                     split = u < 0.25*(temp/centval)
!                     split = u < 0.125*(temp/centval)
                     split = u < k1u*(temp/centval)
                     if( .not. split ) cycle   

                     call csplitMeson(pstore(i), E1, E2, icon)
                     if(icon == 0) then
                        modified = .true.
                     ! split;  if impossilbe, do nothing
                        nw = nw + 1
                        work(nw) = pstore(i)
                        work(nw)%fm%p(4) = E1 + work(nw)%mass 
                        call cae2p(work(nw)) ! adjust momentum
                        nw = nw + 1
                        work(nw) = pstore(i)
                        work(nw)%fm%p(4) = E2 + work(nw)%mass 
                        call cae2p(work(nw))
!                       original one is replaced by E1
                        pstore(i) = work(1)
!                       others are appended to  pstore. 
                        do j = 2, nw ! altough always nw=2
                           nc = nc + 1
                           pstore(nc) = work(j)
                        enddo
                     endif
                  endif
               endif
            endif
         elseif( mode == 1 ) then
            if( i /= maxi ) then
!               discard all pi/K/eta with x>xth (except leanding)
               if(pstore(i)%code == kpion .or. pstore(i)%code == kkaon 
     *              .or.   pstore(i)%code ==  keta ) then
                  if( x > xth ) then
!                   to neglect, put mass as E
                     pstore(i)%fm%p(4) = pstore(i)%mass
                     pstore(i)%fm%p(1:3) = 0.
                     modified = .true.
                  endif
               endif
            endif
         elseif( mode == 2 ) then 
            if( i /= maxi) then
!              discard only pi0/eta
               if( ( pstore(i)%code == kpion .and.
     *              pstore(i)%charge  == 0 ) .or.
     *              pstore(i)%code == keta ) then
                  if(x> xth) then
                     pstore(i)%fm%p(4) = pstore(i)%mass
                     pstore(i)%fm%p(1:3) = 0.    ! put zero energy
                     modified = .true.
                  endif
               endif
            endif
         elseif( mode == 0 ) then
!               do nothing
         else
            write(0,*) ' mode err=',mode, ' in csoftenPiK0'
            stop
         endif
      enddo
      if(abs(mode) == 3) then
         nout = nc
      endif
      end subroutine csoftenPiK1

      subroutine csplitMeson(p, E1, E2, icon) 
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: p   ! input, a high energy ptcl
      real(8),intent(out):: E1  ! split ptcl energy KE
      real(8),intent(out):: E2  ! split ptcl
      integer,intent(out):: icon ! 0--> split ok, 1--> no split
      real(8):: u,  Emin, Em
      logical ok
      integer::count

      ok = .false.

      count = 0
      do while(.not. ok)
         call rndc(u)
         u = u*(1.-xth) + xth
         E1 = u*( p%fm%p(4) - p%mass)
         E2 = (p%fm%p(4) -p%mass) - E1
!         if(E1 > p.mass .and.
!     *      E2 > p.mass ) then
            ok = .true.
!         else
!            count = count + 1
!            if(count > 20) then
!               icon = 1
!               return
!            endif
!         endif
      enddo
      icon = 0
      end subroutine csplitMeson
 
      subroutine  cae2p( pc )
!             adjust mpmentum by refering to changed E
!         keep the Pt same, if possible
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  



      type(ptcl):: pc
      
      real(8):: E,  P2, cf

      E = pc%fm%p(4)
!      
!         Pt^2 + Pz^2 +m^2= E^2
!         so new Pz =sqrt( E^2-Pt^2-m^2) 
!          the sign is the same as original one
      P2 =E**2- ( pc%fm%p(1)**2  + pc%fm%p(2)**2 + pc%mass**2)
      if( P2 > pc%mass**2  ) then
         pc%fm%p(3) =  sign(sqrt(P2), pc%fm%p(3))
      else
!         keep the direction and shirnk the magnitude of p
         P2 = pc%fm%p(1)**2  + pc%fm%p(2)**2  + pc%fm%p(3)**2
         if( E <= pc%mass .or. P2 == 0. ) then
            pc%fm%p(1:3) = 0.         
         else
            cf = sqrt( (E**2 - pc%mass**2) / P2 )
            pc%fm%p(1:3) = pc%fm%p(1:3)*cf
         endif
      endif
      end  subroutine cae2p 
      subroutine cgetMaxptcl(pstore, nin,  pcode, pcharge, maxi, maxE)
!        get max energy ptcl with the same code / charge as incident
!        if meson is incident, most probably, it is leading.
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


      integer,intent(in):: nin ! # of ptcls in pstore
      type(ptcl):: pstore(nin) 
      
      integer(2),intent(in):: pcode    ! incident code
      integer(2),intent(in):: pcharge  ! //       charge
      integer,intent(out):: maxi  !   index of maxE in pstore  // 
      real(8),intent(out):: maxE   ! max Energy with the same code/charg as
                              ! incident.  if there is no such, 0


      integer i

      maxi = 0
      maxE = 0.
      do  i = 1,  nin
         if( pstore(i)%code /=  pcode ) cycle
         if( pstore(i)%charge /= pcharge ) cycle
         if( maxE < pstore(i)%fm%p(4) ) then
            maxE =  pstore(i)%fm%p(4) 
            maxi = i
         endif
      enddo
      end subroutine cgetMaxptcl

      subroutine csoftenFE(inci, fwbwin, a, nin, nout)
!       front end of softening when it is to be  done at CMS
!         x is defined simply by E/E0, 
      implicit none 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: inci  ! incident ptcl (in cms); symmetric case 
      integer,intent(in):: fwbwin  ! modification is applied to
                                 ! 1--> forward only 2--> backword only
                                 ! 3--> both ; However, 1 is used when
                     ! Cosmos output (in cms) is the target, independently of
                     ! fwbw.  
      type(ptcl):: a(*)  ! array containing ptcl info.
      integer,intent(in)::nin ! # of ptcls in w
      integer,intent(out)::nout ! # of ptcls put in w after modification

      type(ptcl):: w1(half)  ! working array
      type(ptcl):: w2(half)  ! working array

      integer::i, nc1, nc2, ncout1, ncout2

!       do modification  extract Pz>0  and Pz<0
      nc1 = 0
      nc2 = 0
      do i = 1, nin
         if(a(i)%fm%p(3) > 0.) then
            nc1 = nc1 + 1
            w1(nc1) = a(i)
         else
            nc2 = nc2 + 1
            w2(nc2) = a(i)
         endif
      enddo
      if( nc1 > 0 .and. IBITS(fwbwin,0,1)>0 ) then  ! LSB pos=0
         call csoftenPiK(inci, w1, nc1, ncout1)
      else
         ncout1 = nc1
      endif
      if( nc2 > 0 .and. IBITS(fwbwin,1,1)>0 ) then  ! 2nd bit pos=1
         call csoftenPiK(inci, w2, nc2, ncout2)
      else
         ncout2 = nc2
      endif

      nout = 0
      do i = 1, ncout1
         nout = nout + 1
         a(nout) = w1(i)
      enddo
      do i = 1, ncout2
         nout = nout + 1
         a(nout) = w2(i)
      enddo
      end subroutine csoftenFE

      subroutine creadSoftenPara(io)
      implicit none
      integer,intent(in):: io   ! logical dev. #
      character*24 vname
      character*100 vvalue


       call cskipsep(io)
       do while( cgetParmN(io, vname, vvalue ) )
          select case(vname)
          case('mode')
             call creadParaI(vvalue, mode)
          case('xth') 
             call creadParaR(vvalue, xth)
          case('E0th') 
             call creadParaR(vvalue, E0th)
          case('fwbw')
             call creadParaI(vvalue, fwbw)
          case('pw')
             call creadParaR(vvalue, pw)
          case('repeat')
             call creadParaR(vvalue, repeat)
          case('special')
             call creadParaL(vvalue, special)
          case('leadingPiK')
             call creadParaL(vvalue, leadingPiK)
          case('useXinCMS')
             call creadParaL(vvalue, useXinCMS)
          case('k1u')
             call creadParaR(vvalue, k1u)
          case('xthl')
             call creadParaR(vvalue, xthl)
          case('xthu')
             call creadParaR(vvalue, xthu)
          case('rejpw')
             call creadParaR(vvalue, rejpw)
          end select
       enddo
       end       subroutine creadSoftenPara
!      *************
       subroutine  cwriteSoftenPara(io)
       implicit none
       integer,intent(in):: io

       write(io,*)'----------------------'
       call cwriteParaI(io,'mode', mode)
       call cwriteParaR(io,'xth', xth)
       call cwriteParaR(io,'E0th', E0th)
       call cwriteParaI(io,'fwbw', fwbw)
       call cwriteParaR(io,'pw', pw)
       call cwriteParaR(io,'repeat',repeat)
       call cwriteParaL(io,'special',special)
       call cwriteParaL(io,'leadingPiK',leadingPiK)
       call cwriteParaL(io,'useXinCMS', useXinCMS)
       call cwriteParaR(io,'k1u', k1u)
       call cwriteParaR(io,'xthl', xthl)
       call cwriteParaR(io,'xthu', xthu)
       call cwriteParaR(io,'rejpw', rejpw)
       end       subroutine  cwriteSoftenPara


       subroutine cskipsep(io)
       implicit none
       integer io
       character(10)  sep
       do while (.true.)
          read(io, '(a)') sep
          if(sep(2:10) == '---------') exit
       enddo
       end  subroutine cskipsep
!        ************************* real*8 data
       subroutine creadParaR(vvalue, x)
        implicit none
        integer io
        character*(*) vvalue
        real*8 x
!        read(vvalue, *)   x, x
        read(vvalue, *)   x
        end       subroutine creadParaR
       subroutine creadParaR2(vvalue, x, n)
        implicit none
        integer io
        character*(*) vvalue
        integer n
        real*8 x(n)
        read(vvalue, *)   x
        end       subroutine creadParaR2

!     ************************* complex data
      subroutine creadParaCx(vvalue, c)
      implicit none
      character*(*) vvalue
      complex*8 c
      read( vvalue, *)   c
      end      subroutine creadParaCx
!     ************************ integer data
      subroutine creadParaI(vvalue, i)
      implicit none
      character*(*) vvalue
      integer i
      read(vvalue, *)   i
      end      subroutine creadParaI
!        ************************* character data
      subroutine creadParaC(vvalue, cha)
      implicit none
      character*(*) vvalue
      character*(*) cha
      read(vvalue, *)  cha
      end      subroutine creadParaC
!        ***************************** logical data
      subroutine creadParaL(vvalue, logi)
      implicit none
      character*(*) vvalue
      logical logi
      read(vvalue, *)  logi
      end           subroutine creadParaL
!        ---------------------------------------------
      subroutine cwriteParaR(io, vname, x)
      implicit none
      integer io
      character*(*) vname
      real*8  x
      
      write(io, *) ' ', vname,' ', x,' /'
      end      subroutine cwriteParaR
      subroutine cwriteParaR2(io, vname, x, n)
      implicit none
      integer io
      integer n  ! arra size of x
      character*(*) vname
      real*8  x(n)
      
      write(io,*) ' ', vname,' ', x,' /'
      end      subroutine cwriteParaR2

      subroutine cwriteParaCx(io, vname, c)
      implicit none
      integer io
      character*(*) vname
      complex*8  c
      write(io,  *) ' ', vname,' ', c,' /'
      end subroutine cwriteParaCx

      subroutine cwriteParaI(io, vname, i)
      implicit none
      integer io
      character*(*) vname
      integer i
      
      write(io,  *) ' ', vname,' ', i,' /'
      end      subroutine cwriteParaI

      subroutine cwriteParaC(io, vname, cha)
      implicit none
      integer io
      character*(*) vname
      character*(*) cha
      integer klena
      character*2 qmk/" '"/             ! ' 
      if(klena(cha) .gt. 0) then
         write(io,  *) ' ', vname, qmk, cha(1:klena(cha)),
     *        qmk,' /'
      else
         write(io, *) ' ', vname, qmk, ' ', qmk, ' /'
      endif
      end      subroutine cwriteParaC
      subroutine cwriteParaL(io, vname, logi)
      implicit none
      integer io
      character*(*) vname
      logical  logi

      write(io,  *) ' ', vname,' ', logi,' /'
      end      subroutine cwriteParaL

      function crejK1( x ) result(ans)
      implicit none
      real(8),intent(in):: x
      real(8):: ans
      ans = ( log(x/(xth/xthu)) * log((xth*xthl)/x) )**rejpw
      end  function crejK1

      function cxthu( E0 ) result(ans)
      implicit none
      real(8),intent(in):: E0 ! lab E0 in Gev
      real(8):: ans   ! xthu
      ans = 12.0*(E0/1.e8)**0.1
      end      function cxthu

      function ck1u( E0 ) result(ans)
      implicit none
      real(8),intent(in):: E0 ! lab E0 in Gev
      real(8):: ans   !  k1u
      ans = 0.3*(E0/1.e8)**0.09
      end      function ck1u

      function cgetParmN( io,  vname, vv ) result(ans)
!          get parameter variable name and given value(s)  from io
       implicit none
       integer io
       character*(*)  vname, vv  ! output
       logical ans

       integer linel
       parameter( linel = 100)
       character*(linel)  line
       integer loc, loc2
       vname = " "
       do while(.true.)
          read(io, '(a)', end=100 ) line
          if( line(1:1) .eq. " " .and. line(2:2) .ne. " ") then
             loc = index( line(3:linel), " ")  + 2
             vname = line(2:loc-1)
             loc2 = index( line, "/")
             if(loc2 .eq. 0 ) then
                write(0,* ) ' "/"  is missing in the input data file '
                write(0,*)  ' The line is: ', line
                stop 1234
             endif
             vv = line(loc+1:linel)  !  some data containes '/' such as '../../Media' so put all
                                     ! data.
             goto 50
          endif
       enddo
 50    continue
       ans = .true.
       return
 100   continue
       ans =.false.
       end function cgetParmN

      function csoftenFixXth(E0)  result(xth)
      implicit none
      real(8),intent(in)::E0 ! proton/pi/K incident E. in GeV
      real(8):: xth !
!        fix the xth above which softening is performed
!       at 10^12 eV:  0.1 
!          10^13      0.063
!          10^14      0.04
!          10^16     0.01585
!          10^17      0.01
!          10^19      0.004
      xth = 0.1d0/(E0/1000.d0)**0.2
      end  function csoftenFixXth

      end module SoftenPiK

      subroutine cutptcl(proj)
!///////////// when the calling place of crot3mom after particle generation
!            is moved to somewhere after the call to chookNEPI, 
!            we must change call cutptcl in  chookNEPI (proj can be simpliy
!            MovedTrack.p)
      use SoftenPiK
      implicit none
!          special purpose routine to see the importance of
!          energetic particles. 
! 

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************



!** MYEFIELD is not used now (Dec.3,2019).  Description below
! is obso.  To use cmyEfield.f, try  UseSpecIntF.sh
!  Effect of HowEfield is the same. 
!
!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)
! #undef MYEFIELD 
!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3
!   #define ATMOSPHERE 3

!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence

          union
              map

                  real*8 r(3)

              endmap
              map
                  real*8 x, y, z  !  x,y,z in m
              endmap          ! 'xyz'
              map 
                  real*8 lat,    ! latitude in deg.  + is to the north.
     *                  long,    ! longitude in deg. + is to the east.
     *                     h     ! height in m       
              endmap      !  'llh'
              map
                  real*8 theta,      ! polar angle
     *                   phi,        ! azimuthal angle
     *                   radius      ! radial distance
              endmap         !   'sph'
          endunion

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)

         union
              map

                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


              endmap          !   
              map
                 real(8):: F(3)
              endmap           ! same as x,y,z
              
              map
                  real*8 n,      ! north com.
     *                   e,      ! east comp.
     *                   d       ! down com.
              endmap             ! 'ned'   this is for geomag
              map
                  real*8 h,       ! horizontal comp.
     *                   v,       ! vertical comp.(down is +)
     *                   a        ! deflection angle (deg. east is +)

              endmap 
          endunion     

!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



!           Parameters used for Tracking.
!	(->	--------------------------------------------

          integer  Eabsorb(2)   !2  If (1)=0, no call to chookEabsorb or chookEabsorb2 is made.
          !  (2) is used to indicate later at which the user want to
         !  energy sum of particles falling on it.
             !  If (1) is non zero, when a charged particle makes energy loss to Air, chookEabsorb is 
             !  always called. When a particle dies (i.e, it K.E becomes < Emin), chookEabsorb2
             !  may be called dedpending on the particle and Eabsorb bit. (LSB is bit 1).
             !  calling cond (See Ztrackv.h, BitPhoton etc).
             !  bit 2  and photon.  bit 3 and e-/e+. bit 4 proton. bit 5 neutron
             !  bit 6 anti-N.  bit 7 decayable ptcl, bit8 others 
             !  bit 1 is for photoelectric effect but is not used in Air.

         logical  ExactThick   !2  If T, a given length is converted into thickness with best accuracy even for very 
                              !  inclined trajectory by using numerical integration.
        logical IncMuonPolari  !1  if T, consider muon polarization
        integer HowPhotoP      !2  if 0--> no photo hadron prod.
          !      1--> Sofia at all E
          !      2--> Exp. data < 2.5 GeV ; Sofia > 2.5GeV
          !      3--> Sofia < 2.5GeV;  (rho, omega, phi) or pi0 or pi+/- at current model
         !      4--> Exp. data < 2.5GeV   //
         integer  PhitsXs !2 when phits is used, specify the Xsection to be used.
                !  D=0.   Use cosmos xsection				
                !  bit 1--> for p,n use phits xs (last bit is bit 1) (btest(..,0)-->T
    	        !  bit 2--> for heavy, use phits xs.        
                !  (phits xs seems to be too large)
 
 	 integer JamXs        !2      0--> use inelastic channel only with Cosmos cross-section
                              !      1--> use total cross-section  with Cosmos cross-section
         integer AAXsec  !2  =1 AA cosmos xsection is normalized to Shen's one at 5GeV/n if
            !     E/n > 5 GeV and used; E/n< 5 GeV, Shen's xs is used
            !  =0 AA Shen's xsection is normalzied to cosmos Xsection at 
            ! 5GeV if E/n < 5 GeV and used; E/n>5 cosmos xs is used
         integer JamFragment  !2     0--> as original Jam, the spectator breaks into nucleons
            !      1--> spectator goes into nucleons, some light heavy ions and heavy remnants
           !           the method is simple but not so bad.
        logical Freec          !1  if F, the first interaction point is forced to be the injection point else
                               !   the interaction poin is randomly sampled.
         integer OneDim	       !1  If 0, 3 dimensional simulation. if $\ge$1, one
                               !  dimensional simulation is performed.  \newline
                               !  1: onedim without use of table. \newline
                               !  2: table is used for thickness $ \leftrightarrow$ length conversion. if cos $<$ .5 \newline
                               !  3: table is always used for any angle.
                               !  ( for height $>$ 30 km, table is not used in any case). 
        real*8  LamorDiv       !2  In the geomagnetic field, a charged particle can travel almost streight 
                               !  in (Lamor Radius)/LamorDiv.  Default is 5. For AMS like tracking 20 may be needed.
         real*8  Truncc         !2 coeff. for truncating path.
         real*8  Truncn         !2 coeff. for truncating path.
         real*8  Truncx         !2 coeff. for truncating path.
         real*8  KEminObs(8)    !1  The min kinetic energy of particles for observation.
          !  KEminObs(i): i=1 is for g, 2 e, 3 mu, 4 pi, 5 K, 6 N, 7 Neu, 8 other
         !  default is 2*500keV,7*10MeV. i=2 is foreced to be the same as i=1.
          !  Normally the user may define only i=1.
         real*8  KEminObs2(8)      !2  Don't touch this. skeleton/flesh use.
         real*8  RatioToE0      !2 In the A.S generation,  hadronic interactions are followed down to at
                               !  least  RatioToE0 * E0/nucleon energy.
        real*8  WaitRatio      !1  Wait A.S generation until the electron energy, Ee, becomes $<$ WaitRatio* E0. 
                               !   This many be 1.0 for hadron origin case. But for gamma/electron primary, 
                               !   this should be as low as 0.01 to enjoy full fluctuation.
        integer EndLevel !2 Used for skeleton/flesh-out job. In a normal job, system default value 0 is reset by
            ! the system to be the max number of observation levels. (=NoOfSites).  Its real use is in such a
            ! skeleton/flesh-out job that one first follows the particles up to some high depth and later chooses
            ! events and flesh them out to deeper depths. In such a skeleton-making job, the user must give the
            ! depth list which is used flesh-out job, too.  In the skeleton job, particle tracking is terminated
            ! at the level specified by EndLevel.  In such a flesh-out job, the user must give a larger value 
            ! or 0 to EndLevel 
        integer EndLevel2 !2  Don't worry. This  is system use.
         integer Trace   !1  Flag for trace information output.\newline
            !   0 $\rightarrow$ no trace information is output.\newline
            !  $<$10$\rightarrow$ x, y, z in the primary system(say, 1)\newline
            !  $<$20 $\rightarrow$ x, y, in the primary sys. z in kg/m$^2$.(say,11)\newline
            !  $<$30 $\rightarrow$ x, y, z in the detector system\newline
            !  $<$40 $\rightarrow$ x, y, in the detector system. z in kg/m2\newline 
            !  $<$50 $\rightarrow$ x, y, z in 'xyz' system.\newline
            !  $<$60 $\rightarrow$ x,y, in 'xyz' and z in kg/m2\newline
            !  61-100 $\rightarrow$  for Cherenkov observation. For Coord system,  subtract 60.\newline
            !   if the value is even,  binary output is made on TraceDev.\newline
            !   if the last digit is 1 or 2, trace is always taken. if the last digit is 3 or 4, trace is taken
            !   only if the particle is located below the heighest observation depeth. 
            !  $>$ 101  $\rightarrow$ subtract 100 and apply the above, but chookTrace or chookCeren are used.\newline
            !  Primary system:  Origin is the deepest detector.  Z-axis is the primary direction. 
            !                   X-axis is Z x Vertical axis.  X-Y plane is orthogonal to the primary.\newline
            !  Detector system: origin is the deepest detector. Z-axis is the vertical one.  X-axis is 
            !                   directed to the magnetic east.  X-Y plane is horizontal.\newline
            !  z in kg/m$^2$ :     Vertical depth in kg/m$^2$  above the  deepest detector to the particle.
         integer TraceDev      !2  Logical dev \# for TraceDir/trace1,2,.... 
        character*70  TraceDir !1 Directory.  Default Trace information is put TraceDir/trace1, 2,..
                               ! for event 1, 2, ... The directory should exist.  Default is ' ' and in this case
                               ! /tmp/YourLoginName/ is employed. The last "/" should not be given.
                               ! *** NOTE that default Cherenkov output is made only using TraceDev,
                               !    TraceDir is not used.  You have to open the disk file at chookbgRun
                               !    It can by binary or ascii file depending on Trace value.
         logical ThinSampling  !1  if F, thinsampling is not tried. if T, alla Hillas thinning. Don't use with
                              !    the  skeleton/flesh method 
        real*8  EthinRatio(4) !2  if ThinsSamplig == T, thin sampling is performed if the energy of a particle is
                              !  between (EthinRatio(2)$\sim$EthinRatio(1))* PrimaryEnergy(/nucleon)
                              !   (=Ethin(2)$sim$Ethin(1)) ( EtinRatio(1)$>$ 0).
                              !  If EthinRatio(1) $<$ 0, Ethin will be |EthinRatio| (GeV). 
                              !  (1),(2) is for e/g. (3),(4) is for mu/hadron.  if(3)(4) are not given, 
                              !  (3)=(1)/10 and (4)=(2)/10 are used.
        logical TimeStructure !1  If T,  time information is computed
         integer HowGeomag     !2  if 1, no magnetic field until first coll. \newline
                              !      2, mag.f always exists. If Reverse not=0, use this. \newline
                              !     11, same as 1 but mag.f is const. \newline
                              !     12, same as 2 but mag.f is const. \newline
                              !     21, same as 1 but mag.f is const. \newline
                              !     22, same as 2 but mag.f is const.  \newline
                              !     31, same as 1 but mag.f is dependent on the position.  \newline
                              !  const value is the one at deepest observation plane. for 11,12  or should be given by
                              !  MagN, MagE, MagD for 21, 22. For normal applications,  11 is good.
                              !  If no magnetic field is applied, energy loss by dE/dx is considered.(bef.4.92,
                              !  and aft. 5.14)
        real*8  MagN          !2 See HowGeomag (in Tesla)
         real*8  MagE          !2 See HowGeomag (in Tesla)
        real*8  MagD          !2 See HowGeomag (in Tesla)

        real*8  MagChgDist    !2 Distance where mag. can be seen  as const.(m) at sea level
        integer UseRungeKutta !2 How to calculate deflection by the geomagnetic field. Let L be the distance
                              !   the  particle travels. \newline
                              ! 0$\rightarrow$Don't use RungeKutta method. Use the solution assuming the constant B, which
                              !     is exact if B is const.  Since the particle path is made  short, this is
                              !     enough for normal cases where particles are inside the atmosphere.(default) \newline
                              !     In every case below, if the particle height is $<$ 30km  
                              !    (= cheight in ccomPathEnd.f), the same method as 0 is used. \newline
                              ! 1$\rightarrow$ Use the Euler method.  Time needed is 20\% more than the 0 case.
                              !      As B, use the value at L/2 point obtained by using the current direction. \newline
                              ! 2$\rightarrow$ mixture of 1 and Runge-Kutta-Gill method. If gradient of B is large, RKG is
                              !      employed. This needs $\sim$4 times more cpu time than case of 1 when making a
                              !      cutoff table.  The step size of RKG is $\sim$1/10 of the Lamore radius. \newline
                              ! 3$\rightarrow$ The same as 2 but use the Runge-Kutta-Fehlberg method instead of RKG.
                              !      Step size is automattically adjusted ($\sim$1/20 $\sim$1/30 of Lamor radius) \newline
                              ! 4$\rightarrow$ As a middle point, use the point obtained by assuming the constant B at
                              !      initial point. If grad B is still large, use RKG. \newline
                              ! 5$\rightarrow$ The same as 4 but us RKF instead of RKG. \newline
                              ! 6$\rightarrow$ Use always RKG \newline
                              ! 7$\rightarrow$ Use always RKF.  This takes very long time.(50 times of 0). \newline
         real*8  BorderHeightH !2 If a particle goes higher than this, discard it.  This should be larger than 
                              !  HeightOfInj or 0.  
                              !  If 0, it is adjusted to be the same as HeightOfInj. NOTE: For upgoin primary cases, you have
                              !  to set this one explicitly. 
         real*8  BorderHeightL !2 If a particle reaches this hight, call observation routine. No further tracking is done. 
                              !  This is for neutrino observation.  See ObsPlane.
        real*8  BackAngLimit  !2 If the cosine of the angle between a particle and the primary becomes smaller than
                              !  this value, the particle is discarded. See also BorderHeighH. If you give a value 
                              !  less than -1.0, such rejection will never happen.   Default is -1.0
         character*16 Generate !1 specify what should be generated \newline
                              !   1)  Electro-magnetic cascade(em), \newline
                              !   2)  one dimensional  hybrid AS(as/qas) and/or \newline
                              !   3)  AS Lateral distribution(lat). \newline
                              !    If Generate= ' ', hadronic cascade shower is generated. \newline
                              !  For example, you may give as follows: \newline
                              !    Generate='em,as' or 'em/as' (order/case/separator insensitive) is to  generate EM-cascade and AS. \newline
                              !    Generate='as' will  generate AS with some  adequate EM cascade (EM cascade is automatically generated
                              !    so that hybrid A.S can be observed, but the minimum energy in EM cascade is independent of KEminObs). \newline
                              !   If 'qas' is given, quick generation of AS for heavy primaries is tried. See  chookASbyH.f 

        character*16 Generate2 !2  don't touch this.  for skeleton/flesh use.

         integer MagBrem       !2 If 0, no magnetic bremsstrahlung is considered. \newline
                              ! if 1 and Ee $>$ MagBremEmin, energy loss due to magnetic brems is considered \newline
                              ! if 2 and Ee $>$ MagBremEmin, real sampling of gamma is performed. \newline
                              ! (note, actually upsilon is referred further).
                              ! if generate='as' with really high energy primaries, WaitRatio
                              ! must be made small so that WaitRatio*E0 $\sim$ MagBremEmin 
        integer MagPair       !2 If 0, no magnetic pair creation is considered. \newline
                              !  if 1 and Eg > MagPairEmin, real sampling is tried.
                              ! (note, actually upsilon is referred further).  To see these magnetic effects,
                              !  HowGeoMag=2 and HightOfInj $\sim$ 5000 km are desirable.

        logical LpmEffect     !1 If t, the LPM effect is  considered when Ee $>$ LpmBremEmin for electrons and
                              !        Eg $>$ LpmPairEmin for gamma rays.

        real*8  MagBremEmin   !2  E $>$ this, magnetic bremsstrahlung by electrons may be considered. However, if
                              !   MagBrem = 0, not considered at all \newline
                              !   MagBrem = 1, total energy loss due to brems is considered. \newline
                              !   MagBrem = 2, gamma energy is sampled actually. \newline
                              !   If upsilon (Ee/m * B/Bcr) is small, the effective treatment will be
                              !   the same as MagBrem = 0 case.
        real*8  MagPairEmin   !2  E $>$ this, magnetic pair creation by gamma may be considered. However, if
                              !   MagPair = 0, not considered at all. \newline
                              !   MagPair = 1, pair creation is sampled.  \newline
                              !   However, again, actual occurrence will be dependent on the angle between
                              !   B and photon direction.
        real*8  UpsilonMin    !2  Magnetic bremsstralhung is considered only if upsilon $>$ UpsilonMin.
        real*8  LpmBremEmin   !2  The LPM effect is taken into account for bremsstrahlung when LpmEffect is .true. 
                              !   and the electron energy is higher than this.
        real*8  LpmPairEmin   !2  The LPM effect is taken into account for pair creation when LpmEffect is .true.
                              !    and the gamma energy is higher than this.
        real*8  StepControl   !2   When  observation depth step becomes small,
                              ! high energy partciles may go that step without
                              ! suffering from scattering and this could lead to
                              ! under estimation of lateral spread (We don't impose
         	              ! scattering when a particle cross the observation depth
                              ! by technical reason.) StepControl
                              ! is used to make the maximum step size of particles
                              ! to be at most (depth step)/StepControl.  Default is 5.
        integer Reverse       !2  0$\rightarrow$ Normal tracking. \newline
                              !   1$\rightarrow$ incident is tracked to a direction opposite to the given one.
                              !       the incident is charge-conjugated.
                              !       All interactions are ignored. (Use when to make cut-off table or to see
                              !       a given particle (say, observed anti proton) can go out of Earth. \newline
                              !   2$\rightarrow$ same as 1 but energy gain (not loss) is taken into account
                              !   TimeStructure should be T if Reverse != 0.  See BackAnglLimit.

        real*8 PathLimit      !2  If the sum of (path/beta) of a particle  exceeds this, it is judged as dead.
                              !   (to avoid infinite cyclotron loop).  However, for normal applications,
                              !   this will not be effective because of BackAnglLimit. See Reverse.
                              !   TimeStructure should be T if Reverse != 0 and PathLimit is to be effective.

       integer MuNI           !2 0$\rightarrow$ nuclear interaction of muon is completely neglected \newline
                              !  1$\rightarrow$ energy loss by n.i is subsumed in dE/dx of muons as a continuous energy loss.  Let v=
                              !     Etransfer/Emu,  the loss here is Int(vc:vmax) of (Emu vdsigma/dv).  (vc $\sim$0, vmax$\sim$1). \newline
                              !  2$\rightarrow$ (Default value). similar to 1 but as the continuous loss only v $<$ vmin=10$^{-3}$ of
                              !     fractional muon energy is subsumed (Int(vc: vmin) of (Emu vdsigma/dv)).  The portion
                              !     of loss by v$>$vmin is treated as a stocastic  process.  However, the product from the
                              !     n.i itself is neglected \newline
                              !  3$\rightarrow$ the same as 2, but the n.i is explicitly included to produce a number of particles.  
                              !     The n.i is treated as a photo-nucleus interaction.
      integer MuBr            !2  parameter similar to MuNI but for bremsstrahlung by muons.
       integer MuPr           !2  parameter similar to MuNI but for pair creation by muons.

       character(len=2):: ASRforDPM  !  D='m'
               ! "no"  ; don't try to restore Pt asymmetry (
               !         original dpm. some asymmetry for heavy
               !         remnant side.
               ! "r"   ; randomize Pt of mesons for Pz< 2GeV
               !         in target rest frame and proj. rest frame
               ! "r1"  ; do the same only for target rest frame
               ! "m"   ; x <= -x  sign change with prob. of 1/2
               !          for all particles. 
               !However, If proj = p,pi.. and Target A<6, no ASR
               !         If proj A<6 and target A<6, also no ASR
!	 <-)	----------------------------------------------

         common /cZtracp/ Truncc, Truncn, Truncx, 
     *  KEminObs, KEminObs2, RatioToE0, PathLimit,
     *  WaitRatio,  EthinRatio, BackAngLimit, LamorDiv,
     *  BorderHeightH,  MagN, MagE, MagD, MagChgDist,
     *  BorderHeightL,  MuNI, MuBr, MuPr,
     *  MagBremEmin, MagPairEmin, UpsilonMin, LpmBremEmin, 
     *  LpmPairEmin, UseRungeKutta, StepControl,
     *  ThinSampling, TimeStructure, HowGeomag,
     *  Trace, TraceDev,  ExactThick, OneDim, Reverse,
     *  Freec,  IncMuonPolari, MagBrem, MagPair, LpmEffect,
     *  EndLevel, EndLevel2, Eabsorb, HowPhotoP, PhitsXS,
     *  JamXs, AAXsec, JamFragment
 
        common /cZtrackpc/
     *  Generate, Generate2, TraceDir, ASRforDPM
 




!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!          common variables used in tracking ptcls.
       integer ToInteract, ToBeObserved, Truncated, Dead,
     *         BorderL,  BorderH, AngleLimit
       parameter(ToInteract = 1, ToBeObserved = 2, Truncated = 3,
     *  BorderL = 4, BorderH =5,  Dead = 6, AngleLimit = 7)
       integer  BitPhotoElec, BitPhoton,
     *    BitElectron, BitPositron, BitProton,
     *    BitNeutron, BitAntiNuc, BitDecay,  BitOther, BitEconsv
       parameter( BitPhotoElec=1, BitPhoton=2, BitElectron=3, 
     *  BitPositron=3, BitProton=4, BitNeutron=5, BitAntiNuc=6,
     *  BitDecay=7, BitOther=8, BitEconsv=9  )

       integer MaxInte
       parameter(MaxInte = 6)  !  Max number of kinds of interactions a particle can
                               !  take. (such as brems, knockon, anihilation)
       type intinf      ! Interaction information
         sequence
           real*8  thickness   ! in kg/m2 set if decay is F
           real*8  length      ! in m, set if decay is T.  or eventually by cfixProc
           character*8 process ! process id string such as brems, pair
            logical decay       ! if decay, T, else F
       end type intinf
!          define array of intinf
       type(intinf) IntInfArray(MaxInte)
!
       type(track):: TrackBefMove  ! track before moved       	
       type(track):: MovedTrack      ! to contain track moved
       type(coord):: Offset        ! the primary is directed to 
!                                     deepest detector origin + Offset
!                                     (in 'xyz')
       type(track):: Zfirst ! to keep first interaction info. V7.0
!       real*8 Zfirst       ! to keep first interaction slant depth
       integer MoveStat    ! status code for moving a particle
       integer NumberOfInte ! Number of different kind of interactions 
                            ! considered for the current particle.
       integer ProcessNo   ! The process really happend is the
                            ! ProcessNo-th process in  IntInfArray.
         logical ObserveAS     ! made to be T, if AS is to be generated
        logical Upgoing     ! if primary is going upward, made to be t
        logical UseTbl       ! becomes T, 
                            ! if length <--> thickness conv. is by table
         real*8  EminAS      ! minimum energy of e for AS generation.
         real*8  EasWait     ! for AS generation, must wait until e 
                            ! energy becomes < EasWait
        real*8 EnergyLoss   !  energy loss 
        real*8 Upsilon      ! Upsilon value 
        real*8 Xai          ! Xai value B x Eg/m /2
        real*8 maxstep(0:50 +1) ! used to cut the path
                ! 1/5 of the depth step. this is necessary cond.
         real*8  KEmin         ! min kinetic energy to be tracked
        real*8  KEminCas      ! //          (for em-cascade)
        real*8  KEmin2        ! min kinetic energy to be tracked.  for skeleton/flesh use.
        real*8  KEminCas2     ! for skeleton/flesh use.
         real*8  Ethin(4)      ! Thin sampling threshold and max weight.  for e/g and hadrons/muons
         real*8 Beta  !  v/c for MovedTrack; given if TimeStrucrue=T.
        type(magfield):: Mag
         integer MaxPtcl
        logical FromEpics     !  to control muon iteraction (pair,brem,nuci)
                              !  must be made t, when Epics treats muon.
                              !  if Cosmos uses Epics, this must be made to
                              !  be t/f depending on Epics mode, or Cosmos mode




         parameter (

     *     MaxPtcl = 35000



     *         )   ! max # of ptcls producable in coll.
        type(ptcl):: Pwork(MaxPtcl)  ! working array to store ptcls.
         integer Nproduced   ! no. of ptcls produced and stored in Pwork.
        integer Nstacked    ! no. of ptcls stacked. If ThinSampling=F,
                            ! same as Nproduced.  Nstacked <= Nproduced
         real*8  MuonPolarization  ! muon polarization value.
        integer FirstColA, FirstColZ
        real(8)::FirstColXs
!
       common /Ztrackv/Pwork, IntInfArray, TrackBefMove,
     *  MovedTrack, Zfirst, Offset,
     *  Mag, MuonPolarization,  EminAS, EasWait,
     *  EnergyLoss,  KEmin, KEminCas, Beta, 
     *  KEmin2, KEminCas2, Ethin, Upsilon, Xai, 
     *  maxstep,
     *  ObserveAS, Nproduced, Nstacked,
     *  MoveStat,  NumberOfInte, ProcessNo, 
     *  Upgoing, UseTbl, FirstColXs,
     *  FromEpics, FirstColA, FirstColZ





       real*8 TargetMassN  ! Number weighted average target mass number.  fixed value
       real*8 TargetAtomicN   !The same for average Z of the target.   fixed value
       real*8 TargetZ2        ! <Z^2> of the target
!       integer TargetNucleonNo  !  target nucleon number at a collision. sampled at each collision
       real*8 TargetZ2_3rd  ! <Z>^(2/3).  Since <Z> is almost same as 7 or 8
!                    we simpley use this as <Z^2/3>
       real*8 TargetZ1_3rd  !  <Z>^(1/3).  same reason

!       integer TargetProtonNo  !  target proton number  //     //
!       real*8  TargetXs   ! inelastic xs for this target

       common /Zair/
     *  TargetMassN, TargetAtomicN, TargetZ2, TargetZ2_3rd,  
     *  TargetZ1_3rd
!     *, TargetXs, TargetNucleonNo, TargetProtonNo
!   last 3 moved to modXsecMedia 
          save /Zair/














!         
!               variables generated during incident angle sampling
          complex*16 Obsvhour      !  observation hour for point source
          real*8 Cspsmx, Cspsmn    ! cos(zenith) of point source
! 
          type(coord):: AngleAtObsCopy, DcAtObsXyz
!        
!           AngleAtObsCopy  :  direction cos at the deepest Obssite
!                              in 'det' system
!           DcAtObsXyz :       its transfroamtion to "xyz" system
!
          type(track):: IncidentCopy
          common /Zincidentv/ IncidentCopy, AngleAtObsCopy,
     *    DcAtObsXyz,  Obsvhour, Cspsmx, Cspsmn

!
!       
      type(ptcl):: proj
      integer:: nout
      real(8):: E0
      integer:: i
      integer:: stackpos
      type(ptcl):: Tglab, Cmsp, Pjcms
      integer icon
      real(8):: y, eta
!//////////
      type(ptcl):: temp
!////////////////      
      
      modified = .false.

      if( IntInfArray(ProcessNo)%process == "coll") then 
         E0lab = proj%fm%p(4)         
         if(useXinCMS) then
!               make proton (only for making CMS)
            call cmkptc(knuc, regptcl, 1, Tglab)
            Tglab%fm%p(1:3)=0.
            Tglab%fm%p(4) = Tglab%mass
!              get cms equivlent mass and 4 momentum
!            call cgeqm(MovedTrack.p, Tglab, Cmsp, icon)
            call cgeqm(proj, Tglab, Cmsp, icon)
            if(icon /=  0) then
               write(0,*) ' cms cannot be formed in cutptcl'
               stop
            endif
!             boost Pwork into CMS
            do i =1, Nproduced
               call cbst1(i, Cmsp, Pwork(i), Pwork(i))
            enddo
!                 projectile in cms
            call cbst1(2, Cmsp, proj, Pjcms)
!                      only forward X is manipulated; fwbw is not used 
            call csoftenFE(Pjcms,  1,  Pwork, Nproduced, nout)  !!!!Pwork(i) bad
            Nproduced = nout
!                 re-boost into Lab
            do i =1, Nproduced
               call cibst1(i, Cmsp, Pwork(i), Pwork(i))
            enddo
         else
!                in lab. do softening
!            call csoftenPiK(MovedTrack.p, Pwork,  Nproduced, nout)
            call csoftenPiK(proj, Pwork,  Nproduced, nout)
!///////////
!            write(0,*) ' E0=',MovedTrack.p.fm.p(4)
!            write(0,*) ' Npro=',Nproduced, ' nout=',nout
!////////////
            Nproduced = nout
         endif

         if(special) then
            do i = 1, Nproduced
               if( Pwork(i)%code == kpion .or.
     *              Pwork(i)%code == kkaon .or.
     *              Pwork(i)%code == keta ) then
                  call cyeta(PWork(i), y, eta)
                  write(*,'("xd ",2i3,  1p,3g13.4)') 
     *            Pwork(i)%code, Pwork(i)%charge,
     *            Pwork(i)%fm%p(4)/E0lab, y, eta
               endif
            enddo
         endif
      endif

      end

      subroutine xBgRun
      use modHistogram
      use modHistogram1
      implicit none

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!              constants thru Cosmos
            real*8 pi,          !  3.14..
     *             sqrtpi,      !  sqrt(pi)
     *             Torad,       !  if multiplied to deg  --> radian
     *             Todeg,       !  1/Torad
     *             c,           !  light velocity m/sec
     *             Infty,       !  infinty
     *             Togpcm2,     !  kg/m2 *Togpcm2 --> g/cm2
     *             Tokgpm2,     !  g/cm2 *Tokgpm2    --> kg/m2
     *             Tom,         !  cm *Tom  --> m
     *             Tocm,        !  m*Tocm  --> cm
     *             Tokgpm3,     !  g/cm3 * Tokgpm3 -->  kg/m3
     *             Togpcm3,     !  kg/m3 * Togpcm3 --> g/cm3
     *	           Tonsec,      !  sec *Tonsec --> nsec 
     *             Bcr,         !  Tesla. m^2c^3/eh = 4.414x10^13G=4. x10^9
     *             SyncConvR    !  alpha(mc^2/Lc). GeV/m. conv. rate of synch.r
       real*8 Avogn,            ! Avogadro #. /mol
     *        A2deninv          ! mfp * n* xs = 1;  mfp in kg/m2
                                ! xs in mb.  1/n = A2deninv*A  


        parameter(pi = 3.141592653589793238d0, 
     *    sqrtpi = 1.772453850905516d0, Torad = pi/180.d0, 
     *    Todeg = 180.d0/pi, c=2.998d8, Infty=1.d50, Tom = 1.d-2,
     *    Tocm = 1.d0/Tom,
     *    Togpcm2 = 0.1d0, Tokgpm2 = 1.d0/Togpcm2,
     *	  Tokgpm3 = Tokgpm2/Tom, Togpcm3 = 1.d0/Tokgpm3,
     *    Tonsec = 1.d9, Bcr = 4.414d9, SyncConvR=9.657d6)
       parameter (Avogn=6.0221415d23, A2deninv = 1.d28/Avogn)
!       real(8),parameter:: alfa= 1.0d0/137.035999139d0
						      


  

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   Parameters   needed  for the Launcher.
!
!	(->	------------------------------------

         integer ErrorOut    !2 Error output logical  dev number.
         character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
         character*128  CutOffFile   !1  Geomagnetic cut-off file
         character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
         character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
         character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
                                    !   Cosmos/Data/DPM/atmos.inp is assumed.  
         character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
         logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
         integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
         integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
         integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
         integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
         logical       Hidden         !1  Make T, if hidden parameters are to be written.
         integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
         integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
         character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'
                                   ! Normally  this may be blank. Then, standard atmosphere
                                   ! is employed.  If another data with the same format
                                   ! atmosphere model is available, it can be specified.
                                   !  If 2 is set to 3 in Zcondc.h, and AtmosFile
                                   !  is blank, you have to set NRL_period (see, for period,
                                   !  Cosmos/Import/NRL/Util/ or manual for NRL atmosphere). 
                                   !  latitude and longitude information is also used.  
                                   ! If AtmosFile is given, it is assumed NRL format
                                   ! atmosphere data and it is used.
                                   ! For such NRL data, see also Cosmos/Import/NRL/Util/
        integer:: NRL_period       !2 see Cosmos/Import/NRL/Util or manual for NRL atmsophere
        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


!	<-)	-------------------------------------
         common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), NRL_period(4),
     *  Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************


!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence

          union
              map

                  real*8 r(3)

              endmap
              map
                  real*8 x, y, z  !  x,y,z in m
              endmap          ! 'xyz'
              map 
                  real*8 lat,    ! latitude in deg.  + is to the north.
     *                  long,    ! longitude in deg. + is to the east.
     *                     h     ! height in m       
              endmap      !  'llh'
              map
                  real*8 theta,      ! polar angle
     *                   phi,        ! azimuthal angle
     *                   radius      ! radial distance
              endmap         !   'sph'
          endunion

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)

         union
              map

                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


              endmap          !   
              map
                 real(8):: F(3)
              endmap           ! same as x,y,z
              
              map
                  real*8 n,      ! north com.
     *                   e,      ! east comp.
     *                   d       ! down com.
              endmap             ! 'ned'   this is for geomag
              map
                  real*8 h,       ! horizontal comp.
     *                   v,       ! vertical comp.(down is +)
     *                   a        ! deflection angle (deg. east is +)

              endmap 
          endunion     

!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



!           Parameters used for Tracking.
!	(->	--------------------------------------------

          integer  Eabsorb(2)   !2  If (1)=0, no call to chookEabsorb or chookEabsorb2 is made.
          !  (2) is used to indicate later at which the user want to
         !  energy sum of particles falling on it.
             !  If (1) is non zero, when a charged particle makes energy loss to Air, chookEabsorb is 
             !  always called. When a particle dies (i.e, it K.E becomes < Emin), chookEabsorb2
             !  may be called dedpending on the particle and Eabsorb bit. (LSB is bit 1).
             !  calling cond (See Ztrackv.h, BitPhoton etc).
             !  bit 2  and photon.  bit 3 and e-/e+. bit 4 proton. bit 5 neutron
             !  bit 6 anti-N.  bit 7 decayable ptcl, bit8 others 
             !  bit 1 is for photoelectric effect but is not used in Air.

         logical  ExactThick   !2  If T, a given length is converted into thickness with best accuracy even for very 
                              !  inclined trajectory by using numerical integration.
        logical IncMuonPolari  !1  if T, consider muon polarization
        integer HowPhotoP      !2  if 0--> no photo hadron prod.
          !      1--> Sofia at all E
          !      2--> Exp. data < 2.5 GeV ; Sofia > 2.5GeV
          !      3--> Sofia < 2.5GeV;  (rho, omega, phi) or pi0 or pi+/- at current model
         !      4--> Exp. data < 2.5GeV   //
         integer  PhitsXs !2 when phits is used, specify the Xsection to be used.
                !  D=0.   Use cosmos xsection				
                !  bit 1--> for p,n use phits xs (last bit is bit 1) (btest(..,0)-->T
    	        !  bit 2--> for heavy, use phits xs.        
                !  (phits xs seems to be too large)
 
 	 integer JamXs        !2      0--> use inelastic channel only with Cosmos cross-section
                              !      1--> use total cross-section  with Cosmos cross-section
         integer AAXsec  !2  =1 AA cosmos xsection is normalized to Shen's one at 5GeV/n if
            !     E/n > 5 GeV and used; E/n< 5 GeV, Shen's xs is used
            !  =0 AA Shen's xsection is normalzied to cosmos Xsection at 
            ! 5GeV if E/n < 5 GeV and used; E/n>5 cosmos xs is used
         integer JamFragment  !2     0--> as original Jam, the spectator breaks into nucleons
            !      1--> spectator goes into nucleons, some light heavy ions and heavy remnants
           !           the method is simple but not so bad.
        logical Freec          !1  if F, the first interaction point is forced to be the injection point else
                               !   the interaction poin is randomly sampled.
         integer OneDim	       !1  If 0, 3 dimensional simulation. if $\ge$1, one
                               !  dimensional simulation is performed.  \newline
                               !  1: onedim without use of table. \newline
                               !  2: table is used for thickness $ \leftrightarrow$ length conversion. if cos $<$ .5 \newline
                               !  3: table is always used for any angle.
                               !  ( for height $>$ 30 km, table is not used in any case). 
        real*8  LamorDiv       !2  In the geomagnetic field, a charged particle can travel almost streight 
                               !  in (Lamor Radius)/LamorDiv.  Default is 5. For AMS like tracking 20 may be needed.
         real*8  Truncc         !2 coeff. for truncating path.
         real*8  Truncn         !2 coeff. for truncating path.
         real*8  Truncx         !2 coeff. for truncating path.
         real*8  KEminObs(8)    !1  The min kinetic energy of particles for observation.
          !  KEminObs(i): i=1 is for g, 2 e, 3 mu, 4 pi, 5 K, 6 N, 7 Neu, 8 other
         !  default is 2*500keV,7*10MeV. i=2 is foreced to be the same as i=1.
          !  Normally the user may define only i=1.
         real*8  KEminObs2(8)      !2  Don't touch this. skeleton/flesh use.
         real*8  RatioToE0      !2 In the A.S generation,  hadronic interactions are followed down to at
                               !  least  RatioToE0 * E0/nucleon energy.
        real*8  WaitRatio      !1  Wait A.S generation until the electron energy, Ee, becomes $<$ WaitRatio* E0. 
                               !   This many be 1.0 for hadron origin case. But for gamma/electron primary, 
                               !   this should be as low as 0.01 to enjoy full fluctuation.
        integer EndLevel !2 Used for skeleton/flesh-out job. In a normal job, system default value 0 is reset by
            ! the system to be the max number of observation levels. (=NoOfSites).  Its real use is in such a
            ! skeleton/flesh-out job that one first follows the particles up to some high depth and later chooses
            ! events and flesh them out to deeper depths. In such a skeleton-making job, the user must give the
            ! depth list which is used flesh-out job, too.  In the skeleton job, particle tracking is terminated
            ! at the level specified by EndLevel.  In such a flesh-out job, the user must give a larger value 
            ! or 0 to EndLevel 
        integer EndLevel2 !2  Don't worry. This  is system use.
         integer Trace   !1  Flag for trace information output.\newline
            !   0 $\rightarrow$ no trace information is output.\newline
            !  $<$10$\rightarrow$ x, y, z in the primary system(say, 1)\newline
            !  $<$20 $\rightarrow$ x, y, in the primary sys. z in kg/m$^2$.(say,11)\newline
            !  $<$30 $\rightarrow$ x, y, z in the detector system\newline
            !  $<$40 $\rightarrow$ x, y, in the detector system. z in kg/m2\newline 
            !  $<$50 $\rightarrow$ x, y, z in 'xyz' system.\newline
            !  $<$60 $\rightarrow$ x,y, in 'xyz' and z in kg/m2\newline
            !  61-100 $\rightarrow$  for Cherenkov observation. For Coord system,  subtract 60.\newline
            !   if the value is even,  binary output is made on TraceDev.\newline
            !   if the last digit is 1 or 2, trace is always taken. if the last digit is 3 or 4, trace is taken
            !   only if the particle is located below the heighest observation depeth. 
            !  $>$ 101  $\rightarrow$ subtract 100 and apply the above, but chookTrace or chookCeren are used.\newline
            !  Primary system:  Origin is the deepest detector.  Z-axis is the primary direction. 
            !                   X-axis is Z x Vertical axis.  X-Y plane is orthogonal to the primary.\newline
            !  Detector system: origin is the deepest detector. Z-axis is the vertical one.  X-axis is 
            !                   directed to the magnetic east.  X-Y plane is horizontal.\newline
            !  z in kg/m$^2$ :     Vertical depth in kg/m$^2$  above the  deepest detector to the particle.
         integer TraceDev      !2  Logical dev \# for TraceDir/trace1,2,.... 
        character*70  TraceDir !1 Directory.  Default Trace information is put TraceDir/trace1, 2,..
                               ! for event 1, 2, ... The directory should exist.  Default is ' ' and in this case
                               ! /tmp/YourLoginName/ is employed. The last "/" should not be given.
                               ! *** NOTE that default Cherenkov output is made only using TraceDev,
                               !    TraceDir is not used.  You have to open the disk file at chookbgRun
                               !    It can by binary or ascii file depending on Trace value.
         logical ThinSampling  !1  if F, thinsampling is not tried. if T, alla Hillas thinning. Don't use with
                              !    the  skeleton/flesh method 
        real*8  EthinRatio(4) !2  if ThinsSamplig == T, thin sampling is performed if the energy of a particle is
                              !  between (EthinRatio(2)$\sim$EthinRatio(1))* PrimaryEnergy(/nucleon)
                              !   (=Ethin(2)$sim$Ethin(1)) ( EtinRatio(1)$>$ 0).
                              !  If EthinRatio(1) $<$ 0, Ethin will be |EthinRatio| (GeV). 
                              !  (1),(2) is for e/g. (3),(4) is for mu/hadron.  if(3)(4) are not given, 
                              !  (3)=(1)/10 and (4)=(2)/10 are used.
        logical TimeStructure !1  If T,  time information is computed
         integer HowGeomag     !2  if 1, no magnetic field until first coll. \newline
                              !      2, mag.f always exists. If Reverse not=0, use this. \newline
                              !     11, same as 1 but mag.f is const. \newline
                              !     12, same as 2 but mag.f is const. \newline
                              !     21, same as 1 but mag.f is const. \newline
                              !     22, same as 2 but mag.f is const.  \newline
                              !     31, same as 1 but mag.f is dependent on the position.  \newline
                              !  const value is the one at deepest observation plane. for 11,12  or should be given by
                              !  MagN, MagE, MagD for 21, 22. For normal applications,  11 is good.
                              !  If no magnetic field is applied, energy loss by dE/dx is considered.(bef.4.92,
                              !  and aft. 5.14)
        real*8  MagN          !2 See HowGeomag (in Tesla)
         real*8  MagE          !2 See HowGeomag (in Tesla)
        real*8  MagD          !2 See HowGeomag (in Tesla)

        real*8  MagChgDist    !2 Distance where mag. can be seen  as const.(m) at sea level
        integer UseRungeKutta !2 How to calculate deflection by the geomagnetic field. Let L be the distance
                              !   the  particle travels. \newline
                              ! 0$\rightarrow$Don't use RungeKutta method. Use the solution assuming the constant B, which
                              !     is exact if B is const.  Since the particle path is made  short, this is
                              !     enough for normal cases where particles are inside the atmosphere.(default) \newline
                              !     In every case below, if the particle height is $<$ 30km  
                              !    (= cheight in ccomPathEnd.f), the same method as 0 is used. \newline
                              ! 1$\rightarrow$ Use the Euler method.  Time needed is 20\% more than the 0 case.
                              !      As B, use the value at L/2 point obtained by using the current direction. \newline
                              ! 2$\rightarrow$ mixture of 1 and Runge-Kutta-Gill method. If gradient of B is large, RKG is
                              !      employed. This needs $\sim$4 times more cpu time than case of 1 when making a
                              !      cutoff table.  The step size of RKG is $\sim$1/10 of the Lamore radius. \newline
                              ! 3$\rightarrow$ The same as 2 but use the Runge-Kutta-Fehlberg method instead of RKG.
                              !      Step size is automattically adjusted ($\sim$1/20 $\sim$1/30 of Lamor radius) \newline
                              ! 4$\rightarrow$ As a middle point, use the point obtained by assuming the constant B at
                              !      initial point. If grad B is still large, use RKG. \newline
                              ! 5$\rightarrow$ The same as 4 but us RKF instead of RKG. \newline
                              ! 6$\rightarrow$ Use always RKG \newline
                              ! 7$\rightarrow$ Use always RKF.  This takes very long time.(50 times of 0). \newline
         real*8  BorderHeightH !2 If a particle goes higher than this, discard it.  This should be larger than 
                              !  HeightOfInj or 0.  
                              !  If 0, it is adjusted to be the same as HeightOfInj. NOTE: For upgoin primary cases, you have
                              !  to set this one explicitly. 
         real*8  BorderHeightL !2 If a particle reaches this hight, call observation routine. No further tracking is done. 
                              !  This is for neutrino observation.  See ObsPlane.
        real*8  BackAngLimit  !2 If the cosine of the angle between a particle and the primary becomes smaller than
                              !  this value, the particle is discarded. See also BorderHeighH. If you give a value 
                              !  less than -1.0, such rejection will never happen.   Default is -1.0
         character*16 Generate !1 specify what should be generated \newline
                              !   1)  Electro-magnetic cascade(em), \newline
                              !   2)  one dimensional  hybrid AS(as/qas) and/or \newline
                              !   3)  AS Lateral distribution(lat). \newline
                              !    If Generate= ' ', hadronic cascade shower is generated. \newline
                              !  For example, you may give as follows: \newline
                              !    Generate='em,as' or 'em/as' (order/case/separator insensitive) is to  generate EM-cascade and AS. \newline
                              !    Generate='as' will  generate AS with some  adequate EM cascade (EM cascade is automatically generated
                              !    so that hybrid A.S can be observed, but the minimum energy in EM cascade is independent of KEminObs). \newline
                              !   If 'qas' is given, quick generation of AS for heavy primaries is tried. See  chookASbyH.f 

        character*16 Generate2 !2  don't touch this.  for skeleton/flesh use.

         integer MagBrem       !2 If 0, no magnetic bremsstrahlung is considered. \newline
                              ! if 1 and Ee $>$ MagBremEmin, energy loss due to magnetic brems is considered \newline
                              ! if 2 and Ee $>$ MagBremEmin, real sampling of gamma is performed. \newline
                              ! (note, actually upsilon is referred further).
                              ! if generate='as' with really high energy primaries, WaitRatio
                              ! must be made small so that WaitRatio*E0 $\sim$ MagBremEmin 
        integer MagPair       !2 If 0, no magnetic pair creation is considered. \newline
                              !  if 1 and Eg > MagPairEmin, real sampling is tried.
                              ! (note, actually upsilon is referred further).  To see these magnetic effects,
                              !  HowGeoMag=2 and HightOfInj $\sim$ 5000 km are desirable.

        logical LpmEffect     !1 If t, the LPM effect is  considered when Ee $>$ LpmBremEmin for electrons and
                              !        Eg $>$ LpmPairEmin for gamma rays.

        real*8  MagBremEmin   !2  E $>$ this, magnetic bremsstrahlung by electrons may be considered. However, if
                              !   MagBrem = 0, not considered at all \newline
                              !   MagBrem = 1, total energy loss due to brems is considered. \newline
                              !   MagBrem = 2, gamma energy is sampled actually. \newline
                              !   If upsilon (Ee/m * B/Bcr) is small, the effective treatment will be
                              !   the same as MagBrem = 0 case.
        real*8  MagPairEmin   !2  E $>$ this, magnetic pair creation by gamma may be considered. However, if
                              !   MagPair = 0, not considered at all. \newline
                              !   MagPair = 1, pair creation is sampled.  \newline
                              !   However, again, actual occurrence will be dependent on the angle between
                              !   B and photon direction.
        real*8  UpsilonMin    !2  Magnetic bremsstralhung is considered only if upsilon $>$ UpsilonMin.
        real*8  LpmBremEmin   !2  The LPM effect is taken into account for bremsstrahlung when LpmEffect is .true. 
                              !   and the electron energy is higher than this.
        real*8  LpmPairEmin   !2  The LPM effect is taken into account for pair creation when LpmEffect is .true.
                              !    and the gamma energy is higher than this.
        real*8  StepControl   !2   When  observation depth step becomes small,
                              ! high energy partciles may go that step without
                              ! suffering from scattering and this could lead to
                              ! under estimation of lateral spread (We don't impose
         	              ! scattering when a particle cross the observation depth
                              ! by technical reason.) StepControl
                              ! is used to make the maximum step size of particles
                              ! to be at most (depth step)/StepControl.  Default is 5.
        integer Reverse       !2  0$\rightarrow$ Normal tracking. \newline
                              !   1$\rightarrow$ incident is tracked to a direction opposite to the given one.
                              !       the incident is charge-conjugated.
                              !       All interactions are ignored. (Use when to make cut-off table or to see
                              !       a given particle (say, observed anti proton) can go out of Earth. \newline
                              !   2$\rightarrow$ same as 1 but energy gain (not loss) is taken into account
                              !   TimeStructure should be T if Reverse != 0.  See BackAnglLimit.

        real*8 PathLimit      !2  If the sum of (path/beta) of a particle  exceeds this, it is judged as dead.
                              !   (to avoid infinite cyclotron loop).  However, for normal applications,
                              !   this will not be effective because of BackAnglLimit. See Reverse.
                              !   TimeStructure should be T if Reverse != 0 and PathLimit is to be effective.

       integer MuNI           !2 0$\rightarrow$ nuclear interaction of muon is completely neglected \newline
                              !  1$\rightarrow$ energy loss by n.i is subsumed in dE/dx of muons as a continuous energy loss.  Let v=
                              !     Etransfer/Emu,  the loss here is Int(vc:vmax) of (Emu vdsigma/dv).  (vc $\sim$0, vmax$\sim$1). \newline
                              !  2$\rightarrow$ (Default value). similar to 1 but as the continuous loss only v $<$ vmin=10$^{-3}$ of
                              !     fractional muon energy is subsumed (Int(vc: vmin) of (Emu vdsigma/dv)).  The portion
                              !     of loss by v$>$vmin is treated as a stocastic  process.  However, the product from the
                              !     n.i itself is neglected \newline
                              !  3$\rightarrow$ the same as 2, but the n.i is explicitly included to produce a number of particles.  
                              !     The n.i is treated as a photo-nucleus interaction.
      integer MuBr            !2  parameter similar to MuNI but for bremsstrahlung by muons.
       integer MuPr           !2  parameter similar to MuNI but for pair creation by muons.

       character(len=2):: ASRforDPM  !  D='m'
               ! "no"  ; don't try to restore Pt asymmetry (
               !         original dpm. some asymmetry for heavy
               !         remnant side.
               ! "r"   ; randomize Pt of mesons for Pz< 2GeV
               !         in target rest frame and proj. rest frame
               ! "r1"  ; do the same only for target rest frame
               ! "m"   ; x <= -x  sign change with prob. of 1/2
               !          for all particles. 
               !However, If proj = p,pi.. and Target A<6, no ASR
               !         If proj A<6 and target A<6, also no ASR
!	 <-)	----------------------------------------------

         common /cZtracp/ Truncc, Truncn, Truncx, 
     *  KEminObs, KEminObs2, RatioToE0, PathLimit,
     *  WaitRatio,  EthinRatio, BackAngLimit, LamorDiv,
     *  BorderHeightH,  MagN, MagE, MagD, MagChgDist,
     *  BorderHeightL,  MuNI, MuBr, MuPr,
     *  MagBremEmin, MagPairEmin, UpsilonMin, LpmBremEmin, 
     *  LpmPairEmin, UseRungeKutta, StepControl,
     *  ThinSampling, TimeStructure, HowGeomag,
     *  Trace, TraceDev,  ExactThick, OneDim, Reverse,
     *  Freec,  IncMuonPolari, MagBrem, MagPair, LpmEffect,
     *  EndLevel, EndLevel2, Eabsorb, HowPhotoP, PhitsXS,
     *  JamXs, AAXsec, JamFragment
 
        common /cZtrackpc/
     *  Generate, Generate2, TraceDir, ASRforDPM
 




!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!          common variables used in tracking ptcls.
       integer ToInteract, ToBeObserved, Truncated, Dead,
     *         BorderL,  BorderH, AngleLimit
       parameter(ToInteract = 1, ToBeObserved = 2, Truncated = 3,
     *  BorderL = 4, BorderH =5,  Dead = 6, AngleLimit = 7)
       integer  BitPhotoElec, BitPhoton,
     *    BitElectron, BitPositron, BitProton,
     *    BitNeutron, BitAntiNuc, BitDecay,  BitOther, BitEconsv
       parameter( BitPhotoElec=1, BitPhoton=2, BitElectron=3, 
     *  BitPositron=3, BitProton=4, BitNeutron=5, BitAntiNuc=6,
     *  BitDecay=7, BitOther=8, BitEconsv=9  )

       integer MaxInte
       parameter(MaxInte = 6)  !  Max number of kinds of interactions a particle can
                               !  take. (such as brems, knockon, anihilation)
       type intinf      ! Interaction information
         sequence
           real*8  thickness   ! in kg/m2 set if decay is F
           real*8  length      ! in m, set if decay is T.  or eventually by cfixProc
           character*8 process ! process id string such as brems, pair
            logical decay       ! if decay, T, else F
       end type intinf
!          define array of intinf
       type(intinf) IntInfArray(MaxInte)
!
       type(track):: TrackBefMove  ! track before moved       	
       type(track):: MovedTrack      ! to contain track moved
       type(coord):: Offset        ! the primary is directed to 
!                                     deepest detector origin + Offset
!                                     (in 'xyz')
       type(track):: Zfirst ! to keep first interaction info. V7.0
!       real*8 Zfirst       ! to keep first interaction slant depth
       integer MoveStat    ! status code for moving a particle
       integer NumberOfInte ! Number of different kind of interactions 
                            ! considered for the current particle.
       integer ProcessNo   ! The process really happend is the
                            ! ProcessNo-th process in  IntInfArray.
         logical ObserveAS     ! made to be T, if AS is to be generated
        logical Upgoing     ! if primary is going upward, made to be t
        logical UseTbl       ! becomes T, 
                            ! if length <--> thickness conv. is by table
         real*8  EminAS      ! minimum energy of e for AS generation.
         real*8  EasWait     ! for AS generation, must wait until e 
                            ! energy becomes < EasWait
        real*8 EnergyLoss   !  energy loss 
        real*8 Upsilon      ! Upsilon value 
        real*8 Xai          ! Xai value B x Eg/m /2
        real*8 maxstep(0:50 +1) ! used to cut the path
                ! 1/5 of the depth step. this is necessary cond.
         real*8  KEmin         ! min kinetic energy to be tracked
        real*8  KEminCas      ! //          (for em-cascade)
        real*8  KEmin2        ! min kinetic energy to be tracked.  for skeleton/flesh use.
        real*8  KEminCas2     ! for skeleton/flesh use.
         real*8  Ethin(4)      ! Thin sampling threshold and max weight.  for e/g and hadrons/muons
         real*8 Beta  !  v/c for MovedTrack; given if TimeStrucrue=T.
        type(magfield):: Mag
         integer MaxPtcl
        logical FromEpics     !  to control muon iteraction (pair,brem,nuci)
                              !  must be made t, when Epics treats muon.
                              !  if Cosmos uses Epics, this must be made to
                              !  be t/f depending on Epics mode, or Cosmos mode




         parameter (

     *     MaxPtcl = 35000



     *         )   ! max # of ptcls producable in coll.
        type(ptcl):: Pwork(MaxPtcl)  ! working array to store ptcls.
         integer Nproduced   ! no. of ptcls produced and stored in Pwork.
        integer Nstacked    ! no. of ptcls stacked. If ThinSampling=F,
                            ! same as Nproduced.  Nstacked <= Nproduced
         real*8  MuonPolarization  ! muon polarization value.
        integer FirstColA, FirstColZ
        real(8)::FirstColXs
!
       common /Ztrackv/Pwork, IntInfArray, TrackBefMove,
     *  MovedTrack, Zfirst, Offset,
     *  Mag, MuonPolarization,  EminAS, EasWait,
     *  EnergyLoss,  KEmin, KEminCas, Beta, 
     *  KEmin2, KEminCas2, Ethin, Upsilon, Xai, 
     *  maxstep,
     *  ObserveAS, Nproduced, Nstacked,
     *  MoveStat,  NumberOfInte, ProcessNo, 
     *  Upgoing, UseTbl, FirstColXs,
     *  FromEpics, FirstColA, FirstColZ





       real*8 TargetMassN  ! Number weighted average target mass number.  fixed value
       real*8 TargetAtomicN   !The same for average Z of the target.   fixed value
       real*8 TargetZ2        ! <Z^2> of the target
!       integer TargetNucleonNo  !  target nucleon number at a collision. sampled at each collision
       real*8 TargetZ2_3rd  ! <Z>^(2/3).  Since <Z> is almost same as 7 or 8
!                    we simpley use this as <Z^2/3>
       real*8 TargetZ1_3rd  !  <Z>^(1/3).  same reason

!       integer TargetProtonNo  !  target proton number  //     //
!       real*8  TargetXs   ! inelastic xs for this target

       common /Zair/
     *  TargetMassN, TargetAtomicN, TargetZ2, TargetZ2_3rd,  
     *  TargetZ1_3rd
!     *, TargetXs, TargetNucleonNo, TargetProtonNo
!   last 3 moved to modXsecMedia 
          save /Zair/














!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!
!	(->	------------------------------------------

         integer Charge2heavyG	!2  charge of heavy $\rightarrow$  heavy group index conversion array.
        integer HeavyG2massN    !2  heavy group index $\rightarrow$     mass number conversion array.
         integer HeavyG2charge	!2  heavy group index $\rightarrow$     charge of heavy conversion array.
        integer HeavyG2code     !2  heavy group index $\rightarrow$     particle code conversion array.
        integer Code2massN      !2  particle code $\rightarrow$     mass number conversion array.
        integer Code2heavyG	!2  particle code $\rightarrow$     heavy group index conversion array.
        real*8  FragmentTbl	!2  tbl(i,j)=$<$Number$>$  of frag. j when a heavy of heavy group index i
                                !    breaks up at air.
        real*8  PtAvNonInteNuc  !2  $<$Pt$>$  of non interacting nucleons.
         real*8  PtAvFrag        !2  $<$Pt$>$  of heavy fragments.
         character*4 HeavyG2symbol !2   heavy group index $\rightarrow$  'Fe' etc conversion array.
          integer HowIntNuc       !2 If 0, the  number of interacting nucleons among a projectile heavy nucleus is 
                                 !  determined as the number of first collision of each interacting nucleon inside 
                                ! the  nucleus.  If 1, the number is determined as the total number of collisions 
                                !   including successive interactions. Default is 1. (There is uncertaninity in
                                !  interpretation of the formula; value 1 gives larger number of interacting
                                !  nucleons.)


 
!	<-)	--------------------------------------
        

         common /Zheavyc/
     *   PtAvNonInteNuc, PtAvFrag,
     *   FragmentTbl(maxHeavyG, maxHeavyG), 
     *	 Charge2heavyG(maxHeavyCharge),
     *   HeavyG2massN(maxHeavyG), HeavyG2charge(maxHeavyG),
     *   HeavyG2code(maxHeavyG), Code2massN(khvymax),
     *   Code2heavyG(khvymax), HowIntNuc
        common /Zheavycc/ HeavyG2symbol(maxHeavyG)



         

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!       Zobs.h     header file for observation sites definition
!
           integer maxNoOfSites, maxNoOfASSites, horizontal,
     *     perpendicular, notUsed, spherical
       parameter (

     *    maxNoOfSites = 50,




     *    maxNoOfASSites=50,



     *    notUsed = 0,           ! detector plane is not used
     *    horizontal = 1,        ! detector is horizontal
     *    perpendicular = 2,      ! detector is pependicular to 1ry.
     *    spherical = 3          ! detector is cocentric sphere as the earth
     *		      )


!       Zobsvp.h---parameters to be given by input.
!       This must be preceded by Zobs.h

!	(->	---------------------------------------------------

         real*8  HeightList  !1  Height of observation levels in m. This is  made from DepthList internally. 
                            ! I.e., this one is usually not an input. However, if the DepthList values are 
                            ! negative, this is used as input and corresponding DepthList is computed internally.
        real*8  DepthList   !1	Depth List of Observation level in kg/m$^2$. If $< 0$, HeightList has priority. 
                            !  (See HeightList)
        real*8  ASHeightList	!1  This is HeightList for Air Shower observ.  Used only if Generate contains
                            !  "as". See  HeightList.
        real*8  ASDepthList     !1  This is DepthList for AS observation.  Used only if Generate contains 
                            ! "as". See DepthList.
        real*8  LatitOfSite     !1  Latitude of the deepest observation level in degree.  East is positive.
        real*8  LongitOfSite    !1  Longitude of the deepest observation level in degree.  North is positive.

     	real*8  DtGMT           !1  Difference of the local time of the observation place from GMT (hour).
         real*8  YearOfGeomag    !1  Like 1999.5. Year when Geomagnetic field is to be calculated.
         integer ObsPlane        !1    How to observe particles. \newline
                                !    0$ \Rightarrow $ no detector plane is used for observation. BorderHeightL
                                !    and BorderHeightH are used to detect particles. This is for, say, neutrino
                                !    observation. See BorderHeight{L,H}. However, the primary is directed to
                                !    the deepest depth.  \newline
                                !    1,-1$ \Rightarrow $ detector at the observation place is horizontal. Note 
                                !    that the horizontal means not tangential plane, but rather a spherical surface \newline
                                !    2,-2$ \Rightarrow $ detector is perpendicular to the primary. \newline
                                !    3$ \Rightarrow $ spherical observation. See text. \newline
                                !    For ObsPlane={1,2}, the user observation routine will receive coordinate values in
                                !    the corresponding detector system. However, if it is 0, 3 or negative, Exyz values
                                !    are obtained.
        integer NoOfSites2    !2   No of Sites for particle observation; not to be touched; for skeleton/flesh use.
         real*8 XaxisFromSouth   !2 Angle between the horizontal detector X-axis and the south(deg). + is counter
                                ! clockwise.  If $|$XaxisFromSouth$| > 360$, it is computed so that the direction is
                                ! to the magnetic east at the deepest observation point. Default is 361.
!	<-)	--------------------------------------------

   

        common /Zobsc/
     *	 HeightList(maxNoOfSites),
     *   DepthList(maxNoOfSites),
     *   ASHeightList(maxNoOfASSites),
     *   ASDepthList(maxNoOfASSites),
     *   LatitOfSite, LongitOfSite, DtGMT,
     *   XaxisFromSouth, YearOfGeomag,
     *   ObsPlane, NoOfSites2


!           need Zcoord.h  Zobs.h  Zpos.h Zmagfield.h
         integer NoOfSites           ! No of particle observation sites
        integer NoOfASSites
!          
         real*8 CosLatitude          ! oos of Latitude of deepest obs. site
        real*8 SinLatitude          ! sin
        real*8 CosLongitude         ! cos of Longitude
        real*8 SinLongitude         ! sin of ..

        type(coord):: DetZaxis     ! detector's Z axis in 'xyz' system
        type(coord):: DetXaxis     !  //        X    // 
        type(coord):: DetYaxis     !  //        Y    // 

        type(coord):: Xprimary     ! primary system x axis in 'xyz'
        type(coord):: Yprimary     ! primary system y axis in 'xyz'
        type(coord):: Zprimary     ! primary system z axis in 'xyz'
                                    ! these are computed in cprimxyz in
                                    ! ciniTracking in ceventLoop
        real(8)::Txyz2prim(3,3)    ! matrix to transform vector in
                              ! E-xyz into primary system
                  ! vector must be given from the oriign of
                  ! the detecor
        real(8)::Tprim2xyz(3,3)  ! inverse of Txyz2prim
        real(8)::Txyz2det(3,3) ! xyz to detector system transform mat
        real(8)::Tdet2xyz(3,3) ! inverse of above
        type(coord):: PolarInjPos  ! polar angle of the injection point in xyz.

         type(magfield):: MagfieldNED     ! mag in 'ned' at deepest obs. site
        type(magfield):: MagfieldHVA     ! mag in 'hva' at //. both in T.
        type(magfield):: MagfieldXYZ     ! mag in 'xyz' at //. both in T.

         type site
           sequence
               type(position):: pos
               real*8  zpl           ! z value in 1ry system
               real*8  mu
               real*8  minitime
         end type site 
         type assite
           sequence
               type(position):: pos
               real*8  zpl 
               real*8  mu             ! Moliere Unit
               real*8  esize          ! electron size
               real*8  age            ! size weighted age
         end type assite

          type(site):: ObsSites(0:maxNoOfSites+1)
         type(assite):: ASObsSites(maxNoOfASSites)
!            to store Ne, age of a component shower for an electron
         real*8 CompASNe(maxNoOfASSites), CompASAge(maxNoOfASSites)

         common /Zobsvc/  ASObsSites,  ObsSites,
     *     MagfieldNED, MagfieldHVA, MagfieldXYZ, 
     *     CompASNe, CompASAge,
     *     DetZaxis, DetXaxis, DetYaxis,
     *     Xprimary, Yprimary, Zprimary,
     *     Txyz2det, Tdet2xyz, Txyz2prim, Tprim2xyz,
     *     PolarInjPos, 
     *     CosLatitude, SinLatitude, CosLongitude, SinLongitude,
     *     NoOfSites,    NoOfASSites

!   ###include  "Zmaxdef.h"
!   ###include  "Ztrack.h"
          integer Max_stack_size
          parameter (

     *    Max_stack_size = 50000



     *    )
          integer Stack_pos
      type(track):: Stack(Max_stack_size)
      common /Zstack/ Stack, Stack_pos

       integer nsites ! # of sites to be histogramed.
       real bin, rmin  !  rbin in log10.  rmin. for lateral in Moliere u.
       integer binw
       parameter (bin=0.1, rmin=0.01)
       parameter (nsites=3)  ! max number of histogram layers
       
       integer histdep(nsites)  !  histdep(j) = k >0 ==> at depth k, histograminng 
                                !  is tried.

!            These must be double.  because addition is done 1 by 1
!            and reach 10^7 or more.(at least  Ng, Ne, at E0
!            >10^16eV.)
       real*8  SumEloss(maxNoOfSites),
     *  Ng(maxNoOfSites), Ne(maxNoOfSites),
     *  Nmu(maxNoOfSites), Nhad(maxNoOfSites)



       logical tkarspec
       logical tkrtspec
       logical tkweb
       character*192 basefilename, basefilename2, filename

       integer fnoT, fnoL,  fnoB, fnoN
       integer nrbin, nfai
       parameter ( nrbin = 42, nfai=12, 
     *   fnoT=42, fnoL=43, fnoN=44, fnoB=45) 
       real*8  rbin(nrbin), 
     * webmin(nrbin,  nfai, MaxNoOfSites)
       real dErfai(nrbin, nfai, MaxNoOfSites)
       real dECent( MaxNoOfSites )
       real*8 dfai
       parameter ( dfai = 360.d0/nfai )


       common /Zprivatec/   Ng, Ne, Nmu, Nhad, SumEloss,
     *   rbin,   dErfai,
     *   histdep,  tkrtspec, tkarspec, tkweb

       common/ Zprivatec2/ basefilename




! #include "../Hist/Z90histc.h"
! #include "../Hist/Z90histo.h"
! #include "../Hist/Z90hist1.h"
!  
!        timing histogram:   
!                   1       2        3        4         nrbin
!            *    $ |  $    |   $    |   $    |    $      |   $
!   rbin(i)         1      2         3        4         nrbin   

       type(histogram1):: tspec(4, nrbin, nfai, nsites)
!                at the center.
       type(histogram1):: tspec0(4, nsites)

       type(histogram1):: rspec(4, nfai, nsites)

            real*8  dEbydEdx(0:MaxNoOfSites+1)   ! real energy loss by dE/dx
            real*8  dEbyDeath(0:MaxNoOfSites+1)  ! Energy contained in all dead ptcls
            real*8  dEbyDeathG(0:MaxNoOfSites+1) ! in gamma
            real*8  dEbyDeathE(0:MaxNoOfSites+1) ! in electron
            real*8  dEbyDeathMuPiK(0:MaxNoOfSites+1)  ! in mu, pi, K
            real*8  dEbyDeathNeu(0:MaxNoOfSites+1)    ! in neutrino
            real*8  dEbyDeathP(0:MaxNoOfSites+1)    ! in proton
            real*8  dEbyDeathNut(0:MaxNoOfSites+1)    ! in Nutron 
            real*8  dEbyDeathO(0:MaxNoOfSites+1)      ! in other ptcls
            real*8  Espace(7),  Ecrash(7)
            real*8  MaxEbreak(2), MaxRelEbreak(2)
            real*8  SumEdiff, SumAbsEdiff 
            type(track):: inci
            type(coord):: angle
            common /Zabsob/  inci, angle,
     *      dEbydEdx, dEbyDeath, dEbyDeathG, dEbyDeathE, dEbyDeathMuPiK,
     *      dEbyDeathNeu, dEbyDeathP, dEbyDeathO, deByDeathNut, Espace,
     *      Ecrash, MaxEbreak, MaxRelEbreak, SumEdiff, SumAbsEdiff 

      integer id  ! input.  1 ==> aTrack is going out from
!                                 outer boundery.
!                           2 ==> reached at an observation level
!                           3 ==> reached at inner boundery.
      type(track):: aTrack

!      type(track):: inci
!////////////
      type(coord):: pdir, cdir
!////////////
      type(coord):: tetafai
      
      character*128 input
      character*64 dirstr
      real sr, dr, tempr
      integer i, j, k, m,  icon
      integer ansites
      save ansites
      integer iij, code
      integer i1, i2, ic
      integer ir,  ifai, l, ridx, faiidx
      real*8  E0, cosz
      real*8  fai0, fai, sint
      real*8  delta  
      integer reducedTime
      integer NN
      integer klena
      integer w2hl(MaxNoOfSites)
      real*8 r, Eloss, rinmu, cosang
      real*8 dedt, dedtF, rho, dist, disto, BinFai
      real*8 aa
      real*8 wx, wy, wz, temp
      real   za
      real  de, Ek, f, molu
      real  dt, tmin 
      real*8  cvh2den
      data BinFai/30./
      integer ldep
!     integer ndummy
      character*9 ptcln(4)
      data ptcln/"Photons", "Electrons","Muons", "hadron"/
      character*9 ptcl2(3)
      data ptcl2/"Electrons", "Muons","All"/
      real power(4)
      integer nstr
      data power/1.,1.,1., 1./
      real  power2(3)
      data power2/1.,1.,1./
      character*128 title
      character*96 evid(nsites)
      save evid
      real*8 cog, cog2, sumne,  obstimes, Savederg(5)
      real*8 firstcdepth, dd
      logical dosort
      real*4  wt, stime
      real*8 sumEbydEdx, sumEbyDeath,sumEbyDeathNeu,sumEbyDeathNut
      real*8 sumEbyDeathE, sumEbyDeathG, sumEbyDeathMuPiK, 
     *      sumEbyDeathP, sumEbyDeathO
      real*8 sumEcrash, sumEspace
      real*8 sumAll, sumdEinAir, sumMissing, sumUncertain
      integer vn/2/ ! version number for the fnoB output
      save 
!/////////////
      real*8 pabs, rcore, sina, cs, sn,  cf, mom(3), Ek8, u
!/////////////

!     ***********************
      include "interface1.h"
!     *********************


      do i = 1, nsites
         w2hl(i) = 0
      enddo

      do i = 1, nsites
!             histdep(i) is the layer number
         if(histdep(i) .eq. 0)  exit
         ansites = i
         w2hl( histdep(i) ) = i
      enddo

      r=rmin
      dr = 10.**bin 

      do i = 1, nrbin
!            center of the bin:   
         rbin(i) = r
         r = r* dr
      enddo


!            specify bin or ascii output
      call kwhistso( binw )


      return      
!     *********************************** hook for Beginning of  1 event
!     *  All system-level initialization for 1 event generation has been
!     *  eneded at this moment.
!     *  After this is executed, event generation starts.
!     *
      entry xBgEvent

      call cqIncident(inci, angle)
      E0 = inci%p%fm%p(4)
      if(inci%p%code .eq. kmuon) then
         call csetMuonPol(1.0d0)
      endif
      cosz = -angle%r(3)
      fai0 = atan2(-angle%r(2), -angle%r(1))*Todeg
      sint = sqrt(1.0-cosz**2)

      if(inci%p%code .eq. 9) then
         NN= inci%p%subcode
      elseif(inci%p%code .eq. 1) then
         NN=0
      else
         NN=1
      endif

      write(0,'("i ",  i6,  i4, g13.4,3f11.7,f7.1)')
     *   EventNo, inci%p%code,
     *   inci%p%fm%e,  -angle%r(1),  -angle%r(2), -angle%r(3)
       write(0,'(a, 1p, 6g15.5)')
     *    '### ', DetXaxis%r(1:3), DetZaxis%r(1:3)
      do i = 1, NoOfSites
         SumEloss(i) = 0.
         do j = 1, 4
            Ng(i) = 0.
            Ne(i) = 0.
            Nmu(i) = 0.
            Nhad(i) = 0.
         enddo
         dECent(i) = 0.
         do ifai = 1, nfai
            do ir= 1, nrbin
               dErfai(ir, ifai, i) = 0.
!               do j = 1, 4
!                  nrfaiAll(ir, ifai, j, i) = 0.
!               enddo
            enddo
         enddo
      enddo


!          estimate time minimum and time bin for eeach web sector
      
      do i = 1, ansites
         ldep = histdep(i)
         call cminTime2WebSec(ObsSites(ldep)%pos%xyz,
     *        ldep, i,  webmin )
      enddo



!     histogram: instanciate
!           t spectrum at each web sector
      if(tkrtspec) then
         do i = 1, ansites
            do j = 1, 4
!                at  center
               call kwhisti( tspec0(j, i),
     *          -5., 0.05, 200, b'00000')
               call kwhistai( tspec0(j, i),
     *         "Arrival time dist. of "//ptcln(j)//" at center",
     *         "t", "ptcls", .false., 0., "time", "ns")
!                   clear
               call kwhistc(tspec0(j, i))

               do ir=1, nrbin
                  do ifai=1, nfai
                     if(reducedTime .eq. 1) then
                        tmin = webmin(ir, 7, i)
                     else
                        tmin = webmin(ir, ifai,i)
                     endif
                     dt = 0.01*10.0**(bin*(ir-1))*100. ! approx core distnace m
                     dt = dt**0.75*1.e9/3.0e8/100. ! if sqrt 1m-->0.03 ns 10 m-->0.15 ns
                                       ! 100m 1ns 1km 5ns   4km 10ns
                                       ! dt**0.65  makes larger bin at large distance (<=x2)
                     if(j .eq. 4) dt=dt*10.0*ir/35.0 ! for delayed hadrons
                     dt= max(dt, 0.02)

                     call kwhisti( tspec(j, ir, ifai, i),
     *                    tmin,  dt, 2000,   b'00000')

                     call kwhistai( tspec(j, ir, ifai,  i),
     *                "Arrival time of "//ptcln(j)//" at (r,fai)",
     *                "rt", "ptcls", .false., 0., "time", "ns")
!                     clear 
                     call kwhistc(tspec(j, ir, ifai, i))
                  enddo
               enddo
            enddo
         enddo
      endif

!            lateral in each fai bin
      if(tkarspec) then

         do i = 1, ansites
            do j = 1, 4         ! g,e,mu,h
               do ifai = 1, nfai
                  call kwhisti(rspec(j, ifai, i),
     *                 rmin, bin, nrbin,  b'00011' )
                  call kwhistai(rspec(j, ifai, i), 
     *            "Lateral Dist. of "//ptcln(j)//" at  diff. azimuth",
     *            "ar", "ptcls", .true.,  power(j),   "r", "m%u")
!                     clear
                  call  kwhistc( rspec(j, ifai, i) )
               enddo
            enddo
         enddo
      endif


      obstimes = 0.

      return
!     ***************
      entry xObs(aTrack, id)
!
!     For id =2, you need not output the z value, because it is always
!     0 (within the computational accuracy).
!

      obstimes = obstimes + 1.d0
      if(mod(obstimes, 100000.d0) .eq. 0. ) then 
         dosort=.false.
         do i = 1, min(4,Stack_pos)
            if(Stack(i)%p%fm%p(4) .ne. Savederg(i)) then
               Savederg(i)=Stack(i)%p%fm%p(4) 
               dosort=.true.
            endif
         enddo
         if(dosort) then
            call csortStack
         endif
         write(0, *) ' obstimes=', obstimes, ' ptclE=',aTrack%p%fm%p(4)
         do i = 1, min(4,Stack_pos)
            write(0,*)' stack tops=', Stack(i)%p%fm%p(4)
         enddo
      endif
!     ***************
      code = aTrack%p%code
      ldep =  aTrack%where
!     ************
      if(id .eq. 2 .and. code .le. 6 ) then  ! neglect rare ptcls
         wz = aTrack%vec%w%r(3) ! downgoing < 0
         if(wz .gt. 0) return
         wz = -wz
         r = sqrt( aTrack%pos%xyz%x**2 +
     *                 aTrack%pos%xyz%y**2 )
         molu = ObsSites(ldep)%mu
         rinmu =r/molu
         sr = rinmu   ! single precision
         ridx = (log10( rinmu/rmin )/bin +0.5) +1 

         Ek = aTrack%p%fm%p(4) -aTrack%p%mass
         wt = aTrack%wgt  ! wt is single
         if(code .eq. kphoton) then
            Ng(ldep) = Ng(ldep) + aTrack%wgt
         elseif(code .eq. kelec) then
            Ne(ldep) = Ne(ldep) + aTrack%wgt
         elseif(code .eq. kmuon) then
            Nmu(ldep) = Nmu(ldep) + aTrack%wgt
         elseif(code .le. 6) then
            Nhad(ldep) = Nhad(ldep) +aTrack%wgt
         endif
!            ---------- compute energy loss 
         if(aTrack%p%charge .ne. 0  ) then
!             -----------------
!                      /|    |
!                     / |   1g/cm2 
!                    /A |    |
!            -------------------
!                  / ptcl direction  
!         get energy loss when aTrack goes some distance
!         of which vertical gramage is 1g/cm2.
!         Gramage the particle travel is 
!         1/cos where cos is the cos of angle (i.e, A if Fig)
!          in the detctor system.
!         1g/cm^2 = 10-3kg/10-4 m^2 =10 kg/m^2.
!         To travel  1 g/cm^2, the ptcl must
!         run dist kg/m^2
            if(abs(wz) .gt. 1.d-2) then
               dist =10./wz    ! in kg/m2/(g/cm2)
            else
!                 for safety
               dist =1000.
            endif

            call cqElossRate(dedt,dedtF) !  loss rate GeV/(kg/m^2)
!                     dedtF is the full eloss ; dedt is the restricted
!                     loss.  We may better use full here.
!                       energy in 1 g/cm2 of vertical direction
            Eloss =min( real(dedtF*dist), Ek)   !  GeV/(g/cm2)
            Eloss = Eloss*aTrack%wgt !  GeV/(g/cm2)
            SumEloss(ldep)=SumEloss(ldep) + Eloss
         else
            Eloss=0.
         endif

         if(code .ge. 4) code=4
         if( aTrack%p%charge .ne. 0   .or. 
     *       w2hl(ldep) .gt. 0 ) then 
!                  fai
!              fai is  in    -15 to 345  (for dfai=30.)                                     
            aa=atan2(aTrack%pos%xyz%y, aTrack%pos%xyz%x)*
     *        Todeg -fai0
            fai = aa/Todeg
            aa= mod(aa + 360.d0,   360.d0)
            if(aa .gt. (360.d0-dfai/2.0d0)) aa= aa-360.d0
            faiidx=(aa+dfai/2.0d0) /dfai + 1
            if(ridx .ge. 1 .and. ridx .le. nrbin) then
               dErfai(ridx, faiidx, ldep) = dErfai(ridx, faiidx, ldep)  
     *             +  Eloss         
            elseif(ridx .le. 0) then
               dECent(ldep) = dECent(ldep) + Eloss
            endif
! 
!  do following   for specified histo layers (typically only 1 layer)
!


            if( w2hl(ldep)  .gt. 0 ) then
               i = w2hl(ldep)
               if(tkarspec) then
                  call kwhist( rspec(code, faiidx,  i), 
     *            sr, wt)
               endif

               if( tkrtspec ) then
                  stime =  aTrack%t 
                  if(reducedTime .eq. 1) then
                     delta =  r*(cos(fai) + 1.)*sint*1.d9/c ! ns
                     stime = stime + delta
                  endif
                  ir = ridx
                  if(ir .lt. 1) then
                     call kwhist( tspec0(code, i), 
     *                  stime, wt)
                  elseif(ir .le. nrbin) then
                     call kwhist( tspec(code, ir, faiidx,  i), 
     *                    stime, wt)
                  endif
               endif
            endif

         endif
      endif
      return
!     **************
      entry xEnEvent
!     **************
!        replace  @ # % in basefilename by hostname, etc
!        and put it in basefilename2
!        
      
      write(0,*) 'ev#=',EventNo,
     *   ' generation phase finished. now writing data'

      call cgetfname(basefilename, basefilename2)
      call cqFirstID(firstcdepth)
      firstcdepth = firstcdepth* 0.1     ! in g/cm2  First col depth.



      if(ObserveAS) then
         cog = 0.
         sumne = 0.
         do i = 1, NoOfASSites
            if(i .gt. 1 .and. i  .lt. NoOfASSites ) then
               dd =(ASDepthList(i+1) - ASDepthList(i-1))/2.0
            elseif(i .eq. 1) then
               dd =(ASDepthList(2) - ASDepthList(1))
            else
               dd =(ASDepthList(NoOfASSites) -
     *              ASDepthList(NoOfASSites-1))
            endif
            cog = cog + ASObsSites(i)%esize*dd*ASDepthList(i)
            sumne= sumne +ASObsSites(i)%esize*dd
         enddo
!          0.1 is for g/cm2
         cog = cog*0.1/sumne

         cog2 = 0.
         sumne = 0.
         do i = 1, NoOfASSites
            if( ASObsSites(i)%age .gt.
     *          (2.0-ASObsSites(NoOfASSites)%age))  then
               if(i .gt. 1 .and. i  .lt. NoOfASSites ) then
                  dd =( ASDepthList(i+1) - ASDepthList(i-1))/2.0
               elseif(i .eq. 1) then
                  dd =(ASDepthList(2) - ASDepthList(1))
               else
                  dd =(ASDepthList(NoOfASSites) -
     *              ASDepthList(NoOfASSites-1))
               endif
               dd = dd
               cog2 = cog2 + ASObsSites(i)%esize*ASDepthList(i)*dd
               sumne= sumne +ASObsSites(i)%esize*dd
            endif
         enddo
         if(sumne .gt. 0.) then
            cog2 = cog2*0.1/sumne
         else
!              to deep penetration
            cog2 = ASDepthList(NoOfASSites)*0.1
         endif

         filename = basefilename2(1:klena(basefilename2))//".hyb"
         call copenfw2(fnoB, filename, 1, icon)

         write(fnoB,
     *   '("h ", i4,  3i3, 1pE11.3, 0p 3f11.7, 1pE11.3, 0p,
     *     2f7.0,i2,a )')
     *      EventNo,  inci%p%code,
     *      inci%p%subcode, inci%p%charge,
     *      inci%p%fm%e, -angle%r(1), -angle%r(2), -angle%r(3),
     *      firstcdepth, cog, cog2, vn, ' /'

         sumEbydEdx = 0.
         sumEbyDeathG =0.
         sumEbyDeathE =0.
         sumEbyDeathMuPiK =0.
         sumEbyDeathNeu = 0.
         sumEbyDeathNut = 0.
         sumEbyDeathP = 0.
         sumEbyDeathO = 0.
         sumEbyDeath = 0.
         sumUncertain = 0.
         sumEcrash = 0.
         sumEspace = 0.

         do i = 1, NoOfASSites 
            if(Eabsorb(1) .ne. 0) then
               write(fnoB, '("t ", i3, 2f7.1,  2f6.3,
     *         1p14g12.3 )')
     *           i, 
     *          ASDepthList(i)*0.1,  ASObsSites(i)%mu,
     *          ASObsSites(i)%age,   ASDepthList(i)*0.1/cog2, 
     *          Ng(i), Ne(i), Nmu(i), Nhad(i),
     *          ASObsSites(i)%esize, SumEloss(i), 
     *          dEbydEdx(i), dEbyDeath(i), 
!                   next ones are from 7.51
     *          dEbyDeathG(i),  dEbyDeathE(i), dEbyDeathMuPiK(i), 
     *          dEbyDeathP(i),  dEbyDeathNut(i), dEbyDeathO(i)

               if(i .le. Eabsorb(2) ) then
!                    to see E consv. we should not count
!                    level > Eabsorb(2).
                  sumEbydEdx = sumEbydEdx + dEbydEdx(i)
                  sumEbyDeath = sumEbyDeath + dEbyDeath(i)
                  sumEbyDeathNeu = sumEbyDeathNeu +dEbyDeathNeu(i)
                  sumEbyDeathNut = sumEbyDeathNut +dEbyDeathNut(i)
                  sumEbyDeathG = sumEbyDeathG + dEbyDeathG(i)
                  sumEbyDeathE = sumEbyDeathE + dEbyDeathE(i)
                  sumEbyDeathMuPiK = sumEbyDeathMuPiK +
     *                   dEbyDeathMuPiK(i)
                  sumEbyDeathP = sumEbyDeathP +dEbyDeathP(i)
                  sumEbyDeathO = sumEbyDeathO +dEbyDeathO(i)
               endif
            else
               write(fnoB, '("t ", i3, 2f7.1,  2f6.3,
     *         1p6E11.3 )')
     *           i, 
     *          ASDepthList(i)*0.1,  ASObsSites(i)%mu,
     *          ASObsSites(i)%age,   ASDepthList(i)*0.1/cog2, 
     *          Ng(i), Ne(i), Nmu(i), Nhad(i),
     *          ASObsSites(i)%esize, SumEloss(i)
            endif
         enddo
         if(Eabsorb(1) .ne. 0) then
            do i = 1, 7
               sumEcrash = sumEcrash + Ecrash(i)
               sumEspace = sumEspace + Espace(i)
            enddo
            write(fnoB,'("b ", 1p7E11.3)') (Espace(i), i=1,7)
            write(fnoB,'("b ", 1p7E11.3, i4)') (Ecrash(i), i=1,7),
     *      Eabsorb(2)
            write(fnoB,
     *       '("c ",1p7E11.3)' ) 
     *      MaxEbreak, MaxRelEbreak, SumEdiff, SumAbsEdiff,
     *      MaxEbreak(1)/inci%p%fm%p(4)

            sumMissing =  sumEcrash + sumEspace + sumEbyDeathNeu
            sumUncertain = sumEbyDeathNut
            sumdEinAir =  sumEbydEdx + sumEbyDeath
            sumAll = sumdEinAir + sumMissing + sumUncertain

            write(fnoB,'("s ", 1p8E11.3)') 
     *       sumEbydEdx, sumEbyDeath, sumdEinAir,
     *       sumEcrash, sumEspace, sumEbyDeathNut,
     *       sumEbyDeathNeu, sumAll

            write(fnoB,'("r ", 1p4E11.3)') 
     *      sumdEinAir/E0, sumUncertain/E0, sumMissing/E0, sumAll/E0
!                normalized one
            write(fnoB,'("n ", 1p4E11.3)') 
     *      sumdEinAir/sumAll, sumUncertain/sumAll,sumMissing/sumAll,
     *      1.0
!                additional info for more details
            write(fnoB,'("a ", 1p5g12.3 )')
     *      sumEbyDeathG,  sumEbyDeathE,  sumEbyDeathMuPiK,
     *      sumEbyDeathP,  sumEbyDeathO
         endif
         write(fnoB,*)
         close(fnoB)
      endif

      do i = 1, ansites
         j=histdep(i)
         write(evid(i), 
     *   '(i3, i5,  f5.2, f5.2,
     *   f7.1,  i4)')
     *   histdep(i), int( ASDepthList(j)*0.1 ),  
     *   ASObsSites(j)%age, ASDepthList(j)*0.1/cog2,
     *   ASObsSites(j)%mu, int(cog2)
      enddo


      if(tkarspec) then
         filename = basefilename2(1:klena(basefilename2))//"-r%hist"
         call copenfw2(fnoL, filename, binw, icon)
        do i = 1, ansites
            k=histdep(i)
            do j = 1, 4
               write(dirstr,'(a,"/d",i4, "/")')
     *              ptcln(j), int( DepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               do l = 1, nfai
                  call kwhistdir(rspec(j, l,  i),  dirstr)
!                  call kwhists(  rspec(j, l, i), 0. )
                  call kwhists(  rspec(j, l, i), 0. )
                  call kwhistev( rspec(j, l, i), EventNo)
                  call kwhistid( rspec(j, l,  i), evid(i))
                  call kwhistp( rspec(j, l, i),  fnoL)
!                        *********** deallocate ********                            
                  call kwhistd( rspec(j, l, i) )
               enddo  ! code loop                                                   
            enddo ! fai loop                                                        
         enddo ! depth loop      

         close(fnoL)
      endif

      if( tkrtspec ) then
         filename = basefilename2(1:klena(basefilename2))//"-t%hist"
         call copenfw2(fnoT, filename, binw, icon)

         do i = 1, ansites
            do j = 1, 4
               call kwhists( tspec0(j,i), 0.)
               call kwhistev( tspec0(j,i), EventNo)
               call kwhistid( tspec0(j,i), evid(i))
               k=histdep(i)
               dirstr = " "
               write( dirstr,'(a,"/d",i4, "/")')
     *              ptcln(j), int( ASDepthList(k)*0.1 )
               call kseblk( dirstr, "|", nstr)
               call kwhistdir( tspec0(j,i),  dirstr )
               call kwhistp( tspec0(j,i),  fnoT )
!                 *********** deallocate ********         
               call kwhistd( tspec0(j,i) )
            enddo
         enddo

         do i = 1, ansites
            do j = 1, 4
               do ifai= 1, nfai
                  do ir= 1, nrbin
                     call kwhists( tspec(j,ir, ifai,i), 0.)
                     call kwhistev(tspec(j,ir, ifai,i), EventNo)
                     call kwhistid( tspec(j,ir, ifai,i), evid(i))
                     dirstr = " "
                     write(dirstr,'(a,"/d",i4, "/F",i2,"/")')
     *                    ptcln(j), int( DepthList(k)*0.1), ifai
                     call kseblk(dirstr, "|", nstr)
                     call kwhistdir(tspec(j,ir, ifai,i),  dirstr)
                     call kwhistp( tspec(j,ir, ifai,i),  fnoT)
!                        *********** deallocate ********                            
                     call kwhistd( tspec(j, ir, ifai, i) )
                  enddo
               enddo
            enddo  ! code loop                                                      
         enddo   ! depth loop    
         close(fnoT)
      endif

!          output web data
      if(tkweb) then
         filename = basefilename2(1:klena(basefilename2))//".nrfai"
         call copenfw2(fnoN, filename, 1, icon)
         
         write(fnoN,
     *   '(i4,1pE11.3, 0p,i3, f8.4, 1pE11.3,0p, 4i4, 1p,8g11.3)')
     *   EventNo, E0, NN, cosz, firstcdepth, nrbin, nfai, ansites,
     *   NoOfSites, KEminObs   ! this is not exist in the older version          
!                                                                      
!           dE/dx lateral                                              
         do i = 1, NoOfSites
            do k = 1, nfai
               write(fnoN, '("dE/dx",f7.1, 3i4)' )
     *            DepthList(i)*0.1, i, i, k
               write(fnoN, '(1p10E11.3)')
     *             ( dErfai(m,k,i), m=1,nrbin  ), dECent(i)
!                                same  center value is put for all fai
            enddo
         enddo
         close(fnoN)
      endif

      write(0,*) 'ev#=',EventNo,' finished completely'

      end

