      implicit none

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************



!** MYEFIELD is not used now (Dec.3,2019).  Description below
! is obso.  To use cmyEfield.f, try  UseSpecIntF.sh
!  Effect of HowEfield is the same. 
!
!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)
! #undef MYEFIELD 
!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3
!   #define ATMOSPHERE 3

!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence

          union
              map

                  real*8 r(3)

              endmap
              map
                  real*8 x, y, z  !  x,y,z in m
              endmap          ! 'xyz'
              map 
                  real*8 lat,    ! latitude in deg.  + is to the north.
     *                  long,    ! longitude in deg. + is to the east.
     *                     h     ! height in m       
              endmap      !  'llh'
              map
                  real*8 theta,      ! polar angle
     *                   phi,        ! azimuthal angle
     *                   radius      ! radial distance
              endmap         !   'sph'
          endunion

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)

         union
              map

                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


              endmap          !   
              map
                 real(8):: F(3)
              endmap           ! same as x,y,z
              
              map
                  real*8 n,      ! north com.
     *                   e,      ! east comp.
     *                   d       ! down com.
              endmap             ! 'ned'   this is for geomag
              map
                  real*8 h,       ! horizontal comp.
     *                   v,       ! vertical comp.(down is +)
     *                   a        ! deflection angle (deg. east is +)

              endmap 
          endunion     

!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



      integer NpMax
      parameter( NpMax = 200000 )
      integer  fnoB
      parameter  (fnoB=4)  ! hybrid AS output file no.
      type ob
        integer*2 where, code, subcode, charge
	real*8 user
        real atime, erg, mass, x, y, wx, wy, wz, zenith
      end type ob
	character*8 proc
      type(ob)::o(NpMax)

      type parent 
         real*8 posx, posy, posz, coszenith
                                  ! these must be double
                                  ! otherwise small shift with
                                  ! children may appear
         real depth, colHeight
         real*8  height,  atime
!///////////
	 real*8  user
!////////////
         integer*2 where, code, asflag
         real  erg
      end type parent
      type(parent):: p


      type child
          real*8 user
          integer*2 code, subcode, charge
          real fm(4), mass
      end type child

      type(child):: c

      integer Np, Wdev, Mdev, NhMin, NgMin, NoOfLowE, NLowCounter,
     *        Rdev, HowFlesh
      real*8 SumehMin, SumegMin,  Ethresh, Cuteg, Cutneg

      character*120  Mskel, Wskel

      integer Accepted, Where
      logical TopOfNode, RealBegin, RealEnd, Copy
!      save o, c, p, TopOfNode, RealBegin, RealEnd, Copy
!       save  Accepted, Where
      common /skelcom/ o, c, p,   SumehMin, SumegMin, Ethresh,
     *     Cuteg, Cutneg,
     *     Np, NoOfLowE, NLowCounter,
     *     Wdev, Mdev,  Rdev,
     *     NhMin, NgMin, Accepted, Where,  HowFlesh, TopOfNode,
     *     RealBegin, RealEnd, Copy

      common /cskelcom/ Wskel, Mskel

      logical bgevent
      type(ptcl):: cmsptcl,  incip, pjcm
      type(track):: incident     
      common /cother/ proc, incident, cmsptcl, incip, pjcm, bgevent




      integer num, cumnum, irevent(2), i,  nr, firstev, lastev
      type(track):: Zfirst
      character*160 str
      character*80  skelin, stro(4)

      real*8  temp

      integer klena, nlow

      Mdev = 71
      Rdev = 70

      str = ' '
      read(*,'(a)')  str
!
      do i = 1, 4
         stro(i) = ' '
      enddo
!
      call ksplit(str,  80, 4, stro,  nr)
      if(nr .lt. 4) stop 'must give 2 files and 2 event #'

      skelin = stro(1)
      read( stro(2), * ) firstev
      read( stro(3), * ) lastev
      Mskel = stro(4)


      open(Rdev, file=skelin(1:klena(skelin)), form='unformatted',
     *       status='old')
      open(Mdev, file=Mskel(1:klena(Mskel)), form='unformatted',
     *       status='unknown')

      do while(.true.)
         read(Rdev, end= 1000) cumnum, num, irevent, Zfirst

         if(cumnum .gt. lastev) goto 1000

         Copy =cumnum .ge. firstev .and. cumnum .le. lastev
         if(Copy) then
            write(Mdev)  cumnum, num, irevent, Zfirst
         endif
         call cgetHES(Rdev)
         nlow = 1
         do while (nlow .ne. -1)
            read(Rdev)  nlow,  p
            if(Copy) then
               write(Mdev)  nlow,  p
            endif
            do i = 1, nlow
               read(Rdev) c
               if(Copy) then
                  write(Mdev) c
               endif
            enddo
         enddo
      enddo
 1000 continue
      if(lastev .gt. cumnum) then
         call cerrorMsg(
     *   'EOF before the specified last event reached; ok?', 1)
      else
         call cerrorMsg(
     *   ' all events copied  successfully', 1)
      endif

      end
      

      subroutine cgetHES(from)
      implicit none

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************


!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence

          union
              map

                  real*8 r(3)

              endmap
              map
                  real*8 x, y, z  !  x,y,z in m
              endmap          ! 'xyz'
              map 
                  real*8 lat,    ! latitude in deg.  + is to the north.
     *                  long,    ! longitude in deg. + is to the east.
     *                     h     ! height in m       
              endmap      !  'llh'
              map
                  real*8 theta,      ! polar angle
     *                   phi,        ! azimuthal angle
     *                   radius      ! radial distance
              endmap         !   'sph'
          endunion

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)

         union
              map

                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


              endmap          !   
              map
                 real(8):: F(3)
              endmap           ! same as x,y,z
              
              map
                  real*8 n,      ! north com.
     *                   e,      ! east comp.
     *                   d       ! down com.
              endmap             ! 'ned'   this is for geomag
              map
                  real*8 h,       ! horizontal comp.
     *                   v,       ! vertical comp.(down is +)
     *                   a        ! deflection angle (deg. east is +)

              endmap 
          endunion     

!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



      integer NpMax
      parameter( NpMax = 200000 )
      integer  fnoB
      parameter  (fnoB=4)  ! hybrid AS output file no.
      type ob
        integer*2 where, code, subcode, charge
	real*8 user
        real atime, erg, mass, x, y, wx, wy, wz, zenith
      end type ob
	character*8 proc
      type(ob)::o(NpMax)

      type parent 
         real*8 posx, posy, posz, coszenith
                                  ! these must be double
                                  ! otherwise small shift with
                                  ! children may appear
         real depth, colHeight
         real*8  height,  atime
!///////////
	 real*8  user
!////////////
         integer*2 where, code, asflag
         real  erg
      end type parent
      type(parent):: p


      type child
          real*8 user
          integer*2 code, subcode, charge
          real fm(4), mass
      end type child

      type(child):: c

      integer Np, Wdev, Mdev, NhMin, NgMin, NoOfLowE, NLowCounter,
     *        Rdev, HowFlesh
      real*8 SumehMin, SumegMin,  Ethresh, Cuteg, Cutneg

      character*120  Mskel, Wskel

      integer Accepted, Where
      logical TopOfNode, RealBegin, RealEnd, Copy
!      save o, c, p, TopOfNode, RealBegin, RealEnd, Copy
!       save  Accepted, Where
      common /skelcom/ o, c, p,   SumehMin, SumegMin, Ethresh,
     *     Cuteg, Cutneg,
     *     Np, NoOfLowE, NLowCounter,
     *     Wdev, Mdev,  Rdev,
     *     NhMin, NgMin, Accepted, Where,  HowFlesh, TopOfNode,
     *     RealBegin, RealEnd, Copy

      common /cskelcom/ Wskel, Mskel

      logical bgevent
      type(ptcl):: cmsptcl,  incip, pjcm
      type(track):: incident     
      common /cother/ proc, incident, cmsptcl, incip, pjcm, bgevent

      integer from
!

      integer i

      read(from) Np
      if(Copy) then
         write(Mdev) Np
      endif
      do i = 1, Np
         read(from) o(i)
         if(Copy) then
            write(Mdev) o(i)
         endif
      enddo

      end

