!
!     chookASbyH2:  This is a special user hook to compute
!                  AS generated by heavy primaries with
!                  generate='qas'.  This is a slave of chookASbyH.
!
      subroutine chookBgRunAS
      implicit none
#include "Zmanagerp.h"
      include "ZASbyH.h"  ! this is in UserHook
      integer ios, i,j


!      open component disk file,
!      We assume that  over all information is in the first 
!      and 2nd record of the direct access file.
!      and record number =3 to NoOfCompS + 2  have component showers.
!
!   *************** record organization *****************
!
!    First rec:  NoOfCompS, NdpethComp, E0
!    Second rec: Depths
!    later rec:  first collision depth (vertical) and sizes, ages
!
!   **************************************************** 


!        
!        
!        
      open(13, file='cs', status='OLD')

!        read direct access file.
!        Number of  compoentent showers
!        Number of  depths
!        Depth list

      read(13, *) NoOfCompS, NdepthComp, E0Comp
     *      , FirstColDep
      if(NoOfCompS .gt. Ncs) then
         write(0, *) 'too many comp showers '
         stop
      endif
      read(13, *)
     *      (DepthComp(i), i = 1, NdepthComp)     

	do i=1,NoOfCompS
	  read(13,*) (ElecSizeComp(i,j),j=1,NdepthComp)
	  read(13,*) (ElecAgeComp(i,j),j=1,NdepthComp)
	end do

	close(13)

      end

      subroutine chookNEPIntA
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
      include "ZASbyH.h"
!  #include  "Ztrackp.h"
      
      

!   MovedTrack is the particle that made interaction
!   Pwork contains produced particles.
!   Nproduced has the number of particles in Pwork
!   IntInfArray(ProcessNo) contains the type of interaction
!
!        IntInfArray(ProcessNo).process  will have
!             'col' or 'decay'

      integer i, recn, ios, j
      integer noOfIntN             ! no. of interacting nucleons
      type(ptcl):: ptclA(maxHeavyMassN)  ! to get nucleon inf.
      real*8 u     ! uniform random number
      real*8 eSizeTemp(NdepthCompM), depStep, depFirst, dep
      real*8 eAgeTemp(NdepthCompM)
      real*8 ans, zobs, t, cosz, length, clenbetween2h, eno
      real*8  clen2thick, age
    

!        inquire the interacting nucleons
      call cqIntePtcl(ptclA, noOfIntN)


!          for each nucleon
      do i = 1, noOfIntN
!           select a component shower
         call rnde(u, 1)   ! get one unif. random. n.
!            
         recn = u* NoOfCompS + 1

!         you may need to verify that
!         the primary energy of the component shower and 
!          ptclA.fm.p(4) is almost the same for safety.

         depFirst = DepthComp(1)   !  first depth
         depStep = DepthComp(2) - DepthComp(1)  ! equi step depth


!          move to real*8  array for use of kintp3
         do j =1, NdepthComp
            eSizeTemp(j) = ElecSizeComp(recn,j)    ! log10( size )
	    eAgeTemp(j)  = ElecAgeComp(recn, j)

         enddo
!              cos of c.s
         cosz = MovedTrack%vec%coszenith
!          compute size at  
         do j = 1, NoOfASSites
            zobs = ASObsSites(j)%pos%depth 
!             current nucleon depth to obseration depth
!             (vertical depth)
            dep = zobs - MovedTrack%pos%depth 
            if(dep .gt. 0.) then
                if(abs(cosz) .gt. 0.5) then
!                         amount of air
                   t= dep/abs(cosz)
                else
!                  slant lenngth between two depths
                   length = clenbetween2h(
     *                  MovedTrack%pos%radiallen,
     *                  ASObsSites(j)%pos%radiallen,
     *                  cosz)
!                         amount of air
                   t = clen2thick(
     *                MovedTrack%pos%height,
     *                cosz,  length)
                endif
!                  current obs depth corresponds to dep in c.s
                dep = t + FirstColDep
!                 interpolate; use diff. one if DepthComp is not
!                  equisteped.
                call kintp3(eSizeTemp, 1, NdepthComp,  depFirst,
     *              depStep, dep, ans)


!             *********************************
!                   for age
                call kintp3(eAgeTemp, 1, NdepthComp,  depFirst,
     *             depStep, dep, age)
!             *********************************

!                   IMPORTANT:   assume that eSizeTemp is in log10
                eno =    10.**ans * MovedTrack%wgt

                ASObsSites(j)%esize =  ASObsSites(j)%esize + eno

!             *********************************************
               ASObsSites(j)%age = ASObsSites(j)%age +
     *             eno * age
!             *********************************************
            endif
         enddo

      enddo
      end
