#!/bin/bash
echo "Show the purpose of this script briefly ?  if so enter 'y', else Return"
read yn
if [ x$yn == "xy" ]; then
    cat <<EOF
       Some of the user interface routines cannot be prepared to meet all users
     requirements. They are special in the sense that in  many  cases, the user
     need not such interface routines. For such routines, Cosmos prepares 
     simple templates  which are called inside Cosmos. 
      Therefore, when the user really wants to use them, the user must specify
     so (by giving some special value to a parameter etc) and prepare adequate
     program based on the template (but keep the internal templates as they
     are).

       When the user application is compiled, Cosmos should call the user made
     interface routine which has the same name as the internal template. 
     This script helps making such scheme. If you are using recent UserHook
     (>= v8.040), such scheme has already been implemented, but if 
     it's old, this script may be useful. (not harmful for new versions)

       What we do is simple: suppose cmyEfield.f is a template, it is in
     $COSMOSTOP/cosmos/cmyEfield.f

     a) cmain.f is copied (actually linked to Cosmos/cosmos/cmain.f)
        (It contains #include "cmyEfield.f" etc)
     b) cmyEfield.f is copied to the current directory which is
        a user's application area. The user is expected to modify
        it.
     
     That's all.
      (some of chook.f may contain #include "cmyEfield.h" etc.
       such lines are commented out). 

     Effect:
      Old Default status:
       cmain.f is not yet contained in the user application area in default
       chook.f contains "#include cmain.f".
     In this default status, 'make' will compile the internal template,
     Cosmos/cosmos/cmyEfield.f, since cmain.f is in Cosmos/cosmos/.
     But this template will not be used since the user generally
     does not give a special value 2 to "HowEfield" parameter.  
     If the user gives 2, the template is designed to stop instantly.

       If cmain.f exists in the current application area, and also
    cmyEfield.f does, 'make' will compile this cmyEfield.f. 
    (Of course, this  cmyEfield.f must be modified not to stop instantly 
     and properly programmed for the user's purpose). If this cmyEfield.f
    is non existent, the system behavior will be the same as the
    default case.
EOF
    echo " "
    echo "proceed further ?, if so enter y else return"
    read yn
    if [ ! x$yn == "xy" ]; then
	exit
    fi
fi

function checkchook0 () {
    # chook.f exists ? if no stop
    # if exists, is it link? if link, set linkf="link" else " "
    if [ ! -f chook.f ]; then
	echo "Current directory:" `pwd` " seems not a Cosmos application area"
	echo "since chook.f is non existent"
	exit
    fi
    if [ -L chook.f ]; then
	#   assume chook.f-xxxx  file is linked to chook.f
	linkf="link"
    else
        linkf="nolink"
    fi
}

function checkcmain() {
    # check if cmain.f exists in the current app. area,
    #    if no, make link to Cosmos/cosmos/cmain.f
    # if exist and  it is link, no problem
    #  //      and not link, some warning. for future change of cmain.f
    if [ ! -f cmain.f ]; then
	ln -s  $COSMOSTOP/cosmos/cmain.f cmain.f
	echo "A link file cmain.f has been created in you present app. area:" 
    fi
    if [ -L cmain.f ]; then
	echo "Your app. area (" `pwd` ") is ready for using special interfaces"
    else
	echo "cmain.f" exists in your app. area: `pwd`
	echo "It is better to be a link to " $COSMOSTOP"/cosmos/cmain.f"
	echo "May I do so now ?; Enter yes if so"
	read yesno
	if [ x$yesno == "xyes" ]; then
	    rm cmain.f
	    ln -s  $COSMOSTOP/cosmos/cmain.f cmain.f
	else
	    echo "Probably at present OK. but in future ??" 
	fi
	echo "Your app. area (" `pwd` ") is ready for using special interfaces"
    fi
}

function checkchook1 () {
    # check  (non linked) chook.f contains #include "cmyEfield.f" etc
    # if so, comment out them.
    nth=0;
    cp chook.f temp$$
    #     see if  cmyEfield.f etc indicated by cmain.f
    #     and ctemplCeren.f (this one is special, it is renamed
    #     in cmain.f as cmyCerenkov.f
    for intf in `awk 'NR>1 {print $2}' cmain.f` \"ctemplCeren.f\"; do
	n=`grep -c -E "^#include +$intf" temp$$` 
	if [ $n -gt 0 ]; then
	    # exist
	    if [ $nth -eq 0 ];then
		cp chook.f chook.f-bkup
	    fi
	    let nth=$nth+1
	    #  in next, " must be used since $f.     ( ' is NG)
	    sed -E "s/^#include +$intf/!!! #include $intf not needed now/" temp$$ > temp2$$
	    mv temp2$$ temp$$
	fi 
    done
    if [ $nth -gt 0 ]; then
	mv temp$$ chook.f
    else
	rm temp$$
    fi
}


function checkchook2 () {
    # check all chook.f-xxxx if they contain #include "cmyEfield.f" etc
    # if so, comment out them.

    for f in chook.f-*; do
	if [ x`echo $f | awk '$1~"-bkup" {print "bu"}'` = "xbu" ]; then
	    continue
	fi
	if [ -f ${f}-bkup ]; then
	    continue
	fi

	cp $f temp$$
    #     see if  cmyEfield.f etc indicated by cmain.f
    #     and ctemplCeren.f are include by #include in $f
    #	( ctemplCeren.f is is special, it is renamed
    #     in cmain.f as cmyCerenkov.f
	for intf in `awk 'NR>1 {print $2}' cmain.f` \"ctemplCeren.f\"; do
	    nth=0;
	    n=`grep -c -E "^#include +$intf" temp$$`
		#########
	    echo " inftf =" $intf
	    echo "n =" $n
		#######
	    if [ $n -gt 0 ]; then
		    # exist
		if [ $nth -eq 0 ];then
		    cp $f $f-bkup
		fi
		let nth=$nth+1
	    #  in next, " must be used since $f.   ( ' is NG)
		sed -E "s/^#include +$intf/!!! #include $intf not needed now/" temp$$ > temp2$$
		mv temp2$$ temp$$
	    fi
	done
	if [ $nth -gt 0 ]; then
	    mv temp$$ $f
	else
	    rm temp$$
	fi
    done
}


function showIntfName(){
    awk 'NR>1 {name=$2; gsub("\"", "", name); \
            if( length(name) > 0)  print NR-1 ": ",name}' cmain.f
}


function copyIntfRoutines(){
    for f in `awk 'NR>1 {gsub("\"","",$2);print $2}' cmain.f`; do
	if [ -f $f ]; then
	    echo  "file ", $f, " already exists in you app. area"
	elif [ -f ${COSMOSTOP}/cosmos/$f ]; then
	    cp ${COSMOSTOP}/cosmos/$f ./
	    echo "Now the file ", $f, " is copied to the present dir"
	else
	    echo some error:  $f non existent 
	    exit
	fi
    done
}
function selectIntf(){
    # now not used: all interfaces are target
    echo  "Which interface do you want to use: Enter a number"
    read num
    let intfnum=$num+1
    fname=`awk 'NR>1 && NR==intfnum {name=$2; gsub("\"", "", name);print name}' intfnum=$intfnum cmain.f`
    echo "You selected #: " $num " file name is " $fname
    if [ -f $fname ]; then
	echo  "file ", $fname, " already exists in you app. area"
    elif [ -f ${COSMOSTOP}/cosmos/$fname ]; then
	cp ${COSMOSTOP}/cosmos/$fname ./
	echo "Now the file ", $fname, " is copied present dir"
    else
	echo some error:  $fname non existent 
	exit
    fi
    echo 'Edit it to be suited for you purpose and "make clean; make"'
}


#==================================================
#  check if chook.f exist in pwd , if no stop
#  if exists, check it is link or not. If link, linkf="link"
checkchook0;
#  check if cmain.f exists in pwd, if no make link
#  if exist and not link, show warning.
#   
checkcmain;
#       if needed, modify chook.f
if [ $linkf = "link" ]; then
    checkchook2;
else
    checkchook1;
fi

copyIntfRoutines;

if [ -f ctemplCeren.f ]; then
    mv ctemplCeren.f ctemplCeren.f- rNOTNEEDED
fi

#       show interface name list
echo " "
echo "List of special interface routines"
echo " "
showIntfName;
#    select needed one  ; don't use
#  selectIntf;
cat <<EOF
  If you want to use some of  special interface, modify a target
  interface routine and 'make clean; make'. If needed, after giving
  a special value to a relevant parameter in param file, 
  execute the program.
EOF
