!  Usage:  compile by make -f cgetXs.mk
!      verbose mode:  (may be target is simple)
!      ./a.out > result
!      file input mode:(may be target is complex)
!                  prepare a file like
!          4            /  1-> proton 2->pion 3->K  4->A
!          56 26        /  if 4, give A,Z of projectile else omit this line
!          14.0, 16.0, 40.0 /     A's for target. "/" is mandatory
!          1.56 .42  .01
!       and
!      ./a.out < thefile > result
!   **NOTE*** verbose mode and file input mode may be
!        used independently of the complexity of the target.
!
      module modgetXs
      implicit none
      integer,parameter::maxel=15   ! max # of elements
      integer::nel  !  actual @ of elements
!      real(8):: A(maxel)
      integer:: A(maxel)
      real(8):: portion(maxel)
      integer,save:: pjk
!      integer,parameter:: nel=3   ! # of elements
!      real(8):: A(nel)=(/14.0, 16.0, 40.0/)   ! mass # (integer value is used)
!      real(8):: portion(nel)=(/78.1, 20.95, 0.94/)    ! relative # of A's in unit volume

      real(8),parameter:: dE=0.01d0   !  log 10 step
      real(8),save:: E1= 0   ! starting Etotal( =>mass*1.1 )
      real(8),parameter:: E0max=1e12 ! total E max
      integer,save:: nebin=480  ! # of  Energy bins 


      integer,save:: pjA, pjZ
      integer,save:: targetnucchg=1  
      contains
      subroutine computeXS(pj, xsa)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: pj  !  projectile . E is fixed here
      real(8),intent(out):: xsa(nebin,3)

      type(ptcl):: tg  ! input target particle in lab.
      integer:: i, j
      real(8):: E, sum(3), xs(3) 
      integer:: TA
      integer:: code
      real(8):: temp
      real(8),external::cA2Z

      E = E1  


      do i = 1, nebin
         pj%fm%p(4) = E*pjA

         sum(:) = 0.
         do  j = 1, nel
            if( A(j) > 1 ) then
                                       ! charge is not used so rough
               temp = A(j)
               call cmkptc(kgnuc, A(j), int(cA2Z(temp)), tg)
            else
               call cmkptc(knuc, -1, targetnucchg, tg) 
            endif
            call cgetXsInterface2(pj, tg, xs)
            sum(:) = sum(:) + xs(:)*portion(j)
         enddo
         xsa(i,:) =  sum(:)
         E = E*10.0d0**dE
         if( E*pjA > E0max ) exit
      enddo
      end   subroutine computeXS
      end       module modgetXs


      program main
      use   modgetXs
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, kXic0,
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync, kChaX
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, kXic0=37,
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=37+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3, kChaX=4,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: pj

      integer:: i, j
      real(8),allocatable:: xs( :,:)
      real(8):: E, temp, p, KE
      integer:: nela(1)
      integer,save::  kpj, pjcharge, pjsubcode, charge

      
      pjA = 1
      
      write(0,*) 'Enter projectile '
      write(0,*)
     *  ' p/n/p~/n~->1; pi->2; K->3; A->4;g->5; 0->stop'
      read(*,*)  kpj

      if( kpj >= 1 .and. kpj <= 5) then
         if(kpj ==  4) then
            write(0,*) ' Enter proj. A, Z (intger)'
            read(*,*)  pjA, pjZ
         elseif( kpj /= 5 ) then
            write(0,*)
     *      ' Enter proj. subcode & charge: / ==> Default=(-1 1)'
            write(0,*) ' subcode for ptcl=', regptcl
            write(0,*) ' subcode for anti-ptcl=', antip
            pjsubcode= -1
            pjcharge = 1
            read(*,*) pjsubcode, pjcharge
            if( kpj == 3 .and.  pjcharge==0 ) then
               pjsubcode = 4  ! k0short (5-->long)
            endif   
         endif
      elseif( kpj == 0) then
         stop
      else
         write(0,*) ' input=',kpj, ' invalid'
         stop
      endif
      write(0,*)
     * "Enter target A (or A's for compound/mixture target) with",
     * "  / at last pos. (# of A's  <= 15)"
      A(:) = 0.
      read(*,*) A(:)
      nela = minloc(A(:))
      nel = nela(1) -1
      if( nel == 0 ) stop
      if( nel == 1 ) then
         portion(nel) = 1.
         if(A(1) == 1.) then
            write(0,*) "Enter charge of target nucleon"
            read(*,*)  targetnucchg
         endif
      else
         write(0,*) "Enter relative portion of A's"
         read(*,*) portion(1:nel)
      endif

      temp = sum(portion(1:nel))

      portion(:) = portion(:)/temp

      call cgetXsIni
      ! make proj.
      if( kpj == 1 ) then
         call cmkptc(knuc, pjsubcode, pjcharge, pj)
      elseif( kpj == 2 ) then
         call cmkptc(kpion, pjsubcode, pjcharge, pj)
      elseif( kpj == 3 ) then
         call cmkptc(kkaon, pjsubcode, pjcharge, pj)
      elseif( kpj == 4) then
         call cmkptc(kgnuc, pjA, pjZ, pj)
      elseif( kpj == 5 ) then
         call cmkptc(kphoton, -1, 0, pj)
      else
         stop 'strange '
      endif

      if(kpj /= 5 .and.  E1 == 0.) then
         E1=pj%mass*1.1
      else
         E1= 155.e-3  ! 153MeV is threshold
      endif


      
      nebin = log10( E0max/E1 )/dE
      allocate( xs(nebin,3) )

      call computeXS(pj, xs)
!         output

      write(*,'(a,i2,i4,i3)') '# pj=',pj%code, pj%subcode, pj%charge
      write(*,'(a, 15i6)')    '#  target=', A(1:nel)
      write(*,'(a, 15f6.3))') '# portion=', portion(1:nel)
      if( kpj == 4 .and. ( nel>1 .or.  A(1)> 1.) ) then
         write(*,'(a)')
     *   '# Et(GeV)  Sinel(mb) p(GeV)  KE(Gev)'
      else
         write(*,'(a)') 
     *   '# Et(GeV)  Sinel  Stot Sel (mb) p(GeV) KE(GeV)'
      endif
      E= E1
      do i = 1, nebin
         p = sqrt( (E*pjA)**2 - pj%mass**2 )
         KE = E*pjA- pj%mass
         if( kpj == 4  .and. (nel > 1 .or. A(1) > 1.0))  then
            write(*,'(1p, 4g13.4 )')  E*pjA, xs(i,1), p, KE
     *
         else
            write(*,'(1p, 6g13.4 )')
     *         E*pjA, xs(i,1), xs(i,2), xs(i,3), p, KE
         endif
         E = E*10.d0** dE
         if(E*pjA> E0max) exit
      enddo
      end program main

