      subroutine cbremsPath(Ee, path)
!          generic brems sampling routine
      implicit none
#include "ZbpCnst.h"
!      entry cBrSampP(Ee, prob, path)


      real*8 Ee            ! input. Electron/positron energy in GeV
      real*8 prob          ! output. Brems prob. per r%l
      real*8 path          ! ouptut. sampled path in r%l

      real*8 u

      if(Ee .le. BrEemaxS) then
!            Seltzer region
         call cBrSSampP(Ee,  prob)
      elseif(Ee .le. CompScrE) then
!            screeinig region
         call cBrLSampP(Ee,  prob)
      elseif(Ee .le. BremEemaxL) then
!            complete screeing region
         call cBrCSampP(Ee, prob)
      else
!         LPM region;
!         call cBrHSampP(Ee, prob); this cannot be used due to rho change.
!         should not come here; LPM routine is called
!         from outer place. However, control may come here
!         because of small BremEemaxL ~ 94 GeV. 
!         If you are very serious about LPM, the effect may
!         be seen in 100 GeV region at very small gamma energies
!         However, the effect in air shower development could be
!         seen  at  least > 10^15 eV. Therefore  we use complete
!         screening cross section.
!         
         call cBrCSampP(Ee, prob)
      endif
      call rndc(u)
      path = - log(u)/prob
      end
!     *********************************** 
      subroutine cbremsEnergy(Ee, Eg)
      implicit none
#include "Zmass.h"
#include "ZbpCnst.h"


      real*8 Ee            ! input. e-/e+ energy in GeV
      real*8 Eg            ! output. sampled Eg in GeV


 10   continue
      if(Ee .le. BrEemaxS) then
!            Seltzer region
         call cBrSSampE(Ee,  Eg)

      elseif(Ee .le. CompScrE) then
!            screeinig region
         call cBrLSampE(Ee,  Eg)

      elseif(Ee .le. BremEemaxL) then
!            complete screeing region
         call cBrCSampE(Ee, Eg)

      else
!            LPM region; same as path part. should not come
!         call cBrHSampE(Ee, Eg)
        call cBrCSampE(Ee, Eg)
      endif
      if( Ee - masele <= Eg ) goto 10
      end
      block data cbpcnst
#include "ZbpCnst.h"
#include "ZbpTable.h"
      integer i


!          mb to /X0=
      data  mbtoPX0/1.513181d-3/
      data  X0g/  36.5667177404807/
!         #-#-#-#-#-#-#-#-#-#-#-#-

!       consts for Seltzer Brems sampling table 
      data BrEeminS/  7.110000000000000E-004/
      data BrEgminS/  1.000000000000000E-005/
      data BrLEeminS/ -3.14813039927023/
      data BrEemaxS/  .100000000000000/
      data BrUminSA/  .100000000000000/
      data BrUmaxSA/  1.00000000000000/
      data BrTXTS/  42/
      data BrdUSA/  2.250000000000000E-002/
      data BrdETXS/  5.239342437244470E-002/
      data BrdES/  5.239342437244470E-002/
      data BrUminSB/  .000000000000000/
      data BrUmaxSB/  .562341325190349/
      data BrdUSB/  1.405853312975870E-002/
      data BrES/  42/
      data BrUszSA/  41/
      data BrUszSB/  41/



!    consts for Brems sampling table at low energies
      data CompScrE/  77.0769320180600/
      data BremEgmin/  1.000000000000000E-004/
      data BremEemin/  1.000000000000000E-002/
      data BremLEemin/ -2.00000000000000/
      data BremEemaxL/  94.1908705778637/
      data BrScrE/  77.0769320180600/
      data BremUminLA/  .100000000000000/
      data BremUmaxLA/  1.00000000000000/
      data BremTXTL/  38/
      data BremdULA/  2.250000000000000E-002/
      data BremdETXL/  .105052011340642/
      data BremdEL/  .105052011340642/
      data BremUminLB/  .000000000000000/
      data BremUmaxLB/  .562341325190349/
      data BremdULB/  1.405853312975870E-002/
      data BremEsize/  38/
      data BremUszLA/  41/
      data BremUszLB/  41/

!                      
      data cScrMain/386.870194/    ! v6.35 is 1/2 of this but mbtoPX0 was
      data cScrC1/285.08480/       ! x2 


!   Brem at Seltzer table region: TX
          data ( BrTXS(i), i=  1,   42)/
     1     3.5802,  3.4417,  3.4355,  3.5145,  3.6535,  3.8269,  4.0274,
     2     4.2450,  4.4805,  4.7288,  4.9915,  5.2616,  5.5366,  5.8078,
     3     6.0833,  6.3569,  6.6300,  6.9025,  7.1736,  7.4395,  7.6975,
     4     7.9481,  8.2049,  8.4275,  8.6783,  8.9207,  9.1577,  9.3965,
     5     9.6267,  9.8608, 10.0901, 10.3108, 10.5329, 10.7511, 10.9644,
     6     11.1759, 11.3834, 11.5873, 11.7877, 11.9819, 12.1756, 11.4255
     * /

!  Brem at Selzer table region; Region A
          data ( BrSTSA(i,   1), i=  1,   41)/
     1  2.53937, 2.48953, 2.44582, 2.40693, 2.37197, 2.34022, 2.31130,
     2  2.28472, 2.26013, 2.23734, 2.21614, 2.19632, 2.17776, 2.16032,
     3  2.14387, 2.12836, 2.11369, 2.09983, 2.08665, 2.07409, 2.06214,
     4  2.05074, 2.03986, 2.02950, 2.01955, 2.01005, 2.00095, 1.99230,
     5  1.98394, 1.97597, 1.96831, 1.96096, 1.95388, 1.94704, 1.94062,
     6  1.93431, 1.92829, 1.92239, 1.91690, 1.91120, 1.90613            
     * /   
          data ( BrSTSA(i,   2), i=  1,   41)/
     1  2.80875, 2.75220, 2.70304, 2.65956, 2.62078, 2.58568, 2.55379,
     2  2.52473, 2.49799, 2.47331, 2.45038, 2.42908, 2.40920, 2.39059,
     3  2.37311, 2.35660, 2.34105, 2.32634, 2.31245, 2.29928, 2.28681,
     4  2.27495, 2.26362, 2.25285, 2.24251, 2.23270, 2.22329, 2.21430,
     5  2.20574, 2.19753, 2.18968, 2.18209, 2.17490, 2.16793, 2.16121,
     6  2.15480, 2.14874, 2.14276, 2.13694, 2.13169, 2.12627            
     * /   
          data ( BrSTSA(i,   3), i=  1,   41)/
     1  3.02830, 2.96716, 2.91424, 2.86778, 2.82632, 2.78924, 2.75570,
     2  2.72517, 2.69714, 2.67131, 2.64746, 2.62529, 2.60457, 2.58518,
     3  2.56700, 2.54998, 2.53397, 2.51884, 2.50448, 2.49082, 2.47778,
     4  2.46547, 2.45375, 2.44253, 2.43194, 2.42182, 2.41218, 2.40295,
     5  2.39419, 2.38576, 2.37771, 2.37002, 2.36270, 2.35567, 2.34888,
     6  2.34238, 2.33617, 2.33018, 2.32457, 2.31923, 2.31378            
     * /   
          data ( BrSTSA(i,   4), i=  1,   41)/
     1  3.22023, 3.15562, 3.10002, 3.05125, 3.00816, 2.96958, 2.93474,
     2  2.90303, 2.87403, 2.84739, 2.82272, 2.79983, 2.77857, 2.75876,
     3  2.74025, 2.72280, 2.70620, 2.69047, 2.67560, 2.66154, 2.64814,
     4  2.63552, 2.62358, 2.61220, 2.60139, 2.59114, 2.58137, 2.57205,
     5  2.56319, 2.55478, 2.54672, 2.53901, 2.53170, 2.52470, 2.51801,
     6  2.51155, 2.50549, 2.49952, 2.49388, 2.48863, 2.48342            
     * /   
          data ( BrSTSA(i,   5), i=  1,   41)/
     1  3.39519, 3.32740, 3.26898, 3.21803, 3.17295, 3.13273, 3.09654,
     2  3.06380, 3.03399, 3.00670, 2.98161, 2.95849, 2.93710, 2.91706,
     3  2.89814, 2.88026, 2.86349, 2.84763, 2.83263, 2.81859, 2.80534,
     4  2.79278, 2.78091, 2.76965, 2.75901, 2.74893, 2.73940, 2.73027,
     5  2.72167, 2.71345, 2.70564, 2.69825, 2.69116, 2.68444, 2.67805,
     6  2.67182, 2.66595, 2.66043, 2.65518, 2.64987, 2.64503            
     * /   
          data ( BrSTSA(i,   6), i=  1,   41)/
     1  3.56158, 3.49147, 3.43118, 3.37866, 3.33234, 3.29110, 3.25417,
     2  3.22084, 3.19056, 3.16295, 3.13765, 3.11434, 3.09244, 3.07185,
     3  3.05242, 3.03433, 3.01714, 3.00112, 2.98612, 2.97194, 2.95859,
     4  2.94603, 2.93417, 2.92298, 2.91242, 2.90245, 2.89298, 2.88403,
     5  2.87553, 2.86748, 2.85983, 2.85265, 2.84575, 2.83918, 2.83288,
     6  2.82695, 2.82140, 2.81586, 2.81067, 2.80585, 2.80112            
     * /   
          data ( BrSTSA(i,   7), i=  1,   41)/
     1  3.72188, 3.64982, 3.58806, 3.53431, 3.48701, 3.44504, 3.40753,
     2  3.37373, 3.34310, 3.31522, 3.28965, 3.26568, 3.24316, 3.22206,
     3  3.20234, 3.18377, 3.16657, 3.15041, 3.13525, 3.12100, 3.10766,
     4  3.09511, 3.08333, 3.07220, 3.06176, 3.05187, 3.04256, 3.03374,
     5  3.02539, 3.01755, 3.01011, 3.00303, 2.99628, 2.98990, 2.98390,
     6  2.97810, 2.97261, 2.96742, 2.96249, 2.95811, 2.95326            
     * /   
          data ( BrSTSA(i,   8), i=  1,   41)/
     1  3.87855, 3.80518, 3.74243, 3.68790, 3.64002, 3.59758, 3.55968,
     2  3.52562, 3.49478, 3.46669, 3.44083, 3.41683, 3.39444, 3.37360,
     3  3.35408, 3.33587, 3.31880, 3.30279, 3.28776, 3.27363, 3.26035,
     4  3.24785, 3.23610, 3.22498, 3.21452, 3.20466, 3.19530, 3.18648,
     5  3.17816, 3.17023, 3.16275, 3.15568, 3.14896, 3.14255, 3.13651,
     6  3.13074, 3.12520, 3.11999, 3.11513, 3.11055, 3.10586            
     * /   
          data ( BrSTSA(i,   9), i=  1,   41)/
     1  4.03210, 3.95786, 3.89447, 3.83943, 3.79099, 3.74800, 3.70962,
     2  3.67506, 3.64379, 3.61518, 3.58870, 3.56407, 3.54119, 3.51980,
     3  3.49991, 3.48133, 3.46393, 3.44763, 3.43240, 3.41810, 3.40469,
     4  3.39207, 3.38024, 3.36912, 3.35865, 3.34878, 3.33946, 3.33068,
     5  3.32239, 3.31458, 3.30718, 3.30016, 3.29354, 3.28734, 3.28135,
     6  3.27570, 3.27040, 3.26520, 3.26047, 3.25623, 3.25159            
     * /   
          data ( BrSTSA(i,   10), i=  1,   41)/
     1  4.18476, 4.11000, 4.04622, 3.99074, 3.94181, 3.89831, 3.85943,
     2  3.82440, 3.79265, 3.76339, 3.73631, 3.71119, 3.68772, 3.66595,
     3  3.64568, 3.62678, 3.60910, 3.59263, 3.57722, 3.56280, 3.54931,
     4  3.53669, 3.52484, 3.51373, 3.50330, 3.49349, 3.48426, 3.47560,
     5  3.46740, 3.45969, 3.45246, 3.44557, 3.43913, 3.43295, 3.42719,
     6  3.42175, 3.41660, 3.41173, 3.40692, 3.40226, 3.39840            
     * /   
          data ( BrSTSA(i,   11), i=  1,   41)/
     1  4.33358, 4.25785, 4.19329, 4.13717, 4.08777, 4.04401, 4.00497,
     2  3.96986, 3.93798, 3.90857, 3.88131, 3.85608, 3.83263, 3.81091,
     3  3.79069, 3.77187, 3.75437, 3.73807, 3.72287, 3.70867, 3.69543,
     4  3.68306, 3.67147, 3.66063, 3.65047, 3.64094, 3.63204, 3.62364,
     5  3.61575, 3.60832, 3.60137, 3.59480, 3.58863, 3.58276, 3.57732,
     6  3.57208, 3.56715, 3.56257, 3.55817, 3.55414, 3.55009            
     * /   
          data ( BrSTSA(i,   12), i=  1,   41)/
     1  4.48153, 4.40499, 4.33983, 4.28326, 4.23363, 4.18978, 4.15077,
     2  4.11574, 4.08377, 4.05432, 4.02712, 4.00187, 3.97859, 3.95700,
     3  3.93695, 3.91834, 3.90107, 3.88502, 3.87011, 3.85619, 3.84324,
     4  3.83118, 3.81992, 3.80941, 3.79959, 3.79036, 3.78176, 3.77370,
     5  3.76613, 3.75905, 3.75238, 3.74609, 3.74024, 3.73472, 3.72953,
     6  3.72462, 3.71993, 3.71549, 3.71164, 3.70772, 3.70397            
     * /   
          data ( BrSTSA(i,   13), i=  1,   41)/
     1  4.62845, 4.55166, 4.48631, 4.42959, 4.37986, 4.33592, 4.29679,
     2  4.26160, 4.22935, 4.19959, 4.17210, 4.14671, 4.12328, 4.10156,
     3  4.08148, 4.06287, 4.04563, 4.02964, 4.01481, 4.00102, 3.98822,
     4  3.97631, 3.96521, 3.95490, 3.94527, 3.93627, 3.92788, 3.92002,
     5  3.91266, 3.90581, 3.89939, 3.89329, 3.88767, 3.88240, 3.87735,
     6  3.87265, 3.86832, 3.86418, 3.86008, 3.85678, 3.85310            
     * /   
          data ( BrSTSA(i,   14), i=  1,   41)/
     1  4.77619, 4.69972, 4.63458, 4.57801, 4.52831, 4.48428, 4.44494,
     2  4.40942, 4.37667, 4.34649, 4.31856, 4.29284, 4.26905, 4.24710,
     3  4.22682, 4.20805, 4.19073, 4.17467, 4.15984, 4.14607, 4.13333,
     4  4.12148, 4.11049, 4.10029, 4.09077, 4.08193, 4.07368, 4.06598,
     5  4.05881, 4.05210, 4.04583, 4.03996, 4.03450, 4.02940, 4.02451,
     6  4.02003, 4.01582, 4.01189, 4.00821, 4.00461, 4.00131            
     * /   
          data ( BrSTSA(i,   15), i=  1,   41)/
     1  4.92266, 4.84664, 4.78186, 4.72554, 4.67596, 4.63192, 4.59246,
     2  4.55657, 4.52342, 4.49283, 4.46454, 4.43848, 4.41442, 4.39224,
     3  4.37178, 4.35293, 4.33551, 4.31946, 4.30460, 4.29090, 4.27820,
     4  4.26645, 4.25556, 4.24549, 4.23611, 4.22741, 4.21932, 4.21180,
     5  4.20476, 4.19825, 4.19216, 4.18649, 4.18124, 4.17624, 4.17166,
     6  4.16721, 4.16328, 4.15938, 4.15578, 4.15234, 4.14938            
     * /   
          data ( BrSTSA(i,   16), i=  1,   41)/
     1  5.06823, 4.99281, 4.92858, 4.87270, 4.82341, 4.77946, 4.73997,
     2  4.70380, 4.67031, 4.63935, 4.61076, 4.58442, 4.56011, 4.53775,
     3  4.51717, 4.49823, 4.48078, 4.46471, 4.44988, 4.43625, 4.42362,
     4  4.41197, 4.40121, 4.39127, 4.38204, 4.37351, 4.36558, 4.35822,
     5  4.35141, 4.34503, 4.33916, 4.33364, 4.32856, 4.32374, 4.31931,
     6  4.31519, 4.31119, 4.30767, 4.30423, 4.30100, 4.29809            
     * /   
          data ( BrSTSA(i,   17), i=  1,   41)/
     1  5.21300, 5.13812, 5.07431, 5.01881, 4.96974, 4.92592, 4.88637,
     2  4.84997, 4.81617, 4.78488, 4.75603, 4.72942, 4.70493, 4.68242,
     3  4.66173, 4.64274, 4.62528, 4.60922, 4.59449, 4.58089, 4.56842,
     4  4.55690, 4.54627, 4.53644, 4.52739, 4.51903, 4.51128, 4.50413,
     5  4.49748, 4.49130, 4.48559, 4.48030, 4.47534, 4.47071, 4.46645,
     6  4.46255, 4.45877, 4.45533, 4.45203, 4.44901, 4.44628            
     * /   
          data ( BrSTSA(i,   18), i=  1,   41)/
     1  5.35660, 5.28181, 5.21813, 5.16272, 5.11375, 5.06997, 5.03038,
     2  4.99377, 4.95976, 4.92818, 4.89916, 4.87236, 4.84776, 4.82516,
     3  4.80447, 4.78549, 4.76809, 4.75213, 4.73748, 4.72406, 4.71171,
     4  4.70035, 4.68992, 4.68028, 4.67145, 4.66326, 4.65574, 4.64874,
     5  4.64230, 4.63638, 4.63087, 4.62571, 4.62099, 4.61655, 4.61257,
     6  4.60876, 4.60517, 4.60196, 4.59876, 4.59592, 4.59335            
     * /   
          data ( BrSTSA(i,   19), i=  1,   41)/
     1  5.49964, 5.42526, 5.36185, 5.30665, 5.25779, 5.21403, 5.17431,
     2  5.13730, 5.10290, 5.07096, 5.04154, 5.01442, 4.98953, 4.96675,
     3  4.94589, 4.92680, 4.90935, 4.89336, 4.87876, 4.86537, 4.85310,
     4  4.84184, 4.83149, 4.82202, 4.81330, 4.80528, 4.79790, 4.79106,
     5  4.78478, 4.77902, 4.77365, 4.76872, 4.76413, 4.75992, 4.75590,
     6  4.75234, 4.74902, 4.74575, 4.74295, 4.74016, 4.73767            
     * /   
          data ( BrSTSA(i,   20), i=  1,   41)/
     1  5.64240, 5.56853, 5.50554, 5.45062, 5.40194, 5.35823, 5.31834,
     2  5.28098, 5.24614, 5.21378, 5.18393, 5.15646, 5.13128, 5.10823,
     3  5.08719, 5.06799, 5.05043, 5.03443, 5.01983, 5.00647, 4.99425,
     4  4.98309, 4.97284, 4.96347, 4.95486, 4.94700, 4.93972, 4.93307,
     5  4.92694, 4.92132, 4.91612, 4.91133, 4.90689, 4.90279, 4.89899,
     6  4.89557, 4.89220, 4.88922, 4.88641, 4.88365, 4.88153            
     * /   
          data ( BrSTSA(i,   21), i=  1,   41)/
     1  5.78521, 5.71206, 5.64968, 5.59522, 5.54686, 5.50341, 5.46345,
     2  5.42589, 5.39070, 5.35801, 5.32779, 5.30002, 5.27458, 5.25135,
     3  5.23015, 5.21086, 5.19328, 5.17726, 5.16268, 5.14938, 5.13726,
     4  5.12620, 5.11607, 5.10683, 5.09840, 5.09065, 5.08354, 5.07707,
     5  5.07108, 5.06563, 5.06058, 5.05596, 5.05168, 5.04773, 5.04416,
     6  5.04072, 5.03760, 5.03486, 5.03217, 5.02956, 5.02745            
     * /   
          data ( BrSTSA(i,   22), i=  1,   41)/
     1  5.92746, 5.85504, 5.79325, 5.73926, 5.69129, 5.64806, 5.60805,
     2  5.57024, 5.53468, 5.50168, 5.47110, 5.44302, 5.41733, 5.39390,
     3  5.37261, 5.35323, 5.33562, 5.31963, 5.30509, 5.29187, 5.27983,
     4  5.26888, 5.25890, 5.24984, 5.24154, 5.23394, 5.22703, 5.22068,
     5  5.21489, 5.20954, 5.20467, 5.20017, 5.19609, 5.19230, 5.18884,
     6  5.18569, 5.18266, 5.18000, 5.17752, 5.17506, 5.17298            
     * /   
          data ( BrSTSA(i,   23), i=  1,   41)/
     1  6.06787, 5.99577, 5.93416, 5.88023, 5.83223, 5.78890, 5.74850,
     2  5.71019, 5.67404, 5.64050, 5.60947, 5.58101, 5.55503, 5.53141,
     3  5.50996, 5.49051, 5.47288, 5.45690, 5.44244, 5.42928, 5.41738,
     4  5.40653, 5.39670, 5.38777, 5.37963, 5.37222, 5.36543, 5.35925,
     5  5.35364, 5.34845, 5.34378, 5.33945, 5.33547, 5.33184, 5.32854,
     6  5.32545, 5.32260, 5.32012, 5.31770, 5.31575, 5.31347            
     * /   
          data ( BrSTSA(i,   24), i=  1,   41)/
     1  6.21151, 6.14035, 6.07939, 6.02618, 5.97906, 5.93647, 5.89717,
     2  5.86043, 5.82586, 5.79327, 5.76264, 5.73399, 5.70731, 5.68258,
     3  5.65977, 5.63875, 5.61948, 5.60184, 5.58571, 5.57096, 5.55748,
     4  5.54520, 5.53398, 5.52379, 5.51445, 5.50593, 5.49816, 5.49106,
     5  5.48457, 5.47862, 5.47319, 5.46827, 5.46370, 5.45952, 5.45577,
     6  5.45223, 5.44902, 5.44597, 5.44325, 5.44093, 5.43846            
     * /   
          data ( BrSTSA(i,   25), i=  1,   41)/
     1  6.35094, 6.28008, 6.21931, 6.16616, 6.11903, 6.07627, 6.03670,
     2  5.99955, 5.96446, 5.93135, 5.90019, 5.87105, 5.84394, 5.81886,
     3  5.79577, 5.77457, 5.75518, 5.73746, 5.72129, 5.70657, 5.69318,
     4  5.68097, 5.66987, 5.65979, 5.65059, 5.64223, 5.63465, 5.62769,
     5  5.62140, 5.61559, 5.61038, 5.60554, 5.60116, 5.59714, 5.59347,
     6  5.59007, 5.58697, 5.58422, 5.58170, 5.57913, 5.57706            
     * /   
          data ( BrSTSA(i,   26), i=  1,   41)/
     1  6.48887, 6.41818, 6.35743, 6.30428, 6.25703, 6.21404, 6.17408,
     2  6.13646, 6.10086, 6.06720, 6.03556, 6.00601, 5.97858, 5.95328,
     3  5.93000, 5.90872, 5.88932, 5.87161, 5.85554, 5.84094, 5.82767,
     4  5.81568, 5.80476, 5.79486, 5.78588, 5.77773, 5.77033, 5.76361,
     5  5.75748, 5.75191, 5.74688, 5.74222, 5.73804, 5.73420, 5.73071,
     6  5.72746, 5.72465, 5.72201, 5.71943, 5.71725, 5.71518            
     * /   
          data ( BrSTSA(i,   27), i=  1,   41)/
     1  6.62576, 6.55514, 6.49435, 6.44110, 6.39366, 6.35038, 6.30998,
     2  6.27184, 6.23568, 6.20153, 6.16943, 6.13954, 6.11186, 6.08635,
     3  6.06303, 6.04172, 6.02236, 6.00478, 5.98886, 5.97443, 5.96139,
     4  5.94956, 5.93890, 5.92922, 5.92046, 5.91256, 5.90539, 5.89888,
     5  5.89301, 5.88765, 5.88279, 5.87840, 5.87442, 5.87076, 5.86746,
     6  5.86437, 5.86166, 5.85909, 5.85693, 5.85442, 5.85279            
     * /   
          data ( BrSTSA(i,   28), i=  1,   41)/
     1  6.76252, 6.69200, 6.63118, 6.57782, 6.53019, 6.48658, 6.44571,
     2  6.40703, 6.37032, 6.33561, 6.30305, 6.27275, 6.24478, 6.21912,
     3  6.19570, 6.17438, 6.15506, 6.13757, 6.12177, 6.10752, 6.09468,
     4  6.08306, 6.07260, 6.06315, 6.05462, 6.04694, 6.03998, 6.03373,
     5  6.02803, 6.02288, 6.01828, 6.01403, 6.01019, 6.00671, 6.00360,
     6  6.00065, 5.99803, 5.99573, 5.99346, 5.99128, 5.98979            
     * /   
          data ( BrSTSA(i,   29), i=  1,   41)/
     1  6.89751, 6.82689, 6.76589, 6.71231, 6.66437, 6.62031, 6.57893,
     2  6.53966, 6.50235, 6.46711, 6.43417, 6.40355, 6.37540, 6.34963,
     3  6.32622, 6.30497, 6.28579, 6.26847, 6.25287, 6.23885, 6.22624,
     4  6.21487, 6.20466, 6.19549, 6.18724, 6.17979, 6.17308, 6.16706,
     5  6.16159, 6.15668, 6.15222, 6.14821, 6.14460, 6.14133, 6.13835,
     6  6.13566, 6.13326, 6.13097, 6.12902, 6.12712, 6.12538            
     * /   
          data ( BrSTSA(i,   30), i=  1,   41)/
     1  7.03317, 6.96253, 6.90141, 6.84764, 6.79942, 6.75494, 6.71302,
     2  6.67312, 6.63520, 6.59943, 6.56601, 6.53510, 6.50671, 6.48084,
     3  6.45735, 6.43618, 6.41707, 6.39993, 6.38450, 6.37069, 6.35830,
     4  6.34718, 6.33721, 6.32827, 6.32021, 6.31304, 6.30654, 6.30075,
     5  6.29551, 6.29076, 6.28657, 6.28271, 6.27925, 6.27615, 6.27328,
     6  6.27075, 6.26841, 6.26635, 6.26450, 6.26287, 6.26114            
     * /   
          data ( BrSTSA(i,   31), i=  1,   41)/
     1  7.16753, 7.09675, 7.03542, 6.98139, 6.93282, 6.88786, 6.84535,
     2  6.80481, 6.76627, 6.72997, 6.69613, 6.66490, 6.63633, 6.61039,
     3  6.58692, 6.56581, 6.54686, 6.52989, 6.51469, 6.50108, 6.48895,
     4  6.47805, 6.46834, 6.45965, 6.45188, 6.44490, 6.43867, 6.43307,
     5  6.42803, 6.42353, 6.41949, 6.41581, 6.41258, 6.40962, 6.40695,
     6  6.40448, 6.40233, 6.40045, 6.39860, 6.39718, 6.39550            
     * /   
          data ( BrSTSA(i,   32), i=  1,   41)/
     1  7.29959, 7.22849, 7.16677, 7.11239, 7.06334, 7.01780, 6.97462,
     2  6.93341, 6.89427, 6.85746, 6.82325, 6.79179, 6.76311, 6.73715,
     3  6.71378, 6.69282, 6.67404, 6.65731, 6.64233, 6.62901, 6.61714,
     4  6.60652, 6.59708, 6.58867, 6.58111, 6.57443, 6.56843, 6.56303,
     5  6.55826, 6.55397, 6.55006, 6.54664, 6.54348, 6.54067, 6.53818,
     6  6.53591, 6.53382, 6.53196, 6.53051, 6.52913, 6.52750            
     * /   
          data ( BrSTSA(i,   33), i=  1,   41)/
     1  7.43226, 7.36089, 7.29884, 7.24411, 7.19465, 7.14853, 7.10470,
     2  7.06286, 7.02312, 6.98586, 6.95129, 6.91961, 6.89088, 6.86492,
     3  6.84167, 6.82085, 6.80229, 6.78579, 6.77109, 6.75804, 6.74642,
     4  6.73611, 6.72693, 6.71875, 6.71151, 6.70501, 6.69923, 6.69412,
     5  6.68953, 6.68542, 6.68172, 6.67846, 6.67552, 6.67291, 6.67051,
     6  6.66837, 6.66642, 6.66468, 6.66316, 6.66187, 6.66049            
     * /   
          data ( BrSTSA(i,   34), i=  1,   41)/
     1  7.56396, 7.49227, 7.42987, 7.37476, 7.32484, 7.27819, 7.23372,
     2  7.19125, 7.15098, 7.11328, 7.07845, 7.04667, 7.01790, 6.99205,
     3  6.96894, 6.94834, 6.93002, 6.91377, 6.89937, 6.88660, 6.87529,
     4  6.86526, 6.85637, 6.84847, 6.84147, 6.83525, 6.82974, 6.82483,
     5  6.82044, 6.81651, 6.81303, 6.80995, 6.80717, 6.80467, 6.80246,
     6  6.80043, 6.79862, 6.79698, 6.79565, 6.79446, 6.79310            
     * /   
          data ( BrSTSA(i,   35), i=  1,   41)/
     1  7.69453, 7.62246, 7.55968, 7.50421, 7.45382, 7.40661, 7.36153,
     2  7.31847, 7.27773, 7.23970, 7.20470, 7.17286, 7.14416, 7.11847,
     3  7.09556, 7.07527, 7.05723, 7.04133, 7.02723, 7.01480, 7.00380,
     4  6.99408, 6.98546, 6.97788, 6.97113, 6.96515, 6.95987, 6.95521,
     5  6.95103, 6.94730, 6.94406, 6.94109, 6.93848, 6.93609, 6.93407,
     6  6.93216, 6.93049, 6.92894, 6.92750, 6.92635, 6.92534            
     * /   
          data ( BrSTSA(i,   36), i=  1,   41)/
     1  7.82494, 7.75257, 7.68944, 7.63363, 7.58285, 7.53510, 7.48948,
     2  7.44592, 7.40478, 7.36652, 7.33143, 7.29960, 7.27106, 7.24557,
     3  7.22297, 7.20297, 7.18530, 7.16971, 7.15595, 7.14385, 7.13321,
     4  7.12382, 7.11551, 7.10819, 7.10175, 7.09604, 7.09096, 7.08652,
     5  7.08257, 7.07906, 7.07595, 7.07317, 7.07074, 7.06849, 7.06657,
     6  7.06486, 7.06320, 7.06182, 7.06064, 7.05964, 7.05849            
     * /   
          data ( BrSTSA(i,   37), i=  1,   41)/
     1  7.95465, 7.88197, 7.81858, 7.76249, 7.71133, 7.66315, 7.61704,
     2  7.57309, 7.53167, 7.49327, 7.45819, 7.42652, 7.39819, 7.37302,
     3  7.35076, 7.33111, 7.31382, 7.29858, 7.28523, 7.27351, 7.26321,
     4  7.25414, 7.24616, 7.23913, 7.23297, 7.22753, 7.22271, 7.21850,
     5  7.21472, 7.21144, 7.20851, 7.20586, 7.20360, 7.20154, 7.19971,
     6  7.19808, 7.19670, 7.19532, 7.19416, 7.19334, 7.19223            
     * /   
          data ( BrSTSA(i,   38), i=  1,   41)/
     1  8.08385, 8.01093, 7.94733, 7.89105, 7.83962, 7.79108, 7.74461,
     2  7.70036, 7.65879, 7.62039, 7.58544, 7.55400, 7.52599, 7.50118,
     3  7.47930, 7.46006, 7.44320, 7.42842, 7.41545, 7.40410, 7.39413,
     4  7.38541, 7.37776, 7.37106, 7.36519, 7.36000, 7.35546, 7.35144,
     5  7.34793, 7.34477, 7.34205, 7.33962, 7.33747, 7.33554, 7.33379,
     6  7.33233, 7.33095, 7.32989, 7.32884, 7.32762, 7.32692            
     * /   
          data ( BrSTSA(i,   39), i=  1,   41)/
     1  8.21323, 8.14013, 8.07636, 8.01989, 7.96820, 7.91931, 7.87252,
     2  7.82803, 7.78635, 7.74799, 7.71322, 7.68205, 7.65438, 7.62996,
     3  7.60850, 7.58972, 7.57327, 7.55888, 7.54632, 7.53534, 7.52576,
     4  7.51738, 7.51008, 7.50367, 7.49805, 7.49315, 7.48879, 7.48503,
     5  7.48166, 7.47875, 7.47617, 7.47388, 7.47192, 7.47009, 7.46849,
     6  7.46716, 7.46589, 7.46472, 7.46380, 7.46289, 7.46215            
     * /   
          data ( BrSTSA(i,   40), i=  1,   41)/
     1  8.34194, 8.26865, 8.20473, 8.14813, 8.09621, 8.04703, 7.99998,
     2  7.95533, 7.91368, 7.87544, 7.84092, 7.81013, 7.78286, 7.75889,
     3  7.73791, 7.71958, 7.70356, 7.68965, 7.67753, 7.66694, 7.65772,
     4  7.64972, 7.64271, 7.63661, 7.63127, 7.62662, 7.62253, 7.61896,
     5  7.61578, 7.61303, 7.61065, 7.60854, 7.60666, 7.60498, 7.60349,
     6  7.60224, 7.60113, 7.60012, 7.59908, 7.59850, 7.59766            
     * /   
          data ( BrSTSA(i,   41), i=  1,   41)/
     1  8.47029, 8.39685, 8.33285, 8.27612, 8.22399, 8.17458, 8.12731,
     2  8.08259, 8.04094, 8.00291, 7.96872, 7.93830, 7.91147, 7.88799,
     3  7.86748, 7.84962, 7.83408, 7.82058, 7.80888, 7.79873, 7.78986,
     4  7.78218, 7.77552, 7.76971, 7.76463, 7.76019, 7.75636, 7.75300,
     5  7.75003, 7.74749, 7.74519, 7.74324, 7.74146, 7.73997, 7.73862,
     6  7.73738, 7.73632, 7.73550, 7.73466, 7.73398, 7.73321            
     * /   
          data ( BrSTSA(i,   42), i=  1,   41)/
     1  8.71164, 8.66027, 8.61920, 8.58603, 8.55899, 8.53679, 8.51847,
     2  8.50325, 8.49054, 8.47994, 8.47102, 8.46352, 8.45720, 8.45184,
     3  8.44732, 8.44347, 8.44021, 8.43745, 8.43506, 8.43307, 8.43133,
     4  8.42988, 8.42859, 8.42752, 8.42662, 8.42582, 8.42514, 8.42456,
     5  8.42405, 8.42360, 8.42324, 8.42287, 8.42262, 8.42239, 8.42212,
     6  8.42198, 8.42178, 8.42155, 8.42167, 8.42123, 7.26832            
     * /   


!  Brem at Seltzer table regtion: Region B
          data ( BrSTSB(i,   1), i=  1,   41)/
     1   17.97893,  18.84461,  17.93870,  17.98593,  17.97341,
     2   17.95559,  17.96709,  17.96985,  17.83043,  17.78198,
     3   17.62832,  17.50904,  17.31814,  17.09651,  16.82949,
     4   16.52173,  16.16613,  15.77945,  15.36073,  14.91968,
     5   14.46113,  13.99762,  13.52959,  13.06660,  12.61013,
     6   12.16490,  11.73142,  11.31178,  10.90723,  10.51736,
     7   10.14143,   9.77974,   9.43127,   9.09625,   8.77380,
     8    8.46428,   8.16724,   7.88284,   7.61097,   7.35115,
     9    7.10301                                                       
     * /   
          data ( BrSTSB(i,   2), i=  1,   41)/
     1   28.55232,  27.99600,  28.54876,  28.54257,  28.51611,
     2   28.47163,  28.43398,  28.31633,  28.07342,  27.74276,
     3   27.36340,  26.88565,  26.28611,  25.62088,  24.85586,
     4   24.04079,  23.16867,  22.27857,  21.38462,  20.49408,
     5   19.62295,  18.77724,  17.96151,  17.17878,  16.43195,
     6   15.72119,  15.04440,  14.40070,  13.78843,  13.20664,
     7   12.65233,  12.12454,  11.62225,  11.14535,  10.69268,
     8   10.26328,   9.85678,   9.47160,   9.10688,   8.76158,
     9    8.43437                                                       
     * /   
          data ( BrSTSB(i,   3), i=  1,   41)/
     1   40.79932,  40.15315,  40.71126,  40.77912,  40.71514,
     2   40.58040,  40.29033,  39.91775,  39.45145,  38.72385,
     3   37.78747,  36.66909,  35.40505,  34.03503,  32.58555,
     4   31.10209,  29.62447,  28.17710,  26.77818,  25.43364,
     5   24.15355,  22.93874,  21.79255,  20.70966,  19.68986,
     6   18.73149,  17.82693,  16.97458,  16.17038,  15.41149,
     7   14.69570,  14.02158,  13.38685,  12.78953,  12.22750,
     8   11.69861,  11.20093,  10.73256,  10.29137,   9.87559,
     9    9.48349                                                       
     * /   
          data ( BrSTSB(i,   4), i=  1,   41)/
     1   54.83263,  55.35069,  54.79047,  54.76282,  54.63386,
     2   54.33674,  53.85181,  53.09881,  51.86760,  50.42654,
     3   48.61886,  46.58029,  44.39588,  42.12844,  39.85588,
     4   37.65326,  35.52496,  33.50772,  31.60276,  29.81690,
     5   28.14332,  26.58058,  25.12137,  23.75905,  22.48619,
     6   21.29526,  20.17911,  19.13480,  18.15733,  17.24256,
     7   16.38782,  15.58811,  14.84010,  14.14038,  13.48590,
     8   12.87330,  12.29945,  11.76140,  11.25679,  10.78280,
     9   10.33720                                                       
     * /   
          data ( BrSTSB(i,   5), i=  1,   41)/
     1   70.46623,  70.59754,  70.41105,  70.30600,  70.03535,
     2   69.47380,  68.39675,  66.98853,  64.89957,  62.28799,
     3   59.32866,  56.12101,  52.84597,  49.59778,  46.46861,
     4   43.51918,  40.76323,  38.19507,  35.82031,  33.62199,
     5   31.59156,  29.71443,  27.97286,  26.35642,  24.85195,
     6   23.45218,  22.14810,  20.93560,  19.80749,  18.75931,
     7   17.78451,  16.87833,  16.03590,  15.25138,  14.52053,
     8   13.83922,  13.20359,  12.60958,  12.05434,  11.53421,
     9   11.04740                                                       
     * /   
          data ( BrSTSB(i,   6), i=  1,   41)/
     1   86.35222,  85.87245,  86.25099,  86.10340,  85.60916,
     2   84.62246,  82.96176,  80.41776,  77.10346,  73.16462,
     3   68.85136,  64.37326,  60.00978,  55.83117,  51.92663,
     4   48.32124,  45.01025,  41.98517,  39.21354,  36.67372,
     5   34.34321,  32.19445,  30.21082,  28.37790,  26.68280,
     6   25.11484,  23.66378,  22.32224,  21.08226,  19.93417,
     7   18.87137,  17.88728,  16.97475,  16.12768,  15.34045,
     8   14.60818,  13.92610,  13.29031,  12.69657,  12.14214,
     9   11.62354                                                       
     * /   
          data ( BrSTSB(i,   7), i=  1,   41)/
     1  102.24195, 101.16394, 102.11031, 101.84587, 101.06093,
     2   99.48074,  96.79832,  92.97477,  88.23045,  82.77704,
     3   76.99817,  71.33715,  65.92210,  60.90657,  56.31703,
     4   52.15556,  48.39342,  44.98691,  41.88367,  39.05933,
     5   36.47396,  34.10091,  31.92199,  29.91724,  28.07328,
     6   26.37882,  24.81927,  23.38313,  22.06018,  20.84117,
     7   19.71517,  18.67495,  17.71232,  16.82031,  15.99259,
     8   15.22344,  14.50790,  13.84145,  13.22011,  12.64023,
     9   12.09778                                                       
     * /   
          data ( BrSTSB(i,   8), i=  1,   41)/
     1  117.87142, 116.46531, 117.79234, 117.30135, 116.11068,
     2  113.74448, 110.05276, 104.57192,  98.12945,  91.02672,
     3   83.85732,  76.99100,  70.66052,  64.90682,  59.73135,
     4   55.10672,  50.96577,  47.24162,  43.88222,  40.82624,
     5   38.03963,  35.49604,  33.16649,  31.03763,  29.09005,
     6   27.30699,  25.67190,  24.17224,  22.79454,  21.52673,
     7   20.35853,  19.28058,  18.28403,  17.36171,  16.50584,
     8   15.71133,  14.97237,  14.28445,  13.64280,  13.04410,
     9   12.48417                                                       
     * /   
          data ( BrSTSB(i,   9), i=  1,   41)/
     1  132.88107, 131.77242, 132.72357, 132.08989, 130.38513,
     2  127.03331, 121.63867, 114.78119, 106.54605,  97.87122,
     3   89.39966,  81.50079,  74.34171,  67.95748,  62.30372,
     4   57.29968,  52.85984,  48.89108,  45.31814,  42.08042,
     5   39.14396,  36.47137,  34.03915,  31.82570,  29.80867,
     6   27.96980,  26.28816,  24.74984,  23.33885,  22.04201,
     7   20.84870,  19.74743,  18.72997,  17.78808,  16.91447,
     8   16.10299,  15.34808,  14.64497,  13.98927,  13.37684,
     9   12.80407                                                       
     * /   
          data ( BrSTSB(i,   10), i=  1,   41)/
     1  145.76119, 147.08258, 145.57168, 144.70836, 142.43270,
     2  138.03930, 131.22036, 122.60718, 112.89445, 102.82428,
     3   93.30531,  84.56745,  76.77320,  69.91872,  63.91990,
     4   58.64777,  53.99057,  49.84961,  46.13464,  42.78538,
     5   39.75483,  37.01293,  34.52679,  32.27197,  30.22613,
     6   28.36378,  26.66519,  25.11207,  23.68922,  22.38256,
     7   21.17988,  20.07006,  19.04427,  18.09427,  17.21280,
     8   16.39367,  15.63087,  14.91998,  14.25667,  13.63647,
     9   13.05623                                                       
     * /   
          data ( BrSTSB(i,   11), i=  1,   41)/
     1  159.37517, 159.35860, 158.98565, 157.88576, 154.89191,
     2  149.24014, 140.89249, 130.31487, 118.78723, 107.36913,
     3   96.70383,  87.17692,  78.78394,  71.50287,  65.17119,
     4   59.66228,  54.81346,  50.52221,  46.69573,  43.25889,
     5   40.17111,  37.38519,  34.86961,  32.59337,  30.53029,
     6   28.65574,  26.94826,  25.38766,  23.95893,  22.64685,
     7   21.43956,  20.32606,  19.29644,  18.34246,  17.45750,
     8   16.63468,  15.86851,  15.15426,  14.48760,  13.86422,
     9   13.28079                                                       
     * /   
          data ( BrSTSB(i,   12), i=  1,   41)/
     1  171.93135, 171.63008, 171.44776, 169.89770, 166.04192,
     2  159.02067, 148.97354, 136.50875, 123.40622, 110.69674,
     3   99.14319,  88.91341,  80.06177,  72.42834,  65.84853,
     4   60.15349,  55.17007,  50.78002,  46.88010,  43.40343,
     5   40.29355,  37.50052,  34.98471,  32.71347,  30.65683,
     6   28.78910,  27.08824,  25.53369,  24.11095,  22.80392,
     7   21.60175,  20.49186,  19.46576,  18.51471,  17.63181,
     8   16.81086,  16.04630,  15.33339,  14.66778,  14.04535,
     9   13.46239                                                       
     * /   
          data ( BrSTSB(i,   13), i=  1,   41)/
     1  184.93436, 183.89732, 184.09598, 182.13080, 177.18739,
     2  168.44008, 156.27398, 141.95131, 127.19828, 113.38492,
     3  101.00281,  90.19753,  80.94194,  73.00789,  66.21553,
     4   60.36077,  55.25758,  50.78743,  46.84908,  43.35215,
     5   40.24072,  37.45861,  34.96010,  32.70890,  30.67165,
     6   28.82300,  27.14013,  25.60209,  24.19287,  22.89860,
     7   21.70667,  20.60626,  19.58760,  18.64302,  17.76505,
     8   16.94833,  16.18710,  15.47697,  14.81344,  14.19250,
     9   13.61069                                                       
     * /   
          data ( BrSTSB(i,   14), i=  1,   41)/
     1  196.54886, 196.16057, 195.41003, 192.82030, 186.59261,
     2  175.96293, 161.75130, 145.59091, 129.54700, 114.86976,
     3  101.91303,  90.69651,  81.15175,  73.02995,  66.08423,
     4   60.11820,  54.94802,  50.44419,  46.49644,  43.01653,
     5   39.93313,  37.19004,  34.73308,  32.52293,  30.52576,
     6   28.71487,  27.06496,  25.55634,  24.17318,  22.90126,
     7   21.72848,  20.64399,  19.63937,  18.70605,  17.83802,
     8   17.02947,  16.27494,  15.57027,  14.91138,  14.29433,
     9   13.71580                                                       
     * /   
          data ( BrSTSB(i,   15), i=  1,   41)/
     1  208.35690, 208.42005, 206.71950, 203.42982, 195.55213,
     2  182.74762, 166.26501, 148.54325, 131.39371, 115.85881,
     3  102.41699,  90.86230,  81.06760,  72.78187,  65.71998,
     4   59.67432,  54.46994,  49.95842,  46.02971,  42.58228,
     5   39.54466,  36.84617,  34.43796,  32.27378,  30.32135,
     6   28.55048,  26.93608,  25.46031,  24.10578,  22.85875,
     7   21.70810,  20.64319,  19.65543,  18.73663,  17.88139,
     8   17.08326,  16.33794,  15.64094,  14.98821,  14.37628,
     9   13.80228                                                       
     * /   
          data ( BrSTSB(i,   16), i=  1,   41)/
     1  220.06492, 220.67598, 218.02480, 213.65898, 203.64943,
     2  188.42325, 169.93795, 150.71196, 132.58661, 116.37736,
     3  102.45292,  90.62605,  80.66017,  72.24257,  65.09702,
     4   59.01762,  53.80854,  49.32817,  45.44368,  42.04835,
     5   39.06704,  36.42856,  34.07438,  31.96266,  30.05706,
     6   28.32872,  26.75345,  25.31246,  23.98936,  22.77114,
     7   21.64561,  20.60350,  19.63550,  18.73489,  17.89532,
     8   17.11097,  16.37700,  15.68935,  15.04471,  14.43940,
     9   13.87098                                                       
     * /   
          data ( BrSTSB(i,   17), i=  1,   41)/
     1  231.59737, 229.88374, 229.13598, 223.39501, 210.90802,
     2  193.16036, 172.85270, 152.14184, 132.96062, 116.26283,
     3  102.03244,  90.04980,  79.97349,  71.48576,  64.31155,
     4   58.23693,  53.05684,  48.61701,  44.78140,  41.44645,
     5   38.52617,  35.94617,  33.65154,  31.59444,  29.74068,
     6   28.06041,  26.52814,  25.12539,  23.83753,  22.65025,
     7   21.55289,  20.53535,  19.58919,  18.70794,  17.88520,
     8   17.11547,  16.39422,  15.71784,  15.08259,  14.48582,
     9   13.92480                                                       
     * /   
          data ( BrSTSB(i,   18), i=  1,   41)/
     1  243.08556, 242.13229, 240.05312, 232.67548, 217.53028,
     2  197.16402, 174.80641, 152.72363, 132.73935, 115.59517,
     3  101.20829,  89.14286,  79.05241,  70.57184,  63.42927,
     4   57.39791,  52.26568,  47.87924,  44.09757,  40.81763,
     5   37.95052,  35.42868,  33.19069,  31.18984,  29.39095,
     6   27.76045,  26.27558,  24.91627,  23.66646,  22.51308,
     7   21.44479,  20.45224,  19.52839,  18.66595,  17.85944,
     8   17.10427,  16.39630,  15.73201,  15.10809,  14.52171,
     9   13.97033                                                       
     * /   
          data ( BrSTSB(i,   19), i=  1,   41)/
     1  254.53039, 254.37799, 250.96683, 241.53808, 223.26601,
     2  200.11686, 175.94817, 152.70135, 132.06619, 114.70380,
     3  100.15744,  88.05321,  77.96346,  69.49388,  62.40388,
     4   56.42632,  51.37173,  47.05093,  43.34521,  40.13334,
     5   37.33695,  34.87975,  32.70354,  30.76300,  29.01861,
     6   27.43799,  26.00007,  24.68188,  23.46940,  22.34970,
     7   21.31165,  20.34617,  19.44568,  18.60449,  17.81660,
     8   17.07804,  16.38512,  15.73397,  15.12194,  14.54628,
     9   14.00441                                                       
     * /   
          data ( BrSTSB(i,   20), i=  1,   41)/
     1  265.73443, 263.57386, 261.68695, 249.75709, 228.05565,
     2  202.15096, 176.03981, 151.94675, 130.96210, 113.36236,
     3   98.81032,  86.70656,  76.65435,  68.28326,  61.26912,
     4   55.37923,  50.40700,  46.17157,  42.54437,  39.41283,
     5   36.68866,  34.30000,  32.18889,  30.30720,  28.61802,
     6   27.08930,  25.69665,  24.42104,  23.24736,  22.16218,
     7   21.15529,  20.21828,  19.34325,  18.52446,  17.75689,
     8   17.03643,  16.35937,  15.72234,  15.12310,  14.55862,
     9   14.02702                                                       
     * /   
          data ( BrSTSB(i,   21), i=  1,   41)/
     1  276.60610, 275.81373, 272.02305, 257.10662, 231.99463,
     2  203.48646, 175.79203, 150.68041, 129.17318, 111.53240,
     3   97.02374,  85.03219,  75.15142,  66.91767,  60.03942,
     4   54.27547,  49.40431,  45.26697,  41.72704,  38.67272,
     5   36.01922,  33.69648,  31.64745,  29.82450,  28.18850,
     6   26.71071,  25.36486,  24.13263,  22.99871,  21.94968,
     7   20.97601,  20.06840,  19.22020,  18.42541,  17.67929,
     8   16.97798,  16.31800,  15.69598,  15.11014,  14.55763,
     9   14.03671                                                       
     * /   
          data ( BrSTSB(i,   22), i=  1,   41)/
     1  287.11580, 285.00308, 281.78471, 263.62427, 234.98766,
     2  203.97704, 174.83241, 148.86488, 127.06115, 109.37998,
     3   94.98556,  83.21238,  73.48826,  65.44924,  58.73299,
     4   53.10540,  48.36231,  44.33134,  40.88486,  37.91244,
     5   35.33320,  33.07712,  31.09103,  29.32624,  27.74573,
     6   26.31764,  25.01970,  23.83108,  22.73659,  21.72423,
     7   20.78381,  19.90668,  19.08624,  18.31594,  17.59237,
     8   16.91089,  16.26861,  15.66237,  15.09040,  14.55046,
     9   14.04075                                                       
     * /   
          data ( BrSTSB(i,   23), i=  1,   41)/
     1  297.83614, 297.23797, 291.73411, 269.83723, 237.26125,
     2  203.69125, 173.19427, 146.84506, 124.92424, 107.33116,
     3   93.13290,  81.46501,  71.89494,  63.98971,  57.42263,
     4   51.92432,  47.29951,  43.37923,  40.02564,  37.14443,
     5   34.64578,  32.46270,  30.54377,  28.83989,  27.31413,
     6   25.93812,  24.68693,  23.54164,  22.48620,  21.50948,
     7   20.60138,  19.75344,  18.95930,  18.21296,  17.51084,
     8   16.84910,  16.22439,  15.63425,  15.07656,  14.54985,
     9   14.05200                                                       
     * /   
          data ( BrSTSB(i,   24), i=  1,   41)/
     1  307.28470, 306.42184, 299.39395, 271.30131, 239.23440,
     2  205.23660, 172.73982, 145.13634, 123.16060, 105.51476,
     3   91.27482,  79.68667,  70.22240,  62.43094,  55.98677,
     4   50.64002,  46.13865,  42.33099,  39.08222,  36.29316,
     5   33.87793,  31.77168,  29.92078,  28.27994,  26.81305,
     6   25.49014,  24.28843,  23.18790,  22.17414,  21.23525,
     7   20.36136,  19.54515,  18.77945,  18.05929,  17.38085,
     8   16.74047,  16.13553,  15.56337,  15.02203,  14.51013,
     9   14.02605                                                       
     * /   
          data ( BrSTSB(i,   25), i=  1,   41)/
     1  317.75322, 315.60315, 308.38530, 275.77510, 240.32070,
     2  204.23068, 170.44914, 142.59886, 120.71875, 103.27448,
     3   89.17765,  77.79861,  68.51025,  60.91244,  54.62195,
     4   49.41733,  45.05560,  41.36278,  38.21758,  35.51755,
     5   33.18164,  31.14773,  29.36199,  27.78234,  26.37059,
     6   25.09813,  23.94216,  22.88441,  21.91013,  21.00679,
     7   20.16531,  19.37852,  18.64020,  17.94499,  17.28885,
     8   16.66871,  16.08207,  15.52666,  15.00059,  14.50241,
     9   14.03063                                                       
     * /   
          data ( BrSTSB(i,   26), i=  1,   41)/
     1  327.77834, 324.78212, 316.61188, 279.37972, 240.62878,
     2  202.68910, 168.20123, 139.92034, 118.09782, 100.86208,
     3   87.00663,  75.80607,  66.76223,  59.35393,  53.24788,
     4   48.20320,  43.97300,  40.39961,  37.36068,  34.75423,
     5   32.50031,  30.54016,  28.82019,  27.29889,  25.94123,
     6   24.71822,  23.60797,  22.59201,  21.65567,  20.78774,
     7   19.97897,  19.22170,  18.50995,  17.83894,  17.20509,
     8   16.60536,  16.03684,  15.49797,  14.98694,  14.50223,
     9   14.04268                                                       
     * /   
          data ( BrSTSB(i,   27), i=  1,   41)/
     1  337.51021, 337.00885, 324.26431, 282.19056, 240.25426,
     2  200.71484, 165.13915, 137.12835, 115.40994,  98.40757,
     3   84.76842,  73.79440,  64.98154,  57.78543,  51.87659,
     4   46.98327,  42.89797,  39.44708,  36.51219,  33.99763,
     5   31.82690,  29.93905,  28.28542,  26.82272,  25.51796,
     6   24.34449,  23.27900,  22.30483,  21.40634,  20.57310,
     7   19.79644,  19.06818,  18.38337,  17.73716,  17.12541,
     8   16.54562,  15.99556,  15.47324,  14.97703,  14.50577,
     9   14.05840                                                       
     * /   
          data ( BrSTSB(i,   28), i=  1,   41)/
     1  347.36871, 346.18399, 331.53340, 284.54687, 239.44784,
     2  198.44502, 162.23597, 134.25828, 112.67593,  95.92402,
     3   82.55033,  71.82325,  63.22937,  56.23756,  50.51027,
     4   45.77488,  41.83181,  38.50145,  35.67295,  33.24844,
     5   31.15948,  29.34075,  27.74950,  26.34411,  25.09259,
     6   23.96684,  22.94576,  22.01240,  21.15109,  20.35271,
     7   19.60782,  18.90885,  18.25123,  17.62939,  17.04006,
     8   16.48081,  15.94923,  15.44374,  14.96262,  14.50524,
     9   14.07042                                                       
     * /   
          data ( BrSTSB(i,   29), i=  1,   41)/
     1  356.75307, 355.35736, 338.03788, 286.03434, 237.99510,
     2  195.81155, 159.15675, 131.12943, 109.88577,  93.46512,
     3   80.30894,  69.83611,  61.48486,  54.70902,  49.16856,
     4   44.59296,  40.79210,  37.58131,  34.85773,  32.52776,
     5   30.51776,  28.76976,  27.24137,  25.89305,  24.69164,
     6   23.61302,  22.63552,  21.74048,  20.91622,  20.15115,
     7   19.43716,  18.76703,  18.13529,  17.53732,  16.97020,
     8   16.43061,  15.91719,  15.42771,  14.96153,  14.51725,
     9   14.09427                                                       
     * /   
          data ( BrSTSB(i,   30), i=  1,   41)/
     1  366.38435, 364.52910, 344.15918, 287.14298, 236.17055,
     2  192.94171, 155.96298, 128.10170, 107.05885,  90.92323,
     3   78.09169,  67.86539,  59.75189,  53.18881,  47.83302,
     4   43.41567,  39.74989,  36.65918,  34.03711,  31.79350,
     5   29.86244,  28.18549,  26.71875,  25.42406,  24.27432,
     6   23.24215,  22.30622,  21.45137,  20.66378,  19.93256,
     7   19.25006,  18.60897,  18.00383,  17.43081,  16.88593,
     8   16.36700,  15.87241,  15.40003,  14.94913,  14.51888,
     9   14.10839                                                       
     * /   
          data ( BrSTSB(i,   31), i=  1,   41)/
     1  375.75377, 373.69936, 349.70672, 287.60915, 233.87901,
     2  189.82111, 152.64782, 124.84489, 104.28910,  88.47680,
     3   75.93700,  65.93736,  58.04903,  51.70427,  46.53426,
     4   42.27410,  38.74130,  35.76816,  33.24502,  31.09139,
     5   29.23579,  27.62478,  26.21911,  24.97861,  23.87805,
     6   22.89120,  21.99660,  21.17992,  20.42726,  19.72893,
     7   19.07703,  18.46368,  17.88479,  17.33597,  16.81295,
     8   16.31427,  15.83784,  15.38194,  14.94596,  14.52900,
     9   14.13069                                                       
     * /   
          data ( BrSTSB(i,   32), i=  1,   41)/
     1  384.62638, 382.86827, 354.29919, 287.35766, 231.13264,
     2  186.46954, 148.91869, 121.69097, 101.48370,  86.00805,
     3   73.80692,  64.07989,  56.41498,  50.26966,  45.29318,
     4   41.17629,  37.77860,  34.92265,  32.50050,  30.43371,
     5   28.65280,  27.10823,  25.76126,  24.57389,  23.52098,
     6   22.57666,  21.72254,  20.94211,  20.22380,  19.55694,
     7   18.93364,  18.34707,  17.79298,  17.26660,  16.76476,
     8   16.28474,  15.82525,  15.38490,  14.96273,  14.55821,
     9   14.17075                                                       
     * /   
          data ( BrSTSB(i,   33), i=  1,   41)/
     1  393.61040, 392.03595, 358.50876, 286.65240, 228.06280,
     2  182.94090, 145.40610, 118.49048,  98.55513,  83.52219,
     3   71.62628,  62.21475,  54.77552,  48.84493,  44.03885,
     4   40.08405,  36.81414,  34.07099,  31.74728,  29.76288,
     5   28.05910,  26.58078,  25.28918,  24.15580,  23.14897,
     6   22.24836,  21.43313,  20.69031,  20.00556,  19.37033,
     7   18.77645,  18.21744,  17.68850,  17.18531,  16.70473,
     8   16.24438,  15.80272,  15.37828,  14.97027,  14.57874,
     9   14.20295                                                       
     * /   
          data ( BrSTSB(i,   34), i=  1,   41)/
     1  402.38896, 401.20252, 362.14483, 285.41816, 224.66969,
     2  179.25492, 141.81740, 115.24879,  95.60237,  80.96135,
     3   69.47505,  60.36967,  53.16922,  47.45808,  42.83326,
     4   39.02878,  35.87825,  33.25124,  31.02323,  29.12167,
     5   27.48700,  26.07315,  24.84043,  23.75577,  22.79584,
     6   21.93712,  21.16096,  20.45332,  19.80144,  19.19714,
     7   18.63148,  18.09941,  17.59502,  17.11445,  16.65458,
     8   16.21309,  15.78856,  15.37937,  14.98558,  14.60625,
     9   14.24165                                                       
     * /   
          data ( BrSTSB(i,   35), i=  1,   41)/
     1  410.90604, 410.36806, 365.01676, 283.69276, 221.00119,
     2  175.43621, 138.16450, 111.97236,  92.72499,  78.38773,
     3   67.27612,  58.54575,  51.57786,  46.09589,  41.65628,
     4   38.00304,  34.97725,  32.46363,  30.32474,  28.50715,
     5   26.94164,  25.58957,  24.41162,  23.37676,  22.46163,
     6   21.64401,  20.90517,  20.23270,  19.61347,  19.03915,
     7   18.50181,  17.99525,  17.51454,  17.05614,  16.61650,
     8   16.19312,  15.78501,  15.39067,  15.01005,  14.64242,
     9   14.28817                                                       
     * /   
          data ( BrSTSB(i,   36), i=  1,   41)/
     1  419.35047, 416.48150, 367.31539, 281.58940, 217.09321,
     2  171.50932, 134.45931, 108.83086,  89.83096,  75.86357,
     3   65.14894,  56.71711,  50.04016,  44.75885,  40.49800,
     4   36.99930,  34.09325,  31.68934,  29.64443,  27.90115,
     5   26.40570,  25.11168,  23.98752,  23.00024,  22.12951,
     6   21.35163,  20.65087,  20.01260,  19.42660,  18.88151,
     7   18.37193,  17.89134,  17.43508,  16.99837,  16.57859,
     8   16.17358,  15.78184,  15.40209,  15.03443,  14.67850,
     9   14.33445                                                       
     * /   
          data ( BrSTSB(i,   37), i=  1,   41)/
     1  427.60152, 425.64520, 368.84998, 278.88202, 212.96978,
     2  167.55263, 131.04177, 105.68138,  86.93229,  73.33655,
     3   63.01990,  54.91408,  48.50155,  43.44876,  39.37004,
     4   36.01857,  33.24515,  30.94323,  28.98653,  27.31933,
     5   25.88945,  24.65203,  23.57685,  22.63783,  21.80807,
     6   21.06935,  20.40609,  19.80297,  19.24877,  18.73405,
     7   18.25246,  17.79791,  17.36485,  16.94982,  16.54980,
     8   16.16217,  15.78595,  15.42048,  15.06510,  14.72007,
     9   14.38553                                                       
     * /   
          data ( BrSTSB(i,   38), i=  1,   41)/
     1  435.68170, 434.80813, 369.62065, 275.53305, 208.65490,
     2  163.57602, 127.61453, 102.52667,  84.22205,  70.92721,
     3   60.92881,  53.13698,  47.00025,  42.16578,  38.26224,
     4   35.07657,  32.42697,  30.22534,  28.35866,  26.76168,
     5   25.39289,  24.20858,  23.18134,  22.28521,  21.49610,
     6   20.79614,  20.16906,  19.59999,  19.07870,  18.59449,
     7   18.14142,  17.71232,  17.30311,  16.90914,  16.52832,
     8   16.15755,  15.79663,  15.44409,  15.10045,  14.76550,
     9   14.44011                                                       
     * /   
          data ( BrSTSB(i,   39), i=  1,   41)/
     1  443.62560, 440.91900, 369.62749, 271.95722, 204.12471,
     2  159.36432, 123.77178,  99.31086,  81.57173,  68.61513,
     3   58.94085,  51.45720,  45.56767,  40.93270,  37.20182,
     4   34.15491,  31.61847,  29.51980,  27.73683,  26.21501,
     5   24.90527,  23.77660,  22.79706,  21.94344,  21.19327,
     6   20.53068,  19.93864,  19.40269,  18.91152,  18.45627,
     7   18.02950,  17.62551,  17.23870,  16.86538,  16.50317,
     8   16.14937,  15.80313,  15.46419,  15.13225,  14.80773,
     9   14.49146                                                       
     * /   
          data ( BrSTSB(i,   40), i=  1,   41)/
     1  451.27437, 447.02914, 369.06128, 268.11689, 199.47478,
     2  155.02521, 120.16964,  96.22494,  78.90186,  66.35068,
     3   57.02345,  49.85248,  44.22606,  39.76568,  36.19052,
     4   33.28614,  30.86291,  28.85106,  27.15563,  25.70108,
     5   24.45430,  23.37888,  22.44636,  21.63553,  20.92386,
     6   20.29672,  19.73693,  19.23161,  18.76834,  18.33949,
     7   17.93681,  17.55510,  17.18873,  16.83476,  16.48935,
     8   16.15102,  15.81866,  15.49170,  15.17071,  14.85579,
     9   14.54793                                                       
     * /   
          data ( BrSTSB(i,   41), i=  1,   41)/
     1  458.88906, 456.19009, 368.11280, 264.01214, 194.70518,
     2  150.65657, 116.55324,  92.96822,  76.22761,  64.20311,
     3   55.22201,  48.32698,  42.94040,  38.65308,  35.22997,
     4   32.44808,  30.13108,  28.21043,  26.59301,  25.20822,
     5   24.01799,  22.99529,  22.10738,  21.33743,  20.66395,
     6   20.07082,  19.54298,  19.06720,  18.63225,  18.22945,
     7   17.85051,  17.49076,  17.14491,  16.80885,  16.48036,
     8   16.15697,  15.83805,  15.52290,  15.21229,  14.90649,
     9   14.60662                                                       
     * /   
          data ( BrSTSB(i,   42), i=  1,   41)/
     1  430.87026, 276.15781, 256.14910, 209.59534, 159.86534,
     2  121.96673,  95.47021,  77.18478,  64.01025,  54.48417,
     3   47.27571,  41.74596,  37.42152,  33.95711,  31.14356,
     4   28.83252,  26.90375,  25.28441,  23.90581,  22.72618,
     5   21.71224,  20.83520,  20.07271,  19.40708,  18.82407,
     6   18.31001,  17.85357,  17.44463,  17.07382,  16.73290,
     7   16.41540,  16.11443,  15.82543,  15.54400,  15.26747,
     8   14.99369,  14.72150,  14.45019,  14.18032,  13.91251,
     9   13.64731                                                       
     * /   



!   Brem at low energy: TX
          data ( BrTXL(i), i=  1,   38)/
     1   4.6901,  5.1357,  5.5855,  6.0307,  6.4742,  6.9035,  7.3271,
     2   7.7443,  8.1535,  8.5518,  8.4760,  8.8336,  9.1873,  9.5375,
     3   9.8847, 10.2291, 10.5712, 10.9112, 11.2494, 11.5861, 11.9214,
     4  12.2556, 12.5888, 12.9212, 13.2529, 13.5840, 13.9146, 14.2448,
     5  14.5747, 14.9042, 15.2336, 15.5627, 15.8916, 16.2205, 16.5492,
     6  16.8778, 17.2063, 17.5359                                       
     * /   

!  Brem at low energy; Region A

          data ( BrSTLA(i,   1), i=  1,   41)/
     1   3.97714,  3.91928,  3.86931,  3.82546,  3.78642,  3.75131,
     2   3.71937,  3.69007,  3.66299,  3.63779,  3.61424,  3.59207,
     3   3.57111,  3.55093,  3.53105,  3.51145,  3.49239,  3.47360,
     4   3.45551,  3.43800,  3.42106,  3.40476,  3.38913,  3.37416,
     5   3.35983,  3.34615,  3.33311,  3.32064,  3.30881,  3.29751,
     6   3.28677,  3.27654,  3.26683,  3.25755,  3.24875,  3.24025,
     7   3.23235,  3.22479,  3.21741,  3.21037,  3.20390                
     * /   

          data ( BrSTLA(i,   2), i=  1,   41)/
     1   4.24529,  4.18801,  4.13854,  4.09512,  4.05652,  4.02178,
     2   3.99008,  3.96099,  3.93423,  3.90944,  3.88630,  3.86447,
     3   3.84367,  3.82366,  3.80430,  3.78545,  3.76709,  3.74915,
     4   3.73170,  3.71462,  3.69804,  3.68193,  3.66633,  3.65124,
     5   3.63670,  3.62266,  3.60913,  3.59621,  3.58381,  3.57193,
     6   3.56053,  3.54965,  3.53924,  3.52932,  3.51984,  3.51083,
     7   3.50229,  3.49397,  3.48614,  3.47875,  3.47160                
     * /   
          data ( BrSTLA(i,   3), i=  1,   41)/
     1   4.50888,  4.45153,  4.40193,  4.35832,  4.31946,  4.28440,
     2   4.25233,  4.22291,  4.19579,  4.17056,  4.14682,  4.12422,
     3   4.10246,  4.08136,  4.06077,  4.04068,  4.02103,  4.00182,
     4   3.98310,  3.96491,  3.94727,  3.93026,  3.91384,  3.89806,
     5   3.88294,  3.86845,  3.85463,  3.84144,  3.82887,  3.81688,
     6   3.80550,  3.79466,  3.78445,  3.77465,  3.76542,  3.75664,
     7   3.74823,  3.74044,  3.73276,  3.72553,  3.71899                
     * /   
          data ( BrSTLA(i,   4), i=  1,   41)/
     1   4.77115,  4.71360,  4.66369,  4.61974,  4.58050,  4.54493,
     2   4.51237,  4.48245,  4.45480,  4.42886,  4.40425,  4.38057,
     3   4.35760,  4.33515,  4.31318,  4.29165,  4.27061,  4.25014,
     4   4.23028,  4.21104,  4.19253,  4.17476,  4.15776,  4.14154,
     5   4.12608,  4.11138,  4.09746,  4.08425,  4.07174,  4.05995,
     6   4.04872,  4.03821,  4.02818,  4.01881,  4.00992,  4.00155,
     7   3.99368,  3.98600,  3.97884,  3.97250,  3.96606                
     * /   
          data ( BrSTLA(i,   5), i=  1,   41)/
     1   5.03297,  4.97517,  4.92490,  4.88052,  4.84077,  4.80460,
     2   4.77145,  4.74096,  4.71259,  4.68577,  4.66007,  4.63510,
     3   4.61071,  4.58677,  4.56331,  4.54036,  4.51799,  4.49632,
     4   4.47541,  4.45532,  4.43612,  4.41782,  4.40045,  4.38397,
     5   4.36841,  4.35373,  4.33984,  4.32683,  4.31455,  4.30305,
     6   4.29218,  4.28205,  4.27245,  4.26351,  4.25502,  4.24707,
     7   4.23969,  4.23261,  4.22609,  4.22021,  4.21412                
     * /   
          data ( BrSTLA(i,   6), i=  1,   41)/
     1   5.29129,  5.23280,  5.18179,  5.13661,  5.09604,  5.05899,
     2   5.02505,  4.99371,  4.96433,  4.93635,  4.90926,  4.88278,
     3   4.85680,  4.83128,  4.80631,  4.78200,  4.75846,  4.73580,
     4   4.71412,  4.69344,  4.67386,  4.65532,  4.63786,  4.62141,
     5   4.60602,  4.59157,  4.57803,  4.56539,  4.55353,  4.54250,
     6   4.53217,  4.52250,  4.51343,  4.50500,  4.49720,  4.48978,
     7   4.48285,  4.47641,  4.47051,  4.46516,  4.45952                
     * /   
          data ( BrSTLA(i,   7), i=  1,   41)/
     1   5.54793,  5.48861,  5.43671,  5.39066,  5.34914,  5.31120,
     2   5.27640,  5.24412,  5.21365,  5.18435,  5.15579,  5.12776,
     3   5.10021,  5.07322,  5.04695,  5.02153,  4.99710,  4.97380,
     4   4.95167,  4.93077,  4.91108,  4.89266,  4.87540,  4.85930,
     5   4.84428,  4.83027,  4.81729,  4.80517,  4.79396,  4.78348,
     6   4.77375,  4.76474,  4.75636,  4.74853,  4.74132,  4.73452,
     7   4.72835,  4.72255,  4.71699,  4.71179,  4.70715                
     * /   
          data ( BrSTLA(i,   8), i=  1,   41)/
     1   5.80278,  5.74253,  5.68970,  5.64276,  5.60030,  5.56151,
     2   5.52591,  5.49269,  5.46111,  5.43049,  5.40051,  5.37105,
     3   5.34215,  5.31402,  5.28678,  5.26065,  5.23576,  5.21222,
     4   5.19005,  5.16932,  5.14993,  5.13189,  5.11515,  5.09965,
     5   5.08525,  5.07195,  5.05966,  5.04830,  5.03780,  5.02807,
     6   5.01907,  5.01077,  5.00307,  4.99600,  4.98937,  4.98325,
     7   4.97760,  4.97243,  4.96745,  4.96277,  4.95884                
     * /   
          data ( BrSTLA(i,   9), i=  1,   41)/
     1   6.05607,  5.99490,  5.94125,  5.89351,  5.85025,  5.81078,
     2   5.77448,  5.74043,  5.70780,  5.67601,  5.64480,  5.61418,
     3   5.58430,  5.55539,  5.52765,  5.50126,  5.47634,  5.45299,
     4   5.43120,  5.41094,  5.39218,  5.37484,  5.35884,  5.34415,
     5   5.33060,  5.31813,  5.30665,  5.29611,  5.28643,  5.27750,
     6   5.26935,  5.26180,  5.25489,  5.24840,  5.24255,  5.23717,
     7   5.23206,  5.22742,  5.22338,  5.21926,  5.21564                
     * /   
          data ( BrSTLA(i,   10), i=  1,   41)/
     1   6.30800,  6.24600,  6.19159,  6.14312,  6.09917,  6.05914,
     2   6.02219,  5.98733,  5.95369,  5.92082,  5.88859,  5.85708,
     3   5.82654,  5.79721,  5.76935,  5.74306,  5.71848,  5.69564,
     4   5.67449,  5.65500,  5.63707,  5.62060,  5.60552,  5.59173,
     5   5.57908,  5.56755,  5.55702,  5.54734,  5.53854,  5.53044,
     6   5.52308,  5.51631,  5.51009,  5.50443,  5.49920,  5.49447,
     7   5.49003,  5.48608,  5.48226,  5.47867,  5.47571                
     * /   
          data ( BrSTLA(i,   11), i=  1,   41)/
     1   6.62244,  6.57205,  6.52961,  6.49372,  6.46316,  6.43700,
     2   6.41447,  6.39500,  6.37809,  6.36336,  6.35048,  6.33919,
     3   6.32926,  6.32052,  6.31280,  6.30598,  6.29995,  6.29458,
     4   6.28981,  6.28559,  6.28183,  6.27845,  6.27546,  6.27277,
     5   6.27038,  6.26821,  6.26630,  6.26458,  6.26301,  6.26161,
     6   6.26038,  6.25926,  6.25825,  6.25727,  6.25644,  6.25574,
     7   6.25505,  6.25450,  6.25391,  6.25319,  6.25289                
     * /   
          data ( BrSTLA(i,   12), i=  1,   41)/
     1   6.87290,  6.82253,  6.78030,  6.74475,  6.71461,  6.68894,
     2   6.66693,  6.64801,  6.63163,  6.61745,  6.60509,  6.59434,
     3   6.58490,  6.57663,  6.56938,  6.56299,  6.55739,  6.55241,
     4   6.54803,  6.54412,  6.54067,  6.53764,  6.53493,  6.53251,
     5   6.53036,  6.52844,  6.52673,  6.52522,  6.52388,  6.52260,
     6   6.52153,  6.52054,  6.51967,  6.51886,  6.51817,  6.51757,
     7   6.51701,  6.51634,  6.51603,  6.51561,  6.51516                
     * /   
          data ( BrSTLA(i,   13), i=  1,   41)/
     1   7.12168,  7.07129,  7.02927,  6.99404,  6.96431,  6.93911,
     2   6.91761,  6.89921,  6.88337,  6.86969,  6.85786,  6.84756,
     3   6.83862,  6.83080,  6.82398,  6.81800,  6.81276,  6.80816,
     4   6.80410,  6.80054,  6.79740,  6.79462,  6.79217,  6.79000,
     5   6.78804,  6.78636,  6.78484,  6.78347,  6.78231,  6.78122,
     6   6.78025,  6.77940,  6.77868,  6.77794,  6.77735,  6.77682,
     7   6.77640,  6.77603,  6.77565,  6.77521,  6.77483                
     * /   
          data ( BrSTLA(i,   14), i=  1,   41)/
     1   7.36886,  7.31848,  7.27663,  7.24172,  7.21242,  7.18768,
     2   7.16668,  7.14875,  7.13343,  7.12025,  7.10888,  7.09907,
     3   7.09057,  7.08319,  7.07674,  7.07115,  7.06626,  7.06199,
     4   7.05825,  7.05499,  7.05210,  7.04957,  7.04737,  7.04540,
     5   7.04368,  7.04217,  7.04080,  7.03963,  7.03858,  7.03761,
     6   7.03678,  7.03608,  7.03538,  7.03486,  7.03434,  7.03391,
     7   7.03334,  7.03303,  7.03266,  7.03222,  7.03216                
     * /   
          data ( BrSTLA(i,   15), i=  1,   41)/
     1   7.61461,  7.56419,  7.52253,  7.48795,  7.45904,  7.43475,
     2   7.41422,  7.39680,  7.38195,  7.36925,  7.35834,  7.34898,
     3   7.34090,  7.33390,  7.32787,  7.32264,  7.31807,  7.31412,
     4   7.31065,  7.30766,  7.30502,  7.30271,  7.30073,  7.29897,
     5   7.29742,  7.29606,  7.29484,  7.29380,  7.29289,  7.29205,
     6   7.29138,  7.29070,  7.29012,  7.28966,  7.28924,  7.28884,
     7   7.28850,  7.28819,  7.28789,  7.28750,  7.28738                
     * /   
          data ( BrSTLA(i,   16), i=  1,   41)/
     1   7.85903,  7.80858,  7.76710,  7.73283,  7.70433,  7.68048,
     2   7.66043,  7.64348,  7.62910,  7.61686,  7.60643,  7.59747,
     3   7.58979,  7.58320,  7.57751,  7.57261,  7.56836,  7.56470,
     4   7.56151,  7.55874,  7.55633,  7.55424,  7.55244,  7.55084,
     5   7.54948,  7.54825,  7.54719,  7.54628,  7.54543,  7.54472,
     6   7.54409,  7.54357,  7.54304,  7.54265,  7.54228,  7.54190,
     7   7.54163,  7.54133,  7.54122,  7.54069,  7.54073                
     * /   
          data ( BrSTLA(i,   17), i=  1,   41)/
     1   8.10224,  8.05177,  8.01050,  7.97653,  7.94843,  7.92503,
     2   7.90544,  7.88896,  7.87506,  7.86327,  7.85326,  7.84472,
     3   7.83743,  7.83120,  7.82585,  7.82126,  7.81729,  7.81390,
     4   7.81097,  7.80844,  7.80626,  7.80435,  7.80269,  7.80129,
     5   7.80005,  7.79894,  7.79802,  7.79721,  7.79651,  7.79586,
     6   7.79532,  7.79482,  7.79446,  7.79406,  7.79372,  7.79341,
     7   7.79313,  7.79302,  7.79273,  7.79275,  7.79243                
     * /   
          data ( BrSTLA(i,   18), i=  1,   41)/
     1   8.34437,  8.29390,  8.25282,  8.21919,  8.19150,  8.16855,
     2   8.14942,  8.13340,  8.11996,  8.10861,  8.09901,  8.09088,
     3   8.08396,  8.07807,  8.07305,  8.06876,  8.06510,  8.06193,
     4   8.05923,  8.05691,  8.05492,  8.05319,  8.05170,  8.05041,
     5   8.04930,  8.04834,  8.04750,  8.04681,  8.04616,  8.04560,
     6   8.04515,  8.04475,  8.04436,  8.04408,  8.04375,  8.04357,
     7   8.04332,  8.04305,  8.04286,  8.04317,  8.04269                
     * /   
          data ( BrSTLA(i,   19), i=  1,   41)/
     1   8.58555,  8.53508,  8.49423,  8.46095,  8.43366,  8.41116,
     2   8.39250,  8.37696,  8.36394,  8.35304,  8.34384,  8.33610,
     3   8.32954,  8.32398,  8.31926,  8.31526,  8.31184,  8.30892,
     4   8.30644,  8.30431,  8.30249,  8.30092,  8.29956,  8.29843,
     5   8.29742,  8.29659,  8.29585,  8.29521,  8.29465,  8.29420,
     6   8.29374,  8.29341,  8.29309,  8.29283,  8.29263,  8.29242,
     7   8.29225,  8.29210,  8.29212,  8.29205,  8.29169                
     * /   
          data ( BrSTLA(i,   20), i=  1,   41)/
     1   8.82589,  8.77546,  8.73483,  8.70192,  8.67506,  8.65302,
     2   8.63481,  8.61973,  8.60717,  8.59667,  8.58789,  8.58050,
     3   8.57430,  8.56906,  8.56464,  8.56090,  8.55771,  8.55502,
     4   8.55275,  8.55079,  8.54912,  8.54771,  8.54651,  8.54546,
     5   8.54457,  8.54384,  8.54318,  8.54261,  8.54213,  8.54175,
     6   8.54136,  8.54107,  8.54078,  8.54051,  8.54040,  8.54016,
     7   8.53998,  8.53994,  8.53982,  8.53941,  8.53959                
     * /   
          data ( BrSTLA(i,   21), i=  1,   41)/
     1   9.06552,  9.01513,  8.97478,  8.94224,  8.91582,  8.89424,
     2   8.87651,  8.86187,  8.84976,  8.83969,  8.83128,  8.82427,
     3   8.81837,  8.81345,  8.80930,  8.80580,  8.80287,  8.80037,
     4   8.79827,  8.79649,  8.79497,  8.79369,  8.79261,  8.79167,
     5   8.79088,  8.79019,  8.78963,  8.78916,  8.78875,  8.78839,
     6   8.78804,  8.78779,  8.78757,  8.78737,  8.78724,  8.78709,
     7   8.78695,  8.78673,  8.78667,  8.78684,  8.78655                
     * /   
          data ( BrSTLA(i,   22), i=  1,   41)/
     1   9.30452,  9.25424,  9.21417,  9.18202,  9.15605,  9.13493,
     2   9.11767,  9.10350,  9.09181,  9.08213,  9.07412,  9.06743,
     3   9.06187,  9.05724,  9.05336,  9.05009,  9.04735,  9.04508,
     4   9.04313,  9.04152,  9.04012,  9.03899,  9.03802,  9.03716,
     5   9.03649,  9.03586,  9.03539,  9.03496,  9.03457,  9.03428,
     6   9.03401,  9.03379,  9.03354,  9.03338,  9.03330,  9.03313,
     7   9.03302,  9.03304,  9.03291,  9.03300,  9.03271                
     * /   
          data ( BrSTLA(i,   23), i=  1,   41)/
     1   9.54302,  9.49285,  9.45310,  9.42137,  9.39587,  9.37521,
     2   9.35843,  9.34470,  9.33342,  9.32416,  9.31649,  9.31017,
     3   9.30490,  9.30053,  9.29689,  9.29386,  9.29134,  9.28922,
     4   9.28746,  9.28596,  9.28473,  9.28367,  9.28280,  9.28208,
     5   9.28144,  9.28089,  9.28045,  9.28010,  9.27977,  9.27948,
     6   9.27925,  9.27905,  9.27889,  9.27873,  9.27859,  9.27849,
     7   9.27846,  9.27834,  9.27839,  9.27846,  9.27817                
     * /   
          data ( BrSTLA(i,   24), i=  1,   41)/
     1   9.78108,  9.73109,  9.69167,  9.66037,  9.63533,  9.61517,
     2   9.59884,  9.58556,  9.57471,  9.56582,  9.55852,  9.55250,
     3   9.54753,  9.54342,  9.54003,  9.53720,  9.53489,  9.53292,
     4   9.53129,  9.52997,  9.52882,  9.52789,  9.52710,  9.52643,
     5   9.52587,  9.52540,  9.52501,  9.52469,  9.52438,  9.52419,
     6   9.52397,  9.52379,  9.52367,  9.52353,  9.52346,  9.52339,
     7   9.52322,  9.52320,  9.52330,  9.52272,  9.52304                
     * /   
          data ( BrSTLA(i,   25), i=  1,   41)/
     1  10.01882,  9.96900,  9.92996,  9.89912,  9.87455,  9.85487,
     2   9.83899,  9.82615,  9.81572,  9.80720,  9.80024,  9.79455,
     3   9.78985,  9.78601,  9.78284,  9.78020,  9.77805,  9.77625,
     4   9.77476,  9.77355,  9.77252,  9.77168,  9.77094,  9.77036,
     5   9.76989,  9.76946,  9.76911,  9.76881,  9.76859,  9.76836,
     6   9.76818,  9.76806,  9.76795,  9.76786,  9.76777,  9.76762,
     7   9.76764,  9.76757,  9.76729,  9.76761,  9.76742                
     * /   
          data ( BrSTLA(i,   26), i=  1,   41)/
     1  10.25627, 10.20670, 10.16805, 10.13765, 10.11358, 10.09438,
     2  10.07896, 10.06656, 10.05652, 10.04837, 10.04174, 10.03634,
     3  10.03192, 10.02831, 10.02534, 10.02291, 10.02093, 10.01926,
     4  10.01790, 10.01679, 10.01587, 10.01511, 10.01446, 10.01393,
     5  10.01348, 10.01312, 10.01281, 10.01257, 10.01237, 10.01219,
     6  10.01206, 10.01194, 10.01180, 10.01172, 10.01168, 10.01157,
     7  10.01160, 10.01143, 10.01133, 10.01157, 10.01138                
     * /   
          data ( BrSTLA(i,   27), i=  1,   41)/
     1  10.49354, 10.44423, 10.40597, 10.37606, 10.35248, 10.33374,
     2  10.31879, 10.30682, 10.29716, 10.28938, 10.28307, 10.27796,
     3  10.27379, 10.27041, 10.26764, 10.26539, 10.26353, 10.26203,
     4  10.26079, 10.25978, 10.25894, 10.25823, 10.25767, 10.25719,
     5  10.25680, 10.25648, 10.25625, 10.25599, 10.25585, 10.25569,
     6  10.25557, 10.25546, 10.25537, 10.25528, 10.25519, 10.25518,
     7  10.25508, 10.25514, 10.25510, 10.25461, 10.25498                
     * /   
          data ( BrSTLA(i,   28), i=  1,   41)/
     1  10.73066, 10.68164, 10.64381, 10.61439, 10.59128, 10.57303,
     2  10.55854, 10.54698, 10.53772, 10.53027, 10.52427, 10.51942,
     3  10.51552, 10.51233, 10.50978, 10.50767, 10.50598, 10.50459,
     4  10.50346, 10.50251, 10.50176, 10.50115, 10.50065, 10.50022,
     5  10.49986, 10.49958, 10.49935, 10.49916, 10.49898, 10.49890,
     6  10.49874, 10.49864, 10.49860, 10.49853, 10.49851, 10.49847,
     7  10.49837, 10.49828, 10.49843, 10.49855, 10.49829                
     * /   
          data ( BrSTLA(i,   29), i=  1,   41)/
     1  10.96767, 10.91897, 10.88160, 10.85266, 10.83005, 10.81227,
     2  10.79823, 10.78707, 10.77819, 10.77107, 10.76538, 10.76081,
     3  10.75711, 10.75415, 10.75176, 10.74981, 10.74823, 10.74696,
     4  10.74594, 10.74508, 10.74440, 10.74385, 10.74340, 10.74303,
     5  10.74272, 10.74246, 10.74227, 10.74210, 10.74196, 10.74183,
     6  10.74177, 10.74172, 10.74157, 10.74157, 10.74145, 10.74144,
     7  10.74139, 10.74136, 10.74144, 10.74149, 10.74135                
     * /   
          data ( BrSTLA(i,   30), i=  1,   41)/
     1  11.20461, 11.15627, 11.11936, 11.09091, 11.06881, 11.05152,
     2  11.03791, 11.02715, 11.01863, 11.01183, 11.00642, 11.00210,
     3  10.99863, 10.99587, 10.99362, 10.99183, 10.99037, 10.98922,
     4  10.98827, 10.98753, 10.98689, 10.98640, 10.98598, 10.98565,
     5  10.98539, 10.98515, 10.98498, 10.98483, 10.98472, 10.98460,
     6  10.98453, 10.98450, 10.98444, 10.98433, 10.98430, 10.98433,
     7  10.98417, 10.98425, 10.98407, 10.98419, 10.98421                
     * /   
          data ( BrSTLA(i,   31), i=  1,   41)/
     1  11.44155, 11.39357, 11.35714, 11.32920, 11.30759, 11.29075,
     2  11.27758, 11.26722, 11.25904, 11.25257, 11.24744, 11.24335,
     3  11.24008, 11.23751, 11.23541, 11.23375, 11.23244, 11.23135,
     4  11.23051, 11.22980, 11.22926, 11.22878, 11.22845, 11.22815,
     5  11.22789, 11.22773, 11.22758, 11.22744, 11.22734, 11.22725,
     6  11.22719, 11.22714, 11.22703, 11.22704, 11.22703, 11.22701,
     7  11.22700, 11.22691, 11.22707, 15.13071, 11.22689                
     * /   
          data ( BrSTLA(i,   32), i=  1,   41)/
     1  11.67848, 11.63090, 11.59494, 11.56751, 11.54640, 11.53003,
     2  11.51727, 11.50731, 11.49946, 11.49329, 11.48841, 11.48457,
     3  11.48150, 11.47908, 11.47715, 11.47562, 11.47439, 11.47341,
     4  11.47263, 11.47201, 11.47149, 11.47110, 11.47076, 11.47050,
     5  11.47031, 11.47012, 11.46997, 11.46990, 11.46978, 11.46973,
     6  11.46969, 11.46960, 11.46955, 11.46951, 11.46955, 11.46946,
     7  11.46948, 10.51214,  6.57615, 13.15231, 11.46943                
     * /   
          data ( BrSTLA(i,   33), i=  1,   41)/
     1  11.91544, 11.86828, 11.83282, 11.80588, 11.78525, 11.76935,
     2  11.75703, 11.74742, 11.73992, 11.73403, 11.72942, 11.72577,
     3  11.72290, 11.72063, 11.71885, 11.71742, 11.71631, 11.71541,
     4  11.71469, 11.71414, 11.71367, 11.71331, 11.71304, 11.71280,
     5  11.71260, 11.71244, 11.71233, 11.71223, 11.71215, 11.71208,
     6  11.71206, 11.71200, 11.71196, 11.71193, 11.71191, 11.71190,
     7  11.71199, 12.44109,  8.08179, 16.16358, 11.71185                
     * /   
          data ( BrSTLA(i,   34), i=  1,   41)/
     1  12.15246, 12.10572, 12.07075, 12.04433, 12.02420, 12.00875,
     2  11.99681, 11.98757, 11.98040, 11.97478, 11.97042, 11.96699,
     3  11.96428, 11.96218, 11.96050, 11.95920, 11.95817, 11.95734,
     4  11.95670, 11.95619, 11.95579, 11.95544, 11.95522, 11.95501,
     5  11.95483, 11.95472, 11.95460, 11.95452, 11.95445, 11.95440,
     6  11.95433, 11.95432, 11.95426, 11.95425, 11.95427, 11.95419,
     7  10.93668, 14.58224,  9.86262, 19.72525, 11.95418                
     * /   
          data ( BrSTLA(i,   35), i=  1,   41)/
     1  12.38954, 12.34322, 12.30878, 12.28287, 12.26321, 12.24821,
     2  12.23668, 12.22779, 12.22092, 12.21558, 12.21144, 12.20820,
     3  12.20567, 12.20369, 12.20215, 12.20095, 12.20001, 12.19925,
     4  12.19867, 12.19821, 12.19782, 12.19755, 12.19731, 12.19712,
     5  12.19698, 12.19686, 12.19678, 12.19673, 12.19665, 12.19663,
     6  12.19654, 12.19656, 12.19655, 12.19648, 12.19653, 12.19645,
     7  12.69439,  7.96127, 11.94191, 23.88382, 12.19643                
     * /   
          data ( BrSTLA(i,   36), i=  1,   41)/
     1  12.62667, 12.58083, 12.54688, 12.52148, 12.50230, 12.48775,
     2  12.47660, 12.46806, 12.46148, 12.45640, 12.45248, 12.44943,
     3  12.44707, 12.44522, 12.44380, 12.44267, 12.44182, 12.44111,
     4  12.44059, 12.44016, 12.43983, 12.43956, 12.43939, 12.43923,
     5  12.43908, 12.43901, 12.43892, 12.43886, 12.43882, 12.43875,
     6  12.43873, 12.43873, 12.43868, 11.82307, 13.79359,  9.19173,
     7  11.48966, 15.31954, 22.97931, 45.95863, 12.43861                
     * /   
          data ( BrSTLA(i,   37), i=  1,   41)/
     1  12.86390, 12.81851, 12.78509, 12.76020, 12.74151, 12.72736,
     2  12.71661, 12.70839, 12.70209, 12.69727, 12.69355, 12.69068,
     3  12.68847, 12.68675, 12.68543, 12.68439, 12.68360, 12.68296,
     4  12.68249, 12.68212, 12.68182, 12.68156, 12.68139, 12.68126,
     5  12.68114, 12.68106, 12.68101, 12.68093, 12.68090, 12.68084,
     6  12.68085, 12.68080, 11.50045, 13.14338,  8.86290, 10.63548,
     7  13.29436, 17.72581, 26.58871, 53.17742, 12.68074                
     * /   
          data ( BrSTLA(i,   38), i=  1,   41)/
     1  13.10209, 13.05717, 13.02424, 12.99983, 12.98161, 12.96788,
     2  12.95749, 12.94960, 12.94359, 12.93899, 12.93547, 12.93275,
     3  12.93068, 12.92907, 12.92786, 12.92689, 12.92617, 12.92560,
     4  12.92517, 12.92482, 12.92455, 12.92435, 12.92419, 12.92406,
     5  12.92398, 12.92387, 12.92384, 12.92380, 12.92374, 12.92371,
     6  12.92371, 12.92370, 12.69162, 14.50470, 10.15732, 12.18879,
     7  15.23599, 20.31465, 30.47197, 60.94394, 12.92361                
     * /   

!  Brem at low energy: Region B

          data ( BrSTLB(i,   1), i=  1,   41)/
     1  170.18477, 170.60779, 168.06826, 160.35890, 145.93763,
     2  129.14257, 112.90455,  97.92050,  84.79101,  73.65077,
     3   64.40332,  56.75851,  50.36140,  44.94767,  40.39297,
     4   36.53430,  33.24963,  30.43369,  28.01247,  25.91990,
     5   24.10003,  22.50900,  21.11194,  19.87398,  18.77665,
     6   17.79353,  16.91024,  16.10976,  15.38053,  14.71208,
     7   14.09556,  13.52407,  12.99237,  12.49553,  12.02972,
     8   11.59161,  11.17825,  10.78765,  10.41742,  10.06634,
     9    9.73288                                                       
     * /   
          data ( BrSTLB(i,   2), i=  1,   41)/
     1  187.98202, 186.14861, 185.68577, 169.86382, 152.84579,
     2  134.42604, 115.57993,  98.64360,  84.41927,  72.92546,
     3   63.48626,  55.69362,  49.23890,  43.84592,  39.33583,
     4   35.53972,  32.32929,  29.60434,  27.26882,  25.25775,
     5   23.51284,  21.99182,  20.65680,  19.48044,  18.43487,
     6   17.50330,  16.66661,  15.90981,  15.22047,  14.58860,
     7   14.00580,  13.46593,  12.96251,  12.49159,  12.04927,
     8   11.63250,  11.23859,  10.86529,  10.51114,  10.17421,
     9    9.85352                                                       
     * /   
          data ( BrSTLB(i,   3), i=  1,   41)/
     1  205.80226, 204.68333, 202.32629, 180.36299, 158.46423,
     2  136.54164, 115.49076,  97.51970,  82.84609,  71.19201,
     3   61.77417,  54.01902,  47.63711,  42.38804,  38.01794,
     4   34.36645,  31.29220,  28.68496,  26.46289,  24.54965,
     5   22.89443,  21.45177,  20.18899,  19.07657,  18.09193,
     6   17.21359,  16.42530,  15.71302,  15.06464,  14.47097,
     7   13.92320,  13.41503,  12.94094,  12.49714,  12.07917,
     8   11.68483,  11.31119,  10.95630,  10.61849,  10.29671,
     9    9.98954                                                       
     * /   
          data ( BrSTLB(i,   4), i=  1,   41)/
     1  223.44557, 223.19201, 217.98671, 188.98254, 162.06218,
     2  137.35863, 114.44757,  95.53429,  80.65631,  69.00137,
     3   59.67328,  52.07135,  45.85615,  40.78137,  36.58575,
     4   33.10338,  30.17034,  27.70180,  25.60005,  23.79381,
     5   22.23259,  20.87666,  19.68852,  18.64384,  17.71875,
     6   16.89666,  16.15810,  15.49195,  14.88635,  14.33119,
     7   13.81947,  13.34455,  12.90113,  12.48537,  12.09336,
     8   11.72269,  11.37070,  11.03552,  10.71573,  10.41011,
     9   10.11764                                                       
     * /   
          data ( BrSTLB(i,   5), i=  1,   41)/
     1  241.06473, 241.67568, 232.66666, 195.87354, 163.84514,
     2  136.25967, 112.15726,  93.02313,  77.95489,  66.48257,
     3   57.35059,  49.96734,  43.96115,  39.07486,  35.08766,
     4   31.78028,  29.00691,  26.66943,  24.69667,  23.00072,
     5   21.53641,  20.26506,  19.15648,  18.18005,  17.31807,
     6   16.54996,  15.86405,  15.24442,  14.68195,  14.16686,
     7   13.69213,  13.25128,  12.83953,  12.45296,  12.08825,
     8   11.74241,  11.41366,  11.09963,  10.79926,  10.51111,
     9   10.23454                                                       
     * /   
          data ( BrSTLB(i,   6), i=  1,   41)/
     1  257.95338, 257.09352, 245.03603, 200.55011, 163.78196,
     2  134.50001, 109.23089,  89.83049,  74.94150,  63.70276,
     3   54.89193,  47.79471,  42.03501,  37.34430,  33.57056,
     4   30.45823,  27.85010,  25.65707,  23.81309,  22.22675,
     5   20.86400,  19.68000,  18.64652,  17.74152,  16.94027,
     6   16.22920,  15.59408,  15.02133,  14.50169,  14.02590,
     7   13.58747,  13.18043,  12.80017,  12.44242,  12.10447,
     8   11.78366,  11.47748,  11.18445,  10.90306,  10.63198,
     9   10.37104                                                       
     * /   
          data ( BrSTLB(i,   7), i=  1,   41)/
     1  274.57017, 272.48620, 255.47485, 203.46588, 162.28215,
     2  131.46131, 105.67526,  86.28973,  71.62209,  60.60699,
     3   52.18283,  45.44846,  40.00385,  35.60729,  32.04815,
     4   29.13174,  26.70227,  24.65666,  22.93483,  21.46691,
     5   20.20026,  19.10194,  18.14614,  17.30916,  16.57038,
     6   15.91370,  15.32891,  14.80260,  14.32583,  13.88933,
     7   13.48755,  13.11461,  12.76549,  12.43717,  12.12634,
     8   11.83017,  11.54709,  11.27494,  11.01259,  10.75893,
     9   10.51334                                                       
     * /   
          data ( BrSTLB(i,   8), i=  1,   41)/
     1  290.88654, 290.90341, 263.79425, 204.58681, 159.50556,
     2  127.14850, 102.10065,  82.56971,  68.19382,  57.50114,
     3   49.38624,  43.01401,  37.94833,  33.83797,  30.53328,
     4   27.81907,  25.57149,  23.67983,  22.08366,  20.72909,
     5   19.55740,  18.54351,  17.66024,  16.88729,  16.20640,
     6   15.60432,  15.06910,  14.58855,  14.15425,  13.75791,
     7   13.39347,  13.05522,  12.73871,  12.44028,  12.15734,
     8   11.88663,  11.62677,  11.37553,  11.13218,  10.89525,
     9   10.66463                                                       
     * /   
          data ( BrSTLB(i,   9), i=  1,   41)/
     1  306.84060, 306.25731, 269.99612, 203.50220, 155.55200,
     2  122.81778,  97.90690,  78.67454,  64.75653,  54.38836,
     3   46.62423,  40.65761,  35.90937,  32.12324,  29.04875,
     4   26.54598,  24.47799,  22.74267,  21.26855,  20.02404,
     5   18.94710,  18.01229,  17.19922,  16.48659,  15.86197,
     6   15.31053,  14.82082,  14.38520,  13.99287,  13.63622,
     7   13.30944,  13.00651,  12.72288,  12.45496,  12.19973,
     8   11.95473,  11.71772,  11.48699,  11.26175,  11.04087,
     9   10.82428                                                       
     * /   
          data ( BrSTLB(i,   10), i=  1,   41)/
     1  322.29897, 321.59531, 273.51103, 201.15624, 150.81885,
     2  117.84752,  93.39992,  74.44377,  61.21675,  51.39154,
     3   44.05755,  38.46252,  34.06252,  30.54903,  27.69089,
     4   25.38623,  23.47305,  21.87084,  20.51427,  19.37202,
     5   18.38343,  17.52696,  16.78283,  16.13232,  15.56188,
     6   15.06031,  14.61739,  14.22399,  13.87127,  13.55147,
     7   13.25891,  12.98776,  12.73347,  12.49252,  12.26206,
     8   12.03978,  11.82336,  11.61100,  11.40205,  11.19566,
     9   10.99176                                                       
     * /   
          data ( BrSTLB(i,   11), i=  1,   41)/
     1  205.75490, 205.81027, 192.76740, 160.98078, 124.74852,
     2   95.96404,  75.57964,  61.04834,  50.56058,  42.97518,
     3   37.24829,  32.84056,  29.37844,  26.59255,  24.33861,
     4   22.48282,  20.93241,  19.62140,  18.51384,  17.56099,
     5   16.73857,  16.02480,  15.40514,  14.86289,  14.38778,
     6   13.96976,  13.60084,  13.27260,  12.97956,  12.71553,
     7   12.47530,  12.25391,  12.04755,  11.85206,  11.66447,
     8   11.48205,  11.30276,  11.12486,  10.94758,  10.77048,
     9   10.59323                                                       
     * /   
          data ( BrSTLB(i,   12), i=  1,   41)/
     1  215.38681, 214.99892, 197.76084, 159.54277, 120.41919,
     2   91.60062,  71.36178,  57.62695,  47.78483,  40.69831,
     3   35.31551,  31.21770,  27.99693,  25.42997,  23.34292,
     4   21.61739,  20.18318,  18.97824,  17.94854,  17.07056,
     5   16.31455,  15.66134,  15.09413,  14.60218,  14.17281,
     6   13.79738,  13.46786,  13.17599,  12.91749,  12.68516,
     7   12.47468,  12.28090,  12.09940,  11.92676,  11.75963,
     8   11.59547,  11.43216,  11.26860,  11.10335,  10.93645,
     9   10.76783                                                       
     * /   
          data ( BrSTLB(i,   13), i=  1,   41)/
     1  224.79407, 224.18175, 201.60382, 156.66600, 115.42747,
     2   86.60636,  67.44266,  54.36651,  45.10335,  38.48037,
     3   33.50070,  29.70295,  26.73074,  24.35169,  22.41044,
     4   20.82454,  19.49688,  18.38006,  17.43550,  16.62608,
     5   15.93392,  15.33866,  14.82329,  14.38063,  13.99578,
     6   13.66044,  13.36920,  13.11362,  12.88775,  12.68589,
     7   12.50347,  12.33530,  12.17737,  12.02607,  11.87769,
     8   11.73020,  11.58138,  11.42977,  11.27518,  11.11688,
     9   10.95547                                                       
     * /   
          data ( BrSTLB(i,   14), i=  1,   41)/
     1  234.00585, 230.30926, 203.72517, 152.53998, 109.97758,
     2   81.60853,  63.52105,  51.10439,  42.61278,  36.44204,
     3   31.80418,  28.29653,  25.54151,  23.34376,  21.56225,
     4   20.08820,  18.86722,  17.83676,  16.97065,  16.23073,
     5   15.59927,  15.05891,  14.59633,  14.19815,  13.85664,
     6   13.56259,  13.30702,  13.08551,  12.89084,  12.71827,
     7   12.56190,  12.41809,  12.28186,  12.14960,  12.01839,
     8   11.88531,  11.74911,  11.60814,  11.46222,  11.31120,
     9   11.15575                                                       
     * /   
          data ( BrSTLB(i,   15), i=  1,   41)/
     1  243.04879, 239.48293, 204.50689, 147.35417, 104.28543,
     2   77.23411,  59.59776,  48.16802,  40.21753,  34.52349,
     3   30.22615,  26.99856,  24.44855,  22.42026,  20.77731,
     4   19.42438,  18.29413,  17.35321,  16.55391,  15.88113,
     5   15.31048,  14.82647,  14.41314,  14.05953,  13.75951,
     6   13.50254,  13.28134,  13.09221,  12.92689,  12.78094,
     7   12.64954,  12.52763,  12.41118,  12.29643,  12.18014,
     8   12.06015,  11.93456,  11.80252,  11.66379,  11.51868,
     9   11.36770                                                       
     * /   
          data ( BrSTLB(i,   16), i=  1,   41)/
     1  251.94680, 248.65332, 203.37756, 141.37329,  98.48321,
     2   72.23195,  55.97558,  45.39434,  38.01384,  32.72492,
     3   28.80619,  25.80907,  23.45185,  21.58114,  20.06608,
     4   18.81697,  17.78377,  16.91939,  16.19312,  15.58690,
     5   15.07279,  14.63896,  14.27170,  13.96305,  13.70014,
     6   13.47907,  13.29218,  13.13238,  12.99478,  12.87413,
     7   12.76528,  12.66334,  12.56454,  12.46506,  12.36216,
     8   12.25329,  12.13664,  12.01216,  11.87902,  11.73827,
     9   11.59053                                                       
     * /   
          data ( BrSTLB(i,   17), i=  1,   41)/
     1  260.72105, 254.76985, 200.90985, 134.86194,  92.71480,
     2   67.85452,  52.65487,  42.78362,  35.90594,  31.04642,
     3   27.46532,  24.70099,  22.53217,  20.81232,  19.41799,
     4   18.27388,  17.32979,  16.54013,  15.88814,  15.34142,
     5   14.88070,  14.49853,  14.17573,  13.90703,  13.68132,
     6   13.49343,  13.33748,  13.20569,  13.09342,  12.99540,
     7   12.90694,  12.82331,  12.74027,  12.65459,  12.56284,
     8   12.46323,  12.35424,  12.23549,  12.10677,  11.96910,
     9   11.82347                                                       
     * /   
          data ( BrSTLB(i,   18), i=  1,   41)/
     1  269.39011, 260.88387, 196.72287, 127.97155,  87.07622,
     2   63.47626,  49.63583,  40.33603,  34.08570,  29.54803,
     3   26.24306,  23.70134,  21.70865,  20.11374,  18.83297,
     4   17.78704,  16.93208,  16.22026,  15.63486,  15.14457,
     5   14.73948,  14.40060,  14.12137,  13.88983,  13.70027,
     6   13.54326,  13.41520,  13.30943,  13.22047,  13.14348,
     7   13.07348,  13.00599,  12.93701,  12.86292,  12.78082,
     8   12.68899,  12.58592,  12.47140,  12.34576,  12.21007,
     9   12.06552                                                       
     * /   
          data ( BrSTLB(i,   19), i=  1,   41)/
     1  277.97011, 266.99585, 191.38926, 120.92877,  81.62753,
     2   59.72334,  46.61654,  38.05166,  32.26551,  28.16972,
     3   25.13934,  22.78304,  20.94287,  19.49931,  18.32138,
     4   17.37230,  16.59675,  15.95964,  15.43320,  14.99951,
     5   14.64102,  14.34738,  14.10673,  13.91148,  13.75424,
     6   13.62622,  13.52444,  13.44192,  13.37449,  13.31635,
     7   13.26276,  13.20982,  13.15275,  13.08883,  13.01469,
     8   12.92899,  12.83044,  12.71894,  12.59518,  12.46010,
     9   12.31559                                                       
     * /   
          data ( BrSTLB(i,   20), i=  1,   41)/
     1  286.47501, 273.10620, 184.90946, 113.84711,  76.44061,
     2   55.97007,  43.89921,  36.09380,  30.73297,  26.91149,
     3   24.11470,  21.94602,  20.27309,  18.94098,  17.87266,
     4   17.01359,  16.31749,  15.74833,  15.27910,  14.89968,
     5   14.58795,  14.33660,  14.13181,  13.96879,  13.84053,
     6   13.73998,  13.66213,  13.60145,  13.55271,  13.51159,
     7   13.47300,  13.43255,  13.38608,  13.33044,  13.26300,
     8   13.18186,  13.08650,  12.97682,  12.85361,  12.71828,
     9   12.57284                                                       
     * /   
          data ( BrSTLB(i,   21), i=  1,   41)/
     1  294.91677, 276.16368, 177.28382, 106.87763,  71.52760,
     2   52.84238,  41.18185,  34.13599,  29.29636,  25.77329,
     3   23.16911,  21.21725,  19.66094,  18.45265,  17.49718,
     4   16.71881,  16.09420,  15.58625,  15.17647,  14.84506,
     5   14.57759,  14.36157,  14.19287,  14.06022,  13.95927,
     6   13.88228,  13.82633,  13.78491,  13.75371,  13.72756,
     7   13.70203,  13.67257,  13.63524,  13.58673,  13.52424,
     8   13.44644,  13.35295,  13.24374,  13.12008,  12.98359,
     9   12.83619                                                       
     * /   
          data ( BrSTLB(i,   22), i=  1,   41)/
     1  303.30561, 279.21998, 169.27561, 100.13366,  66.92444,
     2   49.08885,  39.06854,  32.50466,  27.95567,  24.75509,
     3   22.34192,  20.54263,  19.14463,  18.04821,  17.17398,
     4   16.47991,  15.92683,  15.47829,  15.12131,  14.83239,
     5   14.60459,  14.42456,  14.28621,  14.18101,  14.10498,
     6   14.05084,  14.01399,  13.99061,  13.97472,  13.96222,
     7   13.94841,  13.92859,  13.89873,  13.85572,  13.79681,
     8   13.72122,  13.62833,  13.51862,  13.39360,  13.25489,
     9   13.10499                                                       
     * /   
          data ( BrSTLB(i,   23), i=  1,   41)/
     1  311.65023, 279.22372, 160.50360,  93.65305,  62.63123,
     2   46.58671,  36.95525,  30.87340,  26.71089,  23.79692,
     3   21.59367,  19.94914,  18.68581,  17.69966,  16.91343,
     4   16.29683,  15.80911,  15.41948,  15.10568,  14.86169,
     5   14.66900,  14.52116,  14.41000,  14.33129,  14.27640,
     6   14.24214,  14.22426,  14.21640,  14.21473,  14.21430,
     7   14.21027,  14.19858,  14.17469,  14.13597,  14.07965,
     8   14.00515,  13.91159,  13.80036,  13.67299,  13.53135,
     9   13.37807                                                       
     * /   
          data ( BrSTLB(i,   24), i=  1,   41)/
     1  319.95799, 279.22665, 151.73096,  87.51132,  58.64803,
     2   43.45888,  34.84202,  29.40540,  25.65777,  22.95867,
     3   20.92432,  19.43670,  18.30358,  17.40697,  16.71549,
     4   16.16953,  15.74101,  15.39998,  15.13356,  14.92652,
     5   14.76551,  14.64698,  14.56247,  14.50630,  14.47231,
     6   14.45640,  14.45408,  14.46007,  14.47093,  14.48129,
     7   14.48647,  14.48116,  14.46217,  14.42659,  14.37163,
     8   14.29654,  14.20163,  14.08796,  13.95736,  13.81202,
     9   13.65501                                                       
     * /   
          data ( BrSTLB(i,   25), i=  1,   41)/
     1  328.23512, 279.22895, 142.76711,  81.70856,  54.97490,
     2   40.95674,  33.33271,  28.10063,  24.60474,  22.18041,
     3   20.37321,  19.00528,  17.97876,  17.18402,  16.56967,
     4   16.09000,  15.71632,  15.42470,  15.19704,  15.02369,
     5   14.89421,  14.80209,  14.73992,  14.70293,  14.68720,
     6   14.68885,  14.70038,  14.72041,  14.74272,  14.76226,
     7   14.77469,  14.77490,  14.75986,  14.72570,  14.67091,
     8   14.59448,  14.49725,  14.38036,  14.24573,  14.09632,
     9   13.93470                                                       
     * /   
          data ( BrSTLB(i,   26), i=  1,   41)/
     1  336.48684, 273.12732, 133.99368,  76.28251,  51.58798,
     2   39.08021,  31.52155,  26.95905,  23.74329,  21.52198,
     3   19.86154,  18.65481,  17.73042,  17.01686,  16.47597,
     4   16.05825,  15.73504,  15.48382,  15.29221,  15.15002,
     5   15.04980,  14.97987,  14.93866,  14.92131,  14.92265,
     6   14.93842,  14.96448,  14.99567,  15.02765,  15.05503,
     7   15.07368,  15.07868,  15.06568,  15.03228,  14.97650,
     8   14.89799,  14.79753,  14.67667,  14.53747,  14.38326,
     9   14.21685                                                       
     * /   
          data ( BrSTLB(i,   27), i=  1,   41)/
     1  344.71752, 270.07698, 125.41076,  71.23322,  48.47538,
     2   37.20370,  30.31421,  25.81753,  22.97763,  20.92348,
     3   19.42865,  18.35831,  17.52031,  16.90544,  16.43437,
     4   16.06629,  15.79098,  15.57738,  15.41910,  15.30557,
     5   15.22699,  15.18041,  15.15881,  15.15831,  15.17457,
     6   15.20406,  15.24187,  15.28361,  15.32416,  15.35903,
     7   15.38257,  15.39059,  15.37884,  15.34527,  15.28767,
     8   15.20633,  15.10169,  14.97608,  14.83189,  14.67240,
     9   14.50065                                                       
     * /   
          data ( BrSTLB(i,   28), i=  1,   41)/
     1  352.93081, 260.92282, 117.20916,  66.56073,  45.63710,
     2   35.32722,  28.80505,  24.83917,  22.30773,  20.44474,
     3   19.07452,  18.11574,  17.38664,  16.84976,  16.43443,
     4   16.12212,  15.88414,  15.70541,  15.57380,  15.48717,
     5   15.42857,  15.40155,  15.39667,  15.41243,  15.44168,
     6   15.48342,  15.53219,  15.58290,  15.63111,  15.67197,
     7   15.69925,  15.70976,  15.69854,  15.66352,  15.60362,
     8   15.51806,  15.40899,  15.27803,  15.12837,  14.96307,
     9   14.78567                                                       
     * /   
          data ( BrSTLB(i,   29), i=  1,   41)/
     1  361.12977, 254.82013, 109.38893,  62.26505,  43.03736,
     2   33.45077,  27.59780,  24.02393,  21.63789,  19.96604,
     3   18.79911,  17.95406,  17.31028,  16.82194,  16.46575,
     4   16.20184,  16.00216,  15.85811,  15.75241,  15.68516,
     5   15.64923,  15.63889,  15.65043,  15.68050,  15.72270,
     6   15.77542,  15.83364,  15.89275,  15.94731,  15.99277,
     7   16.02352,  16.03489,  16.02318,  15.98616,  15.92283,
     8   15.83294,  15.71851,  15.58189,  15.42607,  15.25484,
     9   15.07162                                                       
     * /   
          data ( BrSTLB(i,   30), i=  1,   41)/
     1  369.31695, 242.61372, 101.95012,  58.30850,  40.67616,
     2   31.57438,  26.69241,  23.37178,  21.15947,  19.66688,
     3   18.60241,  17.81933,  17.27212,  16.84986,  16.54918,
     4   16.32140,  16.15126,  16.03058,  15.95497,  15.90608,
     5   15.88906,  15.89478,  15.92020,  15.96098,  16.01488,
     6   16.07766,  16.14470,  16.21076,  16.27155,  16.32077,
     7   16.35356,  16.36539,  16.35254,  16.31264,  16.24505,
     8   16.15003,  16.02994,  15.88697,  15.72492,  15.54744,
     9   15.35816                                                       
     * /   
          data ( BrSTLB(i,   31), i=  1,   41)/
     1  377.49446, 233.45889,  94.89274,  54.65341,  38.51771,
     2   30.32351,  25.48524,  22.71965,  20.68108,  19.36774,
     3   18.44507,  17.76546,  17.27215,  16.91957,  16.65346,
     4   16.46489,  16.32527,  16.23273,  16.17360,  16.14678,
     5   16.14274,  16.16251,  16.20029,  16.25399,  16.31833,
     6   16.39027,  16.46436,  16.53709,  16.60211,  16.65439,
     7   16.68872,  16.69987,  16.68529,  16.64163,  16.56931,
     8   16.46893,  16.34241,  16.19305,  16.02429,  15.84020,
     9   15.64475                                                       
     * /   
          data ( BrSTLB(i,   32), i=  1,   41)/
     1  385.66405, 221.25217,  88.40756,  51.33747,  36.56201,
     2   29.07265,  24.88170,  22.06755,  20.29839,  19.12845,
     3   18.32706,  17.73854,  17.32949,  17.01717,  16.78903,
     4   16.63235,  16.51800,  16.44981,  16.41231,  16.39754,
     5   16.41035,  16.44443,  16.49274,  16.55629,  16.63029,
     6   16.70955,  16.79104,  16.86929,  16.93866,  16.99331,
     7   17.02787,  17.03843,  17.02076,  16.97316,  16.89560,
     8   16.78894,  16.65586,  16.49950,  16.32405,  16.13327,
     9   15.93133                                                       
     * /   
          data ( BrSTLB(i,   33), i=  1,   41)/
     1  393.82716, 209.04535,  82.49460,  48.32298,  34.79713,
     2   27.82183,  23.97639,  21.57850,  20.01139,  19.00881,
     3   18.28774,  17.76551,  17.40593,  17.14265,  16.95591,
     4   16.82378,  16.73571,  16.68679,  16.66321,  16.66492,
     5   16.68924,  16.73380,  16.79569,  16.86799,  16.94937,
     6   17.03686,  17.12428,  17.20695,  17.27986,  17.33587,
     7   17.37069,  17.37919,  17.35824,  17.30619,  17.22287,
     8   17.10972,  16.96969,  16.80619,  16.62368,  16.42593,
     9   16.21766                                                       
     * /   
          data ( BrSTLB(i,   34), i=  1,   41)/
     1  401.98497, 196.83846,  76.77236,  45.57228,  33.18730,
     2   27.19643,  23.37288,  21.25248,  19.82007,  18.88918,
     3   18.28776,  17.84639,  17.52058,  17.29603,  17.14370,
     4   17.03124,  16.96598,  16.93384,  16.92633,  16.94574,
     5   16.97947,  17.03523,  17.10532,  17.18748,  17.27566,
     6   17.36972,  17.46300,  17.54963,  17.62484,  17.68215,
     7   17.71642,  17.72258,  17.69737,  17.64033,  17.55071,
     8   17.43087,  17.28360,  17.11280,  16.92300,  16.71849,
     9   16.50348                                                       
     * /   
          data ( BrSTLB(i,   35), i=  1,   41)/
     1  410.13844, 184.63152,  71.81310,  43.04767,  31.73250,
     2   25.94565,  22.76937,  20.92647,  19.62875,  18.88919,
     3   18.32712,  17.92726,  17.65435,  17.47732,  17.35241,
     4   17.26274,  17.21507,  17.20087,  17.20570,  17.23350,
     5   17.28110,  17.34422,  17.42366,  17.51147,  17.60925,
     6   17.70821,  17.80614,  17.89636,  17.97369,  18.03131,
     7   18.06427,  18.06743,  18.03815,  17.97518,  17.87904,
     8   17.75208,  17.59728,  17.41918,  17.22197,  17.01035,
     9   16.78875                                                       
     * /   
          data ( BrSTLB(i,   36), i=  1,   41)/
     1  418.28836, 175.47631,  67.04457,  40.78684,  30.42081,
     2   25.32027,  22.46763,  20.60046,  19.53309,  18.88920,
     3   18.40581,  18.06206,  17.82636,  17.67260,  17.57163,
     4   17.51031,  17.47679,  17.47308,  17.49338,  17.53151,
     5   17.58875,  17.66083,  17.74684,  17.84340,  17.94577,
     6   18.05076,  18.15315,  18.24667,  18.32547,  18.38296,
     7   18.41382,  18.41375,  18.37941,  18.31068,  18.20743,
     8   18.07308,  17.91077,  17.72494,  17.52020,  17.30163,
     9   17.07350                                                       
     * /   
          data ( BrSTLB(i,   37), i=  1,   41)/
     1  426.43539, 163.26929,  62.65753,  38.71442,  29.25223,
     2   24.69490,  21.86415,  20.43747,  19.53310,  18.88921,
     3   18.48451,  18.22381,  18.01750,  17.89582,  17.81180,
     4   17.76600,  17.75116,  17.76040,  17.78940,  17.83653,
     5   17.90245,  17.98280,  18.07689,  18.17993,  18.28825,
     6   18.39742,  18.50352,  18.59955,  18.67926,  18.73620,
     7   18.76466,  18.76070,  18.72148,  18.64600,  18.53605,
     8   18.39391,  18.22372,  18.03010,  17.81785,  17.59230,
     9   17.35739                                                       
     * /   
          data ( BrSTLB(i,   38), i=  1,   41)/
     1   17.53785,  16.78465,  17.45231,  17.53865,  17.54316,
     2   17.81635,  17.64023,  17.50379,  17.52445,  17.57326,
     3   17.57973,  17.60386,  17.61616,  17.64471,  17.68649,
     4   17.72604,  17.78235,  17.84467,  17.92154,  18.00401,
     5   18.10190,  18.20635,  18.32113,  18.44084,  18.56482,
     6   18.68805,  18.80465,  18.90930,  18.99494,  19.05597,
     7   19.08634,  19.08172,  19.03996,  18.96122,  18.84626,
     8   18.69848,  18.52244,  18.32268,  18.10447,  17.87275,
     9   17.63254                                                       
     * /   

!  consts for Pair  sampling table at low energies

      data PairEgmin/  1.100000000000000E-003/
      data PairLEgmin/ -2.95860731484177/
      data PairNonSc/  8.000000000000000E-003/
      data PrScrE/  77.0769320180600/
      data PairEgmaxL/  28257261.4107884/
      data PairTXTL/  48/
      data PairEsize/  48/
      data PairUminLA/  5.000000000000000E-002/
      data PairUmaxLA/  1.00000000000000/
      data PairUszLA/  41/
      data PairdULA/  2.375000000000000E-002/
      data PairdETXL/  .103096419881820/
      data PairUminLB/  .000000000000000/
      data PairUmaxLB/  .472870804501588/
      data PairUszLB/  41/
      data PairdULB/  1.182177011253970E-002/
      data PairdELA/  .103096419881820/
      data PairdELB/  4.683525219905790E-002/

         data ( PrTXL(i), i=  1,   48)/
     1  0.4181E-04, 0.2398E-02, 0.1023E-01, 0.2396E-01, 0.4294E-01,
     2  0.6634E-01, 0.9335E-01, 0.1233E+00, 0.1556E+00, 0.1898E+00,
     3  0.2261E+00, 0.2628E+00, 0.2998E+00, 0.3367E+00, 0.3733E+00,
     4  0.4093E+00, 0.4445E+00, 0.4785E+00, 0.5111E+00, 0.5423E+00,
     5  0.5716E+00, 0.5979E+00, 0.6218E+00, 0.6437E+00, 0.6632E+00,
     6  0.6803E+00, 0.6952E+00, 0.7083E+00, 0.7194E+00, 0.7289E+00,
     7  0.7370E+00, 0.7439E+00, 0.7497E+00, 0.7545E+00, 0.7585E+00,
     8  0.7619E+00, 0.7647E+00, 0.7670E+00, 0.7690E+00, 0.7706E+00,
     9  0.7719E+00, 0.7729E+00, 0.7738E+00, 0.7745E+00, 0.7751E+00,
     a  0.7756E+00, 0.7760E+00, 0.7737E+00                              
     * /   
          data ( PrSTLA(i,   1), i=  1,   41)/
     1   .03277,  .03221,  .03176,  .03138,  .03105,  .03077,  .03050,
     2   .03028,  .03006,  .02988,  .02970,  .02954,  .02940,  .02926,
     3   .02912,  .02900,  .02891,  .02880,  .02870,  .02861,  .02853,
     4   .02846,  .02838,  .02831,  .02826,  .02820,  .02815,  .02811,
     5   .02805,  .02801,  .02797,  .02796,  .02790,  .02788,  .02785,
     6   .02788,  .02784,  .02788,  .02779,  .02788,  .02781            
     * /   
          data ( PrSTLA(i,   2), i=  1,   41)/
     1   .12344,  .12130,  .11959,  .11814,  .11689,  .11581,  .11483,
     2   .11395,  .11315,  .11244,  .11177,  .11116,  .11060,  .11008,
     3   .10959,  .10915,  .10873,  .10834,  .10797,  .10764,  .10734,
     4   .10704,  .10677,  .10652,  .10629,  .10607,  .10587,  .10570,
     5   .10552,  .10537,  .10523,  .10513,  .10501,  .10491,  .10482,
     6   .10477,  .10469,  .10468,  .10465,  .10456,  .10461            
     * /   
          data ( PrSTLA(i,   3), i=  1,   41)/
     1   .19490,  .19153,  .18882,  .18653,  .18457,  .18286,  .18133,
     2   .17995,  .17871,  .17757,  .17653,  .17558,  .17470,  .17389,
     3   .17313,  .17243,  .17179,  .17118,  .17061,  .17010,  .16960,
     4   .16915,  .16874,  .16835,  .16799,  .16765,  .16735,  .16708,
     5   .16681,  .16659,  .16635,  .16619,  .16601,  .16586,  .16576,
     6   .16561,  .16552,  .16546,  .16549,  .16528,  .16539            
     * /   
          data ( PrSTLA(i,   4), i=  1,   41)/
     1   .25130,  .24698,  .24352,  .24062,  .23814,  .23596,  .23403,
     2   .23229,  .23072,  .22930,  .22799,  .22680,  .22570,  .22468,
     3   .22375,  .22288,  .22207,  .22131,  .22063,  .21998,  .21937,
     4   .21883,  .21830,  .21781,  .21738,  .21697,  .21659,  .21625,
     5   .21595,  .21565,  .21539,  .21516,  .21496,  .21475,  .21459,
     6   .21450,  .21437,  .21427,  .21424,  .21415,  .21419            
     * /   
          data ( PrSTLA(i,   5), i=  1,   41)/
     1   .29589,  .29089,  .28690,  .28359,  .28074,  .27826,  .27606,
     2   .27410,  .27233,  .27073,  .26928,  .26793,  .26672,  .26557,
     3   .26454,  .26358,  .26268,  .26186,  .26110,  .26038,  .25972,
     4   .25912,  .25856,  .25803,  .25755,  .25710,  .25669,  .25633,
     5   .25598,  .25565,  .25537,  .25512,  .25491,  .25470,  .25456,
     6   .25444,  .25427,  .25425,  .25422,  .25411,  .25410            
     * /   
          data ( PrSTLA(i,   6), i=  1,   41)/
     1   .33124,  .32580,  .32148,  .31792,  .31487,  .31222,  .30990,
     2   .30782,  .30596,  .30428,  .30276,  .30138,  .30011,  .29895,
     3   .29787,  .29688,  .29598,  .29514,  .29435,  .29363,  .29296,
     4   .29234,  .29178,  .29126,  .29077,  .29033,  .28992,  .28956,
     5   .28922,  .28890,  .28865,  .28839,  .28819,  .28800,  .28780,
     6   .28768,  .28756,  .28743,  .28741,  .28736,  .28736            
     * /   
          data ( PrSTLA(i,   7), i=  1,   41)/
     1   .35939,  .35370,  .34923,  .34555,  .34244,  .33976,  .33740,
     2   .33532,  .33347,  .33180,  .33029,  .32892,  .32768,  .32653,
     3   .32549,  .32454,  .32366,  .32285,  .32211,  .32142,  .32080,
     4   .32020,  .31967,  .31920,  .31873,  .31833,  .31794,  .31761,
     5   .31728,  .31701,  .31676,  .31651,  .31633,  .31616,  .31602,
     6   .31587,  .31578,  .31571,  .31569,  .31563,  .31559            
     * /   
          data ( PrSTLA(i,   8), i=  1,   41)/
     1   .38192,  .37617,  .37168,  .36803,  .36495,  .36231,  .36002,
     2   .35800,  .35621,  .35462,  .35318,  .35189,  .35072,  .34966,
     3   .34869,  .34783,  .34702,  .34627,  .34561,  .34498,  .34443,
     4   .34392,  .34345,  .34301,  .34262,  .34224,  .34191,  .34163,
     5   .34135,  .34111,  .34091,  .34071,  .34054,  .34039,  .34028,
     6   .34018,  .34009,  .34004,  .33993,  .33986,  .33992            
     * /   
          data ( PrSTLA(i,   9), i=  1,   41)/
     1   .40008,  .39439,  .39001,  .38646,  .38350,  .38099,  .37881,
     2   .37693,  .37526,  .37377,  .37246,  .37128,  .37024,  .36929,
     3   .36843,  .36766,  .36693,  .36632,  .36572,  .36520,  .36474,
     4   .36428,  .36391,  .36355,  .36323,  .36295,  .36268,  .36243,
     5   .36223,  .36203,  .36186,  .36172,  .36158,  .36148,  .36139,
     6   .36132,  .36122,  .36123,  .36112,  .36105,  .36113            
     * /   
          data ( PrSTLA(i,   10), i=  1,   41)/
     1   .41312,  .40764,  .40349,  .40021,  .39750,  .39524,  .39332,
     2   .39165,  .39022,  .38897,  .38786,  .38690,  .38603,  .38526,
     3   .38459,  .38401,  .38347,  .38298,  .38255,  .38219,  .38185,
     4   .38156,  .38129,  .38106,  .38085,  .38067,  .38051,  .38037,
     5   .38025,  .38013,  .38005,  .37995,  .37990,  .37983,  .37978,
     6   .37972,  .37970,  .37966,  .37974,  .37966,  .37966            
     * /   
          data ( PrSTLA(i,   11), i=  1,   41)/
     1   .42611,  .42099,  .41716,  .41416,  .41171,  .40969,  .40798,
     2   .40655,  .40529,  .40423,  .40330,  .40252,  .40182,  .40121,
     3   .40070,  .40025,  .39986,  .39951,  .39921,  .39896,  .39876,
     4   .39857,  .39841,  .39828,  .39818,  .39810,  .39803,  .39797,
     5   .39792,  .39787,  .39784,  .39783,  .39782,  .39781,  .39779,
     6   .39777,  .39780,  .39777,  .39784,  .39777,  .39778            
     * /   
          data ( PrSTLA(i,   12), i=  1,   41)/
     1   .43671,  .43198,  .42849,  .42577,  .42358,  .42179,  .42032,
     2   .41907,  .41805,  .41716,  .41642,  .41579,  .41527,  .41482,
     3   .41445,  .41415,  .41390,  .41370,  .41354,  .41342,  .41334,
     4   .41327,  .41323,  .41321,  .41320,  .41321,  .41322,  .41326,
     5   .41327,  .41332,  .41334,  .41341,  .41341,  .41347,  .41348,
     6   .41351,  .41355,  .41361,  .41358,  .41351,  .41361            
     * /   
          data ( PrSTLA(i,   13), i=  1,   41)/
     1   .44548,  .44116,  .43798,  .43556,  .43363,  .43209,  .43083,
     2   .42980,  .42896,  .42827,  .42771,  .42726,  .42691,  .42662,
     3   .42641,  .42625,  .42615,  .42610,  .42607,  .42607,  .42610,
     4   .42615,  .42621,  .42631,  .42639,  .42651,  .42661,  .42671,
     5   .42683,  .42695,  .42704,  .42713,  .42726,  .42733,  .42743,
     6   .42745,  .42754,  .42761,  .42758,  .42751,  .42763            
     * /   
          data ( PrSTLA(i,   14), i=  1,   41)/
     1   .45280,  .44887,  .44603,  .44389,  .44222,  .44090,  .43988,
     2   .43906,  .43840,  .43792,  .43752,  .43725,  .43705,  .43694,
     3   .43688,  .43688,  .43691,  .43700,  .43710,  .43723,  .43737,
     4   .43755,  .43773,  .43793,  .43811,  .43832,  .43852,  .43873,
     5   .43891,  .43908,  .43927,  .43941,  .43958,  .43972,  .43985,
     6   .43990,  .43999,  .44013,  .44010,  .44003,  .44017            
     * /   
          data ( PrSTLA(i,   15), i=  1,   41)/
     1   .45897,  .45542,  .45291,  .45103,  .44962,  .44856,  .44773,
     2   .44713,  .44668,  .44637,  .44616,  .44604,  .44602,  .44605,
     3   .44615,  .44629,  .44646,  .44668,  .44692,  .44718,  .44745,
     4   .44774,  .44804,  .44833,  .44864,  .44893,  .44922,  .44950,
     5   .44978,  .45002,  .45028,  .45050,  .45069,  .45089,  .45106,
     6   .45117,  .45133,  .45139,  .45152,  .45160,  .45151            
     * /   
          data ( PrSTLA(i,   16), i=  1,   41)/
     1   .46422,  .46103,  .45884,  .45724,  .45610,  .45524,  .45465,
     2   .45423,  .45398,  .45383,  .45382,  .45387,  .45400,  .45420,
     3   .45445,  .45474,  .45505,  .45539,  .45576,  .45616,  .45655,
     4   .45695,  .45736,  .45776,  .45816,  .45855,  .45894,  .45931,
     5   .45966,  .45999,  .46030,  .46057,  .46083,  .46107,  .46129,
     6   .46147,  .46159,  .46168,  .46186,  .46179,  .46186            
     * /   
          data ( PrSTLA(i,   17), i=  1,   41)/
     1   .46870,  .46590,  .46400,  .46270,  .46178,  .46116,  .46077,
     2   .46055,  .46049,  .46053,  .46068,  .46090,  .46121,  .46156,
     3   .46194,  .46237,  .46285,  .46330,  .46381,  .46433,  .46485,
     4   .46536,  .46587,  .46639,  .46690,  .46739,  .46786,  .46830,
     5   .46874,  .46915,  .46951,  .46988,  .47019,  .47045,  .47070,
     6   .47091,  .47108,  .47125,  .47127,  .47135,  .47143            
     * /   
          data ( PrSTLA(i,   18), i=  1,   41)/
     1   .47259,  .47014,  .46856,  .46751,  .46684,  .46644,  .46626,
     2   .46626,  .46637,  .46659,  .46692,  .46731,  .46775,  .46824,
     3   .46880,  .46938,  .46998,  .47058,  .47122,  .47186,  .47250,
     4   .47314,  .47376,  .47438,  .47498,  .47558,  .47612,  .47668,
     5   .47717,  .47766,  .47810,  .47853,  .47890,  .47925,  .47950,
     6   .47979,  .47999,  .48010,  .48018,  .48042,  .48035            
     * /   
          data ( PrSTLA(i,   19), i=  1,   41)/
     1   .47599,  .47390,  .47260,  .47182,  .47140,  .47122,  .47124,
     2   .47142,  .47172,  .47213,  .47262,  .47318,  .47377,  .47443,
     3   .47512,  .47586,  .47658,  .47734,  .47810,  .47885,  .47962,
     4   .48036,  .48110,  .48184,  .48254,  .48321,  .48387,  .48451,
     5   .48509,  .48566,  .48616,  .48666,  .48709,  .48746,  .48780,
     6   .48808,  .48834,  .48856,  .48870,  .48877,  .48876            
     * /   
          data ( PrSTLA(i,   20), i=  1,   41)/
     1   .47898,  .47724,  .47624,  .47572,  .47551,  .47556,  .47578,
     2   .47617,  .47665,  .47723,  .47790,  .47861,  .47938,  .48020,
     3   .48103,  .48188,  .48278,  .48364,  .48454,  .48544,  .48631,
     4   .48718,  .48804,  .48886,  .48968,  .49045,  .49121,  .49192,
     5   .49258,  .49322,  .49380,  .49433,  .49484,  .49526,  .49567,
     6   .49598,  .49629,  .49649,  .49657,  .49681,  .49674            
     * /   
          data ( PrSTLA(i,   21), i=  1,   41)/
     1   .48165,  .48024,  .47954,  .47928,  .47931,  .47957,  .47999,
     2   .48055,  .48123,  .48199,  .48283,  .48370,  .48463,  .48559,
     3   .48659,  .48760,  .48861,  .48963,  .49064,  .49167,  .49267,
     4   .49366,  .49462,  .49557,  .49649,  .49736,  .49820,  .49899,
     5   .49976,  .50047,  .50112,  .50175,  .50225,  .50276,  .50317,
     6   .50356,  .50383,  .50405,  .50418,  .50426,  .50441            
     * /   
          data ( PrSTLA(i,   22), i=  1,   41)/
     1   .48409,  .48304,  .48263,  .48265,  .48294,  .48344,  .48410,
     2   .48488,  .48577,  .48673,  .48776,  .48887,  .48998,  .49115,
     3   .49234,  .49354,  .49477,  .49599,  .49721,  .49843,  .49965,
     4   .50084,  .50203,  .50321,  .50438,  .50549,  .50658,  .50761,
     5   .50849,  .50939,  .51012,  .51048,  .51133,  .51224,  .51196,
     6   .51266,  .51347,  .51247,  .51303,  .51183,  .51390            
     * /   
          data ( PrSTLA(i,   23), i=  1,   41)/
     1   .48629,  .48560,  .48549,  .48577,  .48632,  .48707,  .48795,
     2   .48896,  .49006,  .49125,  .49249,  .49378,  .49512,  .49648,
     3   .49787,  .49927,  .50068,  .50211,  .50349,  .50475,  .50614,
     4   .50734,  .50870,  .50976,  .51104,  .51201,  .51311,  .51427,
     5   .51499,  .51601,  .51705,  .51778,  .51874,  .51878,  .51953,
     6   .52039,  .52127,  .52169,  .52315,  .51987,  .52083            
     * /   
          data ( PrSTLA(i,   24), i=  1,   41)/
     1   .48828,  .48792,  .48811,  .48866,  .48945,  .49042,  .49154,
     2   .49274,  .49404,  .49542,  .49686,  .49834,  .49985,  .50134,
     3   .50283,  .50428,  .50575,  .50726,  .50865,  .51011,  .51144,
     4   .51290,  .51425,  .51565,  .51672,  .51802,  .51927,  .52035,
     5   .52108,  .52212,  .52310,  .52402,  .52493,  .52550,  .52627,
     6   .52568,  .52615,  .52640,  .52675,  .52683,  .52784            
     * /   
          data ( PrSTLA(i,   25), i=  1,   41)/
     1   .49011,  .49008,  .49056,  .49136,  .49239,  .49358,  .49491,
     2   .49632,  .49782,  .49935,  .50092,  .50250,  .50409,  .50568,
     3   .50732,  .50891,  .51058,  .51220,  .51370,  .51531,  .51685,
     4   .51822,  .51973,  .52120,  .52264,  .52394,  .52492,  .52616,
     5   .52734,  .52846,  .52953,  .53054,  .53125,  .53129,  .53189,
     6   .53239,  .53283,  .53314,  .53343,  .53367,  .53449            
     * /   
          data ( PrSTLA(i,   26), i=  1,   41)/
     1   .49180,  .49208,  .49282,  .49388,  .49514,  .49654,  .49806,
     2   .49962,  .50121,  .50293,  .50461,  .50632,  .50808,  .50981,
     3   .51160,  .51337,  .51505,  .51683,  .51859,  .52026,  .52179,
     4   .52345,  .52506,  .52664,  .52809,  .52956,  .53065,  .53198,
     5   .53321,  .53441,  .53555,  .53659,  .53741,  .53828,  .53822,
     6   .53877,  .53927,  .53958,  .53987,  .54012,  .54070            
     * /   
          data ( PrSTLA(i,   27), i=  1,   41)/
     1   .49334,  .49392,  .49494,  .49622,  .49769,  .49923,  .50089,
     2   .50262,  .50438,  .50621,  .50804,  .50994,  .51178,  .51371,
     3   .51561,  .51741,  .51933,  .52119,  .52305,  .52485,  .52649,
     4   .52825,  .52995,  .53161,  .53323,  .53471,  .53592,  .53729,
     5   .53862,  .53987,  .54102,  .54214,  .54314,  .54411,  .54480,
     6   .54559,  .54525,  .54553,  .54577,  .54585,  .54644            
     * /   
          data ( PrSTLA(i,   28), i=  1,   41)/
     1   .49474,  .49560,  .49686,  .49834,  .49995,  .50167,  .50349,
     2   .50533,  .50727,  .50921,  .51122,  .51316,  .51518,  .51722,
     3   .51920,  .52114,  .52312,  .52509,  .52706,  .52894,  .53067,
     4   .53248,  .53425,  .53598,  .53764,  .53925,  .54079,  .54217,
     5   .54325,  .54450,  .54567,  .54675,  .54769,  .54859,  .54936,
     6   .55005,  .55068,  .55120,  .55176,  .55120,  .55178            
     * /   
          data ( PrSTLA(i,   29), i=  1,   41)/
     1   .49603,  .49716,  .49863,  .50026,  .50203,  .50391,  .50588,
     2   .50789,  .50994,  .51198,  .51412,  .51623,  .51830,  .52043,
     3   .52255,  .52464,  .52664,  .52869,  .53070,  .53272,  .53467,
     4   .53654,  .53825,  .54004,  .54175,  .54340,  .54500,  .54652,
     5   .54795,  .54931,  .55056,  .55163,  .55232,  .55321,  .55397,
     6   .55465,  .55519,  .55566,  .55595,  .55619,  .55648            
     * /   
          data ( PrSTLA(i,   30), i=  1,   41)/
     1   .49721,  .49857,  .50019,  .50202,  .50394,  .50596,  .50803,
     2   .51018,  .51234,  .51450,  .51671,  .51893,  .52109,  .52330,
     3   .52550,  .52768,  .52985,  .53190,  .53399,  .53603,  .53807,
     4   .54004,  .54196,  .54382,  .54557,  .54716,  .54878,  .55034,
     5   .55180,  .55318,  .55446,  .55566,  .55676,  .55776,  .55866,
     6   .55935,  .56007,  .55997,  .56027,  .56051,  .56067            
     * /   
          data ( PrSTLA(i,   31), i=  1,   41)/
     1   .49828,  .49982,  .50162,  .50357,  .50565,  .50779,  .51000,
     2   .51220,  .51447,  .51671,  .51902,  .52131,  .52360,  .52588,
     3   .52810,  .53035,  .53257,  .53479,  .53695,  .53905,  .54105,
     4   .54307,  .54503,  .54693,  .54877,  .55054,  .55224,  .55386,
     5   .55534,  .55677,  .55791,  .55909,  .56020,  .56117,  .56204,
     6   .56280,  .56347,  .56404,  .56455,  .56544,  .56439            
     * /   
          data ( PrSTLA(i,   32), i=  1,   41)/
     1   .49922,  .50096,  .50290,  .50499,  .50717,  .50941,  .51172,
     2   .51400,  .51635,  .51872,  .52105,  .52341,  .52577,  .52812,
     3   .53046,  .53275,  .53499,  .53722,  .53943,  .54161,  .54375,
     4   .54582,  .54782,  .54970,  .55157,  .55337,  .55510,  .55673,
     5   .55826,  .55972,  .56108,  .56228,  .56330,  .56433,  .56518,
     6   .56591,  .56653,  .56702,  .56737,  .56745,  .56764            
     * /   
          data ( PrSTLA(i,   33), i=  1,   41)/
     1   .50007,  .50196,  .50405,  .50625,  .50854,  .51085,  .51322,
     2   .51562,  .51800,  .52042,  .52285,  .52529,  .52765,  .53004,
     3   .53245,  .53479,  .53714,  .53944,  .54169,  .54385,  .54603,
     4   .54814,  .55019,  .55219,  .55409,  .55594,  .55765,  .55932,
     5   .56087,  .56236,  .56369,  .56495,  .56606,  .56706,  .56792,
     6   .56874,  .56933,  .56977,  .57017,  .57041,  .57045            
     * /   
          data ( PrSTLA(i,   34), i=  1,   41)/
     1   .50083,  .50286,  .50506,  .50736,  .50971,  .51213,  .51454,
     2   .51701,  .51948,  .52192,  .52440,  .52687,  .52933,  .53179,
     3   .53421,  .53659,  .53896,  .54128,  .54358,  .54586,  .54803,
     4   .55017,  .55226,  .55428,  .55621,  .55807,  .55986,  .56153,
     5   .56315,  .56463,  .56599,  .56726,  .56840,  .56946,  .57033,
     6   .57111,  .57179,  .57229,  .57264,  .57272,  .57286            
     * /   
          data ( PrSTLA(i,   35), i=  1,   41)/
     1   .50151,  .50366,  .50596,  .50834,  .51075,  .51322,  .51571,
     2   .51820,  .52073,  .52325,  .52577,  .52826,  .53075,  .53323,
     3   .53571,  .53812,  .54053,  .54289,  .54523,  .54752,  .54974,
     4   .55192,  .55402,  .55608,  .55804,  .55994,  .56174,  .56342,
     5   .56504,  .56657,  .56796,  .56923,  .57041,  .57143,  .57236,
     6   .57315,  .57384,  .57426,  .57461,  .57469,  .57493            
     * /   
          data ( PrSTLA(i,   36), i=  1,   41)/
     1   .50210,  .50437,  .50674,  .50917,  .51166,  .51417,  .51671,
     2   .51926,  .52180,  .52436,  .52691,  .52944,  .53197,  .53450,
     3   .53697,  .53944,  .54187,  .54426,  .54664,  .54893,  .55121,
     4   .55341,  .55553,  .55761,  .55960,  .56149,  .56333,  .56506,
     5   .56671,  .56824,  .56963,  .57094,  .57213,  .57316,  .57411,
     6   .57492,  .57557,  .57601,  .57641,  .57665,  .57669            
     * /   
          data ( PrSTLA(i,   37), i=  1,   41)/
     1   .50262,  .50497,  .50740,  .50990,  .51243,  .51500,  .51756,
     2   .52015,  .52273,  .52532,  .52790,  .53047,  .53303,  .53557,
     3   .53809,  .54057,  .54302,  .54543,  .54783,  .55015,  .55244,
     4   .55465,  .55683,  .55892,  .56091,  .56285,  .56469,  .56645,
     5   .56810,  .56964,  .57104,  .57236,  .57357,  .57466,  .57558,
     6   .57642,  .57712,  .57764,  .57788,  .57796,  .57818            
     * /   
          data ( PrSTLA(i,   38), i=  1,   41)/
     1   .50309,  .50550,  .50800,  .51053,  .51311,  .51570,  .51830,
     2   .52091,  .52351,  .52612,  .52874,  .53133,  .53390,  .53647,
     3   .53900,  .54152,  .54398,  .54643,  .54884,  .55118,  .55346,
     4   .55572,  .55790,  .56000,  .56202,  .56396,  .56581,  .56758,
     5   .56925,  .57080,  .57225,  .57356,  .57475,  .57583,  .57673,
     6   .57754,  .57819,  .57873,  .57903,  .57927,  .57945            
     * /   
          data ( PrSTLA(i,   39), i=  1,   41)/
     1   .50349,  .50596,  .50849,  .51107,  .51366,  .51628,  .51892,
     2   .52154,  .52419,  .52682,  .52944,  .53205,  .53465,  .53723,
     3   .53978,  .54230,  .54480,  .54726,  .54968,  .55205,  .55435,
     4   .55662,  .55881,  .56094,  .56298,  .56492,  .56679,  .56856,
     5   .57025,  .57181,  .57326,  .57461,  .57581,  .57690,  .57781,
     6   .57864,  .57925,  .57982,  .58017,  .58025,  .58050            
     * /   
          data ( PrSTLA(i,   40), i=  1,   41)/
     1   .50382,  .50635,  .50892,  .51153,  .51416,  .51679,  .51944,
     2   .52210,  .52475,  .52739,  .53005,  .53266,  .53528,  .53788,
     3   .54043,  .54298,  .54551,  .54797,  .55039,  .55277,  .55510,
     4   .55736,  .55957,  .56169,  .56375,  .56572,  .56761,  .56939,
     5   .57104,  .57264,  .57408,  .57545,  .57663,  .57774,  .57869,
     6   .57949,  .58014,  .58069,  .58115,  .58123,  .58139            
     * /   
          data ( PrSTLA(i,   41), i=  1,   41)/
     1   .50412,  .50669,  .50929,  .51190,  .51456,  .51722,  .51989,
     2   .52256,  .52522,  .52788,  .53055,  .53318,  .53580,  .53842,
     3   .54101,  .54356,  .54608,  .54857,  .55099,  .55339,  .55572,
     4   .55801,  .56021,  .56234,  .56441,  .56640,  .56829,  .57007,
     5   .57178,  .57335,  .57483,  .57617,  .57740,  .57844,  .57939,
     6   .58021,  .58088,  .58145,  .58180,  .58188,  .58213            
     * /   
          data ( PrSTLA(i,   42), i=  1,   41)/
     1   .50437,  .50696,  .50958,  .51224,  .51491,  .51758,  .52025,
     2   .52294,  .52563,  .52830,  .53097,  .53361,  .53624,  .53888,
     3   .54147,  .54403,  .54654,  .54905,  .55149,  .55389,  .55624,
     4   .55853,  .56073,  .56288,  .56496,  .56694,  .56885,  .57062,
     5   .57232,  .57392,  .57539,  .57675,  .57798,  .57904,  .57999,
     6   .58080,  .58153,  .58200,  .58245,  .58253,  .58275            
     * /   
          data ( PrSTLA(i,   43), i=  1,   41)/
     1   .50459,  .50720,  .50984,  .51251,  .51520,  .51788,  .52058,
     2   .52325,  .52595,  .52864,  .53131,  .53397,  .53662,  .53924,
     3   .54184,  .54442,  .54695,  .54945,  .55191,  .55433,  .55666,
     4   .55897,  .56119,  .56334,  .56542,  .56740,  .56931,  .57112,
     5   .57281,  .57442,  .57591,  .57726,  .57850,  .57960,  .58059,
     6   .58138,  .58210,  .58254,  .58294,  .58318,  .58326            
     * /   
          data ( PrSTLA(i,   44), i=  1,   41)/
     1   .50477,  .50740,  .51007,  .51274,  .51543,  .51814,  .52083,
     2   .52353,  .52624,  .52892,  .53160,  .53427,  .53692,  .53955,
     3   .54217,  .54474,  .54728,  .54979,  .55226,  .55467,  .55702,
     4   .55931,  .56155,  .56371,  .56579,  .56779,  .56971,  .57152,
     5   .57322,  .57481,  .57630,  .57765,  .57887,  .57997,  .58097,
     6   .58177,  .58242,  .58297,  .58343,  .58351,  .58368            
     * /   
          data ( PrSTLA(i,   45), i=  1,   41)/
     1   .50493,  .50757,  .51026,  .51293,  .51563,  .51834,  .52104,
     2   .52375,  .52646,  .52917,  .53184,  .53451,  .53718,  .53982,
     3   .54242,  .54502,  .54755,  .55007,  .55253,  .55495,  .55732,
     4   .55962,  .56186,  .56401,  .56610,  .56809,  .57001,  .57182,
     5   .57354,  .57513,  .57662,  .57798,  .57920,  .58030,  .58129,
     6   .58210,  .58275,  .58330,  .58375,  .58383,  .58404            
     * /   
          data ( PrSTLA(i,   46), i=  1,   41)/
     1   .50505,  .50772,  .51039,  .51309,  .51580,  .51851,  .52123,
     2   .52395,  .52665,  .52936,  .53205,  .53472,  .53738,  .54004,
     3   .54265,  .54523,  .54779,  .55030,  .55277,  .55519,  .55754,
     4   .55986,  .56211,  .56426,  .56636,  .56835,  .57027,  .57210,
     5   .57381,  .57540,  .57688,  .57827,  .57948,  .58058,  .58156,
     6   .58242,  .58307,  .58362,  .58392,  .58416,  .58433            
     * /   
          data ( PrSTLA(i,   47), i=  1,   41)/
     1   .50516,  .50784,  .51053,  .51323,  .51594,  .51866,  .52139,
     2   .52411,  .52681,  .52953,  .53221,  .53490,  .53757,  .54021,
     3   .54282,  .54541,  .54798,  .55049,  .55297,  .55538,  .55777,
     4   .56007,  .56231,  .56449,  .56658,  .56859,  .57050,  .57232,
     5   .57403,  .57563,  .57714,  .57852,  .57976,  .58086,  .58183,
     6   .58262,  .58332,  .58384,  .58424,  .58448,  .58456            
     * /   
          data ( PrSTLA(i,   48), i=  1,   41)/
     1   .50568,  .50840,  .51111,  .51384,  .51657,  .51931,  .52205,
     2   .52479,  .52752,  .53023,  .53296,  .53565,  .53833,  .54099,
     3   .54364,  .54624,  .54881,  .55133,  .55382,  .55627,  .55864,
     4   .56095,  .56322,  .56540,  .56749,  .56951,  .57144,  .57327,
     5   .57499,  .57660,  .57811,  .57949,  .58073,  .58182,  .58280,
     6   .58365,  .58436,  .58491,  .58521,  .58545,  .58557            
     * /   
          data ( PrSTLB(i,   1), i=  1,   41)/
     1   .53545,  .53545,  .53545,  .53545,  .53544,  .53544,  .53542,
     2   .53542,  .53540,  .53537,  .53535,  .53532,  .53529,  .53524,
     3   .53519,  .53514,  .53509,  .53502,  .53495,  .53487,  .53478,
     4   .53469,  .53458,  .53447,  .53436,  .53423,  .53410,  .53395,
     5   .53380,  .53363,  .53346,  .53328,  .53309,  .53288,  .53266,
     6   .53244,  .53220,  .53195,  .53169,  .53142,  .53113            
     * /   
          data ( PrSTLB(i,   2), i=  1,   41)/
     1   .53779,  .53779,  .53779,  .53779,  .53778,  .53778,  .53776,
     2   .53775,  .53773,  .53771,  .53768,  .53765,  .53762,  .53757,
     3   .53751,  .53746,  .53740,  .53733,  .53726,  .53717,  .53708,
     4   .53698,  .53687,  .53675,  .53663,  .53649,  .53635,  .53619,
     5   .53603,  .53585,  .53567,  .53547,  .53527,  .53505,  .53482,
     6   .53458,  .53433,  .53406,  .53379,  .53349,  .53319            
     * /   
          data ( PrSTLB(i,   3), i=  1,   41)/
     1   .54475,  .54474,  .54474,  .54474,  .54473,  .54473,  .54471,
     2   .54469,  .54467,  .54464,  .54461,  .54457,  .54453,  .54448,
     3   .54442,  .54435,  .54428,  .54420,  .54410,  .54401,  .54390,
     4   .54378,  .54365,  .54351,  .54336,  .54320,  .54303,  .54285,
     5   .54265,  .54245,  .54223,  .54200,  .54176,  .54149,  .54123,
     6   .54094,  .54064,  .54032,  .54000,  .53965,  .53929            
     * /   
          data ( PrSTLB(i,   4), i=  1,   41)/
     1   .55610,  .55610,  .55610,  .55610,  .55608,  .55607,  .55605,
     2   .55603,  .55601,  .55597,  .55593,  .55588,  .55583,  .55576,
     3   .55568,  .55560,  .55551,  .55541,  .55529,  .55517,  .55503,
     4   .55488,  .55472,  .55455,  .55436,  .55416,  .55395,  .55372,
     5   .55347,  .55321,  .55294,  .55265,  .55234,  .55202,  .55168,
     6   .55132,  .55095,  .55055,  .55014,  .54971,  .54925            
     * /   
          data ( PrSTLB(i,   5), i=  1,   41)/
     1   .57152,  .57151,  .57151,  .57151,  .57150,  .57149,  .57146,
     2   .57144,  .57140,  .57136,  .57131,  .57124,  .57117,  .57109,
     3   .57099,  .57089,  .57077,  .57063,  .57049,  .57033,  .57016,
     4   .56997,  .56976,  .56954,  .56931,  .56904,  .56877,  .56848,
     5   .56817,  .56784,  .56749,  .56712,  .56673,  .56631,  .56588,
     6   .56542,  .56494,  .56444,  .56391,  .56336,  .56278            
     * /   
          data ( PrSTLB(i,   6), i=  1,   41)/
     1   .59056,  .59056,  .59056,  .59056,  .59053,  .59052,  .59049,
     2   .59046,  .59041,  .59036,  .59029,  .59021,  .59012,  .59001,
     3   .58989,  .58976,  .58960,  .58944,  .58926,  .58905,  .58883,
     4   .58860,  .58833,  .58806,  .58775,  .58743,  .58708,  .58671,
     5   .58631,  .58590,  .58546,  .58498,  .58449,  .58397,  .58341,
     6   .58284,  .58223,  .58159,  .58093,  .58022,  .57949            
     * /   
          data ( PrSTLB(i,   7), i=  1,   41)/
     1   .61269,  .61268,  .61268,  .61268,  .61266,  .61264,  .61260,
     2   .61256,  .61250,  .61243,  .61235,  .61225,  .61214,  .61200,
     3   .61186,  .61169,  .61150,  .61130,  .61107,  .61081,  .61054,
     4   .61024,  .60991,  .60956,  .60919,  .60878,  .60835,  .60789,
     5   .60740,  .60688,  .60633,  .60574,  .60513,  .60447,  .60378,
     6   .60307,  .60231,  .60151,  .60068,  .59982,  .59890            
     * /   
          data ( PrSTLB(i,   8), i=  1,   41)/
     1   .63730,  .63730,  .63730,  .63729,  .63726,  .63724,  .63720,
     2   .63714,  .63707,  .63699,  .63689,  .63677,  .63663,  .63647,
     3   .63629,  .63608,  .63586,  .63561,  .63532,  .63502,  .63468,
     4   .63431,  .63392,  .63349,  .63303,  .63254,  .63201,  .63145,
     5   .63085,  .63022,  .62955,  .62883,  .62808,  .62728,  .62645,
     6   .62557,  .62464,  .62368,  .62267,  .62160,  .62050            
     * /   
          data ( PrSTLB(i,   9), i=  1,   41)/
     1   .66377,  .66376,  .66376,  .66375,  .66372,  .66369,  .66364,
     2   .66357,  .66349,  .66339,  .66327,  .66313,  .66296,  .66277,
     3   .66256,  .66231,  .66204,  .66173,  .66140,  .66103,  .66063,
     4   .66019,  .65972,  .65921,  .65866,  .65807,  .65745,  .65677,
     5   .65606,  .65530,  .65450,  .65365,  .65275,  .65181,  .65081,
     6   .64976,  .64866,  .64750,  .64629,  .64502,  .64370            
     * /   
          data ( PrSTLB(i,   10), i=  1,   41)/
     1   .69143,  .69143,  .69143,  .69141,  .69138,  .69134,  .69129,
     2   .69120,  .69111,  .69099,  .69085,  .69069,  .69049,  .69027,
     3   .69001,  .68973,  .68942,  .68905,  .68867,  .68824,  .68777,
     4   .68725,  .68671,  .68611,  .68547,  .68478,  .68404,  .68326,
     5   .68242,  .68153,  .68059,  .67959,  .67854,  .67743,  .67627,
     6   .67504,  .67375,  .67240,  .67099,  .66951,  .66796            
     * /   
          data ( PrSTLB(i,   11), i=  1,   41)/
     1   .71967,  .71966,  .71966,  .71965,  .71961,  .71957,  .71950,
     2   .71941,  .71930,  .71916,  .71900,  .71882,  .71859,  .71833,
     3   .71804,  .71772,  .71734,  .71694,  .71648,  .71599,  .71545,
     4   .71487,  .71423,  .71355,  .71281,  .71202,  .71117,  .71028,
     5   .70931,  .70829,  .70722,  .70608,  .70486,  .70360,  .70226,
     6   .70085,  .69936,  .69782,  .69620,  .69449,  .69272            
     * /   
          data ( PrSTLB(i,   12), i=  1,   41)/
     1   .74788,  .74787,  .74787,  .74785,  .74781,  .74776,  .74769,
     2   .74759,  .74747,  .74731,  .74713,  .74691,  .74666,  .74637,
     3   .74604,  .74567,  .74526,  .74480,  .74429,  .74373,  .74312,
     4   .74246,  .74174,  .74097,  .74014,  .73924,  .73829,  .73727,
     5   .73619,  .73504,  .73382,  .73253,  .73116,  .72973,  .72822,
     6   .72663,  .72496,  .72321,  .72138,  .71947,  .71747            
     * /   
          data ( PrSTLB(i,   13), i=  1,   41)/
     1   .77553,  .77553,  .77552,  .77550,  .77546,  .77540,  .77532,
     2   .77521,  .77507,  .77490,  .77469,  .77446,  .77417,  .77385,
     3   .77348,  .77307,  .77261,  .77210,  .77153,  .77091,  .77024,
     4   .76950,  .76870,  .76784,  .76692,  .76592,  .76486,  .76373,
     5   .76253,  .76125,  .75989,  .75846,  .75695,  .75535,  .75368,
     6   .75191,  .75006,  .74812,  .74609,  .74397,  .74175            
     * /   
          data ( PrSTLB(i,   14), i=  1,   41)/
     1   .80216,  .80215,  .80214,  .80212,  .80208,  .80201,  .80192,
     2   .80180,  .80165,  .80147,  .80124,  .80098,  .80067,  .80032,
     3   .79991,  .79946,  .79895,  .79839,  .79777,  .79709,  .79634,
     4   .79554,  .79467,  .79372,  .79271,  .79162,  .79046,  .78922,
     5   .78790,  .78650,  .78502,  .78344,  .78179,  .78005,  .77821,
     6   .77628,  .77425,  .77213,  .76991,  .76758,  .76516            
     * /   
          data ( PrSTLB(i,   15), i=  1,   41)/
     1   .82738,  .82737,  .82736,  .82733,  .82729,  .82722,  .82712,
     2   .82699,  .82683,  .82663,  .82638,  .82609,  .82577,  .82539,
     3   .82495,  .82446,  .82391,  .82330,  .82263,  .82189,  .82108,
     4   .82021,  .81926,  .81824,  .81714,  .81596,  .81471,  .81337,
     5   .81194,  .81043,  .80882,  .80713,  .80533,  .80346,  .80147,
     6   .79938,  .79719,  .79490,  .79251,  .79000,  .78738            
     * /   
          data ( PrSTLB(i,   16), i=  1,   41)/
     1   .85090,  .85089,  .85088,  .85085,  .85081,  .85073,  .85063,
     2   .85049,  .85032,  .85009,  .84983,  .84952,  .84917,  .84876,
     3   .84829,  .84777,  .84718,  .84652,  .84581,  .84501,  .84416,
     4   .84322,  .84221,  .84112,  .83994,  .83867,  .83734,  .83590,
     5   .83438,  .83276,  .83105,  .82924,  .82732,  .82531,  .82320,
     6   .82097,  .81864,  .81620,  .81364,  .81096,  .80817            
     * /   
          data ( PrSTLB(i,   17), i=  1,   41)/
     1   .87251,  .87250,  .87249,  .87246,  .87241,  .87233,  .87222,
     2   .87207,  .87189,  .87166,  .87138,  .87105,  .87067,  .87024,
     3   .86974,  .86918,  .86856,  .86786,  .86710,  .86627,  .86535,
     4   .86436,  .86329,  .86213,  .86090,  .85957,  .85814,  .85662,
     5   .85502,  .85331,  .85149,  .84958,  .84757,  .84545,  .84322,
     6   .84087,  .83841,  .83583,  .83314,  .83033,  .82738            
     * /   
          data ( PrSTLB(i,   18), i=  1,   41)/
     1   .89208,  .89208,  .89206,  .89203,  .89198,  .89190,  .89178,
     2   .89162,  .89143,  .89119,  .89089,  .89056,  .89015,  .88969,
     3   .88918,  .88859,  .88794,  .88721,  .88640,  .88553,  .88457,
     4   .88353,  .88241,  .88120,  .87990,  .87851,  .87702,  .87543,
     5   .87374,  .87196,  .87007,  .86807,  .86597,  .86375,  .86143,
     6   .85898,  .85642,  .85373,  .85091,  .84798,  .84492            
     * /   
          data ( PrSTLB(i,   19), i=  1,   41)/
     1   .90957,  .90956,  .90955,  .90952,  .90946,  .90937,  .90925,
     2   .90909,  .90889,  .90864,  .90834,  .90797,  .90756,  .90709,
     3   .90654,  .90592,  .90525,  .90450,  .90366,  .90275,  .90176,
     4   .90068,  .89951,  .89826,  .89691,  .89546,  .89393,  .89229,
     5   .89054,  .88869,  .88674,  .88468,  .88250,  .88021,  .87780,
     6   .87528,  .87263,  .86985,  .86695,  .86393,  .86077            
     * /   
          data ( PrSTLB(i,   20), i=  1,   41)/
     1   .92498,  .92498,  .92496,  .92494,  .92487,  .92478,  .92465,
     2   .92448,  .92428,  .92402,  .92371,  .92334,  .92291,  .92242,
     3   .92185,  .92123,  .92053,  .91975,  .91889,  .91795,  .91694,
     4   .91582,  .91463,  .91333,  .91194,  .91046,  .90888,  .90720,
     5   .90542,  .90352,  .90151,  .89940,  .89718,  .89484,  .89237,
     6   .88979,  .88709,  .88425,  .88130,  .87820,  .87497            
     * /   
          data ( PrSTLB(i,   21), i=  1,   41)/
     1   .93840,  .93839,  .93839,  .93839,  .93838,  .93834,  .93828,
     2   .93819,  .93804,  .93784,  .93756,  .93721,  .93677,  .93623,
     3   .93561,  .93488,  .93407,  .93316,  .93215,  .93106,  .92988,
     4   .92860,  .92723,  .92577,  .92422,  .92258,  .92082,  .91899,
     5   .91706,  .91503,  .91289,  .91065,  .90831,  .90587,  .90330,
     6   .90062,  .89782,  .89492,  .89188,  .88871,  .88542            
     * /   
          data ( PrSTLB(i,   22), i=  1,   41)/
     1   .94992,  .94991,  .94991,  .94991,  .94990,  .94986,  .94980,
     2   .94971,  .94955,  .94935,  .94907,  .94872,  .94826,  .94774,
     3   .94711,  .94640,  .94559,  .94469,  .94371,  .94263,  .94147,
     4   .94020,  .93886,  .93743,  .93591,  .93429,  .93257,  .93077,
     5   .92886,  .92686,  .92476,  .92255,  .92023,  .91781,  .91527,
     6   .91262,  .90985,  .90695,  .90393,  .90078,  .89749            
     * /   
          data ( PrSTLB(i,   23), i=  1,   41)/
     1   .95970,  .95969,  .95969,  .95969,  .95967,  .95963,  .95958,
     2   .95948,  .95932,  .95910,  .95882,  .95845,  .95800,  .95747,
     3   .95685,  .95614,  .95535,  .95447,  .95350,  .95244,  .95130,
     4   .95008,  .94876,  .94736,  .94587,  .94428,  .94262,  .94085,
     5   .93898,  .93702,  .93496,  .93278,  .93051,  .92811,  .92561,
     6   .92300,  .92025,  .91739,  .91440,  .91128,  .90802            
     * /   
          data ( PrSTLB(i,   24), i=  1,   41)/
     1   .96789,  .96788,  .96788,  .96788,  .96787,  .96783,  .96775,
     2   .96765,  .96750,  .96727,  .96698,  .96661,  .96615,  .96561,
     3   .96500,  .96430,  .96351,  .96264,  .96170,  .96067,  .95956,
     4   .95837,  .95709,  .95573,  .95427,  .95275,  .95110,  .94939,
     5   .94758,  .94566,  .94364,  .94152,  .93930,  .93695,  .93450,
     6   .93193,  .92923,  .92642,  .92346,  .92038,  .91715            
     * /   
          data ( PrSTLB(i,   25), i=  1,   41)/
     1   .97468,  .97467,  .97467,  .97467,  .97465,  .97461,  .97454,
     2   .97442,  .97426,  .97403,  .97373,  .97335,  .97290,  .97236,
     3   .97176,  .97106,  .97029,  .96945,  .96854,  .96754,  .96647,
     4   .96532,  .96409,  .96277,  .96137,  .95988,  .95831,  .95665,
     5   .95488,  .95301,  .95106,  .94900,  .94683,  .94454,  .94215,
     6   .93963,  .93699,  .93422,  .93131,  .92828,  .92511            
     * /   
          data ( PrSTLB(i,   26), i=  1,   41)/
     1   .98023,  .98022,  .98022,  .98022,  .98019,  .98016,  .98007,
     2   .97996,  .97978,  .97955,  .97924,  .97887,  .97842,  .97789,
     3   .97729,  .97663,  .97590,  .97508,  .97420,  .97324,  .97222,
     4   .97110,  .96992,  .96866,  .96731,  .96589,  .96436,  .96277,
     5   .96105,  .95926,  .95736,  .95536,  .95325,  .95103,  .94870,
     6   .94623,  .94365,  .94096,  .93812,  .93514,  .93202            
     * /   
          data ( PrSTLB(i,   27), i=  1,   41)/
     1   .98472,  .98471,  .98471,  .98471,  .98468,  .98464,  .98456,
     2   .98444,  .98425,  .98401,  .98370,  .98333,  .98289,  .98239,
     3   .98181,  .98116,  .98046,  .97968,  .97885,  .97794,  .97696,
     4   .97589,  .97477,  .97356,  .97227,  .97091,  .96944,  .96791,
     5   .96626,  .96453,  .96271,  .96078,  .95873,  .95657,  .95431,
     6   .95193,  .94942,  .94677,  .94400,  .94109,  .93803            
     * /   
          data ( PrSTLB(i,   28), i=  1,   41)/
     1   .98831,  .98830,  .98830,  .98830,  .98827,  .98822,  .98814,
     2   .98802,  .98782,  .98758,  .98729,  .98691,  .98648,  .98600,
     3   .98545,  .98484,  .98417,  .98344,  .98264,  .98179,  .98085,
     4   .97985,  .97878,  .97763,  .97641,  .97510,  .97371,  .97223,
     5   .97067,  .96900,  .96724,  .96538,  .96340,  .96133,  .95912,
     6   .95681,  .95437,  .95180,  .94909,  .94625,  .94327            
     * /   
          data ( PrSTLB(i,   29), i=  1,   41)/
     1   .99114,  .99114,  .99114,  .99114,  .99111,  .99106,  .99097,
     2   .99084,  .99066,  .99040,  .99012,  .98976,  .98935,  .98889,
     3   .98838,  .98781,  .98718,  .98649,  .98574,  .98493,  .98405,
     4   .98310,  .98210,  .98100,  .97985,  .97861,  .97727,  .97586,
     5   .97436,  .97277,  .97108,  .96930,  .96739,  .96539,  .96326,
     6   .96102,  .95866,  .95615,  .95353,  .95076,  .94783            
     * /   
          data ( PrSTLB(i,   30), i=  1,   41)/
     1   .99336,  .99335,  .99335,  .99335,  .99332,  .99326,  .99317,
     2   .99303,  .99285,  .99263,  .99234,  .99201,  .99162,  .99120,
     3   .99070,  .99017,  .98959,  .98894,  .98825,  .98748,  .98667,
     4   .98578,  .98483,  .98379,  .98269,  .98152,  .98027,  .97893,
     5   .97750,  .97598,  .97435,  .97263,  .97081,  .96888,  .96684,
     6   .96467,  .96238,  .95996,  .95740,  .95470,  .95186            
     * /   
          data ( PrSTLB(i,   31), i=  1,   41)/
     1   .99507,  .99506,  .99506,  .99506,  .99503,  .99497,  .99488,
     2   .99475,  .99456,  .99435,  .99408,  .99376,  .99342,  .99301,
     3   .99257,  .99207,  .99153,  .99094,  .99027,  .98958,  .98881,
     4   .98798,  .98709,  .98612,  .98508,  .98397,  .98278,  .98151,
     5   .98015,  .97870,  .97714,  .97550,  .97376,  .97190,  .96992,
     6   .96784,  .96563,  .96329,  .96081,  .95818,  .95542            
     * /   
          data ( PrSTLB(i,   32), i=  1,   41)/
     1   .99638,  .99637,  .99637,  .99637,  .99634,  .99628,  .99619,
     2   .99605,  .99588,  .99567,  .99543,  .99514,  .99482,  .99445,
     3   .99404,  .99358,  .99308,  .99254,  .99193,  .99128,  .99055,
     4   .98978,  .98895,  .98804,  .98707,  .98602,  .98490,  .98369,
     5   .98240,  .98102,  .97956,  .97798,  .97630,  .97453,  .97263,
     6   .97062,  .96848,  .96622,  .96383,  .96129,  .95861            
     * /   
          data ( PrSTLB(i,   33), i=  1,   41)/
     1   .99736,  .99736,  .99736,  .99736,  .99733,  .99727,  .99717,
     2   .99705,  .99690,  .99670,  .99648,  .99622,  .99592,  .99558,
     3   .99520,  .99479,  .99434,  .99384,  .99327,  .99267,  .99200,
     4   .99129,  .99051,  .98966,  .98875,  .98776,  .98672,  .98558,
     5   .98435,  .98304,  .98165,  .98016,  .97857,  .97687,  .97504,
     6   .97312,  .97107,  .96890,  .96659,  .96413,  .96154            
     * /   
          data ( PrSTLB(i,   34), i=  1,   41)/
     1   .99810,  .99809,  .99809,  .99809,  .99806,  .99800,  .99791,
     2   .99781,  .99765,  .99749,  .99727,  .99705,  .99677,  .99647,
     3   .99613,  .99575,  .99534,  .99487,  .99437,  .99381,  .99320,
     4   .99253,  .99180,  .99101,  .99016,  .98925,  .98826,  .98718,
     5   .98603,  .98479,  .98347,  .98204,  .98052,  .97891,  .97718,
     6   .97532,  .97336,  .97127,  .96905,  .96669,  .96418            
     * /   
          data ( PrSTLB(i,   35), i=  1,   41)/
     1   .99865,  .99864,  .99864,  .99862,  .99861,  .99855,  .99847,
     2   .99837,  .99823,  .99808,  .99789,  .99768,  .99744,  .99716,
     3   .99686,  .99652,  .99614,  .99572,  .99525,  .99474,  .99418,
     4   .99356,  .99289,  .99216,  .99137,  .99050,  .98957,  .98857,
     5   .98748,  .98631,  .98505,  .98371,  .98227,  .98073,  .97907,
     6   .97730,  .97542,  .97341,  .97128,  .96900,  .96658            
     * /   
          data ( PrSTLB(i,   36), i=  1,   41)/
     1   .99905,  .99904,  .99904,  .99902,  .99901,  .99895,  .99889,
     2   .99878,  .99867,  .99853,  .99837,  .99818,  .99796,  .99771,
     3   .99744,  .99713,  .99678,  .99640,  .99598,  .99550,  .99499,
     4   .99442,  .99380,  .99311,  .99238,  .99157,  .99071,  .98976,
     5   .98874,  .98763,  .98644,  .98518,  .98379,  .98233,  .98075,
     6   .97907,  .97726,  .97534,  .97328,  .97109,  .96876            
     * /   
          data ( PrSTLB(i,   37), i=  1,   41)/
     1   .99933,  .99933,  .99933,  .99931,  .99929,  .99925,  .99917,
     2   .99910,  .99899,  .99887,  .99873,  .99856,  .99837,  .99815,
     3   .99791,  .99762,  .99731,  .99696,  .99657,  .99614,  .99567,
     4   .99513,  .99457,  .99393,  .99325,  .99250,  .99168,  .99079,
     5   .98983,  .98880,  .98767,  .98646,  .98515,  .98375,  .98224,
     6   .98064,  .97891,  .97706,  .97508,  .97298,  .97072            
     * /   
          data ( PrSTLB(i,   38), i=  1,   41)/
     1   .99954,  .99953,  .99953,  .99952,  .99950,  .99945,  .99939,
     2   .99932,  .99924,  .99913,  .99900,  .99886,  .99868,  .99849,
     3   .99827,  .99802,  .99773,  .99741,  .99706,  .99666,  .99622,
     4   .99574,  .99520,  .99462,  .99398,  .99328,  .99252,  .99168,
     5   .99078,  .98979,  .98874,  .98758,  .98634,  .98502,  .98357,
     6   .98203,  .98037,  .97860,  .97669,  .97467,  .97249            
     * /   
          data ( PrSTLB(i,   39), i=  1,   41)/
     1   .99968,  .99968,  .99968,  .99968,  .99965,  .99962,  .99955,
     2   .99949,  .99942,  .99933,  .99920,  .99908,  .99893,  .99876,
     3   .99856,  .99833,  .99808,  .99779,  .99747,  .99710,  .99669,
     4   .99625,  .99576,  .99521,  .99461,  .99396,  .99324,  .99245,
     5   .99159,  .99066,  .98966,  .98858,  .98739,  .98612,  .98475,
     6   .98327,  .98167,  .97996,  .97811,  .97615,  .97403            
     * /   
          data ( PrSTLB(i,   40), i=  1,   41)/
     1   .99979,  .99978,  .99978,  .99978,  .99975,  .99972,  .99967,
     2   .99963,  .99955,  .99947,  .99937,  .99926,  .99912,  .99897,
     3   .99879,  .99859,  .99834,  .99809,  .99780,  .99746,  .99708,
     4   .99667,  .99621,  .99571,  .99514,  .99453,  .99386,  .99311,
     5   .99230,  .99142,  .99047,  .98942,  .98829,  .98707,  .98576,
     6   .98433,  .98279,  .98112,  .97932,  .97740,  .97534            
     * /   
          data ( PrSTLB(i,   41), i=  1,   41)/
     1   .99986,  .99985,  .99985,  .99985,  .99982,  .99980,  .99976,
     2   .99971,  .99965,  .99957,  .99950,  .99939,  .99927,  .99913,
     3   .99898,  .99878,  .99858,  .99834,  .99806,  .99776,  .99741,
     4   .99703,  .99660,  .99613,  .99561,  .99503,  .99439,  .99369,
     5   .99292,  .99208,  .99117,  .99016,  .98908,  .98789,  .98661,
     6   .98523,  .98372,  .98211,  .98035,  .97848,  .97646            
     * /   
          data ( PrSTLB(i,   42), i=  1,   41)/
     1   .99990,  .99990,  .99990,  .99990,  .99988,  .99985,  .99982,
     2   .99977,  .99973,  .99967,  .99959,  .99950,  .99939,  .99927,
     3   .99912,  .99895,  .99875,  .99854,  .99830,  .99801,  .99768,
     4   .99733,  .99692,  .99648,  .99599,  .99544,  .99483,  .99416,
     5   .99343,  .99264,  .99175,  .99077,  .98972,  .98858,  .98733,
     6   .98598,  .98452,  .98293,  .98122,  .97938,  .97738            
     * /   
          data ( PrSTLB(i,   43), i=  1,   41)/
     1   .99994,  .99993,  .99993,  .99993,  .99991,  .99988,  .99987,
     2   .99982,  .99979,  .99973,  .99967,  .99958,  .99949,  .99938,
     3   .99924,  .99909,  .99891,  .99871,  .99848,  .99821,  .99792,
     4   .99758,  .99720,  .99679,  .99631,  .99580,  .99522,  .99457,
     5   .99386,  .99308,  .99222,  .99129,  .99027,  .98914,  .98792,
     6   .98661,  .98516,  .98360,  .98193,  .98011,  .97814            
     * /   
          data ( PrSTLB(i,   44), i=  1,   41)/
     1   .99996,  .99995,  .99995,  .99995,  .99994,  .99992,  .99989,
     2   .99986,  .99983,  .99978,  .99972,  .99965,  .99955,  .99946,
     3   .99934,  .99920,  .99904,  .99885,  .99862,  .99838,  .99811,
     4   .99778,  .99743,  .99702,  .99658,  .99608,  .99551,  .99490,
     5   .99421,  .99345,  .99263,  .99171,  .99071,  .98961,  .98842,
     6   .98710,  .98569,  .98416,  .98248,  .98068,  .97874            
     * /   
          data ( PrSTLB(i,   45), i=  1,   41)/
     1   .99997,  .99997,  .99997,  .99997,  .99995,  .99994,  .99992,
     2   .99989,  .99986,  .99981,  .99977,  .99971,  .99962,  .99952,
     3   .99942,  .99929,  .99914,  .99896,  .99876,  .99853,  .99826,
     4   .99795,  .99762,  .99723,  .99679,  .99632,  .99577,  .99516,
     5   .99450,  .99376,  .99295,  .99205,  .99106,  .98997,  .98880,
     6   .98750,  .98610,  .98457,  .98292,  .98114,  .97920            
     * /   
          data ( PrSTLB(i,   46), i=  1,   41)/
     1   .99998,  .99998,  .99998,  .99998,  .99996,  .99996,  .99995,
     2   .99991,  .99988,  .99985,  .99979,  .99975,  .99967,  .99958,
     3   .99949,  .99937,  .99923,  .99906,  .99886,  .99865,  .99839,
     4   .99810,  .99776,  .99740,  .99697,  .99650,  .99596,  .99538,
     5   .99473,  .99399,  .99319,  .99230,  .99132,  .99026,  .98908,
     6   .98780,  .98641,  .98490,  .98325,  .98147,  .97954            
     * /   
          data ( PrSTLB(i,   47), i=  1,   41)/
     1   .99999,  .99998,  .99998,  .99998,  .99998,  .99997,  .99995,
     2   .99994,  .99991,  .99987,  .99983,  .99977,  .99971,  .99963,
     3   .99954,  .99942,  .99930,  .99913,  .99894,  .99873,  .99849,
     4   .99821,  .99789,  .99753,  .99711,  .99666,  .99612,  .99554,
     5   .99490,  .99418,  .99337,  .99251,  .99153,  .99046,  .98930,
     6   .98803,  .98665,  .98514,  .98350,  .98172,  .97981            
     * /   
          data ( PrSTLB(i,   48), i=  1,   41)/
     1   .99999,  .99999,  .99999,  .99999,  .99999,  .99999,  .99999,
     2   .99997,  .99996,  .99994,  .99992,  .99988,  .99983,  .99977,
     3   .99970,  .99960,  .99950,  .99936,  .99919,  .99901,  .99878,
     4   .99852,  .99822,  .99788,  .99748,  .99704,  .99654,  .99597,
     5   .99533,  .99463,  .99385,  .99298,  .99202,  .99098,  .98982,
     6   .98857,  .98718,  .98569,  .98407,  .98230,  .98039            
     * /   

      end
     

