      subroutine   csibyllXsAAir(IA, Epj, xs)
!       AAir cross-section by sibyll
      implicit none
      integer,intent(in):: IA ! projectile Mass # (2~56)
      real(8),intent(in):: Epj ! projectile total E (GeV)

      real(8),intent(out)::xs  ! x-section in mb for Air
!      since signuc_ini is not practical, we copy
!      data there  and compute xs each time without
!      making table 

!      NE=6 is log10 roots (/n) bins step 10^DA = 10.

!       56 is proj. mass # from 1 to 56.
      integer,parameter:: NE=6
      real(8):: SIGMA(NE,56), SIGQE(NE,56)
      real(8),parameter::AA(NE)=(/1.d0,2.d0,3.d0,4.d0,5.d0,6.d0/)
      real(8),parameter:: AMIN=1.d0, DA=1.d0

!      DATA AVOG /6.0221367E-04/
!      DATA ATARGET /14.514/               ! effective masss of air
!...Data on `inelastic-production' nucleus-air cross section
      integer:: J
!     
!     data of v2.1    
!!      DATA (SIGMA(J, 2),J=1,6) /  392., 434., 507., 617., 739., 866./
!!      DATA (SIGMA(J, 3),J=1,6) /  459., 501., 579., 691., 819., 943./
!!      DATA (SIGMA(J, 4),J=1,6) /  493., 532., 608., 721., 853., 975./
!!      DATA (SIGMA(J, 5),J=1,6) /  589., 632., 716., 839., 986.,1122./
!!      DATA (SIGMA(J, 6),J=1,6) /  695., 746., 838., 974.,1125.,1275./
!!      DATA (SIGMA(J, 7),J=1,6) /  710., 759., 857., 986.,1141.,1292./
!!      DATA (SIGMA(J, 8),J=1,6) /  751., 808., 902.,1039.,1192.,1344./
!!      DATA (SIGMA(J, 9),J=1,6) /  794., 847., 944.,1082.,1241.,1395./
!!      DATA (SIGMA(J,10),J=1,6) /  808., 857., 958.,1095.,1248.,1411./
!!      DATA (SIGMA(J,11),J=1,6) /  808., 858., 958.,1094.,1255.,1409./
!!      DATA (SIGMA(J,12),J=1,6) /  856., 909.,1001.,1144.,1306.,1462./
!!      DATA (SIGMA(J,13),J=1,6) /  868., 916.,1016.,1166.,1324.,1486./
!!      DATA (SIGMA(J,14),J=1,6) /  913., 961.,1063.,1214.,1386.,1543./
!!      DATA (SIGMA(J,15),J=1,6) /  937., 995.,1101.,1240.,1411.,1573./
!!      DATA (SIGMA(J,16),J=1,6) /  998.,1037.,1157.,1304.,1474.,1644./
!!      DATA (SIGMA(J,17),J=1,6) /  991.,1044.,1154.,1310.,1472.,1647./
!!      DATA (SIGMA(J,18),J=1,6) / 1041.,1101.,1208.,1359.,1544.,1718./
!!      DATA (SIGMA(J,19),J=1,6) / 1094.,1151.,1255.,1431.,1614.,1785./
!!      DATA (SIGMA(J,20),J=1,6) / 1141.,1193.,1314.,1485.,1667.,1842./
!!      DATA (SIGMA(J,21),J=1,6) / 1165.,1222.,1341.,1498.,1694.,1880./
!!      DATA (SIGMA(J,22),J=1,6) / 1159.,1219.,1333.,1506.,1687.,1863./
!!      DATA (SIGMA(J,23),J=1,6) / 1211.,1265.,1381.,1553.,1738.,1918./
!!      DATA (SIGMA(J,24),J=1,6) / 1221.,1285.,1402.,1571.,1757.,1947./
!!      DATA (SIGMA(J,25),J=1,6) / 1245.,1314.,1429.,1595.,1792.,1993./
!!      DATA (SIGMA(J,26),J=1,6) / 1270.,1334.,1447.,1624.,1811.,2005./
!!      DATA (SIGMA(J,27),J=1,6) / 1251.,1314.,1431.,1603.,1790.,1984./
!!      DATA (SIGMA(J,28),J=1,6) / 1289.,1351.,1465.,1654.,1839.,2029./
!!      DATA (SIGMA(J,29),J=1,6) / 1412.,1482.,1617.,1796.,2003.,2204./
!!      DATA (SIGMA(J,30),J=1,6) / 1351.,1409.,1526.,1711.,1895.,2105./
!!      DATA (SIGMA(J,31),J=1,6) / 1361.,1422.,1548.,1734.,1932.,2132./
!!      DATA (SIGMA(J,32),J=1,6) / 1381.,1435.,1574.,1751.,1952.,2140./
!!      DATA (SIGMA(J,33),J=1,6) / 1400.,1466.,1593.,1767.,1971.,2173./
!!      DATA (SIGMA(J,34),J=1,6) / 1414.,1479.,1606.,1796.,1985.,2193./
!!      DATA (SIGMA(J,35),J=1,6) / 1425.,1503.,1621.,1800.,2008.,2203./
!!      DATA (SIGMA(J,36),J=1,6) / 1444.,1516.,1643.,1822.,2031.,2225./
!!      DATA (SIGMA(J,37),J=1,6) / 1460.,1529.,1655.,1844.,2042.,2246./
!!      DATA (SIGMA(J,38),J=1,6) / 1484.,1547.,1676.,1861.,2071.,2269./
!!      DATA (SIGMA(J,39),J=1,6) / 1494.,1557.,1700.,1886.,2085.,2291./
!!      DATA (SIGMA(J,40),J=1,6) / 1510.,1585.,1710.,1897.,2116.,2292./
!!      DATA (SIGMA(J,41),J=1,6) / 1532.,1594.,1724.,1922.,2116.,2317./
!!      DATA (SIGMA(J,42),J=1,6) / 1540.,1617.,1735.,1930.,2144.,2334./
!!      DATA (SIGMA(J,43),J=1,6) / 1559.,1627.,1764.,1944.,2158.,2363./
!!      DATA (SIGMA(J,44),J=1,6) / 1570.,1641.,1774.,1949.,2172.,2367./
!!      DATA (SIGMA(J,45),J=1,6) / 1587.,1651.,1784.,1983.,2187.,2396./
!!      DATA (SIGMA(J,46),J=1,6) / 1609.,1675.,1810.,1997.,2206.,2412./
!!      DATA (SIGMA(J,47),J=1,6) / 1611.,1688.,1814.,2011.,2236.,2436./
!!      DATA (SIGMA(J,48),J=1,6) / 1630.,1700.,1833.,2024.,2240.,2457./
!!      DATA (SIGMA(J,49),J=1,6) / 1645.,1717.,1843.,2047.,2251.,2474./
!!      DATA (SIGMA(J,50),J=1,6) / 1655.,1729.,1858.,2051.,2272.,2488./
!!      DATA (SIGMA(J,51),J=1,6) / 1668.,1742.,1875.,2076.,2288.,2504./
!!      DATA (SIGMA(J,52),J=1,6) / 1684.,1757.,1891.,2091.,2308.,2515./
!!      DATA (SIGMA(J,53),J=1,6) / 1697.,1773.,1908.,2103.,2328.,2544./
!!      DATA (SIGMA(J,54),J=1,6) / 1713.,1785.,1917.,2125.,2335.,2533./
!!      DATA (SIGMA(J,55),J=1,6) / 1726.,1803.,1939.,2131.,2355.,2570./
!     !      DATA (SIGMA(J,56),J=1,6) / 1757.,1831.,1970.,2168.,2388.,2620./
!         data of v2.3c      
      DATA (SIGMA(J, 2),J=1,6) /
     &3.842D+02,4.287D+02,4.940D+02,5.887D+02,6.922D+02,7.767D+02/
      DATA (SIGMA(J, 3),J=1,6) /
     &4.601D+02,5.149D+02,5.595D+02,6.663D+02,7.641D+02,8.446D+02/
      DATA (SIGMA(J, 4),J=1,6) /
     &4.881D+02,5.373D+02,6.005D+02,6.895D+02,7.716D+02,8.967D+02/
      DATA (SIGMA(J, 5),J=1,6) /
     &5.874D+02,6.176D+02,7.181D+02,7.993D+02,9.089D+02,1.031D+03/
      DATA (SIGMA(J, 6),J=1,6) /
     &7.054D+02,7.399D+02,8.388D+02,9.463D+02,1.080D+03,1.197D+03/
      DATA (SIGMA(J, 7),J=1,6) /
     &7.192D+02,7.611D+02,8.449D+02,9.539D+02,1.061D+03,1.176D+03/
      DATA (SIGMA(J, 8),J=1,6) /
     &7.550D+02,7.975D+02,9.153D+02,9.944D+02,1.126D+03,1.236D+03/
      DATA (SIGMA(J, 9),J=1,6) /
     &7.929D+02,8.392D+02,9.265D+02,1.059D+03,1.167D+03,1.262D+03/
      DATA (SIGMA(J, 10),J=1,6) /
     &8.157D+02,8.644D+02,9.512D+02,1.058D+03,1.182D+03,1.298D+03/
      DATA (SIGMA(J, 11),J=1,6) /
     &8.039D+02,8.587D+02,9.534D+02,1.055D+03,1.182D+03,1.298D+03/
      DATA (SIGMA(J, 12),J=1,6) /
     &8.515D+02,8.957D+02,9.869D+02,1.122D+03,1.253D+03,1.366D+03/
      DATA (SIGMA(J, 13),J=1,6) /
     &8.769D+02,9.100D+02,1.018D+03,1.119D+03,1.252D+03,1.341D+03/
      DATA (SIGMA(J, 14),J=1,6) /
     &9.058D+02,9.532D+02,1.057D+03,1.171D+03,1.302D+03,1.391D+03/
      DATA (SIGMA(J, 15),J=1,6) /
     &9.555D+02,9.799D+02,1.098D+03,1.201D+03,1.342D+03,1.444D+03/
      DATA (SIGMA(J, 16),J=1,6) /
     &1.009D+03,1.058D+03,1.149D+03,1.290D+03,1.414D+03,1.520D+03/
      DATA (SIGMA(J, 17),J=1,6) /
     &9.907D+02,1.045D+03,1.166D+03,1.290D+03,1.384D+03,1.516D+03/
      DATA (SIGMA(J, 18),J=1,6) /
     &1.036D+03,1.121D+03,1.198D+03,1.328D+03,1.470D+03,1.592D+03/
      DATA (SIGMA(J, 19),J=1,6) /
     &1.083D+03,1.162D+03,1.250D+03,1.371D+03,1.516D+03,1.661D+03/
      DATA (SIGMA(J, 20),J=1,6) /
     &1.146D+03,1.215D+03,1.295D+03,1.443D+03,1.544D+03,1.744D+03/
      DATA (SIGMA(J, 21),J=1,6) /
     &1.158D+03,1.234D+03,1.292D+03,1.467D+03,1.618D+03,1.750D+03/
      DATA (SIGMA(J, 22),J=1,6) /
     &1.153D+03,1.205D+03,1.329D+03,1.451D+03,1.596D+03,1.734D+03/
      DATA (SIGMA(J, 23),J=1,6) /
     &1.210D+03,1.274D+03,1.356D+03,1.493D+03,1.655D+03,1.803D+03/
      DATA (SIGMA(J, 24),J=1,6) /
     &1.212D+03,1.273D+03,1.398D+03,1.489D+03,1.641D+03,1.800D+03/
      DATA (SIGMA(J, 25),J=1,6) /
     &1.236D+03,1.315D+03,1.423D+03,1.561D+03,1.669D+03,1.855D+03/
      DATA (SIGMA(J, 26),J=1,6) /
     &1.279D+03,1.345D+03,1.431D+03,1.595D+03,1.734D+03,1.889D+03/
      DATA (SIGMA(J, 27),J=1,6) /
     &1.228D+03,1.304D+03,1.438D+03,1.546D+03,1.714D+03,1.836D+03/
      DATA (SIGMA(J, 28),J=1,6) /
     &1.289D+03,1.370D+03,1.451D+03,1.597D+03,1.754D+03,1.913D+03/
      DATA (SIGMA(J, 29),J=1,6) /
     &1.411D+03,1.469D+03,1.613D+03,1.777D+03,1.910D+03,2.075D+03/
      DATA (SIGMA(J, 30),J=1,6) /
     &1.347D+03,1.401D+03,1.498D+03,1.642D+03,1.816D+03,1.975D+03/
      DATA (SIGMA(J, 31),J=1,6) /
     &1.359D+03,1.448D+03,1.551D+03,1.694D+03,1.858D+03,2.007D+03/
      DATA (SIGMA(J, 32),J=1,6) /
     &1.358D+03,1.460D+03,1.559D+03,1.698D+03,1.842D+03,1.974D+03/
      DATA (SIGMA(J, 33),J=1,6) /
     &1.418D+03,1.448D+03,1.578D+03,1.727D+03,1.872D+03,2.047D+03/
      DATA (SIGMA(J, 34),J=1,6) /
     &1.433D+03,1.466D+03,1.605D+03,1.738D+03,1.892D+03,2.019D+03/
      DATA (SIGMA(J, 35),J=1,6) /
     &1.430D+03,1.511D+03,1.602D+03,1.752D+03,1.935D+03,2.060D+03/
      DATA (SIGMA(J, 36),J=1,6) /
     &1.462D+03,1.499D+03,1.653D+03,1.805D+03,1.920D+03,2.057D+03/
      DATA (SIGMA(J, 37),J=1,6) /
     &1.470D+03,1.520D+03,1.656D+03,1.818D+03,1.946D+03,2.131D+03/
      DATA (SIGMA(J, 38),J=1,6) /
     &1.470D+03,1.542D+03,1.691D+03,1.800D+03,1.968D+03,2.133D+03/
      DATA (SIGMA(J, 39),J=1,6) /
     &1.495D+03,1.588D+03,1.676D+03,1.834D+03,1.969D+03,2.163D+03/
      DATA (SIGMA(J, 40),J=1,6) /
     &1.525D+03,1.551D+03,1.722D+03,1.833D+03,2.020D+03,2.192D+03/
      DATA (SIGMA(J, 41),J=1,6) /
     &1.526D+03,1.615D+03,1.709D+03,1.899D+03,2.040D+03,2.181D+03/
      DATA (SIGMA(J, 42),J=1,6) /
     &1.510D+03,1.567D+03,1.716D+03,1.892D+03,2.056D+03,2.197D+03/
      DATA (SIGMA(J, 43),J=1,6) /
     &1.557D+03,1.658D+03,1.776D+03,1.898D+03,2.092D+03,2.200D+03/
      DATA (SIGMA(J, 44),J=1,6) /
     &1.556D+03,1.645D+03,1.752D+03,1.920D+03,2.091D+03,2.243D+03/
      DATA (SIGMA(J, 45),J=1,6) /
     &1.583D+03,1.663D+03,1.798D+03,1.940D+03,2.051D+03,2.263D+03/
      DATA (SIGMA(J, 46),J=1,6) /
     &1.599D+03,1.642D+03,1.799D+03,1.941D+03,2.107D+03,2.268D+03/
      DATA (SIGMA(J, 47),J=1,6) /
     &1.611D+03,1.692D+03,1.811D+03,1.956D+03,2.107D+03,2.264D+03/
      DATA (SIGMA(J, 48),J=1,6) /
     &1.625D+03,1.706D+03,1.819D+03,1.986D+03,2.139D+03,2.354D+03/
      DATA (SIGMA(J, 49),J=1,6) /
     &1.666D+03,1.737D+03,1.854D+03,1.971D+03,2.160D+03,2.318D+03/
      DATA (SIGMA(J, 50),J=1,6) /
     &1.648D+03,1.747D+03,1.856D+03,2.023D+03,2.181D+03,2.352D+03/
      DATA (SIGMA(J, 51),J=1,6) /
     &1.653D+03,1.763D+03,1.868D+03,2.015D+03,2.203D+03,2.386D+03/
      DATA (SIGMA(J, 52),J=1,6) /
     &1.690D+03,1.720D+03,1.902D+03,2.027D+03,2.189D+03,2.357D+03/
      DATA (SIGMA(J, 53),J=1,6) /
     &1.690D+03,1.750D+03,1.921D+03,2.059D+03,2.208D+03,2.417D+03/
      DATA (SIGMA(J, 54),J=1,6) /
     &1.705D+03,1.781D+03,1.911D+03,2.073D+03,2.242D+03,2.411D+03/
      DATA (SIGMA(J, 55),J=1,6) /
     &1.714D+03,1.806D+03,1.896D+03,2.100D+03,2.253D+03,2.411D+03/
      DATA (SIGMA(J, 56),J=1,6) /
     &1.774D+03,1.813D+03,1.954D+03,2.098D+03,2.280D+03,2.482D+03/
      
!...Data on `quasi-elastic' nucleus-air cross section
!!      DATA (SIGQE(J, 2),J=1,6) /   41.,  39.,  54.,  99., 159., 229./
!!      DATA (SIGQE(J, 3),J=1,6) /   43.,  40.,  55., 101., 167., 238./
!!      DATA (SIGQE(J, 4),J=1,6) /   40.,  40.,  55., 102., 168., 243./
!!      DATA (SIGQE(J, 5),J=1,6) /   45.,  44.,  61., 113., 179., 262./
!!      DATA (SIGQE(J, 6),J=1,6) /   52.,  49.,  67., 121., 195., 278./
!!      DATA (SIGQE(J, 7),J=1,6) /   50.,  48.,  69., 121., 194., 276./
!!      DATA (SIGQE(J, 8),J=1,6) /   52.,  50.,  70., 125., 199., 282./
!!      DATA (SIGQE(J, 9),J=1,6) /   54.,  50.,  69., 126., 206., 289./
!!      DATA (SIGQE(J,10),J=1,6) /   53.,  50.,  70., 127., 204., 288./
!!      DATA (SIGQE(J,11),J=1,6) /   51.,  50.,  69., 125., 203., 285./
!!      DATA (SIGQE(J,12),J=1,6) /   52.,  51.,  70., 127., 210., 293./
!!      DATA (SIGQE(J,13),J=1,6) /   53.,  50.,  71., 129., 210., 293./
!!      DATA (SIGQE(J,14),J=1,6) /   52.,  53.,  72., 134., 212., 301./
!!      DATA (SIGQE(J,15),J=1,6) /   54.,  52.,  75., 135., 219., 306./
!!      DATA (SIGQE(J,16),J=1,6) /   57.,  56.,  76., 136., 222., 313./
!!      DATA (SIGQE(J,17),J=1,6) /   55.,  54.,  76., 137., 221., 311./
!!      DATA (SIGQE(J,18),J=1,6) /   59.,  55.,  79., 142., 223., 320./
!!      DATA (SIGQE(J,19),J=1,6) /   63.,  58.,  81., 143., 231., 323./
!!      DATA (SIGQE(J,20),J=1,6) /   63.,  60.,  82., 149., 237., 332./
!!      DATA (SIGQE(J,21),J=1,6) /   64.,  61.,  84., 150., 236., 333./
!!      DATA (SIGQE(J,22),J=1,6) /   62.,  61.,  84., 145., 237., 329./
!!      DATA (SIGQE(J,23),J=1,6) /   65.,  62.,  83., 149., 240., 341./
!!      DATA (SIGQE(J,24),J=1,6) /   64.,  61.,  84., 152., 244., 338./
!!      DATA (SIGQE(J,25),J=1,6) /   64.,  61.,  86., 153., 249., 343./
!!      DATA (SIGQE(J,26),J=1,6) /   66.,  64.,  88., 156., 251., 344./
!!      DATA (SIGQE(J,27),J=1,6) /   65.,  61.,  84., 155., 244., 345./
!!      DATA (SIGQE(J,28),J=1,6) /   65.,  63.,  87., 153., 249., 347./
!!      DATA (SIGQE(J,29),J=1,6) /   72.,  64.,  91., 161., 260., 362./
!!      DATA (SIGQE(J,30),J=1,6) /   67.,  63.,  90., 157., 252., 355./
!!      DATA (SIGQE(J,31),J=1,6) /   67.,  66.,  90., 161., 256., 353./
!!      DATA (SIGQE(J,32),J=1,6) /   68.,  65.,  89., 161., 256., 355./
!!      DATA (SIGQE(J,33),J=1,6) /   69.,  66.,  89., 161., 257., 360./
!!      DATA (SIGQE(J,34),J=1,6) /   69.,  63.,  89., 160., 262., 359./
!!      DATA (SIGQE(J,35),J=1,6) /   68.,  65.,  90., 166., 259., 360./
!!      DATA (SIGQE(J,36),J=1,6) /   68.,  66.,  92., 167., 257., 362./
!!      DATA (SIGQE(J,37),J=1,6) /   71.,  67.,  92., 166., 261., 365./
!!      DATA (SIGQE(J,38),J=1,6) /   70.,  67.,  92., 167., 265., 367./
!!      DATA (SIGQE(J,39),J=1,6) /   69.,  68.,  96., 163., 261., 370./
!!      DATA (SIGQE(J,40),J=1,6) /   71.,  67.,  92., 167., 266., 371./
!!      DATA (SIGQE(J,41),J=1,6) /   72.,  68.,  93., 167., 267., 373./
!!      DATA (SIGQE(J,42),J=1,6) /   71.,  69.,  96., 167., 271., 370./
!!      DATA (SIGQE(J,43),J=1,6) /   72.,  70.,  95., 168., 265., 369./
!!      DATA (SIGQE(J,44),J=1,6) /   70.,  68.,  98., 170., 270., 372./
!!      DATA (SIGQE(J,45),J=1,6) /   72.,  69.,  97., 167., 272., 379./
!!      DATA (SIGQE(J,46),J=1,6) /   75.,  69.,  98., 173., 272., 370./
!!      DATA (SIGQE(J,47),J=1,6) /   73.,  70.,  93., 170., 275., 377./
!!      DATA (SIGQE(J,48),J=1,6) /   73.,  71.,  96., 170., 275., 379./
!!      DATA (SIGQE(J,49),J=1,6) /   75.,  72.,  96., 171., 275., 379./
!!      DATA (SIGQE(J,50),J=1,6) /   74.,  73.,  97., 174., 275., 380./
!!      DATA (SIGQE(J,51),J=1,6) /   73.,  68.,  97., 173., 281., 388./
!!      DATA (SIGQE(J,52),J=1,6) /   75.,  71.,  99., 175., 275., 390./
!!      DATA (SIGQE(J,53),J=1,6) /   75.,  71.,  98., 180., 279., 383./
!!      DATA (SIGQE(J,54),J=1,6) /   74.,  71.,  99., 177., 280., 386./
!!      DATA (SIGQE(J,55),J=1,6) /   75.,  71., 100., 179., 278., 394./
!!      DATA (SIGQE(J,56),J=1,6) /   76.,  70., 101., 175., 284., 390./
!        v2.3v
      DATA (SIGQE(J, 2),J=1,6) /
     &4.141D+01,3.708D+01,5.428D+01,8.696D+01,1.403D+02,1.885D+02/
      DATA (SIGQE(J, 3),J=1,6) /
     &4.357D+01,3.894D+01,5.177D+01,9.675D+01,1.447D+02,2.029D+02/
      DATA (SIGQE(J, 4),J=1,6) /
     &4.123D+01,3.933D+01,6.070D+01,9.482D+01,1.474D+02,2.023D+02/
      DATA (SIGQE(J, 5),J=1,6) /
     &4.681D+01,4.287D+01,6.381D+01,1.050D+02,1.519D+02,2.198D+02/
      DATA (SIGQE(J, 6),J=1,6) /
     &5.407D+01,5.195D+01,6.723D+01,1.108D+02,1.750D+02,2.368D+02/
      DATA (SIGQE(J, 7),J=1,6) /
     &4.975D+01,4.936D+01,6.880D+01,1.162D+02,1.689D+02,2.329D+02/
      DATA (SIGQE(J, 8),J=1,6) /
     &5.361D+01,5.027D+01,6.858D+01,1.177D+02,1.759D+02,2.412D+02/
      DATA (SIGQE(J, 9),J=1,6) /
     &4.980D+01,5.063D+01,7.210D+01,1.196D+02,1.806D+02,2.299D+02/
      DATA (SIGQE(J, 10),J=1,6) /
     &5.170D+01,5.070D+01,7.105D+01,1.182D+02,1.679D+02,2.411D+02/
      DATA (SIGQE(J, 11),J=1,6) /
     &4.950D+01,4.950D+01,7.286D+01,1.137D+02,1.769D+02,2.477D+02/
      DATA (SIGQE(J, 12),J=1,6) /
     &5.262D+01,5.133D+01,7.110D+01,1.204D+02,1.789D+02,2.501D+02/
      DATA (SIGQE(J, 13),J=1,6) /
     &5.320D+01,5.378D+01,6.847D+01,1.200D+02,1.805D+02,2.442D+02/
      DATA (SIGQE(J, 14),J=1,6) /
     &5.638D+01,5.271D+01,6.985D+01,1.209D+02,1.867D+02,2.610D+02/
      DATA (SIGQE(J, 15),J=1,6) /
     &5.294D+01,5.353D+01,7.435D+01,1.211D+02,1.899D+02,2.612D+02/
      DATA (SIGQE(J, 16),J=1,6) /
     &5.668D+01,5.254D+01,7.557D+01,1.269D+02,1.917D+02,2.707D+02/
      DATA (SIGQE(J, 17),J=1,6) /
     &5.456D+01,5.721D+01,7.481D+01,1.208D+02,1.859D+02,2.658D+02/
      DATA (SIGQE(J, 18),J=1,6) /
     &5.901D+01,5.382D+01,7.591D+01,1.246D+02,1.872D+02,2.874D+02/
      DATA (SIGQE(J, 19),J=1,6) /
     &6.328D+01,6.116D+01,8.451D+01,1.318D+02,2.088D+02,2.749D+02/
      DATA (SIGQE(J, 20),J=1,6) /
     &5.779D+01,5.924D+01,8.382D+01,1.370D+02,2.062D+02,2.837D+02/
      DATA (SIGQE(J, 21),J=1,6) /
     &7.155D+01,5.732D+01,8.231D+01,1.363D+02,2.047D+02,2.820D+02/
      DATA (SIGQE(J, 22),J=1,6) /
     &6.699D+01,5.651D+01,8.511D+01,1.477D+02,2.031D+02,2.921D+02/
      DATA (SIGQE(J, 23),J=1,6) /
     &6.179D+01,6.269D+01,9.395D+01,1.437D+02,2.195D+02,2.964D+02/
      DATA (SIGQE(J, 24),J=1,6) /
     &6.784D+01,6.028D+01,8.622D+01,1.279D+02,2.214D+02,2.867D+02/
      DATA (SIGQE(J, 25),J=1,6) /
     &6.589D+01,5.795D+01,8.890D+01,1.385D+02,2.055D+02,2.988D+02/
      DATA (SIGQE(J, 26),J=1,6) /
     &6.364D+01,6.325D+01,8.942D+01,1.421D+02,2.128D+02,3.083D+02/
      DATA (SIGQE(J, 27),J=1,6) /
     &6.449D+01,6.664D+01,8.986D+01,1.453D+02,2.140D+02,2.932D+02/
      DATA (SIGQE(J, 28),J=1,6) /
     &7.284D+01,6.139D+01,8.867D+01,1.425D+02,2.179D+02,2.978D+02/
      DATA (SIGQE(J, 29),J=1,6) /
     &7.221D+01,7.085D+01,9.079D+01,1.482D+02,2.277D+02,2.913D+02/
      DATA (SIGQE(J, 30),J=1,6) /
     &6.928D+01,6.294D+01,8.935D+01,1.463D+02,2.265D+02,2.834D+02/
      DATA (SIGQE(J, 31),J=1,6) /
     &6.611D+01,6.586D+01,9.133D+01,1.461D+02,2.201D+02,2.959D+02/
      DATA (SIGQE(J, 32),J=1,6) /
     &6.401D+01,6.177D+01,8.971D+01,1.480D+02,2.155D+02,3.152D+02/
      DATA (SIGQE(J, 33),J=1,6) /
     &7.057D+01,6.918D+01,8.410D+01,1.465D+02,2.288D+02,3.088D+02/
      DATA (SIGQE(J, 34),J=1,6) /
     &6.453D+01,7.020D+01,9.272D+01,1.517D+02,2.189D+02,2.999D+02/
      DATA (SIGQE(J, 35),J=1,6) /
     &6.741D+01,6.295D+01,9.323D+01,1.536D+02,2.190D+02,2.930D+02/
      DATA (SIGQE(J, 36),J=1,6) /
     &6.807D+01,7.046D+01,1.025D+02,1.565D+02,2.315D+02,3.090D+02/
      DATA (SIGQE(J, 37),J=1,6) /
     &8.082D+01,6.565D+01,9.160D+01,1.572D+02,2.229D+02,3.125D+02/
      DATA (SIGQE(J, 38),J=1,6) /
     &6.494D+01,6.964D+01,9.089D+01,1.653D+02,2.336D+02,3.120D+02/
      DATA (SIGQE(J, 39),J=1,6) /
     &6.833D+01,6.860D+01,8.933D+01,1.601D+02,2.261D+02,3.167D+02/
      DATA (SIGQE(J, 40),J=1,6) /
     &7.021D+01,6.866D+01,8.437D+01,1.588D+02,2.249D+02,2.941D+02/
      DATA (SIGQE(J, 41),J=1,6) /
     &7.122D+01,6.205D+01,9.545D+01,1.582D+02,2.335D+02,3.395D+02/
      DATA (SIGQE(J, 42),J=1,6) /
     &7.265D+01,6.936D+01,9.486D+01,1.505D+02,2.379D+02,3.248D+02/
      DATA (SIGQE(J, 43),J=1,6) /
     &7.048D+01,7.539D+01,9.192D+01,1.566D+02,2.532D+02,3.182D+02/
      DATA (SIGQE(J, 44),J=1,6) /
     &6.650D+01,7.139D+01,9.862D+01,1.602D+02,2.289D+02,3.077D+02/
      DATA (SIGQE(J, 45),J=1,6) /
     &7.511D+01,6.893D+01,9.245D+01,1.641D+02,2.519D+02,3.381D+02/
      DATA (SIGQE(J, 46),J=1,6) /
     &6.437D+01,6.894D+01,8.697D+01,1.544D+02,2.391D+02,3.213D+02/
      DATA (SIGQE(J, 47),J=1,6) /
     &7.980D+01,6.958D+01,1.022D+02,1.609D+02,2.408D+02,3.246D+02/
      DATA (SIGQE(J, 48),J=1,6) /
     &7.265D+01,7.313D+01,8.989D+01,1.578D+02,2.387D+02,3.235D+02/
      DATA (SIGQE(J, 49),J=1,6) /
     &6.959D+01,6.337D+01,9.084D+01,1.656D+02,2.331D+02,3.226D+02/
      DATA (SIGQE(J, 50),J=1,6) /
     &7.371D+01,6.807D+01,9.726D+01,1.535D+02,2.445D+02,3.189D+02/
      DATA (SIGQE(J, 51),J=1,6) /
     &7.882D+01,6.680D+01,9.377D+01,1.629D+02,2.448D+02,3.297D+02/
      DATA (SIGQE(J, 52),J=1,6) /
     &7.223D+01,6.794D+01,9.925D+01,1.738D+02,2.446D+02,3.162D+02/
      DATA (SIGQE(J, 53),J=1,6) /
     &7.703D+01,6.971D+01,9.601D+01,1.595D+02,2.484D+02,3.265D+02/
      DATA (SIGQE(J, 54),J=1,6) /
     &7.549D+01,7.459D+01,8.984D+01,1.645D+02,2.348D+02,3.201D+02/
      DATA (SIGQE(J, 55),J=1,6) /
     &7.891D+01,6.840D+01,1.017D+02,1.698D+02,2.501D+02,3.429D+02/
      DATA (SIGQE(J, 56),J=1,6) /
     &7.545D+01,6.673D+01,1.057D+02,1.684D+02,2.424D+02,3.181D+02/

!     ASQS = 0.5*LOG10(1.876E+03*E0)
      real(8):: ASQS,  E0, S1, S2 
      integer:: JE, JA
      external QUAD_INT
      real(8):: QUAD_INT

      E0 = Epj/IA
!       s = (E0+M)^2-p0^2 ~ 2 E0 M ~ 1.876E0
!    log10(root(s)) is 
      ASQS = 0.5*LOG10(1.876*E0)  ! E0 in GeV/n
!      max ASQS=6 so max E0 ~ 10^12/1.876 GeV  =6* 10^20 eV
!

      JE = MIN(INT((ASQS-AMIN)/DA)+1,NE-2)
      JA = IA
      S1 = QUAD_INT(ASQS, AA(JE),AA(JE+1),AA(JE+2),
     +     SIGMA(JE,JA),SIGMA(JE+1,JA),SIGMA(JE+2,JA))
      S2 = QUAD_INT(ASQS, AA(JE),AA(JE+1),AA(JE+2),
     +     SIGQE(JE,JA),SIGQE(JE+1,JA),SIGQE(JE+2,JA))
      xs  = S1 + S2
      end  subroutine csibyllXsAAir
