!  Usage:  compile by make -f cgetXs.mk
!      verbose mode:  (may be target is simple)
!      ./a.out > result
!      file input mode:(may be target is complex)
!                  prepare a file like
!          4            /  1-> proton 2->pion 3->K  4->A
!          56 26        /  if 4, give A,Z of projectile else omit this line
!          14.0, 16.0, 40.0 /     A's for target. "/" is mandatory
!          78.1, 20.95, 0.94 /    portion of A's "/" is mandatory
!       and
!      ./a.out < thefile > result
!   **NOTE*** verbose mode and file input mode may be
!        used independently of the complexity of the target.
!
      module modgetXs
      implicit none
      integer,parameter::maxel=15   ! max # of elements
      integer::nel  !  actual @ of elements
!      real(8):: A(maxel)
      integer:: A(maxel)
      real(8):: portion(maxel)
      integer,save:: pjk
!      integer,parameter:: nel=3   ! # of elements
!      real(8):: A(nel)=(/14.0, 16.0, 40.0/)   ! mass # (integer value is used)
!      real(8):: portion(nel)=(/78.1, 20.95, 0.94/)    ! relative # of A's in unit volume

      real(8),parameter:: dE=0.1d0   ! 0.05 log 10 step
      integer,parameter:: nebin=100  ! # of  Energy bins (from  10^11 eV to 10^21 eV) log10
!                                     ! step 0.1
      real(8),parameter:: E1= 100.    ! from 100GeV

      contains
      subroutine computeXS(pj, xsa)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: pj  !  projectile . E is fixed here
      real(8),intent(out):: xsa(nebin)


      type(ptcl):: tg  !
      integer:: i, j
      real(8):: E, sum, xs 
      integer TA
      E = E1
      do i = 1, nebin
         pj.fm.p(4) = E
         sum = 0.
         do  j = 1, nel
            if( A(j) == 1 ) then
               call cmkptc(knuc, -1, 1, tg)
            elseif( A(j) == 0 ) then  ! air
               call cmkptc(kgnuc, A(j), max(A(j)/2,1), tg)
               tg.subcode = 0
               tg.charge = 7
            else
!                      charge is not used so rough
               call cmkptc(kgnuc, A(j), max(A(j)/2,1), tg)
            endif
            call cgetXsInterface(pj, tg, xs)
            sum = sum + xs*portion(j)
         enddo
         xsa(i) =  sum
         E = E*10.0d0**dE
      enddo
      end   subroutine computeXS
      end       module modgetXs


      program main
      use   modgetXs
      use   modsibyllXs
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: pj

      integer:: i, j
      real(8):: xs( nebin)
      real(8):: E, temp
      integer:: nela(1)
      integer:: pjA, pjZ, kpj
      
      write(0,*) 'Enter projectile '
      write(0,*) ' p->1; pi->2; K->3; A->4; 0->stop'
      read(*,*)  kpj

      if( kpj >= 1 .and. kpj <= 4) then
         if(kpj ==  4) then
            write(0,*) ' Enter proj. A, Z (intger)'
            read(*,*)  pjA, pjZ
         endif
      elseif( kpj == 0) then
         stop
      else
         write(0,*) ' input=',kpj, ' invalid'
         stop
      endif
      write(0,*)
     * "Enter target A ( or A's for compound/mixture target) with",
     * "  / at last (<=15)"
      write(0,*) 
     *  ' 0/ will be Air (sibyll special)'
      A(:) = 0.
      read(*,*) A(:)
      nela = minloc(A(:))
      nel = nela(1) -1
      if( nel == 0 ) then
         nel = 1
      endif
      if( nel == 1 ) then
         portion(nel) = 1.
      else
         write(0,*) "Enter relative portion of A's"
         read(*,*) portion(1:nel)
      endif

      temp = sum(portion(1:nel))
      portion(:) = portion(:)/temp

      call cgetXsIni
      ! make proton
      if( kpj == 1 ) then
         call cmkptc(knuc, -1, 1, pj)
      elseif( kpj == 2 ) then
         call cmkptc(kpion, -1, 1, pj)
      elseif( kpj == 3 ) then
         call cmkptc(kkaon, -1, 1, pj)
      elseif( kpj == 4) then
         call cmkptc(kgnuc, pjA, pjZ, pj)
      else
         stop 'strage '
      endif

      call computeXS(pj, xs)
!         output
      E= E1
      write(*,'(a,i2,i4,i3)') '# pj=',pj.code, pj.subcode, pj.charge
      write(*,'(a, 15(i4,f6.3))') '# tg=',(A(i), portion(i), i=1,nel)
      write(*,'(a, l)') '# Sibyll XS was used=',sibyllXsUsed
      do i = 1, nebin
         write(*,'(1p, 4g13.4 )')  E, xs(i)
         E = E*10.d0** dE
      enddo
      
      end program main

