      module modsibyllXs
      logical,save:: sibyllXsUsed
      end      module modsibyllXs
      subroutine csibyllXs(pj, tg, xs)
!  sibyll can compute  xs for
!      p-p, pi-p, K-p
!      p-Air, pi-Air, K-Air, A-Air (A=2~56)
!      for other  targets, we employ cosmsos standard
!  However, it seems possilbe to generate hadronic 
!   collision events for targets A'=2~??(56?)
!    projectile of n, nba, pbar, Kch (Kl, Ks) are also allowed
!
      use modsibyllXs
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega,
     6  masds, masXic, masXic0, masomC0, mastau, masetap,
     7  masDelta
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=770.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
       parameter(
     1  masds = 1.968, masXic = 2.468, masXic0 = 2.471,
     2      masomC0 = 2.695,  mastau= 1.777,
     3      masetap =957.8e-3, masDelta=1.232
     4		 )
!        masddb and masnnb are the minimum value.

      type(ptcl):: pj  !input projectile particle
      type(ptcl):: tg  ! //   target particle.
                        ! if subcode  is 0, Air is assumed 
                        ! in sibyll
      real(8),intent(out)::xs  ! obtained x-section in mb
      
      integer::TA, PA, L
      real(4):: roots, sxs
      real(8)::At, Zt 
      real(4):: SQS,SIGT,SIGEL,SIGINEL,SIGDIF,SLOPE,RHO
      logical ok
      logical waround
      integer,save:: waroundn=0
      integer:: IA

      L = 0   ! p,pi,K code; not given yet 
      PA = 0  ! projectile is A; not given yet
      ok = .false.  ! sibyll could  give xs; not yet 
      waround =.false.
      
      if( pj%code == knuc) then 
         L = 1
      elseif( pj%code == kpion  ) then
         L = 2
      elseif( pj%code == kkaon ) then
         L = 3
      elseif( pj%code == kgnuc .and. pj%subcode <=56 ) then
         PA = pj%subcode
      else
         if( pj%code == keta  .or.  pj%code == ksigma .or.
     *        pj%code == klambda ) then
         else
            if( waroundn < 10 ) then
               write(0,*)
     *       '********* projectile is N.G for XS calc.in Sibyll2.3c:'
               write(0,*) '********* pj%code, subcode, charge=',
     *              pj%code, pj%subcode, pj%charge
               write(0,*) '********* E=',pj%fm%p(4)
               write(0,*) '********* some workaround is taken'
               waroundn = waroundn + 1
            endif
         endif
         waround = .true.
      endif
      if(.not. waround) then
         if( tg%code ==9 .and. tg%subcode == 0 ) then ! air target               
            if( PA > 0 ) then
               call  csibyllXsAAir(PA, pj%fm%p(4), xs)
               ok = .true.
            else                !  p,pi,K- air xsec.
!           s = ( Epj + massT )**2 - Ppj**2
               roots =
     *              sqrt(2*masp*pj%fm%p(4) + masp**2 + pj%mass**2)
               call SIB_SIGMA_HAIR (L, roots, sxs)
               xs = sxs
               ok = .true.
            endif
         elseif( tg%code == knuc .and. tg%charge == 1 ) then
                   ! target p
            if( L > 0 ) then    !  p,pi,K-p xsec. 
               SQS =
     *              sqrt(2*masp*pj%fm%p(4) + masp**2 + pj%mass**2)
               call SIB_SIGMA_HP(
     *              L,SQS,SIGT,SIGEL,SIGINEL,SIGDIF,SLOPE,RHO)
               xs = SIGINEL
               ok = .true.
            else
!             not ok. see later
            endif
         elseif( tg%code == kgnuc ) then
            if( L > 0 ) then
!                no practical routine for hadron -A
!                cross-section.  see later
            else
!                 not ok. see later
            endif
         else
            write(0,*) ' target error in csibyllXs'
            write(0,*) ' tg code, sub, chge=',tg%code,
     *              tg%subcode, tg%charge            
         endif
      endif
      
      if( .not. ok ) then
         if( tg%subcode == 0 ) then
            At = 14.45
         elseif(tg%code /= kgnuc ) then
            At = 1.
         else
            At = tg%subcode 
         endif
         Zt = tg%charge ! not important
         call cinelx(pj, At, Zt, xs)
      endif

      sibyllXsUsed = ok
      end  subroutine csibyllXs


