      subroutine csibyllinit
      implicit none
!
      COMMON /S_CLDIF/ LDIFF
      INTEGER          LDIFF
      COMMON /S_CSYDEC/IDB(49), CBR(102), KDEC(612), LBARP(49)
      REAL             CBR
      INTEGER          IDB,KDEC,LBARP
      integer  KODFRAG                  
      COMMON /CKFRAG/ KODFRAG                  

      INTEGER NCALL, NDEBUG, LUN
      COMMON /S_DEBUG/ NCALL, NDEBUG, LUN

      

      KODFRAG =0  ! complex fragmentation by Abrasion-ablation model
      LDIFF = 0       ! mix diff and non-diff

      LUN = 0         ! logical dev. # for (error) message  from sibyll
! sibyll default is 7.
      call SIBYLL_INI
      call SIGMA_INI   ! p-/pi-/K-Air  sigma and mfp
                   ! 
      call NUC_NUC_INI  ! A-A' xsec.  init.  seems false.
            ! NUC_NUC_INI calls sigma_ini agian; is it ok?
!      call INI_WRITE(0) !!!!! print pAir xsec.
!        don't let mu, pi, K decay;
!           for AA' col.
!       call SIGNUC_INI(...) !  this is almost useless
!                    so we make cgetAAXsSib for each
!     AA' col.
      IDB(4:12) = -IDB(4:12)

!            short life particle decay is managed by us
!
!       same for eta
      IDB(23)  = -IDB(23)
!       same for  SIGMA, XI, LAMBDA
!      do  i = 34, 39
      IDB(34:36) = -IDB(34:36)
      IDB(39) = -IDB(39)
      
!     decay control: can force not to decay for
!        some of short life ptcls s
!!!      call csibSetStblPtcl
      end
!     ****************
      subroutine  csibyllevent(pj, ia, iz, a, ntp)
      use modXsecMedia
      implicit none

!        Zmanager.h
         
         integer SeedSave(2) ! to store initial seed of random number 
                            ! for each event.  got at cevenLoop.f
        logical RefreshIR   ! becomes t if InitRN(1) < 0 && Job != 'flesh'
                            ! each event IR is read from #14
                            ! the file must be opened by the user routine
        character*80 PrefixConf ! Epics config file directory
        character*80 TopDir ! $COSMOSTOP
        character*6  CosOrEpi ! cosmos or epics; from of cintModels is set.
        integer  TopDirLeng ! length of TopDir 
        integer  PrefixLeng ! lenght of PrefixConf
         common /Zmanager/ SeedSave, RefreshIR, TopDirLeng, PrefixLeng
        common /Zmanagerc/ TopDir, PrefixConf, CosOrEpi




!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega,
     6  masds, masXic, masXic0, masomC0, mastau, masetap,
     7  masDelta
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=770.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
       parameter(
     1  masds = 1.968, masXic = 2.468, masXic0 = 2.471,
     2      masomC0 = 2.695,  mastau= 1.777,
     3      masetap =957.8e-3, masDelta=1.232
     4		 )
!        masddb and masnnb are the minimum value.

!
      type(ptcl):: pj  ! input projectile particle
      integer,intent(in):: ia, iz  ! target A,Z (Z will not be
                  ! used)
      type(ptcl):: a(*)
      integer,intent(out)::ntp  ! # of ptcls produced in a.

      integer k, i, L
      integer::  icp, iat
      integer::  j
      real*8::  E0, Ecm, g, beta, Eg
      integer::icon

      real  sqs
!            not used
!      type(ptcl)::pjcms, tgcms, tgrest
!      data tgrest%fm%p(1:4)/0.d0,0.d0,0.d0,masp/
!      data tgrest.mass/masp/
!      type(ptcl)::Cmsp
!      type(ptcl)::pjpnlab  ! proj. /n in lab 
!      data pjpnlab%fm%p(1:2)/0.d0, 0.d0/


!       call csibyllIniEvent   ! no need at presnt
      call ccoscode2sibyll(pj, icp) ! get sibyll code of pj
      iat =  ia                 !  target mass number
!!        we don't use A=0 for Sibyll Air medium 
!!!      if( CosOrEpi /= 'gencol') then
!!         if( media(mediumNo)%name == "Air") then
!!            iat = 0
!!         endif
!!      endif   
      if(pj%code .eq. kgnuc) then
         E0 = pj%fm%p(4)/pj%subcode !  GeV/n in Lab
         Ecm = sqrt( ( E0 +masp )*2*masp ) ! nn system
      else
!         if( pj%code == klambda ) then   ! upto v8.02
!            icp = 14            ! n
!         endif
         E0 = pj%fm%p(4)
         Ecm = sqrt( E0*2*masp + pj%mass**2 + masp**2)
      endif

      sqs = Ecm
      g = (E0 + masp)/Ecm  ! cms gamma factor  !=sqs/2/mp for pi/K
      beta = sqrt( (g-1.d0) * (g + 1.d0)) /g
      if( pj%code /= kgnuc ) then
         call SIBYLL(icp, iat, sqs)  ! event generator
              ! icp = 7,8, 9,10, 11,12, 13,14, -13,-14       
              !   pi+-,K+-,  KL,KS, p,n,  pbar,nbar
              !  The output is contained in COMMON /S_PLIST/
              ! iat= 0--> Air . sqs = root(s) in GeV for pj-nucleon system.
         call DECSIB            !  all unfamilier ptcls should decay
      else
         call SIBNUC( icp, iat, sqs)  !A-A' col. icp  sqs is n-n system.
                            ! icp=A, iat= A', iat= 0 is for Air
      endif

      if( pj%code /= kgnuc ) then
         call csibhA2coscode(g, beta, a, ntp)
      else
         call csibAA2coscode(g, beta, a, ntp)
      endif
      call crot3mom(pj, a, ntp)
      end

      subroutine csibyllIniEvent
!        at present nothing to do 
      implicit none
      integer:: NP, LLIST
      real::   P
      COMMON /S_PLIST/ NP, P(8000,5), LLIST(8000)
      REAL             PA
      INTEGER          LLA,NPA
      COMMON /S_PLNUC/ NPA, PA(5,40000), LLA(40000)


      end      subroutine csibyllIniEvent


      subroutine csibhA2coscode(g, beta, a, ntp)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega,
     6  masds, masXic, masXic0, masomC0, mastau, masetap,
     7  masDelta
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=770.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
       parameter(
     1  masds = 1.968, masXic = 2.468, masXic0 = 2.471,
     2      masomC0 = 2.695,  mastau= 1.777,
     3      masetap =957.8e-3, masDelta=1.232
     4		 )
!        masddb and masnnb are the minimum value.

!
      real(8),intent(in):: g  ! cms g factor
      real(8),intent(in):: beta  ! its beta 
      type(ptcl)::a(*)  ! output patlcs
      integer,intent(out):: ntp  ! # of ptcls put in a

      integer:: NP, LLIST
      real::   P
      COMMON /S_PLIST/ NP, P(8000,5), LLIST(8000)

      integer:: j, L
      
      ntp = 0
      do  j = 1, NP
         if(abs(LLIST(j)) .lt. 10000) then
            ntp = ntp + 1   
            a(ntp)%fm%p(1:2)=P(j, 1:2)
            a(ntp)%fm%p(3) = g* (P(j,3) +
     *              beta*P(j,4))
            a(ntp)%fm%p(4) = g* (P(j,4) +
     *              beta*P(j,3))
            L = mod(LLIST(j), 10000)
!            L = LLIST(j)
            call csibyllcode2cos(L, a(ntp))
         endif
      enddo
      end      subroutine csibhA2coscode
      subroutine csibAA2coscode(g, beta, a, ntp)
      implicit none

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega,
     6  masds, masXic, masXic0, masomC0, mastau, masetap,
     7  masDelta
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=770.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
       parameter(
     1  masds = 1.968, masXic = 2.468, masXic0 = 2.471,
     2      masomC0 = 2.695,  mastau= 1.777,
     3      masetap =957.8e-3, masDelta=1.232
     4		 )
!        masddb and masnnb are the minimum value.

!     
      real(8),intent(in):: g  ! cms gamma factor
      real(8),intent(in):: beta ! its beta
      type(ptcl)::a(*)  ! output. ptcls stored here
      integer,intent(out):: ntp  ! # of ptlcs in a

      REAL             PA
      INTEGER          LLA,NPA
      COMMON /S_PLNUC/ NPA, PA(5,40000), LLA(40000)

      integer:: L
      integer:: j
      
      ntp = 0
      do  j = 1, NPA
         if(abs(LLA(j)) .lt. 10000) then
            ntp = ntp + 1   
            a(ntp)%fm%p(1:2)=PA(1:2,j)
            a(ntp)%fm%p(3) = g* (PA(3,j) + beta*PA(4,j))
            a(ntp)%fm%p(4) = g* (PA(4,j) + beta*PA(3,j))
            L = mod(LLA(j), 10000)
            call csibyllcode2cos(L, a(ntp))
         endif
      enddo
      end      subroutine csibAA2coscode

       real  function  S_RNDM(X)
       integer  X  !  not used
       real*8 u
       call rndc(u)
       S_RNDM = u
       end
       subroutine ccoscode2sibyll(pj, ksib)
       implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

      type(ptcl):: pj
      integer ksib
!
!      projectiel 7,8,  9,10, 11,12, 13,14, -13,-14
!                 pi+-,  K+-,  KL,KS, p,n,  pbar,nbar
      
      if( pj%code .eq. knuc ) then
         if( pj%charge .eq. 1) then
            ksib = 13
         elseif(pj%charge .eq. -1) then
            ksib = -13
         elseif( pj%charge .eq. 0) then
            if( pj%subcode .eq. antip ) then
               ksib = -14
            else
               ksib = 14
            endif
         endif
      elseif( pj%code .eq. kpion ) then
         if( pj%charge .eq. 1 ) then
            ksib = 7
         elseif( pj%charge .eq. -1 ) then
            ksib = 8
         else
            ksib = 6
         endif
      elseif( pj%code .eq. kkaon ) then
!   9 K+    10 K-  11  K0L   12 K0s
         if( pj%charge .eq. 1 ) then
            ksib= 9
         elseif( pj%charge .eq. -1 ) then
            ksib = 10
         elseif( pj%subcode .eq. k0s ) then
            ksib = 12
         else
            ksib = 11
         endif
      elseif( pj%code == kgnuc) then
         ksib = pj%subcode   ! if 0, assumed to be  Air
      elseif( pj%code == klambda) then
         ksib = 39
      else
         write(0,*) 
     *    ' code =',pj%code, ' not acceptable in sibyll'
         stop 12345
      endif
      end
      subroutine csibyllcode2cos(ksibin, pj)
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!            klast; max ptcl codes in the system.  (except krare)
      integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1   kneue, kneumu,  knnb, kddb, kdmes, krho,
     2   komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3   kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4   ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5   kdeuteron,  kds, kXic, komeC0,  ktau, kneutau, ketap,
     6   kDelta, 
     7   kseethru
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron,
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync
  !
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. '
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22, knnb=23, kddb=24, krho=25,komega=26, kphi=27,
     7  keta=28,
     9  khvymax=kiron, kdeuteron=29,
     a  kds=30, kXic=31, komeC0=32,  ktau=33, kneutau=34,
     b  ketap=35, kDelta=36, 
     c  krare = 0, 
     d  klight=-1, kEdepo=-2, KchgPath=-3, kseethru=-4,
     e  klast=36+4 ) ! 

!       kindmx=kbomega  not used now

        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!             for heavy next are not used. ( to give
!             isotope, iso Z,A	may be used 				     
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                They are neglected in Cosmos. 

      integer,intent(in):: ksibin  ! sibyll code
      type(ptcl):: pj    !   output cos code is put here
!
      real*8 u 
      integer ksib, code, subcode, charge

      ksib = abs(ksibin)
      subcode = regptcl
      if(ksib .eq. 1) then
         code = kphoton
         charge = 0
      elseif(ksib .eq. 2) then
         code = kelec
         charge = 1
      elseif(ksib .eq. 3) then
         code = kelec
         charge = -1
      elseif(ksib .eq. 4) then
         code = kmuon
         charge = 1
      elseif(ksib .eq. 5) then
         code = kmuon
         charge = -1
      elseif(ksib .eq. 6) then
         code = kpion
         charge = 0
      elseif(ksib .eq. 7) then
         code = kpion
         charge = 1
      elseif(ksib .eq. 8) then
         code = kpion
         charge = -1
      elseif(ksib .eq. 9) then
         code = kkaon
         charge = 1
      elseif(ksib .eq. 10) then
         code = kkaon
         charge = -1
      elseif(ksib .eq. 11) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif(ksib .eq. 12) then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif(ksib .eq. 13) then
         code = knuc
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 14) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(ksib .eq. 15) then
         code = kneue
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 16) then
         code = kneue
         subcode = antip
         charge = 0
      elseif(ksib .eq. 17) then
         code = kneumu
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 18) then
         code = kneumu
         charge = 0
         subcode = antip
      elseif(ksib .eq. 19) then
         code = knuc
         charge = -1
         subcode = antip
      elseif(ksib .eq. 20) then
         code = knuc
         charge = 0
         subcode = antip
      elseif(ksib .eq. 21) then
         code = kkaon
         call rndc(u)
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 22) then
         code = kkaon
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 23) then
         code = keta
         charge = 0
      elseif(ksib .eq. 25) then
         code = krho
         charge = 1
      elseif(ksib .eq. 26) then
         code = krho
         charge = -1
      elseif(ksib .eq. 27) then
         code = krho
         charge = 0
      elseif(ksib .eq. 32) then
         code = komega
         charge = 0
         subcode = regptcl
      elseif(ksib .eq. 33) then
         code = kphi
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 34) then
         code = ksigma
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 35) then
         code = ksigma
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 36) then
         code = ksigma
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 37) then
         code = kgzai
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 38) then
         code = kgzai
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 39) then
         code = klambda
         subcode = regptcl
         charge = 0
      elseif( ksib > 1000) then
         subcode = ksib- 1000
         if( subcode > 1 ) then
            code = kgnuc
            charge = subcode/2.15 +0.7 ! some plausible Z
         else
            code  = knuc
            call rndc(u)
            if(u < 0.6) then
               charge = 0
            else
               charge = 1
            endif
            subcode = -1
         endif
      else
         write(0,*) ' ****************sibyllcode=',ksib, ksibin
         code = krare
         charge = 0
         subcode = regptcl
      endif
      if(ksibin .lt. 0) then
         subcode = antip
         charge = - charge
      endif
      call cmkptc(code, subcode, charge, pj)
      end
      subroutine csibylGetDiffCode(nwout, difcode)
      implicit none
!    in case of nuclei for each interaction]. The meaning is
!.       JDIF(JW)  = diffraction code    !!!! changed to field !!!!
!.                  (0 : non-diffractive interaction) 
!.                  (1 : forward diffraction)     
!.                  (2 : backward diffraction) 
!.                  (3 : double diffraction)  
      integer,intent(out):: nwout !
      !   NSD is 0 or 3
      integer,intent(out):: difcode(20)
!          for p/n projectile,nw =1, difcode(1) shows the                      
!          diffraction state.                                                  
      integer NW_max, NS_max, NH_max, NJ_max
      PARAMETER (NW_max = 20)
      PARAMETER (NS_max = 20, NH_max = 50)
      PARAMETER (NJ_max = (NS_max+NH_max)*NW_max)
      real(4):: X1J, X2J, X1JSUM, X2JSUM, PTJET, PHIJET
      integer:: NNPJET, NNPSTR, NNSOF, NNJET, JDIF, NW, NJET, NSOF

      COMMON /S_CHIST/ X1J(NJ_max),X2J(NJ_max),
     &    X1JSUM(NW_max),X2JSUM(NW_max),PTJET(NJ_max),PHIJET(NJ_max),
     &    NNPJET(NJ_max),NNPSTR(2*NW_max),NNSOF(NW_max),NNJET(NW_max),
     &    JDIF(NW_max),NW,NJET,NSOF

      nwout = NW
      difcode(1:nwout)=JDIF(1:nwout)
      end


