
	program MAIN
	 external jamsigda
	 external jamss1da
         external jams2da
         external jamdata
         external pjdata
         external hidata

	call mydummy
	call main2
	end
	subroutine main2
!***********************************************************************
!...Include file of JAM
!***********************************************************************

!...Double precision.
      implicit double precision(a-h, o-z)

!...Maximum number of all particles.
!     parameter(mxv=800)   ! AGS Au+Au
!     parameter(mxv=2000)
      parameter(mxv=30000)
!     parameter(mxv=100000)

!...The event record.
      common/jamevnt1/r(5,mxv),p(5,mxv),v(5,mxv),k(11,mxv)
      common/jamevnt2/nv,nbary,nmeson
      save /jamevnt1/,/jamevnt2/

!...Parton properites or decay orientation.
      common/jamjet1/vq(10,mxv),kq(2,mxv)
      save /jamjet1/

!...Deuteron coalesence.
      common/jamevnt3/weid(mxv)
      save /jamevnt3/

!...Save two-body collisision information.
      common/jamsave1/rcp(5,6),pcp(5,6),vcp(5,6),kcp(11,6)
      common/jamsave2/vqcp(10,6),kqcp(2,6)
      save /jamsave1/,/jamsave2/

!...Max. collision number in each time step.
      parameter (mxcoll=500000)
!     parameter (mxcoll=50000)

!...Collision matrix.
      common/jamcol/coll(6,mxcoll),icoll(3,mxcoll),mentry
      save /jamcol/

!...Box by maru  cell.
      common/jamcell/rcell(3,27)
      save /jamcell/

!=======================================================================

!======================================================================c
!...Switches and parameters of JAM
      common/jamdat1/mstc(200),parc(200),mstd(200),pard(200)
      common/jamdat2/mste(50),pare(50)
      save /jamdat1/,/jamdat2/

!...Output file names and message.
      common/jamdat3/fname(8)
      character fname*80
      save /jamdat3/
      common/jamerdat/check(10)
      character check*120
      save /jamerdat/

!...PYTHIA Commonblocks.
      common/jydat1/mstu(200),paru(200),mstj(200),parj(200)
      common/jydat2/kchg(500,7),pmas(500,4),parf(2000),vckm(4,4)
      common/jydat3/mdcy(500,3),mdme(4000,3),brat(4000),kfdp(4000,5)
      common/jydat4/chaf(500,2)
      character chaf*16
      save /jydat1/,/jydat2/,/jydat3/,/jydat4/

!...Elementary particles.
      common/partdat3/id_quark,id_lept,id_exc,id_boson,id_diq
     $       ,id_tec,id_susy,id_special
!...Mesons.
      common/partdat2/id_pi,id_light1,id_light0
     $    ,id_str,id_charm,id_bott,id_cc,id_bb,id_mdiff
!...Baryons.
      common/partdat1/id_nucl,id_nucls,id_delt,id_delts
     $     ,id_lamb,id_lambs,id_sigm,id_sigms,id_xi,id_xis,id_omega
     $    ,id_charmb,id_bottb,id_bdiff
      save /partdat1/,/partdat2/,/partdat3/

!======================================================================c




	character frame*8, proj*8, targ*8, cwin*15
        real*8 u

c
c	call vbook1(1,'dum', 10,0.d0, 1.d0)
c	fname(1)='jam.cfg'
c     
        call rndc(u)
        fname(1) = '0'
        fname(2) = '/dev/null'
        fname(3) = '/dev/null'
	mevent = 2
	bmin = 0.
c            for pp collison. bmax is not used.?
c            for AA bmax=0 make loop
	bmax = -2.3d0
	dt = 100.d0
	nstep =1
	cwin = '100.0gev'
	frame = 'lab'
c	proj = 'K+'
	proj = 'p'
        mstc(81)=0  ! neglect hard scattering (for meson)
c	targ = '32S'
	targ = '14:7'
c	targ = 'p'
c	targ = 'n'
c	targ = 'p'
c	targ='197Au   '
c	targ = '4:2'
c	targ = '2:1'
c        bmax=-7.50D0        ! maximum impact parameter (1530mb)Au  

	mstc(8) = 0  ! job mode
	mstc(156) = 0  ! no call to jamanacl
        mstc(161) = 0  ! no output on JAMINFO.DAT, JAMRUN.DAT
        mstc(39) = 0   ! no ouptut on JAMMULTI.DAT

        write(0,*)' jaminit' 
    	 call jaminit(mevent, bmin, bmax, dt, nstep, frame, proj, targ,
     *  cwin)
c	 write(0,*) ' getting cross sec'
c	 call getxs
        write(0,*)' event geneation'
	do iev=1, mevent
	   call jamevt(iev)
	   write(*,*) ' nv= ',nv
c	   do i=1, nv
	   do i=1, nv
	      if( k(1,i) .le. 11 .or. k(1,i) .ge. 0  ) then
		 write(*,*) i,k(2,i), p(1,i), p(2,i), p(3,i),
     *             p(4,i), p(5,i)
	      endif
	   enddo

c	   call jamlist(1)
	enddo
c	call jamfin
	end
	subroutine getxs
      implicit none
!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence




                  real*8 p(4)

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

	 external jamsigda
	 external jamss1da
         external jams2da
         external jamdata
         external pjdata
         external hidata

      integer:: msel, icltyp, kf1, kf2, mchanel, mabsrb, ijet, icon
      real(8)::srt, pr, em1, em2, sig, sigel, sigin(30)
      record /ptcl/tg, pj
      real(8):: Eklab, s, prsq
      integer code, subc, charge, ia, iz

      msel = 1

      write(0,*) 'Enter: projectile code, charg '
      read(*,*)  code,  charge
      subc = -1
      call cmkptc(code, subc, charge, pj)
      subc = pj.subcode
      call ccos2kf(code, subc, charge, kf1)
      em1 = pj.mass


      if(code == 6) then
         icltyp = 1    ! pp pn,
      else
         icltyp = 2    ! pip, pin, kp, kn
      endif

      write(0,*) 'Enter: target code, charge (p or n)'
      read(*,*)  code,  charge
      call cmkptc(code, subc, charge, tg)
      subc = tg.subcode
      call ccos2kf(code, subc, charge, kf2)
      em2 =  tg.mass
      ia = 1
      iz = tg.charge
c      call cjamini(pj, ia, iz)
      Eklab=0.5
      do while (Eklab < 10000.) 
         s = em1**2 + em2**2 + 2*em2*(Eklab + em1)
         prsq= (s-(em1+em2)**2)*(s-(em1-em2)**2)/(4*s) 
         pr = sqrt(prsq)
         srt = sqrt(s)
         call jamcross(msel,icltyp,srt,pr,kf1,kf2,em1,em2,
     $       sig,sigel,sigin,mchanel,mabsrb,ijet,icon)
         write(*,*) Eklab, sig, sigel, icon
         Eklab = Eklab * 10.**0.1
      enddo
      end

