#!/bin/bash
if [ $# -ne 2 ]; then
   cat <<EOF
   ./gethist dir  nev
   a file   $dir/data is assumed to contain $nev event data
   e.g,   dir: /tmp/dpm/pp10GeV
          nev: 1e5
   output will be made in $dir
   data format:
      h  ....  (header; diff code etc)
#      1    2    3  4   5  6   7   8    9     10
      code subc chg pt  y  eta  KE  Pz XfKE   XfPz
      ...
      ...
      h  ... header  
EOF
   exit
fi
   
dir=$1
nev=$2
file=$dir/data
#  Pz > 0
#  Pi+
awk '$1==4 && $3==1 && $8 > 0 {print $9}' $file | histo 0.1 0.01 $nev > $dir/pi+.hist
#  X<0.1
awk '$1==4 && $3==1 && $8 > 0 && $9<0.1 {print $9}' $file | histo -l  0.001 0.05 $nev > $dir/pi+log.hist

echo 'unset log x' > /tmp/gnuplot.com
echo 'set log y' >> /tmp/gnuplot.com
echo 'set xr[0:1]' >> /tmp/gnuplot.com
echo 'unset key' >> /tmp/gnuplot.com

echo "plot \"/tmp/${fileid}pi+.hist\" w his lw 3" >> /tmp/gnuplot.com
echo "set output \"/tmp/${fileid}pi+.png\"" >> /tmp/gnuplot.com
echo 'set term png nocrop medium size  288,216'  >> /tmp/gnuplot.com
echo ' rep '  >>/tmp/gnuplot.com

gnuplot /tmp/gnuplot.com

exit


awk '$1==4 && $3==0 && $10 > 0 {print $9}' /tmp/$file | histo 0.1 0.02 $nev > /tmp/${fileid}pi0.hist
awk '$1==4 && $3==0 && $10 > 0 && $9<0.1 {print $9}' /tmp/$file | histo -l  0.01 0.05 $nev > /tmp/${fileid}pi0log.hist

awk '$1==4 && $3==-1 && $10 > 0 {print $9}' /tmp/$file | histo 0.1 0.02 $nev > /tmp/${fileid}pi-.hist
awk '$1==4 && $3==-1 && $10 > 0 && $9<0.1 {print $9}' /tmp/$file | histo -l  0.01 0.05 $nev > /tmp/${fileid}pi-log.hist

awk '$1==5 && $3!=0 && $10 > 0 {print $9}' /tmp/$file | histo 0.1 0.02 $nev > /tmp/${fileid}Kch.hist
awk '$1==5 && $3!=0 && $10 > 0 && $9<0.1 {print $9}' /tmp/$file | histo -l  0.01 0.05 $nev > /tmp/${fileid}Kchlog.hist


awk '$1==5 && $3==0 && $10 > 0 {print $9}' /tmp/$file | histo 0.1 0.02 $nev > /tmp/${fileid}K0.hist
awk '$1==5 && $3==0 && $10 > 0 && $9<0.1 {print $9}' /tmp/$file | histo -l  0.01 0.05 $nev > /tmp/${fileid}K0log.hist




