

!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)

!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3


!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

      program main
      implicit none
      real(8),external:: cvh2thick,  cvh2temp, cvh2den,
     *     cvh2scaleh, cvh2denp, cvh2den2p, cthick2h, 
     *     cthick2den
      real(8):: height, depth, rho, temp, rhop, rhodp, sh
      real(8):: dep2h, dep2rho
      integer::model
      call creadParam(5)
      call ciniAtmos
      


      call cNRLHeaderW0(6)




      
      write(*,'(a,a)')
     *   "#  H(m)   depth(g/cm2) T(K)  rho(kg/m3) SH(km) ",
     *   " rho'(SI)     rho''(SI)  dep->h  dep->rho"
      write(*,'(a)')
     *  "# ------------------------------------------------------"

      height = -500

      do  while( height < 500.d3)
         depth= cvh2thick( height )
         temp= cvh2temp( height )
         rho = cvh2den( height )
         sh = cvh2scaleh( height )
         rhop = cvh2denp( height )
         rhodp = cvh2den2p( height )
         dep2h = cthick2h( depth )
         dep2rho = cthick2den( depth )

         write(*,'(1p, E10.3, 1p, E11.3, 0p, f7.1, 1p, E10.3,
     *    -3p, f7.2, 1p, E12.3, E11.3, 1p, E10.2, E10.3)' )
     *     height, depth/10., temp, rho, sh, rhop, rhodp,
     *     dep2h, dep2rho
         if( height < 10005.d0 ) then
            height = height + 100.d0
         else
            height = height*10.d0**0.05d0
         endif
      enddo

      end


