!        csampEIntL:  sample electron interaction length.
       subroutine csampEIntL
       use modXsecMedia
       use modMCScontrol
!
!         brems, knock-on, and anihilation are considered
!
       implicit none
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

!

       real*8  t
       real*8  cupsilon, cmBremMFP, u
       real*8  ee, den, cvh2den, prob
!     
       ee =  TrackBefMove%p%fm%p(4) 
       if(LpmEffect .and. ee .gt. LpmBremEmin) then
!             den = cthick2den(TrackBefMove.pos.depth)
             den = cvh2den(TrackBefMove%pos%height)
             call cbremLPMXsec(ee, den, prob)
             call rndc(u)
             t = -log(u) / prob 
       else
          call cbremsPath(ee, t)
       endif
       call csetIntInf(t*X0, .false., 'brems')
       if(Knockon) then
          if(TrackBefMove%p%charge .eq. -1) then
             call cmollerPath(ee,  RecoilKineMinE, prob, t)
             call csetIntInf(t*X0, .false., 'mscat')
          else
             call cbhabhaPath(ee,  RecoilKineMinE, prob, t)
             call csetIntInf(t*X0, .false., 'bscat')
          endif
       endif
       if(TrackBefMove%p%charge .eq. 1 .and. 
     *    ee .lt. AnihiE ) then
!          if(ee - TrackBefMove.p.mass .lt. 100.e-6) then
!             t = 0.
!          else
             call canihiPath(ee, prob, t)
!          endif
          call csetIntInf(t*X0, .false., 'anihi')
       endif
       if(MagBrem .eq. 2) then
          if(ee .gt. MagBremEmin) then
!             compute upsilon
             Upsilon = cupsilon(TrackBefMove%p, Mag)
             if( Upsilon .gt. UpsilonMin ) then
                call rndc(u)
                t = -log(u) *  cmBremMFP(ee, Upsilon, 0.d0)
                call csetIntInf(t, .true., 'mbrem')
             endif
          endif
       endif

       if( doNewMCS ) then
          call cfixMCSmodel( TrackBefMove%p )
       else
          ActiveMCS = 'Mol'
       endif
       if( ActiveMCS == 'El_con' )  then
          call cfixMixedConst(1, int(TrackBefMove%p%charge ) )
       elseif(ActiveMCS == 'El_hin' )  then
          write(0,*) ' El_hin  is not supported in Cosmos'
          stop
       endif
          

       end
