#!/bin/bash

if [ $# -ne 1 ];then
    dir=./build_cosmos
    if [ ! -d $dir ]
    then
	echo "argument error"
	echo "bash $0 LIBRARY_BUILD_DIRECTORY"
	echo "Do you want to set LIBRARY_BUILD_DIRECTORY as $dir ? (y\n)"
	read yn
	if [ $yn == "y" ] || [ $yn == "yes" ] || [ $yn == "YES" ] || [ $yn == "Yes" ]
	then
	    echo -n
	else
	    echo "abort."
	    exit
	fi
    fi
else
    dir=$1
fi

if [ ! $COSMOSTOP ];then
    echo "COSMOSTOP is not defined."
    COSMOSTOP=$(cd $(dirname $0); cd .. ; pwd)
    echo "Do you want to set COSMOSTP as $COSMOSTOP ? (y\n)"
    read yn
    if [ $yn == "y" ] || [ $yn == "yes" ] || [ $yn == "YES" ] || [ $yn == "Yes" ]
    then
	export COSMOSTOP
    else
	echo "abort."
	exit
    fi
fi

cd $COSMOSTOP
tf=`find ./ -name "cmake_install.cmake"`
if [ "$tf" ]
then
    rm $tf
fi

tf=`find ./ -name "temp*.f*"`
if [ "$tf" ]
then
   echo Remove following files before compiling
   echo $tf
   exit
fi

### build library
if [ ! -d $dir ];then
    mkdir $dir
fi
cd $dir

cmake ${COSMOSTOP}
if [ $? -ne 0 ];then
    echo "cmake error $?. abort."
    exit
fi
make -j4
if [ $? -ne 0 ];then
    make -j4
    if [ $? -ne 0 ];then
	echo "make error. abort."
	exit
    fi
fi

