      subroutine cmuInte
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zcode.h"
      
      real*8 Et
      character*80 msg

      type(track)::aTrack, MoveSave
      save

      aTrack=MovedTrack

      if( IntInfArray(ProcessNo)%process .eq. 'mupair' ) then
         call cmuPrsmpE(MovedTrack%p%fm%p(4),  Et)
         aTrack%p%fm%p(4) = aTrack%p%fm%p(4) - Et  ! muon; neglect angle
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack%p

         if(MuPr .eq. 3 .or. Eabsorb(1) .ne. 0 ) then
!              If Eabsorb(1)=0 and MuPr=2, Et will be missing
!              so we generate pair explicitly when Eabsorb(1)!=0
!              generate pair electrons; employ cpair
!              to do so, make aTrack a gamma of energy Et
            MoveSave = MovedTrack
!               make MovedTrack to be a photon
            MovedTrack%p%fm%p(4) = Et
            call cmkptc(kphoton, kcasg, 0, MovedTrack%p)
            call ce2p(MovedTrack)
            call cpair
!             restore MovedTrack
            MovedTrack = MoveSave
         endif
      elseif(IntInfArray(ProcessNo)%process .eq.'mubrem' ) then   
         call cmuBrsmpE(MovedTrack%p%fm%p(4),  Et)
         aTrack%p%fm%p(4) = aTrack%p%fm%p(4) - Et  ! muon
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack%p   ! muon
         if(MuBr .eq. 3 .or. Eabsorb(1) .ne. 0 ) then
!             generate brems gamma; no deflection
            aTrack%p%fm%p(4) = Et
            call cmkptc(kphoton, kcasg, 0, aTrack%p)
            call ce2p(aTrack)
            Nproduced = Nproduced + 1
            Pwork(Nproduced) = aTrack%p ! gamma
         endif
      elseif(IntInfArray(ProcessNo)%process .eq.'munuci' ) then 
         call cmuNsmpE(aTrack%p%fm%p(4),  Et)
         aTrack%p%fm%p(4) = aTrack%p%fm%p(4) - Et ! muon
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack%p ! muon
         if(Et .gt.  152.d-3 ) then
            if(  MuNI .eq. 3  .or. Eabsorb(1) .ne. 0 )  then 
!             generate gamma-N interaction; employ gamma interaction
!             routine 
               MoveSave = MovedTrack
               MovedTrack%p%fm%p(4) = Et
               call cmkptc(kphoton, 0, 0, MovedTrack%p)
               call ce2p(MovedTrack) ! adjust momentum
               call cfixModel(MovedTrack%p)  ! fix model since
                                             ! energy is < muon
               call cphotop 
!               restore muon
               MovedTrack = MoveSave
            endif
         endif
      else
         write(msg, *) ' in cinteMuon: process=',
     *        IntInfArray(ProcessNo)%process,
     *        ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif   
      end
