**********************************************************************
! YN  last modified 2015.08.11
! YN new param mstd(101)=1:mom.dep.pot. 2015.04.17
! YN revised mstc(109) 2015.02.20
! mstc(198)->mstc(106) mstc(199)->mstc(107) 2014.11.23 YN
! rel. mom-dep incl 2002.09.12
! AO revised        2002.08.30
! introduced mom-dep2002.08.23
! attempt mom-dep   2002.07.24 
! Otuka-san revised 2002.02.14
! Cooling succeed   2002.01.06
! Compile succeed   2001.10.29
! Included V        2001.10.26 
! Otuka-san revised 2001.10.10
**********************************************************************
c***********************************************************************
c                                                                      *
c        PART  : RQMD/S Evolution                                      *
c                                                                      *
c   List of Subprograms in rough order of relevance with main purpose  *
c      (s = subroutine, f = function, b = block data, e = entry)       *
c  f jamrqpb    to judge potential act on it or not                    *
c  s jamrqmd    to calculate force in RQMD/S                           *
c  s jamrqmm    to prepare matrix in calculating force                 *
c  s jamepart   to calculate single particle energy
c  s jamrqen    to calculate energy in RQMD/S                          *
c                                                                      *
c  s jamrqch    cool or heat proj./targ. to fit binding energy         *
c  s jamrqpt                                                           *
c  s findbeng                                                          *
c  f beld                                                              *
c***********************************************************************

      function icheckMF(iopt,gtime)

      include 'jam1.inc'
      include 'jam3.inc'
      logical jamrqpb
      save NrqmdCount
      data NrqmdCount/0/

      if(gtime.eq.0.0d0) then
        NrqmdCount=0
        do i=1,mxv
          dtfree(i)=0.0d0
        enddo
      else
        NrqmdCount=NrqmdCount+1
      endif

      if(iopt.eq.0.and.NrqmdCount.gt.0) then
        do i=1,nv
           MFon=MF_on(i)
           MF_on(i)=1
           if(jamrqpb(i)) MF_on(i)=0
           if(MFon.eq.1.or.MF_on(i).eq.0) then
             dtfree(i)=0.0d0
           endif
        enddo
      endif

      icheckMF=NrqmdCount

      end

c***********************************************************************
      subroutine jamdtfree

      include 'jam1.inc'
      include 'jam3.inc'
      include 'jam4.inc'

        do i=1,nv
          if(MF_on(i).eq.1.and.dtfree(i).gt.0) then
            dt=dtfree(i)
            emfsq=p(4,i)**2 - p(1,i)**2 - p(2,i)**2 - p(3,i)**2
            p(1,i)=p(1,i)+dt*force(1,i)
            p(2,i)=p(2,i)+dt*force(2,i)
            p(3,i)=p(3,i)+dt*force(3,i)
            p(4,i)=sqrt(emfsq+p(1,i)**2+p(2,i)**2+p(3,i)**2)
c displacement only with interaction
            r(1,i)=r(1,i)+dt*forcer(1,i)
            r(2,i)=r(2,i)+dt*forcer(2,i)
            r(3,i)=r(3,i)+dt*forcer(3,i)
          endif
        enddo
        do i=1,mxv
          dtfree(i)=0.0d0
        enddo

      end

c***********************************************************************

      function jamrqpb(i)   ! judge

c...Purpose: to judge potential should
c              act on i-th particle (false)
c       or not act on i-th particle (true)
c mstc(104) :(D=1) option for RQMD/S transport.
c =0 : Potential effects are counted only for formed nucleons.
c =1 : Potential effects are counted only for formed baryons.
c =10: Potential effects are counted for nucleons (even before formation).
c =11: Potential effects are counted for baryons (even before formation).
c =12: Potential effects are counted for baryons which has original
c......constituent quarks (even before formation).
      include 'jam1.inc'
      include 'jam2.inc'
      parameter(teps=1.0d-8)
      logical jamrqpb
 
      jamrqpb=.true.
      if(k(1,i).gt.10) return
      if(abs(k(2,i)).le.100) return
      if(mstc(104).ne.13.and.k(9,i).eq.0) return! Non-Baryons
c     if(mstc(104).ne.13.and.mod(iabs(k(2,i)),10000)/1000.eq.0) return! Non-Baryons
      if(mod(mstc(104),10).eq.0
     &  .and.k(2,i).ne.2212.and.k(2,i).ne.2112) return  ! Non-Nucleons

c     if(mstc(104).lt.10.and.r(5,i).ge.pard(1)+teps) return ! Not Formed

c....Hadrons within a formation time.
      if(r(5,i).ge.pard(1)+teps) then
        if(mstc(104).lt.10) return
        iq=mod(abs(k(1,i))/10,10)
        if((mstc(104).eq.12.or.mstc(104).eq.13).and.iq.eq.0) return
      else
        if(k(9,i).eq.0) return
      endif

      jamrqpb=.false.
      end

c***********************************************************************

      function jamrqpb2(kf)   ! judge

c...Purpose: to judge potential should
c              act on i-th particle (false)
c       or not act on i-th particle (true)
c mstc(104) :(D=1) option for RQMD/S transport.
c =0 : Potential effects are counted only for formed nucleons.
c =1 : Potential effects are counted only for formed baryons.
c =10: Potential effects are counted for nucleons (even before formation).
c =11: Potential effects are counted for baryons (even before formation).
      include 'jam1.inc'
      include 'jam2.inc'
      logical jamrqpb2
 
      jamrqpb2=.true.
      if(abs(kf).le.100) return
      if(mstc(104).ne.13.and.mod(iabs(kf),10000)/1000.eq.0) return ! Non-Baryons
      if(mod(mstc(104),10).eq.0
     &  .and.kf.ne.2212.and.kf.ne.2112) return  ! Non-Nucleons
      jamrqpb2=.false.

      end

**********************************************************************
      function qfac(i)

      include 'jam1.inc'
      include 'jam2.inc'

      qfac=1.0d0
      if(mstc(104).eq.12.and.r(5,i).ge.pard(1)+1d-8) then
        qnum1=3.0d0
        if(k(9,i).eq.0) qnum1=2.d0
        iqcnum=mod(abs(k(1,i))/10,10)
        if(iqcnum.eq.3) iqcnum=2
        qfac=iqcnum/qnum1
      endif

      end

**********************************************************************

      subroutine jamrqmd(in)   ! forcem

c...Purpose: to calculate force in RQMD/S

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
      logical jamrqpb
c...[ Local Variables
      dimension rhog(mx)
      dimension bi(3),rk(3),b(3)
      dimension dr2ri(3),dr2pi(3),dp2pi(3)
      dimension dr2rj(3),dr2pj(3),dp2pj(3)
c     dimension dp2p(3),pk(3)
      dimension pk(3)
c...] Local Variables
c...[ Test AO 
      izerotest=0
      if(izerotest.eq.1) then
        do i=1,nv
           force(1,i)=0.0d0
           force(2,i)=0.0d0
           force(3,i)=0.0d0
           forcer(1,i)=0.0d0
           forcer(2,i)=0.0d0
           forcer(3,i)=0.0d0
        enddo
        return
      endif
c...] Test AO 

c...Set the time of force evaluation to global time.
c     tforce=pard(1)

      if (in.eq.1) then         ! for target baryon
         n0 = 1
         nn = mstd(5)
      elseif (in.eq.2) then     ! for projectile baryon
         n0 = mstd(5)+1
         nn = mstd(2)+mstd(5)
      elseif (in.eq.0) then
         n0 = 1
         nn = nv
      endif

      NrqmdCount=icheckMF(in,pard(1))

      call jamrqmm(in)
      do 100 i=n0,nn
        do n=1,3
          forcer(n,i) = 0.0d0
          force(n,i) = 0.d0
        enddo
        if(jamrqpb(i)) goto 100
        if(mstc(107).eq.1) then                   !cut-offed
          rhog(i)=rhocut(i)**(pard(103)-1.0d0)
        else
          rhog(i)=rho(i)**(pard(103)-1.0d0)
        endif
 100  continue
 
c....2015/2/17 YN
      if(mstc(109).ge.1) call jamepart

c     t1=pard(101)/2.d0/rho0
c     t3=pard(103)*pard(102)/(pard(103)+1.d0)/(rho0**pard(103))

      do 10 i=n0,nn  ! sum for ith particle (sigma_i) 
c        if(jamrqpb(i)) goto 10
         if(MF_on(i)==0) goto 10

         fengi= p(5,i)/p(4,i)  ! 2m_i/(2E_i)
         if(mstc(109).eq.1) then
            ee=sqrt(p(4,i)**2 + 2*p(5,i)*vpot(i))
           fengi= p(5,i)/ee
         else if(mstc(109).ge.2) then
           em1sq=p(4,i)**2-p(1,i)**2-p(2,i)**2-p(3,i)**2
           emf1=sqrt(em1sq+vpot(i)**2)-vpot(i)
           fengi= emf1/p(4,i)
         endif

         do n=1,3
           bi(n)   = p(n,i)/p(4,i) ! P_i/E_i
         enddo
 
c        vfac1=qfac(i)

         do 11 j=i+1,nn     ! sum for j (sigma_j(not=i))
           if (i.eq.j) goto 11              ! i=j --> itte-yosi!
c          if(jamrqpb(j)) goto 11
           if(MF_on(j)==0) goto 11
c...
           fsky=0.d0
           ceng=p(4,i)+p(4,j) ! E_i+E_j
           deng = p(4,i) - p(4,j) ! E_i - E_j !m

           fengj= p(5,j)/p(4,j)  ! 2m_j/(2E_j)
           if(mstc(109).eq.1) then
               ee=sqrt(p(4,j)**2 + 2*p(5,j)*vpot(j))
               fengj= p(5,j)/ee
           else if(mstc(109).ge.2) then
             em2sq=p(4,j)**2-p(1,j)**2-p(2,j)**2-p(3,j)**2
             emf2=sqrt(em2sq+vpot(j)**2)-vpot(j)
             fengj= emf2/p(4,j)
           endif

           feng = fengi+fengj    ! 2m_i/(2E_i)+2m_j/(2E_j)

c... rb_{ij}=gamma_ij^2 *(R_ij * beta_ij) <jamrqmm

           fac2 = pm(i,j)/ceng 
            !  pm(i,j)  = gamma_ij^4 * [(m_i^2 + m_j^2) / (E_i + E_j)]^2
           do n=1,3
             rk(n)=r(n,i)-r(n,j)                ! R_ij
             b(n) =(p(n,i)+p(n,j))/ceng         ! beta_ij
             dr2ri(n)= rk(n)+rb(i,j)*b(n)         ! 1/2*dR~^2_ij/dR_i
             dr2rj(n)=-dr2ri(n)
c
             bbi=b(n)-bi(n)                   ! beta_ij - P_i/E_i
             bj=p(n,j)/p(4,j)                 ! P_j/E_j
             bbj=b(n)-bj                      ! beta_ij - P_j/E_j
             dr2pi(n)=rb(i,j)/ceng*(rk(n)+rb(i,j)*bbi)
             dr2pj(n)=rb(i,j)/ceng*(rk(n)+rb(i,j)*bbj)
                                                ! 1/2*dR~^2_ij/dP_i 
             !m
             pk(n) = p(n,i)-p(n,j)
             dp2pi(n) = pk(n) - deng*bi(n) + fac2*bbi
             dp2pj(n) =-pk(n) + deng*bj    + fac2*bbj
             !m 
           enddo

c... rho_ij = exp[-R~_ij^2/(4*L)]/[(4*pi*L)^3/2]
       fsky=feng*t1+t3f*(fengi*rhog(i)   +fengj*rhog(j))
       fsky=(-0.5d0/pard(104))*rhom(i,j)*fsky
       fmomd=pmom2(i,j)*(-0.5d0/pard(104))/4.d0/rho0*rhom(i,j)*feng ! D_ij
       fmome=pmom1(i,j)*rhom(i,j)*feng/2.d0  ! E_ij

! dR_i/dt(x,y,z)=P_i/E_i + sigma_j(not=i) D_ij *2*dr2pi(x,y,z)
!                        + sigma j(not=i) E_ij *2*dp2p(x,y,z)
! dP_i/dt(x,y,z)= - sigma_j(not=i) D_ij *2*dr2r(x,y,z)
! rho(i),rho(j),rhom(i,j):rho_ij < jamrqmm
! rho(i):<rho_i>=sigma_j(not=i)rho_ij
! parameter g:gamma, el:L

c          vfac=vfac1*qfac(j)
           vfac=1d0

           do n=1,3
             forcer(n,i) = forcer(n,i) + 2*fsky*dr2pi(n)*vfac ! dR_i/dt
             force(n,i)  = force(n,i)  - 2*fsky*dr2ri(n)*vfac ! dP_i/dt
             forcer(n,j) = forcer(n,j) + 2*fsky*dr2pj(n)*vfac ! dR_i/dt
             force(n,j)  = force(n,j)  - 2*fsky*dr2rj(n)*vfac ! dP_i/dt
           if (mstd(101).eq.1) then
             forcer(n,i) = forcer(n,i) + 2*fmomd*dr2pi(n)*vfac
     &                                 + 2*fmome*dp2pi(n)*vfac
             force(n,i)  = force(n,i)  - 2*fmomd*dr2ri(n)*vfac
 
             forcer(n,j) = forcer(n,j) + 2*fmomd*dr2pj(n)*vfac
     &                                 + 2*fmome*dp2pj(n)*vfac
             force(n,j)  = force(n,j)  - 2*fmomd*dr2rj(n)*vfac
           endif
           enddo
 11      continue               ! loopend of sigma_j [1,nn](j not= i)
 10   continue                  ! loopend of sigma_i [1,nn]

c...[AO:030126
      if(in.eq.0.and.mstc(103).eq.0) then
        dt=parc(2)
        do i=1,nv
          if(MF_on(i).eq.1) then
            emfsq=p(4,i)**2 - p(1,i)**2 - p(2,i)**2 - p(3,i)**2
            p(1,i)=p(1,i)+dt*force(1,i)
            p(2,i)=p(2,i)+dt*force(2,i)
            p(3,i)=p(3,i)+dt*force(3,i)
            p(4,i)=sqrt(emfsq+p(1,i)**2+p(2,i)**2+p(3,i)**2)
c displacement only with interaction
            r(1,i)=r(1,i)+dt*forcer(1,i)
            r(2,i)=r(2,i)+dt*forcer(2,i)
            r(3,i)=r(3,i)+dt*forcer(3,i)
          endif
        enddo

        if(mstc(109).ge.1) then
          call jamrqmm(in)
          call jamepart
        endif

      endif
c...]AO:030126

c...[AO:050728
c      iswR=1
c      if(iswR.eq.1) then
      if(in.eq.0.and.NrqmdCount.gt.0.and.mstc(103).gt.0) then
        call jamdtfree
      endif
c      endif
c...]AO:050728

c     do i=1,nv
c          write(6,800) MF_on(i),(force(j,i),j=1,3),(forcer(j,i),j=1,3)
c      end do
c800   format(i2,6(e12.4,1x))

      end

**********************************************************************

      subroutine jamrqmm(in)  ! makemat

c...Purpose: to prepare matrix in calculating force

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
      logical jamrqpb

      if (in.eq.1) then         ! for target baryon
         n0 = 1
         nn = mstd(5)
      elseif (in.eq.2) then     ! for projectile baryon
         n0 = mstd(5)+1
         nn = mstd(2)+mstd(5)
      elseif (in.eq.0) then
         n0 = 1
         nn = nv
c        do i=n0,nv
c          p(4,i) = sqrt(p(1,i)**2 + p(2,i)**2 + p(3,i)**2 + p(5,i)**2)
c        enddo
      endif

      do i=n0,nn
         MF_on(i)=1
         if(jamrqpb(i)) MF_on(i)=0
      enddo

      fac  =(4.d0*pi*pard(104))**1.5d0 !    [(4*pi*L)^3/2]
      do 100 i=n0,nn              ! sum for ith particle (sigma_i) 
         if(MF_on(i)==0) goto 100

c...  <rho_i> = sigma_j(not= i) rho_ij
         rho(i)=0.d0
         rhocut(i) = 0.d0
         emisq=p(4,i)**2-p(1,i)**2-p(2,i)**2-p(3,i)**2

         do 110 j = i+1 , nn      ! sum for j (sigma_j(>i))
            if(MF_on(j)==0) goto 110
            rhom(i,j)=0.d0
            r22(i,j)=0.d0
            rij=0.d0
            bij=0.d0
            ceng = p(4,i) + p(4,j) ! E_i + E_j
            deng = p(4,i) - p(4,j) ! E_i - E_j !m
            rs   = 0.d0
            ps   = 0.d0 !m
            bij2 = 0.d0
            rbij = 0.d0
            do n=1,3            ! x,y,z
               rij  =  r(n,i) - r(n,j) ! R_ij
               pij  =  p(n,i) - p(n,j) ! P_ij !m
               bij  = (p(n,i) + p(n,j)) ! beta_ij
               rs   =  rs + rij**2 ! R_ij ^2
               ps   =  ps + pij**2 ! P_ij ^2 !m
               bij2 =  bij2 + bij**2 ! beta_ij ^2
               rbij =  rbij + rij*bij ! R_ij * beta_ij
            enddo               ! (n=1,3)
            bij2=bij2/ceng**2
            rbij=rbij/ceng
            if(bij2.eq.1.d0)print *,bij2
            gam2 = 1.d0/(1.d0-bij2) ! gamma_ij^2 =1/(1-beta_ij^2)
            rb(i,j)  =  gam2 * rbij ! gamma_ij^2 *(R_ij * beta_ij)
            rb(j,i)  = -rb(i,j)
            
c... R~_ij^2 = R_ij^2 + gamma_ij^2 * (R_ij*beta_ij)^2
            r22(i,j) = rs + gam2*(rbij**2)
            if (r22(i,j).lt.0)print *, "gam2=",gam2 , "rbij=",rbij
            r22(j,i) = r22(i,j)
            
            emjsq=p(4,j)**2-p(1,j)**2-p(2,j)**2-p(3,j)**2
            !m
            dmas = (emisq- emjsq) /ceng
            ! (m_i^2 + m_j^2) / (E_i + E_j)
            pma  = gam2 * (dmas**2)
            ! gamma_ij^2 * [(m_i^2 + m_j^2) / (E_i + E_j)]^2
            pm(i,j)  = gam2 * pma
            ! gamma_ij^4 * [(m_i^2 + m_j^2) / (E_i + E_j)]^2
            pm(j,i)  = pm(i,j)
            p22(i,j) = ps - deng**2 + pma
            ! P~_ij^2 = P_ij^2 - ( E_i - E_j )^2
            !  + gamma_ij^2 * [(m_i^2 - m_j^2) / (E_i + E_j)]^2
            p22(j,i) = p22(i,j)

            fac1 = 1.d0 + p22(i,j)/((pmu1)**2)
            fac2 = 1.d0 + p22(i,j)/((pmu2)**2)
            pmom1(i,j)=-1.d0/rho0*
     &      (  vex1/pmu1**2/fac1/fac1
     &        +vex2/pmu2**2/fac2/fac2 )
            pmom1(j,i) = pmom1(i,j)
            pmom2(i,j) = vex1/fac1 + vex2/fac2
            pmom2(j,i) = pmom2(i,j)
            !m

            expa = -r22(i,j)/4.d0/pard(104) !     -R~_ij^2/(4*L)
            if (expa.gt.0)print *, "expa=", expa
            den  = exp(expa)    ! exp[-R~_ij^2/(4*L)]
            
c...  rho_ij = exp[-R~_ij^2/(4*L)]/[(4*pi*L)^3/2]
            rhom(i,j) = den / fac * qfac(i) * qfac(j) 
            rhom(j,i) = rhom(i,j)
 110     continue               ! loopend of sigma_j(>i)
 100  continue                  ! loopend of sigma_i
c
      do 8 i=n0,nn
         if(jamrqpb(i)) goto 8
         do 9 j=i+1,nn
           if(jamrqpb(j)) goto 9
            rho(i) = rho(i) + rhom(i,j)
            rho(j) = rho(j) + rhom(i,j)
 9       continue

         if(mstc(107).eq.1) then
         do 99 j=i+1,nn
            if (jamrqpb(j)) goto 99
            faccut = 1.d0 + p22(i,j)/(clam**2)
            rhocut(i) = rhocut(i) + rhom(i,j)/faccut
 99      continue
         endif

 8    continue
      return
      end

**********************************************************************

      subroutine jamrqmm2(i)

c...Purpose: to prepare matrix in calculating force

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
      logical jamrqpb

      fac  =(4.d0*pi*pard(104))**1.5d0 !    [(4*pi*L)^3/2]

c...  <rho_i> = sigma_j(not= i) rho_ij
      rho(i)=0.d0
      rhocut(i) = 0.d0
      if(jamrqpb(i)) return

c     do i=1,nv
c       p(4,i) = sqrt(p(1,i)**2 + p(2,i)**2 + p(3,i)**2 + p(5,i)**2)
c     enddo

      qfaci=qfac(i)
      emisq=p(4,i)**2-p(1,i)**2-p(2,i)**2-p(3,i)**2

      do 110 j = 1 , nv      ! sum for j (sigma_j(>i))

        if(jamrqpb(j)) goto 110
        rhom(i,j)=0.d0
        r22(i,j)=0.d0
        rij=0.d0
        bij=0.d0
        ceng = p(4,i) + p(4,j) ! E_i + E_j
        deng = p(4,i) - p(4,j) ! E_i - E_j !m
        rs   = 0.d0
        ps   = 0.d0 !m
        bij2 = 0.d0
        rbij = 0.d0
        do n=1,3            ! x,y,z
          rij  =  r(n,i) - r(n,j) ! R_ij
          pij  =  p(n,i) - p(n,j) ! P_ij !m
          bij  = (p(n,i) + p(n,j)) ! beta_ij
          rs   =  rs + rij**2 ! R_ij ^2
          ps   =  ps + pij**2 ! P_ij ^2 !m
          bij2 =  bij2 + bij**2 ! beta_ij ^2
          rbij =  rbij + rij*bij ! R_ij * beta_ij
        enddo               ! (n=1,3)
        bij2=bij2/ceng**2
        rbij=rbij/ceng
        if(bij2.eq.1.d0)print *,bij2
        gam2 = 1.d0/(1.d0-bij2) ! gamma_ij^2 =1/(1-beta_ij^2)
        rb(i,j)  =  gam2 * rbij ! gamma_ij^2 *(R_ij * beta_ij)
            
c... R~_ij^2 = R_ij^2 + gamma_ij^2 * (R_ij*beta_ij)^2
        r22(i,j) = rs + gam2*(rbij**2)
        if (r22(i,j).lt.0)print *, "gam2=",gam2 , "rbij=",rbij
           
        emjsq=p(4,j)**2-p(1,j)**2-p(2,j)**2-p(3,j)**2
        dmas = (emisq- emjsq) /ceng
c       dmas = (p(5,i)**2 - p(5,j)**2) /ceng
        pma  = gam2 * (dmas**2)
        pm(i,j)  = gam2 * pma
        p22(i,j) = ps - deng**2 + pma

        fac1 = 1.d0 + p22(i,j)/((pmu1)**2)
        fac2 = 1.d0 + p22(i,j)/((pmu2)**2)
        pmom1(i,j)=-1.d0/rho0*
     &      (  vex1/pmu1**2/fac1/fac1
     &        +vex2/pmu2**2/fac2/fac2 )
        pmom2(i,j) = vex1/fac1 + vex2/fac2
        expa = -r22(i,j)/4.d0/pard(104) !     -R~_ij^2/(4*L)
        if (expa.gt.0)print *, "expa=", expa
        den  = exp(expa)    ! exp[-R~_ij^2/(4*L)]
            
c...  rho_ij = exp[-R~_ij^2/(4*L)]/[(4*pi*L)^3/2]
        rhom(i,j) = den / fac * qfaci * qfac(j)

 110  continue               ! loopend of sigma_j(>i)

      end

c***********************************************************************

      subroutine getrho
      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam4.inc'
      logical jamrqpb

      do 8 i=1,nv
         if(jamrqpb(i)) goto 8
         do 9 j=i+1,nv
           if(jamrqpb(j)) goto 9
            rho(i) = rho(i) + rhom(i,j)
            rho(j) = rho(j) + rhom(i,j)
 9       continue

         if(mstc(107).eq.1) then
         do 99 j=i+1,nv
            if (jamrqpb(j)) goto 99
            faccut = 1.d0 + p22(i,j)/(clam**2)
            rhocut(i) = rhocut(i) + rhom(i,j)/faccut
 99      continue
         endif

 8    continue

      end

c***********************************************************************

      subroutine jamepart  ! energy

c...Purpose: to calculate single particle potential energy in RQMD/S
c H = sigma_i=1^N  1/(2*E_i) *[E_i^2 -vec{p}_i^2 - m_i^2 - 2m_i*V_i ]
c here V_i = t1 * <rho_i> + t3 *<rho_i>^gamma : Skyrme Potential
c...last revised:  2015/2/20

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'

c...Local Variable
      logical jamrqpb

c     if(nv.gt.mx) then
c        write(mstc(38),*)" particle number too large nv mx= ",nv,mx
c        stop
c     endif

      do 100 i=1,nv

       if(jamrqpb(i)) then
         vpot(i)=0.0d0
         goto 100
       endif

       vpot(i) = t1*rho(i) + t3*(rho(i)**pard(103))
       if(mstd(101).eq.1) then
       do 200 j=1,nv
          if(jamrqpb(j)) goto 200
          vpot(i) = vpot(i) + pmom2(i,j)/2.d0/rho0*rhom(i,j) 
200      continue
       endif

c      vpot(i)=qfac(i)*vpot(i)

       p(4,i) = sqrt(p(5,i)**2+p(1,i)**2 + p(2,i)**2 + p(3,i)**2)
c      if(mstc(109).ge.2.and.abs(k(1,i)).eq.1) then
       if(mstc(109).ge.2) then
         p(4,i)=sqrt(max(0d0,p(4,i)**2 + 2*p(5,i)*vpot(i)))
       endif

100   continue

      end

************************************************************************

      subroutine jamrqen(in)  ! energy

c...Purpose: to calculate energy in RQMD/S
c H = sigma_i=1^N  1/(2*E_i) *[E_i^2 -vec{p}_i^2 - m_i^2 - 2m_i*V_i ]
c here V_i = t1 * <rho_i> + t3 *<rho_i>^gamma : Skyrme Potential

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'

c...Local Variable
      logical jamrqpb

c       t1=pard(101)/2.d0/rho0
c       t3=pard(102)/(pard(103)+1.d0)/(rho0**pard(103))

      call jamrqmm(in)

      if (in.eq.1) then         ! for target baryon
         n0 = 1
         nn = mstd(5)
      elseif (in.eq.2) then     ! for projectile baryon
         n0 = mstd(5)+1
         nn = mstd(2)+mstd(5)
      elseif (in.eq.0) then
         n0 = 1
         nn = nv
      endif
        do i=1,min(nv,mx)
        vsky(i)=0.d0
        vmom(i)=0.d0
        enddo

      do 13 i=n0,nn
c      if(jamrqpb(i)) goto 13
       if(MF_on(i)==0) goto 13

           vfac=1.0d0
           if(mstc(104).eq.12.and.r(5,i).ge.pard(1)+1d-8) then
             ibar1=k(9,i)
             if(abs(ibar1).eq.3) qnum1=3.d0
             if(ibar1.eq.0) qnum1=2.d0
             iqcnum=mod(abs(k(1,i))/10,10)
             if(iqcnum.eq.3) iqcnum=2
             vfac=iqcnum/qnum1
           endif

c       p(4,i) = sqrt(p(1,i)**2 + p(2,i)**2 + p(3,i)**2 + p(5,i)**2 )
        vsky(i) = vfac*(t1*rho(i) + t3*(rho(i)**pard(103)))
        vmom(i)=0.d0
       if(mstd(101).eq.1) then
        do 14 j=n0,nn
c         if(jamrqpb(j)) goto 14
          if(MF_on(j)==0) goto 14
          vmom(i) = vmom(i) + pmom2(i,j)/2.d0/rho0*rhom(i,j) 
14      continue
          vmom(i)=vfac*vmom(i)
       else
         goto 13
       endif

13    continue


      return
      end
************************************************************************
      subroutine jamrqmde(ekin,epot,etot)
************************************************************************
c...Purpose: to calculate energy in RQMD/S
c H = sigma_i=1^N  1/(2*E_i) *[E_i^2 -vec{p}_i^2 - m_i^2 - 2m_i*V_i ]
c here V_i = t1 * <rho_i> + t3 *<rho_i>^gamma : Skyrme Potential

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
        logical jamrqpb

c...Local Variable
      ekin=0.0d0
      epot=0.0d0
c       write(*,*) nv
      call jamrqen(0)
      do 100 i=1,nv
c...
        if(k(1,i).gt.10) goto 100

        em=p(5,i)
        pp=p(1,i)**2+p(2,i)**2+p(3,i)**2
c       if(jamrqpb(i)) then
        if(MF_on(i)==0) then
         ekin = ekin + sqrt(pp+em**2)
         goto 100
        endif

        emf2=em**2+2*em0*(vsky(i)+vmom(i))
        p4=sqrt(pp+em**2)
        ekin=ekin+p4
        ee=sqrt(pp+emf2) ! Tot.E
        epot=epot+ee-p4
100   continue
      ekin=ekin/mstd(11)
      epot=epot/mstd(11)
      etot=ekin+epot
      return
      end
************************************************************************
      subroutine jamrqch(dt2,ic,in) ! coolheat

c...Purpose: Cool and Heat Projectile(1)/Target(2) Nuclei to fit 
c            the binding energy
c
c  d P_i/dt = - del<H>/del R_i - mu/b *  del <H>/del P_i 
c  d R_i/dt =   del<H>/del P_i - mu   *  del <H>/del R_i non-rel 
c  force(n,i)  = +del <H>/del R_i <= dP_i/dt   <H>is rel. 
c  forcer(n,i)  = -del <H>/del P_i <= dR_i/dt
c  sp =  mu/b > 0
c  sr =  mu   > 0

      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
c     dimension force(3,mx),forcer(3,mx)
      data sp,sr/-1.d-1,-1.d-1/
      call jamrqmd(in)
      call jamrqen(in)

      if (in.eq.1) then         ! for target baryon
         n0 = 1
         nn = mstd(5)
      elseif (in.eq.2) then     ! for projectile baryon
         n0 = mstd(5)+1
         nn = mstd(2)+mstd(5)
      endif

      do i=n0,nn
        do n=1,3
c...[Modified by AO 2002/08/30
            vn=p(n,i)/p(4,i)
c forcer(n,i)+vn=   dH/dp(n,i)
c force(n,i)   = - dH/dr(n,i)
c cooling Eq.: dp/dt=-dH/dp =  fr+vn
c              dr/dt=-dH/dr = -fp
          if (ic.eq.1) then      ! cool
            p(n,i)=p(n,i) + dt2*(force(n,i)     + sp*(forcer(n,i)+vn))
            r(n,i)=r(n,i) + dt2*(forcer(n,i)+vn - sr* force(n,i)    )
          elseif (ic.eq.2) then  ! heat
            p(n,i)=p(n,i) + dt2*(force(n,i)     - sp*(forcer(n,i)+vn))
            r(n,i)=r(n,i) + dt2*(forcer(n,i)+vn + sr* force(n,i)    )
          endif 
c...]Modified by AO 2002/08/30
        enddo
        e2 = p(5,i)**2 + p(1,i)**2 + p(2,i)**2 + p(3,i)**2
        p(4,i) = sqrt( e2 +2.d0*p(5,i)* (vsky(i)+vmom(i))) !m
c       p(4,i) = sqrt( e2 )
      enddo

      return 
      end

************************************************************************
      subroutine jamrqpt(in) ! trans
************************************************************************
      include 'jam1.inc'
      include 'jam2.inc'
      include 'jam3.inc'
      include 'jam4.inc'
      parameter (de=0.1d-3)
      data dt2/0.05d0/
      data sau/-7.9d-3/         ! binding energy per nucleon for 197Au
      if (in.eq.1) then         ! for target baryon
         n0 = 1
         nn = mstd(5)
         ia = mstd(5)
         iz = mstd(6)
      elseif (in.eq.2) then     ! for projectile baryon
         n0 = mstd(5)+1
         nn = mstd(2)+mstd(5)
         ia = mstd(2)
         iz = mstd(3)
      endif
        call findbeng(ia,iz,beng)
        sau = -beng/dble(nn-n0+1)
      do 1000 it=1,10000
        call jamrqen(in)
        esky = 0.d0
        emom = 0.d0
        eqmas= 0.d0
        ekin = 0.d0
        do i = n0,nn
          esky  = esky  + vsky(i)
          emom  = emom  + vmom(i) !m
          eqmas = eqmas + p(5,i)
          ekin  = ekin  + sqrt(p(1,i)**2+p(2,i)**2+p(3,i)**2+p(5,i)**2)
        enddo
        ekin= ekin - eqmas
        if(mstd(101).eq.1) then
          eng = esky + emom + ekin !m
        else
          eng = esky + ekin 
        endif
        esky= esky/dble(nn-n0+1)
        emom= emom/dble(nn-n0+1)
        ekin= ekin/dble(nn-n0+1)
        sine= eng /dble(nn-n0+1)  ! Binding energy (AGeV)
        if(mstc(8).ge.2.or.(mstc(8).ge.1.and.mod(it,10).eq.0)) then
          write(*,820) it, sau-de , sine , sau+de , eng, ekin ! check
        endif
820     format (i5,1x,6(f13.7,1x))

        if ((sine.ge.sau-de) .and. (sine.le.sau+de))  then
          return
        else
c          dt2=abs(sau-sine)*10.d0
c         dt2=abs(sau-sine)
          if (sine.gt.sau) call jamrqch(dt2,1,in) ! cool (underbinding)
          if (sine.lt.sau) call jamrqch(dt2,2,in) ! heat (overbinding)
        endif
          
1000  continue

      return
      end 

************************************************************************
        subroutine findbeng(ia,iz,beng) ! findbeng
************************************************************************
       include 'jam1.inc'
       character symbol*5
       open(410,file='beng.dat',status='old',err=1000)
c     print *, ia,iz
10     read(410,*,end=1000,err=1000) kz,kn,beng,symbol
c     print *, kz,kn,beng,symbol
       if (kn+kz.eq.ia.and.kz.eq.iz) then
        write(*,*)"B.E of",ia,"-",symbol,"-",iz,"=",beng,"MeV"
        beng=beng/1000.d0
        close(410)
        return
       endif
       goto 10

1000   continue
       beng=beld(ia,iz)/1000.d0
c20    continue
c      write(*,*)"(findbeng) error: cannot find B.E."
c      stop
c30     continue
c       write(*,*)"(findbeng) error: read error occur in subroutine"
c      stop
      end
************************************************************************
        function beld(ia,iz)
************************************************************************
        implicit real*8(a-h,o-z)
c a1              = -15.4602          #       +/- 0.105768
c a2              = 18.4107           #       +/- 0.256056
        parameter(av=-15.68d0,as=18.56d0,ac=0.717d0,ai=28.1d0)
        beld=0.0d0
        if(ia.le.1) return
        aa=dble(ia)
        aa3=aa**(1.0d0/3.0d0)
        beld=av*ia+as*aa3*aa3+ac*iz**2/aa3+ai*(2*iz-ia)**2/ia
        end
