//  Lateral Fit function

//-----------------------------------------------------------------------
//  made by E.Kido
//
//  to execute this example, do:
//  root > .x lateral.C
// or
//  root > .x lateral.C++
//
//-----------------------------------------------------------------------

#include "TH1.h"
#include "TF1.h"
#include "TROOT.h"
#include "TStyle.h"

#include <stdlib.h>
#include <stdio.h>
#include <fstream>
#include <iostream>

using namespace std ;

#define MAX_EXC 10 // for photon maybe dangerous

Double_t lateralfun_ph(Double_t *x, Double_t *par) {

   //Fit parameters:
   //-1.2 =power 1 : parameter of first power of NKG
   //param[0]=power 2 : parameter of second power of NKG
   //par[0]=Total area (integral -inf to inf, normalization constant)
  // x is in moliere unit
  // AGASA-like modification
  // param[2]=power 3 : parameter of third power of NKG
  // param[3]=distance scaling parameter
  // par[1]=power 1 : parameter of fourth power of NKG
  // par[2]=power 2 : parameter of fourth power of NKG
  // par[3]=power 3 : parameter of fourth power of NKG
  // par[4]=power 4 : parameter of fourth power of NKG
  // par[5]=power 5 : parameter of fourth power of NKG

  return (par[0] * TMath::Power(x[0] , -1.2) * TMath::Power(1. + x[0], par[1])* TMath::Power(1. + (x[0]/7.5)*(x[0]/7.5), par[2])*TMath::Power(1. + TMath::Power((x[0]/15),3.), par[3])*TMath::Power(1. + TMath::Power((x[0]/30),4.), par[4])*TMath::Power(1. + TMath::Power((x[0]/45),5.), par[5]));
}



TF1 *lateralfit_ph(TH1F *his, Double_t *fitrange, Double_t *startvalues, Double_t *parlimitslo, Double_t *parlimitshi, Double_t *fitparams, Double_t *fiterrors, Double_t *ChiSqr, Int_t *NDF,Int_t Flg)
{

  //Fit parameters:
   //-1.2 =power 1 : parameter of first power of NKG
   //param[0]=power 2 : parameter of second power of NKG
   //par[0]=Total area (integral -inf to inf, normalization constant)
  // x is in moliere unit
  // AGASA-like modification
  // param[2]=power 3 : parameter of third power of NKG
  // param[3]=distance scaling parameter
  // par[1]=power 4 : parameter of fourth power of NKG
  // par[2]=distance scaling parameter
  // par[3]=power 5 : parameter of fifth power of NKG

   //
   // Variables for lateralfit call:
   //   his             histogram to fit
   //   fitrange[2]     lo and hi boundaries of fit range
   //   startvalues[6]  reasonable start values for the fit
   //   parlimitslo[6]  lower parameter limits
   //   parlimitshi[6]  upper parameter limits
   //   fitparams[6]    returns the final fit parameters
   //   fiterrors[6]    returns the final fit errors
   //   ChiSqr          returns the chi square
   //   NDF             returns ndf

   Int_t i;
   Char_t FunName[100];

   sprintf(FunName,"Fitfcn_%s",his->GetName());

   TF1 *ffitold = (TF1*)gROOT->GetListOfFunctions()->FindObject(FunName);
   if (ffitold) delete ffitold;

   TF1 *ffit = new TF1(FunName,lateralfun_ph,fitrange[0],fitrange[1],6);
   ffit->SetParameters(startvalues);
   ffit->SetParNames("Area","POW1","POW2","POW3","POW4","POW5");
   
   for (i=0; i<6; i++) {
      ffit->SetParLimits(i, parlimitslo[i], parlimitshi[i]);
   }

   if(Flg == 0){ //do not write results
     his->Fit(FunName,"QRB0");   // fit within specified range, use ParLimits, do not plot
   } // write results
   else{
     his->Fit(FunName,"RB0");   // fit within specified range, use ParLimits, do not plot
   }

   ffit->GetParameters(fitparams);    // obtain fit parameters
   for (i=0; i<6; i++) {
      fiterrors[i] = ffit->GetParError(i);     // obtain fit parameter errors
   }
   ChiSqr[0] = ffit->GetChisquare();  // obtain chi^2
   NDF[0] = ffit->GetNDF();           // obtain ndf

   return (ffit);              // return fit function

}

void lateral_ph_fit(double *xhist, double *hist,double *yerror,double *area,char *fin,int maxbin,Double_t *fp,Double_t *fpe,Double_t *chisqr,Int_t *ndf,Int_t *rflag) {

   TH1F* hSNR;
   Int_t iBin=0,maxiBin=0;

   const Int_t nbins = 40; // changed
   Double_t xmin = TMath::Power(10.,-2.05);
   Double_t xmax = TMath::Power(10.,1.95);
   Double_t logxmin = TMath::Log10(xmin);
   Double_t logxmax = TMath::Log10(xmax);
   Double_t binwidth = (logxmax-logxmin)/nbins;
   Double_t xbins[nbins+1];
   Int_t i;

   xbins[0] = xmin;

   for(i=1;i<=nbins;i++){
     xbins[i] = (2.*TMath::Power(10,logxmin - 0.05 + i*binwidth) - xbins[i-1]);
   }

   hSNR = new TH1F(fin,fin,nbins,xbins);

   Double_t fr[2];
   Double_t sv[6], pllo[6], plhi[6];
   Double_t h = 0.5,lastchi = 10000.,lastsv = 0.,nextsv = 0.,storesv =0.,lastsv_s = 0.;
   Int_t max_loop = 5,loop = 0;

   Double_t diff = 0.;
   Int_t Out_bin = 0,errflag = 0;

   // fill histrgrams
   for(iBin=0;iBin < maxbin;iBin++ ){ // changed
     //re-define

     hist[iBin] = (hist[iBin]/((TMath::Pi()*(TMath::Power(10.,0.1) + 1)*(TMath::Power(10.,0.1) - 1))*(area[iBin]*area[iBin])/12.)); // changed
       
     if(yerror[iBin] == 0){
       yerror[iBin] = 0;
     }
     else{
       yerror[iBin] = sqrt(yerror[iBin])*hist[iBin]/yerror[iBin];
     }     

     //     cout << iBin << " " << xhist[iBin] << " " << hist[iBin] << " " << yerror[iBin] << endl;
     
   }

   //---end reading each file

   maxiBin = iBin-1; // do not use last bin(temporary)
   
   for(iBin=0;iBin<maxiBin;iBin++){
     hSNR->SetBinContent(iBin+1,hist[iBin]);
     hSNR->SetBinError(iBin+1,yerror[iBin]);
   }
   
   // Set error bars
   gStyle->SetErrorX(0);
   
   // Fitting SNR histo
//    printf("Fitting...\n");
   
   // Setting fit range and start values
   
   fr[0] = 2.;
   fr[1] = 100.;
   
   pllo[0]= TMath::Power(10.,5.); 
   plhi[0] = TMath::Power(10.,12.);
   sv[0]= 4.9e+10;
   
   pllo[1]= -5.; pllo[2]= -8.; pllo[3]= -2.;
   plhi[1]= 0.;plhi[2] = 0.; plhi[3] = 2.;
   sv[1]=  -1.84434;sv[2] =  -1.57968; sv[3]= -0.05;
   
   pllo[4]= -2.; pllo[5]= -3.0;
   plhi[4]= 2.;plhi[5] = -0.1; // from -1.5
   sv[4]=  0.3;sv[5] =  -2.;
    
   h = 0.5,lastchi = 10000. ;
   max_loop = 5,loop = 0;
   
   // fitting loop start---
   
   for(loop = 0;loop < max_loop;loop++){

     for(sv[1] = -0.5;sv[1] >= -5.0;sv[1] -= h){ // changed     
       for(sv[5] = -0.5;sv[5] >= -2.0;sv[5] -= h){
	 sv[2] =  -1.57968; sv[3]= -0.05;
	 sv[4]=  0.3;
       
//        TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,0);
	 lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);       

	 if(chisqr[0] < lastchi){
	   lastsv_s = sv[1] ;
	   lastsv = sv[5] ;
	   nextsv = fp[0] ;
	   storesv = sv[0] ;
	   lastchi = chisqr[0] ;
	 }
       }
     }
     
     sv[0] = nextsv ; // sv[0]-sv[5] combination does not become the best.
     
   }
   
   sv[0]= storesv;
   sv[1]=  lastsv_s ;sv[2] =  -1.57968; sv[3]= -0.05;
   sv[4]=  0.3;
   sv[5] = lastsv ;
   
//    TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,1);
//    lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,1);
   lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);
   
   // fitting loop end---
      
   rflag[0] = 0;

   //----------------chi_square is over 1000 case needed?
   
   if(chisqr[0] > 1000.){
     rflag[0] = 1;
//      printf("Chi_Square was over 1000 re-fitting...\n");
     
     // Setting fit range and start values
     
     sv[0]= fp[0]; // changed
     sv[1]=  -1.84434;sv[2] =  -1.57968; sv[3]= -0.05;
     sv[4]=  0.3;sv[5] =  -2.;
     
//      cout << sv[0] << " " << endl ;
     
     h = 0.5,lastchi = 10000. ;
     max_loop = 5,loop = 0;
     
     // fitting loop start---
     
     for(loop = 0;loop < max_loop;loop++){
   
       for(sv[1] = -0.5;sv[1] >= -5.0;sv[1] -= h){    
	 for(sv[5] = -0.5;sv[5] >= -2.0;sv[5] -= h){
	   sv[2] =  -1.57968; sv[3]= -0.05;
	   sv[4]=  0.3;
	 
	   // 	 TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,0);
	   lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);
	   
	   if(chisqr[0] < lastchi){
	     lastsv_s = sv[1] ;
	     lastsv = sv[5] ;
	     nextsv = fp[0] ;
	     storesv = sv[0] ;
	     lastchi = chisqr[0] ;
	   }
	 }
       }

       sv[0] = nextsv ; // sv[0]-sv[5] combination does not become the best.	 
     }
     
     sv[0]= storesv;
     sv[1]=  lastsv_s;sv[2] =  -1.57968; sv[3]= -0.05;
     sv[4]=  0.3;
     sv[5] = lastsv ;
     
//      TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,1);
//      lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,1);
     lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);     

     // fitting loop end---
          
   }

   // changing results

   // exclude bad points begin---

   // check fluctuation from fit lines

   for(iBin=0;iBin<maxiBin;iBin++){
     if(xhist[iBin] >= 2 && xhist[iBin] < 100.){ // fit region

       diff = hist[iBin] - lateralfun_ph(&xhist[iBin],fp);
       //       cout << xhist[iBin] << " " << diff << " " << yerror[iBin] << endl;
       if(yerror[iBin] > 0.){
	 if(TMath::Abs(diff) > 5.*yerror[iBin] ){ // exclude when more than 5 sigma difference exists
	   if(Out_bin < MAX_EXC){
	     //     cout << xhist[iBin] << " " << diff << " " << yerror[iBin] << endl;
	     hist[iBin] = 0.;
	     yerror[iBin] = 0.;
	     Out_bin ++;
	   }
	   else{
	     errflag = 1;
	   }
	 }
       }
       
     }
   }

   if(Out_bin > 0 && errflag == 0){

     // re-fit
     hSNR->Reset();
     for(iBin=0;iBin<maxiBin;iBin++){
       hSNR->SetBinContent(iBin+1,hist[iBin]);
       hSNR->SetBinError(iBin+1,yerror[iBin]);
     }

     h = 0.5,lastchi = 10000.;
     max_loop = 5,loop = 0;

   // fitting loop start---
   
     for(loop = 0;loop < max_loop;loop++){
       
       for(sv[1] = -0.5;sv[1] >= -5.0;sv[1] -= h){ // changed     
	 for(sv[5] = -0.5;sv[5] >= -2.0;sv[5] -= h){
	   sv[2] =  -1.57968; sv[3]= -0.05;
	   sv[4]=  0.3;
	   
	   //        TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,0);
	   lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);       
	   
	   if(chisqr[0] < lastchi){
	     lastsv_s = sv[1] ;
	     lastsv = sv[5] ;
	     nextsv = fp[0] ;
	     storesv = sv[0] ;
	     lastchi = chisqr[0] ;
	   }
	 }
       }
       
       sv[0] = nextsv ; // sv[0]-sv[5] combination does not become the best.
       
     }
     
     sv[0]= storesv;
     sv[1]=  lastsv_s ;sv[2] =  -1.57968; sv[3]= -0.05;
     sv[4]=  0.3;
     sv[5] = lastsv ;
     
//    TF1 *fitsnr = lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,&chisqr,&ndf,1);
//    lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,1);
     lateralfit_ph(hSNR,fr,sv,pllo,plhi,fp,fpe,chisqr,ndf,0);
   
   // fitting loop end---
     
     //     printf("Fitting done\nPlotting results...\n");

   }
   else if(errflag == 1){
     //    printf("Give up fitting \n");
     rflag[0] = 2; // changed
   }

   // exclude bad points end----

   //   printf("Fitting done\nPlotting results...\n");


   // comment out

//    TAxis *xaxis = hSNR->GetXaxis();
//    Double_t binCenter,test,tests;

//    for(iBin=0;iBin<=maxiBin;iBin++){ // changed
//      binCenter = xaxis->GetBinCenter(iBin);
//      test = hSNR->GetBinContent(iBin);
//      tests = hSNR->GetBinError(iBin);
//      cout << binCenter << " " << test << " " << tests << " " << endl;
//    }

   // check process

// we need error estimation

//    printf("Fitting done\nPlotting results...\n");
   
   //      TCanvas *c1 = new TCanvas("c1");
   
   //      //    // Global style settings
   //      gStyle->SetOptStat(1111);
   //      gStyle->SetOptFit(111);
   //      gStyle->SetLabelSize(0.03,"x");
   //      gStyle->SetLabelSize(0.03,"y");
   
   //      hSNR->GetXaxis()->SetRange(0,40);
   
   //      c1->SetLogy();
   //      c1->SetLogx();
   
   //      hSNR->Draw("E1");
   //      fitsnr->Draw("lsame");

//    c1->Print("FILE.eps");
//    printf("SNRPeak %f SNRFWHM %f\n",SNRPeak,SNRFWHM);
//    exit();   
}
