      subroutine cinteNuc
      use modXsecMedia
      implicit none


#include  "Ztrack.h"
#include  "Ztrackv.h"

!          cinteNuc.  Treat Nucelon interactions with air target.
      character*70 msg
!////////////
      logical show
      common /showshow/ show
!/////////////
      if(IntInfArray(ProcessNo)%process .eq. 'coll') then
!/////////////
         if(show) then
            write(0,*) 'entering chAcol'
         endif
!//////////////
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
!/////////
         if(show) then
            write(0,*) ' aft chAcol: Npro=',Nproduced
         endif
!////////////////
      else
         write(msg, *) ' in cinteNuc: process=',
     *                IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg,0)
      endif
      end
!     ********************
      subroutine cintePion
!     ********************
      use modXsecMedia
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"

!
      character*70 msg

      if(IntInfArray(ProcessNo)%process .eq. 'coll') then
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)

      elseif(IntInfArray(ProcessNo)%process .eq. 'decay') then
         if(MovedTrack%p%charge .eq. 0) then
            call cpi0Decay(MovedTrack%p, Pwork, Nproduced)
         else
            call cpiMuDecay(MovedTrack%p, IncMuonPolari, 
     *           Pwork, Nproduced, MuonPolarization)
         endif
      else
         write(msg, *) ' in cintePion: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         write(0,*) ' Et=', MovedTrack%p%fm%p(4), ' chg=',
     *                MovedTrack%p%charge
         call cerrorMsg(msg,0)
      endif

      end
!     ********************
      subroutine cinteKaon
!     ********************
      use modXsecMedia
      implicit none
!----      include 'Ztrack.h'
#include  "Ztrack.h"
!----      include 'Ztrackv.h'
#include  "Ztrackv.h"
!----      include 'Ztrackp.h'
#include  "Ztrackp.h"
!
      character*70 msg

      if(IntInfArray(ProcessNo)%process .eq. 'coll') then
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call ckaonDecay(MovedTrack%p, IncMuonPolari, 
     *           Pwork, Nproduced, MuonPolarization)
      else
         write(msg, *) ' in cinteKaon: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteDmes
!     ********************
      use modXsecMedia
      implicit none

!----      include 'Ztrack.h'
#include  "Zcode.h"
#include  "Ztrack.h"
!----      include 'Ztrackv.h'
#include  "Ztrackv.h"
!
      character*70 msg
      integer icg
      icg =  MovedTrack%p%charge
      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cdDecay(MovedTrack%p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'coll') then   
!            use kaon 
         if(icg .eq. 0) then
            call cmkptc(kkaon, k0l, 0, MovedTrack%p)
         else
            call cmkptc(kkaon, 0, icg, MovedTrack%p)
         endif
         call ce2p(MovedTrack)
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      else
         write(msg, *) ' in cinteDmeson: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteHeavy
      use modXsecMedia
!     ********************
      implicit none
#include  "Zcode.h"      
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"

!
      character*70 msg

      if(IntInfArray(ProcessNo)%process .eq. 'coll') then
         call cheavyInt(MovedTrack%p, TargetNucleonNo,
     *         TargetProtonNo,  Pwork, Nproduced)
      else
         write(msg, *) ' in cinteHeavy: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteMuon
      use modXsecMedia
!     ********************
      implicit none

!----      include 'Ztrack.h'
#include  "Ztrack.h"
!----      include 'Ztrackv.h'
#include  "Ztrackv.h"
!----      include 'Zlife.h'
#include  "Zlife.h"
#include  "Ztrackp.h"
      real*8  capr, t0cap, u1, u2

!
      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
!           see if negative muon is being captured
         if(MovedTrack%p%charge .eq. -1) then
            if(MovedTrack%p%fm%p(4) .le. MovedTrack%p%mass*1.001) then
!                   assume stopping muon
               call cgetCaprate( media(mediumNo) )  ! v7.640
!               call cmucap(TargetNucleonNo, TargetProtonNo, capr)
               capr = media(mediumNo)%xs
               t0cap = 1./capr
               call rndc(u1)
               call rndc(u2)
               if( - log(u1)*t0mu .gt. - log(u2)*t0cap) then
!                     capture
                  call cfixTarget( media(mediumNo) )
                  call ccapnu(TargetNucleonNo, TargetProtonNo,
     *               Pwork, Nproduced)
               else
!!!!              MuonPolarization = 0.   ! stopping mu has no pol.
!                                          keep the value ;it's better.
                  call cmuNeuDcy(MovedTrack%p, MuonPolarization, 
     *            Eabsorb(1),   Pwork, Nproduced)
               endif
            else
               call cmuNeuDcy(MovedTrack%p, MuonPolarization,
     *            Eabsorb(1),   Pwork, Nproduced)
            endif
         else
            call cmuNeuDcy(MovedTrack%p, MuonPolarization,
     *            Eabsorb(1),   Pwork, Nproduced)
         endif
      else
         call cmuInte
      endif
      end
      subroutine csetMuonPol(val)
!         This may be used when you set muon as a primary for which
!        polarization is not fixed.
!
      implicit none
#include  "Ztrack.h"
#include "Ztrackv.h"
      real*8 val
      MuonPolarization =min(1.d0, max(val, -1.d0 ))
      end
!     ********************
      subroutine cintennb
!     ********************may be used if 1ry is nn~
      implicit none
      
!----      include 'Ztrack.h'
#include  "Ztrack.h"
!----      include 'Ztrackv.h'
#include  "Ztrackv.h"
!
      character*70 msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cnnbdc(MovedTrack%p,  Pwork, Nproduced)
      else
         write(msg, *) ' in cintennb: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call  cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteddb
!     ********************may be used if 1ry is dd~
      implicit none
      
!----      include 'Ztrack.h'
#include  "Ztrack.h"
!----      include 'Ztrackv.h'
#include  "Ztrackv.h"
!
      character*70  msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cddbdc(MovedTrack%p,  Pwork, Nproduced)
      else
         write(msg, *) ' in cintennb: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteSigma
!     *****************
      use modXsecMedia
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
!

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call csigmaDecay(MovedTrack%p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
!     ********************
      subroutine cinteLambda
!     ****************
      use modXsecMedia
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
!

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call clambdaDcy(MovedTrack%p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
!     ********************
      subroutine cinteGzai
!     *****************
      use modXsecMedia
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
!

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cgzaiDecay(MovedTrack%p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
!     ********************
      subroutine cinteBomega
!     *****************
      use modXsecMedia
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
!

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cbomegaDcy(MovedTrack%p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
!     *******************
      subroutine cinteEta
!     *****************
      use modXsecMedia
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
!

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cetaDecay(MovedTrack%p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
!     ********************
      subroutine cinteLambdac
!     ********************
      use modXsecMedia
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zcode.h"
!
      character*80 msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call clambdacDcy(MovedTrack%p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'coll') then   
!            use proton or p-bar
         if( MovedTrack%p%charge > 0 ) then
            call cmkptc(knuc, -1, 1, MovedTrack%p)
         else
            call cmkptc(knuc, 1, -1, MovedTrack%p)
         endif
         call ce2p(MovedTrack)
         call chAcol(MovedTrack%p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      else
         write(msg, *) ' in cinteLambdac: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinterho
!     *******************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
!
      character*80 msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call crhodc(MovedTrack%p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'coll') then   
         Nproduced = 0     ! neglect coll.
      else
         write(msg, *) ' in cinterho: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cinteomega
!     *******************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
!
      character*80 msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call comgdc(MovedTrack%p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'coll') then   
         Nproduced = 0     ! neglect coll.
      else
         write(msg, *) ' in cinteomega: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
!     ********************
      subroutine cintephi
!     *******************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
!
      character*80 msg

      if(IntInfArray(ProcessNo)%process .eq. 'decay') then
         call cphidc(MovedTrack%p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo)%process .eq. 'coll') then   
         Nproduced = 0     ! neglect coll.
      else
         write(msg, *) ' in cintephi: process=',
     *           IntInfArray(ProcessNo)%process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
