!     ******************************************************************
!     *                                                                *
!     * cdecayLeng: samples decay length of a given particle
!     *                                                                *
!        samples decay length of a particle.
!        
!        For a charged particle, we consider the change of the life
!     time due to the energy change by ionization loss.

      subroutine  cdecayLeng(aTrack, length)
      implicit none

!              constants thru Cosmos
            real*8 pi,          !  3.14..
     *             sqrtpi,      !  sqrt(pi)
     *             Torad,       !  if multiplied to deg  --> radian
     *             Todeg,       !  1/Torad
     *             c,           !  light velocity m/sec
     *             Infty,       !  infinty
     *             Togpcm2,     !  kg/m2 *Togpcm2 --> g/cm2
     *             Tokgpm2,     !  g/cm2 *Tokgpm2    --> kg/m2
     *             Tom,         !  cm *Tom  --> m
     *             Tocm,        !  m*Tocm  --> cm
     *             Tokgpm3,     !  g/cm3 * Tokgpm3 -->  kg/m3
     *             Togpcm3,     !  kg/m3 * Togpcm3 --> g/cm3
     *	           Tonsec,      !  sec *Tonsec --> nsec 
     *             Bcr,         !  Tesla. m^2c^3/eh = 4.414x10^13G=4. x10^9
     *             SyncConvR    !  alpha(mc^2/Lc). GeV/m. conv. rate of synch.r
       real*8 Avogn,            ! Avogadro #. /mol
     *        A2deninv          ! mfp * n* xs = 1;  mfp in kg/m2
                                ! xs in mb.  1/n = A2deninv*A  


        parameter(pi = 3.141592653589793238d0, 
     *    sqrtpi = 1.772453850905516d0, Torad = pi/180.d0, 
     *    Todeg = 180.d0/pi, c=2.998d8, Infty=1.d50, Tom = 1.d-2,
     *    Tocm = 1.d0/Tom,
     *    Togpcm2 = 0.1d0, Tokgpm2 = 1.d0/Togpcm2,
     *	  Tokgpm3 = Tokgpm2/Tom, Togpcm3 = 1.d0/Tokgpm3,
     *    Tonsec = 1.d9, Bcr = 4.414d9, SyncConvR=9.657d6)
       parameter (Avogn=6.0221415d23, A2deninv = 1.d28/Avogn)




  

!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************



!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)

!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3


!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence




                  real*8 p(4)

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence




                  real*8 r(3)

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)




                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  





      type(track)::aTrack ! input%a  track of a decaying particle
      real*8  length  ! output. length to wthich the decay takes place (m).

      real*8 g, u,  gbeta, dedt, dedl, ctau, rho
      real*8 a, x, p, gmin, ctaumax, pmin, cvh2den
      type(fmom)::gb

      data gmin/200.d0/, ctaumax/50.d0/, pmin/10.d0/

      if(aTrack%p%fm%p(4) .le. aTrack%p%mass) then
         length = 0.
         return   ! *******
      endif

      call cgetctau(aTrack%p, ctau)
      if(ctau .eq. Infty) then
         length = Infty
      else
         g = aTrack%p%fm%p(4)/aTrack%p%mass
         if(g .gt. gmin) then
            call rndc(u)
            length = - ctau* g *log(u)
         else
            call cgetlf(aTrack%p, gb)
            gbeta = sqrt(gb%p(1)**2 + gb%p(2)**2 + gb%p(3)**2)
            if(aTrack%p%charge .eq. 0 .or. ctau .lt. ctaumax) then
               call rndc(u)
               length = - ctau * gbeta * log(u)
            else
               rho = cvh2den(aTrack%pos%height)
               call cdedxInAir(aTrack%p, rho, dedt) ! dedt in GeV/(kg/m^2)
               dedl= dedt*rho   !    GeV/m
               a = dedl/aTrack%p%fm%p(4) ! 1/m
               p =1.0d0/( a * ctau * g )
               if( p .gt. pmin) then
                  call rndc(u)
                  length = - ctau* gbeta *log(u)
               else   
                  call cdecayWEL(p, g, x)
                  length =(1.0d0 -  x/g)/a
               endif
            endif
         endif
      endif
      end

