#!/bin/bash
GetAtmosModelandNum() {
        # $atmosmodel and $atmosnum are abtained
    GetAtmosModel
    GetATMOSPHEREnum
    return
}
GetAtmosModel () {
 source setarch.sh
 NRL=`nm $COSMOSTOP/lib/$ARCH/libcosmos.a 2>/dev/null | grep  cnrlgendata | awk 'NR>1 {exit};{print $1}'` 
 if [ -z $NRL ]; then
   atmosmodel=2  
   return 
 else
   atmosmodel=3   
   return 
 fi
}
ShowAtmosModel() {
    GetAtmosModelandNum
    #    if [ $? -eq 0 ]; then
    echo " "
    if [ $atmosmodel -eq 3 ]; then
	echo "Current atmosphere model # is " 
	echo "3: NRL atmosphere model"
    else
	echo "Current atmosphere model is"
	echo "      Standard one with  model #"
	if [ $atmosnum -eq 2 ]; then
	    echo "2: segmented default setup "
	elif [ $atmosnum -eq 1 ]; then
	    echo "1: cubic spline setup"
	elif [ $atmosnum -eq 0 ]; then
            echo "0: old segmented setup"
        else
            echo "Invalid ATMOSPHERE:" $atmosnum
	    echo "forced to be 2"
	    atmosnum=2
        fi	    
    fi
    return 
}
    
GetATMOSPHEREnum () {
  atmosnum=`awk '$1=="#define" && $2=="ATMOSPHERE" {print $3;exit}' $COSMOSTOP/cosmos/Zcondc.h`
  return
}
ShowATMOSPHEREnum() {
    GetATMOSPHEREnum
    #    echo "#define ATMOSHERE " $?
    echo "#define ATMOSHERE " $atmosnum
    echo "is given in $COSMOSTOP/cosmos/Zcondc.h"
    return  0
}
UsageStandAtmos () {
    GetAtmosModelandNum
    if [ $atmosnum -lt 3 ]; then
	cat <<EOF
          Current model is standard, you need not do
          anything (But keep AtmosFile=" " in \$HPARAM of
          the param  file).
EOF
	return
    elif [ $atmosnum -eq 3 ]; then
	cat <<EOF
          Current 
          You have to change the current atmospheric model
          to standard by using this script again and remake
          the library.

          Then, make your application, 
          (Be sure AtmosFile=" " in \$HPARAM of your param
          file.)
EOF
	return
    else
        source setarch.sh
	cat <<EOF
          Current setting in Zcond.c is OK for standard atmosphere
          but the library is not yet for the standard.
          You have to 
             rm $COSMOSTOP/lib/$ARCH/libcosmos.a
          and 
             make veryclean; make
           at $COSMOSTOP  
EOF
    fi	
    return
}

ShowNRLUsage () {
 cat <<EOF
   You have to specify either of
      1) NRL_period   
    or
      2) AtmosFile
   in the  param file (\$HPARAM) of your application. 
   Using 1) is recomended.  The format in the Namelist is
  
     NRL_period=day1, day1, hour1, hour2

   where day1, day2: 1~365 (1 is Jan.1 365 Dec.31).
   if day1 > day2, the period straddls Dec. to Jan.

   hour1, hour2: 0~23 (0 is midnight, 12 noon) 
   They specify  hours in each day of day1 to day2.
   If hour1 > hour2, the hours straddle the midnight.
   
   Atmospheric constants are calculated by taking the
   average over a number of points sampled in the given period.
   The boundary days and hours are always employed. A table is made
   and used for further calculaiton inside Cosmos.
   Several seconds would be needed to make such a table,
   if the period covers the day and night of the whole year.

   In some case, the user may want to use 2) above.  In that case,
   AtmosFile must be given and NRL_period is neglectd. The file 
   specified by AtmosFile is understood as the path 
   to a file where the NRL data is written. (NRL_period is
   also in the file). 
     Two examples are

   $COSMOSTOP/Data/Atmos/NRLAtmosWholeYear.d
     and
   $COSMOSTOP/Data/Atmos/NRLAtmos.d

   E.g you may give AtmosFile="\$COSMOSTOP/Data/Atmos/NRLAtmos.d".

   The former is the  averge of the whole year.
   The latter is for night time in Jan to March.  Both for
   @ middle part of Japan (latitude 32, longitude 138 degrees).
   You must give the same values to LatitOfSite and  LongitOfSite
   in the namelist input (within 1 and 2 deg diff.  respetively)
   
   The user can find a utility in 
        $COSMOSTOP/Import/NRL/Util/
   to make such  an input file specifiable in AtmosFile.
   It also  makes a table of
     height  density depth ..              temperature

   These may be used to make and see graphs, e.g, depth vs height.
EOF
}

UsageNRLAtmos () {
    GetAtmosModelandNum
    if [ $atmosnum -eq 3 ] && [ $atmosmodel -eq 3 ]; then
	echo "Setup is ready for NRL atmosphere." 
        ShowNRLUsage
    else
      cat <<EOF
      Current model is not NRL model.
      Note: To use NRL atmosphere,
	    You have to re-make the library.  
            To do so, call this script again.
      At any rate, do you want to see the Usage of NRL atmosphere?
      Enter yes, if so
EOF
      read yes
      if [ -z $yes ]; then
	  return
      elif [ $yes == "yes" ]; then
	  ShowNRLUsage
      fi
    fi  
    return
}

ToNRLAtmosModel (){
   source setarch.sh
   awk '$1=="#define" && $2=="ATMOSPHERE" {$3=3};{print}' $COSMOSTOP/cosmos/Zcondc.h > temp$$
   mv  $COSMOSTOP/cosmos/Zcondc.h  $COSMOSTOP/cosmos/Zcondc.hSave 
   mv temp$$ $COSMOSTOP/cosmos/Zcondc.h 
 #  (cd $COSMOSTOP/; rm -f $COSMOSTOP/lib/$ARCH/libcosmos.a;  make veryclean; make )
   (cd $COSMOSTOP/Manager;  make veryclean; make )
   (cd $COSMOSTOP/Atmosphere;  make veryclean; make )
  ShowAtmosModel
 }

ToSTDAtmosModel (){
   source setarch.sh
   awk '$1=="#define" && $2=="ATMOSPHERE" {$3=num};{print}' num=$modelnum $COSMOSTOP/cosmos/Zcondc.h > temp$$
   mv  $COSMOSTOP/cosmos/Zcondc.h  $COSMOSTOP/cosmos/Zcondc.hSave 
   mv temp$$ $COSMOSTOP/cosmos/Zcondc.h 
   #  (cd $COSMOSTOP/; rm -f $COSMOSTOP/lib/$ARCH/libcosmos.a;  make veryclean; make )
   (cd $COSMOSTOP/Manager;  make veryclean; make )
   (cd $COSMOSTOP/Atmosphere;  make veryclean; make )
  ShowAtmosModel
}

ChangeAtmosModel() {
    ShowAtmosModel
    echo " "
    echo "model # "
    echo "3:  NRL location-time dependent atmosphere"
    echo "2:  standard atmosphere with segmented setup"
    echo "1:  standard atmosphere with cubic spline setup"
    echo "0:  old standard atmosphere "
    echo " "
    echo "Enter #  (0-3); 0 or 1 is for special purpose"
    echo "                2 is default at installation time"
    read modelnum
    
    if [ -z $modelnum ]; then
	return
    elif [ $modelnum -eq  $atmosnum ]; then
	echo  "Current model is already #=" $atmosnum
        echo  "So nothing to do"
	return
    elif [ $modelnum -gt 3 ] || [ $modelnum -lt 0 ]; then
	return
    fi	
    if [ $modelnum -eq 3 ]; then
	echo "Change to  the NRL atmospheric model ?"
	echo "Enter yes, if yes"
	read toNRL
	if [ -z $toNRL ]; then
	    return
        fi
	if [ $toNRL == 'yes' ]; then
	    ToNRLAtmosModel
        fi
    else
	echo "Change to the standard atmospheric model "
	echo "with #=" $modelnum
	echo "Enter yes, if yes"
	read toSTD
	if [ -z $toSTD ]; then
	    return
        fi
	if [ $toSTD == 'yes' ]; then
	    ToSTDAtmosModel
        fi
    fi
    cat <<EOF
      Note: The library has been updated. But your application
            must be rebuilt at your application folder
            by make veryclean; make
        In parm file, basically  keep AtmosFile=" " 
EOF
    if [ $modelnum -eq 3 ]; then
	cat <<EOF
         but for NRL model,  NRL_period must be given "
EOF
    fi
    echo "For more details, use this script again"
    return
}


#----------------- main --------------

if [ "$COSMOSTOP" == "" ]; then
    echo "Env. variable COSMOSTOP is empty"
    exit
fi

ShowAtmosModel
cat <<EOF
    
    1) Show the usage of the standard atmosphere
    2) Show the usage of the NRL time/place dependent atmosphere
    3) Change the atmospheric model
other) exit
    Select a number  
EOF
read num
if [ -z $num ]; then
    exit
fi


if [ $num -eq 1 ]; then
  UsageStandAtmos
elif [ $num -eq 2 ]; then
  UsageNRLAtmos
elif [ $num -eq 3 ]; then
    ChangeAtmosModel
elif [ $num -eq 4 ]; then
    exit
else 
  echo your input $num invalid
fi
exit
