!        gp  xsection
      subroutine cgpxs1(Eg, xs)
      implicit none
#include "Zmass.h"
      real*8 Eg  ! input.  momentum /Energy of gamma in GeV
      real*8 xs     ! output. total np cross section in mb
      integer np, i, m
      real*8  error, s, rts
      
      real*8 delta, s0, Z, Y1, eta1, B
      parameter( delta = 0.00308,  s0=5.38**2,  Z = delta*35.45,
     *   Y1 =0.0317,  eta1 = 0.458,  B = delta*0.308)
      
      parameter (np=66, m=5)
      real*8  roots(np), mb(np)
           data ( roots(i), i=           1 ,           np )/
     1   1.0705    ,  1.1016    ,  1.1256    ,  
     2   1.1501    ,  1.1625    ,  1.1878    ,  1.2049    ,
     3   1.2179    ,  1.2355    ,  1.2534    ,  1.2715    ,
     4   1.2898    ,  1.3179    ,  1.3274    ,  1.3369    ,
     5   1.3660    ,  1.3758    ,  1.4158    ,  1.4570    ,
     6   1.4887    ,  1.5431    ,  1.5823    ,  1.6167    ,
     7   1.6518    ,  1.6877    ,  1.7121    ,  1.7306    ,
     8   1.7556    ,  1.7873    ,  1.8460    ,  1.9133    ,
     9   1.9761    ,  2.0046    ,  2.0778    ,  2.1769    ,
     a   2.2563    ,  2.3981    ,  2.5672    ,  2.7187    ,
     b   2.9208    ,  3.1718    ,  3.4692    ,  3.7809    ,
     c   4.1801    ,  4.6049    ,  5.1094    ,  5.8132    ,
     d   6.6377    ,  7.6611    ,  8.7165    ,  9.7759    ,
     e   11.243    ,  13.070    ,  15.468    ,  17.917    ,
     f   20.239    ,  23.360    ,  26.865    ,  32.956    ,
     g   39.995    ,  52.520    ,  68.968    ,  93.871    ,
     h   116.40    ,  151.76    ,  199.28                               
     * /   
           data ( mb(i), i=           1 ,           np )/
     1  0.34130E-01, 0.79199E-01, 0.11944    , 
     2  0.25327    , 0.33197    , 0.45290    , 0.52636    ,
     3  0.56460    , 0.51589    , 0.43072    , 0.32208    ,
     4  0.25321    , 0.20721    , 0.18008    , 0.16455    ,
     5  0.18372    , 0.20513    , 0.22674    , 0.25316    ,
     6  0.27704    , 0.25313    , 0.22670    , 0.21133    ,
     7  0.22442    , 0.23831    , 0.21130    , 0.19308    ,
     8  0.17642    , 0.16282    , 0.15958    , 0.16280    ,
     9  0.16117    , 0.15483    , 0.14725    , 0.14288    ,
     a  0.14003    , 0.13451    , 0.13316    , 0.13050    ,
     b  0.12789    , 0.12533    , 0.12657    , 0.12529    ,
     c  0.12278    , 0.12154    , 0.12030    , 0.11907    ,
     d  0.11904    , 0.11901    , 0.11779    , 0.11777    ,
     e  0.11774    , 0.11537    , 0.11418    , 0.11530    ,
     f  0.11879    , 0.12116    , 0.12235    , 0.12478    ,
     g  0.12726    , 0.13108    , 0.13501    , 0.14186    ,
     h  0.14468    , 0.15357    , 0.15977                               
     * /   

      save    
!      s = (E+Mp)^2-E^2 = 2EMp+Mp^2
      s = (2*Eg+masp)*masp
      rts = sqrt(s)
!//////
!      write(*,*) Eg, s, rts
!/////////
      if( rts .lt. 1.08) then
         xs = 0.
      elseif(rts .lt. 15.) then
         call
     *    kpolintplogxyFE(roots, 1, mb, 1, np, m, 3, rts, xs, error) 
      else
         xs = Z + B*log(s/s0)**2 + Y1*(1./s)**eta1
      endif
      end
!c          These are x-sections near threshold. 
!       implicit none
!       real*8 e, eg, xs
!
!c           to test cgppi0, cgppip, cgppi2, cgppi3
!       do  e=2.2, 3.7, .02
!          eg = 10.**e/1000.
!          call cgppi0(e, xs)
!          write(*, *) eg, xs
!       enddo
!       write(*, *)
!       do e=2.2, 3.7, .02
!          eg = 10.**e/1000.
!          call cgppip(e, xs)
!          write(*, *) eg, xs
!       enddo
!       write(*, *)
!       do e=2.2, 3.7, .02
!          eg = 10.**e/1000.
!          call cgppi2(e, xs)
!          write(*, *) eg, xs
!       enddo        
!       write(*, *)
!       do  e=2.2, 3.7, .02
!          eg = 10.**e/1000.
!          call cgppi3(e,  xs)
!          write(*, *) eg, xs
!       enddo
!       end
        subroutine cgppi0(egl10, xs)
!        egl10: input. log10(Eg/MeV)
!           xs: output. xsection in micro-barn for gp-->p+pi0
        implicit none
        real*8  xs, egl10
        integer i
        real*8 xs1(107), xs2(100), xs3(109), xs4(92)
!            log10(Eg/MeV) range step 0.01
      real*8  e11/2.2328224/,   e12/3.2981243/, eps/1./
      real*8  e21/2.3053560/,  e22/3.2981243/
      real*8 e31/2.6146288/,  e32/3.7040262/
      real*8 e41/2.8246450/

!
!            gp-->ppi0
       data ( xs1(i),i=   1,  72)/
     1    0.0,    2.4,    5.8,    8.9,   11.6,   12.8,   13.6,   14.4,
     2   17.2,   20.9,   25.3,   30.3,   35.9,   42.4,   48.5,   53.4,
     3   60.9,   71.8,   85.8,  120.9,  150.4,  204.4,  224.5,  241.6,
     4  251.3,  252.4,  248.9,  233.7,  210.9,  196.1,  186.7,  170.5,
     5  155.6,  145.1,  140.3,  134.9,  124.5,  111.0,  100.6,   91.3,
     6   86.8,   77.9,   66.8,   55.4,   46.5,   41.0,   40.0,   39.5,
     7   40.0,   40.4,   40.8,   41.2,   41.6,   42.0,   42.8,   41.7,
     8   40.3,   38.8,   37.3,   35.5,   34.2,   33.5,   32.7,   32.8,
     9   32.4,   32.0,   31.6,   31.2,   30.6,   30.0,   29.7,   28.9/
       data ( xs1(i),i=  73, 107)/
     1   27.9,   26.7,   25.3,   23.4,   21.8,   20.3,   18.8,   16.8,
     2   15.4,   14.2,   13.2,   12.3,   11.9,   11.2,   10.5,    9.8,
     3    9.0,    8.0,    7.3,    6.8,    6.2,    5.7,    5.3,    4.8,
     4    4.8,    4.7,    4.7,    4.7,    4.5,    4.1,    4.0,    2.5,
     5    1.2,    0.7,    0.7/
!

!            gp-->npi+
      data ( xs2(i),i=   1,  72)/
     1    0.0,   59.9,   82.4,  105.5,  127.1,  147.2,  160.8,  166.5,
     2  175.5,  185.1,  191.6,  194.8,  197.7,  200.1,  201.8,  203.0,
     3  203.2,  203.4,  202.3,  198.6,  195.0,  193.8,  190.1,  159.7,
     4  152.0,  143.0,  130.8,  119.4,  109.8,  101.7,   92.2,   81.5,
     5   73.8,   67.7,   64.9,   61.5,   58.4,   56.5,   56.5,   59.2,
     6   62.0,   64.1,   68.6,   76.9,   84.7,   90.1,   93.4,   96.1,
     7   97.6,   98.0,   97.3,   97.0,   96.0,   94.7,   93.0,   91.0,
     8   88.8,   86.4,   83.6,   80.6,   78.0,   74.3,   69.7,   63.7,
     9   58.1,   52.8,   47.4,   43.3,   41.2,   38.2,   35.0,   31.2/
      data ( xs2(i),i=  73, 100)/
     1   28.3,   25.7,   23.6,   22.1,   20.5,   19.1,   18.5,   17.3,
     2   16.0,   14.6,   12.8,   11.6,   10.6,    9.8,    9.2,    8.7,
     3    8.7,    8.7,    8.6,    8.6,    8.2,    7.5,    6.9,    6.2,
     4    5.7,    4.6,    3.2,    1.3/
!
!          gp-->ppi+pi-
      data ( xs3(i),i=   1,  72)/
     1    0.0,    0.7,    3.0,    5.7,    8.9,   12.9,   16.6,   21.1,
     2   23.0,   30.9,   44.3,   50.9,   57.5,   63.4,   67.4,   69.9,
     3   70.7,   71.3,   72.6,   72.4,   72.4,   71.6,   70.3,   68.5,
     4   67.4,   66.4,   65.3,   64.3,   63.3,   62.3,   61.2,   60.2,
     5   59.1,   58.0,   56.9,   55.8,   54.8,   53.8,   52.9,   51.9,
     6   51.0,   50.0,   49.4,   48.4,   47.4,   46.4,   45.4,   44.3,
     7   43.2,   42.2,   40.7,   39.6,   38.5,   37.5,   36.4,   35.4,
     8   34.4,   33.4,   32.4,   31.4,   30.4,   29.4,   28.5,   27.6,
     9   26.7,   25.8,   24.9,   24.0,   22.3,   21.5,   20.7,   20.1/
      data ( xs3(i),i=  73, 109)/
     1   19.5,   19.1,   19.2,   19.3,   19.4,   19.9,   19.6,   19.7,
     2   19.8,   20.0,   19.8,   19.7,   19.1,   18.8,   18.5,   18.3,
     3   18.0,   17.8,   17.6,   17.1,   16.9,   16.8,   16.7,   16.9,
     4   17.1,   17.4,   17.8,   18.2,   18.8,   19.4,   20.4,   21.1,
     5   21.8,   22.4,   23.0,   23.5,   23.9/
!

!                          e42/3.7369471/
!          gp-->ppi+pi- x (x=pi+,pi-,,,)
      data ( xs4(i),i=   1,  72)/
     1    0.0,    2.6,    5.6,    8.7,   11.8,   14.9,   18.1,   21.2,
     2   24.4,   28.2,   31.1,   34.0,   36.7,   39.2,   41.6,   43.9,
     3   45.9,   48.0,   50.1,   52.0,   53.9,   55.6,   57.3,   58.4,
     4   60.0,   61.6,   63.2,   64.7,   66.2,   67.6,   68.8,   70.2,
     5   71.6,   73.0,   74.4,   75.8,   77.2,   77.9,   79.3,   80.7,
     6   82.3,   84.0,   85.9,   87.8,   89.9,   93.2,   95.4,   97.4,
     7   99.3,  101.2,  103.0,  104.6,  106.7,  108.0,  109.2,  109.9,
     8  110.3,  111.7,  112.0,  112.3,  111.9,  112.3,  112.3,  112.0,
     9  111.6,  110.9,  110.1,  109.2,  108.2,  107.0,  105.7,  104.0/
      data ( xs4(i),i=  73,  92)/
     1  102.5,  100.9,   99.3,   97.6,   95.7,   93.9,   92.1,   90.3,
     2   88.5,   86.1,   84.4,   82.8,   81.4,   81.1,   80.3,   79.1,
     3   77.7,   75.9,   73.9,   71.6/
!
        goto 10
!     **********************
      entry cgppip(egl10, xs)
!     **********************
        goto 20
!     **********************
      entry cgppi2(egl10, xs)
!     **********************
        goto 30
!     **********************
      entry cgppi3(egl10, xs)
!     **********************
        goto 40
!

   10 continue
        if(egl10 .lt. e11) then
           xs=0.
        elseif(egl10 .lt. e12) then
           call kintp3(xs1, 1, 107, e11, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
!
   20   continue
        if(egl10 .lt. e21) then
           xs=0.
        elseif(egl10 .lt. e22) then
           call kintp3(xs2, 1, 100, e21, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
!
   30   continue
        if(egl10 .lt. e31) then
           xs=0.
        elseif(egl10 .lt. e32) then
           call kintp3(xs3, 1, 109, e31, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
!
   40   continue
        if(egl10 .lt. e41) then
           xs=0.
        else
           call kintp3(xs4, 1, 92, e41, 0.01d0, egl10, xs)
        endif
       end
