      subroutine cQGSjet(pj, iat, iz,  a, ntp)
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
!        masddb and masnnb are the minimum value.

! ------------------------
      type(ptcl)::pj  ! input .projectile
      integer iat  !  input target mass number
      integer iz     ! input. charge no. of target
      integer ntp    ! output%produced ptcls number
      type(ptcl):: a(*)  ! produced ptlcs' a(ntp)
      type(ptcl):: ldcy(2)
      real*8 xs
      integer ngen, i, ngen2
!   if  next is 1:  at collision point forced decay and decay prod
!                   is made to collide
!               2:  collision is manage by dpmjet3
!               3:  collision is replaced by proton. 

      if(pj%code .eq. klambda) then

!           regard it as neutron
      call cmkptc(knuc, -1, 0, pj)
      call cadjm(pj, pj)
      call cxsecQGS( pj, iat,   xs )
      call cQGSjet0( pj, iat, iz, a, ntp)


      elseif( pj%code .eq. ksigma .or. pj%code .eq. kgzai
     * .or. pj%code .eq. kbomega) then
!        althogh qgsjet dose not generate sigma and gzai, bomega
!        klambda treatment above generates these; 
!          eventuall they will be treated by ad-hoc.
!          bomega is very rare 1 or 2 during one 10^20 eV proton event
         call cdpmjet(pj, iat, iz,  a, ntp)
      elseif( pj%code .eq. keta) then
!          same as above; but use ad-hoc
!                  at Ultra H.E, eta may collide.
         call chAcolAdhoc(pj, iat, iz, a, ntp)
      else
!          intrinsic qgsjet2
         call cQGSjet0(pj, iat, iz, a, ntp)
      endif
      end

      subroutine ciniQGS
      implicit none

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   Parameters   needed  for the Launcher.
!
!	(->	------------------------------------

         integer ErrorOut    !2 Error output logical  dev number.
         character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
         character*128  CutOffFile   !1  Geomagnetic cut-off file
         character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
         character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
         character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
                                    !   Cosmos/Data/DPM/atmos.inp is assumed.  
         character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
         logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
         integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
         integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
         integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
         integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
         logical       Hidden         !1  Make T, if hidden parameters are to be written.
         integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
         integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
         character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'
                                   ! Normally  this may be blank. Then, standard atmosphere
                                   ! is employed.  If another data with the same format
                                   ! atmosphere model is available, it can be specified.
                                   !  If ATMOSPHERE is set to 3 in Zcondc.h, and AtmosFile
                                   !  is blank, you have to set NRL_period (see, for period,
                                   !  Cosmos/Import/NRL/Util/ or manual for NRL atmosphere). 
                                   !  latitude and longitude information is also used.  
                                   ! If AtmosFile is given, it is assumed NRL format
                                   ! atmosphere data and it is used.
                                   ! For such NRL data, see also Cosmos/Import/NRL/Util/
        integer:: NRL_period       !2 see Cosmos/Import/NRL/Util or manual for NRL atmsophere
        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


!	<-)	-------------------------------------
         common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), NRL_period(4),
     *  Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
!        masddb and masnnb are the minimum value.

!  #include "Zair.h"
!           dummy ptcl and target for init
      type(ptcl)::pj  !  dummy projectile
      integer ia  !  target mass number
      integer iz     ! charge no. of target
      integer ntp    ! output%produced ptcls number
      type(ptcl):: a(100)  ! produced ptlcs' a(ntp)


      integer debug      
      common /debug/   debug  ! this is for 03; 04 uses /qgdebug/
      integer moniou
      common /qgarr43/ moniou

      logical  first
      save first
      integer iseq, j
      integer iseed(103,10)
      character*120 file1, file2
      real*8 u, xs

      data first /.true./


      if( first ) then
         moniou = ErrorOut      !set output channel (6-default)
         call cqQGSfile(file1, file2)
         iseq=1                 !set random sequence&seed
         call rndc(u)
         iseed(1,iseq)=int(u*1.e7)
         call rndc(u)
         iseed(2,iseq)=int(u*1.e7)
         iseed(3,iseq)=0
         call rmmaq( iseed(1,iseq), iseq, 's' )
         call rmmaq( iseed(1,iseq), iseq, 'r' )
         write(moniou,*) 'qgsjetII-03 rn seed ',
     *      iseq,(iseed(j,iseq),j=1,3)
         call qgset             !set model parameters
         debug=0                !set debugging level (1-default) 
         call qgaini            !initialize QGSJET-II
!             dummy collision for init. without this,
!          first event will be biased. (why?)
         call cmkptc(knuc, -1, 1, pj)
         pj%fm%p(1)=0.
         pj%fm%p(2)=0.
         pj%fm%p(3)=1000.
         pj%fm%p(4)=sqrt(pj%fm%p(3)**2 + pj%mass**2)
!         ia = TargetMassN
!         iz = TargetAtomicN
         ia = 14
         iz = 7
         call cxsecQGS(pj, ia, xs)
         call cQGSjet0( pj, ia, iz, a, ntp)
         if(ntp .gt. 100) then
            write(0,*) ' too many ptcls at init of qgs2'
            stop
         endif
         first = .false.
      endif
      end
!     **********************************
      subroutine cqQGSfile(file1, file2)
!        check if data files exist for QGSJetII
      implicit none
      character*120  cosmostop
      character*(*) file1, file2
      integer kgetenv2, leng
      logical yes1, yes2 

      leng = kgetenv2("COSMOSTOP", cosmostop)
!      file1= cosmostop(1:leng)//"/Data/QGS/qgsdat-II-1"
      file1= cosmostop(1:leng)//"/Data/QGS/qgsdat-II-03.ascii"
      inquire(file =file1, exist=yes1) 
      if(.not. yes1) then
         call cerrorMsg(file1, 1)
         call cerrorMsg("Data for QGS shown above is missing", 0)
      endif
!      file2= cosmostop(1:leng)//"/Data/QGS/sectnu-II-1"
      file2= cosmostop(1:leng)//"/Data/QGS/sectnu-II-03"
      inquire(file =file2, exist=yes2) 
      if(.not. yes2) then
         call cerrorMsg(file2, 1)
         call cerrorMsg("Data for QGS shown above is missing", 0)
         if(.not. yes1) stop  99999
      endif
      end

      subroutine cxsecQGS( pj, iat,   xs )
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.


!               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
!        masddb and masnnb are the minimum value.


      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
!      real*8  ep, ebal
!    ****************** important *****
!    if you increase iapmax, changes are also needed in qgsjet and
!    207 in Epics/prog/epixsec.f 
      parameter(iapmax=209,nptmax=50000)
!      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.

      integer ntp    !  produced ptcls number
      type(ptcl):: a(*)  ! produced ptlcs' a(ntp)
! ------------------------
      type(ptcl)::pj  ! input .projectile

      integer ic

      integer iat  !  input target mass number
      real*8  e0n  !  output E0/N (for Nuc) or E0 (for had)
      integer icz   ! output  1ry class
      integer iap   ! output projectile mass number. (1 for had)
      integer icp   ! output projectile QGS code  (2 for heavy)


      real*8  xs    ! output  xsection in mb  

      integer iz     ! input. charge no. of target

      integer isf, i, is
      integer zfrag, mfrag
!       following are to be kept inside
      real*8  ke0n, qgsect  
      integer kicz 
      integer kiap 
      integer kicp 
      integer kiat
      integer check
      data check/0/
      save check

      save ke0n, kicz, kiap, kicp, kiat


      if( pj%code .ne. kgnuc ) then
         kiap = 1                !set proj. mass number (1-for hadron)
      else
         kiap = pj%subcode
      endif
      call ccoscode2QGS( pj, kicp )
      if(kicp .eq. 0) then
         xs = 1.d-30
      else
         ke0n = pj%fm%p(4)/kiap !to get energy per nucleon
         kiat = iat

         kicz=iabs(kicp)/2+1    !primary particle class (1- pion, 2 - nucleon, 3 - kaon)
         xs=qgsect(ke0n,kicz,kiap,kiat) !get particle production cross sectio
      endif
      check= 1
      return
!     *********************************
      entry cqQGSint( e0n, icz, iap, icp, iat )
!     *********************************
!        inquire current interacion conditions
!  
      e0n = ke0n
      icz = kicz
      iap = kiap
      icp = kicp
      iat = kiat
      return
!     ***********************************
      entry  cQGSjet0(pj, iat, iz,  a, ntp)
!     ***********************************

!      ebal(1)=e0n*iap+.939d0*iat           
!      ebal(2)=dsqrt(e0n**2-.939d0**2)*iap
!      ebal(3)=0.d0
!      ebal(4)=0.d0
!      aknn=0.d0
!      ach=0.d0
!       call rmmaq( iseed(1,iseq), iseq, 'r' )    !get random seed
!           check below will not be 0 but 1,   if projectile Xsection 
!           is calculable by cxsecQGS.  0 means special case 
!           where particles generated by qgsjet2 cannout use cxsecQGS
!           and qgsjet2 cannot be used for particle generation by
!           such a partilce
      if(check .eq. 0) then
!          now   should not come here
         write(0,*) ' check=0 in  qgsjet interface'
         write(0,*) ' pj=',pj%code,pj%subcode,pj%charge,pj%fm%p(4)
         stop
!         if(pj.code .eq. klambda) then
!            call chAcolAdhoc(pj, iat, iz, a, ntp)
!         elseif(pj.code .eq. keta) then
!                  at Ultra H.E, eta may collide.
!            call chAcolAdhoc(pj, iat, iz, a, ntp)
!         else           
!            write(0,*) ' check=0 in  qgsjet interface'
!            write(0,*) ' pj=',pj.code,pj.subcode,pj.charge,pj.fm.p(4)
!         endif
      endif
      if(check .eq. 1) then
         kiat = iat             ! may not be the same as iat from cxsecqgs

         call qgini( ke0n, kicp, kiap, iat) !initialize current interaction
         call qgconf            !inelastic interaction
!           next is projectile fragments
         ntp = 0
         do isf = 1, nsf        !loop over produced fragments
            mfrag = iaf(isf)    !fragment mass number
!!            zfrag = pj.charge*mfrag/kiap ! fragment charge
!!            Apr. 25, 2013
            call csetFragChg(kiap,  mfrag, zfrag) 
            ntp = ntp + 1
!                set this heavy in a
            if( mfrag == 1 ) then
               call cmkptc( knuc, regptcl, zfrag, a(ntp) )
            else
               call cmkptc(kgnuc, mfrag, zfrag, a(ntp))
            endif
            a(ntp)%fm%p(4) = ke0n*mfrag
         enddo
!          set fragment Pt
         call csampFragMom( a, ntp )
         do  is = 1, nsp        !loop over produced particles
            ntp = ntp + 1
            ic=ich(is)    
            call cQGScode2cos(ic, a(ntp))
            do i=1,4
               a(ntp)%fm%p(5-i)=esp(i,is) !particle 4-vector
            enddo 
         enddo
         check = 0
      endif
         
!     -------------- rotate so that we get the same coordinate as pj
       call crot3mom( pj, a, ntp ) 
       if( pj%code .eq. kpion .and. pj%charge .eq. 0) then
!            pi0 is projectile.  we have been using pi+/- as
!            projectile so we wil replace the leading particle by pi+/pi-
!            kicp =1 is pi+/ kicp=-1 is pi- so we regard it as charge of pi
          call cfindHighestPi( kicp, a, ntp, i )
          if(i .gt.  0) then
             call cmkptc( kpion, 0, 0, a(i) )
          endif
       endif
      end


      subroutine ccoscode2QGS(pj, icp)

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.

      type(ptcl):: pj  ! input. cosmos ptcl 
      integer icp       ! output. code for qgsjet

      real*8 u
      character*80 msg

      if(pj%code  .eq. kpion) then
         if(pj%charge .eq.  -1) then
            icp = -1
         elseif( pj%charge .eq. 1) then
            icp = 1
         else
!            pi0, first assign it to pi+ pr pi- and later replace the leading ptcl
!            by pi0
            call rndc(u) 
            if(u .lt. 0.5) then
               icp =1
            else
               icp =-1
            endif
         endif
      elseif(pj%code .eq.  knuc ) then
         if(pj%charge .eq. 1 ) then
            icp = 2
         elseif( pj%charge .eq. -1) then
            icp = -2
         else
            if(pj%subcode .eq. antip ) then
               icp = -3
            else
               icp = 3
            endif
         endif
      elseif(pj%code .eq. kkaon) then
         if(pj%charge .eq. 1) then
            icp = 4
         elseif( pj%charge .eq. -1) then
            icp = -4
         else
            if(pj%subcode .eq. antip) then
               icp = -5
            else
               icp = 5
            endif
         endif
      elseif( pj%code .eq. kgnuc ) then
         icp = 2
      elseif( pj%code .eq. kdmes ) then
         icp = 0
      else 
         write(msg,
     *   '("ptcl code=",i3," charge=",i3,"not supported in QGSII")') 
     *    pj%code, pj%charge
         call cerrorMsg(msg, 0)
      endif
!        set proj. type (-1 - pi^-, 1 - pi+,
!       -2 - p~, 2 - p, -3 - n~, 3 - n, -4 - k^-, 4 - k+, -5 - k0~, 5 - k0)
      end
      subroutine cQGScode2cos(icp, pj)
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.

      integer icp    ! input qgs code
      type(ptcl):: pj  ! output.  cosmos ptcl to get code

      integer  code, subcode, charge 

      character*80 msg

      if(icp .eq. -1) then
         code = kpion
          charge = -1
      elseif(icp .eq. 1) then
         code = kpion
         charge = 1
      elseif(icp .eq. 0 ) then
         code = kpion
         charge = 0
      elseif(icp .eq.  2 ) then
         code = knuc
         charge = 1
      elseif(icp .eq. -2) then
         code = knuc
         charge = -1
      elseif(icp .eq. 3) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(icp .eq. -3) then
         code = knuc
         charge = 0
         subcode = antip
      elseif( icp .eq. 4 ) then
         code = kkaon
         charge = 1
      elseif( icp .eq. -4) then
         code  = kkaon
         charge = -1
      elseif( icp .eq. 5 )  then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif( icp .eq. -5) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif( icp .eq.  -6) then
         code = klambda
         subcode = antip
         charge = 0
      elseif( icp .eq. 6 ) then
         code = klambda
         subcode = regptcl
         charge = 0
      elseif( abs(icp) .eq. 10 ) then
         code = keta
         subcode = 0
         charge = 0
      else
         write(msg,
     *   '("ptcl code from QGSII =",i3," is unknown")') 
     *    icp
         call cerrorMsg(msg, 0)
      endif
!          ((0 - pi0, -1 - pi^-, 1 - pi+,-2 - p~, 2 - p, -3 - n~, 3 - n,
!         -4 - k^-, 4 - k+, -5 - k0l, 5 - k0s, 6 - eta, -10 - lambda~, 10 - lambda)
      call cmkptc(code, subcode, charge, pj)
      end

      subroutine cfindHighestPi(chg, a, ntp, n)
!           find highest enrgy Pi+ (if chg =1)  of  Pi- (if chg=-1)
!     and return its index n
      implicit none

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
!                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
!                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      integer chg  !  input   incident is +  / or -
      integer ntp  ! input  total number of ptcls
      type(ptcl):: a(ntp)  ! input
      integer n   ! output  n-th ptcl is highest energy if 0, no ptcl

      integer i
      real*8 erg

      n = 0
      erg = 0.
      do i = 1, ntp
         if( a(i)%code .eq. kpion ) then
            if( a(i)%charge .eq. chg ) then
               if( erg .lt. a(i)%fm%p(4) ) then
                  erg = a(i)%fm%p(4)
                  n = i
               endif
            endif
         endif
      enddo
      end
      subroutine cqgsFragChg(ia, iz, fm, fc)
!      fix   projectile fragment charge
      implicit none
      integer,intent(in):: ia  ! heavy proj. mass #
      integer,intent(in):: iz  ! heavy proj. charge
      integer,intent(in):: fm !  fragment mass #
      integer,intent(out):: fc !  fragment charge

      real(8):: pprob, u

      if( fm  == 1 ) then
         if( ia > 29 ) then
            pprob = 0.4         ! proton prob.
         else
            pprob = 0.5
         endif
         call rndc(u)
         if(u < pprob ) then
            fc = 1
         else
            fc = 0
         endif
      elseif( fm == 2 ) then
         fc = 1
      elseif( fm <= 4 ) then
         fc = 2
      elseif( fm < 29 ) then
         if( fm == 27) then
            fc = 13
         elseif( fm == 19 ) then
            fc = 9
         else
            fc = fm*0.5
         endif
      else
         if( fm == 56 ) then
            fc = 26
         elseif( fm == 40 ) then
            fc = 18
         elseif( fm == 48 )  then
            fc = 22
         elseif( fm < 70 ) then
            fc = fm*0.47
         else 
            fc =fm*0.4
         endif
      endif
      end   subroutine cqgsFragChg


      
      
      

      
      

