      module modEpos
      implicit none

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence




                  real*8 p(4)

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      type(ptcl):: cms
      character*10,save:: from
      end module modEpos

      subroutine ceposIniAll
!        init of  EPOS  (once for all)

      implicit none
      call aaset(0)   ! default init for all events
!      call LHCparameters  ! needed for epos LHC version
      call ceposini00  ! some change from the default
 !          use ainit to specify r max target and projectile
      call cinieposmax
      end
      subroutine cinieposmax
      use modEpos
      include "../epos.inc"

      call cqfrom(from)  ! if called from Gencol, from = 'gencol' 

      idprojin = 1120
      idtargin = 1120
!      elab = 200.
      engy   = -1.
      pnll = 200.
      ekin = -1.
      ecms =  -1.
!      iframe=12                 ! 12=target frame (needed ?)
      if( from == 'gencol' ) then
         call cqGencolCMS(cms)
      endif
      if( from == 'epics'  .or. from ==  'gencol') then
         maproj = 56
         laproj = 26
         matarg = 14
         latarg = 1
      else
         maproj = 56
         laproj = 26
         matarg = 14 
         latarg = 1  
      endif
      call ainit
      end
      subroutine cqfrom(from)

!        Zmanager.h
         
         integer SeedSave(2) ! to store initial seed of random number 
                            ! for each event.  got at cevenLoop.f
        logical RefreshIR   ! becomes t if InitRN(1) < 0 && Job != 'flesh'
                            ! each event IR is read from #14
                            ! the file must be opened by the user routine
        character*80 PrefixConf ! Epics config file directory
        character*80 TopDir ! $COSMOSTOP
        character*6  CosOrEpi ! cosmos or epics; from of cintModels is set.
        integer  TopDirLeng ! length of TopDir 
        integer  PrefixLeng ! lenght of PrefixConf
         common /Zmanager/ SeedSave, RefreshIR, TopDirLeng, PrefixLeng
        common /Zmanagerc/ TopDir, PrefixConf, CosOrEpi




      character(*),intent(out):: from 
      from = CosOrEpi
      end

      subroutine ceposIniOneEvent(pjin, tg, sig)
!        This is called from dummy init from ceposIniAll
!        and when getting xs for a given media to calculate mfp.
!        and when the target is fixed and event generation just starts.
!         (from within cepposGenOneEvent)

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence




                  real*8 p(4)

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

      include "../epos.inc"
      type(ptcl):: pjin  ! input projectile particle
      type(ptcl):: tg  ! input target particle in lab.
      real(8),intent(out):: sig  ! inelastic cross section in mb

      type(ptcl)::pj
      real(8):: u

      pj = pjin

      elab = pj%fm%p(4)
      engy = -1.
      pnll = -1.
      ekin = -1.
      ecms =  -1.
      iframe=12            ! 12=target frame ; needed ?

      if( pj%code == kgnuc )  then
         maproj = pj%subcode           !proj A
         laproj = pj%charge
         idprojin = 1120
         elab = elab/pj%subcode   ! E(GeV)/n
      else
         if( pj%code == kphoton)  then
         !  replace it to pi0 or eta
            call rndc(u)
            if( u < 0.5d0 ) then
               call cmkptc(kpion, 1,  0, pj)
            else
               call cmkptc(keta, 1,  0, pj)
            endif
            ! adjust momentum
            cf = sqrt(1.d0 - (pj%mass/pj%fm%p(4))**2 )
            pj%fm%p(1:3) = cf * pj%fm%p(1:3)
         endif   
         call ccos2eposB( pj, idprojin)
                ! not idporj; before ainit "in"  must be added
         if( abs(idprojin) == 20  ) then ! k0s(20) or k0l(-20)
            call rndc(u)
            if(u < 0.5d0 ) then
               idprojin = 230   ! k0 
            else
               idprojin = -230  ! k0bar
            endif
         elseif(abs(idprojin) == 2130 ) then ! Lambda/lambda-bar
            idprojin = sign(1230, idprojin) ! use sigma/sigma-ba
         else
               !     use idprojin as it is;  
         endif
         laproj = -1
         maproj = 1
      endif
!/////////////
!      write(0,*) ' idprojin, laproj, maproj= ',
!     *        idprojin, laproj, maproj
!      write(0,*) ' idprojin has been changed to', idprojin
!//////////


      if( tg%code == kgnuc ) then
         idtargin = 1120
         latarg = tg%charge     !targ Z
         matarg = tg%subcode    !targ A
      else  ! p or n
         call ccos2eposB( tg, idtargin)
         matarg = 1           
         laproj = -1
      endif
!////////////
!      write(0,*) ' idtargin, latarg, matarg= ',
!     *  idtargin, latarg, matarg
!      write(0,*) ' entering  ainit'
!/////////////
      call ainit
      sig = sigineaa
      end
      
      subroutine ceposGenOneEvent(pj, ia, iz, a, n)
      use modEpos
!!!      implicit none ! cannot be used due to epos.inc

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.

! #include "Zptcl.h"

      type(ptcl):: pj   !  inp. projectile
      integer,intent(in):: ia  ! target A
      integer,intent(in):: iz  ! target Z
      type(ptcl):: a(*)  !  generated ptcl. must be >= n
      integer,intent(out):: n  ! # of  ptcls
      
      integer:: i, j
      include "../epos.inc"
      integer code, subcode, charge, kf
      type(ptcl):: tg
      real(8):: xs

      if( ia > 1 ) then
         call cmkptc(kgnuc, ia, iz, tg)
      else
         call cmkptc(knuc, ia, iz, tg)
      endif         
      tg%fm%p(1:3) = 0.
      tg%fm%p(4) = tg%mass
      call ceposIniOneEvent(pj, tg, xs)


      call aepos(-1)   ! generate 1 event -1 or 1 ?? 
              ! corsika use 1.
!       Fix final particles and some event parameters; epos code obtained
      if( from /= 'gencol') then
         call afinal   ! to the original system (NG at high E)
      endif
!       convert to HEP code 
      call ustore   !!!
      if(nhep .gt. nmxhep)then
         write(0,*) 'Error: produced number of particles=', nhep

         write(0,*) '>  nmxhep =',nmxhep
         stop
      endif
      
      n = 0
      do i = 1, nhep
         kf = idhep(i)
         call ckf2cos(kf, code, subcode, charge)
!///////////
!         write(0,
!     *  '(i3, a, i10, a, i3, a, i3, a, i4, a, i4, a, 1p,4g13.3)')
!     *  i, ' idhep=', idhep(i), ' code=',code, 
!     *  ' status=', isthep(i), ' moth=', jmohep(1,i), ' daug=',
!     *  jdahep(1,i), ' p(1:4)= ', phep(1:4, i)
!///////////
         if( isthep(i) /= 4 ) then
            if( code == krare .and. kf >= 1000000020 ) then
!                 Z= 0 A=subcode;  nucleus
               if( phep(4,i)/subcode > phep(5,i)*2 ) then
                  ! energy/n  > 2mass ; issue warning
                  write(0,*) 'from epos: idhep=',kf
                  write(0,*) ' subcode=',subcode,' charge=',charge
                  write(0,*) ' ia = ', ia, ' iz=',iz
                  write(0,*) ' 4mom=',phep(1:4,i) 
                  if( pj%code == kgnuc ) then
                  !  assign charge; not so bad method
                     call csetFragChg(
     *                    int(pj%subcode), subcode, charge)
                     code = kgnuc
                     n = n + 1
                     call cmkptc(code, subcode, charge, a(n))
                     a(n)%fm%p(1:4) = phep(1:4,i)
                     if( phep(4,i)/subcode > phep(5,i)*10 ) then
                        write(0,*) ' accepted as charge=',charge
                        write(0,*) ' nucleus'
                     endif
                  endif
               endif
            else
               n = n + 1
               call cmkptc(code, subcode, charge, a(n))
               a(n)%fm%p(1:4) = phep(1:4,i)
               !    use mass in phep
               a(n)%mass = phep(5,i)
            endif
         endif
      enddo
      if( from == 'gencol') then
         ! a is still in cms, so boost to lab system
         do i = 1, n
            call cibst1(i, cms, a(i), a(i))
         enddo
      endif
      call crot3mom(pj, a, n)  ! rotate result
      end


      subroutine ceposini00
!          change some of the parameters from default.  
!            (modification of IniEpos prepared for LHCf)
!      implicit none cannot be used because of epos.inc 

         integer kfpion, kfpi0, kfkaon, kfk0l, 
     *     kfk0s, kfproton, kfneutron,
     *     kfdmes, kfd0, kfelec, kflambdac,
     *     kfmuon, kfgzai0, kfgzai, kfbomega,
     *     kfneue, kfneumu, kfeta, kfphoton,
     *     kflambda, kfsigma0, kfsigmap, kfsigmam,
     *     kfrho, kfomega, kfphi
       parameter(
     * kfpion =211, kfpi0 = 111, kfkaon = 321,
     * kfk0l = 130, kfk0s = 310, kfproton =2212, 
     * kfneutron = 2112,  kflambdac=4122,
     * kfdmes = 411,  kfd0 = 421, kfbomega = 3334,
     * kflambda=3122, kfsigma0=3212,
     * kfsigmap=3222, kfsigmam=3112, kfgzai0=3322, kfgzai=3312,
     * kfeta = 221, kfelec = 11, kfmuon = 13, 
     * kfneue = 12, kfrho = 113, kfomega=223, kfphi=333,
     * kfneumu = 14, kfphoton=22 )


      include "../epos.inc"

      integer:: idtrafo  ! pdg<--->epos code conversion
      

      integer:: kgetenv2 ! func to get Environmental variable
      integer:: leng     ! to get length of the string
      real(8):: u
      call rndc(u)
      seedi=u   !seed for random number generator: at start program
      call rndc(u)
      seedj=u   !seed for random number generator: for first event
      iwseed = 0   ! no record seed

! Initialize decay of particles
      nrnody=0       !number of particle types without decay (if 0 (default) : all unstable particles decay (at the end only (anti)nucleons, (anti)electrons and muons)
! Particle code is given as
!     id=+/-ijkl
!
!          mesons--
!          i=0, j<=k, +/- is sign for j
!          id=110 for pi0, id=220 for eta, etc.
!
!          baryons--
!          i<=j<=k in general
!          j<i<k for second state antisymmetric in (i,j), eg. l = 2130
!
!          other--
!          id=1,...,6 for quarks
!          id=9 for gluon
!          id=10 for photon
!          id=11,...,16 for leptons
!          i=17 for deuteron
!          i=18 for triton
!          i=19 for alpha
!          id=20 for ks, id=-20 for kl
!
!          i=21...26 for scalar quarks
!          i=29 for gluino
!
!          i=30 for h-dibaryon
!
!          i=31...36 for scalar leptons
!          i=39 for wino
!          i=40 for zino
!
!          id=80 for w+
!          id=81,...,83 for higgs mesons (h0, H0, A0, H+)
!          id=84,...,87 for excited bosons (Z'0, Z''0, W'+)
!          id=90 for z0
!
!          diquarks--
!          id=+/-ij00, i<j for diquark composed of i,j.
!
! Examples : 2130 = lambda, 1330=xi0, 2330=xi-, 3331=omega
!
! Conversion from epos to  pdg code can be done using
!      id_pdg=idtrafo('nxs','pdg',id_epos)

      nrnody=nrnody+1
      nody(nrnody)=120     !pi+

      nrnody=nrnody+1
      nody(nrnody)=-120    !pi-
      nrnody=nrnody+1

      nody(nrnody)=130     !K+
      nrnody=nrnody+1

      nody(nrnody)=-130    !K-
      nrnody=nrnody+1

      nody(nrnody)=-20     !Kl

      nrnody=nrnody+1
      nody(nrnody)=-14     !mu+
      nrnody=nrnody+1
      nody(nrnody)=14      !mu-

!         we inhibit decay of  pi0, Lambda0,  k0s, sigma, (gzai ?)
      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs',kflambda)    !lambda using pdg code

      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs',kfpi0)    !pi0 

      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs',kfk0s)    !k0short 

      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs', kfsigmam)    ! sigma-

      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs',kfsigmap)    !sigma+

      nrnody=nrnody+1
      nody(nrnody)=idtrafo('pdg','nxs',kfsigma0)    !sigma0

      nrnody = nrnody + 1
      nody(nrnody) = idtrafo('pdg', 'nxs', kfgzai0) ! Xi0
      nrnody = nrnody + 1
      nody(nrnody) = idtrafo('pdg', 'nxs', kfgzai) ! Xi-
      nrnody = nrnody + 1
      nody(nrnody) = idtrafo('pdg', 'nxs', -kfgzai) ! Xi+
      nrnody=nrnody+1
      nody(nrnody)=1220     ! n
      nrnody=nrnody+1
      nody(nrnody)=-1220     ! an
      nrnody = nrnody + 1
      nody(nrnody) = idtrafo('pdg', 'nxs', kfeta) !  eta


      isigma=0   !do not print out the cross section on screen
!      ionudi=3   !count diffraction without excitation as elastic
      ionudi=1  ! this is used in  Corska.  include quasi elastic events but strict calculation of xs
      iorsce=0  ! used in corsika. color exchange turned on(1) or off(0)
      iorsdf=3  !corsika. droplet formation turned on(>0) or off(0)        
      iorshh=0  !corsika. other hadron-hadron int. turned on(1) or off(0) 
      istore = 0  !corsika  DO NOT STORE EVENTS ON zzz.data FILE
!      iframe=11                 !nucleon-nucleon frame (12=target)
      iframe=12                 ! 12=target frame
      iecho=0                     !"silent" reading mode

!    infragm= 0  ???????????

!      fnnx="./"                    ! path to main epos subdirectory
      leng=kgetenv2("COSMOSTOP", fnnx)
      if( leng == 0 ) then

         write(0,*) 'env.  COSMOSTOP not given '
         stop
      endif
!          file management
      fnnx = fnnx(1:leng)//"/Import/EPOS/"
      nfnnx=len(trim(fnnx))  ! length of fnnx
!            files are opened and closed by epos prog.
!        with file # =1. 
!      nfnii=10                     ! epos tab file name length
!      fnii="epos.initl"            ! epos tab file name
!       files are  used in epos-sem except fnie which is in ep-qsh 
      fnii = trim(fnnx)//"epos.initl"
      nfnii = len(trim(fnii))

      fnid=trim(fnnx)//"epos.inidi"
      nfnid=len(trim(fnid))
!         used in ep-qsh
      fnie=trim(fnnx)//"epos.iniev"
      nfnie=len(trim(fnie))

      fnrj=trim(fnnx)//"epos.inirj"
      nfnrj=len(trim(fnrj))

      fncs=trim(fnnx)//"epos.inics"
      nfncs=len(trim(fncs))

! Debug
      ish=0       !debug level
      ifch=0      !debug output (screen); stderr
      ifmt = 0    ! r messages
!      ifch=31    !debug output (file)
!      fnch="epos.debug"
!      nfnch=index(fnch,' ')-1
!      open(ifch,file=fnch(1:nfnch),status='unknown')

!       These are postponed until init for each event.
!      nevent = 1  !number of events
!      modsho = 1  !printout every modsho events
!
!      ecms=14000  !center of mass energy in GeV/c2
!      
!      idproj = 1120   !proton
!      laproj = 1      !proj Z
!      maproj = 1      !proj A
!      idtarg = 1120   !proton
!      latarg = 1      !targ Z
!      matarg = 1      !targ A
!
      istmax = 0      !only final particles (istmax=1 includes mother particles)

! for main program
!      nevto  = nevent
!      isho   = ish

      end



!-----------------------------------------------------------------------     
      subroutine EposInput(nevto,isho)
!-----------------------------------------------------------------------     
! Read informations (new options or parameter change) in the file
! "epos.param". The unit "ifop" is used in aread. If not used, it will
! use the default value of all parameters.
!-----------------------------------------------------------------------     
! for TempDev

!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!   Parameters   needed  for the Launcher.
!
!	(->	------------------------------------

         integer ErrorOut    !2 Error output logical  dev number.
         character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
         character*128  CutOffFile   !1  Geomagnetic cut-off file
         character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
         character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
         character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
                                    !   Cosmos/Data/DPM/atmos.inp is assumed.  
         character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
         logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
         integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
         integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
         integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
         integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
         logical       Hidden         !1  Make T, if hidden parameters are to be written.
         integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
         integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
         character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'
                                   ! Normally  this may be blank. Then, standard atmosphere
                                   ! is employed.  If another data with the same format
                                   ! atmosphere model is available, it can be specified.
                                   !  If ATMOSPHERE is set to 3 in Zcondc.h, and AtmosFile
                                   !  is blank, you have to set NRL_period (see, for period,
                                   !  Cosmos/Import/NRL/Util/ or manual for NRL atmosphere). 
                                   !  latitude and longitude information is also used.  
                                   ! If AtmosFile is given, it is assumed NRL format
                                   ! atmosphere data and it is used.
                                   ! For such NRL data, see also Cosmos/Import/NRL/Util/
        integer:: NRL_period       !2 see Cosmos/Import/NRL/Util or manual for NRL atmsophere
        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


!	<-)	-------------------------------------
         common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), NRL_period(4),
     *  Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 

      include "../epos.inc"
      nopen=0
!      ifop=35
      ifop = TempDev
      open(unit=ifop,file='example.param',status='old')
      call aread
      close(ifop)
! for main program
      nevto  = nevent
      isho   = ish
      end

!-----------------------------------------------------------------------
      function rangen()  result(rn)   ! single precision
!-----------------------------------------------------------------------
!     generates a random number
!         use Cosmos generator 
      implicit none
      real(8):: u
      real(4):: rn
      call rndc(u)
      rn = u
!-----------------------------------------------------------------------
!      include 'epos.inc'
!      double precision dranf
! 1    rangen=sngl(dranf(dble(rangen)))
!      if(rangen.le.0.)goto 1
!      if(rangen.ge.1.)goto 1
!      if(irandm.eq.1)write(ifch,*)'rangen()= ',rangen
!
!      return
      end

!-----------------------------------------------------------------------
!      double precision function drangen(dummy)
      function drangen(dummy)  result(u)
!-----------------------------------------------------------------------
!     generates a random number
!-----------------------------------------------------------------------
!      include 'epos.inc'
!      double precision dummy,dranf
!      drangen=dranf(dummy)
!      if(irandm.eq.1)write(ifch,*)'drangen()= ',drangen
!
      real(8):: dummy
      real(8):: u
      call rndc(u)
      
      end
!-----------------------------------------------------------------------
      function cxrangen(dummy)  result(rn)
!-----------------------------------------------------------------------
!     generates a random number
!-----------------------------------------------------------------------
!      include 'epos.inc'
!      double precision dummy,dranf
!      cxrangen=sngl(dranf(dummy))
!      if(irandm.eq.1)write(ifch,*)'cxrangen()= ',cxrangen
!
      real(8):: dummy
      real(4):: rn
      real(8):: u
      call rndc(u)
      rn = u
      end

! Random number generator from CORSIKA *********************************




!C=======================================================================
!
!      DOUBLE PRECISION FUNCTION DRANF(dummy)
!
!C-----------------------------------------------------------------------
!C  RAN(DOM  NUMBER) GEN(ERATOR) USED IN EPOS
!C  If calling this function within a DO-loop
!C  you should use an argument which prevents (dummy) to draw this function 
!C  outside the loop by an optimizing compiler.
!C-----------------------------------------------------------------------
!      implicit none
!      integer irndmseq
!      double precision uni,dummy
!C-----------------------------------------------------------------------
!
!      call RMMARD( uni,1,irndmseq)
!
!      DRANF = UNI
!      UNI = dummy        !to avoid warning
!
!      RETURN
!      END


!-----------------------------------------------------------------------
      subroutine ranfgt(seed)
!-----------------------------------------------------------------------
! Initialize seed in EPOS : read seed (output)
! Since original output seed and EPOS seed are different,
! define output seed as : seed=ISEED(3)*1E9+ISEED(2)
! but only for printing. Important values stored in /eporansto/
! Important : to be call before ranfst
!-----------------------------------------------------------------------
      IMPLICIT NONE
      INTEGER          KSEQ
      PARAMETER        (KSEQ = 2)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ)
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ
      common/eporansto/diu0(100),iiseed(3)
      double precision    seed,diu0
      integer iiseed,i

      iiseed(1)=IJKL(1)
      iiseed(2)=NTOT(1)
      iiseed(3)=NTOT2(1)
      seed=dble(iiseed(3))*dble(MODCNS)+dble(iiseed(2))
      diu0(1)=C(1)
      do i=2,98
        diu0(i)=U(i-1,1)
      enddo
      diu0(99)=dble(I97(1))
      diu0(100)=dble(J97(1))
      return
      end

!-----------------------------------------------------------------------
      subroutine ranfst(seed)
!-----------------------------------------------------------------------
! Initialize seed in EPOS :  restore seed (input)
! Since original output seed and EPOS seed are different,
! define output seed as : seed=ISEED(3)*1E9+ISEED(2)
! but only for printing. Important values restored from /eporansto/
! Important : to be call after ranfgt
!-----------------------------------------------------------------------
      IMPLICIT NONE
      INTEGER          KSEQ
      PARAMETER        (KSEQ = 2)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ)
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ
      common/eporansto/diu0(100),iiseed(3)
      double precision    seedi,seed,diu0
      integer i,iiseed

      seedi=seed
      IJKL(1)=iiseed(1)
      NTOT(1)=iiseed(2)
      NTOT2(1)=iiseed(3)
      C(1)=diu0(1)
      do i=2,98
        U(i-1,1)=diu0(i)
      enddo
      I97(1)=nint(diu0(99))
      J97(1)=nint(diu0(100))
      return
      end

!-----------------------------------------------------------------------
      subroutine ranflim(seed)
!-----------------------------------------------------------------------
      double precision seed
      if(seed .gt. 1d9)stop'seed larger than 1e9 not possible !'
      end

!-----------------------------------------------------------------------
      subroutine ranfcv(seed)
!-----------------------------------------------------------------------
! Convert input seed to EPOS random number seed
! Since input seed and EPOS (from Corsika) seed are different,
! define input seed as : seed=ISEED(3)*1E9+ISEED(2) 
!-----------------------------------------------------------------------
      IMPLICIT NONE
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      common/eporansto/diu0(100),iiseed(3)
      double precision    seed,diu0
      integer iiseed

      iiseed(3)=nint(seed/dble(MODCNS))
      iiseed(2)=nint(mod(seed,dble(MODCNS)))

      return
      end

!-----------------------------------------------------------------------
      subroutine ranfini(seed,iseq,iqq)
!-----------------------------------------------------------------------
! Initialize random number sequence iseq with seed
! if iqq=-1, run first ini
!    iqq=0 , set what sequence should be used
!    iqq=1 , initialize sequence for initialization
!    iqq=2 , initialize sequence for first event
!-----------------------------------------------------------------------
      IMPLICIT NONE
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      common/eporansto/diu0(100),iiseed(3)
      double precision    seed,diu0
      integer iiseed
      common/eporansto2/irndmseq
      integer irndmseq
      integer iseed(3),iseq,iqq,iseqdum
 
      if(iqq .eq.0)then
        irndmseq=iseq
      elseif(iqq .eq.-1)then
        iseqdum=0
        call RMMAQD(iseed,iseqdum,'R')   !first initialization
      elseif(iqq .eq.2)then
        irndmseq=iseq
        if(seed .ge. dble(MODCNS))then
           write(*,'(a,1p,e8.1)')'seedj larger than',dble(MODCNS)
           stop 'Forbidden !'
        endif
        iiseed(1)=nint(mod(seed,dble(MODCNS)))
! iiseed(2) and iiseed(3) defined in aread
        call RMMAQD(iiseed,iseq,'S') !initialize random number generator
      elseif(iqq .eq.1)then        !dummy sequence for EPOS initialization
        irndmseq=iseq
        if(seed .ge. dble(MODCNS))then
           write(*,'(a,1p,e8.1)')'seedi larger than',dble(MODCNS)
           stop 'Forbidden !'
        endif
        iseed(1)=nint(mod(seed,dble(MODCNS)))
        iseed(2)=0
        iseed(3)=0
        call RMMAQD(iseed,iseq,'S') !initialize random number generator
      endif
      return
      end

!=======================================================================

      SUBROUTINE RMMARD( RVEC,LENV,ISEQ )

!-----------------------------------------------------------------------
!  C(ONE)X
!  R(ANDO)M (NUMBER GENERATOR OF) MAR(SAGLIA TYPE) D(OUBLE PRECISION)
!
!  THESE ROUTINES (RMMARD,RMMAQD) ARE MODIFIED VERSIONS OF ROUTINES
!  FROM THE CERN LIBRARIES. DESCRIPTION OF ALGORITHM SEE:
!               http://consult.cern.ch/shortwrups/v113/top.html
!  IT HAS BEEN CHECKED THAT RESULTS ARE BIT-IDENTICAL WITH CERN
!  DOUBLE PRECISION RANDOM NUMBER GENERATOR RMM48, DESCRIBED IN
!               http://consult.cern.ch/shortwrups/v116/top.html
!  ARGUMENTS:
!   RVEC   = DOUBLE PREC. VECTOR FIELD TO BE FILLED WITH RANDOM NUMBERS
!   LENV   = LENGTH OF VECTOR (# OF RANDNUMBERS TO BE GENERATED)
!   ISEQ   = # OF RANDOM SEQUENCE
!
!  VERSION OF D. HECK FOR DOUBLE PRECISION RANDOM NUMBERS.
!  ADAPTATION  : T. PIEROG    IK  FZK KARLSRUHE FROM D. HECK VERSION
!  DATE     : Feb  17, 2009
!-----------------------------------------------------------------------

      IMPLICIT NONE
      INTEGER          KSEQ
      PARAMETER        (KSEQ = 2)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ),UNI
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ

      DOUBLE PRECISION RVEC(*)
      INTEGER          ISEQ,IVEC,LENV
      SAVE

!-----------------------------------------------------------------------

      IF ( ISEQ .GT. 0  .AND.  ISEQ .LE. KSEQ ) JSEQ = ISEQ
      
      DO   IVEC = 1, LENV
        UNI = U(I97(JSEQ),JSEQ) - U(J97(JSEQ),JSEQ)
        IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
        U(I97(JSEQ),JSEQ) = UNI
        I97(JSEQ)  = I97(JSEQ) - 1
        IF ( I97(JSEQ) .EQ. 0 ) I97(JSEQ) = 97
        J97(JSEQ)  = J97(JSEQ) - 1
        IF ( J97(JSEQ) .EQ. 0 ) J97(JSEQ) = 97
        C(JSEQ)    = C(JSEQ) - CD
        IF ( C(JSEQ) .LT. 0.D0 ) C(JSEQ)  = C(JSEQ) + CM
        UNI        = UNI - C(JSEQ)
        IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
!  AN EXACT ZERO HERE IS VERY UNLIKELY, BUT LET'S BE SAFE.
        IF ( UNI .EQ. 0.D0 ) UNI = TWOM48
        RVEC(IVEC) = UNI
      ENDDO

      NTOT(JSEQ) = NTOT(JSEQ) + LENV
      IF ( NTOT(JSEQ) .GE. MODCNS )  THEN
        NTOT2(JSEQ) = NTOT2(JSEQ) + 1
        NTOT(JSEQ)  = NTOT(JSEQ) - MODCNS
      ENDIF

      RETURN
      END

!=======================================================================

      SUBROUTINE RMMAQD( ISEED, ISEQ, CHOPT )

!-----------------------------------------------------------------------
!  R(ANDO)M (NUMBER GENERATOR OF) MA(RSAGLIA TYPE INITIALIZATION) DOUBLE
!
!  SUBROUTINE FOR INITIALIZATION OF RMMARD
!  THESE ROUTINE RMMAQD IS A MODIFIED VERSION OF ROUTINE RMMAQ FROM
!  THE CERN LIBRARIES. DESCRIPTION OF ALGORITHM SEE:
!               http://consult.cern.ch/shortwrups/v113/top.html
!  FURTHER DETAILS SEE SUBR. RMMARD
!  ARGUMENTS:
!   ISEED  = SEED TO INITIALIZE A SEQUENCE (3 INTEGERS)
!   ISEQ   = # OF RANDOM SEQUENCE
!   CHOPT  = CHARACTER TO STEER INITIALIZE OPTIONS
!
!  CERN PROGLIB# V113    RMMAQ           .VERSION KERNFOR  1.0
!  ORIG. 01/03/89 FCA + FJ
!  ADAPTATION  : T. PIEROG    IK  FZK KARLSRUHE FROM D. HECK VERSION
!  DATE     : Feb  17, 2009
!-----------------------------------------------------------------------

      IMPLICIT NONE
      INTEGER          KSEQ
      PARAMETER        (KSEQ = 2)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS
      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ),UNI
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ

      DOUBLE PRECISION CC,S,T,UU(97)
      INTEGER          ISEED(3),I,IDUM,II,II97,IJ,IJ97,IORNDM,
     *                 ISEQ,J,JJ,K,KL,L,LOOP2,M,NITER
      CHARACTER        CHOPT*(*), CCHOPT*12
      LOGICAL          FIRST
      SAVE
      DATA             FIRST / .TRUE. /, IORNDM/11/, JSEQ/1/

      
!-----------------------------------------------------------------------

      IF ( FIRST ) THEN
        TWOM24 = 2.D0**(-24)
        TWOM48 = 2.D0**(-48)
        CD     = 7654321.D0*TWOM24
        CM     = 16777213.D0*TWOM24
        CINT   = 362436.D0*TWOM24
        MODCNS = 1000000000
        FIRST  = .FALSE.
        JSEQ   = 1
      ENDIF
      CCHOPT = CHOPT
      IF ( CCHOPT .EQ. ' ' ) THEN
        ISEED(1) = 54217137
        ISEED(2) = 0
        ISEED(3) = 0
        CCHOPT   = 'S'
        JSEQ     = 1
      ENDIF

      IF     ( INDEX(CCHOPT,'S') .NE. 0 ) THEN
        IF ( ISEQ .GT. 0  .AND.  ISEQ .LE. KSEQ ) JSEQ = ISEQ
        IF ( INDEX(CCHOPT,'V') .NE. 0 ) THEN
          READ(IORNDM,'(3Z8)') IJKL(JSEQ),NTOT(JSEQ),NTOT2(JSEQ)
          READ(IORNDM,'(2Z8,Z16)') I97(JSEQ),J97(JSEQ),C(JSEQ)
          READ(IORNDM,'(24(4Z16,/),Z16)') U
          IJ = IJKL(JSEQ)/30082
          KL = IJKL(JSEQ) - 30082 * IJ
          I  = MOD(IJ/177, 177) + 2
          J  = MOD(IJ, 177)     + 2
          K  = MOD(KL/169, 178) + 1
          L  = MOD(KL, 169)
          CD =  7654321.D0 * TWOM24
          CM = 16777213.D0 * TWOM24
        ELSE
          IJKL(JSEQ)  = ISEED(1)
          NTOT(JSEQ)  = ISEED(2)
          NTOT2(JSEQ) = ISEED(3)
          IJ = IJKL(JSEQ) / 30082
          KL = IJKL(JSEQ) - 30082*IJ
          I  = MOD(IJ/177, 177) + 2
          J  = MOD(IJ, 177)     + 2
          K  = MOD(KL/169, 178) + 1
          L  = MOD(KL, 169)
          DO   II = 1, 97
            S = 0.D0
            T = 0.5D0
            DO   JJ = 1, 48
              M = MOD(MOD(I*J,179)*K, 179)
              I = J
              J = K
              K = M
              L = MOD(53*L+1, 169)
              IF ( MOD(L*M,64) .GE. 32 ) S = S + T
              T = 0.5D0 * T
            ENDDO
            UU(II) = S
          ENDDO
          CC    = CINT
          II97  = 97
          IJ97  = 33
!  COMPLETE INITIALIZATION BY SKIPPING (NTOT2*MODCNS+NTOT) RANDOMNUMBERS
          NITER = MODCNS
          DO   LOOP2 = 1, NTOT2(JSEQ)+1
            IF ( LOOP2 .GT. NTOT2(JSEQ) ) NITER = NTOT(JSEQ)
            DO   IDUM = 1, NITER
              UNI = UU(II97) - UU(IJ97)
              IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
              UU(II97) = UNI
              II97     = II97 - 1
              IF ( II97 .EQ. 0 ) II97 = 97
              IJ97     = IJ97 - 1
              IF ( IJ97 .EQ. 0 ) IJ97 = 97
              CC       = CC - CD
              IF ( CC .LT. 0.D0 ) CC  = CC + CM
            ENDDO
          ENDDO
          I97(JSEQ) = II97
          J97(JSEQ) = IJ97
          C(JSEQ)   = CC
          DO   JJ = 1, 97
            U(JJ,JSEQ) = UU(JJ)
          ENDDO
        ENDIF
      ELSEIF ( INDEX(CCHOPT,'R') .NE. 0 ) THEN
        IF ( ISEQ .GT. 0 ) THEN
          JSEQ = ISEQ
        ELSE
          ISEQ = JSEQ
        ENDIF
        IF ( INDEX(CCHOPT,'V') .NE. 0 ) THEN
          WRITE(IORNDM,'(3Z8)') IJKL(JSEQ),NTOT(JSEQ),NTOT2(JSEQ)
          WRITE(IORNDM,'(2Z8,Z16)') I97(JSEQ),J97(JSEQ),C(JSEQ)
          WRITE(IORNDM,'(24(4Z16,/),Z16)') U
        ELSE
          ISEED(1) = IJKL(JSEQ)
          ISEED(2) = NTOT(JSEQ)
          ISEED(3) = NTOT2(JSEQ)
        ENDIF
      ENDIF

      RETURN
      END

