      subroutine cqPtclDen(lat, depindx, how, r, rho)

!      Since the observed particle density is heavily affected by
!      the detector structure, we assume here some detecotrs for 
!      certain input parameters.

      implicit none
      integer lat   ! input. 1 --> Lateral distribution used in GENAS
                    !              is employed. (recomended)
                    !        2 --> nkg function is used, making the
                    !              Moliere unit length half.
                    !        3 --> nkg function is used with normal
                    !              Moriele unit
                    !        4 --> Bare electron lateral distribution
                    !              is used which created by an electron
                    !              primary.   
      integer depindx ! input. A%S observation depth index.
                      !        1 to NoOfASSites.

      integer how   ! input.  has sence, if lat = 1.
                    !        1--> very normal scintillator detector is
                    !             assumed; thin iron + scintillator
                    !             of  ~ 4cm thick. 
                    !             
                    !        2--> 0.5 cm lead plate is added to the
                    !             how=1 case.
                    !   
      real*8 r      ! input. distance from the core in m (pependicular
                    !        to the axis) where you want to have the
                    !        effective particle density.

      real*8 rho    ! output. effective average particle number in an area of
                    !         1 m2 at r.  The area is assumed to be
                    !         horiazontal (if ObsPlane = 1) or perpendicular
                    !         to the shower direction (if ObsPlane =2)


!   #ifndef Ztrack_
!   #define Ztrack_
!    structure used when tracking a particle
!    *************************



!  define MYEFIELD  if Electric field is to be supplied 
!  by the user using cmyEfield.f of which template is
!  in UserHook/.  The user may copy it to the users
!  application area, modify it and may add  cmyEfield.o in
!  the chook.mk like:
!      objs =  chook.o cmyEfield.o
!  Also the user must give a value of
!  >1 to the 'HowEfield' parameter  in the namelist ($HPARAM).
!  Note simple Electric field can be specified
!  without using this but by giving HowEfield=1 in the
!  namelist parameter.  Then simple electric
!  field can be specified (together with other parameters)

!!! define MYEFIELD
!   dpmjet cannot be used on NEXTSTEP, so
!   you have to make the next 0. 






!   if parameter statement does not permit to use math such as 
!      parameter::pi=asin(1.d0)*2 define MATHLOUSY




!            make DEBUG > 0 depending on the debug purpose. 


!
!   choose:    Old atmosphere or new segmented atmosphere
!            define, or  NRL time-dependent one 
!               old atmosphere --> 0
!           or  new with c-spline
!               new atmosphere --> 1
!           or  new with linear interp.
!               new atmosphere --> 2 (default)
!           or  NRL atmosphere --> 3


!     if you want to put a lable on each particle to identify that
!     the one and the same particle crosses a given observation
!     plane more than once, make this 1 or 2.  Then the same particle
!     will have the  same label number in track record.
!     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
!     exists. 
!     If 1; after any interaction (except for continuous energy
!     loss by dE/dx and deflection by B or scattering), label is
!     changed.
!     If 2: For knockon and Bremstrahlung, the survival particle
!     will have the same label. In the case of Moller scattring
!     higher enregy electrons are regarded as the survival one.
!

!     if you want to have a detailed info. for particle tracking
!     make the below >=1.  The user observation routine is called
!     with the following id  on the following  conditions:
!              chookobs(a, id)
!     1)  if it is >=1,  a particle is going to interact at a point given in
!         the track information, id=4
!     2)  if it is >=1,  a particle is going to die, id=5
!     3)  if it is >=2,  a particle is being discarded due to the large
!          angle (cos(angle relative to the parent) > BackAngLimit). id=6
!     4)  if it is >=3,  a particle makes a step. id=7
!        

!  #ifndef Zptcl_
!  #define Zptcl_



!#    for gfortran  must be disabled.  





!    structure defining a particle at production
!         Basic idea of what is to be contained in 
!         the particle structue is that
!        1) dynamical ones should be included
!        2) those derivable from the particle code
!           is not included 
!     ******************************************************
      type fmom     ! 4 momentum
	sequence




                  real*8 p(4)

      end type fmom
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!       Important note:   Bug in sun fortran
!           If we define, say,
!                 record /fmom/ p1
!           and set
!                 p1.e = some value (or p1.p(4)= ...)
!           where some value is a constant or arithmetic
!           expression which results in a value > 1.d37
!           then overflow message comes out on SUN fortran
!           although the result is correct.
!           Setting the same into, say, p1.px does not
!           cause such. (as of 1993/08/14)
!     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
!     ******************************************************
      type ptcl       ! particle at production
        sequence
!                   4 momentum. 

      type(fmom):: fm 
!
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
!       code: ptcl code
!    subcode:used mainly to identify paticle/antiparticle
!            if the difference is important.
!            To set particle, "ptcl" is used.
!                   anti-partilce, 'antip" is used for particles
!           For particles of which partilce/antiparticle nature
!            can be judded by its code and charge, the user 
!            need not specify it when using cmkptc subroutine.
!            give 0.
!            subcode for gamma ray may be used to identify
!            brems gamma and direct gamma by kdiretg, kcasg
      end type ptcl
!     ******************************************************
!  #endif  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence




                  real*8 r(3)

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef Zpos_
! #define Zpos_
!          location of a ptcl 
!       Zcoord.h must be  preceeded
!
         type  position
           sequence
           type(coord):: xyz   ! in xyz
            real*8  radiallen    ! in m . radial length
            real*8  depth       ! in kg/m2   depth.
            real*8  height      ! in m.  vertical height(from sea level
           real*8  colheight   ! in m.  //  where the  
!                           latest nuclear collision took place.
!                           (iniitial value is very large value).
         end  type position
!  #endif  

!  #ifndef Zdirec_
!  #define Zdirec_
      type direc
        sequence
          type (coord) w
           real*8  coszenith   ! cos of the zenith angle.  
!               it is defined as follows:
!                   Let's assume w and position are given
!                   in xyz sytem.
!                  
!                   coszenith = -( x*w.x + y * w.y + z * w.z )/
!                                (length of (x,y,z)) 
!                   This should be computed whenever w is
!                   updated.
      end type direc
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)




                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!     ---------------------
      type track      ! full particle attributes in Cosmos
        sequence

          type(ptcl):: p    ! basic ptcl attributes.

!               position and time
          type(position):: pos
          real*8 t           ! time in length/beta (m)
          type(direc):: vec
          real*4 wgt         ! weight for thin sampling
           integer*2 where    ! current obsSite no. (0 is initial value)
          integer*2 asflag   ! non 0, if As has been generated from this
!                             ptcl (only for electrons)
          real*8   user      ! user use

      end type track
!   #endif  



!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!          common variables used in tracking ptcls.
       integer ToInteract, ToBeObserved, Truncated, Dead,
     *         BorderL,  BorderH, AngleLimit
       parameter(ToInteract = 1, ToBeObserved = 2, Truncated = 3,
     *  BorderL = 4, BorderH =5,  Dead = 6, AngleLimit = 7)
       integer  BitPhotoElec, BitPhoton,
     *    BitElectron, BitPositron, BitProton,
     *    BitNeutron, BitAntiNuc, BitDecay,  BitOther, BitEconsv
       parameter( BitPhotoElec=1, BitPhoton=2, BitElectron=3, 
     *  BitPositron=3, BitProton=4, BitNeutron=5, BitAntiNuc=6,
     *  BitDecay=7, BitOther=8, BitEconsv=9  )

       integer MaxInte
       parameter(MaxInte = 6)  !  Max number of kinds of interactions a particle can
                               !  take. (such as brems, knockon, anihilation)
       type intinf      ! Interaction information
         sequence
           real*8  thickness   ! in kg/m2 set if decay is F
           real*8  length      ! in m, set if decay is T.  or eventually by cfixProc
           character*8 process ! process id string such as brems, pair
            logical decay       ! if decay, T, else F
       end type intinf
!          define array of intinf
       type(intinf) IntInfArray(MaxInte)
!
       type(track):: TrackBefMove  ! track before moved       	
       type(track):: MovedTrack      ! to contain track moved
       type(coord):: Offset        ! the primary is directed to 
!                                     deepest detector origin + Offset
!                                     (in 'xyz')
       type(track):: Zfirst ! to keep first interaction info. V7.0
!       real*8 Zfirst       ! to keep first interaction slant depth
       integer MoveStat    ! status code for moving a particle
       integer NumberOfInte ! Number of different kind of interactions 
                            ! considered for the current particle.
       integer ProcessNo   ! The process really happend is the
                            ! ProcessNo-th process in  IntInfArray.
         logical ObserveAS     ! made to be T, if AS is to be generated
        logical Upgoing     ! if primary is going upward, made to be t
        logical UseTbl       ! becomes T, 
                            ! if length <--> thickness conv. is by table
         real*8  EminAS      ! minimum energy of e for AS generation.
         real*8  EasWait     ! for AS generation, must wait until e 
                            ! energy becomes < EasWait
        real*8 EnergyLoss   !  energy loss 
        real*8 Upsilon      ! Upsilon value 
        real*8 Xai          ! Xai value B x Eg/m /2
        real*8 maxstep(0:50 +1) ! used to cut the path
                ! 1/5 of the depth step. this is necessary cond.
         real*8  KEmin         ! min kinetic energy to be tracked
        real*8  KEminCas      ! //          (for em-cascade)
        real*8  KEmin2        ! min kinetic energy to be tracked.  for skeleton/flesh use.
        real*8  KEminCas2     ! for skeleton/flesh use.
         real*8  Ethin(4)      ! Thin sampling threshold and max weight.  for e/g and hadrons/muons
         real*8 Beta  !  v/c for MovedTrack; given if TimeStrucrue=T.
        type(magfield):: Mag
         integer MaxPtcl
        logical FromEpics     !  to control muon iteraction (pair,brem,nuci)
                              !  must be made t, when Epics treats muon.
                              !  if Cosmos uses Epics, this must be made to
                              !  be t/f depending on Epics mode, or Cosmos mode




         parameter (

     *     MaxPtcl = 35000



     *         )   ! max # of ptcls producable in coll.
        type(ptcl):: Pwork(MaxPtcl)  ! working array to store ptcls.
         integer Nproduced   ! no. of ptcls produced and stored in Pwork.
        integer Nstacked    ! no. of ptcls stacked. If ThinSampling=F,
                            ! same as Nproduced.  Nstacked <= Nproduced
         real*8  MuonPolarization  ! muon polarization value.
        integer FirstColA, FirstColZ
        real(8)::FirstColXs
!
       common /Ztrackv/Pwork, IntInfArray, TrackBefMove,
     *  MovedTrack, Zfirst, Offset,
     *  Mag, MuonPolarization,  EminAS, EasWait,
     *  EnergyLoss,  KEmin, KEminCas, Beta, 
     *  KEmin2, KEminCas2, Ethin, Upsilon, Xai, 
     *  maxstep,
     *  ObserveAS, Nproduced, Nstacked,
     *  MoveStat,  NumberOfInte, ProcessNo, 
     *  Upgoing, UseTbl, FirstColXs,
     *  FromEpics, FirstColA, FirstColZ





       real*8 TargetMassN  ! Number weighted average target mass number.  fixed value
       real*8 TargetAtomicN   !The same for average Z of the target.   fixed value
       real*8 TargetZ2        ! <Z^2> of the target
!       integer TargetNucleonNo  !  target nucleon number at a collision. sampled at each collision
       real*8 TargetZ2_3rd  ! <Z>^(2/3).  Since <Z> is almost same as 7 or 8
!                    we simpley use this as <Z^2/3>
       real*8 TargetZ1_3rd  !  <Z>^(1/3).  same reason

!       integer TargetProtonNo  !  target proton number  //     //
!       real*8  TargetXs   ! inelastic xs for this target

       common /Zair/
     *  TargetMassN, TargetAtomicN, TargetZ2, TargetZ2_3rd,  
     *  TargetZ1_3rd
!     *, TargetXs, TargetNucleonNo, TargetProtonNo
!   last 3 moved to modXsecMedia 
          save /Zair/














!   make next as large as 1~2 milion for practical case
!  (for general MPI application)





!       Zobs.h     header file for observation sites definition
!
           integer maxNoOfSites, maxNoOfASSites, horizontal,
     *     perpendicular, notUsed, spherical
       parameter (

     *    maxNoOfSites = 50,




     *    maxNoOfASSites=50,



     *    notUsed = 0,           ! detector plane is not used
     *    horizontal = 1,        ! detector is horizontal
     *    perpendicular = 2,      ! detector is pependicular to 1ry.
     *    spherical = 3          ! detector is cocentric sphere as the earth
     *		      )


!       Zobsvp.h---parameters to be given by input.
!       This must be preceded by Zobs.h

!	(->	---------------------------------------------------

         real*8  HeightList  !1  Height of observation levels in m. This is  made from DepthList internally. 
                            ! I.e., this one is usually not an input. However, if the DepthList values are 
                            ! negative, this is used as input and corresponding DepthList is computed internally.
        real*8  DepthList   !1	Depth List of Observation level in kg/m$^2$. If $< 0$, HeightList has priority. 
                            !  (See HeightList)
        real*8  ASHeightList	!1  This is HeightList for Air Shower observ.  Used only if Generate contains
                            !  "as". See  HeightList.
        real*8  ASDepthList     !1  This is DepthList for AS observation.  Used only if Generate contains 
                            ! "as". See DepthList.
        real*8  LatitOfSite     !1  Latitude of the deepest observation level in degree.  East is positive.
        real*8  LongitOfSite    !1  Longitude of the deepest observation level in degree.  North is positive.

     	real*8  DtGMT           !1  Difference of the local time of the observation place from GMT (hour).
         real*8  YearOfGeomag    !1  Like 1999.5. Year when Geomagnetic field is to be calculated.
         integer ObsPlane        !1    How to observe particles. \newline
                                !    0$ \Rightarrow $ no detector plane is used for observation. BorderHeightL
                                !    and BorderHeightH are used to detect particles. This is for, say, neutrino
                                !    observation. See BorderHeight{L,H}. However, the primary is directed to
                                !    the deepest depth.  \newline
                                !    1,-1$ \Rightarrow $ detector at the observation place is horizontal. Note 
                                !    that the horizontal means not tangential plane, but rather a spherical surface \newline
                                !    2,-2$ \Rightarrow $ detector is perpendicular to the primary. \newline
                                !    3$ \Rightarrow $ spherical observation. See text. \newline
                                !    For ObsPlane={1,2}, the user observation routine will receive coordinate values in
                                !    the corresponding detector system. However, if it is 0, 3 or negative, Exyz values
                                !    are obtained.
        integer NoOfSites2    !2   No of Sites for particle observation; not to be touched; for skeleton/flesh use.
         real*8 XaxisFromSouth   !2 Angle between the horizontal detector X-axis and the south(deg). + is counter
                                ! clockwise.  If $|$XaxisFromSouth$| > 360$, it is computed so that the direction is
                                ! to the magnetic east at the deepest observation point. Default is 361.
!	<-)	--------------------------------------------

   

        common /Zobsc/
     *	 HeightList(maxNoOfSites),
     *   DepthList(maxNoOfSites),
     *   ASHeightList(maxNoOfASSites),
     *   ASDepthList(maxNoOfASSites),
     *   LatitOfSite, LongitOfSite, DtGMT,
     *   XaxisFromSouth, YearOfGeomag,
     *   ObsPlane, NoOfSites2


!           need Zcoord.h  Zobs.h  Zpos.h Zmagfield.h
         integer NoOfSites           ! No of particle observation sites
        integer NoOfASSites
!          
         real*8 CosLatitude          ! oos of Latitude of deepest obs. site
        real*8 SinLatitude          ! sin
        real*8 CosLongitude         ! cos of Longitude
        real*8 SinLongitude         ! sin of ..

        type(coord):: DetZaxis     ! detector's Z axis in 'xyz' system
        type(coord):: DetXaxis     !  //        X    // 
        type(coord):: DetYaxis     !  //        Y    // 

        type(coord):: Xprimary     ! primary system x axis in 'xyz'
        type(coord):: Yprimary     ! primary system y axis in 'xyz'
        type(coord):: Zprimary     ! primary system z axis in 'xyz'
                                    ! these are computed in cprimxyz in
                                    ! ciniTracking in ceventLoop
        real(8)::Txyz2prim(3,3)    ! matrix to transform vector in
                              ! E-xyz into primary system
                  ! vector must be given from the oriign of
                  ! the detecor
        real(8)::Tprim2xyz(3,3)  ! inverse of Txyz2prim
        real(8)::Txyz2det(3,3) ! xyz to detector system transform mat
        real(8)::Tdet2xyz(3,3) ! inverse of above
        type(coord):: PolarInjPos  ! polar angle of the injection point in xyz.

         type(magfield):: MagfieldNED     ! mag in 'ned' at deepest obs. site
        type(magfield):: MagfieldHVA     ! mag in 'hva' at //. both in T.
        type(magfield):: MagfieldXYZ     ! mag in 'xyz' at //. both in T.

         type site
           sequence
               type(position):: pos
               real*8  zpl           ! z value in 1ry system
               real*8  mu
               real*8  minitime
         end type site 
         type assite
           sequence
               type(position):: pos
               real*8  zpl 
               real*8  mu             ! Moliere Unit
               real*8  esize          ! electron size
               real*8  age            ! size weighted age
         end type assite

          type(site):: ObsSites(0:maxNoOfSites+1)
         type(assite):: ASObsSites(maxNoOfASSites)
!            to store Ne, age of a component shower for an electron
         real*8 CompASNe(maxNoOfASSites), CompASAge(maxNoOfASSites)

         common /Zobsvc/  ASObsSites,  ObsSites,
     *     MagfieldNED, MagfieldHVA, MagfieldXYZ, 
     *     CompASNe, CompASAge,
     *     DetZaxis, DetXaxis, DetYaxis,
     *     Xprimary, Yprimary, Zprimary,
     *     Txyz2det, Tdet2xyz, Txyz2prim, Tprim2xyz,
     *     PolarInjPos, 
     *     CosLatitude, SinLatitude, CosLongitude, SinLongitude,
     *     NoOfSites,    NoOfASSites

!             ptcl kind code; kindmx is the no. of observable ptcls
!             klast; max ptcl code in the system.
!
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
!            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

!
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
!          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
!
         integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
         parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
!       kphoton: gamma ray 
!        kelec: electron, positiron
!        kmuon: muon
!        kpion: pion
!        kkaon: kaon
!        knuc: neucleon
!        kneue: electron neutrino
!       kneumu: muon neutrino
!        kgnuc: general nucleus(A>=2.)
!        kalfa: alpha  (heliunm)
!        klibe: Li, Be, B
!         kcno: C, N, O 
!         khvy: heavy such as, Na/Mg/Si
!        kvhvy: very heavy such as S/Cl/Ar
!        kiron: iron group
!        regptcl: particle index
!        antip: anti-particle index
!        klight: light normally 100 nm~1000 nm
!             subcode: kscinit scintillation light
!                      kceren  Cerekov light
!                      ksycn   synchrotron light
!        kEdepo: energy deposit in a small cell from whcih
!                scintillation lightis produced.
!        kchgPath: charged particle path form which Cerenkov
!               light is generated.
!        krare:  used to set very rare particle code
!                which might come from imported soft.
!                such as tau. They are neglected in
!                Cosmos.


      type(track):: inci
      
      type(coord):: angle
      real*4  s, e0, cosz, rmu, rhog
      real*8  hr, cnkg, mu, s8

      call cqIncident(inci, angle)
      s = ASObsSites(depindx)%age
      e0 = inci%p%fm%p(4) /1000.   ! TeV
      cosz = inci%vec%coszenith  
      mu = ASObsSites(depindx)%mu   
      rmu = r /mu   ! in Moriele unit 

      if(lat .eq. 1) then
         if(inci%p%code .eq. kphoton .or. 
     *      inci%p%code .eq. kelec) then
            if(how .eq. 1) then
               call kdig0(e0, cosz, s, rmu, rhog)
            elseif(how .eq. 2) then
               call kdigb0(e0, cosz, s, rmu, rhog)
            else
               call cerrorMsg('how is wrong in cqPtclDen.f', 0)
            endif
         else
            if(how .eq. 1) then
               call kdip0(e0, cosz, s, rmu, rhog)
            elseif(how .eq. 2) then
               call kdipb0(e0, cosz, s, rmu, rhog)
            else
               call cerrorMsg('how is wrong in cqPtclDen.f', 0)
            endif
         endif
      elseif(lat .eq. 2) then
         hr = rmu*2.
         s8 = s
         rhog = cnkg(s8, hr)
      elseif(lat .eq. 3) then
         hr = rmu
         s8 = s
         rhog = cnkg(s8, hr)
      elseif(lat .eq. 4) then
         call klee(s, rmu, rhog)
      else
         call cerrorMsg('lat is wwong in cqPtclDen', 0)
      endif
      rho = rhog * mu * mu
      if(ObsPlane .eq. 1) then
         rho =rho * cosz
      endif
      end

         





