!************************************************************************
!*                                                                      *
      block data bertbl0
!*                                                                      *
!*       Bertini model data                                             *
!*       last modified by K.Niita on 08/02/2000                         *
!*                                                                      *
!*          tapcrs(6600) : original data                                *
!*          tapcr1(352)  : old Cugnon cross section                     *
!*          tapcr2(352)  : new Cugnon cross section                     *
!*                         tapcr1,tapcr2 (i=1,352) = tapcrs(5992-6343)  *
!*                                                                      *
!*                                                                      *
!************************************************************************

!*-----------------------------------------------------------------------

      implicit real*8 (a-h,o-z)

!*-----------------------------------------------------------------------

      common/rtcom/tapcrs(6600)
      common/rtco1/tapcr1(352),tapcr2(352)

!*-----------------------------------------------------------------------

      data ( tapcrs(i),i=   1, 200 )/
     &  1.0000000D+00,  0.0000000D+00,  9.0127760D-01,  3.9488965D-01,
     &  8.3069974D-01,  6.7720091D-01,  7.6133651D-01,  9.5465392D-01,
     &  7.0149255D-01,  1.1940298D+00,  6.4999998D-01,  1.3999996D+00,
     &  6.0765851D-01,  1.5693665D+00,  5.6782335D-01,  1.7287064D+00,
     &  5.2926207D-01,  1.8829517D+00,  4.9136275D-01,  2.0345488D+00,
     &  4.5876288D-01,  2.1649485D+00,  4.2847812D-01,  2.2860870D+00,
     &  4.0052700D-01,  2.3978920D+00,  3.7333333D-01,  2.5066671D+00,
     &  3.5135132D-01,  2.5945950D+00,  3.3103448D-01,  2.6758623D+00,
     &  3.0790961D-01,  2.7683620D+00,  2.8674871D-01,  2.8530054D+00,
     &  2.6666665D-01,  2.9333334D+00,  2.4427480D-01,  3.0229006D+00,
     &  2.3255813D-01,  3.0697670D+00,  2.1800947D-01,  3.1279621D+00,
     &  2.0032310D-01,  3.1987076D+00,  1.9512194D-01,  3.2195120D+00,
     &  1.9249594D-01,  3.2300167D+00,  1.8985271D-01,  3.2405891D+00,
     &  5.0000000D-01,  1.0000000D+00,  0.0000000D+00,  1.0000000D+00,
     &  0.0000000D+00,  4.9925578D-01,  9.8807496D-01,  5.9625212D-02,
     &  9.8513800D-01,  5.9447981D-02,  4.9355435D-01,  8.9552236D-01,
     &  5.2238804D-01,  8.7272727D-01,  5.0909090D-01,  4.8889625D-01,
     &  8.2281333D-01,  8.8593328D-01,  7.8706199D-01,  8.5175204D-01,
     &  4.8738897D-01,  7.5801748D-01,  1.2099123D+00,  7.2072071D-01,
     &  1.1171169D+00,  4.9122804D-01,  6.9686413D-01,  1.5156794D+00,
     &  6.7283434D-01,  1.3086624D+00,  5.0746268D-01,  6.4705884D-01,
     &  1.7647057D+00,  6.6666669D-01,  1.3333330D+00,  5.3832227D-01,
     &  6.0538113D-01,  1.9730940D+00,  7.0588231D-01,  1.1764708D+00,
     &  5.3970486D-01,  5.9895831D-01,  2.0052080D+00,  7.0229006D-01,
     &  1.1908398D+00,  5.3358066D-01,  6.0834301D-01,  1.9582853D+00,
     &  6.9594032D-01,  1.2162390D+00,  5.3165376D-01,  6.0753340D-01,
     &  1.9623327D+00,  6.8965518D-01,  1.2413797D+00,  5.3004360D-01,
     &  6.0164660D-01,  1.9917669D+00,  6.7857140D-01,  1.2857141D+00,
     &  5.2814293D-01,  6.0625398D-01,  1.9687300D+00,  6.7857140D-01,
     &  1.2857141D+00,  5.2797204D-01,  5.9602648D-01,  2.0198679D+00,
     &  6.6666669D-01,  1.3333330D+00,  5.2729219D-01,  5.9201622D-01,
     &  2.0399189D+00,  6.6037738D-01,  1.3584909D+00,  5.2727270D-01,
     &  5.8620685D-01,  2.0689659D+00,  6.5384614D-01,  1.3846149D+00,
     &  5.2230972D-01,  5.9798992D-01,  2.8140707D+00,  6.5384614D-01,
     &  1.3846149D+00,  5.2016127D-01,  5.9689921D-01,  2.8217058D+00,
     &  6.4705884D-01,  1.4117651D+00,  5.1825839D-01,  5.8807588D-01,
     &  2.8834686D+00,  6.3265306D-01,  1.4693880D+00,  5.1585013D-01,
     &  5.8659220D-01,  2.8938551D+00,  6.2500000D-01,  1.5000000D+00,
     &  5.1331359D-01,  5.8501440D-01,  2.9048986D+00,  6.1702126D-01,
     &  1.5319147D+00,  5.1063830D-01,  5.8333331D-01,  2.9166670D+00,
     &  6.0869563D-01,  1.5652170D+00,  5.0842696D-01,  5.8011049D-01,
     &  2.9392262D+00,  6.0000002D-01,  1.6000004D+00,  5.0625199D-01,
     &  5.7631409D-01,  2.9658012D+00,  5.9090906D-01,  1.6363640D+00,
     &  5.0362796D-01,  5.7301897D-01,  2.9888668D+00,  5.8139533D-01,
     &  1.6744184D+00,  5.0135684D-01,  5.6833559D-01,  3.0216513D+00,
     &  5.7142860D-01,  1.7142859D+00,  4.9860239D-01,  5.6412053D-01,
     &  3.0511560D+00,  5.6097561D-01,  1.7560978D+00,  4.9640286D-01,
     &  5.5797100D-01,  3.0942030D+00,  5.5000001D-01,  1.8000002D+00,
     &  4.9357325D-01,  5.5729169D-01,  3.0989580D+00,  5.4314721D-01,
     &  1.8274117D+00,  4.9090910D-01,  5.5092591D-01,  3.1435184D+00/
      data ( tapcrs(i),i=  201, 400 )/
     &  5.3125000D-01,  1.8750000D+00,  4.8846155D-01,  5.5118108D-01,
     &  3.1417322D+00,  5.2631581D-01,  1.8947372D+00,  4.8570293D-01,
     &  5.4374486D-01,  3.1937857D+00,  5.1351351D-01,  1.9459457D+00,
     &  4.8297083D-01,  5.3525913D-01,  3.2531862D+00,  5.0000000D-01,
     &  2.0000000D+00,  4.8006713D-01,  5.3234267D-01,  3.2736015D+00,
     &  4.9152541D-01,  2.0338984D+00,  4.7697651D-01,  5.2276868D-01,
     &  3.3406191D+00,  4.7674417D-01,  2.0930233D+00,  4.7382551D-01,
     &  5.1558071D-01,  3.3909349D+00,  4.6428573D-01,  2.1428576D+00,
     &  4.7009349D-01,  5.0099403D-01,  3.4930420D+00,  4.4444442D-01,
     &  2.2222223D+00,  4.6717411D-01,  4.9898165D-01,  3.5071287D+00,
     &  4.3750000D-01,  2.2500000D+00,  4.6340257D-01,  4.8559231D-01,
     &  3.6008539D+00,  4.1935486D-01,  2.3225803D+00, -1.0000000D+00,
     & -9.3312496D-01, -8.6447698D-01, -7.9392940D-01, -7.2134018D-01,
     & -6.4654922D-01, -5.6937516D-01, -4.8961067D-01, -4.0701753D-01,
     & -3.2132012D-01, -2.3219579D-01, -1.3926357D-01, -4.2068690D-02,
     &  5.9939887D-02,  1.6743916D-01,  2.8127688D-01,  4.0253758D-01,
     &  5.3264618D-01,  6.7353749D-01,  8.2795268D-01,  9.9999976D-01,
     & -1.0000000D+00, -9.5523840D-01, -9.0895885D-01, -8.6102372D-01,
     & -8.1127369D-01, -7.5952321D-01, -7.0555437D-01, -6.4910787D-01,
     & -5.8987188D-01, -5.2746606D-01, -4.6141815D-01, -3.9113110D-01,
     & -3.1583142D-01, -2.3448807D-01, -1.4567614D-01, -4.7331918D-02,
     &  6.3729405D-02,  1.9288909D-01,  3.5063368D-01,  5.6362611D-01,
     &  9.9999881D-01, -1.0000000D+00, -9.6367997D-01, -9.2604977D-01,
     & -8.8698459D-01, -8.4633976D-01, -8.0394572D-01, -7.5960171D-01,
     & -7.1306747D-01, -6.6405171D-01, -6.1219585D-01, -5.5705059D-01,
     & -4.9804091D-01, -4.3441266D-01, -3.6514497D-01, -2.8880084D-01,
     & -2.0325190D-01, -1.0511851D-01,  1.1533059D-02,  1.5893567D-01,
     &  3.7143475D-01,  9.9999732D-01, -1.0000000D+00, -9.6552199D-01,
     & -9.2959529D-01, -8.9206159D-01, -8.5273337D-01, -8.1138587D-01,
     & -7.6774669D-01, -7.2148043D-01, -6.7216748D-01, -6.1927223D-01,
     & -5.6209451D-01, -4.9969327D-01, -4.3075830D-01, -3.5338432D-01,
     & -2.6464015D-01, -1.5966725D-01, -2.9562999D-02,  1.4421594D-01,
     &  4.0167308D-01,  7.4063343D-01,  9.9999976D-01, -1.0000000D+00,
     & -9.6344805D-01, -9.2510593D-01, -8.8474655D-01, -8.4209442D-01,
     & -7.9680991D-01, -7.4846810D-01, -6.9652659D-01, -6.4027750D-01,
     & -5.7877171D-01, -5.1069504D-01, -4.3415546D-01, -3.4629637D-01,
     & -2.4255407D-01, -1.1519772D-01,  4.9040455D-02,  2.6591265D-01,
     &  5.1250207D-01,  7.2031403D-01,  8.7727368D-01,  9.9999988D-01,
     & -1.0000000D+00, -9.6031350D-01, -9.1836989D-01, -8.7383717D-01,
     & -8.2630122D-01, -7.7523512D-01, -7.1995449D-01, -6.5954840D-01,
     & -5.9276700D-01, -5.1783627D-01, -4.3213415D-01, -3.3161509D-01,
     & -2.0983213D-01, -5.6950159D-02,  1.3592106D-01,  3.5137540D-01,
     &  5.4271257D-01,  6.9415963D-01,  8.1494725D-01,  9.1478413D-01,
     &  9.9999988D-01, -1.0000000D+00, -9.5694464D-01, -9.1109830D-01,
     & -8.6199349D-01, -8.0903012D-01, -7.5142050D-01, -6.8810320D-01,
     & -6.1760390D-01, -5.3780222D-01, -4.4553286D-01, -3.3592504D-01,
     & -2.0159429D-01, -3.3808824D-02,  1.6468567D-01,  3.6053306D-01,
     &  5.2376747D-01,  6.5448213D-01,  7.6155436D-01,  8.5202622D-01,
     &  9.3050694D-01,  9.9999994D-01, -1.0000000D+00, -9.5338666D-01,
     & -9.0336078D-01, -8.4927613D-01, -7.9027939D-01, -7.2521305D-01/
      data ( tapcrs(i),i=  401, 600 )/
     & -6.5245754D-01, -5.6966817D-01, -4.7333366D-01, -3.5810232D-01,
     & -2.1631885D-01, -4.1414760D-02,  1.5541852D-01,  3.3864856D-01,
     &  4.8899382D-01,  6.1053503D-01,  7.1133387D-01,  7.9736060D-01,
     &  8.7254715D-01,  9.3949932D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.5002896D-01, -8.9600337D-01, -8.3707184D-01, -7.7208018D-01,
     & -6.9941556D-01, -6.1674684D-01, -5.2059299D-01, -4.0567619D-01,
     & -2.6452577D-01, -9.0931773D-02,  1.0391408D-01,  2.8551042D-01,
     &  4.3497205D-01,  5.5605632D-01,  6.5659052D-01,  7.4244255D-01,
     &  8.1750053D-01,  8.8435006D-01,  9.4476402D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.4700384D-01, -8.8932830D-01, -8.2590371D-01,
     & -7.5524682D-01, -6.7523253D-01, -5.8271295D-01, -4.7292179D-01,
     & -3.3890551D-01, -1.7337108D-01,  1.8630728D-02,  2.0591146D-01,
     &  3.6300093D-01,  4.9006003D-01,  5.9487128D-01,  6.8382156D-01,
     &  7.6119649D-01,  8.2983541D-01,  8.9167064D-01,  9.4806248D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.4458425D-01, -8.8395041D-01,
     & -8.1682563D-01, -7.4141330D-01, -6.5508991D-01, -5.5390728D-01,
     & -4.3191451D-01, -2.8126001D-01, -9.8644018D-02,  9.5978200D-02,
     &  2.6840717D-01,  4.0846169D-01,  5.2258313D-01,  6.1817425D-01,
     &  7.0043421D-01,  7.7279150D-01,  8.3754474D-01,  8.9628643D-01,
     &  9.5015728D-01,  9.9999994D-01, -1.0000000D+00, -9.4229424D-01,
     & -8.7883687D-01, -8.0814260D-01, -7.2808200D-01, -6.3549662D-01,
     & -5.2559358D-01, -3.9134711D-01, -2.2529227D-01, -3.2333199D-02,
     &  1.5594226D-01,  3.1365937D-01,  4.4106811D-01,  5.4608983D-01,
     &  6.3518155D-01,  7.1266097D-01,  7.8138268D-01,  8.4328693D-01,
     &  8.9973849D-01,  9.5172906D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.4024187D-01, -8.7422293D-01, -8.0024362D-01, -7.1583188D-01,
     & -6.1727411D-01, -4.9892414D-01, -3.5293412D-01, -1.7391849D-01,
     &  2.2860188D-02,  2.0161569D-01,  3.4733832D-01,  4.6549118D-01,
     &  5.6390935D-01,  6.4821970D-01,  7.2212297D-01,  7.8808284D-01,
     &  8.4779388D-01,  9.0246254D-01,  9.5297498D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.3792760D-01, -8.6899596D-01, -7.9124135D-01,
     & -7.0176566D-01, -5.9616470D-01, -4.6780527D-01, -3.0846661D-01,
     & -1.1788511D-01,  7.6885223D-02,  2.4359816D-01,  3.7794363D-01,
     &  4.8779279D-01,  5.8029938D-01,  6.6028929D-01,  7.3092741D-01,
     &  7.9434264D-01,  8.5201794D-01,  9.0502191D-01,  9.5414782D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.3565387D-01, -8.6382920D-01,
     & -7.8227478D-01, -6.8762302D-01, -5.7471627D-01, -4.3597418D-01,
     & -2.6378828D-01, -6.5877616D-02,  1.2248367D-01,  2.7781612D-01,
     &  4.0289414D-01,  5.0612724D-01,  5.9389037D-01,  6.7037082D-01,
     &  7.3832512D-01,  7.9962736D-01,  8.5559797D-01,  9.0719801D-01,
     &  9.5514774D-01,  9.9999994D-01, -1.0000000D+00, -9.3333352D-01,
     & -8.5852313D-01, -7.7299380D-01, -6.7284334D-01, -5.5207527D-01,
     & -4.0228456D-01, -2.1802962D-01, -1.7236274D-02,  1.6219789D-01,
     &  3.0713254D-01,  4.2436904D-01,  5.2203828D-01,  6.0577518D-01,
     &  6.7924237D-01,  7.4486828D-01,  8.0432117D-01,  8.5878843D-01,
     &  9.0914285D-01,  9.5604348D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.3076789D-01, -8.5262233D-01, -7.6259673D-01, -6.5614074D-01,
     & -5.2629030D-01, -3.6414915D-01, -1.6901970D-01,  2.9980607D-02,
     &  1.9877988D-01,  3.3392131D-01,  4.4408697D-01,  5.3674197D-01,
     &  6.1681968D-01,  6.8752360D-01,  7.5099742D-01,  8.0872983D-01/

      data ( tapcrs(i),i= 601,800 )/
     &  8.6179155D-01,  9.1097647D-01,  9.5688909D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.2874265D-01, -8.4793216D-01, -7.5426155D-01,
     & -6.4261550D-01, -5.0524175D-01, -3.3333975D-01, -1.3181138D-01,
     &  6.3139975D-02,  2.2378236D-01,  3.5225791D-01,  4.5768845D-01,
     &  5.4696304D-01,  6.2454736D-01,  6.9334900D-01,  7.5532788D-01,
     &  8.1185615D-01,  8.6392766D-01,  9.1228420D-01,  9.5749354D-01,
     &  9.9999994D-01, -1.0000000D+00, -8.5788077D-01, -7.2368109D-01,
     & -5.9629798D-01, -4.7486120D-01, -3.5867012D-01, -2.4715048D-01,
     & -1.3982493D-01, -3.6291506D-02,  6.3791931D-02,  1.6071945D-01,
     &  2.5474602D-01,  3.4609449D-01,  4.3496066D-01,  5.2151805D-01,
     &  6.0592097D-01,  6.8830746D-01,  7.6880163D-01,  8.4751564D-01,
     &  9.2455095D-01,  9.9999988D-01, -1.0000000D+00, -6.9053251D-01,
     & -4.8534197D-01, -3.2354027D-01, -1.8702102D-01, -6.7488551D-02,
     &  3.9663084D-02,  1.3729852D-01,  2.2733921D-01,  3.1114626D-01,
     &  3.8972414D-01,  4.6383858D-01,  5.3408849D-01,  6.0095263D-01,
     &  6.6482031D-01,  7.2601342D-01,  7.8480124D-01,  8.4141171D-01,
     &  8.9603978D-01,  9.4885379D-01,  9.9999994D-01, -9.9999988D-01,
     & -4.2338705D-01, -2.1336406D-01, -6.3850045D-02,  5.6043103D-02,
     &  1.5774471D-01,  2.4692219D-01,  3.2685238D-01,  3.9962202D-01,
     &  4.6665210D-01,  5.2895933D-01,  5.8729941D-01,  6.4225096D-01,
     &  6.9426823D-01,  7.4371517D-01,  7.9088831D-01,  8.3603293D-01,
     &  8.7935448D-01,  9.2102700D-01,  9.6119934D-01,  1.0000000D+00,
     & -1.0000000D+00, -4.3509680D-01, -1.7399162D-01, -8.9353882D-03,
     &  1.1583036D-01,  2.1795279D-01,  3.0535674D-01,  3.8232619D-01,
     &  4.5145857D-01,  5.1445758D-01,  5.7250613D-01,  6.2646210D-01,
     &  6.7696917D-01,  7.2452402D-01,  7.6951844D-01,  8.1226760D-01,
     &  8.5302931D-01,  8.9201719D-01,  9.2941046D-01,  9.6536136D-01,
     &  9.9999994D-01, -1.0000000D+00, -6.6104209D-01, -3.0269569D-01,
     & -8.0107033D-02,  7.2821081D-02,  1.9082081D-01,  2.8805566D-01,
     &  3.7146837D-01,  4.4496644D-01,  5.1097143D-01,  5.7109183D-01,
     &  6.2645358D-01,  6.7787725D-01,  7.2598082D-01,  7.7124202D-01,
     &  8.1403846D-01,  8.5467416D-01,  8.9339775D-01,  9.3041557D-01,
     &  9.6590072D-01,  9.9999994D-01, -1.0000000D+00, -8.4318888D-01,
     & -6.2671143D-01, -3.4989023D-01, -1.0721141D-01,  6.7653537D-02,
     &  1.9951051D-01,  3.0551797D-01,  3.9470196D-01,  4.7211403D-01,
     &  5.4082137D-01,  6.0281754D-01,  6.5947008D-01,  7.1175820D-01,
     &  7.6040775D-01,  8.0597222D-01,  8.4888393D-01,  8.8948721D-01,
     &  9.2806107D-01,  9.6483493D-01,  9.9999994D-01, -1.0000000D+00,
     & -8.8775855D-01, -7.4697936D-01, -5.6208766D-01, -3.2754809D-01,
     & -9.6608162D-02,  8.3258569D-02,  2.2066861D-01,  3.3074552D-01,
     &  4.2279649D-01,  5.0224817D-01,  5.7242835D-01,  6.3550019D-01,
     &  6.9294220D-01,  7.4580854D-01,  7.9487681D-01,  8.4073734D-01,
     &  8.8384902D-01,  9.2457622D-01,  9.6321285D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.1096973D-01, -8.0561179D-01, -6.7641985D-01,
     & -5.1217079D-01, -3.0619115D-01, -8.8322580D-02,  9.4841123D-02,
     &  2.3801291D-01,  3.5277587D-01,  4.4832754D-01,  5.3040105D-01,
     &  6.0258204D-01,  6.6721117D-01,  7.2588670D-01,  7.7974445D-01,
     &  8.2961893D-01,  8.7614137D-01,  9.1980064D-01,  9.6098316D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.2443013D-01, -8.3795577D-01,
     & -7.3655164D-01, -6.1396879D-01, -4.6129978D-01, -2.7258068D-01/
      data ( tapcrs(i),i= 801,1000 )/
     & -6.7026794D-02,  1.1524206D-01,  2.6153207D-01,  3.7953305D-01,
     &  4.7773981D-01,  5.6191266D-01,  6.3576180D-01,  7.0173562D-01,
     &  7.6151240D-01,  8.1628495D-01,  8.6692947D-01,  9.1410720D-01,
     &  9.5832950D-01,  9.9999994D-01, -1.0000000D+00, -9.3156654D-01,
     & -8.5463411D-01, -7.6650125D-01, -6.6310376D-01, -5.3833991D-01,
     & -3.8430721D-01, -1.9834673D-01, -1.8087833D-03,  1.7138171D-01,
     &  3.1204545D-01,  4.2684770D-01,  5.2315789D-01,  6.0613644D-01,
     &  6.7919213D-01,  7.4461550D-01,  8.0399686D-01,  8.5847747D-01,
     &  9.0890157D-01,  9.5590985D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.3560207D-01, -8.6395341D-01, -7.8297198D-01, -6.8961233D-01,
     & -5.7935131D-01, -4.4578260D-01, -2.8248304D-01, -9.3978882D-02,
     &  9.2136383D-02,  2.5101167D-01,  3.8080746D-01,  4.8830968D-01,
     &  5.7966787D-01,  6.5915906D-01,  7.2966349D-01,  7.9315788D-01,
     &  8.5104001D-01,  9.0432864D-01,  9.5378679D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.3767202D-01, -8.6871672D-01, -7.9134363D-01,
     & -7.0298016D-01, -5.9985912D-01, -4.7657579D-01, -3.2670552D-01,
     & -1.4904177D-01,  3.8468406D-02,  2.0730090D-01,  3.4731698D-01,
     &  4.6290165D-01,  5.6039202D-01,  6.4459532D-01,  7.1881002D-01,
     &  7.8529871D-01,  8.4565109D-01,  9.0101659D-01,  9.5224941D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.3992776D-01, -8.7386799D-01,
     & -8.0030972D-01, -7.1712428D-01, -6.2124729D-01, -5.0827676D-01,
     & -3.7245244D-01, -2.0942712D-01, -2.6653487D-02,  1.5067703D-01,
     &  3.0305445D-01,  4.2929041D-01,  5.3500777D-01,  6.2552071D-01,
     &  7.0466733D-01,  7.7510351D-01,  8.3868718D-01,  8.9675063D-01,
     &  9.5027477D-01,  9.9999994D-01, -1.0000000D+00, -9.4113046D-01,
     & -8.7665021D-01, -8.0521244D-01, -7.2494841D-01, -6.3321066D-01,
     & -5.2623677D-01, -3.9899683D-01, -2.4666679D-01, -7.1651280D-02,
     &  1.0711074D-01,  2.6694888D-01,  4.0113318D-01,  5.1345813D-01,
     &  6.0919791D-01,  6.9249582D-01,  7.6628888D-01,  8.3264226D-01,
     &  8.9303422D-01,  9.4854873D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.4250065D-01, -8.7975895D-01, -8.1057441D-01, -7.3330241D-01,
     & -6.4564276D-01, -5.4435068D-01, -4.2500937D-01, -2.8269970D-01,
     & -1.1640942D-01,  6.1496370D-02,  2.2807831D-01,  3.7073910D-01,
     &  4.9037194D-01,  5.9188551D-01,  6.7971265D-01,  7.5711358D-01,
     &  8.2639968D-01,  8.8922322D-01,  9.4678980D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.4361854D-01, -8.8231480D-01, -8.1501395D-01,
     & -7.4026269D-01, -6.5605676D-01, -5.5960226D-01, -4.4708467D-01,
     & -3.1393015D-01, -1.5739930D-01,  1.5901424D-02,  1.8632090D-01,
     &  3.3684862D-01,  4.6420324D-01,  5.7211238D-01,  6.6505414D-01,
     &  7.4656588D-01,  8.1921023D-01,  8.8482738D-01,  9.4475818D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.4428217D-01, -8.8383698D-01,
     & -8.1766415D-01, -7.4442279D-01, -6.6228122D-01, -5.6870806D-01,
     & -4.6025401D-01, -3.3266228D-01, -1.8264425D-01, -1.3850905D-02,
     &  1.5735817D-01,  3.1248397D-01,  4.4509548D-01,  5.5758810D-01,
     &  6.5426409D-01,  7.3879731D-01,  8.1391501D-01,  8.8159043D-01,
     &  9.4326252D-01,  9.9999994D-01, -1.0000000D+00, -9.4499844D-01,
     & -8.8547432D-01, -8.2050294D-01, -7.4885595D-01, -6.6887212D-01,
     & -5.7827663D-01, -4.7398061D-01, -3.5208559D-01, -2.0902044D-01,
     & -4.5972917D-02,  1.2461305D-01,  2.8405154D-01,  4.2249149D-01,
     &  5.4033631D-01,  6.4144576D-01,  7.2957981D-01,  8.0764270D-01/
      data ( tapcrs(i),i= 1001,1200 )/
     &  8.7776273D-01,  9.4149679D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.1784364D-01, -8.3433616D-01, -7.4941832D-01, -6.6302621D-01,
     & -5.7509083D-01, -4.8553795D-01, -3.9428782D-01, -3.0125344D-01,
     & -2.0634031D-01, -1.0944575D-01, -1.0457426D-02,  9.0747297D-02,
     &  1.9430423D-01,  3.0036223D-01,  4.0908700D-01,  5.2066261D-01,
     &  6.3529474D-01,  7.5321478D-01,  8.7468404D-01,  9.9999976D-01,
     & -1.0000000D+00, -9.3795162D-01, -8.7411761D-01, -8.0835903D-01,
     & -7.4051857D-01, -6.7041695D-01, -5.9784824D-01, -5.2257442D-01,
     & -4.4431740D-01, -3.6274999D-01, -2.7748162D-01, -1.8804115D-01,
     & -9.3851089D-02,  5.8088787D-03,  1.1185604D-01,  2.2548872D-01,
     &  3.4832263D-01,  4.8262519D-01,  6.3175178D-01,  8.0104566D-01,
     &  9.9999976D-01, -1.0000000D+00, -9.5222706D-01, -9.0286273D-01,
     & -8.5176444D-01, -7.9876810D-01, -7.4368262D-01, -6.8628424D-01,
     & -6.2630707D-01, -5.6343257D-01, -4.9727327D-01, -4.2734969D-01,
     & -3.5305810D-01, -2.7362090D-01, -1.8800694D-01, -9.4802320D-02,
     &  8.0217831D-03,  1.2355596D-01,  2.5692737D-01,  4.1783839D-01,
     &  6.2955827D-01,  9.9999934D-01, -1.0000000D+00, -9.6222317D-01,
     & -9.2311066D-01, -8.8253748D-01, -8.4035861D-01, -7.9640466D-01,
     & -7.5047535D-01, -7.0233190D-01, -6.5168542D-01, -5.9818137D-01,
     & -5.4137719D-01, -4.8070890D-01, -4.1544032D-01, -3.4458023D-01,
     & -2.6674318D-01, -1.7989379D-01, -8.0834389D-02,  3.5970531D-02,
     &  1.8170023D-01,  3.8667017D-01,  9.9998552D-01, -1.0000000D+00,
     & -9.6516144D-01, -9.2901301D-01, -8.9142579D-01, -8.5224891D-01,
     & -8.1130517D-01, -7.6838332D-01, -7.2322911D-01, -6.7553186D-01,
     & -6.2490612D-01, -5.7086432D-01, -5.1277590D-01, -4.4980294D-01,
     & -3.8079363D-01, -3.0409646D-01, -2.1720612D-01, -1.1602026D-01,
     &  6.9767833D-03,  1.6828150D-01,  4.1905904D-01,  9.9999928D-01,
     & -1.0000000D+00, -9.6522039D-01, -9.2897713D-01, -8.9111012D-01,
     & -8.5142964D-01, -8.0970860D-01, -7.6567143D-01, -7.1897918D-01,
     & -6.6920751D-01, -6.1581486D-01, -5.5809385D-01, -4.9509370D-01,
     & -4.2549175D-01, -3.4736651D-01, -2.5776714D-01, -1.5181869D-01,
     & -2.0645939D-02,  1.5395820D-01,  4.0962684D-01,  7.4165094D-01,
     &  9.9999982D-01, -1.0000000D+00, -9.6322012D-01, -9.2467010D-01,
     & -8.8412976D-01, -8.4133267D-01, -7.9595232D-01, -7.4758178D-01,
     & -6.9570506D-01, -6.3965321D-01, -5.7853723D-01, -5.1113909D-01,
     & -4.3572867D-01, -3.4973705D-01, -2.4914712D-01, -1.2731618D-01,
     &  2.7039226D-02,  2.2956538D-01,  4.7349757D-01,  6.9613290D-01,
     &  8.6728698D-01,  9.9999982D-01, -1.0000000D+00, -9.5969981D-01,
     & -9.1712588D-01, -8.7194812D-01, -8.2375574D-01, -7.7202839D-01,
     & -7.1609396D-01, -6.5506285D-01, -5.8772576D-01, -5.1238465D-01,
     & -4.2656904D-01, -3.2655114D-01, -2.0657891D-01, -5.8248814D-02,
     &  1.2596667D-01,  3.3378631D-01,  5.2573001D-01,  6.8180692D-01,
     &  8.0739212D-01,  9.1134506D-01,  9.9999988D-01, -1.0000000D+00,
     & -9.5510387D-01, -9.0722835D-01, -8.5586649D-01, -8.0036676D-01,
     & -7.3987299D-01, -6.7323196D-01, -5.9884596D-01, -5.1443464D-01,
     & -4.1665679D-01, -3.0059606D-01, -1.5963107D-01,  1.1211280D-02,
     &  2.0204568D-01,  3.8300025D-01,  5.3508908D-01,  6.5974528D-01,
     &  7.6376832D-01,  8.5277611D-01,  9.3064380D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.5018482D-01, -8.9655185D-01, -8.3835453D-01,
     & -7.7460307D-01, -7.0395201D-01, -6.2452292D-01, -5.3362864D-01/

      data ( tapcrs(i),i=1201,1400 )/
     & -4.2738497D-01, -3.0042827D-01, -1.4717841D-01,  3.0762751D-02,
     &  2.1328855D-01,  3.7548864D-01,  5.1049203D-01,  6.2281829D-01,
     &  7.1820951D-01,  8.0102408D-01,  8.7429208D-01,  9.4011891D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.4573057D-01, -8.8679588D-01,
     & -8.2217783D-01, -7.5049210D-01, -6.6980851D-01, -5.7737607D-01,
     & -4.6926105D-01, -3.4019363D-01, -1.8527257D-01, -7.8740008D-03,
     &  1.7114097D-01,  3.2925797D-01,  4.6124065D-01,  5.7158220D-01,
     &  6.6567129D-01,  7.4760705D-01,  8.2026297D-01,  8.8565177D-01,
     &  9.4521236D-01,  9.9999994D-01, -1.0000000D+00, -9.4147122D-01,
     & -8.7740588D-01, -8.0648410D-01, -7.2687727D-01, -6.3599700D-01,
     & -5.3016073D-01, -4.0440434D-01, -2.5375736D-01, -7.9806268D-02,
     &  9.9505305D-02,  2.6091939D-01,  3.9664966D-01,  5.1017469D-01,
     &  6.0680544D-01,  6.9077122D-01,  7.6507664D-01,  8.3183265D-01,
     &  8.9254820D-01,  9.4832784D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.3700790D-01, -8.6747146D-01, -7.8969216D-01, -7.0127815D-01,
     & -5.9882563D-01, -4.7765356D-01, -3.3252394D-01, -1.6260344D-01,
     &  1.8119588D-02,  1.8535995D-01,  3.2731956D-01,  4.4589710D-01,
     &  5.4639643D-01,  6.3334227D-01,  7.0999509D-01,  7.7864599D-01,
     &  8.4092569D-01,  8.9802200D-01,  9.5082116D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.3210226D-01, -8.5648751D-01, -7.7099615D-01,
     & -6.7256343D-01, -5.5690897D-01, -4.1878051D-01, -2.5515354D-01,
     & -7.4726403D-02,  9.9190891D-02,  2.4962091D-01,  3.7541151D-01,
     &  4.8150015D-01,  5.7275546D-01,  6.5279621D-01,  7.2417521D-01,
     &  7.8870231D-01,  8.4768736D-01,  9.0210176D-01,  9.5268226D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.2690921D-01, -8.4473062D-01,
     & -7.5073123D-01, -6.4103895D-01, -5.1053452D-01, -3.5454065D-01,
     & -1.7626882D-01,  4.4287816D-03,  1.6529226D-01,  3.0031151D-01,
     &  4.1348964D-01,  5.1009959D-01,  5.9425896D-01,  6.6888833D-01,
     &  7.3604542D-01,  7.9720628D-01,  8.5345519D-01,  9.0560800D-01,
     &  9.5429218D-01,  9.9999994D-01, -1.0000000D+00, -9.2119068D-01,
     & -8.3167994D-01, -7.2804666D-01, -6.0555249D-01, -4.5874518D-01,
     & -2.8617704D-01, -1.0119593D-01,  7.1093440D-02,  2.1757221D-01,
     &  3.3979833D-01,  4.4323009D-01,  5.3258955D-01,  6.1128289D-01,
     &  6.8169951D-01,  7.4553680D-01,  8.0402839D-01,  8.5809344D-01,
     &  9.0843236D-01,  9.5559049D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.1520852D-01, -8.1789762D-01, -7.0387357D-01, -5.6763846D-01,
     & -4.0460157D-01, -2.1997017D-01, -3.6549706D-02,  1.2408340D-01,
     &  2.5811607D-01,  3.7045294D-01,  4.6650618D-01,  5.5034614D-01,
     &  6.2482816D-01,  6.9195861D-01,  7.5317734D-01,  8.0954367D-01,
     &  8.6185610D-01,  9.1073000D-01,  9.5664907D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.0974915D-01, -8.0521792D-01, -6.8150002D-01,
     & -5.3273034D-01, -3.5670149D-01, -1.6658777D-01,  1.0872558D-02,
     &  1.6130304D-01,  2.8635985D-01,  3.9188957D-01,  4.8288673D-01,
     &  5.6291783D-01,  6.3446665D-01,  6.9928819D-01,  7.5865334D-01,
     &  8.1350607D-01,  8.6456436D-01,  9.1238612D-01,  9.5741284D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.5474732D-01, -9.0797156D-01,
     & -8.5953504D-01, -8.0927891D-01, -7.5701791D-01, -7.0253474D-01,
     & -6.4557099D-01, -5.8581614D-01, -5.2289140D-01, -4.5632708D-01,
     & -3.8552970D-01, -3.0973125D-01, -2.2790891D-01, -1.3865066D-01,
     & -3.9914124D-02,  7.1447670D-02,  2.0074219D-01,  3.5828817D-01/
      data ( tapcrs(i),i=1401,1600 )/
     &  5.7023323D-01,  9.9999905D-01, -1.0000000D+00, -9.6515286D-01,
     & -9.2897826D-01, -8.9134371D-01, -8.5209447D-01, -8.1104821D-01,
     & -7.6798719D-01, -7.2264880D-01, -6.7471129D-01, -6.2377453D-01,
     & -5.6933063D-01, -5.1072037D-01, -4.4706392D-01, -3.7714565D-01,
     & -2.9921085D-01, -2.1057701D-01, -1.0680532D-01,  2.0348281D-02,
     &  1.8931282D-01,  4.5787227D-01,  9.9999946D-01, -1.0000000D+00,
     & -9.6465778D-01, -9.2774224D-01, -8.8907164D-01, -8.4842902D-01,
     & -8.0555195D-01, -7.6011866D-01, -7.1172827D-01, -6.5987200D-01,
     & -6.0388935D-01, -5.4290086D-01, -4.7569704D-01, -4.0054822D-01,
     & -3.1485701D-01, -2.1447420D-01, -9.2242360D-02,  6.5219641D-02,
     &  2.8202093D-01,  5.6381589D-01,  8.1718135D-01,  9.9999988D-01,
     & -1.0000000D+00, -9.5966858D-01, -9.1698384D-01, -8.7159079D-01,
     & -8.2304406D-01, -7.7077407D-01, -7.1403587D-01, -6.5182990D-01,
     & -5.8277279D-01, -5.0488096D-01, -4.1519260D-01, -3.0910605D-01,
     & -1.7935860D-01, -1.5808716D-02,  1.8529671D-01,  3.9437628D-01,
     &  5.7112050D-01,  7.1097803D-01,  8.2400483D-01,  9.1855681D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.5546091D-01, -9.0787077D-01,
     & -8.5668892D-01, -8.0121267D-01, -7.4050552D-01, -6.7328376D-01,
     & -5.9772897D-01, -5.1117039D-01, -4.0955031D-01, -2.8664619D-01,
     & -1.3395101D-01,  5.2781019D-02,  2.5250065D-01,  4.2817038D-01,
     &  5.6967193D-01,  6.8442214D-01,  7.8031117D-01,  8.6272919D-01,
     &  9.3518162D-01,  9.9999994D-01, -1.0000000D+00, -9.5273095D-01,
     & -9.0191084D-01, -8.4684879D-01, -7.8662604D-01, -7.1998596D-01,
     & -6.4515340D-01, -5.5953121D-01, -4.5919204D-01, -3.3814514D-01,
     & -1.8820751D-01, -4.9517751D-03,  1.9246984D-01,  3.6785293D-01,
     &  5.0975674D-01,  6.2491304D-01,  7.2109592D-01,  8.0370867D-01,
     &  8.7628329D-01,  9.4117284D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.5004457D-01, -8.9601034D-01, -8.3703375D-01, -7.7194101D-01,
     & -6.9908589D-01, -6.1607856D-01, -5.1932925D-01, -4.0335667D-01,
     & -2.6036495D-01, -8.4096611D-02,  1.1258978D-01,  2.9360336D-01,
     &  4.4144511D-01,  5.6097960D-01,  6.6024494D-01,  7.4507523D-01,
     &  8.1929857D-01,  8.8545245D-01,  9.4527519D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.4771069D-01, -8.9084876D-01, -8.2837582D-01,
     & -7.5885326D-01, -6.8021959D-01, -5.8941424D-01, -4.8176640D-01,
     & -3.5028833D-01, -1.8688828D-01,  5.8203787D-03,  1.9699484D-01,
     &  3.5770959D-01,  4.8701793D-01,  5.9312946D-01,  6.8284005D-01,
     &  7.6066679D-01,  8.2957351D-01,  8.9156199D-01,  9.4803298D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.4592154D-01, -8.8687217D-01,
     & -8.2166398D-01, -7.4862754D-01, -6.6533256D-01, -5.6811649D-01,
     & -4.5136678D-01, -3.0709749D-01, -1.2912631D-01,  6.8450272D-02,
     &  2.4875021D-01,  3.9538068D-01,  5.1385552D-01,  6.1228675D-01,
     &  6.9646090D-01,  7.7015668D-01,  8.3587593D-01,  8.9533269D-01,
     &  9.4974357D-01,  9.9999994D-01, -1.0000000D+00, -9.4437110D-01,
     & -8.8341355D-01, -8.1579936D-01, -7.3963958D-01, -6.5214902D-01,
     & -5.4908562D-01, -4.2398232D-01, -2.6838219D-01, -8.0068648D-02,
     &  1.1616290D-01,  2.8562915D-01,  4.2190868D-01,  5.3286290D-01,
     &  6.2596554D-01,  7.0625645D-01,  7.7702081D-01,  8.4045529D-01,
     &  8.9808238D-01,  9.5099455D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.4319689D-01, -8.8078326D-01, -8.1131649D-01, -7.3272568D-01,
     & -6.4192808D-01, -5.3419745D-01, -4.0240413D-01, -2.3814243D-01/
      data ( tapcrs(i),i=1601,1800 )/
     & -4.3835081D-02,  1.4876527D-01,  3.1006980D-01,  4.3949670D-01,
     &  5.4556108D-01,  6.3517481D-01,  7.1289450D-01,  7.8169715D-01,
     &  8.4358865D-01,  8.9997053D-01,  9.5185614D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.4194156D-01, -8.7796533D-01, -8.0650032D-01,
     & -7.2527027D-01, -6.3085490D-01, -5.1798677D-01, -3.7888211D-01,
     & -2.0581532D-01, -7.4911006D-03,  1.7948508D-01,  3.3265042D-01,
     &  4.5574361D-01,  5.5733645D-01,  6.4374769D-01,  7.1909302D-01,
     &  7.8607422D-01,  8.4652662D-01,  9.0174329D-01,  9.5266587D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.4105405D-01, -8.7596601D-01,
     & -8.0306840D-01, -7.1992892D-01, -6.2286943D-01, -5.0621390D-01,
     & -3.6175179D-01, -1.8271077D-01,  1.7110121D-02,  1.9945979D-01,
     &  3.4723204D-01,  4.6628428D-01,  5.6502372D-01,  6.4937538D-01,
     &  7.2318065D-01,  7.8897154D-01,  8.4847742D-01,  9.0292346D-01,
     &  9.5320612D-01,  9.9999994D-01, -1.0000000D+00, -9.3986768D-01,
     & -8.7328815D-01, -7.9845947D-01, -7.1273100D-01, -6.1206311D-01,
     & -4.9022132D-01, -3.3854413D-01, -1.5228772D-01,  4.7694791D-02,
     &  2.2346300D-01,  3.6464596D-01,  4.7889900D-01,  5.7425380D-01,
     &  6.5615177D-01,  7.2811365D-01,  7.9247391D-01,  8.5083866D-01,
     &  9.0435332D-01,  9.5386106D-01,  9.9999994D-01, -1.0000000D+00,
     & -9.3882328D-01, -8.7092441D-01, -7.9437745D-01, -7.0632863D-01,
     & -6.0240203D-01, -4.7586167D-01, -3.1780124D-01, -1.2603891D-01,
     &  7.2603047D-02,  2.4249291D-01,  3.7841678D-01,  4.8891085D-01,
     &  5.8160955D-01,  6.6157079D-01,  7.3206937D-01,  7.9528850D-01,
     &  8.5273939D-01,  9.0550584D-01,  9.5438963D-01,  9.9999994D-01,
     & -1.0000000D+00, -9.3782640D-01, -8.6866266D-01, -7.9045874D-01,
     & -7.0015723D-01, -5.9304488D-01, -4.6190435D-01, -2.9777563D-01,
     & -1.0161740D-01,  9.4689548D-02,  2.5907177D-01,  3.9041227D-01,
     &  4.9766427D-01,  5.8806461D-01,  6.6634101D-01,  7.3556006D-01,
     &  7.9777700D-01,  8.5442245D-01,  9.0652764D-01,  9.5485866D-01,
     &  9.9999994D-01, -1.0000000D+00, -9.3656057D-01, -8.6578262D-01,
     & -7.8545189D-01, -6.9223768D-01, -5.8097804D-01, -4.4385612D-01,
     & -2.7217954D-01, -7.1801722D-02,  1.2040854D-01,  2.7810723D-01,
     &  4.0419799D-01,  5.0776207D-01,  5.9553808D-01,  6.7187989D-01,
     &  7.3962247D-01,  8.0067825D-01,  8.5638750D-01,  9.0772194D-01,
     &  9.5540738D-01,  9.9999994D-01, -1.0000000D+00, -9.3575716D-01,
     & -8.6395049D-01, -7.8225690D-01, -6.8716502D-01, -5.7321721D-01,
     & -4.3223363D-01, -2.5593144D-01, -5.3707235D-02,  1.3543469D-01,
     &  2.8912467D-01,  4.1218805D-01,  5.1363337D-01,  5.9989607D-01,
     &  6.7511731D-01,  7.4200112D-01,  8.0237937D-01,  8.5754085D-01,
     &  9.0842348D-01,  9.5572990D-01,  9.9999994D-01,  1.0000001D-26,
     &  1.4000001D-26,  1.6999999D-26,  2.5000000D-26,  3.2000001D-26,
     &  3.8000000D-26,  4.5000000D-26,  4.2999998D-26,  4.0000000D-26,
     &  3.8000000D-26,  3.2000001D-26,  2.5000000D-26,  2.1000001D-26,
     &  1.6000000D-26,  1.2000001D-26,  7.9999987D-27,  5.0000007D-27,
     &  2.0000001D-27,  0.0000000D+00,  1.0000001D-26,  1.4000001D-26,
     &  1.7000002D-26,  2.5000000D-26,  3.2000000D-26,  3.8000002D-26,
     &  4.4999998D-26,  4.3000000D-26,  4.0000000D-26,  3.8000002D-26,
     &  3.2000000D-26,  2.5000000D-26,  2.1000002D-26,  1.5999997D-26,
     &  1.1999998D-26,  7.9999986D-27,  5.0000000D-27,  2.0000000D-27,
     &  0.0000000D+00,  6.6000000D+02,  1.6157001D-01,  8.2629979D-02/

      data ( tapcrs(i),i=1801,2000 )/
     &  1.3814002D-01,  2.1460003D-01,  1.6280001D-01,  2.4026000D-01,
     &  5.0000000D-01,  8.0000000D+02,  1.5381998D-01,  1.3207000D-01,
     &  1.9955999D-01,  2.4044001D-01,  1.3415003D-01,  1.3997000D-01,
     &  5.0000000D-01,  9.3000000D+02,  2.0169997D-01,  1.3169998D-01,
     &  1.8089998D-01,  2.6010001D-01,  1.4969999D-01,  7.5919986D-02,
     &  5.0000000D-01,  1.0000000D+03,  1.9009000D-01,  1.6614002D-01,
     &  2.2601002D-01,  2.2033000D-01,  1.0162997D-01,  9.5790029D-02,
     &  5.0000000D-01,  1.5000000D+03,  2.9960001D-01,  2.1249998D-01,
     &  2.4940002D-01,  1.8599999D-01,  4.4590000D-02,  7.8039989D-03,
     &  5.0000000D-01,  2.2400000D+03,  3.9399999D-01,  2.3140001D-01,
     &  2.0940000D-01,  1.0869998D-01,  2.8269999D-02,  2.8269999D-02,
     &  5.0000000D-01,  2.7500000D+03,  4.7350001D-01,  2.6789999D-01,
     &  1.9279999D-01,  5.5459999D-02,  3.4129999D-03,  6.8259984D-03,
     &  5.0000000D-01,  4.4000000D+03,  6.5329999D-01,  1.7540002D-01,
     &  1.0310000D-01,  4.4009998D-02,  1.3750002D-02,  1.0450002D-02,
     &  5.0000000D-01,  6.6000000D+02,  1.6157001D-01,  8.2629979D-02,
     &  1.3814002D-01,  2.1460003D-01,  1.6280001D-01,  2.4026000D-01,
     &  4.7399998D-01,  8.0000000D+02,  1.5381998D-01,  1.3207000D-01,
     &  1.9955999D-01,  2.4044001D-01,  1.3415003D-01,  1.3997000D-01,
     &  4.5700002D-01,  9.3000000D+02,  2.0169997D-01,  1.3169998D-01,
     &  1.8089998D-01,  2.6010001D-01,  1.4969999D-01,  7.5919986D-02,
     &  4.4000000D-01,  1.0000000D+03,  1.9009000D-01,  1.6614002D-01,
     &  2.2601002D-01,  2.2033000D-01,  1.0162997D-01,  9.5790029D-02,
     &  4.3099999D-01,  1.5000000D+03,  2.9960001D-01,  2.1249998D-01,
     &  2.4940002D-01,  1.8599999D-01,  4.4590000D-02,  7.8039989D-03,
     &  3.6799997D-01,  2.2400000D+03,  3.9399999D-01,  2.3140001D-01,
     &  2.0940000D-01,  1.0869998D-01,  2.8269999D-02,  2.8269999D-02,
     &  2.7300000D-01,  2.7500000D+03,  4.7350001D-01,  2.6789999D-01,
     &  1.9279999D-01,  5.5459999D-02,  3.4129999D-03,  6.8259984D-03,
     &  2.0800000D-01,  4.4000000D+03,  6.5329999D-01,  1.7540002D-01,
     &  1.0310000D-01,  4.4009998D-02,  1.3750002D-02,  1.0450002D-02,
     &  1.5799999D-01,  0.0000000D+00,  2.0000000D-28,  4.0000005D-28,
     &  7.0000004D-28,  1.3000000D-27,  2.0000001D-27,  3.2000000D-27,
     &  4.4999985D-27,  5.7000008D-27,  7.2499984D-27,  9.0000001D-27,
     &  1.1200001D-26,  1.2629999D-26,  1.4100001D-26,  1.5250000D-26,
     &  1.6299999D-26,  1.7099999D-26,  1.7630000D-26,  1.8129999D-26,
     &  1.8499999D-26,  1.8800001D-26,  1.9099999D-26,  1.9300000D-26,
     &  1.9550001D-26,  1.9700002D-26,  1.9799999D-26,  2.0100000D-26,
     &  2.0200001D-26,  2.0399998D-26,  2.0599999D-26,  2.0700000D-26,
     &  2.0800000D-26,  2.0879999D-26,  2.0900001D-26,  2.1000001D-26,
     &  2.1050001D-26,  2.1099999D-26,  2.1120000D-26,  2.1120000D-26,
     &  2.1120000D-26,  2.1120000D-26,  2.1099999D-26,  2.1099999D-26,
     &  2.1060001D-26,  2.1039999D-26,  2.1000001D-26,  2.0950001D-26,
     &  2.0900001D-26,  2.0869999D-26,  2.0840001D-26,  2.0810000D-26,
     &  2.0780001D-26,  2.0750000D-26,  2.0700000D-26,  2.0650000D-26,
     &  2.0599999D-26,  2.0549999D-26,  2.0499999D-26,  2.0439999D-26,
     &  2.0380000D-26,  2.0320000D-26,  2.0260000D-26,  2.0200001D-26,
     &  2.0100000D-26,  2.0000000D-26,  1.9899999D-26,  1.9849999D-26,
     &  1.9799999D-26,  1.9749999D-26,  1.9650001D-26,  1.9600001D-26,
     &  2.0499999D-26,  1.9450000D-26,  1.9369999D-26,  1.9300000D-26/
      data ( tapcrs(i),i=2001,2200 )/
     &  1.9250000D-26,  1.9199999D-26,  1.9099999D-26,  1.9000001D-26,
     &  1.8900001D-26,  1.8800001D-26,  1.8750000D-26,  1.8700000D-26,
     &  1.8669999D-26,  1.8549999D-26,  1.8449999D-26,  1.8370001D-26,
     &  1.8300001D-26,  1.8250001D-26,  1.8119999D-26,  1.8100001D-26,
     &  1.8000000D-26,  1.7900000D-26,  1.7799999D-26,  1.7749999D-26,
     &  1.7699999D-26,  1.7600001D-26,  1.7500001D-26,  1.7400001D-26,
     &  1.7300000D-26,  1.7200000D-26,  1.7120001D-26,  1.7099999D-26,
     &  1.6949999D-26,  1.6870000D-26,  1.6800001D-26,  1.6700000D-26,
     &  1.6600000D-26,  1.6500000D-26,  1.6399999D-26,  1.6299999D-26,
     &  1.6200001D-26,  1.6100001D-26,  1.6000000D-26,  1.5900000D-26,
     &  1.5800000D-26,  1.5699999D-26,  1.5599999D-26,  1.5500001D-26,
     &  1.5369999D-26,  1.5250000D-26,  1.5120001D-26,  1.4999999D-26,
     &  1.4899999D-26,  1.4800001D-26,  1.4700001D-26,  1.4600000D-26,
     &  1.4399999D-26,  1.4299999D-26,  1.4199999D-26,  1.4100001D-26,
     &  1.3900000D-26,  1.3800000D-26,  1.3699999D-26,  1.3599999D-26,
     &  1.3400001D-26,  1.3250001D-26,  1.3119999D-26,  1.2999999D-26,
     &  1.2799998D-26,  1.2700001D-26,  1.2500000D-26,  1.2400000D-26,
     &  1.2249999D-26,  1.2099998D-26,  1.1900001D-26,  1.1700000D-26,
     &  1.1599999D-26,  1.1400002D-26,  1.1200001D-26,  1.1100000D-26,
     &  1.0799999D-26,  1.0700001D-26,  1.0600001D-26,  1.0369999D-26,
     &  1.0199999D-26,  9.9999983D-27,  9.8000005D-27,  0.0000000D+00,
     &  2.0000000D-28,  2.9999999D-28,  5.9999998D-28,  7.0000004D-28,
     &  8.4999994D-28,  1.1000001D-27,  1.2500000D-27,  1.4000001D-27,
     &  1.6000000D-27,  1.7500001D-27,  1.9000000D-27,  2.0999999D-27,
     &  2.3000000D-27,  2.5000000D-27,  2.6500001D-27,  2.8000000D-27,
     &  3.0000001D-27,  3.2000000D-27,  3.2999993D-27,  3.5000002D-27,
     &  3.7000011D-27,  3.8000015D-27,  4.0999998D-27,  4.2000002D-27,
     &  4.3500009D-27,  4.5499987D-27,  4.6999994D-27,  4.7999998D-27,
     &  5.0000007D-27,  5.1999985D-27,  5.3999994D-27,  5.5500001D-27,
     &  5.7000008D-27,  5.8000012D-27,  5.9999990D-27,  6.1999999D-27,
     &  6.3000003D-27,  6.5000012D-27,  6.6249987D-27,  6.7999995D-27,
     &  6.8999999D-27,  7.1000008D-27,  7.2999986D-27,  7.3999991D-27,
     &  7.6000000D-27,  7.7000004D-27,  7.8500011D-27,  7.9999987D-27,
     &  8.1999996D-27,  8.3000000D-27,  8.4000005D-27,  8.6000014D-27,
     &  8.6999987D-27,  8.8499994D-27,  9.0000001D-27,  9.2000009D-27,
     &  9.2500012D-27,  9.3999988D-27,  9.4999992D-27,  9.7000001D-27,
     &  9.7500003D-27,  9.8500008D-27,  9.9999983D-27,  1.0130000D-26,
     &  1.0249999D-26,  1.0400000D-26,  1.0500001D-26,  1.0650001D-26,
     &  1.0749999D-26,  1.0849999D-26,  1.0899999D-26,  1.1100000D-26,
     &  1.1200001D-26,  1.1300001D-26,  1.1400002D-26,  1.1549999D-26,
     &  1.1650000D-26,  1.1750000D-26,  1.1800000D-26,  1.1900001D-26,
     &  1.2050001D-26,  1.2130000D-26,  1.2249999D-26,  1.2299999D-26,
     &  1.2400000D-26,  1.2500000D-26,  1.2600001D-26,  1.2700001D-26,
     &  1.2750001D-26,  1.2799998D-26,  1.2849999D-26,  1.2999999D-26,
     &  1.3100000D-26,  1.3200000D-26,  1.3250001D-26,  1.3300001D-26,
     &  1.3379999D-26,  1.3450001D-26,  1.3549999D-26,  1.3649999D-26,
     &  1.3699999D-26,  1.3750000D-26,  1.3800000D-26,  1.3850000D-26,
     &  1.3900000D-26,  1.4000001D-26,  1.4050001D-26,  1.4100001D-26,
     &  1.4120000D-26,  1.4199999D-26,  1.4249999D-26,  1.4299999D-26,
     &  1.4349999D-26,  1.4399999D-26,  1.4450000D-26,  1.4500000D-26/
      data ( tapcrs(i),i=2201,2400 )/
     &  1.4550000D-26,  1.4600000D-26,  1.4679999D-26,  1.4700001D-26,
     &  1.4729999D-26,  1.4750001D-26,  1.4779999D-26,  1.4800001D-26,
     &  1.4850001D-26,  1.4870000D-26,  1.4899999D-26,  1.4920001D-26,
     &  1.4949999D-26,  0.0000000D+00,  1.0000000D-28,  2.0000000D-28,
     &  2.9999999D-28,  4.9999992D-28,  7.9999991D-28,  1.3000000D-27,
     &  2.2500000D-27,  3.2499991D-27,  3.9999993D-27,  5.0000007D-27,
     &  5.7500010D-27,  6.4000008D-27,  6.6999990D-27,  7.4999995D-27,
     &  7.8000009D-27,  8.2499998D-27,  8.6000014D-27,  8.8499994D-27,
     &  9.1250006D-27,  9.3499985D-27,  9.5499994D-27,  9.7000001D-27,
     &  9.8000005D-27,  9.9000010D-27,  9.9999983D-27,  1.0099999D-26,
     &  1.0149999D-26,  1.0199999D-26,  1.0300000D-26,  1.0350000D-26,
     &  1.0400000D-26,  1.0450000D-26,  1.0479999D-26,  1.0500001D-26,
     &  1.0519999D-26,  1.0550001D-26,  1.0600001D-26,  1.0600001D-26,
     &  1.0600001D-26,  1.0600001D-26,  1.0600001D-26,  1.0600001D-26,
     &  1.0600001D-26,  1.0600001D-26,  1.0550001D-26,  1.0500001D-26,
     &  1.0500001D-26,  1.0500001D-26,  1.0450000D-26,  1.0440001D-26,
     &  1.0419999D-26,  1.0400000D-26,  1.0380001D-26,  1.0359999D-26,
     &  1.0340000D-26,  1.0319999D-26,  1.0300000D-26,  1.0249999D-26,
     &  1.0230001D-26,  1.0199999D-26,  1.0149999D-26,  1.0120001D-26,
     &  1.0120001D-26,  1.0099999D-26,  1.0049999D-26,  9.9999983D-27,
     &  9.9500012D-27,  9.9199998D-27,  9.8899985D-27,  9.8600002D-27,
     &  9.8299988D-27,  9.8000005D-27,  9.7599997D-27,  9.7199989D-27,
     &  9.6800012D-27,  9.6400004D-27,  9.5999996D-27,  9.5499994D-27,
     &  9.4999992D-27,  9.4499990D-27,  9.3999988D-27,  9.3749986D-27,
     &  9.3499985D-27,  9.3000014D-27,  9.2500012D-27,  9.2000009D-27,
     &  9.1500007D-27,  9.1250006D-27,  9.1000005D-27,  9.0500003D-27,
     &  9.0000001D-27,  8.9499998D-27,  8.8999996D-27,  8.8749995D-27,
     &  8.8700013D-27,  8.7749990D-27,  8.7499989D-27,  8.6999987D-27,
     &  8.6749986D-27,  8.6499985D-27,  8.6000014D-27,  8.5500011D-27,
     &  8.5000009D-27,  8.4500007D-27,  8.4000005D-27,  8.3500002D-27,
     &  8.3000000D-27,  8.2499998D-27,  8.1999996D-27,  8.1499993D-27,
     &  8.0999991D-27,  8.0499989D-27,  7.9999987D-27,  7.9499985D-27,
     &  7.9000013D-27,  7.8500011D-27,  7.8000009D-27,  7.7500006D-27,
     &  7.7000004D-27,  7.6500002D-27,  7.6000000D-27,  7.4999995D-27,
     &  7.4900001D-27,  7.4300005D-27,  7.3700008D-27,  7.3100011D-27,
     &  7.2499984D-27,  7.1799993D-27,  7.1100003D-27,  7.0400012D-27,
     &  6.9699990D-27,  6.8999999D-27,  6.8749998D-27,  6.7999995D-27,
     &  6.7499993D-27,  6.6999990D-27,  6.6249987D-27,  6.5999986D-27,
     &  6.4500010D-27,  6.3500006D-27,  6.3000003D-27,  6.2500001D-27,
     &  6.1999999D-27,  6.0999995D-27,  5.9999990D-27,  5.8500014D-27,
     &  5.8000012D-27,  5.7500010D-27,  5.7000008D-27,  5.6000003D-27,
     &  5.4999999D-27,  5.3999994D-27,  5.2999990D-27,  5.1999985D-27,
     &  5.1000012D-27,  5.0000007D-27,  4.9000003D-27,  0.0000000D+00,
     &  1.8000000D-28,  2.4999996D-28,  4.5000008D-28,  5.9999998D-28,
     &  7.5000007D-28,  8.9999997D-28,  1.1000001D-27,  1.2500000D-27,
     &  1.3500000D-27,  1.5500000D-27,  1.7000001D-27,  1.7999999D-27,
     &  2.0500001D-27,  2.2000000D-27,  2.3500001D-27,  2.5000000D-27,
     &  2.6500001D-27,  2.8000000D-27,  3.0000001D-27,  3.2000000D-27,
     &  3.2999993D-27,  3.3999997D-27,  3.6000006D-27,  3.7500013D-27,
     &  3.8999989D-27,  4.1500000D-27,  4.2000002D-27,  4.3500009D-27/

      data ( tapcrs(i),i=2401,2600 )/
     &  4.4999985D-27,  4.6999994D-27,  4.7999998D-27,  4.9000003D-27,
     &  5.1500014D-27,  5.2499987D-27,  5.3999994D-27,  5.6000003D-27,
     &  5.7000008D-27,  5.8000012D-27,  5.9999990D-27,  6.1499997D-27,
     &  6.2500001D-27,  6.4000008D-27,  6.5999986D-27,  6.6999990D-27,
     &  6.7999995D-27,  6.8999999D-27,  7.1000008D-27,  7.2999986D-27,
     &  7.3999991D-27,  7.5499998D-27,  7.6500002D-27,  7.8000009D-27,
     &  7.9000013D-27,  8.0999991D-27,  8.1999996D-27,  8.3000000D-27,
     &  8.4000005D-27,  8.6000014D-27,  8.6999987D-27,  8.7999992D-27,
     &  8.8999996D-27,  9.1000005D-27,  9.2000009D-27,  9.3000014D-27,
     &  9.3999988D-27,  9.5999996D-27,  9.7000001D-27,  9.8000005D-27,
     &  9.8699996D-27,  9.9500012D-27,  1.0149999D-26,  1.0199999D-26,
     &  1.0300000D-26,  1.0400000D-26,  1.0500001D-26,  1.0600001D-26,
     &  1.0700001D-26,  1.0799999D-26,  1.0899999D-26,  1.1000000D-26,
     &  1.1150000D-26,  1.1200001D-26,  1.1250001D-26,  1.1300001D-26,
     &  1.1400002D-26,  1.1499999D-26,  1.1599999D-26,  1.1700000D-26,
     &  1.1730001D-26,  1.1750000D-26,  1.1800000D-26,  1.1850000D-26,
     &  1.1900001D-26,  1.1950001D-26,  1.2050001D-26,  1.2099998D-26,
     &  1.2130000D-26,  1.2170001D-26,  1.2199999D-26,  1.2230000D-26,
     &  1.2249999D-26,  1.2249999D-26,  1.2270001D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,  1.2299999D-26,
     &  1.2299999D-26,  1.2299999D-26,  1.2290000D-26,  1.2280000D-26,
     &  1.2270001D-26,  7.5957203D-01,  7.6007801D-01,  7.6024699D-01,
     &  7.6075602D-01,  7.6160902D-01,  7.6195198D-01,  7.6246697D-01,
     &  7.6333100D-01,  7.6367801D-01,  7.6420099D-01,  7.6507598D-01,
     &  7.6560402D-01,  7.6631200D-01,  7.6702297D-01,  7.6773798D-01,
     &  7.6845598D-01,  7.6917899D-01,  7.7008802D-01,  7.7045298D-01,
     &  7.7173901D-01,  7.7229398D-01,  7.7359802D-01,  7.7416003D-01,
     &  7.7548200D-01,  7.7605200D-01,  7.7739298D-01,  7.7816403D-01,
     &  7.7972001D-01,  7.8070199D-01,  7.8188902D-01,  7.8348702D-01,
     &  7.8308600D-01,  7.8591901D-01,  7.8776997D-01,  7.8922600D-01,
     &  7.9112101D-01,  7.9282600D-01,  7.9476798D-01,  7.9673600D-01,
     &  7.9895401D-01,  8.0097800D-01,  8.0303001D-01,  8.0441397D-01,
     &  8.0580997D-01,  8.0698401D-01,  8.0745602D-01,  8.0769199D-01,
     &  8.0745602D-01,  8.0698401D-01,  8.0534399D-01,  8.0303001D-01,
     &  8.0075198D-01,  7.9828501D-01,  7.9520297D-01,  7.9239798D-01,
     &  7.8901702D-01,  7.8571397D-01,  7.8248602D-01,  7.7874601D-01,
     &  7.7529198D-01,  7.7136999D-01,  7.6755899D-01,  7.6385200D-01,
     &  7.5974000D-01,  7.5608200D-01,  7.5268501D-01,  7.4968797D-01,
     &  7.4660897D-01,  7.4405098D-01,  7.4154598D-01,  7.3952103D-01,
     &  7.3767102D-01,  7.3570997D-01,  7.3391801D-01,  7.3242301D-01,
     &  7.3108000D-01,  7.2962099D-01,  7.2844100D-01,  7.2727299D-01,
     &  7.2624397D-01,  7.2522497D-01,  7.2446698D-01,  7.2383898D-01,
     &  7.2321397D-01,  7.2246897D-01,  7.2197598D-01,  7.2148401D-01,
     &  7.2099400D-01,  7.2050697D-01,  7.2014296D-01,  7.1977997D-01,
     &  7.1953899D-01,  7.1917802D-01,  7.1893799D-01,  7.1869898D-01,
     &  7.1845996D-01,  7.1822101D-01,  7.1810198D-01,  7.1786499D-01/
      data ( tapcrs(i),i=2601,2800 )/
     &  7.1774602D-01,  7.1762800D-01,  7.1750998D-01,  7.1750998D-01,
     &  7.1744996D-01,  7.1739101D-01,  7.1739101D-01,  7.1739101D-01,
     &  7.1739101D-01,  7.1739101D-01,  7.1739101D-01,  7.1739101D-01,
     &  7.1739101D-01,  7.1739101D-01,  7.1739101D-01,  7.1739101D-01,
     &  7.1739101D-01,  7.1739101D-01,  7.1744996D-01,  7.1750998D-01,
     &  7.1750998D-01,  7.1762800D-01,  7.1774602D-01,  7.1786499D-01,
     &  7.1798402D-01,  7.1810198D-01,  7.1822101D-01,  7.1834099D-01,
     &  7.1845996D-01,  7.1857899D-01,  7.1869898D-01,  7.1893799D-01,
     &  7.1917802D-01,  7.1953899D-01,  7.1977997D-01,  7.2002196D-01,
     &  7.2038597D-01,  7.2075099D-01,  7.2111702D-01,  7.2148401D-01,
     &  7.2197598D-01,  7.2234601D-01,  7.2296500D-01,  7.2346401D-01,
     &  7.2408998D-01,  7.2471899D-01,  7.2535199D-01,  7.2624397D-01,
     &  7.2701502D-01,  7.2804999D-01,  7.2909498D-01,  7.3014998D-01,
     &  7.3041499D-01,  7.3094702D-01,  7.3121399D-01,  7.3161602D-01,
     &  7.3215300D-01,  7.3529398D-01,  7.3282897D-01,  7.3323601D-01,
     &  7.3378098D-01,  7.3391801D-01,  7.3515600D-01,  7.3557103D-01,
     &  7.3640698D-01,  7.3696697D-01,  7.3781198D-01,  7.3852098D-01,
     &  7.3952103D-01,  7.4023998D-01,  7.4110901D-01,  7.4242401D-01,
     &  7.4286598D-01,  7.4360502D-01,  7.4419999D-01,  7.4494803D-01,
     &  7.4539900D-01,  0.0000000D+00,  6.2350940D-05,  5.7214685D-04,
     &  1.6245572D-03,  3.2676181D-03,  5.5575818D-03,  8.5417815D-03,
     &  1.2711395D-02,  1.8640257D-02,  2.6964016D-02,  3.8335141D-02,
     &  5.3144585D-02,  7.1814001D-02,  9.4626844D-02,  1.2178957D-01,
     &  1.5337914D-01,  1.8780130D-01,  2.2294515D-01,  2.5624502D-01,
     &  2.8600812D-01,  3.1311518D-01,  3.3809590D-01,  3.6096317D-01,
     &  3.8177198D-01,  4.0060759D-01,  4.1763681D-01,  4.3305963D-01,
     &  4.4703591D-01,  4.5967454D-01,  4.7100914D-01,  4.8120320D-01,
     &  4.9040234D-01,  4.9858737D-01,  5.0585181D-01,  5.1237512D-01,
     &  5.1834315D-01,  5.2388239D-01,  5.2900523D-01,  5.3375536D-01,
     &  5.3820920D-01,  5.4240036D-01,  5.4633588D-01,  5.5004174D-01,
     &  5.5355203D-01,  5.5689251D-01,  5.6005162D-01,  5.6301928D-01,
     &  5.6584382D-01,  5.6857681D-01,  5.7124335D-01,  5.7385242D-01,
     &  5.7640433D-01,  5.7889944D-01,  5.8133799D-01,  5.8372360D-01,
     &  5.8608085D-01,  5.8843088D-01,  5.9077382D-01,  5.9310961D-01,
     &  5.9543836D-01,  5.9776014D-01,  6.0007507D-01,  6.0238594D-01,
     &  6.0471702D-01,  6.0708940D-01,  6.0950297D-01,  6.1195308D-01,
     &  6.1442959D-01,  6.1691779D-01,  6.1942351D-01,  6.2196583D-01,
     &  6.2454873D-01,  6.2715989D-01,  6.2978119D-01,  6.3242018D-01,
     &  6.3510460D-01,  6.3786262D-01,  6.4068532D-01,  6.4356786D-01,
     &  6.4655614D-01,  6.4963788D-01,  6.5276569D-01,  6.5593237D-01,
     &  6.5915561D-01,  6.6245884D-01,  6.6584724D-01,  6.6932076D-01,
     &  6.7287886D-01,  6.7652148D-01,  6.8024820D-01,  6.8405879D-01,
     &  6.8795294D-01,  6.9193047D-01,  6.9599307D-01,  7.0018703D-01,
     &  7.0453179D-01,  7.0898026D-01,  7.1351045D-01,  7.1813357D-01,
     &  7.2287244D-01,  7.2773814D-01,  7.3273039D-01,  7.3784864D-01,
     &  7.4307001D-01,  7.4837136D-01,  7.5375181D-01,  7.5921130D-01,
     &  7.6474947D-01,  7.7036613D-01,  7.7603388D-01,  7.8171629D-01,
     &  7.8739470D-01,  7.9305565D-01,  7.9868984D-01,  8.0428714D-01,
     &  8.0981165D-01,  8.1524336D-01,  8.2059795D-01,  8.2584733D-01,
     &  8.3096981D-01,  8.3598614D-01,  8.4092182D-01,  8.4576917D-01/
      data ( tapcrs(i),i=2801,3000 )/
     &  8.5049593D-01,  8.5510832D-01,  8.5963410D-01,  8.6409378D-01,
     &  8.6850160D-01,  8.7286073D-01,  8.7716705D-01,  8.8141972D-01,
     &  8.8563842D-01,  8.8983995D-01,  8.9401382D-01,  8.9815676D-01,
     &  9.0227771D-01,  9.0638560D-01,  9.1048044D-01,  9.1455007D-01,
     &  9.1858417D-01,  9.2259532D-01,  9.2658263D-01,  9.3053031D-01,
     &  9.3445402D-01,  9.3837005D-01,  9.4227821D-01,  9.4617867D-01,
     &  9.5007151D-01,  9.5395672D-01,  9.5783430D-01,  9.6170437D-01,
     &  9.6556693D-01,  9.6942210D-01,  9.7326982D-01,  9.7711015D-01,
     &  9.8094314D-01,  9.8476893D-01,  9.8858744D-01,  9.9239880D-01,
     &  9.9620295D-01,  1.0000000D+00,  5.4660002D+13,  5.7360698D+13,
     &  5.8188720D+13,  5.8683598D+13,  5.9067544D+13,  5.9364468D+13,
     &  5.9661374D+13,  5.9878287D+13,  6.0078254D+13,  6.0278222D+13,
     &  6.0478189D+13,  6.0634905D+13,  6.0782025D+13,  6.0929144D+13,
     &  6.1076264D+13,  6.1223383D+13,  6.1361107D+13,  6.1487054D+13,
     &  6.1612984D+13,  6.1738930D+13,  6.1864877D+13,  6.1990823D+13,
     &  6.2118968D+13,  6.2253940D+13,  6.2388896D+13,  6.2523869D+13,
     &  6.2658825D+13,  6.2793781D+13,  6.2942142D+13,  6.3102247D+13,
     &  6.3262352D+13,  6.3422457D+13,  6.3582562D+13,  6.3761340D+13,
     &  6.3945520D+13,  6.4129700D+13,  6.4313864D+13,  6.4519871D+13,
     &  6.4735693D+13,  6.4951515D+13,  6.5176867D+13,  6.5432032D+13,
     &  6.5687196D+13,  6.5958702D+13,  6.6259266D+13,  6.6559830D+13,
     &  6.6912789D+13,  6.7269086D+13,  6.7687863D+13,  6.8132895D+13,
     &  6.8643208D+13,  6.9244805D+13,  6.9929483D+13,  7.0710043D+13,
     &  7.1613865D+13,  7.2650597D+13,  7.3852030D+13,  7.5250914D+13,
     &  7.6780325D+13,  7.8404880D+13,  8.0037940D+13,  8.1624327D+13,
     &  8.3113657D+13,  8.4526030D+13,  8.5856715D+13,  8.7061604D+13,
     &  8.8178749D+13,  8.9213970D+13,  9.0174466D+13,  9.1075084D+13,
     &  9.1915521D+13,  9.2697776D+13,  9.3439144D+13,  9.4142344D+13,
     &  9.4804088D+13,  9.5441421D+13,  9.6059527D+13,  9.6659699D+13,
     &  9.7246952D+13,  9.7831772D+13,  9.8418354D+13,  9.9012250D+13,
     &  9.9619334D+13,  1.0024883D+14,  1.0090026D+14,  1.0157408D+14,
     &  1.0228027D+14,  1.0300506D+14,  1.0374681D+14,  1.0450030D+14,
     &  1.0526109D+14,  1.0602707D+14,  1.0679981D+14,  1.0758198D+14,
     &  1.0837218D+14,  1.0916237D+14,  1.0995256D+14,  1.1074273D+14,
     &  1.1153292D+14,  1.1232311D+14,  1.1311328D+14,  8.7471638D+25,
     &  1.5313041D+26,  1.9884459D+26,  2.3647835D+26,  2.6943879D+26,
     &  2.9927385D+26,  3.2684059D+26,  3.5267135D+26,  3.7712258D+26,
     &  4.0044723D+26,  4.2283184D+26,  4.4441807D+26,  4.6531720D+26,
     &  4.8561806D+26,  5.0539238D+26,  5.2469978D+26,  5.4358983D+26,
     &  5.6210476D+26,  5.8028056D+26,  5.9814793D+26,  6.1573372D+26,
     &  6.3306127D+26,  6.5015122D+26,  6.6702216D+26,  6.8368976D+26,
     &  7.0016875D+26,  7.1647213D+26,  7.3261170D+26,  7.4859780D+26,
     &  7.6444016D+26,  7.8014734D+26,  7.9572790D+26,  8.1118834D+26,
     &  8.2653603D+26,  8.4177688D+26,  8.5691649D+26,  8.7196018D+26,
     &  8.8691296D+26,  9.0177897D+26,  9.1656263D+26,  9.3126808D+26,
     &  9.4589857D+26,  9.6045792D+26,  9.7494879D+26,  9.8937474D+26,
     &  1.0037381D+27,  1.0180419D+27,  1.0322881D+27,  1.0464797D+27,
     &  1.0606184D+27,  1.0747064D+27,  1.0887457D+27,  1.1027381D+27,
     &  1.1166853D+27,  1.1305891D+27,  1.1444511D+27,  1.1582725D+27,
     &  1.1720551D+27,  1.1858004D+27,  1.1995088D+27,  1.2131824D+27/

      data ( tapcrs(i),i=3001,3200 )/
     &  1.2268221D+27,  1.2404290D+27,  1.2540041D+27,  1.2675484D+27,
     &  1.2810632D+27,  1.2945488D+27,  1.3080067D+27,  1.3214374D+27,
     &  1.3348418D+27,  1.3482209D+27,  1.3615751D+27,  1.3749052D+27,
     &  1.3882119D+27,  1.4014960D+27,  1.4147581D+27,  1.4279988D+27,
     &  1.4412187D+27,  1.4544180D+27,  1.4675979D+27,  1.4807585D+27,
     &  1.4939003D+27,  1.5070237D+27,  1.5201295D+27,  1.5332181D+27,
     &  1.5462899D+27,  1.5593449D+27,  1.5723842D+27,  1.5854076D+27,
     &  1.5984160D+27,  1.6114093D+27,  1.6243881D+27,  1.6373528D+27,
     &  1.6503036D+27,  1.6632408D+27,  1.6761647D+27,  1.6890757D+27,
     &  1.7019742D+27,  1.7148604D+27,  1.7277344D+27,  1.7405964D+27,
     &  1.7534471D+27,  1.7662864D+27,  1.7791147D+27,  1.7919321D+27,
     &  1.8047388D+27,  1.8175353D+27,  1.8303217D+27,  1.8430980D+27,
     &  1.8558646D+27,  1.8686218D+27,  1.8813696D+27,  1.8941081D+27,
     &  1.9068376D+27,  1.9195584D+27,  1.9322705D+27,  1.9449745D+27,
     &  1.9576697D+27,  1.9703569D+27,  1.9830362D+27,  1.9957078D+27,
     &  2.0083714D+27,  2.0210276D+27,  2.0336765D+27,  2.0463180D+27,
     &  2.0589524D+27,  2.0715797D+27,  2.0842002D+27,  2.0968142D+27,
     &  2.1094212D+27,  2.1220219D+27,  2.1346159D+27,  2.1472040D+27,
     &  2.1597858D+27,  2.1723612D+27,  2.1849312D+27,  2.1974951D+27,
     &  2.2100531D+27,  2.2226054D+27,  2.2351524D+27,  2.2476936D+27,
     &  2.2602294D+27,  2.2727602D+27,  2.2852857D+27,  2.2978058D+27,
     &  2.3103210D+27,  2.3228314D+27,  2.3353371D+27,  2.3478372D+27,
     &  2.3603332D+27,  2.3728245D+27,  2.3853110D+27,  2.3977931D+27,
     &  2.4102708D+27,  2.4227440D+27,  2.4352125D+27,  2.4476775D+27,
     &  2.4601381D+27,  2.4725945D+27,  2.4850468D+27,  2.4974949D+27,
     &  5.6885007D+26,  5.8853702D+26,  6.0777417D+26,  6.2669611D+26,
     &  6.4524940D+26,  6.6352201D+26,  6.8151747D+26,  6.9925704D+26,
     &  7.1675990D+26,  7.3404317D+26,  7.5112161D+26,  7.6800909D+26,
     &  7.8471800D+26,  8.0125956D+26,  8.1764352D+26,  8.3387961D+26,
     &  8.4997609D+26,  8.6594064D+26,  8.8178093D+26,  8.9750287D+26,
     &  9.1311324D+26,  9.2861707D+26,  9.4401995D+26,  9.5932661D+26,
     &  9.7454149D+26,  9.8966930D+26,  1.0047133D+27,  1.0196776D+27,
     &  1.0345657D+27,  1.0493807D+27,  1.0641257D+27,  1.0788037D+27,
     &  1.0934170D+27,  1.1079687D+27,  1.1224605D+27,  1.1368956D+27,
     &  1.1512752D+27,  1.1656019D+27,  1.1798777D+27,  1.1941041D+27,
     &  1.2082830D+27,  1.2224161D+27,  1.2365050D+27,  1.2505508D+27,
     &  1.2645556D+27,  1.2785202D+27,  1.2924462D+27,  1.3063347D+27,
     &  1.3201868D+27,  1.3340036D+27,  1.3477867D+27,  1.3615365D+27,
     &  1.3752544D+27,  1.3889410D+27,  1.4025977D+27,  1.4162247D+27,
     &  1.4298237D+27,  1.4433946D+27,  1.4569389D+27,  1.4704570D+27,
     &  1.4839494D+27,  1.4974173D+27,  1.5108609D+27,  1.5242813D+27,
     &  1.5376787D+27,  1.5510539D+27,  1.5644073D+27,  1.5777397D+27,
     &  1.5910515D+27,  1.6043431D+27,  1.6176154D+27,  1.6308684D+27,
     &  1.6441025D+27,  1.6573186D+27,  1.6705174D+27,  1.6836981D+27,
     &  1.6968623D+27,  1.7100099D+27,  1.7231411D+27,  1.7362568D+27,
     &  1.7493567D+27,  1.7624418D+27,  1.7755121D+27,  1.7885677D+27,
     &  1.8016091D+27,  1.8146372D+27,  1.8276512D+27,  1.8406521D+27,
     &  1.8536401D+27,  1.8666157D+27,  1.8795786D+27,  1.8925291D+27,
     &  1.9054681D+27,  1.9183950D+27,  1.9313106D+27,  1.9442151D+27,
     &  1.9571083D+27,  1.9699910D+27,  1.9828630D+27,  1.9957246D+27/
      data ( tapcrs(i),i=3201,3400 )/
     &  2.0085759D+27,  2.0214175D+27,  2.0342491D+27,  2.0470712D+27,
     &  2.0598839D+27,  2.0726871D+27,  2.0854817D+27,  2.0982670D+27,
     &  2.1110436D+27,  2.1238117D+27,  2.1365713D+27,  2.1493225D+27,
     &  2.1620658D+27,  2.1748009D+27,  2.1875280D+27,  2.2002476D+27,
     &  2.2129597D+27,  2.2256640D+27,  2.2383610D+27,  2.2510512D+27,
     &  2.2637340D+27,  2.2764100D+27,  2.2890789D+27,  2.3017410D+27,
     &  2.3143970D+27,  2.3270461D+27,  2.3396888D+27,  2.3523250D+27,
     &  2.3649552D+27,  2.3775793D+27,  3.8200003D-01,  8.2499999D-01,
     &  1.7500001D-01,  6.6499996D-01,  3.3499998D-01,  3.5699999D-01,
     &  8.7000000D-01,  1.3000000D-01,  7.5199997D-01,  2.5000000D-01,
     &  3.5100001D-01,  8.8000000D-01,  1.2000000D-01,  7.9100001D-01,
     &  2.0800000D-01,  3.7000000D-01,  8.6000001D-01,  1.3999999D-01,
     &  7.8299999D-01,  2.1700001D-01,  3.7599999D-01,  8.3800000D-01,
     &  1.6000003D-01,  7.7399999D-01,  2.2600001D-01,  3.6900002D-01,
     &  7.8999996D-01,  2.0999998D-01,  6.7000002D-01,  3.2999998D-01,
     &  3.6199999D-01,  7.1499997D-01,  2.7999997D-01,  5.8499998D-01,
     &  4.1600001D-01,  3.5299999D-01,  6.4499998D-01,  3.5500002D-01,
     &  5.9499997D-01,  4.0600002D-01,  3.4299999D-01,  5.7400000D-01,
     &  4.2600000D-01,  6.0399997D-01,  3.9600003D-01,  3.3399999D-01,
     &  5.0000000D-01,  5.0000000D-01,  6.1399996D-01,  3.8599998D-01,
     &  3.2199997D-01,  4.3000001D-01,  5.6999999D-01,  6.2299997D-01,
     &  3.7699997D-01,  3.1099999D-01,  4.0499997D-01,  5.9399998D-01,
     &  5.9999996D-01,  3.9999998D-01,  2.9799998D-01,  4.2000002D-01,
     &  5.7800001D-01,  5.3799999D-01,  4.6200001D-01,  2.7999997D-01,
     &  4.3599999D-01,  5.6299996D-01,  4.8000002D-01,  5.1999998D-01,
     &  2.4599999D-01,  4.7700000D-01,  5.1700002D-01,  4.6399999D-01,
     &  5.3600001D-01,  1.9999999D-01,  5.1999998D-01,  4.7499996D-01,
     &  4.4999999D-01,  5.5000001D-01,  2.1700001D-01,  5.6199998D-01,
     &  4.3500000D-01,  4.3500000D-01,  5.6500000D-01,  2.3500001D-01,
     &  6.0399997D-01,  3.9499998D-01,  4.2199999D-01,  5.7900000D-01,
     &  2.5099999D-01,  6.4700001D-01,  3.5200000D-01,  4.0600002D-01,
     &  5.9499997D-01,  2.6899999D-01,  6.8900001D-01,  3.1000000D-01,
     &  3.9099997D-01,  6.1000001D-01,  2.8499997D-01,  6.9999999D-01,
     &  3.0000001D-01,  3.5799998D-01,  6.4200002D-01,  3.0100000D-01,
     &  7.1099997D-01,  2.8899997D-01,  3.2300001D-01,  6.8000001D-01,
     &  3.0000001D-01,  7.2100002D-01,  2.7800000D-01,  2.8700000D-01,
     &  7.1499997D-01,  2.9699999D-01,  7.3199999D-01,  2.6700002D-01,
     &  2.5000000D-01,  7.5000000D-01,  2.9500002D-01,  7.4299997D-01,
     &  2.5599998D-01,  2.0999998D-01,  7.8999996D-01,  2.9100001D-01,
     &  7.5299996D-01,  2.4599999D-01,  1.7500001D-01,  8.2499999D-01,
     &  2.8799999D-01,  7.6400000D-01,  2.3500001D-01,  1.3999999D-01,
     &  8.6000001D-01,  2.8499997D-01,  7.7499998D-01,  2.2399998D-01,
     &  1.0500002D-01,  8.9499998D-01,  2.8200001D-01,  7.8499997D-01,
     &  2.1399999D-01,  6.8000019D-02,  9.3199998D-01,  2.7999997D-01,
     &  7.8899997D-01,  2.1100003D-01,  6.9999993D-02,  9.3000001D-01,
     &  2.7700001D-01,  7.9299998D-01,  2.0599997D-01,  7.0999980D-02,
     &  9.2899996D-01,  2.6599997D-01,  7.9799998D-01,  2.0200002D-01,
     &  7.3000014D-02,  9.2699999D-01,  2.5400001D-01,  8.0100000D-01,
     &  1.9900000D-01,  7.4500024D-02,  9.2600000D-01,  2.4199998D-01,
     &  8.0500001D-01,  1.9499999D-01,  7.4999988D-02,  9.2399997D-01/
      data ( tapcrs(i),i=3401,3600 )/
     &  1.0000000D+03,  1.7188001D-01,  7.7272999D-01,  1.0000000D+00,
     &  8.0190003D-02,  4.7059000D-01,  8.7180018D-02,  2.7528000D-01,
     &  3.6821997D-01,  1.3770000D+03,  1.5991998D-01,  4.5714003D-01,
     &  5.4135001D-01,  4.8174001D-02,  3.2257998D-01,  1.4693999D-01,
     &  2.4879998D-01,  4.0763998D-01,  1.8750000D+03,  8.7059975D-02,
     &  3.9999998D-01,  5.3850001D-01,  6.4520001D-02,  4.5450002D-01,
     &  5.5640001D-02,  1.8260002D-01,  3.2989997D-01,  2.3940000D+03,
     &  2.3883998D-01,  4.3478000D-01,  4.4230998D-01,  1.8417001D-01,
     &  4.4444001D-01,  1.9063997D-01,  3.6673999D-01,  4.4534999D-01,
     &  2.5000000D+03,  2.7399999D-01,  4.5400000D-01,  4.0509999D-01,
     &  2.1399999D-01,  4.4400001D-01,  2.1700001D-01,  4.0399998D-01,
     &  4.7600001D-01,  5.0000000D-01,  8.2499999D-01,  1.7500001D-01,
     &  6.6499996D-01,  3.3499998D-01,  5.0000000D-01,  8.7000000D-01,
     &  1.3000000D-01,  7.5199997D-01,  2.5000000D-01,  5.0000000D-01,
     &  8.8000000D-01,  1.2000000D-01,  7.9100001D-01,  2.0800000D-01,
     &  5.0000000D-01,  8.6000001D-01,  1.3999999D-01,  7.8299999D-01,
     &  2.1700001D-01,  5.0000000D-01,  8.3800000D-01,  1.6000003D-01,
     &  7.7399999D-01,  2.2600001D-01,  5.0000000D-01,  7.8999996D-01,
     &  2.0999998D-01,  6.7000002D-01,  3.2999998D-01,  5.0000000D-01,
     &  7.1499997D-01,  2.7999997D-01,  5.8499998D-01,  4.1600001D-01,
     &  5.0000000D-01,  6.4499998D-01,  3.5500002D-01,  5.9499997D-01,
     &  4.0600002D-01,  5.0000000D-01,  5.7400000D-01,  4.2600000D-01,
     &  6.0399997D-01,  3.9600003D-01,  5.0000000D-01,  5.0000000D-01,
     &  5.0000000D-01,  6.1399996D-01,  3.8599998D-01,  5.0000000D-01,
     &  4.3000001D-01,  5.6999999D-01,  6.2299997D-01,  3.7699997D-01,
     &  5.0000000D-01,  4.0499997D-01,  5.9399998D-01,  5.9999996D-01,
     &  3.9999998D-01,  5.0000000D-01,  4.2000002D-01,  5.7800001D-01,
     &  5.3799999D-01,  4.6200001D-01,  5.0000000D-01,  4.3599999D-01,
     &  5.6299996D-01,  4.8000002D-01,  5.1999998D-01,  5.0000000D-01,
     &  4.7700000D-01,  5.1700002D-01,  4.6399999D-01,  5.3600001D-01,
     &  5.0000000D-01,  5.1999998D-01,  4.7499996D-01,  4.4999999D-01,
     &  5.5000001D-01,  5.0000000D-01,  5.6199998D-01,  4.3500000D-01,
     &  4.3500000D-01,  5.6500000D-01,  5.0000000D-01,  6.0399997D-01,
     &  3.9499998D-01,  4.2199999D-01,  5.7900000D-01,  5.0000000D-01,
     &  6.4700001D-01,  3.5200000D-01,  4.0600002D-01,  5.9499997D-01,
     &  5.0000000D-01,  6.8900001D-01,  3.1000000D-01,  3.9099997D-01,
     &  6.1000001D-01,  5.0000000D-01,  6.9999999D-01,  3.0000001D-01,
     &  3.5799998D-01,  6.4200002D-01,  5.0000000D-01,  7.1099997D-01,
     &  2.8899997D-01,  3.2300001D-01,  6.8000001D-01,  5.0000000D-01,
     &  7.2100002D-01,  2.7800000D-01,  2.8700000D-01,  7.1499997D-01,
     &  5.0000000D-01,  7.3199999D-01,  2.6700002D-01,  2.5000000D-01,
     &  7.5000000D-01,  5.0000000D-01,  7.4299997D-01,  2.5599998D-01,
     &  2.0999998D-01,  7.8999996D-01,  5.0000000D-01,  7.5299996D-01,
     &  2.4599999D-01,  1.7500001D-01,  8.2499999D-01,  5.0000000D-01,
     &  7.6400000D-01,  2.3500001D-01,  1.3999999D-01,  8.6000001D-01,
     &  5.0000000D-01,  7.7499998D-01,  2.2399998D-01,  1.0500002D-01,
     &  8.9499998D-01,  5.0000000D-01,  7.8499997D-01,  2.1399999D-01,
     &  6.8000019D-02,  9.3199998D-01,  5.0000000D-01,  7.8899997D-01,
     &  2.1100003D-01,  6.9999993D-02,  9.3000001D-01,  5.0000000D-01,
     &  7.9299998D-01,  2.0599997D-01,  7.0999980D-02,  9.2899996D-01/

      data ( tapcrs(i),i=3601,3800 )/
     &  5.0000000D-01,  7.9799998D-01,  2.0200002D-01,  7.3000014D-02,
     &  9.2699999D-01,  5.0000000D-01,  8.0100000D-01,  1.9900000D-01,
     &  7.4500024D-02,  9.2600000D-01,  5.0000000D-01,  8.0500001D-01,
     &  1.9499999D-01,  7.4999988D-02,  9.2399997D-01,  1.0000000D+03,
     &  1.7188001D-01,  7.7272999D-01,  1.0000000D+00,  8.0190003D-02,
     &  4.7059000D-01,  8.7180018D-02,  2.7528000D-01,  3.6821997D-01,
     &  1.3770000D+03,  1.5991998D-01,  4.5714003D-01,  5.4135001D-01,
     &  4.8174001D-02,  3.2257998D-01,  1.4693999D-01,  2.4879998D-01,
     &  4.0763998D-01,  1.8750000D+03,  8.7059975D-02,  3.9999998D-01,
     &  5.3850001D-01,  6.4520001D-02,  4.5450002D-01,  5.5640001D-02,
     &  1.8260002D-01,  3.2989997D-01,  2.3940000D+03,  2.3883998D-01,
     &  4.3478000D-01,  4.4230998D-01,  1.8417001D-01,  4.4444001D-01,
     &  1.9063997D-01,  3.6673999D-01,  4.4534999D-01,  2.5000000D+03,
     &  2.7399999D-01,  4.5400000D-01,  4.0509999D-01,  2.1399999D-01,
     &  4.4400001D-01,  2.1700001D-01,  4.0399998D-01,  4.7600001D-01,
     &  5.0000000D-01,  8.2499999D-01,  1.7500001D-01,  6.6499996D-01,
     &  3.3499998D-01,  5.0000000D-01,  8.7000000D-01,  1.3000000D-01,
     &  7.5199997D-01,  2.5000000D-01,  5.0000000D-01,  8.8000000D-01,
     &  1.2000000D-01,  7.9100001D-01,  2.0800000D-01,  5.0000000D-01,
     &  8.6000001D-01,  1.3999999D-01,  7.8299999D-01,  2.1700001D-01,
     &  5.0000000D-01,  8.3800000D-01,  1.6000003D-01,  7.7399999D-01,
     &  2.2600001D-01,  5.0000000D-01,  7.8999996D-01,  2.0999998D-01,
     &  6.7000002D-01,  3.2999998D-01,  5.0000000D-01,  7.1499997D-01,
     &  2.7999997D-01,  5.8499998D-01,  4.1600001D-01,  5.0000000D-01,
     &  6.4499998D-01,  3.5500002D-01,  5.9499997D-01,  4.0600002D-01,
     &  5.0000000D-01,  5.7400000D-01,  4.2600000D-01,  6.0399997D-01,
     &  3.9600003D-01,  5.0000000D-01,  5.0000000D-01,  5.0000000D-01,
     &  6.1399996D-01,  3.8599998D-01,  5.0000000D-01,  4.3000001D-01,
     &  5.6999999D-01,  6.2299997D-01,  3.7699997D-01,  5.0000000D-01,
     &  4.0499997D-01,  5.9399998D-01,  5.9999996D-01,  3.9999998D-01,
     &  5.0000000D-01,  4.2000002D-01,  5.7800001D-01,  5.3799999D-01,
     &  4.6200001D-01,  5.0000000D-01,  4.3599999D-01,  5.6299996D-01,
     &  4.8000002D-01,  5.1999998D-01,  5.0000000D-01,  4.7700000D-01,
     &  5.1700002D-01,  4.6399999D-01,  5.3600001D-01,  5.0000000D-01,
     &  5.1999998D-01,  4.7499996D-01,  4.4999999D-01,  5.5000001D-01,
     &  5.0000000D-01,  5.6199998D-01,  4.3500000D-01,  4.3500000D-01,
     &  5.6500000D-01,  5.0000000D-01,  6.0399997D-01,  3.9499998D-01,
     &  4.2199999D-01,  5.7900000D-01,  5.0000000D-01,  6.4700001D-01,
     &  3.5200000D-01,  4.0600002D-01,  5.9499997D-01,  5.0000000D-01,
     &  6.8900001D-01,  3.1000000D-01,  3.9099997D-01,  6.1000001D-01,
     &  5.0000000D-01,  6.9999999D-01,  3.0000001D-01,  3.5799998D-01,
     &  6.4200002D-01,  5.0000000D-01,  7.1099997D-01,  2.8899997D-01,
     &  3.2300001D-01,  6.8000001D-01,  5.0000000D-01,  7.2100002D-01,
     &  2.7800000D-01,  2.8700000D-01,  7.1499997D-01,  5.0000000D-01,
     &  7.3199999D-01,  2.6700002D-01,  2.5000000D-01,  7.5000000D-01,
     &  5.0000000D-01,  7.4299997D-01,  2.5599998D-01,  2.0999998D-01,
     &  7.8999996D-01,  5.0000000D-01,  7.5299996D-01,  2.4599999D-01,
     &  1.7500001D-01,  8.2499999D-01,  5.0000000D-01,  7.6400000D-01,
     &  2.3500001D-01,  1.3999999D-01,  8.6000001D-01,  5.0000000D-01,
     &  7.7499998D-01,  2.2399998D-01,  1.0500002D-01,  8.9499998D-01/
      data ( tapcrs(i),i=3801,4000 )/
     &  5.0000000D-01,  7.8499997D-01,  2.1399999D-01,  6.8000019D-02,
     &  9.3199998D-01,  5.0000000D-01,  7.8899997D-01,  2.1100003D-01,
     &  6.9999993D-02,  9.3000001D-01,  5.0000000D-01,  7.9299998D-01,
     &  2.0599997D-01,  7.0999980D-02,  9.2899996D-01,  5.0000000D-01,
     &  7.9799998D-01,  2.0200002D-01,  7.3000014D-02,  9.2699999D-01,
     &  5.0000000D-01,  8.0100000D-01,  1.9900000D-01,  7.4500024D-02,
     &  9.2600000D-01,  5.0000000D-01,  8.0500001D-01,  1.9499999D-01,
     &  7.4999988D-02,  9.2399997D-01,  1.0000000D+03,  1.7188001D-01,
     &  7.7272999D-01,  1.0000000D+00,  8.0190003D-02,  4.7059000D-01,
     &  8.7180018D-02,  2.7528000D-01,  3.6821997D-01,  1.3770000D+03,
     &  1.5991998D-01,  4.5714003D-01,  5.4135001D-01,  4.8174001D-02,
     &  3.2257998D-01,  1.4693999D-01,  2.4879998D-01,  4.0763998D-01,
     &  1.8750000D+03,  8.7059975D-02,  3.9999998D-01,  5.3850001D-01,
     &  6.4520001D-02,  4.5450002D-01,  5.5640001D-02,  1.8260002D-01,
     &  3.2989997D-01,  2.3940000D+03,  2.3883998D-01,  4.3478000D-01,
     &  4.4230998D-01,  1.8417001D-01,  4.4444001D-01,  1.9063997D-01,
     &  3.6673999D-01,  4.4534999D-01,  2.5000000D+03,  2.7399999D-01,
     &  4.5400000D-01,  4.0509999D-01,  2.1399999D-01,  4.4400001D-01,
     &  2.1700001D-01,  4.0399998D-01,  4.7600001D-01,  5.0000000D-01,
     &  8.2499999D-01,  1.7500001D-01,  6.6499996D-01,  3.3499998D-01,
     &  5.0000000D-01,  8.7000000D-01,  1.3000000D-01,  7.5199997D-01,
     &  2.5000000D-01,  5.0000000D-01,  8.8000000D-01,  1.2000000D-01,
     &  7.9100001D-01,  2.0800000D-01,  5.0000000D-01,  8.6000001D-01,
     &  1.3999999D-01,  7.8299999D-01,  2.1700001D-01,  5.0000000D-01,
     &  8.3800000D-01,  1.6000003D-01,  7.7399999D-01,  2.2600001D-01,
     &  5.0000000D-01,  7.8999996D-01,  2.0999998D-01,  6.7000002D-01,
     &  3.2999998D-01,  5.0000000D-01,  7.1499997D-01,  2.7999997D-01,
     &  5.8499998D-01,  4.1600001D-01,  5.0000000D-01,  6.4499998D-01,
     &  3.5500002D-01,  5.9499997D-01,  4.0600002D-01,  5.0000000D-01,
     &  5.7400000D-01,  4.2600000D-01,  6.0399997D-01,  3.9600003D-01,
     &  5.0000000D-01,  5.0000000D-01,  5.0000000D-01,  6.1399996D-01,
     &  3.8599998D-01,  5.0000000D-01,  4.3000001D-01,  5.6999999D-01,
     &  6.2299997D-01,  3.7699997D-01,  5.0000000D-01,  4.0499997D-01,
     &  5.9399998D-01,  5.9999996D-01,  3.9999998D-01,  5.0000000D-01,
     &  4.2000002D-01,  5.7800001D-01,  5.3799999D-01,  4.6200001D-01,
     &  5.0000000D-01,  4.3599999D-01,  5.6299996D-01,  4.8000002D-01,
     &  5.1999998D-01,  5.0000000D-01,  4.7700000D-01,  5.1700002D-01,
     &  4.6399999D-01,  5.3600001D-01,  5.0000000D-01,  5.1999998D-01,
     &  4.7499996D-01,  4.4999999D-01,  5.5000001D-01,  5.0000000D-01,
     &  5.6199998D-01,  4.3500000D-01,  4.3500000D-01,  5.6500000D-01,
     &  5.0000000D-01,  6.0399997D-01,  3.9499998D-01,  4.2199999D-01,
     &  5.7900000D-01,  5.0000000D-01,  6.4700001D-01,  3.5200000D-01,
     &  4.0600002D-01,  5.9499997D-01,  5.0000000D-01,  6.8900001D-01,
     &  3.1000000D-01,  3.9099997D-01,  6.1000001D-01,  5.0000000D-01,
     &  6.9999999D-01,  3.0000001D-01,  3.5799998D-01,  6.4200002D-01,
     &  5.0000000D-01,  7.1099997D-01,  2.8899997D-01,  3.2300001D-01,
     &  6.8000001D-01,  5.0000000D-01,  7.2100002D-01,  2.7800000D-01,
     &  2.8700000D-01,  7.1499997D-01,  5.0000000D-01,  7.3199999D-01,
     &  2.6700002D-01,  2.5000000D-01,  7.5000000D-01,  5.0000000D-01,
     &  7.4299997D-01,  2.5599998D-01,  2.0999998D-01,  7.8999996D-01/
      data ( tapcrs(i),i=4001,4200 )/
     &  5.0000000D-01,  7.5299996D-01,  2.4599999D-01,  1.7500001D-01,
     &  8.2499999D-01,  5.0000000D-01,  7.6400000D-01,  2.3500001D-01,
     &  1.3999999D-01,  8.6000001D-01,  5.0000000D-01,  7.7499998D-01,
     &  2.2399998D-01,  1.0500002D-01,  8.9499998D-01,  5.0000000D-01,
     &  7.8499997D-01,  2.1399999D-01,  6.8000019D-02,  9.3199998D-01,
     &  5.0000000D-01,  7.8899997D-01,  2.1100003D-01,  6.9999993D-02,
     &  9.3000001D-01,  5.0000000D-01,  7.9299998D-01,  2.0599997D-01,
     &  7.0999980D-02,  9.2899996D-01,  5.0000000D-01,  7.9799998D-01,
     &  2.0200002D-01,  7.3000014D-02,  9.2699999D-01,  5.0000000D-01,
     &  8.0100000D-01,  1.9900000D-01,  7.4500024D-02,  9.2600000D-01,
     &  5.0000000D-01,  8.0500001D-01,  1.9499999D-01,  7.4999988D-02,
     &  9.2399997D-01,  1.0000000D+03,  1.7188001D-01,  7.7272999D-01,
     &  1.0000000D+00,  8.0190003D-02,  4.7059000D-01,  8.7180018D-02,
     &  2.7528000D-01,  3.6821997D-01,  1.3770000D+03,  1.5991998D-01,
     &  4.5714003D-01,  5.4135001D-01,  4.8174001D-02,  3.2257998D-01,
     &  1.4693999D-01,  2.4879998D-01,  4.0763998D-01,  1.8750000D+03,
     &  8.7059975D-02,  3.9999998D-01,  5.3850001D-01,  6.4520001D-02,
     &  4.5450002D-01,  5.5640001D-02,  1.8260002D-01,  3.2989997D-01,
     &  2.3940000D+03,  2.3883998D-01,  4.3478000D-01,  4.4230998D-01,
     &  1.8417001D-01,  4.4444001D-01,  1.9063997D-01,  3.6673999D-01,
     &  4.4534999D-01,  2.5000000D+03,  2.7399999D-01,  4.5400000D-01,
     &  4.0509999D-01,  2.1399999D-01,  4.4400001D-01,  2.1700001D-01,
     &  4.0399998D-01,  4.7600001D-01,  0.0000000D+00,  5.0000000D-30,
     &  1.4999999D-28,  2.0000000D-28,  2.9999999D-28,  4.0000005D-28,
     &  5.4999995D-28,  7.0000004D-28,  8.9999997D-28,  1.1000001D-27,
     &  1.4000001D-27,  1.6000000D-27,  1.7999999D-27,  2.0999999D-27,
     &  2.2999999D-27,  2.6999999D-27,  2.8999998D-27,  3.2000000D-27,
     &  3.3999997D-27,  3.7000011D-27,  4.2000002D-27,  4.4000011D-27,
     &  4.6999994D-27,  5.0000007D-27,  5.2999990D-27,  5.6000003D-27,
     &  5.8999986D-27,  6.3000003D-27,  6.5999986D-27,  6.7999995D-27,
     &  7.2499984D-27,  7.7000004D-27,  7.9000013D-27,  8.3000000D-27,
     &  8.5999983D-27,  9.1000005D-27,  9.3000014D-27,  9.7500003D-27,
     &  1.0199999D-26,  1.0600001D-26,  1.1200001D-26,  1.1499999D-26,
     &  1.2000001D-26,  1.2799998D-26,  1.3399998D-26,  1.4299999D-26,
     &  1.5200000D-26,  1.6299999D-26,  1.8000000D-26,  1.9500001D-26,
     &  2.1000001D-26,  2.1899999D-26,  2.2800000D-26,  2.3400000D-26,
     &  2.4200000D-26,  2.4699999D-26,  2.5299999D-26,  2.5700001D-26,
     &  2.5999999D-26,  2.6099999D-26,  2.6049999D-26,  2.5900001D-26,
     &  2.5700001D-26,  2.5200001D-26,  2.4800000D-26,  2.4200000D-26,
     &  2.3600000D-26,  2.3199999D-26,  2.2699999D-26,  2.2300001D-26,
     &  2.1799999D-26,  2.1700001D-26,  2.1500000D-26,  2.1299999D-26,
     &  2.1199999D-26,  2.0900001D-26,  2.0800000D-26,  2.0700000D-26,
     &  2.0599999D-26,  2.0499999D-26,  2.0399998D-26,  2.0300001D-26,
     &  2.0250001D-26,  2.0200001D-26,  2.0200001D-26,  2.0100000D-26,
     &  2.0050000D-26,  2.0030001D-26,  2.0009999D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26/

      data ( tapcrs(i),i=4201,4400 )/
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,
     &  2.0000000D-26,  2.0000000D-26,  2.0000000D-26,  0.0000000D+00,
     &  1.4999999D-28,  2.9999999D-28,  4.9999992D-28,  7.5000007D-28,
     &  1.0000000D-27,  1.3000000D-27,  1.6300000D-27,  2.0000001D-27,
     &  2.3999999D-27,  2.8000000D-27,  3.2499991D-27,  3.7000011D-27,
     &  4.2500005D-27,  4.9500005D-27,  5.5500001D-27,  6.4500010D-27,
     &  7.2999986D-27,  8.1999996D-27,  9.2000009D-27,  1.0199999D-26,
     &  1.1100000D-26,  1.1599999D-26,  1.1800000D-26,  1.1800000D-26,
     &  1.1200001D-26,  1.0799999D-26,  1.1000000D-26,  1.1250001D-26,
     &  1.1700000D-26,  1.2199999D-26,  1.2799998D-26,  1.3450001D-26,
     &  1.4199999D-26,  1.4899999D-26,  1.5599999D-26,  1.6199998D-26,
     &  1.6249998D-26,  1.6100001D-26,  1.5800000D-26,  1.5500001D-26,
     &  1.5250000D-26,  1.5300000D-26,  1.5599999D-26,  1.5900000D-26,
     &  1.6249998D-26,  1.6700000D-26,  1.7200000D-26,  1.7749999D-26,
     &  1.8300001D-26,  1.8900001D-26,  1.9550001D-26,  2.0200001D-26,
     &  2.0800000D-26,  2.1500000D-26,  2.1999999D-26,  2.2499999D-26,
     &  2.2750000D-26,  2.2900000D-26,  2.3000001D-26,  2.2950001D-26,
     &  2.2900000D-26,  2.2750000D-26,  2.2599999D-26,  2.2400001D-26,
     &  2.2200000D-26,  2.1799999D-26,  2.1600001D-26,  2.1249999D-26,
     &  2.0950001D-26,  2.0700000D-26,  2.0449999D-26,  2.0250001D-26,
     &  2.0100000D-26,  1.9950000D-26,  1.9799999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  0.0000000D+00,  2.4999996D-28,  7.0000004D-28,  1.1000001D-27,
     &  1.6000000D-27,  2.0000001D-27,  2.5000000D-27,  3.0000001D-27,
     &  3.5000002D-27,  3.9999993D-27,  4.6999994D-27,  5.2499987D-27,
     &  5.8000012D-27,  6.5999986D-27,  7.4999995D-27,  8.5000009D-27,
     &  9.9999983D-27,  1.1499999D-26,  1.3499999D-26,  1.5500001D-26,
     &  1.8250001D-26,  1.9899999D-26,  1.9700002D-26,  1.9250000D-26,
     &  1.8700000D-26,  1.7900000D-26,  1.7500001D-26,  1.7699999D-26,
     &  1.8000000D-26,  1.8750000D-26,  1.9500001D-26,  2.0250001D-26,
     &  2.1199999D-26,  2.1999999D-26,  2.2699999D-26,  2.3100001D-26,
     &  2.3299999D-26,  2.3199999D-26,  2.2900000D-26,  2.2499999D-26,
     &  2.1999999D-26,  2.1500000D-26,  2.0800000D-26,  2.0100000D-26,
     &  1.9400000D-26,  1.8700000D-26,  1.8100001D-26,  1.7799999D-26,
     &  1.7749999D-26,  1.7900000D-26,  1.8200001D-26,  1.8499999D-26,
     &  1.9000001D-26,  1.9500001D-26,  2.0200001D-26,  2.0800000D-26,
     &  2.1500000D-26,  2.1750001D-26,  2.1999999D-26,  2.2100000D-26,
     &  2.2100000D-26,  2.1999999D-26,  2.1600001D-26,  2.0800000D-26,
     &  1.9749999D-26,  1.8900001D-26,  1.8399999D-26,  1.8100001D-26,
     &  1.8000000D-26,  1.8100001D-26,  1.8250001D-26,  1.8399999D-26,
     &  1.8700000D-26,  1.8900001D-26,  1.9099999D-26,  1.9300000D-26/
      data ( tapcrs(i),i=4401,4600 )/
     &  1.9500001D-26,  1.9700002D-26,  1.9799999D-26,  2.0050000D-26,
     &  2.0200001D-26,  2.0399998D-26,  2.0499999D-26,  2.0700000D-26,
     &  2.0750000D-26,  2.0800000D-26,  2.1000001D-26,  2.1199999D-26,
     &  2.1249999D-26,  2.1400000D-26,  2.1500000D-26,  2.1600001D-26,
     &  2.1700001D-26,  2.1750001D-26,  2.1799999D-26,  2.1899999D-26,
     &  2.1999999D-26,  2.2100000D-26,  2.2200000D-26,  2.2250001D-26,
     &  2.2300001D-26,  2.2400001D-26,  2.2499999D-26,  2.2549999D-26,
     &  2.2599999D-26,  2.2699999D-26,  2.2750000D-26,  2.2800000D-26,
     &  2.2850000D-26,  2.2900000D-26,  2.3000001D-26,  2.3050001D-26,
     &  2.3100001D-26,  2.3150001D-26,  2.3199999D-26,  2.3249999D-26,
     &  2.3299999D-26,  0.0000000D+00,  1.4999999D-28,  2.9999999D-28,
     &  4.9999992D-28,  7.5000007D-28,  1.0000000D-27,  1.3000000D-27,
     &  1.6300000D-27,  2.0000001D-27,  2.3999999D-27,  2.8000000D-27,
     &  3.2499991D-27,  3.7000011D-27,  4.2500005D-27,  4.9500005D-27,
     &  5.5500001D-27,  6.4500010D-27,  7.2999986D-27,  8.1999996D-27,
     &  9.2000009D-27,  1.0199999D-26,  1.1100000D-26,  1.1599999D-26,
     &  1.1800000D-26,  1.1800000D-26,  1.1200001D-26,  1.0799999D-26,
     &  1.1000000D-26,  1.1250001D-26,  1.1700000D-26,  1.2199999D-26,
     &  1.2799998D-26,  1.3450001D-26,  1.4199999D-26,  1.4899999D-26,
     &  1.5599999D-26,  1.6199998D-26,  1.6249998D-26,  1.6100001D-26,
     &  1.5800000D-26,  1.5500001D-26,  1.5250000D-26,  1.5300000D-26,
     &  1.5599999D-26,  1.5900000D-26,  1.6249998D-26,  1.6700000D-26,
     &  1.7200000D-26,  1.7749999D-26,  1.8300001D-26,  1.8900001D-26,
     &  1.9550001D-26,  2.0200001D-26,  2.0800000D-26,  2.1500000D-26,
     &  2.1999999D-26,  2.2499999D-26,  2.2750000D-26,  2.2900000D-26,
     &  2.3000001D-26,  2.2950001D-26,  2.2900000D-26,  2.2750000D-26,
     &  2.2599999D-26,  2.2400001D-26,  2.2200000D-26,  2.1799999D-26,
     &  2.1600001D-26,  2.1249999D-26,  2.0950001D-26,  2.0700000D-26,
     &  2.0449999D-26,  2.0250001D-26,  2.0100000D-26,  1.9950000D-26,
     &  1.9799999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,  1.9749999D-26,
     &  1.9749999D-26,  1.9749999D-26,  2.8316677D-01,  5.0407380D-01,
     &  2.8532821D-01,  5.0604892D-01,  2.8776699D-01,  5.0834954D-01,
     &  2.9019147D-01,  5.1057702D-01,  2.9326499D-01,  5.1366699D-01,
     &  2.9638702D-01,  5.1668602D-01,  2.9971898D-01,  5.2015001D-01,
     &  3.0397099D-01,  5.2420300D-01,  3.0830598D-01,  5.2889299D-01,
     &  3.1349796D-01,  5.3436399D-01,  3.1948602D-01,  5.4146999D-01,
     &  3.2544601D-01,  5.5089301D-01,  3.3333302D-01,  5.6507897D-01,
     &  3.4315801D-01,  5.8666700D-01,  3.6054200D-01,  6.1703998D-01,
     &  3.7635797D-01,  6.4259797D-01,  3.8088697D-01,  6.5870303D-01,
     &  3.8060302D-01,  6.6925299D-01,  3.7528098D-01,  6.7490596D-01,
     &  3.2664096D-01,  6.4942098D-01,  2.7569300D-01,  6.2132496D-01/
      data ( tapcrs(i),i=4601,4800 )/
     &  2.6801598D-01,  6.2159199D-01,  2.6831299D-01,  6.2578899D-01,
     &  2.8464699D-01,  6.3872796D-01,  3.2857102D-01,  6.7114800D-01,
     &  3.6371303D-01,  6.9564003D-01,  3.6776900D-01,  6.9963199D-01,
     &  3.6425501D-01,  6.9815600D-01,  3.4482199D-01,  6.8454999D-01,
     &  3.1201398D-01,  6.6181600D-01,  2.7626300D-01,  6.3669997D-01,
     &  2.4686199D-01,  6.1562097D-01,  2.1509099D-01,  5.9214997D-01,
     &  1.8688500D-01,  5.7049203D-01,  1.5364701D-01,  5.4554296D-01,
     &  1.4639997D-01,  5.3759998D-01,  1.4901298D-01,  5.3612196D-01,
     &  1.5698797D-01,  5.3757799D-01,  1.7557299D-01,  5.4605597D-01,
     &  1.9504499D-01,  5.5525500D-01,  2.1107000D-01,  5.6211597D-01,
     &  2.2002900D-01,  5.6439298D-01,  2.2419900D-01,  5.6298900D-01,
     &  2.2681600D-01,  5.6070799D-01,  2.2602701D-01,  5.5616403D-01,
     &  2.2570699D-01,  5.5235499D-01,  2.2434199D-01,  5.4692996D-01,
     &  2.2280902D-01,  5.4183799D-01,  2.0836699D-01,  5.4134101D-01,
     &  2.1773100D-01,  5.3114301D-01,  2.1542197D-01,  5.2576399D-01,
     &  2.1142203D-01,  5.1941299D-01,  2.0605701D-01,  5.1209497D-01,
     &  2.0022798D-01,  5.0471801D-01,  1.8959099D-01,  4.9427301D-01,
     &  1.7643201D-01,  4.8281896D-01,  1.4999998D-01,  4.6304297D-01,
     &  1.2975901D-01,  4.4736397D-01,  1.2639999D-01,  4.4426697D-01,
     &  1.2785101D-01,  4.4438499D-01,  1.3276798D-01,  4.4757897D-01,
     &  1.4719999D-01,  4.5813298D-01,  1.8084401D-01,  4.8289996D-01,
     &  2.0907599D-01,  5.0540501D-01,  2.3000598D-01,  5.2447200D-01,
     &  2.3393101D-01,  5.3516501D-01,  2.2830200D-01,  5.4087996D-01,
     &  2.2625500D-01,  5.4388702D-01,  2.2330099D-01,  5.4304200D-01,
     &  2.1888697D-01,  5.3997397D-01,  2.1286201D-01,  5.3483403D-01,
     &  2.0952398D-01,  5.3015900D-01,  2.0363897D-01,  5.2396500D-01,
     &  1.9739801D-01,  5.1747203D-01,  1.9141102D-01,  5.1165599D-01,
     &  1.8480200D-01,  5.0557202D-01,  1.7831302D-01,  4.9959797D-01,
     &  1.7405897D-01,  4.9535799D-01,  1.6955000D-01,  4.9075800D-01,
     &  1.6601998D-01,  4.8704702D-01,  1.6254401D-01,  4.8339200D-01,
     &  1.5955997D-01,  4.8018497D-01,  1.5561998D-01,  4.7665697D-01,
     &  1.5214700D-01,  4.7315401D-01,  1.4985800D-01,  4.7084498D-01,
     &  1.4702898D-01,  4.6779901D-01,  1.4478898D-01,  4.6553999D-01,
     &  1.4244097D-01,  4.6293402D-01,  1.3954300D-01,  4.6034598D-01,
     &  1.3765901D-01,  4.5816201D-01,  1.3591200D-01,  4.5635402D-01,
     &  1.3406599D-01,  4.5421201D-01,  1.3165402D-01,  4.5206296D-01,
     &  1.2995100D-01,  4.5029998D-01,  1.2895197D-01,  4.4892299D-01,
     &  1.2727302D-01,  4.4718599D-01,  1.2531000D-01,  4.4543999D-01,
     &  1.2434202D-01,  4.4409800D-01,  1.2240100D-01,  4.4237202D-01,
     &  1.2115401D-01,  4.4102597D-01,  1.1976600D-01,  4.3967301D-01,
     &  1.1838502D-01,  4.3832803D-01,  1.1686099D-01,  4.3697399D-01,
     &  1.1632299D-01,  4.3602699D-01,  1.1466199D-01,  4.3466902D-01,
     &  1.1383498D-01,  4.3370199D-01,  1.1301202D-01,  4.3273902D-01,
     &  1.1151803D-01,  4.3141401D-01,  1.1055398D-01,  4.3044198D-01,
     &  1.0944200D-01,  4.2945600D-01,  1.0863698D-01,  4.2851198D-01,
     &  1.0753202D-01,  4.2753202D-01,  1.0643202D-01,  4.2655599D-01,
     &  1.0600400D-01,  4.2594898D-01,  1.0491002D-01,  4.2497802D-01,
     &  1.0381800D-01,  4.2401099D-01,  1.0324597D-01,  4.2338997D-01,
     &  1.7032900D-04,  1.6885290D-03,  4.7747493D-03,  1.0224044D-02,
     &  1.9466672D-02,  3.3597156D-02,  5.4791424D-02,  7.9999983D-02/

      data ( tapcrs(i),i=4801,5000 )/
     &  1.1500001D-01,  1.6100001D-01,  2.1700001D-01,  2.8259367D-01,
     &  3.2199997D-01,  3.5799998D-01,  3.8599998D-01,  4.1100001D-01,
     &  4.3553710D-01,  4.4900000D-01,  4.6499997D-01,  4.7899997D-01,
     &  4.9100000D-01,  5.0085497D-01,  5.1099998D-01,  5.1849997D-01,
     &  5.2399999D-01,  5.2899998D-01,  5.3427237D-01,  5.3999996D-01,
     &  5.4399997D-01,  5.4899997D-01,  5.5399996D-01,  5.5645859D-01,
     &  5.6099999D-01,  5.6500000D-01,  5.6800002D-01,  5.7099998D-01,
     &  5.7364732D-01,  5.7800001D-01,  5.8099997D-01,  5.8399999D-01,
     &  5.8700001D-01,  5.8822197D-01,  5.9200001D-01,  5.9600002D-01,
     &  5.9799999D-01,  6.0299999D-01,  6.0699999D-01,  6.1000001D-01,
     &  6.1500001D-01,  6.1900002D-01,  6.2299997D-01,  6.2761486D-01,
     &  6.3199997D-01,  6.3499999D-01,  6.3999999D-01,  6.4499998D-01,
     &  6.4999998D-01,  6.5499997D-01,  6.6100001D-01,  6.6499996D-01,
     &  6.7199999D-01,  6.7738897D-01,  6.8400002D-01,  6.9099998D-01,
     &  6.9699997D-01,  7.0400000D-01,  7.0999998D-01,  7.1700001D-01,
     &  7.2399998D-01,  7.3000002D-01,  7.3699999D-01,  7.4470294D-01,
     &  7.5000000D-01,  7.5800002D-01,  7.6400000D-01,  7.7300000D-01,
     &  7.7899998D-01,  7.8799999D-01,  7.9399997D-01,  8.0100000D-01,
     &  8.0900002D-01,  8.1773829D-01,  8.2300001D-01,  8.2999998D-01,
     &  8.3599997D-01,  8.4200001D-01,  8.4899998D-01,  8.5299999D-01,
     &  8.5899997D-01,  8.6500001D-01,  8.7099999D-01,  8.7663573D-01,
     &  8.8199997D-01,  8.8699996D-01,  8.9200002D-01,  8.9700001D-01,
     &  9.0099996D-01,  9.0700001D-01,  9.1200000D-01,  9.1799998D-01,
     &  9.2199999D-01,  9.2825812D-01,  9.3299997D-01,  9.4000000D-01,
     &  9.4300002D-01,  9.4900000D-01,  9.5300001D-01,  9.5899999D-01,
     &  9.6200001D-01,  9.6799999D-01,  9.7100002D-01,  9.7600001D-01,
     &  9.8100001D-01,  9.8600000D-01,  9.9000001D-01,  9.9500000D-01,
     &  1.0000000D+00,  5.4660002D+13,  5.7388900D+13,  5.8218919D+13,
     &  5.8728879D+13,  5.9103783D+13,  5.9409749D+13,  5.9714927D+13,
     &  5.9921001D+13,  6.0127059D+13,  6.0333134D+13,  6.0532665D+13,
     &  6.0684281D+13,  6.0835880D+13,  6.0987495D+13,  6.1139111D+13,
     &  6.1290710D+13,  6.1422579D+13,  6.1552368D+13,  6.1682156D+13,
     &  6.1811945D+13,  6.1941716D+13,  6.2071505D+13,  6.2209565D+13,
     &  6.2348648D+13,  6.2487714D+13,  6.2626797D+13,  6.2765880D+13,
     &  6.2913922D+13,  6.3078910D+13,  6.3243897D+13,  6.3408884D+13,
     &  6.3573871D+13,  6.3756961D+13,  6.3946761D+13,  6.4136562D+13,
     &  6.4326363D+13,  6.4541094D+13,  6.4763493D+13,  6.4985892D+13,
     &  6.5225320D+13,  6.5488269D+13,  6.5751218D+13,  6.6043276D+13,
     &  6.6353017D+13,  6.6678478D+13,  6.7045647D+13,  6.7434795D+13,
     &  6.7871909D+13,  6.8369890D+13,  6.8933554D+13,  6.9592546D+13,
     &  7.0353410D+13,  7.1228241D+13,  7.2233599D+13,  7.3402535D+13,
     &  7.4779994D+13,  7.6323297D+13,  7.7978671D+13,  7.9661543D+13,
     &  8.1315827D+13,  8.2865824D+13,  8.4333327D+13,  8.5718722D+13,
     &  8.6971762D+13,  8.8127109D+13,  8.9197042D+13,  9.0187032D+13,
     &  9.1113000D+13,  9.1976439D+13,  9.2776998D+13,  9.3537576D+13,
     &  9.4253275D+13,  9.4930857D+13,  9.5584111D+13,  9.6216193D+13,
     &  9.6829182D+13,  9.7433246D+13,  9.8036152D+13,  9.8641675D+13,
     &  9.9259848D+13,  9.9894732D+13,  1.0055260D+14,  1.0123548D+14,
     &  1.0194659D+14,  1.0268643D+14,  1.0344259D+14,  1.0421597D+14,
     &  1.0499725D+14,  1.0578540D+14,  1.0657869D+14,  1.0738224D+14/
      data ( tapcrs(i),i=5001,5200 )/
     &  1.0819543D+14,  1.0900971D+14,  1.0982401D+14,  1.1063831D+14,
     &  1.1145259D+14,  1.1226689D+14,  1.1308119D+14,  1.1389549D+14,
     &  1.1470977D+14,  1.1552407D+14,  1.3678358D+25,  2.7085096D+25,
     &  3.8333017D+25,  4.9107649D+25,  5.9785086D+25,  7.0511646D+25,
     &  8.1338372D+25,  9.2286552D+25,  1.0336200D+26,  1.1456302D+26,
     &  1.2588412D+26,  1.3731808D+26,  1.4885691D+26,  1.6049256D+26,
     &  1.7221716D+26,  1.8402317D+26,  1.9590354D+26,  2.0785171D+26,
     &  2.1986158D+26,  2.3192757D+26,  2.4404452D+26,  2.5620773D+26,
     &  2.6841284D+26,  2.8065592D+26,  2.9293336D+26,  3.0524187D+26,
     &  3.1757826D+26,  3.2994024D+26,  3.4232494D+26,  3.5472971D+26,
     &  3.6715307D+26,  3.7959297D+26,  3.9204762D+26,  4.0451496D+26,
     &  4.1699411D+26,  4.2948359D+26,  4.4198192D+26,  4.5448822D+26,
     &  4.6700131D+26,  4.7952001D+26,  4.9204402D+26,  5.0457217D+26,
     &  5.1710385D+26,  5.2963849D+26,  5.4217519D+26,  5.5471337D+26,
     &  5.6725302D+26,  5.7979327D+26,  5.9233381D+26,  6.0487405D+26,
     &  6.1741400D+26,  6.2995306D+26,  6.4249095D+26,  6.5502735D+26,
     &  6.6756229D+26,  6.8009545D+26,  6.9262625D+26,  7.0515527D+26,
     &  7.1768135D+26,  7.3020536D+26,  7.4272642D+26,  7.5524453D+26,
     &  7.6775998D+26,  7.8027219D+26,  7.9278144D+26,  8.0528745D+26,
     &  8.1779021D+26,  8.3028943D+26,  8.4278540D+26,  8.5527812D+26,
     &  8.6776731D+26,  8.8025295D+26,  8.9273505D+26,  9.0521361D+26,
     &  9.1768862D+26,  9.3015980D+26,  9.4262774D+26,  9.5509213D+26,
     &  9.6755268D+26,  9.8000969D+26,  9.9246317D+26,  1.0049131D+27,
     &  1.0173592D+27,  1.0298023D+27,  1.0422413D+27,  1.0546771D+27,
     &  1.0671093D+27,  1.0795380D+27,  1.0919631D+27,  1.1043850D+27,
     &  1.1168034D+27,  1.1292182D+27,  1.1416297D+27,  1.1540380D+27,
     &  1.1664428D+27,  1.1788443D+27,  1.1912426D+27,  1.2036377D+27,
     &  1.2160294D+27,  1.2284180D+27,  1.2408036D+27,  1.2531859D+27,
     &  1.2655650D+27,  1.2779411D+27,  1.2903143D+27,  1.3026846D+27,
     &  1.3150513D+27,  1.3274156D+27,  1.3397770D+27,  1.3521351D+27,
     &  1.3644906D+27,  1.3768431D+27,  1.3891930D+27,  1.4015402D+27,
     &  1.4138845D+27,  1.4262258D+27,  1.4385648D+27,  4.1112310D-01,
     &  4.7742981D-01,  4.1159421D-01,  4.7853261D-01,  4.1205478D-01,
     &  4.7972602D-01,  4.1245621D-01,  4.8087341D-01,  4.1296798D-01,
     &  4.8233598D-01,  4.1349196D-01,  4.8383301D-01,  4.1380799D-01,
     &  4.8525500D-01,  4.1459101D-01,  4.8736900D-01,  4.1482401D-01,
     &  4.8912001D-01,  4.1525698D-01,  4.9135697D-01,  4.1493201D-01,
     &  4.9337500D-01,  4.1208100D-01,  4.9362397D-01,  4.0617299D-01,
     &  4.9259299D-01,  3.9333302D-01,  4.8782599D-01,  3.7791800D-01,
     &  4.8554897D-01,  3.6482596D-01,  4.8527598D-01,  3.4545499D-01,
     &  4.7552401D-01,  3.2461101D-01,  4.6214998D-01,  3.0085498D-01,
     &  4.4358999D-01,  2.4587202D-01,  3.7522900D-01,  1.8765402D-01,
     &  3.0078000D-01,  1.6357398D-01,  2.7731997D-01,  1.4982098D-01,
     &  2.6666701D-01,  1.5677696D-01,  2.8241801D-01,  1.8484801D-01,
     &  3.3295500D-01,  2.1302700D-01,  3.7816101D-01,  2.1243203D-01,
     &  3.8088602D-01,  2.0627499D-01,  3.7411797D-01,  1.9065398D-01,
     &  3.4883201D-01,  1.6373497D-01,  3.0601901D-01,  1.3607299D-01,
     &  2.6095903D-01,  1.1535603D-01,  2.2584301D-01,  9.6198976D-02,
     &  1.9100899D-01,  8.2979023D-02,  1.6382998D-01,  6.5702021D-02,
     &  1.3099200D-01,  7.2000027D-02,  1.3300002D-01,  8.6525023D-02/
      data ( tapcrs(i),i=5201,5400 )/
     &  1.4738899D-01,  1.0706300D-01,  1.6970301D-01,  1.3511896D-01,
     &  2.0357102D-01,  1.6219902D-01,  2.3659801D-01,  1.8567502D-01,
     &  2.6446301D-01,  2.0265400D-01,  2.8312099D-01,  2.1679401D-01,
     &  2.9694700D-01,  2.2883701D-01,  3.0821103D-01,  2.3802799D-01,
     &  3.1549299D-01,  2.4619597D-01,  3.2214701D-01,  2.5541103D-01,
     &  3.2922101D-01,  2.6317501D-01,  3.3503699D-01,  2.3324198D-01,
     &  3.0355197D-01,  2.7493197D-01,  3.4275800D-01,  2.8101099D-01,
     &  3.4693402D-01,  2.8557098D-01,  3.4919399D-01,  2.8928000D-01,
     &  3.5025901D-01,  2.9214901D-01,  3.5049897D-01,  2.9193199D-01,
     &  3.4638399D-01,  2.8911799D-01,  3.3921200D-01,  2.7798200D-01,
     &  3.2018298D-01,  2.7055299D-01,  3.0672598D-01,  2.7022201D-01,
     &  3.0533302D-01,  2.7253997D-01,  3.0792999D-01,  2.7541101D-01,
     &  3.1214797D-01,  2.8177798D-01,  3.2266700D-01,  2.9653901D-01,
     &  3.4726799D-01,  3.0627596D-01,  3.6584699D-01,  3.0967098D-01,
     &  3.7667000D-01,  2.9776299D-01,  3.6839801D-01,  2.7618998D-01,
     &  3.4821397D-01,  2.6591998D-01,  3.3880597D-01,  2.6163501D-01,
     &  3.3396196D-01,  2.5904500D-01,  3.2989901D-01,  2.5755697D-01,
     &  3.2608700D-01,  2.6060599D-01,  3.2727301D-01,  2.6161098D-01,
     &  3.2571101D-01,  2.6249999D-01,  3.2395798D-01,  2.6249999D-01,
     &  3.2159102D-01,  2.6182503D-01,  3.1843597D-01,  2.6117200D-01,
     &  3.1538498D-01,  2.6139402D-01,  3.1397599D-01,  2.6183403D-01,
     &  3.1268698D-01,  2.6239002D-01,  3.1188202D-01,  2.6293200D-01,
     &  3.1110001D-01,  2.6352501D-01,  3.1055301D-01,  2.6294398D-01,
     &  3.0862898D-01,  2.6318997D-01,  3.0762303D-01,  2.6335001D-01,
     &  3.0696499D-01,  2.6391298D-01,  3.0649000D-01,  2.6406497D-01,
     &  3.0585396D-01,  2.6467198D-01,  3.0559802D-01,  2.6423800D-01,
     &  3.0421901D-01,  2.6489401D-01,  3.0417901D-01,  2.6509398D-01,
     &  3.0377400D-01,  2.6573199D-01,  3.0373800D-01,  2.6536602D-01,
     &  3.0260199D-01,  2.6555902D-01,  3.0221599D-01,  2.6629996D-01,
     &  3.0256599D-01,  2.6648498D-01,  3.0218601D-01,  2.6618302D-01,
     &  3.0126899D-01,  2.6690698D-01,  3.0162001D-01,  2.6660699D-01,
     &  3.0071700D-01,  2.6684499D-01,  3.0053496D-01,  2.6684397D-01,
     &  3.0008900D-01,  2.6684302D-01,  2.9964697D-01,  2.6660800D-01,
     &  2.9894400D-01,  2.6736701D-01,  2.9947501D-01,  2.6689899D-01,
     &  2.9851699D-01,  2.6718801D-01,  2.9852301D-01,  2.6747400D-01,
     &  2.9852903D-01,  2.6724100D-01,  2.9784501D-01,  2.6729703D-01,
     &  2.9759401D-01,  2.6712400D-01,  2.9708701D-01,  2.6740599D-01,
     &  2.9709899D-01,  2.6723397D-01,  2.9659599D-01,  2.6706302D-01,
     &  2.9609501D-01,  2.6739997D-01,  2.9627699D-01,  2.6722902D-01,
     &  2.9578102D-01,  2.6705903D-01,  2.9528600D-01,  2.6717001D-01,
     &  2.9521400D-01,  0.0000000D+00,  2.0000000D-29,  2.2999999D-27,
     &  7.0000004D-27,  1.4000001D-26,  2.3999999D-26,  3.6700000D-26,
     &  5.6999983D-26,  8.0000011D-26,  8.2799975D-26,  7.5999994D-26,
     &  6.3000010D-26,  5.1999985D-26,  4.4499998D-26,  3.9500000D-26,
     &  3.4299999D-26,  2.9000000D-26,  2.4500001D-26,  2.0000000D-26,
     &  1.7300000D-26,  1.5500001D-26,  1.4000001D-26,  1.2999999D-26,
     &  1.2199999D-26,  1.1499999D-26,  1.1000000D-26,  1.0500001D-26,
     &  1.0099999D-26,  9.7000001D-27,  9.4999992D-27,  9.3000014D-27,
     &  9.3000014D-27,  9.3999988D-27,  9.4999992D-27,  9.4999992D-27,
     &  9.3000014D-27,  9.1000005D-27,  8.7999992D-27,  8.3000000D-27/

      data ( tapcrs(i),i=5401,5600 )/
     &  7.9000013D-27,  7.6000000D-27,  7.8000009D-27,  8.4000005D-27,
     &  9.9999983D-27,  1.2899999D-26,  1.4500000D-26,  1.4100001D-26,
     &  1.3100000D-26,  1.2500000D-26,  1.2299999D-26,  1.2199999D-26,
     &  1.2099998D-26,  1.2149999D-26,  1.2199999D-26,  1.2299999D-26,
     &  1.2500000D-26,  1.2700001D-26,  1.2799998D-26,  1.2849999D-26,
     &  1.2899999D-26,  1.2990000D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2990000D-26,
     &  1.2799998D-26,  1.2700001D-26,  1.2400000D-26,  1.2199999D-26,
     &  1.1900001D-26,  1.1599999D-26,  1.1400002D-26,  1.1200001D-26,
     &  1.1100000D-26,  1.1000000D-26,  1.1000000D-26,  1.1050000D-26,
     &  1.1200001D-26,  1.1400002D-26,  1.1499999D-26,  1.1700000D-26,
     &  1.1800000D-26,  1.1900001D-26,  1.2000001D-26,  1.2050001D-26,
     &  1.2099998D-26,  1.2199999D-26,  1.2299999D-26,  1.2350000D-26,
     &  1.2400000D-26,  1.2500000D-26,  1.2500000D-26,  1.2500000D-26,
     &  1.2500000D-26,  1.2500000D-26,  1.2500000D-26,  1.2400000D-26,
     &  1.2350000D-26,  1.2299999D-26,  1.2270001D-26,  1.2249999D-26,
     &  1.2199999D-26,  1.2149999D-26,  1.2099998D-26,  1.2070000D-26,
     &  1.2050001D-26,  1.2029999D-26,  1.2020000D-26,  1.2010001D-26,
     &  1.2000001D-26,  1.1989999D-26,  1.1989999D-26,  1.1979999D-26,
     &  1.1950001D-26,  1.1940001D-26,  1.1900001D-26,  1.1850000D-26,
     &  1.1829998D-26,  1.1810000D-26,  1.1800000D-26,  1.1769999D-26,
     &  1.1750000D-26,  1.1700000D-26,  1.1549999D-26,  0.0000000D+00,
     &  2.0000000D-29,  2.2999999D-27,  7.0000004D-27,  1.4000001D-26,
     &  2.3999999D-26,  3.6700000D-26,  5.6999983D-26,  8.0000011D-26,
     &  8.2799975D-26,  7.5999994D-26,  6.3000010D-26,  5.1999985D-26,
     &  4.4499998D-26,  3.9500000D-26,  3.4299999D-26,  2.9000000D-26,
     &  2.4500001D-26,  2.0000000D-26,  1.7300000D-26,  1.5500001D-26,
     &  1.4000001D-26,  1.2999999D-26,  1.2199999D-26,  1.1499999D-26,
     &  1.1000000D-26,  1.0500001D-26,  1.0099999D-26,  9.7000001D-27,
     &  9.4999992D-27,  9.3000014D-27,  9.3000014D-27,  9.3999988D-27,
     &  9.4999992D-27,  9.4999992D-27,  9.3000014D-27,  9.1000005D-27,
     &  8.7999992D-27,  8.3000000D-27,  7.9000013D-27,  7.6000000D-27,
     &  7.8000009D-27,  8.4000005D-27,  9.9999983D-27,  1.2899999D-26,
     &  1.4500000D-26,  1.4100001D-26,  1.3100000D-26,  1.2500000D-26,
     &  1.2299999D-26,  1.2199999D-26,  1.2099998D-26,  1.2149999D-26,
     &  1.2199999D-26,  1.2299999D-26,  1.2500000D-26,  1.2700001D-26,
     &  1.2799998D-26,  1.2849999D-26,  1.2899999D-26,  1.2990000D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2990000D-26,  1.2799998D-26,  1.2700001D-26,
     &  1.2400000D-26,  1.2199999D-26,  1.1900001D-26,  1.1599999D-26,
     &  1.1400002D-26,  1.1200001D-26,  1.1100000D-26,  1.1000000D-26,
     &  1.1000000D-26,  1.1050000D-26,  1.1200001D-26,  1.1400002D-26,
     &  1.1499999D-26,  1.1700000D-26,  1.1800000D-26,  1.1900001D-26,
     &  1.2000001D-26,  1.2050001D-26,  1.2099998D-26,  1.2199999D-26,
     &  1.2299999D-26,  1.2350000D-26,  1.2400000D-26,  1.2500000D-26,
     &  1.2500000D-26,  1.2500000D-26,  1.2500000D-26,  1.2500000D-26,
     &  1.2500000D-26,  1.2400000D-26,  1.2350000D-26,  1.2299999D-26,
     &  1.2270001D-26,  1.2249999D-26,  1.2199999D-26,  1.2149999D-26,
     &  1.2099998D-26,  1.2070000D-26,  1.2050001D-26,  1.2029999D-26,
     &  1.2020000D-26,  1.2010001D-26,  1.2000001D-26,  1.1989999D-26/
      data ( tapcrs(i),i=5601,5800 )/
     &  1.1989999D-26,  1.1979999D-26,  1.1950001D-26,  1.1940001D-26,
     &  1.1900001D-26,  1.1850000D-26,  1.1829998D-26,  1.1810000D-26,
     &  1.1800000D-26,  1.1769999D-26,  1.1750000D-26,  1.1700000D-26,
     &  1.1549999D-26,  0.0000000D+00,  2.7000001D-27,  5.7500010D-27,
     &  9.0000001D-27,  1.2750001D-26,  1.6750001D-26,  2.1999999D-26,
     &  3.2500000D-26,  4.3500000D-26,  4.5000000D-26,  4.2999998D-26,
     &  3.4249999D-26,  2.8799999D-26,  2.5399999D-26,  2.2699999D-26,
     &  2.0200001D-26,  1.8300001D-26,  1.6000000D-26,  1.4000001D-26,
     &  1.2700001D-26,  1.1900001D-26,  1.1300001D-26,  1.0799999D-26,
     &  1.0500001D-26,  1.0199999D-26,  9.9000010D-27,  9.7500003D-27,
     &  9.5999996D-27,  9.4999992D-27,  9.3999988D-27,  9.2000009D-27,
     &  8.5000009D-27,  7.1000008D-27,  5.9999990D-27,  5.2999990D-27,
     &  5.0000007D-27,  4.7999998D-27,  5.0000007D-27,  5.4999999D-27,
     &  6.3000003D-27,  7.1000008D-27,  7.7500006D-27,  8.1999996D-27,
     &  8.2499998D-27,  7.9999987D-27,  7.4999995D-27,  6.5999986D-27,
     &  5.8000012D-27,  5.3999994D-27,  4.9000003D-27,  4.4999985D-27,
     &  4.2000002D-27,  3.8000015D-27,  3.6000006D-27,  3.2999993D-27,
     &  3.0000001D-27,  2.8000000D-27,  2.6000000D-27,  2.3999999D-27,
     &  2.2000000D-27,  2.0000001D-27,  1.7999999D-27,  1.7000001D-27,
     &  1.4999999D-27,  1.4000001D-27,  1.2500000D-27,  1.2000000D-27,
     &  1.0000000D-27,  8.9999997D-28,  7.9999991D-28,  7.5000007D-28,
     &  7.0000004D-28,  6.5000001D-28,  5.9999998D-28,  4.9999992D-28,
     &  4.0000005D-28,  3.5000002D-28,  2.9999999D-28,  2.4999996D-28,
     &  2.0000000D-28,  1.7500000D-28,  1.4999999D-28,  1.0000000D-28,
     &  4.9999994D-29,  1.0000000D-29,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  7.0000004D-28,  1.4999999D-27,  2.8000000D-27,  4.6999994D-27,
     &  7.2000013D-27,  1.0199999D-26,  1.5800000D-26,  2.1099999D-26,
     &  2.1899999D-26,  2.0800000D-26,  1.6800001D-26,  1.4199999D-26,
     &  1.2199999D-26,  1.0500001D-26,  9.3999988D-27,  8.8999996D-27,
     &  8.6999987D-27,  9.1000005D-27,  9.8000005D-27,  1.0799999D-26,
     &  1.1900001D-26,  1.2899999D-26,  1.3800000D-26,  1.4399999D-26,
     &  1.4999999D-26,  1.5400001D-26,  1.5800000D-26,  1.6100001D-26,
     &  1.6299999D-26,  1.6500000D-26,  1.6600000D-26,  1.6399999D-26,
     &  1.6000000D-26,  1.5599999D-26,  1.5100000D-26,  1.4800001D-26,
     &  1.4600000D-26,  1.4349999D-26,  1.4299999D-26,  1.4399999D-26,
     &  1.4999999D-26,  1.6900001D-26,  2.0200001D-26,  2.5800001D-26,
     &  2.7899998D-26,  2.6599998D-26,  2.3400000D-26,  2.1299999D-26,
     &  1.9899999D-26,  1.9000001D-26,  1.8200001D-26,  1.7500001D-26,
     &  1.6800001D-26,  1.6100001D-26,  1.5400001D-26,  1.4700001D-26,
     &  1.4100001D-26,  1.3499999D-26,  1.2999999D-26,  1.2400000D-26/
      data ( tapcrs(i),i=5801,6000 )/
     &  1.1900001D-26,  1.1499999D-26,  1.1000000D-26,  1.0600001D-26,
     &  1.0199999D-26,  9.9000010D-27,  9.7000001D-27,  9.3999988D-27,
     &  9.3000014D-27,  9.1000005D-27,  9.0500003D-27,  9.0000001D-27,
     &  9.0000001D-27,  9.0500003D-27,  9.1000005D-27,  9.3000014D-27,
     &  9.4999992D-27,  9.7000001D-27,  9.8000005D-27,  1.0099999D-26,
     &  1.0199999D-26,  1.0400000D-26,  1.0600001D-26,  1.0700001D-26,
     &  1.0899999D-26,  1.1100000D-26,  1.1300001D-26,  1.1400002D-26,
     &  1.1499999D-26,  1.1599999D-26,  1.1700000D-26,  1.1750000D-26,
     &  1.1800000D-26,  1.1850000D-26,  1.1900001D-26,  1.1900001D-26,
     &  1.1900001D-26,  1.1900001D-26,  1.1850000D-26,  1.1800000D-26,
     &  1.1750000D-26,  1.1700000D-26,  1.1680001D-26,  1.1650000D-26,
     &  1.1620001D-26,  1.1599999D-26,  1.1590000D-26,  1.1580000D-26,
     &  1.1549999D-26,  1.1449999D-26,  1.1400002D-26,  1.1350001D-26,
     &  1.1300001D-26,  1.1200001D-26,  1.1179999D-26,  1.1150000D-26,
     &  1.1100000D-26,  1.1050000D-26,  1.1000000D-26,  1.0899999D-26,
     &  1.0849999D-26,  1.0799999D-26,  1.0700001D-26,  1.0650001D-26,
     &  1.0600001D-26,  0.0000000D+00,  3.7500013D-27,  9.9999983D-27,
     &  1.9500001D-26,  3.4999999D-26,  6.2500020D-26,  9.5499994D-26,
     &  1.4630002D-25,  2.0019998D-25,  2.0030002D-25,  1.6449998D-25,
     &  1.4249998D-25,  1.2379998D-25,  1.0660001D-25,  9.1250006D-26,
     &  7.6600021D-26,  6.4099978D-26,  5.2499975D-26,  4.3749998D-26,
     &  3.6799998D-26,  3.1659999D-26,  2.7800001D-26,  2.4500001D-26,
     &  2.1249999D-26,  1.8800001D-26,  1.6999999D-26,  1.5500001D-26,
     &  1.3499999D-26,  1.2999999D-26,  1.2000001D-26,  1.1000000D-26,
     &  1.0500001D-26,  9.4999992D-27,  9.0000001D-27,  8.7499989D-27,
     &  8.5000009D-27,  8.4369999D-27,  8.3329997D-27,  8.1249992D-27,
     &  8.1249992D-27,  7.9999987D-27,  7.9999987D-27,  8.0999991D-27,
     &  8.1999996D-27,  8.3000000D-27,  8.4369999D-27,  8.7499989D-27,
     &  8.8999996D-27,  9.1000005D-27,  9.4999992D-27,  9.9999983D-27,
     &  1.0500001D-26,  1.0799999D-26,  1.1250001D-26,  1.1900001D-26,
     &  1.2500000D-26,  1.3100000D-26,  1.3699999D-26,  1.4199999D-26,
     &  1.4999999D-26,  1.5500001D-26,  1.5800000D-26,  1.6249998D-26,
     &  1.6299999D-26,  1.6299999D-26,  1.6299999D-26,  1.6249998D-26,
     &  1.6249998D-26,  1.5800000D-26,  1.5699999D-26,  1.5599999D-26,
     &  1.5200000D-26,  1.4700001D-26,  1.4199999D-26,  1.3750000D-26,
     &  1.3329999D-26,  1.3100000D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,
     &  1.2999999D-26,  1.2999999D-26,  1.2999999D-26,  7.0000001D-25,
     &  1.6000002D-25,  7.1499986D-26,  4.7499999D-26,  3.4000001D-26,
     &  3.0000001D-26,  2.8000002D-26,  2.6500001D-26,  2.5500000D-26/

      data ( tapcrs(i),i=6001,6200 )/
     &  2.4699999D-26,  2.4049999D-26,  2.3800001D-26,  2.3500000D-26,
     &  2.3400000D-26,  2.3400000D-26,  2.3400000D-26,  2.3500000D-26,
     &  2.3600000D-26,  2.3700001D-26,  2.3800001D-26,  2.3999999D-26,
     &  2.4200000D-26,  2.4300000D-26,  2.4500001D-26,  2.4599999D-26,
     &  2.4800000D-26,  2.4900000D-26,  2.5000000D-26,  2.5000000D-26,
     &  2.5100001D-26,  2.5200001D-26,  2.5249999D-26,  2.5200001D-26,
     &  2.5000000D-26,  2.4900000D-26,  2.4599999D-26,  2.4300000D-26,
     &  2.3899999D-26,  2.3500000D-26,  2.3000001D-26,  2.2499999D-26,
     &  2.1999999D-26,  2.1500000D-26,  2.1050001D-26,  2.0700000D-26,
     &  2.0399998D-26,  2.0100000D-26,  1.9899999D-26,  1.9700002D-26,
     &  1.9600001D-26,  1.9400000D-26,  1.9300000D-26,  1.9199999D-26,
     &  1.9099999D-26,  1.9049999D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.8950001D-26,  1.8900001D-26,
     &  1.8850001D-26,  1.8800001D-26,  1.8750000D-26,  1.8700000D-26,
     &  1.8650000D-26,  1.8600000D-26,  1.8549999D-26,  1.8499999D-26,
     &  1.8449999D-26,  1.8399999D-26,  1.8349999D-26,  1.8300001D-26,
     &  1.8250001D-26,  1.8200001D-26,  1.8100001D-26,  1.8000000D-26,
     &  1.8000000D-26,  1.7950000D-26,  1.7900000D-26,  1.7799999D-26,
     &  1.7699999D-26,  1.7600001D-26,  1.7500001D-26,  1.7400001D-26,
     &  1.7300000D-26,  1.7200000D-26,  1.7099999D-26,  1.7049999D-26,
     &  1.6999999D-26,  1.6900001D-26,  1.6800001D-26,  1.6700000D-26,
     &  1.6600000D-26,  1.6550000D-26,  1.6500000D-26,  1.6399999D-26,
     &  1.6299999D-26,  1.6200001D-26,  1.6100001D-26,  1.6000000D-26,
     &  1.5900000D-26,  1.5800000D-26,  1.5699999D-26,  1.5599999D-26,
     &  1.5500001D-26,  1.5400001D-26,  1.5300000D-26,  1.5200000D-26,
     &  1.5100000D-26,  1.4999999D-26,  1.4899999D-26,  1.4800001D-26,
     &  1.4700001D-26,  1.4600000D-26,  1.4500000D-26,  1.4399999D-26,
     &  1.4199999D-26,  1.4100001D-26,  1.4000001D-26,  1.3950001D-26,
     &  1.3900000D-26,  1.3800000D-26,  1.3599999D-26,  1.3499999D-26,
     &  1.3400001D-26,  1.3300001D-26,  1.3200000D-26,  1.3100000D-26,
     &  1.2999999D-26,  1.2899999D-26,  1.2799998D-26,  1.2700001D-26,
     &  1.2600001D-26,  1.2500000D-26,  1.2400000D-26,  1.2299999D-26,
     &  1.2199999D-26,  1.2099998D-26,  1.2000001D-26,  1.1900001D-26,
     &  1.1800000D-26,  1.1700000D-26,  1.1599999D-26,  1.1499999D-26,
     &  1.1400002D-26,  1.1300001D-26,  1.1200001D-26,  4.4000003D-24,
     &  4.7999997D-25,  2.1999999D-25,  1.3999998D-25,  1.0000000D-25,
     &  7.3999985D-26,  6.1999981D-26,  5.6000003D-26,  5.1499998D-26,
     &  4.7499999D-26,  4.3999999D-26,  4.1099998D-26,  3.8700000D-26,
     &  3.6499999D-26,  3.5200000D-26,  3.4299999D-26,  3.3800000D-26,
     &  3.3400001D-26,  3.3100000D-26,  3.2999999D-26,  3.2800001D-26,
     &  3.2400000D-26,  3.2000001D-26,  3.1400001D-26,  3.0899999D-26,
     &  3.0199999D-26,  2.9499999D-26,  2.8899999D-26,  2.8000002D-26,
     &  2.7200001D-26,  2.6400001D-26,  2.5800001D-26,  2.5000000D-26/
      data ( tapcrs(i),i=6201,6400 )/
     &  2.4400001D-26,  2.3899999D-26,  2.3500000D-26,  2.3199999D-26,
     &  2.2900000D-26,  2.2800000D-26,  2.2599999D-26,  2.2499999D-26,
     &  2.2400001D-26,  2.2300001D-26,  2.2250001D-26,  2.2200000D-26,
     &  2.2200000D-26,  2.2150000D-26,  2.2150000D-26,  2.2150000D-26,
     &  2.2150000D-26,  2.2200000D-26,  2.2250001D-26,  2.2300001D-26,
     &  2.2400001D-26,  2.2499999D-26,  2.2599999D-26,  2.2699999D-26,
     &  2.2900000D-26,  2.3050001D-26,  2.3400000D-26,  2.3700001D-26,
     &  2.3999999D-26,  2.4300000D-26,  2.4699999D-26,  2.4950000D-26,
     &  2.5200001D-26,  2.5399999D-26,  2.5500000D-26,  2.5700001D-26,
     &  2.5800001D-26,  2.5900001D-26,  2.5999999D-26,  2.6049999D-26,
     &  2.6099999D-26,  2.6099999D-26,  2.6099999D-26,  2.6099999D-26,
     &  2.6049999D-26,  2.5999999D-26,  2.5949999D-26,  2.5800001D-26,
     &  2.5750001D-26,  2.5600000D-26,  2.5500000D-26,  2.5399999D-26,
     &  2.5200001D-26,  2.5100001D-26,  2.5000000D-26,  2.4950000D-26,
     &  2.4900000D-26,  2.4800000D-26,  2.4599999D-26,  2.4500001D-26,
     &  2.4300000D-26,  2.4200000D-26,  2.4100000D-26,  2.3949999D-26,
     &  2.3800001D-26,  2.3700001D-26,  2.3600000D-26,  2.3400000D-26,
     &  2.3299999D-26,  2.3199999D-26,  2.3000001D-26,  2.2900000D-26,
     &  2.2800000D-26,  2.2599999D-26,  2.2499999D-26,  2.2300001D-26,
     &  2.2100000D-26,  2.1999999D-26,  2.1799999D-26,  2.1600001D-26,
     &  2.1500000D-26,  2.1299999D-26,  2.1199999D-26,  2.1000001D-26,
     &  2.0800000D-26,  2.0599999D-26,  2.0399998D-26,  2.0200001D-26,
     &  2.0100000D-26,  1.9950000D-26,  1.9799999D-26,  1.9600001D-26,
     &  1.9400000D-26,  1.9300000D-26,  1.9099999D-26,  1.9000001D-26,
     &  1.8800001D-26,  1.8600000D-26,  1.8399999D-26,  1.8200001D-26,
     &  1.8000000D-26,  1.7799999D-26,  1.7600001D-26,  1.7500001D-26,
     &  1.7300000D-26,  1.7099999D-26,  1.6949999D-26,  1.6700000D-26,
     &  1.6500000D-26,  1.6399999D-26,  1.6200001D-26,  1.5950000D-26,
     &  1.5699999D-26,  1.5500001D-26,  1.5400001D-26,  1.5200000D-26,
     &  1.4999999D-26,  1.4800001D-26,  1.4399999D-26,  1.4199999D-26,
     &  1.4000001D-26,  1.3800000D-26,  1.3599999D-26,  1.3400001D-26,
     &  1.3200000D-26,  1.3050000D-26,  1.2899999D-26,  1.2700001D-26,
     &  1.2500000D-26,  1.2249999D-26,  1.2000001D-26,  1.1800000D-26,
     &  1.1599999D-26,  1.1499999D-26,  1.1250001D-26,  1.1050000D-26,
     &  1.0799999D-26,  1.0700001D-26,  1.0500001D-26,  1.0300000D-26,
     &  1.0099999D-26,  9.9000010D-27,  9.7000001D-27,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00/
      data ( tapcrs(i),i=6401,6600 )/
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,
     &  0.0000000D+00,  0.0000000D+00,  0.0000000D+00,  0.0000000D+00/

!*-----------------------------------------------------------------------

      data ( tapcr1(i),i = 1, 201 )/
     &  2.6360000D-25,
     &  8.8676700D-26,  5.5000000D-26,  3.7700000D-26,  3.1800000D-26,
     &  2.8900000D-26,  2.7119800D-26,  2.5942100D-26,  2.5106700D-26,
     &  2.4483400D-26,  2.4000500D-26,  2.3615300D-26,  2.3300900D-26,
     &  2.3039500D-26,  2.2818600D-26,  2.2629600D-26,  2.2421500D-26,
     &  2.2275200D-26,  2.2146300D-26,  2.2031800D-26,  2.1929500D-26,
     &  2.1837500D-26,  2.1754300D-26,  2.1678800D-26,  2.1609800D-26,
     &  2.1546700D-26,  2.1488600D-26,  2.1435000D-26,  2.1385400D-26,
     &  2.1339400D-26,  2.1296600D-26,  2.1256600D-26,  2.1219200D-26,
     &  2.1184200D-26,  2.1151300D-26,  2.1120400D-26,  2.1091200D-26,
     &  2.1063600D-26,  2.1037600D-26,  2.1012900D-26,  2.0989500D-26,
     &  2.0967300D-26,  2.0946200D-26,  2.0926000D-26,  2.0906800D-26,
     &  2.0888500D-26,  2.0871000D-26,  2.0854300D-26,  2.0838300D-26,
     &  2.0822900D-26,  2.0808200D-26,  2.0762100D-26,  2.0711400D-26,
     &  2.0660700D-26,  2.0610100D-26,  2.0559400D-26,  2.0508700D-26,
     &  2.0458000D-26,  2.0407300D-26,  2.0356600D-26,  2.0306000D-26,
     &  2.0255300D-26,  2.0204600D-26,  2.0153900D-26,  2.0103200D-26,
     &  2.0052500D-26,  2.0001900D-26,  1.9951200D-26,  1.9900500D-26,
     &  1.9849800D-26,  1.9799100D-26,  1.9748400D-26,  1.9697800D-26,
     &  1.9647100D-26,  1.9596400D-26,  1.9545700D-26,  1.9495000D-26,
     &  1.9444300D-26,  1.9393600D-26,  1.9343000D-26,  1.9292300D-26,
     &  1.9241600D-26,  1.9190900D-26,  1.9140200D-26,  1.9089500D-26,
     &  1.9038900D-26,  1.9000000D-26,  1.8950000D-26,  1.8900000D-26,
     &  1.8850000D-26,  1.8800000D-26,  1.8750000D-26,  1.8700000D-26,
     &  1.8650000D-26,  1.8600000D-26,  1.8550000D-26,  1.8500000D-26,
     &  1.8450000D-26,  1.8400000D-26,  1.8350000D-26,  1.8300000D-26,
     &  1.8250000D-26,  1.8200000D-26,  1.8100000D-26,  1.8000000D-26,
     &  1.8000000D-26,  1.7950000D-26,  1.7900000D-26,  1.7800000D-26,
     &  1.7700000D-26,  1.7600000D-26,  1.7500000D-26,  1.7400000D-26,
     &  1.7300000D-26,  1.7200000D-26,  1.7100000D-26,  1.7050000D-26,
     &  1.7000000D-26,  1.6900000D-26,  1.6800000D-26,  1.6700000D-26,
     &  1.6600000D-26,  1.6550000D-26,  1.6500000D-26,  1.6400000D-26,
     &  1.6300000D-26,  1.6200000D-26,  1.6100000D-26,  1.6000000D-26,
     &  1.5900000D-26,  1.5800000D-26,  1.5700000D-26,  1.5600000D-26,
     &  1.5500000D-26,  1.5400000D-26,  1.5300000D-26,  1.5200000D-26,
     &  1.5100000D-26,  1.5000000D-26,  1.4900000D-26,  1.4800000D-26,
     &  1.4700000D-26,  1.4600000D-26,  1.4500000D-26,  1.4400000D-26,
     &  1.4200000D-26,  1.4100000D-26,  1.4000000D-26,  1.3950000D-26,
     &  1.3900000D-26,  1.3800000D-26,  1.3600000D-26,  1.3500000D-26,
     &  1.3400000D-26,  1.3300000D-26,  1.3200000D-26,  1.3100000D-26,
     &  1.3000000D-26,  1.2900000D-26,  1.2800000D-26,  1.2700000D-26,
     &  1.2600000D-26,  1.2500000D-26,  1.2400000D-26,  1.2300000D-26,
     &  1.2200000D-26,  1.2100000D-26,  1.2000000D-26,  1.1900000D-26,
     &  1.1800000D-26,  1.1700000D-26,  1.1600000D-26,  1.1500000D-26,
     &  1.1400000D-26,  1.1300000D-26,  1.1200000D-26,  2.6360000D-25,
     &  8.8676700D-26,  5.5000000D-26,  3.9700000D-26,  3.4500000D-26,
     &  3.1900000D-26,  3.0308600D-26,  2.9270200D-26,  2.8527000D-26,
     &  2.7968900D-26,  2.7534300D-26,  2.7186400D-26,  2.6901500D-26,
     &  2.6664000D-26,  2.6462900D-26,  2.6290400D-26,  2.6156700D-26,
     &  2.6029600D-26,  2.5917100D-26,  2.5816800D-26,  2.5726800D-26,
     &  2.5645600D-26,  2.5572000D-26,  2.5505000D-26,  2.5443600D-26/
      data ( tapcr1(i),i = 202, 352 )/
     &  2.5387300D-26,  2.5335500D-26,  2.5287500D-26,  2.5243100D-26,
     &  2.5201700D-26,  2.5163200D-26,  2.5127200D-26,  2.5093500D-26,
     &  2.5061900D-26,  2.5032200D-26,  2.5004200D-26,  2.4977800D-26,
     &  2.4952800D-26,  2.4929200D-26,  2.4906800D-26,  2.4885500D-26,
     &  2.4865300D-26,  2.4846000D-26,  2.4827700D-26,  2.4810200D-26,
     &  2.4793500D-26,  2.4777500D-26,  2.4762300D-26,  2.4747600D-26,
     &  2.4733600D-26,  2.4720100D-26,  2.4665800D-26,  2.4599800D-26,
     &  2.4533800D-26,  2.4467800D-26,  2.4401800D-26,  2.4335800D-26,
     &  2.4269800D-26,  2.4203800D-26,  2.4137800D-26,  2.4071800D-26,
     &  2.4005800D-26,  2.3939800D-26,  2.3873700D-26,  2.3807700D-26,
     &  2.3741700D-26,  2.3675700D-26,  2.3609700D-26,  2.3543700D-26,
     &  2.3477700D-26,  2.3411700D-26,  2.3345700D-26,  2.3279700D-26,
     &  2.3213700D-26,  2.3147700D-26,  2.3081700D-26,  2.3015700D-26,
     &  2.2949700D-26,  2.2883700D-26,  2.2817700D-26,  2.2751700D-26,
     &  2.2685700D-26,  2.2619700D-26,  2.2553700D-26,  2.2487700D-26,
     &  2.2421700D-26,  2.2355700D-26,  2.2289700D-26,  2.2223600D-26,
     &  2.2157600D-26,  2.2091600D-26,  2.2025600D-26,  2.1959600D-26,
     &  2.1893600D-26,  2.1827600D-26,  2.1761600D-26,  2.1695600D-26,
     &  2.1629600D-26,  2.1563600D-26,  2.1497600D-26,  2.1431600D-26,
     &  2.1365600D-26,  2.1299600D-26,  2.1233600D-26,  2.1167600D-26,
     &  2.1101600D-26,  2.1035600D-26,  2.0969600D-26,  2.0903600D-26,
     &  2.0837600D-26,  2.0771600D-26,  2.0705600D-26,  2.0639600D-26,
     &  2.0573500D-26,  2.0507500D-26,  2.0441500D-26,  2.0375500D-26,
     &  2.0309500D-26,  2.0243500D-26,  2.0177500D-26,  2.0111500D-26,
     &  2.0100000D-26,  1.9950000D-26,  1.9800000D-26,  1.9600000D-26,
     &  1.9400000D-26,  1.9300000D-26,  1.9100000D-26,  1.9000000D-26,
     &  1.8800000D-26,  1.8600000D-26,  1.8400000D-26,  1.8200000D-26,
     &  1.8000000D-26,  1.7800000D-26,  1.7600000D-26,  1.7500000D-26,
     &  1.7300000D-26,  1.7100000D-26,  1.6950000D-26,  1.6700000D-26,
     &  1.6500000D-26,  1.6400000D-26,  1.6200000D-26,  1.5950000D-26,
     &  1.5700000D-26,  1.5500000D-26,  1.5400000D-26,  1.5200000D-26,
     &  1.5000000D-26,  1.4800000D-26,  1.4400000D-26,  1.4200000D-26,
     &  1.4000000D-26,  1.3800000D-26,  1.3600000D-26,  1.3400000D-26,
     &  1.3200000D-26,  1.3050000D-26,  1.2900000D-26,  1.2700000D-26,
     &  1.2500000D-26,  1.2250000D-26,  1.2000000D-26,  1.1800000D-26,
     &  1.1600000D-26,  1.1500000D-26,  1.1250000D-26,  1.1050000D-26,
     &  1.0800000D-26,  1.0700000D-26,  1.0500000D-26,  1.0300000D-26,
     &  1.0100000D-26,  9.9000000D-27,  9.7000000D-27/

!*-----------------------------------------------------------------------

      data ( tapcr2(i),i = 1, 201 )/
     &  2.6360000D-25,
     &  8.8676650D-26,  5.5556426D-26,  4.0143180D-26,  3.2088518D-26,
     &  2.7760029D-26,  2.5466840D-26,  2.4310671D-26,  2.3779042D-26,
     &  2.3570580D-26,  2.4049999D-26,  2.3800001D-26,  2.3500000D-26,
     &  2.3400000D-26,  2.3400000D-26,  2.3400000D-26,  2.3500000D-26,
     &  2.3600000D-26,  2.3700001D-26,  2.3800001D-26,  2.3999999D-26,
     &  2.4200000D-26,  2.4300000D-26,  2.4500001D-26,  2.4599999D-26,
     &  2.4800000D-26,  2.4900000D-26,  2.5000000D-26,  2.5000000D-26,
     &  2.5100001D-26,  2.5200001D-26,  2.5249999D-26,  2.5200001D-26,
     &  2.5000000D-26,  2.4900000D-26,  2.4599999D-26,  2.4300000D-26,
     &  2.3899999D-26,  2.3500000D-26,  2.3000001D-26,  2.2499999D-26,
     &  2.1999999D-26,  2.1500000D-26,  2.1050001D-26,  2.0700000D-26,
     &  2.0399998D-26,  2.0100000D-26,  1.9899999D-26,  1.9700002D-26,
     &  1.9600001D-26,  1.9400000D-26,  1.9300000D-26,  1.9199999D-26,
     &  1.9099999D-26,  1.9049999D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,  1.9000001D-26,
     &  1.9000001D-26,  1.9000001D-26,  1.8950001D-26,  1.8900001D-26,
     &  1.8850001D-26,  1.8800001D-26,  1.8750000D-26,  1.8700000D-26,
     &  1.8650000D-26,  1.8600000D-26,  1.8549999D-26,  1.8499999D-26,
     &  1.8449999D-26,  1.8399999D-26,  1.8349999D-26,  1.8300001D-26,
     &  1.8250001D-26,  1.8200001D-26,  1.8100001D-26,  1.8000000D-26,
     &  1.8000000D-26,  1.7950000D-26,  1.7900000D-26,  1.7799999D-26,
     &  1.7699999D-26,  1.7600001D-26,  1.7500001D-26,  1.7400001D-26,
     &  1.7300000D-26,  1.7200000D-26,  1.7099999D-26,  1.7049999D-26,
     &  1.6999999D-26,  1.6900001D-26,  1.6800001D-26,  1.6700000D-26,
     &  1.6600000D-26,  1.6550000D-26,  1.6500000D-26,  1.6399999D-26,
     &  1.6299999D-26,  1.6200001D-26,  1.6100001D-26,  1.6000000D-26,
     &  1.5900000D-26,  1.5800000D-26,  1.5699999D-26,  1.5599999D-26,
     &  1.5500001D-26,  1.5400001D-26,  1.5300000D-26,  1.5200000D-26,
     &  1.5100000D-26,  1.4999999D-26,  1.4899999D-26,  1.4800001D-26,
     &  1.4700001D-26,  1.4600000D-26,  1.4500000D-26,  1.4399999D-26,
     &  1.4199999D-26,  1.4100001D-26,  1.4000001D-26,  1.3950001D-26,
     &  1.3900000D-26,  1.3800000D-26,  1.3599999D-26,  1.3499999D-26,
     &  1.3400001D-26,  1.3300001D-26,  1.3200000D-26,  1.3100000D-26,
     &  1.2999999D-26,  1.2899999D-26,  1.2799998D-26,  1.2700001D-26,
     &  1.2600001D-26,  1.2500000D-26,  1.2400000D-26,  1.2299999D-26,
     &  1.2199999D-26,  1.2099998D-26,  1.2000001D-26,  1.1900001D-26,
     &  1.1800000D-26,  1.1700000D-26,  1.1599999D-26,  1.1499999D-26,
     &  1.1400002D-26,  1.1300001D-26,  1.1200001D-26,  2.0541104D-25,
     &  1.3016522D-25,  1.0587070D-25,  8.9769570D-26,  7.7860280D-26,
     &  6.8605022D-26,  6.1219383D-26,  5.6000003D-26,  5.1499998D-26,
     &  4.7499999D-26,  4.3999999D-26,  4.1099998D-26,  3.8700000D-26,
     &  3.6499999D-26,  3.5200000D-26,  3.4299999D-26,  3.3800000D-26,
     &  3.3400001D-26,  3.3100000D-26,  3.2999999D-26,  3.2800001D-26,
     &  3.2400000D-26,  3.2000001D-26,  3.1400001D-26,  3.0899999D-26/
      data ( tapcr2(i),i = 202, 352 )/
     &  3.0199999D-26,  2.9499999D-26,  2.8899999D-26,  2.8000002D-26,
     &  2.7200001D-26,  2.6400001D-26,  2.5800001D-26,  2.5000000D-26,
     &  2.4400001D-26,  2.3899999D-26,  2.3500000D-26,  2.3199999D-26,
     &  2.2900000D-26,  2.2800000D-26,  2.2599999D-26,  2.2499999D-26,
     &  2.2400001D-26,  2.2300001D-26,  2.2250001D-26,  2.2200000D-26,
     &  2.2200000D-26,  2.2150000D-26,  2.2150000D-26,  2.2150000D-26,
     &  2.2150000D-26,  2.2200000D-26,  2.2250001D-26,  2.2300001D-26,
     &  2.2400001D-26,  2.2499999D-26,  2.2599999D-26,  2.2699999D-26,
     &  2.2900000D-26,  2.3050001D-26,  2.3400000D-26,  2.3700001D-26,
     &  2.3999999D-26,  2.4300000D-26,  2.4699999D-26,  2.4950000D-26,
     &  2.5200001D-26,  2.5399999D-26,  2.5500000D-26,  2.5700001D-26,
     &  2.5800001D-26,  2.5900001D-26,  2.5999999D-26,  2.6049999D-26,
     &  2.6099999D-26,  2.6099999D-26,  2.6099999D-26,  2.6099999D-26,
     &  2.6049999D-26,  2.5999999D-26,  2.5949999D-26,  2.5800001D-26,
     &  2.5750001D-26,  2.5600000D-26,  2.5500000D-26,  2.5399999D-26,
     &  2.5200001D-26,  2.5100001D-26,  2.5000000D-26,  2.4950000D-26,
     &  2.4900000D-26,  2.4800000D-26,  2.4599999D-26,  2.4500001D-26,
     &  2.4300000D-26,  2.4200000D-26,  2.4100000D-26,  2.3949999D-26,
     &  2.3800001D-26,  2.3700001D-26,  2.3600000D-26,  2.3400000D-26,
     &  2.3299999D-26,  2.3199999D-26,  2.3000001D-26,  2.2900000D-26,
     &  2.2800000D-26,  2.2599999D-26,  2.2499999D-26,  2.2300001D-26,
     &  2.2100000D-26,  2.1999999D-26,  2.1799999D-26,  2.1600001D-26,
     &  2.1500000D-26,  2.1299999D-26,  2.1199999D-26,  2.1000001D-26,
     &  2.0800000D-26,  2.0599999D-26,  2.0399998D-26,  2.0200001D-26,
     &  2.0100000D-26,  1.9950000D-26,  1.9799999D-26,  1.9600001D-26,
     &  1.9400000D-26,  1.9300000D-26,  1.9099999D-26,  1.9000001D-26,
     &  1.8800001D-26,  1.8600000D-26,  1.8399999D-26,  1.8200001D-26,
     &  1.8000000D-26,  1.7799999D-26,  1.7600001D-26,  1.7500001D-26,
     &  1.7300000D-26,  1.7099999D-26,  1.6949999D-26,  1.6700000D-26,
     &  1.6500000D-26,  1.6399999D-26,  1.6200001D-26,  1.5950000D-26,
     &  1.5699999D-26,  1.5500001D-26,  1.5400001D-26,  1.5200000D-26,
     &  1.4999999D-26,  1.4800001D-26,  1.4399999D-26,  1.4199999D-26,
     &  1.4000001D-26,  1.3800000D-26,  1.3599999D-26,  1.3400001D-26,
     &  1.3200000D-26,  1.3050000D-26,  1.2899999D-26,  1.2700001D-26,
     &  1.2500000D-26,  1.2249999D-26,  1.2000001D-26,  1.1800000D-26,
     &  1.1599999D-26,  1.1499999D-26,  1.1250001D-26,  1.1050000D-26,
     &  1.0799999D-26,  1.0700001D-26,  1.0500001D-26,  1.0300000D-26,
     &  1.0099999D-26,  9.9000010D-27,  9.7000001D-27/

!*-----------------------------------------------------------------------

      end block data
