!              constants thru Cosmos
            real*8 pi,          !  3.14..
     *             sqrtpi,      !  sqrt(pi)
     *             Torad,       !  if multiplied to deg  --> radian
     *             Todeg,       !  1/Torad
     *             c,           !  light velocity m/sec
     *             Infty,       !  infinty
     *             Togpcm2,     !  kg/m2 *Togpcm2 --> g/cm2
     *             Tokgpm2,     !  g/cm2 *Tokgpm2    --> kg/m2
     *             Tom,         !  cm *Tom  --> m
     *             Tocm,        !  m*Tocm  --> cm
     *             Tokgpm3,     !  g/cm3 * Tokgpm3 -->  kg/m3
     *             Togpcm3,     !  kg/m3 * Togpcm3 --> g/cm3
     *	           Tonsec,      !  sec *Tonsec --> nsec 
     *             Bcr,         !  Tesla. m^2c^3/eh = 4.414x10^13G=4. x10^9
     *             SyncConvR    !  alpha(mc^2/Lc). GeV/m. conv. rate of synch.r
       real*8 Avogn,            ! Avogadro #. /mol
     *        A2deninv          ! mfp * n* xs = 1;  mfp in kg/m2
                                ! xs in mb.  1/n = A2deninv*A  


        parameter(pi = 3.141592653589793238d0, 
     *    sqrtpi = 1.772453850905516d0, Torad = pi/180.d0, 
     *    Todeg = 180.d0/pi, c=2.998d8, Infty=1.d50, Tom = 1.d-2,
     *    Tocm = 1.d0/Tom,
     *    Togpcm2 = 0.1d0, Tokgpm2 = 1.d0/Togpcm2,
     *	  Tokgpm3 = Tokgpm2/Tom, Togpcm3 = 1.d0/Tokgpm3,
     *    Tonsec = 1.d9, Bcr = 4.414d9, SyncConvR=9.657d6)
       parameter (Avogn=6.0221415d23, A2deninv = 1.d28/Avogn)




  

!  #ifndef Zcoord_
!  #define Zcoord_



!#    for gfortran  must be disabled.  





!        sys="xyz":  origin is center of the Earth.
!              x:  directed to longitude 0, latitude 0
!              y:  directed to longitude 90 deg, latitude 0
!              z:  center to the North pole
!  ****************************************************************
!  *       During the paticle tracking, this system is used.      *
!  ****************************************************************
!


!
      type coord
        sequence




                  real*8 r(3)

          character*4 sys  ! which system. 'xyz', 'llh', 'sph'
      end type coord
!  #endif 

! #ifndef  Zmagfield_
! #define  Zmagfield_



!#    for gfortran  must be disabled.  





!
       type magfield
         sequence
!          Note that position vector where the magnetic field is given
!          is not included here.
!          unit of field strength is  in T (1 gauss = 10**-4 T)




                  real*8 x,       ! in earth_center coordinate
     *                   y,       !
     *                   z        !


!  
          character*4 sys  ! which system. 'xyz',  'ned',  'hva'
        end type magfield
!  #endif  

!         earth defining parameter
       real*8 Eradius,     !  radius in m
     *        Eecen2,      !  squared of the ecentricity 
     *        Eone_ecen2,  !  1 - ecen2
     *        Maxheight,   !  max height with some air. m
     *        Minheight    !  min height without soil. m   

!
       parameter (Eradius = 6378136.0d0, Eecen2= 0.006694470d0,
     *       Eone_ecen2 = 1.d0 - Eecen2, Maxheight=220.d3, 
     *       Minheight = -500.d0)

      real*8 yearin, lat, long, height
      type(coord):: llh
      type(magfield):: h
      integer icon
                                  
      character*100 filepath
      filepath='../../../Data/Geomag/igrf'


      yearin= 2005.0
      write(*,*)  'y=',yearin
      write(*,*)  ' Change above values, if want or enter /'
      read(*,*)  yearin

      call  crdGeomag(filepath, yearin)

      lat = 30.d0
      long = 140.d0
      height = 0.d0

      do while (.true.)
         write(*,*) ' lat=',lat, ' long=',long, ' h=', height
         write(*,*)  ' Change above values, if want  or "99 /" to stop'
         read(*,*)  lat, long, height
         if( lat > 90. ) stop

         call csetCoord('llh', lat, long, height, llh)
         call cgeomag(yearin, llh, h,  icon)

         write(*,*)  ' icon=',icon, ' h%x,y,z=',h%x, h%y, h%z
         write(*,*)  ' |B|=',sqrt(h%x**2 + h%y**2 + h%z**2)
      enddo

      end

