      module modqgsjet2  ! instead of using common or entry
                        ! inside this interface routines

      implicit none
      real(8),save::  ke0n
      integer,save::  kicz 
      integer,save::  kiap 
      integer,save::   kicp 
      integer,save::   kiat
      integer,save:: check=0
      end module  modqgsjet2 

      subroutine cQGSjet(pj, iat, iz,  a, ntp)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"
! ------------------------
      type(ptcl)::pj  ! input .projectile
      integer iat  !  input target mass number
      integer iz     ! input. charge no. of target
      integer ntp    ! output.produced ptcls number
      type(ptcl):: a(*)  ! produced ptlcs' a(ntp)
      type(ptcl):: ldcy(2)
      real*8 xs
      integer ngen, i, ngen2
!   if  next is 1:  at collision point forced decay and decay prod
!                   is made to collide
!               2:  collision is manage by dpmjet3
!               3:  collision is replaced by proton. 
#define  LAMBDA 3
      if(pj%code .eq. klambda) then
#if  LAMBDA == 1 
!         make it decay here and make the product interact here
         call clambdaDcy(pj,  ldcy, ngen)
         ntp = 0
         do i = 1, ngen
!                  next is not to get xs but setup condition
!                 for QGS internally; pi0 can be managed well
            call cxsecQGS( ldcy(i), iat,   xs )
            call cQGSjet0( ldcy(i), iat, iz, a(ntp+1), ngen2)
            ntp = ntp + ngen2
         enddo
#endif
#if  LAMBDA == 2
!              qgsjet cannot treat it though it is generated by qgsjet2
!         so we employ dpmjet3
         call cdpmjet(pj, iat, iz,  a, ntp)
#endif
#if  LAMBDA == 3
!           regard it as neutron
      call cmkptc(knuc, -1, 0, pj)
      call cadjm(pj, pj)
      call cxsecQGS( pj, iat,   xs )
      call cQGSjet0( pj, iat, iz, a, ntp)
#endif

      elseif( pj%code .eq. ksigma .or. pj%code .eq. kgzai
     * .or. pj%code .eq. kbomega) then
!        althogh qgsjet dose not generate sigma and gzai, bomega
!        klambda treatment above generates these; 
!          eventuall they will be treated by ad-hoc.
!          bomega is very rare 1 or 2 during one 10^20 eV proton event
         call cdpmjet(pj, iat, iz,  a, ntp)
      elseif( pj%code .eq. keta) then
!          same as above; but use ad-hoc
!                  at Ultra H.E, eta may collide.
         call chAcolAdhoc(pj, iat, iz, a, ntp)
      else
!          intrinsic qgsjet2
         call cQGSjet0(pj, iat, iz, a, ntp)
      endif
      end

      subroutine ciniQGS
      implicit none
#include "Zmanagerp.h"
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"
!  #include "Zair.h"
!           dummy ptcl and target for init
      type(ptcl)::pj  !  dummy projectile
      integer ia  !  target mass number
      integer iz     ! charge no. of target
      integer ntp    ! output.produced ptcls number
      type(ptcl):: a(100)  ! produced ptlcs' a(ntp)


!      integer debug        
!      common /debug/   debug !-04  /qgdebug/.  default is 
                        ! so don't touch it
      integer moniou
      common /qgarr43/ moniou

      logical,save::  first=.true.

      integer iseq, j


      real*8 u, xs
!//////////// file management for qgsjetII-04
      common/producetab/ producetables !used to link with CRMC
      logical producetables
      character*500 fnIIdat,fnIIncs !used to link with nexus ?
      integer ifIIdat, ifIIncs
      common/qgsIIfname/fnIIdat, fnIIncs, ifIIdat, ifIIncs 
!////////////////
      character*(132):: cosmostop
      integer:: leng, kgetenv2

      if( first ) then
         call qgset     !set model parameters (moniou is 6)
         moniou = 0     ! reset moniou(=errout) to 0 
         producetables = .false.  ! x sec. table exists so read it 

         ifIIdat = 0     ! read qgsdat-II-04 from logical dev # 1
         ifIIncs = 0     ! read ectnu-II-04 from # 2
         leng = kgetenv2("COSMOSTOP", cosmostop)
         if( leng == 0 ) then
            write(0,*)
     *      ' Env. Variable  COSMOSTOP is enmpty'
            stop
         endif
!           they are assumed to be in  the following dir.
         cosmostop=trim(cosmostop)//"/Import/QGS/"
         call qgaini(cosmostop)   !initialize QGSJET-II 

!             dummy collision for init. without this,
!          first event will be biased. (why?)
         call cmkptc(knuc, -1, 1, pj)
         pj%fm%p(1)=0.
         pj%fm%p(2)=0.
         pj%fm%p(3)=100.
         pj%fm%p(4)=sqrt(pj%fm%p(3)**2 + pj%mass**2)
!         ia = TargetMassN
!         iz = TargetAtomicN
         ia = 4
         iz = 2
         call cxsecQGS(pj, ia, xs)
         call cQGSjet0( pj, ia, iz, a, ntp)
         if(ntp .gt. 100) then
            write(0,*) ' too many ptcls at init of qgs2'
            stop
         endif
         first = .false.
      endif
      end

      subroutine cxsecQGS( pj, iat,   xs )
      use modqgsjet2
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"

!      real*8  ep, ebal
!    ****************** important *****
!    if you increase iapmax, changes are also needed in qgsjet and
!    207 in Epics/prog/epixsec.f 
!      parameter(iapmax=209,nptmax=50000) ! -03

      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
!     !      parameter(iapmax=209,nptmax=95000)  !!!!!!/// -04
      parameter(iapmax=208,nptmax=95000) !!!!!!/// -04
!      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.

      type(ptcl)::pj  ! input .projectile
      integer,intent(in):: iat  !  target mass number

      real(8),intent(out):: xs  !  xsection in mb  



      real*8  qgsect  

      if( pj%code .ne. kgnuc ) then
         kiap = 1     !set proj. mass number (1-for hadron)
      else
         kiap = pj%subcode
      endif
      call ccoscode2QGS( pj, kicp )
      if(kicp .eq. 0) then
         xs = 1.d-30
      else
         ke0n = pj%fm%p(4)/kiap !to get energy per nucleon
         kiat = iat

         kicz=iabs(kicp)/2+1    !primary particle class (1- pion, 2 - nucleon, 3 - kaon)
         xs=qgsect(ke0n,kicz,kiap,kiat) !get particle production cross sectio
      endif
      check= 1
      end
!     *********************************
      subroutine cqQGSint( e0n, icz, iap, icp, iat )
!        inquire current interacion conditions
!     *********************************
      use modqgsjet2
      implicit none
      real(8),intent(out):: e0n !  E0/N (for Nuc) or E0 (for had)
      integer,intent(out):: icz ! 1ry class
      integer,intent(out):: iap ! projectile mass number. (1 for had)
      integer,intent(out):: icp ! projectile QGS code  (2 for heavy)
      integer,intent(out):: iat ! target mass number

!  
      e0n = ke0n
      icz = kicz
      iap = kiap
      icp = kicp
      iat = kiat
      end      subroutine cqQGSint
!     ***********************************
      subroutine  cQGSjet0(pj, iat, iz,  a, ntp)
      use modqgsjet2
!     ***********************************
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      type(ptcl)::pj  ! input .projectile
      integer,intent(in):: iat  ! target mass number
      integer,intent(in):: iz   !  charge no. of target
      type(ptcl):: a(*)  ! produced ptlcs' a(ntp)
      integer,intent(out)::ntp    !  produced ptcls number
! ------------------------
      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
!     !      parameter(iapmax=209,nptmax=95000)  !!!!!!/// -04
       parameter(iapmax=208,nptmax=95000)  !!!!!!/// -04
!      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.



      integer::ic
      integer:: isf, i, is
      integer zfrag, mfrag


!      ebal(1)=e0n*iap+.939d0*iat           
!      ebal(2)=dsqrt(e0n**2-.939d0**2)*iap
!      ebal(3)=0.d0
!      ebal(4)=0.d0
!      aknn=0.d0
!      ach=0.d0

!           check below will not be 0 but 1,   if projectile Xsection 
!           is calculable by cxsecQGS.  0 means special case 
!           where particles generated by qgsjet2 cannout use cxsecQGS
!           and qgsjet2 cannot be used for particle generation by
!           such a partilce
      if(check .eq. 0) then
!          now   should not come here
         write(0,*) ' check=0 in  qgsjet interface'
         write(0,*) ' pj=',pj%code,pj%subcode,pj%charge,pj%fm%p(4)
         stop
!         if(pj%code .eq. klambda) then
!            call chAcolAdhoc(pj, iat, iz, a, ntp)
!         elseif(pj%code .eq. keta) then
!                  at Ultra H.E, eta may collide.
!            call chAcolAdhoc(pj, iat, iz, a, ntp)
!         else           
!            write(0,*) ' check=0 in  qgsjet interface'
!            write(0,*) ' pj=',pj%code,pj%subcode,pj%charge,pj%fm%p(4)
!         endif
      endif
      if(check .eq. 1) then
         kiat = iat             ! may not be the same as iat from cxsecqgs

         call qgini( ke0n, kicp, kiap, iat) !initialize current interaction
         call qgconf            !inelastic interaction
!           next is projectile fragments
         ntp = 0
         do isf = 1, nsf        !loop over produced fragments
            mfrag = iaf(isf)    !fragment mass number
!!            zfrag = pj%charge*mfrag/kiap ! fragment charge
!!           by this, He --> charge 1 so updated
!!            2013/Apr/25
            call csetFragChg(kiap,  mfrag,  zfrag)  
            ntp = ntp + 1
!                set this heavy in a
            if( mfrag == 1 ) then
               call cmkptc( knuc, regptcl, zfrag, a(ntp) )
            else
               call cmkptc(kgnuc, mfrag, zfrag, a(ntp))
            endif
            a(ntp)%fm%p(4) = ke0n*mfrag
         enddo
!          set fragment Pt
         call csampFragMom( a, ntp )
         do  is = 1, nsp        !loop over produced particles
            ntp = ntp + 1
            ic=ich(is)    
            call cQGScode2cos(ic, a(ntp))
            do i=1,4
               a(ntp)%fm%p(5-i)=esp(i,is) !particle 4-vector
            enddo 
         enddo
         check = 0
      endif
         
!     -------------- rotate so that we get the same coordinate as pj
       call crot3mom( pj, a, ntp ) 
       if( pj%code .eq. kpion .and. pj%charge .eq. 0) then
!            pi0 is projectile.  we have been using pi+/- as
!            projectile so we wil replace the leading particle by pi+/pi-
!            kicp =1 is pi+/ kicp=-1 is pi- so we regard it as charge of pi
          call cfindHighestPi( kicp, a, ntp, i )
          if(i .gt.  0) then
             call cmkptc( kpion, 0, 0, a(i) )
          endif
       endif
      end


      subroutine ccoscode2QGS(pj, icp)
#include "Zptcl.h"
#include "Zcode.h"
      type(ptcl):: pj  ! input. cosmos ptcl 
      integer icp       ! output. code for qgsjet

      real*8 u
      character*80 msg

      if(pj%code  .eq. kpion) then
         if(pj%charge .eq.  -1) then
            icp = -1
         elseif( pj%charge .eq. 1) then
            icp = 1
         else
!            pi0, first assign it to pi+ pr pi- and later replace the leading ptcl
!            by pi0
            call rndc(u) 
            if(u .lt. 0.5) then
               icp =1
            else
               icp =-1
            endif
         endif
      elseif(pj%code .eq.  knuc ) then
         if(pj%charge .eq. 1 ) then
            icp = 2
         elseif( pj%charge .eq. -1) then
            icp = -2
         else
            if(pj%subcode .eq. antip ) then
               icp = -3
            else
               icp = 3
            endif
         endif
      elseif(pj%code .eq. kkaon) then
         if(pj%charge .eq. 1) then
            icp = 4
         elseif( pj%charge .eq. -1) then
            icp = -4
         else
            if(pj%subcode .eq. antip) then
               icp = -5
            else
               icp = 5
            endif
         endif
      elseif( pj%code .eq. kgnuc ) then
         icp = 2
      elseif( pj%code .eq. kdmes ) then
         icp = 0
      else 
         write(msg,
     *   '("ptcl code=",i3," charge=",i3,"not supported in QGSII")') 
     *    pj%code, pj%charge
         call cerrorMsg(msg, 0)
      endif
!        set proj. type (-1 - pi^-, 1 - pi+,
!       -2 - p~, 2 - p, -3 - n~, 3 - n, -4 - k^-, 4 - k+, -5 - k0~, 5 - k0)
      end
      subroutine cQGScode2cos(icp, pj)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
      integer icp    ! input qgs code
      type(ptcl):: pj  ! output.  cosmos ptcl to get code

      integer  code, subcode, charge 

      character*80 msg

      if(icp .eq. -1) then
         code = kpion
          charge = -1
      elseif(icp .eq. 1) then
         code = kpion
         charge = 1
      elseif(icp .eq. 0 ) then
         code = kpion
         charge = 0
      elseif(icp .eq.  2 ) then
         code = knuc
         charge = 1
      elseif(icp .eq. -2) then
         code = knuc
         charge = -1
      elseif(icp .eq. 3) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(icp .eq. -3) then
         code = knuc
         charge = 0
         subcode = antip
      elseif( icp .eq. 4 ) then
         code = kkaon
         charge = 1
      elseif( icp .eq. -4) then
         code  = kkaon
         charge = -1
      elseif( icp .eq. 5 )  then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif( icp .eq. -5) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif( icp .eq.  -6) then
         code = klambda
         subcode = antip
         charge = 0
      elseif( icp .eq. 6 ) then
         code = klambda
         subcode = regptcl
         charge = 0
      elseif( abs(icp) .eq. 10 ) then
         code = keta
         subcode = 0
         charge = 0
      else
         write(msg,
     *   '("ptcl code from QGSII =",i3," is unknown")') 
     *    icp
         call cerrorMsg(msg, 0)
      endif
!          ((0 - pi0, -1 - pi^-, 1 - pi+,-2 - p~, 2 - p, -3 - n~, 3 - n,
!         -4 - k^-, 4 - k+, -5 - k0l, 5 - k0s, 6 - eta, -10 - lambda~, 10 - lambda)
      call cmkptc(code, subcode, charge, pj)
      end   subroutine cQGScode2cos

      subroutine cfindHighestPi(chg, a, ntp, n)
!           find highest enrgy Pi+ (if chg =1)  of  Pi- (if chg=-1)
!     and return its index n
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      integer chg  !  input   incident is +  / or -
      integer ntp  ! input  total number of ptcls
      type(ptcl):: a(ntp)  ! input
      integer n   ! output  n-th ptcl is highest energy if 0, no ptcl

      integer i
      real*8 erg

      n = 0
      erg = 0.
      do i = 1, ntp
         if( a(i)%code .eq. kpion ) then
            if( a(i)%charge .eq. chg ) then
               if( erg .lt. a(i)%fm%p(4) ) then
                  erg = a(i)%fm%p(4)
                  n = i
               endif
            endif
         endif
      enddo
      end
!         -04 does not supply random # generator
!       
      function  qgran(X) result(ans)
      real(8),intent(in):: X                 !  not used

      real(8):: u
      real(8):: ans
      call rndc(u)
      ans= u
      end

      subroutine cqgsFragChg(ia, iz, fm, fc)
!      fix   projectile fragment charge
      implicit none
      integer,intent(in):: ia  ! heavy proj. mass #
      integer,intent(in):: iz  ! heavy proj. charge
      integer,intent(in):: fm !  fragment mass #
      integer,intent(out):: fc !  fragment charge

      real(8):: pprob, u

      if( fm  == 1 ) then
         if( ia > 29 ) then
            pprob = 0.4         ! proton prob.
         else
            pprob = 0.5
         endif
         call rndc(u)
         if(u < pprob ) then
            fc = 1
         else
            fc = 0
         endif
      elseif( fm == 2 ) then
         fc = 1
      elseif( fm <= 4 ) then
         fc = 2
      elseif( fm < 29 ) then
         if( fm == 27) then
            fc = 13
         elseif( fm == 19 ) then
            fc = 9
         else
            fc = fm*0.5
         endif
      else
         if( fm == 56 ) then
            fc = 26
         elseif( fm == 40 ) then
            fc = 18
         elseif( fm == 48 )  then
            fc = 22
         elseif( fm < 70 ) then
            fc = fm*0.47
         else 
            fc =fm*0.4
         endif
      endif
      end   subroutine cqgsFragChg


      
      
      
