       subroutine cinteElec
       implicit none
!----       include 'Ztrack.h'
#include  "Ztrack.h"
!----       include 'Ztrackv.h'
#include  "Ztrackv.h"
         character*70 msg
!
         if(IntInfArray(ProcessNo)%process .eq. 'brems') then
            call  cbrems
         elseif(IntInfArray(ProcessNo)%process .eq. 'mscat') then
            call cknockon(-1)
         elseif(IntInfArray(ProcessNo)%process .eq. 'bscat') then
            call cknockon(1)
         elseif(IntInfArray(ProcessNo)%process .eq. 'anihi') then
            call canihi
         elseif(IntInfArray(ProcessNo)%process .eq. 'mbrem') then
            call cmbrem
         else

              write(msg, *) ' process#=', ProcessNo,
     *       'and process for electron=',
     *        IntInfArray(ProcessNo)%process, ' undef'
              call cerrorMsg(msg, 0)
         endif
         end
!
!         Pwork assumes that higher energy particles are normally
!         in the last part, and stacked later from the last to
!         save the stack area.  Due to this fact, putting ptlcs
!         in Pwork must be reversed (realized from v6.10)
!        *****************
         subroutine cbrems
!        *****************
         use modBremPairAng
         implicit none

#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"


         real*8 beg, den, cvh2den
         real*8 theta, sint, cost, sn, cs
         type(coord)::dc1
         type(coord)::w
         type(track)::aTrack

!           get brem gamma energy
         if(LpmEffect .and. 
     *        TrackBefMove%p%fm%p(4) .gt. LpmBremEmin) then ! use BefMove%p
!            den = cthick2den(TrackBefMove.pos.depth)
            den = cvh2den(TrackBefMove%pos%height)  ! this should be better
            call cbremErgLPM(TrackBefMove%p%fm%p(4), den, beg)
         else
            call cbremsEnergy(MovedTrack%p%fm%p(4), beg)
         endif

         aTrack = MovedTrack

!         
         aTrack%p%fm%p(4) = MovedTrack%p%fm%p(4) -beg
         call ce2p(aTrack)
!
!         see           !! note above
         Pwork(Nproduced+2) = aTrack%p


          aTrack%p%fm%p(4) = beg
          call cmkptc(kphoton,  kcasg, 0,  aTrack%p)
!           brems angle at low energy
         if(  TrackBefMove%p%fm%p(4)  .lt. 10. ) then
!             call cBremAng( TrackBefMove.p.fm.p(4), TrackBefMove.p.mass, 
!     *       beg, TargetAtomicN, theta)
             ! v7.646
            call cBremAng(1, TrackBefMove%p%fm%p(4), beg, theta)
            if(theta .lt. 0.03d0) then
               sint = theta
               cost = 1.- theta**2 / 2
            else
                sint = sin(theta)
                cost = cos(theta)
             endif
             call kcossn(cs,sn)
             w%r(1) = cs*sint
             w%r(2) = sn*sint
             w%r(3) = cost
             call ctransVectZ(MovedTrack%vec%w, w, dc1)
             call csetDirCos(dc1, aTrack)
          endif
          call ce2p(aTrack)
          Pwork(Nproduced+1) = aTrack%p
          Nproduced = Nproduced + 2
         end
!      *****************
       subroutine cknockon(cg)
!      *****************  moller and bhabha scattering
       implicit none
!----       include '../Particle/Zcode.h'
#include  "Zcode.h"
!----       include 'Ztrack.h'
#include  "Ztrack.h"
!----       include 'Ztrackv.h'
#include  "Ztrackv.h"
#include  "Zelemagp.h"
!     
       integer cg
       real*8 e1, er, tmp, cos1, cosr, sine, cs, sn, sinr
       type(coord)::dc
       type(coord)::dc1
       type(coord)::dcr
!
       type(track)::aTrack
!
       if(cg .eq. -1) then
          call cmollerea(MovedTrack%p%fm%p(4), RecoilKineMinE,
     *                   e1, er, cos1, cosr)
       else
          call cbhabhaea(MovedTrack%p%fm%p(4), RecoilKineMinE,
     *    e1, er, cos1, cosr)
       endif

       tmp=1.d0-cos1*cos1
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cos1=1.d0
       endif
       sine=sqrt(tmp)
       call kcossn(cs,sn)
       dc%r(1) = cs*sine
       dc%r(2) = sn*sine
       dc%r(3) = cos1
!           convert angle
       call ctransVectZ(MovedTrack%vec%w, dc, dc1)
       aTrack = MovedTrack
       aTrack%p%fm%p(4) = e1
       call csetDirCos(dc1, aTrack)
       call ce2p(aTrack)

       Pwork(Nproduced + 2) = aTrack%p
!            knock on electron
       tmp=1.d0-cosr*cosr
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cosr=1.d0
       endif
       sinr=sqrt(tmp)
       dc%r(1) = -cs*sinr
       dc%r(2) = -sn*sinr
       dc%r(3) = cosr
       call ctransVectZ(MovedTrack%vec%w, dc, dcr)
       aTrack%p%fm%p(4) = er
       call csetDirCos(dcr, aTrack)
!
       if(cg .eq. 1) then
          call cmkptc(kelec,  0,  -1,  aTrack%p)
       endif

       call ce2p(aTrack)

       Pwork(Nproduced + 1) = aTrack%p

       Nproduced = Nproduced + 2
      end
!     *****************
      subroutine canihi
!     *****************
       implicit none
!----       include '../Particle/Zcode.h'
#include  "Zcode.h"
!----       include 'Ztrack.h'
#include  "Ztrack.h"
!----       include 'Ztrackv.h'
#include  "Ztrackv.h"

       real*8 e1, er, cos1, cosr, tmp, sine
       real*8 cs, sn, sinr
       type(track)::aTrack
       type(coord)::dc
       type(coord)::dc1
       type(coord)::dcr
!
       call canihiea(MovedTrack%p%fm%p(4), e1, er, cos1, cosr)
!               
       tmp=1.d0-cos1*cos1
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cos1=-1.d0
       endif
       sine=sqrt(tmp)
       call kcossn(cs,sn)
       dc%r(1) = cs*sine
       dc%r(2) = sn*sine
       dc%r(3) = cos1
!             
       call ctransVectZ(MovedTrack%vec%w, dc, dc1)
!            higher gamma
       aTrack = MovedTrack
       call csetDirCos(dc1, aTrack)
       call cmkptc(kphoton, kcasg, 0,  aTrack%p)
       aTrack%p%fm%p(4) = e1
       call ce2p(aTrack)


       Nproduced = Nproduced + 1
       Pwork(Nproduced) = aTrack%p
!       call cpush(aTrack)
!                low gamma
       tmp=1.d0-cosr*cosr
       if(tmp .lt. 0.d0) then
          tmp=0.d0
          cosr=-1.d0
       endif
       sinr=sqrt(tmp)
       dc%r(1) = -cs*sinr
       dc%r(2) = -sn*sinr
       dc%r(3) = cosr
       call ctransVectZ(MovedTrack%vec%w, dc, dcr)
       call csetDirCos(dcr, aTrack)
       aTrack%p%fm%p(4) = er
       call ce2p(aTrack)


       Nproduced = Nproduced + 1
       Pwork(Nproduced) = aTrack%p
!       call cpush(aTrack)
       end

!        *****************
         subroutine cmbrem
!          magnetic brems
!        *****************
         implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

         real*8 x, beg

         type(track)::aTrack

!           get brem gamma energy
         call cmBremE(Upsilon, x) 
         beg = x * MovedTrack%p%fm%p(4)  ! gamma energy

         aTrack = MovedTrack
         aTrack%p%fm%p(4) = MovedTrack%p%fm%p(4) -beg
         call ce2p(aTrack)
         Pwork( Nproduced + 2 ) = aTrack%p   
!           stack gamma (probably lower energy than e)
         aTrack%p%fm%p(4) = beg
         call cmkptc(kphoton,  kcasg, 0,  aTrack%p)
         call ce2p(aTrack)
         Pwork(Nproduced + 1) = aTrack%p

         Nproduced = Nproduced + 2         
         end


