!       cgetBsin. 
!       get  |p x  B|/p = B x sin
!
      real*8  function cgetBsin(aPtcl, mag)
      implicit none
#include "Zglobalc.h"
#include "Zptcl.h"
#include "Zcoord.h"
#include "Zmagfield.h"

      type(ptcl):: aPtcl    ! input. electron or gamma 
      type(magfield):: mag  ! magnetic field.

      type(coord):: p, b, pb      ! pb is  P x B
      real*8 pbsin, pabs
      integer i
!           for safety
      do i = 1, 3
	      p%r(i) = aPtcl%fm%p(i)
      enddo

      b%r(1) = mag%x
      b%r(2) = mag%y
      b%r(3) = mag%z

      call cvecProd(p, b, pb)
!        get pbsin
      pbsin = sqrt( pb%r(1)**2 + pb%r(2)**2 + pb%r(3)**2 )
!
      call cpxyzp(aPtcl%fm, pabs)

      cgetBsin = pbsin/pabs
      end
