      subroutine cMCSconstForMedia(md, pm, aMCS)
!      for this media, sampling table is read and 
!      stored in aMCS.
!      It is assumed that pm = -1 comes first for a given md
!      and next call is for pm=1. So the file opened for
!      pm=-1 is kept open for pm=1. After it is read for
!      pm=1, the file will be closed.
      use modXSecMedia
      use modMCS
      implicit none
#include "Zmanager.h"
#include "Zmanagerp.h"
      !  CosOrEpi is used from above
      type(xsmedia),intent(in):: md  ! media 
      integer,intent(in):: pm   ! >0 for e+, < 0 for e-
      type(MCSconst),intent(out):: aMCS

      integer::icon, ie

      if( CosOrEpi == "epics") then
!          filename is declared in modTPXS
         filename="$EPICSTOP/Data/MCS/"//trim(md%name)
      else
         filename="$COSMOSTOP/Data/MCS/"//trim(md%name)
      endif
      if( pm == -1 ) then
         call copenf(TempDev, filename, icon)
         if( icon /= 0 ) then
            write(0,*) trim(filename), ' cannot be opened for MCS'
            if( CosOrEpi == "epics") then
               write(0,*)
     *         'If  media name :',trim(md%name), ' is valid one'
               write(0,*)
     *         'Probably you have to do a simple job as follows'
               write(0,*) 
     *         ' 1 goto $EPICSTOP/Util/Elemag/MixedMCS'
               write(0,*)
     *         ' 2 do ./ForManyMedia%sh $EPICSTOP/Data/MCS ',
     *           trim(md%name)
            endif
            stop
         endif
         read(TempDev, *)  ! skip 1 line  which is  C1forHardScat
         call creadMCSTab(TempDev, aMCS)
         read(TempDev, *)  
      elseif(pm == 1 ) then
         call creadMCSTab(TempDev, aMCS)
         close(TempDeV)
      else
         write(0,*)' pm =',pm, ' invalid for  cMCSconstForMedia'
         stop
      endif

      aMCS%loglambdah(:) =log( aMCS%lambdah(:) )

      ie = aMCS%minNon0mucEindex  ! for ie, 0 is stored
      aMCS%loglambdas1(ie:) =log( aMCS%lambdas1(ie:) )
      aMCS%loglambdas2(ie:) =log( aMCS%lambdas2(ie:) )
      aMCS%logmuc(ie:) =log( aMCS%muc(ie:) )

      end  subroutine cMCSconstForMedia
