module modMCSparam
  implicit none
!     multi scattering model
  character(100),save::MCSmodel='"Mol"'
!  other example
!  character(100),save::MCSmodel='"El_hin",10.0d-3,"El_con",100.0d-3, "Mol"'
end module modMCSparam

module modMCScontrol
  use modMCSparam, MCS=>MCSmodel
  implicit none
                !     max list.    Now 3 models
  integer,parameter::MaxHowMCS=6, NoOfUsableMCS=3
  real(8),parameter::MinErgMCS=100.0d-9  ! GeV ->100eV
  real(8),parameter::MaxErgMCS=1.0d0     ! GeV.  > this Moliere
                                   ! is referred.
  character(len=8),save::HowMCSList(MaxHowMCS)=' '
  real(8),save::MCSErg(MaxHowMCS)=1.d0
  integer,save:: NoOfHowMCS   ! # of actually specified List
  character(len=8),parameter::UsableMCS(NoOfUsableMCS)=  &
    (/"El_hin  ", "El_con  ", "Mol     "/)  !  embed " " gfortr

  real(8),save:: KEGeV, KEeV, mfpHardgr, lHardrl, lHardcm, lHardgr
  real(8),save:: tMCScm, pathScm
  logical,save:: doNewMCS   ! becomes F if always "Mol"
  character(len=4),save::MCSmode ! A1,A2,B1,B2,B3 used for El_hin 
  character(len=8),save::ActiveMCS  ! current MCS model; One of UsableMCS 
                !      length must be same as HowMCSList
end   module modMCScontrol

!    
subroutine cHowMCS
!
!      Establish how to treat Multiple Coulomb Scattering
!      below 1 GeV: any cobination of
!        El_hin, El_con, Mol  (hin means hinge, con means condense
!        Mol means to use old Moliere parameter).
!      is permitted. Format: E.g
!
!      MCS=' "El_hin" 1e-3 "El_con" 100e-3 "Mol"'
!  
!        100eV ~ 1MeV:  El_hinge 
!            ~ 100MeV:  El_condense
!            >       :  Mol (parameter Moliere is referred)
!      MCS='"Mol"'
!                 In the entire region, Moliere is referred.
!      
!      MCS=' "El_con" 10e-6 "El_hin" 100e-6 "El_con" '
!        100 eV ~ 10 keV: El_condense 
!               ~ 10MeV:  El_hinge
!               ~ 1GeV:   El_condense 
!               >         Mol
!  
!     This may used for test. If the result shows
!   almost the same as
!      MCS='"Mol"' or MCS='"El_hin"'
!   you may employ latter, since cpu time is much shorter.
!   (In stead of "El_con", "Mol" may be used in the last example).
!
!   The minimum energy used in Epics is normally 10keV to 100 keV
!   but, in the case of e+, it must be followed down to 0 energy
!   since it annihilates to produce 2Me absorbable energy.
!   In normal situations, it anhihilates before it's energy becomes
!   lower than 10 keV or so. However, sometimes we encounter
!   very low energy e+ of which energy is even below 100 eV.
!   Epics assumes thick  detectors and, treatment of
!   e-/e+ below *10 keV need not be so accurate because they
!   stop soon. So any Mol treatment is ok for them where no
!   data is available from  Elsepa.
! 
  use modMCScontrol
  implicit none

  integer i, j, l    

  l=len(MCS)
  MCS(l:l) = '/'

  read(MCS, *, Err=100) &
       (HowMCSList(i), MCSErg(i), i=1, MaxHowMCS)

  NoOfHowMCS = MaxHowMCS
  do i = 1, MaxHowMCS
     if(HowMCSList(i) .eq. ' ') then
        NoOfHowMCS = i-1
        exit
     endif
  enddo


  do i = 1, NoOfHowMCS-1
     if(MCSErg(i) >= MCSErg(i+1)) then !
!                 energy region invalid
        write(0,*)'MCSmodle is invalid; energy not ascending'
        write(0,*)' MCSmodel=', MCS
        stop
     endif
  enddo
!         exam models
  do i = 1, NoOfHowMCS
     do j = 1, NoOfUsableMCS
        if( HowMCSList(i) ==  UsableMCS(j) ) goto 25
     enddo
     call cerrorMsg( HowMCSList(i),  1)
     call cerrorMsg('above MCSmodel is not yet registered', 0)
25   continue
  enddo
!!!!!!!!!!
  write(0,*) 'MCS model @KE(GeV)<'
  do i = 1, NoOfHowMCS
     write(0,*) HowMCSList(i), MCSErg(i)
  enddo
!!!!!!!!!!
  return
100 continue
  write(0,*) ' MCSmodel=',MCS, ' is invalid'
  stop
end subroutine cHowMCS

subroutine ciniMCS
  use modMCScontrol
  implicit none
!    From Epics:
!        This must be called after config file has been read
!        and  cHowMCS has been called.  only once.
!    From Cosmos:  must be called after cHowMCS and cixsec 
!            has been read.
!
  
  integer::i
  doNeWMCS =.false.

  do i = 1, NoOfHowMCS
     if( index( HowMCSList(i), 'El_hin' )  > 0  .or.  &
         index( HowMCSList(i), 'El_con' )  > 0 ) then
        call ciniMixedMS
        doNewMCS =.true.
        exit
     endif
  enddo
!!!!!!!!!
  write(0,*) 'doNewMCS=',  doNewMCS
!!!!!!!!!
end subroutine ciniMCS

