************************************************************************
*                                                                      *
      block data shellef
*                                                                      *
*                                                                      *
*        Purpose:                                                      *
*                                                                      *
*              Shell effect data for Myer-Swaitecki fission barrier    *
*              calculation                                             *
*                                                                      *
*                                                                      *
************************************************************************

*-----------------------------------------------------------------------

      implicit double precision(a-h, o-z)

*-----------------------------------------------------------------------

      common /gemsh/ nsz(10000), nsa(10000), shin(10000)

*-----------------------------------------------------------------------
*     Shell effect data for Myer-Swaitecki fission barrier calculation
*-----------------------------------------------------------------------

      data (nsz(i),nsa(i),shin(i),i=   1,  30)/
     &  1,  2,  -6.56E+00,   1,  3,  -1.82E+00,   1,  4,  -4.00E-01,
     &  1,  5,   0.00E+00,   1,  6,   1.23E+00,   1,  7,  -8.80E-01,
     &  1,  8,  -1.32E+00,   1,  9,  -6.60E-01,   2,  3,  -2.04E+00,
     &  2,  4,  -1.51E+00,   2,  5,  -2.70E+00,   2,  6,  -6.30E-01,
     &  2,  7,  -3.07E+00,   2,  8,  -9.30E-01,   2,  9,  -1.33E+00,
     &  2, 10,  -7.20E-01,   2, 11,   1.50E+00,   2, 12,   1.61E+00,
     &  3,  4,  -4.00E-01,   3,  5,  -3.21E+00,   3,  6,   1.23E+00,
     &  3,  7,   2.70E+00,   3,  8,   1.73E+00,   3,  9,   1.40E-01,
     &  3, 10,  -8.00E-02,   3, 11,  -2.10E-01,   3, 12,   1.85E+00,
     &  3, 13,   1.94E+00,   3, 14,   1.98E+00,   3, 15,   1.19E+00/
      data (nsz(i),nsa(i),shin(i),i=  31,  60)/
     &  4,  5,   0.00E+00,   4,  6,  -1.78E+00,   4,  7,   2.26E+00,
     &  4,  8,   2.28E+00,   4,  9,   1.98E+00,   4, 10,   1.50E+00,
     &  4, 11,   1.01E+00,   4, 12,   1.91E+00,   4, 13,   2.37E+00,
     &  4, 14,   1.44E+00,   4, 15,   2.06E+00,   4, 16,   1.30E+00,
     &  4, 17,   1.47E+00,   4, 18,   3.00E-02,   5,  6,   1.23E+00,
     &  5,  7,   9.80E-01,   5,  8,   7.50E-01,   5,  9,   1.29E+00,
     &  5, 10,   3.55E+00,   5, 11,   1.92E+00,   5, 12,   1.88E+00,
     &  5, 13,   1.80E+00,   5, 14,   2.21E+00,   5, 15,   2.30E+00,
     &  5, 16,   2.23E+00,   5, 17,   2.20E+00,   5, 18,   2.01E+00,
     &  5, 19,   6.00E-01,   5, 20,   5.90E-01,   5, 21,   1.15E+00/
      data (nsz(i),nsa(i),shin(i),i=  61,  90)/
     &  6,  7,  -8.80E-01,   6,  8,  -9.30E-01,   6,  9,  -7.80E-01,
     &  6, 10,   7.20E-01,   6, 11,   1.73E+00,   6, 12,   5.60E-01,
     &  6, 13,  -4.80E-01,   6, 14,  -7.00E-01,   6, 15,   1.80E-01,
     &  6, 16,   1.65E+00,   6, 17,   1.29E+00,   6, 18,   1.01E+00,
     &  6, 19,  -1.00E-01,   6, 20,  -8.80E-01,   6, 21,  -2.43E+00,
     &  6, 22,   1.90E-01,   6, 23,   4.60E-01,   6, 24,   8.10E-01,
     &  7,  8,  -1.32E+00,   7,  9,  -1.33E+00,   7, 10,  -7.50E-01,
     &  7, 11,  -4.80E-01,   7, 12,   1.14E+00,   7, 13,  -8.40E-01,
     &  7, 14,  -3.80E-01,   7, 15,  -5.10E-01,   7, 16,   1.90E+00,
     &  7, 17,   2.43E+00,   7, 18,   2.56E+00,   7, 19,   1.70E+00/
      data (nsz(i),nsa(i),shin(i),i=  91, 120)/
     &  7, 20,   8.80E-01,   7, 21,  -7.90E-01,   7, 22,  -1.93E+00,
     &  7, 23,  -2.58E+00,   7, 24,  -2.19E+00,   7, 25,   5.50E-01,
     &  7, 26,   7.70E-01,   7, 27,   6.80E-01,   8, 11,  -2.10E-01,
     &  8, 12,   0.00E+00,   8, 13,   8.10E-01,   8, 14,  -1.21E+00,
     &  8, 15,  -7.20E-01,   8, 16,   5.00E-01,   8, 17,   1.87E+00,
     &  8, 18,   2.92E+00,   8, 19,   2.57E+00,   8, 20,   1.94E+00,
     &  8, 21,   1.00E-02,   8, 22,  -1.48E+00,   8, 23,  -3.85E+00,
     &  8, 24,  -4.17E+00,   8, 25,   4.80E-01,   8, 26,   8.10E-01,
     &  8, 27,   1.02E+00,   8, 28,   9.30E-01,   8, 29,   1.92E+00,
     &  8, 30,   1.94E+00,   8, 31,   1.54E+00,   8, 32,   9.70E-01/
      data (nsz(i),nsa(i),shin(i),i= 121, 150)/
     &  8, 33,   3.70E-01,   8, 34,  -2.40E-01,   9, 12,   1.85E+00,
     &  9, 13,   1.94E+00,   9, 14,   1.55E+00,   9, 15,  -1.64E+00,
     &  9, 16,   6.50E-01,   9, 17,   1.30E+00,   9, 18,   3.41E+00,
     &  9, 19,   4.33E+00,   9, 20,   3.78E+00,   9, 21,   3.27E+00,
     &  9, 22,   2.22E+00,   9, 23,   4.20E-01,   9, 24,  -6.80E-01,
     &  9, 25,  -9.40E-01,   9, 26,  -5.00E-01,   9, 27,   1.43E+00,
     &  9, 28,   2.16E+00,   9, 29,   2.05E+00,   9, 30,   2.99E+00,
     &  9, 31,   2.98E+00,   9, 32,   2.57E+00,   9, 33,   2.00E+00,
     &  9, 34,   1.39E+00,   9, 35,   7.70E-01,   9, 36,   0.00E+00,
     &  9, 37,  -1.04E+00,   9, 38,  -6.40E-01,  10, 14,   2.02E+00/
      data (nsz(i),nsa(i),shin(i),i= 151, 180)/
     & 10, 15,   2.60E+00,  10, 16,  -2.50E-01,  10, 17,   1.20E+00,
     & 10, 18,   2.05E+00,  10, 19,   3.89E+00,  10, 20,   3.54E+00,
     & 10, 21,   3.40E+00,  10, 22,   2.96E+00,  10, 23,   2.53E+00,
     & 10, 24,   1.62E+00,  10, 25,   5.50E-01,  10, 26,   1.21E+00,
     & 10, 27,   1.37E+00,  10, 28,   2.26E+00,  10, 29,   2.22E+00,
     & 10, 30,   2.11E+00,  10, 31,   3.03E+00,  10, 32,   3.02E+00,
     & 10, 33,   2.62E+00,  10, 34,   2.05E+00,  10, 35,   1.46E+00,
     & 10, 36,   8.50E-01,  10, 37,   9.00E-02,  10, 38,  -9.30E-01,
     & 10, 39,  -5.40E-01,  10, 40,  -4.00E-02,  10, 41,  -1.07E+00,
     & 11, 15,   2.06E+00,  11, 16,   2.62E+00,  11, 17,  -4.70E-01/
      data (nsz(i),nsa(i),shin(i),i= 181, 210)/
     & 11, 18,   1.07E+00,  11, 19,   1.25E+00,  11, 20,   2.97E+00,
     & 11, 21,   2.92E+00,  11, 22,   3.33E+00,  11, 23,   2.75E+00,
     & 11, 24,   2.73E+00,  11, 25,   2.21E+00,  11, 26,   1.77E+00,
     & 11, 27,   1.73E+00,  11, 28,   1.74E+00,  11, 29,   2.70E+00,
     & 11, 30,   2.58E+00,  11, 31,   2.72E+00,  11, 32,   1.74E+00,
     & 11, 33,   3.72E+00,  11, 34,   2.64E+00,  11, 35,   2.09E+00,
     & 11, 36,   1.50E+00,  11, 37,   9.00E-01,  11, 38,   1.60E-01,
     & 11, 39,  -8.40E-01,  11, 40,  -4.70E-01,  11, 41,   1.17E+00,
     & 11, 42,   9.80E-01,  11, 43,   3.90E-01,  11, 44,   9.00E-02,
     & 12, 17,   1.86E+00,  12, 18,   7.30E-01,  12, 19,   1.00E-02/
      data (nsz(i),nsa(i),shin(i),i= 211, 240)/
     & 12, 20,   5.80E-01,  12, 21,   2.27E+00,  12, 22,   2.25E+00,
     & 12, 23,   2.46E+00,  12, 24,   2.21E+00,  12, 25,   2.33E+00,
     & 12, 26,   1.83E+00,  12, 27,   1.07E+00,  12, 28,   1.29E+00,
     & 12, 29,   1.68E+00,  12, 30,   2.29E+00,  12, 31,   2.68E+00,
     & 12, 32,   2.84E+00,  12, 33,   2.26E+00,  12, 34,   2.57E+00,
     & 12, 35,   2.19E+00,  12, 36,   1.65E+00,  12, 37,   1.09E+00,
     & 12, 38,   5.00E-01,  12, 39,  -2.20E-01,  12, 40,  -1.20E+00,
     & 12, 41,  -8.20E-01,  12, 42,   1.00E+00,  12, 43,   1.14E+00,
     & 12, 44,  -4.93E+00,  12, 45,   1.21E+00,  12, 46,  -1.50E+00,
     & 12, 47,   1.26E+00,  13, 18,   2.01E+00,  13, 19,   9.10E-01/
      data (nsz(i),nsa(i),shin(i),i= 241, 270)/
     & 13, 20,   6.10E-01,  13, 21,  -1.49E+00,  13, 22,   9.70E-01,
     & 13, 23,   1.50E+00,  13, 24,   2.09E+00,  13, 25,   1.94E+00,
     & 13, 26,   2.23E+00,  13, 27,   1.40E+00,  13, 28,   1.32E+00,
     & 13, 29,   1.10E+00,  13, 30,   1.34E+00,  13, 31,   1.72E+00,
     & 13, 32,   2.03E+00,  13, 33,   2.56E+00,  13, 34,   3.09E+00,
     & 13, 35,   2.77E+00,  13, 36,   2.28E+00,  13, 37,   1.76E+00,
     & 13, 38,   1.20E+00,  13, 39,   6.30E-01,  13, 40,  -9.00E-02,
     & 13, 41,  -1.05E+00,  13, 42,  -6.90E-01,  13, 43,   1.66E+00,
     & 13, 44,   1.26E+00,  13, 45,  -3.54E+00,  13, 46,   1.55E+00,
     & 13, 47,   1.76E+00,  13, 48,   2.41E+00,  13, 49,   2.80E+00/
      data (nsz(i),nsa(i),shin(i),i= 271, 300)/
     & 13, 50,   1.93E+00,  13, 51,   1.35E+00,  14, 20,  -4.10E-01,
     & 14, 21,  -6.70E-01,  14, 22,  -2.98E+00,  14, 23,  -4.30E-01,
     & 14, 24,   4.90E-01,  14, 25,   1.46E+00,  14, 26,   1.26E+00,
     & 14, 27,   1.23E+00,  14, 28,   1.90E-01,  14, 29,  -1.80E-01,
     & 14, 30,   3.20E-01,  14, 31,   1.70E-01,  14, 32,   3.30E-01,
     & 14, 33,   7.80E-01,  14, 34,   1.05E+00,  14, 35,   2.19E+00,
     & 14, 36,   2.48E+00,  14, 37,   3.71E+00,  14, 38,   8.90E-01,
     & 14, 39,   3.50E-01,  14, 40,  -2.00E-01,  14, 41,  -8.80E-01,
     & 14, 42,  -1.82E+00,  14, 43,  -1.45E+00,  14, 44,   3.50E-01,
     & 14, 45,   5.50E-01,  14, 46,  -1.97E+00,  14, 47,   1.25E+00/
      data (nsz(i),nsa(i),shin(i),i= 301, 330)/
     & 14, 48,   1.63E+00,  14, 49,   1.99E+00,  14, 50,   2.13E+00,
     & 14, 51,   2.29E+00,  14, 52,   1.28E+00,  14, 53,   3.30E-01,
     & 14, 54,  -1.10E-01,  15, 21,  -3.80E-01,  15, 22,  -6.30E-01,
     & 15, 23,  -3.10E-01,  15, 24,   9.90E-01,  15, 25,   1.08E+00,
     & 15, 26,   1.14E+00,  15, 27,   2.00E-02,  15, 28,   7.50E-01,
     & 15, 29,  -5.20E-01,  15, 30,  -2.00E-02,  15, 31,   2.30E-01,
     & 15, 32,   5.00E-01,  15, 33,   2.00E-01,  15, 34,   5.50E-01,
     & 15, 35,   4.10E-01,  15, 36,   2.18E+00,  15, 37,   2.15E+00,
     & 15, 38,   1.37E+00,  15, 39,   8.80E-01,  15, 40,   3.50E-01,
     & 15, 41,  -1.90E-01,  15, 42,  -8.60E-01,  15, 43,  -1.79E+00/
      data (nsz(i),nsa(i),shin(i),i= 331, 360)/
     & 15, 44,  -1.42E+00,  15, 45,   1.64E+00,  15, 46,   1.54E+00,
     & 15, 47,  -2.60E-01,  15, 48,   1.89E+00,  15, 49,   1.87E+00,
     & 15, 50,   2.71E+00,  15, 51,   3.07E+00,  15, 52,   2.80E+00,
     & 15, 53,   2.76E+00,  15, 54,   1.92E+00,  15, 55,   1.19E+00,
     & 15, 56,   1.30E+00,  15, 57,   1.24E+00,  16, 23,  -7.00E-02,
     & 16, 24,   2.30E-01,  16, 25,   1.48E+00,  16, 26,   1.55E+00,
     & 16, 27,   1.60E+00,  16, 28,   1.20E-01,  16, 29,   3.50E-01,
     & 16, 30,  -1.70E-01,  16, 31,   3.00E-02,  16, 32,   1.02E+00,
     & 16, 33,   1.02E+00,  16, 34,   1.14E+00,  16, 35,   1.21E+00,
     & 16, 36,   1.23E+00,  16, 37,   2.55E+00,  16, 38,   2.95E+00/
      data (nsz(i),nsa(i),shin(i),i= 361, 390)/
     & 16, 39,   2.94E+00,  16, 40,   2.66E+00,  16, 41,   7.20E-01,
     & 16, 42,   1.80E-01,  16, 43,  -4.90E-01,  16, 44,  -1.41E+00,
     & 16, 45,  -1.05E+00,  16, 46,   1.72E+00,  16, 47,   1.70E+00,
     & 16, 48,   1.67E+00,  16, 49,   1.64E+00,  16, 50,   1.44E+00,
     & 16, 51,   2.57E+00,  16, 52,   3.11E+00,  16, 53,   3.01E+00,
     & 16, 54,   3.01E+00,  16, 55,   2.85E+00,  16, 56,   2.41E+00,
     & 16, 57,   1.85E+00,  16, 58,   1.87E+00,  16, 59,   3.57E+00,
     & 16, 60,   4.11E+00,  17, 24,   2.00E-01,  17, 25,   4.80E-01,
     & 17, 26,   1.69E+00,  17, 27,   1.76E+00,  17, 28,   1.81E+00,
     & 17, 29,   1.31E+00,  17, 30,   1.43E+00,  17, 31,  -6.60E-01/
      data (nsz(i),nsa(i),shin(i),i= 391, 420)/
     & 17, 32,   2.00E-02,  17, 33,   7.30E-01,  17, 34,   1.19E+00,
     & 17, 35,   1.38E+00,  17, 36,   1.49E+00,  17, 37,   1.48E+00,
     & 17, 38,   2.57E+00,  17, 39,   3.32E+00,  17, 40,   3.35E+00,
     & 17, 41,   2.93E+00,  17, 42,   2.25E+00,  17, 43,   3.60E-01,
     & 17, 44,  -3.10E-01,  17, 45,  -1.21E+00,  17, 46,  -8.60E-01,
     & 17, 47,   1.53E+00,  17, 48,   1.86E+00,  17, 49,   1.95E+00,
     & 17, 50,   2.19E+00,  17, 51,   2.22E+00,  17, 52,   2.78E+00,
     & 17, 53,   3.39E+00,  17, 54,   3.53E+00,  17, 55,   4.01E+00,
     & 17, 56,   3.84E+00,  17, 57,   3.60E+00,  17, 58,   1.85E+00,
     & 17, 59,   9.50E-01,  17, 60,   4.20E-01,  17, 61,  -1.23E+00/
      data (nsz(i),nsa(i),shin(i),i= 421, 450)/
     & 17, 62,  -1.44E+00,  17, 63,  -1.13E+00,  18, 27,   1.99E+00,
     & 18, 28,   2.05E+00,  18, 29,   2.09E+00,  18, 30,   1.59E+00,
     & 18, 31,   1.71E+00,  18, 32,  -5.80E-01,  18, 33,  -4.30E-01,
     & 18, 34,   6.50E-01,  18, 35,   1.17E+00,  18, 36,   1.89E+00,
     & 18, 37,   2.18E+00,  18, 38,   2.23E+00,  18, 39,   3.23E+00,
     & 18, 40,   3.71E+00,  18, 41,   3.85E+00,  18, 42,   3.39E+00,
     & 18, 43,   2.79E+00,  18, 44,   2.15E+00,  18, 45,   5.50E-01,
     & 18, 46,  -9.00E-01,  18, 47,  -2.19E+00,  18, 48,   1.35E+00,
     & 18, 49,   1.73E+00,  18, 50,   1.79E+00,  18, 51,   2.01E+00,
     & 18, 52,   2.03E+00,  18, 53,   2.39E+00,  18, 54,   2.78E+00/
      data (nsz(i),nsa(i),shin(i),i= 451, 480)/
     & 18, 55,   2.00E+00,  18, 56,   1.17E+00,  18, 57,   1.58E+00,
     & 18, 58,   1.73E+00,  18, 59,   1.27E+00,  18, 60,   7.40E-01,
     & 18, 61,  -2.40E-01,  18, 62,  -1.60E+00,  18, 63,  -1.62E+00,
     & 18, 64,  -1.59E+00,  18, 65,  -1.24E+00,  18, 66,   3.00E-02,
     & 18, 67,  -4.50E-01,  19, 29,   2.22E+00,  19, 30,   2.25E+00,
     & 19, 31,   1.76E+00,  19, 32,   1.88E+00,  19, 33,   9.10E-01,
     & 19, 34,   9.00E-01,  19, 35,   4.30E-01,  19, 36,   9.80E-01,
     & 19, 37,   1.88E+00,  19, 38,   1.92E+00,  19, 39,   1.89E+00,
     & 19, 40,   3.21E+00,  19, 41,   3.83E+00,  19, 42,   4.00E+00,
     & 19, 43,   3.67E+00,  19, 44,   2.80E+00,  19, 45,   1.98E+00/
      data (nsz(i),nsa(i),shin(i),i= 481, 510)/
     & 19, 46,   3.80E-01,  19, 47,  -1.05E+00,  19, 48,  -1.29E+00,
     & 19, 49,  -1.66E+00,  19, 50,  -1.59E+00,  19, 51,   2.33E+00,
     & 19, 52,   2.78E+00,  19, 53,   3.09E+00,  19, 54,   3.60E+00,
     & 19, 55,   4.12E+00,  19, 56,   3.49E+00,  19, 57,   3.30E+00,
     & 19, 58,   3.45E+00,  19, 59,   2.51E+00,  19, 60,   2.17E+00,
     & 19, 61,   1.42E+00,  19, 62,   8.10E-01,  19, 63,   2.90E-01,
     & 19, 64,   1.62E+00,  19, 65,   7.40E-01,  19, 66,   4.50E-01,
     & 19, 67,  -2.50E-01,  19, 68,  -9.00E-01,  19, 69,  -1.84E+00,
     & 19, 70,  -1.98E+00,  20, 30,   2.11E+00,  20, 31,   2.14E+00,
     & 20, 32,   1.67E+00,  20, 33,   1.78E+00,  20, 34,   8.40E-01/
      data (nsz(i),nsa(i),shin(i),i= 511, 540)/
     & 20, 35,  -8.90E-01,  20, 36,   3.10E-01,  20, 37,   7.60E-01,
     & 20, 38,   1.72E+00,  20, 39,   1.69E+00,  20, 40,   1.99E+00,
     & 20, 41,   3.09E+00,  20, 42,   3.80E+00,  20, 43,   3.93E+00,
     & 20, 44,   3.54E+00,  20, 45,   2.89E+00,  20, 46,   1.92E+00,
     & 20, 47,   2.40E-01,  20, 48,  -1.47E+00,  20, 49,  -2.07E+00,
     & 20, 50,  -1.26E+00,  20, 51,  -1.17E+00,  20, 52,   2.13E+00,
     & 20, 53,   2.48E+00,  20, 54,   2.68E+00,  20, 55,   2.79E+00,
     & 20, 56,   2.68E+00,  20, 57,   3.39E+00,  20, 58,   2.41E+00,
     & 20, 59,   2.52E+00,  20, 60,   2.44E+00,  20, 61,   1.68E+00,
     & 20, 62,   1.42E+00,  20, 63,   1.64E+00,  20, 64,   1.07E+00/
      data (nsz(i),nsa(i),shin(i),i= 541, 570)/
     & 20, 65,   7.90E-01,  20, 66,   1.50E-01,  20, 67,  -4.20E-01,
     & 20, 68,  -1.17E+00,  20, 69,  -1.85E+00,  20, 70,  -3.12E+00,
     & 20, 71,  -2.64E+00,  20, 72,  -2.57E+00,  20, 73,  -2.48E+00,
     & 21, 32,   3.05E+00,  21, 33,   2.57E+00,  21, 34,   2.66E+00,
     & 21, 35,   1.72E+00,  21, 36,   1.69E+00,  21, 37,   2.06E+00,
     & 21, 38,   2.22E+00,  21, 39,   2.16E+00,  21, 40,   2.49E+00,
     & 21, 41,   2.59E+00,  21, 42,   3.28E+00,  21, 43,   4.39E+00,
     & 21, 44,   4.15E+00,  21, 45,   3.91E+00,  21, 46,   3.28E+00,
     & 21, 47,   2.39E+00,  21, 48,   1.08E+00,  21, 49,  -5.30E-01,
     & 21, 50,  -7.50E-01,  21, 51,  -7.00E-02,  21, 52,   1.67E+00/
      data (nsz(i),nsa(i),shin(i),i= 571, 600)/
     & 21, 53,   2.60E+00,  21, 54,   3.27E+00,  21, 55,   3.64E+00,
     & 21, 56,   4.01E+00,  21, 57,   4.09E+00,  21, 58,   4.23E+00,
     & 21, 59,   3.76E+00,  21, 60,   3.52E+00,  21, 61,   2.56E+00,
     & 21, 62,   3.22E+00,  21, 63,   2.82E+00,  21, 64,   2.49E+00,
     & 21, 65,   1.90E+00,  21, 66,   1.52E+00,  21, 67,   7.90E-01,
     & 21, 68,   2.50E-01,  21, 69,  -5.50E-01,  21, 70,  -1.27E+00,
     & 21, 71,  -1.93E+00,  21, 72,  -2.08E+00,  21, 73,  -2.15E+00,
     & 21, 74,  -2.17E+00,  21, 75,  -1.72E+00,  21, 76,  -8.60E-01,
     & 22, 34,   2.57E+00,  22, 35,   2.66E+00,  22, 36,   1.74E+00,
     & 22, 37,   1.71E+00,  22, 38,   2.07E+00,  22, 39,   2.23E+00/
      data (nsz(i),nsa(i),shin(i),i= 601, 630)/
     & 22, 40,   2.33E+00,  22, 41,   2.73E+00,  22, 42,   2.97E+00,
     & 22, 43,   3.99E+00,  22, 44,   3.59E+00,  22, 45,   3.86E+00,
     & 22, 46,   3.13E+00,  22, 47,   2.71E+00,  22, 48,   2.17E+00,
     & 22, 49,   1.26E+00,  22, 50,   1.50E-01,  22, 51,  -1.20E-01,
     & 22, 52,   7.70E-01,  22, 53,   4.30E-01,  22, 54,   2.37E+00,
     & 22, 55,   2.82E+00,  22, 56,   3.11E+00,  22, 57,   3.71E+00,
     & 22, 58,   3.66E+00,  22, 59,   3.81E+00,  22, 60,   3.36E+00,
     & 22, 61,   3.11E+00,  22, 62,   2.71E+00,  22, 63,   3.00E+00,
     & 22, 64,   2.10E+00,  22, 65,   2.31E+00,  22, 66,   1.46E+00,
     & 22, 67,   1.14E+00,  22, 68,   5.40E-01,  22, 69,   0.00E+00/
      data (nsz(i),nsa(i),shin(i),i= 631, 660)/
     & 22, 70,  -8.60E-01,  22, 71,  -1.69E+00,  22, 72,  -2.65E+00,
     & 22, 73,  -2.41E+00,  22, 74,  -2.23E+00,  22, 75,  -1.90E+00,
     & 22, 76,  -1.25E+00,  22, 77,  -6.10E-01,  22, 78,   1.40E-01,
     & 22, 79,  -1.12E+00,  22, 80,  -4.20E-01,  23, 36,   2.28E+00,
     & 23, 37,   1.38E+00,  23, 38,   1.37E+00,  23, 39,   1.73E+00,
     & 23, 40,   1.89E+00,  23, 41,   2.11E+00,  23, 42,   2.25E+00,
     & 23, 43,   2.16E+00,  23, 44,   3.46E+00,  23, 45,   3.46E+00,
     & 23, 46,   2.55E+00,  23, 47,   2.98E+00,  23, 48,   2.22E+00,
     & 23, 49,   2.06E+00,  23, 50,   1.24E+00,  23, 51,   3.20E-01,
     & 23, 52,   3.60E-01,  23, 53,   8.60E-01,  23, 54,   1.04E+00/
      data (nsz(i),nsa(i),shin(i),i= 661, 690)/
     & 23, 55,   1.62E+00,  23, 56,   3.26E+00,  23, 57,   3.49E+00,
     & 23, 58,   4.03E+00,  23, 59,   3.88E+00,  23, 60,   4.41E+00,
     & 23, 61,   4.03E+00,  23, 62,   3.89E+00,  23, 63,   3.26E+00,
     & 23, 64,   3.84E+00,  23, 65,   3.04E+00,  23, 66,   2.25E+00,
     & 23, 67,   2.15E+00,  23, 68,   1.59E+00,  23, 69,   8.50E-01,
     & 23, 70,   3.30E-01,  23, 71,  -3.30E-01,  23, 72,  -1.25E+00,
     & 23, 73,  -2.04E+00,  23, 74,  -1.85E+00,  23, 75,  -1.49E+00,
     & 23, 76,  -1.05E+00,  23, 77,  -6.30E-01,  23, 78,  -4.00E-01,
     & 23, 79,  -1.00E-01,  23, 80,  -3.00E-02,  23, 81,   3.20E-01,
     & 23, 82,   4.20E-01,  23, 83,   8.80E-01,  24, 38,   8.90E-01/
      data (nsz(i),nsa(i),shin(i),i= 691, 720)/
     & 24, 39,   8.80E-01,  24, 40,   1.24E+00,  24, 41,   1.41E+00,
     & 24, 42,   1.63E+00,  24, 43,   1.78E+00,  24, 44,   1.94E+00,
     & 24, 45,   3.01E+00,  24, 46,   2.47E+00,  24, 47,   2.64E+00,
     & 24, 48,   2.19E+00,  24, 49,   1.69E+00,  24, 50,   1.38E+00,
     & 24, 51,   9.40E-01,  24, 52,   3.00E-01,  24, 53,  -3.80E-01,
     & 24, 54,   4.80E-01,  24, 55,   8.00E-01,  24, 56,   1.64E+00,
     & 24, 57,   2.67E+00,  24, 58,   2.90E+00,  24, 59,   3.34E+00,
     & 24, 60,   3.25E+00,  24, 61,   4.28E+00,  24, 62,   4.11E+00,
     & 24, 63,   4.33E+00,  24, 64,   2.93E+00,  24, 65,   3.51E+00,
     & 24, 66,   2.73E+00,  24, 67,   2.29E+00,  24, 68,   1.59E+00/
      data (nsz(i),nsa(i),shin(i),i= 721, 750)/
     & 24, 69,   9.60E-01,  24, 70,   2.30E-01,  24, 71,  -1.80E-01,
     & 24, 72,  -7.60E-01,  24, 73,  -1.62E+00,  24, 74,  -2.41E+00,
     & 24, 75,  -2.13E+00,  24, 76,  -1.74E+00,  24, 77,  -1.39E+00,
     & 24, 78,  -1.09E+00,  24, 79,  -8.50E-01,  24, 80,   4.40E-01,
     & 24, 81,   4.10E-01,  24, 82,   7.60E-01,  24, 83,   4.60E-01,
     & 24, 84,   8.30E-01,  24, 85,   8.30E-01,  24, 86,   1.15E+00,
     & 25, 40,   3.50E-01,  25, 41,   7.20E-01,  25, 42,   8.90E-01,
     & 25, 43,   1.12E+00,  25, 44,   1.27E+00,  25, 45,   1.20E+00,
     & 25, 46,   1.93E+00,  25, 47,   1.95E+00,  25, 48,   1.65E+00,
     & 25, 49,   1.36E+00,  25, 50,   7.40E-01,  25, 51,   6.40E-01/
      data (nsz(i),nsa(i),shin(i),i= 751, 780)/
     & 25, 52,   1.70E-01,  25, 53,  -2.10E-01,  25, 54,  -2.80E-01,
     & 25, 55,  -4.00E-02,  25, 56,   4.30E-01,  25, 57,   1.15E+00,
     & 25, 58,   1.46E+00,  25, 59,   2.09E+00,  25, 60,   2.11E+00,
     & 25, 61,   3.34E+00,  25, 62,   3.96E+00,  25, 63,   3.71E+00,
     & 25, 64,   4.02E+00,  25, 65,   3.79E+00,  25, 66,   3.86E+00,
     & 25, 67,   2.63E+00,  25, 68,   2.52E+00,  25, 69,   1.75E+00,
     & 25, 70,   1.27E+00,  25, 71,   4.70E-01,  25, 72,  -1.20E-01,
     & 25, 73,  -8.70E-01,  25, 74,  -1.81E+00,  25, 75,  -2.60E+00,
     & 25, 76,  -2.16E+00,  25, 77,  -1.51E+00,  25, 78,  -1.07E+00,
     & 25, 79,  -6.10E-01,  25, 80,  -2.00E-01,  25, 81,   9.00E-02/
      data (nsz(i),nsa(i),shin(i),i= 781, 810)/
     & 25, 82,   9.40E-01,  25, 83,   1.47E+00,  25, 84,   1.37E+00,
     & 25, 85,   1.33E+00,  25, 86,   1.35E+00,  25, 87,   1.51E+00,
     & 25, 88,   1.46E+00,  25, 89,   1.16E+00,  26, 42,   1.80E-01,
     & 26, 43,   3.60E-01,  26, 44,   6.00E-01,  26, 45,   7.50E-01,
     & 26, 46,   6.90E-01,  26, 47,   1.42E+00,  26, 48,   9.30E-01,
     & 26, 49,   1.32E+00,  26, 50,   8.30E-01,  26, 51,   3.60E-01,
     & 26, 52,   7.00E-02,  26, 53,  -2.80E-01,  26, 54,  -7.50E-01,
     & 26, 55,  -9.10E-01,  26, 56,  -4.40E-01,  26, 57,  -8.00E-02,
     & 26, 58,   4.00E-01,  26, 59,   8.00E-01,  26, 60,   1.45E+00,
     & 26, 61,   1.89E+00,  26, 62,   2.35E+00,  26, 63,   2.34E+00/
      data (nsz(i),nsa(i),shin(i),i= 811, 840)/
     & 26, 64,   2.70E+00,  26, 65,   2.60E+00,  26, 66,   2.24E+00,
     & 26, 67,   2.81E+00,  26, 68,   1.97E+00,  26, 69,   1.99E+00,
     & 26, 70,   1.26E+00,  26, 71,   6.70E-01,  26, 72,  -1.70E-01,
     & 26, 73,  -6.90E-01,  26, 74,  -1.54E+00,  26, 75,  -2.42E+00,
     & 26, 76,  -3.36E+00,  26, 77,  -2.77E+00,  26, 78,  -2.04E+00,
     & 26, 79,  -1.71E+00,  26, 80,  -8.20E-01,  26, 81,  -2.50E-01,
     & 26, 82,   1.80E-01,  26, 83,   5.80E-01,  26, 84,   1.49E+00,
     & 26, 85,   1.50E+00,  26, 86,   1.26E+00,  26, 87,   1.28E+00,
     & 26, 88,   1.55E+00,  26, 89,   1.21E+00,  26, 90,   9.80E-01,
     & 26, 91,   1.47E+00,  26, 92,   3.50E-01,  27, 44,  -3.10E-01/
      data (nsz(i),nsa(i),shin(i),i= 841, 870)/
     & 27, 45,  -6.00E-02,  27, 46,   1.00E-01,  27, 47,   5.00E-02,
     & 27, 48,   7.80E-01,  27, 49,   8.10E-01,  27, 50,   5.40E-01,
     & 27, 51,   1.40E-01,  27, 52,  -3.30E-01,  27, 53,  -5.30E-01,
     & 27, 54,  -1.40E+00,  27, 55,  -1.75E+00,  27, 56,  -1.53E+00,
     & 27, 57,  -9.60E-01,  27, 58,  -3.70E-01,  27, 59,  -4.00E-02,
     & 27, 60,   5.60E-01,  27, 61,   9.50E-01,  27, 62,   1.46E+00,
     & 27, 63,   1.72E+00,  27, 64,   1.90E+00,  27, 65,   2.28E+00,
     & 27, 66,   1.99E+00,  27, 67,   2.23E+00,  27, 68,   2.45E+00,
     & 27, 69,   1.78E+00,  27, 70,   1.70E+00,  27, 71,   1.04E+00,
     & 27, 72,   5.20E-01,  27, 73,  -2.90E-01,  27, 74,  -9.10E-01/
      data (nsz(i),nsa(i),shin(i),i= 871, 900)/
     & 27, 75,  -1.88E+00,  27, 76,  -2.79E+00,  27, 77,  -3.60E+00,
     & 27, 78,  -3.03E+00,  27, 79,  -2.30E+00,  27, 80,  -1.72E+00,
     & 27, 81,  -9.50E-01,  27, 82,  -3.20E-01,  27, 83,   1.20E-01,
     & 27, 84,   9.10E-01,  27, 85,   1.80E+00,  27, 86,   1.73E+00,
     & 27, 87,   1.72E+00,  27, 88,   1.61E+00,  27, 89,   1.74E+00,
     & 27, 90,   1.57E+00,  27, 91,   1.19E+00,  27, 92,   1.70E+00,
     & 27, 93,   1.83E+00,  27, 94,   1.17E+00,  27, 95,   1.13E+00,
     & 27, 96,   8.10E-01,  28, 46,  -9.60E-01,  28, 47,  -7.90E-01,
     & 28, 48,  -8.20E-01,  28, 49,  -9.00E-02,  28, 50,  -5.00E-02,
     & 28, 51,  -3.10E-01,  28, 52,  -8.40E-01,  28, 53,  -5.30E-01/
      data (nsz(i),nsa(i),shin(i),i= 901, 930)/
     & 28, 54,  -1.06E+00,  28, 55,  -1.85E+00,  28, 56,  -2.61E+00,
     & 28, 57,  -2.29E+00,  28, 58,  -1.41E+00,  28, 59,  -9.90E-01,
     & 28, 60,  -4.60E-01,  28, 61,   6.00E-02,  28, 62,   2.90E-01,
     & 28, 63,   8.00E-01,  28, 64,   9.40E-01,  28, 65,   1.28E+00,
     & 28, 66,   1.17E+00,  28, 67,   9.70E-01,  28, 68,   1.16E+00,
     & 28, 69,   9.10E-01,  28, 70,   8.00E-01,  28, 71,   9.80E-01,
     & 28, 72,   5.40E-01,  28, 73,   0.00E+00,  28, 74,  -6.90E-01,
     & 28, 75,  -1.57E+00,  28, 76,  -2.47E+00,  28, 77,  -3.33E+00,
     & 28, 78,  -4.76E+00,  28, 79,  -3.62E+00,  28, 80,  -3.33E+00,
     & 28, 81,  -2.35E+00,  28, 82,  -1.91E+00,  28, 83,  -6.70E-01/
      data (nsz(i),nsa(i),shin(i),i= 931, 960)/
     & 28, 84,  -6.00E-02,  28, 85,   5.40E-01,  28, 86,   1.62E+00,
     & 28, 87,   1.78E+00,  28, 88,   1.75E+00,  28, 89,   1.67E+00,
     & 28, 90,   1.70E+00,  28, 91,   1.52E+00,  28, 92,   1.42E+00,
     & 28, 93,   1.48E+00,  28, 94,   1.73E+00,  28, 95,   1.51E+00,
     & 28, 96,   1.19E+00,  28, 97,   7.60E-01,  28, 98,   6.10E-01,
     & 28, 99,   5.00E-02,  29, 48,  -4.60E-01,  29, 49,  -4.90E-01,
     & 29, 50,   2.20E-01,  29, 51,   2.60E-01,  29, 52,   0.00E+00,
     & 29, 53,  -3.80E-01,  29, 54,  -8.00E-01,  29, 55,  -1.22E+00,
     & 29, 56,  -1.87E+00,  29, 57,  -2.56E+00,  29, 58,  -2.31E+00,
     & 29, 59,  -1.21E+00,  29, 60,  -7.30E-01,  29, 61,  -2.80E-01/
      data (nsz(i),nsa(i),shin(i),i= 961, 990)/
     & 29, 62,   2.70E-01,  29, 63,   4.80E-01,  29, 64,   9.90E-01,
     & 29, 65,   1.11E+00,  29, 66,   1.52E+00,  29, 67,   1.48E+00,
     & 29, 68,   1.76E+00,  29, 69,   1.70E+00,  29, 70,   2.19E+00,
     & 29, 71,   1.91E+00,  29, 72,   1.74E+00,  29, 73,   9.90E-01,
     & 29, 74,   5.30E-01,  29, 75,  -3.20E-01,  29, 76,  -9.50E-01,
     & 29, 77,  -1.87E+00,  29, 78,  -2.68E+00,  29, 79,  -3.48E+00,
     & 29, 80,  -2.88E+00,  29, 81,  -2.15E+00,  29, 82,  -1.39E+00,
     & 29, 83,  -9.10E-01,  29, 84,  -2.80E-01,  29, 85,   1.70E-01,
     & 29, 86,   8.20E-01,  29, 87,   1.85E+00,  29, 88,   2.05E+00,
     & 29, 89,   1.76E+00,  29, 90,   1.75E+00,  29, 91,   1.97E+00/
      data (nsz(i),nsa(i),shin(i),i= 991,1020)/
     & 29, 92,   1.73E+00,  29, 93,   1.66E+00,  29, 94,   1.97E+00,
     & 29, 95,   2.28E+00,  29, 96,   2.19E+00,  29, 97,   1.92E+00,
     & 29, 98,   1.58E+00,  29, 99,   1.28E+00,  29,100,   1.37E+00,
     & 29,101,   1.54E+00,  29,102,   1.20E+00,  30, 51,   1.05E+00,
     & 30, 52,   1.19E+00,  30, 53,   1.83E+00,  30, 54,   1.08E+00,
     & 30, 55,   1.12E+00,  30, 56,  -1.41E+00,  30, 57,  -1.42E+00,
     & 30, 58,  -1.80E+00,  30, 59,  -1.40E+00,  30, 60,  -5.00E-01,
     & 30, 61,   5.00E-02,  30, 62,   4.10E-01,  30, 63,   9.80E-01,
     & 30, 64,   1.26E+00,  30, 65,   1.93E+00,  30, 66,   1.95E+00,
     & 30, 67,   2.60E+00,  30, 68,   2.52E+00,  30, 69,   2.83E+00/
      data (nsz(i),nsa(i),shin(i),i=1021,1050)/
     & 30, 70,   2.82E+00,  30, 71,   2.97E+00,  30, 72,   2.45E+00,
     & 30, 73,   2.31E+00,  30, 74,   1.53E+00,  30, 75,   1.20E+00,
     & 30, 76,   1.80E-01,  30, 77,  -3.60E-01,  30, 78,  -1.41E+00,
     & 30, 79,  -2.64E+00,  30, 80,  -3.13E+00,  30, 81,  -2.30E+00,
     & 30, 82,  -1.49E+00,  30, 83,  -8.90E-01,  30, 84,  -4.70E-01,
     & 30, 85,  -1.00E-02,  30, 86,   3.50E-01,  30, 87,   1.14E+00,
     & 30, 88,   1.88E+00,  30, 89,   2.31E+00,  30, 90,   2.16E+00,
     & 30, 91,   2.37E+00,  30, 92,   2.58E+00,  30, 93,   2.13E+00,
     & 30, 94,   2.09E+00,  30, 95,   2.26E+00,  30, 96,   2.67E+00,
     & 30, 97,   2.53E+00,  30, 98,   2.24E+00,  30, 99,   1.55E+00/
      data (nsz(i),nsa(i),shin(i),i=1051,1080)/
     & 30,100,   1.29E+00,  30,101,   1.65E+00,  30,102,   1.90E+00,
     & 30,103,   1.56E+00,  30,104,   1.48E+00,  30,105,   1.02E+00,
     & 31, 53,   1.68E+00,  31, 54,   2.27E+00,  31, 55,   1.72E+00,
     & 31, 56,   1.77E+00,  31, 57,   1.14E+00,  31, 58,   6.10E-01,
     & 31, 59,  -2.00E-01,  31, 60,  -1.01E+00,  31, 61,   1.21E+00,
     & 31, 62,  -4.50E-01,  31, 63,   7.80E-01,  31, 64,   1.30E+00,
     & 31, 65,   1.79E+00,  31, 66,   2.35E+00,  31, 67,   2.43E+00,
     & 31, 68,   2.87E+00,  31, 69,   2.89E+00,  31, 70,   3.02E+00,
     & 31, 71,   3.13E+00,  31, 72,   3.56E+00,  31, 73,   2.93E+00,
     & 31, 74,   2.67E+00,  31, 75,   1.95E+00,  31, 76,   1.32E+00/
      data (nsz(i),nsa(i),shin(i),i=1081,1110)/
     & 31, 77,   8.50E-01,  31, 78,   2.60E-01,  31, 79,  -1.06E+00,
     & 31, 80,  -1.76E+00,  31, 81,  -2.65E+00,  31, 82,  -1.58E+00,
     & 31, 83,  -6.10E-01,  31, 84,  -1.10E-01,  31, 85,   3.40E-01,
     & 31, 86,   9.00E-01,  31, 87,   1.28E+00,  31, 88,   1.79E+00,
     & 31, 89,   2.27E+00,  31, 90,   2.73E+00,  31, 91,   2.52E+00,
     & 31, 92,   2.59E+00,  31, 93,   2.58E+00,  31, 94,   2.58E+00,
     & 31, 95,   2.83E+00,  31, 96,   3.16E+00,  31, 97,   3.21E+00,
     & 31, 98,   3.00E+00,  31, 99,   2.74E+00,  31,100,   2.21E+00,
     & 31,101,   1.88E+00,  31,102,   1.88E+00,  31,103,   2.07E+00,
     & 31,104,   1.83E+00,  31,105,   1.67E+00,  31,106,   1.16E+00/
      data (nsz(i),nsa(i),shin(i),i=1111,1140)/
     & 31,107,   5.00E-02,  31,108,  -7.60E-01,  32, 55,   2.47E+00,
     & 32, 56,   1.94E+00,  32, 57,   2.01E+00,  32, 58,   1.47E+00,
     & 32, 59,   1.08E+00,  32, 60,  -1.32E+00,  32, 61,   1.12E+00,
     & 32, 62,   1.80E+00,  32, 63,   2.37E+00,  32, 64,   1.11E+00,
     & 32, 65,   2.03E+00,  32, 66,   2.17E+00,  32, 67,   2.99E+00,
     & 32, 68,   2.93E+00,  32, 69,   3.67E+00,  32, 70,   3.47E+00,
     & 32, 71,   4.06E+00,  32, 72,   3.71E+00,  32, 73,   4.07E+00,
     & 32, 74,   3.39E+00,  32, 75,   3.22E+00,  32, 76,   2.49E+00,
     & 32, 77,   2.02E+00,  32, 78,   1.23E+00,  32, 79,   4.30E-01,
     & 32, 80,  -3.70E-01,  32, 81,  -1.04E+00,  32, 82,  -1.78E+00/
      data (nsz(i),nsa(i),shin(i),i=1141,1170)/
     & 32, 83,  -7.80E-01,  32, 84,  -1.70E-01,  32, 85,   4.50E-01,
     & 32, 86,   9.00E-01,  32, 87,   1.40E+00,  32, 88,   1.83E+00,
     & 32, 89,   2.25E+00,  32, 90,   2.61E+00,  32, 91,   3.00E+00,
     & 32, 92,   3.09E+00,  32, 93,   2.93E+00,  32, 94,   3.00E+00,
     & 32, 95,   3.12E+00,  32, 96,   3.26E+00,  32, 97,   3.37E+00,
     & 32, 98,   3.26E+00,  32, 99,   2.93E+00,  32,100,   2.58E+00,
     & 32,101,   2.04E+00,  32,102,   1.85E+00,  32,103,   1.84E+00,
     & 32,104,   2.02E+00,  32,105,   1.66E+00,  32,106,   1.54E+00,
     & 32,107,   1.13E+00,  32,108,   9.50E-01,  32,109,  -3.70E-01,
     & 32,110,  -5.90E-01,  32,111,  -1.43E+00,  32,112,  -1.67E+00/
      data (nsz(i),nsa(i),shin(i),i=1171,1200)/
     & 33, 57,   2.37E+00,  33, 58,   2.40E+00,  33, 59,   1.90E+00,
     & 33, 60,   1.74E+00,  33, 61,   1.24E+00,  33, 62,   1.95E+00,
     & 33, 63,   2.34E+00,  33, 64,   2.85E+00,  33, 65,   3.05E+00,
     & 33, 66,   1.16E+00,  33, 67,   2.60E+00,  33, 68,   3.24E+00,
     & 33, 69,   3.53E+00,  33, 70,   4.13E+00,  33, 71,   4.05E+00,
     & 33, 72,   4.62E+00,  33, 73,   4.42E+00,  33, 74,   4.55E+00,
     & 33, 75,   4.01E+00,  33, 76,   3.96E+00,  33, 77,   3.13E+00,
     & 33, 78,   2.67E+00,  33, 79,   1.88E+00,  33, 80,   1.11E+00,
     & 33, 81,   2.00E-02,  33, 82,  -6.50E-01,  33, 83,  -1.64E+00,
     & 33, 84,  -4.40E-01,  33, 85,   2.20E-01,  33, 86,   9.30E-01/
      data (nsz(i),nsa(i),shin(i),i=1201,1230)/
     & 33, 87,   1.45E+00,  33, 88,   1.98E+00,  33, 89,   2.38E+00,
     & 33, 90,   2.76E+00,  33, 91,   3.05E+00,  33, 92,   3.38E+00,
     & 33, 93,   3.53E+00,  33, 94,   3.46E+00,  33, 95,   3.47E+00,
     & 33, 96,   3.57E+00,  33, 97,   3.72E+00,  33, 98,   3.59E+00,
     & 33, 99,   3.38E+00,  33,100,   2.94E+00,  33,101,   2.83E+00,
     & 33,102,   2.32E+00,  33,103,   1.97E+00,  33,104,   1.92E+00,
     & 33,105,   1.99E+00,  33,106,   1.73E+00,  33,107,   1.58E+00,
     & 33,108,   1.04E+00,  33,109,   9.40E-01,  33,110,  -1.00E-02,
     & 33,111,  -1.50E-01,  33,112,  -1.02E+00,  33,113,  -1.44E+00,
     & 33,114,  -4.51E+00,  33,115,  -5.22E+00,  34, 59,   2.34E+00/
      data (nsz(i),nsa(i),shin(i),i=1231,1260)/
     & 34, 60,   1.88E+00,  34, 61,   1.71E+00,  34, 62,   1.55E+00,
     & 34, 63,   2.10E+00,  34, 64,   2.53E+00,  34, 65,   2.99E+00,
     & 34, 66,   3.15E+00,  34, 67,   3.41E+00,  34, 68,   3.41E+00,
     & 34, 69,   3.66E+00,  34, 70,   3.70E+00,  34, 71,   4.25E+00,
     & 34, 72,   4.07E+00,  34, 73,   4.87E+00,  34, 74,   4.37E+00,
     & 34, 75,   4.64E+00,  34, 76,   4.13E+00,  34, 77,   4.18E+00,
     & 34, 78,   3.47E+00,  34, 79,   3.19E+00,  34, 80,   2.29E+00,
     & 34, 81,   1.54E+00,  34, 82,   5.20E-01,  34, 83,  -2.00E-02,
     & 34, 84,  -1.14E+00,  34, 85,  -1.04E+00,  34, 86,  -3.30E-01,
     & 34, 87,  -4.20E-01,  34, 88,   1.83E+00,  34, 89,   2.29E+00/
      data (nsz(i),nsa(i),shin(i),i=1261,1290)/
     & 34, 90,   2.67E+00,  34, 91,   3.10E+00,  34, 92,   3.32E+00,
     & 34, 93,   3.60E+00,  34, 94,   3.65E+00,  34, 95,   3.56E+00,
     & 34, 96,   3.62E+00,  34, 97,   3.70E+00,  34, 98,   3.86E+00,
     & 34, 99,   3.66E+00,  34,100,   3.18E+00,  34,101,   2.74E+00,
     & 34,102,   2.65E+00,  34,103,   2.09E+00,  34,104,   1.85E+00,
     & 34,105,   1.75E+00,  34,106,   1.88E+00,  34,107,   1.59E+00,
     & 34,108,   1.40E+00,  34,109,   1.02E+00,  34,110,   9.90E-01,
     & 34,111,   2.40E-01,  34,112,  -4.00E-01,  34,113,  -1.04E+00,
     & 34,114,  -1.40E+00,  34,115,  -4.31E+00,  34,116,  -4.84E+00,
     & 34,117,  -4.73E+00,  34,118,  -3.82E+00,  35, 61,   2.23E+00/
      data (nsz(i),nsa(i),shin(i),i=1291,1320)/
     & 35, 62,   2.75E+00,  35, 63,   1.99E+00,  35, 64,   2.61E+00,
     & 35, 65,   2.87E+00,  35, 66,   3.42E+00,  35, 67,   3.53E+00,
     & 35, 68,   3.72E+00,  35, 69,   3.53E+00,  35, 70,   3.84E+00,
     & 35, 71,   3.77E+00,  35, 72,   4.16E+00,  35, 73,   4.64E+00,
     & 35, 74,   4.97E+00,  35, 75,   4.82E+00,  35, 76,   4.83E+00,
     & 35, 77,   4.65E+00,  35, 78,   4.75E+00,  35, 79,   4.04E+00,
     & 35, 80,   3.73E+00,  35, 81,   2.76E+00,  35, 82,   1.98E+00,
     & 35, 83,   8.30E-01,  35, 84,   1.10E-01,  35, 85,  -1.07E+00,
     & 35, 86,  -7.00E-01,  35, 87,   7.00E-02,  35, 88,  -3.00E-02,
     & 35, 89,   4.90E-01,  35, 90,   6.00E-01,  35, 91,   1.52E+00/
      data (nsz(i),nsa(i),shin(i),i=1321,1350)/
     & 35, 92,   2.19E+00,  35, 93,   3.73E+00,  35, 94,   3.67E+00,
     & 35, 95,   3.73E+00,  35, 96,   3.60E+00,  35, 97,   3.62E+00,
     & 35, 98,   3.70E+00,  35, 99,   3.83E+00,  35,100,   3.66E+00,
     & 35,101,   3.37E+00,  35,102,   2.97E+00,  35,103,   2.69E+00,
     & 35,104,   2.31E+00,  35,105,   2.12E+00,  35,106,   2.00E+00,
     & 35,107,   2.11E+00,  35,108,   1.90E+00,  35,109,   1.92E+00,
     & 35,110,   2.68E+00,  35,111,   2.66E+00,  35,112,   3.80E-01,
     & 35,113,  -1.00E-02,  35,114,  -9.20E-01,  35,115,  -1.33E+00,
     & 35,116,  -4.44E+00,  35,117,  -5.07E+00,  35,118,  -4.83E+00,
     & 35,119,  -3.93E+00,  35,120,  -2.95E+00,  35,121,  -1.91E+00/
      data (nsz(i),nsa(i),shin(i),i=1351,1380)/
     & 36, 63,   2.65E+00,  36, 64,   1.95E+00,  36, 65,   2.49E+00,
     & 36, 66,   2.78E+00,  36, 67,   3.40E+00,  36, 68,   3.48E+00,
     & 36, 69,   3.68E+00,  36, 70,   3.47E+00,  36, 71,   3.76E+00,
     & 36, 72,   3.66E+00,  36, 73,   4.03E+00,  36, 74,   4.37E+00,
     & 36, 75,   4.58E+00,  36, 76,   4.47E+00,  36, 77,   4.63E+00,
     & 36, 78,   4.34E+00,  36, 79,   4.55E+00,  36, 80,   3.92E+00,
     & 36, 81,   3.81E+00,  36, 82,   2.90E+00,  36, 83,   2.44E+00,
     & 36, 84,   1.20E+00,  36, 85,   3.70E-01,  36, 86,  -9.20E-01,
     & 36, 87,  -8.20E-01,  36, 88,   1.00E-02,  36, 89,  -1.00E-01,
     & 36, 90,   8.40E-01,  36, 91,   7.80E-01,  36, 92,   2.00E+00/
      data (nsz(i),nsa(i),shin(i),i=1381,1410)/
     & 36, 93,   2.41E+00,  36, 94,   3.69E+00,  36, 95,   3.59E+00,
     & 36, 96,   3.62E+00,  36, 97,   3.46E+00,  36, 98,   3.49E+00,
     & 36, 99,   3.53E+00,  36,100,   3.62E+00,  36,101,   3.47E+00,
     & 36,102,   3.28E+00,  36,103,   2.88E+00,  36,104,   2.46E+00,
     & 36,105,   2.21E+00,  36,106,   2.02E+00,  36,107,   1.86E+00,
     & 36,108,   2.21E+00,  36,109,   1.98E+00,  36,110,   3.10E+00,
     & 36,111,   3.01E+00,  36,112,   2.97E+00,  36,113,   4.50E-01,
     & 36,114,   2.00E-02,  36,115,  -9.30E-01,  36,116,  -1.69E+00,
     & 36,117,  -4.20E+00,  36,118,  -5.00E+00,  36,119,  -4.69E+00,
     & 36,120,  -3.77E+00,  36,121,  -2.97E+00,  36,122,  -1.88E+00/
      data (nsz(i),nsa(i),shin(i),i=1411,1440)/
     & 36,123,  -1.50E+00,  36,124,  -7.00E-02,  37, 66,   3.25E+00,
     & 37, 67,   3.40E+00,  37, 68,   4.09E+00,  37, 69,   4.18E+00,
     & 37, 70,   4.08E+00,  37, 71,   3.90E+00,  37, 72,   4.26E+00,
     & 37, 73,   3.89E+00,  37, 74,   3.20E+00,  37, 75,   3.91E+00,
     & 37, 76,   3.82E+00,  37, 77,   4.29E+00,  37, 78,   4.55E+00,
     & 37, 79,   4.58E+00,  37, 80,   4.61E+00,  37, 81,   4.31E+00,
     & 37, 82,   4.13E+00,  37, 83,   3.42E+00,  37, 84,   2.54E+00,
     & 37, 85,   1.51E+00,  37, 86,  -1.00E-02,  37, 87,  -1.20E+00,
     & 37, 88,  -8.40E-01,  37, 89,   2.00E-02,  37, 90,   1.00E-01,
     & 37, 91,   9.70E-01,  37, 92,   1.07E+00,  37, 93,   1.90E+00/
      data (nsz(i),nsa(i),shin(i),i=1441,1470)/
     & 37, 94,   2.62E+00,  37, 95,   3.44E+00,  37, 96,   4.11E+00,
     & 37, 97,   4.55E+00,  37, 98,   4.24E+00,  37, 99,   4.61E+00,
     & 37,100,   3.36E+00,  37,101,   3.47E+00,  37,102,   3.31E+00,
     & 37,103,   3.18E+00,  37,104,   2.87E+00,  37,105,   2.46E+00,
     & 37,106,   2.08E+00,  37,107,   2.08E+00,  37,108,   1.73E+00,
     & 37,109,   2.04E+00,  37,110,   2.18E+00,  37,111,   3.19E+00,
     & 37,112,   3.19E+00,  37,113,   1.54E+00,  37,114,   6.00E-01,
     & 37,115,   3.00E-02,  37,116,  -8.80E-01,  37,117,  -1.71E+00,
     & 37,118,  -4.19E+00,  37,119,  -5.13E+00,  37,120,  -4.69E+00,
     & 37,121,  -3.86E+00,  37,122,  -2.92E+00,  37,123,  -2.00E+00/
      data (nsz(i),nsa(i),shin(i),i=1471,1500)/
     & 37,124,  -1.37E+00,  37,125,  -5.00E-02,  37,126,   1.30E+00,
     & 37,127,   1.22E+00,  37,128,   1.09E+00,  38, 68,   2.95E+00,
     & 38, 69,   3.68E+00,  38, 70,   3.79E+00,  38, 71,   4.23E+00,
     & 38, 72,   3.94E+00,  38, 73,   4.00E+00,  38, 74,   3.46E+00,
     & 38, 75,   3.28E+00,  38, 76,   2.92E+00,  38, 77,   3.45E+00,
     & 38, 78,   2.98E+00,  38, 79,   3.35E+00,  38, 80,   4.13E+00,
     & 38, 81,   4.44E+00,  38, 82,   3.80E+00,  38, 83,   3.74E+00,
     & 38, 84,   2.94E+00,  38, 85,   2.44E+00,  38, 86,   1.26E+00,
     & 38, 87,   1.20E-01,  38, 88,  -1.44E+00,  38, 89,  -1.20E+00,
     & 38, 90,  -1.50E-01,  38, 91,   1.00E-02,  38, 92,   8.50E-01/
      data (nsz(i),nsa(i),shin(i),i=1501,1530)/
     & 38, 93,   8.70E-01,  38, 94,   1.67E+00,  38, 95,   2.11E+00,
     & 38, 96,   3.16E+00,  38, 97,   3.43E+00,  38, 98,   4.10E+00,
     & 38, 99,   4.04E+00,  38,100,   3.79E+00,  38,101,   3.12E+00,
     & 38,102,   3.22E+00,  38,103,   3.07E+00,  38,104,   2.97E+00,
     & 38,105,   2.61E+00,  38,106,   2.29E+00,  38,107,   1.97E+00,
     & 38,108,   1.97E+00,  38,109,   1.85E+00,  38,110,   2.35E+00,
     & 38,111,   2.32E+00,  38,112,   3.09E+00,  38,113,   1.93E+00,
     & 38,114,   1.27E+00,  38,115,   3.40E-01,  38,116,  -9.00E-02,
     & 38,117,  -1.00E+00,  38,118,  -1.76E+00,  38,119,  -4.34E+00,
     & 38,120,  -5.18E+00,  38,121,  -4.67E+00,  38,122,  -3.74E+00/
      data (nsz(i),nsa(i),shin(i),i=1531,1560)/
     & 38,123,  -3.14E+00,  38,124,  -1.97E+00,  38,125,  -1.45E+00,
     & 38,126,   4.80E-01,  38,127,   1.45E+00,  38,128,   1.37E+00,
     & 38,129,   1.60E+00,  38,130,   1.58E+00,  38,131,   1.32E+00,
     & 39, 70,   3.67E+00,  39, 71,   3.88E+00,  39, 72,   4.14E+00,
     & 39, 73,   4.05E+00,  39, 74,   4.02E+00,  39, 75,   3.52E+00,
     & 39, 76,   3.28E+00,  39, 77,   2.80E+00,  39, 78,   2.82E+00,
     & 39, 79,   2.75E+00,  39, 80,   3.17E+00,  39, 81,   3.71E+00,
     & 39, 82,   3.94E+00,  39, 83,   3.84E+00,  39, 84,   3.57E+00,
     & 39, 85,   3.16E+00,  39, 86,   2.54E+00,  39, 87,   1.21E+00,
     & 39, 88,  -2.00E-02,  39, 89,  -1.78E+00,  39, 90,  -1.23E+00/
      data (nsz(i),nsa(i),shin(i),i=1561,1590)/
     & 39, 91,  -1.60E-01,  39, 92,   3.00E-02,  39, 93,   8.60E-01,
     & 39, 94,   8.00E-01,  39, 95,   1.56E+00,  39, 96,   1.89E+00,
     & 39, 97,   2.96E+00,  39, 98,   3.79E+00,  39, 99,   4.37E+00,
     & 39,100,   3.63E+00,  39,101,   3.12E+00,  39,102,   3.09E+00,
     & 39,103,   3.19E+00,  39,104,   3.03E+00,  39,105,   2.96E+00,
     & 39,106,   2.61E+00,  39,107,   2.33E+00,  39,108,   1.96E+00,
     & 39,109,   1.95E+00,  39,110,   1.91E+00,  39,111,   2.24E+00,
     & 39,112,   2.69E+00,  39,113,   2.56E+00,  39,114,   2.17E+00,
     & 39,115,   1.51E+00,  39,116,   4.40E-01,  39,117,  -5.00E-02,
     & 39,118,  -9.60E-01,  39,119,  -1.42E+00,  39,120,  -3.89E+00/
      data (nsz(i),nsa(i),shin(i),i=1591,1620)/
     & 39,121,  -5.05E+00,  39,122,  -4.43E+00,  39,123,  -3.51E+00,
     & 39,124,  -2.83E+00,  39,125,  -1.66E+00,  39,126,  -1.05E+00,
     & 39,127,   5.00E-01,  39,128,   1.47E+00,  39,129,   1.59E+00,
     & 39,130,   1.50E+00,  39,131,   1.71E+00,  39,132,   1.37E+00,
     & 39,133,   1.65E+00,  39,134,   1.56E+00,  40, 72,   3.74E+00,
     & 40, 73,   4.13E+00,  40, 74,   3.95E+00,  40, 75,   3.92E+00,
     & 40, 76,   3.55E+00,  40, 77,   3.29E+00,  40, 78,   2.84E+00,
     & 40, 79,   2.77E+00,  40, 80,   2.71E+00,  40, 81,   2.41E+00,
     & 40, 82,   2.88E+00,  40, 83,   3.22E+00,  40, 84,   4.00E+00,
     & 40, 85,   3.27E+00,  40, 86,   2.42E+00,  40, 87,   2.11E+00/
      data (nsz(i),nsa(i),shin(i),i=1621,1650)/
     & 40, 88,   1.08E+00,  40, 89,   6.00E-02,  40, 90,  -1.38E+00,
     & 40, 91,  -1.00E+00,  40, 92,   1.60E-01,  40, 93,   3.20E-01,
     & 40, 94,   1.22E+00,  40, 95,   1.00E+00,  40, 96,   1.61E+00,
     & 40, 97,   1.68E+00,  40, 98,   3.12E+00,  40, 99,   3.62E+00,
     & 40,100,   4.00E+00,  40,101,   3.68E+00,  40,102,   3.98E+00,
     & 40,103,   3.31E+00,  40,104,   3.28E+00,  40,105,   3.16E+00,
     & 40,106,   3.14E+00,  40,107,   2.77E+00,  40,108,   2.52E+00,
     & 40,109,   2.11E+00,  40,110,   2.17E+00,  40,111,   2.09E+00,
     & 40,112,   2.36E+00,  40,113,   2.83E+00,  40,114,   2.41E+00,
     & 40,115,   1.72E+00,  40,116,   1.16E+00,  40,117,   1.40E-01/
      data (nsz(i),nsa(i),shin(i),i=1651,1680)/
     & 40,118,  -4.20E-01,  40,119,  -1.34E+00,  40,120,  -1.77E+00,
     & 40,121,  -4.20E+00,  40,122,  -5.38E+00,  40,123,  -4.71E+00,
     & 40,124,  -3.78E+00,  40,125,  -3.05E+00,  40,126,  -1.91E+00,
     & 40,127,  -8.40E-01,  40,128,   7.80E-01,  40,129,   1.48E+00,
     & 40,130,   1.82E+00,  40,131,   1.49E+00,  40,132,   1.84E+00,
     & 40,133,   1.63E+00,  40,134,   1.84E+00,  40,135,   1.80E+00,
     & 40,136,   2.00E+00,  40,137,   1.75E+00,  41, 74,   4.07E+00,
     & 41, 75,   4.44E+00,  41, 76,   4.45E+00,  41, 77,   3.99E+00,
     & 41, 78,   3.79E+00,  41, 79,   3.20E+00,  41, 80,   3.09E+00,
     & 41, 81,   3.03E+00,  41, 82,   3.36E+00,  41, 83,   1.94E+00/
      data (nsz(i),nsa(i),shin(i),i=1681,1710)/
     & 41, 84,   5.03E+00,  41, 85,   2.37E+00,  41, 86,   3.52E+00,
     & 41, 87,   2.22E+00,  41, 88,   1.67E+00,  41, 89,   1.04E+00,
     & 41, 90,  -3.40E-01,  41, 91,  -1.36E+00,  41, 92,  -8.60E-01,
     & 41, 93,   2.60E-01,  41, 94,   7.10E-01,  41, 95,   1.49E+00,
     & 41, 96,   1.61E+00,  41, 97,   2.14E+00,  41, 98,   2.55E+00,
     & 41, 99,   3.65E+00,  41,100,   3.79E+00,  41,101,   4.13E+00,
     & 41,102,   3.89E+00,  41,103,   3.68E+00,  41,104,   3.45E+00,
     & 41,105,   3.05E+00,  41,106,   3.38E+00,  41,107,   3.38E+00,
     & 41,108,   3.14E+00,  41,109,   2.89E+00,  41,110,   2.49E+00,
     & 41,111,   2.49E+00,  41,112,   2.39E+00,  41,113,   3.19E+00/
      data (nsz(i),nsa(i),shin(i),i=1711,1740)/
     & 41,114,   2.94E+00,  41,115,   2.52E+00,  41,116,   1.72E+00,
     & 41,117,   1.16E+00,  41,118,   1.60E-01,  41,119,  -3.90E-01,
     & 41,120,  -1.37E+00,  41,121,  -1.71E+00,  41,122,  -4.47E+00,
     & 41,123,  -5.32E+00,  41,124,  -4.74E+00,  41,125,  -3.81E+00,
     & 41,126,  -3.01E+00,  41,127,  -2.02E+00,  41,128,  -5.80E-01,
     & 41,129,   7.90E-01,  41,130,   1.43E+00,  41,131,   1.79E+00,
     & 41,132,   1.58E+00,  41,133,   1.86E+00,  41,134,   1.72E+00,
     & 41,135,   1.95E+00,  41,136,   1.87E+00,  41,137,   2.06E+00,
     & 41,138,   1.82E+00,  41,139,   1.88E+00,  41,140,   1.47E+00,
     & 42, 77,   4.05E+00,  42, 78,   4.37E+00,  42, 79,   4.79E+00/
      data (nsz(i),nsa(i),shin(i),i=1741,1770)/
     & 42, 80,   3.30E+00,  42, 81,   3.28E+00,  42, 82,   4.12E+00,
     & 42, 83,   4.06E+00,  42, 84,   4.84E+00,  42, 85,   4.61E+00,
     & 42, 86,   3.59E+00,  42, 87,   1.84E+00,  42, 88,   1.99E+00,
     & 42, 89,   1.33E+00,  42, 90,   4.00E-01,  42, 91,  -4.40E-01,
     & 42, 92,  -1.61E+00,  42, 93,  -1.14E+00,  42, 94,  -7.00E-02,
     & 42, 95,   3.90E-01,  42, 96,   1.28E+00,  42, 97,   1.62E+00,
     & 42, 98,   2.34E+00,  42, 99,   2.95E+00,  42,100,   3.39E+00,
     & 42,101,   3.94E+00,  42,102,   3.94E+00,  42,103,   3.96E+00,
     & 42,104,   3.95E+00,  42,105,   3.74E+00,  42,106,   3.75E+00,
     & 42,107,   3.37E+00,  42,108,   3.71E+00,  42,109,   3.45E+00/
      data (nsz(i),nsa(i),shin(i),i=1771,1800)/
     & 42,110,   3.19E+00,  42,111,   2.82E+00,  42,112,   2.83E+00,
     & 42,113,   3.39E+00,  42,114,   3.08E+00,  42,115,   2.53E+00,
     & 42,116,   2.10E+00,  42,117,   1.32E+00,  42,118,   8.10E-01,
     & 42,119,  -2.00E-01,  42,120,  -7.50E-01,  42,121,  -1.78E+00,
     & 42,122,  -2.14E+00,  42,123,  -4.86E+00,  42,124,  -5.93E+00,
     & 42,125,  -5.33E+00,  42,126,  -4.25E+00,  42,127,  -3.50E+00,
     & 42,128,  -2.32E+00,  42,129,  -4.10E-01,  42,130,   5.00E-01,
     & 42,131,   1.15E+00,  42,132,   1.63E+00,  42,133,   1.59E+00,
     & 42,134,   1.91E+00,  42,135,   1.81E+00,  42,136,   2.10E+00,
     & 42,137,   2.05E+00,  42,138,   2.24E+00,  42,139,   2.06E+00/
      data (nsz(i),nsa(i),shin(i),i=1801,1830)/
     & 42,140,   2.18E+00,  42,141,   1.80E+00,  42,142,   1.74E+00,
     & 42,143,   1.06E+00,  42,144,   8.00E-01,  43, 79,   4.12E+00,
     & 43, 80,   4.41E+00,  43, 81,   4.18E+00,  43, 82,   4.31E+00,
     & 43, 83,   3.76E+00,  43, 84,   3.66E+00,  43, 85,   4.52E+00,
     & 43, 86,   4.27E+00,  43, 87,   3.24E+00,  43, 88,   2.76E+00,
     & 43, 89,   1.62E+00,  43, 90,   8.40E-01,  43, 91,   3.00E-02,
     & 43, 92,  -9.20E-01,  43, 93,  -1.99E+00,  43, 94,  -1.29E+00,
     & 43, 95,  -3.20E-01,  43, 96,   4.20E-01,  43, 97,   1.13E+00,
     & 43, 98,   1.78E+00,  43, 99,   2.32E+00,  43,100,   2.84E+00,
     & 43,101,   3.30E+00,  43,102,   3.68E+00,  43,103,   3.83E+00/
      data (nsz(i),nsa(i),shin(i),i=1831,1860)/
     & 43,104,   3.97E+00,  43,105,   3.77E+00,  43,106,   3.77E+00,
     & 43,107,   3.51E+00,  43,108,   3.63E+00,  43,109,   3.50E+00,
     & 43,110,   4.35E+00,  43,111,   4.02E+00,  43,112,   3.69E+00,
     & 43,113,   3.42E+00,  43,114,   3.17E+00,  43,115,   2.87E+00,
     & 43,116,   2.36E+00,  43,117,   1.97E+00,  43,118,   1.15E+00,
     & 43,119,   6.30E-01,  43,120,  -3.20E-01,  43,121,  -9.10E-01,
     & 43,122,  -1.89E+00,  43,123,  -2.27E+00,  43,124,  -4.99E+00,
     & 43,125,  -6.09E+00,  43,126,  -5.46E+00,  43,127,  -4.38E+00,
     & 43,128,  -3.57E+00,  43,129,  -2.13E+00,  43,130,  -5.90E-01,
     & 43,131,   3.10E-01,  43,132,   9.60E-01,  43,133,   1.56E+00/
      data (nsz(i),nsa(i),shin(i),i=1861,1890)/
     & 43,134,   1.55E+00,  43,135,   1.74E+00,  43,136,   1.81E+00,
     & 43,137,   2.08E+00,  43,138,   2.04E+00,  43,139,   2.14E+00,
     & 43,140,   2.03E+00,  43,141,   2.22E+00,  43,142,   1.84E+00,
     & 43,143,   1.76E+00,  43,144,   1.17E+00,  43,145,   1.01E+00,
     & 43,146,   8.30E-01,  43,147,   1.44E+00,  44, 81,   4.02E+00,
     & 44, 82,   3.80E+00,  44, 83,   5.23E+00,  44, 84,   4.74E+00,
     & 44, 85,   4.64E+00,  44, 86,   3.77E+00,  44, 87,   3.52E+00,
     & 44, 88,   2.49E+00,  44, 89,   1.98E+00,  44, 90,   8.50E-01,
     & 44, 91,   8.00E-02,  44, 92,  -1.20E+00,  44, 93,  -1.61E+00,
     & 44, 94,  -2.52E+00,  44, 95,  -2.00E+00,  44, 96,  -1.00E+00/
      data (nsz(i),nsa(i),shin(i),i=1891,1920)/
     & 44, 97,  -3.60E-01,  44, 98,   4.20E-01,  44, 99,   1.02E+00,
     & 44,100,   1.61E+00,  44,101,   2.23E+00,  44,102,   2.61E+00,
     & 44,103,   3.19E+00,  44,104,   3.26E+00,  44,105,   3.58E+00,
     & 44,106,   3.49E+00,  44,107,   3.52E+00,  44,108,   3.52E+00,
     & 44,109,   3.41E+00,  44,110,   4.20E+00,  44,111,   3.93E+00,
     & 44,112,   3.60E+00,  44,113,   3.28E+00,  44,114,   3.01E+00,
     & 44,115,   2.77E+00,  44,116,   2.49E+00,  44,117,   1.99E+00,
     & 44,118,   1.55E+00,  44,119,   7.80E-01,  44,120,   2.40E-01,
     & 44,121,  -7.90E-01,  44,122,  -1.36E+00,  44,123,  -2.39E+00,
     & 44,124,  -3.65E+00,  44,125,  -5.79E+00,  44,126,  -6.88E+00/
      data (nsz(i),nsa(i),shin(i),i=1921,1950)/
     & 44,127,  -6.19E+00,  44,128,  -5.09E+00,  44,129,  -4.27E+00,
     & 44,130,  -3.11E+00,  44,131,  -1.36E+00,  44,132,  -2.00E-01,
     & 44,133,   4.40E-01,  44,134,   1.24E+00,  44,135,   1.36E+00,
     & 44,136,   1.65E+00,  44,137,   1.73E+00,  44,138,   2.03E+00,
     & 44,139,   1.98E+00,  44,140,   2.15E+00,  44,141,   2.01E+00,
     & 44,142,   2.18E+00,  44,143,   1.90E+00,  44,144,   1.89E+00,
     & 44,145,   1.43E+00,  44,146,   1.28E+00,  44,147,   1.17E+00,
     & 44,148,   1.62E+00,  44,149,   1.71E+00,  44,150,   1.92E+00,
     & 45, 83,   3.33E+00,  45, 84,   4.34E+00,  45, 85,   3.89E+00,
     & 45, 86,   3.90E+00,  45, 87,   3.00E+00,  45, 88,   2.78E+00/
      data (nsz(i),nsa(i),shin(i),i=1951,1980)/
     & 45, 89,   1.71E+00,  45, 90,   1.24E+00,  45, 91,   9.00E-02,
     & 45, 92,  -6.00E-01,  45, 93,  -1.86E+00,  45, 94,  -2.43E+00,
     & 45, 95,  -3.29E+00,  45, 96,  -2.39E+00,  45, 97,  -1.58E+00,
     & 45, 98,  -7.10E-01,  45, 99,  -3.00E-02,  45,100,   6.50E-01,
     & 45,101,   1.16E+00,  45,102,   1.83E+00,  45,103,   2.30E+00,
     & 45,104,   2.84E+00,  45,105,   2.97E+00,  45,106,   3.33E+00,
     & 45,107,   3.26E+00,  45,108,   3.43E+00,  45,109,   3.28E+00,
     & 45,110,   3.11E+00,  45,111,   3.86E+00,  45,112,   3.60E+00,
     & 45,113,   3.28E+00,  45,114,   2.98E+00,  45,115,   2.70E+00,
     & 45,116,   2.49E+00,  45,117,   2.17E+00,  45,118,   1.72E+00/
      data (nsz(i),nsa(i),shin(i),i=1981,2010)/
     & 45,119,   1.29E+00,  45,120,   5.10E-01,  45,121,  -1.00E-01,
     & 45,122,  -1.09E+00,  45,123,  -1.74E+00,  45,124,  -2.74E+00,
     & 45,125,  -4.01E+00,  45,126,  -6.12E+00,  45,127,  -7.27E+00,
     & 45,128,  -6.47E+00,  45,129,  -5.44E+00,  45,130,  -4.60E+00,
     & 45,131,  -2.93E+00,  45,132,  -1.62E+00,  45,133,  -5.20E-01,
     & 45,134,   1.80E-01,  45,135,   9.30E-01,  45,136,   1.25E+00,
     & 45,137,   1.48E+00,  45,138,   1.48E+00,  45,139,   1.86E+00,
     & 45,140,   1.84E+00,  45,141,   1.95E+00,  45,142,   1.84E+00,
     & 45,143,   2.01E+00,  45,144,   1.66E+00,  45,145,   1.70E+00,
     & 45,146,   1.32E+00,  45,147,   1.26E+00,  45,148,   1.16E+00/
      data (nsz(i),nsa(i),shin(i),i=2011,2040)/
     & 45,149,   1.67E+00,  45,150,   1.62E+00,  45,151,   1.84E+00,
     & 45,152,   1.55E+00,  45,153,   1.51E+00,  46, 86,   3.13E+00,
     & 46, 87,   3.13E+00,  46, 88,   2.26E+00,  46, 89,   2.04E+00,
     & 46, 90,   9.60E-01,  46, 91,   4.80E-01,  46, 92,  -7.00E-01,
     & 46, 93,  -1.43E+00,  46, 94,  -2.87E+00,  46, 95,  -3.48E+00,
     & 46, 96,  -4.11E+00,  46, 97,  -3.40E+00,  46, 98,  -2.36E+00,
     & 46, 99,  -1.66E+00,  46,100,  -9.10E-01,  46,101,  -2.10E-01,
     & 46,102,   3.60E-01,  46,103,   1.04E+00,  46,104,   1.53E+00,
     & 46,105,   2.10E+00,  46,106,   2.36E+00,  46,107,   2.89E+00,
     & 46,108,   2.88E+00,  46,109,   3.22E+00,  46,110,   3.04E+00/
      data (nsz(i),nsa(i),shin(i),i=2041,2070)/
     & 46,111,   3.24E+00,  46,112,   2.95E+00,  46,113,   2.96E+00,
     & 46,114,   2.66E+00,  46,115,   2.68E+00,  46,116,   1.85E+00,
     & 46,117,   2.17E+00,  46,118,   1.27E+00,  46,119,   1.36E+00,
     & 46,120,   7.80E-01,  46,121,   4.00E-02,  46,122,  -5.80E-01,
     & 46,123,  -1.46E+00,  46,124,  -2.46E+00,  46,125,  -3.84E+00,
     & 46,126,  -5.26E+00,  46,127,  -6.98E+00,  46,128,  -7.97E+00,
     & 46,129,  -7.36E+00,  46,130,  -6.32E+00,  46,131,  -5.39E+00,
     & 46,132,  -4.21E+00,  46,133,  -2.42E+00,  46,134,  -1.18E+00,
     & 46,135,  -3.10E-01,  46,136,   3.80E-01,  46,137,   8.90E-01,
     & 46,138,   1.23E+00,  46,139,   1.25E+00,  46,140,   1.53E+00/
      data (nsz(i),nsa(i),shin(i),i=2071,2100)/
     & 46,141,   1.60E+00,  46,142,   1.81E+00,  46,143,   1.74E+00,
     & 46,144,   1.93E+00,  46,145,   1.66E+00,  46,146,   1.74E+00,
     & 46,147,   1.47E+00,  46,148,   1.47E+00,  46,149,   1.35E+00,
     & 46,150,   1.74E+00,  46,151,   1.70E+00,  46,152,   1.94E+00,
     & 46,153,   1.66E+00,  46,154,   1.59E+00,  46,155,   1.12E+00,
     & 46,156,   9.00E-01,  47, 88,   2.03E+00,  47, 89,   1.12E+00,
     & 47, 90,   9.10E-01,  47, 91,  -1.70E-01,  47, 92,  -5.70E-01,
     & 47, 93,  -1.78E+00,  47, 94,  -2.52E+00,  47, 95,  -3.82E+00,
     & 47, 96,  -4.55E+00,  47, 97,  -5.67E+00,  47, 98,  -4.81E+00,
     & 47, 99,  -3.25E+00,  47,100,  -2.32E+00,  47,101,  -1.40E+00/
      data (nsz(i),nsa(i),shin(i),i=2101,2130)/
     & 47,102,  -6.60E-01,  47,103,  -1.50E-01,  47,104,   5.00E-01,
     & 47,105,   1.05E+00,  47,106,   1.51E+00,  47,107,   1.92E+00,
     & 47,108,   2.42E+00,  47,109,   2.57E+00,  47,110,   2.96E+00,
     & 47,111,   2.87E+00,  47,112,   3.03E+00,  47,113,   2.73E+00,
     & 47,114,   2.85E+00,  47,115,   2.44E+00,  47,116,   2.17E+00,
     & 47,117,   1.76E+00,  47,118,   1.43E+00,  47,119,   1.08E+00,
     & 47,120,   5.10E-01,  47,121,  -1.30E-01,  47,122,  -5.00E-02,
     & 47,123,  -1.23E+00,  47,124,  -2.15E+00,  47,125,  -3.45E+00,
     & 47,126,  -4.71E+00,  47,127,  -6.00E+00,  47,128,  -7.69E+00,
     & 47,129,  -8.72E+00,  47,130,  -8.06E+00,  47,131,  -7.00E+00/
      data (nsz(i),nsa(i),shin(i),i=2131,2160)/
     & 47,132,  -6.05E+00,  47,133,  -4.91E+00,  47,134,  -2.94E+00,
     & 47,135,  -1.98E+00,  47,136,  -8.80E-01,  47,137,  -2.40E-01,
     & 47,138,   5.40E-01,  47,139,   1.01E+00,  47,140,   1.04E+00,
     & 47,141,   1.28E+00,  47,142,   1.40E+00,  47,143,   1.64E+00,
     & 47,144,   1.57E+00,  47,145,   1.75E+00,  47,146,   1.52E+00,
     & 47,147,   1.57E+00,  47,148,   1.35E+00,  47,149,   1.38E+00,
     & 47,150,   1.21E+00,  47,151,   1.50E+00,  47,152,   1.53E+00,
     & 47,153,   1.71E+00,  47,154,   1.42E+00,  47,155,   1.30E+00,
     & 47,156,   8.30E-01,  47,157,   5.90E-01,  47,158,  -1.40E-01,
     & 47,159,  -4.80E-01,  47,160,  -9.10E-01,  48, 90,   1.90E-01/
      data (nsz(i),nsa(i),shin(i),i=2161,2190)/
     & 48, 91,  -4.00E-02,  48, 92,  -1.13E+00,  48, 93,  -1.61E+00,
     & 48, 94,  -2.81E+00,  48, 95,  -3.54E+00,  48, 96,  -5.00E+00,
     & 48, 97,  -5.64E+00,  48, 98,  -7.05E+00,  48, 99,  -5.83E+00,
     & 48,100,  -4.23E+00,  48,101,  -3.10E+00,  48,102,  -2.56E+00,
     & 48,103,  -1.63E+00,  48,104,  -1.01E+00,  48,105,  -2.80E-01,
     & 48,106,   1.80E-01,  48,107,   7.70E-01,  48,108,   1.11E+00,
     & 48,109,   1.68E+00,  48,110,   1.80E+00,  48,111,   2.14E+00,
     & 48,112,   2.17E+00,  48,113,   2.38E+00,  48,114,   2.20E+00,
     & 48,115,   2.28E+00,  48,116,   1.90E+00,  48,117,   1.84E+00,
     & 48,118,   1.28E+00,  48,119,   1.21E+00,  48,120,   4.10E-01/
      data (nsz(i),nsa(i),shin(i),i=2191,2220)/
     & 48,121,   1.30E-01,  48,122,  -4.90E-01,  48,123,  -1.20E+00,
     & 48,124,  -2.27E+00,  48,125,  -3.04E+00,  48,126,  -4.15E+00,
     & 48,127,  -4.89E+00,  48,128,  -6.15E+00,  48,129,  -8.83E+00,
     & 48,130,  -9.85E+00,  48,131,  -9.15E+00,  48,132,  -8.06E+00,
     & 48,133,  -7.02E+00,  48,134,  -5.78E+00,  48,135,  -4.78E+00,
     & 48,136,  -3.72E+00,  48,137,  -2.01E+00,  48,138,  -1.08E+00,
     & 48,139,   1.50E-01,  48,140,   7.40E-01,  48,141,   8.00E-01,
     & 48,142,   1.05E+00,  48,143,   1.23E+00,  48,144,   1.50E+00,
     & 48,145,   1.48E+00,  48,146,   1.68E+00,  48,147,   1.47E+00,
     & 48,148,   1.55E+00,  48,149,   1.31E+00,  48,150,   1.43E+00/
      data (nsz(i),nsa(i),shin(i),i=2221,2250)/
     & 48,151,   1.21E+00,  48,152,   1.52E+00,  48,153,   1.49E+00,
     & 48,154,   1.73E+00,  48,155,   1.48E+00,  48,156,   1.36E+00,
     & 48,157,   8.50E-01,  48,158,   6.50E-01,  48,159,  -2.00E-02,
     & 48,160,  -2.90E-01,  48,161,  -7.70E-01,  48,162,  -6.80E-01,
     & 48,163,  -1.54E+00,  49, 92,  -1.60E+00,  49, 93,  -2.75E+00,
     & 49, 94,  -3.23E+00,  49, 95,  -4.44E+00,  49, 96,  -5.18E+00,
     & 49, 97,  -6.53E+00,  49, 98,  -7.33E+00,  49, 99,  -8.69E+00,
     & 49,100,  -7.48E+00,  49,101,  -6.49E+00,  49,102,  -5.25E+00,
     & 49,103,  -3.22E+00,  49,104,  -2.19E+00,  49,105,  -1.51E+00,
     & 49,106,  -8.10E-01,  49,107,  -3.80E-01,  49,108,   2.30E-01/
      data (nsz(i),nsa(i),shin(i),i=2251,2280)/
     & 49,109,   5.70E-01,  49,110,   1.12E+00,  49,111,   1.28E+00,
     & 49,112,   1.60E+00,  49,113,   1.71E+00,  49,114,   1.87E+00,
     & 49,115,   1.80E+00,  49,116,   1.91E+00,  49,117,   1.57E+00,
     & 49,118,   1.57E+00,  49,119,   9.00E-01,  49,120,   7.00E-01,
     & 49,121,  -7.00E-02,  49,122,  -4.80E-01,  49,123,  -1.48E+00,
     & 49,124,  -2.05E+00,  49,125,  -3.24E+00,  49,126,  -4.12E+00,
     & 49,127,  -5.32E+00,  49,128,  -6.63E+00,  49,129,  -7.69E+00,
     & 49,130,  -8.95E+00,  49,131,  -1.01E+01,  49,132,  -9.62E+00,
     & 49,133,  -8.92E+00,  49,134,  -7.74E+00,  49,135,  -6.55E+00,
     & 49,136,  -5.45E+00,  49,137,  -4.32E+00,  49,138,  -2.73E+00/
      data (nsz(i),nsa(i),shin(i),i=2281,2310)/
     & 49,139,  -2.00E+00,  49,140,  -1.03E+00,  49,141,   3.50E-01,
     & 49,142,   4.90E-01,  49,143,   8.60E-01,  49,144,   1.11E+00,
     & 49,145,   1.33E+00,  49,146,   1.35E+00,  49,147,   1.59E+00,
     & 49,148,   1.39E+00,  49,149,   1.50E+00,  49,150,   1.26E+00,
     & 49,151,   1.39E+00,  49,152,   1.26E+00,  49,153,   1.53E+00,
     & 49,154,   1.38E+00,  49,155,   1.46E+00,  49,156,   1.24E+00,
     & 49,157,   1.20E+00,  49,158,   7.70E-01,  49,159,   5.30E-01,
     & 49,160,   1.80E-01,  49,161,   9.00E-02,  49,162,  -3.90E-01,
     & 49,163,  -8.60E-01,  49,164,  -1.67E+00,  49,165,  -2.00E+00,
     & 49,166,  -2.88E+00,  50, 94,  -4.15E+00,  50, 95,  -4.62E+00/
      data (nsz(i),nsa(i),shin(i),i=2311,2340)/
     & 50, 96,  -5.86E+00,  50, 97,  -6.61E+00,  50, 98,  -8.04E+00,
     & 50, 99,  -8.63E+00,  50,100,  -1.00E+01,  50,101,  -9.02E+00,
     & 50,102,  -8.09E+00,  50,103,  -6.67E+00,  50,104,  -4.03E+00,
     & 50,105,  -3.04E+00,  50,106,  -2.46E+00,  50,107,  -2.25E+00,
     & 50,108,  -9.80E-01,  50,109,  -3.40E-01,  50,110,  -1.10E-01,
     & 50,111,   4.30E-01,  50,112,   4.90E-01,  50,113,   8.70E-01,
     & 50,114,   8.00E-01,  50,115,   8.00E-01,  50,116,   8.80E-01,
     & 50,117,   9.30E-01,  50,118,   6.90E-01,  50,119,   6.70E-01,
     & 50,120,   1.20E-01,  50,121,  -8.00E-02,  50,122,  -8.50E-01,
     & 50,123,  -1.31E+00,  50,124,  -2.24E+00,  50,125,  -2.93E+00/
      data (nsz(i),nsa(i),shin(i),i=2341,2370)/
     & 50,126,  -4.03E+00,  50,127,  -4.99E+00,  50,128,  -6.23E+00,
     & 50,129,  -7.40E+00,  50,130,  -8.75E+00,  50,131,  -1.03E+01,
     & 50,132,  -1.18E+01,  50,133,  -1.10E+01,  50,134,  -9.67E+00,
     & 50,135,  -8.51E+00,  50,136,  -7.23E+00,  50,137,  -6.18E+00,
     & 50,138,  -5.08E+00,  50,139,  -4.06E+00,  50,140,  -3.12E+00,
     & 50,141,  -1.76E+00,  50,142,  -1.01E+00,  50,143,   2.40E-01,
     & 50,144,   5.40E-01,  50,145,   8.10E-01,  50,146,   1.14E+00,
     & 50,147,   1.19E+00,  50,148,   1.53E+00,  50,149,   1.34E+00,
     & 50,150,   1.48E+00,  50,151,   1.28E+00,  50,152,   1.42E+00,
     & 50,153,   1.27E+00,  50,154,   1.58E+00,  50,155,   1.50E+00/
      data (nsz(i),nsa(i),shin(i),i=2371,2400)/
     & 50,156,   1.63E+00,  50,157,   1.44E+00,  50,158,   1.58E+00,
     & 50,159,   1.11E+00,  50,160,   9.10E-01,  50,161,   6.30E-01,
     & 50,162,   3.20E-01,  50,163,  -2.40E-01,  50,164,  -5.70E-01,
     & 50,165,  -1.30E+00,  50,166,  -1.87E+00,  50,167,  -2.76E+00,
     & 50,168,  -3.27E+00,  50,169,  -4.25E+00,  51, 97,  -4.11E+00,
     & 51, 98,  -4.82E+00,  51, 99,  -6.10E+00,  51,100,  -6.83E+00,
     & 51,101,  -8.22E+00,  51,102,  -7.10E+00,  51,103,  -6.18E+00,
     & 51,104,  -4.94E+00,  51,105,  -3.83E+00,  51,106,  -2.88E+00,
     & 51,107,  -1.94E+00,  51,108,  -1.11E+00,  51,109,  -6.70E-01,
     & 51,110,   1.70E-01,  51,111,   7.30E-01,  51,112,   8.60E-01/
      data (nsz(i),nsa(i),shin(i),i=2401,2430)/
     & 51,113,   9.40E-01,  51,114,   1.41E+00,  51,115,   1.37E+00,
     & 51,116,   1.69E+00,  51,117,   1.56E+00,  51,118,   1.78E+00,
     & 51,119,   1.43E+00,  51,120,   1.53E+00,  51,121,   9.40E-01,
     & 51,122,   7.50E-01,  51,123,  -8.00E-02,  51,124,  -4.30E-01,
     & 51,125,  -1.50E+00,  51,126,  -2.05E+00,  51,127,  -3.26E+00,
     & 51,128,  -4.02E+00,  51,129,  -5.37E+00,  51,130,  -6.36E+00,
     & 51,131,  -7.82E+00,  51,132,  -9.29E+00,  51,133,  -1.07E+01,
     & 51,134,  -9.76E+00,  51,135,  -8.04E+00,  51,136,  -7.72E+00,
     & 51,137,  -6.47E+00,  51,138,  -4.71E+00,  51,139,  -3.84E+00,
     & 51,140,  -2.89E+00,  51,141,  -2.12E+00,  51,142,  -7.70E-01/
      data (nsz(i),nsa(i),shin(i),i=2431,2460)/
     & 51,143,  -3.20E-01,  51,144,   4.00E-02,  51,145,   3.80E-01,
     & 51,146,   5.00E-01,  51,147,   7.80E-01,  51,148,   9.10E-01,
     & 51,149,   1.16E+00,  51,150,   1.09E+00,  51,151,   1.28E+00,
     & 51,152,   1.11E+00,  51,153,   1.28E+00,  51,154,   1.12E+00,
     & 51,155,   1.42E+00,  51,156,   1.32E+00,  51,157,   1.50E+00,
     & 51,158,   1.37E+00,  51,159,   1.52E+00,  51,160,   1.11E+00,
     & 51,161,   1.09E+00,  51,162,   7.40E-01,  51,163,   5.20E-01,
     & 51,164,  -4.00E-02,  51,165,  -4.60E-01,  51,166,  -1.11E+00,
     & 51,167,  -1.76E+00,  51,168,  -2.53E+00,  51,169,  -3.03E+00,
     & 51,170,  -3.72E+00,  51,171,  -3.97E+00,  51,172,  -5.17E+00/
      data (nsz(i),nsa(i),shin(i),i=2461,2490)/
     & 52, 99,  -3.73E+00,  52,100,  -5.26E+00,  52,101,  -5.64E+00,
     & 52,102,  -7.11E+00,  52,103,  -5.89E+00,  52,104,  -5.03E+00,
     & 52,105,  -3.72E+00,  52,106,  -3.01E+00,  52,107,  -1.94E+00,
     & 52,108,  -1.30E+00,  52,109,  -4.00E-01,  52,110,  -1.80E-01,
     & 52,111,   7.40E-01,  52,112,   1.25E+00,  52,113,   1.67E+00,
     & 52,114,   2.04E+00,  52,115,   2.01E+00,  52,116,   2.02E+00,
     & 52,117,   2.46E+00,  52,118,   2.27E+00,  52,119,   2.43E+00,
     & 52,120,   2.00E+00,  52,121,   1.99E+00,  52,122,   1.47E+00,
     & 52,123,   1.23E+00,  52,124,   5.90E-01,  52,125,   2.20E-01,
     & 52,126,  -6.20E-01,  52,127,  -1.17E+00,  52,128,  -2.15E+00/
      data (nsz(i),nsa(i),shin(i),i=2491,2520)/
     & 52,129,  -2.93E+00,  52,130,  -4.02E+00,  52,131,  -5.08E+00,
     & 52,132,  -6.27E+00,  52,133,  -7.63E+00,  52,134,  -8.69E+00,
     & 52,135,  -8.12E+00,  52,136,  -6.71E+00,  52,137,  -6.19E+00,
     & 52,138,  -5.39E+00,  52,139,  -3.82E+00,  52,140,  -2.87E+00,
     & 52,141,  -1.87E+00,  52,142,  -1.27E+00,  52,143,  -7.70E-01,
     & 52,144,  -4.00E-01,  52,145,  -1.20E-01,  52,146,   2.50E-01,
     & 52,147,   3.70E-01,  52,148,   6.60E-01,  52,149,   7.10E-01,
     & 52,150,   9.90E-01,  52,151,   9.90E-01,  52,152,   1.22E+00,
     & 52,153,   1.04E+00,  52,154,   1.20E+00,  52,155,   9.30E-01,
     & 52,156,   1.29E+00,  52,157,   1.24E+00,  52,158,   1.50E+00/
      data (nsz(i),nsa(i),shin(i),i=2521,2550)/
     & 52,159,   1.38E+00,  52,160,   1.58E+00,  52,161,   1.24E+00,
     & 52,162,   1.28E+00,  52,163,   8.20E-01,  52,164,   7.20E-01,
     & 52,165,   3.10E-01,  52,166,  -5.00E-02,  52,167,  -7.40E-01,
     & 52,168,  -1.03E+00,  52,169,  -2.12E+00,  52,170,  -2.52E+00,
     & 52,171,  -3.05E+00,  52,172,  -3.76E+00,  52,173,  -4.64E+00,
     & 52,174,  -5.54E+00,  52,175,  -7.05E+00,  52,176,  -8.02E+00,
     & 53,101,  -3.74E+00,  53,102,  -4.31E+00,  53,103,  -5.30E+00,
     & 53,104,  -4.60E+00,  53,105,  -3.89E+00,  53,106,  -2.67E+00,
     & 53,107,  -1.91E+00,  53,108,  -1.15E+00,  53,109,  -7.00E-01,
     & 53,110,   1.90E-01,  53,111,   8.00E-01,  53,112,   1.22E+00/
      data (nsz(i),nsa(i),shin(i),i=2551,2580)/
     & 53,113,   1.47E+00,  53,114,   1.88E+00,  53,115,   2.28E+00,
     & 53,116,   2.43E+00,  53,117,   2.56E+00,  53,118,   2.58E+00,
     & 53,119,   2.64E+00,  53,120,   3.00E+00,  53,121,   2.38E+00,
     & 53,122,   2.38E+00,  53,123,   1.85E+00,  53,124,   1.68E+00,
     & 53,125,   1.01E+00,  53,126,   7.10E-01,  53,127,  -8.00E-02,
     & 53,128,  -5.40E-01,  53,129,  -1.49E+00,  53,130,  -2.09E+00,
     & 53,131,  -3.28E+00,  53,132,  -4.13E+00,  53,133,  -5.41E+00,
     & 53,134,  -6.55E+00,  53,135,  -7.89E+00,  53,136,  -7.07E+00,
     & 53,137,  -5.93E+00,  53,138,  -5.53E+00,  53,139,  -4.42E+00,
     & 53,140,  -2.97E+00,  53,141,  -2.22E+00,  53,142,  -1.46E+00/
      data (nsz(i),nsa(i),shin(i),i=2581,2610)/
     & 53,143,  -9.60E-01,  53,144,  -4.80E-01,  53,145,  -1.10E-01,
     & 53,146,   5.00E-02,  53,147,   4.30E-01,  53,148,   5.10E-01,
     & 53,149,   7.80E-01,  53,150,   8.80E-01,  53,151,   1.10E+00,
     & 53,152,   9.70E-01,  53,153,   1.20E+00,  53,154,   9.90E-01,
     & 53,155,   1.16E+00,  53,156,   8.10E-01,  53,157,   1.15E+00,
     & 53,158,   1.15E+00,  53,159,   1.39E+00,  53,160,   1.28E+00,
     & 53,161,   1.43E+00,  53,162,   1.17E+00,  53,163,   1.16E+00,
     & 53,164,   8.30E-01,  53,165,   9.00E-01,  53,166,   4.60E-01,
     & 53,167,   2.40E-01,  53,168,  -5.10E-01,  53,169,  -7.30E-01,
     & 53,170,  -1.44E+00,  53,171,  -2.17E+00,  53,172,  -2.70E+00/
      data (nsz(i),nsa(i),shin(i),i=2611,2640)/
     & 53,173,  -3.21E+00,  53,174,  -4.09E+00,  53,175,  -4.84E+00,
     & 53,176,  -6.42E+00,  53,177,  -7.36E+00,  53,178,  -8.95E+00,
     & 53,179,  -9.69E+00,  54,103,  -3.14E+00,  54,104,  -4.22E+00,
     & 54,105,  -3.40E+00,  54,106,  -2.73E+00,  54,107,  -1.83E+00,
     & 54,108,  -1.15E+00,  54,109,  -4.70E-01,  54,110,   1.20E-01,
     & 54,111,   7.80E-01,  54,112,   7.60E-01,  54,113,   1.57E+00,
     & 54,114,   1.89E+00,  54,115,   2.07E+00,  54,116,   2.38E+00,
     & 54,117,   2.56E+00,  54,118,   2.69E+00,  54,119,   2.99E+00,
     & 54,120,   3.04E+00,  54,121,   2.81E+00,  54,122,   2.85E+00,
     & 54,123,   2.49E+00,  54,124,   2.05E+00,  54,125,   1.89E+00/
      data (nsz(i),nsa(i),shin(i),i=2641,2670)/
     & 54,126,   1.34E+00,  54,127,   1.05E+00,  54,128,   4.20E-01,
     & 54,129,  -3.00E-02,  54,130,  -8.00E-01,  54,131,  -1.43E+00,
     & 54,132,  -2.34E+00,  54,133,  -3.24E+00,  54,134,  -4.22E+00,
     & 54,135,  -5.54E+00,  54,136,  -6.41E+00,  54,137,  -5.72E+00,
     & 54,138,  -4.80E+00,  54,139,  -4.13E+00,  54,140,  -3.18E+00,
     & 54,141,  -2.63E+00,  54,142,  -1.94E+00,  54,143,  -1.23E+00,
     & 54,144,  -6.20E-01,  54,145,  -1.80E-01,  54,146,   2.00E-02,
     & 54,147,   9.00E-02,  54,148,   4.40E-01,  54,149,   5.50E-01,
     & 54,150,   8.80E-01,  54,151,   8.40E-01,  54,152,   1.09E+00,
     & 54,153,   9.20E-01,  54,154,   1.05E+00,  54,155,   7.40E-01/
      data (nsz(i),nsa(i),shin(i),i=2671,2700)/
     & 54,156,   8.80E-01,  54,157,   7.00E-01,  54,158,   1.07E+00,
     & 54,159,   1.06E+00,  54,160,   1.37E+00,  54,161,   1.26E+00,
     & 54,162,   1.44E+00,  54,163,   1.22E+00,  54,164,   1.29E+00,
     & 54,165,   1.01E+00,  54,166,   9.60E-01,  54,167,   5.80E-01,
     & 54,168,   5.60E-01,  54,169,  -2.00E-02,  54,170,  -3.80E-01,
     & 54,171,  -9.00E-01,  54,172,  -1.31E+00,  54,173,  -2.09E+00,
     & 54,174,  -2.49E+00,  54,175,  -3.42E+00,  54,176,  -4.24E+00,
     & 54,177,  -5.64E+00,  54,178,  -6.49E+00,  54,179,  -8.19E+00,
     & 54,180,  -8.73E+00,  54,181,  -7.95E+00,  54,182,  -6.62E+00,
     & 55,106,  -2.31E+00,  55,107,  -1.80E+00,  55,108,  -1.10E+00/
      data (nsz(i),nsa(i),shin(i),i=2701,2730)/
     & 55,109,  -5.10E-01,  55,110,  -2.70E-01,  55,111,   1.60E-01,
     & 55,112,   8.40E-01,  55,113,   1.13E+00,  55,114,   1.70E+00,
     & 55,115,   1.80E+00,  55,116,   2.28E+00,  55,117,   2.79E+00,
     & 55,118,   3.08E+00,  55,119,   2.96E+00,  55,120,   3.07E+00,
     & 55,121,   3.02E+00,  55,122,   3.09E+00,  55,123,   2.79E+00,
     & 55,124,   2.66E+00,  55,125,   2.35E+00,  55,126,   2.11E+00,
     & 55,127,   1.74E+00,  55,128,   1.54E+00,  55,129,   9.70E-01,
     & 55,130,   6.20E-01,  55,131,  -9.00E-02,  55,132,  -6.70E-01,
     & 55,133,  -1.55E+00,  55,134,  -2.32E+00,  55,135,  -3.49E+00,
     & 55,136,  -4.55E+00,  55,137,  -5.62E+00,  55,138,  -4.74E+00/
      data (nsz(i),nsa(i),shin(i),i=2731,2760)/
     & 55,139,  -3.84E+00,  55,140,  -3.37E+00,  55,141,  -2.47E+00,
     & 55,142,  -2.10E+00,  55,143,  -1.38E+00,  55,144,  -9.30E-01,
     & 55,145,  -2.20E-01,  55,146,   1.00E-02,  55,147,   6.10E-01,
     & 55,148,   7.20E-01,  55,149,   6.50E-01,  55,150,   6.80E-01,
     & 55,151,   1.00E+00,  55,152,   8.60E-01,  55,153,   1.06E+00,
     & 55,154,   9.20E-01,  55,155,   9.80E-01,  55,156,   6.40E-01,
     & 55,157,   7.60E-01,  55,158,   5.80E-01,  55,159,   9.50E-01,
     & 55,160,   1.02E+00,  55,161,   1.27E+00,  55,162,   1.20E+00,
     & 55,163,   1.40E+00,  55,164,   1.22E+00,  55,165,   1.33E+00,
     & 55,166,   1.09E+00,  55,167,   9.90E-01,  55,168,   7.00E-01/
      data (nsz(i),nsa(i),shin(i),i=2761,2790)/
     & 55,169,   6.50E-01,  55,170,   1.60E-01,  55,171,  -6.00E-02,
     & 55,172,  -7.70E-01,  55,173,  -1.09E+00,  55,174,  -1.99E+00,
     & 55,175,  -2.01E+00,  55,176,  -2.92E+00,  55,177,  -3.71E+00,
     & 55,178,  -5.11E+00,  55,179,  -5.97E+00,  55,180,  -7.59E+00,
     & 55,181,  -8.24E+00,  55,182,  -7.40E+00,  55,183,  -6.22E+00,
     & 55,184,  -5.24E+00,  55,185,  -4.18E+00,  56,108,  -1.04E+00,
     & 56,109,  -3.80E-01,  56,110,  -1.40E-01,  56,111,   2.60E-01,
     & 56,112,   9.30E-01,  56,113,   1.47E+00,  56,114,   1.65E+00,
     & 56,115,   1.82E+00,  56,116,   1.77E+00,  56,117,   1.97E+00,
     & 56,118,   2.22E+00,  56,119,   2.41E+00,  56,120,   2.60E+00/
      data (nsz(i),nsa(i),shin(i),i=2791,2820)/
     & 56,121,   2.66E+00,  56,122,   2.65E+00,  56,123,   2.57E+00,
     & 56,124,   2.51E+00,  56,125,   2.87E+00,  56,126,   2.33E+00,
     & 56,127,   2.42E+00,  56,128,   1.90E+00,  56,129,   1.88E+00,
     & 56,130,   1.29E+00,  56,131,   9.50E-01,  56,132,   3.30E-01,
     & 56,133,  -1.90E-01,  56,134,  -9.50E-01,  56,135,  -1.71E+00,
     & 56,136,  -2.58E+00,  56,137,  -3.70E+00,  56,138,  -4.53E+00,
     & 56,139,  -3.88E+00,  56,140,  -2.95E+00,  56,141,  -2.52E+00,
     & 56,142,  -1.77E+00,  56,143,  -1.39E+00,  56,144,  -7.70E-01,
     & 56,145,  -9.20E-01,  56,146,   2.30E-01,  56,147,  -4.00E-01,
     & 56,148,   3.50E-01,  56,149,   2.70E-01,  56,150,   5.80E-01/
      data (nsz(i),nsa(i),shin(i),i=2821,2850)/
     & 56,151,   5.30E-01,  56,152,   8.70E-01,  56,153,   7.60E-01,
     & 56,154,   9.60E-01,  56,155,   7.70E-01,  56,156,   8.70E-01,
     & 56,157,   5.10E-01,  56,158,   5.80E-01,  56,159,   4.60E-01,
     & 56,160,   8.20E-01,  56,161,   8.60E-01,  56,162,   1.16E+00,
     & 56,163,   1.12E+00,  56,164,   1.37E+00,  56,165,   1.19E+00,
     & 56,166,   1.38E+00,  56,167,   1.14E+00,  56,168,   1.17E+00,
     & 56,169,   7.20E-01,  56,170,   8.00E-01,  56,171,   3.40E-01,
     & 56,172,   1.90E-01,  56,173,  -5.90E-01,  56,174,  -7.20E-01,
     & 56,175,  -1.55E+00,  56,176,  -1.47E+00,  56,177,  -2.52E+00,
     & 56,178,  -3.07E+00,  56,179,  -4.45E+00,  56,180,  -5.26E+00/
      data (nsz(i),nsa(i),shin(i),i=2851,2880)/
     & 56,181,  -6.97E+00,  56,182,  -7.39E+00,  56,183,  -6.59E+00,
     & 56,184,  -5.59E+00,  56,185,  -4.57E+00,  56,186,  -3.37E+00,
     & 56,187,  -3.32E+00,  56,188,  -2.75E+00,  56,189,  -3.04E+00,
     & 57,110,   6.00E-02,  57,111,   3.10E-01,  57,112,   8.60E-01,
     & 57,113,   9.40E-01,  57,114,   1.25E+00,  57,115,   1.43E+00,
     & 57,116,   1.44E+00,  57,117,   1.34E+00,  57,118,   1.54E+00,
     & 57,119,   1.76E+00,  57,120,   2.06E+00,  57,121,   2.28E+00,
     & 57,122,   2.35E+00,  57,123,   2.38E+00,  57,124,   2.37E+00,
     & 57,125,   2.36E+00,  57,126,   2.26E+00,  57,127,   2.33E+00,
     & 57,128,   2.56E+00,  57,129,   2.27E+00,  57,130,   2.17E+00/
      data (nsz(i),nsa(i),shin(i),i=2881,2910)/
     & 57,131,   1.80E+00,  57,132,   1.49E+00,  57,133,   1.36E+00,
     & 57,134,   3.90E-01,  57,135,  -3.10E-01,  57,136,  -9.40E-01,
     & 57,137,  -1.79E+00,  57,138,  -2.90E+00,  57,139,  -3.82E+00,
     & 57,140,  -3.05E+00,  57,141,  -2.34E+00,  57,142,  -1.94E+00,
     & 57,143,  -1.16E+00,  57,144,  -8.50E-01,  57,145,  -3.90E-01,
     & 57,146,   1.40E-01,  57,147,   2.50E-01,  57,148,  -1.00E-02,
     & 57,149,   3.20E-01,  57,150,   1.50E-01,  57,151,   4.30E-01,
     & 57,152,   3.70E-01,  57,153,   6.70E-01,  57,154,   5.60E-01,
     & 57,155,   7.90E-01,  57,156,   6.30E-01,  57,157,   7.40E-01,
     & 57,158,   3.80E-01,  57,159,   4.20E-01,  57,160,   3.80E-01/
      data (nsz(i),nsa(i),shin(i),i=2911,2940)/
     & 57,161,   7.50E-01,  57,162,   8.40E-01,  57,163,   1.19E+00,
     & 57,164,   1.15E+00,  57,165,   1.42E+00,  57,166,   1.36E+00,
     & 57,167,   1.52E+00,  57,168,   1.26E+00,  57,169,   1.29E+00,
     & 57,170,   8.40E-01,  57,171,   9.20E-01,  57,172,   5.00E-01,
     & 57,173,   3.70E-01,  57,174,  -3.80E-01,  57,175,  -5.00E-01,
     & 57,176,  -1.26E+00,  57,177,  -9.50E-01,  57,178,  -2.11E+00,
     & 57,179,  -2.65E+00,  57,180,  -4.07E+00,  57,181,  -4.82E+00,
     & 57,182,  -6.41E+00,  57,183,  -6.92E+00,  57,184,  -6.32E+00,
     & 57,185,  -5.13E+00,  57,186,  -4.07E+00,  57,187,  -2.98E+00,
     & 57,188,  -2.99E+00,  57,189,  -2.37E+00,  57,190,  -2.55E+00/
      data (nsz(i),nsa(i),shin(i),i=2941,2970)/
     & 57,191,  -1.95E+00,  57,192,  -2.08E+00,  58,113,   1.04E+00,
     & 58,114,   1.32E+00,  58,115,   1.40E+00,  58,116,   1.28E+00,
     & 58,117,   1.19E+00,  58,118,   1.05E+00,  58,119,   1.17E+00,
     & 58,120,   1.36E+00,  58,121,   1.60E+00,  58,122,   1.83E+00,
     & 58,123,   1.95E+00,  58,124,   2.06E+00,  58,125,   2.07E+00,
     & 58,126,   2.14E+00,  58,127,   2.10E+00,  58,128,   2.24E+00,
     & 58,129,   2.22E+00,  58,130,   2.32E+00,  58,131,   2.34E+00,
     & 58,132,   2.24E+00,  58,133,   1.96E+00,  58,134,   1.24E+00,
     & 58,135,   6.40E-01,  58,136,   9.00E-02,  58,137,  -4.90E-01,
     & 58,138,  -1.33E+00,  58,139,  -2.36E+00,  58,140,  -3.11E+00/
      data (nsz(i),nsa(i),shin(i),i=2971,3000)/
     & 58,141,  -2.52E+00,  58,142,  -1.69E+00,  58,143,  -1.25E+00,
     & 58,144,  -5.70E-01,  58,145,  -1.10E-01,  58,146,   3.80E-01,
     & 58,147,   6.60E-01,  58,148,   1.12E+00,  58,149,   1.12E+00,
     & 58,150,   1.26E+00,  58,151,   6.00E-02,  58,152,   2.80E-01,
     & 58,153,   1.60E-01,  58,154,   4.00E-01,  58,155,   2.40E-01,
     & 58,156,   4.50E-01,  58,157,   2.90E-01,  58,158,   4.60E-01,
     & 58,159,   1.10E-01,  58,160,   3.00E-01,  58,161,   1.40E-01,
     & 58,162,   6.20E-01,  58,163,   6.70E-01,  58,164,   1.04E+00,
     & 58,165,   1.02E+00,  58,166,   1.34E+00,  58,167,   1.23E+00,
     & 58,168,   1.43E+00,  58,169,   1.27E+00,  58,170,   1.34E+00/
      data (nsz(i),nsa(i),shin(i),i=3001,3030)/
     & 58,171,   8.70E-01,  58,172,   9.60E-01,  58,173,   5.80E-01,
     & 58,174,   5.10E-01,  58,175,  -1.60E-01,  58,176,  -2.30E-01,
     & 58,177,  -6.20E-01,  58,178,  -5.10E-01,  58,179,  -1.57E+00,
     & 58,180,  -2.13E+00,  58,181,  -3.44E+00,  58,182,  -4.29E+00,
     & 58,183,  -5.85E+00,  58,184,  -6.39E+00,  58,185,  -5.61E+00,
     & 58,186,  -4.65E+00,  58,187,  -3.40E+00,  58,188,  -2.42E+00,
     & 58,189,  -2.48E+00,  58,190,  -1.87E+00,  58,191,  -1.97E+00,
     & 58,192,  -9.40E-01,  58,193,  -1.50E+00,  58,194,  -1.52E+00,
     & 58,195,  -1.70E+00,  59,115,   1.03E+00,  59,116,   1.00E+00,
     & 59,117,   7.40E-01,  59,118,   5.90E-01,  59,119,   4.00E-01/
      data (nsz(i),nsa(i),shin(i),i=3031,3060)/
     & 59,120,   4.20E-01,  59,121,   6.10E-01,  59,122,   8.60E-01,
     & 59,123,   1.15E+00,  59,124,   1.32E+00,  59,125,   1.49E+00,
     & 59,126,   1.56E+00,  59,127,   1.66E+00,  59,128,   1.71E+00,
     & 59,129,   1.87E+00,  59,130,   1.97E+00,  59,131,   2.20E+00,
     & 59,132,   2.21E+00,  59,133,   2.26E+00,  59,134,   2.19E+00,
     & 59,135,   1.54E+00,  59,136,   9.70E-01,  59,137,   5.40E-01,
     & 59,138,   3.90E-01,  59,139,  -7.80E-01,  59,140,  -1.70E+00,
     & 59,141,  -2.58E+00,  59,142,  -1.84E+00,  59,143,  -1.12E+00,
     & 59,144,  -7.20E-01,  59,145,  -2.00E-02,  59,146,   5.50E-01,
     & 59,147,   9.90E-01,  59,148,   1.26E+00,  59,149,   1.53E+00/
      data (nsz(i),nsa(i),shin(i),i=3061,3090)/
     & 59,150,   1.43E+00,  59,151,   2.20E-01,  59,152,  -8.00E-02,
     & 59,153,   6.00E-02,  59,154,  -9.00E-02,  59,155,   1.30E-01,
     & 59,156,  -2.00E-02,  59,157,   2.00E-01,  59,158,   6.00E-02,
     & 59,159,   1.20E-01,  59,160,  -1.00E-01,  59,161,   1.20E-01,
     & 59,162,  -2.00E-02,  59,163,   3.50E-01,  59,164,   5.30E-01,
     & 59,165,   8.80E-01,  59,166,   9.10E-01,  59,167,   1.26E+00,
     & 59,168,   1.23E+00,  59,169,   1.47E+00,  59,170,   1.34E+00,
     & 59,171,   1.44E+00,  59,172,   1.11E+00,  59,173,   1.03E+00,
     & 59,174,   6.90E-01,  59,175,   6.50E-01,  59,176,   4.00E-02,
     & 59,177,  -4.00E-02,  59,178,  -4.00E-01,  59,179,  -2.60E-01/
      data (nsz(i),nsa(i),shin(i),i=3091,3120)/
     & 59,180,  -1.25E+00,  59,181,  -1.71E+00,  59,182,  -3.10E+00,
     & 59,183,  -3.91E+00,  59,184,  -5.40E+00,  59,185,  -5.96E+00,
     & 59,186,  -5.20E+00,  59,187,  -4.13E+00,  59,188,  -2.95E+00,
     & 59,189,  -2.14E+00,  59,190,  -2.26E+00,  59,191,  -1.62E+00,
     & 59,192,  -1.20E+00,  59,193,  -6.50E-01,  59,194,  -1.21E+00,
     & 59,195,  -1.15E+00,  59,196,  -1.48E+00,  59,197,  -1.31E+00,
     & 59,198,  -1.58E+00,  60,118,   4.50E-01,  60,119,   2.70E-01,
     & 60,120,   0.00E+00,  60,121,   3.00E-02,  60,122,   2.20E-01,
     & 60,123,   4.80E-01,  60,124,   7.60E-01,  60,125,   9.90E-01,
     & 60,126,   1.18E+00,  60,127,   1.27E+00,  60,128,   1.40E+00/
      data (nsz(i),nsa(i),shin(i),i=3121,3150)/
     & 60,129,   1.44E+00,  60,130,   1.64E+00,  60,131,   1.77E+00,
     & 60,132,   2.03E+00,  60,133,   2.32E+00,  60,134,   2.41E+00,
     & 60,135,   2.30E+00,  60,136,   1.64E+00,  60,137,   1.26E+00,
     & 60,138,   1.50E+00,  60,139,   1.90E-01,  60,140,  -7.30E-01,
     & 60,141,  -1.43E+00,  60,142,  -2.17E+00,  60,143,  -1.63E+00,
     & 60,144,  -8.20E-01,  60,145,  -3.40E-01,  60,146,   2.90E-01,
     & 60,147,   8.20E-01,  60,148,   1.27E+00,  60,149,   1.66E+00,
     & 60,150,   1.67E+00,  60,151,   1.37E+00,  60,152,   1.10E+00,
     & 60,153,  -1.70E-01,  60,154,  -1.30E-01,  60,155,  -3.00E-01,
     & 60,156,  -1.50E-01,  60,157,  -3.30E-01,  60,158,  -1.60E-01/
      data (nsz(i),nsa(i),shin(i),i=3151,3180)/
     & 60,159,  -3.30E-01,  60,160,  -2.40E-01,  60,161,  -5.30E-01,
     & 60,162,  -4.10E-01,  60,163,  -4.90E-01,  60,164,  -2.00E-02,
     & 60,165,   2.00E-01,  60,166,   7.10E-01,  60,167,   7.20E-01,
     & 60,168,   1.08E+00,  60,169,   1.07E+00,  60,170,   1.35E+00,
     & 60,171,   1.20E+00,  60,172,   1.32E+00,  60,173,   1.01E+00,
     & 60,174,   9.90E-01,  60,175,   6.90E-01,  60,176,   6.90E-01,
     & 60,177,   2.90E-01,  60,178,   1.70E-01,  60,179,   3.90E-01,
     & 60,180,   1.00E-02,  60,181,  -8.70E-01,  60,182,  -1.33E+00,
     & 60,183,  -2.69E+00,  60,184,  -3.50E+00,  60,185,  -5.00E+00,
     & 60,186,  -5.48E+00,  60,187,  -4.70E+00,  60,188,  -3.74E+00/
      data (nsz(i),nsa(i),shin(i),i=3181,3210)/
     & 60,189,  -2.56E+00,  60,190,  -1.79E+00,  60,191,  -1.72E+00,
     & 60,192,  -1.03E+00,  60,193,  -6.70E-01,  60,194,  -2.10E-01,
     & 60,195,  -5.60E-01,  60,196,  -5.90E-01,  60,197,  -1.05E+00,
     & 60,198,  -9.00E-01,  60,199,  -1.22E+00,  60,200,  -1.10E+00,
     & 60,201,  -1.51E+00,  61,120,  -2.00E-02,  61,121,  -3.40E-01,
     & 61,122,  -3.60E-01,  61,123,  -1.90E-01,  61,124,   7.00E-02,
     & 61,125,   3.50E-01,  61,126,   5.60E-01,  61,127,   7.90E-01,
     & 61,128,   9.20E-01,  61,129,   1.07E+00,  61,130,   1.12E+00,
     & 61,131,   1.33E+00,  61,132,   1.41E+00,  61,133,   1.73E+00,
     & 61,134,   1.99E+00,  61,135,   2.30E+00,  61,136,   2.17E+00/
      data (nsz(i),nsa(i),shin(i),i=3211,3240)/
     & 61,137,   2.27E+00,  61,138,   2.12E+00,  61,139,   1.21E+00,
     & 61,140,   4.30E-01,  61,141,  -9.00E-02,  61,142,  -1.10E+00,
     & 61,143,  -1.88E+00,  61,144,  -1.19E+00,  61,145,  -4.00E-01,
     & 61,146,   1.40E-01,  61,147,   7.50E-01,  61,148,   1.22E+00,
     & 61,149,   1.81E+00,  61,150,   2.16E+00,  61,151,   1.75E+00,
     & 61,152,   1.39E+00,  61,153,   9.80E-01,  61,154,   3.70E-01,
     & 61,155,  -2.20E-01,  61,156,  -4.30E-01,  61,157,  -3.60E-01,
     & 61,158,  -5.90E-01,  61,159,  -4.90E-01,  61,160,  -7.10E-01,
     & 61,161,  -6.40E-01,  61,162,  -9.20E-01,  61,163,  -8.00E-01,
     & 61,164,  -8.60E-01,  61,165,  -4.20E-01,  61,166,  -1.70E-01/
      data (nsz(i),nsa(i),shin(i),i=3241,3270)/
     & 61,167,   3.50E-01,  61,168,   5.20E-01,  61,169,   8.70E-01,
     & 61,170,   8.70E-01,  61,171,   1.20E+00,  61,172,   1.15E+00,
     & 61,173,   1.31E+00,  61,174,   1.04E+00,  61,175,   1.04E+00,
     & 61,176,   7.90E-01,  61,177,   7.90E-01,  61,178,   4.90E-01,
     & 61,179,   3.30E-01,  61,180,   5.40E-01,  61,181,   1.80E-01,
     & 61,182,  -7.10E-01,  61,183,  -1.08E+00,  61,184,  -2.32E+00,
     & 61,185,  -3.21E+00,  61,186,  -4.68E+00,  61,187,  -5.16E+00,
     & 61,188,  -4.36E+00,  61,189,  -3.38E+00,  61,190,  -2.45E+00,
     & 61,191,  -1.74E+00,  61,192,  -1.40E+00,  61,193,  -7.50E-01,
     & 61,194,  -3.00E-01,  61,195,   3.00E-02,  61,196,  -4.60E-01/
      data (nsz(i),nsa(i),shin(i),i=3271,3300)/
     & 61,197,  -4.00E-01,  61,198,  -8.40E-01,  61,199,  -7.00E-01,
     & 61,200,  -1.03E+00,  61,201,  -9.50E-01,  61,202,  -1.31E+00,
     & 61,203,  -1.56E+00,  61,204,  -2.11E+00,  61,205,  -2.24E+00,
     & 62,123,  -3.70E-01,  62,124,  -2.00E-01,  62,125,   4.00E-02,
     & 62,126,   3.90E-01,  62,127,   5.70E-01,  62,128,   7.60E-01,
     & 62,129,   9.30E-01,  62,130,   1.03E+00,  62,131,   1.12E+00,
     & 62,132,   1.19E+00,  62,133,   1.38E+00,  62,134,   1.68E+00,
     & 62,135,   1.89E+00,  62,136,   2.15E+00,  62,137,   2.10E+00,
     & 62,138,   2.18E+00,  62,139,   1.85E+00,  62,140,   1.82E+00,
     & 62,141,   7.90E-01,  62,142,  -1.00E-01,  62,143,  -9.60E-01/
      data (nsz(i),nsa(i),shin(i),i=3301,3330)/
     & 62,144,  -1.73E+00,  62,145,  -1.19E+00,  62,146,  -3.20E-01,
     & 62,147,   1.90E-01,  62,148,   8.70E-01,  62,149,   1.44E+00,
     & 62,150,   1.86E+00,  62,151,   2.30E+00,  62,152,   2.03E+00,
     & 62,153,   1.80E+00,  62,154,   1.43E+00,  62,155,   8.90E-01,
     & 62,156,   8.50E-01,  62,157,   2.90E-01,  62,158,  -1.60E-01,
     & 62,159,  -4.80E-01,  62,160,  -4.30E-01,  62,161,  -7.30E-01,
     & 62,162,  -6.70E-01,  62,163,  -9.70E-01,  62,164,  -8.70E-01,
     & 62,165,  -9.30E-01,  62,166,  -3.70E-01,  62,167,  -1.50E-01,
     & 62,168,   2.30E-01,  62,169,   3.00E-01,  62,170,   6.20E-01,
     & 62,171,   6.30E-01,  62,172,   9.60E-01,  62,173,   8.80E-01/
      data (nsz(i),nsa(i),shin(i),i=3331,3360)/
     & 62,174,   1.05E+00,  62,175,   7.90E-01,  62,176,   8.20E-01,
     & 62,177,   5.70E-01,  62,178,   7.00E-01,  62,179,   5.00E-01,
     & 62,180,   3.70E-01,  62,181,   5.60E-01,  62,182,   2.30E-01,
     & 62,183,  -5.30E-01,  62,184,  -9.20E-01,  62,185,  -2.12E+00,
     & 62,186,  -2.95E+00,  62,187,  -4.35E+00,  62,188,  -4.80E+00,
     & 62,189,  -4.00E+00,  62,190,  -3.02E+00,  62,191,  -2.10E+00,
     & 62,192,  -1.38E+00,  62,193,  -9.30E-01,  62,194,  -2.20E-01,
     & 62,195,   1.20E-01,  62,196,   5.10E-01,  62,197,  -2.00E-02,
     & 62,198,  -3.00E-02,  62,199,  -3.40E-01,  62,200,  -2.00E-01,
     & 62,201,  -6.00E-01,  62,202,  -3.90E-01,  62,203,  -8.70E-01/
      data (nsz(i),nsa(i),shin(i),i=3361,3390)/
     & 62,204,  -7.50E-01,  62,205,  -1.71E+00,  62,206,  -1.85E+00,
     & 62,207,  -2.72E+00,  62,208,  -2.77E+00,  63,125,  -1.60E-01,
     & 63,126,   1.70E-01,  63,127,   3.70E-01,  63,128,   4.90E-01,
     & 63,129,   6.20E-01,  63,130,   7.30E-01,  63,131,   7.60E-01,
     & 63,132,   7.80E-01,  63,133,   8.60E-01,  63,134,   1.07E+00,
     & 63,135,   1.37E+00,  63,136,   1.65E+00,  63,137,   1.97E+00,
     & 63,138,   1.93E+00,  63,139,   1.94E+00,  63,140,   2.04E+00,
     & 63,141,   1.51E+00,  63,142,   5.60E-01,  63,143,   1.00E-02,
     & 63,144,  -1.01E+00,  63,145,  -1.61E+00,  63,146,  -9.50E-01,
     & 63,147,  -9.00E-02,  63,148,   5.70E-01,  63,149,   1.19E+00/
      data (nsz(i),nsa(i),shin(i),i=3391,3420)/
     & 63,150,   1.76E+00,  63,151,   2.30E+00,  63,152,   2.56E+00,
     & 63,153,   2.06E+00,  63,154,   1.80E+00,  63,155,   1.30E+00,
     & 63,156,   7.50E-01,  63,157,   5.70E-01,  63,158,   1.80E-01,
     & 63,159,   1.60E-01,  63,160,  -4.20E-01,  63,161,  -4.50E-01,
     & 63,162,  -7.20E-01,  63,163,  -7.20E-01,  63,164,  -1.03E+00,
     & 63,165,  -9.80E-01,  63,166,  -1.09E+00,  63,167,  -7.10E-01,
     & 63,168,  -5.60E-01,  63,169,  -6.00E-02,  63,170,   1.00E-02,
     & 63,171,   3.20E-01,  63,172,   3.40E-01,  63,173,   6.90E-01,
     & 63,174,   6.80E-01,  63,175,   9.20E-01,  63,176,   7.10E-01,
     & 63,177,   7.80E-01,  63,178,   5.00E-01,  63,179,   6.70E-01/
      data (nsz(i),nsa(i),shin(i),i=3421,3450)/
     & 63,180,   4.70E-01,  63,181,   4.40E-01,  63,182,   5.40E-01,
     & 63,183,   2.00E-01,  63,184,  -5.20E-01,  63,185,  -8.40E-01,
     & 63,186,  -1.98E+00,  63,187,  -2.67E+00,  63,188,  -4.15E+00,
     & 63,189,  -4.58E+00,  63,190,  -3.75E+00,  63,191,  -2.76E+00,
     & 63,192,  -2.00E+00,  63,193,  -1.30E+00,  63,194,  -6.00E-01,
     & 63,195,   3.00E-02,  63,196,   4.00E-01,  63,197,   6.80E-01,
     & 63,198,   2.30E-01,  63,199,   2.90E-01,  63,200,  -8.00E-02,
     & 63,201,   7.00E-02,  63,202,  -2.70E-01,  63,203,  -1.90E-01,
     & 63,204,  -6.40E-01,  63,205,  -9.20E-01,  63,206,  -1.48E+00,
     & 63,207,  -1.62E+00,  63,208,  -2.51E+00,  63,209,  -2.69E+00/
      data (nsz(i),nsa(i),shin(i),i=3451,3480)/
     & 63,210,  -3.09E+00,  63,211,  -2.98E+00,  64,128,   6.00E-01,
     & 64,129,   6.50E-01,  64,130,   7.10E-01,  64,131,   7.70E-01,
     & 64,132,   6.70E-01,  64,133,   6.50E-01,  64,134,   7.00E-01,
     & 64,135,   8.90E-01,  64,136,   1.20E+00,  64,137,   1.47E+00,
     & 64,138,   1.58E+00,  64,139,   1.73E+00,  64,140,   1.70E+00,
     & 64,141,   2.55E+00,  64,142,   1.69E+00,  64,143,   1.08E+00,
     & 64,144,   2.00E-01,  64,145,  -8.70E-01,  64,146,  -1.71E+00,
     & 64,147,  -1.11E+00,  64,148,  -1.80E-01,  64,149,   3.80E-01,
     & 64,150,   1.13E+00,  64,151,   1.69E+00,  64,152,   2.11E+00,
     & 64,153,   2.52E+00,  64,154,   2.21E+00,  64,155,   2.02E+00/
      data (nsz(i),nsa(i),shin(i),i=3481,3510)/
     & 64,156,   1.67E+00,  64,157,   1.16E+00,  64,158,   1.01E+00,
     & 64,159,   5.50E-01,  64,160,   5.00E-01,  64,161,  -1.00E-02,
     & 64,162,   1.90E-01,  64,163,  -5.20E-01,  64,164,  -5.60E-01,
     & 64,165,  -9.00E-01,  64,166,  -8.20E-01,  64,167,  -1.00E+00,
     & 64,168,  -6.50E-01,  64,169,  -5.50E-01,  64,170,  -2.80E-01,
     & 64,171,  -3.00E-01,  64,172,  -2.00E-02,  64,173,  -2.00E-02,
     & 64,174,   2.90E-01,  64,175,   2.80E-01,  64,176,   5.20E-01,
     & 64,177,   3.30E-01,  64,178,   4.50E-01,  64,179,   2.30E-01,
     & 64,180,   4.40E-01,  64,181,   2.30E-01,  64,182,   3.40E-01,
     & 64,183,   3.90E-01,  64,184,   7.00E-02,  64,185,  -5.90E-01/
      data (nsz(i),nsa(i),shin(i),i=3511,3540)/
     & 64,186,  -8.60E-01,  64,187,  -1.93E+00,  64,188,  -2.55E+00,
     & 64,189,  -3.98E+00,  64,190,  -4.38E+00,  64,191,  -3.54E+00,
     & 64,192,  -2.55E+00,  64,193,  -1.71E+00,  64,194,  -9.50E-01,
     & 64,195,  -2.90E-01,  64,196,   3.60E-01,  64,197,   6.20E-01,
     & 64,198,   1.05E+00,  64,199,   6.50E-01,  64,200,   6.60E-01,
     & 64,201,   3.60E-01,  64,202,   5.00E-01,  64,203,   1.40E-01,
     & 64,204,   1.90E-01,  64,205,  -2.70E-01,  64,206,  -4.70E-01,
     & 64,207,  -1.05E+00,  64,208,  -1.29E+00,  64,209,  -2.02E+00,
     & 64,210,  -2.12E+00,  64,211,  -2.70E+00,  64,212,  -2.61E+00,
     & 64,213,  -2.84E+00,  64,214,  -2.63E+00,  65,130,   4.50E-01/
      data (nsz(i),nsa(i),shin(i),i=3541,3570)/
     & 65,131,   4.40E-01,  65,132,   4.10E-01,  65,133,   3.00E-01,
     & 65,134,   2.00E-01,  65,135,   2.10E-01,  65,136,   3.90E-01,
     & 65,137,   7.60E-01,  65,138,   1.05E+00,  65,139,   1.36E+00,
     & 65,140,   1.29E+00,  65,141,   1.37E+00,  65,142,   2.30E+00,
     & 65,143,   1.57E+00,  65,144,   1.00E+00,  65,145,  -1.20E-01,
     & 65,146,  -8.30E-01,  65,147,  -1.40E+00,  65,148,  -8.10E-01,
     & 65,149,   2.80E-01,  65,150,   6.30E-01,  65,151,   1.57E+00,
     & 65,152,   1.96E+00,  65,153,   2.43E+00,  65,154,   2.70E+00,
     & 65,155,   2.18E+00,  65,156,   2.04E+00,  65,157,   1.55E+00,
     & 65,158,   1.14E+00,  65,159,   8.60E-01,  65,160,   4.80E-01/
      data (nsz(i),nsa(i),shin(i),i=3571,3600)/
     & 65,161,   2.50E-01,  65,162,  -3.90E-01,  65,163,  -3.90E-01,
     & 65,164,  -5.70E-01,  65,165,  -6.00E-01,  65,166,  -9.40E-01,
     & 65,167,  -9.50E-01,  65,168,  -1.14E+00,  65,169,  -8.70E-01,
     & 65,170,  -8.80E-01,  65,171,  -6.50E-01,  65,172,  -6.70E-01,
     & 65,173,  -4.10E-01,  65,174,  -4.30E-01,  65,175,  -9.00E-02,
     & 65,176,  -6.00E-02,  65,177,   2.80E-01,  65,178,   1.00E-02,
     & 65,179,   1.90E-01,  65,180,  -4.00E-02,  65,181,   2.20E-01,
     & 65,182,   9.00E-02,  65,183,   2.60E-01,  65,184,   2.50E-01,
     & 65,185,  -6.00E-02,  65,186,  -7.10E-01,  65,187,  -9.40E-01,
     & 65,188,  -1.86E+00,  65,189,  -2.44E+00,  65,190,  -3.66E+00/
      data (nsz(i),nsa(i),shin(i),i=3601,3630)/
     & 65,191,  -4.24E+00,  65,192,  -3.26E+00,  65,193,  -2.20E+00,
     & 65,194,  -1.44E+00,  65,195,  -6.30E-01,  65,196,  -1.00E-01,
     & 65,197,   5.20E-01,  65,198,   8.00E-01,  65,199,   3.38E+00,
     & 65,200,   8.20E-01,  65,201,   8.40E-01,  65,202,   5.60E-01,
     & 65,203,   6.50E-01,  65,204,   3.50E-01,  65,205,   3.50E-01,
     & 65,206,  -8.00E-02,  65,207,  -5.00E-02,  65,208,  -8.50E-01,
     & 65,209,  -1.15E+00,  65,210,  -1.81E+00,  65,211,  -1.89E+00,
     & 65,212,  -2.35E+00,  65,213,  -2.28E+00,  65,214,  -2.54E+00,
     & 65,215,  -2.40E+00,  65,216,  -2.92E+00,  65,217,  -2.85E+00,
     & 65,218,  -3.16E+00,  66,133,   1.80E-01,  66,134,   2.00E-02/
      data (nsz(i),nsa(i),shin(i),i=3631,3660)/
     & 66,135,  -5.00E-02,  66,136,  -1.20E-01,  66,137,   5.00E-02,
     & 66,138,   3.90E-01,  66,139,   6.10E-01,  66,140,   8.40E-01,
     & 66,141,   9.70E-01,  66,142,   1.04E+00,  66,143,   2.03E+00,
     & 66,144,   1.25E+00,  66,145,   6.80E-01,  66,146,  -1.00E-02,
     & 66,147,  -1.11E+00,  66,148,  -1.68E+00,  66,149,  -1.32E+00,
     & 66,150,  -4.00E-02,  66,151,   5.70E-01,  66,152,   1.20E+00,
     & 66,153,   1.79E+00,  66,154,   2.09E+00,  66,155,   2.51E+00,
     & 66,156,   2.26E+00,  66,157,   2.13E+00,  66,158,   1.84E+00,
     & 66,159,   1.45E+00,  66,160,   1.24E+00,  66,161,   8.60E-01,
     & 66,162,   6.30E-01,  66,163,   5.00E-02,  66,164,  -1.00E-02/
      data (nsz(i),nsa(i),shin(i),i=3661,3690)/
     & 66,165,  -3.80E-01,  66,166,  -1.80E-01,  66,167,  -6.10E-01,
     & 66,168,  -9.30E-01,  66,169,  -1.22E+00,  66,170,  -9.60E-01,
     & 66,171,  -1.04E+00,  66,172,  -8.60E-01,  66,173,  -9.60E-01,
     & 66,174,  -7.80E-01,  66,175,  -8.00E-01,  66,176,  -5.10E-01,
     & 66,177,  -5.30E-01,  66,178,  -2.70E-01,  66,179,  -4.10E-01,
     & 66,180,  -2.30E-01,  66,181,  -4.10E-01,  66,182,  -1.40E-01,
     & 66,183,  -2.20E-01,  66,184,  -1.00E-02,  66,185,  -4.00E-02,
     & 66,186,  -3.60E-01,  66,187,  -9.30E-01,  66,188,  -1.11E+00,
     & 66,189,  -2.02E+00,  66,190,  -2.55E+00,  66,191,  -3.82E+00,
     & 66,192,  -4.25E+00,  66,193,  -3.26E+00,  66,194,  -2.39E+00/
      data (nsz(i),nsa(i),shin(i),i=3691,3720)/
     & 66,195,  -1.42E+00,  66,196,  -4.10E-01,  66,197,   1.70E-01,
     & 66,198,   7.90E-01,  66,199,   1.08E+00,  66,200,   1.46E+00,
     & 66,201,   1.16E+00,  66,202,   1.18E+00,  66,203,   9.20E-01,
     & 66,204,   1.04E+00,  66,205,   6.90E-01,  66,206,   6.90E-01,
     & 66,207,   3.10E-01,  66,208,   2.90E-01,  66,209,  -2.20E-01,
     & 66,210,  -6.20E-01,  66,211,  -1.29E+00,  66,212,  -1.49E+00,
     & 66,213,  -1.96E+00,  66,214,  -1.86E+00,  66,215,  -2.21E+00,
     & 66,216,  -2.09E+00,  66,217,  -2.65E+00,  66,218,  -2.62E+00,
     & 66,219,  -2.81E+00,  66,220,  -2.59E+00,  66,221,  -2.75E+00,
     & 67,136,  -6.70E-01,  67,137,  -7.60E-01,  67,138,  -5.90E-01/
      data (nsz(i),nsa(i),shin(i),i=3721,3750)/
     & 67,139,  -2.70E-01,  67,140,   1.00E-02,  67,141,   4.10E-01,
     & 67,142,   3.40E-01,  67,143,   5.20E-01,  67,144,   1.67E+00,
     & 67,145,   9.80E-01,  67,146,   4.40E-01,  67,147,  -2.20E-01,
     & 67,148,  -9.20E-01,  67,149,  -2.06E+00,  67,150,  -7.50E-01,
     & 67,151,   1.60E-01,  67,152,   7.30E-01,  67,153,   1.52E+00,
     & 67,154,   2.03E+00,  67,155,   2.25E+00,  67,156,   1.61E+00,
     & 67,157,   2.32E+00,  67,158,   2.30E+00,  67,159,   1.93E+00,
     & 67,160,   1.77E+00,  67,161,   1.31E+00,  67,162,   9.70E-01,
     & 67,163,   6.00E-01,  67,164,   1.20E-01,  67,165,  -2.10E-01,
     & 67,166,  -6.10E-01,  67,167,  -6.00E-01,  67,168,  -1.15E+00/
      data (nsz(i),nsa(i),shin(i),i=3751,3780)/
     & 67,169,  -8.30E-01,  67,170,  -1.19E+00,  67,171,  -1.26E+00,
     & 67,172,  -1.41E+00,  67,173,  -1.31E+00,  67,174,  -1.49E+00,
     & 67,175,  -1.30E+00,  67,176,  -1.32E+00,  67,177,  -1.02E+00,
     & 67,178,  -1.04E+00,  67,179,  -7.10E-01,  67,180,  -8.60E-01,
     & 67,181,  -6.40E-01,  67,182,  -8.00E-01,  67,183,  -5.10E-01,
     & 67,184,  -6.00E-01,  67,185,  -2.20E-01,  67,186,  -3.10E-01,
     & 67,187,  -6.20E-01,  67,188,  -1.10E+00,  67,189,  -1.30E+00,
     & 67,190,  -2.19E+00,  67,191,  -2.69E+00,  67,192,  -3.78E+00,
     & 67,193,  -4.27E+00,  67,194,  -3.28E+00,  67,195,  -2.32E+00,
     & 67,196,  -1.16E+00,  67,197,  -2.40E-01,  67,198,   2.80E-01/
      data (nsz(i),nsa(i),shin(i),i=3781,3810)/
     & 67,199,   8.70E-01,  67,200,   1.17E+00,  67,201,   1.49E+00,
     & 67,202,   1.23E+00,  67,203,   1.29E+00,  67,204,   1.02E+00,
     & 67,205,   1.12E+00,  67,206,   8.00E-01,  67,207,   8.00E-01,
     & 67,208,   4.10E-01,  67,209,   4.90E-01,  67,210,  -1.00E-01,
     & 67,211,  -4.70E-01,  67,212,  -1.13E+00,  67,213,  -1.19E+00,
     & 67,214,  -1.73E+00,  67,215,  -1.74E+00,  67,216,  -2.14E+00,
     & 67,217,  -2.10E+00,  67,218,  -2.68E+00,  67,219,  -2.71E+00,
     & 67,220,  -3.03E+00,  67,221,  -2.73E+00,  67,222,  -2.95E+00,
     & 67,223,  -2.75E+00,  67,224,  -3.09E+00,  68,138,  -1.04E+00,
     & 68,139,  -9.30E-01,  68,140,  -5.20E-01,  68,141,  -3.10E-01/
      data (nsz(i),nsa(i),shin(i),i=3811,3840)/
     & 68,142,   5.00E-02,  68,143,   1.40E-01,  68,144,   3.40E-01,
     & 68,145,   1.38E+00,  68,146,   6.70E-01,  68,147,   1.40E-01,
     & 68,148,  -5.10E-01,  68,149,  -1.16E+00,  68,150,  -2.34E+00,
     & 68,151,  -1.35E+00,  68,152,  -3.50E-01,  68,153,   3.50E-01,
     & 68,154,   9.40E-01,  68,155,   1.56E+00,  68,156,   1.62E+00,
     & 68,157,   2.31E+00,  68,158,   1.78E+00,  68,159,   2.24E+00,
     & 68,160,   2.03E+00,  68,161,   1.85E+00,  68,162,   1.58E+00,
     & 68,163,   1.31E+00,  68,164,   1.02E+00,  68,165,   6.30E-01,
     & 68,166,   3.20E-01,  68,167,  -2.30E-01,  68,168,  -2.10E-01,
     & 68,169,  -6.70E-01,  68,170,  -5.00E-01,  68,171,  -9.70E-01/
      data (nsz(i),nsa(i),shin(i),i=3841,3870)/
     & 68,172,  -7.20E-01,  68,173,  -1.53E+00,  68,174,  -1.47E+00,
     & 68,175,  -1.70E+00,  68,176,  -1.58E+00,  68,177,  -1.66E+00,
     & 68,178,  -1.36E+00,  68,179,  -1.44E+00,  68,180,  -1.16E+00,
     & 68,181,  -1.33E+00,  68,182,  -1.11E+00,  68,183,  -1.24E+00,
     & 68,184,  -9.30E-01,  68,185,  -1.01E+00,  68,186,  -5.90E-01,
     & 68,187,  -7.30E-01,  68,188,  -1.01E+00,  68,189,  -1.46E+00,
     & 68,190,  -1.65E+00,  68,191,  -2.52E+00,  68,192,  -2.99E+00,
     & 68,193,  -4.17E+00,  68,194,  -4.51E+00,  68,195,  -3.49E+00,
     & 68,196,  -2.61E+00,  68,197,  -1.36E+00,  68,198,  -3.80E-01,
     & 68,199,   2.90E-01,  68,200,   9.00E-01,  68,201,   1.21E+00/
      data (nsz(i),nsa(i),shin(i),i=3871,3900)/
     & 68,202,   1.59E+00,  68,203,   1.44E+00,  68,204,   1.54E+00,
     & 68,205,   1.29E+00,  68,206,   1.41E+00,  68,207,   1.13E+00,
     & 68,208,   1.15E+00,  68,209,   7.40E-01,  68,210,   7.90E-01,
     & 68,211,   3.90E-01,  68,212,   2.00E-01,  68,213,  -6.30E-01,
     & 68,214,  -8.20E-01,  68,215,  -1.33E+00,  68,216,  -1.37E+00,
     & 68,217,  -1.83E+00,  68,218,  -1.85E+00,  68,219,  -2.46E+00,
     & 68,220,  -2.51E+00,  68,221,  -2.79E+00,  68,222,  -2.62E+00,
     & 68,223,  -2.89E+00,  68,224,  -2.76E+00,  68,225,  -3.08E+00,
     & 68,226,  -3.03E+00,  68,227,  -3.53E+00,  69,141,  -1.20E+00,
     & 69,142,  -9.10E-01,  69,143,  -4.90E-01,  69,144,  -5.70E-01/
      data (nsz(i),nsa(i),shin(i),i=3901,3930)/
     & 69,145,  -3.40E-01,  69,146,   8.60E-01,  69,147,   1.90E-01,
     & 69,148,  -3.70E-01,  69,149,  -9.90E-01,  69,150,  -1.42E+00,
     & 69,151,  -2.43E+00,  69,152,  -1.48E+00,  69,153,  -6.00E-01,
     & 69,154,   4.50E-01,  69,155,   1.02E+00,  69,156,   1.49E+00,
     & 69,157,   1.43E+00,  69,158,   1.62E+00,  69,159,   1.67E+00,
     & 69,160,   2.21E+00,  69,161,   1.93E+00,  69,162,   1.95E+00,
     & 69,163,   1.70E+00,  69,164,   1.53E+00,  69,165,   1.12E+00,
     & 69,166,   8.60E-01,  69,167,   3.50E-01,  69,168,  -1.00E-01,
     & 69,169,  -2.80E-01,  69,170,  -8.40E-01,  69,171,  -8.50E-01,
     & 69,172,  -1.39E+00,  69,173,  -1.22E+00,  69,174,  -1.54E+00/
      data (nsz(i),nsa(i),shin(i),i=3931,3960)/
     & 69,175,  -1.24E+00,  69,176,  -2.14E+00,  69,177,  -2.01E+00,
     & 69,178,  -2.12E+00,  69,179,  -1.87E+00,  69,180,  -1.93E+00,
     & 69,181,  -1.64E+00,  69,182,  -1.80E+00,  69,183,  -1.56E+00,
     & 69,184,  -1.68E+00,  69,185,  -1.40E+00,  69,186,  -1.44E+00,
     & 69,187,  -9.90E-01,  69,188,  -1.06E+00,  69,189,  -1.37E+00,
     & 69,190,  -1.79E+00,  69,191,  -1.94E+00,  69,192,  -2.82E+00,
     & 69,193,  -3.25E+00,  69,194,  -4.40E+00,  69,195,  -4.78E+00,
     & 69,196,  -3.68E+00,  69,197,  -2.81E+00,  69,198,  -1.49E+00,
     & 69,199,  -3.30E-01,  69,200,   8.00E-02,  69,201,   7.60E-01,
     & 69,202,   1.13E+00,  69,203,   1.54E+00,  69,204,   1.44E+00/
      data (nsz(i),nsa(i),shin(i),i=3961,3990)/
     & 69,205,   1.58E+00,  69,206,   1.33E+00,  69,207,   1.45E+00,
     & 69,208,   1.17E+00,  69,209,   1.19E+00,  69,210,   7.80E-01,
     & 69,211,   8.40E-01,  69,212,   3.70E-01,  69,213,   1.80E-01,
     & 69,214,  -2.90E-01,  69,215,  -6.80E-01,  69,216,  -1.32E+00,
     & 69,217,  -1.31E+00,  69,218,  -1.78E+00,  69,219,  -1.81E+00,
     & 69,220,  -2.42E+00,  69,221,  -2.47E+00,  69,222,  -2.80E+00,
     & 69,223,  -2.65E+00,  69,224,  -2.98E+00,  69,225,  -2.86E+00,
     & 69,226,  -3.25E+00,  69,227,  -3.23E+00,  69,228,  -3.73E+00,
     & 69,229,  -3.82E+00,  69,230,  -4.38E+00,  70,143,  -1.19E+00,
     & 70,144,  -7.90E-01,  70,145,  -8.00E-01,  70,146,   9.60E-01/
      data (nsz(i),nsa(i),shin(i),i=3991,4020)/
     & 70,147,   4.70E-01,  70,148,  -2.50E-01,  70,149,  -7.80E-01,
     & 70,150,  -1.46E+00,  70,151,  -1.87E+00,  70,152,  -2.92E+00,
     & 70,153,  -1.92E+00,  70,154,  -1.04E+00,  70,155,   1.20E-01,
     & 70,156,   2.60E-01,  70,157,   9.80E-01,  70,158,   1.23E+00,
     & 70,159,   1.65E+00,  70,160,   1.75E+00,  70,161,   1.84E+00,
     & 70,162,   1.82E+00,  70,163,   1.94E+00,  70,164,   1.47E+00,
     & 70,165,   1.72E+00,  70,166,   1.36E+00,  70,167,   1.10E+00,
     & 70,168,   7.70E-01,  70,169,   3.60E-01,  70,170,   2.30E-01,
     & 70,171,  -2.90E-01,  70,172,  -3.40E-01,  70,173,  -9.70E-01,
     & 70,174,  -8.10E-01,  70,175,  -1.23E+00,  70,176,  -8.20E-01/
      data (nsz(i),nsa(i),shin(i),i=4021,4050)/
     & 70,177,  -1.32E+00,  70,178,  -1.16E+00,  70,179,  -2.26E+00,
     & 70,180,  -2.06E+00,  70,181,  -2.18E+00,  70,182,  -2.01E+00,
     & 70,183,  -2.06E+00,  70,184,  -1.95E+00,  70,185,  -2.13E+00,
     & 70,186,  -1.78E+00,  70,187,  -1.85E+00,  70,188,  -1.46E+00,
     & 70,189,  -1.46E+00,  70,190,  -1.78E+00,  70,191,  -2.22E+00,
     & 70,192,  -2.39E+00,  70,193,  -3.30E+00,  70,194,  -3.73E+00,
     & 70,195,  -4.88E+00,  70,196,  -5.19E+00,  70,197,  -4.26E+00,
     & 70,198,  -3.25E+00,  70,199,  -1.80E+00,  70,200,  -6.80E-01,
     & 70,201,  -1.40E-01,  70,202,   6.10E-01,  70,203,   8.90E-01,
     & 70,204,   1.52E+00,  70,205,   1.54E+00,  70,206,   1.74E+00/
      data (nsz(i),nsa(i),shin(i),i=4051,4080)/
     & 70,207,   1.52E+00,  70,208,   1.65E+00,  70,209,   1.39E+00,
     & 70,210,   1.42E+00,  70,211,   1.08E+00,  70,212,   1.11E+00,
     & 70,213,   6.50E-01,  70,214,   6.20E-01,  70,215,   2.00E-02,
     & 70,216,  -3.30E-01,  70,217,  -8.40E-01,  70,218,  -9.20E-01,
     & 70,219,  -1.45E+00,  70,220,  -1.49E+00,  70,221,  -2.11E+00,
     & 70,222,  -2.15E+00,  70,223,  -2.47E+00,  70,224,  -2.32E+00,
     & 70,225,  -2.66E+00,  70,226,  -2.60E+00,  70,227,  -3.05E+00,
     & 70,228,  -3.05E+00,  70,229,  -3.67E+00,  70,230,  -3.83E+00,
     & 70,231,  -4.45E+00,  70,232,  -4.58E+00,  70,233,  -4.76E+00,
     & 70,234,  -4.40E+00,  71,146,  -1.17E+00,  71,147,   3.60E-01/
      data (nsz(i),nsa(i),shin(i),i=4081,4110)/
     & 71,148,  -8.00E-02,  71,149,  -8.00E-01,  71,150,  -1.27E+00,
     & 71,151,  -1.88E+00,  71,152,  -2.28E+00,  71,153,  -3.30E+00,
     & 71,154,  -2.32E+00,  71,155,  -1.42E+00,  71,156,  -3.50E-01,
     & 71,157,   1.60E-01,  71,158,   7.70E-01,  71,159,   1.23E+00,
     & 71,160,   1.32E+00,  71,161,   1.50E+00,  71,162,   1.65E+00,
     & 71,163,   1.89E+00,  71,164,   1.65E+00,  71,165,   1.97E+00,
     & 71,166,   1.76E+00,  71,167,   1.51E+00,  71,168,   1.14E+00,
     & 71,169,   8.70E-01,  71,170,   5.10E-01,  71,171,   3.20E-01,
     & 71,172,  -9.00E-02,  71,173,  -2.80E-01,  71,174,  -8.20E-01,
     & 71,175,  -8.00E-01,  71,176,  -1.22E+00,  71,177,  -9.70E-01/
      data (nsz(i),nsa(i),shin(i),i=4111,4140)/
     & 71,178,  -1.46E+00,  71,179,  -1.30E+00,  71,180,  -1.71E+00,
     & 71,181,  -2.30E+00,  71,182,  -2.48E+00,  71,183,  -2.24E+00,
     & 71,184,  -2.58E+00,  71,185,  -2.33E+00,  71,186,  -2.56E+00,
     & 71,187,  -2.29E+00,  71,188,  -2.39E+00,  71,189,  -1.99E+00,
     & 71,190,  -1.83E+00,  71,191,  -2.16E+00,  71,192,  -2.62E+00,
     & 71,193,  -2.81E+00,  71,194,  -3.74E+00,  71,195,  -4.14E+00,
     & 71,196,  -5.22E+00,  71,197,  -5.49E+00,  71,198,  -4.66E+00,
     & 71,199,  -3.64E+00,  71,200,  -2.24E+00,  71,201,  -1.01E+00,
     & 71,202,  -4.50E-01,  71,203,   3.30E-01,  71,204,   6.70E-01,
     & 71,205,   1.30E+00,  71,206,   1.36E+00,  71,207,   1.63E+00/
      data (nsz(i),nsa(i),shin(i),i=4141,4170)/
     & 71,208,   1.50E+00,  71,209,   1.59E+00,  71,210,   1.33E+00,
     & 71,211,   1.38E+00,  71,212,   1.06E+00,  71,213,   1.05E+00,
     & 71,214,   6.40E-01,  71,215,   6.00E-01,  71,216,   4.00E-02,
     & 71,217,  -2.00E-02,  71,218,  -5.20E-01,  71,219,  -9.40E-01,
     & 71,220,  -1.42E+00,  71,221,  -1.49E+00,  71,222,  -2.11E+00,
     & 71,223,  -2.18E+00,  71,224,  -2.49E+00,  71,225,  -2.39E+00,
     & 71,226,  -2.72E+00,  71,227,  -2.65E+00,  71,228,  -3.11E+00,
     & 71,229,  -3.17E+00,  71,230,  -3.81E+00,  71,231,  -4.02E+00,
     & 71,232,  -4.69E+00,  71,233,  -4.85E+00,  71,234,  -4.99E+00,
     & 71,235,  -4.81E+00,  71,236,  -4.94E+00,  71,237,  -4.73E+00/
      data (nsz(i),nsa(i),shin(i),i=4171,4200)/
     & 72,149,  -3.30E-01,  72,150,  -1.14E+00,  72,151,  -1.64E+00,
     & 72,152,  -2.33E+00,  72,153,  -2.82E+00,  72,154,  -3.98E+00,
     & 72,155,  -2.88E+00,  72,156,  -2.02E+00,  72,157,  -9.60E-01,
     & 72,158,  -1.00E-01,  72,159,   2.80E-01,  72,160,   3.90E-01,
     & 72,161,   1.13E+00,  72,162,   1.16E+00,  72,163,   1.58E+00,
     & 72,164,   1.72E+00,  72,165,   1.74E+00,  72,166,   1.68E+00,
     & 72,167,   1.47E+00,  72,168,   1.27E+00,  72,169,   1.31E+00,
     & 72,170,   7.60E-01,  72,171,   4.20E-01,  72,172,   7.00E-01,
     & 72,173,  -1.70E-01,  72,174,   2.50E-01,  72,175,  -1.90E-01,
     & 72,176,  -2.00E-01,  72,177,  -6.50E-01,  72,178,  -4.80E-01/
      data (nsz(i),nsa(i),shin(i),i=4201,4230)/
     & 72,179,  -9.70E-01,  72,180,  -9.10E-01,  72,181,  -1.33E+00,
     & 72,182,  -9.20E-01,  72,183,  -1.25E+00,  72,184,  -7.30E-01,
     & 72,185,  -2.38E+00,  72,186,  -2.42E+00,  72,187,  -2.67E+00,
     & 72,188,  -2.47E+00,  72,189,  -2.52E+00,  72,190,  -2.46E+00,
     & 72,191,  -2.25E+00,  72,192,  -2.60E+00,  72,193,  -3.12E+00,
     & 72,194,  -3.48E+00,  72,195,  -4.33E+00,  72,196,  -4.76E+00,
     & 72,197,  -5.81E+00,  72,198,  -6.10E+00,  72,199,  -5.26E+00,
     & 72,200,  -4.24E+00,  72,201,  -3.03E+00,  72,202,  -1.71E+00,
     & 72,203,  -8.10E-01,  72,204,   1.00E-02,  72,205,   5.10E-01,
     & 72,206,   9.90E-01,  72,207,   1.35E+00,  72,208,   1.66E+00/
      data (nsz(i),nsa(i),shin(i),i=4231,4260)/
     & 72,209,   1.54E+00,  72,210,   1.74E+00,  72,211,   1.49E+00,
     & 72,212,   1.54E+00,  72,213,   1.23E+00,  72,214,   1.28E+00,
     & 72,215,   8.70E-01,  72,216,   8.20E-01,  72,217,   3.20E-01,
     & 72,218,   2.60E-01,  72,219,  -2.20E-01,  72,220,  -3.30E-01,
     & 72,221,  -1.06E+00,  72,222,  -1.17E+00,  72,223,  -1.71E+00,
     & 72,224,  -1.85E+00,  72,225,  -2.05E+00,  72,226,  -2.01E+00,
     & 72,227,  -2.07E+00,  72,228,  -2.09E+00,  72,229,  -2.61E+00,
     & 72,230,  -2.93E+00,  72,231,  -3.62E+00,  72,232,  -3.86E+00,
     & 72,233,  -4.56E+00,  72,234,  -4.77E+00,  72,235,  -4.98E+00,
     & 72,236,  -4.70E+00,  72,237,  -5.02E+00,  72,238,  -4.81E+00/
      data (nsz(i),nsa(i),shin(i),i=4261,4290)/
     & 72,239,  -5.15E+00,  72,240,  -3.26E+00,  73,151,  -1.81E+00,
     & 73,152,  -2.33E+00,  73,153,  -3.03E+00,  73,154,  -3.49E+00,
     & 73,155,  -4.67E+00,  73,156,  -3.53E+00,  73,157,  -2.71E+00,
     & 73,158,  -1.52E+00,  73,159,  -7.90E-01,  73,160,  -3.10E-01,
     & 73,161,   2.40E-01,  73,162,   7.30E-01,  73,163,   1.07E+00,
     & 73,164,   1.18E+00,  73,165,   1.38E+00,  73,166,   1.46E+00,
     & 73,167,   1.45E+00,  73,168,   1.38E+00,  73,169,   1.18E+00,
     & 73,170,   9.70E-01,  73,171,   7.40E-01,  73,172,   8.50E-01,
     & 73,173,   2.60E-01,  73,174,  -4.00E-02,  73,175,  -2.70E-01,
     & 73,176,  -4.00E-02,  73,177,  -1.60E-01,  73,178,  -6.40E-01/
      data (nsz(i),nsa(i),shin(i),i=4291,4320)/
     & 73,179,  -6.90E-01,  73,180,  -1.26E+00,  73,181,  -1.33E+00,
     & 73,182,  -1.66E+00,  73,183,  -1.42E+00,  73,184,  -1.61E+00,
     & 73,185,  -1.39E+00,  73,186,  -1.56E+00,  73,187,  -2.84E+00,
     & 73,188,  -3.03E+00,  73,189,  -2.91E+00,  73,190,  -3.00E+00,
     & 73,191,  -3.12E+00,  73,192,  -2.69E+00,  73,193,  -3.07E+00,
     & 73,194,  -3.63E+00,  73,195,  -4.03E+00,  73,196,  -4.87E+00,
     & 73,197,  -5.30E+00,  73,198,  -6.32E+00,  73,199,  -6.59E+00,
     & 73,200,  -5.75E+00,  73,201,  -4.74E+00,  73,202,  -3.43E+00,
     & 73,203,  -2.20E+00,  73,204,  -1.34E+00,  73,205,  -4.30E-01,
     & 73,206,   5.00E-02,  73,207,   6.10E-01,  73,208,   1.03E+00/
      data (nsz(i),nsa(i),shin(i),i=4321,4350)/
     & 73,209,   1.38E+00,  73,210,   1.33E+00,  73,211,   1.60E+00,
     & 73,212,   1.32E+00,  73,213,   1.39E+00,  73,214,   1.11E+00,
     & 73,215,   1.16E+00,  73,216,   8.20E-01,  73,217,   7.70E-01,
     & 73,218,   4.00E-01,  73,219,   3.40E-01,  73,220,  -1.80E-01,
     & 73,221,  -2.80E-01,  73,222,  -8.10E-01,  73,223,  -9.10E-01,
     & 73,224,  -1.41E+00,  73,225,  -1.80E+00,  73,226,  -1.76E+00,
     & 73,227,  -1.78E+00,  73,228,  -1.98E+00,  73,229,  -2.03E+00,
     & 73,230,  -2.58E+00,  73,231,  -2.77E+00,  73,232,  -3.63E+00,
     & 73,233,  -3.91E+00,  73,234,  -4.61E+00,  73,235,  -4.86E+00,
     & 73,236,  -5.10E+00,  73,237,  -4.99E+00,  73,238,  -5.24E+00/
      data (nsz(i),nsa(i),shin(i),i=4351,4380)/
     & 73,239,  -5.07E+00,  73,240,  -4.81E+00,  73,241,  -3.82E+00,
     & 73,242,  -4.06E+00,  73,243,  -4.21E+00,  74,154,  -3.65E+00,
     & 74,155,  -4.21E+00,  74,156,  -5.24E+00,  74,157,  -4.25E+00,
     & 74,158,  -3.44E+00,  74,159,  -2.08E+00,  74,160,  -1.27E+00,
     & 74,161,  -6.40E-01,  74,162,  -1.10E-01,  74,163,   3.10E-01,
     & 74,164,   3.20E-01,  74,165,   9.60E-01,  74,166,   9.40E-01,
     & 74,167,   1.33E+00,  74,168,   1.40E+00,  74,169,   1.39E+00,
     & 74,170,   1.28E+00,  74,171,   1.15E+00,  74,172,   1.00E+00,
     & 74,173,   7.70E-01,  74,174,   6.10E-01,  74,175,   3.70E-01,
     & 74,176,   1.00E-01,  74,177,  -2.40E-01,  74,178,   1.00E-01/
      data (nsz(i),nsa(i),shin(i),i=4381,4410)/
     & 74,179,  -3.80E-01,  74,180,  -4.70E-01,  74,181,  -1.04E+00,
     & 74,182,  -1.12E+00,  74,183,  -1.53E+00,  74,184,  -1.30E+00,
     & 74,185,  -1.59E+00,  74,186,  -1.47E+00,  74,187,  -1.79E+00,
     & 74,188,  -1.63E+00,  74,189,  -1.65E+00,  74,190,  -1.87E+00,
     & 74,191,  -3.52E+00,  74,192,  -3.56E+00,  74,193,  -3.10E+00,
     & 74,194,  -3.52E+00,  74,195,  -4.14E+00,  74,196,  -4.65E+00,
     & 74,197,  -5.51E+00,  74,198,  -6.05E+00,  74,199,  -7.12E+00,
     & 74,200,  -7.34E+00,  74,201,  -6.47E+00,  74,202,  -5.53E+00,
     & 74,203,  -4.34E+00,  74,204,  -3.08E+00,  74,205,  -1.92E+00,
     & 74,206,  -9.70E-01,  74,207,  -2.40E-01,  74,208,   3.00E-01/
      data (nsz(i),nsa(i),shin(i),i=4411,4440)/
     & 74,209,   6.40E-01,  74,210,   1.23E+00,  74,211,   1.29E+00,
     & 74,212,   1.55E+00,  74,213,   1.41E+00,  74,214,   1.51E+00,
     & 74,215,   1.26E+00,  74,216,   1.33E+00,  74,217,   1.01E+00,
     & 74,218,   9.70E-01,  74,219,   5.50E-01,  74,220,   5.50E-01,
     & 74,221,   4.00E-02,  74,222,  -1.00E-02,  74,223,  -5.40E-01,
     & 74,224,  -6.20E-01,  74,225,  -1.10E+00,  74,226,  -1.16E+00,
     & 74,227,  -1.42E+00,  74,228,  -1.32E+00,  74,229,  -1.71E+00,
     & 74,230,  -1.78E+00,  74,231,  -2.33E+00,  74,232,  -2.52E+00,
     & 74,233,  -3.26E+00,  74,234,  -3.54E+00,  74,235,  -4.26E+00,
     & 74,236,  -4.54E+00,  74,237,  -4.92E+00,  74,238,  -4.72E+00/
      data (nsz(i),nsa(i),shin(i),i=4441,4470)/
     & 74,239,  -4.89E+00,  74,240,  -4.53E+00,  74,241,  -4.75E+00,
     & 74,242,  -3.76E+00,  74,243,  -4.31E+00,  74,244,  -4.64E+00,
     & 74,245,  -2.80E+00,  74,246,  -3.19E+00,  74,247,  -3.17E+00,
     & 75,156,  -5.09E+00,  75,157,  -6.17E+00,  75,158,  -5.09E+00,
     & 75,159,  -4.30E+00,  75,160,  -3.05E+00,  75,161,  -2.10E+00,
     & 75,162,  -1.49E+00,  75,163,  -8.30E-01,  75,164,  -3.30E-01,
     & 75,165,   9.00E-02,  75,166,   6.20E-01,  75,167,   8.40E-01,
     & 75,168,   9.30E-01,  75,169,   1.08E+00,  75,170,   1.12E+00,
     & 75,171,   1.07E+00,  75,172,   9.60E-01,  75,173,   8.90E-01,
     & 75,174,   6.40E-01,  75,175,   4.90E-01,  75,176,   1.90E-01/
      data (nsz(i),nsa(i),shin(i),i=4471,4500)/
     & 75,177,   0.00E+00,  75,178,   2.60E-01,  75,179,   1.00E-01,
     & 75,180,  -2.70E-01,  75,181,  -1.30E+00,  75,182,  -1.07E+00,
     & 75,183,  -1.47E+00,  75,184,  -1.71E+00,  75,185,  -1.70E+00,
     & 75,186,  -1.95E+00,  75,187,  -1.96E+00,  75,188,  -2.22E+00,
     & 75,189,  -2.23E+00,  75,190,  -2.59E+00,  75,191,  -2.71E+00,
     & 75,192,  -4.12E+00,  75,193,  -4.22E+00,  75,194,  -4.33E+00,
     & 75,195,  -4.14E+00,  75,196,  -4.75E+00,  75,197,  -5.36E+00,
     & 75,198,  -6.20E+00,  75,199,  -6.74E+00,  75,200,  -7.62E+00,
     & 75,201,  -7.86E+00,  75,202,  -7.04E+00,  75,203,  -5.97E+00,
     & 75,204,  -4.69E+00,  75,205,  -3.56E+00,  75,206,  -2.58E+00/
      data (nsz(i),nsa(i),shin(i),i=4501,4530)/
     & 75,207,  -1.60E+00,  75,208,  -8.90E-01,  75,209,  -2.20E-01,
     & 75,210,   1.70E-01,  75,211,   8.20E-01,  75,212,   9.30E-01,
     & 75,213,   1.26E+00,  75,214,   1.17E+00,  75,215,   1.30E+00,
     & 75,216,   1.06E+00,  75,217,   1.16E+00,  75,218,   8.60E-01,
     & 75,219,   8.50E-01,  75,220,   4.70E-01,  75,221,   4.10E-01,
     & 75,222,   0.00E+00,  75,223,  -8.00E-02,  75,224,  -6.00E-01,
     & 75,225,  -6.40E-01,  75,226,  -1.17E+00,  75,227,  -1.22E+00,
     & 75,228,  -1.44E+00,  75,229,  -1.45E+00,  75,230,  -1.83E+00,
     & 75,231,  -1.89E+00,  75,232,  -2.35E+00,  75,233,  -2.56E+00,
     & 75,234,  -3.25E+00,  75,235,  -3.62E+00,  75,236,  -4.25E+00/
      data (nsz(i),nsa(i),shin(i),i=4531,4560)/
     & 75,237,  -4.59E+00,  75,238,  -4.95E+00,  75,239,  -4.71E+00,
     & 75,240,  -4.94E+00,  75,241,  -4.21E+00,  75,242,  -4.18E+00,
     & 75,243,  -4.21E+00,  75,244,  -4.74E+00,  75,245,  -4.19E+00,
     & 75,246,  -3.29E+00,  75,247,  -3.60E+00,  75,248,  -3.78E+00,
     & 75,249,  -4.22E+00,  75,250,  -5.01E+00,  76,159,  -6.09E+00,
     & 76,160,  -5.30E+00,  76,161,  -3.85E+00,  76,162,  -2.81E+00,
     & 76,163,  -1.91E+00,  76,164,  -1.21E+00,  76,165,  -6.70E-01,
     & 76,166,  -1.90E-01,  76,167,   1.60E-01,  76,168,   2.20E-01,
     & 76,169,   8.30E-01,  76,170,   8.40E-01,  76,171,   1.03E+00,
     & 76,172,   1.09E+00,  76,173,   1.04E+00,  76,174,   9.30E-01/
      data (nsz(i),nsa(i),shin(i),i=4561,4590)/
     & 76,175,   9.50E-01,  76,176,   7.60E-01,  76,177,   5.60E-01,
     & 76,178,   3.30E-01,  76,179,   8.00E-02,  76,180,  -2.80E-01,
     & 76,181,  -5.70E-01,  76,182,  -2.10E-01,  76,183,  -1.32E+00,
     & 76,184,  -9.40E-01,  76,185,  -1.26E+00,  76,186,  -1.38E+00,
     & 76,187,  -1.70E+00,  76,188,  -1.89E+00,  76,189,  -2.15E+00,
     & 76,190,  -2.46E+00,  76,191,  -2.88E+00,  76,192,  -3.27E+00,
     & 76,193,  -3.80E+00,  76,194,  -4.05E+00,  76,195,  -4.63E+00,
     & 76,196,  -4.73E+00,  76,197,  -5.45E+00,  76,198,  -6.11E+00,
     & 76,199,  -7.00E+00,  76,200,  -7.58E+00,  76,201,  -8.63E+00,
     & 76,202,  -8.82E+00,  76,203,  -8.02E+00,  76,204,  -6.97E+00/
      data (nsz(i),nsa(i),shin(i),i=4591,4620)/
     & 76,205,  -5.71E+00,  76,206,  -4.53E+00,  76,207,  -3.38E+00,
     & 76,208,  -2.33E+00,  76,209,  -1.41E+00,  76,210,  -6.60E-01,
     & 76,211,  -2.40E-01,  76,212,   3.50E-01,  76,213,   7.10E-01,
     & 76,214,   1.09E+00,  76,215,   1.07E+00,  76,216,   1.27E+00,
     & 76,217,   1.14E+00,  76,218,   1.25E+00,  76,219,   1.02E+00,
     & 76,220,   9.90E-01,  76,221,   6.50E-01,  76,222,   6.40E-01,
     & 76,223,   1.90E-01,  76,224,   1.00E-01,  76,225,  -3.50E-01,
     & 76,226,  -4.20E-01,  76,227,  -8.70E-01,  76,228,  -9.10E-01,
     & 76,229,  -1.13E+00,  76,230,  -1.12E+00,  76,231,  -1.47E+00,
     & 76,232,  -1.48E+00,  76,233,  -1.85E+00,  76,234,  -2.05E+00/
      data (nsz(i),nsa(i),shin(i),i=4621,4650)/
     & 76,235,  -2.71E+00,  76,236,  -3.06E+00,  76,237,  -3.72E+00,
     & 76,238,  -4.09E+00,  76,239,  -4.38E+00,  76,240,  -4.05E+00,
     & 76,241,  -4.06E+00,  76,242,  -3.41E+00,  76,243,  -3.79E+00,
     & 76,244,  -3.60E+00,  76,245,  -2.62E+00,  76,246,  -1.99E+00,
     & 76,247,  -3.54E+00,  76,248,  -3.89E+00,  76,249,  -3.69E+00,
     & 76,250,  -4.12E+00,  76,251,  -4.97E+00,  76,252,  -5.19E+00,
     & 76,253,  -6.32E+00,  77,162,  -5.21E+00,  77,163,  -4.03E+00,
     & 77,164,  -2.95E+00,  77,165,  -2.05E+00,  77,166,  -1.35E+00,
     & 77,167,  -7.60E-01,  77,168,  -3.40E-01,  77,169,   1.40E-01,
     & 77,170,   6.10E-01,  77,171,   8.60E-01,  77,172,   9.90E-01/
      data (nsz(i),nsa(i),shin(i),i=4651,4680)/
     & 77,173,   1.19E+00,  77,174,   1.22E+00,  77,175,   1.22E+00,
     & 77,176,   8.90E-01,  77,177,   1.03E+00,  77,178,   6.80E-01,
     & 77,179,   3.60E-01,  77,180,   1.80E-01,  77,181,  -1.70E-01,
     & 77,182,  -2.90E-01,  77,183,  -7.20E-01,  77,184,  -9.10E-01,
     & 77,185,  -1.42E+00,  77,186,  -9.50E-01,  77,187,  -1.47E+00,
     & 77,188,  -1.64E+00,  77,189,  -1.98E+00,  77,190,  -2.20E+00,
     & 77,191,  -2.75E+00,  77,192,  -3.16E+00,  77,193,  -3.72E+00,
     & 77,194,  -4.30E+00,  77,195,  -4.63E+00,  77,196,  -5.27E+00,
     & 77,197,  -5.57E+00,  77,198,  -6.46E+00,  77,199,  -7.01E+00,
     & 77,200,  -7.89E+00,  77,201,  -8.48E+00,  77,202,  -9.50E+00/
      data (nsz(i),nsa(i),shin(i),i=4681,4710)/
     & 77,203,  -9.69E+00,  77,204,  -8.75E+00,  77,205,  -7.86E+00,
     & 77,206,  -6.54E+00,  77,207,  -5.42E+00,  77,208,  -4.16E+00,
     & 77,209,  -3.09E+00,  77,210,  -2.10E+00,  77,211,  -1.32E+00,
     & 77,212,  -8.20E-01,  77,213,  -2.10E-01,  77,214,   2.80E-01,
     & 77,215,   6.70E-01,  77,216,   8.00E-01,  77,217,   1.00E+00,
     & 77,218,   8.70E-01,  77,219,   1.01E+00,  77,220,   8.10E-01,
     & 77,221,   9.00E-01,  77,222,   5.80E-01,  77,223,   6.00E-01,
     & 77,224,   1.50E-01,  77,225,   1.00E-01,  77,226,  -3.90E-01,
     & 77,227,  -4.50E-01,  77,228,  -8.80E-01,  77,229,  -8.80E-01,
     & 77,230,  -1.07E+00,  77,231,  -9.50E-01,  77,232,  -1.14E+00/
      data (nsz(i),nsa(i),shin(i),i=4711,4740)/
     & 77,233,  -1.16E+00,  77,234,  -1.42E+00,  77,235,  -1.63E+00,
     & 77,236,  -2.23E+00,  77,237,  -2.58E+00,  77,238,  -3.35E+00,
     & 77,239,  -3.65E+00,  77,240,  -3.91E+00,  77,241,  -3.63E+00,
     & 77,242,  -3.42E+00,  77,243,  -3.28E+00,  77,244,  -3.61E+00,
     & 77,245,  -2.31E+00,  77,246,  -2.58E+00,  77,247,  -2.28E+00,
     & 77,248,  -4.11E+00,  77,249,  -4.44E+00,  77,250,  -4.27E+00,
     & 77,251,  -4.43E+00,  77,252,  -5.28E+00,  77,253,  -5.68E+00,
     & 77,254,  -6.87E+00,  77,255,  -6.97E+00,  77,256,  -6.94E+00,
     & 78,165,  -3.53E+00,  78,166,  -2.61E+00,  78,167,  -1.65E+00,
     & 78,168,  -8.80E-01,  78,169,  -5.00E-01,  78,170,   8.00E-02/
      data (nsz(i),nsa(i),shin(i),i=4741,4770)/
     & 78,171,   4.90E-01,  78,172,   2.00E-01,  78,173,   9.60E-01,
     & 78,174,   8.10E-01,  78,175,   1.15E+00,  78,176,   1.26E+00,
     & 78,177,   1.26E+00,  78,178,   1.10E+00,  78,179,   1.06E+00,
     & 78,180,   9.40E-01,  78,181,   6.80E-01,  78,182,   5.10E-01,
     & 78,183,   2.20E-01,  78,184,  -8.00E-02,  78,185,  -3.70E-01,
     & 78,186,  -2.90E-01,  78,187,  -8.20E-01,  78,188,  -1.01E+00,
     & 78,189,  -1.27E+00,  78,190,  -1.87E+00,  78,191,  -2.16E+00,
     & 78,192,  -2.86E+00,  78,193,  -3.29E+00,  78,194,  -4.00E+00,
     & 78,195,  -4.58E+00,  78,196,  -5.16E+00,  78,197,  -5.77E+00,
     & 78,198,  -6.29E+00,  78,199,  -6.91E+00,  78,200,  -7.45E+00/
      data (nsz(i),nsa(i),shin(i),i=4771,4800)/
     & 78,201,  -7.97E+00,  78,202,  -9.22E+00,  78,203,  -1.02E+01,
     & 78,204,  -1.04E+01,  78,205,  -9.58E+00,  78,206,  -8.54E+00,
     & 78,207,  -7.19E+00,  78,208,  -6.02E+00,  78,209,  -4.91E+00,
     & 78,210,  -3.78E+00,  78,211,  -2.78E+00,  78,212,  -1.84E+00,
     & 78,213,  -1.24E+00,  78,214,  -5.20E-01,  78,215,  -1.10E-01,
     & 78,216,   3.50E-01,  78,217,   5.90E-01,  78,218,   8.80E-01,
     & 78,219,   8.40E-01,  78,220,   1.04E+00,  78,221,   8.90E-01,
     & 78,222,   9.50E-01,  78,223,   6.50E-01,  78,224,   7.10E-01,
     & 78,225,   3.50E-01,  78,226,   3.20E-01,  78,227,  -8.00E-02,
     & 78,228,  -1.10E-01,  78,229,  -5.40E-01,  78,230,  -5.00E-01/
      data (nsz(i),nsa(i),shin(i),i=4801,4830)/
     & 78,231,  -6.60E-01,  78,232,  -5.40E-01,  78,233,  -8.50E-01,
     & 78,234,  -7.10E-01,  78,235,  -1.03E+00,  78,236,  -1.12E+00,
     & 78,237,  -1.70E+00,  78,238,  -2.00E+00,  78,239,  -2.75E+00,
     & 78,240,  -3.02E+00,  78,241,  -3.28E+00,  78,242,  -3.08E+00,
     & 78,243,  -2.86E+00,  78,244,  -2.68E+00,  78,245,  -9.20E-01,
     & 78,246,  -1.90E+00,  78,247,  -2.11E+00,  78,248,  -2.09E+00,
     & 78,249,  -2.79E+00,  78,250,  -3.37E+00,  78,251,  -4.10E+00,
     & 78,252,  -4.52E+00,  78,253,  -5.27E+00,  78,254,  -5.69E+00,
     & 78,255,  -7.35E+00,  78,256,  -7.47E+00,  78,257,  -7.45E+00,
     & 78,258,  -7.77E+00,  78,259,  -8.40E+00,  78,260,  -8.52E+00/
      data (nsz(i),nsa(i),shin(i),i=4831,4860)/
     & 79,167,  -4.02E+00,  79,168,  -3.02E+00,  79,169,  -2.17E+00,
     & 79,170,  -1.34E+00,  79,171,  -7.00E-01,  79,172,  -5.00E-02,
     & 79,173,   4.30E-01,  79,174,   6.50E-01,  79,175,   1.01E+00,
     & 79,176,   1.47E+00,  79,177,   1.60E+00,  79,178,   1.69E+00,
     & 79,179,   1.66E+00,  79,180,   1.60E+00,  79,181,   1.43E+00,
     & 79,182,   1.27E+00,  79,183,   9.90E-01,  79,184,   7.60E-01,
     & 79,185,   4.70E-01,  79,186,   1.90E-01,  79,187,  -1.40E-01,
     & 79,188,  -3.80E-01,  79,189,  -7.90E-01,  79,190,  -1.47E+00,
     & 79,191,  -2.17E+00,  79,192,  -2.56E+00,  79,193,  -3.24E+00,
     & 79,194,  -3.91E+00,  79,195,  -4.58E+00,  79,196,  -5.27E+00/
      data (nsz(i),nsa(i),shin(i),i=4861,4890)/
     & 79,197,  -5.95E+00,  79,198,  -6.79E+00,  79,199,  -7.31E+00,
     & 79,200,  -8.17E+00,  79,201,  -8.59E+00,  79,202,  -9.58E+00,
     & 79,203,  -9.89E+00,  79,204,  -1.11E+01,  79,205,  -1.14E+01,
     & 79,206,  -1.04E+01,  79,207,  -9.47E+00,  79,208,  -8.25E+00,
     & 79,209,  -6.93E+00,  79,210,  -5.77E+00,  79,211,  -4.65E+00,
     & 79,212,  -3.76E+00,  79,213,  -2.80E+00,  79,214,  -1.99E+00,
     & 79,215,  -1.25E+00,  79,216,  -6.50E-01,  79,217,  -1.50E-01,
     & 79,218,   1.90E-01,  79,219,   5.10E-01,  79,220,   5.30E-01,
     & 79,221,   8.10E-01,  79,222,   7.10E-01,  79,223,   7.80E-01,
     & 79,224,   5.50E-01,  79,225,   6.20E-01,  79,226,   3.10E-01/
      data (nsz(i),nsa(i),shin(i),i=4891,4920)/
     & 79,227,   3.10E-01,  79,228,  -6.00E-02,  79,229,  -8.00E-02,
     & 79,230,  -4.40E-01,  79,231,  -4.20E-01,  79,232,  -5.20E-01,
     & 79,233,  -4.00E-01,  79,234,  -6.70E-01,  79,235,  -5.60E-01,
     & 79,236,  -8.70E-01,  79,237,  -1.01E+00,  79,238,  -1.31E+00,
     & 79,239,  -1.78E+00,  79,240,  -2.40E+00,  79,241,  -2.70E+00,
     & 79,242,  -2.90E+00,  79,243,  -2.40E+00,  79,244,  -2.10E-01,
     & 79,245,  -5.00E-01,  79,246,  -1.14E+00,  79,247,  -1.88E+00,
     & 79,248,  -2.33E+00,  79,249,  -2.77E+00,  79,250,  -4.76E+00,
     & 79,251,  -5.08E+00,  79,252,  -5.79E+00,  79,253,  -5.04E+00,
     & 79,254,  -5.80E+00,  79,255,  -7.16E+00,  79,256,  -7.94E+00/
      data (nsz(i),nsa(i),shin(i),i=4921,4950)/
     & 79,257,  -8.15E+00,  79,258,  -8.17E+00,  79,259,  -8.46E+00,
     & 79,260,  -9.09E+00,  79,261,  -9.22E+00,  79,262,  -9.77E+00,
     & 79,263,  -9.57E+00,  80,170,  -2.78E+00,  80,171,  -1.90E+00,
     & 80,172,  -1.22E+00,  80,173,  -5.50E-01,  80,174,  -2.00E-02,
     & 80,175,   4.50E-01,  80,176,   9.00E-02,  80,177,   1.13E+00,
     & 80,178,   6.00E-01,  80,179,   1.45E+00,  80,180,   1.48E+00,
     & 80,181,   1.46E+00,  80,182,   1.32E+00,  80,183,   1.19E+00,
     & 80,184,   9.10E-01,  80,185,   6.70E-01,  80,186,   4.20E-01,
     & 80,187,   1.20E-01,  80,188,  -2.50E-01,  80,189,  -5.50E-01,
     & 80,190,  -1.00E+00,  80,191,  -1.73E+00,  80,192,  -1.95E+00/
      data (nsz(i),nsa(i),shin(i),i=4951,4980)/
     & 80,193,  -2.82E+00,  80,194,  -3.59E+00,  80,195,  -4.16E+00,
     & 80,196,  -4.87E+00,  80,197,  -5.65E+00,  80,198,  -6.32E+00,
     & 80,199,  -7.27E+00,  80,200,  -7.80E+00,  80,201,  -8.61E+00,
     & 80,202,  -9.16E+00,  80,203,  -1.00E+01,  80,204,  -1.06E+01,
     & 80,205,  -1.14E+01,  80,206,  -1.15E+01,  80,207,  -1.03E+01,
     & 80,208,  -1.01E+01,  80,209,  -8.91E+00,  80,210,  -7.60E+00,
     & 80,211,  -6.44E+00,  80,212,  -5.31E+00,  80,213,  -4.29E+00,
     & 80,214,  -3.37E+00,  80,215,  -2.35E+00,  80,216,  -1.49E+00,
     & 80,217,  -6.80E-01,  80,218,  -8.00E-02,  80,219,   2.40E-01,
     & 80,220,   5.80E-01,  80,221,   5.30E-01,  80,222,   8.50E-01/
      data (nsz(i),nsa(i),shin(i),i=4981,5010)/
     & 80,223,   7.80E-01,  80,224,   8.80E-01,  80,225,   6.50E-01,
     & 80,226,   7.60E-01,  80,227,   4.50E-01,  80,228,   4.80E-01,
     & 80,229,   1.30E-01,  80,230,   1.70E-01,  80,231,  -1.70E-01,
     & 80,232,  -1.10E-01,  80,233,  -1.90E-01,  80,234,  -2.00E-02,
     & 80,235,  -1.60E-01,  80,236,  -1.30E-01,  80,237,  -4.20E-01,
     & 80,238,  -5.10E-01,  80,239,  -9.40E-01,  80,240,  -1.27E+00,
     & 80,241,  -1.80E+00,  80,242,  -1.99E+00,  80,243,  -2.33E+00,
     & 80,244,  -1.30E-01,  80,245,  -6.30E-01,  80,246,  -1.24E+00,
     & 80,247,  -2.12E+00,  80,248,  -2.86E+00,  80,249,  -3.72E+00,
     & 80,250,  -4.13E+00,  80,251,  -4.83E+00,  80,252,  -5.20E+00/
      data (nsz(i),nsa(i),shin(i),i=5011,5040)/
     & 80,253,  -5.88E+00,  80,254,  -6.14E+00,  80,255,  -7.00E+00,
     & 80,256,  -7.35E+00,  80,257,  -8.06E+00,  80,258,  -8.28E+00,
     & 80,259,  -8.46E+00,  80,260,  -8.72E+00,  80,261,  -9.33E+00,
     & 80,262,  -9.48E+00,  80,263,  -1.01E+01,  80,264,  -9.86E+00,
     & 80,265,  -9.07E+00,  80,266,  -8.34E+00,  81,173,  -1.98E+00,
     & 81,174,  -1.19E+00,  81,175,  -6.40E-01,  81,176,  -3.00E-02,
     & 81,177,   3.30E-01,  81,178,   7.00E-01,  81,179,   6.00E-01,
     & 81,180,   1.13E+00,  81,181,   1.11E+00,  81,182,   1.22E+00,
     & 81,183,   1.06E+00,  81,184,   1.04E+00,  81,185,   8.10E-01,
     & 81,186,   6.00E-01,  81,187,   3.10E-01,  81,188,   0.00E+00/
      data (nsz(i),nsa(i),shin(i),i=5041,5070)/
     & 81,189,  -4.00E-01,  81,190,  -7.90E-01,  81,191,  -1.32E+00,
     & 81,192,  -1.79E+00,  81,193,  -2.47E+00,  81,194,  -2.91E+00,
     & 81,195,  -3.84E+00,  81,196,  -4.38E+00,  81,197,  -5.17E+00,
     & 81,198,  -5.91E+00,  81,199,  -6.74E+00,  81,200,  -7.61E+00,
     & 81,201,  -8.26E+00,  81,202,  -9.29E+00,  81,203,  -9.89E+00,
     & 81,204,  -1.10E+01,  81,205,  -1.16E+01,  81,206,  -1.28E+01,
     & 81,207,  -1.30E+01,  81,208,  -1.18E+01,  81,209,  -1.04E+01,
     & 81,210,  -9.33E+00,  81,211,  -8.40E+00,  81,212,  -7.34E+00,
     & 81,213,  -6.16E+00,  81,214,  -5.15E+00,  81,215,  -4.12E+00,
     & 81,216,  -3.12E+00,  81,217,  -2.33E+00,  81,218,  -1.88E+00/
      data (nsz(i),nsa(i),shin(i),i=5071,5100)/
     & 81,219,  -1.17E+00,  81,220,  -4.70E-01,  81,221,   2.30E-01,
     & 81,222,   2.50E-01,  81,223,   6.00E-01,  81,224,   5.70E-01,
     & 81,225,   7.00E-01,  81,226,   5.70E-01,  81,227,   7.00E-01,
     & 81,228,   4.00E-01,  81,229,   4.40E-01,  81,230,   1.00E-01,
     & 81,231,   1.40E-01,  81,232,  -1.70E-01,  81,233,  -9.00E-02,
     & 81,234,  -1.40E-01,  81,235,   7.00E-02,  81,236,  -1.00E-01,
     & 81,237,  -2.00E-02,  81,238,  -2.90E-01,  81,239,  -3.50E-01,
     & 81,240,  -8.20E-01,  81,241,   8.50E-01,  81,242,   4.70E-01,
     & 81,243,   1.00E-01,  81,244,  -3.10E-01,  81,245,  -6.90E-01,
     & 81,246,  -1.11E+00,  81,247,  -1.42E+00,  81,248,  -2.10E+00/
      data (nsz(i),nsa(i),shin(i),i=5101,5130)/
     & 81,249,  -2.58E+00,  81,250,  -3.15E+00,  81,251,  -3.51E+00,
     & 81,252,  -4.12E+00,  81,253,  -4.62E+00,  81,254,  -5.24E+00,
     & 81,255,  -5.64E+00,  81,256,  -6.40E+00,  81,257,  -7.24E+00,
     & 81,258,  -7.78E+00,  81,259,  -8.11E+00,  81,260,  -8.94E+00,
     & 81,261,  -9.20E+00,  81,262,  -9.87E+00,  81,263,  -1.01E+01,
     & 81,264,  -1.05E+01,  81,265,  -1.03E+01,  81,266,  -9.49E+00,
     & 81,267,  -8.77E+00,  81,268,  -7.70E+00,  81,269,  -6.76E+00,
     & 82,175,  -1.50E+00,  82,176,  -9.60E-01,  82,177,  -4.40E-01,
     & 82,178,  -7.00E-02,  82,179,   3.40E-01,  82,180,   4.80E-01,
     & 82,181,   7.30E-01,  82,182,   3.40E-01,  82,183,   8.40E-01/
      data (nsz(i),nsa(i),shin(i),i=5131,5160)/
     & 82,184,   8.00E-01,  82,185,   8.00E-01,  82,186,   6.10E-01,
     & 82,187,   5.60E-01,  82,188,   2.10E-01,  82,189,  -2.00E-02,
     & 82,190,  -4.30E-01,  82,191,  -7.00E-01,  82,192,  -1.33E+00,
     & 82,193,  -1.69E+00,  82,194,  -2.42E+00,  82,195,  -2.88E+00,
     & 82,196,  -3.68E+00,  82,197,  -4.26E+00,  82,198,  -5.08E+00,
     & 82,199,  -5.62E+00,  82,200,  -6.59E+00,  82,201,  -7.32E+00,
     & 82,202,  -8.07E+00,  82,203,  -9.11E+00,  82,204,  -9.83E+00,
     & 82,205,  -1.10E+01,  82,206,  -1.17E+01,  82,207,  -1.31E+01,
     & 82,208,  -1.34E+01,  82,209,  -1.23E+01,  82,210,  -1.07E+01,
     & 82,211,  -9.75E+00,  82,212,  -8.38E+00,  82,213,  -7.26E+00/
      data (nsz(i),nsa(i),shin(i),i=5161,5190)/
     & 82,214,  -6.38E+00,  82,215,  -5.23E+00,  82,216,  -4.36E+00,
     & 82,217,  -3.59E+00,  82,218,  -2.80E+00,  82,219,  -2.09E+00,
     & 82,220,  -1.36E+00,  82,221,  -5.00E-02,  82,222,   3.70E-01,
     & 82,223,   3.80E-01,  82,224,   6.50E-01,  82,225,   7.20E-01,
     & 82,226,   8.20E-01,  82,227,   6.40E-01,  82,228,   7.60E-01,
     & 82,229,   4.60E-01,  82,230,   5.50E-01,  82,231,   2.20E-01,
     & 82,232,   3.00E-01,  82,233,  -4.00E-02,  82,234,   1.20E-01,
     & 82,235,   9.00E-02,  82,236,   3.20E-01,  82,237,   2.10E-01,
     & 82,238,   3.60E-01,  82,239,   9.00E-02,  82,240,   7.00E-02,
     & 82,241,  -3.50E-01,  82,242,   9.10E-01,  82,243,   5.20E-01/
      data (nsz(i),nsa(i),shin(i),i=5191,5220)/
     & 82,244,   1.60E-01,  82,245,  -2.60E-01,  82,246,  -8.10E-01,
     & 82,247,  -1.08E+00,  82,248,  -1.39E+00,  82,249,  -2.06E+00,
     & 82,250,  -2.51E+00,  82,251,  -3.08E+00,  82,252,  -3.47E+00,
     & 82,253,  -4.08E+00,  82,254,  -4.43E+00,  82,255,  -5.06E+00,
     & 82,256,  -5.42E+00,  82,257,  -6.13E+00,  82,258,  -6.60E+00,
     & 82,259,  -7.47E+00,  82,260,  -7.93E+00,  82,261,  -8.73E+00,
     & 82,262,  -8.95E+00,  82,263,  -9.66E+00,  82,264,  -9.79E+00,
     & 82,265,  -1.02E+01,  82,266,  -1.00E+01,  82,267,  -9.18E+00,
     & 82,268,  -8.47E+00,  82,269,  -7.45E+00,  82,270,  -6.57E+00,
     & 82,271,  -6.06E+00,  82,272,  -5.42E+00,  82,273,  -5.19E+00/
      data (nsz(i),nsa(i),shin(i),i=5221,5250)/
     & 83,178,   6.20E-01,  83,179,   1.02E+00,  83,180,   1.40E+00,
     & 83,181,   1.84E+00,  83,182,   1.85E+00,  83,183,   2.03E+00,
     & 83,184,   2.12E+00,  83,185,   1.96E+00,  83,186,   1.92E+00,
     & 83,187,   1.69E+00,  83,188,   1.56E+00,  83,189,   1.24E+00,
     & 83,190,   9.60E-01,  83,191,   5.30E-01,  83,192,   1.70E-01,
     & 83,193,  -3.90E-01,  83,194,  -8.20E-01,  83,195,  -1.49E+00,
     & 83,196,  -2.13E+00,  83,197,  -2.88E+00,  83,198,  -3.60E+00,
     & 83,199,  -4.38E+00,  83,200,  -5.01E+00,  83,201,  -5.81E+00,
     & 83,202,  -6.61E+00,  83,203,  -7.43E+00,  83,204,  -8.35E+00,
     & 83,205,  -9.06E+00,  83,206,  -1.01E+01,  83,207,  -1.08E+01/
      data (nsz(i),nsa(i),shin(i),i=5251,5280)/
     & 83,208,  -1.19E+01,  83,209,  -1.23E+01,  83,210,  -1.14E+01,
     & 83,211,  -9.74E+00,  83,212,  -8.91E+00,  83,213,  -7.52E+00,
     & 83,214,  -6.67E+00,  83,215,  -5.52E+00,  83,216,  -4.51E+00,
     & 83,217,  -3.70E+00,  83,218,  -2.99E+00,  83,219,  -2.15E+00,
     & 83,220,  -1.52E+00,  83,221,  -9.00E-01,  83,222,  -3.50E-01,
     & 83,223,   5.00E-02,  83,224,   1.00E-01,  83,225,   5.10E-01,
     & 83,226,   5.10E-01,  83,227,   6.40E-01,  83,228,   4.70E-01,
     & 83,229,   6.40E-01,  83,230,   3.60E-01,  83,231,   4.60E-01,
     & 83,232,   1.50E-01,  83,233,   2.60E-01,  83,234,  -3.00E-02,
     & 83,235,   1.10E-01,  83,236,   1.10E-01,  83,237,   3.50E-01/
      data (nsz(i),nsa(i),shin(i),i=5281,5310)/
     & 83,238,   2.80E-01,  83,239,   4.10E-01,  83,240,   1.80E-01,
     & 83,241,   1.80E-01,  83,242,  -2.10E-01,  83,243,   1.05E+00,
     & 83,244,   7.70E-01,  83,245,   4.10E-01,  83,246,  -4.00E-02,
     & 83,247,  -3.30E-01,  83,248,  -8.90E-01,  83,249,  -1.15E+00,
     & 83,250,  -1.87E+00,  83,251,  -2.27E+00,  83,252,  -2.83E+00,
     & 83,253,  -3.14E+00,  83,254,  -3.76E+00,  83,255,  -4.16E+00,
     & 83,256,  -4.75E+00,  83,257,  -5.09E+00,  83,258,  -5.78E+00,
     & 83,259,  -6.40E+00,  83,260,  -7.02E+00,  83,261,  -7.36E+00,
     & 83,262,  -8.22E+00,  83,263,  -8.48E+00,  83,264,  -9.11E+00,
     & 83,265,  -9.23E+00,  83,266,  -9.67E+00,  83,267,  -9.40E+00/
      data (nsz(i),nsa(i),shin(i),i=5311,5340)/
     & 83,268,  -8.56E+00,  83,269,  -7.86E+00,  83,270,  -6.82E+00,
     & 83,271,  -5.98E+00,  83,272,  -5.45E+00,  83,273,  -4.78E+00,
     & 83,274,  -4.57E+00,  83,275,  -3.90E+00,  83,276,  -1.24E+00,
     & 84,181,   1.43E+00,  84,182,   1.40E+00,  84,183,   1.28E+00,
     & 84,184,   1.21E+00,  84,185,   1.07E+00,  84,186,   1.12E+00,
     & 84,187,   1.09E+00,  84,188,   1.32E+00,  84,189,   1.42E+00,
     & 84,190,   1.48E+00,  84,191,   1.47E+00,  84,192,   9.20E-01,
     & 84,193,   6.50E-01,  84,194,   4.50E-01,  84,195,   0.00E+00,
     & 84,196,  -5.00E-01,  84,197,  -1.10E+00,  84,198,  -1.73E+00,
     & 84,199,  -2.31E+00,  84,200,  -3.15E+00,  84,201,  -3.80E+00/
      data (nsz(i),nsa(i),shin(i),i=5341,5370)/
     & 84,202,  -4.64E+00,  84,203,  -5.59E+00,  84,204,  -6.26E+00,
     & 84,205,  -7.14E+00,  84,206,  -7.73E+00,  84,207,  -8.72E+00,
     & 84,208,  -9.28E+00,  84,209,  -1.05E+01,  84,210,  -1.06E+01,
     & 84,211,  -9.69E+00,  84,212,  -8.45E+00,  84,213,  -7.61E+00,
     & 84,214,  -6.52E+00,  84,215,  -5.71E+00,  84,216,  -4.79E+00,
     & 84,217,  -3.82E+00,  84,218,  -3.23E+00,  84,219,  -2.19E+00,
     & 84,220,  -1.41E+00,  84,221,  -8.60E-01,  84,222,  -2.60E-01,
     & 84,223,  -1.10E-01,  84,224,   2.90E-01,  84,225,   2.80E-01,
     & 84,226,   6.30E-01,  84,227,   5.80E-01,  84,228,   7.10E-01,
     & 84,229,   5.30E-01,  84,230,   6.90E-01,  84,231,   3.50E-01/
      data (nsz(i),nsa(i),shin(i),i=5371,5400)/
     & 84,232,   4.70E-01,  84,233,   1.80E-01,  84,234,   3.00E-01,
     & 84,235,  -2.00E-02,  84,236,   1.80E-01,  84,237,   1.90E-01,
     & 84,238,   4.90E-01,  84,239,   4.50E-01,  84,240,   6.60E-01,
     & 84,241,   4.70E-01,  84,242,   5.20E-01,  84,243,   1.40E-01,
     & 84,244,   5.00E-02,  84,245,  -3.90E-01,  84,246,  -4.30E-01,
     & 84,247,   5.30E-01,  84,248,   9.00E-02,  84,249,  -3.40E-01,
     & 84,250,  -5.80E-01,  84,251,  -1.29E+00,  84,252,  -1.68E+00,
     & 84,253,  -2.20E+00,  84,254,  -2.52E+00,  84,255,  -3.12E+00,
     & 84,256,  -4.10E+00,  84,257,  -4.08E+00,  84,258,  -4.40E+00,
     & 84,259,  -5.15E+00,  84,260,  -5.63E+00,  84,261,  -6.27E+00/
      data (nsz(i),nsa(i),shin(i),i=5401,5430)/
     & 84,262,  -6.59E+00,  84,263,  -7.43E+00,  84,264,  -7.75E+00,
     & 84,265,  -8.35E+00,  84,266,  -8.45E+00,  84,267,  -8.89E+00,
     & 84,268,  -8.61E+00,  84,269,  -7.76E+00,  84,270,  -7.06E+00,
     & 84,271,  -6.13E+00,  84,272,  -5.26E+00,  84,273,  -4.88E+00,
     & 84,274,  -4.23E+00,  84,275,  -4.06E+00,  84,276,  -1.00E+00,
     & 84,277,  -1.25E+00,  84,278,  -1.15E+00,  84,279,  -1.21E+00,
     & 85,184,   1.03E+00,  85,185,   8.30E-01,  85,186,   7.20E-01,
     & 85,187,   7.80E-01,  85,188,   8.70E-01,  85,189,   1.00E+00,
     & 85,190,   1.15E+00,  85,191,   1.49E+00,  85,192,   1.24E+00,
     & 85,193,   9.90E-01,  85,194,   7.30E-01,  85,195,   5.00E-01/
      data (nsz(i),nsa(i),shin(i),i=5431,5460)/
     & 85,196,   3.20E-01,  85,197,   1.00E-02,  85,198,  -3.20E-01,
     & 85,199,  -8.70E-01,  85,200,  -2.07E+00,  85,201,  -2.79E+00,
     & 85,202,  -3.48E+00,  85,203,  -4.26E+00,  85,204,  -4.86E+00,
     & 85,205,  -5.57E+00,  85,206,  -6.33E+00,  85,207,  -7.01E+00,
     & 85,208,  -7.90E+00,  85,209,  -8.44E+00,  85,210,  -9.43E+00,
     & 85,211,  -9.61E+00,  85,212,  -8.76E+00,  85,213,  -7.51E+00,
     & 85,214,  -6.77E+00,  85,215,  -5.71E+00,  85,216,  -4.95E+00,
     & 85,217,  -4.14E+00,  85,218,  -3.44E+00,  85,219,  -2.60E+00,
     & 85,220,  -2.07E+00,  85,221,  -1.43E+00,  85,222,  -8.60E-01,
     & 85,223,  -2.90E-01,  85,224,  -1.80E-01,  85,225,   1.60E-01/
      data (nsz(i),nsa(i),shin(i),i=5461,5490)/
     & 85,226,   1.30E-01,  85,227,   4.40E-01,  85,228,   3.90E-01,
     & 85,229,   5.10E-01,  85,230,   3.20E-01,  85,231,   4.80E-01,
     & 85,232,   1.60E-01,  85,233,   3.20E-01,  85,234,   2.00E-02,
     & 85,235,   1.80E-01,  85,236,  -1.30E-01,  85,237,  -6.00E-02,
     & 85,238,   1.50E-01,  85,239,   4.40E-01,  85,240,   5.10E-01,
     & 85,241,   7.10E-01,  85,242,   5.40E-01,  85,243,   5.90E-01,
     & 85,244,   2.60E-01,  85,245,   1.80E-01,  85,246,  -2.10E-01,
     & 85,247,  -2.70E-01,  85,248,   6.90E-01,  85,249,   4.70E-01,
     & 85,250,   6.00E-02,  85,251,  -2.20E-01,  85,252,  -8.60E-01,
     & 85,253,  -1.30E+00,  85,254,  -1.85E+00,  85,255,  -2.12E+00/
      data (nsz(i),nsa(i),shin(i),i=5491,5520)/
     & 85,256,  -2.72E+00,  85,257,  -3.91E+00,  85,258,  -3.62E+00,
     & 85,259,  -3.94E+00,  85,260,  -4.61E+00,  85,261,  -5.14E+00,
     & 85,262,  -5.74E+00,  85,263,  -6.05E+00,  85,264,  -6.71E+00,
     & 85,265,  -6.99E+00,  85,266,  -7.59E+00,  85,267,  -7.66E+00,
     & 85,268,  -8.10E+00,  85,269,  -7.79E+00,  85,270,  -6.94E+00,
     & 85,271,  -6.28E+00,  85,272,  -5.26E+00,  85,273,  -4.42E+00,
     & 85,274,  -3.92E+00,  85,275,  -3.41E+00,  85,276,  -1.33E+00,
     & 85,277,  -1.19E+00,  85,278,  -1.41E+00,  85,279,  -1.31E+00,
     & 85,280,  -1.59E+00,  85,281,  -1.31E+00,  85,282,  -1.54E+00,
     & 86,186,   5.90E-01,  86,187,   4.70E-01,  86,188,   5.60E-01/
      data (nsz(i),nsa(i),shin(i),i=5521,5550)/
     & 86,189,   5.90E-01,  86,190,   8.00E-01,  86,191,   1.05E+00,
     & 86,192,   1.29E+00,  86,193,   1.42E+00,  86,194,   1.42E+00,
     & 86,195,   1.16E+00,  86,196,   9.20E-01,  86,197,   6.50E-01,
     & 86,198,   4.50E-01,  86,199,   9.00E-02,  86,200,  -1.90E-01,
     & 86,201,  -6.70E-01,  86,202,  -1.45E+00,  86,203,  -2.13E+00,
     & 86,204,  -2.90E+00,  86,205,  -3.72E+00,  86,206,  -4.26E+00,
     & 86,207,  -5.42E+00,  86,208,  -5.83E+00,  86,209,  -6.76E+00,
     & 86,210,  -7.19E+00,  86,211,  -8.21E+00,  86,212,  -8.19E+00,
     & 86,213,  -7.38E+00,  86,214,  -6.38E+00,  86,215,  -5.66E+00,
     & 86,216,  -4.90E+00,  86,217,  -4.20E+00,  86,218,  -3.58E+00/
      data (nsz(i),nsa(i),shin(i),i=5551,5580)/
     & 86,219,  -2.91E+00,  86,220,  -2.37E+00,  86,221,  -1.75E+00,
     & 86,222,  -1.29E+00,  86,223,  -5.20E-01,  86,224,  -4.00E-02,
     & 86,225,   1.00E-02,  86,226,   3.20E-01,  86,227,   2.20E-01,
     & 86,228,   4.60E-01,  86,229,   3.20E-01,  86,230,   4.60E-01,
     & 86,231,   2.20E-01,  86,232,   3.80E-01,  86,233,   8.00E-02,
     & 86,234,   2.40E-01,  86,235,  -1.00E-02,  86,236,   1.40E-01,
     & 86,237,  -1.60E-01,  86,238,  -7.00E-02,  86,239,   2.10E-01,
     & 86,240,   4.90E-01,  86,241,   5.20E-01,  86,242,   8.10E-01,
     & 86,243,   7.00E-01,  86,244,   8.00E-01,  86,245,   4.90E-01,
     & 86,246,   4.30E-01,  86,247,   3.00E-02,  86,248,   0.00E+00/
      data (nsz(i),nsa(i),shin(i),i=5581,5610)/
     & 86,249,  -2.80E-01,  86,250,   9.70E-01,  86,251,   7.60E-01,
     & 86,252,   4.70E-01,  86,253,  -2.70E-01,  86,254,  -6.40E-01,
     & 86,255,  -1.22E+00,  86,256,  -1.48E+00,  86,257,  -2.06E+00,
     & 86,258,  -3.25E+00,  86,259,  -2.89E+00,  86,260,  -3.15E+00,
     & 86,261,  -3.81E+00,  86,262,  -4.50E+00,  86,263,  -5.11E+00,
     & 86,264,  -5.20E+00,  86,265,  -5.87E+00,  86,266,  -6.08E+00,
     & 86,267,  -6.60E+00,  86,268,  -6.63E+00,  86,269,  -7.06E+00,
     & 86,270,  -6.73E+00,  86,271,  -5.87E+00,  86,272,  -5.23E+00,
     & 86,273,  -4.27E+00,  86,274,  -3.54E+00,  86,275,  -3.13E+00,
     & 86,276,  -2.55E+00,  86,277,  -1.26E+00,  86,278,  -1.11E+00/
      data (nsz(i),nsa(i),shin(i),i=5611,5640)/
     & 86,279,  -1.37E+00,  86,280,  -1.26E+00,  86,281,  -1.39E+00,
     & 86,282,  -1.17E+00,  86,283,  -1.35E+00,  86,284,  -1.52E+00,
     & 86,285,  -1.69E+00,  86,286,  -1.57E+00,  87,189,   1.90E-01,
     & 87,190,   2.60E-01,  87,191,   4.40E-01,  87,192,   5.30E-01,
     & 87,193,   8.10E-01,  87,194,   1.16E+00,  87,195,   1.19E+00,
     & 87,196,   1.47E+00,  87,197,   1.24E+00,  87,198,   9.50E-01,
     & 87,199,   6.90E-01,  87,200,   4.10E-01,  87,201,   8.00E-02,
     & 87,202,  -3.30E-01,  87,203,  -8.00E-01,  87,204,  -2.03E+00,
     & 87,205,  -2.71E+00,  87,206,  -3.38E+00,  87,207,  -4.04E+00,
     & 87,208,  -4.62E+00,  87,209,  -5.18E+00,  87,210,  -5.89E+00/
      data (nsz(i),nsa(i),shin(i),i=5641,5670)/
     & 87,211,  -6.44E+00,  87,212,  -7.28E+00,  87,213,  -7.30E+00,
     & 87,214,  -6.45E+00,  87,215,  -5.52E+00,  87,216,  -4.87E+00,
     & 87,217,  -4.17E+00,  87,218,  -3.72E+00,  87,219,  -3.06E+00,
     & 87,220,  -2.78E+00,  87,221,  -2.15E+00,  87,222,  -1.87E+00,
     & 87,223,  -1.32E+00,  87,224,  -1.15E+00,  87,225,  -6.40E-01,
     & 87,226,  -5.20E-01,  87,227,  -1.90E-01,  87,228,   1.00E-02,
     & 87,229,   1.90E-01,  87,230,   4.00E-02,  87,231,   1.80E-01,
     & 87,232,  -5.00E-02,  87,233,   9.00E-02,  87,234,  -1.70E-01,
     & 87,235,   1.00E-02,  87,236,  -2.50E-01,  87,237,  -5.00E-02,
     & 87,238,  -3.60E-01,  87,239,  -2.90E-01,  87,240,  -8.00E-02/
      data (nsz(i),nsa(i),shin(i),i=5671,5700)/
     & 87,241,   3.90E-01,  87,242,   4.60E-01,  87,243,   7.50E-01,
     & 87,244,   7.00E-01,  87,245,   8.50E-01,  87,246,   5.20E-01,
     & 87,247,   4.90E-01,  87,248,   1.00E-01,  87,249,   1.10E-01,
     & 87,250,  -1.70E-01,  87,251,   1.23E+00,  87,252,   9.30E-01,
     & 87,253,   6.70E-01,  87,254,   7.00E-02,  87,255,  -3.60E-01,
     & 87,256,  -8.90E-01,  87,257,  -1.20E+00,  87,258,  -1.77E+00,
     & 87,259,  -2.85E+00,  87,260,  -2.52E+00,  87,261,  -2.68E+00,
     & 87,262,  -3.39E+00,  87,263,  -4.10E+00,  87,264,  -4.67E+00,
     & 87,265,  -4.63E+00,  87,266,  -5.26E+00,  87,267,  -5.41E+00,
     & 87,268,  -5.99E+00,  87,269,  -5.98E+00,  87,270,  -6.42E+00/
      data (nsz(i),nsa(i),shin(i),i=5701,5730)/
     & 87,271,  -6.07E+00,  87,272,  -5.20E+00,  87,273,  -4.57E+00,
     & 87,274,  -3.56E+00,  87,275,  -2.79E+00,  87,276,  -1.45E+00,
     & 87,277,  -1.27E+00,  87,278,  -1.41E+00,  87,279,  -1.27E+00,
     & 87,280,  -1.53E+00,  87,281,  -1.44E+00,  87,282,  -1.44E+00,
     & 87,283,  -1.35E+00,  87,284,  -1.12E+00,  87,285,  -6.50E-01,
     & 87,286,  -1.89E+00,  87,287,  -1.72E+00,  87,288,  -4.00E-02,
     & 87,289,   1.10E-01,  88,192,   3.50E-01,  88,193,   5.90E-01,
     & 88,194,   8.80E-01,  88,195,   1.14E+00,  88,196,   1.27E+00,
     & 88,197,   1.27E+00,  88,198,   1.65E+00,  88,199,   1.37E+00,
     & 88,200,   1.22E+00,  88,201,   8.90E-01,  88,202,   6.50E-01/
      data (nsz(i),nsa(i),shin(i),i=5731,5760)/
     & 88,203,   2.50E-01,  88,204,  -2.30E-01,  88,205,  -7.80E-01,
     & 88,206,  -1.61E+00,  88,207,  -2.31E+00,  88,208,  -2.90E+00,
     & 88,209,  -3.51E+00,  88,210,  -3.98E+00,  88,211,  -5.07E+00,
     & 88,212,  -5.44E+00,  88,213,  -6.29E+00,  88,214,  -6.15E+00,
     & 88,215,  -5.42E+00,  88,216,  -4.60E+00,  88,217,  -3.99E+00,
     & 88,218,  -3.45E+00,  88,219,  -2.98E+00,  88,220,  -2.60E+00,
     & 88,221,  -2.45E+00,  88,222,  -1.87E+00,  88,223,  -1.74E+00,
     & 88,224,  -1.23E+00,  88,225,  -1.09E+00,  88,226,  -7.40E-01,
     & 88,227,  -5.30E-01,  88,228,  -3.40E-01,  88,229,  -1.60E-01,
     & 88,230,   3.00E-02,  88,231,  -1.40E-01,  88,232,  -3.00E-02/
      data (nsz(i),nsa(i),shin(i),i=5761,5790)/
     & 88,233,  -2.60E-01,  88,234,  -7.00E-02,  88,235,  -4.20E-01,
     & 88,236,  -2.50E-01,  88,237,  -5.10E-01,  88,238,  -3.00E-01,
     & 88,239,  -4.80E-01,  88,240,  -4.00E-01,  88,241,  -1.60E-01,
     & 88,242,   3.60E-01,  88,243,   4.50E-01,  88,244,   6.90E-01,
     & 88,245,   6.60E-01,  88,246,   8.80E-01,  88,247,   5.80E-01,
     & 88,248,   6.00E-01,  88,249,   2.30E-01,  88,250,   2.30E-01,
     & 88,251,   3.00E-02,  88,252,   2.80E-01,  88,253,   1.29E+00,
     & 88,254,   1.21E+00,  88,255,   5.00E-01,  88,256,   1.70E-01,
     & 88,257,  -4.60E-01,  88,258,  -6.90E-01,  88,259,  -1.25E+00,
     & 88,260,  -2.47E+00,  88,261,  -1.92E+00,  88,262,  -2.10E+00/
      data (nsz(i),nsa(i),shin(i),i=5791,5820)/
     & 88,263,  -2.75E+00,  88,264,  -3.55E+00,  88,265,  -3.99E+00,
     & 88,266,  -4.04E+00,  88,267,  -4.49E+00,  88,268,  -4.64E+00,
     & 88,269,  -5.14E+00,  88,270,  -5.13E+00,  88,271,  -5.52E+00,
     & 88,272,  -5.15E+00,  88,273,  -4.28E+00,  88,274,  -3.66E+00,
     & 88,275,  -2.71E+00,  88,276,  -1.95E+00,  88,277,  -1.33E+00,
     & 88,278,  -1.13E+00,  88,279,  -1.34E+00,  88,280,  -1.23E+00,
     & 88,281,  -1.46E+00,  88,282,  -1.16E+00,  88,283,  -1.27E+00,
     & 88,284,  -1.13E+00,  88,285,  -7.50E-01,  88,286,  -5.90E-01,
     & 88,287,  -7.80E-01,  88,288,  -1.65E+00,  88,289,  -6.00E-02,
     & 88,290,   7.00E-02,  88,291,  -2.20E+00,  88,292,  -2.09E+00/
      data (nsz(i),nsa(i),shin(i),i=5821,5850)/
     & 89,195,   5.40E-01,  89,196,   6.80E-01,  89,197,   8.60E-01,
     & 89,198,   1.03E+00,  89,199,   1.47E+00,  89,200,   1.74E+00,
     & 89,201,   1.57E+00,  89,202,   1.28E+00,  89,203,   1.02E+00,
     & 89,204,   6.20E-01,  89,205,   1.60E-01,  89,206,  -3.50E-01,
     & 89,207,  -9.40E-01,  89,208,  -1.52E+00,  89,209,  -2.56E+00,
     & 89,210,  -3.20E+00,  89,211,  -3.70E+00,  89,212,  -4.24E+00,
     & 89,213,  -4.66E+00,  89,214,  -5.38E+00,  89,215,  -5.38E+00,
     & 89,216,  -4.58E+00,  89,217,  -3.85E+00,  89,218,  -3.30E+00,
     & 89,219,  -2.77E+00,  89,220,  -2.45E+00,  89,221,  -2.15E+00,
     & 89,222,  -2.19E+00,  89,223,  -1.72E+00,  89,224,  -1.75E+00/
      data (nsz(i),nsa(i),shin(i),i=5851,5880)/
     & 89,225,  -1.34E+00,  89,226,  -1.34E+00,  89,227,  -1.08E+00,
     & 89,228,  -9.60E-01,  89,229,  -4.90E-01,  89,230,  -4.70E-01,
     & 89,231,  -4.40E-01,  89,232,  -5.40E-01,  89,233,  -4.50E-01,
     & 89,234,  -6.30E-01,  89,235,  -4.30E-01,  89,236,  -7.70E-01,
     & 89,237,  -5.70E-01,  89,238,  -8.40E-01,  89,239,  -6.20E-01,
     & 89,240,  -9.70E-01,  89,241,  -7.00E-01,  89,242,  -4.30E-01,
     & 89,243,  -4.00E-02,  89,244,   2.30E-01,  89,245,   5.50E-01,
     & 89,246,   5.50E-01,  89,247,   7.40E-01,  89,248,   4.90E-01,
     & 89,249,   5.20E-01,  89,250,   2.10E-01,  89,251,   2.60E-01,
     & 89,252,   5.00E-02,  89,253,   3.20E-01,  89,254,   1.46E+00/
      data (nsz(i),nsa(i),shin(i),i=5881,5910)/
     & 89,255,   1.48E+00,  89,256,   9.30E-01,  89,257,   4.50E-01,
     & 89,258,  -4.00E-02,  89,259,  -3.30E-01,  89,260,  -7.90E-01,
     & 89,261,  -2.12E+00,  89,262,  -1.58E+00,  89,263,  -1.75E+00,
     & 89,264,  -2.41E+00,  89,265,  -3.05E+00,  89,266,  -3.60E+00,
     & 89,267,  -3.62E+00,  89,268,  -3.98E+00,  89,269,  -4.11E+00,
     & 89,270,  -4.60E+00,  89,271,  -4.54E+00,  89,272,  -4.93E+00,
     & 89,273,  -4.55E+00,  89,274,  -3.69E+00,  89,275,  -3.07E+00,
     & 89,276,  -2.11E+00,  89,277,  -1.36E+00,  89,278,  -1.46E+00,
     & 89,279,  -1.31E+00,  89,280,  -1.44E+00,  89,281,  -1.36E+00,
     & 89,282,  -1.63E+00,  89,283,  -1.44E+00,  89,284,  -1.63E+00/
      data (nsz(i),nsa(i),shin(i),i=5911,5940)/
     & 89,285,  -1.36E+00,  89,286,  -1.31E+00,  89,287,  -1.16E+00,
     & 89,288,  -1.98E+00,  89,289,  -1.83E+00,  89,290,  -3.00E-01,
     & 89,291,  -2.00E-01,  89,292,  -2.38E+00,  89,293,  -2.23E+00,
     & 89,294,  -2.49E+00,  89,295,  -2.29E+00,  90,198,   8.70E-01,
     & 90,199,   9.90E-01,  90,200,   1.25E+00,  90,201,   1.74E+00,
     & 90,202,   1.96E+00,  90,203,   1.70E+00,  90,204,   1.48E+00,
     & 90,205,   1.10E+00,  90,206,   6.50E-01,  90,207,   1.10E-01,
     & 90,208,  -5.30E-01,  90,209,  -1.12E+00,  90,210,  -1.71E+00,
     & 90,211,  -2.23E+00,  90,212,  -2.55E+00,  90,213,  -3.22E+00,
     & 90,214,  -3.75E+00,  90,215,  -4.70E+00,  90,216,  -4.65E+00/
      data (nsz(i),nsa(i),shin(i),i=5941,5970)/
     & 90,217,  -3.86E+00,  90,218,  -3.16E+00,  90,219,  -2.61E+00,
     & 90,220,  -2.19E+00,  90,221,  -1.75E+00,  90,222,  -1.57E+00,
     & 90,223,  -1.49E+00,  90,224,  -1.23E+00,  90,225,  -1.30E+00,
     & 90,226,  -1.04E+00,  90,227,  -1.05E+00,  90,228,  -1.00E+00,
     & 90,229,  -1.06E+00,  90,230,  -9.40E-01,  90,231,  -1.13E+00,
     & 90,232,  -9.20E-01,  90,233,  -1.00E+00,  90,234,  -7.90E-01,
     & 90,235,  -7.60E-01,  90,236,  -6.70E-01,  90,237,  -1.02E+00,
     & 90,238,  -8.20E-01,  90,239,  -1.03E+00,  90,240,  -8.10E-01,
     & 90,241,  -1.16E+00,  90,242,  -8.90E-01,  90,243,  -6.00E-01,
     & 90,244,  -1.90E-01,  90,245,   1.10E-01,  90,246,   4.40E-01/
      data (nsz(i),nsa(i),shin(i),i=5971,6000)/
     & 90,247,   3.70E-01,  90,248,   6.60E-01,  90,249,   4.30E-01,
     & 90,250,   4.80E-01,  90,251,   1.70E-01,  90,252,   2.20E-01,
     & 90,253,   9.00E-02,  90,254,   4.20E-01,  90,255,   5.50E-01,
     & 90,256,   1.58E+00,  90,257,   1.04E+00,  90,258,   7.60E-01,
     & 90,259,   7.00E-02,  90,260,  -4.00E-02,  90,261,  -5.70E-01,
     & 90,262,  -1.66E+00,  90,263,  -1.17E+00,  90,264,  -1.28E+00,
     & 90,265,  -1.93E+00,  90,266,  -2.50E+00,  90,267,  -3.04E+00,
     & 90,268,  -3.08E+00,  90,269,  -3.34E+00,  90,270,  -3.47E+00,
     & 90,271,  -3.93E+00,  90,272,  -3.88E+00,  90,273,  -4.19E+00,
     & 90,274,  -3.80E+00,  90,275,  -2.92E+00,  90,276,  -2.32E+00/
      data (nsz(i),nsa(i),shin(i),i=6001,6030)/
     & 90,277,  -1.43E+00,  90,278,  -8.10E-01,  90,279,  -1.35E+00,
     & 90,280,  -1.19E+00,  90,281,  -1.31E+00,  90,282,  -1.13E+00,
     & 90,283,  -1.44E+00,  90,284,  -1.31E+00,  90,285,  -1.50E+00,
     & 90,286,  -1.24E+00,  90,287,  -1.21E+00,  90,288,  -1.50E+00,
     & 90,289,  -1.79E+00,  90,290,  -6.00E-02,  90,291,  -3.80E-01,
     & 90,292,  -2.60E-01,  90,293,  -2.26E+00,  90,294,  -2.11E+00,
     & 90,295,  -2.37E+00,  90,296,  -2.17E+00,  90,297,  -2.24E+00,
     & 90,298,  -1.64E+00,  90,299,  -2.21E+00,  91,200,   6.80E-01,
     & 91,201,   9.60E-01,  91,202,   1.55E+00,  91,203,   1.57E+00,
     & 91,204,   1.48E+00,  91,205,   1.47E+00,  91,206,   1.11E+00/
      data (nsz(i),nsa(i),shin(i),i=6031,6060)/
     & 91,207,   9.50E-01,  91,208,   4.10E-01,  91,209,  -1.80E-01,
     & 91,210,  -7.30E-01,  91,211,  -1.29E+00,  91,212,  -1.66E+00,
     & 91,213,  -1.95E+00,  91,214,  -2.55E+00,  91,215,  -3.41E+00,
     & 91,216,  -3.95E+00,  91,217,  -3.76E+00,  91,218,  -3.02E+00,
     & 91,219,  -2.59E+00,  91,220,  -1.90E+00,  91,221,   1.60E-01,
     & 91,222,  -1.45E+00,  91,223,  -1.13E+00,  91,224,  -1.36E+00,
     & 91,225,  -1.15E+00,  91,226,  -1.44E+00,  91,227,  -1.22E+00,
     & 91,228,  -1.44E+00,  91,229,  -1.28E+00,  91,230,  -1.50E+00,
     & 91,231,  -1.39E+00,  91,232,  -1.64E+00,  91,233,  -1.46E+00,
     & 91,234,  -1.62E+00,  91,235,  -1.26E+00,  91,236,  -1.49E+00/
      data (nsz(i),nsa(i),shin(i),i=6061,6090)/
     & 91,237,  -1.07E+00,  91,238,  -1.42E+00,  91,239,  -1.21E+00,
     & 91,240,  -1.40E+00,  91,241,  -1.18E+00,  91,242,  -1.33E+00,
     & 91,243,  -1.29E+00,  91,244,  -1.17E+00,  91,245,  -5.40E-01,
     & 91,246,  -1.60E-01,  91,247,   1.40E-01,  91,248,   1.20E-01,
     & 91,249,   3.70E-01,  91,250,   2.00E-01,  91,251,   2.70E-01,
     & 91,252,   1.00E-02,  91,253,   1.00E-01,  91,254,  -3.00E-02,
     & 91,255,   3.40E-01,  91,256,   6.00E-01,  91,257,   6.60E-01,
     & 91,258,   1.09E+00,  91,259,   8.30E-01,  91,260,   3.90E-01,
     & 91,261,   1.60E-01,  91,262,  -2.70E-01,  91,263,  -1.37E+00,
     & 91,264,  -8.20E-01,  91,265,  -9.30E-01,  91,266,  -1.48E+00/
      data (nsz(i),nsa(i),shin(i),i=6091,6120)/
     & 91,267,  -2.11E+00,  91,268,  -2.62E+00,  91,269,  -2.64E+00,
     & 91,270,  -2.88E+00,  91,271,  -2.99E+00,  91,272,  -3.43E+00,
     & 91,273,  -3.34E+00,  91,274,  -3.64E+00,  91,275,  -3.22E+00,
     & 91,276,  -2.34E+00,  91,277,  -1.75E+00,  91,278,  -9.10E-01,
     & 91,279,  -1.24E+00,  91,280,  -1.42E+00,  91,281,  -1.18E+00,
     & 91,282,  -1.34E+00,  91,283,  -1.23E+00,  91,284,  -1.56E+00,
     & 91,285,  -1.41E+00,  91,286,  -1.67E+00,  91,287,  -1.48E+00,
     & 91,288,  -1.69E+00,  91,289,  -1.59E+00,  91,290,  -1.81E+00,
     & 91,291,  -3.60E-01,  91,292,  -7.00E-01,  91,293,  -6.00E-01,
     & 91,294,  -8.30E-01,  91,295,  -2.12E+00,  91,296,  -2.42E+00/
      data (nsz(i),nsa(i),shin(i),i=6121,6150)/
     & 91,297,  -2.05E+00,  91,298,  -2.05E+00,  91,299,  -1.72E+00,
     & 91,300,  -1.26E+00,  91,301,  -2.42E+00,  91,302,  -2.54E+00,
     & 92,203,   1.32E+00,  92,204,   1.50E+00,  92,205,   1.46E+00,
     & 92,206,   1.57E+00,  92,207,   1.20E+00,  92,208,   1.08E+00,
     & 92,209,   7.90E-01,  92,210,   1.80E-01,  92,211,  -3.50E-01,
     & 92,212,  -8.80E-01,  92,213,  -1.30E+00,  92,214,  -1.49E+00,
     & 92,215,  -2.07E+00,  92,216,  -2.52E+00,  92,217,  -3.26E+00,
     & 92,218,  -3.33E+00,  92,219,  -2.39E+00,  92,220,  -1.61E+00,
     & 92,221,  -1.27E+00,  92,222,  -5.10E-01,  92,223,  -9.50E-01,
     & 92,224,  -5.30E-01,  92,225,  -7.40E-01,  92,226,  -8.70E-01/
      data (nsz(i),nsa(i),shin(i),i=6151,6180)/
     & 92,227,  -3.60E-01,  92,228,  -9.90E-01,  92,229,  -1.23E+00,
     & 92,230,  -1.29E+00,  92,231,  -1.59E+00,  92,232,  -1.53E+00,
     & 92,233,  -1.93E+00,  92,234,  -1.72E+00,  92,235,  -1.91E+00,
     & 92,236,  -1.65E+00,  92,237,  -1.92E+00,  92,238,  -1.50E+00,
     & 92,239,  -1.69E+00,  92,240,  -1.30E+00,  92,241,  -1.62E+00,
     & 92,242,  -1.41E+00,  92,243,  -1.57E+00,  92,244,  -1.49E+00,
     & 92,245,  -1.41E+00,  92,246,  -7.40E-01,  92,247,  -3.90E-01,
     & 92,248,  -8.00E-02,  92,249,  -8.00E-02,  92,250,   1.90E-01,
     & 92,251,   0.00E+00,  92,252,   8.00E-02,  92,253,  -1.70E-01,
     & 92,254,  -6.00E-02,  92,255,  -1.40E-01,  92,256,   2.80E-01/
      data (nsz(i),nsa(i),shin(i),i=6181,6210)/
     & 92,257,   2.10E-01,  92,258,   6.80E-01,  92,259,   4.20E-01,
     & 92,260,   6.70E-01,  92,261,   3.60E-01,  92,262,   3.60E-01,
     & 92,263,  -6.00E-02,  92,264,  -1.03E+00,  92,265,  -6.60E-01,
     & 92,266,  -7.20E-01,  92,267,  -1.29E+00,  92,268,  -1.75E+00,
     & 92,269,  -2.23E+00,  92,270,  -2.28E+00,  92,271,  -2.45E+00,
     & 92,272,  -2.53E+00,  92,273,  -2.96E+00,  92,274,  -2.84E+00,
     & 92,275,  -3.13E+00,  92,276,  -2.71E+00,  92,277,  -1.79E+00,
     & 92,278,  -1.20E+00,  92,279,  -4.50E-01,  92,280,  -1.04E+00,
     & 92,281,  -1.25E+00,  92,282,  -1.10E+00,  92,283,  -1.29E+00,
     & 92,284,  -1.08E+00,  92,285,  -1.33E+00,  92,286,  -1.21E+00/
      data (nsz(i),nsa(i),shin(i),i=6211,6240)/
     & 92,287,  -1.46E+00,  92,288,  -1.20E+00,  92,289,  -1.38E+00,
     & 92,290,  -1.29E+00,  92,291,  -1.49E+00,  92,292,  -3.50E-01,
     & 92,293,  -6.60E-01,  92,294,  -7.10E-01,  92,295,  -1.01E+00,
     & 92,296,  -8.30E-01,  92,297,  -8.30E-01,  92,298,  -1.62E+00,
     & 92,299,  -1.77E+00,  92,300,  -1.28E+00,  92,301,  -2.42E+00,
     & 92,302,  -2.44E+00,  92,303,  -2.57E+00,  92,304,  -4.40E-01,
     & 92,305,  -2.43E+00,  93,206,   1.07E+00,  93,207,   1.19E+00,
     & 93,208,   1.12E+00,  93,209,   9.90E-01,  93,210,   7.30E-01,
     & 93,211,   4.20E-01,  93,212,  -1.00E-01,  93,213,  -5.60E-01,
     & 93,214,  -9.70E-01,  93,215,  -1.07E+00,  93,216,  -1.58E+00/
      data (nsz(i),nsa(i),shin(i),i=6241,6270)/
     & 93,217,  -1.92E+00,  93,218,  -2.51E+00,  93,219,  -2.68E+00,
     & 93,220,  -1.70E+00,  93,221,  -9.80E-01,  93,222,   3.00E-01,
     & 93,223,  -7.30E-01,  93,224,  -4.70E-01,  93,225,   1.00E-02,
     & 93,226,  -8.00E-02,  93,227,  -1.40E-01,  93,228,  -5.20E-01,
     & 93,229,  -1.16E+00,  93,230,  -1.52E+00,  93,231,  -1.57E+00,
     & 93,232,  -1.29E+00,  93,233,  -1.35E+00,  93,234,  -2.40E+00,
     & 93,235,  -2.29E+00,  93,236,  -2.56E+00,  93,237,  -2.29E+00,
     & 93,238,  -2.55E+00,  93,239,  -2.18E+00,  93,240,  -2.25E+00,
     & 93,241,  -2.03E+00,  93,242,  -2.19E+00,  93,243,  -1.64E+00,
     & 93,244,  -2.00E+00,  93,245,  -1.96E+00,  93,246,  -1.83E+00/
      data (nsz(i),nsa(i),shin(i),i=6271,6300)/
     & 93,247,  -1.19E+00,  93,248,  -1.00E+00,  93,249,  -4.30E-01,
     & 93,250,  -4.20E-01,  93,251,  -1.30E-01,  93,252,  -2.90E-01,
     & 93,253,  -1.70E-01,  93,254,  -4.20E-01,  93,255,  -3.00E-01,
     & 93,256,  -3.50E-01,  93,257,   5.00E-02,  93,258,   3.00E-02,
     & 93,259,   6.10E-01,  93,260,   3.80E-01,  93,261,   5.80E-01,
     & 93,262,   3.40E-01,  93,263,   4.80E-01,  93,264,   1.00E-02,
     & 93,265,  -8.50E-01,  93,266,  -4.50E-01,  93,267,  -4.60E-01,
     & 93,268,  -1.00E+00,  93,269,  -1.46E+00,  93,270,  -1.93E+00,
     & 93,271,  -1.95E+00,  93,272,  -2.02E+00,  93,273,  -2.02E+00,
     & 93,274,  -2.40E+00,  93,275,  -2.22E+00,  93,276,  -2.57E+00/
      data (nsz(i),nsa(i),shin(i),i=6301,6330)/
     & 93,277,  -2.13E+00,  93,278,  -1.24E+00,  93,279,  -6.70E-01,
     & 93,280,  -1.29E+00,  93,281,  -1.11E+00,  93,282,  -1.38E+00,
     & 93,283,  -1.26E+00,  93,284,  -1.36E+00,  93,285,  -1.27E+00,
     & 93,286,  -1.51E+00,  93,287,  -1.31E+00,  93,288,  -1.52E+00,
     & 93,289,  -1.20E+00,  93,290,  -1.01E+00,  93,291,  -8.70E-01,
     & 93,292,  -4.40E-01,  93,293,  -5.60E-01,  93,294,  -1.02E+00,
     & 93,295,  -9.80E-01,  93,296,  -1.40E+00,  93,297,  -1.24E+00,
     & 93,298,  -1.52E+00,  93,299,  -1.28E+00,  93,300,  -2.23E+00,
     & 93,301,  -2.31E+00,  93,302,  -2.73E+00,  93,303,  -2.74E+00,
     & 93,304,  -2.84E+00,  93,305,  -7.60E-01,  93,306,  -2.68E+00/
      data (nsz(i),nsa(i),shin(i),i=6331,6360)/
     & 93,307,  -2.40E+00,  93,308,  -2.29E+00,  94,209,   9.60E-01,
     & 94,210,   9.50E-01,  94,211,   6.40E-01,  94,212,   5.00E-01,
     & 94,213,   1.20E-01,  94,214,  -3.30E-01,  94,215,  -7.10E-01,
     & 94,216,  -8.00E-01,  94,217,  -1.29E+00,  94,218,  -1.62E+00,
     & 94,219,  -2.28E+00,  94,220,  -2.34E+00,  94,221,  -1.40E+00,
     & 94,222,  -6.30E-01,  94,223,  -6.40E-01,  94,224,  -2.50E-01,
     & 94,225,  -1.40E-01,  94,226,   2.50E-01,  94,227,   2.40E-01,
     & 94,228,   9.00E-02,  94,229,  -2.60E-01,  94,230,  -4.10E-01,
     & 94,231,  -7.40E-01,  94,232,  -1.45E+00,  94,233,  -1.84E+00,
     & 94,234,  -1.86E+00,  94,235,  -2.36E+00,  94,236,  -2.24E+00/
      data (nsz(i),nsa(i),shin(i),i=6361,6390)/
     & 94,237,  -2.60E+00,  94,238,  -2.39E+00,  94,239,  -2.78E+00,
     & 94,240,  -2.36E+00,  94,241,  -2.58E+00,  94,242,  -2.18E+00,
     & 94,243,  -2.42E+00,  94,244,  -1.97E+00,  94,245,  -2.12E+00,
     & 94,246,  -1.72E+00,  94,247,  -2.13E+00,  94,248,  -1.45E+00,
     & 94,249,  -1.25E+00,  94,250,  -7.30E-01,  94,251,  -7.40E-01,
     & 94,252,  -4.60E-01,  94,253,  -5.90E-01,  94,254,  -4.80E-01,
     & 94,255,  -7.10E-01,  94,256,  -5.90E-01,  94,257,  -6.20E-01,
     & 94,258,  -1.80E-01,  94,259,  -1.30E-01,  94,260,   5.10E-01,
     & 94,261,   3.20E-01,  94,262,   3.50E-01,  94,263,   4.10E-01,
     & 94,264,   5.60E-01,  94,265,   8.00E-02,  94,266,  -6.70E-01/
      data (nsz(i),nsa(i),shin(i),i=6391,6420)/
     & 94,267,  -3.50E-01,  94,268,  -3.90E-01,  94,269,  -8.80E-01,
     & 94,270,  -1.38E+00,  94,271,  -1.73E+00,  94,272,  -1.74E+00,
     & 94,273,  -1.81E+00,  94,274,  -1.81E+00,  94,275,  -2.21E+00,
     & 94,276,  -2.04E+00,  94,277,  -2.28E+00,  94,278,  -1.83E+00,
     & 94,279,  -9.90E-01,  94,280,  -3.80E-01,  94,281,   1.00E-01,
     & 94,282,  -7.40E-01,  94,283,  -1.09E+00,  94,284,  -8.60E-01,
     & 94,285,  -1.20E+00,  94,286,  -1.00E+00,  94,287,  -1.22E+00,
     & 94,288,  -9.00E-01,  94,289,  -7.60E-01,  94,290,  -6.00E-01,
     & 94,291,  -7.90E-01,  94,292,  -2.50E-01,  94,293,  -5.70E-01,
     & 94,294,  -5.40E-01,  94,295,  -1.06E+00,  94,296,  -1.12E+00/
      data (nsz(i),nsa(i),shin(i),i=6421,6450)/
     & 94,297,  -1.39E+00,  94,298,  -1.41E+00,  94,299,  -1.52E+00,
     & 94,300,  -1.82E+00,  94,301,  -2.29E+00,  94,302,  -2.37E+00,
     & 94,303,  -2.79E+00,  94,304,  -2.82E+00,  94,305,  -2.91E+00,
     & 94,306,  -2.62E+00,  94,307,  -2.81E+00,  94,308,  -2.42E+00,
     & 94,309,  -2.55E+00,  94,310,  -2.33E+00,  94,311,  -2.52E+00,
     & 94,312,  -2.52E+00,  95,212,   4.90E-01,  95,213,   3.00E-01,
     & 95,214,   2.90E-01,  95,215,  -9.00E-02,  95,216,  -3.90E-01,
     & 95,217,  -5.10E-01,  95,218,  -9.30E-01,  95,219,  -1.18E+00,
     & 95,220,  -1.69E+00,  95,221,  -1.88E+00,  95,222,  -7.90E-01,
     & 95,223,  -1.90E-01,  95,224,   1.05E+00,  95,225,   2.20E-01/
      data (nsz(i),nsa(i),shin(i),i=6451,6480)/
     & 95,226,   3.80E-01,  95,227,   4.90E-01,  95,228,   1.60E-01,
     & 95,229,  -2.00E-02,  95,230,  -3.80E-01,  95,231,  -5.10E-01,
     & 95,232,  -8.70E-01,  95,233,  -9.80E-01,  95,234,  -1.37E+00,
     & 95,235,  -1.52E+00,  95,236,  -1.87E+00,  95,237,  -1.95E+00,
     & 95,238,  -3.23E+00,  95,239,  -3.10E+00,  95,240,  -3.43E+00,
     & 95,241,  -3.08E+00,  95,242,  -3.23E+00,  95,243,  -2.86E+00,
     & 95,244,  -3.07E+00,  95,245,  -2.63E+00,  95,246,  -2.69E+00,
     & 95,247,  -2.66E+00,  95,248,  -2.57E+00,  95,249,  -1.88E+00,
     & 95,250,  -1.65E+00,  95,251,  -1.13E+00,  95,252,  -1.13E+00,
     & 95,253,  -8.50E-01,  95,254,  -1.00E+00,  95,255,  -8.60E-01/
      data (nsz(i),nsa(i),shin(i),i=6481,6510)/
     & 95,256,  -1.05E+00,  95,257,  -9.20E-01,  95,258,  -9.30E-01,
     & 95,259,  -4.70E-01,  95,260,  -3.90E-01,  95,261,   3.00E-01,
     & 95,262,   9.00E-02,  95,263,   2.10E-01,  95,264,   1.40E-01,
     & 95,265,   5.70E-01,  95,266,   1.00E-01,  95,267,  -5.50E-01,
     & 95,268,  -3.40E-01,  95,269,  -2.80E-01,  95,270,  -7.60E-01,
     & 95,271,  -1.20E+00,  95,272,  -1.64E+00,  95,273,  -1.52E+00,
     & 95,274,  -1.53E+00,  95,275,  -1.49E+00,  95,276,  -1.82E+00,
     & 95,277,  -1.62E+00,  95,278,  -1.82E+00,  95,279,  -1.34E+00,
     & 95,280,  -7.00E-01,  95,281,  -1.00E-01,  95,282,  -8.60E-01,
     & 95,283,  -7.10E-01,  95,284,  -9.60E-01,  95,285,  -8.50E-01/
      data (nsz(i),nsa(i),shin(i),i=6511,6540)/
     & 95,286,  -1.13E+00,  95,287,   2.00E-01,  95,288,  -1.11E+00,
     & 95,289,  -6.30E-01,  95,290,  -8.40E-01,  95,291,  -3.80E-01,
     & 95,292,  -6.50E-01,  95,293,  -6.80E-01,  95,294,  -1.00E+00,
     & 95,295,  -9.90E-01,  95,296,  -1.43E+00,  95,297,  -1.57E+00,
     & 95,298,  -1.80E+00,  95,299,  -1.86E+00,  95,300,  -2.20E+00,
     & 95,301,  -2.16E+00,  95,302,  -2.57E+00,  95,303,  -2.64E+00,
     & 95,304,  -3.06E+00,  95,305,  -3.08E+00,  95,306,  -3.16E+00,
     & 95,307,  -2.86E+00,  95,308,  -3.03E+00,  95,309,  -2.70E+00,
     & 95,310,  -2.92E+00,  95,311,  -2.57E+00,  95,312,  -2.97E+00,
     & 95,313,  -2.95E+00,  95,314,  -3.21E+00,  95,315,  -3.19E+00/
      data (nsz(i),nsa(i),shin(i),i=6541,6570)/
     & 96,215,   8.00E-02,  96,216,   2.00E-02,  96,217,  -2.90E-01,
     & 96,218,  -4.20E-01,  96,219,  -8.30E-01,  96,220,  -1.09E+00,
     & 96,221,  -1.67E+00,  96,222,  -1.76E+00,  96,223,  -7.80E-01,
     & 96,224,  -3.60E-01,  96,225,   1.18E+00,  96,226,   3.70E-01,
     & 96,227,   6.60E-01,  96,228,   7.10E-01,  96,229,   4.20E-01,
     & 96,230,   2.40E-01,  96,231,  -1.00E-01,  96,232,  -2.70E-01,
     & 96,233,  -6.20E-01,  96,234,  -7.50E-01,  96,235,  -1.15E+00,
     & 96,236,  -1.33E+00,  96,237,  -1.66E+00,  96,238,  -2.74E+00,
     & 96,239,  -2.06E+00,  96,240,  -3.04E+00,  96,241,  -3.46E+00,
     & 96,242,  -3.07E+00,  96,243,  -3.35E+00,  96,244,  -3.05E+00/
      data (nsz(i),nsa(i),shin(i),i=6571,6600)/
     & 96,245,  -3.40E+00,  96,246,  -2.99E+00,  96,247,  -3.20E+00,
     & 96,248,  -2.79E+00,  96,249,  -2.79E+00,  96,250,  -2.23E+00,
     & 96,251,  -2.15E+00,  96,252,  -1.62E+00,  96,253,  -1.45E+00,
     & 96,254,  -1.19E+00,  96,255,  -1.33E+00,  96,256,  -1.20E+00,
     & 96,257,  -1.42E+00,  96,258,  -1.29E+00,  96,259,  -1.30E+00,
     & 96,260,  -8.10E-01,  96,261,  -7.20E-01,  96,262,  -2.30E-01,
     & 96,263,  -6.00E-02,  96,264,   4.00E-02,  96,265,  -2.40E-01,
     & 96,266,   5.00E-01,  96,267,   6.00E-02,  96,268,  -4.40E-01,
     & 96,269,  -3.80E-01,  96,270,  -3.10E-01,  96,271,  -7.90E-01,
     & 96,272,  -1.10E+00,  96,273,  -1.52E+00,  96,274,  -1.41E+00/
      data (nsz(i),nsa(i),shin(i),i=6601,6630)/
     & 96,275,  -1.47E+00,  96,276,  -1.41E+00,  96,277,  -1.73E+00,
     & 96,278,  -1.53E+00,  96,279,  -1.71E+00,  96,280,  -1.23E+00,
     & 96,281,  -5.30E-01,  96,282,   1.00E-02,  96,283,   4.40E-01,
     & 96,284,   9.60E-01,  96,285,   5.20E-01,  96,286,   4.30E-01,
     & 96,287,   1.20E-01,  96,288,   9.00E-02,  96,289,  -1.80E-01,
     & 96,290,  -1.90E-01,  96,291,  -4.30E-01,  96,292,  -4.30E-01,
     & 96,293,  -7.30E-01,  96,294,  -7.50E-01,  96,295,  -1.11E+00,
     & 96,296,  -1.11E+00,  96,297,  -1.48E+00,  96,298,  -1.50E+00,
     & 96,299,  -1.97E+00,  96,300,  -1.91E+00,  96,301,  -2.24E+00,
     & 96,302,  -2.18E+00,  96,303,  -2.58E+00,  96,304,  -2.66E+00/
      data (nsz(i),nsa(i),shin(i),i=6631,6660)/
     & 96,305,  -3.08E+00,  96,306,  -3.09E+00,  96,307,  -3.17E+00,
     & 96,308,  -2.91E+00,  96,309,  -3.08E+00,  96,310,  -2.77E+00,
     & 96,311,  -3.00E+00,  96,312,  -2.79E+00,  96,313,  -3.12E+00,
     & 96,314,  -3.13E+00,  96,315,  -3.36E+00,  96,316,  -3.33E+00,
     & 96,317,  -3.55E+00,  96,318,  -3.24E+00,  97,218,  -1.60E-01,
     & 97,219,  -2.60E-01,  97,220,  -6.50E-01,  97,221,  -8.30E-01,
     & 97,222,  -1.27E+00,  97,223,  -1.47E+00,  97,224,  -3.80E-01,
     & 97,225,  -2.50E-01,  97,226,   1.35E+00,  97,227,   8.40E-01,
     & 97,228,   6.20E-01,  97,229,   4.70E-01,  97,230,   2.80E-01,
     & 97,231,   8.00E-02,  97,232,  -2.40E-01,  97,233,  -3.90E-01/
      data (nsz(i),nsa(i),shin(i),i=6661,6690)/
     & 97,234,  -7.50E-01,  97,235,  -9.20E-01,  97,236,  -1.32E+00,
     & 97,237,  -1.52E+00,  97,238,  -1.85E+00,  97,239,  -2.03E+00,
     & 97,240,  -2.48E+00,  97,241,  -2.48E+00,  97,242,  -2.79E+00,
     & 97,243,  -3.58E+00,  97,244,  -3.85E+00,  97,245,  -3.68E+00,
     & 97,246,  -3.52E+00,  97,247,  -3.73E+00,  97,248,  -3.87E+00,
     & 97,249,  -3.56E+00,  97,250,  -3.45E+00,  97,251,  -2.83E+00,
     & 97,252,  -2.55E+00,  97,253,  -2.17E+00,  97,254,  -1.95E+00,
     & 97,255,  -1.69E+00,  97,256,  -1.82E+00,  97,257,  -1.69E+00,
     & 97,258,  -1.89E+00,  97,259,  -1.76E+00,  97,260,  -1.76E+00,
     & 97,261,  -1.27E+00,  97,262,  -1.11E+00,  97,263,  -6.70E-01/
      data (nsz(i),nsa(i),shin(i),i=6691,6720)/
     & 97,264,  -3.50E-01,  97,265,  -2.10E-01,  97,266,  -4.70E-01,
     & 97,267,   2.20E-01,  97,268,   0.00E+00,  97,269,  -4.50E-01,
     & 97,270,  -4.40E-01,  97,271,  -4.00E-01,  97,272,  -8.10E-01,
     & 97,273,  -1.03E+00,  97,274,  -1.46E+00,  97,275,  -1.31E+00,
     & 97,276,  -1.29E+00,  97,277,  -1.23E+00,  97,278,  -1.52E+00,
     & 97,279,  -1.26E+00,  97,280,  -1.39E+00,  97,281,  -9.00E-01,
     & 97,282,  -3.80E-01,  97,283,   1.30E-01,  97,284,   4.70E-01,
     & 97,285,   5.60E-01,  97,286,   2.60E-01,  97,287,   1.80E-01,
     & 97,288,  -1.40E-01,  97,289,  -1.60E-01,  97,290,  -4.40E-01,
     & 97,291,  -4.50E-01,  97,292,  -7.20E-01,  97,293,  -7.30E-01/
      data (nsz(i),nsa(i),shin(i),i=6721,6750)/
     & 97,294,  -1.09E+00,  97,295,  -1.06E+00,  97,296,  -1.50E+00,
     & 97,297,  -1.57E+00,  97,298,  -1.95E+00,  97,299,  -1.93E+00,
     & 97,300,  -2.44E+00,  97,301,  -2.38E+00,  97,302,  -2.74E+00,
     & 97,303,  -2.44E+00,  97,304,  -2.77E+00,  97,305,  -2.88E+00,
     & 97,306,  -3.31E+00,  97,307,  -3.32E+00,  97,308,  -3.58E+00,
     & 97,309,  -3.35E+00,  97,310,  -3.38E+00,  97,311,  -3.13E+00,
     & 97,312,  -3.30E+00,  97,313,  -3.11E+00,  97,314,  -3.52E+00,
     & 97,315,  -3.52E+00,  97,316,  -3.70E+00,  97,317,  -3.67E+00,
     & 97,318,  -3.89E+00,  97,319,  -3.61E+00,  97,320,  -3.73E+00,
     & 97,321,  -3.37E+00,  98,221,  -7.30E-01,  98,222,  -9.30E-01/
      data (nsz(i),nsa(i),shin(i),i=6751,6780)/
     & 98,223,  -1.37E+00,  98,224,  -1.52E+00,  98,225,  -5.40E-01,
     & 98,226,  -2.30E-01,  98,227,   1.28E+00,  98,228,   8.60E-01,
     & 98,229,   7.00E-01,  98,230,   6.10E-01,  98,231,   3.90E-01,
     & 98,232,   2.40E-01,  98,233,   0.00E+00,  98,234,  -1.80E-01,
     & 98,235,  -5.30E-01,  98,236,  -7.00E-01,  98,237,  -1.11E+00,
     & 98,238,  -1.32E+00,  98,239,  -1.65E+00,  98,240,  -1.86E+00,
     & 98,241,  -2.34E+00,  98,242,  -3.33E+00,  98,243,  -2.92E+00,
     & 98,244,  -3.52E+00,  98,245,  -3.87E+00,  98,246,  -3.73E+00,
     & 98,247,  -4.20E+00,  98,248,  -3.91E+00,  98,249,  -4.17E+00,
     & 98,250,  -3.78E+00,  98,251,  -3.80E+00,  98,252,  -3.20E+00/
      data (nsz(i),nsa(i),shin(i),i=6781,6810)/
     & 98,253,  -3.14E+00,  98,254,  -2.62E+00,  98,255,  -2.40E+00,
     & 98,256,  -1.97E+00,  98,257,  -2.11E+00,  98,258,  -2.00E+00,
     & 98,259,  -2.21E+00,  98,260,  -2.12E+00,  98,261,  -2.16E+00,
     & 98,262,  -1.63E+00,  98,263,  -1.42E+00,  98,264,  -9.40E-01,
     & 98,265,  -5.80E-01,  98,266,  -4.90E-01,  98,267,  -6.60E-01,
     & 98,268,   4.00E-02,  98,269,  -1.90E-01,  98,270,  -4.50E-01,
     & 98,271,  -6.20E-01,  98,272,  -5.80E-01,  98,273,  -9.60E-01,
     & 98,274,  -1.08E+00,  98,275,  -1.49E+00,  98,276,  -1.35E+00,
     & 98,277,  -1.39E+00,  98,278,  -1.29E+00,  98,279,  -1.57E+00,
     & 98,280,  -1.31E+00,  98,281,  -1.41E+00,  98,282,  -9.00E-01/
      data (nsz(i),nsa(i),shin(i),i=6811,6840)/
     & 98,283,  -3.40E-01,  98,284,   1.60E-01,  98,285,   4.10E-01,
     & 98,286,   6.20E-01,  98,287,   3.10E-01,  98,288,   2.30E-01,
     & 98,289,  -9.00E-02,  98,290,  -1.10E-01,  98,291,  -4.20E-01,
     & 98,292,  -4.30E-01,  98,293,  -7.20E-01,  98,294,  -7.40E-01,
     & 98,295,  -1.03E+00,  98,296,  -1.13E+00,  98,297,  -1.52E+00,
     & 98,298,  -1.65E+00,  98,299,  -2.06E+00,  98,300,  -2.06E+00,
     & 98,301,  -2.47E+00,  98,302,  -2.38E+00,  98,303,  -2.80E+00,
     & 98,304,  -2.65E+00,  98,305,  -2.91E+00,  98,306,  -2.74E+00,
     & 98,307,  -3.27E+00,  98,308,  -3.19E+00,  98,309,  -3.47E+00,
     & 98,310,  -3.23E+00,  98,311,  -3.30E+00,  98,312,  -3.06E+00/
      data (nsz(i),nsa(i),shin(i),i=6841,6870)/
     & 98,313,  -3.29E+00,  98,314,  -3.09E+00,  98,315,  -3.57E+00,
     & 98,316,  -3.32E+00,  98,317,  -3.79E+00,  98,318,  -3.81E+00,
     & 98,319,  -4.05E+00,  98,320,  -3.71E+00,  98,321,  -3.91E+00,
     & 98,322,  -3.55E+00,  98,323,  -3.64E+00,  98,324,  -3.00E-02,
     & 98,325,  -8.80E-01,  99,224,  -1.22E+00,  99,225,  -1.34E+00,
     & 99,226,  -3.70E-01,  99,227,  -2.60E-01,  99,228,   1.37E+00,
     & 99,229,   5.50E-01,  99,230,   4.00E-01,  99,231,   3.40E-01,
     & 99,232,   1.30E-01,  99,233,   6.00E-02,  99,234,  -2.20E-01,
     & 99,235,  -3.90E-01,  99,236,  -7.20E-01,  99,237,  -9.40E-01,
     & 99,238,  -1.32E+00,  99,239,  -1.60E+00,  99,240,  -1.94E+00/
      data (nsz(i),nsa(i),shin(i),i=6871,6900)/
     & 99,241,  -2.22E+00,  99,242,  -2.58E+00,  99,243,  -2.64E+00,
     & 99,244,  -3.22E+00,  99,245,  -3.26E+00,  99,246,  -3.63E+00,
     & 99,247,  -4.10E+00,  99,248,  -4.51E+00,  99,249,  -4.48E+00,
     & 99,250,  -4.52E+00,  99,251,  -4.50E+00,  99,252,  -4.35E+00,
     & 99,253,  -3.90E+00,  99,254,  -3.77E+00,  99,255,  -3.19E+00,
     & 99,256,  -2.92E+00,  99,257,  -2.62E+00,  99,258,  -2.62E+00,
     & 99,259,  -2.51E+00,  99,260,  -2.75E+00,  99,261,  -2.65E+00,
     & 99,262,  -2.65E+00,  99,263,  -2.17E+00,  99,264,  -1.93E+00,
     & 99,265,  -1.46E+00,  99,266,  -9.50E-01,  99,267,  -8.50E-01,
     & 99,268,  -9.90E-01,  99,269,  -4.00E-01,  99,270,  -6.10E-01/
      data (nsz(i),nsa(i),shin(i),i=6901,6930)/
     & 99,271,  -3.90E-01,  99,272,  -7.90E-01,  99,273,  -7.40E-01,
     & 99,274,  -1.13E+00,  99,275,  -8.90E-01,  99,276,  -1.51E+00,
     & 99,277,  -1.36E+00,  99,278,  -1.41E+00,  99,279,  -1.24E+00,
     & 99,280,  -1.49E+00,  99,281,  -1.15E+00,  99,282,  -1.30E+00,
     & 99,283,  -7.90E-01,  99,284,  -4.50E-01,  99,285,   1.00E-01,
     & 99,286,   5.50E-01,  99,287,   4.00E-01,  99,288,   9.00E-02,
     & 99,289,   1.00E-02,  99,290,  -3.00E-01,  99,291,  -3.50E-01,
     & 99,292,  -6.60E-01,  99,293,  -6.80E-01,  99,294,  -9.80E-01,
     & 99,295,  -1.00E+00,  99,296,  -1.39E+00,  99,297,  -1.44E+00,
     & 99,298,  -1.90E+00,  99,299,  -1.98E+00,  99,300,  -2.45E+00/
      data (nsz(i),nsa(i),shin(i),i=6931,6960)/
     & 99,301,  -2.47E+00,  99,302,  -2.86E+00,  99,303,  -2.78E+00,
     & 99,304,  -3.06E+00,  99,305,  -2.91E+00,  99,306,  -3.12E+00,
     & 99,307,  -3.01E+00,  99,308,  -3.46E+00,  99,309,  -3.35E+00,
     & 99,310,  -3.66E+00,  99,311,  -3.43E+00,  99,312,  -3.64E+00,
     & 99,313,  -3.55E+00,  99,314,  -3.64E+00,  99,315,  -3.49E+00,
     & 99,316,  -3.96E+00,  99,317,  -3.68E+00,  99,318,  -4.14E+00,
     & 99,319,  -4.18E+00,  99,320,  -4.44E+00,  99,321,  -4.13E+00,
     & 99,322,  -4.29E+00,  99,323,  -3.94E+00,  99,324,  -4.06E+00,
     & 99,325,  -3.69E+00,  99,326,  -1.00E+00,  99,327,  -1.78E+00,
     & 99,328,  -2.23E+00, 100,226,  -1.62E+00, 100,227,  -6.50E-01/
      data (nsz(i),nsa(i),shin(i),i=6961,6990)/
     &100,228,  -3.00E-01, 100,229,   1.13E+00, 100,230,   5.30E-01,
     &100,231,   3.70E-01, 100,232,   3.30E-01, 100,233,   1.10E-01,
     &100,234,   4.00E-02, 100,235,  -1.20E-01, 100,236,  -2.80E-01,
     &100,237,  -5.60E-01, 100,238,  -8.00E-01, 100,239,  -1.17E+00,
     &100,240,  -1.36E+00, 100,241,  -1.72E+00, 100,242,  -1.99E+00,
     &100,243,  -2.36E+00, 100,244,  -2.47E+00, 100,245,  -3.07E+00,
     &100,246,  -3.66E+00, 100,247,  -3.52E+00, 100,248,  -3.94E+00,
     &100,249,  -3.97E+00, 100,250,  -4.31E+00, 100,251,  -4.76E+00,
     &100,252,  -4.61E+00, 100,253,  -4.67E+00, 100,254,  -4.03E+00,
     &100,255,  -3.97E+00, 100,256,  -3.43E+00, 100,257,  -3.39E+00/
      data (nsz(i),nsa(i),shin(i),i=6991,7020)/
     &100,258,  -2.88E+00, 100,259,  -3.08E+00, 100,260,  -2.88E+00,
     &100,261,  -3.12E+00, 100,262,  -3.05E+00, 100,263,  -3.08E+00,
     &100,264,  -2.60E+00, 100,265,  -2.31E+00, 100,266,  -1.83E+00,
     &100,267,  -1.30E+00, 100,268,  -1.16E+00, 100,269,  -1.30E+00,
     &100,270,  -7.20E-01, 100,271,  -8.80E-01, 100,272,  -6.80E-01,
     &100,273,  -1.11E+00, 100,274,  -1.05E+00, 100,275,  -1.43E+00,
     &100,276,  -1.17E+00, 100,277,  -1.68E+00, 100,278,  -1.53E+00,
     &100,279,  -1.63E+00, 100,280,  -1.45E+00, 100,281,  -1.69E+00,
     &100,282,  -1.29E+00, 100,283,  -1.43E+00, 100,284,  -9.30E-01,
     &100,285,  -5.20E-01, 100,286,   6.10E-01, 100,287,   2.80E-01/
      data (nsz(i),nsa(i),shin(i),i=7021,7050)/
     &100,288,   5.40E-01, 100,289,   2.30E-01, 100,290,   1.30E-01,
     &100,291,  -1.90E-01, 100,292,  -2.20E-01, 100,293,  -5.40E-01,
     &100,294,  -5.70E-01, 100,295,  -8.80E-01, 100,296,  -9.00E-01,
     &100,297,  -1.33E+00, 100,298,  -1.36E+00, 100,299,  -1.86E+00,
     &100,300,  -2.03E+00, 100,301,  -2.47E+00, 100,302,  -2.46E+00,
     &100,303,  -2.94E+00, 100,304,  -2.85E+00, 100,305,  -2.85E+00,
     &100,306,  -2.90E+00, 100,307,  -2.94E+00, 100,308,  -2.79E+00,
     &100,309,  -3.23E+00, 100,310,  -3.10E+00, 100,311,  -3.43E+00,
     &100,312,  -3.25E+00, 100,313,  -3.27E+00, 100,314,  -3.42E+00,
     &100,315,  -3.55E+00, 100,316,  -3.48E+00, 100,317,  -3.65E+00/
      data (nsz(i),nsa(i),shin(i),i=7051,7080)/
     &100,318,  -3.72E+00, 100,319,  -4.22E+00, 100,320,  -4.27E+00,
     &100,321,  -4.56E+00, 100,322,  -4.23E+00, 100,323,  -4.45E+00,
     &100,324,  -4.11E+00, 100,325,  -4.24E+00, 100,326,  -3.90E+00,
     &100,327,  -1.29E+00, 100,328,  -2.07E+00, 100,329,  -2.51E+00,
     &100,330,  -2.50E+00, 100,331,  -2.64E+00, 101,229,  -4.30E-01,
     &101,230,   1.07E+00, 101,231,   4.60E-01, 101,232,   2.50E-01,
     &101,233,   2.00E-01, 101,234,  -2.00E-02, 101,235,  -1.30E-01,
     &101,236,  -2.60E-01, 101,237,  -3.50E-01, 101,238,  -6.00E-01,
     &101,239,  -7.20E-01, 101,240,  -1.09E+00, 101,241,  -1.37E+00,
     &101,242,  -1.73E+00, 101,243,  -1.99E+00, 101,244,  -2.36E+00/
      data (nsz(i),nsa(i),shin(i),i=7081,7110)/
     &101,245,  -2.47E+00, 101,246,  -2.81E+00, 101,247,  -3.16E+00,
     &101,248,  -3.59E+00, 101,249,  -3.68E+00, 101,250,  -4.10E+00,
     &101,251,  -4.23E+00, 101,252,  -4.76E+00, 101,253,  -4.71E+00,
     &101,254,  -4.53E+00, 101,255,  -4.61E+00, 101,256,  -4.36E+00,
     &101,257,  -4.07E+00, 101,258,  -4.07E+00, 101,259,  -3.43E+00,
     &101,260,  -3.65E+00, 101,261,  -3.46E+00, 101,262,  -3.72E+00,
     &101,263,  -3.66E+00, 101,264,  -3.70E+00, 101,265,  -3.20E+00,
     &101,266,  -2.89E+00, 101,267,  -2.42E+00, 101,268,  -2.12E+00,
     &101,269,  -1.55E+00, 101,270,  -1.66E+00, 101,271,  -1.40E+00,
     &101,272,  -1.17E+00, 101,273,  -1.15E+00, 101,274,  -1.38E+00/
      data (nsz(i),nsa(i),shin(i),i=7111,7140)/
     &101,275,  -1.32E+00, 101,276,  -1.68E+00, 101,277,  -1.42E+00,
     &101,278,  -1.81E+00, 101,279,  -1.67E+00, 101,280,  -1.72E+00,
     &101,281,  -1.53E+00, 101,282,  -1.74E+00, 101,283,  -1.33E+00,
     &101,284,  -1.46E+00, 101,285,  -9.90E-01, 101,286,   6.00E-02,
     &101,287,  -1.20E-01, 101,288,   1.00E-01, 101,289,   3.60E-01,
     &101,290,   6.00E-02, 101,291,  -6.00E-02, 101,292,  -3.80E-01,
     &101,293,  -4.20E-01, 101,294,  -7.30E-01, 101,295,  -7.60E-01,
     &101,296,  -1.08E+00, 101,297,  -1.10E+00, 101,298,  -1.52E+00,
     &101,299,  -1.62E+00, 101,300,  -2.11E+00, 101,301,  -2.27E+00,
     &101,302,  -2.74E+00, 101,303,  -2.77E+00, 101,304,  -3.14E+00/
      data (nsz(i),nsa(i),shin(i),i=7141,7170)/
     &101,305,  -3.03E+00, 101,306,  -3.04E+00, 101,307,  -2.99E+00,
     &101,308,  -3.21E+00, 101,309,  -3.03E+00, 101,310,  -3.26E+00,
     &101,311,  -3.15E+00, 101,312,  -3.50E+00, 101,313,  -3.18E+00,
     &101,314,  -3.57E+00, 101,315,  -3.58E+00, 101,316,  -3.83E+00,
     &101,317,  -3.76E+00, 101,318,  -4.27E+00, 101,319,  -4.03E+00,
     &101,320,  -4.57E+00, 101,321,  -4.57E+00, 101,322,  -4.91E+00,
     &101,323,  -4.66E+00, 101,324,  -4.85E+00, 101,325,  -4.54E+00,
     &101,326,  -4.64E+00, 101,327,  -4.29E+00, 101,328,  -1.54E+00,
     &101,329,  -2.31E+00, 101,330,  -2.75E+00, 101,331,  -2.71E+00,
     &101,332,  -2.86E+00, 101,333,  -2.82E+00, 101,334,  -3.15E+00/
      data (nsz(i),nsa(i),shin(i),i=7171,7200)/
     &102,232,   1.00E+00, 102,233,   3.50E-01, 102,234,   3.00E-01,
     &102,235,   8.00E-02, 102,236,  -1.00E-02, 102,237,  -2.20E-01,
     &102,238,  -2.70E-01, 102,239,  -3.90E-01, 102,240,  -5.70E-01,
     &102,241,  -8.80E-01, 102,242,  -1.08E+00, 102,243,  -1.42E+00,
     &102,244,  -1.69E+00, 102,245,  -2.06E+00, 102,246,  -2.18E+00,
     &102,247,  -2.55E+00, 102,248,  -2.90E+00, 102,249,  -3.31E+00,
     &102,250,  -3.44E+00, 102,251,  -3.87E+00, 102,252,  -4.41E+00,
     &102,253,  -4.49E+00, 102,254,  -4.82E+00, 102,255,  -4.91E+00,
     &102,256,  -4.48E+00, 102,257,  -4.53E+00, 102,258,  -3.57E+00,
     &102,259,  -4.19E+00, 102,260,  -3.57E+00, 102,261,  -3.73E+00/
      data (nsz(i),nsa(i),shin(i),i=7201,7230)/
     &102,262,  -3.73E+00, 102,263,  -4.03E+00, 102,264,  -4.01E+00,
     &102,265,  -4.06E+00, 102,266,  -3.58E+00, 102,267,  -3.24E+00,
     &102,268,  -2.80E+00, 102,269,  -2.55E+00, 102,270,  -1.94E+00,
     &102,271,  -2.06E+00, 102,272,  -1.77E+00, 102,273,  -1.59E+00,
     &102,274,  -1.53E+00, 102,275,  -1.78E+00, 102,276,  -1.72E+00,
     &102,277,  -2.08E+00, 102,278,  -1.81E+00, 102,279,  -2.05E+00,
     &102,280,  -1.91E+00, 102,281,  -2.06E+00, 102,282,  -1.86E+00,
     &102,283,  -2.01E+00, 102,284,  -1.65E+00, 102,285,  -1.72E+00,
     &102,286,  -1.17E+00, 102,287,  -8.70E-01, 102,288,  -2.90E-01,
     &102,289,  -5.00E-02, 102,290,   2.18E+00, 102,291,   2.30E-01/
      data (nsz(i),nsa(i),shin(i),i=7231,7260)/
     &102,292,   1.20E-01, 102,293,  -2.00E-01, 102,294,  -2.60E-01,
     &102,295,  -5.80E-01, 102,296,  -5.90E-01, 102,297,  -9.10E-01,
     &102,298,  -9.50E-01, 102,299,  -1.38E+00, 102,300,  -1.49E+00,
     &102,301,  -2.00E+00, 102,302,  -2.15E+00, 102,303,  -2.64E+00,
     &102,304,  -2.64E+00, 102,305,  -2.97E+00, 102,306,  -2.86E+00,
     &102,307,  -2.89E+00, 102,308,  -2.56E+00, 102,309,  -2.76E+00,
     &102,310,  -2.56E+00, 102,311,  -2.77E+00, 102,312,  -2.64E+00,
     &102,313,  -2.95E+00, 102,314,  -2.91E+00, 102,315,  -3.31E+00,
     &102,316,  -3.36E+00, 102,317,  -3.65E+00, 102,318,  -3.64E+00,
     &102,319,  -4.14E+00, 102,320,  -4.24E+00, 102,321,  -4.52E+00/
      data (nsz(i),nsa(i),shin(i),i=7261,7290)/
     &102,322,  -4.82E+00, 102,323,  -4.95E+00, 102,324,  -4.86E+00,
     &102,325,  -5.03E+00, 102,326,  -4.70E+00, 102,327,  -4.88E+00,
     &102,328,  -4.55E+00, 102,329,  -1.96E+00, 102,330,  -2.69E+00,
     &102,331,  -3.09E+00, 102,332,  -3.09E+00, 102,333,  -3.20E+00,
     &102,334,  -3.10E+00, 102,335,  -3.46E+00, 102,336,  -3.33E+00,
     &102,337,  -3.77E+00, 102,338,  -3.62E+00, 103,235,   1.40E-01,
     &103,236,  -7.00E-02, 103,237,  -1.70E-01, 103,238,  -3.70E-01,
     &103,239,  -4.70E-01, 103,240,  -6.70E-01, 103,241,  -7.30E-01,
     &103,242,  -9.50E-01, 103,243,  -1.13E+00, 103,244,  -1.49E+00,
     &103,245,  -1.72E+00, 103,246,  -2.09E+00, 103,247,  -2.25E+00/
      data (nsz(i),nsa(i),shin(i),i=7291,7320)/
     &103,248,  -2.61E+00, 103,249,  -2.97E+00, 103,250,  -3.42E+00,
     &103,251,  -3.61E+00, 103,252,  -4.04E+00, 103,253,  -4.32E+00,
     &103,254,  -4.76E+00, 103,255,  -4.94E+00, 103,256,  -4.76E+00,
     &103,257,  -4.57E+00, 103,258,  -4.53E+00, 103,259,  -4.64E+00,
     &103,260,  -4.68E+00, 103,261,  -4.13E+00, 103,262,  -4.31E+00,
     &103,263,  -4.36E+00, 103,264,  -4.64E+00, 103,265,  -4.66E+00,
     &103,266,  -4.76E+00, 103,267,  -4.27E+00, 103,268,  -3.93E+00,
     &103,269,  -3.42E+00, 103,270,  -3.08E+00, 103,271,  -2.45E+00,
     &103,272,  -2.58E+00, 103,273,  -2.35E+00, 103,274,  -2.23E+00,
     &103,275,  -2.12E+00, 103,276,  -2.17E+00, 103,277,  -2.10E+00/
      data (nsz(i),nsa(i),shin(i),i=7321,7350)/
     &103,278,  -2.45E+00, 103,279,  -2.17E+00, 103,280,  -2.30E+00,
     &103,281,  -2.16E+00, 103,282,  -2.28E+00, 103,283,  -2.08E+00,
     &103,284,  -2.21E+00, 103,285,  -1.83E+00, 103,286,  -1.87E+00,
     &103,287,  -1.42E+00, 103,288,  -1.13E+00, 103,289,  -5.80E-01,
     &103,290,   1.29E+00, 103,291,   2.05E+00, 103,292,   1.10E-01,
     &103,293,  -3.00E-02, 103,294,  -3.60E-01, 103,295,  -4.00E-01,
     &103,296,  -7.00E-01, 103,297,  -7.10E-01, 103,298,  -1.08E+00,
     &103,299,  -1.14E+00, 103,300,  -1.50E+00, 103,301,  -1.73E+00,
     &103,302,  -2.17E+00, 103,303,  -2.42E+00, 103,304,  -2.90E+00,
     &103,305,  -2.99E+00, 103,306,  -3.32E+00, 103,307,  -3.12E+00/
      data (nsz(i),nsa(i),shin(i),i=7351,7380)/
     &103,308,  -3.17E+00, 103,309,  -2.98E+00, 103,310,  -3.13E+00,
     &103,311,  -2.99E+00, 103,312,  -3.13E+00, 103,313,  -3.08E+00,
     &103,314,  -3.29E+00, 103,315,  -3.17E+00, 103,316,  -3.51E+00,
     &103,317,  -3.59E+00, 103,318,  -3.89E+00, 103,319,  -3.94E+00,
     &103,320,  -4.45E+00, 103,321,  -4.58E+00, 103,322,  -5.12E+00,
     &103,323,  -5.15E+00, 103,324,  -5.51E+00, 103,325,  -5.23E+00,
     &103,326,  -5.46E+00, 103,327,  -5.13E+00, 103,328,  -5.31E+00,
     &103,329,  -4.99E+00, 103,330,  -2.30E+00, 103,331,  -3.00E+00,
     &103,332,  -3.41E+00, 103,333,  -3.39E+00, 103,334,  -3.53E+00,
     &103,335,  -3.40E+00, 103,336,  -3.70E+00, 103,337,  -3.69E+00/
      data (nsz(i),nsa(i),shin(i),i=7381,7410)/
     &103,338,  -4.09E+00, 103,339,  -3.94E+00, 104,238,  -2.00E-02,
     &104,239,  -3.10E-01, 104,240,  -2.80E-01, 104,241,  -4.70E-01,
     &104,242,  -4.40E-01, 104,243,  -6.40E-01, 104,244,  -8.20E-01,
     &104,245,  -1.15E+00, 104,246,  -1.40E+00, 104,247,  -1.74E+00,
     &104,248,  -1.92E+00, 104,249,  -2.30E+00, 104,250,  -2.67E+00,
     &104,251,  -3.12E+00, 104,252,  -3.34E+00, 104,253,  -3.83E+00,
     &104,254,  -4.12E+00, 104,255,  -4.70E+00, 104,256,  -5.07E+00,
     &104,257,  -4.68E+00, 104,258,  -4.49E+00, 104,259,  -5.10E+00,
     &104,260,  -4.12E+00, 104,261,  -4.34E+00, 104,262,  -4.26E+00,
     &104,263,  -4.60E+00, 104,264,  -4.57E+00, 104,265,  -4.92E+00/
      data (nsz(i),nsa(i),shin(i),i=7411,7440)/
     &104,266,  -5.04E+00, 104,267,  -5.08E+00, 104,268,  -4.61E+00,
     &104,269,  -4.28E+00, 104,270,  -3.75E+00, 104,271,  -3.39E+00,
     &104,272,  -2.75E+00, 104,273,  -2.90E+00, 104,274,  -2.63E+00,
     &104,275,  -2.41E+00, 104,276,  -2.37E+00, 104,277,  -2.63E+00,
     &104,278,  -2.59E+00, 104,279,  -2.91E+00, 104,280,  -2.64E+00,
     &104,281,  -2.65E+00, 104,282,  -2.52E+00, 104,283,  -2.70E+00,
     &104,284,  -2.40E+00, 104,285,  -2.59E+00, 104,286,  -2.25E+00,
     &104,287,  -2.28E+00, 104,288,  -1.75E+00, 104,289,  -1.38E+00,
     &104,290,  -1.90E-01, 104,291,   8.90E-01, 104,292,   9.00E-02,
     &104,293,   3.20E-01, 104,294,   1.60E-01, 104,295,  -1.80E-01/
      data (nsz(i),nsa(i),shin(i),i=7441,7470)/
     &104,296,  -2.20E-01, 104,297,  -5.20E-01, 104,298,  -5.90E-01,
     &104,299,  -9.20E-01, 104,300,  -9.80E-01, 104,301,  -1.46E+00,
     &104,302,  -1.59E+00, 104,303,  -2.08E+00, 104,304,  -2.35E+00,
     &104,305,  -2.79E+00, 104,306,  -2.88E+00, 104,307,  -3.17E+00,
     &104,308,  -2.97E+00, 104,309,  -3.15E+00, 104,310,  -2.95E+00,
     &104,311,  -3.10E+00, 104,312,  -2.93E+00, 104,313,  -3.15E+00,
     &104,314,  -3.05E+00, 104,315,  -3.33E+00, 104,316,  -3.22E+00,
     &104,317,  -3.64E+00, 104,318,  -3.49E+00, 104,319,  -3.96E+00,
     &104,320,  -3.89E+00, 104,321,  -4.43E+00, 104,322,  -4.54E+00,
     &104,323,  -5.10E+00, 104,324,  -5.15E+00, 104,325,  -5.52E+00/
      data (nsz(i),nsa(i),shin(i),i=7471,7500)/
     &104,326,  -5.28E+00, 104,327,  -5.48E+00, 104,328,  -5.16E+00,
     &104,329,  -5.35E+00, 104,330,  -5.12E+00, 104,331,  -2.76E+00,
     &104,332,  -3.49E+00, 104,333,  -3.87E+00, 104,334,  -3.83E+00,
     &104,335,  -3.95E+00, 104,336,  -3.79E+00, 104,337,  -4.12E+00,
     &104,338,  -3.98E+00, 104,339,  -4.36E+00, 105,241,  -4.10E-01,
     &105,242,  -6.40E-01, 105,243,  -6.10E-01, 105,244,  -7.70E-01,
     &105,245,  -9.40E-01, 105,246,  -1.27E+00, 105,247,  -1.50E+00,
     &105,248,  -1.88E+00, 105,249,  -2.06E+00, 105,250,  -2.44E+00,
     &105,251,  -2.82E+00, 105,252,  -3.30E+00, 105,253,  -3.57E+00,
     &105,254,  -4.01E+00, 105,255,  -4.41E+00, 105,256,  -4.99E+00/
      data (nsz(i),nsa(i),shin(i),i=7501,7530)/
     &105,257,  -5.10E+00, 105,258,  -5.07E+00, 105,259,  -4.91E+00,
     &105,260,  -4.98E+00, 105,261,  -4.66E+00, 105,262,  -4.89E+00,
     &105,263,  -4.84E+00, 105,264,  -5.21E+00, 105,265,  -5.32E+00,
     &105,266,  -5.57E+00, 105,267,  -5.75E+00, 105,268,  -5.79E+00,
     &105,269,  -5.28E+00, 105,270,  -4.97E+00, 105,271,  -4.40E+00,
     &105,272,  -4.06E+00, 105,273,  -3.29E+00, 105,274,  -3.43E+00,
     &105,275,  -3.19E+00, 105,276,  -3.11E+00, 105,277,  -2.89E+00,
     &105,278,  -3.14E+00, 105,279,  -3.11E+00, 105,280,  -3.42E+00,
     &105,281,  -3.15E+00, 105,282,  -3.00E+00, 105,283,  -2.85E+00,
     &105,284,  -3.07E+00, 105,285,  -2.89E+00, 105,286,  -2.86E+00/
      data (nsz(i),nsa(i),shin(i),i=7531,7560)/
     &105,287,  -2.51E+00, 105,288,  -2.56E+00, 105,289,  -2.03E+00,
     &105,290,  -9.60E-01, 105,291,  -4.20E-01, 105,292,  -8.80E-01,
     &105,293,  -2.70E-01, 105,294,   1.90E-01, 105,295,   2.00E-02,
     &105,296,  -3.10E-01, 105,297,  -3.70E-01, 105,298,  -7.00E-01,
     &105,299,  -7.50E-01, 105,300,  -1.09E+00, 105,301,  -1.20E+00,
     &105,302,  -1.66E+00, 105,303,  -1.84E+00, 105,304,  -2.30E+00,
     &105,305,  -2.56E+00, 105,306,  -3.04E+00, 105,307,  -3.06E+00,
     &105,308,  -3.32E+00, 105,309,  -3.24E+00, 105,310,  -3.43E+00,
     &105,311,  -3.20E+00, 105,312,  -3.38E+00, 105,313,  -3.26E+00,
     &105,314,  -3.53E+00, 105,315,  -3.48E+00, 105,316,  -3.85E+00/
      data (nsz(i),nsa(i),shin(i),i=7561,7590)/
     &105,317,  -3.72E+00, 105,318,  -4.11E+00, 105,319,  -4.16E+00,
     &105,320,  -4.56E+00, 105,321,  -4.64E+00, 105,322,  -5.05E+00,
     &105,323,  -4.92E+00, 105,324,  -5.47E+00, 105,325,  -5.54E+00,
     &105,326,  -5.92E+00, 105,327,  -5.70E+00, 105,328,  -5.84E+00,
     &105,329,  -5.64E+00, 105,330,  -5.85E+00, 105,331,  -5.56E+00,
     &105,332,  -3.26E+00, 105,333,  -3.92E+00, 105,334,  -4.30E+00,
     &105,335,  -4.23E+00, 105,336,  -4.35E+00, 105,337,  -4.16E+00,
     &105,338,  -4.51E+00, 105,339,  -4.36E+00, 106,244,  -5.70E-01,
     &106,245,  -5.30E-01, 106,246,  -6.70E-01, 106,247,  -1.01E+00,
     &106,248,  -1.22E+00, 106,249,  -1.57E+00, 106,250,  -1.78E+00/
      data (nsz(i),nsa(i),shin(i),i=7591,7620)/
     &106,251,  -2.16E+00, 106,252,  -2.57E+00, 106,253,  -3.06E+00,
     &106,254,  -3.35E+00, 106,255,  -3.90E+00, 106,256,  -4.35E+00,
     &106,257,  -4.83E+00, 106,258,  -4.95E+00, 106,259,  -5.07E+00,
     &106,260,  -5.35E+00, 106,261,  -4.93E+00, 106,262,  -4.63E+00,
     &106,263,  -5.50E+00, 106,264,  -4.89E+00, 106,265,  -5.30E+00,
     &106,266,  -5.44E+00, 106,267,  -5.81E+00, 106,268,  -5.91E+00,
     &106,269,  -5.97E+00, 106,270,  -5.52E+00, 106,271,  -5.18E+00,
     &106,272,  -4.59E+00, 106,273,  -4.23E+00, 106,274,  -3.52E+00,
     &106,275,  -3.66E+00, 106,276,  -3.35E+00, 106,277,  -3.11E+00,
     &106,278,  -3.13E+00, 106,279,  -3.55E+00, 106,280,  -3.56E+00/
      data (nsz(i),nsa(i),shin(i),i=7621,7650)/
     &106,281,  -3.92E+00, 106,282,  -3.62E+00, 106,283,  -3.46E+00,
     &106,284,  -3.41E+00, 106,285,  -3.63E+00, 106,286,  -3.31E+00,
     &106,287,  -3.47E+00, 106,288,  -3.10E+00, 106,289,  -3.15E+00,
     &106,290,  -2.54E+00, 106,291,  -1.52E+00, 106,292,  -1.42E+00,
     &106,293,  -1.10E+00, 106,294,  -4.30E-01, 106,295,  -2.70E-01,
     &106,296,   2.50E-01, 106,297,  -2.00E-02, 106,298,  -1.30E-01,
     &106,299,  -4.60E-01, 106,300,  -5.10E-01, 106,301,  -8.90E-01,
     &106,302,  -1.02E+00, 106,303,  -1.46E+00, 106,304,  -1.66E+00,
     &106,305,  -2.17E+00, 106,306,  -2.43E+00, 106,307,  -2.86E+00,
     &106,308,  -2.97E+00, 106,309,  -3.20E+00, 106,310,  -3.15E+00/
      data (nsz(i),nsa(i),shin(i),i=7651,7680)/
     &106,311,  -3.30E+00, 106,312,  -3.13E+00, 106,313,  -3.34E+00,
     &106,314,  -3.24E+00, 106,315,  -3.57E+00, 106,316,  -3.56E+00,
     &106,317,  -3.93E+00, 106,318,  -3.98E+00, 106,319,  -4.31E+00,
     &106,320,  -4.20E+00, 106,321,  -4.43E+00, 106,322,  -4.40E+00,
     &106,323,  -4.55E+00, 106,324,  -4.89E+00, 106,325,  -5.51E+00,
     &106,326,  -5.45E+00, 106,327,  -5.82E+00, 106,328,  -5.47E+00,
     &106,329,  -5.81E+00, 106,330,  -5.55E+00, 106,331,  -5.76E+00,
     &106,332,  -2.74E+00, 106,333,  -3.78E+00, 106,334,  -4.53E+00,
     &106,335,  -4.84E+00, 106,336,  -4.77E+00, 106,337,  -4.96E+00,
     &106,338,  -4.61E+00, 106,339,  -4.86E+00, 107,247,  -1.02E+00/
      data (nsz(i),nsa(i),shin(i),i=7681,7710)/
     &107,248,  -1.12E+00, 107,249,  -1.34E+00, 107,250,  -1.68E+00,
     &107,251,  -2.05E+00, 107,252,  -2.45E+00, 107,253,  -2.73E+00,
     &107,254,  -3.21E+00, 107,255,  -3.59E+00, 107,256,  -4.07E+00,
     &107,257,  -4.51E+00, 107,258,  -5.02E+00, 107,259,  -5.22E+00,
     &107,260,  -5.28E+00, 107,261,  -5.19E+00, 107,262,  -5.31E+00,
     &107,263,  -5.17E+00, 107,264,  -5.37E+00, 107,265,  -5.40E+00,
     &107,266,  -5.84E+00, 107,267,  -6.00E+00, 107,268,  -6.41E+00,
     &107,269,  -6.55E+00, 107,270,  -6.61E+00, 107,271,  -6.17E+00,
     &107,272,  -5.84E+00, 107,273,  -5.26E+00, 107,274,  -4.93E+00,
     &107,275,  -4.11E+00, 107,276,  -4.23E+00, 107,277,  -4.01E+00/
      data (nsz(i),nsa(i),shin(i),i=7711,7740)/
     &107,278,  -3.69E+00, 107,279,  -3.72E+00, 107,280,  -4.13E+00,
     &107,281,  -4.11E+00, 107,282,  -4.49E+00, 107,283,  -4.17E+00,
     &107,284,  -4.21E+00, 107,285,  -3.88E+00, 107,286,  -4.14E+00,
     &107,287,  -3.79E+00, 107,288,  -3.96E+00, 107,289,  -3.61E+00,
     &107,290,  -3.63E+00, 107,291,  -3.02E+00, 107,292,  -2.46E+00,
     &107,293,  -1.85E+00, 107,294,  -1.50E+00, 107,295,  -8.20E-01,
     &107,296,  -6.30E-01, 107,297,   2.10E-01, 107,298,  -1.30E-01,
     &107,299,  -2.10E-01, 107,300,  -5.50E-01, 107,301,  -5.80E-01,
     &107,302,  -9.80E-01, 107,303,  -1.09E+00, 107,304,  -1.55E+00,
     &107,305,  -1.77E+00, 107,306,  -2.28E+00, 107,307,  -2.51E+00/
      data (nsz(i),nsa(i),shin(i),i=7741,7770)/
     &107,308,  -2.99E+00, 107,309,  -3.08E+00, 107,310,  -3.30E+00,
     &107,311,  -3.24E+00, 107,312,  -3.43E+00, 107,313,  -3.27E+00,
     &107,314,  -3.51E+00, 107,315,  -3.43E+00, 107,316,  -3.79E+00,
     &107,317,  -3.80E+00, 107,318,  -4.25E+00, 107,319,  -4.26E+00,
     &107,320,  -4.61E+00, 107,321,  -4.45E+00, 107,322,  -4.62E+00,
     &107,323,  -4.57E+00, 107,324,  -4.72E+00, 107,325,  -4.77E+00,
     &107,326,  -5.60E+00, 107,327,  -5.56E+00, 107,328,  -5.97E+00,
     &107,329,  -5.70E+00, 107,330,  -6.01E+00, 107,331,  -5.83E+00,
     &107,332,  -6.09E+00, 107,333,  -3.36E+00, 107,334,  -4.41E+00,
     &107,335,  -5.17E+00, 107,336,  -5.47E+00, 107,337,  -5.37E+00/
      data (nsz(i),nsa(i),shin(i),i=7771,7800)/
     &107,338,  -5.55E+00, 107,339,  -5.11E+00, 108,250,  -1.01E+00,
     &108,251,  -1.33E+00, 108,252,  -1.58E+00, 108,253,  -1.97E+00,
     &108,254,  -2.37E+00, 108,255,  -2.85E+00, 108,256,  -3.20E+00,
     &108,257,  -3.67E+00, 108,258,  -4.12E+00, 108,259,  -4.62E+00,
     &108,260,  -4.80E+00, 108,261,  -4.96E+00, 108,262,  -4.91E+00,
     &108,263,  -5.07E+00, 108,264,  -4.86E+00, 108,265,  -5.21E+00,
     &108,266,  -5.27E+00, 108,267,  -5.75E+00, 108,268,  -5.95E+00,
     &108,269,  -6.38E+00, 108,270,  -6.54E+00, 108,271,  -6.64E+00,
     &108,272,  -6.23E+00, 108,273,  -5.93E+00, 108,274,  -5.31E+00,
     &108,275,  -4.90E+00, 108,276,  -4.24E+00, 108,277,  -4.32E+00/
      data (nsz(i),nsa(i),shin(i),i=7801,7830)/
     &108,278,  -3.68E+00, 108,279,  -4.11E+00, 108,280,  -4.20E+00,
     &108,281,  -4.64E+00, 108,282,  -4.59E+00, 108,283,  -4.97E+00,
     &108,284,  -4.72E+00, 108,285,  -4.79E+00, 108,286,  -4.44E+00,
     &108,287,  -4.77E+00, 108,288,  -4.47E+00, 108,289,  -4.66E+00,
     &108,290,  -4.21E+00, 108,291,  -4.22E+00, 108,292,  -3.59E+00,
     &108,293,  -2.81E+00, 108,294,  -2.13E+00, 108,295,  -1.67E+00,
     &108,296,  -9.40E-01, 108,297,  -6.70E-01, 108,298,   1.49E+00,
     &108,299,   1.10E-01, 108,300,   8.00E-02, 108,301,  -2.30E-01,
     &108,302,  -3.30E-01, 108,303,  -7.10E-01, 108,304,  -8.20E-01,
     &108,305,  -1.28E+00, 108,306,  -1.48E+00, 108,307,  -1.98E+00/
      data (nsz(i),nsa(i),shin(i),i=7831,7860)/
     &108,308,  -2.18E+00, 108,309,  -2.64E+00, 108,310,  -2.72E+00,
     &108,311,  -2.94E+00, 108,312,  -2.88E+00, 108,313,  -3.07E+00,
     &108,314,  -2.90E+00, 108,315,  -3.16E+00, 108,316,  -3.08E+00,
     &108,317,  -3.46E+00, 108,318,  -3.49E+00, 108,319,  -3.93E+00,
     &108,320,  -3.94E+00, 108,321,  -4.30E+00, 108,322,  -4.12E+00,
     &108,323,  -4.28E+00, 108,324,  -3.99E+00, 108,325,  -4.36E+00,
     &108,326,  -4.33E+00, 108,327,  -5.21E+00, 108,328,  -2.14E+00,
     &108,329,  -2.40E+00, 108,330,  -2.59E+00, 108,331,  -3.13E+00,
     &108,332,  -5.46E+00, 108,333,  -3.23E+00, 108,334,  -3.96E+00,
     &108,335,  -5.01E+00, 108,336,  -5.79E+00, 108,337,  -6.08E+00/
      data (nsz(i),nsa(i),shin(i),i=7861,7890)/
     &108,338,  -5.95E+00, 108,339,  -6.11E+00, 109,253,  -1.56E+00,
     &109,254,  -1.96E+00, 109,255,  -2.24E+00, 109,256,  -2.68E+00,
     &109,257,  -3.17E+00, 109,258,  -3.63E+00, 109,259,  -4.09E+00,
     &109,260,  -4.58E+00, 109,261,  -4.78E+00, 109,262,  -4.77E+00,
     &109,263,  -4.80E+00, 109,264,  -5.04E+00, 109,265,  -5.04E+00,
     &109,266,  -5.39E+00, 109,267,  -5.41E+00, 109,268,  -5.93E+00,
     &109,269,  -6.25E+00, 109,270,  -6.65E+00, 109,271,  -6.92E+00,
     &109,272,  -7.06E+00, 109,273,  -6.67E+00, 109,274,  -6.36E+00,
     &109,275,  -5.78E+00, 109,276,  -5.46E+00, 109,277,  -4.81E+00,
     &109,278,  -4.82E+00, 109,279,  -4.31E+00, 109,280,  -4.77E+00/
      data (nsz(i),nsa(i),shin(i),i=7891,7920)/
     &109,281,  -4.78E+00, 109,282,  -5.18E+00, 109,283,  -5.20E+00,
     &109,284,  -5.55E+00, 109,285,  -5.23E+00, 109,286,  -5.27E+00,
     &109,287,  -5.07E+00, 109,288,  -5.46E+00, 109,289,  -5.12E+00,
     &109,290,  -5.32E+00, 109,291,  -4.86E+00, 109,292,  -4.86E+00,
     &109,293,  -4.23E+00, 109,294,  -3.39E+00, 109,295,  -2.70E+00,
     &109,296,  -2.15E+00, 109,297,  -1.39E+00, 109,298,   1.90E-01,
     &109,299,  -4.10E-01, 109,300,  -2.10E-01, 109,301,  -2.00E-02,
     &109,302,  -3.20E-01, 109,303,  -3.90E-01, 109,304,  -7.60E-01,
     &109,305,  -8.60E-01, 109,306,  -1.27E+00, 109,307,  -1.48E+00,
     &109,308,  -1.96E+00, 109,309,  -2.11E+00, 109,310,  -2.65E+00/
      data (nsz(i),nsa(i),shin(i),i=7921,7950)/
     &109,311,  -2.61E+00, 109,312,  -2.82E+00, 109,313,  -2.75E+00,
     &109,314,  -2.96E+00, 109,315,  -2.83E+00, 109,316,  -3.10E+00,
     &109,317,  -3.04E+00, 109,318,  -3.45E+00, 109,319,  -3.48E+00,
     &109,320,  -3.92E+00, 109,321,  -3.93E+00, 109,322,  -4.27E+00,
     &109,323,  -4.07E+00, 109,324,  -4.24E+00, 109,325,  -4.14E+00,
     &109,326,  -4.51E+00, 109,327,  -4.46E+00, 109,328,  -2.43E+00,
     &109,329,  -2.35E+00, 109,330,  -2.59E+00, 109,331,  -2.78E+00,
     &109,332,  -3.28E+00, 109,333,  -3.47E+00, 109,334,  -3.95E+00,
     &109,335,  -4.73E+00, 109,336,  -5.79E+00, 109,337,  -6.58E+00,
     &109,338,  -6.85E+00, 109,339,  -6.70E+00, 110,256,  -1.84E+00/
      data (nsz(i),nsa(i),shin(i),i=7951,7980)/
     &110,257,  -2.27E+00, 110,258,  -2.64E+00, 110,259,  -3.15E+00,
     &110,260,  -3.48E+00, 110,261,  -3.94E+00, 110,262,  -4.12E+00,
     &110,263,  -4.29E+00, 110,264,  -4.35E+00, 110,265,  -4.59E+00,
     &110,266,  -4.53E+00, 110,267,  -4.93E+00, 110,268,  -5.07E+00,
     &110,269,  -5.60E+00, 110,270,  -5.85E+00, 110,271,  -6.34E+00,
     &110,272,  -6.55E+00, 110,273,  -6.79E+00, 110,274,  -6.40E+00,
     &110,275,  -6.15E+00, 110,276,  -5.61E+00, 110,277,  -5.21E+00,
     &110,278,  -4.74E+00, 110,279,  -4.91E+00, 110,280,  -4.76E+00,
     &110,281,  -5.20E+00, 110,282,  -5.22E+00, 110,283,  -5.65E+00,
     &110,284,  -5.65E+00, 110,285,  -6.01E+00, 110,286,  -5.73E+00/
      data (nsz(i),nsa(i),shin(i),i=7981,8010)/
     &110,287,  -5.74E+00, 110,288,  -5.83E+00, 110,289,  -6.16E+00,
     &110,290,  -5.83E+00, 110,291,  -6.01E+00, 110,292,  -5.54E+00,
     &110,293,  -5.52E+00, 110,294,  -4.88E+00, 110,295,  -3.89E+00,
     &110,296,  -3.29E+00, 110,297,  -2.44E+00, 110,298,  -1.44E+00,
     &110,299,  -1.14E+00, 110,300,   2.30E-01, 110,301,  -1.30E-01,
     &110,302,   4.10E-01, 110,303,  -1.10E-01, 110,304,  -1.10E-01,
     &110,305,  -4.60E-01, 110,306,  -5.40E-01, 110,307,  -9.70E-01,
     &110,308,  -1.13E+00, 110,309,  -1.64E+00, 110,310,  -1.83E+00,
     &110,311,  -2.27E+00, 110,312,  -2.23E+00, 110,313,  -2.45E+00,
     &110,314,  -2.36E+00, 110,315,  -2.55E+00, 110,316,  -2.40E+00/
      data (nsz(i),nsa(i),shin(i),i=8011,8040)/
     &110,317,  -2.65E+00, 110,318,  -2.62E+00, 110,319,  -2.99E+00,
     &110,320,  -3.01E+00, 110,321,  -3.44E+00, 110,322,  -3.42E+00,
     &110,323,  -3.75E+00, 110,324,  -3.56E+00, 110,325,  -3.72E+00,
     &110,326,  -3.69E+00, 110,327,  -3.96E+00, 110,328,  -2.22E+00,
     &110,329,  -2.42E+00, 110,330,  -2.43E+00, 110,331,  -2.98E+00,
     &110,332,  -3.17E+00, 110,333,  -3.65E+00, 110,334,  -3.68E+00,
     &110,335,  -4.50E+00, 110,336,  -5.37E+00, 110,337,  -6.44E+00,
     &110,338,  -7.24E+00, 110,339,  -7.50E+00, 111,259,  -2.52E+00,
     &111,260,  -2.95E+00, 111,261,  -3.32E+00, 111,262,  -3.78E+00,
     &111,263,  -3.93E+00, 111,264,  -4.09E+00, 111,265,  -4.15E+00/
      data (nsz(i),nsa(i),shin(i),i=8041,8070)/
     &111,266,  -4.41E+00, 111,267,  -4.44E+00, 111,268,  -4.82E+00,
     &111,269,  -4.96E+00, 111,270,  -5.48E+00, 111,271,  -5.71E+00,
     &111,272,  -6.20E+00, 111,273,  -6.41E+00, 111,274,  -6.70E+00,
     &111,275,  -6.38E+00, 111,276,  -6.19E+00, 111,277,  -5.69E+00,
     &111,278,  -5.36E+00, 111,279,  -5.12E+00, 111,280,  -5.45E+00,
     &111,281,  -5.43E+00, 111,282,  -5.88E+00, 111,283,  -5.94E+00,
     &111,284,  -6.34E+00, 111,285,  -6.35E+00, 111,286,  -6.71E+00,
     &111,287,  -6.49E+00, 111,288,  -6.56E+00, 111,289,  -6.71E+00,
     &111,290,  -7.01E+00, 111,291,  -6.66E+00, 111,292,  -6.82E+00,
     &111,293,  -6.35E+00, 111,294,  -6.29E+00, 111,295,  -5.65E+00/
      data (nsz(i),nsa(i),shin(i),i=8071,8100)/
     &111,296,  -4.70E+00, 111,297,  -4.07E+00, 111,298,  -2.94E+00,
     &111,299,  -2.30E+00, 111,300,  -1.22E+00, 111,301,  -9.40E-01,
     &111,302,  -5.30E-01, 111,303,   5.00E-02, 111,304,   3.20E-01,
     &111,305,  -2.10E-01, 111,306,  -5.20E-01, 111,307,  -6.00E-01,
     &111,308,  -1.03E+00, 111,309,  -1.18E+00, 111,310,  -1.63E+00,
     &111,311,  -1.81E+00, 111,312,  -2.21E+00, 111,313,  -2.14E+00,
     &111,314,  -2.35E+00, 111,315,  -2.26E+00, 111,316,  -2.45E+00,
     &111,317,  -2.26E+00, 111,318,  -2.50E+00, 111,319,  -2.41E+00,
     &111,320,  -2.72E+00, 111,321,  -2.74E+00, 111,322,  -3.12E+00,
     &111,323,  -3.13E+00, 111,324,  -3.40E+00, 111,325,  -3.05E+00/
      data (nsz(i),nsa(i),shin(i),i=8101,8130)/
     &111,326,  -3.35E+00, 111,327,  -3.36E+00, 111,328,  -3.35E+00,
     &111,329,  -2.99E+00, 111,330,  -3.17E+00, 111,331,  -3.19E+00,
     &111,332,  -3.57E+00, 111,333,  -3.77E+00, 111,334,  -4.13E+00,
     &111,335,  -4.47E+00, 111,336,  -5.21E+00, 111,337,  -6.26E+00,
     &111,338,  -7.34E+00, 111,339,  -8.16E+00, 112,262,  -2.80E+00,
     &112,263,  -3.21E+00, 112,264,  -3.33E+00, 112,265,  -3.53E+00,
     &112,266,  -3.58E+00, 112,267,  -3.84E+00, 112,268,  -3.87E+00,
     &112,269,  -4.23E+00, 112,270,  -4.39E+00, 112,271,  -4.91E+00,
     &112,272,  -5.17E+00, 112,273,  -5.67E+00, 112,274,  -5.91E+00,
     &112,275,  -6.17E+00, 112,276,  -5.92E+00, 112,277,  -5.77E+00/
      data (nsz(i),nsa(i),shin(i),i=8131,8160)/
     &112,278,  -5.06E+00, 112,279,  -5.14E+00, 112,280,  -5.17E+00,
     &112,281,  -5.62E+00, 112,282,  -5.75E+00, 112,283,  -6.19E+00,
     &112,284,  -6.23E+00, 112,285,  -6.63E+00, 112,286,  -6.64E+00,
     &112,287,  -6.99E+00, 112,288,  -6.93E+00, 112,289,  -7.29E+00,
     &112,290,  -7.44E+00, 112,291,  -7.71E+00, 112,292,  -7.39E+00,
     &112,293,  -7.58E+00, 112,294,  -7.10E+00, 112,295,  -7.02E+00,
     &112,296,  -6.37E+00, 112,297,  -5.48E+00, 112,298,  -4.78E+00,
     &112,299,  -3.69E+00, 112,300,  -2.93E+00, 112,301,  -2.02E+00,
     &112,302,  -1.25E+00, 112,303,  -6.40E-01, 112,304,  -1.00E-02,
     &112,305,   4.10E-01, 112,306,   1.47E+00, 112,307,  -2.60E-01/
      data (nsz(i),nsa(i),shin(i),i=8161,8190)/
     &112,308,  -3.70E-01, 112,309,  -7.60E-01, 112,310,  -8.60E-01,
     &112,311,  -1.35E+00, 112,312,  -1.52E+00, 112,313,  -1.94E+00,
     &112,314,  -1.93E+00, 112,315,  -2.10E+00, 112,316,  -1.83E+00,
     &112,317,  -2.00E+00, 112,318,  -1.82E+00, 112,319,  -2.06E+00,
     &112,320,  -1.96E+00, 112,321,  -2.30E+00, 112,322,  -2.28E+00,
     &112,323,  -2.73E+00, 112,324,  -2.11E+00, 112,325,  -2.49E+00,
     &112,326,  -2.62E+00, 112,327,  -2.97E+00, 112,328,  -2.95E+00,
     &112,329,  -3.24E+00, 112,330,  -3.13E+00, 112,331,  -3.23E+00,
     &112,332,  -3.33E+00, 112,333,  -3.72E+00, 112,334,  -3.94E+00,
     &112,335,  -4.38E+00, 112,336,  -4.96E+00, 112,337,  -5.80E+00/
      data (nsz(i),nsa(i),shin(i),i=8191,8220)/
     &112,338,  -6.92E+00, 112,339,  -8.00E+00, 113,266,  -3.10E+00,
     &113,267,  -3.21E+00, 113,268,  -3.52E+00, 113,269,  -3.60E+00,
     &113,270,  -3.98E+00, 113,271,  -4.17E+00, 113,272,  -4.70E+00,
     &113,273,  -4.96E+00, 113,274,  -5.48E+00, 113,275,  -5.66E+00,
     &113,276,  -6.03E+00, 113,277,  -5.86E+00, 113,278,  -5.62E+00,
     &113,279,  -5.11E+00, 113,280,  -5.95E+00, 113,281,  -6.09E+00,
     &113,282,  -6.54E+00, 113,283,  -6.61E+00, 113,284,  -7.00E+00,
     &113,285,  -7.04E+00, 113,286,  -7.43E+00, 113,287,  -7.43E+00,
     &113,288,  -7.76E+00, 113,289,  -7.94E+00, 113,290,  -8.19E+00,
     &113,291,  -8.37E+00, 113,292,  -8.61E+00, 113,293,  -8.22E+00/
      data (nsz(i),nsa(i),shin(i),i=8221,8250)/
     &113,294,  -8.35E+00, 113,295,  -7.82E+00, 113,296,  -7.72E+00,
     &113,297,  -7.06E+00, 113,298,  -5.99E+00, 113,299,  -5.47E+00,
     &113,300,  -4.34E+00, 113,301,  -3.62E+00, 113,302,  -2.71E+00,
     &113,303,  -1.93E+00, 113,304,  -1.26E+00, 113,305,  -6.00E-01,
     &113,306,   3.00E-01, 113,307,   4.30E-01, 113,308,  -5.80E-01,
     &113,309,  -4.10E-01, 113,310,  -7.80E-01, 113,311,  -9.00E-01,
     &113,312,  -1.36E+00, 113,313,  -1.50E+00, 113,314,  -1.88E+00,
     &113,315,  -1.96E+00, 113,316,  -2.03E+00, 113,317,  -1.86E+00,
     &113,318,  -1.86E+00, 113,319,  -1.65E+00, 113,320,  -1.88E+00,
     &113,321,  -1.76E+00, 113,322,  -2.07E+00, 113,323,  -2.02E+00/
      data (nsz(i),nsa(i),shin(i),i=8251,8280)/
     &113,324,  -2.50E+00, 113,325,  -1.91E+00, 113,326,  -2.27E+00,
     &113,327,  -2.51E+00, 113,328,  -2.96E+00, 113,329,  -3.03E+00,
     &113,330,  -3.22E+00, 113,331,  -3.24E+00, 113,332,  -3.49E+00,
     &113,333,  -3.63E+00, 113,334,  -4.16E+00, 113,335,  -4.45E+00,
     &113,336,  -5.11E+00, 113,337,  -5.69E+00, 113,338,  -6.59E+00,
     &113,339,  -7.68E+00, 114,269,  -3.02E+00, 114,270,  -3.14E+00,
     &114,271,  -3.50E+00, 114,272,  -3.68E+00, 114,273,  -4.16E+00,
     &114,274,  -4.41E+00, 114,275,  -4.84E+00, 114,276,  -5.10E+00,
     &114,277,  -5.47E+00, 114,278,  -5.28E+00, 114,279,  -6.01E+00,
     &114,280,  -6.07E+00, 114,281,  -6.47E+00, 114,282,  -6.57E+00/
      data (nsz(i),nsa(i),shin(i),i=8281,8310)/
     &114,283,  -6.95E+00, 114,284,  -7.00E+00, 114,285,  -7.41E+00,
     &114,286,  -7.36E+00, 114,287,  -7.74E+00, 114,288,  -7.80E+00,
     &114,289,  -8.37E+00, 114,290,  -8.61E+00, 114,291,  -8.89E+00,
     &114,292,  -8.89E+00, 114,293,  -9.12E+00, 114,294,  -8.76E+00,
     &114,295,  -8.88E+00, 114,296,  -8.39E+00, 114,297,  -8.26E+00,
     &114,298,  -7.59E+00, 114,299,  -6.51E+00, 114,300,  -5.99E+00,
     &114,301,  -4.84E+00, 114,302,  -4.13E+00, 114,303,  -3.10E+00,
     &114,304,  -2.43E+00, 114,305,  -1.52E+00, 114,306,  -9.50E-01,
     &114,307,  -1.50E-01, 114,308,   3.10E-01, 114,309,   9.90E-01,
     &114,310,   1.33E+00, 114,311,  -7.10E-01, 114,312,  -7.70E-01/
      data (nsz(i),nsa(i),shin(i),i=8311,8340)/
     &114,313,  -1.16E+00, 114,314,  -1.32E+00, 114,315,  -1.69E+00,
     &114,316,  -1.72E+00, 114,317,  -1.87E+00, 114,318,  -1.58E+00,
     &114,319,  -1.68E+00, 114,320,  -1.29E+00, 114,321,  -1.49E+00,
     &114,322,  -1.34E+00, 114,323,  -1.62E+00, 114,324,  -1.57E+00,
     &114,325,  -2.07E+00, 114,326,  -1.64E+00, 114,327,  -2.01E+00,
     &114,328,  -2.26E+00, 114,329,  -2.69E+00, 114,330,  -2.64E+00,
     &114,331,  -2.91E+00, 114,332,  -2.98E+00, 114,333,  -3.26E+00,
     &114,334,  -3.53E+00, 114,335,  -4.03E+00, 114,336,  -4.54E+00,
     &114,337,  -5.34E+00, 114,338,  -6.18E+00, 114,339,  -7.12E+00,
     &115,272,  -3.33E+00, 115,273,  -3.52E+00, 115,274,  -3.96E+00/
      data (nsz(i),nsa(i),shin(i),i=8341,8370)/
     &115,275,  -4.21E+00, 115,276,  -4.70E+00, 115,277,  -4.96E+00,
     &115,278,  -5.33E+00, 115,279,  -5.79E+00, 115,280,  -6.30E+00,
     &115,281,  -6.45E+00, 115,282,  -6.86E+00, 115,283,  -6.95E+00,
     &115,284,  -7.40E+00, 115,285,  -7.43E+00, 115,286,  -7.84E+00,
     &115,287,  -7.76E+00, 115,288,  -8.16E+00, 115,289,  -8.17E+00,
     &115,290,  -8.52E+00, 115,291,  -8.66E+00, 115,292,  -8.98E+00,
     &115,293,  -9.10E+00, 115,294,  -9.44E+00, 115,295,  -9.09E+00,
     &115,296,  -9.16E+00, 115,297,  -8.59E+00, 115,298,  -8.46E+00,
     &115,299,  -7.78E+00, 115,300,  -6.70E+00, 115,301,  -6.19E+00,
     &115,302,  -5.06E+00, 115,303,  -4.34E+00, 115,304,  -3.33E+00/
      data (nsz(i),nsa(i),shin(i),i=8371,8400)/
     &115,305,  -2.66E+00, 115,306,  -1.76E+00, 115,307,  -1.19E+00,
     &115,308,  -5.00E-01, 115,309,   1.00E-02, 115,310,  -1.02E+00,
     &115,311,  -7.00E-01, 115,312,  -9.50E-01, 115,313,  -9.80E-01,
     &115,314,  -1.31E+00, 115,315,  -1.40E+00, 115,316,  -1.78E+00,
     &115,317,  -1.80E+00, 115,318,  -1.92E+00, 115,319,  -1.66E+00,
     &115,320,  -1.71E+00, 115,321,  -1.32E+00, 115,322,  -1.47E+00,
     &115,323,  -1.13E+00, 115,324,  -1.52E+00, 115,325,  -1.43E+00,
     &115,326,  -1.73E+00, 115,327,  -1.81E+00, 115,328,  -2.06E+00,
     &115,329,  -2.23E+00, 115,330,  -2.54E+00, 115,331,  -2.73E+00,
     &115,332,  -3.04E+00, 115,333,  -3.11E+00, 115,334,  -3.54E+00/
      data (nsz(i),nsa(i),shin(i),i=8401,8430)/
     &115,335,  -3.82E+00, 115,336,  -4.34E+00, 115,337,  -4.87E+00,
     &115,338,  -5.76E+00, 115,339,  -6.39E+00, 116,275,  -3.42E+00,
     &116,276,  -3.66E+00, 116,277,  -4.15E+00, 116,278,  -4.41E+00,
     &116,279,  -4.77E+00, 116,280,  -5.48E+00, 116,281,  -5.99E+00,
     &116,282,  -6.18E+00, 116,283,  -6.64E+00, 116,284,  -6.78E+00,
     &116,285,  -7.21E+00, 116,286,  -7.22E+00, 116,287,  -7.60E+00,
     &116,288,  -7.50E+00, 116,289,  -7.83E+00, 116,290,  -7.81E+00,
     &116,291,  -8.07E+00, 116,292,  -8.30E+00, 116,293,  -8.62E+00,
     &116,294,  -8.70E+00, 116,295,  -8.98E+00, 116,296,  -8.58E+00,
     &116,297,  -8.63E+00, 116,298,  -8.08E+00, 116,299,  -7.94E+00/
      data (nsz(i),nsa(i),shin(i),i=8431,8460)/
     &116,300,  -7.25E+00, 116,301,  -6.39E+00, 116,302,  -5.66E+00,
     &116,303,  -4.54E+00, 116,304,  -3.82E+00, 116,305,  -2.83E+00,
     &116,306,  -2.15E+00, 116,307,  -1.32E+00, 116,308,  -6.20E-01,
     &116,309,  -1.10E-01, 116,310,   5.30E-01, 116,311,  -6.70E-01,
     &116,312,  -5.50E-01, 116,313,  -5.80E-01, 116,314,  -9.40E-01,
     &116,315,  -1.30E+00, 116,316,  -1.34E+00, 116,317,  -1.69E+00,
     &116,318,  -1.71E+00, 116,319,  -1.83E+00, 116,320,  -1.56E+00,
     &116,321,  -1.53E+00, 116,322,  -1.21E+00, 116,323,  -1.25E+00,
     &116,324,  -1.04E+00, 116,325,  -1.39E+00, 116,326,  -1.27E+00,
     &116,327,  -1.60E+00, 116,328,  -1.40E+00, 116,329,  -1.76E+00/
      data (nsz(i),nsa(i),shin(i),i=8461,8490)/
     &116,330,  -1.87E+00, 116,331,  -2.24E+00, 116,332,  -2.25E+00,
     &116,333,  -2.53E+00, 116,334,  -2.80E+00, 116,335,  -3.27E+00,
     &116,336,  -3.55E+00, 116,337,  -4.10E+00, 116,338,  -4.51E+00,
     &116,339,  -5.55E+00, 117,278,  -4.01E+00, 117,279,  -4.61E+00,
     &117,280,  -4.55E+00, 117,281,  -5.52E+00, 117,282,  -6.09E+00,
     &117,283,  -6.25E+00, 117,284,  -6.72E+00, 117,285,  -6.87E+00,
     &117,286,  -7.27E+00, 117,287,  -7.33E+00, 117,288,  -7.72E+00,
     &117,289,  -7.68E+00, 117,290,  -8.03E+00, 117,291,  -8.02E+00,
     &117,292,  -8.30E+00, 117,293,  -8.21E+00, 117,294,  -8.44E+00,
     &117,295,  -8.55E+00, 117,296,  -8.96E+00, 117,297,  -8.57E+00/
      data (nsz(i),nsa(i),shin(i),i=8491,8520)/
     &117,298,  -8.59E+00, 117,299,  -8.02E+00, 117,300,  -7.85E+00,
     &117,301,  -7.16E+00, 117,302,  -6.29E+00, 117,303,  -5.57E+00,
     &117,304,  -4.47E+00, 117,305,  -3.74E+00, 117,306,  -2.72E+00,
     &117,307,  -2.07E+00, 117,308,  -1.32E+00, 117,309,  -2.24E+00,
     &117,310,   1.10E-01, 117,311,   5.30E-01, 117,312,  -8.30E-01,
     &117,313,  -4.30E-01, 117,314,  -1.90E-01, 117,315,  -1.26E+00,
     &117,316,  -1.53E+00, 117,317,  -1.58E+00, 117,318,  -1.87E+00,
     &117,319,  -1.94E+00, 117,320,  -1.99E+00, 117,321,  -1.70E+00,
     &117,322,  -1.66E+00, 117,323,  -1.31E+00, 117,324,  -1.34E+00,
     &117,325,  -1.09E+00, 117,326,  -1.39E+00, 117,327,  -1.21E+00/
      data (nsz(i),nsa(i),shin(i),i=8521,8550)/
     &117,328,  -1.51E+00, 117,329,  -1.43E+00, 117,330,  -1.74E+00,
     &117,331,  -1.81E+00, 117,332,  -2.20E+00, 117,333,  -2.26E+00,
     &117,334,  -2.71E+00, 117,335,  -2.98E+00, 117,336,  -3.46E+00,
     &117,337,  -3.73E+00, 117,338,  -4.32E+00, 117,339,  -4.72E+00,
     &118,281,  -4.04E+00, 118,282,  -5.07E+00, 118,283,  -5.52E+00,
     &118,284,  -5.72E+00, 118,285,  -6.15E+00, 118,286,  -6.25E+00,
     &118,287,  -6.75E+00, 118,288,  -6.78E+00, 118,289,  -7.20E+00,
     &118,290,  -7.04E+00, 118,291,  -7.55E+00, 118,292,  -7.52E+00,
     &118,293,  -7.82E+00, 118,294,  -7.67E+00, 118,295,  -7.89E+00,
     &118,296,  -7.90E+00, 118,297,  -8.27E+00, 118,298,  -7.83E+00/
      data (nsz(i),nsa(i),shin(i),i=8551,8580)/
     &118,299,  -7.84E+00, 118,300,  -7.24E+00, 118,301,  -7.05E+00,
     &118,302,  -6.36E+00, 118,303,  -5.29E+00, 118,304,  -4.78E+00,
     &118,305,  -3.67E+00, 118,306,  -2.95E+00, 118,307,  -2.05E+00,
     &118,308,  -1.31E+00, 118,309,  -6.60E-01, 118,310,   1.60E-01,
     &118,311,   3.80E-01, 118,312,   7.60E-01, 118,313,  -5.04E+00,
     &118,314,  -4.91E+00, 118,315,  -5.13E+00, 118,316,  -1.41E+00,
     &118,317,  -1.55E+00, 118,318,  -1.59E+00, 118,319,  -1.88E+00,
     &118,320,  -1.82E+00, 118,321,  -1.99E+00, 118,322,  -1.69E+00,
     &118,323,  -1.64E+00, 118,324,  -1.28E+00, 118,325,  -1.31E+00,
     &118,326,  -1.04E+00, 118,327,  -1.20E+00, 118,328,  -9.90E-01/
      data (nsz(i),nsa(i),shin(i),i=8581,8610)/
     &118,329,  -2.63E+00, 118,330,  -2.64E+00, 118,331,  -2.86E+00,
     &118,332,  -1.44E+00, 118,333,  -1.79E+00, 118,334,  -1.79E+00,
     &118,335,  -2.28E+00, 118,336,  -2.56E+00, 118,337,  -3.04E+00,
     &118,338,  -3.35E+00, 118,339,  -3.95E+00, 119,284,  -5.36E+00,
     &119,285,  -5.45E+00, 119,286,  -5.96E+00, 119,287,  -6.29E+00,
     &119,288,  -6.71E+00, 119,289,  -6.58E+00, 119,290,  -7.05E+00,
     &119,291,  -7.15E+00, 119,292,  -7.45E+00, 119,293,  -7.58E+00,
     &119,294,  -7.89E+00, 119,295,  -7.67E+00, 119,296,  -7.63E+00,
     &119,297,  -7.75E+00, 119,298,  -8.11E+00, 119,299,  -7.79E+00,
     &119,300,  -7.73E+00, 119,301,  -7.09E+00, 119,302,  -6.88E+00/
      data (nsz(i),nsa(i),shin(i),i=8611,8640)/
     &119,303,  -6.18E+00, 119,304,  -5.11E+00, 119,305,  -4.60E+00,
     &119,306,  -3.47E+00, 119,307,  -2.78E+00, 119,308,  -1.93E+00,
     &119,309,  -1.18E+00, 119,310,  -5.90E-01, 119,311,  -8.00E-02,
     &119,312,   4.30E-01, 119,313,   7.70E-01, 119,314,  -5.33E+00,
     &119,315,  -5.31E+00, 119,316,  -5.53E+00, 119,317,  -1.99E+00,
     &119,318,  -1.93E+00, 119,319,  -1.96E+00, 119,320,  -2.15E+00,
     &119,321,  -2.04E+00, 119,322,  -2.18E+00, 119,323,  -1.86E+00,
     &119,324,  -1.76E+00, 119,325,  -1.39E+00, 119,326,  -1.43E+00,
     &119,327,  -1.13E+00, 119,328,  -1.29E+00, 119,329,  -1.10E+00,
     &119,330,  -3.10E+00, 119,331,  -3.00E+00, 119,332,  -3.21E+00/
      data (nsz(i),nsa(i),shin(i),i=8641,8670)/
     &119,333,  -1.15E+00, 119,334,  -1.57E+00, 119,335,  -1.66E+00,
     &119,336,  -2.18E+00, 119,337,  -2.50E+00, 119,338,  -3.03E+00,
     &119,339,  -3.34E+00, 120,287,  -5.53E+00, 120,288,  -5.68E+00,
     &120,289,  -6.02E+00, 120,290,  -6.12E+00, 120,291,  -6.37E+00,
     &120,292,  -6.30E+00, 120,293,  -6.81E+00, 120,294,  -6.92E+00,
     &120,295,  -7.25E+00, 120,296,  -6.77E+00, 120,297,  -7.09E+00,
     &120,298,  -7.02E+00, 120,299,  -7.36E+00, 120,300,  -6.95E+00,
     &120,301,  -6.92E+00, 120,302,  -6.31E+00, 120,303,  -6.08E+00,
     &120,304,  -5.37E+00, 120,305,  -4.39E+00, 120,306,  -3.79E+00,
     &120,307,  -2.71E+00, 120,308,  -1.93E+00, 120,309,  -1.25E+00/
      data (nsz(i),nsa(i),shin(i),i=8671,8700)/
     &120,310,  -5.10E-01, 120,311,   0.00E+00, 120,312,   4.30E-01,
     &120,313,   8.00E-01, 120,314,   1.09E+00, 120,315,  -5.50E+00,
     &120,316,  -5.49E+00, 120,317,  -5.71E+00, 120,318,  -5.53E+00,
     &120,319,  -1.98E+00, 120,320,  -1.91E+00, 120,321,  -2.19E+00,
     &120,322,  -2.09E+00, 120,323,  -2.22E+00, 120,324,  -1.85E+00,
     &120,325,  -1.78E+00, 120,326,  -1.43E+00, 120,327,  -1.46E+00,
     &120,328,  -1.17E+00, 120,329,  -1.30E+00, 120,330,  -1.00E+00,
     &120,331,  -1.23E+00, 120,332,  -1.04E+00, 120,333,  -3.22E+00,
     &120,334,  -8.30E-01, 120,335,  -9.20E-01, 120,336,  -1.16E+00,
     &120,337,  -1.56E+00, 120,338,  -1.87E+00, 120,339,  -2.41E+00/
      data (nsz(i),nsa(i),shin(i),i=8701,8730)/
     &121,290,  -5.87E+00, 121,291,  -5.98E+00, 121,292,  -6.30E+00,
     &121,293,  -6.24E+00, 121,294,  -6.57E+00, 121,295,  -6.50E+00,
     &121,296,  -6.80E+00, 121,297,  -6.54E+00, 121,298,  -6.75E+00,
     &121,299,  -6.73E+00, 121,300,  -7.11E+00, 121,301,  -6.75E+00,
     &121,302,  -6.65E+00, 121,303,  -6.02E+00, 121,304,  -5.76E+00,
     &121,305,  -5.05E+00, 121,306,  -3.80E+00, 121,307,  -3.39E+00,
     &121,308,  -2.42E+00, 121,309,  -1.69E+00, 121,310,  -1.17E+00,
     &121,311,  -4.80E-01, 121,312,  -9.00E-02, 121,313,   3.00E-01,
     &121,314,   6.00E-01, 121,315,   8.60E-01, 121,316,  -5.95E+00,
     &121,317,  -5.79E+00, 121,318,  -6.13E+00, 121,319,  -5.94E+00/
      data (nsz(i),nsa(i),shin(i),i=8731,8760)/
     &121,320,  -2.43E+00, 121,321,  -2.30E+00, 121,322,  -2.49E+00,
     &121,323,  -2.46E+00, 121,324,  -2.47E+00, 121,325,  -2.14E+00,
     &121,326,  -1.98E+00, 121,327,  -1.67E+00, 121,328,  -1.65E+00,
     &121,329,  -1.13E+00, 121,330,  -1.47E+00, 121,331,  -1.27E+00,
     &121,332,  -1.40E+00, 121,333,  -1.22E+00, 121,334,  -3.33E+00,
     &121,335,  -7.70E-01, 121,336,  -1.04E+00, 121,337,  -8.70E-01,
     &121,338,  -1.35E+00, 121,339,  -1.49E+00, 122,294,  -5.67E+00,
     &122,295,  -5.92E+00, 122,296,  -5.76E+00, 122,297,  -5.84E+00,
     &122,298,  -5.73E+00, 122,299,  -5.85E+00, 122,300,  -6.27E+00,
     &122,301,  -6.56E+00, 122,302,  -6.21E+00, 122,303,  -5.77E+00/
      data (nsz(i),nsa(i),shin(i),i=8761,8790)/
     &122,304,  -5.14E+00, 122,305,  -4.88E+00, 122,306,  -4.16E+00,
     &122,307,  -3.13E+00, 122,308,  -2.44E+00, 122,309,  -1.73E+00,
     &122,310,  -9.50E-01, 122,311,  -5.90E-01, 122,312,   0.00E+00,
     &122,313,   3.30E-01, 122,314,   6.60E-01, 122,315,   8.80E-01,
     &122,316,   1.10E+00, 122,317,  -6.16E+00, 122,318,  -6.13E+00,
     &122,319,  -6.33E+00, 122,320,  -6.14E+00, 122,321,  -6.34E+00,
     &122,322,  -2.38E+00, 122,323,  -2.57E+00, 122,324,  -2.56E+00,
     &122,325,  -2.57E+00, 122,326,  -2.24E+00, 122,327,  -2.10E+00,
     &122,328,  -1.75E+00, 122,329,  -1.75E+00, 122,330,  -1.45E+00,
     &122,331,  -1.54E+00, 122,332,  -1.34E+00, 122,333,  -1.48E+00/
      data (nsz(i),nsa(i),shin(i),i=8791,8820)/
     &122,334,  -1.27E+00, 122,335,  -1.25E+00, 122,336,  -5.70E-01,
     &122,337,  -8.10E-01, 122,338,  -8.10E-01, 122,339,  -9.60E-01,
     &123,297,  -5.59E+00, 123,298,  -5.51E+00, 123,299,  -5.46E+00,
     &123,300,  -5.63E+00, 123,301,  -6.15E+00, 123,302,  -6.56E+00,
     &123,303,  -6.69E+00, 123,304,  -5.29E+00, 123,305,  -4.66E+00,
     &123,306,  -4.39E+00, 123,307,  -3.62E+00, 123,308,  -2.63E+00,
     &123,309,  -1.98E+00, 123,310,  -1.44E+00, 123,311,  -8.00E-01,
     &123,312,  -5.40E-01, 123,313,  -1.00E-02, 123,314,   2.70E-01,
     &123,315,   5.60E-01, 123,316,   7.50E-01, 123,317,   9.60E-01,
     &123,318,  -6.64E+00, 123,319,  -6.48E+00, 123,320,  -6.80E+00/
      data (nsz(i),nsa(i),shin(i),i=8821,8850)/
     &123,321,  -6.62E+00, 123,322,  -6.80E+00, 123,323,  -2.85E+00,
     &123,324,  -2.91E+00, 123,325,  -2.91E+00, 123,326,  -2.93E+00,
     &123,327,  -2.58E+00, 123,328,  -2.44E+00, 123,329,  -2.10E+00,
     &123,330,  -2.06E+00, 123,331,  -1.75E+00, 123,332,  -1.78E+00,
     &123,333,  -1.57E+00, 123,334,  -1.69E+00, 123,335,  -1.51E+00,
     &123,336,  -1.47E+00, 123,337,  -7.40E-01, 123,338,  -8.70E-01,
     &123,339,  -8.80E-01, 124,300,  -4.62E+00, 124,301,  -4.94E+00,
     &124,302,  -6.10E+00, 124,303,  -6.53E+00, 124,304,  -6.66E+00,
     &124,305,  -7.03E+00, 124,306,  -3.68E+00, 124,307,  -3.40E+00,
     &124,308,  -2.56E+00, 124,309,  -1.82E+00, 124,310,  -1.15E+00/
      data (nsz(i),nsa(i),shin(i),i=8851,8880)/
     &124,311,  -8.20E-01, 124,312,  -2.20E-01, 124,313,  -3.00E-02,
     &124,314,   4.60E-01, 124,315,   6.80E-01, 124,316,   9.20E-01,
     &124,317,  -5.28E+00, 124,318,  -6.67E+00, 124,319,  -6.88E+00,
     &124,320,  -6.86E+00, 124,321,  -7.07E+00, 124,322,  -6.89E+00,
     &124,323,  -7.08E+00, 124,324,  -6.87E+00, 124,325,  -2.99E+00,
     &124,326,  -2.89E+00, 124,327,  -3.00E+00, 124,328,  -2.64E+00,
     &124,329,  -2.53E+00, 124,330,  -2.18E+00, 124,331,  -2.19E+00,
     &124,332,  -1.86E+00, 124,333,  -1.91E+00, 124,334,  -1.70E+00,
     &124,335,  -1.82E+00, 124,336,  -1.66E+00, 124,337,  -1.60E+00,
     &124,338,  -1.78E+00, 124,339,  -7.70E-01, 125,303,  -6.61E+00/
      data (nsz(i),nsa(i),shin(i),i=8881,8910)/
     &125,304,  -6.97E+00, 125,305,  -7.17E+00, 125,306,  -3.64E+00,
     &125,307,  -2.96E+00, 125,308,  -2.59E+00, 125,309,  -1.74E+00,
     &125,310,  -1.15E+00, 125,311,  -3.60E-01, 125,312,  -3.70E-01,
     &125,313,   1.00E-01, 125,314,   2.40E-01, 125,315,   6.80E-01,
     &125,316,   7.90E-01, 125,317,   1.09E+00, 125,318,  -5.89E+00,
     &125,319,  -7.19E+00, 125,320,  -7.39E+00, 125,321,  -7.26E+00,
     &125,322,  -7.60E+00, 125,323,  -7.43E+00, 125,324,  -7.61E+00,
     &125,325,  -7.40E+00, 125,326,  -3.35E+00, 125,327,  -7.09E+00,
     &125,328,  -3.38E+00, 125,329,  -3.02E+00, 125,330,  -2.89E+00,
     &125,331,  -2.62E+00, 125,332,  -2.55E+00, 125,333,  -2.32E+00/
      data (nsz(i),nsa(i),shin(i),i=8911,8940)/
     &125,334,  -2.25E+00, 125,335,  -2.02E+00, 125,336,  -2.11E+00,
     &125,337,  -1.95E+00, 125,338,  -1.91E+00, 125,339,  -1.90E+00,
     &126,306,  -7.21E+00, 126,307,  -7.58E+00, 126,308,  -1.91E+00,
     &126,309,  -1.57E+00, 126,310,  -1.01E+00, 126,311,  -5.40E-01,
     &126,312,  -1.40E-01, 126,313,   1.60E-01, 126,314,   6.80E-01,
     &126,315,   7.60E-01, 126,316,   1.18E+00, 126,317,   1.21E+00,
     &126,318,   1.52E+00, 126,319,  -6.14E+00, 126,320,  -5.60E+00,
     &126,321,  -7.66E+00, 126,322,  -7.67E+00, 126,323,  -7.91E+00,
     &126,324,  -7.76E+00, 126,325,  -7.96E+00, 126,326,  -7.75E+00,
     &126,327,  -3.44E+00, 126,328,  -3.35E+00, 126,329,  -3.44E+00/
      data (nsz(i),nsa(i),shin(i),i=8941,8970)/
     &126,330,  -3.11E+00, 126,331,  -2.99E+00, 126,332,  -2.66E+00,
     &126,333,  -2.66E+00, 126,334,  -2.29E+00, 126,335,  -2.40E+00,
     &126,336,  -2.17E+00, 126,337,  -2.28E+00, 126,338,  -2.11E+00,
     &126,339,  -2.03E+00, 127,310,  -7.50E-01, 127,311,  -2.60E-01,
     &127,312,   6.00E-02, 127,313,   3.80E-01, 127,314,   6.50E-01,
     &127,315,   9.90E-01, 127,316,   1.16E+00, 127,317,   1.54E+00,
     &127,318,  -7.44E+00, 127,319,  -7.01E+00, 127,320,  -6.71E+00,
     &127,321,  -6.16E+00, 127,322,  -8.18E+00, 127,323,  -8.21E+00,
     &127,324,  -8.44E+00, 127,325,  -8.29E+00, 127,326,  -8.46E+00,
     &127,327,  -8.27E+00, 127,328,  -8.31E+00, 127,329,  -7.94E+00/
      data (nsz(i),nsa(i),shin(i),i=8971,9000)/
     &127,330,  -3.81E+00, 127,331,  -3.48E+00, 127,332,  -3.37E+00,
     &127,333,  -3.04E+00, 127,334,  -3.01E+00, 127,335,  -2.78E+00,
     &127,336,  -2.83E+00, 127,337,  -2.61E+00, 127,338,  -2.65E+00,
     &127,339,  -2.48E+00, 128,313,   5.00E-01, 128,314,   9.40E-01,
     &128,315,   1.05E+00, 128,316,   1.52E+00, 128,317,   1.52E+00,
     &128,318,   1.89E+00, 128,319,  -7.56E+00, 128,320,  -7.07E+00,
     &128,321,  -6.83E+00, 128,322,  -6.27E+00, 128,323,  -5.86E+00,
     &128,324,  -8.53E+00, 128,325,  -8.76E+00, 128,326,  -8.65E+00,
     &128,327,  -8.87E+00, 128,328,  -8.66E+00, 128,329,  -8.71E+00,
     &128,330,  -8.34E+00, 128,331,  -3.79E+00, 128,332,  -3.49E+00/
      data (nsz(i),nsa(i),shin(i),i=9001,9030)/
     &128,333,  -3.45E+00, 128,334,  -3.10E+00, 128,335,  -3.14E+00,
     &128,336,  -2.83E+00, 128,337,  -2.85E+00, 128,338,  -2.61E+00,
     &128,339,  -2.85E+00, 129,316,   1.43E+00, 129,317,   1.74E+00,
     &129,318,  -8.34E+00, 129,319,  -8.06E+00, 129,320,  -7.87E+00,
     &129,321,  -7.38E+00, 129,322,  -7.19E+00, 129,323,  -6.65E+00,
     &129,324,  -6.28E+00, 129,325,  -9.10E+00, 129,326,  -9.36E+00,
     &129,327,  -9.23E+00, 129,328,  -9.45E+00, 129,329,  -9.26E+00,
     &129,330,  -9.29E+00, 129,331,  -8.93E+00, 129,332,  -4.16E+00,
     &129,333,  -3.88E+00, 129,334,  -3.83E+00, 129,335,  -3.48E+00,
     &129,336,  -3.44E+00, 129,337,  -3.05E+00, 129,338,  -2.91E+00/
      data (nsz(i),nsa(i),shin(i),i=9031,9060)/
     &129,339,  -3.21E+00, 130,319,   2.10E+00, 130,320,   2.42E+00,
     &130,321,  -7.71E+00, 130,322,  -7.32E+00, 130,323,  -7.07E+00,
     &130,324,  -6.61E+00, 130,325,  -9.49E+00, 130,326,  -9.41E+00,
     &130,327,  -9.68E+00, 130,328,  -9.55E+00, 130,329,  -9.76E+00,
     &130,330,  -9.57E+00, 130,331,  -4.22E+00, 130,332,  -9.24E+00,
     &130,333,  -4.26E+00, 130,334,  -3.96E+00, 130,335,  -3.90E+00,
     &130,336,  -3.56E+00, 130,337,  -3.69E+00, 130,338,  -3.40E+00,
     &130,339,  -3.19E+00, 131,323,  -7.70E+00, 131,324,  -7.39E+00,
     &131,325,  -6.89E+00, 131,326,  -1.01E+01, 131,327,  -9.99E+00,
     &131,328,  -1.03E+01, 131,329,  -1.01E+01, 131,330,  -1.04E+01/
      data (nsz(i),nsa(i),shin(i),i=9061,9090)/
     &131,331,  -1.02E+01, 131,332,  -1.02E+01, 131,333,  -9.87E+00,
     &131,334,  -4.64E+00, 131,335,  -4.26E+00, 131,336,  -4.29E+00,
     &131,337,  -4.38E+00, 131,338,  -4.30E+00, 131,339,  -3.95E+00,
     &132,326,  -6.79E+00, 132,327,  -1.04E+01, 132,328,  -1.03E+01,
     &132,329,  -1.06E+01, 132,330,  -1.05E+01, 132,331,  -1.07E+01,
     &132,332,  -1.05E+01, 132,333,  -4.70E+00, 132,334,  -4.60E+00,
     &132,335,  -4.80E+00, 132,336,  -4.38E+00, 132,337,  -4.36E+00,
     &132,338,  -4.03E+00, 132,339,  -4.55E+00, 133,329,  -1.09E+01,
     &133,330,  -1.12E+01, 133,331,  -1.11E+01, 133,332,  -1.13E+01,
     &133,333,  -5.68E+00, 133,334,  -5.08E+00, 133,335,  -4.87E+00/
      data (nsz(i),nsa(i),shin(i),i=9091,9107)/
     &133,336,  -5.20E+00, 133,337,  -4.92E+00, 133,338,  -4.78E+00,
     &133,339,  -5.26E+00, 134,332,  -6.14E+00, 134,333,  -6.06E+00,
     &134,334,  -5.81E+00, 134,335,  -5.17E+00, 134,336,  -5.15E+00,
     &134,337,  -5.34E+00, 134,338,  -5.10E+00, 134,339,  -5.12E+00,
     &135,336,  -5.61E+00, 135,337,  -5.59E+00, 135,338,  -5.84E+00,
     &135,339,  -5.59E+00, 136,339,  -6.12E+00/


      end

************************************************************************
*                                                                      *
      block data exlevel
*                                                                      *
*                                                                      *
*        Purpose:                                                      *
*                                                                      *
*              Nuclear levels of the ejectiles for GEM                 *
*                                                                      *
*                                                                      *
************************************************************************

*-----------------------------------------------------------------------

      implicit double precision(a-h, o-z)

*-----------------------------------------------------------------------

      common /exiejn/ nimax,ndmax,nlvl(70)
      common /exieje/ exm(70,200),spin(70,200),width(70,200)

*-----------------------------------------------------------------------
*     total number of data
*-----------------------------------------------------------------------

      data ndmax /65/

*-----------------------------------------------------------------------
*     Nuclear levels of the ejectiles for GEM
*-----------------------------------------------------------------------


*( 7) 6He 
      data nlvl( 7) /  1/
      data (width( 7,j),spin( 7,j),exm( 7,j),j=  1,  1)/
     &   1.130E+02,  2.0,   1.79700/

*( 8) 8He 
      data nlvl( 8) /  0/

*( 9) 6Li 
      data nlvl( 9) /  3/
      data (width( 9,j),spin( 9,j),exm( 9,j),j=  1,  3)/
     &   8.200E-06,  0.0,   3.56288,
     &   2.400E-02,  3.0,   2.18600,
     &   5.400E-01,  2.0,   5.36600/

*(10) 7Li 
      data nlvl(10) /  6/
      data (width(10,j),spin(10,j),exm(10,j),j=  1,  6)/
     &   6.250E-09,  0.5,   0.47761,
     &   8.900E-02,  2.5,   7.45950,
     &   9.300E-02,  3.5,   4.63000,
     &   2.600E-01,  1.5,  11.24000,
     &   4.000E-01,  3.5,   9.67000,
     &   8.800E-01,  2.5,   6.68000/

*(11) 8Li 
      data nlvl(11) /  5/
      data (width(11,j),spin(11,j),exm(11,j),j=  1,  5)/
     &   5.703E-08,  1.0,   0.98080,
     &   1.200E-02,  0.0,  10.82220,
     &   3.300E-02,  3.0,   2.25500,
     &   3.500E-02,  4.0,   6.53000,
     &   6.500E-01,  0.5,   5.40000/

*(12) 9Li 
      data nlvl(12) /  1/
      data (width(12,j),spin(12,j),exm(12,j),j=  1,  1)/
     &   4.000E-02,  4.5,   6.43000/

*(13) 7Be 
      data nlvl(13) /  4/
      data (width(13,j),spin(13,j),exm(13,j),j=  1,  4)/
     &   3.430E-09,  0.5,   0.42908,
     &   1.750E-01,  3.5,   4.57000,
     &   5.000E-01,  2.5,   7.21000,
     &   3.200E-01,  1.5,  11.01000/

*(14) 9Be 
      data nlvl(14) /  9/
      data (width(14,j),spin(14,j),exm(14,j),j=  1,  9)/
     &   3.810E-04,  1.5,  14.39220,
     &   4.900E-04,  0.5,  16.97520,
     &   7.700E-04,  2.5,   2.42940,
     &   4.100E-02,  2.5,  16.67100,
     &   4.700E-02,  3.5,  17.49300,
     &   2.000E-01,  2.5,  17.29800,
     &   2.170E-01,  0.5,   1.68400,
     &   2.820E-01,  2.5,   3.04900,
     &   7.430E-01,  1.5,   4.70400/

*(15) 10Be
      data nlvl(15) /  9/
      data (width(15,j),spin(15,j),exm(15,j),j=  1,  9)/
     &   5.703E-10,  0.0,   6.17930,
     &   5.703E-10,  2.0,   6.26330,
     &   3.650E-09,  2.0,   3.36803,
     &   8.295E-09,  2.0,   5.95839,
     &   8.295E-09,  1.0,   5.95990,
     &   6.300E-03,  2.0,   7.54200,
     &   1.570E-02,  3.0,   7.37100,
     &   1.500E-01,  4.0,   9.27000,
     &   2.910E-01,  2.0,   9.40000/

*(16) 11Be
      data nlvl(16) /  5/
      data (width(16,j),spin(16,j),exm(16,j),j=  1,  5)/
     &   3.967E-09,  0.5,   0.32004,
     &   1.500E-02,  1.5,   3.95600,
     &   1.000E-01,  2.0,   1.77800,
     &   1.250E-01,  1.5,   3.41000,
     &   2.000E-01,  1.5,   2.69000/

*(17) 12Be
      data nlvl(17) /  0/

*(18) 8B  
      data nlvl(18) /  2/
      data (width(18,j),spin(18,j),exm(18,j),j=  1,  2)/
     &   6.000E-02,  0.0,  10.61900,
     &   3.500E-01,  3.0,   2.32000/

*(19) 10B 
      data nlvl(19) / 28/
      data (width(19,j),spin(19,j),exm(19,j),j=  1, 10)/
     &   6.453E-13,  1.0,   0.71835,
     &   3.083E-10,  1.0,   2.15430,
     &   4.304E-09,  2.0,   3.58710,
     &   9.125E-08,  0.0,   1.74015,
     &   1.086E-07,  2.0,   5.16390,
     &   8.400E-06,  3.0,   4.77400,
     &   5.000E-05,  4.0,   6.02500,
     &   9.800E-04,  2.0,   5.11030,
     &   2.360E-03,  3.0,   6.12720,
     &   2.650E-03,  0.0,   7.55990/
      data (width(19,j),spin(19,j),exm(19,j),j= 11, 20)/
     &   6.000E-03,  2.0,   5.91950,
     &   2.510E-02,  4.0,   6.56000,
     &   4.000E-02,  2.0,   8.89400,
     &   6.500E-02,  1.0,   7.46700,
     &   7.400E-02,  2.0,   7.47800,
     &   8.400E-02,  3.0,   8.88900,
     &   1.000E-01,  2.0,   7.43000,
     &   1.000E-01,  1.5,   7.00200,
     &   1.000E-01,  1.0,  12.56000,
     &   1.100E-01,  1.0,   5.18000/
      data (width(19,j),spin(19,j),exm(19,j),j= 21, 28)/
     &   1.200E-01,  1.0,   6.87300,
     &   1.900E-01,  2.0,  19.29000,
     &   2.600E-01,  1.0,   7.81900,
     &   3.000E-01,  1.0,  13.49000,
     &   3.000E-01,  3.0,  10.84000,
     &   3.400E-01,  2.0,  18.43000,
     &   6.000E-01,  1.5,  18.80000,
     &   8.000E-01,  2.0,   8.07000/

*(20) 11B 
      data nlvl(20) / 26/
      data (width(20,j),spin(20,j),exm(20,j),j=  1, 10)/
     &   1.201E-07,  0.5,   2.12469,
     &   1.900E-06,  3.5,   9.18500,
     &   4.370E-06,  2.5,   8.92020,
     &   3.400E-04,  1.5,   5.02031,
     &   5.700E-04,  1.5,   7.97784,
     &   5.700E-04,  2.5,   7.28551,
     &   7.000E-04,  1.5,   8.56030,
     &   1.180E-03,  2.5,   4.44489,
     &   1.700E-03,  0.5,   6.79180,
     &   4.000E-03,  2.5,   9.27440/
      data (width(20,j),spin(20,j),exm(20,j),j= 11, 20)/
     &   2.200E-02,  3.5,   6.74290,
     &   1.000E-01,  3.5,  10.59700,
     &   1.100E-01,  2.5,  10.33000,
     &   1.100E-01,  1.5,   9.87600,
     &   1.100E-01,  4.5,  11.26500,
     &   1.500E-01,  1.5,  10.26000,
     &   1.700E-01,  2.5,  11.60000,
     &   2.000E-01,  0.5,  12.91600,
     &   2.000E-01,  2.5,  11.88600,
     &   2.100E-01,  0.5,  12.55700/
      data (width(20,j),spin(20,j),exm(20,j),j= 21, 26)/
     &   2.500E-01,  2.5,  15.29000,
     &   2.540E-01,  2.5,  14.34000,
     &   2.600E-01,  1.5,  18.37000,
     &   4.260E-01,  4.5,  13.13700,
     &   4.300E-01,  3.0,  13.16000,
     &   5.000E-01, 10.5,  14.00000/

*(21) 12B 
      data nlvl(21) / 19/
      data (width(21,j),spin(21,j),exm(21,j),j=  1, 10)/
     &   2.535E-09,  2.0,   0.95314,
     &   9.311E-09,  1.0,   2.62080,
     &   1.304E-08,  2.0,   1.67365,
     &   3.100E-06,  3.0,   3.38910,
     &   9.000E-03,  1.0,   4.30100,
     &   2.700E-02,  1.0,   7.93700,
     &   3.400E-02,  3.0,   9.58500,
     &   4.000E-02,  2.0,   3.75900,
     &   5.000E-02,  3.0,   5.72600,
     &   5.000E-02,  1.0,   5.00000/
      data (width(21,j),spin(21,j),exm(21,j),j= 11, 19)/
     &   6.000E-02,  1.0,   7.83600,
     &   6.500E-02,  3.0,   8.24000,
     &   7.500E-02,  3.0,   8.58000,
     &   8.500E-02,  0.0,  12.75000,
     &   9.500E-02,  1.0,   9.04000,
     &   1.100E-01,  4.0,   4.51800,
     &   1.100E-01,  3.0,   5.61200,
     &   1.400E-01,  1.0,   6.60000,
     &   2.000E-01,  2.0,  14.80000/

*(22) 13B 
      data nlvl(22) /  0/

*(23) 10C 
      data nlvl(23) /  2/
      data (width(23,j),spin(23,j),exm(23,j),j=  1,  2)/
     &   4.264E-09,  2.0,   3.35360,
     &   2.000E-01,  2.0,   6.58000/

*(24) 11C 
      data nlvl(24) / 19/
      data (width(24,j),spin(24,j),exm(24,j),j=  1, 10)/
     &   5.987E-09,  0.5,   6.33920,
     &   7.242E-09,  1.5,   7.49970,
     &   9.505E-09,  2.5,   6.90480,
     &   5.497E-08,  2.5,   4.31880,
     &   6.003E-08,  1.5,   4.80420,
     &   6.426E-08,  0.5,   2.00000,
     &   7.604E-08,  3.5,   6.47820,
     &   1.141E-05,  1.5,   8.10450,
     &   1.521E-05,  2.5,   8.42000,
     &   5.000E-03,  3.5,   8.65500/
      data (width(24,j),spin(24,j),exm(24,j),j= 11, 19)/
     &   1.500E-02,  2.5,   8.69900,
     &   1.200E-01,  3.5,   9.97000,
     &   2.000E-01,  4.5,  10.67900,
     &   2.100E-01,  1.5,   9.65000,
     &   2.300E-01,  3.5,  10.08300,
     &   2.400E-01,  2.5,   9.78000,
     &   3.600E-01,  3.5,  12.65000,
     &   4.900E-01,  0.5,  12.51000,
     &   5.000E-01,  2.5,   9.20000/

*(25) 12C 
      data nlvl(25) / 30/
      data (width(25,j),spin(25,j),exm(25,j),j=  1, 10)/
     &   1.080E-08,  2.0,   4.43891,
     &   8.500E-06,  0.0,   7.65420,
     &   1.810E-05,  1.0,  12.71000,
     &   4.360E-05,  1.0,  15.11000,
     &   5.300E-03,  2.0,  16.10580,
     &   3.000E-02,  0.0,  27.59500,
     &   3.400E-02,  3.0,   9.64100,
     &   6.000E-02,  2.0,  23.04000,
     &   8.000E-02,  0.0,  17.76000,
     &   1.000E-01,  2.0,  18.80000/
      data (width(25,j),spin(25,j),exm(25,j),j= 11, 20)/
     &   1.400E-01,  1.0,  20.27000,
     &   2.000E-01,  3.0,  20.62000,
     &   2.200E-01,  3.0,  18.35000,
     &   2.300E-01,  1.0,  23.52000,
     &   2.300E-01,  1.0,  19.69000,
     &   2.400E-01,  1.0,  18.16000,
     &   2.500E-01,  2.0,  20.00000,
     &   2.580E-01,  4.0,  14.08300,
     &   2.600E-01,  2.0,  11.82800,
     &   2.750E-01,  1.0,  22.40000/
      data (width(25,j),spin(25,j),exm(25,j),j= 21, 30)/
     &   3.000E-01,  3.0,  20.50000,
     &   3.000E-01,  2.0,  16.57000,
     &   3.150E-01,  1.0,  10.84400,
     &   3.500E-01,  2.0,  18.35000,
     &   3.750E-01,  2.0,  13.35200,
     &   4.000E-01,  1.0,  23.92000,
     &   4.800E-01,  2.0,  19.40000,
     &   4.900E-01,  4.0,  19.55000,
     &   5.100E-01,  1.0,  25.30000,
     &   8.000E-01,  1.0,  22.00000/

*(26) 13C 
      data nlvl(26) / 40/
      data (width(26,j),spin(26,j),exm(26,j),j=  1, 10)/
     &   5.305E-11,  2.5,   3.85381,
     &   4.148E-07,  1.5,   3.68451,
     &   4.264E-07,  0.5,   3.08944,
     &   1.200E-03,  2.5,   7.54700,
     &   4.000E-03,  0.5,  11.08000,
     &   5.000E-03,  4.5,   9.49980,
     &   5.000E-03,  3.5,   7.49200,
     &   5.490E-03,  1.5,  15.10820,
     &   6.000E-03,  2.5,   6.86400,
     &   2.400E-02,  2.5,  10.81800/
      data (width(26,j),spin(26,j),exm(26,j),j= 11, 20)/
     &   2.600E-02,  1.5,   9.89700,
     &   3.500E-02,  4.5,  13.41000,
     &   3.700E-02,  0.5,  10.99600,
     &   5.500E-02,  3.5,  10.75300,
     &   6.800E-02,  3.5,  11.84800,
     &   7.000E-02,  1.5,   7.68600,
     &   8.000E-02,  2.5,  12.13000,
     &   1.000E-01,  2.0,  18.69900,
     &   1.100E-01,  1.5,  11.74800,
     &   1.140E-01,  2.5,  21.81000/
      data (width(26,j),spin(26,j),exm(26,j),j= 21, 30)/
     &   1.400E-01,  3.5,  12.43800,
     &   1.500E-01,  1.5,  14.13000,
     &   1.500E-01,  1.5,  12.18700,
     &   1.500E-01,  0.5,   8.86000,
     &   1.500E-01,  3.5,  16.08000,
     &   1.500E-01,  1.5,  15.52600,
     &   1.700E-01,  2.0,  17.69900,
     &   2.300E-01,  4.0,  14.58200,
     &   2.300E-01,  2.5,  16.15000,
     &   2.700E-01,  4.0,  21.46600/
      data (width(26,j),spin(26,j),exm(26,j),j= 31, 40)/
     &   2.800E-01,  1.5,  14.39000,
     &   3.000E-01,  2.0,  13.76000,
     &   3.800E-01,  3.5,  14.98300,
     &   4.300E-01,  0.5,  12.14000,
     &   5.000E-01,  2.5,  19.51000,
     &   5.000E-01,  2.5,  11.95000,
     &   5.400E-01,  1.5,  12.10600,
     &   5.600E-01,  3.5,  20.20000,
     &   6.200E-01,  3.5,  13.57000,
     &   1.100E+00,  1.5,   8.20000/

*(27) 14C 
      data nlvl(27) / 19/
      data (width(27,j),spin(27,j),exm(27,j),j=  1, 10)/
     &   6.913E-12,  3.0,   6.72820,
     &   1.521E-10,  0.0,   6.58940,
     &   4.110E-09,  2.0,   7.34100,
     &   1.825E-08,  0.0,   6.90260,
     &   5.069E-08,  2.0,   7.01200,
     &   6.518E-08,  1.0,   6.09380,
     &   3.400E-03,  2.0,   8.31790,
     &   2.000E-02,  4.0,  11.66600,
     &   2.000E-02,  4.0,  10.73600,
     &   2.200E-02,  1.0,  11.39500/
      data (width(27,j),spin(27,j),exm(27,j),j= 11, 19)/
     &   2.600E-02,  3.0,  10.49800,
     &   3.000E-02,  3.0,  12.96300,
     &   4.500E-02,  3.0,   9.80100,
     &   4.600E-02,  1.0,  11.30600,
     &   5.700E-02,  4.0,  14.66700,
     &   9.500E-02,  2.0,  12.58300,
     &   2.000E-01,  1.0,  16.71500,
     &   3.000E-01,  4.0,  24.40000,
     &   9.500E-01,  1.0,  11.90000/

*(28) 15C 
      data nlvl(28) / 17/
      data (width(28,j),spin(28,j),exm(28,j),j=  1, 10)/
     &   1.748E-13,  2.5,   0.74000,
     &   1.400E-02,  7.5,   6.44900,
     &   1.400E-02,  2.5,   4.22000,
     &   1.500E-02,  1.5,   7.09500,
     &   2.000E-02,  3.5,  10.24800,
     &   2.000E-02,  8.5,   9.78900,
     &   2.000E-02,  7.5,   7.35200,
     &   2.000E-02,  3.5,   6.35800,
     &   2.000E-02,  4.5,   6.88100,
     &   2.000E-02,  1.5,   6.62600/
      data (width(28,j),spin(28,j),exm(28,j),j= 11, 17)/
     &   3.000E-02, 12.5,  11.12300,
     &   4.000E-02,  7.5,   8.55900,
     &   4.000E-02,  7.5,   8.47000,
     &   4.000E-02,  0.5,   3.10300,
     &   5.000E-02,  2.5,   6.41700,
     &   6.400E-02,  1.5,   5.83300,
     &   7.000E-02, 11.5,  11.82500/

*(29) 16C 
      data nlvl(29) /  1/
      data (width(29,j),spin(29,j),exm(29,j),j=  1,  1)/
     &   2.500E-02,  3.0,   6.10900/

*(30) 12N 
      data nlvl(30) /  8/
      data (width(30,j),spin(30,j),exm(30,j),j=  1,  8)/
     &   2.000E-02,  2.0,   0.96000,
     &   6.800E-02,  0.0,   2.43900,
     &   1.180E-01,  2.0,   1.19100,
     &   1.800E-01,  3.0,   5.34800,
     &   2.200E-01,  1.0,   3.55800,
     &   2.200E-01,  2.5,   3.13200,
     &   7.500E-01,  1.0,   1.80000,
     &   8.250E-01,  2.0,   4.14000/

*(31) 13N 
      data nlvl(31) / 34/
      data (width(31,j),spin(31,j),exm(31,j),j=  1, 10)/
     &   9.300E-04,  1.5,  15.06460,
     &   9.000E-03,  3.5,   7.15500,
     &   1.100E-02,  2.5,   6.36400,
     &   2.300E-02,  2.5,  18.96100,
     &   3.000E-02,  2.5,  10.36000,
     &   3.000E-02,  1.5,   9.47600,
     &   3.170E-02,  0.5,   2.36490,
     &   4.700E-02,  2.5,   3.54700,
     &   6.200E-02,  1.5,   3.50200,
     &   6.600E-02,  1.5,  18.40600/
      data (width(31,j),spin(31,j),exm(31,j),j= 11, 20)/
     &   7.500E-02,  2.5,   7.37600,
     &   7.600E-02,  3.5,  10.36000,
     &   1.150E-01,  1.5,   6.88600,
     &   1.150E-01,  2.5,  11.70000,
     &   1.350E-01,  3.5,  15.99000,
     &   1.650E-01,  1.5,  14.05000,
     &   2.250E-01,  0.5,  18.17000,
     &   2.300E-01,  0.5,   8.91800,
     &   2.400E-01,  1.5,  25.60000,
     &   2.400E-01,  1.5,  11.74000/
      data (width(31,j),spin(31,j),exm(31,j),j= 21, 30)/
     &   2.500E-01,  3.5,  12.13000,
     &   2.800E-01,  0.5,  10.25000,
     &   2.800E-01,  4.5,   9.00000,
     &   3.200E-01,  1.5,  18.15000,
     &   3.500E-01,  1.5,  15.30000,
     &   3.500E-01,  1.5,  23.83000,
     &   3.800E-01,  0.5,  11.86000,
     &   4.000E-01,  1.5,  23.30000,
     &   4.300E-01,  2.5,  11.53000,
     &   5.300E-01,  1.5,  11.74000/
      data (width(31,j),spin(31,j),exm(31,j),j= 31, 34)/
     &   7.500E-01,  2.5,  21.40000,
     &   7.500E-01,  3.5,  19.88000,
     &   1.500E+00,  1.5,   7.90000,
     &   6.500E+00,  1.5,  13.50000/

*(32) 14N 
      data nlvl(32) / 95/
      data (width(32,j),spin(32,j),exm(32,j),j=  1, 10)/
     &   5.497E-11,  3.0,   5.83425,
     &   1.049E-10,  2.0,   5.10589,
     &   1.061E-09,  3.0,   6.44617,
     &   4.110E-09,  1.0,   6.20350,
     &   6.250E-09,  5.0,   8.96400,
     &   6.709E-09,  0.0,   2.31280,
     &   3.456E-08,  4.0,   8.49000,
     &   4.148E-08,  1.0,   5.69144,
     &   5.069E-08,  3.0,   9.12900,
     &   8.608E-08,  0.0,   4.91510/
      data (width(32,j),spin(32,j),exm(32,j),j= 11, 20)/
     &   9.505E-08,  1.0,   3.94810,
     &   1.233E-07,  2.0,   7.02912,
     &   3.900E-07,  5.0,  10.81200,
     &   2.500E-06,  2.0,   7.96690,
     &   1.220E-04,  2.0,   9.17225,
     &   1.200E-03,  3.0,  11.05000,
     &   3.800E-03,  0.0,   8.61800,
     &   5.000E-03,  4.0,  12.81300,
     &   7.000E-03,  2.5,  11.51350,
     &   8.000E-03,  2.0,   8.98000/
      data (width(32,j),spin(32,j),exm(32,j),j= 21, 30)/
     &   1.000E-02,  3.0,  10.07900,
     &   1.100E-02,  3.0,  11.24000,
     &   1.200E-02,  1.5,  10.10100,
     &   1.300E-02,  2.0,   9.38800,
     &   1.500E-02,  1.0,  13.16700,
     &   1.500E-02,  1.0,   9.70300,
     &   1.600E-02,  3.0,   8.90700,
     &   1.600E-02,  4.0,  12.78900,
     &   1.800E-02,  3.0,  12.69000,
     &   2.200E-02,  4.0,  12.92200/
      data (width(32,j),spin(32,j),exm(32,j),j= 31, 40)/
     &   2.300E-02,  1.0,   8.06200,
     &   3.000E-02,  1.0,  11.35700,
     &   3.300E-02,  2.0,  10.43200,
     &   3.400E-02,  4.0,  12.40800,
     &   3.900E-02,  1.0,  12.49500,
     &   4.000E-02,  1.5,  11.74100,
     &   4.100E-02,  3.5,  12.41800,
     &   4.100E-02,  2.0,   9.50900,
     &   4.800E-02,  3.0,  12.59400,
     &   6.000E-02,  3.5,  15.02000/
      data (width(32,j),spin(32,j),exm(32,j),j= 41, 50)/
     &   6.200E-02,  5.0,  18.50000,
     &   6.500E-02,  3.0,  13.19200,
     &   6.500E-02,  4.0,  22.26000,
     &   7.800E-02,  3.5,  11.76100,
     &   8.000E-02,  1.0,  10.22600,
     &   9.000E-02,  2.5,  13.65600,
     &   9.200E-02,  2.0,  13.24300,
     &   1.000E-01,  1.0,  11.07000,
     &   1.000E-01,  5.0,  14.66000,
     &   1.010E-01,  2.0,  11.87400/
      data (width(32,j),spin(32,j),exm(32,j),j= 51, 60)/
     &   1.050E-01,  2.5,  13.71400,
     &   1.190E-01,  2.0,  11.80700,
     &   1.200E-01,  1.0,  13.77000,
     &   1.250E-01,  2.0,  14.73000,
     &   1.400E-01,  1.0,  10.53400,
     &   1.500E-01,  1.5,  11.67600,
     &   1.700E-01,  5.0,  16.91000,
     &   1.800E-01,  1.0,  13.74000,
     &   1.800E-01,  2.0,  11.27000,
     &   2.350E-01,  3.0,  21.51000/
      data (width(32,j),spin(32,j),exm(32,j),j= 61, 70)/
     &   2.400E-01,  4.0,  16.65000,
     &   2.450E-01,  4.0,  17.40000,
     &   2.450E-01,  3.0,  17.03000,
     &   2.750E-01,  4.0,  17.31000,
     &   2.900E-01,  4.0,  16.91000,
     &   3.000E-01,  1.5,  12.20000,
     &   3.000E-01,  1.0,  17.17000,
     &   3.100E-01,  3.0,  18.53000,
     &   3.150E-01,  1.0,  18.78000,
     &   3.150E-01,  4.0,  18.43000/
      data (width(32,j),spin(32,j),exm(32,j),j= 71, 80)/
     &   3.400E-01,  2.0,  17.93000,
     &   3.600E-01,  4.0,  21.68000,
     &   3.600E-01,  5.0,  21.53000,
     &   4.100E-01,  0.0,   8.77600,
     &   4.100E-01,  2.0,  18.53000,
     &   4.150E-01,  4.0,  21.24000,
     &   4.200E-01,  3.0,  14.25000,
     &   4.400E-01,  3.0,  17.85000,
     &   4.500E-01,  2.5,  18.93000,
     &   4.750E-01,  4.0,  18.88000/
      data (width(32,j),spin(32,j),exm(32,j),j= 81, 90)/
     &   4.750E-01,  4.0,  17.85000,
     &   4.800E-01,  4.0,  18.14000,
     &   5.100E-01,  1.0,  19.99000,
     &   5.600E-01,  1.0,  18.35000,
     &   5.700E-01,  5.0,  22.31000,
     &   5.700E-01,  3.0,  18.02000,
     &   5.750E-01,  2.0,  19.90000,
     &   6.100E-01,  5.0,  20.65000,
     &   6.400E-01,  5.0,  23.40000,
     &   6.500E-01,  4.0,  21.80000/
      data (width(32,j),spin(32,j),exm(32,j),j= 91, 95)/
     &   6.750E-01,  3.0,  18.64000,
     &   8.300E-01,  2.0,  16.92000,
     &   8.700E-01,  3.0,  19.10000,
     &   1.100E+00,  4.0,  20.60000,
     &   3.000E+00,  2.0,  23.00000/

*(33) 15N 
      data nlvl(33) / 61/
      data (width(33,j),spin(33,j),exm(33,j),j=  1, 10)/
     &   2.549E-10,  2.5,   5.27015,
     &   5.069E-09,  0.5,   9.22210,
     &   2.684E-08,  0.5,   5.29882,
     &   3.802E-08,  3.5,   9.82900,
     &   3.802E-08,  2.5,   7.15505,
     &   3.802E-08,  4.5,  10.69320,
     &   5.703E-08,  3.5,   7.56710,
     &   9.125E-08,  2.5,   9.15490,
     &   2.535E-07,  2.5,   9.76000,
     &   3.802E-07,  0.5,   8.31262/
      data (width(33,j),spin(33,j),exm(33,j),j= 11, 20)/
     &   4.703E-07,  1.5,   9.15190,
     &   9.125E-07,  1.5,   8.57140,
     &   1.000E-06,  1.5,  10.80400,
     &   1.086E-06,  1.5,   7.30083,
     &   1.304E-06,  0.5,   9.04971,
     &   2.173E-06,  1.5,   9.92500,
     &   3.125E-06,  1.5,   6.32378,
     &   6.612E-06,  1.5,  10.06600,
     &   2.000E-04,  1.5,  10.70190,
     &   5.000E-04,  2.5,  10.44970/
      data (width(33,j),spin(33,j),exm(33,j),j= 21, 30)/
     &   3.000E-03,  4.5,  11.94200,
     &   3.300E-03,  1.5,  11.23500,
     &   7.000E-03,  4.5,  13.17400,
     &   8.000E-03,  0.5,  11.29280,
     &   1.400E-02,  2.5,  12.09500,
     &   1.600E-02,  1.5,  13.36200,
     &   1.700E-02,  0.5,  11.96500,
     &   1.800E-02,  2.5,  13.60800,
     &   2.200E-02,  2.5,  12.32700,
     &   2.200E-02,  4.0,  14.09000/
      data (width(33,j),spin(33,j),exm(33,j),j= 31, 40)/
     &   2.500E-02,  1.5,  11.87600,
     &   2.700E-02,  1.5,  14.16200,
     &   4.000E-02,  1.5,  11.76300,
     &   4.000E-02,  2.5,  12.49300,
     &   4.100E-02,  1.5,  12.14500,
     &   4.140E-02,  0.5,  11.43760,
     &   5.600E-02,  1.5,  13.39000,
     &   5.600E-02,  1.5,  12.92000,
     &   5.800E-02,  2.5,  12.52200,
     &   7.500E-02,  1.5,  13.84000/
      data (width(33,j),spin(33,j),exm(33,j),j= 41, 50)/
     &   8.000E-02,  0.5,  16.67700,
     &   8.100E-02,  2.5,  12.94000,
     &   8.500E-02,  1.5,  13.53700,
     &   9.800E-02,  2.5,  13.99000,
     &   1.000E-01,  3.5,  14.38000,
     &   1.000E-01,  1.5,  14.10000,
     &   1.100E-01,  2.5,  16.85000,
     &   1.100E-01,  2.5,  14.72000,
     &   1.300E-01,  0.5,  19.20000,
     &   1.500E-01,  1.5,  16.26000/
      data (width(33,j),spin(33,j),exm(33,j),j= 51, 60)/
     &   1.500E-01,  2.5,  14.24000,
     &   2.500E-01,  1.0,  17.15000,
     &   4.000E-01,  1.5,  20.50000,
     &   4.000E-01,  1.5,  19.50000,
     &   4.050E-01,  0.5,  11.61500,
     &   4.500E-01,  1.5,  17.58000,
     &   4.500E-01,  1.5,  16.19000,
     &   4.900E-01,  1.5,  16.59000,
     &   6.000E-01,  1.5,  17.67000,
     &   7.500E-01,  1.0,  18.90000/
      data (width(33,j),spin(33,j),exm(33,j),j= 61, 61)/
     &   9.300E-01,  0.5,  13.90000/

*(34) 16N 
      data nlvl(34) / 41/
      data (width(34,j),spin(34,j),exm(34,j),j=  1, 10)/
     &   8.690E-17,  0.0,   0.12042,
     &   4.997E-12,  3.0,   0.29822,
     &   1.170E-10,  1.0,   0.39727,
     &   2.000E-03,  3.0,   3.96300,
     &   3.000E-03,  2.0,   3.52300,
     &   4.000E-03,  3.0,   5.23000,
     &   1.100E-02,  4.0,   7.63700,
     &   1.100E-02,  3.0,   7.57200,
     &   1.100E-02,  3.0,   5.15000,
     &   1.100E-02,  2.0,   5.12900/
      data (width(34,j),spin(34,j),exm(34,j),j= 11, 20)/
     &   1.100E-02,  4.0,   6.60800,
     &   1.100E-02,  4.0,   6.17070,
     &   1.100E-02,  5.0,   5.73170,
     &   1.100E-02,  3.0,   5.52160,
     &   1.200E-02,  2.0,  11.70100,
     &   1.200E-02,  0.0,   9.92800,
     &   1.500E-02,  1.0,   3.35300,
     &   1.700E-02,  2.0,   7.25000,
     &   1.800E-02,  1.0,   8.36500,
     &   1.900E-02,  2.0,   5.05400/
      data (width(34,j),spin(34,j),exm(34,j),j= 21, 30)/
     &   2.000E-02,  1.0,   4.32000,
     &   2.200E-02,  1.0,   7.02000,
     &   2.800E-02,  3.5,   8.19900,
     &   3.000E-02,  3.0,   6.37400,
     &   3.000E-02,  3.0,  10.05500,
     &   3.400E-02,  1.0,   6.50500,
     &   4.000E-02,  1.0,   8.72000,
     &   5.000E-02,  1.0,   8.49000,
     &   5.900E-02,  2.0,   4.78300,
     &   8.200E-02,  1.0,   4.39100/
      data (width(34,j),spin(34,j),exm(34,j),j= 31, 40)/
     &   1.000E-01,  4.0,   7.87700,
     &   1.000E-01,  2.0,   9.45900,
     &   1.000E-01,  2.0,   9.16000,
     &   1.200E-01,  2.0,  10.71000,
     &   1.650E-01,  2.0,  10.37000,
     &   1.800E-01,  3.0,  14.36000,
     &   2.200E-01,  3.0,  11.61000,
     &   2.500E-01,  1.0,   4.76000,
     &   2.600E-01,  0.5,   5.31800,
     &   2.700E-01,  1.0,   6.00300/
      data (width(34,j),spin(34,j),exm(34,j),j= 41, 41)/
     &   3.200E-01,  2.0,   5.25000/

*(35) 17N 
      data nlvl(35) / 16/
      data (width(35,j),spin(35,j),exm(35,j),j=  1, 10)/
     &   2.389E-12,  3.5,   3.12890,
     &   1.629E-11,  0.5,   1.84960,
     &   1.992E-11,  2.5,   2.52600,
     &   5.497E-11,  4.0,   3.62870,
     &   6.003E-11,  2.5,   1.90680,
     &   1.878E-09,  0.5,   3.66300,
     &   5.497E-09,  1.0,   5.77200,
     &   6.518E-09,  1.5,   5.51500,
     &   6.913E-09,  1.5,   5.19500,
     &   7.129E-09,  1.5,   1.37390/
      data (width(35,j),spin(35,j),exm(35,j),j= 11, 16)/
     &   9.311E-09,  2.5,   4.20900,
     &   1.086E-08,  4.5,   5.17000,
     &   1.086E-08,  2.0,   4.41500,
     &   1.267E-08,  2.0,   3.90600,
     &   2.173E-08,  1.5,   3.20420,
     &   4.148E-08,  1.5,   4.00640/

*(36) 14O 
      data nlvl(36) /  6/
      data (width(36,j),spin(36,j),exm(36,j),j=  1,  6)/
     &   3.810E-02,  1.0,   5.17300,
     &   5.000E-02,  0.0,   5.92000,
     &   6.000E-02,  2.0,   6.59000,
     &   7.600E-02,  2.0,   7.76800,
     &   1.000E-01,  4.0,   9.91500,
     &   1.030E-01,  3.0,   6.27200/

*(37) 15O 
      data nlvl(37) / 45/
      data (width(37,j),spin(37,j),exm(37,j),j=  1, 10)/
     &   2.028E-10,  2.5,   5.24090,
     &   9.311E-10,  3.5,   7.27590,
     &   2.281E-08,  1.5,   6.79310,
     &   4.110E-08,  2.5,   6.85940,
     &   8.004E-08,  0.5,   5.18300,
     &   2.622E-07,  1.5,   6.17630,
     &   9.900E-04,  0.5,   7.55650,
     &   2.000E-03,  4.5,  10.46100,
     &   2.000E-03,  4.0,   9.66200,
     &   3.000E-03,  2.5,  10.29000/
      data (width(37,j),spin(37,j),exm(37,j),j= 11, 20)/
     &   3.300E-03,  2.5,   8.92200,
     &   3.600E-03,  1.5,   8.28400,
     &   3.900E-03,  0.5,   8.98210,
     &   7.500E-03,  0.5,   8.92200,
     &   8.800E-03,  1.5,   9.60900,
     &   1.010E-02,  2.5,   9.48800,
     &   1.100E-02,  2.5,  10.30000,
     &   2.000E-02,  2.5,  11.98000,
     &   2.000E-02,  2.5,  11.56900,
     &   2.500E-02,  0.5,  11.02500/
      data (width(37,j),spin(37,j),exm(37,j),j= 21, 30)/
     &   2.500E-02,  1.5,  10.48000,
     &   3.200E-02,  0.5,   8.74300,
     &   4.000E-02,  1.5,  11.21800,
     &   6.500E-02,  2.5,  11.84600,
     &   7.700E-02,  2.5,  12.47100,
     &   8.000E-02,  1.0,  11.61600,
     &   9.000E-02,  3.5,  10.91700,
     &   9.900E-02,  2.5,  11.74800,
     &   9.900E-02,  0.5,  10.93800,
     &   1.000E-01,  2.0,  14.46500/
      data (width(37,j),spin(37,j),exm(37,j),j= 31, 40)/
     &   1.350E-01,  2.5,  12.25500,
     &   1.600E-01,  4.0,  14.03000,
     &   2.000E-01,  2.5,  12.12900,
     &   2.000E-01,  1.5,   9.48400,
     &   2.000E-01,  1.0,  17.99000,
     &   2.400E-01,  2.5,  14.34000,
     &   3.400E-01,  0.5,  14.27000,
     &   3.500E-01,  1.0,  15.90000,
     &   5.200E-01,  1.0,  18.67000,
     &   5.600E-01,  0.5,  16.43000/
      data (width(37,j),spin(37,j),exm(37,j),j= 41, 45)/
     &   6.400E-01,  1.0,  17.51000,
     &   7.000E-01,  1.0,  17.05000,
     &   7.300E-01,  1.0,  21.56000,
     &   7.800E-01,  1.0,  19.57000,
     &   9.700E-01,  1.0,  20.42000/

*(38) 16O 
      data nlvl(38) /115/
      data (width(38,j),spin(38,j),exm(38,j),j=  1, 10)/
     &   6.810E-12,  0.0,   6.04940,
     &   2.480E-11,  3.0,   6.12989,
     &   3.650E-09,  2.0,   8.87190,
     &   5.497E-08,  1.0,   7.11685,
     &   8.295E-08,  0.0,  10.95700,
     &   9.707E-08,  2.0,   6.91710,
     &   1.110E-04,  2.0,  12.53000,
     &   2.800E-04,  4.0,  11.09670,
     &   6.200E-04,  2.0,   9.84450,
     &   1.340E-03,  2.0,  12.96860/
      data (width(38,j),spin(38,j),exm(38,j),j= 11, 20)/
     &   1.500E-03,  0.0,  12.04900,
     &   8.000E-03,  4.0,  18.97700,
     &   1.100E-02,  5.0,  20.54100,
     &   1.200E-02,  3.0,  11.08000,
     &   1.250E-02,  0.0,  22.72100,
     &   1.400E-02,  4.0,  18.01600,
     &   1.900E-02,  1.0,  16.20900,
     &   2.000E-02,  2.0,  13.98000,
     &   2.100E-02,  3.0,  13.25900,
     &   2.200E-02,  5.0,  18.64000/
      data (width(38,j),spin(38,j),exm(38,j),j= 21, 30)/
     &   2.300E-02,  4.0,  19.37500,
     &   2.400E-02,  2.0,  17.87700,
     &   2.500E-02,  2.0,  16.44230,
     &   2.600E-02,  3.0,  18.02900,
     &   2.600E-02,  6.0,  23.87900,
     &   2.600E-02,  4.0,  10.35600,
     &   2.700E-02,  5.0,  14.39900,
     &   2.800E-02,  3.0,  16.81700,
     &   3.200E-02,  4.0,  19.80800,
     &   3.400E-02,  4.0,  14.30200/
      data (width(38,j),spin(38,j),exm(38,j),j= 31, 40)/
     &   3.400E-02,  1.0,  17.14000,
     &   3.500E-02,  1.5,  18.48400,
     &   4.000E-02,  3.0,  15.78500,
     &   4.000E-02,  0.0,  12.79600,
     &   4.200E-02,  3.0,  19.89500,
     &   4.300E-02,  3.0,  21.77600,
     &   4.500E-02,  4.0,  17.77500,
     &   5.000E-02,  2.0,  24.52200,
     &   5.000E-02,  4.0,  20.51000,
     &   5.000E-02,  5.0,  19.25300/
      data (width(38,j),spin(38,j),exm(38,j),j= 41, 50)/
     &   5.400E-02,  2.0,  14.92600,
     &   6.000E-02,  0.0,  22.04000,
     &   6.000E-02,  7.0,  21.62300,
     &   6.100E-02,  2.0,  16.35200,
     &   6.300E-02,  2.0,  15.19600,
     &   6.400E-02,  1.0,  13.66400,
     &   6.500E-02,  6.0,  19.31900,
     &   6.800E-02,  3.0,  19.20600,
     &   7.000E-02,  6.0,  14.81530,
     &   7.100E-02,  2.0,  11.52000/
      data (width(38,j),spin(38,j),exm(38,j),j= 51, 60)/
     &   7.500E-02,  1.0,  17.72000,
     &   7.800E-02,  1.0,  17.28200,
     &   8.900E-02,  4.0,  13.86900,
     &   9.000E-02,  2.0,  18.43000,
     &   9.100E-02,  1.0,  12.44000,
     &   1.070E-01,  2.0,  17.12900,
     &   1.100E-01,  3.0,  13.12900,
     &   1.140E-01,  2.0,  17.60900,
     &   1.150E-01,  6.0,  21.64800,
     &   1.200E-01,  2.5,  21.50000/
      data (width(38,j),spin(38,j),exm(38,j),j= 61, 70)/
     &   1.200E-01,  2.0,  19.08000,
     &   1.200E-01,  1.0,  18.79000,
     &   1.300E-01,  1.0,  13.09000,
     &   1.320E-01,  3.0,  15.40800,
     &   1.500E-01,  2.0,  13.02000,
     &   1.500E-01,  3.5,  18.60000,
     &   1.550E-01,  2.0,  19.25700,
     &   1.600E-01,  2.0,  17.19700,
     &   1.660E-01,  0.0,  15.09700,
     &   1.750E-01,  2.0,  22.35000/
      data (width(38,j),spin(38,j),exm(38,j),j= 71, 80)/
     &   1.800E-01,  6.0,  17.55500,
     &   1.800E-01,  1.0,  17.51000,
     &   1.850E-01,  0.0,  14.03200,
     &   1.900E-01,  3.0,  20.41200,
     &   2.000E-01,  1.0,  19.47000,
     &   2.050E-01,  6.0,  21.05200,
     &   2.150E-01,  1.0,  18.77300,
     &   2.200E-01,  2.0,  18.20200,
     &   2.550E-01,  2.0,  19.53900,
     &   2.600E-01,  4.0,  18.78500/
      data (width(38,j),spin(38,j),exm(38,j),j= 81, 90)/
     &   2.800E-01,  2.0,  16.93000,
     &   2.880E-01,  0.0,  18.08900,
     &   2.900E-01,  2.0,  19.75400,
     &   2.980E-01,  2.0,  21.05000,
     &   3.000E-01,  5.0,  23.51000,
     &   3.000E-01,  1.0,  22.89000,
     &   3.000E-01,  1.0,  20.94500,
     &   3.000E-01,  2.0,  15.26000,
     &   3.000E-01,  4.0,  18.60000,
     &   3.400E-01,  3.0,  24.76000/
      data (width(38,j),spin(38,j),exm(38,j),j= 91,100)/
     &   3.800E-01,  1.0,  17.09000,
     &   4.000E-01,  4.0,  17.78400,
     &   4.000E-01,  3.0,  22.50000,
     &   4.000E-01,  2.0,  20.05500,
     &   4.200E-01,  1.0,   9.58500,
     &   4.200E-01,  6.0,  16.27500,
     &   4.200E-01,  2.0,  19.00100,
     &   4.240E-01,  2.5,  24.36000,
     &   4.500E-01,  3.0,  25.60000,
     &   4.900E-01,  4.0,  14.62000/
      data (width(38,j),spin(38,j),exm(38,j),j=101,110)/
     &   5.000E-01,  6.0,  23.00000,
     &   5.500E-01,  5.0,  18.40400,
     &   5.500E-01,  3.0,  26.36300,
     &   5.500E-01,  1.0,  24.07000,
     &   5.600E-01,  1.0,  23.23500,
     &   5.700E-01,  4.0,  16.84400,
     &   5.800E-01,  1.0,  16.20000,
     &   6.700E-01,  5.0,  14.66000,
     &   6.800E-01,  1.0,  22.15000,
     &   7.000E-01,  3.0,  15.82800/
      data (width(38,j),spin(38,j),exm(38,j),j=111,115)/
     &   7.500E-01,  8.5,  29.80000,
     &   7.500E-01,  1.0,  26.00000,
     &   8.000E-01,  3.0,  11.60000,
     &   8.300E-01,  3.0,  27.40000,
     &   9.000E-01,  7.0,  20.85700/

*(39) 17O 
      data nlvl(39) / 81/
      data (width(39,j),spin(39,j),exm(39,j),j=  1, 10)/
     &   2.546E-12,  0.5,   0.87073,
     &   5.703E-09,  0.5,   3.05536,
     &   2.535E-08,  2.5,   3.84280,
     &   1.000E-04,  4.5,   5.21580,
     &   1.000E-04,  3.5,   7.57600,
     &   6.400E-04,  2.5,   7.37920,
     &   9.600E-04,  2.5,   7.38220,
     &   1.000E-03,  3.5,   6.97200,
     &   1.000E-03,  2.5,   6.86200,
     &   1.000E-03,  2.5,   5.73280/
      data (width(39,j),spin(39,j),exm(39,j),j= 11, 20)/
     &   1.380E-03,  2.5,   7.16570,
     &   2.130E-03,  3.5,   8.46600,
     &   2.400E-03,  0.5,  11.07870,
     &   2.500E-03,  2.5,  12.99820,
     &   3.000E-03,  3.5,   9.18000,
     &   3.400E-03,  3.5,   5.69730,
     &   3.530E-03,  2.5,   9.19390,
     &   4.000E-03,  0.5,   9.14700,
     &   4.010E-03,  2.5,   9.85890,
     &   6.000E-03,  4.0,   8.88500/
      data (width(39,j),spin(39,j),exm(39,j),j= 21, 30)/
     &   6.000E-03,  0.5,  12.94400,
     &   6.170E-03,  2.5,   8.40230,
     &   6.600E-03,  1.5,   5.86910,
     &   6.890E-03,  2.5,   8.50070,
     &   6.900E-03,  1.5,  12.46600,
     &   9.000E-03,  2.5,  13.63530,
     &   1.140E-02,  0.5,   8.34240,
     &   1.170E-02,  1.5,   9.78330,
     &   1.440E-02,  3.5,   7.68820,
     &   1.500E-02,  2.5,   9.49200/
      data (width(39,j),spin(39,j),exm(39,j),j= 31, 40)/
     &   1.670E-02,  0.5,   9.87650,
     &   2.000E-02,  4.5,  20.70000,
     &   2.000E-02, 10.5,  17.06000,
     &   2.050E-02,  3.5,  14.23030,
     &   2.100E-02,  4.5,  16.24300,
     &   2.310E-02,  3.5,   9.71190,
     &   2.600E-02,  3.5,   8.96720,
     &   2.800E-02,  1.5,   5.37920,
     &   3.000E-02, 11.5,  15.78000,
     &   3.100E-02, 10.5,  20.14000/
      data (width(39,j),spin(39,j),exm(39,j),j= 41, 50)/
     &   3.200E-02,  0.5,   5.93900,
     &   3.500E-02,  4.5,  14.72000,
     &   3.600E-02,  0.5,  14.79100,
     &   4.000E-02,  1.5,   4.55380,
     &   4.000E-02,  2.5,  15.36800,
     &   4.170E-02,  2.5,  10.91300,
     &   4.250E-02,  3.5,  10.55910,
     &   4.600E-02,  1.5,  18.11000,
     &   4.910E-02,  3.5,  10.16780,
     &   5.530E-02,  1.5,   8.68700/
      data (width(39,j),spin(39,j),exm(39,j),j= 51, 60)/
     &   6.000E-02,  1.5,   8.20000,
     &   6.800E-02,  1.0,  13.58000,
     &   7.400E-02,  2.0,  10.77700,
     &   7.500E-02,  3.0,  10.49000,
     &   8.000E-02,  2.5,   9.97600,
     &   8.500E-02,  1.5,   8.07000,
     &   9.000E-02,  0.5,   7.95600,
     &   9.600E-02,  1.5,   5.08480,
     &   1.000E-01,  7.5,  14.20000,
     &   1.010E-01,  1.5,   8.89700/
      data (width(39,j),spin(39,j),exm(39,j),j= 61, 70)/
     &   1.200E-01,  1.5,   9.42000,
     &   1.240E-01,  0.5,   6.35600,
     &   1.500E-01,  3.0,  10.33600,
     &   1.900E-01,  1.5,  11.51000,
     &   2.500E-01, 12.0,  20.20000,
     &   2.500E-01, 12.0,  19.60000,
     &   2.700E-01,  1.5,  12.00500,
     &   2.700E-01,  0.5,   7.99000,
     &   2.800E-01,  1.5,   7.20200,
     &   3.000E-01,  1.0,  16.58000/
      data (width(39,j),spin(39,j),exm(39,j),j= 71, 80)/
     &   3.400E-01,  1.5,  14.80000,
     &   4.000E-01,  0.5,  23.00000,
     &   4.700E-01,  1.5,  21.05000,
     &   5.000E-01,  7.5,  15.10000,
     &   5.000E-01,  1.5,   7.55900,
     &   5.500E-01,  1.5,  19.82000,
     &   5.700E-01,  0.5,  20.58000,
     &   6.600E-01,  3.0,  20.39000,
     &   7.000E-01,  7.5,  16.00000,
     &   7.500E-01,  3.5,  22.10000/
      data (width(39,j),spin(39,j),exm(39,j),j= 81, 81)/
     &   7.500E-01,  2.5,  21.70000/

*(40) 18O 
      data nlvl(40) / 58/
      data (width(40,j),spin(40,j),exm(40,j),j=  1, 10)/
     &   2.653E-11,  4.0,   3.55484,
     &   2.352E-10,  2.0,   1.98207,
     &   4.752E-10,  0.0,   3.63376,
     &   3.282E-09,  0.0,   5.33640,
     &   1.014E-08,  1.0,   4.45554,
     &   1.061E-08,  3.0,   5.09778,
     &   1.901E-08,  2.0,   6.35130,
     &   2.173E-08,  3.0,   6.40440,
     &   2.173E-08,  3.0,   5.37780,
     &   2.480E-08,  2.0,   3.92044/
      data (width(40,j),spin(40,j),exm(40,j),j= 11, 20)/
     &   2.684E-08,  4.0,   7.11690,
     &   2.684E-08,  0.0,   6.88045,
     &   2.684E-08,  2.0,   5.53024,
     &   6.518E-08,  2.0,   5.25480,
     &   1.755E-07,  1.0,   6.19822,
     &   1.000E-03,  2.0,   8.21300,
     &   2.500E-03,  1.0,   8.03780,
     &   2.500E-03,  1.0,   7.61590,
     &   8.000E-03,  2.0,   8.41000,
     &   8.000E-03,  3.0,   8.28200/
      data (width(40,j),spin(40,j),exm(40,j),j= 21, 30)/
     &   1.600E-02,  3.0,  10.11800,
     &   2.000E-02,  4.0,  20.36000,
     &   2.000E-02,  3.0,  19.24000,
     &   2.000E-02,  4.0,  18.70000,
     &   2.000E-02,  3.0,  17.02500,
     &   2.000E-02,  2.0,  16.39900,
     &   2.700E-02,  3.0,   9.36100,
     &   5.000E-02,  2.0,  11.52000,
     &   5.000E-02,  2.0,  10.99000,
     &   5.000E-02,  4.0,  21.42000/
      data (width(40,j),spin(40,j),exm(40,j),j= 31, 40)/
     &   5.000E-02,  2.0,  10.67000,
     &   5.000E-02,  2.0,  10.43000,
     &   5.000E-02,  4.0,  10.29500,
     &   5.000E-02,  3.0,  16.88000,
     &   5.000E-02,  2.0,  12.66000,
     &   5.000E-02,  2.0,   7.77107,
     &   5.000E-02,  1.5,  12.09000,
     &   5.000E-02,  2.0,  11.90000,
     &   6.000E-02,  3.0,   9.67200,
     &   6.800E-02,  4.0,  12.99000/
      data (width(40,j),spin(40,j),exm(40,j),j= 41, 50)/
     &   7.000E-02,  1.0,   8.81700,
     &   7.500E-02,  3.0,  18.45000,
     &   9.100E-02,  4.0,  22.40000,
     &   1.080E-01,  2.0,  13.40000,
     &   1.120E-01,  3.0,  11.67000,
     &   1.400E-01,  6.0,  14.17000,
     &   1.430E-01,  3.0,  12.41000,
     &   1.500E-01,  1.0,  21.00000,
     &   2.000E-01,  6.0,  13.85000,
     &   3.500E-01,  7.0,  18.95000/
      data (width(40,j),spin(40,j),exm(40,j),j= 51, 58)/
     &   3.500E-01,  7.0,  17.05000,
     &   6.000E-01,  4.0,  17.46000,
     &   6.000E-01,  1.0,  17.39800,
     &   6.000E-01,  1.0,  13.80000,
     &   7.000E-01,  1.0,  15.80000,
     &   7.000E-01,  1.0,  13.10000,
     &   8.000E-01,  1.0,  14.70000,
     &   9.000E-01,  1.0,  19.40000/

*(41) 19O 
      data nlvl(41) / 18/
      data (width(41,j),spin(41,j),exm(41,j),j=  1, 10)/
     &   3.282E-13,  1.5,   0.09600,
     &   1.901E-10,  4.5,   2.37150,
     &   5.185E-10,  0.5,   1.47170,
     &   6.518E-10,  2.5,   3.15350,
     &   6.518E-10,  1.5,   3.06740,
     &   7.129E-09,  3.5,   2.77900,
     &   3.400E-03,  2.5,   5.14840,
     &   7.800E-03,  3.0,   5.70460,
     &   1.500E-02,  1.5,   4.10930,
     &   1.500E-02,  2.0,   5.00700/
      data (width(41,j),spin(41,j),exm(41,j),j= 11, 18)/
     &   1.500E-02,  2.5,   4.70260,
     &   1.500E-02,  2.5,   4.40250,
     &   1.500E-02,  2.0,   4.32810,
     &   1.920E-02,  3.5,   6.26930,
     &   4.900E-02,  0.5,   5.08200,
     &   5.200E-02,  1.5,   4.58200,
     &   1.100E-01,  1.5,   6.11960,
     &   4.900E-01,  1.5,   5.54000/

*(42) 20O 
      data nlvl(42) /  1/
      data (width(42,j),spin(42,j),exm(42,j),j=  1,  1)/
     &   6.250E-11,  2.0,   1.67368/

*(43) 17F 
      data nlvl(43) / 50/
      data (width(43,j),spin(43,j),exm(43,j),j=  1, 10)/
     &   1.595E-12,  0.5,   0.49533,
     &   1.800E-04,  0.5,  11.19290,
     &   6.000E-04,  2.5,   5.68200,
     &   1.500E-03,  2.5,   3.85700,
     &   1.800E-03,  2.5,   6.69700,
     &   2.000E-03,  0.5,  13.08000,
     &   2.000E-03,  2.5,  13.06100,
     &   2.830E-03,  1.5,  12.55010,
     &   3.800E-03,  2.5,   7.02700,
     &   4.500E-03,  1.5,   6.77400/
      data (width(43,j),spin(43,j),exm(43,j),j= 11, 20)/
     &   1.000E-02,  1.5,   7.35600,
     &   1.100E-02,  2.5,   8.38300,
     &   1.200E-02,  2.5,  13.78100,
     &   1.900E-02,  0.5,   3.10400,
     &   1.930E-02,  3.5,  14.30400,
     &   3.000E-02,  1.5,  14.17600,
     &   3.000E-02,  0.5,   6.03700,
     &   3.000E-02,  3.5,   7.54600,
     &   4.000E-02,  3.5,   5.67200,
     &   4.500E-02,  3.5,   8.41600/
      data (width(43,j),spin(43,j),exm(43,j),j= 21, 30)/
     &   6.800E-02,  1.5,   5.48800,
     &   9.000E-02,  4.5,   9.92000,
     &   9.000E-02,  1.5,   8.76000,
     &   1.000E-01,  2.5,   8.07000,
     &   1.400E-01,  1.5,   9.17000,
     &   1.600E-01,  2.5,  10.40000,
     &   1.650E-01,  3.5,  10.49900,
     &   1.650E-01,  3.5,   8.98000,
     &   1.700E-01,  2.5,   8.75000,
     &   1.790E-01,  0.5,   7.75000/
      data (width(43,j),spin(43,j),exm(43,j),j= 31, 40)/
     &   1.800E-01,  1.5,   5.82000,
     &   1.900E-01,  0.5,  14.80900,
     &   1.900E-01,  0.5,  12.35500,
     &   2.000E-01,  0.5,   6.56000,
     &   2.250E-01,  1.5,   4.64000,
     &   2.600E-01,  3.5,  14.00000,
     &   2.800E-01,  3.5,  10.04000,
     &   3.000E-01,  1.5,  12.25000,
     &   4.000E-01,  4.5,  21.80000,
     &   4.700E-01,  0.5,  14.70000/
      data (width(43,j),spin(43,j),exm(43,j),j= 41, 50)/
     &   5.200E-01,  2.5,  13.10000,
     &   5.600E-01,  0.5,  10.90000,
     &   6.000E-01,  3.5,  23.80000,
     &   6.000E-01,  3.5,  22.70000,
     &   6.000E-01,  4.5,  20.90000,
     &   6.000E-01,  3.5,  12.50000,
     &   6.100E-01,  2.5,  14.38000,
     &   7.000E-01,  1.5,   8.20000,
     &   7.950E-01,  1.5,   7.47900,
     &   1.530E+00,  1.5,   5.00000/

*(44) 18F 
      data nlvl(44) /192/
      data (width(44,j),spin(44,j),exm(44,j),j=  1, 10)/
     &   2.816E-15,  5.0,   1.12136,
     &   9.728E-12,  3.0,   0.93720,
     &   1.267E-10,  5.0,   4.84830,
     &   1.304E-10,  2.0,   2.10061,
     &   3.456E-10,  3.0,   3.79149,
     &   6.892E-10,  1.0,   1.70081,
     &   1.118E-09,  2.0,   2.52335,
     &   1.521E-09,  3.0,   3.35820,
     &   1.690E-09,  1.0,   3.13387,
     &   6.003E-09,  2.0,   4.22580/
      data (width(44,j),spin(44,j),exm(44,j),j= 11, 20)/
     &   7.242E-09,  3.0,   4.11590,
     &   9.918E-09,  1.0,   4.86000,
     &   1.037E-08,  3.0,   5.50200,
     &   1.141E-08,  4.0,   4.39810,
     &   2.173E-08,  4.0,   5.29760,
     &   2.389E-08,  0.0,   1.08054,
     &   2.401E-08,  1.0,   4.36015,
     &   3.456E-08,  2.0,   3.83917,
     &   4.562E-08,  2.0,   5.78600,
     &   6.518E-08,  4.0,   4.65200/
      data (width(44,j),spin(44,j),exm(44,j),j= 21, 30)/
     &   1.521E-07,  2.0,   4.96360,
     &   2.401E-07,  1.0,   3.72419,
     &   2.578E-07,  0.0,   1.04155,
     &   5.497E-07,  2.0,   3.06184,
     &   2.200E-06,  1.5,   7.66060,
     &   2.600E-06, 10.5,   9.87400,
     &   6.900E-06, 10.5,   7.16620,
     &   3.400E-05,  1.0,   6.10800,
     &   4.330E-05,  1.0,   5.60338,
     &   4.700E-05,  2.5,   8.31000/
      data (width(44,j),spin(44,j),exm(44,j),j= 31, 40)/
     &   1.600E-04,  2.5,   7.53960,
     &   1.800E-04,  3.0,   6.24200,
     &   1.900E-04,  3.0,   6.24040,
     &   2.400E-04,  4.0,   6.09640,
     &   3.000E-04,  2.5,   9.82000,
     &   3.000E-04,  0.5,   8.13770,
     &   4.000E-04,  3.0,   6.48490,
     &   4.900E-04,  2.0,   6.38550,
     &   5.000E-04,  2.5,   8.58350,
     &   5.600E-04,  5.0,   6.56700/
      data (width(44,j),spin(44,j),exm(44,j),j= 41, 50)/
     &   5.700E-04,  3.5,   9.09970,
     &   6.000E-04,  2.0,   6.64370,
     &   6.000E-04,  1.0,   6.26200,
     &   8.000E-04,  1.0,   5.67257,
     &   8.000E-04,  2.5,   8.19900,
     &   9.500E-04,  3.0,   6.31050,
     &   1.000E-03,  4.5,   9.92600,
     &   1.000E-03,  0.0,   6.13647,
     &   1.000E-03, 11.0,   9.83400,
     &   1.000E-03,  7.5,   9.71000/
      data (width(44,j),spin(44,j),exm(44,j),j= 51, 60)/
     &   1.000E-03,  3.0,   9.50900,
     &   1.000E-03,  4.0,   9.10100,
     &   1.000E-03, 10.5,   8.95300,
     &   1.000E-03,  3.5,   8.86400,
     &   1.000E-03,  3.5,   8.62900,
     &   1.000E-03, 11.5,   8.28800,
     &   1.000E-03,  0.5,  10.23200,
     &   1.200E-03,  1.0,   5.60486,
     &   1.500E-03,  3.0,  10.08800,
     &   1.500E-03,  4.0,   9.28000/
      data (width(44,j),spin(44,j),exm(44,j),j= 61, 70)/
     &   1.500E-03,  3.0,   8.25430,
     &   1.500E-03, 11.5,  10.41100,
     &   2.000E-03,  7.5,   9.26700,
     &   2.000E-03,  3.5,   6.87740,
     &   2.000E-03,  1.5,   8.59190,
     &   2.000E-03,  2.0,   6.80310,
     &   2.400E-03,  3.5,   6.92650,
     &   3.000E-03,  2.0,   6.81100,
     &   3.000E-03,  4.5,  10.36500,
     &   3.400E-03,  1.5,   9.31800/
      data (width(44,j),spin(44,j),exm(44,j),j= 71, 80)/
     &   3.600E-03,  1.5,   9.66750,
     &   3.600E-03,  1.5,   8.92670,
     &   4.000E-03,  1.5,  11.50200,
     &   4.000E-03,  1.5,  10.55500,
     &   4.200E-03,  3.0,   9.03000,
     &   4.300E-03,  1.5,  10.13700,
     &   4.500E-03,  0.5,  13.27000,
     &   4.700E-03,  2.5,  10.61430,
     &   5.000E-03,  0.5,   9.32100,
     &   5.000E-03,  3.0,   6.85700/
      data (width(44,j),spin(44,j),exm(44,j),j= 81, 90)/
     &   5.700E-03,  1.5,  10.49630,
     &   6.000E-03,  2.0,   9.65400,
     &   6.000E-03,  1.0,   7.45400,
     &   6.000E-03,  1.5,   9.32900,
     &   6.000E-03,  3.0,   7.74000,
     &   6.000E-03,  1.5,   7.26200,
     &   6.000E-03,  0.5,  10.76330,
     &   6.200E-03,  0.5,   9.16700,
     &   6.300E-03,  2.5,   9.53640,
     &   6.500E-03,  4.0,   7.20100/
      data (width(44,j),spin(44,j),exm(44,j),j= 91,100)/
     &   7.000E-03,  0.5,  13.24500,
     &   7.500E-03,  3.0,   8.37000,
     &   8.000E-03,  2.0,   9.64200,
     &   8.900E-03,  3.5,   9.58600,
     &   9.200E-03,  4.0,   6.77700,
     &   9.200E-03,  1.5,  10.30800,
     &   1.000E-02,  0.5,  13.06800,
     &   1.000E-02,  2.0,   6.28320,
     &   1.020E-02,  1.5,   9.20400,
     &   1.200E-02,  4.0,   7.50600/
      data (width(44,j),spin(44,j),exm(44,j),j=101,110)/
     &   1.200E-02,  2.0,   7.47800,
     &   1.400E-02,  3.0,   6.16320,
     &   1.400E-02,  2.0,  10.97500,
     &   1.460E-02,  1.0,   7.40600,
     &   1.500E-02,  0.5,  12.52200,
     &   1.600E-02,  1.0,   7.33600,
     &   1.650E-02,  2.0,   7.52800,
     &   1.700E-02,  0.5,  11.18800,
     &   2.000E-02,  2.0,   7.87800,
     &   2.000E-02,  4.0,   8.23800/
      data (width(44,j),spin(44,j),exm(44,j),j=111,120)/
     &   2.100E-02,  0.5,  14.14700,
     &   2.200E-02,  0.5,  13.53200,
     &   2.200E-02,  2.5,  11.54000,
     &   2.200E-02,  2.5,  11.28600,
     &   2.200E-02,  2.5,  10.58100,
     &   2.200E-02,  0.5,  10.25400,
     &   2.500E-02,  0.5,   9.88700,
     &   2.600E-02,  1.5,   9.56600,
     &   2.800E-02,  2.5,   9.52700,
     &   2.800E-02,  3.5,  13.31700/
      data (width(44,j),spin(44,j),exm(44,j),j=121,130)/
     &   2.800E-02,  1.5,   6.89100,
     &   3.000E-02,  1.0,   7.55500,
     &   3.000E-02,  0.5,   7.70200,
     &   3.100E-02,  0.5,  10.16200,
     &   3.200E-02,  1.0,   7.48500,
     &   3.200E-02,  1.5,  17.45000,
     &   3.200E-02,  3.5,   7.11400,
     &   3.300E-02,  1.5,  11.65300,
     &   3.500E-02,  0.5,  11.07200,
     &   3.600E-02,  3.5,   7.68500/
      data (width(44,j),spin(44,j),exm(44,j),j=131,140)/
     &   3.800E-02,  3.0,   7.29100,
     &   3.800E-02,  1.5,  13.36000,
     &   3.800E-02,  0.5,  11.45000,
     &   3.800E-02,  2.0,   7.89900,
     &   4.600E-02,  0.5,   8.79320,
     &   4.600E-02,  2.5,  14.46000,
     &   4.650E-02,  1.0,   7.24700,
     &   4.800E-02,  2.5,  12.57700,
     &   5.100E-02,  1.5,  14.25500,
     &   5.100E-02,  0.5,   6.98900/
      data (width(44,j),spin(44,j),exm(44,j),j=141,150)/
     &   5.200E-02,  3.0,   7.31500,
     &   5.200E-02,  3.5,  13.73200,
     &   5.200E-02,  2.0,   8.20900,
     &   6.000E-02,  4.5,  16.72000,
     &   6.000E-02,  4.5,  14.10000,
     &   6.000E-02,  4.5,  14.02000,
     &   6.000E-02,  4.5,  13.83000,
     &   6.000E-02,  4.0,   8.06400,
     &   6.300E-02,  1.5,  11.60300,
     &   6.600E-02,  1.0,   7.72900/
      data (width(44,j),spin(44,j),exm(44,j),j=151,160)/
     &   6.700E-02,  1.5,   9.57500,
     &   7.000E-02,  5.0,   6.56700,
     &   7.100E-02,  2.5,  12.94000,
     &   7.100E-02,  0.5,  12.04000,
     &   7.400E-02,  1.5,  12.22200,
     &   7.600E-02,  1.5,  14.33000,
     &   8.000E-02,  1.0,   6.63300,
     &   8.400E-02,  1.5,  14.10000,
     &   8.800E-02,  2.0,   6.80900,
     &   9.000E-02,  3.5,   7.56000/
      data (width(44,j),spin(44,j),exm(44,j),j=161,170)/
     &   9.100E-02,  1.0,   6.64700,
     &   9.500E-02,  3.5,  17.65000,
     &   9.500E-02,  2.5,  12.78000,
     &   1.010E-01,  0.5,  13.87800,
     &   1.050E-01,  1.5,  12.13600,
     &   1.120E-01,  1.0,   7.94100,
     &   1.240E-01,  1.5,  14.70000,
     &   1.240E-01,  0.5,  12.98000,
     &   1.410E-01,  2.5,  14.04000,
     &   1.500E-01,  1.5,  15.77000/
      data (width(44,j),spin(44,j),exm(44,j),j=171,180)/
     &   1.540E-01,  0.5,  14.35200,
     &   1.790E-01,  1.5,  14.46000,
     &   2.000E-01,  1.5,  16.28000,
     &   2.200E-01,  4.5,  16.07000,
     &   2.400E-01,  2.5,  10.85970,
     &   2.550E-01,  1.5,  17.93000,
     &   2.570E-01,  0.5,  14.72000,
     &   2.720E-01,  0.5,  11.35000,
     &   2.760E-01,  1.5,  12.86000,
     &   2.850E-01,  1.5,  13.09000/
      data (width(44,j),spin(44,j),exm(44,j),j=181,190)/
     &   2.850E-01,  0.5,  12.58000,
     &   3.000E-01,  0.5,   8.65000,
     &   3.170E-01,  1.5,  20.93000,
     &   3.230E-01,  3.5,  17.16000,
     &   3.310E-01,  1.5,  17.05000,
     &   3.610E-01,  0.5,  14.74000,
     &   3.650E-01,  3.5,  18.03000,
     &   3.690E-01,  2.5,  19.80000,
     &   4.120E-01,  0.5,  20.81000,
     &   4.480E-01,  3.5,  21.05000/
      data (width(44,j),spin(44,j),exm(44,j),j=191,192)/
     &   4.730E-01,  1.5,  19.89000,
     &   5.600E-01,  1.5,  19.07000/

*(45) 20F 
      data nlvl(45) / 45/
      data (width(45,j),spin(45,j),exm(45,j),j=  1, 10)/
     &   8.295E-12,  4.0,   0.82273,
     &   3.355E-10,  1.0,   0.98359,
     &   3.510E-10,  2.0,   1.30919,
     &   1.086E-09,  3.0,   1.97083,
     &   1.496E-09,  3.0,   0.65602,
     &   9.918E-09,  2.0,   1.84380,
     &   1.014E-08,  5.0,   1.82380,
     &   2.281E-08,  3.0,   2.86486,
     &   2.963E-08,  1.5,   3.68017,
     &   5.633E-08,  1.0,   3.48841/
      data (width(45,j),spin(45,j),exm(45,j),j= 11, 20)/
     &   8.946E-08,  1.0,   1.05685,
     &   9.125E-08,  0.5,   4.27709,
     &   9.505E-08,  1.0,   3.96507,
     &   1.086E-07,  1.5,   5.55534,
     &   1.201E-07,  0.0,   3.52631,
     &   1.267E-07,  3.0,   2.96611,
     &   1.304E-07,  0.5,   4.31200,
     &   1.342E-07,  1.0,   5.31917,
     &   1.521E-07,  2.0,   4.37147,
     &   1.573E-07,  3.0,   2.19430/
      data (width(45,j),spin(45,j),exm(45,j),j= 21, 30)/
     &   1.690E-07,  2.0,   2.04398,
     &   1.825E-07,  1.0,   4.08217,
     &   1.984E-07,  2.0,   6.01778,
     &   3.259E-07,  2.0,   5.93613,
     &   4.703E-07,  1.5,   5.22610,
     &   6.003E-07,  1.5,   3.58654,
     &   8.000E-05,  3.5,   6.64260,
     &   3.100E-04,  2.0,   6.62700,
     &   6.000E-04,  3.0,   6.76610,
     &   1.590E-03,  1.0,   6.64750/
      data (width(45,j),spin(45,j),exm(45,j),j= 31, 40)/
     &   5.000E-03,  1.0,   6.96780,
     &   8.000E-03,  2.0,   7.16600,
     &   1.000E-02,  2.0,   7.42000,
     &   1.000E-02,  2.0,   6.85670,
     &   1.380E-02,  1.0,   6.69340,
     &   1.400E-02,  1.0,   7.98500,
     &   1.900E-02,  1.0,   7.37000,
     &   2.400E-02,  1.0,   7.08000,
     &   3.300E-02,  1.0,   7.31900,
     &   5.000E-02,  1.0,   7.84300/
      data (width(45,j),spin(45,j),exm(45,j),j= 41, 45)/
     &   6.500E-02,  2.0,   7.65500,
     &   7.000E-02,  1.5,  10.64100,
     &   8.000E-02,  2.0,   7.49500,
     &   2.000E-01,  0.5,  10.22800,
     &   3.100E-01,  0.5,  10.80700/

*(46) 21F 
      data nlvl(46) /  4/
      data (width(46,j),spin(46,j),exm(46,j),j=  1,  4)/
     &   7.479E-14,  0.5,   0.27992,
     &   6.518E-10,  2.0,   3.45965,
     &   6.518E-10,  2.0,   3.51766,
     &   1.496E-09,  1.0,   1.10090/

*(47) 18Ne
      data nlvl(47) / 11/
      data (width(47,j),spin(47,j),exm(47,j),j=  1, 10)/
     &   1.521E-10,  0.0,   3.57630,
     &   1.521E-10,  4.0,   3.37620,
     &   9.918E-10,  2.0,   1.88730,
     &   1.037E-08,  2.0,   3.61640,
     &   2.000E-02,  0.0,   4.59000,
     &   2.000E-02,  1.0,   4.51900,
     &   2.500E-02,  2.5,   5.14600,
     &   4.000E-02,  2.5,   5.09000,
     &   5.000E-02,  1.5,   7.91000,
     &   6.000E-02,  4.0,   6.29700/
      data (width(47,j),spin(47,j),exm(47,j),j= 11, 11)/
     &   1.800E-01,  1.5,   7.05900/

*(48) 19Ne
      data nlvl(48) / 19/
      data (width(48,j),spin(48,j),exm(48,j),j=  1, 10)/
     &   2.535E-14,  2.5,   0.23827,
     &   1.071E-11,  0.5,   0.27509,
     &   4.703E-10,  2.5,   1.50756,
     &   6.518E-10, 11.5,   4.63500,
     &   1.901E-09,  3.5,   4.19710,
     &   2.281E-09,  4.5,   4.14000,
     &   4.148E-09,  2.5,   4.60000,
     &   4.608E-09,  1.5,   1.61560,
     &   4.703E-09,  4.5,   2.79470,
     &   5.703E-09,  3.5,   4.37910/
      data (width(48,j),spin(48,j),exm(48,j),j= 11, 19)/
     &   8.295E-09,  1.0,   4.54900,
     &   1.304E-08,  1.5,   4.03290,
     &   2.401E-08,  1.5,   1.53600,
     &   2.500E-02,  1.5,  11.51000,
     &   4.500E-02,  1.5,  10.40700,
     &   1.800E-01,  0.5,  12.69000,
     &   1.800E-01,  3.5,  12.40000,
     &   2.000E-01,  2.5,  12.23000,
     &   3.550E-01,  0.5,  10.46000/

*(49) 20Ne
      data nlvl(49) /200/
      data (width(49,j),spin(49,j),exm(49,j),j=  1, 10)/
     &   1.383E-10,  2.0,   4.96651,
     &   6.250E-10,  2.0,   1.63367,
     &   1.496E-09,  4.0,   7.00400,
     &   3.282E-09,  3.0,   5.62140,
     &   7.129E-09,  4.0,   4.24770,
     &   1.878E-08,  1.0,   9.93500,
     &   2.173E-08,  3.5,  11.52800,
     &   2.173E-08,  3.0,  10.88400,
     &   2.851E-08,  6.0,  10.60900,
     &   1.300E-05,  5.0,   8.45300/
      data (width(49,j),spin(49,j),exm(49,j),j= 11, 20)/
     &   2.800E-05,  1.0,   5.78770,
     &   3.500E-05,  8.0,  11.95100,
     &   8.000E-05,  7.0,  13.33800,
     &   1.100E-04,  6.0,   8.77760,
     &   1.400E-04,  2.0,  13.88100,
     &   3.000E-04,  1.0,  11.27000,
     &   3.000E-04,  2.0,  10.27320,
     &   4.400E-04,  4.0,  11.92800,
     &   5.000E-04,  4.0,  11.09000,
     &   9.000E-04,  1.0,  13.30750/
      data (width(49,j),spin(49,j),exm(49,j),j= 21, 30)/
     &   1.000E-03,  2.0,  13.06070,
     &   1.000E-03,  5.0,   8.82000,
     &   1.000E-03,  3.0,  12.25600,
     &   1.000E-03,  2.0,  12.22100,
     &   1.100E-03,  0.0,  11.55800,
     &   2.000E-03,  2.0,   7.83340,
     &   2.000E-03,  0.0,  16.73290,
     &   2.100E-03,  1.0,   8.70800,
     &   2.300E-03,  1.0,  13.17130,
     &   3.000E-03,  4.0,   9.03100/
      data (width(49,j),spin(49,j),exm(49,j),j= 31, 40)/
     &   3.200E-03,  3.0,   9.11600,
     &   3.400E-03,  0.0,   7.19100,
     &   3.500E-03,  0.0,  13.92600,
     &   4.500E-03,  2.0,  13.67600,
     &   4.700E-03,  2.0,  14.12800,
     &   6.400E-03,  1.0,  13.48400,
     &   7.300E-03,  6.0,  14.76100,
     &   7.700E-03,  1.0,  13.73600,
     &   8.100E-03,  4.0,  13.96500,
     &   8.200E-03,  3.0,   7.15630/
      data (width(49,j),spin(49,j),exm(49,j),j= 41, 50)/
     &   9.000E-03,  2.0,  13.58600,
     &   9.500E-03,  2.0,  18.43000,
     &   1.000E-02,  7.0,  18.00500,
     &   1.100E-02,  5.0,  13.67700,
     &   1.180E-02,  2.0,  14.15000,
     &   1.200E-02,  2.0,  13.57300,
     &   1.300E-02,  2.0,  10.84300,
     &   1.400E-02,  1.0,  14.20000,
     &   1.500E-02,  5.0,  14.45400,
     &   1.510E-02,  2.0,   7.42190/
      data (width(49,j),spin(49,j),exm(49,j),j= 51, 60)/
     &   1.600E-02,  4.0,  10.55300,
     &   1.600E-02,  5.0,  16.84700,
     &   1.700E-02,  0.0,  13.64200,
     &   1.800E-02,  4.0,  13.04800,
     &   1.900E-02,  0.0,   6.72500,
     &   1.900E-02,  2.0,  17.55000,
     &   1.900E-02,  1.0,   8.85400,
     &   2.400E-02,  2.0,  10.58400,
     &   2.400E-02,  1.0,  13.50700,
     &   2.400E-02,  3.0,  13.41400/
      data (width(49,j),spin(49,j),exm(49,j),j= 61, 70)/
     &   2.400E-02,  4.0,  11.02000,
     &   2.400E-02,  6.0,  16.50500,
     &   2.440E-02,  0.0,  12.43600,
     &   2.500E-02,  0.0,  14.65300,
     &   2.500E-02,  5.0,  16.71700,
     &   2.600E-02,  5.0,  17.15500,
     &   2.600E-02,  4.0,  13.34100,
     &   2.900E-02,  2.0,   9.48300,
     &   2.900E-02,  7.0,  18.12500,
     &   3.000E-02,  1.0,  12.83600/
      data (width(49,j),spin(49,j),exm(49,j),j= 71, 80)/
     &   3.000E-02,  1.0,  11.98500,
     &   3.300E-02,  1.0,  14.45500,
     &   3.400E-02,  4.0,  15.33000,
     &   3.400E-02,  5.0,  18.02400,
     &   3.500E-02,  2.0,  16.43700,
     &   3.600E-02,  1.0,  14.69900,
     &   3.730E-02,  3.0,  12.40100,
     &   3.800E-02,  2.0,  12.95700,
     &   4.000E-02,  2.0,  11.32000,
     &   4.000E-02,  0.0,  13.22200/
      data (width(49,j),spin(49,j),exm(49,j),j= 81, 90)/
     &   4.200E-02,  2.0,  14.11500,
     &   4.500E-02,  3.0,  10.84000,
     &   4.500E-02,  3.0,  14.31300,
     &   4.500E-02,  4.0,  16.32900,
     &   4.600E-02,  2.0,  11.88500,
     &   4.800E-02,  3.0,  13.13700,
     &   4.900E-02,  5.0,  13.42600,
     &   5.300E-02,  3.0,  13.22600,
     &   6.000E-02,  6.0,  15.15900,
     &   6.000E-02,  2.0,  15.14200/
      data (width(49,j),spin(49,j),exm(49,j),j= 91,100)/
     &   6.000E-02,  4.0,  14.73100,
     &   6.000E-02,  6.0,  14.30400,
     &   6.000E-02,  9.0,  21.06200,
     &   6.100E-02,  2.0,  12.74300,
     &   6.100E-02,  2.0,  13.52900,
     &   6.500E-02,  6.0,  13.92800,
     &   6.600E-02,  2.0,  15.04700,
     &   6.800E-02,  0.0,  14.47500,
     &   7.000E-02,  1.0,  14.02000,
     &   7.200E-02,  6.0,  12.58500/
      data (width(49,j),spin(49,j),exm(49,j),j=101,110)/
     &   7.400E-02,  2.0,  13.90800,
     &   7.600E-02,  0.0,  13.53000,
     &   7.800E-02,  9.0,  20.68600,
     &   7.900E-02,  4.0,  14.83900,
     &   7.900E-02,  0.0,  13.94800,
     &   8.000E-02,  3.0,  10.40600,
     &   8.000E-02,  6.0,  20.02700,
     &   8.000E-02,  0.0,  13.74400,
     &   8.000E-02,  3.0,  16.62800,
     &   8.000E-02,  1.0,  13.22400/
      data (width(49,j),spin(49,j),exm(49,j),j=111,120)/
     &   8.400E-02,  5.0,  12.71300,
     &   8.600E-02,  6.0,  14.80700,
     &   8.600E-02,  6.0,  17.54100,
     &   8.600E-02,  3.0,  17.28400,
     &   9.000E-02,  3.0,  15.43600,
     &   9.000E-02,  5.0,  19.05100,
     &   9.000E-02,  5.0,  16.55900,
     &   9.200E-02,  4.0,  14.27000,
     &   9.200E-02,  7.0,  16.58100,
     &   1.000E-01,  8.0,  15.87400/
      data (width(49,j),spin(49,j),exm(49,j),j=121,130)/
     &   1.000E-01,  2.0,  14.88800,
     &   1.000E-01,  4.0,  16.66700,
     &   1.000E-01,  2.0,  16.01000,
     &   1.020E-01,  6.0,  13.10500,
     &   1.100E-01,  7.0,  15.36600,
     &   1.100E-01,  1.0,  14.77600,
     &   1.160E-01,  1.0,  14.59700,
     &   1.170E-01,  5.0,  14.81600,
     &   1.170E-01,  6.0,  14.31100,
     &   1.200E-01,  7.0,  19.88400/
      data (width(49,j),spin(49,j),exm(49,j),j=131,140)/
     &   1.240E-01,  2.0,  12.47200,
     &   1.250E-01,  4.0,  17.76900,
     &   1.300E-01,  4.0,  19.99100,
     &   1.300E-01,  6.0,  19.44300,
     &   1.300E-01,  5.0,  18.49400,
     &   1.350E-01,  7.0,  20.34400,
     &   1.360E-01,  3.0,  13.82700,
     &   1.380E-01,  8.0,  18.53800,
     &   1.400E-01,  2.0,  14.06300,
     &   1.400E-01,  6.0,  19.65500/
      data (width(49,j),spin(49,j),exm(49,j),j=141,150)/
     &   1.400E-01,  6.0,  19.28400,
     &   1.400E-01,  7.0,  18.76800,
     &   1.400E-01,  6.0,  18.74500,
     &   1.400E-01,  4.0,  18.08300,
     &   1.400E-01,  5.0,  17.60600,
     &   1.450E-01,  2.0,  12.59200,
     &   1.450E-01,  5.0,  10.26200,
     &   1.550E-01,  4.0,  12.25300,
     &   1.550E-01,  4.0,   9.99000,
     &   1.600E-01,  5.0,  15.07300/
      data (width(49,j),spin(49,j),exm(49,j),j=151,160)/
     &   1.600E-01,  8.0,  16.74600,
     &   1.620E-01,  2.0,  13.09500,
     &   1.700E-01,  5.0,  20.80000,
     &   1.700E-01,  5.0,  19.85900,
     &   1.750E-01,  1.0,  13.86600,
     &   1.750E-01,  1.0,  11.24000,
     &   1.800E-01,  4.0,  17.07200,
     &   1.850E-01,  8.0,  18.62100,
     &   1.850E-01,  7.0,  18.43000,
     &   1.900E-01,  5.0,  20.34100/
      data (width(49,j),spin(49,j),exm(49,j),j=161,170)/
     &   1.900E-01,  7.0,  20.10600,
     &   1.900E-01,  6.0,  18.28600,
     &   1.950E-01,  1.0,  13.46100,
     &   2.000E-01,  8.0,  25.10000,
     &   2.000E-01,  9.0,  23.70000,
     &   2.000E-01,  6.0,  19.15000,
     &   2.000E-01,  8.0,  18.96000,
     &   2.000E-01,  5.0,  17.85100,
     &   2.000E-01,  8.0,  17.29500,
     &   2.150E-01,  6.0,  20.41900/
      data (width(49,j),spin(49,j),exm(49,j),j=171,180)/
     &   2.200E-01,  9.0,  17.43000,
     &   2.250E-01,  9.0,  22.87000,
     &   2.250E-01,  4.0,  17.21300,
     &   2.300E-01,  5.0,  15.17400,
     &   2.400E-01,  7.0,  20.76000,
     &   2.500E-01,  6.0,  19.53600,
     &   2.550E-01,  7.0,  20.29600,
     &   2.600E-01,  4.0,  14.59300,
     &   2.800E-01,  5.0,  20.46800,
     &   2.850E-01,  1.0,  15.27000/
      data (width(49,j),spin(49,j),exm(49,j),j=181,190)/
     &   2.900E-01,  6.0,  20.16800,
     &   3.000E-01,  7.0,  21.80000,
     &   3.000E-01,  7.0,  21.30000,
     &   3.000E-01,  7.0,  20.95000,
     &   3.100E-01,  7.0,  13.69200,
     &   3.300E-01,  8.0,  19.73100,
     &   3.500E-01,  4.0,  10.80000,
     &   3.500E-01,  8.0,  24.21000,
     &   3.500E-01,  6.0,  16.87100,
     &   3.600E-01,  6.0,  19.84500/
      data (width(49,j),spin(49,j),exm(49,j),j=191,200)/
     &   3.700E-01,  6.0,  20.44500,
     &   3.900E-01,  2.0,  12.32700,
     &   4.300E-01,  7.0,  19.29800,
     &   5.000E-01,  8.0,  23.40000,
     &   5.000E-01,  9.0,  22.80000,
     &   5.000E-01,  7.0,  22.30000,
     &   5.800E-01,  0.0,  11.00000,
     &   7.000E-01,  9.0,  27.10000,
     &   8.000E-01,  0.0,   8.70000,
     &   8.000E-01,  2.0,   9.00000/

*(50) 21Ne
      data nlvl(50) / 49/
      data (width(50,j),spin(50,j),exm(50,j),j=  1, 10)/
     &   5.633E-12,  0.5,   2.78883,
     &   6.435E-11,  2.5,   0.35073,
     &   6.165E-09,  0.5,   7.21100,
     &   7.019E-09,  1.5,   3.66367,
     &   8.774E-09,  3.5,   1.74591,
     &   1.113E-08,  3.5,   5.81900,
     &   1.170E-08,  4.5,   2.86680,
     &   1.629E-08,  1.5,   5.54900,
     &   1.690E-08,  2.5,   3.88430,
     &   1.901E-08,  1.5,   5.82200/
      data (width(50,j),spin(50,j),exm(50,j),j= 11, 20)/
     &   1.984E-08, 10.5,   4.43360,
     &   2.173E-08,  4.5,   8.15400,
     &   2.401E-08,  4.5,   6.03290,
     &   3.042E-08,  4.5,   6.64000,
     &   3.259E-08,  4.5,   6.55170,
     &   3.259E-08,  8.0,   6.44760,
     &   3.259E-08,  4.5,   6.26740,
     &   3.510E-08,  4.5,   7.04230,
     &   3.510E-08,  1.5,   5.99256,
     &   3.802E-08,  3.5,   7.00640/
      data (width(50,j),spin(50,j),exm(50,j),j= 21, 30)/
     &   3.802E-08,  2.0,   5.77470,
     &   4.148E-08,  1.5,   4.68450,
     &   4.562E-08,  2.5,   3.73530,
     &   4.562E-08,  3.0,   6.17380,
     &   4.562E-08,  7.5,   8.24050,
     &   4.562E-08,  3.5,   7.65300,
     &   5.069E-08,  2.0,   6.60810,
     &   5.703E-08,  3.0,   5.43080,
     &   6.518E-08,  3.5,   5.33570,
     &   6.518E-08,  1.5,   4.72536/
      data (width(50,j),spin(50,j),exm(50,j),j= 31, 40)/
     &   6.518E-08,  2.5,   4.52540,
     &   6.518E-08,  4.0,   7.36000,
     &   6.518E-08,  3.5,   5.62900,
     &   7.604E-08,  0.5,   5.68977,
     &   9.125E-08,  0.5,   2.79414,
     &   1.000E-03,  1.5,  10.63110,
     &   2.500E-03,  2.0,   8.85920,
     &   6.000E-03,  1.5,   7.97900,
     &   7.600E-03,  0.5,   9.14890,
     &   8.000E-03,  1.5,   8.06500/
      data (width(50,j),spin(50,j),exm(50,j),j= 41, 49)/
     &   9.800E-03,  1.5,  10.91290,
     &   1.000E-02,  1.5,   8.36000,
     &   2.400E-02,  1.5,  13.80100,
     &   2.700E-02,  1.5,   8.30300,
     &   3.200E-02,  0.5,   8.00800,
     &   3.800E-02,  1.5,   8.59100,
     &   5.000E-02,  1.5,   8.78200,
     &   5.400E-02,  1.5,   8.68000,
     &   5.500E-02,  1.5,  16.05800/

*(51) 22Ne
      data nlvl(51) / 24/
      data (width(51,j),spin(51,j),exm(51,j),j=  1, 10)/
     &   1.243E-10,  2.0,   1.27454,
     &   5.703E-10,  2.0,   5.14750,
     &   2.028E-09,  4.0,   3.35720,
     &   7.359E-09,  2.0,   7.40600,
     &   9.125E-09,  6.0,   6.31140,
     &   9.707E-09,  4.0,   7.42300,
     &   1.304E-08,  3.0,   5.90990,
     &   2.173E-08,  2.0,   5.36500,
     &   2.401E-08,  4.0,   5.52320,
     &   3.259E-08,  2.5,   6.63600/
      data (width(51,j),spin(51,j),exm(51,j),j= 11, 20)/
     &   3.259E-08,  3.0,   5.64130,
     &   3.510E-08,  2.0,   6.11500,
     &   4.562E-08,  4.0,   6.34520,
     &   4.562E-08,  2.0,   4.45670,
     &   4.148E-07,  1.0,   5.32620,
     &   5.703E-07,  2.0,   7.64400,
     &   1.933E-06,  1.0,   6.85340,
     &   5.497E-06,  1.0,   9.17800,
     &   1.141E-05,  1.0,  10.20600,
     &   2.000E-03,  0.0,  10.28700/
      data (width(51,j),spin(51,j),exm(51,j),j= 21, 24)/
     &   3.000E-03,  1.0,  11.46600,
     &   5.000E-03,  5.0,  10.75100,
     &   1.000E-02,  8.0,  11.03200,
     &   2.500E-02,  1.0,  10.92200/

*(52) 23Ne
      data nlvl(52) / 11/
      data (width(52,j),spin(52,j),exm(52,j),j=  1, 10)/
     &   2.563E-12,  0.5,   1.01700,
     &   6.518E-09,  1.5,   3.43180,
     &   6.518E-09,  1.5,   3.22066,
     &   6.518E-09,  1.5,   1.82250,
     &   6.518E-09,  1.5,   3.98820,
     &   6.518E-09,  0.5,   3.83640,
     &   6.518E-09,  3.0,   2.51700,
     &   6.518E-09,  2.5,   3.83090,
     &   6.518E-09,  1.5,   3.45820,
     &   6.518E-09,  2.5,   2.31510/
      data (width(52,j),spin(52,j),exm(52,j),j= 11, 11)/
     &   6.518E-09,  3.5,   1.70151/

*(53) 24Ne
      data nlvl(53) /  5/
      data (width(53,j),spin(53,j),exm(53,j),j=  1,  5)/
     &   2.281E-14,  4.0,   3.96200,
     &   2.281E-14,  2.0,   5.57600,
     &   2.851E-10,  0.0,   4.76400,
     &   6.913E-10,  2.0,   1.98160,
     &   6.518E-09,  2.0,   3.86700/

*(54) 21Na
      data nlvl(54) / 23/
      data (width(54,j),spin(54,j),exm(54,j),j=  1, 10)/
     &   4.400E-12,  0.5,   2.79820,
     &   5.000E-11,  4.5,   2.82940,
     &   6.444E-11,  2.5,   0.33193,
     &   1.629E-08,  3.5,   1.71600,
     &   2.281E-07,  0.5,   2.42490,
     &   2.600E-06,  2.5,   3.86310,
     &   1.550E-05,  2.5,   3.54400,
     &   1.930E-04,  1.5,   3.67970,
     &   4.000E-04,  1.5,   5.81500,
     &   1.200E-03,  2.0,   8.97300/
      data (width(54,j),spin(54,j),exm(54,j),j= 11, 20)/
     &   2.300E-03,  0.5,   9.22000,
     &   3.930E-03,  2.5,   4.29400,
     &   5.000E-03,  3.0,   6.09400,
     &   2.000E-02,  3.5,   5.77000,
     &   2.100E-02,  1.5,   4.46800,
     &   2.500E-02,  0.5,   5.82800,
     &   1.000E-01,  1.5,   6.90800,
     &   1.100E-01,  0.5,   5.45700,
     &   1.800E-01,  1.5,   4.17000,
     &   2.000E-01,  0.5,   4.98000/
      data (width(54,j),spin(54,j),exm(54,j),j= 21, 23)/
     &   2.200E-01,  1.5,   6.51200,
     &   3.000E-01,  2.5,   7.43200,
     &   3.200E-01,  0.5,   7.19400/

*(55) 22Na
      data nlvl(55) / 74/
      data (width(55,j),spin(55,j),exm(55,j),j=  1, 10)/
     &   1.870E-15,  1.0,   0.58303,
     &   6.612E-12,  1.0,   4.62170,
     &   6.612E-12,  2.0,   4.58280,
     &   2.364E-11,  0.0,   0.65700,
     &   3.062E-11,  1.0,   2.21150,
     &   4.655E-11,  4.0,   0.89089,
     &   7.733E-11,  3.0,   4.77100,
     &   8.608E-11,  2.0,   2.57150,
     &   1.304E-10,  0.0,   4.29610,
     &   1.342E-10,  5.0,   1.52806/
      data (width(55,j),spin(55,j),exm(55,j),j= 11, 20)/
     &   2.869E-10,  3.0,   1.98380,
     &   9.833E-10,  3.0,   3.51920,
     &   4.387E-09,  4.0,   4.46830,
     &   6.003E-09,  7.0,   4.52380,
     &   6.612E-09,  6.0,   3.70660,
     &   1.201E-08,  4.0,   5.10060,
     &   1.201E-08,  5.0,   4.71000,
     &   1.426E-08,  3.0,   2.96870,
     &   2.074E-08,  2.0,   3.05960,
     &   2.684E-08,  1.0,   4.31900/
      data (width(55,j),spin(55,j),exm(55,j),j= 21, 30)/
     &   3.259E-08,  2.0,   5.06240,
     &   3.510E-08,  1.0,   1.93690,
     &   5.703E-08,  2.0,   1.95180,
     &   9.311E-08,  2.0,   4.36000,
     &   1.472E-07,  1.5,   5.60300,
     &   1.573E-07,  2.0,   5.95900,
     &   4.562E-07,  2.0,   5.17400,
     &   6.518E-07,  1.0,   3.94350,
     &   6.518E-07,  2.0,   5.31800,
     &   1.000E-04,  3.0,   6.99700/
      data (width(55,j),spin(55,j),exm(55,j),j= 31, 40)/
     &   1.000E-04,  1.5,   7.07600,
     &   2.000E-04,  3.0,   7.01500,
     &   3.000E-04,  3.0,   7.23900,
     &   4.000E-04,  1.5,   7.21900,
     &   5.000E-04,  2.5,   8.03900,
     &   5.000E-04,  3.0,   7.96400,
     &   5.000E-04,  3.5,   7.88830,
     &   5.000E-04,  1.5,   7.82020,
     &   5.000E-04,  3.0,   7.68200,
     &   5.000E-04,  2.5,   7.63500/
      data (width(55,j),spin(55,j),exm(55,j),j= 41, 50)/
     &   5.000E-04,  4.0,   7.57260,
     &   5.000E-04,  2.5,   7.37750,
     &   5.000E-04,  2.0,   7.37100,
     &   5.000E-04,  1.5,   7.27700,
     &   5.000E-04,  3.5,   7.15100,
     &   6.000E-04,  1.5,   7.60400,
     &   6.000E-04,  2.0,   7.54620,
     &   6.000E-04,  3.0,   8.19600,
     &   1.000E-03,  4.0,   8.01700,
     &   1.000E-03,  3.5,   7.35900/
      data (width(55,j),spin(55,j),exm(55,j),j= 51, 60)/
     &   1.200E-03,  2.0,   6.85900,
     &   1.500E-03,  3.5,   8.10600,
     &   1.500E-03,  1.5,   7.40000,
     &   1.500E-03,  5.0,   7.27800,
     &   1.900E-03,  2.0,   7.59900,
     &   2.400E-03,  1.5,   7.79980,
     &   2.500E-03,  2.0,   7.42200,
     &   2.700E-03,  1.5,   8.32700,
     &   2.800E-03,  2.0,   7.77730,
     &   3.100E-03,  3.0,   8.11300/
      data (width(55,j),spin(55,j),exm(55,j),j= 61, 70)/
     &   3.200E-03,  1.5,   7.40790,
     &   3.800E-03,  1.5,   8.10000,
     &   4.000E-03,  2.0,   7.47090,
     &   4.500E-03,  1.5,   8.28600,
     &   5.100E-03,  1.5,   8.21000,
     &   5.400E-03,  1.5,   8.43400,
     &   1.000E-02,  1.0,   7.97600,
     &   1.100E-02,  1.5,   8.63500,
     &   1.100E-02,  1.5,   8.23200,
     &   1.120E-02,  1.5,   8.60000/
      data (width(55,j),spin(55,j),exm(55,j),j= 71, 74)/
     &   1.320E-02,  1.5,   8.53600,
     &   1.700E-02,  2.0,   7.91800,
     &   2.250E-02,  3.0,   8.16400,
     &   4.400E-02,  1.5,   8.49500/

*(56) 23Na
      data nlvl(56) / 71/
      data (width(56,j),spin(56,j),exm(56,j),j=  1, 10)/
     &   4.110E-10,  2.5,   0.43999,
     &   8.295E-10,  0.5,   2.39073,
     &   5.126E-09,  2.5,   3.84807,
     &   6.003E-09,  4.5,   2.70350,
     &   6.518E-09,  2.5,   6.19460,
     &   6.810E-09,  0.5,   2.63986,
     &   1.201E-08,  6.5,   6.11500,
     &   1.304E-08,  3.5,   7.41240,
     &   1.521E-08,  1.5,   6.94740,
     &   1.755E-08,  4.5,   6.35450/
      data (width(56,j),spin(56,j),exm(56,j),j= 11, 20)/
     &   1.755E-08,  3.5,   2.07601,
     &   1.901E-08,  1.5,   3.67760,
     &   2.173E-08,  1.5,   8.41743,
     &   2.281E-08,  3.5,   8.94500,
     &   3.042E-08,  8.0,   6.23600,
     &   3.510E-08,  3.5,   5.92680,
     &   3.802E-08,  2.5,   7.87620,
     &   4.148E-08,  3.0,   6.57779,
     &   4.148E-08,  1.5,   5.96440,
     &   5.069E-08,  3.0,   7.27710/
      data (width(56,j),spin(56,j),exm(56,j),j= 21, 30)/
     &   5.069E-08, 10.5,   5.53400,
     &   5.497E-08,  2.5,   3.91424,
     &   5.703E-08,  2.5,   6.81960,
     &   7.359E-08,  3.5,   6.04219,
     &   7.604E-08,  2.0,   6.86770,
     &   1.521E-07,  1.5,   2.98206,
     &   1.521E-07,  2.0,   7.87283,
     &   1.521E-07,  3.0,   7.83413,
     &   1.521E-07,  1.0,   7.48784,
     &   1.521E-07,  2.5,   7.45150/
      data (width(56,j),spin(56,j),exm(56,j),j= 31, 40)/
     &   3.259E-07,  3.5,   4.77461,
     &   6.518E-07,  3.0,   6.61790,
     &   8.774E-07,  1.5,   6.73550,
     &   1.099E-06,  1.5,   5.76603,
     &   1.322E-06,  2.5,   5.74180,
     &   1.825E-06,  1.5,   7.08190,
     &   1.984E-06,  2.0,   7.13320,
     &   2.173E-06,  0.5,   4.42963,
     &   2.173E-06,  0.5,   8.82950,
     &   2.607E-06,  2.5,   5.37856/
      data (width(56,j),spin(56,j),exm(56,j),j= 41, 50)/
     &   2.943E-06,  2.5,   7.89120,
     &   3.802E-06,  0.5,   8.66380,
     &   4.000E-06,  2.5,  10.23120,
     &   6.000E-06,  1.5,   9.60808,
     &   8.000E-06,  2.5,  10.34570,
     &   2.500E-05,  2.5,  10.44010,
     &   2.900E-05,  1.5,   9.70070,
     &   4.700E-05,  1.5,   9.83520,
     &   6.500E-05,  2.5,  10.16927,
     &   6.500E-05,  0.5,   9.40470/
      data (width(56,j),spin(56,j),exm(56,j),j= 51, 60)/
     &   6.900E-05,  2.5,  10.01640,
     &   1.000E-04,  2.5,  10.51860,
     &   1.050E-04,  0.5,   9.65550,
     &   1.160E-04,  3.0,  12.55680,
     &   1.500E-04,  0.5,   9.84970,
     &   1.900E-04,  0.5,  10.33830,
     &   2.100E-04,  1.5,  10.35340,
     &   4.000E-04,  1.5,  10.70400,
     &   4.250E-04,  2.0,  10.61640,
     &   4.700E-04,  1.5,  10.47840/
      data (width(56,j),spin(56,j),exm(56,j),j= 61, 70)/
     &   4.750E-04,  0.5,  10.00300,
     &   5.400E-04,  2.5,  10.54880,
     &   5.600E-04,  0.5,  10.50740,
     &   9.200E-04,  1.5,  10.50140,
     &   1.100E-03,  1.5,  10.57410,
     &   1.270E-03,  0.5,  10.08477,
     &   1.900E-03,  2.5,  19.58600,
     &   2.000E-03,  1.5,  10.31760,
     &   2.450E-03,  0.5,  10.24340,
     &   4.200E-03,  0.5,  10.11450/
      data (width(56,j),spin(56,j),exm(56,j),j= 71, 71)/
     &   2.300E-02,  1.5,  10.67500/

*(57) 24Na
      data nlvl(57) / 51/
      data (width(57,j),spin(57,j),exm(57,j),j=  1, 10)/
     &   2.259E-20,  1.0,   0.47221,
     &   1.267E-11,  2.0,   0.56320,
     &   1.037E-10,  1.0,   1.34663,
     &   2.535E-09,  2.0,   1.84601,
     &   6.518E-09,  0.0,   4.04849,
     &   7.604E-09,  2.0,   1.34143,
     &   9.125E-09,  4.0,   4.89135,
     &   9.125E-09,  1.0,   5.47896,
     &   9.125E-09,  3.0,   5.25000,
     &   9.125E-09,  2.0,   5.05972/
      data (width(57,j),spin(57,j),exm(57,j),j= 11, 20)/
     &   1.304E-08,  2.0,   4.44154,
     &   1.304E-08,  3.0,   2.90394,
     &   1.521E-08,  2.0,   5.04490,
     &   1.690E-08,  5.0,   1.51240,
     &   1.755E-08,  3.0,   1.34465,
     &   1.755E-08,  3.0,   1.88551,
     &   1.984E-08,  2.0,   4.20719,
     &   2.281E-08,  4.0,   4.14500,
     &   2.684E-08,  2.0,   2.97783,
     &   2.684E-08,  4.0,   2.56280/
      data (width(57,j),spin(57,j),exm(57,j),j= 21, 30)/
     &   2.684E-08,  2.0,   3.93570,
     &   2.684E-08,  3.0,   3.74509,
     &   3.042E-08,  4.0,   3.21670,
     &   3.259E-08,  1.0,   3.41325,
     &   3.259E-08,  2.0,   4.18680,
     &   3.259E-08,  1.5,   3.97732,
     &   3.259E-08,  4.0,   3.94339,
     &   3.259E-08,  0.0,   3.68179,
     &   3.259E-08,  2.0,   5.62840,
     &   3.259E-08,  2.0,   5.33906/
      data (width(57,j),spin(57,j),exm(57,j),j= 31, 40)/
     &   3.259E-08,  2.0,   3.65597,
     &   3.259E-08,  3.0,   3.62825,
     &   3.510E-08,  2.0,   3.37184,
     &   4.562E-08,  1.0,   4.56206,
     &   4.562E-08,  1.5,   4.19630,
     &   4.562E-08,  3.0,   2.51351,
     &   6.518E-08,  0.0,   5.96620,
     &   6.518E-08,  3.0,   5.19244,
     &   7.604E-08,  1.0,   3.58926,
     &   1.300E-06,  3.0,   6.99337/
      data (width(57,j),spin(57,j),exm(57,j),j= 41, 50)/
     &   3.000E-04,  1.0,   7.24610,
     &   4.110E-04,  1.0,   6.96221,
     &   1.800E-03,  0.0,   7.19230,
     &   2.000E-03,  2.0,   7.24560,
     &   2.600E-03,  1.0,   7.32760,
     &   5.500E-03,  2.0,   7.18700,
     &   7.800E-03,  0.0,   7.37270,
     &   9.000E-03,  2.0,   7.38630,
     &   2.600E-02,  1.0,   7.53230,
     &   2.600E-02,  1.0,   7.33670/
      data (width(57,j),spin(57,j),exm(57,j),j= 51, 51)/
     &   4.500E-02,  3.0,   7.65550/

*(58) 25Na
      data nlvl(58) /  9/
      data (width(58,j),spin(58,j),exm(58,j),j=  1,  9)/
     &   8.946E-14,  1.5,   0.08953,
     &   3.456E-10,  0.5,   1.06932,
     &   2.607E-09,  2.5,   2.78800,
     &   3.259E-09,  3.5,   2.41700,
     &   1.472E-08,  0.5,   3.99500,
     &   1.825E-08,  1.5,   2.20200,
     &   2.535E-08,  1.5,   3.68700,
     &   2.851E-08,  2.5,   3.35300,
     &   4.562E-08,  2.5,   2.91400/

*(59) 22Mg
      data nlvl(59) / 10/
      data (width(59,j),spin(59,j),exm(59,j),j=  1, 10)/
     &   2.684E-14,  2.0,   5.31700,
     &   2.684E-14,  5.0,   5.83700,
     &   2.684E-14,  2.0,   5.00600,
     &   6.612E-12,  2.0,   5.03700,
     &   6.612E-12,  3.0,   5.46400,
     &   2.173E-10,  2.0,   1.24630,
     &   2.270E-09,  4.0,   3.30820,
     &   1.037E-08,  2.5,   5.29200,
     &   1.629E-08,  2.0,   5.71390,
     &   2.173E-08,  2.0,   4.40090/

*(60) 23Mg
      data nlvl(60) /  9/
      data (width(60,j),spin(60,j),exm(60,j),j=  1,  9)/
     &   3.259E-14,  1.5,   3.80000,
     &   3.259E-14,  0.5,   4.35400,
     &   3.259E-14,  2.5,   3.97400,
     &   3.650E-10,  2.5,   0.45070,
     &   7.935E-10,  0.5,   2.35900,
     &   4.148E-09,  0.5,   2.77100,
     &   4.803E-09,  4.5,   2.71500,
     &   2.281E-08,  3.5,   2.05100,
     &   2.684E-08,  2.0,   2.90800/

*(61) 24Mg
      data nlvl(61) /132/
      data (width(61,j),spin(61,j),exm(61,j),j=  1, 10)/
     &   3.380E-10,  2.0,   1.36867,
     &   4.854E-10,  3.0,   7.61647,
     &   1.690E-09,  1.0,   7.55530,
     &   2.200E-09,  2.0,  11.20800,
     &   2.607E-09,  3.5,   9.29980,
     &   6.426E-09,  3.0,   5.23520,
     &   6.913E-09,  0.0,   6.43250,
     &   7.359E-09,  5.0,  10.02790,
     &   7.359E-09,  7.0,  11.86000,
     &   7.733E-09,  3.0,   8.35810/
      data (width(61,j),spin(61,j),exm(61,j),j= 11, 20)/
     &   7.866E-09,  4.0,   6.01032,
     &   9.311E-09,  2.0,   4.23836,
     &   1.901E-08,  4.0,   4.12287,
     &   2.281E-08,  3.0,  11.29300,
     &   2.684E-08,  4.5,   7.81220,
     &   3.042E-08,  3.0,  11.59500,
     &   3.259E-08,  1.0,   7.74770,
     &   4.148E-08,  6.0,   9.52800,
     &   4.148E-08,  7.0,  12.44100,
     &   4.562E-08,  1.0,   8.43840/
      data (width(61,j),spin(61,j),exm(61,j),j= 21, 30)/
     &   4.562E-08,  4.0,   9.51621,
     &   4.562E-08,  2.0,   9.28440,
     &   4.562E-08,  2.0,   8.65490,
     &   5.069E-08,  5.0,  10.57598,
     &   6.003E-08,  2.0,   9.00350,
     &   6.518E-08,  2.0,   7.34905,
     &   6.518E-08,  4.0,   9.30095,
     &   6.518E-08,  2.0,  10.73110,
     &   6.518E-08,  2.0,   8.86450,
     &   6.518E-08,  8.0,  16.90400/
      data (width(61,j),spin(61,j),exm(61,j),j= 31, 40)/
     &   9.125E-08,  4.0,   8.43930,
     &   1.141E-07,  2.5,   9.45780,
     &   1.141E-07,  8.0,  14.15200,
     &   1.304E-07,  6.0,   8.11300,
     &   1.521E-07,  1.5,  10.05910,
     &   2.281E-07,  3.5,  10.58126,
     &   2.281E-07,  3.5,  10.66017,
     &   3.042E-07,  2.0,  10.36070,
     &   6.000E-07,  3.0,  11.16200,
     &   7.800E-07,  4.0,  11.21669/
      data (width(61,j),spin(61,j),exm(61,j),j= 41, 50)/
     &   1.000E-06,  2.0,  11.45280,
     &   1.400E-06,  2.0,  11.01600,
     &   1.600E-06,  4.0,  11.69500,
     &   1.601E-06,  1.0,   9.82840,
     &   2.300E-06,  0.0,  10.67970,
     &   6.612E-06,  1.0,   9.96780,
     &   7.500E-06,  2.0,  10.91720,
     &   2.000E-05,  4.0,  12.04940,
     &   2.000E-05,  2.0,  11.98800,
     &   2.000E-05,  3.0,  11.93120/
      data (width(61,j),spin(61,j),exm(61,j),j= 51, 60)/
     &   3.000E-05,  4.0,  12.63680,
     &   5.000E-05,  1.5,  12.18140,
     &   6.000E-05,  2.0,  12.25790,
     &   7.000E-05,  3.0,  12.33910,
     &   9.000E-05,  3.0,  12.39870,
     &   9.000E-05,  4.0,  13.05022,
     &   1.000E-04,  2.0,  12.40330,
     &   2.000E-04,  3.0,  12.84500,
     &   3.200E-04,  2.0,  12.85030,
     &   3.300E-04,  1.0,  12.89320/
      data (width(61,j),spin(61,j),exm(61,j),j= 61, 70)/
     &   4.000E-04,  2.5,  13.44490,
     &   5.000E-04,  2.0,  11.51900,
     &   5.000E-04,  1.0,  11.39000,
     &   5.000E-04,  0.0,  15.43640,
     &   7.000E-04,  3.0,  12.01520,
     &   8.000E-04,  2.0,  13.02790,
     &   9.000E-04,  4.0,  12.16100,
     &   9.000E-04,  3.0,  12.65890,
     &   1.000E-03,  6.0,  14.08200,
     &   1.000E-03,  6.0,  13.85200/
      data (width(61,j),spin(61,j),exm(61,j),j= 71, 80)/
     &   1.000E-03,  6.0,  12.00200,
     &   1.000E-03,  3.0,  13.47300,
     &   1.000E-03,  6.0,  13.43600,
     &   1.000E-03,  5.0,  13.05500,
     &   1.000E-03,  0.0,  11.45700,
     &   1.000E-03,  6.0,  12.86100,
     &   1.000E-03,  0.0,  12.85200,
     &   1.000E-03,  4.0,  14.32700,
     &   1.200E-03,  3.0,  12.25750,
     &   1.200E-03,  3.0,  13.34380/
      data (width(61,j),spin(61,j),exm(61,j),j= 81, 90)/
     &   1.400E-03,  3.0,  14.09900,
     &   1.500E-03,  1.0,  13.63070,
     &   1.600E-03,  5.0,  13.36500,
     &   1.700E-03,  2.0,  12.80590,
     &   1.800E-03,  4.0,  14.14800,
     &   1.900E-03,  5.0,  13.77000,
     &   1.900E-03,  4.0,  12.11710,
     &   2.000E-03,  2.0,  13.98200,
     &   2.000E-03,  1.0,  13.87900,
     &   2.000E-03,  1.0,  13.27360/
      data (width(61,j),spin(61,j),exm(61,j),j= 91,100)/
     &   2.100E-03,  2.0,  13.45110,
     &   2.300E-03,  2.0,  11.96470,
     &   2.300E-03,  4.0,  12.50400,
     &   2.500E-03,  1.0,  12.95490,
     &   2.600E-03,  2.0,  13.72000,
     &   2.700E-03,  0.0,  13.19800,
     &   2.800E-03,  0.0,  13.04100,
     &   2.800E-03,  1.0,  12.81590,
     &   3.000E-03,  2.0,  13.93300,
     &   3.200E-03,  2.0,  12.96190/
      data (width(61,j),spin(61,j),exm(61,j),j=101,110)/
     &   3.300E-03,  4.0,  12.97200,
     &   3.800E-03,  2.0,  12.46700,
     &   4.000E-03,  2.0,  12.66990,
     &   4.500E-03,  3.0,  13.42280,
     &   4.500E-03,  2.0,  13.41740,
     &   5.400E-03,  2.0,  13.67550,
     &   5.400E-03,  2.0,  13.13700,
     &   5.500E-03,  1.0,  14.07800,
     &   5.700E-03,  1.0,  12.44700,
     &   6.000E-03,  1.0,  13.26680/
      data (width(61,j),spin(61,j),exm(61,j),j=111,120)/
     &   6.200E-03,  2.0,  12.57700,
     &   6.700E-03,  3.0,  12.91970,
     &   6.900E-03,  2.0,  13.54040,
     &   7.000E-03,  2.0,  14.02400,
     &   7.000E-03,  0.0,  12.38300,
     &   7.000E-03,  1.0,  11.86400,
     &   7.500E-03,  1.0,  12.52650,
     &   8.000E-03,  1.0,  13.94600,
     &   8.000E-03,  1.0,  13.58530,
     &   8.100E-03,  2.0,  12.73710/
      data (width(61,j),spin(61,j),exm(61,j),j=121,130)/
     &   8.500E-03,  3.0,  14.01700,
     &   9.000E-03,  2.0,  13.35310,
     &   9.000E-03,  3.0,  13.08680,
     &   1.000E-02,  0.0,  11.72700,
     &   2.100E-02,  1.0,  13.58100,
     &   2.300E-02,  2.0,  13.68200,
     &   2.400E-02,  1.0,  13.81000,
     &   3.000E-02,  2.0,  13.82000,
     &   3.100E-02,  1.0,  13.33200,
     &   3.100E-02,  2.0,  12.77600/
      data (width(61,j),spin(61,j),exm(61,j),j=131,132)/
     &   3.600E-02,  1.0,  13.25300,
     &   4.800E-02,  2.0,  13.88400/

*(62) 25Mg
      data nlvl(62) / 82/
      data (width(62,j),spin(62,j),exm(62,j),j=  1, 10)/
     &   1.350E-13,  0.5,   0.58504,
     &   4.038E-11,  1.5,   0.97474,
     &   2.684E-10, 11.5,   5.46170,
     &   6.518E-10,  2.5,   1.96461,
     &   1.659E-09,  3.5,   2.73770,
     &   4.562E-09,  7.0,   6.88300,
     &   8.608E-09,  4.5,   4.05960,
     &   1.141E-08,  2.5,   6.67800,
     &   1.233E-08,  3.5,   5.79310,
     &   1.521E-08,  3.5,   7.83800/
      data (width(62,j),spin(62,j),exm(62,j),j= 11, 20)/
     &   1.521E-08,  2.5,   7.18100,
     &   1.521E-08,  2.0,   6.83200,
     &   1.521E-08,  8.0,   8.01100,
     &   1.629E-08,  1.5,   2.80147,
     &   1.755E-08,  4.5,   4.71140,
     &   2.173E-08, 10.5,   7.49300,
     &   2.281E-08,  4.5,   7.65300,
     &   2.281E-08,  8.0,   7.55100,
     &   2.281E-08,  2.5,   7.03800,
     &   2.401E-08,  3.5,   3.97070/
      data (width(62,j),spin(62,j),exm(62,j),j= 21, 30)/
     &   2.684E-08,  6.0,   8.88800,
     &   3.042E-08,  3.5,   1.61177,
     &   3.259E-08,  3.5,   7.96100,
     &   3.259E-08, 10.5,   5.25130,
     &   3.802E-08,  7.0,   7.86600,
     &   3.802E-08,  4.5,   7.80100,
     &   4.148E-08,  1.5,   3.41397,
     &   4.562E-08,  3.0,   7.52500,
     &   4.562E-08,  2.5,   7.50030,
     &   4.562E-08,  0.5,   2.56380/
      data (width(62,j),spin(62,j),exm(62,j),j= 31, 40)/
     &   4.562E-08,  3.5,   8.65600,
     &   4.562E-08,  7.0,   8.53200,
     &   4.562E-08,  4.0,   8.26700,
     &   6.426E-08,  4.5,   3.40520,
     &   6.518E-08,  1.5,   6.16900,
     &   6.518E-08,  2.5,   6.08200,
     &   6.518E-08,  7.0,   6.04120,
     &   6.518E-08,  1.5,   4.35940,
     &   6.518E-08,  3.5,   5.97800,
     &   6.518E-08,  4.5,   5.97160/
      data (width(62,j),spin(62,j),exm(62,j),j= 41, 50)/
     &   6.518E-08,  2.5,   5.86000,
     &   6.518E-08,  0.5,   4.27680,
     &   6.518E-08,  3.5,   7.28500,
     &   6.518E-08,  2.0,   7.22600,
     &   6.518E-08,  2.5,   5.52090,
     &   6.518E-08,  2.0,   7.08800,
     &   6.518E-08,  0.5,   5.47480,
     &   6.518E-08,  2.5,   6.95800,
     &   6.518E-08,  2.5,   6.91300,
     &   6.518E-08,  2.5,   3.90770/
      data (width(62,j),spin(62,j),exm(62,j),j= 51, 60)/
     &   6.518E-08,  0.5,   6.77700,
     &   6.518E-08,  0.5,   5.11630,
     &   6.518E-08,  1.0,   6.57000,
     &   6.518E-08,  3.5,   5.01220,
     &   6.518E-08,  1.5,   6.46800,
     &   6.518E-08,  4.5,   6.43400,
     &   6.518E-08,  2.5,   4.72200,
     &   6.518E-08,  1.5,   6.36200,
     &   7.604E-08, 10.5,   5.53360,
     &   9.125E-08,  6.0,   9.01300/
      data (width(62,j),spin(62,j),exm(62,j),j= 61, 70)/
     &   9.125E-08, 10.5,   8.55100,
     &   7.866E-07,  2.0,   5.74700,
     &   1.800E-06,  1.5,   7.37520,
     &   1.300E-05,  1.5,   7.86370,
     &   1.300E-05,  2.5,   7.78690,
     &   5.300E-04,  1.5,   7.80880,
     &   9.000E-04,  0.5,   7.94670,
     &   1.250E-03,  2.5,   8.31130,
     &   1.800E-03,  2.5,   8.55880,
     &   4.200E-03,  0.5,   8.83460/
      data (width(62,j),spin(62,j),exm(62,j),j= 71, 80)/
     &   4.200E-03,  1.5,   8.56950,
     &   7.200E-03,  1.5,   7.41090,
     &   8.400E-03,  1.5,   8.57950,
     &   9.600E-03,  2.5,   8.97080,
     &   1.000E-02,  0.5,   8.32420,
     &   1.000E-02,  0.5,   7.96370,
     &   1.300E-02,  1.5,   8.14080,
     &   1.500E-02,  1.5,   8.86910,
     &   2.000E-02,  0.5,   8.36260,
     &   3.100E-02,  1.5,   7.74390/
      data (width(62,j),spin(62,j),exm(62,j),j= 81, 82)/
     &   3.500E-02,  0.5,   8.89410,
     &   7.800E-02,  0.5,   7.58600/

*(63) 26Mg
      data nlvl(63) / 52/
      data (width(63,j),spin(63,j),exm(63,j),j=  1, 10)/
     &   7.084E-11,  0.0,   3.58880,
     &   5.368E-10,  3.0,   3.94080,
     &   9.585E-10,  2.0,   1.80872,
     &   1.037E-09,  0.0,   4.97200,
     &   1.677E-09,  4.0,   4.31840,
     &   3.236E-09,  2.0,   2.93841,
     &   4.345E-09,  3.0,   4.35000,
     &   5.368E-09,  3.0,   6.87750,
     &   6.518E-09,  4.0,   5.71550,
     &   8.774E-09,  0.0,   6.25600/
      data (width(63,j),spin(63,j),exm(63,j),j= 11, 20)/
     &   1.233E-08,  6.0,   9.82900,
     &   1.573E-08,  4.0,   4.90030,
     &   1.573E-08,  5.0,   8.62500,
     &   1.629E-08,  2.0,   4.83430,
     &   1.755E-08,  6.0,   9.16900,
     &   1.901E-08,  4.0,   7.28150,
     &   2.173E-08,  4.0,   5.47370,
     &   2.173E-08,  6.0,  10.65000,
     &   2.281E-08,  2.0,   4.33220,
     &   2.401E-08,  4.0,   6.62200/
      data (width(63,j),spin(63,j),exm(63,j),j= 21, 30)/
     &   2.851E-08,  2.0,   6.74500,
     &   3.259E-08,  5.0,   7.95300,
     &   3.259E-08,  3.0,   6.12500,
     &   3.259E-08,  5.0,   7.39500,
     &   3.259E-08,  2.0,   7.10000,
     &   3.259E-08,  5.0,   6.97800,
     &   3.259E-08,  5.0,   9.54100,
     &   3.259E-08,  6.0,   8.47200,
     &   3.259E-08,  6.0,   8.20100,
     &   4.562E-08,  3.5,   7.67700/
      data (width(63,j),spin(63,j),exm(63,j),j= 31, 40)/
     &   4.562E-08,  2.0,   5.29080,
     &   4.562E-08,  6.0,   9.11100,
     &   5.703E-08,  1.0,   5.68980,
     &   6.518E-08,  3.0,   7.77300,
     &   6.518E-08,  2.5,   7.54290,
     &   6.518E-08,  2.5,   7.26130,
     &   6.518E-08,  3.0,   7.24200,
     &   6.518E-08,  6.0,   9.98900,
     &   6.518E-08,  1.0,   7.06300,
     &   6.518E-08,  6.0,   9.38300/
      data (width(63,j),spin(63,j),exm(63,j),j= 41, 50)/
     &   6.518E-08,  5.0,   9.06400,
     &   6.518E-08,  4.0,   8.67000,
     &   6.518E-08,  2.0,   6.63400,
     &   4.562E-07,  1.5,   8.22900,
     &   7.242E-07,  1.0,   9.56000,
     &   7.866E-07,  1.0,  10.31900,
     &   1.342E-06,  1.0,   9.23900,
     &   4.148E-06,  1.0,  10.14800,
     &   6.083E-06,  1.0,  10.64600,
     &   1.800E-03,  2.0,  11.11200/
      data (width(63,j),spin(63,j),exm(63,j),j= 51, 52)/
     &   7.600E-03,  2.0,  11.16330,
     &   1.000E-02,  2.0,  11.19450/

*(64) 27Mg
      data nlvl(64) / 24/
      data (width(64,j),spin(64,j),exm(64,j),j=  1, 10)/
     &   4.655E-10,  2.5,   1.69800,
     &   4.655E-10,  1.5,   0.98466,
     &   6.003E-10,  2.5,   1.94000,
     &   9.125E-10,  3.5,   3.88400,
     &   1.086E-09,  3.5,   3.76040,
     &   6.612E-09,  3.0,   3.42690,
     &   6.612E-09,  2.5,   3.10940,
     &   1.014E-08,  2.5,   4.39820,
     &   1.629E-08,  0.5,   5.02800,
     &   1.901E-08,  2.5,   4.77610/
      data (width(64,j),spin(64,j),exm(64,j),j= 11, 20)/
     &   2.684E-08,  2.0,   5.76400,
     &   2.684E-08,  1.5,   3.78590,
     &   2.684E-08,  2.0,   5.37200,
     &   4.562E-08,  2.0,   4.55280,
     &   4.562E-08,  2.0,   3.49070,
     &   4.562E-08,  2.0,   5.17200,
     &   6.518E-08,  2.0,   5.82100,
     &   6.518E-08,  2.0,   4.14980,
     &   6.518E-08,  0.5,   3.47550,
     &   6.518E-08,  2.0,   5.62700/
      data (width(64,j),spin(64,j),exm(64,j),j= 21, 24)/
     &   6.518E-08,  1.5,   5.42200,
     &   6.518E-08,  2.5,   4.99230,
     &   6.518E-08,  1.0,   4.82730,
     &   6.518E-08,  1.5,   3.55950/

*(65) 28Mg
      data nlvl(65) /  9/
      data (width(65,j),spin(65,j),exm(65,j),j=  1,  9)/
     &   3.802E-10,  2.0,   1.47340,
     &   8.295E-10,  0.0,   3.86270,
     &   2.173E-09,  0.0,   5.70230,
     &   3.802E-09,  3.0,   5.17180,
     &   4.345E-09,  4.0,   4.02020,
     &   4.562E-09,  1.0,   5.27170,
     &   5.703E-09,  2.0,   4.87860,
     &   1.521E-08,  2.0,   4.55700,
     &   2.281E-08,  1.0,   5.19270/


      end

************************************************************************
*                                                                      *
      block data excmass
*                                                                      *
*                                                                      *
*        Purpose:                                                      *
*                                                                      *
*              excess mass table of GEM                                *
*                                                                      *
*                                                                      *
************************************************************************

*-----------------------------------------------------------------------

      implicit double precision(a-h, o-z)

*-----------------------------------------------------------------------

      common /gemms/ niz(10000), nia(10000), bie(10000)

*-----------------------------------------------------------------------
*     Excess Mass Table of GEM
*-----------------------------------------------------------------------

      data (niz(i),nia(i),bie(i),i=   1,  20)/
     &  0,  1,   8.07132300E+00,       0,  2,   2.18800000E+01,
     &  0,  3,   4.02500000E+01,       0,  4,   4.92800000E+01,
     &  0,  5,   6.74600000E+01,       0,  6,   7.89400000E+01,
     &  0,  7,   9.70500000E+01,       0,  8,   1.11310000E+02,
     &  0,  9,   1.32000000E+02,       0, 10,   1.48902490E+02,
     &  1,  1,   7.28896900E+00,       1,  2,   1.31357200E+01,
     &  1,  3,   1.49497940E+01,       1,  4,   2.59277840E+01,
     &  1,  5,   3.68339790E+01,       1,  6,   4.18637630E+01,
     &  1,  7,   5.10000000E+01,       1,  8,   7.60000000E+01,
     &  1,  9,   9.40000000E+01,       1, 10,   1.04000000E+02/
      data (niz(i),nia(i),bie(i),i=  21,  40)/
     &  1, 11,   1.20000000E+02,       1, 12,   1.44000000E+02,
     &  2,  2,   2.10789700E+01,       2,  3,   1.49312040E+01,
     &  2,  4,   2.42491100E+00,       2,  5,   1.13862340E+01,
     &  2,  6,   1.75941230E+01,       2,  7,   2.61102640E+01,
     &  2,  8,   3.15979830E+01,       2,  9,   4.08183620E+01,
     &  2, 10,   4.88100110E+01,       2, 11,   6.48200000E+01,
     &  2, 12,   7.50900000E+01,       2, 13,   8.88700000E+01,
     &  2, 14,   9.80600000E+01,       3,  3,   3.97389700E+01,
     &  3,  4,   2.53201730E+01,       3,  5,   1.16788800E+01,
     &  3,  6,   1.40863120E+01,       3,  7,   1.49076730E+01/
      data (niz(i),nia(i),bie(i),i=  41,  60)/
     &  3,  8,   2.09461950E+01,       3,  9,   2.49539030E+01,
     &  3, 10,   3.30502260E+01,       3, 11,   4.07958600E+01,
     &  3, 12,   5.00960000E+01,       3, 13,   6.17700000E+01,
     &  3, 14,   7.22900000E+01,       3, 15,   8.12600000E+01,
     &  3, 16,   9.36400000E+01,       3, 17,   1.02600000E+02,
     &  4,  4,   4.96308700E+01,       4,  5,   3.79960000E+01,
     &  4,  6,   1.83744650E+01,       4,  7,   1.57694890E+01,
     &  4,  8,   4.94166200E+00,       4,  9,   1.13475840E+01,
     &  4, 10,   1.26065770E+01,       4, 11,   2.01739700E+01,
     &  4, 12,   2.50764020E+01,       4, 13,   3.36584450E+01/
      data (niz(i),nia(i),bie(i),i=  61,  80)/
     &  4, 14,   3.98823960E+01,       4, 15,   5.09700000E+01,
     &  4, 16,   5.85600000E+01,       4, 17,   6.93800000E+01,
     &  4, 18,   7.62100000E+01,       4, 19,   8.71100000E+01,
     &  4, 20,   9.52700000E+01,       4, 21,   1.07970000E+02,
     &  4, 22,   1.18050000E+02,       5,  5,   6.88789700E+01,
     &  5,  6,   4.42013700E+01,       5,  7,   2.78678640E+01,
     &  5,  8,   2.29210020E+01,       5,  9,   1.24157010E+01,
     &  5, 10,   1.20507610E+01,       5, 11,   8.66798400E+00,
     &  5, 12,   1.33689010E+01,       5, 13,   1.65622090E+01,
     &  5, 14,   2.36637300E+01,       5, 15,   2.89669360E+01/
      data (niz(i),nia(i),bie(i),i=  81, 100)/
     &  5, 16,   3.70816860E+01,       5, 17,   4.37163100E+01,
     &  5, 18,   5.23220000E+01,       5, 19,   5.93640000E+01,
     &  5, 20,   6.66000000E+01,       5, 21,   7.42700000E+01,
     &  5, 22,   8.52200000E+01,       5, 23,   9.49500000E+01,
     &  5, 24,   1.08370000E+02,       5, 25,   1.20380000E+02,
     &  6,  6,   8.23410700E+01,       6,  7,   5.51834700E+01,
     &  6,  8,   3.50940560E+01,       6,  9,   2.89136500E+01,
     &  6, 10,   1.56985680E+01,       6, 11,   1.06505310E+01,
     &  6, 12,   0.00000000E+00,       6, 13,   3.12501100E+00,
     &  6, 14,   3.01989200E+00,       6, 15,   9.87314300E+00/
      data (niz(i),nia(i),bie(i),i= 101, 120)/
     &  6, 16,   1.36941170E+01,       6, 17,   2.10365890E+01,
     &  6, 18,   2.49240360E+01,       6, 19,   3.28333830E+01,
     &  6, 20,   3.75600630E+01,       6, 21,   4.59600000E+01,
     &  6, 22,   5.25830000E+01,       6, 23,   6.02400000E+01,
     &  6, 24,   6.84800000E+01,       6, 25,   8.17400000E+01,
     &  6, 26,   9.19800000E+01,       6, 27,   1.07130000E+02,
     &  6, 28,   1.18910000E+02,       7,  7,   1.02671630E+02,
     &  7,  8,   8.24040400E+01,       7,  9,   4.84573200E+01,
     &  7, 10,   3.96990000E+01,       7, 11,   2.49605200E+01,
     &  7, 12,   1.73380830E+01,       7, 13,   5.34545600E+00/
      data (niz(i),nia(i),bie(i),i= 121, 140)/
     &  7, 14,   2.86341700E+00,       7, 15,   1.01438000E-01,
     &  7, 16,   5.68343200E+00,       7, 17,   7.87081900E+00,
     &  7, 18,   1.31171360E+01,       7, 19,   1.58604490E+01,
     &  7, 20,   2.17664920E+01,       7, 21,   2.52319090E+01,
     &  7, 22,   3.20808900E+01,       7, 23,   3.77350000E+01,
     &  7, 24,   4.70400000E+01,       7, 25,   5.27500000E+01,
     &  7, 26,   6.42400000E+01,       7, 27,   7.34900000E+01,
     &  7, 28,   8.71300000E+01,       7, 29,   9.84100000E+01,
     &  7, 30,   1.11790000E+02,       7, 31,   1.22900000E+02,
     &  8,  8,   1.19685530E+02,       8,  9,   1.03157930E+02/
      data (niz(i),nia(i),bie(i),i= 141, 160)/
     &  8, 10,   6.15165500E+01,       8, 11,   5.01200000E+01,
     &  8, 12,   3.20478380E+01,       8, 13,   2.31107350E+01,
     &  8, 14,   8.00645600E+00,       8, 15,   2.85538800E+00,
     &  8, 16,  -4.73699800E+00,       8, 17,  -8.09002000E-01,
     &  8, 18,  -7.82064000E-01,       8, 19,   3.33356500E+00,
     &  8, 20,   3.79690900E+00,       8, 21,   8.06173600E+00,
     &  8, 22,   9.28434600E+00,       8, 23,   1.46163730E+01,
     &  8, 24,   1.89744570E+01,       8, 25,   2.71440000E+01,
     &  8, 26,   3.51640000E+01,       8, 27,   4.65800000E+01,
     &  8, 28,   5.37300000E+01,       8, 29,   6.50300000E+01/
      data (niz(i),nia(i),bie(i),i= 161, 180)/
     &  8, 30,   7.28300000E+01,       8, 31,   8.23000000E+01,
     &  8, 32,   9.13200000E+01,       8, 33,   1.04630000E+02,
     &  8, 34,   1.13700000E+02,       9,  9,   1.43137080E+02,
     &  9, 10,   1.15919490E+02,       9, 11,   7.69351800E+01,
     &  9, 12,   6.49700000E+01,       9, 13,   4.62200000E+01,
     &  9, 14,   3.36080000E+01,       9, 15,   1.67770010E+01,
     &  9, 16,   1.06802570E+01,       9, 17,   1.95170100E+00,
     &  9, 18,   8.73431000E-01,       9, 19,  -1.48740500E+00,
     &  9, 20,  -1.73960000E-02,       9, 21,  -4.75800000E-02,
     &  9, 22,   2.79378300E+00,       9, 23,   3.32951800E+00/
      data (niz(i),nia(i),bie(i),i= 181, 200)/
     &  9, 24,   7.54451400E+00,       9, 25,   1.12663840E+01,
     &  9, 26,   1.82881650E+01,       9, 27,   2.50500280E+01,
     &  9, 28,   3.32260000E+01,       9, 29,   4.02960000E+01,
     &  9, 30,   4.93200000E+01,       9, 31,   5.35500000E+01,
     &  9, 32,   6.33800000E+01,       9, 33,   7.20200000E+01,
     &  9, 34,   8.37900000E+01,       9, 35,   9.31200000E+01,
     &  9, 36,   1.04000000E+02,       9, 37,   1.10240000E+02,
     &  9, 38,   1.24510000E+02,       9, 39,   1.42260000E+02,
     & 10, 11,   1.35157770E+02,      10, 12,   9.04209200E+01,
     & 10, 13,   7.69500000E+01,      10, 14,   5.49400000E+01/
      data (niz(i),nia(i),bie(i),i= 201, 220)/
     & 10, 15,   4.19000000E+01,      10, 16,   2.39924010E+01,
     & 10, 17,   1.64851730E+01,      10, 18,   5.30678200E+00,
     & 10, 19,   1.75105900E+00,      10, 20,  -7.04193000E+00,
     & 10, 21,  -5.73172000E+00,      10, 22,  -8.02434400E+00,
     & 10, 23,  -5.15364100E+00,      10, 24,  -5.94751900E+00,
     & 10, 25,  -2.05869600E+00,      10, 26,   4.29882000E-01,
     & 10, 27,   7.09351200E+00,      10, 28,   1.12785950E+01,
     & 10, 29,   1.80205890E+01,      10, 30,   2.22366210E+01,
     & 10, 31,   3.08420000E+01,      10, 32,   3.71760000E+01,
     & 10, 33,   4.29600000E+01,      10, 34,   4.95600000E+01/
      data (niz(i),nia(i),bie(i),i= 221, 240)/
     & 10, 35,   6.08500000E+01,      10, 36,   6.87800000E+01,
     & 10, 37,   7.95900000E+01,      10, 38,   8.48500000E+01,
     & 10, 39,   9.88600000E+01,      10, 40,   1.07820000E+02,
     & 10, 41,   1.18930000E+02,      10, 42,   1.36980000E+02,
     & 10, 43,   1.50190000E+02,      10, 44,   1.60270000E+02,
     & 11, 13,   1.07980800E+02,      11, 14,   9.07149800E+01,
     & 11, 15,   6.87799700E+01,      11, 16,   5.44200000E+01,
     & 11, 17,   3.58400000E+01,      11, 18,   2.53180000E+01,
     & 11, 19,   1.29286220E+01,      11, 20,   6.84485900E+00,
     & 11, 21,  -2.18426100E+00,      11, 22,  -5.18210400E+00/
      data (niz(i),nia(i),bie(i),i= 241, 260)/
     & 11, 23,  -9.52948500E+00,      11, 24,  -8.41760100E+00,
     & 11, 25,  -9.35745900E+00,      11, 26,  -6.90246500E+00,
     & 11, 27,  -5.58085700E+00,      11, 28,  -1.03357600E+00,
     & 11, 29,   2.61871000E+00,      11, 30,   8.59441600E+00,
     & 11, 31,   1.26637600E+01,      11, 32,   1.83036610E+01,
     & 11, 33,   2.55098910E+01,      11, 34,   3.25090000E+01,
     & 11, 35,   4.11530000E+01,      11, 36,   4.53800000E+01,
     & 11, 37,   5.24100000E+01,      11, 38,   6.14400000E+01,
     & 11, 39,   6.87800000E+01,      11, 40,   8.01400000E+01,
     & 11, 41,   8.85100000E+01,      11, 42,   9.91500000E+01/
      data (niz(i),nia(i),bie(i),i= 261, 280)/
     & 11, 43,   1.07710000E+02,      11, 44,   1.18770000E+02,
     & 11, 45,   1.35070000E+02,      11, 46,   1.47330000E+02,
     & 11, 47,   1.57450000E+02,      12, 15,   1.04110960E+02,
     & 12, 16,   8.04900000E+01,      12, 17,   6.45100000E+01,
     & 12, 18,   4.38000000E+01,      12, 19,   3.25600000E+01,
     & 12, 20,   1.75705300E+01,      12, 21,   1.09116810E+01,
     & 12, 22,  -3.96766000E-01,      12, 23,  -5.47266600E+00,
     & 12, 24,  -1.39333810E+01,      12, 25,  -1.31927260E+01,
     & 12, 26,  -1.62144760E+01,      12, 27,  -1.45865030E+01,
     & 12, 28,  -1.50187520E+01,      12, 29,  -1.06611870E+01/
      data (niz(i),nia(i),bie(i),i= 281, 300)/
     & 12, 30,  -8.88223300E+00,      12, 31,  -3.21508900E+00,
     & 12, 32,  -7.95599000E-01,      12, 33,   5.20423300E+00,
     & 12, 34,   8.45092200E+00,      12, 35,   1.62920000E+01,
     & 12, 36,   2.09120000E+01,      12, 37,   2.91000000E+01,
     & 12, 38,   3.27400000E+01,      12, 39,   4.11200000E+01,
     & 12, 40,   4.54200000E+01,      12, 41,   5.81800000E+01,
     & 12, 42,   6.55200000E+01,      12, 43,   7.62800000E+01,
     & 12, 44,   7.80600000E+01,      12, 45,   9.53700000E+01,
     & 12, 46,   1.01100000E+02,      12, 47,   1.15530000E+02,
     & 12, 48,   1.28050000E+02,      12, 49,   1.40760000E+02/
      data (niz(i),nia(i),bie(i),i= 301, 320)/
     & 12, 50,   1.50570000E+02,      12, 51,   1.64010000E+02,
     & 12, 52,   1.74600000E+02,      12, 53,   1.88510000E+02,
     & 12, 54,   1.99250000E+02,      13, 17,   9.68002300E+01,
     & 13, 18,   7.86891000E+01,      13, 19,   5.72884900E+01,
     & 13, 20,   4.19600000E+01,      13, 21,   2.61190000E+01,
     & 13, 22,   1.81830000E+01,      13, 23,   6.76721000E+00,
     & 13, 24,  -5.50410000E-02,      13, 25,  -8.91574200E+00,
     & 13, 26,  -1.22103390E+01,      13, 27,  -1.71968290E+01,
     & 13, 28,  -1.68505520E+01,      13, 29,  -1.82155040E+01,
     & 13, 30,  -1.58723720E+01,      13, 31,  -1.49541810E+01/
      data (niz(i),nia(i),bie(i),i= 321, 340)/
     & 13, 32,  -1.10620680E+01,      13, 33,  -8.50492300E+00,
     & 13, 34,  -2.86224300E+00,      13, 35,  -5.80790000E-02,
     & 13, 36,   5.91638400E+00,      13, 37,   9.60370200E+00,
     & 13, 38,   1.57420000E+01,      13, 39,   2.04000000E+01,
     & 13, 40,   2.81500000E+01,      13, 41,   3.04300000E+01,
     & 13, 42,   4.11100000E+01,      13, 43,   4.94700000E+01,
     & 13, 44,   5.83800000E+01,      13, 45,   6.12200000E+01,
     & 13, 46,   7.62400000E+01,      13, 47,   8.47000000E+01,
     & 13, 48,   9.58300000E+01,      13, 49,   1.05020000E+02,
     & 13, 50,   1.15130000E+02,      13, 51,   1.23860000E+02/
      data (niz(i),nia(i),bie(i),i= 341, 360)/
     & 13, 52,   1.38520000E+02,      13, 53,   1.48750000E+02,
     & 13, 54,   1.61570000E+02,      13, 55,   1.72000000E+02,
     & 14, 19,   8.78900000E+01,      14, 20,   6.35900000E+01,
     & 14, 21,   4.94400000E+01,      14, 22,   3.21640000E+01,
     & 14, 23,   2.37720000E+01,      14, 24,   1.07547590E+01,
     & 14, 25,   3.82531000E+00,      14, 26,  -7.14461800E+00,
     & 14, 27,  -1.23844310E+01,      14, 28,  -2.14927930E+01,
     & 14, 29,  -2.18950250E+01,      14, 30,  -2.44328810E+01,
     & 14, 31,  -2.29489580E+01,      14, 32,  -2.40808590E+01,
     & 14, 33,  -2.04923810E+01,      14, 34,  -1.99565620E+01/
      data (niz(i),nia(i),bie(i),i= 361, 380)/
     & 14, 35,  -1.43597620E+01,      14, 36,  -1.24006390E+01,
     & 14, 37,  -6.52419200E+00,      14, 38,  -3.74460500E+00,
     & 14, 39,   2.14200000E+00,      14, 40,   5.40300000E+00,
     & 14, 41,   1.18300000E+01,      14, 42,   1.49970000E+01,
     & 14, 43,   2.26200000E+01,      14, 44,   2.91700000E+01,
     & 14, 45,   3.84400000E+01,      14, 46,   4.22800000E+01,
     & 14, 47,   5.52100000E+01,      14, 48,   6.26200000E+01,
     & 14, 49,   7.32600000E+01,      14, 50,   8.10300000E+01,
     & 14, 51,   9.20000000E+01,      14, 52,   9.91700000E+01,
     & 14, 53,   1.09510000E+02,      14, 54,   1.17750000E+02/
      data (niz(i),nia(i),bie(i),i= 381, 400)/
     & 14, 55,   1.32880000E+02,      14, 56,   1.42290000E+02,
     & 14, 57,   1.55230000E+02,      14, 58,   1.65020000E+02,
     & 14, 59,   1.78070000E+02,      14, 60,   1.88050000E+02,
     & 15, 22,   6.06500000E+01,      15, 23,   4.56600000E+01,
     & 15, 24,   3.19970000E+01,      15, 25,   1.88720000E+01,
     & 15, 26,   1.09730000E+01,      15, 27,  -7.52978000E-01,
     & 15, 28,  -7.16101800E+00,      15, 29,  -1.69519070E+01,
     & 15, 30,  -2.02005560E+01,      15, 31,  -2.44409910E+01,
     & 15, 32,  -2.43053180E+01,      15, 33,  -2.63377270E+01,
     & 15, 34,  -2.45575490E+01,      15, 35,  -2.48576130E+01/
      data (niz(i),nia(i),bie(i),i= 401, 420)/
     & 15, 36,  -2.02508400E+01,      15, 37,  -1.89947080E+01,
     & 15, 38,  -1.44661000E+01,      15, 39,  -1.26496870E+01,
     & 15, 40,  -8.33687000E+00,      15, 41,  -4.84376800E+00,
     & 15, 42,   8.40000000E-02,      15, 43,   3.08300000E+00,
     & 15, 44,   9.20300000E+00,      15, 45,   1.41030000E+01,
     & 15, 46,   2.21970000E+01,      15, 47,   2.91800000E+01,
     & 15, 48,   3.98100000E+01,      15, 49,   4.66000000E+01,
     & 15, 50,   5.65500000E+01,      15, 51,   6.43400000E+01,
     & 15, 52,   7.37400000E+01,      15, 53,   8.17100000E+01,
     & 15, 54,   9.10600000E+01,      15, 55,   9.88600000E+01/
      data (niz(i),nia(i),bie(i),i= 421, 440)/
     & 15, 56,   1.09640000E+02,      15, 57,   1.18580000E+02,
     & 15, 58,   1.31470000E+02,      15, 59,   1.40960000E+02,
     & 15, 60,   1.52840000E+02,      15, 61,   1.62700000E+02,
     & 16, 23,   7.15900000E+01,      16, 24,   5.57400000E+01,
     & 16, 25,   4.34000000E+01,      16, 26,   2.59700000E+01,
     & 16, 27,   1.75070000E+01,      16, 28,   4.07310700E+00,
     & 16, 29,  -3.15887800E+00,      16, 30,  -1.40628060E+01,
     & 16, 31,  -1.90449320E+01,      16, 32,  -2.60159810E+01,
     & 16, 33,  -2.65862350E+01,      16, 34,  -2.99318500E+01,
     & 16, 35,  -2.88463710E+01,      16, 36,  -3.06639580E+01/
      data (niz(i),nia(i),bie(i),i= 441, 460)/
     & 16, 37,  -2.68962180E+01,      16, 38,  -2.68610760E+01,
     & 16, 39,  -2.31613390E+01,      16, 40,  -2.28495440E+01,
     & 16, 41,  -1.86019320E+01,      16, 42,  -1.72419510E+01,
     & 16, 43,  -1.24820180E+01,      16, 44,  -1.08800000E+01,
     & 16, 45,  -4.82500000E+00,      16, 46,  -4.01000000E-01,
     & 16, 47,   7.09800000E+00,      16, 48,   1.21000000E+01,
     & 16, 49,   2.05020000E+01,      16, 50,   2.76500000E+01,
     & 16, 51,   3.76700000E+01,      16, 52,   4.44800000E+01,
     & 16, 53,   5.38700000E+01,      16, 54,   6.07400000E+01,
     & 16, 55,   7.06100000E+01,      16, 56,   7.76200000E+01/
      data (niz(i),nia(i),bie(i),i= 461, 480)/
     & 16, 57,   8.75700000E+01,      16, 58,   9.55500000E+01,
     & 16, 59,   1.08220000E+02,      16, 60,   1.17200000E+02,
     & 16, 61,   1.27730000E+02,      16, 62,   1.36410000E+02,
     & 16, 63,   1.48180000E+02,      16, 64,   1.56820000E+02,
     & 16, 65,   1.68880000E+02,      16, 66,   1.77830000E+02,
     & 16, 67,   1.91400000E+02,      16, 68,   2.03170000E+02,
     & 17, 25,   7.00200000E+01,      17, 26,   5.43100000E+01,
     & 17, 27,   3.92900000E+01,      17, 28,   2.65570000E+01,
     & 17, 29,   1.31430000E+01,      17, 30,   4.44300000E+00,
     & 17, 31,  -7.06443600E+00,      17, 32,  -1.33306940E+01/
      data (niz(i),nia(i),bie(i),i= 481, 500)/
     & 17, 33,  -2.10035120E+01,      17, 34,  -2.44405660E+01,
     & 17, 35,  -2.90135120E+01,      17, 36,  -2.95218860E+01,
     & 17, 37,  -3.17615190E+01,      17, 38,  -2.97979760E+01,
     & 17, 39,  -2.98006520E+01,      17, 40,  -2.75577280E+01,
     & 17, 41,  -2.73391480E+01,      17, 42,  -2.49873280E+01,
     & 17, 43,  -2.40293890E+01,      17, 44,  -1.99910580E+01,
     & 17, 45,  -1.89093250E+01,      17, 46,  -1.47920000E+01,
     & 17, 47,  -1.12250000E+01,      17, 48,  -4.79700000E+00,
     & 17, 49,  -1.02000000E-01,      17, 50,   7.20000000E+00,
     & 17, 51,   1.26030000E+01,      17, 52,   2.35600000E+01/
      data (niz(i),nia(i),bie(i),i= 501, 520)/
     & 17, 53,   3.02400000E+01,      17, 54,   3.87300000E+01,
     & 17, 55,   4.59000000E+01,      17, 56,   5.46600000E+01,
     & 17, 57,   6.17100000E+01,      17, 58,   6.94200000E+01,
     & 17, 59,   7.63300000E+01,      17, 60,   8.57500000E+01,
     & 17, 61,   9.24100000E+01,      17, 62,   1.02600000E+02,
     & 17, 63,   1.11670000E+02,      17, 64,   1.25790000E+02,
     & 17, 65,   1.34540000E+02,      17, 66,   1.45230000E+02,
     & 17, 67,   1.54200000E+02,      17, 68,   1.66890000E+02,
     & 17, 69,   1.78440000E+02,      18, 27,   6.47100000E+01,
     & 18, 28,   4.58100000E+01,      18, 29,   3.54100000E+01/
      data (niz(i),nia(i),bie(i),i= 521, 540)/
     & 18, 30,   2.00830000E+01,      18, 31,   1.12960000E+01,
     & 18, 32,  -2.17908100E+00,      18, 33,  -9.38133600E+00,
     & 18, 34,  -1.83782640E+01,      18, 35,  -2.30482080E+01,
     & 18, 36,  -3.02304390E+01,      18, 37,  -3.09480340E+01,
     & 18, 38,  -3.47147630E+01,      18, 39,  -3.32418360E+01,
     & 18, 40,  -3.50398900E+01,      18, 41,  -3.30672610E+01,
     & 18, 42,  -3.44220650E+01,      18, 43,  -3.19775310E+01,
     & 18, 44,  -3.22620390E+01,      18, 45,  -2.97193310E+01,
     & 18, 46,  -2.97207390E+01,      18, 47,  -2.59083480E+01,
     & 18, 48,  -2.32220000E+01,      18, 49,  -1.65990000E+01/
      data (niz(i),nia(i),bie(i),i= 541, 560)/
     & 18, 50,  -1.30970000E+01,      18, 51,  -6.29700000E+00,
     & 18, 52,  -1.70500000E+00,      18, 53,   5.80000000E+00,
     & 18, 54,   1.28600000E+01,      18, 55,   2.02200000E+01,
     & 18, 56,   2.49800000E+01,      18, 57,   3.41300000E+01,
     & 18, 58,   4.04900000E+01,      18, 59,   4.93100000E+01,
     & 18, 60,   5.55600000E+01,      18, 61,   6.43800000E+01,
     & 18, 62,   7.03200000E+01,      18, 63,   8.05700000E+01,
     & 18, 64,   8.83900000E+01,      18, 65,   9.94400000E+01,
     & 18, 66,   1.08940000E+02,      18, 67,   1.19560000E+02,
     & 18, 68,   1.29270000E+02,      18, 69,   1.41750000E+02/
      data (niz(i),nia(i),bie(i),i= 561, 580)/
     & 18, 70,   1.52300000E+02,      18, 71,   1.65190000E+02,
     & 18, 72,   1.76070000E+02,      18, 73,   1.89250000E+02,
     & 18, 74,   2.00310000E+02,      19, 29,   6.16300000E+01,
     & 19, 30,   4.80800000E+01,      19, 31,   3.21600000E+01,
     & 19, 32,   2.04180000E+01,      19, 33,   6.76300000E+00,
     & 19, 34,  -1.48100000E+00,      19, 35,  -1.11671070E+01,
     & 19, 36,  -1.74250780E+01,      19, 37,  -2.47992400E+01,
     & 19, 38,  -2.88016910E+01,      19, 39,  -3.38068360E+01,
     & 19, 40,  -3.35350160E+01,      19, 41,  -3.55588720E+01,
     & 19, 42,  -3.50213190E+01,      19, 43,  -3.65930420E+01/
      data (niz(i),nia(i),bie(i),i= 581, 600)/
     & 19, 44,  -3.58102140E+01,      19, 45,  -3.66080280E+01,
     & 19, 46,  -3.54189330E+01,      19, 47,  -3.56968870E+01,
     & 19, 48,  -3.21244790E+01,      19, 49,  -3.03200470E+01,
     & 19, 50,  -2.53526250E+01,      19, 51,  -2.20020000E+01,
     & 19, 52,  -1.61990000E+01,      19, 53,  -1.19980000E+01,
     & 19, 54,  -5.59800000E+00,      19, 55,  -5.70000000E-01,
     & 19, 56,   8.92000000E+00,      19, 57,   1.41100000E+01,
     & 19, 58,   2.19300000E+01,      19, 59,   2.70100000E+01,
     & 19, 60,   3.49200000E+01,      19, 61,   4.07800000E+01,
     & 19, 62,   4.89600000E+01,      19, 63,   5.55900000E+01/
      data (niz(i),nia(i),bie(i),i= 601, 620)/
     & 19, 64,   6.62100000E+01,      19, 65,   7.29800000E+01,
     & 19, 66,   8.24400000E+01,      19, 67,   8.98600000E+01,
     & 19, 68,   9.93900000E+01,      19, 69,   1.07000000E+02,
     & 19, 70,   1.17430000E+02,      19, 71,   1.30920000E+02,
     & 19, 72,   1.42730000E+02,      19, 73,   1.53510000E+02,
     & 19, 74,   1.65590000E+02,      19, 75,   1.76490000E+02,
     & 20, 29,   9.52800000E+01,      20, 30,   7.29400000E+01,
     & 20, 31,   5.87600000E+01,      20, 32,   4.08300000E+01,
     & 20, 33,   2.87800000E+01,      20, 34,   1.31530000E+01,
     & 20, 35,   4.43900000E+00,      20, 36,  -6.43919900E+00/
      data (niz(i),nia(i),bie(i),i= 621, 640)/
     & 20, 37,  -1.31606070E+01,      20, 38,  -2.20590440E+01,
     & 20, 39,  -2.72762560E+01,      20, 40,  -3.48461100E+01,
     & 20, 41,  -3.51374870E+01,      20, 42,  -3.85467650E+01,
     & 20, 43,  -3.84084420E+01,      20, 44,  -4.14690870E+01,
     & 20, 45,  -4.08125300E+01,      20, 46,  -4.31349110E+01,
     & 20, 47,  -4.23396940E+01,      20, 48,  -4.42147420E+01,
     & 20, 49,  -4.12900470E+01,      20, 50,  -3.95714560E+01,
     & 20, 51,  -3.58865110E+01,      20, 52,  -3.25091360E+01,
     & 20, 53,  -2.78980000E+01,      20, 54,  -2.35850000E+01,
     & 20, 55,  -1.81180000E+01,      20, 56,  -1.32370000E+01/
      data (niz(i),nia(i),bie(i),i= 641, 660)/
     & 20, 57,  -7.12000000E+00,      20, 58,  -1.99000000E+00,
     & 20, 59,   5.59000000E+00,      20, 60,   1.04700000E+01,
     & 20, 61,   1.77800000E+01,      20, 62,   2.31000000E+01,
     & 20, 63,   3.19400000E+01,      20, 64,   3.75300000E+01,
     & 20, 65,   4.63800000E+01,      20, 66,   5.24300000E+01,
     & 20, 67,   6.14700000E+01,      20, 68,   6.79000000E+01,
     & 20, 69,   7.72700000E+01,      20, 70,   8.36500000E+01,
     & 20, 71,   9.45800000E+01,      20, 72,   1.02730000E+02,
     & 20, 73,   1.13660000E+02,      20, 74,   1.28680000E+02,
     & 20, 75,   1.40600000E+02,      20, 76,   1.50400000E+02/
      data (niz(i),nia(i),bie(i),i= 661, 680)/
     & 20, 77,   1.63060000E+02,      20, 78,   1.73500000E+02,
     & 20, 79,   1.86600000E+02,      20, 80,   1.97210000E+02,
     & 21, 32,   7.07500000E+01,      21, 33,   5.42300000E+01,
     & 21, 34,   4.03700000E+01,      21, 35,   2.50500000E+01,
     & 21, 36,   1.38980000E+01,      21, 37,   2.84100000E+00,
     & 21, 38,  -4.93700000E+00,      21, 39,  -1.41680140E+01,
     & 21, 40,  -2.05263860E+01,      21, 41,  -2.86422110E+01,
     & 21, 42,  -3.21209250E+01,      21, 43,  -3.61876230E+01,
     & 21, 44,  -3.78158110E+01,      21, 45,  -4.10693380E+01,
     & 21, 46,  -4.17586370E+01,      21, 47,  -4.43316310E+01/
      data (niz(i),nia(i),bie(i),i= 681, 700)/
     & 21, 48,  -4.44928120E+01,      21, 49,  -4.65522770E+01,
     & 21, 50,  -4.45375080E+01,      21, 51,  -4.32188000E+01,
     & 21, 52,  -4.03802590E+01,      21, 53,  -3.79680000E+01,
     & 21, 54,  -3.44652730E+01,      21, 55,  -3.03390000E+01,
     & 21, 56,  -2.54670000E+01,      21, 57,  -2.13870000E+01,
     & 21, 58,  -1.57700000E+01,      21, 59,  -1.11400000E+01,
     & 21, 60,  -4.83000000E+00,      21, 61,  -1.02000000E+00,
     & 21, 62,   6.67000000E+00,      21, 63,   1.16800000E+01,
     & 21, 64,   1.89700000E+01,      21, 65,   2.43700000E+01,
     & 21, 66,   3.21600000E+01,      21, 67,   3.79600000E+01/
      data (niz(i),nia(i),bie(i),i= 701, 720)/
     & 21, 68,   4.60900000E+01,      21, 69,   5.23400000E+01,
     & 21, 70,   6.07600000E+01,      21, 71,   6.76200000E+01,
     & 21, 72,   7.70400000E+01,      21, 73,   8.49400000E+01,
     & 21, 74,   9.49000000E+01,      21, 75,   1.03720000E+02,
     & 21, 76,   1.14940000E+02,      21, 77,   1.30350000E+02,
     & 21, 78,   1.42110000E+02,      21, 79,   1.52460000E+02,
     & 21, 80,   1.64720000E+02,      21, 81,   1.75070000E+02,
     & 22, 31,   1.28670000E+02,      22, 32,   1.06590000E+02,
     & 22, 33,   8.97600000E+01,      22, 34,   6.34500000E+01,
     & 22, 35,   4.96400000E+01,      22, 36,   3.35300000E+01/
      data (niz(i),nia(i),bie(i),i= 721, 740)/
     & 22, 37,   2.26300000E+01,      22, 38,   9.10100000E+00,
     & 22, 39,   1.23200000E+00,      22, 40,  -8.85021000E+00,
     & 22, 41,  -1.57130000E+01,      22, 42,  -2.51208780E+01,
     & 22, 43,  -2.93203140E+01,      22, 44,  -3.75482990E+01,
     & 22, 45,  -3.90069120E+01,      22, 46,  -4.41253380E+01,
     & 22, 47,  -4.49317320E+01,      22, 48,  -4.84870000E+01,
     & 22, 49,  -4.85580400E+01,      22, 50,  -5.14258490E+01,
     & 22, 51,  -4.97268520E+01,      22, 52,  -4.94640240E+01,
     & 22, 53,  -4.68246040E+01,      22, 54,  -4.57642930E+01,
     & 22, 55,  -4.18054440E+01,      22, 56,  -3.91320570E+01/
      data (niz(i),nia(i),bie(i),i= 741, 760)/
     & 22, 57,  -3.45580000E+01,      22, 58,  -3.15680000E+01,
     & 22, 59,  -2.61190000E+01,      22, 60,  -2.26910000E+01,
     & 22, 61,  -1.67500000E+01,      22, 62,  -1.46800000E+01,
     & 22, 63,  -7.55000000E+00,      22, 64,  -4.07000000E+00,
     & 22, 65,   3.59000000E+00,      22, 66,   7.75000000E+00,
     & 22, 67,   1.54300000E+01,      22, 68,   2.04100000E+01,
     & 22, 69,   2.83900000E+01,      22, 70,   3.36500000E+01,
     & 22, 71,   4.18200000E+01,      22, 72,   4.74700000E+01,
     & 22, 73,   5.71600000E+01,      22, 74,   6.44300000E+01,
     & 22, 75,   7.46200000E+01,      22, 76,   8.27900000E+01/
      data (niz(i),nia(i),bie(i),i= 761, 780)/
     & 22, 77,   9.36900000E+01,      22, 78,   1.02380000E+02,
     & 22, 79,   1.11730000E+02,      22, 80,   1.20750000E+02,
     & 22, 81,   1.40780000E+02,      22, 82,   1.50390000E+02,
     & 23, 36,   6.25400000E+01,      23, 37,   4.57100000E+01,
     & 23, 38,   3.38400000E+01,      23, 39,   1.98600000E+01,
     & 23, 40,   1.03300000E+01,      23, 41,  -2.42000000E-01,
     & 23, 42,  -8.16900000E+00,      23, 43,  -1.80240000E+01,
     & 23, 44,  -2.38460000E+01,      23, 45,  -3.18735910E+01,
     & 23, 46,  -3.70739290E+01,      23, 47,  -4.20039290E+01,
     & 23, 48,  -4.44746590E+01,      23, 49,  -4.79561790E+01/
      data (niz(i),nia(i),bie(i),i= 781, 800)/
     & 23, 50,  -4.92175350E+01,      23, 51,  -5.21974930E+01,
     & 23, 52,  -5.14374090E+01,      23, 53,  -5.18446040E+01,
     & 23, 54,  -4.98867300E+01,      23, 55,  -4.91472980E+01,
     & 23, 56,  -4.62393550E+01,      23, 57,  -4.43763670E+01,
     & 23, 58,  -4.03802590E+01,      23, 59,  -3.79118000E+01,
     & 23, 60,  -3.30680320E+01,      23, 61,  -3.03570000E+01,
     & 23, 62,  -2.50200000E+01,      23, 63,  -2.16570000E+01,
     & 23, 64,  -1.68900000E+01,      23, 65,  -1.34900000E+01,
     & 23, 66,  -7.82000000E+00,      23, 67,  -3.08000000E+00,
     & 23, 68,   3.40000000E+00,      23, 69,   8.08000000E+00/
      data (niz(i),nia(i),bie(i),i= 801, 820)/
     & 23, 70,   1.51500000E+01,      23, 71,   2.04600000E+01,
     & 23, 72,   2.76300000E+01,      23, 73,   3.33200000E+01,
     & 23, 74,   4.20800000E+01,      23, 75,   4.94100000E+01,
     & 23, 76,   5.88500000E+01,      23, 77,   6.66800000E+01,
     & 23, 78,   7.63300000E+01,      23, 79,   8.44500000E+01,
     & 23, 80,   9.43300000E+01,      23, 81,   1.02910000E+02,
     & 23, 82,   1.13180000E+02,      23, 83,   1.22230000E+02,
     & 23, 84,   1.41150000E+02,      23, 85,   1.50570000E+02,
     & 24, 35,   1.19060000E+02,      24, 36,   9.64900000E+01,
     & 24, 37,   7.94900000E+01,      24, 38,   5.56500000E+01/
      data (niz(i),nia(i),bie(i),i= 821, 840)/
     & 24, 39,   4.33100000E+01,      24, 40,   2.80400000E+01,
     & 24, 41,   1.77000000E+01,      24, 42,   5.99000000E+00,
     & 24, 43,  -2.13600000E+00,      24, 44,  -1.35350000E+01,
     & 24, 45,  -1.94120000E+01,      24, 46,  -2.94709290E+01,
     & 24, 47,  -3.45523570E+01,      24, 48,  -4.28153130E+01,
     & 24, 49,  -4.53254340E+01,      24, 50,  -5.02544600E+01,
     & 24, 51,  -5.14447600E+01,      24, 52,  -5.54127970E+01,
     & 24, 53,  -5.52806380E+01,      24, 54,  -5.69283210E+01,
     & 24, 55,  -5.51032980E+01,      24, 56,  -5.52885960E+01,
     & 24, 57,  -5.23929900E+01,      24, 58,  -5.19307830E+01/
      data (niz(i),nia(i),bie(i),i= 841, 860)/
     & 24, 59,  -4.78508400E+01,      24, 60,  -4.68261960E+01,
     & 24, 61,  -4.27648830E+01,      24, 62,  -4.11720290E+01,
     & 24, 63,  -3.55270000E+01,      24, 64,  -3.33470000E+01,
     & 24, 65,  -2.76000000E+01,      24, 66,  -2.63300000E+01,
     & 24, 67,  -2.05000000E+01,      24, 68,  -1.73400000E+01,
     & 24, 69,  -1.10900000E+01,      24, 70,  -7.36000000E+00,
     & 24, 71,  -3.30000000E-01,      24, 72,   4.13000000E+00,
     & 24, 73,   1.12300000E+01,      24, 74,   1.60200000E+01,
     & 24, 75,   2.47300000E+01,      24, 76,   3.12100000E+01,
     & 24, 77,   4.04400000E+01,      24, 78,   4.72900000E+01/
      data (niz(i),nia(i),bie(i),i= 861, 880)/
     & 24, 79,   5.68500000E+01,      24, 80,   6.51400000E+01,
     & 24, 81,   7.48100000E+01,      24, 82,   8.25700000E+01,
     & 24, 83,   9.23600000E+01,      24, 84,   1.00530000E+02,
     & 24, 85,   1.10960000E+02,      24, 86,   1.19450000E+02,
     & 24, 87,   1.37750000E+02,      24, 88,   1.46240000E+02,
     & 25, 40,   5.60600000E+01,      25, 41,   4.01200000E+01,
     & 25, 42,   2.88400000E+01,      25, 43,   1.50200000E+01,
     & 25, 44,   6.39900000E+00,      25, 45,  -5.11400000E+00,
     & 25, 46,  -1.23700000E+01,      25, 47,  -2.22630000E+01,
     & 25, 48,  -2.89970000E+01,      25, 49,  -3.76105410E+01/
      data (niz(i),nia(i),bie(i),i= 881, 900)/
     & 25, 50,  -4.26214700E+01,      25, 51,  -4.82369560E+01,
     & 25, 52,  -5.07011370E+01,      25, 53,  -5.46836250E+01,
     & 25, 54,  -5.55512690E+01,      25, 55,  -5.77063840E+01,
     & 25, 56,  -5.69055510E+01,      25, 57,  -5.74848540E+01,
     & 25, 58,  -5.59022530E+01,      25, 59,  -5.54731000E+01,
     & 25, 60,  -5.29144420E+01,      25, 61,  -5.17351690E+01,
     & 25, 62,  -4.84656260E+01,      25, 63,  -4.67516770E+01,
     & 25, 64,  -4.31002210E+01,      25, 65,  -4.08925800E+01,
     & 25, 66,  -3.64960000E+01,      25, 67,  -3.37010000E+01,
     & 25, 68,  -2.92900000E+01,      25, 69,  -2.63900000E+01/
      data (niz(i),nia(i),bie(i),i= 901, 920)/
     & 25, 70,  -2.09400000E+01,      25, 71,  -1.74400000E+01,
     & 25, 72,  -1.15200000E+01,      25, 73,  -7.38000000E+00,
     & 25, 74,  -1.26000000E+00,      25, 75,   3.38000000E+00,
     & 25, 76,   1.13800000E+01,      25, 77,   1.79900000E+01,
     & 25, 78,   2.64600000E+01,      25, 79,   3.33500000E+01,
     & 25, 80,   4.22400000E+01,      25, 81,   4.94200000E+01,
     & 25, 82,   5.91600000E+01,      25, 83,   6.70000000E+01,
     & 25, 84,   7.61900000E+01,      25, 85,   8.38500000E+01,
     & 25, 86,   9.35400000E+01,      25, 87,   1.01790000E+02,
     & 25, 88,   1.11750000E+02,      25, 89,   1.19890000E+02/
      data (niz(i),nia(i),bie(i),i= 921, 940)/
     & 25, 90,   1.36310000E+02,      25, 91,   1.45190000E+02,
     & 26, 37,   1.50400000E+02,      26, 38,   1.25500000E+02,
     & 26, 39,   1.06580000E+02,      26, 40,   8.42100000E+01,
     & 26, 41,   6.85800000E+01,      26, 42,   4.94000000E+01,
     & 26, 43,   3.79900000E+01,      26, 44,   2.36200000E+01,
     & 26, 45,   1.35630000E+01,      26, 46,   7.55000000E-01,
     & 26, 47,  -6.62300000E+00,      26, 48,  -1.81080000E+01,
     & 26, 49,  -2.45820000E+01,      26, 50,  -3.44714990E+01,
     & 26, 51,  -4.02173070E+01,      26, 52,  -4.83291370E+01,
     & 26, 53,  -5.09412730E+01,      26, 54,  -5.62484100E+01/
      data (niz(i),nia(i),bie(i),i= 941, 960)/
     & 26, 55,  -5.74750070E+01,      26, 56,  -6.06010030E+01,
     & 26, 57,  -6.01757080E+01,      26, 58,  -6.21488440E+01,
     & 26, 59,  -6.06584210E+01,      26, 60,  -6.14069230E+01,
     & 26, 61,  -5.89174890E+01,      26, 62,  -5.88978960E+01,
     & 26, 63,  -5.57793040E+01,      26, 64,  -5.50792320E+01,
     & 26, 65,  -5.12880520E+01,      26, 66,  -5.03192980E+01,
     & 26, 67,  -4.65746930E+01,      26, 68,  -4.42370000E+01,
     & 26, 69,  -3.94020000E+01,      26, 70,  -3.82500000E+01,
     & 26, 71,  -3.30800000E+01,      26, 72,  -3.05600000E+01,
     & 26, 73,  -2.47400000E+01,      26, 74,  -2.16100000E+01/
      data (niz(i),nia(i),bie(i),i= 961, 980)/
     & 26, 75,  -1.55900000E+01,      26, 76,  -1.19800000E+01,
     & 26, 77,  -3.97000000E+00,      26, 78,   1.85000000E+00,
     & 26, 79,   1.00800000E+01,      26, 80,   1.65500000E+01,
     & 26, 81,   2.54900000E+01,      26, 82,   3.19800000E+01,
     & 26, 83,   4.11600000E+01,      26, 84,   4.85700000E+01,
     & 26, 85,   5.77700000E+01,      26, 86,   6.44500000E+01,
     & 26, 87,   7.40400000E+01,      26, 88,   8.16300000E+01,
     & 26, 89,   9.12200000E+01,      26, 90,   9.86800000E+01,
     & 26, 91,   1.09430000E+02,      26, 92,   1.16360000E+02,
     & 26, 93,   1.32820000E+02,      26, 94,   1.41260000E+02/
      data (niz(i),nia(i),bie(i),i= 981,1000)/
     & 26, 95,   1.52400000E+02,      26, 96,   1.61050000E+02,
     & 26, 97,   1.72400000E+02,      26, 98,   1.81420000E+02,
     & 26, 99,   1.93010000E+02,      26,100,   2.01850000E+02,
     & 27, 43,   6.43000000E+01,      27, 44,   5.05100000E+01,
     & 27, 45,   3.47200000E+01,      27, 46,   2.33300000E+01,
     & 27, 47,   9.58000000E+00,      27, 48,   1.63900000E+00,
     & 27, 49,  -9.57600000E+00,      27, 50,  -1.71950000E+01,
     & 27, 51,  -2.72740000E+01,      27, 52,  -3.39160000E+01,
     & 27, 53,  -4.26391450E+01,      27, 54,  -4.80053300E+01,
     & 27, 55,  -5.40237110E+01,      27, 56,  -5.60350030E+01/
      data (niz(i),nia(i),bie(i),i=1001,1020)/
     & 27, 57,  -5.93396660E+01,      27, 58,  -5.98414280E+01,
     & 27, 59,  -6.22236090E+01,      27, 60,  -6.16442180E+01,
     & 27, 61,  -6.28950420E+01,      27, 62,  -6.14280970E+01,
     & 27, 63,  -6.18370170E+01,      27, 64,  -5.97893090E+01,
     & 27, 65,  -5.91642220E+01,      27, 66,  -5.60522590E+01,
     & 27, 67,  -5.53214200E+01,      27, 68,  -5.18283180E+01,
     & 27, 69,  -5.10458640E+01,      27, 70,  -4.67520000E+01,
     & 27, 71,  -4.49630000E+01,      27, 72,  -4.06040000E+01,
     & 27, 73,  -3.88300000E+01,      27, 74,  -3.40200000E+01,
     & 27, 75,  -3.11700000E+01,      27, 76,  -2.60700000E+01/
      data (niz(i),nia(i),bie(i),i=1021,1040)/
     & 27, 77,  -2.24800000E+01,      27, 78,  -1.53600000E+01,
     & 27, 79,  -9.68000000E+00,      27, 80,  -2.05000000E+00,
     & 27, 81,   4.18000000E+00,      27, 82,   1.23400000E+01,
     & 27, 83,   1.87200000E+01,      27, 84,   2.74900000E+01,
     & 27, 85,   3.47800000E+01,      27, 86,   4.31100000E+01,
     & 27, 87,   4.99100000E+01,      27, 88,   5.86000000E+01,
     & 27, 89,   6.59600000E+01,      27, 90,   7.49600000E+01,
     & 27, 91,   8.21900000E+01,      27, 92,   9.22200000E+01,
     & 27, 93,   1.00320000E+02,      27, 94,   1.09530000E+02,
     & 27, 95,   1.17790000E+02,      27, 96,   1.27660000E+02/
      data (niz(i),nia(i),bie(i),i=1041,1060)/
     & 27, 97,   1.40170000E+02,      27, 98,   1.51050000E+02,
     & 27, 99,   1.59740000E+02,      27,100,   1.70400000E+02,
     & 27,101,   1.79260000E+02,      27,102,   1.89980000E+02,
     & 27,103,   1.98480000E+02,      28, 41,   1.35270000E+02,
     & 28, 42,   1.11150000E+02,      28, 43,   9.37200000E+01,
     & 28, 44,   7.44200000E+01,      28, 45,   6.01300000E+01,
     & 28, 46,   4.47300000E+01,      28, 47,   3.22000000E+01,
     & 28, 48,   1.75900000E+01,      28, 49,   7.83000000E+00,
     & 28, 50,  -3.79100000E+00,      28, 51,  -1.14390000E+01,
     & 28, 52,  -2.26540000E+01,      28, 53,  -2.93790000E+01/
      data (niz(i),nia(i),bie(i),i=1061,1080)/
     & 28, 54,  -3.92061030E+01,      28, 55,  -4.53299110E+01,
     & 28, 56,  -5.38996450E+01,      28, 57,  -5.60754750E+01,
     & 28, 58,  -6.02230140E+01,      28, 59,  -6.11511250E+01,
     & 28, 60,  -6.44681000E+01,      28, 61,  -6.42167750E+01,
     & 28, 62,  -6.67426880E+01,      28, 63,  -6.55092170E+01,
     & 28, 64,  -6.70959000E+01,      28, 65,  -6.51225870E+01,
     & 28, 66,  -6.60287260E+01,      28, 67,  -6.37424620E+01,
     & 28, 68,  -6.34860270E+01,      28, 69,  -6.03777210E+01,
     & 28, 70,  -5.94851980E+01,      28, 71,  -5.58896320E+01,
     & 28, 72,  -5.46786900E+01,      28, 73,  -5.02260000E+01/
      data (niz(i),nia(i),bie(i),i=1081,1100)/
     & 28, 74,  -4.85220000E+01,      28, 75,  -4.38080000E+01,
     & 28, 76,  -4.16100000E+01,      28, 77,  -3.64870000E+01,
     & 28, 78,  -3.37200000E+01,      28, 79,  -2.84900000E+01,
     & 28, 80,  -2.41200000E+01,      28, 81,  -1.62200000E+01,
     & 28, 82,  -1.11600000E+01,      28, 83,  -2.51000000E+00,
     & 28, 84,   3.21000000E+00,      28, 85,   1.16800000E+01,
     & 28, 86,   1.83500000E+01,      28, 87,   2.68100000E+01,
     & 28, 88,   3.28200000E+01,      28, 89,   4.14300000E+01,
     & 28, 90,   4.79200000E+01,      28, 91,   5.68300000E+01,
     & 28, 92,   6.35800000E+01,      28, 93,   7.30900000E+01/
      data (niz(i),nia(i),bie(i),i=1101,1120)/
     & 28, 94,   8.05700000E+01,      28, 95,   9.01400000E+01,
     & 28, 96,   9.74100000E+01,      28, 97,   1.07100000E+02,
     & 28, 98,   1.14880000E+02,      28, 99,   1.24740000E+02,
     & 28,100,   1.36000000E+02,      28,101,   1.46680000E+02,
     & 28,102,   1.54730000E+02,      28,103,   1.65170000E+02,
     & 28,104,   1.73140000E+02,      28,105,   1.83710000E+02,
     & 28,106,   1.92020000E+02,      28,107,   2.02840000E+02,
     & 28,108,   2.11160000E+02,      28,109,   2.21970000E+02,
     & 28,110,   2.30510000E+02,      28,111,   2.43280000E+02,
     & 28,112,   2.54180000E+02,      29, 48,   4.49700000E+01/
      data (niz(i),nia(i),bie(i),i=1121,1140)/
     & 29, 49,   2.96800000E+01,      29, 50,   1.91300000E+01,
     & 29, 51,   5.94000000E+00,      29, 52,  -2.62700000E+00,
     & 29, 53,  -1.34600000E+01,      29, 54,  -2.16940000E+01,
     & 29, 55,  -3.16240000E+01,      29, 56,  -3.86010000E+01,
     & 29, 57,  -4.73052680E+01,      29, 58,  -5.16599660E+01,
     & 29, 59,  -5.63515470E+01,      29, 60,  -5.83412090E+01,
     & 29, 61,  -6.19795700E+01,      29, 62,  -6.27945170E+01,
     & 29, 63,  -6.55761620E+01,      29, 64,  -6.54208020E+01,
     & 29, 65,  -6.72597190E+01,      29, 66,  -6.62543260E+01,
     & 29, 67,  -6.73001580E+01,      29, 68,  -6.55418870E+01/
      data (niz(i),nia(i),bie(i),i=1141,1160)/
     & 29, 69,  -6.57399170E+01,      29, 70,  -6.29603340E+01,
     & 29, 71,  -6.27642250E+01,      29, 72,  -6.00630000E+01,
     & 29, 73,  -5.91590000E+01,      29, 74,  -5.57030000E+01,
     & 29, 75,  -5.43060000E+01,      29, 76,  -5.03100000E+01,
     & 29, 77,  -4.84840000E+01,      29, 78,  -4.39570000E+01,
     & 29, 79,  -4.16560000E+01,      29, 80,  -3.54990000E+01,
     & 29, 81,  -3.21400000E+01,      29, 82,  -2.52900000E+01,
     & 29, 83,  -2.03300000E+01,      29, 84,  -1.31100000E+01,
     & 29, 85,  -7.67000000E+00,      29, 86,   4.00000000E-02,
     & 29, 87,   6.55000000E+00,      29, 88,   1.42600000E+01/
      data (niz(i),nia(i),bie(i),i=1161,1180)/
     & 29, 89,   1.99000000E+01,      29, 90,   2.78100000E+01,
     & 29, 91,   3.44000000E+01,      29, 92,   4.24900000E+01,
     & 29, 93,   4.91900000E+01,      29, 94,   5.82100000E+01,
     & 29, 95,   6.56700000E+01,      29, 96,   7.46400000E+01,
     & 29, 97,   8.18900000E+01,      29, 98,   9.09600000E+01,
     & 29, 99,   9.85100000E+01,      29,100,   1.08340000E+02,
     & 29,101,   1.16710000E+02,      29,102,   1.26400000E+02,
     & 29,103,   1.35260000E+02,      29,104,   1.45170000E+02,
     & 29,105,   1.53160000E+02,      29,106,   1.63130000E+02,
     & 29,107,   1.71330000E+02,      29,108,   1.81320000E+02/
      data (niz(i),nia(i),bie(i),i=1181,1200)/
     & 29,109,   1.89770000E+02,      29,110,   1.99580000E+02,
     & 29,111,   2.08270000E+02,      29,112,   2.20320000E+02,
     & 29,113,   2.31180000E+02,      29,114,   2.43320000E+02,
     & 30, 49,   5.46300000E+01,      30, 50,   3.87000000E+01,
     & 30, 51,   2.90400000E+01,      30, 52,   1.51800000E+01,
     & 30, 53,   6.18000000E+00,      30, 54,  -6.56700000E+00,
     & 30, 55,  -1.49230000E+01,      30, 56,  -2.57280000E+01,
     & 30, 57,  -3.26860000E+01,      30, 58,  -4.22931140E+01,
     & 30, 59,  -4.72574090E+01,      30, 60,  -5.41831060E+01,
     & 30, 61,  -5.63424250E+01,      30, 62,  -6.11673530E+01/
      data (niz(i),nia(i),bie(i),i=1201,1220)/
     & 30, 63,  -6.22092930E+01,      30, 64,  -6.59995280E+01,
     & 30, 65,  -6.59077750E+01,      30, 66,  -6.88963010E+01,
     & 30, 67,  -6.78771580E+01,      30, 68,  -7.00040300E+01,
     & 30, 69,  -6.84149280E+01,      30, 70,  -6.95594250E+01,
     & 30, 71,  -6.73216740E+01,      30, 72,  -6.81284160E+01,
     & 30, 73,  -6.54099940E+01,      30, 74,  -6.57091970E+01,
     & 30, 75,  -6.24684190E+01,      30, 76,  -6.20428880E+01,
     & 30, 77,  -5.86041380E+01,      30, 78,  -5.72220630E+01,
     & 30, 79,  -5.33980000E+01,      30, 80,  -5.17773450E+01,
     & 30, 81,  -4.61280000E+01,      30, 82,  -4.20660000E+01/
      data (niz(i),nia(i),bie(i),i=1221,1240)/
     & 30, 83,  -3.62600000E+01,      30, 84,  -3.21800000E+01,
     & 30, 85,  -2.52700000E+01,      30, 86,  -2.07200000E+01,
     & 30, 87,  -1.30000000E+01,      30, 88,  -7.58000000E+00,
     & 30, 89,   2.50000000E-01,      30, 90,   5.25000000E+00,
     & 30, 91,   1.33000000E+01,      30, 92,   1.91000000E+01,
     & 30, 93,   2.68900000E+01,      30, 94,   3.28700000E+01,
     & 30, 95,   4.16600000E+01,      30, 96,   4.84800000E+01,
     & 30, 97,   5.73300000E+01,      30, 98,   6.38400000E+01,
     & 30, 99,   7.24800000E+01,      30,100,   7.93800000E+01,
     & 30,101,   8.94100000E+01,      30,102,   9.71700000E+01/
      data (niz(i),nia(i),bie(i),i=1241,1260)/
     & 30,103,   1.06790000E+02,      30,104,   1.14540000E+02,
     & 30,105,   1.24360000E+02,      30,106,   1.32020000E+02,
     & 30,107,   1.41880000E+02,      30,108,   1.49250000E+02,
     & 30,109,   1.59370000E+02,      30,110,   1.66810000E+02,
     & 30,111,   1.76780000E+02,      30,112,   1.84740000E+02,
     & 30,113,   1.96740000E+02,      30,114,   2.06810000E+02,
     & 30,115,   2.18820000E+02,      30,116,   2.28930000E+02,
     & 30,117,   2.41280000E+02,      30,118,   2.51460000E+02,
     & 31, 53,   2.79000000E+01,      31, 54,   1.76400000E+01,
     & 31, 55,   4.68000000E+00,      31, 56,  -4.74100000E+00/
      data (niz(i),nia(i),bie(i),i=1261,1280)/
     & 31, 57,  -1.59010000E+01,      31, 58,  -2.39860000E+01,
     & 31, 59,  -3.41210000E+01,      31, 60,  -3.99980000E+01,
     & 31, 61,  -4.73480000E+01,      31, 62,  -5.19963530E+01,
     & 31, 63,  -5.66892930E+01,      31, 64,  -5.88347290E+01,
     & 31, 65,  -6.26529090E+01,      31, 66,  -6.37213010E+01,
     & 31, 67,  -6.68766810E+01,      31, 68,  -6.70829300E+01,
     & 31, 69,  -6.93209230E+01,      31, 70,  -6.89047050E+01,
     & 31, 71,  -7.01368210E+01,      31, 72,  -6.85864980E+01,
     & 31, 73,  -6.97038420E+01,      31, 74,  -6.80540110E+01,
     & 31, 75,  -6.84641980E+01,      31, 76,  -6.62028880E+01/
      data (niz(i),nia(i),bie(i),i=1281,1300)/
     & 31, 77,  -6.58741380E+01,      31, 78,  -6.36620630E+01,
     & 31, 79,  -6.24879890E+01,      31, 80,  -5.90677450E+01,
     & 31, 81,  -5.79827410E+01,      31, 82,  -5.29460000E+01,
     & 31, 83,  -4.94900000E+01,      31, 84,  -4.43950000E+01,
     & 31, 85,  -3.95800000E+01,      31, 86,  -3.33800000E+01,
     & 31, 87,  -2.89500000E+01,      31, 88,  -2.22900000E+01,
     & 31, 89,  -1.72600000E+01,      31, 90,  -1.01800000E+01,
     & 31, 91,  -5.34000000E+00,      31, 92,   1.79000000E+00,
     & 31, 93,   7.27000000E+00,      31, 94,   1.47700000E+01,
     & 31, 95,   2.09300000E+01,      31, 96,   2.91600000E+01/
      data (niz(i),nia(i),bie(i),i=1301,1320)/
     & 31, 97,   3.55300000E+01,      31, 98,   4.35900000E+01,
     & 31, 99,   5.00600000E+01,      31,100,   5.81500000E+01,
     & 31,101,   6.49000000E+01,      31,102,   7.38900000E+01,
     & 31,103,   8.15000000E+01,      31,104,   9.05700000E+01,
     & 31,105,   9.81800000E+01,      31,106,   1.07280000E+02,
     & 31,107,   1.14250000E+02,      31,108,   1.23360000E+02,
     & 31,109,   1.31100000E+02,      31,110,   1.40210000E+02,
     & 31,111,   1.47810000E+02,      31,112,   1.57040000E+02,
     & 31,113,   1.64960000E+02,      31,114,   1.76180000E+02,
     & 31,115,   1.86110000E+02,      31,116,   1.97500000E+02/
      data (niz(i),nia(i),bie(i),i=1321,1340)/
     & 31,117,   2.07580000E+02,      31,118,   2.19280000E+02,
     & 31,119,   2.29280000E+02,      32, 51,   8.15200000E+01,
     & 32, 52,   6.43100000E+01,      32, 53,   5.27600000E+01,
     & 32, 54,   3.79600000E+01,      32, 55,   2.74700000E+01,
     & 32, 56,   1.33500000E+01,      32, 57,   4.02000000E+00,
     & 32, 58,  -8.37400000E+00,      32, 59,  -1.70000000E+01,
     & 32, 60,  -2.77680000E+01,      32, 61,  -3.37290000E+01,
     & 32, 62,  -4.22430000E+01,      32, 63,  -4.69100000E+01,
     & 32, 64,  -5.44247290E+01,      32, 65,  -5.64105590E+01,
     & 32, 66,  -6.16213010E+01,      32, 67,  -6.26537530E+01/
      data (niz(i),nia(i),bie(i),i=1341,1360)/
     & 32, 68,  -6.69769550E+01,      32, 69,  -6.70936380E+01,
     & 32, 70,  -7.05603200E+01,      32, 71,  -6.99048970E+01,
     & 32, 72,  -7.25855570E+01,      32, 73,  -7.12971360E+01,
     & 32, 74,  -7.34220110E+01,      32, 75,  -7.18559080E+01,
     & 32, 76,  -7.32128880E+01,      32, 77,  -7.12141380E+01,
     & 32, 78,  -7.18620630E+01,      32, 79,  -6.94879890E+01,
     & 32, 80,  -6.94477450E+01,      32, 81,  -6.63027410E+01,
     & 32, 82,  -6.56234390E+01,      32, 83,  -6.10040000E+01,
     & 32, 84,  -5.83950000E+01,      32, 85,  -5.33840000E+01,
     & 32, 86,  -5.00490000E+01,      32, 87,  -4.33200000E+01/
      data (niz(i),nia(i),bie(i),i=1361,1380)/
     & 32, 88,  -3.96500000E+01,      32, 89,  -3.32000000E+01,
     & 32, 90,  -2.90700000E+01,      32, 91,  -2.21900000E+01,
     & 32, 92,  -1.78300000E+01,      32, 93,  -1.10300000E+01,
     & 32, 94,  -6.22000000E+00,      32, 95,   1.29000000E+00,
     & 32, 96,   6.61000000E+00,      32, 97,   1.45100000E+01,
     & 32, 98,   2.00000000E+01,      32, 99,   2.78500000E+01,
     & 32,100,   3.35200000E+01,      32,101,   4.15200000E+01,
     & 32,102,   4.77100000E+01,      32,103,   5.66000000E+01,
     & 32,104,   6.35400000E+01,      32,105,   7.24100000E+01,
     & 32,106,   7.93900000E+01,      32,107,   8.85200000E+01/
      data (niz(i),nia(i),bie(i),i=1381,1400)/
     & 32,108,   9.57700000E+01,      32,109,   1.04300000E+02,
     & 32,110,   1.11820000E+02,      32,111,   1.21120000E+02,
     & 32,112,   1.28930000E+02,      32,113,   1.36230000E+02,
     & 32,114,   1.43360000E+02,      32,115,   1.54430000E+02,
     & 32,116,   1.63750000E+02,      32,117,   1.75120000E+02,
     & 32,118,   1.84540000E+02,      32,119,   1.96050000E+02,
     & 32,120,   2.05360000E+02,      33, 57,   2.59900000E+01,
     & 33, 58,   1.54700000E+01,      33, 59,   2.86000000E+00,
     & 33, 60,  -6.39900000E+00,      33, 61,  -1.80520000E+01,
     & 33, 62,  -2.49640000E+01,      33, 63,  -3.38230000E+01/
      data (niz(i),nia(i),bie(i),i=1401,1420)/
     & 33, 64,  -3.95210000E+01,      33, 65,  -4.70560000E+01,
     & 33, 66,  -5.18210000E+01,      33, 67,  -5.66437530E+01,
     & 33, 68,  -5.88769550E+01,      33, 69,  -6.30806210E+01,
     & 33, 70,  -6.43403200E+01,      33, 71,  -6.78921870E+01,
     & 33, 72,  -6.82294590E+01,      33, 73,  -7.09562760E+01,
     & 33, 74,  -7.08595990E+01,      33, 75,  -7.30324570E+01,
     & 33, 76,  -7.22895750E+01,      33, 77,  -7.39161770E+01,
     & 33, 78,  -7.28162010E+01,      33, 79,  -7.36359890E+01,
     & 33, 80,  -7.21179670E+01,      33, 81,  -7.25327410E+01,
     & 33, 82,  -7.03234390E+01,      33, 83,  -6.98800880E+01/
      data (niz(i),nia(i),bie(i),i=1421,1440)/
     & 33, 84,  -6.60800000E+01,      33, 85,  -6.35190000E+01,
     & 33, 86,  -5.94010000E+01,      33, 87,  -5.62810000E+01,
     & 33, 88,  -5.16420000E+01,      33, 89,  -4.72920000E+01,
     & 33, 90,  -4.07700000E+01,      33, 91,  -3.68200000E+01,
     & 33, 92,  -3.07600000E+01,      33, 93,  -2.64600000E+01,
     & 33, 94,  -2.03300000E+01,      33, 95,  -1.56900000E+01,
     & 33, 96,  -8.95000000E+00,      33, 97,  -3.72000000E+00,
     & 33, 98,   3.21000000E+00,      33, 99,   8.52000000E+00,
     & 33,100,   1.55500000E+01,      33,101,   2.13500000E+01,
     & 33,102,   2.86900000E+01,      33,103,   3.46400000E+01/
      data (niz(i),nia(i),bie(i),i=1441,1460)/
     & 33,104,   4.28100000E+01,      33,105,   4.95500000E+01,
     & 33,106,   5.78600000E+01,      33,107,   6.47300000E+01,
     & 33,108,   7.30800000E+01,      33,109,   8.03400000E+01,
     & 33,110,   8.85900000E+01,      33,111,   9.61400000E+01,
     & 33,112,   1.04780000E+02,      33,113,   1.12340000E+02,
     & 33,114,   1.19060000E+02,      33,115,   1.26630000E+02,
     & 33,116,   1.35860000E+02,      33,117,   1.45150000E+02,
     & 33,118,   1.55860000E+02,      33,119,   1.65100000E+02,
     & 33,120,   1.75920000E+02,      33,121,   1.85060000E+02,
     & 34, 55,   8.00100000E+01,      34, 56,   6.38800000E+01/
      data (niz(i),nia(i),bie(i),i=1461,1480)/
     & 34, 57,   5.20700000E+01,      34, 58,   3.70800000E+01,
     & 34, 59,   2.50800000E+01,      34, 60,   1.13900000E+01,
     & 34, 61,   2.03000000E+00,      34, 62,  -9.77000000E+00,
     & 34, 63,  -1.69300000E+01,      34, 64,  -2.66500000E+01,
     & 34, 65,  -3.29190000E+01,      34, 66,  -4.17220000E+01,
     & 34, 67,  -4.64910000E+01,      34, 68,  -5.41480000E+01,
     & 34, 69,  -5.62974810E+01,      34, 70,  -6.19400000E+01,
     & 34, 71,  -6.30920000E+01,      34, 72,  -6.78944320E+01,
     & 34, 73,  -6.82162760E+01,      34, 74,  -7.22126070E+01,
     & 34, 75,  -7.21688180E+01,      34, 76,  -7.52515630E+01/
      data (niz(i),nia(i),bie(i),i=1481,1500)/
     & 34, 77,  -7.45990490E+01,      34, 78,  -7.70256730E+01,
     & 34, 79,  -7.59169340E+01,      34, 80,  -7.77594040E+01,
     & 34, 81,  -7.63890810E+01,      34, 82,  -7.75934390E+01,
     & 34, 83,  -7.53400880E+01,      34, 84,  -7.59497960E+01,
     & 34, 85,  -7.24286050E+01,      34, 86,  -7.05409450E+01,
     & 34, 87,  -6.65824840E+01,      34, 88,  -6.38781400E+01,
     & 34, 89,  -5.95970000E+01,      34, 90,  -5.64300000E+01,
     & 34, 91,  -5.08880000E+01,      34, 92,  -4.71990000E+01,
     & 34, 93,  -4.09400000E+01,      34, 94,  -3.75000000E+01,
     & 34, 95,  -3.15100000E+01,      34, 96,  -2.75600000E+01/
      data (niz(i),nia(i),bie(i),i=1501,1520)/
     & 34, 97,  -2.09500000E+01,      34, 98,  -1.64400000E+01,
     & 34, 99,  -9.67000000E+00,      34,100,  -5.36000000E+00,
     & 34,101,   1.57000000E+00,      34,102,   6.70000000E+00,
     & 34,103,   1.39000000E+01,      34,104,   1.92700000E+01,
     & 34,105,   2.73000000E+01,      34,106,   3.34300000E+01,
     & 34,107,   4.16200000E+01,      34,108,   4.77800000E+01,
     & 34,109,   5.62300000E+01,      34,110,   6.29000000E+01,
     & 34,111,   7.12900000E+01,      34,112,   7.77000000E+01,
     & 34,113,   8.64900000E+01,      34,114,   9.34900000E+01,
     & 34,115,   1.00310000E+02,      34,116,   1.07450000E+02/
      data (niz(i),nia(i),bie(i),i=1521,1540)/
     & 34,117,   1.17570000E+02,      34,118,   1.26430000E+02,
     & 34,119,   1.35130000E+02,      34,120,   1.43680000E+02,
     & 34,121,   1.54340000E+02,      34,122,   1.62930000E+02,
     & 34,123,   1.73740000E+02,      34,124,   1.82300000E+02,
     & 34,125,   1.93210000E+02,      34,126,   2.01980000E+02,
     & 35, 61,   2.39600000E+01,      35, 62,   1.41900000E+01,
     & 35, 63,   1.58000000E+00,      35, 64,  -6.60000000E+00,
     & 35, 65,  -1.67100000E+01,      35, 66,  -2.35800000E+01,
     & 35, 67,  -3.27980000E+01,      35, 68,  -3.88920000E+01,
     & 35, 69,  -4.64090000E+01,      35, 70,  -5.15900000E+01/
      data (niz(i),nia(i),bie(i),i=1541,1560)/
     & 35, 71,  -5.65920000E+01,      35, 72,  -5.91527700E+01,
     & 35, 73,  -6.35326420E+01,      35, 74,  -6.53059610E+01,
     & 35, 75,  -6.91388180E+01,      35, 76,  -7.02886880E+01,
     & 35, 77,  -7.32339330E+01,      35, 78,  -7.34518960E+01,
     & 35, 79,  -7.60679800E+01,      35, 80,  -7.58888490E+01,
     & 35, 81,  -7.79743630E+01,      35, 82,  -7.74959430E+01,
     & 35, 83,  -7.90091060E+01,      35, 84,  -7.77763040E+01,
     & 35, 85,  -7.86106050E+01,      35, 86,  -7.56399450E+01,
     & 35, 87,  -7.38574840E+01,      35, 88,  -7.07321400E+01,
     & 35, 89,  -6.85698150E+01,      35, 90,  -6.46130830E+01/
      data (niz(i),nia(i),bie(i),i=1561,1580)/
     & 35, 91,  -6.15109180E+01,      35, 92,  -5.65833540E+01,
     & 35, 93,  -5.30020000E+01,      35, 94,  -4.78040000E+01,
     & 35, 95,  -4.47100000E+01,      35, 96,  -3.95100000E+01,
     & 35, 97,  -3.57200000E+01,      35, 98,  -2.98300000E+01,
     & 35, 99,  -2.54600000E+01,      35,100,  -1.93800000E+01,
     & 35,101,  -1.49800000E+01,      35,102,  -8.72000000E+00,
     & 35,103,  -3.87000000E+00,      35,104,   2.81000000E+00,
     & 35,105,   8.15000000E+00,      35,106,   1.54800000E+01,
     & 35,107,   2.15000000E+01,      35,108,   2.91200000E+01,
     & 35,109,   3.54100000E+01,      35,110,   4.43400000E+01/
      data (niz(i),nia(i),bie(i),i=1581,1600)/
     & 35,111,   5.09600000E+01,      35,112,   5.71700000E+01,
     & 35,113,   6.37500000E+01,      35,114,   7.16600000E+01,
     & 35,115,   7.85400000E+01,      35,116,   8.45500000E+01,
     & 35,117,   9.15200000E+01,      35,118,   1.01170000E+02,
     & 35,119,   1.09960000E+02,      35,120,   1.20630000E+02,
     & 35,121,   1.29850000E+02,      35,122,   1.36190000E+02,
     & 35,123,   1.44640000E+02,      35,124,   1.54880000E+02,
     & 35,125,   1.63450000E+02,      35,126,   1.73730000E+02,
     & 35,127,   1.82610000E+02,      36, 59,   7.90800000E+01,
     & 36, 60,   6.26200000E+01,      36, 61,   5.01200000E+01/
      data (niz(i),nia(i),bie(i),i=1601,1620)/
     & 36, 62,   3.49200000E+01,      36, 63,   2.38400000E+01,
     & 36, 64,   1.02000000E+01,      36, 65,   1.72000000E+00,
     & 36, 66,  -9.41000000E+00,      36, 67,  -1.64400000E+01,
     & 36, 68,  -2.63900000E+01,      36, 69,  -3.23040000E+01,
     & 36, 70,  -4.09760000E+01,      36, 71,  -4.61000000E+01,
     & 36, 72,  -5.41127700E+01,      36, 73,  -5.68852910E+01,
     & 36, 74,  -6.21695540E+01,      36, 75,  -6.42415970E+01,
     & 36, 76,  -6.89787000E+01,      36, 77,  -7.01714070E+01,
     & 36, 78,  -7.41597000E+01,      36, 79,  -7.44422020E+01,
     & 36, 80,  -7.78933420E+01,      36, 81,  -7.76936500E+01/
      data (niz(i),nia(i),bie(i),i=1621,1640)/
     & 36, 82,  -8.05885630E+01,      36, 83,  -7.99818330E+01,
     & 36, 84,  -8.24310330E+01,      36, 85,  -8.14806050E+01,
     & 36, 86,  -8.32659450E+01,      36, 87,  -8.07099840E+01,
     & 36, 88,  -7.96921400E+01,      36, 89,  -7.67248150E+01,
     & 36, 90,  -7.49630830E+01,      36, 91,  -7.13129180E+01,
     & 36, 92,  -6.87882580E+01,      36, 93,  -6.40260010E+01,
     & 36, 94,  -6.11410000E+01,      36, 95,  -5.60390000E+01,
     & 36, 96,  -5.30300000E+01,      36, 97,  -4.79160000E+01,
     & 36, 98,  -4.60400000E+01,      36, 99,  -4.03100000E+01,
     & 36,100,  -3.67100000E+01,      36,101,  -3.07200000E+01/
      data (niz(i),nia(i),bie(i),i=1641,1660)/
     & 36,102,  -2.69300000E+01,      36,103,  -2.07700000E+01,
     & 36,104,  -1.67600000E+01,      36,105,  -1.00400000E+01,
     & 36,106,  -5.39000000E+00,      36,107,   1.82000000E+00,
     & 36,108,   7.40000000E+00,      36,109,   1.49100000E+01,
     & 36,110,   2.16500000E+01,      36,111,   2.96400000E+01,
     & 36,112,   3.56000000E+01,      36,113,   4.15000000E+01,
     & 36,114,   4.74000000E+01,      36,115,   5.52000000E+01,
     & 36,116,   6.11000000E+01,      36,117,   6.76400000E+01,
     & 36,118,   7.38300000E+01,      36,119,   8.34900000E+01,
     & 36,120,   9.17100000E+01,      36,121,   1.02130000E+02/
      data (niz(i),nia(i),bie(i),i=1661,1680)/
     & 36,122,   1.10810000E+02,      36,123,   1.21100000E+02,
     & 36,124,   1.30400000E+02,      36,125,   1.34580000E+02,
     & 36,126,   1.42510000E+02,      36,127,   1.52910000E+02,
     & 36,128,   1.61130000E+02,      36,129,   1.71480000E+02,
     & 36,130,   1.79970000E+02,      36,131,   1.90560000E+02,
     & 36,132,   1.99210000E+02,      36,133,   2.10130000E+02,
     & 36,134,   2.19380000E+02,      36,135,   2.30530000E+02,
     & 36,136,   2.40130000E+02,      37, 64,   3.65100000E+01,
     & 37, 65,   2.26000000E+01,      37, 66,   1.37000000E+01,
     & 37, 67,   2.21000000E+00,      37, 68,  -5.77000000E+00/
      data (niz(i),nia(i),bie(i),i=1681,1700)/
     & 37, 69,  -1.59200000E+01,      37, 70,  -2.33800000E+01,
     & 37, 71,  -3.23040000E+01,      37, 72,  -3.81170000E+01,
     & 37, 73,  -4.62340000E+01,      37, 74,  -5.17255040E+01,
     & 37, 75,  -5.72224140E+01,      37, 76,  -6.04805470E+01,
     & 37, 77,  -6.48258260E+01,      37, 78,  -6.69357660E+01,
     & 37, 79,  -7.07965890E+01,      37, 80,  -7.21727760E+01,
     & 37, 81,  -7.54564380E+01,      37, 82,  -7.61890340E+01,
     & 37, 83,  -7.90726960E+01,      37, 84,  -7.97501490E+01,
     & 37, 85,  -8.21676870E+01,      37, 86,  -8.27473190E+01,
     & 37, 87,  -8.45950450E+01,      37, 88,  -8.26062210E+01/
      data (niz(i),nia(i),bie(i),i=1701,1720)/
     & 37, 89,  -8.17106980E+01,      37, 90,  -7.93549480E+01,
     & 37, 91,  -7.77479180E+01,      37, 92,  -7.47752580E+01,
     & 37, 93,  -7.26260010E+01,      37, 94,  -6.85511240E+01,
     & 37, 95,  -6.58386760E+01,      37, 96,  -6.12140860E+01,
     & 37, 97,  -5.83647380E+01,      37, 98,  -5.43027790E+01,
     & 37, 99,  -5.08403610E+01,      37,100,  -4.66960000E+01,
     & 37,101,  -4.35976450E+01,      37,102,  -3.79960000E+01,
     & 37,103,  -3.51200000E+01,      37,104,  -2.95600000E+01,
     & 37,105,  -2.56500000E+01,      37,106,  -1.97400000E+01,
     & 37,107,  -1.49900000E+01,      37,108,  -8.65000000E+00/
      data (niz(i),nia(i),bie(i),i=1721,1740)/
     & 37,109,  -3.19000000E+00,      37,110,   4.03000000E+00,
     & 37,111,   1.05700000E+01,      37,112,   1.80100000E+01,
     & 37,113,   2.22600000E+01,      37,114,   2.91100000E+01,
     & 37,115,   3.48000000E+01,      37,116,   4.20100000E+01,
     & 37,117,   4.77900000E+01,      37,118,   5.37400000E+01,
     & 37,119,   5.97200000E+01,      37,120,   6.89000000E+01,
     & 37,121,   7.69700000E+01,      37,122,   8.69400000E+01,
     & 37,123,   9.54000000E+01,      37,124,   1.05340000E+02,
     & 37,125,   1.14480000E+02,      37,126,   1.25420000E+02,
     & 37,127,   1.33430000E+02,      37,128,   1.43150000E+02/
      data (niz(i),nia(i),bie(i),i=1741,1760)/
     & 37,129,   1.43600000E+02,      37,130,   1.53370000E+02,
     & 37,131,   1.61790000E+02,      37,132,   1.71790000E+02,
     & 37,133,   1.80540000E+02,      37,134,   1.91090000E+02,
     & 37,135,   2.00130000E+02,      37,136,   2.10960000E+02,
     & 37,137,   2.20340000E+02,      38, 63,   7.66400000E+01,
     & 38, 64,   5.99200000E+01,      38, 65,   4.75300000E+01,
     & 38, 66,   3.22700000E+01,      38, 67,   2.22300000E+01,
     & 38, 68,   1.05700000E+01,      38, 69,   2.43000000E+00,
     & 38, 70,  -8.72000000E+00,      38, 71,  -1.58500000E+01,
     & 38, 72,  -2.60700000E+01,      38, 73,  -3.16990000E+01/
      data (niz(i),nia(i),bie(i),i=1761,1780)/
     & 38, 74,  -4.06970000E+01,      38, 75,  -4.66490000E+01,
     & 38, 76,  -5.43900000E+01,      38, 77,  -5.79747700E+01,
     & 38, 78,  -6.31745080E+01,      38, 79,  -6.54774270E+01,
     & 38, 80,  -7.03048830E+01,      38, 81,  -7.15265300E+01,
     & 38, 82,  -7.60087270E+01,      38, 83,  -7.67969850E+01,
     & 38, 84,  -8.06442880E+01,      38, 85,  -8.11026650E+01,
     & 38, 86,  -8.45215630E+01,      38, 87,  -8.48783580E+01,
     & 38, 88,  -8.79196630E+01,      38, 89,  -8.62070500E+01,
     & 38, 90,  -8.59418630E+01,      38, 91,  -8.36389780E+01,
     & 38, 92,  -8.28751060E+01,      38, 93,  -8.00875980E+01/
      data (niz(i),nia(i),bie(i),i=1781,1800)/
     & 38, 94,  -7.88417740E+01,      38, 95,  -7.51173300E+01,
     & 38, 96,  -7.29541580E+01,      38, 97,  -6.87919790E+01,
     & 38, 98,  -6.66286590E+01,      38, 99,  -6.21166330E+01,
     & 38,100,  -6.02194680E+01,      38,101,  -5.54076450E+01,
     & 38,102,  -5.30776430E+01,      38,103,  -4.75530000E+01,
     & 38,104,  -4.44040000E+01,      38,105,  -4.00400000E+01,
     & 38,106,  -3.67400000E+01,      38,107,  -3.08600000E+01,
     & 38,108,  -2.68000000E+01,      38,109,  -2.03200000E+01,
     & 38,110,  -1.53400000E+01,      38,111,  -8.38000000E+00,
     & 38,112,  -2.73000000E+00,      38,113,   3.47000000E+00/
      data (niz(i),nia(i),bie(i),i=1801,1820)/
     & 38,114,   8.08000000E+00,      38,115,   1.48500000E+01,
     & 38,116,   2.00400000E+01,      38,117,   2.71800000E+01,
     & 38,118,   3.24000000E+01,      38,119,   3.82000000E+01,
     & 38,120,   4.36600000E+01,      38,121,   5.28500000E+01,
     & 38,122,   6.04100000E+01,      38,123,   6.99900000E+01,
     & 38,124,   7.81000000E+01,      38,125,   8.78800000E+01,
     & 38,126,   9.70400000E+01,      38,127,   1.07550000E+02,
     & 38,128,   1.14980000E+02,      38,129,   1.25010000E+02,
     & 38,130,   1.32790000E+02,      38,131,   1.42580000E+02,
     & 38,132,   1.41350000E+02,      38,133,   1.51450000E+02/
      data (niz(i),nia(i),bie(i),i=1821,1840)/
     & 38,134,   1.59820000E+02,      38,135,   1.70170000E+02,
     & 38,136,   1.78890000E+02,      38,137,   1.89500000E+02,
     & 38,138,   1.98280000E+02,      38,139,   2.09150000E+02,
     & 38,140,   2.18340000E+02,      38,141,   2.29340000E+02,
     & 38,142,   2.38760000E+02,      39, 68,   3.50700000E+01,
     & 39, 69,   2.31300000E+01,      39, 70,   1.37600000E+01,
     & 39, 71,   2.51000000E+00,      39, 72,  -5.78000000E+00,
     & 39, 73,  -1.60100000E+01,      39, 74,  -2.33500000E+01,
     & 39, 75,  -3.27700000E+01,      39, 76,  -3.91800000E+01,
     & 39, 77,  -4.69290000E+01,      39, 78,  -5.26290000E+01/
      data (niz(i),nia(i),bie(i),i=1841,1860)/
     & 39, 79,  -5.83574270E+01,      39, 80,  -6.11650000E+01,
     & 39, 81,  -6.60161640E+01,      39, 82,  -6.81927360E+01,
     & 39, 83,  -7.23281030E+01,      39, 84,  -7.41583060E+01,
     & 39, 85,  -7.78476650E+01,      39, 86,  -7.92815630E+01,
     & 39, 87,  -8.30167520E+01,      39, 88,  -8.42970630E+01,
     & 39, 89,  -8.77021010E+01,      39, 90,  -8.64878610E+01,
     & 39, 91,  -8.63463000E+01,      39, 92,  -8.48154670E+01,
     & 39, 93,  -8.42242010E+01,      39, 94,  -8.23496390E+01,
     & 39, 95,  -8.12041790E+01,      39, 96,  -7.83406950E+01,
     & 39, 97,  -7.62604550E+01,      39, 98,  -7.24520350E+01/
      data (niz(i),nia(i),bie(i),i=1861,1880)/
     & 39, 99,  -7.02022800E+01,      39,100,  -6.72944680E+01,
     & 39,101,  -6.49126450E+01,      39,102,  -6.18926430E+01,
     & 39,103,  -5.87400000E+01,      39,104,  -5.45390000E+01,
     & 39,105,  -5.11480000E+01,      39,106,  -4.63700000E+01,
     & 39,107,  -4.39200000E+01,      39,108,  -3.87800000E+01,
     & 39,109,  -3.48300000E+01,      39,110,  -2.89300000E+01,
     & 39,111,  -2.42000000E+01,      39,112,  -1.74300000E+01,
     & 39,113,  -1.27600000E+01,      39,114,  -6.44000000E+00,
     & 39,115,  -1.92000000E+00,      39,116,   4.09000000E+00,
     & 39,117,   9.15000000E+00,      39,118,   1.56600000E+01/
      data (niz(i),nia(i),bie(i),i=1881,1900)/
     & 39,119,   2.11000000E+01,      39,120,   2.63900000E+01,
     & 39,121,   3.14700000E+01,      39,122,   4.01700000E+01,
     & 39,123,   4.76500000E+01,      39,124,   5.67200000E+01,
     & 39,125,   6.47700000E+01,      39,126,   7.40500000E+01,
     & 39,127,   8.27900000E+01,      39,128,   9.27200000E+01,
     & 39,129,   1.00300000E+02,      39,130,   1.09440000E+02,
     & 39,131,   1.17400000E+02,      39,132,   1.26550000E+02,
     & 39,133,   1.34840000E+02,      39,134,   1.44500000E+02,
     & 39,135,   1.42850000E+02,      39,136,   1.52870000E+02,
     & 39,137,   1.61370000E+02,      39,138,   1.71370000E+02/
      data (niz(i),nia(i),bie(i),i=1901,1920)/
     & 39,139,   1.80210000E+02,      39,140,   1.90500000E+02,
     & 39,141,   1.99560000E+02,      39,142,   2.09960000E+02,
     & 39,143,   2.19300000E+02,      40, 67,   7.34300000E+01,
     & 40, 68,   5.73100000E+01,      40, 69,   4.61700000E+01,
     & 40, 70,   3.32200000E+01,      40, 71,   2.37000000E+01,
     & 40, 72,   1.13400000E+01,      40, 73,   2.98000000E+00,
     & 40, 74,  -8.30000000E+00,      40, 75,  -1.58400000E+01,
     & 40, 76,  -2.60700000E+01,      40, 77,  -3.26900000E+01,
     & 40, 78,  -4.18200000E+01,      40, 79,  -4.73570000E+01,
     & 40, 80,  -5.53770000E+01,      40, 81,  -5.88561640E+01/
      data (niz(i),nia(i),bie(i),i=1921,1940)/
     & 40, 82,  -6.41927360E+01,      40, 83,  -6.64601030E+01,
     & 40, 84,  -7.14920000E+01,      40, 85,  -7.31546650E+01,
     & 40, 86,  -7.78050270E+01,      40, 87,  -7.93478350E+01,
     & 40, 88,  -8.36237630E+01,      40, 89,  -8.48694160E+01,
     & 40, 90,  -8.87679380E+01,      40, 91,  -8.78911330E+01,
     & 40, 92,  -8.84545590E+01,      40, 93,  -8.71173790E+01,
     & 40, 94,  -8.72662890E+01,      40, 95,  -8.56576240E+01,
     & 40, 96,  -8.54406460E+01,      40, 97,  -8.29488610E+01,
     & 40, 98,  -8.12762240E+01,      40, 99,  -7.77694130E+01,
     & 40,100,  -7.66044680E+01,      40,101,  -7.34576450E+01/
      data (niz(i),nia(i),bie(i),i=1941,1960)/
     & 40,102,  -7.17426430E+01,      40,103,  -6.83743860E+01,
     & 40,104,  -6.63410000E+01,      40,105,  -6.23640000E+01,
     & 40,106,  -5.96990000E+01,      40,107,  -5.50890000E+01,
     & 40,108,  -5.19030000E+01,      40,109,  -4.79700000E+01,
     & 40,110,  -4.46200000E+01,      40,111,  -3.88600000E+01,
     & 40,112,  -3.48700000E+01,      40,113,  -2.81500000E+01,
     & 40,114,  -2.44300000E+01,      40,115,  -1.84900000E+01,
     & 40,116,  -1.45200000E+01,      40,117,  -8.54000000E+00,
     & 40,118,  -4.18000000E+00,      40,119,   2.25000000E+00,
     & 40,120,   7.10000000E+00,      40,121,   1.23600000E+01/
      data (niz(i),nia(i),bie(i),i=1961,1980)/
     & 40,122,   1.68100000E+01,      40,123,   2.55000000E+01,
     & 40,124,   3.23900000E+01,      40,125,   4.14400000E+01,
     & 40,126,   4.88700000E+01,      40,127,   5.85600000E+01,
     & 40,128,   6.67800000E+01,      40,129,   7.63800000E+01,
     & 40,130,   8.36200000E+01,      40,131,   9.24700000E+01,
     & 40,132,   1.00000000E+02,      40,133,   1.09240000E+02,
     & 40,134,   1.16910000E+02,      40,135,   1.26560000E+02,
     & 40,136,   1.34490000E+02,      40,137,   1.44180000E+02,
     & 40,138,   1.42070000E+02,      40,139,   1.52130000E+02,
     & 40,140,   1.60390000E+02,      40,141,   1.70540000E+02/
      data (niz(i),nia(i),bie(i),i=1981,2000)/
     & 40,142,   1.79000000E+02,      40,143,   1.89320000E+02,
     & 40,144,   1.98070000E+02,      40,145,   2.08350000E+02,
     & 40,146,   2.17580000E+02,      40,147,   2.28200000E+02,
     & 40,148,   2.37200000E+02,      41, 72,   3.64900000E+01,
     & 41, 73,   2.45100000E+01,      41, 74,   1.43900000E+01,
     & 41, 75,   3.47000000E+00,      41, 76,  -4.97000000E+00,
     & 41, 77,  -1.54600000E+01,      41, 78,  -2.29400000E+01,
     & 41, 79,  -3.24100000E+01,      41, 80,  -3.87100000E+01,
     & 41, 81,  -4.74600000E+01,      41, 82,  -5.29740000E+01,
     & 41, 83,  -5.89601030E+01,      41, 84,  -6.18790000E+01/
      data (niz(i),nia(i),bie(i),i=2001,2020)/
     & 41, 85,  -6.71546650E+01,      41, 86,  -6.98270270E+01,
     & 41, 87,  -7.41828350E+01,      41, 88,  -7.64240000E+01,
     & 41, 89,  -8.05784080E+01,      41, 90,  -8.26569380E+01,
     & 41, 91,  -8.66377430E+01,      41, 92,  -8.64489520E+01,
     & 41, 93,  -8.72087440E+01,      41, 94,  -8.63648910E+01,
     & 41, 95,  -8.67824600E+01,      41, 96,  -8.56042150E+01,
     & 41, 97,  -8.56069460E+01,      41, 98,  -8.35264120E+01,
     & 41, 99,  -8.23274170E+01,      41,100,  -7.99394680E+01,
     & 41,101,  -7.89426450E+01,      41,102,  -7.63476430E+01,
     & 41,103,  -7.53193860E+01,      41,104,  -7.22285330E+01/
      data (niz(i),nia(i),bie(i),i=2021,2040)/
     & 41,105,  -7.08549910E+01,      41,106,  -6.68910000E+01,
     & 41,107,  -6.49160000E+01,      41,108,  -6.05380000E+01,
     & 41,109,  -5.80970000E+01,      41,110,  -5.33930000E+01,
     & 41,111,  -5.07100000E+01,      41,112,  -4.56300000E+01,
     & 41,113,  -4.12000000E+01,      41,114,  -3.58700000E+01,
     & 41,115,  -3.22200000E+01,      41,116,  -2.70500000E+01,
     & 41,117,  -2.31400000E+01,      41,118,  -1.77900000E+01,
     & 41,119,  -1.34900000E+01,      41,120,  -7.74000000E+00,
     & 41,121,  -2.88000000E+00,      41,122,   1.44000000E+00,
     & 41,123,   6.15000000E+00,      41,124,   1.41400000E+01/
      data (niz(i),nia(i),bie(i),i=2041,2060)/
     & 41,125,   2.09700000E+01,      41,126,   2.95100000E+01,
     & 41,127,   3.67200000E+01,      41,128,   4.62000000E+01,
     & 41,129,   5.41100000E+01,      41,130,   6.30800000E+01,
     & 41,131,   7.02900000E+01,      41,132,   7.86900000E+01,
     & 41,133,   8.61000000E+01,      41,134,   9.48500000E+01,
     & 41,135,   1.02490000E+02,      41,136,   1.11560000E+02,
     & 41,137,   1.19430000E+02,      41,138,   1.28590000E+02,
     & 41,139,   1.36590000E+02,      41,140,   1.45830000E+02,
     & 41,141,   1.44420000E+02,      41,142,   1.53970000E+02,
     & 41,143,   1.62350000E+02,      41,144,   1.72070000E+02/
      data (niz(i),nia(i),bie(i),i=2061,2080)/
     & 41,145,   1.80730000E+02,      41,146,   1.90700000E+02,
     & 41,147,   1.99610000E+02,      41,148,   2.09640000E+02,
     & 41,149,   2.18770000E+02,      42, 70,   8.44400000E+01,
     & 42, 71,   7.21800000E+01,      42, 72,   5.80200000E+01,
     & 42, 73,   4.73100000E+01,      42, 74,   3.42500000E+01,
     & 42, 75,   2.45800000E+01,      42, 76,   1.22900000E+01,
     & 42, 77,   3.59000000E+00,      42, 78,  -7.05000000E+00,
     & 42, 79,  -1.41000000E+01,      42, 80,  -2.53700000E+01,
     & 42, 81,  -3.17600000E+01,      42, 82,  -3.95900000E+01,
     & 42, 83,  -4.77480000E+01,      42, 84,  -5.58060000E+01/
      data (niz(i),nia(i),bie(i),i=2081,2100)/
     & 42, 85,  -5.90660000E+01,      42, 86,  -6.45570270E+01,
     & 42, 87,  -6.76946110E+01,      42, 88,  -7.27005550E+01,
     & 42, 89,  -7.50033630E+01,      42, 90,  -8.01679380E+01,
     & 42, 91,  -8.22036310E+01,      42, 92,  -8.68054660E+01,
     & 42, 93,  -8.68038520E+01,      42, 94,  -8.84103380E+01,
     & 42, 95,  -8.77080770E+01,      42, 96,  -8.87910150E+01,
     & 42, 97,  -8.75408310E+01,      42, 98,  -8.81120110E+01,
     & 42, 99,  -8.59660800E+01,      42,100,  -8.61844680E+01,
     & 42,101,  -8.35116450E+01,      42,102,  -8.35576430E+01,
     & 42,103,  -8.08493860E+01,      42,104,  -8.03335330E+01/
      data (niz(i),nia(i),bie(i),i=2101,2120)/
     & 42,105,  -7.73399910E+01,      42,106,  -7.62574120E+01,
     & 42,107,  -7.29408840E+01,      42,108,  -7.11850000E+01,
     & 42,109,  -6.72450000E+01,      42,110,  -6.54560000E+01,
     & 42,111,  -6.10040000E+01,      42,112,  -5.88330000E+01,
     & 42,113,  -5.39990000E+01,      42,114,  -5.04700000E+01,
     & 42,115,  -4.55200000E+01,      42,116,  -4.25500000E+01,
     & 42,117,  -3.74300000E+01,      42,118,  -3.41200000E+01,
     & 42,119,  -2.88500000E+01,      42,120,  -2.51900000E+01,
     & 42,121,  -1.95700000E+01,      42,122,  -1.53400000E+01,
     & 42,123,  -1.10600000E+01,      42,124,  -7.17000000E+00/
      data (niz(i),nia(i),bie(i),i=2121,2140)/
     & 42,125,   7.70000000E-01,      42,126,   7.16000000E+00,
     & 42,127,   1.55700000E+01,      42,128,   2.23900000E+01,
     & 42,129,   3.22700000E+01,      42,130,   3.91500000E+01,
     & 42,131,   4.80700000E+01,      42,132,   5.48300000E+01,
     & 42,133,   6.33500000E+01,      42,134,   7.02400000E+01,
     & 42,135,   7.89800000E+01,      42,136,   8.61200000E+01,
     & 42,137,   9.51800000E+01,      42,138,   1.02500000E+02,
     & 42,139,   1.11680000E+02,      42,140,   1.19200000E+02,
     & 42,141,   1.28430000E+02,      42,142,   1.36030000E+02,
     & 42,143,   1.45190000E+02,      42,144,   1.52830000E+02/
      data (niz(i),nia(i),bie(i),i=2141,2160)/
     & 42,145,   1.53170000E+02,      42,146,   1.61520000E+02,
     & 42,147,   1.71170000E+02,      42,148,   1.79490000E+02,
     & 42,149,   1.89640000E+02,      42,150,   1.98130000E+02,
     & 42,151,   2.08540000E+02,      42,152,   2.17260000E+02,
     & 42,153,   2.27790000E+02,      42,154,   2.36880000E+02,
     & 43, 76,   3.70400000E+01,      43, 77,   2.48700000E+01,
     & 43, 78,   1.55500000E+01,      43, 79,   4.14000000E+00,
     & 43, 80,  -3.93000000E+00,      43, 81,  -1.41200000E+01,
     & 43, 82,  -2.12500000E+01,      43, 83,  -3.06500000E+01,
     & 43, 84,  -3.69500000E+01,      43, 85,  -4.75620000E+01/
      data (niz(i),nia(i),bie(i),i=2161,2180)/
     & 43, 86,  -5.32070000E+01,      43, 87,  -5.91220000E+01,
     & 43, 88,  -6.25680000E+01,      43, 89,  -6.74933630E+01,
     & 43, 90,  -7.12072750E+01,      43, 91,  -7.59836310E+01,
     & 43, 92,  -7.89351110E+01,      43, 93,  -8.36029970E+01,
     & 43, 94,  -8.41545930E+01,      43, 95,  -8.60174460E+01,
     & 43, 96,  -8.58177810E+01,      43, 97,  -8.72205740E+01,
     & 43, 98,  -8.64280130E+01,      43, 99,  -8.73233070E+01,
     & 43,100,  -8.60163840E+01,      43,101,  -8.63360860E+01,
     & 43,102,  -8.45675910E+01,      43,103,  -8.45993860E+01,
     & 43,104,  -8.24885330E+01,      43,105,  -8.22899910E+01/
      data (niz(i),nia(i),bie(i),i=2181,2200)/
     & 43,106,  -7.97774120E+01,      43,107,  -7.91008840E+01,
     & 43,108,  -7.59354040E+01,      43,109,  -7.48670000E+01,
     & 43,110,  -7.13620000E+01,      43,111,  -6.98150000E+01,
     & 43,112,  -6.59130000E+01,      43,113,  -6.39660000E+01,
     & 43,114,  -5.97270000E+01,      43,115,  -5.74920000E+01,
     & 43,116,  -5.19700000E+01,      43,117,  -4.90500000E+01,
     & 43,118,  -4.46000000E+01,      43,119,  -4.13900000E+01,
     & 43,120,  -3.66900000E+01,      43,121,  -3.31400000E+01,
     & 43,122,  -2.80900000E+01,      43,123,  -2.39500000E+01,
     & 43,124,  -2.02800000E+01,      43,125,  -1.65000000E+01/
      data (niz(i),nia(i),bie(i),i=2201,2220)/
     & 43,126,  -9.13000000E+00,      43,127,  -2.81000000E+00,
     & 43,128,   5.08000000E+00,      43,129,   1.20900000E+01,
     & 43,130,   2.10300000E+01,      43,131,   2.78300000E+01,
     & 43,132,   3.61800000E+01,      43,133,   4.29900000E+01,
     & 43,134,   5.09900000E+01,      43,135,   5.76900000E+01,
     & 43,136,   6.60400000E+01,      43,137,   7.31200000E+01,
     & 43,138,   8.16400000E+01,      43,139,   8.88300000E+01,
     & 43,140,   9.75400000E+01,      43,141,   1.05090000E+02,
     & 43,142,   1.13790000E+02,      43,143,   1.21320000E+02,
     & 43,144,   1.30060000E+02,      43,145,   1.37760000E+02/
      data (niz(i),nia(i),bie(i),i=2221,2240)/
     & 43,146,   1.47140000E+02,      43,147,   1.55860000E+02,
     & 43,148,   1.54460000E+02,      43,149,   1.62900000E+02,
     & 43,150,   1.72410000E+02,      43,151,   1.80760000E+02,
     & 43,152,   1.90510000E+02,      43,153,   1.99180000E+02,
     & 43,154,   2.09230000E+02,      43,155,   2.18300000E+02,
     & 43,156,   2.28750000E+02,      43,157,   2.37810000E+02,
     & 44, 74,   8.47800000E+01,      44, 75,   7.28300000E+01,
     & 44, 76,   5.84900000E+01,      44, 77,   4.78400000E+01,
     & 44, 78,   3.47600000E+01,      44, 79,   2.53600000E+01,
     & 44, 80,   1.34400000E+01,      44, 81,   4.83000000E+00/
      data (niz(i),nia(i),bie(i),i=2241,2260)/
     & 44, 82,  -6.24000000E+00,      44, 83,  -1.22400000E+01,
     & 44, 84,  -2.24400000E+01,      44, 85,  -2.89200000E+01,
     & 44, 86,  -3.84400000E+01,      44, 87,  -4.73390000E+01,
     & 44, 88,  -5.54980000E+01,      44, 89,  -5.95130000E+01,
     & 44, 90,  -6.54090000E+01,      44, 91,  -6.85789690E+01,
     & 44, 92,  -7.44080000E+01,      44, 93,  -7.72659970E+01,
     & 44, 94,  -8.25680170E+01,      44, 95,  -8.34499930E+01,
     & 44, 96,  -8.60721920E+01,      44, 97,  -8.61123720E+01,
     & 44, 98,  -8.82244740E+01,      44, 99,  -8.76169580E+01,
     & 44,100,  -8.92187950E+01,      44,101,  -8.79495840E+01/
      data (niz(i),nia(i),bie(i),i=2261,2280)/
     & 44,102,  -8.90978510E+01,      44,103,  -8.72589190E+01,
     & 44,104,  -8.80912390E+01,      44,105,  -8.59299910E+01,
     & 44,106,  -8.63244120E+01,      44,107,  -8.39208840E+01,
     & 44,108,  -8.36554040E+01,      44,109,  -8.08522090E+01,
     & 44,110,  -8.01399710E+01,      44,111,  -7.67920000E+01,
     & 44,112,  -7.58670000E+01,      44,113,  -7.21540000E+01,
     & 44,114,  -7.07940000E+01,      44,115,  -6.67790000E+01,
     & 44,116,  -6.50560000E+01,      44,117,  -6.07430000E+01,
     & 44,118,  -5.86560000E+01,      44,119,  -5.34100000E+01,
     & 44,120,  -5.08400000E+01,      44,121,  -4.63100000E+01/
      data (niz(i),nia(i),bie(i),i=2281,2300)/
     & 44,122,  -4.33700000E+01,      44,123,  -3.84500000E+01,
     & 44,124,  -3.58000000E+01,      44,125,  -3.16300000E+01,
     & 44,126,  -2.84300000E+01,      44,127,  -2.10800000E+01,
     & 44,128,  -1.53300000E+01,      44,129,  -7.50000000E+00,
     & 44,130,  -1.35000000E+00,      44,131,   7.72000000E+00,
     & 44,132,   1.42100000E+01,      44,133,   2.24900000E+01,
     & 44,134,   2.89400000E+01,      44,135,   3.70100000E+01,
     & 44,136,   4.32500000E+01,      44,137,   5.15600000E+01,
     & 44,138,   5.81100000E+01,      44,139,   6.65800000E+01,
     & 44,140,   7.32900000E+01,      44,141,   8.19200000E+01/
      data (niz(i),nia(i),bie(i),i=2301,2320)/
     & 44,142,   8.89200000E+01,      44,143,   9.76700000E+01,
     & 44,144,   1.04750000E+02,      44,145,   1.13570000E+02,
     & 44,146,   1.20760000E+02,      44,147,   1.30180000E+02,
     & 44,148,   1.38220000E+02,      44,149,   1.48070000E+02,
     & 44,150,   1.56120000E+02,      44,151,   1.53400000E+02,
     & 44,152,   1.61090000E+02,      44,153,   1.70780000E+02,
     & 44,154,   1.78970000E+02,      44,155,   1.89010000E+02,
     & 44,156,   1.97510000E+02,      44,157,   2.07860000E+02,
     & 44,158,   2.16560000E+02,      44,159,   2.27410000E+02,
     & 44,160,   2.36520000E+02,      44,161,   2.47490000E+02/
      data (niz(i),nia(i),bie(i),i=2321,2340)/
     & 44,162,   2.56830000E+02,      45, 80,   3.81000000E+01,
     & 45, 81,   2.59200000E+01,      45, 82,   1.67500000E+01,
     & 45, 83,   4.91000000E+00,      45, 84,  -2.38000000E+00,
     & 45, 85,  -1.27100000E+01,      45, 86,  -1.99300000E+01,
     & 45, 87,  -2.96600000E+01,      45, 88,  -3.61100000E+01,
     & 45, 89,  -4.71520000E+01,      45, 90,  -5.32160000E+01,
     & 45, 91,  -5.91030000E+01,      45, 92,  -6.33600000E+01,
     & 45, 93,  -6.91730000E+01,      45, 94,  -7.29380000E+01,
     & 45, 95,  -7.83399930E+01,      45, 96,  -7.96257600E+01,
     & 45, 97,  -8.25893720E+01,      45, 98,  -8.31670960E+01/
      data (niz(i),nia(i),bie(i),i=2341,2360)/
     & 45, 99,  -8.55743840E+01,      45,100,  -8.55887950E+01,
     & 45,101,  -8.74080990E+01,      45,102,  -8.67753180E+01,
     & 45,103,  -8.80222740E+01,      45,104,  -8.69500010E+01,
     & 45,105,  -8.78469090E+01,      45,106,  -8.63638120E+01,
     & 45,107,  -8.68613000E+01,      45,108,  -8.50167290E+01,
     & 45,109,  -8.50122090E+01,      45,110,  -8.29499710E+01,
     & 45,111,  -8.22880000E+01,      45,112,  -7.95370000E+01,
     & 45,113,  -7.87860000E+01,      45,114,  -7.55940000E+01,
     & 45,115,  -7.44033740E+01,      45,116,  -7.10610000E+01,
     & 45,117,  -6.95360000E+01,      45,118,  -6.57360000E+01/
      data (niz(i),nia(i),bie(i),i=2361,2380)/
     & 45,119,  -6.39380000E+01,      45,120,  -5.98210000E+01,
     & 45,121,  -5.76780000E+01,      45,122,  -5.28300000E+01,
     & 45,123,  -5.00500000E+01,      45,124,  -4.57100000E+01,
     & 45,125,  -4.31600000E+01,      45,126,  -3.95500000E+01,
     & 45,127,  -3.65000000E+01,      45,128,  -2.96200000E+01,
     & 45,129,  -2.40200000E+01,      45,130,  -1.67600000E+01,
     & 45,131,  -1.01700000E+01,      45,132,  -2.10000000E+00,
     & 45,133,   4.26000000E+00,      45,134,   1.20300000E+01,
     & 45,135,   1.83700000E+01,      45,136,   2.60700000E+01,
     & 45,137,   3.22000000E+01,      45,138,   3.98800000E+01/
      data (niz(i),nia(i),bie(i),i=2381,2400)/
     & 45,139,   4.64700000E+01,      45,140,   5.44100000E+01,
     & 45,141,   6.10100000E+01,      45,142,   6.91400000E+01,
     & 45,143,   7.60800000E+01,      45,144,   8.42400000E+01,
     & 45,145,   9.13300000E+01,      45,146,   9.97100000E+01,
     & 45,147,   1.06960000E+02,      45,148,   1.15860000E+02,
     & 45,149,   1.23930000E+02,      45,150,   1.33120000E+02,
     & 45,151,   1.41150000E+02,      45,152,   1.50340000E+02,
     & 45,153,   1.58340000E+02,      45,154,   1.54320000E+02,
     & 45,155,   1.62490000E+02,      45,156,   1.71960000E+02,
     & 45,157,   1.80380000E+02,      45,158,   1.90350000E+02/
      data (niz(i),nia(i),bie(i),i=2401,2420)/
     & 45,159,   1.99000000E+02,      45,160,   2.09370000E+02,
     & 45,161,   2.18390000E+02,      45,162,   2.28970000E+02,
     & 45,163,   2.38160000E+02,      46, 78,   8.50600000E+01,
     & 46, 79,   7.34100000E+01,      46, 80,   5.94100000E+01,
     & 46, 81,   4.89000000E+01,      46, 82,   3.59900000E+01,
     & 46, 83,   2.64300000E+01,      46, 84,   1.41100000E+01,
     & 46, 85,   5.58000000E+00,      46, 86,  -4.96000000E+00,
     & 46, 87,  -1.23500000E+01,      46, 88,  -2.28900000E+01,
     & 46, 89,  -2.95100000E+01,      46, 90,  -3.92300000E+01,
     & 46, 91,  -4.70590000E+01,      46, 92,  -5.54980000E+01/
      data (niz(i),nia(i),bie(i),i=2421,2440)/
     & 46, 93,  -5.96990000E+01,      46, 94,  -6.63500000E+01,
     & 46, 95,  -7.01510000E+01,      46, 96,  -7.61757600E+01,
     & 46, 97,  -7.77993720E+01,      46, 98,  -8.13000840E+01,
     & 46, 99,  -8.21877930E+01,      46,100,  -8.52274070E+01,
     & 46,101,  -8.54280990E+01,      46,102,  -8.79258330E+01,
     & 46,103,  -8.74791930E+01,      46,104,  -8.93908900E+01,
     & 46,105,  -8.84136280E+01,      46,106,  -8.99049120E+01,
     & 46,107,  -8.83722640E+01,      46,108,  -8.95217290E+01,
     & 46,109,  -8.76037050E+01,      46,110,  -8.83499710E+01,
     & 46,111,  -8.60290920E+01,      46,112,  -8.63371130E+01/
      data (niz(i),nia(i),bie(i),i=2441,2460)/
     & 46,113,  -8.36934690E+01,      46,114,  -8.34941530E+01,
     & 46,115,  -8.04033740E+01,      46,116,  -7.99610270E+01,
     & 46,117,  -7.65320000E+01,      46,118,  -7.54659860E+01,
     & 46,119,  -7.20230000E+01,      46,120,  -7.07660000E+01,
     & 46,121,  -6.69000000E+01,      46,122,  -6.53910000E+01,
     & 46,123,  -6.12360000E+01,      46,124,  -5.90400000E+01,
     & 46,125,  -5.51600000E+01,      46,126,  -5.33700000E+01,
     & 46,127,  -4.94500000E+01,      46,128,  -4.68400000E+01,
     & 46,129,  -4.02300000E+01,      46,130,  -3.52000000E+01,
     & 46,131,  -2.79300000E+01,      46,132,  -2.24000000E+01/
      data (niz(i),nia(i),bie(i),i=2461,2480)/
     & 46,133,  -1.39200000E+01,      46,134,  -7.99000000E+00,
     & 46,135,  -1.20000000E-01,      46,136,   5.60000000E+00,
     & 46,137,   1.34300000E+01,      46,138,   1.91200000E+01,
     & 46,139,   2.67600000E+01,      46,140,   3.26900000E+01,
     & 46,141,   4.06700000E+01,      46,142,   4.68400000E+01,
     & 46,143,   5.49500000E+01,      46,144,   6.13900000E+01,
     & 46,145,   6.95800000E+01,      46,146,   7.61700000E+01,
     & 46,147,   8.46200000E+01,      46,148,   9.14100000E+01,
     & 46,149,   1.00250000E+02,      46,150,   1.07690000E+02,
     & 46,151,   1.16860000E+02,      46,152,   1.24400000E+02/
      data (niz(i),nia(i),bie(i),i=2481,2500)/
     & 46,153,   1.33570000E+02,      46,154,   1.41030000E+02,
     & 46,155,   1.50230000E+02,      46,156,   1.57780000E+02,
     & 46,157,   1.53300000E+02,      46,158,   1.61340000E+02,
     & 46,159,   1.71260000E+02,      46,160,   1.79430000E+02,
     & 46,161,   1.89710000E+02,      46,162,   1.98340000E+02,
     & 46,163,   2.08770000E+02,      46,164,   2.17610000E+02,
     & 46,165,   2.28370000E+02,      46,166,   2.37430000E+02,
     & 46,167,   2.48380000E+02,      46,168,   2.57460000E+02,
     & 47, 84,   3.87000000E+01,      47, 85,   2.64500000E+01,
     & 47, 86,   1.67600000E+01,      47, 87,   5.57000000E+00/
      data (niz(i),nia(i),bie(i),i=2501,2520)/
     & 47, 88,  -2.49000000E+00,      47, 89,  -1.32200000E+01,
     & 47, 90,  -2.06600000E+01,      47, 91,  -3.05400000E+01,
     & 47, 92,  -3.72000000E+01,      47, 93,  -4.62500000E+01,
     & 47, 94,  -5.33000000E+01,      47, 95,  -6.01000000E+01,
     & 47, 96,  -6.45710000E+01,      47, 97,  -7.07940000E+01,
     & 47, 98,  -7.28800840E+01,      47, 99,  -7.67577930E+01,
     & 47,100,  -7.81808510E+01,      47,101,  -8.12242750E+01,
     & 47,102,  -8.19714630E+01,      47,103,  -8.47916010E+01,
     & 47,104,  -8.51122440E+01,      47,105,  -8.70683760E+01,
     & 47,106,  -8.69396470E+01,      47,107,  -8.84052690E+01/
      data (niz(i),nia(i),bie(i),i=2521,2540)/
     & 47,108,  -8.76035460E+01,      47,109,  -8.87196540E+01,
     & 47,110,  -8.74575300E+01,      47,111,  -8.82174250E+01,
     & 47,112,  -8.66250800E+01,      47,113,  -8.70334690E+01,
     & 47,114,  -8.49448750E+01,      47,115,  -8.49873740E+01,
     & 47,116,  -8.25680270E+01,      47,117,  -8.22656380E+01,
     & 47,118,  -7.95659860E+01,      47,119,  -7.85565620E+01,
     & 47,120,  -7.56479120E+01,      47,121,  -7.46582330E+01,
     & 47,122,  -7.14270000E+01,      47,123,  -6.99550000E+01,
     & 47,124,  -6.65740000E+01,      47,125,  -6.47020000E+01,
     & 47,126,  -6.10130000E+01,      47,127,  -5.87960000E+01/
      data (niz(i),nia(i),bie(i),i=2541,2560)/
     & 47,128,  -5.63100000E+01,      47,129,  -5.38100000E+01,
     & 47,130,  -4.77400000E+01,      47,131,  -4.27800000E+01,
     & 47,132,  -3.60600000E+01,      47,133,  -3.06400000E+01,
     & 47,134,  -2.25600000E+01,      47,135,  -1.69700000E+01,
     & 47,136,  -9.43000000E+00,      47,137,  -3.84000000E+00,
     & 47,138,   3.71000000E+00,      47,139,   9.47000000E+00,
     & 47,140,   1.65700000E+01,      47,141,   2.24100000E+01,
     & 47,142,   2.99000000E+01,      47,143,   3.60400000E+01,
     & 47,144,   4.36200000E+01,      47,145,   5.00000000E+01,
     & 47,146,   5.76900000E+01,      47,147,   6.42200000E+01/
      data (niz(i),nia(i),bie(i),i=2561,2580)/
     & 47,148,   7.22000000E+01,      47,149,   7.89700000E+01,
     & 47,150,   8.72600000E+01,      47,151,   9.45600000E+01,
     & 47,152,   1.03290000E+02,      47,153,   1.10720000E+02,
     & 47,154,   1.19380000E+02,      47,155,   1.26760000E+02,
     & 47,156,   1.35480000E+02,      47,157,   1.42970000E+02,
     & 47,158,   1.51650000E+02,      47,159,   1.59270000E+02,
     & 47,160,   1.68470000E+02,      47,161,   1.63540000E+02,
     & 47,162,   1.73430000E+02,      47,163,   1.81910000E+02,
     & 47,164,   1.91990000E+02,      47,165,   2.00720000E+02,
     & 47,166,   2.11040000E+02,      47,167,   2.20090000E+02/
      data (niz(i),nia(i),bie(i),i=2581,2600)/
     & 47,168,   2.30400000E+02,      47,169,   2.39630000E+02,
     & 48, 82,   8.56400000E+01,      48, 83,   7.40100000E+01,
     & 48, 84,   5.98400000E+01,      48, 85,   4.94900000E+01,
     & 48, 86,   3.60800000E+01,      48, 87,   2.62900000E+01,
     & 48, 88,   1.43000000E+01,      48, 89,   5.84000000E+00,
     & 48, 90,  -5.41000000E+00,      48, 91,  -1.30000000E+01,
     & 48, 92,  -2.37100000E+01,      48, 93,  -3.06000000E+01,
     & 48, 94,  -4.04400000E+01,      48, 95,  -4.66800000E+01,
     & 48, 96,  -5.61040000E+01,      48, 97,  -6.06030000E+01,
     & 48, 98,  -6.74600000E+01,      48, 99,  -6.98530000E+01/
      data (niz(i),nia(i),bie(i),i=2601,2620)/
     & 48,100,  -7.43050490E+01,      48,101,  -7.57477380E+01,
     & 48,102,  -7.93844630E+01,      48,103,  -8.06497140E+01,
     & 48,104,  -8.39759500E+01,      48,105,  -8.43301720E+01,
     & 48,106,  -8.71337920E+01,      48,107,  -8.69882690E+01,
     & 48,108,  -8.92525720E+01,      48,109,  -8.85053590E+01,
     & 48,110,  -9.03497080E+01,      48,111,  -8.92542250E+01,
     & 48,112,  -9.05810470E+01,      48,113,  -8.90499310E+01,
     & 48,114,  -9.00213170E+01,      48,115,  -8.80908590E+01,
     & 48,116,  -8.87197290E+01,      48,117,  -8.64256380E+01,
     & 48,118,  -8.67089040E+01,      48,119,  -8.39065620E+01/
      data (niz(i),nia(i),bie(i),i=2621,2640)/
     & 48,120,  -8.39729120E+01,      48,121,  -8.10582330E+01,
     & 48,122,  -8.05740000E+01,      48,123,  -7.73105670E+01,
     & 48,124,  -7.67101010E+01,      48,125,  -7.33577770E+01,
     & 48,126,  -7.23267760E+01,      48,127,  -6.85255120E+01,
     & 48,128,  -6.72905420E+01,      48,129,  -6.30990000E+01,
     & 48,130,  -6.14970000E+01,      48,131,  -5.70800000E+01,
     & 48,132,  -5.26800000E+01,      48,133,  -4.59300000E+01,
     & 48,134,  -4.10100000E+01,      48,135,  -3.39600000E+01,
     & 48,136,  -2.88500000E+01,      48,137,  -2.07600000E+01,
     & 48,138,  -1.54300000E+01,      48,139,  -7.49000000E+00/
      data (niz(i),nia(i),bie(i),i=2641,2660)/
     & 48,140,  -2.18000000E+00,      48,141,   4.90000000E+00,
     & 48,142,   1.02100000E+01,      48,143,   1.76900000E+01,
     & 48,144,   2.33200000E+01,      48,145,   3.09100000E+01,
     & 48,146,   3.67700000E+01,      48,147,   4.44400000E+01,
     & 48,148,   5.04700000E+01,      48,149,   5.83800000E+01,
     & 48,150,   6.47300000E+01,      48,151,   7.29200000E+01,
     & 48,152,   7.97300000E+01,      48,153,   8.83600000E+01,
     & 48,154,   9.53600000E+01,      48,155,   1.04010000E+02,
     & 48,156,   1.10900000E+02,      48,157,   1.19530000E+02,
     & 48,158,   1.26590000E+02,      48,159,   1.35280000E+02/
      data (niz(i),nia(i),bie(i),i=2661,2680)/
     & 48,160,   1.42500000E+02,      48,161,   1.51610000E+02,
     & 48,162,   1.59410000E+02,      48,163,   1.68360000E+02,
     & 48,164,   1.63450000E+02,      48,165,   1.73420000E+02,
     & 48,166,   1.81710000E+02,      48,167,   1.92020000E+02,
     & 48,168,   2.00420000E+02,      48,169,   2.10890000E+02,
     & 48,170,   2.19710000E+02,      48,171,   2.30250000E+02,
     & 48,172,   2.39420000E+02,      49, 88,   3.85400000E+01,
     & 49, 89,   2.63200000E+01,      49, 90,   1.71800000E+01,
     & 49, 91,   6.18000000E+00,      49, 92,  -3.38000000E+00,
     & 49, 93,  -1.43000000E+01,      49, 94,  -2.19800000E+01/
      data (niz(i),nia(i),bie(i),i=2681,2700)/
     & 49, 95,  -3.19900000E+01,      49, 96,  -3.90100000E+01,
     & 49, 97,  -4.82200000E+01,      49, 98,  -5.38030000E+01,
     & 49, 99,  -6.09100000E+01,      49,100,  -6.41342530E+01,
     & 49,101,  -6.84090000E+01,      49,102,  -7.01344630E+01,
     & 49,103,  -7.45997140E+01,      49,104,  -7.60672640E+01,
     & 49,105,  -7.94811720E+01,      49,106,  -8.06104220E+01,
     & 49,107,  -8.35622690E+01,      49,108,  -8.40955610E+01,
     & 49,109,  -8.64854060E+01,      49,110,  -8.64717080E+01,
     & 49,111,  -8.83888210E+01,      49,112,  -8.79951160E+01,
     & 49,113,  -8.93663810E+01,      49,114,  -8.85694570E+01/
      data (niz(i),nia(i),bie(i),i=2701,2720)/
     & 49,115,  -8.95367470E+01,      49,116,  -8.82497330E+01,
     & 49,117,  -8.89430100E+01,      49,118,  -8.72300940E+01,
     & 49,119,  -8.77035620E+01,      49,120,  -8.57332930E+01,
     & 49,121,  -8.58382330E+01,      49,122,  -8.35763270E+01,
     & 49,123,  -8.34255670E+01,      49,124,  -8.08761010E+01,
     & 49,125,  -8.04797770E+01,      49,126,  -7.78127760E+01,
     & 49,127,  -7.69935120E+01,      49,128,  -7.43605420E+01,
     & 49,129,  -7.29751310E+01,      49,130,  -6.99971610E+01,
     & 49,131,  -6.82157100E+01,      49,132,  -6.24855350E+01,
     & 49,133,  -5.74360000E+01,      49,134,  -5.15490000E+01/
      data (niz(i),nia(i),bie(i),i=2721,2740)/
     & 49,135,  -4.79200000E+01,      49,136,  -4.13500000E+01,
     & 49,137,  -3.62300000E+01,      49,138,  -2.88200000E+01,
     & 49,139,  -2.37500000E+01,      49,140,  -1.66300000E+01,
     & 49,141,  -1.05900000E+01,      49,142,  -3.98000000E+00,
     & 49,143,   1.39000000E+00,      49,144,   8.41000000E+00,
     & 49,145,   1.39400000E+01,      49,146,   2.10300000E+01,
     & 49,147,   2.68800000E+01,      49,148,   3.40400000E+01,
     & 49,149,   4.00400000E+01,      49,150,   4.74300000E+01,
     & 49,151,   5.37400000E+01,      49,152,   6.15200000E+01,
     & 49,153,   6.82400000E+01,      49,154,   7.62600000E+01/
      data (niz(i),nia(i),bie(i),i=2741,2760)/
     & 49,155,   8.30400000E+01,      49,156,   9.12400000E+01,
     & 49,157,   9.81700000E+01,      49,158,   1.06390000E+02,
     & 49,159,   1.13360000E+02,      49,160,   1.21890000E+02,
     & 49,161,   1.29260000E+02,      49,162,   1.37890000E+02,
     & 49,163,   1.45110000E+02,      49,164,   1.53620000E+02,
     & 49,165,   1.61200000E+02,      49,166,   1.69870000E+02,
     & 49,167,   1.66300000E+02,      49,168,   1.75970000E+02,
     & 49,169,   1.84530000E+02,      49,170,   1.94590000E+02,
     & 49,171,   2.03190000E+02,      49,172,   2.13360000E+02,
     & 49,173,   2.22390000E+02,      49,174,   2.32680000E+02/
      data (niz(i),nia(i),bie(i),i=2761,2780)/
     & 49,175,   2.42630000E+02,      50, 86,   8.57700000E+01,
     & 50, 87,   7.41500000E+01,      50, 88,   5.98400000E+01,
     & 50, 89,   4.90200000E+01,      50, 90,   3.61300000E+01,
     & 50, 91,   2.69200000E+01,      50, 92,   1.52200000E+01,
     & 50, 93,   6.44000000E+00,      50, 94,  -6.70000000E+00,
     & 50, 95,  -1.45200000E+01,      50, 96,  -2.53300000E+01,
     & 50, 97,  -3.25200000E+01,      50, 98,  -4.25800000E+01,
     & 50, 99,  -4.87300000E+01,      50,100,  -5.68640000E+01,
     & 50,101,  -5.95600000E+01,      50,102,  -6.47480000E+01,
     & 50,103,  -6.69460000E+01,      50,104,  -7.15522640E+01/
      data (niz(i),nia(i),bie(i),i=2781,2800)/
     & 50,105,  -7.32243510E+01,      50,106,  -7.74253300E+01,
     & 50,107,  -7.85559490E+01,      50,108,  -8.20037460E+01,
     & 50,109,  -8.26357280E+01,      50,110,  -8.58346560E+01,
     & 50,111,  -8.59439050E+01,      50,112,  -8.86588310E+01,
     & 50,113,  -8.83304210E+01,      50,114,  -9.05581420E+01,
     & 50,115,  -9.00326330E+01,      50,116,  -9.15247220E+01,
     & 50,117,  -9.03979720E+01,      50,118,  -9.16531020E+01,
     & 50,119,  -9.00671850E+01,      50,120,  -9.11032930E+01,
     & 50,121,  -8.92027700E+01,      50,122,  -8.99449180E+01,
     & 50,123,  -8.78194700E+01,      50,124,  -8.82361010E+01/
      data (niz(i),nia(i),bie(i),i=2801,2820)/
     & 50,125,  -8.58977770E+01,      50,126,  -8.60197760E+01,
     & 50,127,  -8.35075120E+01,      50,128,  -8.33361420E+01,
     & 50,129,  -8.06301310E+01,      50,130,  -8.02461610E+01,
     & 50,131,  -7.73893070E+01,      50,132,  -7.66205350E+01,
     & 50,133,  -7.09667120E+01,      50,134,  -6.66357400E+01,
     & 50,135,  -6.07990000E+01,      50,136,  -5.65040000E+01,
     & 50,137,  -5.04960000E+01,      50,138,  -4.57000000E+01,
     & 50,139,  -3.89200000E+01,      50,140,  -3.42000000E+01,
     & 50,141,  -2.67700000E+01,      50,142,  -2.19000000E+01,
     & 50,143,  -1.42400000E+01,      50,144,  -9.49000000E+00/
      data (niz(i),nia(i),bie(i),i=2821,2840)/
     & 50,145,  -2.50000000E+00,      50,146,   2.60000000E+00,
     & 50,147,   9.66000000E+00,      50,148,   1.50800000E+01,
     & 50,149,   2.22000000E+01,      50,150,   2.77100000E+01,
     & 50,151,   3.51000000E+01,      50,152,   4.09100000E+01,
     & 50,153,   4.86100000E+01,      50,154,   5.48700000E+01,
     & 50,155,   6.29000000E+01,      50,156,   6.92500000E+01,
     & 50,157,   7.74200000E+01,      50,158,   8.40400000E+01,
     & 50,159,   9.21800000E+01,      50,160,   9.87100000E+01,
     & 50,161,   1.07280000E+02,      50,162,   1.13940000E+02,
     & 50,163,   1.22460000E+02,      50,164,   1.29330000E+02/
      data (niz(i),nia(i),bie(i),i=2841,2860)/
     & 50,165,   1.37910000E+02,      50,166,   1.44770000E+02,
     & 50,167,   1.53390000E+02,      50,168,   1.60550000E+02,
     & 50,169,   1.69280000E+02,      50,170,   1.66310000E+02,
     & 50,171,   1.76160000E+02,      50,172,   1.84390000E+02,
     & 50,173,   1.94420000E+02,      50,174,   2.03150000E+02,
     & 50,175,   2.13490000E+02,      50,176,   2.22770000E+02,
     & 50,177,   2.34860000E+02,      50,178,   2.45510000E+02,
     & 51, 96,  -7.90000000E-01,      51, 97,  -1.23100000E+01,
     & 51, 98,  -2.02200000E+01,      51, 99,  -3.02900000E+01,
     & 51,100,  -3.73300000E+01,      51,101,  -4.66000000E+01/
      data (niz(i),nia(i),bie(i),i=2861,2880)/
     & 51,102,  -5.06600000E+01,      51,103,  -5.57780000E+01,
     & 51,104,  -5.93480000E+01,      51,105,  -6.37806950E+01,
     & 51,106,  -6.63570000E+01,      51,107,  -7.06540000E+01,
     & 51,108,  -7.25070000E+01,      51,109,  -7.62557280E+01,
     & 51,110,  -7.75350000E+01,      51,111,  -8.08440000E+01,
     & 51,112,  -8.16038550E+01,      51,113,  -8.44138910E+01,
     & 51,114,  -8.46766340E+01,      51,115,  -8.70026330E+01,
     & 51,116,  -8.68178030E+01,      51,117,  -8.86413380E+01,
     & 51,118,  -8.79964700E+01,      51,119,  -8.94732830E+01,
     & 51,120,  -8.84226930E+01,      51,121,  -8.95929010E+01/
      data (niz(i),nia(i),bie(i),i=2881,2900)/
     & 51,122,  -8.83285190E+01,      51,123,  -8.92224910E+01,
     & 51,124,  -8.76186180E+01,      51,125,  -8.82610890E+01,
     & 51,126,  -8.63977760E+01,      51,127,  -8.67085120E+01,
     & 51,128,  -8.46100750E+01,      51,129,  -8.46261310E+01,
     & 51,130,  -8.23939300E+01,      51,131,  -8.20213070E+01,
     & 51,132,  -7.97235350E+01,      51,133,  -7.89567120E+01,
     & 51,134,  -7.40057400E+01,      51,135,  -6.97055840E+01,
     & 51,136,  -6.45900000E+01,      51,137,  -6.02580000E+01,
     & 51,138,  -5.49950000E+01,      51,139,  -5.05710000E+01,
     & 51,140,  -4.37300000E+01,      51,141,  -3.92500000E+01/
      data (niz(i),nia(i),bie(i),i=2901,2920)/
     & 51,142,  -3.23600000E+01,      51,143,  -2.78600000E+01,
     & 51,144,  -2.16400000E+01,      51,145,  -1.69100000E+01,
     & 51,146,  -1.06100000E+01,      51,147,  -5.62000000E+00,
     & 51,148,   1.01000000E+00,      51,149,   6.28000000E+00,
     & 51,150,   1.29900000E+01,      51,151,   1.85100000E+01,
     & 51,152,   2.54100000E+01,      51,153,   3.11900000E+01,
     & 51,154,   3.83800000E+01,      51,155,   4.45800000E+01,
     & 51,156,   5.20900000E+01,      51,157,   5.84400000E+01,
     & 51,158,   6.61800000E+01,      51,159,   7.27700000E+01,
     & 51,160,   8.04800000E+01,      51,161,   8.71500000E+01/
      data (niz(i),nia(i),bie(i),i=2921,2940)/
     & 51,162,   9.51600000E+01,      51,163,   1.01880000E+02,
     & 51,164,   1.09920000E+02,      51,165,   1.16680000E+02,
     & 51,166,   1.24860000E+02,      51,167,   1.31610000E+02,
     & 51,168,   1.39890000E+02,      51,169,   1.47020000E+02,
     & 51,170,   1.55590000E+02,      51,171,   1.63200000E+02,
     & 51,172,   1.71460000E+02,      51,173,   1.70530000E+02,
     & 51,174,   1.80250000E+02,      51,175,   1.89040000E+02,
     & 51,176,   1.98710000E+02,      51,177,   2.07980000E+02,
     & 51,178,   2.19700000E+02,      51,179,   2.30300000E+02,
     & 51,180,   2.42200000E+02,      51,181,   2.52690000E+02/
      data (niz(i),nia(i),bie(i),i=2941,2960)/
     & 52, 95,   3.12800000E+01,      52, 96,   1.91400000E+01,
     & 52, 97,   1.02600000E+01,      52, 98,  -8.40000000E-01,
     & 52, 99,  -1.00200000E+01,      52,100,  -2.10900000E+01,
     & 52,101,  -2.79200000E+01,      52,102,  -3.80300000E+01,
     & 52,103,  -4.24200000E+01,      52,104,  -4.93300000E+01,
     & 52,105,  -5.22600000E+01,      52,106,  -5.80300000E+01,
     & 52,107,  -6.05130000E+01,      52,108,  -6.56825770E+01,
     & 52,109,  -6.75738400E+01,      52,110,  -7.22772500E+01,
     & 52,111,  -7.34756870E+01,      52,112,  -7.72565940E+01,
     & 52,113,  -7.83140000E+01,      52,114,  -8.19190000E+01/
      data (niz(i),nia(i),bie(i),i=2961,2980)/
     & 52,115,  -8.23639660E+01,      52,116,  -8.53059720E+01,
     & 52,117,  -8.51067000E+01,      52,118,  -8.77232600E+01,
     & 52,119,  -8.71802710E+01,      52,120,  -8.94048820E+01,
     & 52,121,  -8.85572940E+01,      52,122,  -9.03110640E+01,
     & 52,123,  -8.91691580E+01,      52,124,  -9.05230710E+01,
     & 52,125,  -8.90277890E+01,      52,126,  -9.00702930E+01,
     & 52,127,  -8.82895120E+01,      52,128,  -8.89936350E+01,
     & 52,129,  -8.70056310E+01,      52,130,  -8.73529300E+01,
     & 52,131,  -8.52113070E+01,      52,132,  -8.52095350E+01,
     & 52,133,  -8.29597120E+01,      52,134,  -8.23994380E+01/
      data (niz(i),nia(i),bie(i),i=2981,3000)/
     & 52,135,  -7.78255840E+01,      52,136,  -7.44234200E+01,
     & 52,137,  -6.95595190E+01,      52,138,  -6.59310000E+01,
     & 52,139,  -6.07990000E+01,      52,140,  -5.71010000E+01,
     & 52,141,  -5.18000000E+01,      52,142,  -4.79720000E+01,
     & 52,143,  -4.03900000E+01,      52,144,  -3.65100000E+01,
     & 52,145,  -3.04300000E+01,      52,146,  -2.62100000E+01,
     & 52,147,  -1.99700000E+01,      52,148,  -1.55000000E+01,
     & 52,149,  -9.02000000E+00,      52,150,  -4.24000000E+00,
     & 52,151,   2.49000000E+00,      52,152,   7.53000000E+00,
     & 52,153,   1.43700000E+01,      52,154,   1.96200000E+01/
      data (niz(i),nia(i),bie(i),i=3001,3020)/
     & 52,155,   2.66600000E+01,      52,156,   3.24100000E+01,
     & 52,157,   3.99300000E+01,      52,158,   4.58500000E+01,
     & 52,159,   5.35700000E+01,      52,160,   5.97100000E+01,
     & 52,161,   6.74500000E+01,      52,162,   7.36900000E+01,
     & 52,163,   8.15600000E+01,      52,164,   8.79100000E+01,
     & 52,165,   9.60700000E+01,      52,166,   1.02400000E+02,
     & 52,167,   1.10500000E+02,      52,168,   1.17150000E+02,
     & 52,169,   1.25080000E+02,      52,170,   1.31850000E+02,
     & 52,171,   1.40560000E+02,      52,172,   1.47230000E+02,
     & 52,173,   1.55800000E+02,      52,174,   1.62510000E+02/
      data (niz(i),nia(i),bie(i),i=3021,3040)/
     & 52,175,   1.70640000E+02,      52,176,   1.77490000E+02,
     & 52,177,   1.82820000E+02,      52,178,   1.91710000E+02,
     & 52,179,   2.03380000E+02,      52,180,   2.13560000E+02,
     & 52,181,   2.25100000E+02,      52,182,   2.35270000E+02,
     & 52,183,   2.47450000E+02,      53,100,   3.26000000E+00,
     & 53,101,  -8.07000000E+00,      53,102,  -1.58300000E+01,
     & 53,103,  -2.56000000E+01,      53,104,  -3.12300000E+01,
     & 53,105,  -3.84400000E+01,      53,106,  -4.24500000E+01,
     & 53,107,  -4.85200000E+01,      53,108,  -5.28240000E+01,
     & 53,109,  -5.75740910E+01,      53,110,  -6.03480000E+01/
      data (niz(i),nia(i),bie(i),i=3041,3060)/
     & 53,111,  -6.49470000E+01,      53,112,  -6.70960000E+01,
     & 53,113,  -7.11249170E+01,      53,114,  -7.27960000E+01,
     & 53,115,  -7.64590000E+01,      53,116,  -7.75608230E+01,
     & 53,117,  -8.04366450E+01,      53,118,  -8.06904420E+01,
     & 53,119,  -8.36659990E+01,      53,120,  -8.37898820E+01,
     & 53,121,  -8.62879430E+01,      53,122,  -8.60770640E+01,
     & 53,123,  -8.79349360E+01,      53,124,  -8.73634840E+01,
     & 53,125,  -8.88420190E+01,      53,126,  -8.79149620E+01,
     & 53,127,  -8.89870800E+01,      53,128,  -8.77418270E+01,
     & 53,129,  -8.85035730E+01,      53,130,  -8.69325800E+01/
      data (niz(i),nia(i),bie(i),i=3061,3080)/
     & 53,131,  -8.74447610E+01,      53,132,  -8.57025350E+01,
     & 53,133,  -8.58777120E+01,      53,134,  -8.39494380E+01,
     & 53,135,  -8.37875840E+01,      53,136,  -7.94982460E+01,
     & 53,137,  -7.65011190E+01,      53,138,  -7.22991390E+01,
     & 53,139,  -6.88435420E+01,      53,140,  -6.40770000E+01,
     & 53,141,  -6.07050000E+01,      53,142,  -5.57220000E+01,
     & 53,143,  -5.20980000E+01,      53,144,  -4.69380000E+01,
     & 53,145,  -4.15500000E+01,      53,146,  -3.61400000E+01,
     & 53,147,  -3.19700000E+01,      53,148,  -2.63000000E+01,
     & 53,149,  -2.19100000E+01,      53,150,  -1.59100000E+01/
      data (niz(i),nia(i),bie(i),i=3081,3100)/
     & 53,151,  -1.12400000E+01,      53,152,  -5.16000000E+00,
     & 53,153,  -1.80000000E-01,      53,154,   6.12000000E+00,
     & 53,155,   1.13400000E+01,      53,156,   1.77800000E+01,
     & 53,157,   2.34700000E+01,      53,158,   3.05400000E+01,
     & 53,159,   3.64100000E+01,      53,160,   4.36300000E+01,
     & 53,161,   4.96700000E+01,      53,162,   5.70100000E+01,
     & 53,163,   6.31600000E+01,      53,164,   7.06800000E+01,
     & 53,165,   7.71600000E+01,      53,166,   8.48100000E+01,
     & 53,167,   9.12500000E+01,      53,168,   9.88300000E+01,
     & 53,169,   1.05500000E+02,      53,170,   1.13350000E+02/
      data (niz(i),nia(i),bie(i),i=3101,3120)/
     & 53,171,   1.19750000E+02,      53,172,   1.28000000E+02,
     & 53,173,   1.34850000E+02,      53,174,   1.42970000E+02,
     & 53,175,   1.49800000E+02,      53,176,   1.57410000E+02,
     & 53,177,   1.64260000E+02,      53,178,   1.72080000E+02,
     & 53,179,   1.79340000E+02,      53,180,   1.89430000E+02,
     & 53,181,   1.99250000E+02,      53,182,   2.10480000E+02,
     & 53,183,   2.20640000E+02,      53,184,   2.32590000E+02,
     & 53,185,   2.42710000E+02,      54, 99,   3.56500000E+01,
     & 54,100,   2.33000000E+01,      54,101,   1.45200000E+01,
     & 54,102,   3.04000000E+00,      54,103,  -5.29000000E+00/
      data (niz(i),nia(i),bie(i),i=3121,3140)/
     & 54,104,  -1.58700000E+01,      54,105,  -2.15200000E+01,
     & 54,106,  -2.95000000E+01,      54,107,  -3.42400000E+01,
     & 54,108,  -4.13800000E+01,      54,109,  -4.50200000E+01,
     & 54,110,  -5.17210000E+01,      54,111,  -5.43690000E+01,
     & 54,112,  -5.99273310E+01,      54,113,  -6.20534790E+01,
     & 54,114,  -6.69320000E+01,      54,115,  -6.84300000E+01,
     & 54,116,  -7.29010000E+01,      54,117,  -7.39938160E+01,
     & 54,118,  -7.77136760E+01,      54,119,  -7.86606560E+01,
     & 54,120,  -8.18298820E+01,      54,121,  -8.25429340E+01,
     & 54,122,  -8.51866070E+01,      54,123,  -8.52589360E+01/
      data (niz(i),nia(i),bie(i),i=3141,3160)/
     & 54,124,  -8.76575080E+01,      54,125,  -8.71894680E+01,
     & 54,126,  -8.91729620E+01,      54,127,  -8.83246380E+01,
     & 54,128,  -8.98608070E+01,      54,129,  -8.86973500E+01,
     & 54,130,  -8.98817960E+01,      54,131,  -8.84156080E+01,
     & 54,132,  -8.92795350E+01,      54,133,  -8.76483000E+01,
     & 54,134,  -8.81244380E+01,      54,135,  -8.64356450E+01,
     & 54,136,  -8.64244420E+01,      54,137,  -8.23785790E+01,
     & 54,138,  -8.01191390E+01,      54,139,  -7.56495420E+01,
     & 54,140,  -7.29958970E+01,      54,141,  -6.83285380E+01,
     & 54,142,  -6.54812420E+01,      54,143,  -6.06500000E+01/
      data (niz(i),nia(i),bie(i),i=3161,3180)/
     & 54,144,  -5.75380000E+01,      54,145,  -5.24710000E+01,
     & 54,146,  -4.90900000E+01,      54,147,  -4.37710000E+01,
     & 54,148,  -3.97900000E+01,      54,149,  -3.41500000E+01,
     & 54,150,  -3.02400000E+01,      54,151,  -2.44300000E+01,
     & 54,152,  -2.02600000E+01,      54,153,  -1.42700000E+01,
     & 54,154,  -9.91000000E+00,      54,155,  -3.76000000E+00,
     & 54,156,   9.20000000E-01,      54,157,   7.48000000E+00,
     & 54,158,   1.26900000E+01,      54,159,   1.97000000E+01,
     & 54,160,   2.51400000E+01,      54,161,   3.23200000E+01,
     & 54,162,   3.79000000E+01,      54,163,   4.52300000E+01/
      data (niz(i),nia(i),bie(i),i=3181,3200)/
     & 54,164,   5.09900000E+01,      54,165,   5.85000000E+01,
     & 54,166,   6.43900000E+01,      54,167,   7.20700000E+01,
     & 54,168,   7.82400000E+01,      54,169,   8.59400000E+01,
     & 54,170,   9.20100000E+01,      54,171,   1.00010000E+02,
     & 54,172,   1.06280000E+02,      54,173,   1.14250000E+02,
     & 54,174,   1.20750000E+02,      54,175,   1.28770000E+02,
     & 54,176,   1.35080000E+02,      54,177,   1.42860000E+02,
     & 54,178,   1.49350000E+02,      54,179,   1.57030000E+02,
     & 54,180,   1.64040000E+02,      54,181,   1.74400000E+02,
     & 54,182,   1.83490000E+02,      54,183,   1.94550000E+02/
      data (niz(i),nia(i),bie(i),i=3201,3220)/
     & 54,184,   2.04490000E+02,      54,185,   2.16010000E+02,
     & 54,186,   2.25700000E+02,      54,187,   2.37150000E+02,
     & 54,188,   2.47190000E+02,      55,104,   6.91000000E+00,
     & 55,105,  -4.07000000E+00,      55,106,  -9.41000000E+00,
     & 55,107,  -1.76700000E+01,      55,108,  -2.33300000E+01,
     & 55,109,  -3.06900000E+01,      55,110,  -3.57500000E+01,
     & 55,111,  -4.21900000E+01,      55,112,  -4.62660000E+01,
     & 55,113,  -5.16648300E+01,      55,114,  -5.45660000E+01,
     & 55,115,  -5.96720000E+01,      55,116,  -6.24900550E+01,
     & 55,117,  -6.64718830E+01,      55,118,  -6.84136760E+01/
      data (niz(i),nia(i),bie(i),i=3221,3240)/
     & 55,119,  -7.23110490E+01,      55,120,  -7.38877520E+01,
     & 55,121,  -7.71429340E+01,      55,122,  -7.81318930E+01,
     & 55,123,  -8.10491240E+01,      55,124,  -8.17425630E+01,
     & 55,125,  -8.40907280E+01,      55,126,  -8.43486760E+01,
     & 55,127,  -8.62399370E+01,      55,128,  -8.59322470E+01,
     & 55,129,  -8.75013950E+01,      55,130,  -8.69026360E+01,
     & 55,131,  -8.80632140E+01,      55,132,  -8.71600680E+01,
     & 55,133,  -8.80756600E+01,      55,134,  -8.68958770E+01,
     & 55,135,  -8.75865950E+01,      55,136,  -8.63441340E+01,
     & 55,137,  -8.65511450E+01,      55,138,  -8.28931390E+01/
      data (niz(i),nia(i),bie(i),i=3241,3260)/
     & 55,139,  -8.07065650E+01,      55,140,  -7.70558970E+01,
     & 55,141,  -7.44785380E+01,      55,142,  -7.05212420E+01,
     & 55,143,  -6.76913870E+01,      55,144,  -6.33160840E+01,
     & 55,145,  -6.01854710E+01,      55,146,  -5.57387040E+01,
     & 55,147,  -5.22899340E+01,      55,148,  -4.75997660E+01,
     & 55,149,  -4.40410000E+01,      55,150,  -3.91510000E+01,
     & 55,151,  -3.53970000E+01,      55,152,  -3.01700000E+01,
     & 55,153,  -2.61000000E+01,      55,154,  -2.06100000E+01,
     & 55,155,  -1.63700000E+01,      55,156,  -1.07600000E+01,
     & 55,157,  -6.15000000E+00,      55,158,  -9.00000000E-02/
      data (niz(i),nia(i),bie(i),i=3261,3280)/
     & 55,159,   5.07000000E+00,      55,160,   1.16600000E+01,
     & 55,161,   1.69900000E+01,      55,162,   2.37200000E+01,
     & 55,163,   2.92700000E+01,      55,164,   3.61700000E+01,
     & 55,165,   4.19100000E+01,      55,166,   4.89900000E+01,
     & 55,167,   5.47900000E+01,      55,168,   6.20800000E+01,
     & 55,169,   6.81800000E+01,      55,170,   7.55000000E+01,
     & 55,171,   8.16800000E+01,      55,172,   8.90300000E+01,
     & 55,173,   9.53500000E+01,      55,174,   1.02740000E+02,
     & 55,175,   1.09590000E+02,      55,176,   1.17180000E+02,
     & 55,177,   1.23500000E+02,      55,178,   1.30820000E+02/
      data (niz(i),nia(i),bie(i),i=3281,3300)/
     & 55,179,   1.37280000E+02,      55,180,   1.44600000E+02,
     & 55,181,   1.51480000E+02,      55,182,   1.61460000E+02,
     & 55,183,   1.70380000E+02,      55,184,   1.80690000E+02,
     & 55,185,   1.89700000E+02,      55,186,   2.02140000E+02,
     & 55,187,   2.11670000E+02,      55,188,   2.22740000E+02,
     & 55,189,   2.32810000E+02,      55,190,   2.43970000E+02,
     & 55,191,   2.54040000E+02,      56,103,   3.94700000E+01,
     & 56,104,   2.71800000E+01,      56,105,   1.83200000E+01,
     & 56,106,   6.74000000E+00,      56,107,  -2.00000000E-02,
     & 56,108,  -7.99000000E+00,      56,109,  -1.38100000E+01/
      data (niz(i),nia(i),bie(i),i=3301,3320)/
     & 56,110,  -2.22200000E+01,      56,111,  -2.75300000E+01,
     & 56,112,  -3.47000000E+01,      56,113,  -3.85800000E+01,
     & 56,114,  -4.56980000E+01,      56,115,  -4.87080000E+01,
     & 56,116,  -5.43250000E+01,      56,117,  -5.69520000E+01,
     & 56,118,  -6.20000000E+01,      56,119,  -6.42247070E+01,
     & 56,120,  -6.88877520E+01,      56,121,  -7.03409130E+01,
     & 56,122,  -7.42770000E+01,      56,123,  -7.55910000E+01,
     & 56,124,  -7.90946000E+01,      56,125,  -7.95307280E+01,
     & 56,126,  -8.26755330E+01,      56,127,  -8.27899370E+01,
     & 56,128,  -8.54097250E+01,      56,129,  -8.50698420E+01/
      data (niz(i),nia(i),bie(i),i=3321,3340)/
     & 56,130,  -8.72712140E+01,      56,131,  -8.66933900E+01,
     & 56,132,  -8.84396110E+01,      56,133,  -8.75582170E+01,
     & 56,134,  -8.89545460E+01,      56,135,  -8.78559400E+01,
     & 56,136,  -8.88923580E+01,      56,137,  -8.77267740E+01,
     & 56,138,  -8.82671720E+01,      56,139,  -8.49192800E+01,
     & 56,140,  -8.32760310E+01,      56,141,  -7.97298770E+01,
     & 56,142,  -7.78280120E+01,      56,143,  -7.39446060E+01,
     & 56,144,  -7.17804810E+01,      56,145,  -6.80700250E+01,
     & 56,146,  -6.51052310E+01,      56,147,  -6.14855630E+01,
     & 56,148,  -5.80484830E+01,      56,149,  -5.35980000E+01/
      data (niz(i),nia(i),bie(i),i=3341,3360)/
     & 56,150,  -5.06550000E+01,      56,151,  -4.59230000E+01,
     & 56,152,  -4.27000000E+01,      56,153,  -3.76230000E+01,
     & 56,154,  -3.39000000E+01,      56,155,  -2.85100000E+01,
     & 56,156,  -2.47400000E+01,      56,157,  -1.92100000E+01,
     & 56,158,  -1.51600000E+01,      56,159,  -9.10000000E+00,
     & 56,160,  -4.45000000E+00,      56,161,   2.06000000E+00,
     & 56,162,   6.95000000E+00,      56,163,   1.36600000E+01,
     & 56,164,   1.87800000E+01,      56,165,   2.56200000E+01,
     & 56,166,   3.09600000E+01,      56,167,   3.80100000E+01,
     & 56,168,   4.34500000E+01,      56,169,   5.05400000E+01/
      data (niz(i),nia(i),bie(i),i=3361,3380)/
     & 56,170,   5.62900000E+01,      56,171,   6.36200000E+01,
     & 56,172,   6.94000000E+01,      56,173,   7.66400000E+01,
     & 56,174,   8.26900000E+01,      56,175,   9.01100000E+01,
     & 56,176,   9.66100000E+01,      56,177,   1.04030000E+02,
     & 56,178,   1.10130000E+02,      56,179,   1.17450000E+02,
     & 56,180,   1.23510000E+02,      56,181,   1.30710000E+02,
     & 56,182,   1.37380000E+02,      56,183,   1.47290000E+02,
     & 56,184,   1.55590000E+02,      56,185,   1.65930000E+02,
     & 56,186,   1.74640000E+02,      56,187,   1.84200000E+02,
     & 56,188,   1.92490000E+02,      56,189,   2.01880000E+02/
      data (niz(i),nia(i),bie(i),i=3381,3400)/
     & 56,190,   2.15770000E+02,      56,191,   2.26870000E+02,
     & 56,192,   2.36390000E+02,      57,109,   4.00000000E+00,
     & 57,110,  -2.10000000E+00,      57,111,  -1.06100000E+01,
     & 57,112,  -1.64500000E+01,      57,113,  -2.43400000E+01,
     & 57,114,  -2.94000000E+01,      57,115,  -3.61400000E+01,
     & 57,116,  -4.05300000E+01,      57,117,  -4.65650000E+01,
     & 57,118,  -4.97700000E+01,      57,119,  -5.49670000E+01,
     & 57,120,  -5.76870000E+01,      57,121,  -6.24010000E+01,
     & 57,122,  -6.45430000E+01,      57,123,  -6.87070000E+01,
     & 57,124,  -7.03000000E+01,      57,125,  -7.38950000E+01/
      data (niz(i),nia(i),bie(i),i=3401,3420)/
     & 57,126,  -7.51060000E+01,      57,127,  -7.80960000E+01,
     & 57,128,  -7.87597250E+01,      57,129,  -8.13498420E+01,
     & 57,130,  -8.16730000E+01,      57,131,  -8.37333900E+01,
     & 57,132,  -8.37316110E+01,      57,133,  -8.53282170E+01,
     & 57,134,  -8.52413690E+01,      57,135,  -8.66559400E+01,
     & 57,136,  -8.60223580E+01,      57,137,  -8.71266670E+01,
     & 57,138,  -8.65294210E+01,      57,139,  -8.72361140E+01,
     & 57,140,  -8.43257620E+01,      57,141,  -8.29429930E+01,
     & 57,142,  -8.00390860E+01,      57,143,  -7.81908560E+01,
     & 57,144,  -7.48998690E+01,      57,145,  -7.29933770E+01/
      data (niz(i),nia(i),bie(i),i=3421,3440)/
     & 57,146,  -6.92098580E+01,      57,147,  -6.72355630E+01,
     & 57,148,  -6.31634830E+01,      57,149,  -6.11340000E+01,
     & 57,150,  -5.72220000E+01,      57,151,  -5.44370000E+01,
     & 57,152,  -5.01980000E+01,      57,153,  -4.70870000E+01,
     & 57,154,  -4.24760000E+01,      57,155,  -3.90020000E+01,
     & 57,156,  -3.37200000E+01,      57,157,  -3.00100000E+01,
     & 57,158,  -2.49800000E+01,      57,159,  -2.10200000E+01,
     & 57,160,  -1.53800000E+01,      57,161,  -1.07700000E+01,
     & 57,162,  -4.70000000E+00,      57,163,   1.80000000E-01,
     & 57,164,   6.41000000E+00,      57,165,   1.15100000E+01/
      data (niz(i),nia(i),bie(i),i=3441,3460)/
     & 57,166,   1.79800000E+01,      57,167,   2.32500000E+01,
     & 57,168,   2.97900000E+01,      57,169,   3.52000000E+01,
     & 57,170,   4.18100000E+01,      57,171,   4.75300000E+01,
     & 57,172,   5.44200000E+01,      57,173,   6.01900000E+01,
     & 57,174,   6.70000000E+01,      57,175,   7.30300000E+01,
     & 57,176,   8.00500000E+01,      57,177,   8.67500000E+01,
     & 57,178,   9.36200000E+01,      57,179,   9.96900000E+01,
     & 57,180,   1.06520000E+02,      57,181,   1.12620000E+02,
     & 57,182,   1.19490000E+02,      57,183,   1.26040000E+02,
     & 57,184,   1.35320000E+02,      57,185,   1.43790000E+02/
      data (niz(i),nia(i),bie(i),i=3461,3480)/
     & 57,186,   1.53730000E+02,      57,187,   1.62310000E+02,
     & 57,188,   1.71380000E+02,      57,189,   1.79700000E+02,
     & 57,190,   1.88780000E+02,      57,191,   1.97280000E+02,
     & 57,192,   2.06600000E+02,      57,193,   2.22120000E+02,
     & 58,107,   4.45400000E+01,      58,108,   3.20200000E+01,
     & 58,109,   2.45500000E+01,      58,110,   1.47700000E+01,
     & 58,111,   7.76000000E+00,      58,112,  -1.47000000E+00,
     & 58,113,  -7.19000000E+00,      58,114,  -1.55600000E+01,
     & 58,115,  -2.12200000E+01,      58,116,  -2.92100000E+01,
     & 58,117,  -3.38000000E+01,      58,118,  -4.05700000E+01/
      data (niz(i),nia(i),bie(i),i=3481,3500)/
     & 58,119,  -4.40040000E+01,      58,120,  -4.97050000E+01,
     & 58,121,  -5.24710000E+01,      58,122,  -5.77430000E+01,
     & 58,123,  -6.00720000E+01,      58,124,  -6.47200000E+01,
     & 58,125,  -6.65650000E+01,      58,126,  -7.07000000E+01,
     & 58,127,  -7.19580000E+01,      58,128,  -7.55720000E+01,
     & 58,129,  -7.63000000E+01,      58,130,  -7.94620000E+01,
     & 58,131,  -7.97133900E+01,      58,132,  -8.24470000E+01,
     & 58,133,  -8.23910000E+01,      58,134,  -8.47413690E+01,
     & 58,135,  -8.46303570E+01,      58,136,  -8.64951900E+01,
     & 58,137,  -8.59045670E+01,      58,138,  -8.75738600E+01/
      data (niz(i),nia(i),bie(i),i=3501,3520)/
     & 58,139,  -8.69581140E+01,      58,140,  -8.80876150E+01,
     & 58,141,  -8.54449050E+01,      58,142,  -8.45426310E+01,
     & 58,143,  -8.16164130E+01,      58,144,  -8.04413080E+01,
     & 58,145,  -7.71017300E+01,      58,146,  -7.57400250E+01,
     & 58,147,  -7.21805630E+01,      58,148,  -7.04258370E+01,
     & 58,149,  -6.67981640E+01,      58,150,  -6.49936810E+01,
     & 58,151,  -6.14410000E+01,      58,152,  -5.92620000E+01,
     & 58,153,  -5.53490000E+01,      58,154,  -5.27970000E+01,
     & 58,155,  -4.84000000E+01,      58,156,  -4.54010000E+01,
     & 58,157,  -4.06690000E+01,      58,158,  -3.72900000E+01/
      data (niz(i),nia(i),bie(i),i=3521,3540)/
     & 58,159,  -3.23200000E+01,      58,160,  -2.87000000E+01,
     & 58,161,  -2.32300000E+01,      58,162,  -1.90100000E+01,
     & 58,163,  -1.30400000E+01,      58,164,  -8.62000000E+00,
     & 58,165,  -2.43000000E+00,      58,166,   2.23000000E+00,
     & 58,167,   8.61000000E+00,      58,168,   1.34300000E+01,
     & 58,169,   2.00300000E+01,      58,170,   2.50000000E+01,
     & 58,171,   3.15600000E+01,      58,172,   3.68200000E+01,
     & 58,173,   4.37200000E+01,      58,174,   4.90700000E+01,
     & 58,175,   5.59300000E+01,      58,176,   6.15300000E+01,
     & 58,177,   6.89000000E+01,      58,178,   7.49400000E+01/
      data (niz(i),nia(i),bie(i),i=3541,3560)/
     & 58,179,   8.18700000E+01,      58,180,   8.74800000E+01,
     & 58,181,   9.43900000E+01,      58,182,   9.99400000E+01,
     & 58,183,   1.06820000E+02,      58,184,   1.12900000E+02,
     & 58,185,   1.22330000E+02,      58,186,   1.30130000E+02,
     & 58,187,   1.40240000E+02,      58,188,   1.48270000E+02,
     & 58,189,   1.57280000E+02,      58,190,   1.65150000E+02,
     & 58,191,   1.74310000E+02,      58,192,   1.82800000E+02,
     & 58,193,   1.91680000E+02,      58,194,   1.99330000E+02,
     & 58,195,   2.08780000E+02,      59,114,   4.49000000E+00,
     & 59,115,  -4.41000000E+00,      59,116,  -1.08700000E+01/
      data (niz(i),nia(i),bie(i),i=3561,3580)/
     & 59,117,  -1.91100000E+01,      59,118,  -2.46900000E+01,
     & 59,119,  -3.18700000E+01,      59,120,  -3.63300000E+01,
     & 59,121,  -4.15790000E+01,      59,122,  -4.50380000E+01,
     & 59,123,  -5.03380000E+01,      59,124,  -5.31320000E+01,
     & 59,125,  -5.79110000E+01,      59,126,  -6.02580000E+01,
     & 59,127,  -6.44310000E+01,      59,128,  -6.63220000E+01,
     & 59,129,  -6.99920000E+01,      59,130,  -7.13710000E+01,
     & 59,131,  -7.44633900E+01,      59,132,  -7.53390000E+01,
     & 59,133,  -7.80590000E+01,      59,134,  -7.85510000E+01,
     & 59,135,  -8.09103570E+01,      59,136,  -8.13688440E+01/
      data (niz(i),nia(i),bie(i),i=3581,3600)/
     & 59,137,  -8.32025670E+01,      59,138,  -8.31368600E+01,
     & 59,139,  -8.48291140E+01,      59,140,  -8.46996150E+01,
     & 59,141,  -8.60255760E+01,      59,142,  -8.37973140E+01,
     & 59,143,  -8.30778580E+01,      59,144,  -8.07599630E+01,
     & 59,145,  -7.96363010E+01,      59,146,  -7.67662570E+01,
     & 59,147,  -7.54705630E+01,      59,148,  -7.24858370E+01,
     & 59,149,  -7.09881640E+01,      59,150,  -6.80036810E+01,
     & 59,151,  -6.68553000E+01,      59,152,  -6.37140000E+01,
     & 59,153,  -6.18050000E+01,      59,154,  -5.83210000E+01,
     & 59,155,  -5.58990000E+01,      59,156,  -5.20520000E+01/
      data (niz(i),nia(i),bie(i),i=3601,3620)/
     & 59,157,  -4.92110000E+01,      59,158,  -4.49170000E+01,
     & 59,159,  -4.17030000E+01,      59,160,  -3.69300000E+01,
     & 59,161,  -3.33500000E+01,      59,162,  -2.83600000E+01,
     & 59,163,  -2.43000000E+01,      59,164,  -1.86800000E+01,
     & 59,165,  -1.43400000E+01,      59,166,  -8.58000000E+00,
     & 59,167,  -3.95000000E+00,      59,168,   2.04000000E+00,
     & 59,169,   6.85000000E+00,      59,170,   1.30000000E+01,
     & 59,171,   1.79600000E+01,      59,172,   2.41800000E+01,
     & 59,173,   2.92300000E+01,      59,174,   3.57000000E+01,
     & 59,175,   4.10500000E+01,      59,176,   4.75000000E+01/
      data (niz(i),nia(i),bie(i),i=3621,3640)/
     & 59,177,   5.30700000E+01,      59,178,   6.00100000E+01,
     & 59,179,   6.60400000E+01,      59,180,   7.26000000E+01,
     & 59,181,   7.82800000E+01,      59,182,   8.46600000E+01,
     & 59,183,   9.02200000E+01,      59,184,   9.67200000E+01,
     & 59,185,   1.02750000E+02,      59,186,   1.11730000E+02,
     & 59,187,   1.19620000E+02,      59,188,   1.29220000E+02,
     & 59,189,   1.37070000E+02,      59,190,   1.45580000E+02,
     & 59,191,   1.53460000E+02,      59,192,   1.62710000E+02,
     & 59,193,   1.70700000E+02,      59,194,   1.79170000E+02,
     & 59,195,   1.86870000E+02,      59,196,   1.95760000E+02/
      data (niz(i),nia(i),bie(i),i=3641,3660)/
     & 59,197,   2.03760000E+02,      59,198,   2.12890000E+02,
     & 60,112,   4.02800000E+01,      60,113,   3.24900000E+01,
     & 60,114,   2.24300000E+01,      60,115,   1.51800000E+01,
     & 60,116,   5.23000000E+00,      60,117,  -1.48000000E+00,
     & 60,118,  -1.06900000E+01,      60,119,  -1.66600000E+01,
     & 60,120,  -2.48300000E+01,      60,121,  -2.94000000E+01,
     & 60,122,  -3.59000000E+01,      60,123,  -3.95600000E+01,
     & 60,124,  -4.53000000E+01,      60,125,  -4.83600000E+01,
     & 60,126,  -5.30300000E+01,      60,127,  -5.54240000E+01,
     & 60,128,  -6.01840000E+01,      60,129,  -6.21730000E+01/
      data (niz(i),nia(i),bie(i),i=3661,3680)/
     & 60,130,  -6.63410000E+01,      60,131,  -6.79033900E+01,
     & 60,132,  -7.16130000E+01,      60,133,  -7.24610000E+01,
     & 60,134,  -7.57810000E+01,      60,135,  -7.61590000E+01,
     & 60,136,  -7.91578440E+01,      60,137,  -7.95125670E+01,
     & 60,138,  -8.20370000E+01,      60,139,  -8.20421140E+01,
     & 60,140,  -8.44773420E+01,      60,141,  -8.42025740E+01,
     & 60,142,  -8.59595170E+01,      60,143,  -8.40117800E+01,
     & 60,144,  -8.37574790E+01,      60,145,  -8.14415820E+01,
     & 60,146,  -8.09355090E+01,      60,147,  -7.81562530E+01,
     & 60,148,  -7.74178370E+01,      60,149,  -7.43851960E+01/
      data (niz(i),nia(i),bie(i),i=3681,3700)/
     & 60,150,  -7.36936810E+01,      60,151,  -7.09567880E+01,
     & 60,152,  -7.01578560E+01,      60,153,  -6.73520980E+01,
     & 60,154,  -6.56858780E+01,      60,155,  -6.27551590E+01,
     & 60,156,  -6.03610000E+01,      60,157,  -5.65700000E+01,
     & 60,158,  -5.41480000E+01,      60,159,  -4.99370000E+01,
     & 60,160,  -4.71430000E+01,      60,161,  -4.25410000E+01,
     & 60,162,  -4.01900000E+01,      60,163,  -3.52000000E+01,
     & 60,164,  -3.15400000E+01,      60,165,  -2.59300000E+01,
     & 60,166,  -2.19300000E+01,      60,167,  -1.62400000E+01,
     & 60,168,  -1.20800000E+01,      60,169,  -6.12000000E+00/
      data (niz(i),nia(i),bie(i),i=3701,3720)/
     & 60,170,  -1.75000000E+00,      60,171,   4.34000000E+00,
     & 60,172,   8.84000000E+00,      60,173,   1.50400000E+01,
     & 60,174,   1.96800000E+01,      60,175,   2.61500000E+01,
     & 60,176,   3.10700000E+01,      60,177,   3.77000000E+01,
     & 60,178,   4.27600000E+01,      60,179,   5.02600000E+01,
     & 60,180,   5.53100000E+01,      60,181,   6.19500000E+01,
     & 60,182,   6.71700000E+01,      60,183,   7.35500000E+01,
     & 60,184,   7.86600000E+01,      60,185,   8.51300000E+01,
     & 60,186,   9.08100000E+01,      60,187,   9.97700000E+01,
     & 60,188,   1.07120000E+02,      60,189,   1.16690000E+02/
      data (niz(i),nia(i),bie(i),i=3721,3740)/
     & 60,190,   1.24060000E+02,      60,191,   1.32730000E+02,
     & 60,192,   1.40250000E+02,      60,193,   1.49410000E+02,
     & 60,194,   1.56900000E+02,      60,195,   1.65550000E+02,
     & 60,196,   1.72750000E+02,      60,197,   1.81490000E+02,
     & 60,198,   1.89060000E+02,      60,199,   1.98120000E+02,
     & 60,200,   2.05850000E+02,      60,201,   2.15010000E+02,
     & 60,202,   2.36260000E+02,      61,118,   1.07800000E+01,
     & 61,119,   1.79000000E+00,      61,120,  -5.91000000E+00,
     & 61,121,  -1.42400000E+01,      61,122,  -1.97500000E+01,
     & 61,123,  -2.66300000E+01,      61,124,  -3.09300000E+01/
      data (niz(i),nia(i),bie(i),i=3741,3760)/
     & 61,125,  -3.67700000E+01,      61,126,  -4.04900000E+01,
     & 61,127,  -4.57300000E+01,      61,128,  -4.81950000E+01,
     & 61,129,  -5.29460000E+01,      61,130,  -5.54700000E+01,
     & 61,131,  -5.98020000E+01,      61,132,  -6.17110000E+01,
     & 61,133,  -6.54650000E+01,      61,134,  -6.66110000E+01,
     & 61,135,  -7.02190000E+01,      61,136,  -7.13078440E+01,
     & 61,137,  -7.38560000E+01,      61,138,  -7.50370000E+01,
     & 61,139,  -7.75377220E+01,      61,140,  -7.84302470E+01,
     & 61,141,  -8.04748880E+01,      61,142,  -8.10858530E+01,
     & 61,143,  -8.29704200E+01,      61,144,  -8.14258200E+01/
      data (niz(i),nia(i),bie(i),i=3761,3780)/
     & 61,145,  -8.12785410E+01,      61,146,  -7.94637240E+01,
     & 61,147,  -7.90522530E+01,      61,148,  -7.68782510E+01,
     & 61,149,  -7.60758530E+01,      61,150,  -7.36071320E+01,
     & 61,151,  -7.33992070E+01,      61,152,  -7.12680760E+01,
     & 61,153,  -7.06880980E+01,      61,154,  -6.84210010E+01,
     & 61,155,  -6.69771590E+01,      61,156,  -6.42168540E+01,
     & 61,157,  -6.22240000E+01,      61,158,  -5.89730000E+01,
     & 61,159,  -5.67000000E+01,      61,160,  -5.31040000E+01,
     & 61,161,  -5.04310000E+01,      61,162,  -4.63050000E+01,
     & 61,163,  -4.32960000E+01,      61,164,  -3.93400000E+01/
      data (niz(i),nia(i),bie(i),i=3781,3800)/
     & 61,165,  -3.57600000E+01,      61,166,  -3.06100000E+01,
     & 61,167,  -2.66500000E+01,      61,168,  -2.12800000E+01,
     & 61,169,  -1.71900000E+01,      61,170,  -1.17000000E+01,
     & 61,171,  -7.32000000E+00,      61,172,  -1.60000000E+00,
     & 61,173,   2.89000000E+00,      61,174,   8.66000000E+00,
     & 61,175,   1.32800000E+01,      61,176,   1.93300000E+01,
     & 61,177,   2.42200000E+01,      61,178,   3.04900000E+01,
     & 61,179,   3.54700000E+01,      61,180,   4.24900000E+01,
     & 61,181,   4.75400000E+01,      61,182,   5.37100000E+01,
     & 61,183,   5.90000000E+01,      61,184,   6.50500000E+01/
      data (niz(i),nia(i),bie(i),i=3801,3820)/
     & 61,185,   7.00500000E+01,      61,186,   7.61000000E+01,
     & 61,187,   8.17600000E+01,      61,188,   9.03100000E+01,
     & 61,189,   9.76400000E+01,      61,190,   1.06530000E+02,
     & 61,191,   1.13820000E+02,      61,192,   1.22340000E+02,
     & 61,193,   1.29780000E+02,      61,194,   1.38620000E+02,
     & 61,195,   1.45940000E+02,      61,196,   1.54040000E+02,
     & 61,197,   1.61310000E+02,      61,198,   1.69650000E+02,
     & 61,199,   1.77200000E+02,      61,200,   1.85840000E+02,
     & 61,201,   1.93520000E+02,      61,202,   2.02320000E+02,
     & 61,203,   2.09860000E+02,      61,204,   2.18650000E+02/
      data (niz(i),nia(i),bie(i),i=3821,3840)/
     & 61,205,   2.26490000E+02,      62,115,   5.82200000E+01,
     & 62,116,   4.74100000E+01,      62,117,   3.95200000E+01,
     & 62,118,   2.88900000E+01,      62,119,   2.13400000E+01,
     & 62,120,   1.16500000E+01,      62,121,   4.55000000E+00,
     & 62,122,  -4.83000000E+00,      62,123,  -1.10900000E+01,
     & 62,124,  -1.88600000E+01,      62,125,  -2.32900000E+01,
     & 62,126,  -2.96900000E+01,      62,127,  -3.35400000E+01,
     & 62,128,  -3.94400000E+01,      62,129,  -4.26800000E+01,
     & 62,130,  -4.78510000E+01,      62,131,  -5.04030000E+01,
     & 62,132,  -5.51260000E+01,      62,133,  -5.70730000E+01/
      data (niz(i),nia(i),bie(i),i=3841,3860)/
     & 62,134,  -6.14600000E+01,      62,135,  -6.30160000E+01,
     & 62,136,  -6.67880000E+01,      62,137,  -6.79555430E+01,
     & 62,138,  -7.12220000E+01,      62,139,  -7.23752100E+01,
     & 62,140,  -7.54593860E+01,      62,141,  -7.59460810E+01,
     & 62,142,  -7.89969440E+01,      62,143,  -7.95276340E+01,
     & 62,144,  -8.19763690E+01,      62,145,  -8.06621420E+01,
     & 62,146,  -8.10057240E+01,      62,147,  -7.92763920E+01,
     & 62,148,  -7.93465900E+01,      62,149,  -7.71467680E+01,
     & 62,150,  -7.70611320E+01,      62,151,  -7.45862500E+01,
     & 62,152,  -7.47726470E+01,      62,153,  -7.25690480E+01/
      data (niz(i),nia(i),bie(i),i=3861,3880)/
     & 62,154,  -7.24652820E+01,      62,155,  -7.02011590E+01,
     & 62,156,  -6.93718540E+01,      62,157,  -6.67373380E+01,
     & 62,158,  -6.52158060E+01,      62,159,  -6.22240000E+01,
     & 62,160,  -6.04170000E+01,      62,161,  -5.69790000E+01,
     & 62,162,  -5.47530000E+01,      62,163,  -5.08970000E+01,
     & 62,164,  -4.81770000E+01,      62,165,  -4.37990000E+01,
     & 62,166,  -4.13800000E+01,      62,167,  -3.63200000E+01,
     & 62,168,  -3.29800000E+01,      62,169,  -2.77700000E+01,
     & 62,170,  -2.41700000E+01,      62,171,  -1.87300000E+01,
     & 62,172,  -1.48300000E+01,      62,173,  -9.19000000E+00/
      data (niz(i),nia(i),bie(i),i=3881,3900)/
     & 62,174,  -5.15000000E+00,      62,175,   5.90000000E-01,
     & 62,176,   4.76000000E+00,      62,177,   1.07700000E+01,
     & 62,178,   1.53300000E+01,      62,179,   2.16500000E+01,
     & 62,180,   2.62100000E+01,      62,181,   3.31900000E+01,
     & 62,182,   3.78100000E+01,      62,183,   4.40600000E+01,
     & 62,184,   4.88800000E+01,      62,185,   5.49400000E+01,
     & 62,186,   5.95700000E+01,      62,187,   6.56500000E+01,
     & 62,188,   7.09000000E+01,      62,189,   7.94200000E+01,
     & 62,190,   8.63200000E+01,      62,191,   9.51800000E+01,
     & 62,192,   1.02040000E+02,      62,193,   1.10640000E+02/
      data (niz(i),nia(i),bie(i),i=3901,3920)/
     & 62,194,   1.17720000E+02,      62,195,   1.26420000E+02,
     & 62,196,   1.33390000E+02,      62,197,   1.41420000E+02,
     & 62,198,   1.48210000E+02,      62,199,   1.56660000E+02,
     & 62,200,   1.63800000E+02,      62,201,   1.72340000E+02,
     & 62,202,   1.79750000E+02,      62,203,   1.88410000E+02,
     & 62,204,   1.95920000E+02,      62,205,   2.04270000E+02,
     & 62,206,   2.11710000E+02,      62,207,   2.20340000E+02,
     & 62,208,   2.28050000E+02,      63,125,  -7.59000000E+00,
     & 63,126,  -1.28100000E+01,      63,127,  -1.97000000E+01,
     & 63,128,  -2.42400000E+01,      63,129,  -3.03000000E+01/
      data (niz(i),nia(i),bie(i),i=3921,3940)/
     & 63,130,  -3.42200000E+01,      63,131,  -3.97500000E+01,
     & 63,132,  -4.27000000E+01,      63,133,  -4.75990000E+01,
     & 63,134,  -5.00030000E+01,      63,135,  -5.42870000E+01,
     & 63,136,  -5.63550000E+01,      63,137,  -6.03510000E+01,
     & 63,138,  -6.19910000E+01,      63,139,  -6.53550000E+01,
     & 63,140,  -6.69893860E+01,      63,141,  -6.99683530E+01,
     & 63,142,  -7.13523990E+01,      63,143,  -7.42525110E+01,
     & 63,144,  -7.56614120E+01,      63,145,  -7.80020990E+01,
     & 63,146,  -7.71279580E+01,      63,147,  -7.75550550E+01,
     & 63,148,  -7.62392560E+01,      63,149,  -7.64515000E+01/
      data (niz(i),nia(i),bie(i),i=3941,3960)/
     & 63,150,  -7.48005460E+01,      63,151,  -7.46629390E+01,
     & 63,152,  -7.28983380E+01,      63,153,  -7.33772940E+01,
     & 63,154,  -7.17479550E+01,      63,155,  -7.18280230E+01,
     & 63,156,  -7.00941160E+01,      63,157,  -6.94713380E+01,
     & 63,158,  -6.72148060E+01,      63,159,  -6.60573530E+01,
     & 63,160,  -6.33720000E+01,      63,161,  -6.17770000E+01,
     & 63,162,  -5.86470000E+01,      63,163,  -5.66260000E+01,
     & 63,164,  -5.31040000E+01,      63,165,  -5.05610000E+01,
     & 63,166,  -4.66030000E+01,      63,167,  -4.37340000E+01,
     & 63,168,  -3.98700000E+01,      63,169,  -3.64600000E+01/
      data (niz(i),nia(i),bie(i),i=3961,3980)/
     & 63,170,  -3.17300000E+01,      63,171,  -2.82100000E+01,
     & 63,172,  -2.32200000E+01,      63,173,  -1.93500000E+01,
     & 63,174,  -1.41100000E+01,      63,175,  -1.00500000E+01,
     & 63,176,  -4.74000000E+00,      63,177,  -5.60000000E-01,
     & 63,178,   4.97000000E+00,      63,179,   9.51000000E+00,
     & 63,180,   1.53800000E+01,      63,181,   2.00000000E+01,
     & 63,182,   2.64200000E+01,      63,183,   3.10000000E+01,
     & 63,184,   3.68600000E+01,      63,185,   4.17100000E+01,
     & 63,186,   4.73900000E+01,      63,187,   5.21100000E+01,
     & 63,188,   5.76900000E+01,      63,189,   6.29100000E+01/
      data (niz(i),nia(i),bie(i),i=3981,4000)/
     & 63,190,   7.10300000E+01,      63,191,   7.79200000E+01,
     & 63,192,   8.61800000E+01,      63,193,   9.30000000E+01,
     & 63,194,   1.01430000E+02,      63,195,   1.08400000E+02,
     & 63,196,   1.16710000E+02,      63,197,   1.23550000E+02,
     & 63,198,   1.31240000E+02,      63,199,   1.38070000E+02,
     & 63,200,   1.46060000E+02,      63,201,   1.53180000E+02,
     & 63,202,   1.61380000E+02,      63,203,   1.68630000E+02,
     & 63,204,   1.76910000E+02,      63,205,   1.84010000E+02,
     & 63,206,   1.92370000E+02,      63,207,   1.99790000E+02,
     & 63,208,   2.08000000E+02,      63,209,   2.15570000E+02/
      data (niz(i),nia(i),bie(i),i=4001,4020)/
     & 63,210,   2.24440000E+02,      63,211,   2.32480000E+02,
     & 64,120,   5.39100000E+01,      64,121,   4.55000000E+01,
     & 64,122,   3.51000000E+01,      64,123,   2.73200000E+01,
     & 64,124,   1.72300000E+01,      64,125,   1.01800000E+01,
     & 64,126,   9.80000000E-01,      64,127,  -5.35000000E+00,
     & 64,128,  -1.13500000E+01,      64,129,  -1.60600000E+01,
     & 64,130,  -2.28100000E+01,      64,131,  -2.68800000E+01,
     & 64,132,  -3.31500000E+01,      64,133,  -3.66800000E+01,
     & 64,134,  -4.22000000E+01,      64,135,  -4.49400000E+01,
     & 64,136,  -4.93040000E+01,      64,137,  -5.15580000E+01/
      data (niz(i),nia(i),bie(i),i=4021,4040)/
     & 64,138,  -5.59180000E+01,      64,139,  -5.76780000E+01,
     & 64,140,  -6.15290000E+01,      64,141,  -6.31460000E+01,
     & 64,142,  -6.68520000E+01,      64,143,  -6.82425110E+01,
     & 64,144,  -7.19210000E+01,      64,145,  -7.29476150E+01,
     & 64,146,  -7.60980700E+01,      64,147,  -7.53676840E+01,
     & 64,148,  -7.62802450E+01,      64,149,  -7.51376230E+01,
     & 64,150,  -7.57719440E+01,      64,151,  -7.41988210E+01,
     & 64,152,  -7.47170960E+01,      64,153,  -7.28928570E+01,
     & 64,154,  -7.37163080E+01,      64,155,  -7.20801120E+01,
     & 64,156,  -7.25451590E+01,      64,157,  -7.08338800E+01/
      data (niz(i),nia(i),bie(i),i=4041,4060)/
     & 64,158,  -7.06998880E+01,      64,159,  -6.85718510E+01,
     & 64,160,  -6.79519030E+01,      64,161,  -6.55159800E+01,
     & 64,162,  -6.42905780E+01,      64,163,  -6.14880000E+01,
     & 64,164,  -5.97460000E+01,      64,165,  -5.64670000E+01,
     & 64,166,  -5.43990000E+01,      64,167,  -5.07010000E+01,
     & 64,168,  -4.81020000E+01,      64,169,  -4.39010000E+01,
     & 64,170,  -4.17100000E+01,      64,171,  -3.71200000E+01,
     & 64,172,  -3.41000000E+01,      64,173,  -2.91900000E+01,
     & 64,174,  -2.58300000E+01,      64,175,  -2.06400000E+01,
     & 64,176,  -1.70500000E+01,      64,177,  -1.17600000E+01/
      data (niz(i),nia(i),bie(i),i=4061,4080)/
     & 64,178,  -8.00000000E+00,      64,179,  -2.46000000E+00,
     & 64,180,   1.67000000E+00,      64,181,   7.49000000E+00,
     & 64,182,   1.18000000E+01,      64,183,   1.81300000E+01,
     & 64,184,   2.22700000E+01,      64,185,   2.81500000E+01,
     & 64,186,   3.26000000E+01,      64,187,   3.83200000E+01,
     & 64,188,   4.26800000E+01,      64,189,   4.82600000E+01,
     & 64,190,   5.30900000E+01,      64,191,   6.11800000E+01,
     & 64,192,   6.76400000E+01,      64,193,   7.59600000E+01,
     & 64,194,   8.24000000E+01,      64,195,   9.07600000E+01,
     & 64,196,   9.73300000E+01,      64,197,   1.05500000E+02/
      data (niz(i),nia(i),bie(i),i=4081,4100)/
     & 64,198,   1.12080000E+02,      64,199,   1.19790000E+02,
     & 64,200,   1.26150000E+02,      64,201,   1.34180000E+02,
     & 64,202,   1.40880000E+02,      64,203,   1.49050000E+02,
     & 64,204,   1.55870000E+02,      64,205,   1.64120000E+02,
     & 64,206,   1.70890000E+02,      64,207,   1.79210000E+02,
     & 64,208,   1.86130000E+02,      64,209,   1.94480000E+02,
     & 64,210,   2.01740000E+02,      64,211,   2.10420000E+02,
     & 64,212,   2.18040000E+02,      64,213,   2.27250000E+02,
     & 64,214,   2.35170000E+02,      65,130,  -5.60000000E+00,
     & 65,131,  -1.27500000E+01,      65,132,  -1.75200000E+01/
      data (niz(i),nia(i),bie(i),i=4101,4120)/
     & 65,133,  -2.38900000E+01,      65,134,  -2.81100000E+01,
     & 65,135,  -3.37600000E+01,      65,136,  -3.71100000E+01,
     & 65,137,  -4.18000000E+01,      65,138,  -4.39010000E+01,
     & 65,139,  -4.84100000E+01,      65,140,  -5.07290000E+01,
     & 65,141,  -5.48090000E+01,      65,142,  -5.69520000E+01,
     & 65,143,  -6.07800000E+01,      65,144,  -6.28480000E+01,
     & 65,145,  -6.62480000E+01,      65,146,  -6.78307970E+01,
     & 65,147,  -7.07589040E+01,      65,148,  -7.05153560E+01,
     & 65,149,  -7.14999500E+01,      65,150,  -7.11156840E+01,
     & 65,151,  -7.16335830E+01,      65,152,  -7.07270960E+01/
      data (niz(i),nia(i),bie(i),i=4121,4140)/
     & 65,153,  -7.13236860E+01,      65,154,  -7.01543080E+01,
     & 65,155,  -7.12588980E+01,      65,156,  -7.01007360E+01,
     & 65,157,  -7.07738280E+01,      65,158,  -6.94798850E+01,
     & 65,159,  -6.95424120E+01,      65,160,  -6.78462670E+01,
     & 65,161,  -6.74715570E+01,      65,162,  -6.56844730E+01,
     & 65,163,  -6.46047420E+01,      65,164,  -6.20866250E+01,
     & 65,165,  -6.06590000E+01,      65,166,  -5.77060000E+01,
     & 65,167,  -5.58430000E+01,      65,168,  -5.24990000E+01,
     & 65,169,  -5.00960000E+01,      65,170,  -4.63420000E+01,
     & 65,171,  -4.35010000E+01,      65,172,  -4.00300000E+01/
      data (niz(i),nia(i),bie(i),i=4141,4160)/
     & 65,173,  -3.70800000E+01,      65,174,  -3.26600000E+01,
     & 65,175,  -2.93300000E+01,      65,176,  -2.45600000E+01,
     & 65,177,  -2.09200000E+01,      65,178,  -1.61700000E+01,
     & 65,179,  -1.23900000E+01,      65,180,  -7.33000000E+00,
     & 65,181,  -3.19000000E+00,      65,182,   2.26000000E+00,
     & 65,183,   6.59000000E+00,      65,184,   1.24100000E+01,
     & 65,185,   1.65200000E+01,      65,186,   2.19600000E+01,
     & 65,187,   2.64300000E+01,      65,188,   3.18500000E+01,
     & 65,189,   3.62000000E+01,      65,190,   4.15700000E+01,
     & 65,191,   4.61700000E+01,      65,192,   5.39800000E+01/
      data (niz(i),nia(i),bie(i),i=4161,4180)/
     & 65,193,   6.04700000E+01,      65,194,   6.82800000E+01,
     & 65,195,   7.47500000E+01,      65,196,   8.25600000E+01,
     & 65,197,   8.90700000E+01,      65,198,   9.68500000E+01,
     & 65,199,   1.05540000E+02,      65,200,   1.10690000E+02,
     & 65,201,   1.17040000E+02,      65,202,   1.24660000E+02,
     & 65,203,   1.31300000E+02,      65,204,   1.39110000E+02,
     & 65,205,   1.45850000E+02,      65,206,   1.53730000E+02,
     & 65,207,   1.60720000E+02,      65,208,   1.68420000E+02,
     & 65,209,   1.75250000E+02,      65,210,   1.83290000E+02,
     & 65,211,   1.90540000E+02,      65,212,   1.98950000E+02/
      data (niz(i),nia(i),bie(i),i=4181,4200)/
     & 65,213,   2.06540000E+02,      65,214,   2.15340000E+02,
     & 65,215,   2.23180000E+02,      65,216,   2.31880000E+02,
     & 65,217,   2.39820000E+02,      65,218,   2.48910000E+02,
     & 66,126,   4.16500000E+01,      66,127,   3.40800000E+01,
     & 66,128,   2.43400000E+01,      66,129,   1.73200000E+01,
     & 66,130,   8.31000000E+00,      66,131,   1.99000000E+00,
     & 66,132,  -6.40000000E+00,      66,133,  -9.38000000E+00,
     & 66,134,  -1.64200000E+01,      66,135,  -2.07100000E+01,
     & 66,136,  -2.70200000E+01,      66,137,  -3.04800000E+01,
     & 66,138,  -3.57900000E+01,      66,139,  -3.86200000E+01/
      data (niz(i),nia(i),bie(i),i=4201,4220)/
     & 66,140,  -4.30440000E+01,      66,141,  -4.54660000E+01,
     & 66,142,  -5.00520000E+01,      66,143,  -5.23220000E+01,
     & 66,144,  -5.67560000E+01,      66,145,  -5.87280000E+01,
     & 66,146,  -6.26707970E+01,      66,147,  -6.43862570E+01,
     & 66,148,  -6.78333560E+01,      66,149,  -6.76879500E+01,
     & 66,150,  -6.93220270E+01,      66,151,  -6.87632210E+01,
     & 66,152,  -7.01285640E+01,      66,153,  -6.91532980E+01,
     & 66,154,  -7.04004000E+01,      66,155,  -6.91643980E+01,
     & 66,156,  -7.05343240E+01,      66,157,  -6.94323820E+01,
     & 66,158,  -7.04166160E+01,      66,159,  -6.91767770E+01/
      data (niz(i),nia(i),bie(i),i=4221,4240)/
     & 66,160,  -6.96815920E+01,      66,161,  -6.80646340E+01,
     & 66,162,  -6.81902580E+01,      66,163,  -6.63898660E+01,
     & 66,164,  -6.59766250E+01,      66,165,  -6.36211910E+01,
     & 66,166,  -6.25933680E+01,      66,167,  -5.99425380E+01,
     & 66,168,  -5.84700000E+01,      66,169,  -5.56067850E+01,
     & 66,170,  -5.34030000E+01,      66,171,  -4.98540000E+01,
     & 66,172,  -4.74040000E+01,      66,173,  -4.33700000E+01,
     & 66,174,  -4.18500000E+01,      66,175,  -3.74900000E+01,
     & 66,176,  -3.46700000E+01,      66,177,  -3.00000000E+01,
     & 66,178,  -2.69200000E+01,      66,179,  -2.20800000E+01/
      data (niz(i),nia(i),bie(i),i=4241,4260)/
     & 66,180,  -1.87700000E+01,      66,181,  -1.37000000E+01,
     & 66,182,  -1.00100000E+01,      66,183,  -4.55000000E+00,
     & 66,184,  -6.40000000E-01,      66,185,   5.13000000E+00,
     & 66,186,   8.79000000E+00,      66,187,   1.42700000E+01,
     & 66,188,   1.83300000E+01,      66,189,   2.37300000E+01,
     & 66,190,   2.76900000E+01,      66,191,   3.29800000E+01,
     & 66,192,   3.73000000E+01,      66,193,   4.50800000E+01,
     & 66,194,   5.09500000E+01,      66,195,   5.89400000E+01,
     & 66,196,   6.51800000E+01,      66,197,   7.30100000E+01,
     & 66,198,   7.91000000E+01,      66,199,   8.68500000E+01/
      data (niz(i),nia(i),bie(i),i=4261,4280)/
     & 66,200,   9.29300000E+01,      66,201,   1.00310000E+02,
     & 66,202,   1.06250000E+02,      66,203,   1.13870000E+02,
     & 66,204,   1.20120000E+02,      66,205,   1.27870000E+02,
     & 66,206,   1.34210000E+02,      66,207,   1.42120000E+02,
     & 66,208,   1.48640000E+02,      66,209,   1.56620000E+02,
     & 66,210,   1.62960000E+02,      66,211,   1.70960000E+02,
     & 66,212,   1.77700000E+02,      66,213,   1.86080000E+02,
     & 66,214,   1.93320000E+02,      66,215,   2.01990000E+02,
     & 66,216,   2.09430000E+02,      66,217,   2.18090000E+02,
     & 66,218,   2.25610000E+02,      66,219,   2.34800000E+02/
      data (niz(i),nia(i),bie(i),i=4281,4300)/
     & 66,220,   2.42690000E+02,      66,221,   2.52070000E+02,
     & 67,134,   1.50000000E-01,      67,135,  -6.30000000E+00,
     & 67,136,  -1.12700000E+01,      67,137,  -1.77100000E+01,
     & 67,138,  -2.17500000E+01,      67,139,  -2.71600000E+01,
     & 67,140,  -3.05200000E+01,      67,141,  -3.52800000E+01,
     & 67,142,  -3.73900000E+01,      67,143,  -4.22060000E+01,
     & 67,144,  -4.50470000E+01,      67,145,  -4.94810000E+01,
     & 67,146,  -5.20710000E+01,      67,147,  -5.60390000E+01,
     & 67,148,  -5.84330000E+01,      67,149,  -6.16742610E+01,
     & 67,150,  -6.20820000E+01,      67,151,  -6.36389230E+01/
      data (niz(i),nia(i),bie(i),i=4301,4320)/
     & 67,152,  -6.35832140E+01,      67,153,  -6.50233890E+01,
     & 67,154,  -6.46491510E+01,      67,155,  -6.60623980E+01,
     & 67,156,  -6.54740000E+01,      67,157,  -6.68923820E+01,
     & 67,158,  -6.61866160E+01,      67,159,  -6.73390540E+01,
     & 67,160,  -6.63915920E+01,      67,161,  -6.72057340E+01,
     & 67,162,  -6.60499750E+01,      67,163,  -6.63873010E+01,
     & 67,164,  -6.49897890E+01,      67,165,  -6.49072660E+01,
     & 67,166,  -6.30795840E+01,      67,167,  -6.22925380E+01,
     & 67,168,  -6.00846850E+01,      67,169,  -5.88067850E+01,
     & 67,170,  -5.62483020E+01,      67,171,  -5.45285080E+01/
      data (niz(i),nia(i),bie(i),i=4321,4340)/
     & 67,172,  -5.14000000E+01,      67,173,  -4.90990000E+01,
     & 67,174,  -4.55030000E+01,      67,175,  -4.28020000E+01,
     & 67,176,  -3.99500000E+01,      67,177,  -3.71700000E+01,
     & 67,178,  -3.29700000E+01,      67,179,  -2.98600000E+01,
     & 67,180,  -2.55000000E+01,      67,181,  -2.21900000E+01,
     & 67,182,  -1.75600000E+01,      67,183,  -1.38800000E+01,
     & 67,184,  -8.90000000E+00,      67,185,  -4.86000000E+00,
     & 67,186,   4.00000000E-01,      67,187,   4.02000000E+00,
     & 67,188,   9.15000000E+00,      67,189,   1.31600000E+01,
     & 67,190,   1.81400000E+01,      67,191,   2.21000000E+01/
      data (niz(i),nia(i),bie(i),i=4341,4360)/
     & 67,192,   2.71300000E+01,      67,193,   3.13500000E+01,
     & 67,194,   3.87100000E+01,      67,195,   4.46200000E+01,
     & 67,196,   5.23900000E+01,      67,197,   5.85100000E+01,
     & 67,198,   6.58500000E+01,      67,199,   7.18800000E+01,
     & 67,200,   7.92300000E+01,      67,201,   8.52200000E+01,
     & 67,202,   9.22200000E+01,      67,203,   9.81700000E+01,
     & 67,204,   1.05380000E+02,      67,205,   1.11590000E+02,
     & 67,206,   1.18960000E+02,      67,207,   1.25270000E+02,
     & 67,208,   1.32770000E+02,      67,209,   1.39370000E+02,
     & 67,210,   1.46870000E+02,      67,211,   1.53220000E+02/
      data (niz(i),nia(i),bie(i),i=4361,4380)/
     & 67,212,   1.60840000E+02,      67,213,   1.67700000E+02,
     & 67,214,   1.75620000E+02,      67,215,   1.82730000E+02,
     & 67,216,   1.90970000E+02,      67,217,   1.98310000E+02,
     & 67,218,   2.06550000E+02,      67,219,   2.14010000E+02,
     & 67,220,   2.22690000E+02,      67,221,   2.30640000E+02,
     & 67,222,   2.39600000E+02,      67,223,   2.47630000E+02,
     & 67,224,   2.56620000E+02,      68,131,   4.18600000E+01,
     & 68,132,   3.21900000E+01,      68,133,   2.53700000E+01,
     & 68,134,   1.67100000E+01,      68,135,   1.04700000E+01,
     & 68,136,   2.46000000E+00,      68,137,  -1.59000000E+00/
      data (niz(i),nia(i),bie(i),i=4381,4400)/
     & 68,138,  -9.87000000E+00,      68,139,  -1.40600000E+01,
     & 68,140,  -1.99800000E+01,      68,141,  -2.35000000E+01,
     & 68,142,  -2.88700000E+01,      68,143,  -3.19600000E+01,
     & 68,144,  -3.67100000E+01,      68,145,  -3.96260000E+01,
     & 68,146,  -4.46000000E+01,      68,147,  -4.72170000E+01,
     & 68,148,  -5.17540000E+01,      68,149,  -5.38640000E+01,
     & 68,150,  -5.79740000E+01,      68,151,  -5.82560000E+01,
     & 68,152,  -6.04740240E+01,      68,153,  -6.04603550E+01,
     & 68,154,  -6.26175380E+01,      68,155,  -6.22198100E+01,
     & 68,156,  -6.42591030E+01,      68,157,  -6.33923330E+01/
      data (niz(i),nia(i),bie(i),i=4401,4420)/
     & 68,158,  -6.52870000E+01,      68,159,  -6.45704860E+01,
     & 68,160,  -6.60625470E+01,      68,161,  -6.52033150E+01,
     & 68,162,  -6.63457220E+01,      68,163,  -6.51773030E+01,
     & 68,164,  -6.59525630E+01,      68,165,  -6.45312860E+01,
     & 68,166,  -6.49344640E+01,      68,167,  -6.32992480E+01,
     & 68,168,  -6.29989970E+01,      68,169,  -6.09308000E+01,
     & 68,170,  -6.01183020E+01,      68,171,  -5.77285080E+01,
     & 68,172,  -5.64931010E+01,      68,173,  -5.36540000E+01,
     & 68,174,  -5.18470000E+01,      68,175,  -4.85030000E+01,
     & 68,176,  -4.63050000E+01,      68,177,  -4.25040000E+01/
      data (niz(i),nia(i),bie(i),i=4421,4440)/
     & 68,178,  -4.13100000E+01,      68,179,  -3.72300000E+01,
     & 68,180,  -3.46200000E+01,      68,181,  -3.03300000E+01,
     & 68,182,  -2.74900000E+01,      68,183,  -2.28700000E+01,
     & 68,184,  -1.96300000E+01,      68,185,  -1.46800000E+01,
     & 68,186,  -1.10500000E+01,      68,187,  -5.88000000E+00,
     & 68,188,  -2.68000000E+00,      68,189,   2.44000000E+00,
     & 68,190,   6.02000000E+00,      68,191,   1.09800000E+01,
     & 68,192,   1.45400000E+01,      68,193,   1.94300000E+01,
     & 68,194,   2.33900000E+01,      68,195,   3.07300000E+01,
     & 68,196,   3.61400000E+01,      68,197,   4.39500000E+01/
      data (niz(i),nia(i),bie(i),i=4441,4460)/
     & 68,198,   4.97100000E+01,      68,199,   5.71800000E+01,
     & 68,200,   6.28100000E+01,      68,201,   7.01400000E+01,
     & 68,202,   7.57700000E+01,      68,203,   8.28600000E+01,
     & 68,204,   8.84400000E+01,      68,205,   9.56400000E+01,
     & 68,206,   1.01460000E+02,      68,207,   1.08840000E+02,
     & 68,208,   1.14770000E+02,      68,209,   1.22220000E+02,
     & 68,210,   1.28400000E+02,      68,211,   1.36060000E+02,
     & 68,212,   1.42200000E+02,      68,213,   1.49630000E+02,
     & 68,214,   1.55960000E+02,      68,215,   1.63900000E+02,
     & 68,216,   1.70580000E+02,      68,217,   1.78750000E+02/
      data (niz(i),nia(i),bie(i),i=4461,4480)/
     & 68,218,   1.85640000E+02,      68,219,   1.93840000E+02,
     & 68,220,   2.00900000E+02,      68,221,   2.09600000E+02,
     & 68,222,   2.17050000E+02,      68,223,   2.25940000E+02,
     & 68,224,   2.33520000E+02,      68,225,   2.42530000E+02,
     & 68,226,   2.50210000E+02,      68,227,   2.59200000E+02,
     & 69,140,  -1.40000000E+00,      69,141,  -1.03600000E+01,
     & 69,142,  -1.43800000E+01,      69,143,  -1.97800000E+01,
     & 69,144,  -2.36000000E+01,      69,145,  -2.86300000E+01,
     & 69,146,  -3.12100000E+01,      69,147,  -3.62530000E+01,
     & 69,148,  -3.95420000E+01,      69,149,  -4.41060000E+01/
      data (niz(i),nia(i),bie(i),i=4481,4500)/
     & 69,150,  -4.68820000E+01,      69,151,  -5.08280000E+01,
     & 69,152,  -5.18840000E+01,      69,153,  -5.40009050E+01,
     & 69,154,  -5.45640000E+01,      69,155,  -5.66426870E+01,
     & 69,156,  -5.68147030E+01,      69,157,  -5.89113330E+01,
     & 69,158,  -5.86870000E+01,      69,159,  -6.07250480E+01,
     & 69,160,  -6.04625470E+01,      69,161,  -6.20393150E+01,
     & 69,162,  -6.15064020E+01,      69,163,  -6.27383030E+01,
     & 69,164,  -6.19900110E+01,      69,165,  -6.29387460E+01,
     & 69,166,  -6.18948490E+01,      69,167,  -6.25508900E+01,
     & 69,168,  -6.13198910E+01,      69,169,  -6.12819400E+01/
      data (niz(i),nia(i),bie(i),i=4501,4520)/
     & 69,170,  -5.98038830E+01,      69,171,  -5.92189610E+01,
     & 69,172,  -5.73836380E+01,      69,173,  -5.62619160E+01,
     & 69,174,  -5.38733030E+01,      69,175,  -5.23193110E+01,
     & 69,176,  -4.93771740E+01,      69,177,  -4.74690000E+01,
     & 69,178,  -4.41160000E+01,      69,179,  -4.16010000E+01,
     & 69,180,  -3.90800000E+01,      69,181,  -3.65200000E+01,
     & 69,182,  -3.26700000E+01,      69,183,  -2.98600000E+01,
     & 69,184,  -2.56800000E+01,      69,185,  -2.25200000E+01,
     & 69,186,  -1.79800000E+01,      69,187,  -1.43700000E+01,
     & 69,188,  -9.57000000E+00,      69,189,  -6.44000000E+00/
      data (niz(i),nia(i),bie(i),i=4521,4540)/
     & 69,190,  -1.72000000E+00,      69,191,   1.85000000E+00,
     & 69,192,   6.36000000E+00,      69,193,   9.92000000E+00,
     & 69,194,   1.44200000E+01,      69,195,   1.82800000E+01,
     & 69,196,   2.52800000E+01,      69,197,   3.06600000E+01,
     & 69,198,   3.81100000E+01,      69,199,   4.40200000E+01,
     & 69,200,   5.08000000E+01,      69,201,   5.64700000E+01,
     & 69,202,   6.34500000E+01,      69,203,   6.90800000E+01,
     & 69,204,   7.58000000E+01,      69,205,   8.14000000E+01,
     & 69,206,   8.81900000E+01,      69,207,   9.39800000E+01,
     & 69,208,   1.00960000E+02,      69,209,   1.06860000E+02/
      data (niz(i),nia(i),bie(i),i=4541,4560)/
     & 69,210,   1.13920000E+02,      69,211,   1.20070000E+02,
     & 69,212,   1.27280000E+02,      69,213,   1.33390000E+02,
     & 69,214,   1.40790000E+02,      69,215,   1.46900000E+02,
     & 69,216,   1.54320000E+02,      69,217,   1.61040000E+02,
     & 69,218,   1.68810000E+02,      69,219,   1.75670000E+02,
     & 69,220,   1.83490000E+02,      69,221,   1.90510000E+02,
     & 69,222,   1.98800000E+02,      69,223,   2.06210000E+02,
     & 69,224,   2.14660000E+02,      69,225,   2.22230000E+02,
     & 69,226,   2.30790000E+02,      69,227,   2.38420000E+02,
     & 69,228,   2.47050000E+02,      69,229,   2.54750000E+02/
      data (niz(i),nia(i),bie(i),i=4561,4580)/
     & 69,230,   2.63470000E+02,      70,136,   4.16400000E+01,
     & 70,137,   3.48500000E+01,      70,138,   2.60200000E+01,
     & 70,139,   1.98400000E+01,      70,140,   1.16400000E+01,
     & 70,141,   7.43000000E+00,      70,142,   7.60000000E-01,
     & 70,143,  -6.29000000E+00,      70,144,  -1.22800000E+01,
     & 70,145,  -1.61200000E+01,      70,146,  -2.01700000E+01,
     & 70,147,  -2.39500000E+01,      70,148,  -3.09630000E+01,
     & 70,149,  -3.40180000E+01,      70,150,  -3.91320000E+01,
     & 70,151,  -4.16850000E+01,      70,152,  -4.64190000E+01,
     & 70,153,  -4.73110000E+01,      70,154,  -5.00750000E+01/
      data (niz(i),nia(i),bie(i),i=4581,4600)/
     & 70,155,  -5.04940000E+01,      70,156,  -5.32375670E+01,
     & 70,157,  -5.34131150E+01,      70,158,  -5.60220000E+01,
     & 70,159,  -5.57464280E+01,      70,160,  -5.81630000E+01,
     & 70,161,  -5.78890000E+01,      70,162,  -5.98480000E+01,
     & 70,163,  -5.93683030E+01,      70,164,  -6.09940000E+01,
     & 70,165,  -6.01767460E+01,      70,166,  -6.15907250E+01,
     & 70,167,  -6.05965980E+01,      70,168,  -6.15769000E+01,
     & 70,169,  -6.03728000E+01,      70,170,  -6.07719160E+01,
     & 70,171,  -5.93153890E+01,      70,172,  -5.92637860E+01,
     & 70,173,  -5.75600270E+01,      70,174,  -5.69533030E+01/
      data (niz(i),nia(i),bie(i),i=4601,4620)/
     & 70,175,  -5.47043110E+01,      70,176,  -5.34971740E+01,
     & 70,177,  -5.09926510E+01,      70,178,  -4.97013490E+01,
     & 70,179,  -4.64160000E+01,      70,180,  -4.44040000E+01,
     & 70,181,  -4.08460000E+01,      70,182,  -4.01000000E+01,
     & 70,183,  -3.61900000E+01,      70,184,  -3.39700000E+01,
     & 70,185,  -2.99000000E+01,      70,186,  -2.71200000E+01,
     & 70,187,  -2.26500000E+01,      70,188,  -1.95400000E+01,
     & 70,189,  -1.47300000E+01,      70,190,  -1.20400000E+01,
     & 70,191,  -7.39000000E+00,      70,192,  -4.28000000E+00,
     & 70,193,   1.60000000E-01,      70,194,   3.29000000E+00/
      data (niz(i),nia(i),bie(i),i=4621,4640)/
     & 70,195,   7.75000000E+00,      70,196,   1.12500000E+01,
     & 70,197,   1.80500000E+01,      70,198,   2.31300000E+01,
     & 70,199,   3.06900000E+01,      70,200,   3.61300000E+01,
     & 70,201,   4.30100000E+01,      70,202,   4.83300000E+01,
     & 70,203,   5.51800000E+01,      70,204,   6.06200000E+01,
     & 70,205,   6.74400000E+01,      70,206,   7.26800000E+01,
     & 70,207,   7.94700000E+01,      70,208,   8.48800000E+01,
     & 70,209,   9.18400000E+01,      70,210,   9.73600000E+01,
     & 70,211,   1.04460000E+02,      70,212,   1.10180000E+02,
     & 70,213,   1.17370000E+02,      70,214,   1.23250000E+02/
      data (niz(i),nia(i),bie(i),i=4641,4660)/
     & 70,215,   1.30490000E+02,      70,216,   1.36260000E+02,
     & 70,217,   1.43780000E+02,      70,218,   1.50020000E+02,
     & 70,219,   1.57710000E+02,      70,220,   1.64180000E+02,
     & 70,221,   1.71980000E+02,      70,222,   1.78630000E+02,
     & 70,223,   1.86910000E+02,      70,224,   1.93940000E+02,
     & 70,225,   2.02360000E+02,      70,226,   2.09500000E+02,
     & 70,227,   2.17990000E+02,      70,228,   2.25240000E+02,
     & 70,229,   2.33720000E+02,      70,230,   2.40990000E+02,
     & 70,231,   2.49630000E+02,      70,232,   2.57100000E+02,
     & 70,233,   2.66350000E+02,      70,234,   2.74470000E+02/
      data (niz(i),nia(i),bie(i),i=4661,4680)/
     & 71,144,   7.15000000E+00,      71,145,   7.90000000E-01,
     & 71,146,  -6.43000000E+00,      71,147,  -1.08000000E+01,
     & 71,148,  -1.50800000E+01,      71,149,  -2.11400000E+01,
     & 71,150,  -2.54600000E+01,      71,151,  -3.06020000E+01,
     & 71,152,  -3.38970000E+01,      71,153,  -3.84800000E+01,
     & 71,154,  -3.99610000E+01,      71,155,  -4.26320000E+01,
     & 71,156,  -4.38660000E+01,      71,157,  -4.64801130E+01,
     & 71,158,  -4.73490000E+01,      71,159,  -4.97276940E+01,
     & 71,160,  -5.02830000E+01,      71,161,  -5.25890000E+01,
     & 71,162,  -5.28880000E+01,      71,163,  -5.47683030E+01/
      data (niz(i),nia(i),bie(i),i=4681,4700)/
     & 71,164,  -5.47580000E+01,      71,165,  -5.62567460E+01,
     & 71,166,  -5.61107250E+01,      71,167,  -5.74665980E+01,
     & 71,168,  -5.71019000E+01,      71,169,  -5.80798000E+01,
     & 71,170,  -5.73127780E+01,      71,171,  -5.78365440E+01,
     & 71,172,  -5.67445200E+01,      71,173,  -5.68892160E+01,
     & 71,174,  -5.55789580E+01,      71,175,  -5.51743340E+01,
     & 71,176,  -5.33909930E+01,      71,177,  -5.23918840E+01,
     & 71,178,  -5.03459710E+01,      71,179,  -4.90671700E+01,
     & 71,180,  -4.66865020E+01,      71,181,  -4.47400000E+01,
     & 71,182,  -4.17220000E+01,      71,183,  -3.95230000E+01/
      data (niz(i),nia(i),bie(i),i=4701,4720)/
     & 71,184,  -3.61700000E+01,      71,185,  -3.52000000E+01,
     & 71,186,  -3.16300000E+01,      71,187,  -2.89800000E+01,
     & 71,188,  -2.49900000E+01,      71,189,  -2.19100000E+01,
     & 71,190,  -1.73800000E+01,      71,191,  -1.47500000E+01,
     & 71,192,  -1.05600000E+01,      71,193,  -7.50000000E+00,
     & 71,194,  -3.52000000E+00,      71,195,  -4.10000000E-01,
     & 71,196,   3.69000000E+00,      71,197,   7.21000000E+00,
     & 71,198,   1.34700000E+01,      71,199,   1.85300000E+01,
     & 71,200,   2.56100000E+01,      71,201,   3.11300000E+01,
     & 71,202,   3.76200000E+01,      71,203,   4.29300000E+01/
      data (niz(i),nia(i),bie(i),i=4721,4740)/
     & 71,204,   4.94300000E+01,      71,205,   5.48400000E+01,
     & 71,206,   6.12800000E+01,      71,207,   6.65600000E+01,
     & 71,208,   7.30400000E+01,      71,209,   7.83800000E+01,
     & 71,210,   8.49400000E+01,      71,211,   9.04500000E+01,
     & 71,212,   9.71700000E+01,      71,213,   1.02840000E+02,
     & 71,214,   1.09680000E+02,      71,215,   1.15520000E+02,
     & 71,216,   1.22410000E+02,      71,217,   1.28440000E+02,
     & 71,218,   1.35590000E+02,      71,219,   1.41460000E+02,
     & 71,220,   1.48820000E+02,      71,221,   1.55240000E+02,
     & 71,222,   1.62660000E+02,      71,223,   1.69270000E+02/
      data (niz(i),nia(i),bie(i),i=4741,4760)/
     & 71,224,   1.77170000E+02,      71,225,   1.84140000E+02,
     & 71,226,   1.92200000E+02,      71,227,   1.99320000E+02,
     & 71,228,   2.07440000E+02,      71,229,   2.14610000E+02,
     & 71,230,   2.22710000E+02,      71,231,   2.29910000E+02,
     & 71,232,   2.38150000E+02,      71,233,   2.45560000E+02,
     & 71,234,   2.54490000E+02,      71,235,   2.62420000E+02,
     & 71,236,   2.71520000E+02,      71,237,   2.79640000E+02,
     & 72,140,   5.15000000E+01,      72,141,   4.46100000E+01,
     & 72,142,   3.56700000E+01,      72,143,   2.91500000E+01,
     & 72,144,   2.06900000E+01,      72,145,   1.61500000E+01/
      data (niz(i),nia(i),bie(i),i=4761,4780)/
     & 72,146,   9.49000000E+00,      72,147,   5.16000000E+00,
     & 72,148,  -1.69000000E+00,      72,149,  -7.26000000E+00,
     & 72,150,  -1.39800000E+01,      72,151,  -1.78500000E+01,
     & 72,152,  -2.39000000E+01,      72,153,  -2.72600000E+01,
     & 72,154,  -3.33010000E+01,      72,155,  -3.46890000E+01,
     & 72,156,  -3.79610000E+01,      72,157,  -3.90040000E+01,
     & 72,158,  -4.22460000E+01,      72,159,  -4.28460000E+01,
     & 72,160,  -4.59099900E+01,      72,161,  -4.62665060E+01,
     & 72,162,  -4.91801030E+01,      72,163,  -4.93160000E+01,
     & 72,164,  -5.17700000E+01,      72,165,  -5.16610000E+01/
      data (niz(i),nia(i),bie(i),i=4781,4800)/
     & 72,166,  -5.37940000E+01,      72,167,  -5.34680000E+01,
     & 72,168,  -5.53030000E+01,      72,169,  -5.48104340E+01,
     & 72,170,  -5.62160000E+01,      72,171,  -5.54330000E+01,
     & 72,172,  -5.63945200E+01,      72,173,  -5.52840000E+01,
     & 72,174,  -5.58522240E+01,      72,175,  -5.44896050E+01,
     & 72,176,  -5.45838380E+01,      72,177,  -5.28902090E+01,
     & 72,178,  -5.24452160E+01,      72,179,  -5.04729270E+01,
     & 72,180,  -4.97895020E+01,      72,181,  -4.74138530E+01,
     & 72,182,  -4.60596770E+01,      72,183,  -4.32855770E+01,
     & 72,184,  -4.15000260E+01,      72,185,  -3.83960000E+01/
      data (niz(i),nia(i),bie(i),i=4801,4820)/
     & 72,186,  -3.64030000E+01,      72,187,  -3.44200000E+01,
     & 72,188,  -3.22900000E+01,      72,189,  -2.83000000E+01,
     & 72,190,  -2.60100000E+01,      72,191,  -2.14700000E+01,
     & 72,192,  -1.93100000E+01,      72,193,  -1.52200000E+01,
     & 72,194,  -1.27700000E+01,      72,195,  -8.74000000E+00,
     & 72,196,  -6.09000000E+00,      72,197,  -2.00000000E+00,
     & 72,198,   1.06000000E+00,      72,199,   7.30000000E+00,
     & 72,200,   1.19300000E+01,      72,201,   1.87900000E+01,
     & 72,202,   2.39800000E+01,      72,203,   3.07800000E+01,
     & 72,204,   3.57100000E+01,      72,205,   4.23400000E+01/
      data (niz(i),nia(i),bie(i),i=4821,4840)/
     & 72,206,   4.71800000E+01,      72,207,   5.38900000E+01,
     & 72,208,   5.88100000E+01,      72,209,   6.52700000E+01,
     & 72,210,   7.03000000E+01,      72,211,   7.68600000E+01,
     & 72,212,   8.19600000E+01,      72,213,   8.86700000E+01,
     & 72,214,   9.39900000E+01,      72,215,   1.00810000E+02,
     & 72,216,   1.06250000E+02,      72,217,   1.13180000E+02,
     & 72,218,   1.18820000E+02,      72,219,   1.25970000E+02,
     & 72,220,   1.31770000E+02,      72,221,   1.38850000E+02,
     & 72,222,   1.44850000E+02,      72,223,   1.52320000E+02,
     & 72,224,   1.58480000E+02,      72,225,   1.66480000E+02/
      data (niz(i),nia(i),bie(i),i=4841,4860)/
     & 72,226,   1.73010000E+02,      72,227,   1.81330000E+02,
     & 72,228,   1.87990000E+02,      72,229,   1.96020000E+02,
     & 72,230,   2.02560000E+02,      72,231,   2.10600000E+02,
     & 72,232,   2.17400000E+02,      72,233,   2.25590000E+02,
     & 72,234,   2.32600000E+02,      72,235,   2.41440000E+02,
     & 72,236,   2.49110000E+02,      72,237,   2.58020000E+02,
     & 72,238,   2.65780000E+02,      72,239,   2.74820000E+02,
     & 72,240,   2.84420000E+02,      73,148,   1.53100000E+01,
     & 73,149,   8.59000000E+00,      73,150,   3.79000000E+00,
     & 73,151,  -4.33000000E+00,      73,152,  -8.78000000E+00/
      data (niz(i),nia(i),bie(i),i=4861,4880)/
     & 73,153,  -1.49200000E+01,      73,154,  -1.87800000E+01,
     & 73,155,  -2.48700000E+01,      73,156,  -2.63710000E+01,
     & 73,157,  -2.96730000E+01,      73,158,  -3.13280000E+01,
     & 73,159,  -3.45450000E+01,      73,160,  -3.59950000E+01,
     & 73,161,  -3.87753020E+01,      73,162,  -3.99170000E+01,
     & 73,163,  -4.25537600E+01,      73,164,  -4.32490000E+01,
     & 73,165,  -4.58130000E+01,      73,166,  -4.61370000E+01,
     & 73,167,  -4.84630000E+01,      73,168,  -4.86360000E+01,
     & 73,169,  -5.03750000E+01,      73,170,  -5.02170000E+01,
     & 73,171,  -5.17350000E+01,      73,172,  -5.14745200E+01/
      data (niz(i),nia(i),bie(i),i=4881,4900)/
     & 73,173,  -5.25940000E+01,      73,174,  -5.20072240E+01,
     & 73,175,  -5.24900000E+01,      73,176,  -5.14738380E+01,
     & 73,177,  -5.17242090E+01,      73,178,  -5.05332160E+01,
     & 73,179,  -5.03620410E+01,      73,180,  -4.89354200E+01,
     & 73,181,  -4.84410850E+01,      73,182,  -4.64327200E+01,
     & 73,183,  -4.52955770E+01,      73,184,  -4.28400260E+01,
     & 73,185,  -4.13964390E+01,      73,186,  -3.86103270E+01,
     & 73,187,  -3.68780000E+01,      73,188,  -3.38040000E+01,
     & 73,189,  -3.30300000E+01,      73,190,  -2.95300000E+01,
     & 73,191,  -2.74700000E+01,      73,192,  -2.31500000E+01/
      data (niz(i),nia(i),bie(i),i=4901,4920)/
     & 73,193,  -2.10500000E+01,      73,194,  -1.74400000E+01,
     & 73,195,  -1.50700000E+01,      73,196,  -1.14700000E+01,
     & 73,197,  -8.86000000E+00,      73,198,  -5.17000000E+00,
     & 73,199,  -2.12000000E+00,      73,200,   3.69000000E+00,
     & 73,201,   8.27000000E+00,      73,202,   1.48100000E+01,
     & 73,203,   1.98800000E+01,      73,204,   2.62200000E+01,
     & 73,205,   3.12100000E+01,      73,206,   3.74000000E+01,
     & 73,207,   4.22900000E+01,      73,208,   4.86600000E+01,
     & 73,209,   5.35800000E+01,      73,210,   5.97100000E+01,
     & 73,211,   6.47800000E+01,      73,212,   7.09100000E+01/
      data (niz(i),nia(i),bie(i),i=4921,4940)/
     & 73,213,   7.60100000E+01,      73,214,   8.23400000E+01,
     & 73,215,   8.76400000E+01,      73,216,   9.41400000E+01,
     & 73,217,   9.95500000E+01,      73,218,   1.06220000E+02,
     & 73,219,   1.11830000E+02,      73,220,   1.18560000E+02,
     & 73,221,   1.24340000E+02,      73,222,   1.31250000E+02,
     & 73,223,   1.37230000E+02,      73,224,   1.44360000E+02,
     & 73,225,   1.50260000E+02,      73,226,   1.58120000E+02,
     & 73,227,   1.64570000E+02,      73,228,   1.72370000E+02,
     & 73,229,   1.78980000E+02,      73,230,   1.86620000E+02,
     & 73,231,   1.93280000E+02,      73,232,   2.00780000E+02/
      data (niz(i),nia(i),bie(i),i=4941,4960)/
     & 73,233,   2.07510000E+02,      73,234,   2.15350000E+02,
     & 73,235,   2.22300000E+02,      73,236,   2.30760000E+02,
     & 73,237,   2.38240000E+02,      73,238,   2.46860000E+02,
     & 73,239,   2.54570000E+02,      73,240,   2.63860000E+02,
     & 73,241,   2.72550000E+02,      73,242,   2.81490000E+02,
     & 73,243,   2.89210000E+02,      74,146,   4.51700000E+01,
     & 74,147,   3.81600000E+01,      74,148,   2.93900000E+01,
     & 74,149,   2.46000000E+01,      74,150,   1.72300000E+01,
     & 74,151,   1.23000000E+01,      74,152,   5.05000000E+00,
     & 74,153,   3.50000000E-01,      74,154,  -7.65000000E+00/
      data (niz(i),nia(i),bie(i),i=4961,4980)/
     & 74,155,  -1.17000000E+01,      74,156,  -1.81700000E+01,
     & 74,157,  -2.01600000E+01,      74,158,  -2.42760000E+01,
     & 74,159,  -2.58210000E+01,      74,160,  -2.94640000E+01,
     & 74,161,  -3.06560000E+01,      74,162,  -3.41470000E+01,
     & 74,163,  -3.49010000E+01,      74,164,  -3.82063290E+01,
     & 74,165,  -3.88097950E+01,      74,166,  -4.18986910E+01,
     & 74,167,  -4.22230000E+01,      74,168,  -4.48390000E+01,
     & 74,169,  -4.49360000E+01,      74,170,  -4.72360000E+01,
     & 74,171,  -4.70780000E+01,      74,172,  -4.89750000E+01,
     & 74,173,  -4.85940000E+01,      74,174,  -5.01520000E+01/
      data (niz(i),nia(i),bie(i),i=4981,5000)/
     & 74,175,  -4.95830000E+01,      74,176,  -5.06830000E+01,
     & 74,177,  -4.97230000E+01,      74,178,  -5.04419160E+01,
     & 74,179,  -4.93023560E+01,      74,180,  -4.96432820E+01,
     & 74,181,  -4.82531950E+01,      74,182,  -4.82462410E+01,
     & 74,183,  -4.63656110E+01,      74,184,  -4.57060260E+01,
     & 74,185,  -4.33884390E+01,      74,186,  -4.25113270E+01,
     & 74,187,  -3.99067200E+01,      74,188,  -3.86691480E+01,
     & 74,189,  -3.54785340E+01,      74,190,  -3.42980320E+01,
     & 74,191,  -3.21700000E+01,      74,192,  -3.04700000E+01,
     & 74,193,  -2.61700000E+01,      74,194,  -2.45500000E+01/
      data (niz(i),nia(i),bie(i),i=5001,5020)/
     & 74,195,  -2.10400000E+01,      74,196,  -1.92200000E+01,
     & 74,197,  -1.56800000E+01,      74,198,  -1.36100000E+01,
     & 74,199,  -1.00100000E+01,      74,200,  -7.34000000E+00,
     & 74,201,  -1.53000000E+00,      74,202,   2.56000000E+00,
     & 74,203,   8.94000000E+00,      74,204,   1.36200000E+01,
     & 74,205,   2.02200000E+01,      74,206,   2.48400000E+01,
     & 74,207,   3.12400000E+01,      74,208,   3.57100000E+01,
     & 74,209,   4.19700000E+01,      74,210,   4.67200000E+01,
     & 74,211,   5.29200000E+01,      74,212,   5.75800000E+01,
     & 74,213,   6.38100000E+01,      74,214,   6.85400000E+01/
      data (niz(i),nia(i),bie(i),i=5021,5040)/
     & 74,215,   7.48800000E+01,      74,216,   7.98100000E+01,
     & 74,217,   8.62900000E+01,      74,218,   9.13300000E+01,
     & 74,219,   9.79200000E+01,      74,220,   1.03210000E+02,
     & 74,221,   1.09920000E+02,      74,222,   1.15360000E+02,
     & 74,223,   1.22250000E+02,      74,224,   1.27870000E+02,
     & 74,225,   1.35000000E+02,      74,226,   1.40850000E+02,
     & 74,227,   1.48380000E+02,      74,228,   1.54590000E+02,
     & 74,229,   1.62190000E+02,      74,230,   1.68400000E+02,
     & 74,231,   1.76020000E+02,      74,232,   1.82300000E+02,
     & 74,233,   1.89910000E+02,      74,234,   1.96290000E+02/
      data (niz(i),nia(i),bie(i),i=5041,5060)/
     & 74,235,   2.04090000E+02,      74,236,   2.10650000E+02,
     & 74,237,   2.18950000E+02,      74,238,   2.26160000E+02,
     & 74,239,   2.34840000E+02,      74,240,   2.42390000E+02,
     & 74,241,   2.51190000E+02,      74,242,   2.59530000E+02,
     & 74,243,   2.68150000E+02,      74,244,   2.75330000E+02,
     & 74,245,   2.86500000E+02,      74,246,   2.93780000E+02,
     & 74,247,   3.03290000E+02,      75,154,   1.01100000E+01,
     & 75,155,   3.26000000E+00,      75,156,  -2.46000000E+00,
     & 75,157,  -9.06000000E+00,      75,158,  -1.14900000E+01,
     & 75,159,  -1.57100000E+01,      75,160,  -1.72470000E+01/
      data (niz(i),nia(i),bie(i),i=5061,5080)/
     & 75,161,  -2.08090000E+01,      75,162,  -2.26290000E+01,
     & 75,163,  -2.61120000E+01,      75,164,  -2.76470000E+01,
     & 75,165,  -3.06924730E+01,      75,166,  -3.18550000E+01,
     & 75,167,  -3.48720000E+01,      75,168,  -3.57610000E+01,
     & 75,169,  -3.83500000E+01,      75,170,  -3.89710000E+01,
     & 75,171,  -4.14080000E+01,      75,172,  -4.16510000E+01,
     & 75,173,  -4.37220000E+01,      75,174,  -4.36760000E+01,
     & 75,175,  -4.52770000E+01,      75,176,  -4.51120000E+01,
     & 75,177,  -4.63230000E+01,      75,178,  -4.57819160E+01,
     & 75,179,  -4.65923560E+01,      75,180,  -4.58409740E+01/
      data (niz(i),nia(i),bie(i),i=5081,5100)/
     & 75,181,  -4.65145220E+01,      75,182,  -4.54462410E+01,
     & 75,183,  -4.58096110E+01,      75,184,  -4.42233340E+01,
     & 75,185,  -4.38214330E+01,      75,186,  -4.19297710E+01,
     & 75,187,  -4.12178710E+01,      75,188,  -3.90181480E+01,
     & 75,189,  -3.79785340E+01,      75,190,  -3.55680320E+01,
     & 75,191,  -3.43501480E+01,      75,192,  -3.17080000E+01,
     & 75,193,  -3.09000000E+01,      75,194,  -2.76000000E+01,
     & 75,195,  -2.54100000E+01,      75,196,  -2.23400000E+01,
     & 75,197,  -2.06600000E+01,      75,198,  -1.75300000E+01,
     & 75,199,  -1.55000000E+01,      75,200,  -1.21300000E+01/
      data (niz(i),nia(i),bie(i),i=5101,5120)/
     & 75,201,  -9.53000000E+00,      75,202,  -4.19000000E+00,
     & 75,203,  -2.52000000E+00,      75,204,   6.05000000E+00,
     & 75,205,   1.05600000E+01,      75,206,   1.65700000E+01,
     & 75,207,   2.11800000E+01,      75,208,   2.71600000E+01,
     & 75,209,   3.17200000E+01,      75,210,   3.76100000E+01,
     & 75,211,   4.24000000E+01,      75,212,   4.82600000E+01,
     & 75,213,   5.29500000E+01,      75,214,   5.88300000E+01,
     & 75,215,   6.35600000E+01,      75,216,   6.95100000E+01,
     & 75,217,   7.44400000E+01,      75,218,   8.05600000E+01,
     & 75,219,   8.55900000E+01,      75,220,   9.18400000E+01/
      data (niz(i),nia(i),bie(i),i=5121,5140)/
     & 75,221,   9.70500000E+01,      75,222,   1.03460000E+02,
     & 75,223,   1.08860000E+02,      75,224,   1.15370000E+02,
     & 75,225,   1.21010000E+02,      75,226,   1.27720000E+02,
     & 75,227,   1.33550000E+02,      75,228,   1.40750000E+02,
     & 75,229,   1.46820000E+02,      75,230,   1.54050000E+02,
     & 75,231,   1.60260000E+02,      75,232,   1.67610000E+02,
     & 75,233,   1.73850000E+02,      75,234,   1.81150000E+02,
     & 75,235,   1.87420000E+02,      75,236,   1.94940000E+02,
     & 75,237,   2.01420000E+02,      75,238,   2.09400000E+02,
     & 75,239,   2.16630000E+02,      75,240,   2.24900000E+02/
      data (niz(i),nia(i),bie(i),i=5141,5160)/
     & 75,241,   2.32800000E+02,      75,242,   2.41490000E+02,
     & 75,243,   2.48800000E+02,      75,244,   2.57090000E+02,
     & 75,245,   2.65140000E+02,      75,246,   2.75020000E+02,
     & 75,247,   2.82390000E+02,      75,248,   2.91340000E+02,
     & 75,249,   2.98720000E+02,      75,250,   3.07220000E+02,
     & 76,152,   3.76900000E+01,      76,153,   3.20300000E+01,
     & 76,154,   2.42500000E+01,      76,155,   1.90600000E+01,
     & 76,156,   1.16500000E+01,      76,157,   6.49000000E+00,
     & 76,158,  -3.00000000E-01,      76,159,  -4.33000000E+00,
     & 76,160,  -9.07000000E+00,      76,161,  -1.07100000E+01/
      data (niz(i),nia(i),bie(i),i=5161,5180)/
     & 76,162,  -1.50720000E+01,      76,163,  -1.67220000E+01,
     & 76,164,  -2.05610000E+01,      76,165,  -2.19140000E+01,
     & 76,166,  -2.55920000E+01,      76,167,  -2.64970000E+01,
     & 76,168,  -2.99634460E+01,      76,169,  -3.06683130E+01,
     & 76,170,  -3.39345860E+01,      76,171,  -3.44280000E+01,
     & 76,172,  -3.71870000E+01,      76,173,  -3.74540000E+01,
     & 76,174,  -3.99390000E+01,      76,175,  -3.99800000E+01,
     & 76,176,  -4.19640000E+01,      76,177,  -4.18750000E+01,
     & 76,178,  -4.34558420E+01,      76,179,  -4.28940000E+01,
     & 76,180,  -4.43850000E+01,      76,181,  -4.35245220E+01/
      data (niz(i),nia(i),bie(i),i=5181,5200)/
     & 76,182,  -4.45382410E+01,      76,183,  -4.36780000E+01,
     & 76,184,  -4.42545210E+01,      76,185,  -4.28086420E+01,
     & 76,186,  -4.29992890E+01,      76,187,  -4.12205340E+01,
     & 76,188,  -4.11385010E+01,      76,189,  -3.89878000E+01,
     & 76,190,  -3.87080320E+01,      76,191,  -3.63953740E+01,
     & 76,192,  -3.58820310E+01,      76,193,  -3.33958400E+01,
     & 76,194,  -3.24352550E+01,      76,195,  -2.96924020E+01,
     & 76,196,  -2.82964080E+01,      76,197,  -2.50900000E+01,
     & 76,198,  -2.39000000E+01,      76,199,  -2.08500000E+01,
     & 76,200,  -1.92900000E+01,      76,201,  -1.61400000E+01/
      data (niz(i),nia(i),bie(i),i=5201,5220)/
     & 76,202,  -1.39000000E+01,      76,203,  -8.64000000E+00,
     & 76,204,  -4.89000000E+00,      76,205,   1.11000000E+00,
     & 76,206,   5.25000000E+00,      76,207,   1.13900000E+01,
     & 76,208,   1.56600000E+01,      76,209,   2.18200000E+01,
     & 76,210,   2.60400000E+01,      76,211,   3.19400000E+01,
     & 76,212,   3.62600000E+01,      76,213,   4.23300000E+01,
     & 76,214,   4.66800000E+01,      76,215,   5.26000000E+01,
     & 76,216,   5.70000000E+01,      76,217,   6.30300000E+01,
     & 76,218,   6.75800000E+01,      76,219,   7.37400000E+01,
     & 76,220,   7.83600000E+01,      76,221,   8.46200000E+01/
      data (niz(i),nia(i),bie(i),i=5221,5240)/
     & 76,222,   8.94800000E+01,      76,223,   9.58400000E+01,
     & 76,224,   1.00850000E+02,      76,225,   1.07400000E+02,
     & 76,226,   1.12640000E+02,      76,227,   1.19390000E+02,
     & 76,228,   1.24860000E+02,      76,229,   1.32040000E+02,
     & 76,230,   1.37760000E+02,      76,231,   1.45000000E+02,
     & 76,232,   1.50890000E+02,      76,233,   1.58300000E+02,
     & 76,234,   1.64190000E+02,      76,235,   1.71490000E+02,
     & 76,236,   1.77430000E+02,      76,237,   1.84900000E+02,
     & 76,238,   1.90990000E+02,      76,239,   1.99020000E+02,
     & 76,240,   2.05990000E+02,      76,241,   2.14460000E+02/
      data (niz(i),nia(i),bie(i),i=5241,5260)/
     & 76,242,   2.21930000E+02,      76,243,   2.30190000E+02,
     & 76,244,   2.37370000E+02,      76,245,   2.47150000E+02,
     & 76,246,   2.54940000E+02,      76,247,   2.62360000E+02,
     & 76,248,   2.69330000E+02,      76,249,   2.78660000E+02,
     & 76,250,   2.85710000E+02,      76,251,   2.94130000E+02,
     & 76,252,   3.01560000E+02,      76,253,   3.09850000E+02,
     & 77,162,  -2.20000000E+00,      77,163,  -6.12000000E+00,
     & 77,164,  -8.16000000E+00,      77,165,  -1.15690000E+01,
     & 77,166,  -1.35010000E+01,      77,167,  -1.71930000E+01,
     & 77,168,  -1.86620000E+01,      77,169,  -2.19917620E+01/
      data (niz(i),nia(i),bie(i),i=5261,5280)/
     & 77,170,  -2.32570000E+01,      77,171,  -2.62880000E+01,
     & 77,172,  -2.73460000E+01,      77,173,  -3.00800000E+01,
     & 77,174,  -3.09220000E+01,      77,175,  -3.32740000E+01,
     & 77,176,  -3.39890000E+01,      77,177,  -3.61700000E+01,
     & 77,178,  -3.62510000E+01,      77,179,  -3.80520000E+01,
     & 77,180,  -3.79550000E+01,      77,181,  -3.94560720E+01,
     & 77,182,  -3.90038010E+01,      77,183,  -4.02280000E+01,
     & 77,184,  -3.96925210E+01,      77,185,  -4.04360000E+01,
     & 77,186,  -3.91682890E+01,      77,187,  -3.97181250E+01,
     & 77,188,  -3.83291440E+01,      77,189,  -3.84553520E+01/
      data (niz(i),nia(i),bie(i),i=5281,5300)/
     & 77,190,  -3.67080320E+01,      77,191,  -3.67090630E+01,
     & 77,192,  -3.48358230E+01,      77,193,  -3.45363460E+01,
     & 77,194,  -3.25318550E+01,      77,195,  -3.16924020E+01,
     & 77,196,  -2.94539230E+01,      77,197,  -2.82834170E+01,
     & 77,198,  -2.58210000E+01,      77,199,  -2.44171000E+01,
     & 77,200,  -2.18900000E+01,      77,201,  -2.03900000E+01,
     & 77,202,  -1.76200000E+01,      77,203,  -1.54300000E+01,
     & 77,204,  -1.04300000E+01,      77,205,  -6.88000000E+00,
     & 77,206,  -1.25000000E+00,      77,207,   2.80000000E+00,
     & 77,208,   8.64000000E+00,      77,209,   1.28900000E+01/
      data (niz(i),nia(i),bie(i),i=5301,5320)/
     & 77,210,   1.87100000E+01,      77,211,   2.29300000E+01,
     & 77,212,   2.85000000E+01,      77,213,   3.28000000E+01,
     & 77,214,   3.86100000E+01,      77,215,   4.29300000E+01,
     & 77,216,   4.86100000E+01,      77,217,   5.29700000E+01,
     & 77,218,   5.86200000E+01,      77,219,   6.31600000E+01,
     & 77,220,   6.89600000E+01,      77,221,   7.36800000E+01,
     & 77,222,   7.95700000E+01,      77,223,   8.44400000E+01,
     & 77,224,   9.04100000E+01,      77,225,   9.54300000E+01,
     & 77,226,   1.01560000E+02,      77,227,   1.06790000E+02,
     & 77,228,   1.13180000E+02,      77,229,   1.18670000E+02/
      data (niz(i),nia(i),bie(i),i=5321,5340)/
     & 77,230,   1.25510000E+02,      77,231,   1.31310000E+02,
     & 77,232,   1.38350000E+02,      77,233,   1.44200000E+02,
     & 77,234,   1.51350000E+02,      77,235,   1.57220000E+02,
     & 77,236,   1.64220000E+02,      77,237,   1.70130000E+02,
     & 77,238,   1.77140000E+02,      77,239,   1.83280000E+02,
     & 77,240,   1.90970000E+02,      77,241,   1.97880000E+02,
     & 77,242,   2.06210000E+02,      77,243,   2.13160000E+02,
     & 77,244,   2.21120000E+02,      77,245,   2.29400000E+02,
     & 77,246,   2.37590000E+02,      77,247,   2.45030000E+02,
     & 77,248,   2.51820000E+02,      77,249,   2.58800000E+02/
      data (niz(i),nia(i),bie(i),i=5341,5360)/
     & 77,250,   2.67750000E+02,      77,251,   2.75060000E+02,
     & 77,252,   2.83150000E+02,      77,253,   2.90380000E+02,
     & 77,254,   2.98280000E+02,      77,255,   3.05960000E+02,
     & 77,256,   3.15230000E+02,      78,158,   3.20000000E+01,
     & 78,159,   2.64200000E+01,      78,160,   1.91000000E+01,
     & 78,161,   1.57700000E+01,      78,162,   1.09000000E+01,
     & 78,163,   7.96000000E+00,      78,164,   3.37000000E+00,
     & 78,165,  -8.10000000E-01,      78,166,  -5.00000000E+00,
     & 78,167,  -6.77000000E+00,      78,168,  -1.11460000E+01,
     & 78,169,  -1.26490000E+01,      78,170,  -1.64630000E+01/
      data (niz(i),nia(i),bie(i),i=5361,5380)/
     & 78,171,  -1.74650000E+01,      78,172,  -2.10739890E+01,
     & 78,173,  -2.18904390E+01,      78,174,  -2.53261290E+01,
     & 78,175,  -2.58250000E+01,      78,176,  -2.88760000E+01,
     & 78,177,  -2.93860000E+01,      78,178,  -3.19410000E+01,
     & 78,179,  -3.21600000E+01,      78,180,  -3.42650000E+01,
     & 78,181,  -3.43000000E+01,      78,182,  -3.60789590E+01,
     & 78,183,  -3.56500000E+01,      78,184,  -3.73580000E+01,
     & 78,185,  -3.65576110E+01,      78,186,  -3.77885210E+01,
     & 78,187,  -3.67400000E+01,      78,188,  -3.78226590E+01,
     & 78,189,  -3.64848450E+01,      78,190,  -3.73248910E+01/
      data (niz(i),nia(i),bie(i),i=5381,5400)/
     & 78,191,  -3.56905110E+01,      78,192,  -3.62955110E+01,
     & 78,193,  -3.44797070E+01,      78,194,  -3.47786450E+01,
     & 78,195,  -3.28123850E+01,      78,196,  -3.26629400E+01,
     & 78,197,  -3.04380510E+01,      78,198,  -2.99233000E+01,
     & 78,199,  -2.74080770E+01,      78,200,  -2.66184750E+01,
     & 78,201,  -2.37563850E+01,      78,202,  -2.25980000E+01,
     & 78,203,  -2.03500000E+01,      78,204,  -1.85400000E+01,
     & 78,205,  -1.37100000E+01,      78,206,  -1.04300000E+01,
     & 78,207,  -4.80000000E+00,      78,208,  -1.12000000E+00,
     & 78,209,   4.53000000E+00,      78,210,   8.44000000E+00/
      data (niz(i),nia(i),bie(i),i=5401,5420)/
     & 78,211,   1.42300000E+01,      78,212,   1.82100000E+01,
     & 78,213,   2.38500000E+01,      78,214,   2.78500000E+01,
     & 78,215,   3.35400000E+01,      78,216,   3.75300000E+01,
     & 78,217,   4.32900000E+01,      78,218,   4.73500000E+01,
     & 78,219,   5.30600000E+01,      78,220,   5.72700000E+01,
     & 78,221,   6.30800000E+01,      78,222,   6.73900000E+01,
     & 78,223,   7.32700000E+01,      78,224,   7.77900000E+01,
     & 78,225,   8.38200000E+01,      78,226,   8.84800000E+01,
     & 78,227,   9.46800000E+01,      78,228,   9.95600000E+01,
     & 78,229,   1.05940000E+02,      78,230,   1.11080000E+02/
      data (niz(i),nia(i),bie(i),i=5421,5440)/
     & 78,231,   1.17930000E+02,      78,232,   1.23360000E+02,
     & 78,233,   1.30260000E+02,      78,234,   1.35900000E+02,
     & 78,235,   1.42980000E+02,      78,236,   1.48590000E+02,
     & 78,237,   1.55590000E+02,      78,238,   1.61180000E+02,
     & 78,239,   1.68200000E+02,      78,240,   1.74010000E+02,
     & 78,241,   1.81680000E+02,      78,242,   1.88150000E+02,
     & 78,243,   1.96490000E+02,      78,244,   2.03110000E+02,
     & 78,245,   2.13160000E+02,      78,246,   2.18800000E+02,
     & 78,247,   2.27030000E+02,      78,248,   2.33850000E+02,
     & 78,249,   2.41760000E+02,      78,250,   2.48140000E+02/
      data (niz(i),nia(i),bie(i),i=5441,5460)/
     & 78,251,   2.56180000E+02,      78,252,   2.62890000E+02,
     & 78,253,   2.71060000E+02,      78,254,   2.77930000E+02,
     & 78,255,   2.85360000E+02,      78,256,   2.92680000E+02,
     & 78,257,   3.01920000E+02,      78,258,   3.09210000E+02,
     & 78,259,   3.17960000E+02,      78,260,   3.25590000E+02,
     & 79,166,   1.06800000E+01,      79,167,   3.73000000E+00,
     & 79,168,   1.51000000E+00,      79,169,  -2.35000000E+00,
     & 79,170,  -4.29000000E+00,      79,171,  -7.66200000E+00,
     & 79,172,  -9.21300000E+00,      79,173,  -1.26700510E+01,
     & 79,174,  -1.40500000E+01,      79,175,  -1.71850000E+01/
      data (niz(i),nia(i),bie(i),i=5461,5480)/
     & 79,176,  -1.83790000E+01,      79,177,  -2.12240000E+01,
     & 79,178,  -2.23790000E+01,      79,179,  -2.47670000E+01,
     & 79,180,  -2.57130000E+01,      79,181,  -2.79930000E+01,
     & 79,182,  -2.82990000E+01,      79,183,  -3.01610000E+01,
     & 79,184,  -3.02980000E+01,      79,185,  -3.18506110E+01,
     & 79,186,  -3.16729610E+01,      79,187,  -3.30100000E+01,
     & 79,188,  -3.25230000E+01,      79,189,  -3.36350000E+01,
     & 79,190,  -3.28828910E+01,      79,191,  -3.38605110E+01,
     & 79,192,  -3.27791700E+01,      79,193,  -3.34110600E+01,
     & 79,194,  -3.22866110E+01,      79,195,  -3.25855850E+01/
      data (niz(i),nia(i),bie(i),i=5481,5500)/
     & 79,196,  -3.11572450E+01,      79,197,  -3.11569710E+01,
     & 79,198,  -2.95979900E+01,      79,199,  -2.91110310E+01,
     & 79,200,  -2.72761090E+01,      79,201,  -2.64163850E+01,
     & 79,202,  -2.44159160E+01,      79,203,  -2.31594930E+01,
     & 79,204,  -2.07670000E+01,      79,205,  -1.89930000E+01,
     & 79,206,  -1.46200000E+01,      79,207,  -1.14700000E+01,
     & 79,208,  -6.39000000E+00,      79,209,  -2.60000000E+00,
     & 79,210,   2.69000000E+00,      79,211,   6.55000000E+00,
     & 79,212,   1.18300000E+01,      79,213,   1.57900000E+01,
     & 79,214,   2.12400000E+01,      79,215,   2.52300000E+01/
      data (niz(i),nia(i),bie(i),i=5501,5520)/
     & 79,216,   3.07100000E+01,      79,217,   3.47100000E+01,
     & 79,218,   4.01700000E+01,      79,219,   4.42300000E+01,
     & 79,220,   4.96000000E+01,      79,221,   5.38600000E+01,
     & 79,222,   5.93400000E+01,      79,223,   6.36200000E+01,
     & 79,224,   6.91900000E+01,      79,225,   7.36900000E+01,
     & 79,226,   7.94000000E+01,      79,227,   8.40600000E+01,
     & 79,228,   8.99100000E+01,      79,229,   9.47700000E+01,
     & 79,230,   1.00840000E+02,      79,231,   1.05940000E+02,
     & 79,232,   1.12470000E+02,      79,233,   1.17890000E+02,
     & 79,234,   1.24450000E+02,      79,235,   1.30040000E+02/
      data (niz(i),nia(i),bie(i),i=5521,5540)/
     & 79,236,   1.36760000E+02,      79,237,   1.42310000E+02,
     & 79,238,   1.49220000E+02,      79,239,   1.54630000E+02,
     & 79,240,   1.61410000E+02,      79,241,   1.67180000E+02,
     & 79,242,   1.74550000E+02,      79,243,   1.81310000E+02,
     & 79,244,   1.91250000E+02,      79,245,   1.97390000E+02,
     & 79,246,   2.04690000E+02,      79,247,   2.10560000E+02,
     & 79,248,   2.18200000E+02,      79,249,   2.24540000E+02,
     & 79,250,   2.30820000E+02,      79,251,   2.37450000E+02,
     & 79,252,   2.45170000E+02,      79,253,   2.53030000E+02,
     & 79,254,   2.60850000E+02,      79,255,   2.66770000E+02/
      data (niz(i),nia(i),bie(i),i=5541,5560)/
     & 79,256,   2.74740000E+02,      79,257,   2.81970000E+02,
     & 79,258,   2.90840000E+02,      79,259,   2.98140000E+02,
     & 79,260,   3.06560000E+02,      79,261,   3.14170000E+02,
     & 79,262,   3.22810000E+02,      79,263,   3.30900000E+02,
     & 80,163,   3.63500000E+01,      80,164,   3.09800000E+01,
     & 80,165,   2.75800000E+01,      80,166,   2.24400000E+01,
     & 80,167,   1.95800000E+01,      80,168,   1.45500000E+01,
     & 80,169,   1.20400000E+01,      80,170,   4.84000000E+00,
     & 80,171,   2.89000000E+00,      80,172,  -1.16000000E+00,
     & 80,173,  -2.88000000E+00,      80,174,  -6.64000000E+00/
      data (niz(i),nia(i),bie(i),i=5561,5580)/
     & 80,175,  -8.00000000E+00,      80,176,  -1.17244820E+01,
     & 80,177,  -1.27271180E+01,      80,178,  -1.63231950E+01,
     & 80,179,  -1.69690000E+01,      80,180,  -2.01930000E+01,
     & 80,181,  -2.06740000E+01,      80,182,  -2.35190000E+01,
     & 80,183,  -2.36960000E+01,      80,184,  -2.61780000E+01,
     & 80,185,  -2.60980000E+01,      80,186,  -2.84478030E+01,
     & 80,187,  -2.81450000E+01,      80,188,  -3.02230000E+01,
     & 80,189,  -2.96850000E+01,      80,190,  -3.14130000E+01,
     & 80,191,  -3.06805110E+01,      80,192,  -3.20690000E+01,
     & 80,193,  -3.10707520E+01,      80,194,  -3.22466110E+01/
      data (niz(i),nia(i),bie(i),i=5581,5600)/
     & 80,195,  -3.10755850E+01,      80,196,  -3.18432610E+01,
     & 80,197,  -3.05573460E+01,      80,198,  -3.09704660E+01,
     & 80,199,  -2.95632970E+01,      80,200,  -2.95202270E+01,
     & 80,201,  -2.76790840E+01,      80,202,  -2.73620700E+01,
     & 80,203,  -2.52834480E+01,      80,204,  -2.47072780E+01,
     & 80,205,  -2.23035930E+01,      80,206,  -2.09598490E+01,
     & 80,207,  -1.62293950E+01,      80,208,  -1.30970000E+01,
     & 80,209,  -8.95000000E+00,      80,210,  -5.58000000E+00,
     & 80,211,  -3.20000000E-01,      80,212,   3.13000000E+00,
     & 80,213,   8.51000000E+00,      80,214,   1.20200000E+01/
      data (niz(i),nia(i),bie(i),i=5601,5620)/
     & 80,215,   1.76400000E+01,      80,216,   2.13500000E+01,
     & 80,217,   2.70100000E+01,      80,218,   3.07100000E+01,
     & 80,219,   3.61200000E+01,      80,220,   3.98000000E+01,
     & 80,221,   4.50800000E+01,      80,222,   4.89800000E+01,
     & 80,223,   5.44600000E+01,      80,224,   5.83800000E+01,
     & 80,225,   6.39300000E+01,      80,226,   6.80900000E+01,
     & 80,227,   7.37700000E+01,      80,228,   7.80700000E+01,
     & 80,229,   8.39200000E+01,      80,230,   8.84600000E+01,
     & 80,231,   9.45300000E+01,      80,232,   9.92900000E+01,
     & 80,233,   1.05830000E+02,      80,234,   1.10910000E+02/
      data (niz(i),nia(i),bie(i),i=5621,5640)/
     & 80,235,   1.17580000E+02,      80,236,   1.22730000E+02,
     & 80,237,   1.29440000E+02,      80,238,   1.34670000E+02,
     & 80,239,   1.41450000E+02,      80,240,   1.46620000E+02,
     & 80,241,   1.53480000E+02,      80,242,   1.58990000E+02,
     & 80,243,   1.66220000E+02,      80,244,   1.74310000E+02,
     & 80,245,   1.81550000E+02,      80,246,   1.87020000E+02,
     & 80,247,   1.94060000E+02,      80,248,   1.99570000E+02,
     & 80,249,   2.06790000E+02,      80,250,   2.12820000E+02,
     & 80,251,   2.20370000E+02,      80,252,   2.26600000E+02,
     & 80,253,   2.34340000E+02,      80,254,   2.40850000E+02/
      data (niz(i),nia(i),bie(i),i=5641,5660)/
     & 80,255,   2.48570000E+02,      80,256,   2.55160000E+02,
     & 80,257,   2.63170000E+02,      80,258,   2.70060000E+02,
     & 80,259,   2.78760000E+02,      80,260,   2.85760000E+02,
     & 80,261,   2.94190000E+02,      80,262,   3.01450000E+02,
     & 80,263,   3.10040000E+02,      80,264,   3.17820000E+02,
     & 80,265,   3.27930000E+02,      80,266,   3.36390000E+02,
     & 81,172,   1.47900000E+01,      81,173,   8.00000000E+00,
     & 81,174,   5.92000000E+00,      81,175,   2.12000000E+00,
     & 81,176,   3.00000000E-01,      81,177,  -2.90500000E+00,
     & 81,178,  -4.44500000E+00,      81,179,  -7.94900000E+00/
      data (niz(i),nia(i),bie(i),i=5661,5680)/
     & 81,180,  -9.13500000E+00,      81,181,  -1.21990000E+01,
     & 81,182,  -1.34040000E+01,      81,183,  -1.61180000E+01,
     & 81,184,  -1.69900000E+01,      81,185,  -1.94680000E+01,
     & 81,186,  -1.99820000E+01,      81,187,  -2.21970000E+01,
     & 81,188,  -2.24300000E+01,      81,189,  -2.45080000E+01,
     & 81,190,  -2.44130000E+01,      81,191,  -2.61880000E+01,
     & 81,192,  -2.59490000E+01,      81,193,  -2.74340000E+01,
     & 81,194,  -2.69640000E+01,      81,195,  -2.82710000E+01,
     & 81,196,  -2.74660000E+01,      81,197,  -2.83768430E+01,
     & 81,198,  -2.75104660E+01,      81,199,  -2.81182250E+01/
      data (niz(i),nia(i),bie(i),i=5681,5700)/
     & 81,200,  -2.70641870E+01,      81,201,  -2.71961090E+01,
     & 81,202,  -2.59974630E+01,      81,203,  -2.57752840E+01,
     & 81,204,  -2.43598250E+01,      81,205,  -2.38348130E+01,
     & 81,206,  -2.22670620E+01,      81,207,  -2.10443950E+01,
     & 81,208,  -1.67625550E+01,      81,209,  -1.36472000E+01,
     & 81,210,  -9.25385700E+00,      81,211,  -5.97000000E+00,
     & 81,212,  -1.22000000E+00,      81,213,   2.25000000E+00,
     & 81,214,   7.20000000E+00,      81,215,   1.07900000E+01,
     & 81,216,   1.59900000E+01,      81,217,   1.95900000E+01,
     & 81,218,   2.44900000E+01,      81,219,   2.82700000E+01/
      data (niz(i),nia(i),bie(i),i=5701,5720)/
     & 81,220,   3.36700000E+01,      81,221,   3.76800000E+01,
     & 81,222,   4.26300000E+01,      81,223,   4.65400000E+01,
     & 81,224,   5.16700000E+01,      81,225,   5.56000000E+01,
     & 81,226,   6.08500000E+01,      81,227,   6.50000000E+01,
     & 81,228,   7.03000000E+01,      81,229,   7.46000000E+01,
     & 81,230,   8.00800000E+01,      81,231,   8.45900000E+01,
     & 81,232,   9.03100000E+01,      81,233,   9.50700000E+01,
     & 81,234,   1.01260000E+02,      81,235,   1.06370000E+02,
     & 81,236,   1.12640000E+02,      81,237,   1.17820000E+02,
     & 81,238,   1.24190000E+02,      81,239,   1.29430000E+02/
      data (niz(i),nia(i),bie(i),i=5721,5740)/
     & 81,240,   1.35790000E+02,      81,241,   1.42950000E+02,
     & 81,242,   1.49600000E+02,      81,243,   1.54920000E+02,
     & 81,244,   1.61710000E+02,      81,245,   1.67210000E+02,
     & 81,246,   1.74170000E+02,      81,247,   1.79920000E+02,
     & 81,248,   1.86810000E+02,      81,249,   1.92570000E+02,
     & 81,250,   1.99730000E+02,      81,251,   2.05790000E+02,
     & 81,252,   2.13090000E+02,      81,253,   2.19190000E+02,
     & 81,254,   2.26630000E+02,      81,255,   2.32990000E+02,
     & 81,256,   2.40470000E+02,      81,257,   2.46560000E+02,
     & 81,258,   2.54410000E+02,      81,259,   2.61170000E+02/
      data (niz(i),nia(i),bie(i),i=5741,5760)/
     & 81,260,   2.68890000E+02,      81,261,   2.75880000E+02,
     & 81,262,   2.83920000E+02,      81,263,   2.91140000E+02,
     & 81,264,   2.99520000E+02,      81,265,   3.07300000E+02,
     & 81,266,   3.17110000E+02,      81,267,   3.25540000E+02,
     & 81,268,   3.35770000E+02,      81,269,   3.44560000E+02,
     & 82,170,   3.51300000E+01,      82,171,   3.20000000E+01,
     & 82,172,   2.68100000E+01,      82,173,   2.38200000E+01,
     & 82,174,   1.90200000E+01,      82,175,   1.37200000E+01,
     & 82,176,   9.42000000E+00,      82,177,   7.45000000E+00,
     & 82,178,   3.43000000E+00,      82,179,   1.77000000E+00/
      data (niz(i),nia(i),bie(i),i=5761,5780)/
     & 82,180,  -2.03000000E+00,      82,181,  -3.06100000E+00,
     & 82,182,  -6.82216700E+00,      82,183,  -7.51700000E+00,
     & 82,184,  -1.09930000E+01,      82,185,  -1.15690000E+01,
     & 82,186,  -1.46230000E+01,      82,187,  -1.48760000E+01,
     & 82,188,  -1.76420000E+01,      82,189,  -1.78100000E+01,
     & 82,190,  -2.03251880E+01,      82,191,  -2.03070000E+01,
     & 82,192,  -2.25770000E+01,      82,193,  -2.22810000E+01,
     & 82,194,  -2.42500000E+01,      82,195,  -2.37800000E+01,
     & 82,196,  -2.54200000E+01,      82,197,  -2.47960000E+01,
     & 82,198,  -2.61000000E+01,      82,199,  -2.52347430E+01/
      data (niz(i),nia(i),bie(i),i=5781,5800)/
     & 82,200,  -2.62536330E+01,      82,201,  -2.52932360E+01,
     & 82,202,  -2.59478920E+01,      82,203,  -2.48005660E+01,
     & 82,204,  -2.51235440E+01,      82,205,  -2.37837280E+01,
     & 82,206,  -2.38005980E+01,      82,207,  -2.24670680E+01,
     & 82,208,  -2.17635630E+01,      82,209,  -1.76287070E+01,
     & 82,210,  -1.47426340E+01,      82,211,  -1.04965630E+01,
     & 82,212,  -7.55674900E+00,      82,213,  -3.26000000E+00,
     & 82,214,  -1.88025000E-01,      82,215,   5.32000000E+00,
     & 82,216,   8.34000000E+00,      82,217,   1.32700000E+01,
     & 82,218,   1.64800000E+01,      82,219,   2.16000000E+01/
      data (niz(i),nia(i),bie(i),i=5801,5820)/
     & 82,220,   2.50000000E+01,      82,221,   3.09700000E+01,
     & 82,222,   3.43200000E+01,      82,223,   3.92200000E+01,
     & 82,224,   4.26600000E+01,      82,225,   4.78600000E+01,
     & 82,226,   5.13700000E+01,      82,227,   5.65400000E+01,
     & 82,228,   6.03100000E+01,      82,229,   6.55900000E+01,
     & 82,230,   6.95400000E+01,      82,231,   7.50100000E+01,
     & 82,232,   7.91800000E+01,      82,233,   8.48500000E+01,
     & 82,234,   8.93200000E+01,      82,235,   9.55100000E+01,
     & 82,236,   1.00260000E+02,      82,237,   1.06570000E+02,
     & 82,238,   1.11450000E+02,      82,239,   1.17790000E+02/
      data (niz(i),nia(i),bie(i),i=5821,5840)/
     & 82,240,   1.22710000E+02,      82,241,   1.29100000E+02,
     & 82,242,   1.35490000E+02,      82,243,   1.42100000E+02,
     & 82,244,   1.47080000E+02,      82,245,   1.53850000E+02,
     & 82,246,   1.58810000E+02,      82,247,   1.65920000E+02,
     & 82,248,   1.71320000E+02,      82,249,   1.78190000E+02,
     & 82,250,   1.83640000E+02,      82,251,   1.90790000E+02,
     & 82,252,   1.96460000E+02,      82,253,   2.03740000E+02,
     & 82,254,   2.09640000E+02,      82,255,   2.17070000E+02,
     & 82,256,   2.23130000E+02,      82,257,   2.30650000E+02,
     & 82,258,   2.36760000E+02,      82,259,   2.44280000E+02/
      data (niz(i),nia(i),bie(i),i=5841,5860)/
     & 82,260,   2.50570000E+02,      82,261,   2.58310000E+02,
     & 82,262,   2.65000000E+02,      82,263,   2.72990000E+02,
     & 82,264,   2.79930000E+02,      82,265,   2.88320000E+02,
     & 82,266,   2.95780000E+02,      82,267,   3.05610000E+02,
     & 82,268,   3.13710000E+02,      82,269,   3.23860000E+02,
     & 82,270,   3.32270000E+02,      82,271,   3.42060000E+02,
     & 82,272,   3.50380000E+02,      82,273,   3.60040000E+02,
     & 83,178,   1.83100000E+01,      83,179,   1.42700000E+01,
     & 83,180,   1.21000000E+01,      83,181,   8.53000000E+00,
     & 83,182,   6.41000000E+00,      83,183,   3.02000000E+00/
      data (niz(i),nia(i),bie(i),i=5861,5880)/
     & 83,184,   1.39000000E+00,      83,185,  -2.13500000E+00,
     & 83,186,  -3.27900000E+00,      83,187,  -6.09400000E+00,
     & 83,188,  -7.29100000E+00,      83,189,  -9.77600000E+00,
     & 83,190,  -1.06950000E+01,      83,191,  -1.29910000E+01,
     & 83,192,  -1.36290000E+01,      83,193,  -1.57790000E+01,
     & 83,194,  -1.60700000E+01,      83,195,  -1.79300000E+01,
     & 83,196,  -1.80640000E+01,      83,197,  -1.96225820E+01,
     & 83,198,  -1.95386460E+01,      83,199,  -2.08869300E+01,
     & 83,200,  -2.03606090E+01,      83,201,  -2.14516320E+01,
     & 83,202,  -2.07960620E+01,      83,203,  -2.15472060E+01/
      data (niz(i),nia(i),bie(i),i=5881,5900)/
     & 83,204,  -2.06743560E+01,      83,205,  -2.10753390E+01,
     & 83,206,  -2.00430900E+01,      83,207,  -2.00688330E+01,
     & 83,208,  -1.88844550E+01,      83,209,  -1.82728910E+01,
     & 83,210,  -1.48061470E+01,      83,211,  -1.18689650E+01,
     & 83,212,  -8.13050500E+00,      83,213,  -5.23980600E+00,
     & 83,214,  -1.21218600E+00,      83,215,   1.70682100E+00,
     & 83,216,   5.77500000E+00,      83,217,   9.48000000E+00,
     & 83,218,   1.39400000E+01,      83,219,   1.71700000E+01,
     & 83,220,   2.18100000E+01,      83,221,   2.50800000E+01,
     & 83,222,   2.98900000E+01,      83,223,   3.31900000E+01/
      data (niz(i),nia(i),bie(i),i=5901,5920)/
     & 83,224,   3.77400000E+01,      83,225,   4.12900000E+01,
     & 83,226,   4.60300000E+01,      83,227,   4.95400000E+01,
     & 83,228,   5.43400000E+01,      83,229,   5.81300000E+01,
     & 83,230,   6.30400000E+01,      83,231,   6.69900000E+01,
     & 83,232,   7.20900000E+01,      83,233,   7.62700000E+01,
     & 83,234,   8.16100000E+01,      83,235,   8.60400000E+01,
     & 83,236,   9.18900000E+01,      83,237,   9.66300000E+01,
     & 83,238,   1.02600000E+02,      83,239,   1.07450000E+02,
     & 83,240,   1.13470000E+02,      83,241,   1.18380000E+02,
     & 83,242,   1.24440000E+02,      83,243,   1.30810000E+02/
      data (niz(i),nia(i),bie(i),i=5921,5940)/
     & 83,244,   1.37180000E+02,      83,245,   1.42120000E+02,
     & 83,246,   1.48510000E+02,      83,247,   1.53720000E+02,
     & 83,248,   1.60180000E+02,      83,249,   1.65600000E+02,
     & 83,250,   1.72090000E+02,      83,251,   1.77560000E+02,
     & 83,252,   1.84380000E+02,      83,253,   1.90120000E+02,
     & 83,254,   1.97040000E+02,      83,255,   2.02880000E+02,
     & 83,256,   2.10000000E+02,      83,257,   2.16070000E+02,
     & 83,258,   2.23260000E+02,      83,259,   2.29210000E+02,
     & 83,260,   2.36650000E+02,      83,261,   2.43050000E+02,
     & 83,262,   2.50390000E+02,      83,263,   2.57040000E+02/
      data (niz(i),nia(i),bie(i),i=5941,5960)/
     & 83,264,   2.64770000E+02,      83,265,   2.71720000E+02,
     & 83,266,   2.79790000E+02,      83,267,   2.87290000E+02,
     & 83,268,   2.96790000E+02,      83,269,   3.04870000E+02,
     & 83,270,   3.14720000E+02,      83,271,   3.23080000E+02,
     & 83,272,   3.32570000E+02,      83,273,   3.40920000E+02,
     & 83,274,   3.50230000E+02,      83,275,   3.58710000E+02,
     & 83,276,   3.70620000E+02,      84,178,   3.32400000E+01,
     & 84,179,   3.04200000E+01,      84,180,   2.58300000E+01,
     & 84,181,   2.00600000E+01,      84,182,   1.55500000E+01,
     & 84,183,   1.32400000E+01,      84,184,   9.13000000E+00/
      data (niz(i),nia(i),bie(i),i=5961,5980)/
     & 84,185,   7.20000000E+00,      84,186,   3.63000000E+00,
     & 84,187,   2.22000000E+00,      84,188,  -7.70000000E-01,
     & 84,189,  -1.66000000E+00,      84,190,  -4.55500000E+00,
     & 84,191,  -4.98000000E+00,      84,192,  -7.89700000E+00,
     & 84,193,  -8.28900000E+00,      84,194,  -1.09132830E+01,
     & 84,195,  -1.11360000E+01,      84,196,  -1.34950000E+01,
     & 84,197,  -1.34450000E+01,      84,198,  -1.55160000E+01,
     & 84,199,  -1.52810000E+01,      84,200,  -1.70140000E+01,
     & 84,201,  -1.65720000E+01,      84,202,  -1.79750000E+01,
     & 84,203,  -1.73138040E+01,      84,204,  -1.83438030E+01/
      data (niz(i),nia(i),bie(i),i=5981,6000)/
     & 84,205,  -1.75443180E+01,      84,206,  -1.81965080E+01,
     & 84,207,  -1.71597680E+01,      84,208,  -1.74831540E+01,
     & 84,209,  -1.63795860E+01,      84,210,  -1.59682300E+01,
     & 84,211,  -1.24476750E+01,      84,212,  -1.03845220E+01,
     & 84,213,  -6.66714700E+00,      84,214,  -4.48425900E+00,
     & 84,215,  -5.45288000E-01,      84,216,   1.77468000E+00,
     & 84,217,   5.82500000E+00,      84,218,   8.35156300E+00,
     & 84,219,   1.34700000E+01,      84,220,   1.62400000E+01,
     & 84,221,   2.07600000E+01,      84,222,   2.36100000E+01,
     & 84,223,   2.79900000E+01,      84,224,   3.08900000E+01/
      data (niz(i),nia(i),bie(i),i=6001,6020)/
     & 84,225,   3.53500000E+01,      84,226,   3.84500000E+01,
     & 84,227,   4.31200000E+01,      84,228,   4.62400000E+01,
     & 84,229,   5.10000000E+01,      84,230,   5.44000000E+01,
     & 84,231,   5.92200000E+01,      84,232,   6.28100000E+01,
     & 84,233,   6.79100000E+01,      84,234,   7.17200000E+01,
     & 84,235,   7.70100000E+01,      84,236,   8.11200000E+01,
     & 84,237,   8.69500000E+01,      84,238,   9.13800000E+01,
     & 84,239,   9.73700000E+01,      84,240,   1.01920000E+02,
     & 84,241,   1.07960000E+02,      84,242,   1.12560000E+02,
     & 84,243,   1.18610000E+02,      84,244,   1.23270000E+02/
      data (niz(i),nia(i),bie(i),i=6021,6040)/
     & 84,245,   1.29450000E+02,      84,246,   1.34370000E+02,
     & 84,247,   1.42140000E+02,      84,248,   1.46840000E+02,
     & 84,249,   1.53410000E+02,      84,250,   1.58510000E+02,
     & 84,251,   1.64980000E+02,      84,252,   1.70120000E+02,
     & 84,253,   1.76960000E+02,      84,254,   1.82350000E+02,
     & 84,255,   1.89270000E+02,      84,256,   1.94190000E+02,
     & 84,257,   2.01900000E+02,      84,258,   2.07650000E+02,
     & 84,259,   2.14770000E+02,      84,260,   2.20530000E+02,
     & 84,261,   2.27920000E+02,      84,262,   2.34010000E+02,
     & 84,263,   2.41360000E+02,      84,264,   2.47620000E+02/
      data (niz(i),nia(i),bie(i),i=6041,6060)/
     & 84,265,   2.55370000E+02,      84,266,   2.61990000E+02,
     & 84,267,   2.70070000E+02,      84,268,   2.77240000E+02,
     & 84,269,   2.86750000E+02,      84,270,   2.94490000E+02,
     & 84,271,   3.04230000E+02,      84,272,   3.12300000E+02,
     & 84,273,   3.21640000E+02,      84,274,   3.29640000E+02,
     & 84,275,   3.38900000E+02,      84,276,   3.49460000E+02,
     & 84,277,   3.58450000E+02,      84,278,   3.66190000E+02,
     & 84,279,   3.75510000E+02,      85,184,   2.26300000E+01,
     & 85,185,   1.83200000E+01,      85,186,   1.59700000E+01,
     & 85,187,   1.23400000E+01,      85,188,   1.05900000E+01/
      data (niz(i),nia(i),bie(i),i=6061,6080)/
     & 85,189,   7.44000000E+00,      85,190,   6.14000000E+00,
     & 85,191,   3.59000000E+00,      85,192,   2.28000000E+00,
     & 85,193,   1.75000000E-01,      85,194,  -9.59000000E-01,
     & 85,195,  -3.21000000E+00,      85,196,  -4.00300000E+00,
     & 85,197,  -6.25000000E+00,      85,198,  -6.75100000E+00,
     & 85,199,  -8.72500000E+00,      85,200,  -9.04200000E+00,
     & 85,201,  -1.07243740E+01,      85,202,  -1.07600310E+01,
     & 85,203,  -1.22517370E+01,      85,204,  -1.18657790E+01,
     & 85,205,  -1.30070520E+01,      85,206,  -1.24827240E+01,
     & 85,207,  -1.32496980E+01,      85,208,  -1.24983120E+01/
      data (niz(i),nia(i),bie(i),i=6081,6100)/
     & 85,209,  -1.28931060E+01,      85,210,  -1.19871070E+01,
     & 85,211,  -1.16615520E+01,      85,212,  -8.63061000E+00,
     & 85,213,  -6.59390600E+00,      85,214,  -3.39398000E+00,
     & 85,215,  -1.26567200E+00,      85,216,   2.24381800E+00,
     & 85,217,   4.38698100E+00,      85,218,   8.08672500E+00,
     & 85,219,   1.05226000E+01,      85,220,   1.42530000E+01,
     & 85,221,   1.68970000E+01,      85,222,   2.08000000E+01,
     & 85,223,   2.36040000E+01,      85,224,   2.80900000E+01,
     & 85,225,   3.09000000E+01,      85,226,   3.49500000E+01,
     & 85,227,   3.79800000E+01,      85,228,   4.22500000E+01/
      data (niz(i),nia(i),bie(i),i=6101,6120)/
     & 85,229,   4.53300000E+01,      85,230,   4.97100000E+01,
     & 85,231,   5.30700000E+01,      85,232,   5.75400000E+01,
     & 85,233,   6.11400000E+01,      85,234,   6.58600000E+01,
     & 85,235,   6.96800000E+01,      85,236,   7.46000000E+01,
     & 85,237,   7.85500000E+01,      85,238,   8.42200000E+01,
     & 85,239,   8.86100000E+01,      85,240,   9.43500000E+01,
     & 85,241,   9.88600000E+01,      85,242,   1.04560000E+02,
     & 85,243,   1.09140000E+02,      85,244,   1.14870000E+02,
     & 85,245,   1.19520000E+02,      85,246,   1.25400000E+02,
     & 85,247,   1.30270000E+02,      85,248,   1.37690000E+02/
      data (niz(i),nia(i),bie(i),i=6121,6140)/
     & 85,249,   1.42600000E+02,      85,250,   1.48830000E+02,
     & 85,251,   1.53870000E+02,      85,252,   1.60070000E+02,
     & 85,253,   1.65140000E+02,      85,254,   1.71590000E+02,
     & 85,255,   1.77020000E+02,      85,256,   1.83610000E+02,
     & 85,257,   1.88290000E+02,      85,258,   1.95950000E+02,
     & 85,259,   2.01680000E+02,      85,260,   2.08530000E+02,
     & 85,261,   2.14220000E+02,      85,262,   2.21320000E+02,
     & 85,263,   2.27400000E+02,      85,264,   2.34610000E+02,
     & 85,265,   2.40890000E+02,      85,266,   2.48310000E+02,
     & 85,267,   2.54960000E+02,      85,268,   2.62700000E+02/
      data (niz(i),nia(i),bie(i),i=6141,6160)/
     & 85,269,   2.69900000E+02,      85,270,   2.79080000E+02,
     & 85,271,   2.86780000E+02,      85,272,   2.96280000E+02,
     & 85,273,   3.04320000E+02,      85,274,   3.13440000E+02,
     & 85,275,   3.21300000E+02,      85,276,   3.32150000E+02,
     & 85,277,   3.39790000E+02,      85,278,   3.48480000E+02,
     & 85,279,   3.56230000E+02,      85,280,   3.65010000E+02,
     & 85,281,   3.73060000E+02,      85,282,   3.82030000E+02,
     & 86,182,   4.78100000E+01,      86,183,   4.47200000E+01,
     & 86,184,   4.00800000E+01,      86,185,   3.71400000E+01,
     & 86,186,   2.59100000E+01,      86,187,   2.34900000E+01/
      data (niz(i),nia(i),bie(i),i=6161,6180)/
     & 86,188,   1.94300000E+01,      86,189,   1.75700000E+01,
     & 86,190,   1.40400000E+01,      86,191,   1.27900000E+01,
     & 86,192,   9.69000000E+00,      86,193,   8.70000000E+00,
     & 86,194,   5.75000000E+00,      86,195,   4.74000000E+00,
     & 86,196,   2.15100000E+00,      86,197,   1.54700000E+00,
     & 86,198,  -1.13644300E+00,      86,199,  -1.57500000E+00,
     & 86,200,  -4.02700000E+00,      86,201,  -4.15900000E+00,
     & 86,202,  -6.31800000E+00,      86,203,  -6.22600000E+00,
     & 86,204,  -8.04400000E+00,      86,205,  -7.76100000E+00,
     & 86,206,  -9.16600000E+00,      86,207,  -8.63790500E+00/
      data (niz(i),nia(i),bie(i),i=6181,6200)/
     & 86,208,  -9.65844000E+00,      86,209,  -8.96410600E+00,
     & 86,210,  -9.61314500E+00,      86,211,  -8.76963300E+00,
     & 86,212,  -8.67323300E+00,      86,213,  -5.71159100E+00,
     & 86,214,  -4.33491700E+00,      86,215,  -1.18374700E+00,
     & 86,216,   2.40468000E-01,      86,217,   3.64638400E+00,
     & 86,218,   5.20361800E+00,      86,219,   8.82574700E+00,
     & 86,220,   1.06042650E+01,      86,221,   1.43960000E+01,
     & 86,222,   1.63667870E+01,      86,223,   2.02970000E+01,
     & 86,224,   2.24400000E+01,      86,225,   2.64920000E+01,
     & 86,226,   2.87740000E+01,      86,227,   3.29810000E+01/
      data (niz(i),nia(i),bie(i),i=6201,6220)/
     & 86,228,   3.54750000E+01,      86,229,   4.01600000E+01,
     & 86,230,   4.28700000E+01,      86,231,   4.71700000E+01,
     & 86,232,   5.01500000E+01,      86,233,   5.46000000E+01,
     & 86,234,   5.78200000E+01,      86,235,   6.25600000E+01,
     & 86,236,   6.60000000E+01,      86,237,   7.09200000E+01,
     & 86,238,   7.45100000E+01,      86,239,   8.02200000E+01,
     & 86,240,   8.42400000E+01,      86,241,   8.99100000E+01,
     & 86,242,   9.41500000E+01,      86,243,   9.98800000E+01,
     & 86,244,   1.04150000E+02,      86,245,   1.09880000E+02,
     & 86,246,   1.14190000E+02,      86,247,   1.20040000E+02/
      data (niz(i),nia(i),bie(i),i=6221,6240)/
     & 86,248,   1.24590000E+02,      86,249,   1.30740000E+02,
     & 86,250,   1.36770000E+02,      86,251,   1.43180000E+02,
     & 86,252,   1.47860000E+02,      86,253,   1.53930000E+02,
     & 86,254,   1.58730000E+02,      86,255,   1.65130000E+02,
     & 86,256,   1.70230000E+02,      86,257,   1.76820000E+02,
     & 86,258,   1.81160000E+02,      86,259,   1.88870000E+02,
     & 86,260,   1.94310000E+02,      86,261,   2.01160000E+02,
     & 86,262,   2.06370000E+02,      86,263,   2.13440000E+02,
     & 86,264,   2.19400000E+02,      86,265,   2.26590000E+02,
     & 86,266,   2.32600000E+02,      86,267,   2.40090000E+02/
      data (niz(i),nia(i),bie(i),i=6241,6260)/
     & 86,268,   2.46450000E+02,      86,269,   2.54190000E+02,
     & 86,270,   2.61080000E+02,      86,271,   2.70260000E+02,
     & 86,272,   2.77610000E+02,      86,273,   2.87050000E+02,
     & 86,274,   2.94650000E+02,      86,275,   3.03680000E+02,
     & 86,276,   3.11290000E+02,      86,277,   3.21350000E+02,
     & 86,278,   3.28680000E+02,      86,279,   3.37330000E+02,
     & 86,280,   3.44750000E+02,      86,281,   3.53670000E+02,
     & 86,282,   3.61370000E+02,      86,283,   3.70380000E+02,
     & 86,284,   3.77820000E+02,      86,285,   3.86970000E+02,
     & 86,286,   3.94850000E+02,      87,189,   2.89900000E+01/
      data (niz(i),nia(i),bie(i),i=6261,6280)/
     & 87,190,   2.67100000E+01,      87,191,   2.30900000E+01,
     & 87,192,   2.12300000E+01,      87,193,   1.81200000E+01,
     & 87,194,   1.69000000E+01,      87,195,   1.39200000E+01,
     & 87,196,   1.30100000E+01,      87,197,   1.01500000E+01,
     & 87,198,   9.04000000E+00,      87,199,   6.52000000E+00,
     & 87,200,   6.05400000E+00,      87,201,   3.71300000E+00,
     & 87,202,   3.06200000E+00,      87,203,   9.76000000E-01,
     & 87,204,   5.52000000E-01,      87,205,  -1.24451200E+00,
     & 87,206,  -1.40945700E+00,      87,207,  -2.92546400E+00,
     & 87,208,  -2.66980200E+00,      87,209,  -3.80476000E+00/
      data (niz(i),nia(i),bie(i),i=6281,6300)/
     & 87,210,  -3.35493600E+00,      87,211,  -4.16440000E+00,
     & 87,212,  -3.54434600E+00,      87,213,  -3.56310800E+00,
     & 87,214,  -9.73653000E-01,      87,215,   3.03694000E-01,
     & 87,216,   2.96948400E+00,      87,217,   4.30019600E+00,
     & 87,218,   7.04519100E+00,      87,219,   8.60778800E+00,
     & 87,220,   1.14694630E+01,      87,221,   1.32697390E+01,
     & 87,222,   1.63420890E+01,      87,223,   1.83790370E+01,
     & 87,224,   2.16437370E+01,      87,225,   2.38526830E+01,
     & 87,226,   2.73332180E+01,      87,227,   2.96523990E+01,
     & 87,228,   3.32760000E+01,      87,229,   3.57930000E+01/
      data (niz(i),nia(i),bie(i),i=6301,6320)/
     & 87,230,   3.95980000E+01,      87,231,   4.22960000E+01,
     & 87,232,   4.62530000E+01,      87,233,   4.96700000E+01,
     & 87,234,   5.37900000E+01,      87,235,   5.70100000E+01,
     & 87,236,   6.13600000E+01,      87,237,   6.48200000E+01,
     & 87,238,   6.93500000E+01,      87,239,   7.29100000E+01,
     & 87,240,   7.81800000E+01,      87,241,   8.23600000E+01,
     & 87,242,   8.77000000E+01,      87,243,   9.19100000E+01,
     & 87,244,   9.73500000E+01,      87,245,   1.01640000E+02,
     & 87,246,   1.07000000E+02,      87,247,   1.11310000E+02,
     & 87,248,   1.16810000E+02,      87,249,   1.21380000E+02/
      data (niz(i),nia(i),bie(i),i=6321,6340)/
     & 87,250,   1.27180000E+02,      87,251,   1.33340000E+02,
     & 87,252,   1.39310000E+02,      87,253,   1.44000000E+02,
     & 87,254,   1.49870000E+02,      87,255,   1.54580000E+02,
     & 87,256,   1.60690000E+02,      87,257,   1.65720000E+02,
     & 87,258,   1.71970000E+02,      87,259,   1.76410000E+02,
     & 87,260,   1.83750000E+02,      87,261,   1.89280000E+02,
     & 87,262,   1.95750000E+02,      87,263,   2.00910000E+02,
     & 87,264,   2.07690000E+02,      87,265,   2.13770000E+02,
     & 87,266,   2.20650000E+02,      87,267,   2.26720000E+02,
     & 87,268,   2.33820000E+02,      87,269,   2.40210000E+02/
      data (niz(i),nia(i),bie(i),i=6341,6360)/
     & 87,270,   2.47620000E+02,      87,271,   2.54510000E+02,
     & 87,272,   2.63370000E+02,      87,273,   2.70710000E+02,
     & 87,274,   2.79880000E+02,      87,275,   2.87500000E+02,
     & 87,276,   2.97140000E+02,      87,277,   3.04340000E+02,
     & 87,278,   3.12650000E+02,      87,279,   3.19950000E+02,
     & 87,280,   3.28300000E+02,      87,281,   3.35700000E+02,
     & 87,282,   3.44440000E+02,      87,283,   3.52000000E+02,
     & 87,284,   3.61100000E+02,      87,285,   3.69180000E+02,
     & 87,286,   3.76950000E+02,      87,287,   3.84870000E+02,
     & 87,288,   3.95700000E+02,      87,289,   4.03740000E+02/
      data (niz(i),nia(i),bie(i),i=6361,6380)/
     & 88,188,   5.38600000E+01,      88,189,   5.07800000E+01,
     & 88,190,   4.58500000E+01,      88,191,   4.28000000E+01,
     & 88,192,   3.07000000E+01,      88,193,   2.89300000E+01,
     & 88,194,   2.53700000E+01,      88,195,   2.40200000E+01,
     & 88,196,   2.07000000E+01,      88,197,   1.94400000E+01,
     & 88,198,   1.67600000E+01,      88,199,   1.56000000E+01,
     & 88,200,   1.27600000E+01,      88,201,   1.19100000E+01,
     & 88,202,   9.34000000E+00,      88,203,   8.57900000E+00,
     & 88,204,   6.03400000E+00,      88,205,   5.76300000E+00,
     & 88,206,   3.52300000E+00,      88,207,   3.47200000E+00/
      data (niz(i),nia(i),bie(i),i=6381,6400)/
     & 88,208,   1.65400000E+00,      88,209,   1.81100000E+00,
     & 88,210,   4.16000000E-01,      88,211,   8.32752000E-01,
     & 88,212,  -2.01676000E-01,      88,213,   3.22155000E-01,
     & 88,214,   8.48980000E-02,      88,215,   2.51894100E+00,
     & 88,216,   3.27737000E+00,      88,217,   5.87401000E+00,
     & 88,218,   6.63591300E+00,      88,219,   9.37901300E+00,
     & 88,220,   1.02600960E+01,      88,221,   1.29549950E+01,
     & 88,222,   1.43094410E+01,      88,223,   1.72299730E+01,
     & 88,224,   1.88180430E+01,      88,225,   2.19874120E+01,
     & 88,226,   2.36623240E+01,      88,227,   2.71723060E+01/
      data (niz(i),nia(i),bie(i),i=6401,6420)/
     & 88,228,   2.89360190E+01,      88,229,   3.24349040E+01,
     & 88,230,   3.45442390E+01,      88,231,   3.83960000E+01,
     & 88,232,   4.07000000E+01,      88,233,   4.47070000E+01,
     & 88,234,   4.70850000E+01,      88,235,   5.16300000E+01,
     & 88,236,   5.44600000E+01,      88,237,   5.87800000E+01,
     & 88,238,   6.18800000E+01,      88,239,   6.65100000E+01,
     & 88,240,   6.97100000E+01,      88,241,   7.49800000E+01,
     & 88,242,   7.88500000E+01,      88,243,   8.41800000E+01,
     & 88,244,   8.79900000E+01,      88,245,   9.34100000E+01,
     & 88,246,   9.74100000E+01,      88,247,   1.02780000E+02/
      data (niz(i),nia(i),bie(i),i=6421,6440)/
     & 88,248,   1.06790000E+02,      88,249,   1.12290000E+02,
     & 88,250,   1.16490000E+02,      88,251,   1.22340000E+02,
     & 88,252,   1.26990000E+02,      88,253,   1.34260000E+02,
     & 88,254,   1.38770000E+02,      88,255,   1.44510000E+02,
     & 88,256,   1.48980000E+02,      88,257,   1.54980000E+02,
     & 88,258,   1.59740000E+02,      88,259,   1.65990000E+02,
     & 88,260,   1.69940000E+02,      88,261,   1.77480000E+02,
     & 88,262,   1.82650000E+02,      88,263,   1.89160000E+02,
     & 88,264,   1.93900000E+02,      88,265,   2.00790000E+02,
     & 88,266,   2.06460000E+02,      88,267,   2.13510000E+02/
      data (niz(i),nia(i),bie(i),i=6441,6460)/
     & 88,268,   2.19240000E+02,      88,269,   2.26410000E+02,
     & 88,270,   2.32470000E+02,      88,271,   2.39910000E+02,
     & 88,272,   2.46490000E+02,      88,273,   2.55350000E+02,
     & 88,274,   2.62350000E+02,      88,275,   2.71450000E+02,
     & 88,276,   2.78740000E+02,      88,277,   2.87650000E+02,
     & 88,278,   2.94550000E+02,      88,279,   3.02790000E+02,
     & 88,280,   3.09740000E+02,      88,281,   3.18100000E+02,
     & 88,282,   3.25400000E+02,      88,283,   3.34030000E+02,
     & 88,284,   3.41320000E+02,      88,285,   3.50580000E+02,
     & 88,286,   3.58020000E+02,      88,287,   3.66850000E+02/
      data (niz(i),nia(i),bie(i),i=6461,6480)/
     & 88,288,   3.73410000E+02,      88,289,   3.84150000E+02,
     & 88,290,   3.91860000E+02,      88,291,   3.98870000E+02,
     & 88,292,   4.06700000E+02,      89,195,   3.48200000E+01,
     & 89,196,   3.29000000E+01,      89,197,   2.95800000E+01,
     & 89,198,   2.80500000E+01,      89,199,   2.53800000E+01,
     & 89,200,   2.43300000E+01,      89,201,   2.14200000E+01,
     & 89,202,   2.01700000E+01,      89,203,   1.75200000E+01,
     & 89,204,   1.65200000E+01,      89,205,   1.40500000E+01,
     & 89,206,   1.32700000E+01,      89,207,   1.12650000E+01,
     & 89,208,   1.06980000E+01,      89,209,   8.91321900E+00/
      data (niz(i),nia(i),bie(i),i=6481,6500)/
     & 89,210,   8.62265400E+00,      89,211,   7.12424700E+00,
     & 89,212,   7.27630900E+00,      89,213,   6.12335100E+00,
     & 89,214,   6.42085500E+00,      89,215,   6.00891100E+00,
     & 89,216,   8.12380800E+00,      89,217,   8.69333000E+00,
     & 89,218,   1.08286580E+01,      89,219,   1.15551050E+01,
     & 89,220,   1.37414950E+01,      89,221,   1.45087120E+01,
     & 89,222,   1.66074660E+01,      89,223,   1.78157790E+01,
     & 89,224,   2.02212740E+01,      89,225,   2.16298240E+01,
     & 89,226,   2.43025330E+01,      89,227,   2.58461410E+01,
     & 89,228,   2.88901190E+01,      89,229,   3.06749040E+01/
      data (niz(i),nia(i),bie(i),i=6501,6520)/
     & 89,230,   3.35572010E+01,      89,231,   3.59104880E+01,
     & 89,232,   3.91436770E+01,      89,233,   4.14980000E+01,
     & 89,234,   4.51030000E+01,      89,235,   4.76010000E+01,
     & 89,236,   5.13980000E+01,      89,237,   5.44600000E+01,
     & 89,238,   5.84000000E+01,      89,239,   6.14800000E+01,
     & 89,240,   6.55800000E+01,      89,241,   6.89400000E+01,
     & 89,242,   7.38700000E+01,      89,243,   7.75900000E+01,
     & 89,244,   8.27400000E+01,      89,245,   8.65900000E+01,
     & 89,246,   9.16900000E+01,      89,247,   9.56300000E+01,
     & 89,248,   1.00690000E+02,      89,249,   1.04690000E+02/
      data (niz(i),nia(i),bie(i),i=6521,6540)/
     & 89,250,   1.09890000E+02,      89,251,   1.14120000E+02,
     & 89,252,   1.19610000E+02,      89,253,   1.24260000E+02,
     & 89,254,   1.31310000E+02,      89,255,   1.35910000E+02,
     & 89,256,   1.41450000E+02,      89,257,   1.45760000E+02,
     & 89,258,   1.51540000E+02,      89,259,   1.56230000E+02,
     & 89,260,   1.62230000E+02,      89,261,   1.66060000E+02,
     & 89,262,   1.73250000E+02,      89,263,   1.78420000E+02,
     & 89,264,   1.84590000E+02,      89,265,   1.89470000E+02,
     & 89,266,   1.95920000E+02,      89,267,   2.01590000E+02,
     & 89,268,   2.08400000E+02,      89,269,   2.14140000E+02/
      data (niz(i),nia(i),bie(i),i=6541,6560)/
     & 89,270,   2.20990000E+02,      89,271,   2.27090000E+02,
     & 89,272,   2.34200000E+02,      89,273,   2.40790000E+02,
     & 89,274,   2.49300000E+02,      89,275,   2.56300000E+02,
     & 89,276,   2.65080000E+02,      89,277,   2.72350000E+02,
     & 89,278,   2.80230000E+02,      89,279,   2.87060000E+02,
     & 89,280,   2.95060000E+02,      89,281,   3.01990000E+02,
     & 89,282,   3.09980000E+02,      89,283,   3.17170000E+02,
     & 89,284,   3.25390000E+02,      89,285,   3.32810000E+02,
     & 89,286,   3.41420000E+02,      89,287,   3.48860000E+02,
     & 89,288,   3.56740000E+02,      89,289,   3.64330000E+02/
      data (niz(i),nia(i),bie(i),i=6561,6580)/
     & 89,290,   3.74700000E+02,      89,291,   3.82370000E+02,
     & 89,292,   3.89170000E+02,      89,293,   3.97030000E+02,
     & 89,294,   4.05880000E+02,      89,295,   4.13930000E+02,
     & 90,192,   6.74300000E+01,      90,193,   6.37800000E+01,
     & 90,194,   5.87300000E+01,      90,195,   5.51900000E+01,
     & 90,196,   5.03400000E+01,      90,197,   4.72000000E+01,
     & 90,198,   3.71600000E+01,      90,199,   3.55400000E+01,
     & 90,200,   3.22300000E+01,      90,201,   3.13600000E+01,
     & 90,202,   2.84000000E+01,      90,203,   2.71400000E+01,
     & 90,204,   2.41000000E+01,      90,205,   2.30700000E+01/
      data (niz(i),nia(i),bie(i),i=6581,6600)/
     & 90,206,   2.01700000E+01,      90,207,   1.93200000E+01,
     & 90,208,   1.65800000E+01,      90,209,   1.60100000E+01,
     & 90,210,   1.40010000E+01,      90,211,   1.38400000E+01,
     & 90,212,   1.20320000E+01,      90,213,   1.20740000E+01,
     & 90,214,   1.06660000E+01,      90,215,   1.09232530E+01,
     & 90,216,   1.02939040E+01,      90,217,   1.21710560E+01,
     & 90,218,   1.23588220E+01,      90,219,   1.44579520E+01,
     & 90,220,   1.46553100E+01,      90,221,   1.69266400E+01,
     & 90,222,   1.71899090E+01,      90,223,   1.93705580E+01,
     & 90,224,   1.99891600E+01,      90,225,   2.23013060E+01/
      data (niz(i),nia(i),bie(i),i=6601,6620)/
     & 90,226,   2.31855170E+01,      90,227,   2.58013170E+01,
     & 90,228,   2.67630750E+01,      90,229,   2.95799040E+01,
     & 90,230,   3.08572010E+01,      90,231,   3.38104880E+01,
     & 90,232,   3.54436770E+01,      90,233,   3.87286490E+01,
     & 90,234,   4.06089380E+01,      90,235,   4.42500760E+01,
     & 90,236,   4.63050000E+01,      90,237,   5.02020000E+01,
     & 90,238,   5.23900000E+01,      90,239,   5.68100000E+01,
     & 90,240,   5.95200000E+01,      90,241,   6.35900000E+01,
     & 90,242,   6.65900000E+01,      90,243,   7.15100000E+01,
     & 90,244,   7.48700000E+01,      90,245,   8.00300000E+01/
      data (niz(i),nia(i),bie(i),i=6621,6640)/
     & 90,246,   8.35300000E+01,      90,247,   8.85400000E+01,
     & 90,248,   9.22300000E+01,      90,249,   9.72700000E+01,
     & 90,250,   1.00930000E+02,      90,251,   1.06120000E+02,
     & 90,252,   1.09990000E+02,      90,253,   1.15550000E+02,
     & 90,254,   1.19900000E+02,      90,255,   1.25910000E+02,
     & 90,256,   1.31180000E+02,      90,257,   1.36720000E+02,
     & 90,258,   1.40860000E+02,      90,259,   1.46440000E+02,
     & 90,260,   1.50960000E+02,      90,261,   1.56880000E+02,
     & 90,262,   1.60600000E+02,      90,263,   1.67720000E+02,
     & 90,264,   1.72610000E+02,      90,265,   1.78780000E+02/
      data (niz(i),nia(i),bie(i),i=6641,6660)/
     & 90,266,   1.83390000E+02,      90,267,   1.89840000E+02,
     & 90,268,   1.95160000E+02,      90,269,   2.02060000E+02,
     & 90,270,   2.07460000E+02,      90,271,   2.14330000E+02,
     & 90,272,   2.20090000E+02,      90,273,   2.27260000E+02,
     & 90,274,   2.33530000E+02,      90,275,   2.42070000E+02,
     & 90,276,   2.48710000E+02,      90,277,   2.57410000E+02,
     & 90,278,   2.64230000E+02,      90,279,   2.71660000E+02,
     & 90,280,   2.78180000E+02,      90,281,   2.86180000E+02,
     & 90,282,   2.92880000E+02,      90,283,   3.00840000E+02,
     & 90,284,   3.07650000E+02,      90,285,   3.15870000E+02/
      data (niz(i),nia(i),bie(i),i=6661,6680)/
     & 90,286,   3.22960000E+02,      90,287,   3.31550000E+02,
     & 90,288,   3.38230000E+02,      90,289,   3.46650000E+02,
     & 90,290,   3.55490000E+02,      90,291,   3.64010000E+02,
     & 90,292,   3.71400000E+02,      90,293,   3.78380000E+02,
     & 90,294,   3.85930000E+02,      90,295,   3.94770000E+02,
     & 90,296,   4.02520000E+02,      90,297,   4.11690000E+02,
     & 90,298,   4.19970000E+02,      90,299,   4.28760000E+02,
     & 91,200,   4.49400000E+01,      91,201,   4.16100000E+01,
     & 91,202,   4.04000000E+01,      91,203,   3.71800000E+01,
     & 91,204,   3.56500000E+01,      91,205,   3.27800000E+01/
      data (niz(i),nia(i),bie(i),i=6681,6700)/
     & 91,206,   3.13400000E+01,      91,207,   2.86800000E+01,
     & 91,208,   2.74100000E+01,      91,209,   2.46700000E+01,
     & 91,210,   2.37300000E+01,      91,211,   2.13700000E+01,
     & 91,212,   2.09300000E+01,      91,213,   1.97320300E+01,
     & 91,214,   1.93184650E+01,      91,215,   1.77893080E+01,
     & 91,216,   1.78005200E+01,      91,217,   1.70356910E+01,
     & 91,218,   1.86372420E+01,      91,219,   1.85184220E+01,
     & 91,220,   2.03778190E+01,      91,221,   2.03659410E+01,
     & 91,222,   2.21000000E+01,      91,223,   2.23220840E+01,
     & 91,224,   2.38600800E+01,      91,225,   2.43261230E+01/
      data (niz(i),nia(i),bie(i),i=6701,6720)/
     & 91,226,   2.60191860E+01,      91,227,   2.68206440E+01,
     & 91,228,   2.89107210E+01,      91,229,   2.98903350E+01,
     & 91,230,   3.21668690E+01,      91,231,   3.34209730E+01,
     & 91,232,   3.59386350E+01,      91,233,   3.74835320E+01,
     & 91,234,   4.03358500E+01,      91,235,   4.23240620E+01,
     & 91,236,   4.53406270E+01,      91,237,   4.76360650E+01,
     & 91,238,   5.07636640E+01,      91,239,   5.32160000E+01,
     & 91,240,   5.68020000E+01,      91,241,   5.99900000E+01,
     & 91,242,   6.38800000E+01,      91,243,   6.66200000E+01,
     & 91,244,   7.10100000E+01,      91,245,   7.45600000E+01/
      data (niz(i),nia(i),bie(i),i=6721,6740)/
     & 91,246,   7.94400000E+01,      91,247,   8.28900000E+01,
     & 91,248,   8.75700000E+01,      91,249,   9.12000000E+01,
     & 91,250,   9.59500000E+01,      91,251,   9.96200000E+01,
     & 91,252,   1.04480000E+02,      91,253,   1.08380000E+02,
     & 91,254,   1.13580000E+02,      91,255,   1.17950000E+02,
     & 91,256,   1.23750000E+02,      91,257,   1.28020000E+02,
     & 91,258,   1.34180000E+02,      91,259,   1.38340000E+02,
     & 91,260,   1.43820000E+02,      91,261,   1.48190000E+02,
     & 91,262,   1.53870000E+02,      91,263,   1.57570000E+02,
     & 91,264,   1.64410000E+02,      91,265,   1.69290000E+02/
      data (niz(i),nia(i),bie(i),i=6741,6760)/
     & 91,266,   1.75220000E+02,      91,267,   1.79750000E+02,
     & 91,268,   1.85890000E+02,      91,269,   1.91210000E+02,
     & 91,270,   1.97800000E+02,      91,271,   2.03220000E+02,
     & 91,272,   2.09770000E+02,      91,273,   2.15560000E+02,
     & 91,274,   2.22430000E+02,      91,275,   2.28710000E+02,
     & 91,276,   2.36920000E+02,      91,277,   2.43540000E+02,
     & 91,278,   2.51860000E+02,      91,279,   2.57730000E+02,
     & 91,280,   2.65190000E+02,      91,281,   2.71800000E+02,
     & 91,282,   2.79430000E+02,      91,283,   2.86060000E+02,
     & 91,284,   2.93680000E+02,      91,285,   3.00500000E+02/
      data (niz(i),nia(i),bie(i),i=6761,6780)/
     & 91,286,   3.08340000E+02,      91,287,   3.15350000E+02,
     & 91,288,   3.23380000E+02,      91,289,   3.30460000E+02,
     & 91,290,   3.38620000E+02,      91,291,   3.47190000E+02,
     & 91,292,   3.55380000E+02,      91,293,   3.62740000E+02,
     & 91,294,   3.71180000E+02,      91,295,   3.77290000E+02,
     & 91,296,   3.85800000E+02,      91,297,   3.93710000E+02,
     & 91,298,   4.02650000E+02,      91,299,   4.10660000E+02,
     & 91,300,   4.20190000E+02,      91,301,   4.26830000E+02,
     & 91,302,   4.35920000E+02,      92,201,   6.00100000E+01,
     & 92,202,   5.53200000E+01,      92,203,   4.80700000E+01/
      data (niz(i),nia(i),bie(i),i=6781,6800)/
     & 92,204,   4.45800000E+01,      92,205,   4.30600000E+01,
     & 92,206,   3.98700000E+01,      92,207,   3.83700000E+01,
     & 92,208,   3.53300000E+01,      92,209,   3.42600000E+01,
     & 92,210,   3.10800000E+01,      92,211,   3.01100000E+01,
     & 92,212,   2.73500000E+01,      92,213,   2.68200000E+01,
     & 92,214,   2.47500000E+01,      92,215,   2.43900000E+01,
     & 92,216,   2.23800000E+01,      92,217,   2.21700000E+01,
     & 92,218,   2.18780000E+01,      92,219,   2.32085640E+01,
     & 92,220,   2.30190000E+01,      92,221,   2.45460000E+01,
     & 92,222,   2.42840000E+01,      92,223,   2.58237630E+01/
      data (niz(i),nia(i),bie(i),i=6801,6820)/
     & 92,224,   2.57000450E+01,      92,225,   2.73713600E+01,
     & 92,226,   2.73297970E+01,      92,227,   2.90067830E+01,
     & 92,228,   2.92175690E+01,      92,229,   3.12014460E+01,
     & 92,230,   3.16031580E+01,      92,231,   3.38031280E+01,
     & 92,232,   3.46015310E+01,      92,233,   3.69134210E+01,
     & 92,234,   3.81405800E+01,      92,235,   4.09140620E+01,
     & 92,236,   4.24406270E+01,      92,237,   4.53860650E+01,
     & 92,238,   4.73036640E+01,      92,239,   5.05687310E+01,
     & 92,240,   5.27092640E+01,      92,241,   5.61970000E+01,
     & 92,242,   5.86140000E+01,      92,243,   6.27500000E+01/
      data (niz(i),nia(i),bie(i),i=6821,6840)/
     & 92,244,   6.51600000E+01,      92,245,   6.94800000E+01,
     & 92,246,   7.27200000E+01,      92,247,   7.75400000E+01,
     & 92,248,   8.06300000E+01,      92,249,   8.53200000E+01,
     & 92,250,   8.86000000E+01,      92,251,   9.33100000E+01,
     & 92,252,   9.66300000E+01,      92,253,   1.01480000E+02,
     & 92,254,   1.05040000E+02,      92,255,   1.10280000E+02,
     & 92,256,   1.14350000E+02,      92,257,   1.19790000E+02,
     & 92,258,   1.24130000E+02,      92,259,   1.29570000E+02,
     & 92,260,   1.33890000E+02,      92,261,   1.39490000E+02,
     & 92,262,   1.43750000E+02,      92,263,   1.49420000E+02/
      data (niz(i),nia(i),bie(i),i=6841,6860)/
     & 92,264,   1.52900000E+02,      92,265,   1.59560000E+02,
     & 92,266,   1.64140000E+02,      92,267,   1.70020000E+02,
     & 92,268,   1.74400000E+02,      92,269,   1.80550000E+02,
     & 92,270,   1.85520000E+02,      92,271,   1.92160000E+02,
     & 92,272,   1.97270000E+02,      92,273,   2.03820000E+02,
     & 92,274,   2.09320000E+02,      92,275,   2.16170000E+02,
     & 92,276,   2.22130000E+02,      92,277,   2.30370000E+02,
     & 92,278,   2.36670000E+02,      92,279,   2.44890000E+02,
     & 92,280,   2.50180000E+02,      92,281,   2.57600000E+02,
     & 92,282,   2.63790000E+02,      92,283,   2.71390000E+02/
      data (niz(i),nia(i),bie(i),i=6861,6880)/
     & 92,284,   2.77800000E+02,      92,285,   2.85480000E+02,
     & 92,286,   2.91970000E+02,      92,287,   2.99800000E+02,
     & 92,288,   3.06580000E+02,      92,289,   3.14630000E+02,
     & 92,290,   3.21380000E+02,      92,291,   3.29570000E+02,
     & 92,292,   3.37510000E+02,      92,293,   3.45730000E+02,
     & 92,294,   3.52640000E+02,      92,295,   3.61000000E+02,
     & 92,296,   3.68280000E+02,      92,297,   3.77080000E+02,
     & 92,298,   3.83520000E+02,      92,299,   3.92310000E+02,
     & 92,300,   4.00180000E+02,      92,301,   4.08100000E+02,
     & 92,302,   4.15600000E+02,      92,303,   4.24670000E+02/
      data (niz(i),nia(i),bie(i),i=6881,6900)/
     & 92,304,   4.34440000E+02,      92,305,   4.41780000E+02,
     & 93,206,   5.22600000E+01,      93,207,   4.90400000E+01,
     & 93,208,   4.74100000E+01,      93,209,   4.43100000E+01,
     & 93,210,   4.28500000E+01,      93,211,   3.99300000E+01,
     & 93,212,   3.85500000E+01,      93,213,   3.58200000E+01,
     & 93,214,   3.48800000E+01,      93,215,   3.28500000E+01,
     & 93,216,   3.21500000E+01,      93,217,   3.02100000E+01,
     & 93,218,   2.97300000E+01,      93,219,   2.82900000E+01,
     & 93,220,   2.97000000E+01,      93,221,   2.94700000E+01,
     & 93,222,   3.14800000E+01,      93,223,   2.98000000E+01/
      data (niz(i),nia(i),bie(i),i=6901,6920)/
     & 93,224,   3.10900000E+01,      93,225,   3.15773520E+01,
     & 93,226,   3.27230000E+01,      93,227,   3.25634060E+01,
     & 93,228,   3.37010000E+01,      93,229,   3.37637340E+01,
     & 93,230,   3.52221970E+01,      93,231,   3.56139550E+01,
     & 93,232,   3.73520000E+01,      93,233,   3.79419340E+01,
     & 93,234,   3.99504260E+01,      93,235,   4.10377780E+01,
     & 93,236,   4.33700970E+01,      93,237,   4.48675010E+01,
     & 93,238,   4.74507290E+01,      93,239,   4.93052730E+01,
     & 93,240,   5.23209180E+01,      93,241,   5.42560390E+01,
     & 93,242,   5.74130000E+01,      93,243,   5.98700000E+01/
      data (niz(i),nia(i),bie(i),i=6921,6940)/
     & 93,244,   6.32020000E+01,      93,245,   6.60100000E+01,
     & 93,246,   7.00200000E+01,      93,247,   7.31900000E+01,
     & 93,248,   7.74900000E+01,      93,249,   8.08200000E+01,
     & 93,250,   8.51600000E+01,      93,251,   8.84400000E+01,
     & 93,252,   9.28200000E+01,      93,253,   9.61500000E+01,
     & 93,254,   1.00660000E+02,      93,255,   1.04190000E+02,
     & 93,256,   1.09110000E+02,      93,257,   1.13150000E+02,
     & 93,258,   1.18300000E+02,      93,259,   1.22710000E+02,
     & 93,260,   1.27850000E+02,      93,261,   1.32090000E+02,
     & 93,262,   1.37420000E+02,      93,263,   1.41790000E+02/
      data (niz(i),nia(i),bie(i),i=6941,6960)/
     & 93,264,   1.47070000E+02,      93,265,   1.50660000E+02,
     & 93,266,   1.56990000E+02,      93,267,   1.61620000E+02,
     & 93,268,   1.67190000E+02,      93,269,   1.71550000E+02,
     & 93,270,   1.77380000E+02,      93,271,   1.82370000E+02,
     & 93,272,   1.88770000E+02,      93,273,   1.93950000E+02,
     & 93,274,   2.00220000E+02,      93,275,   2.05760000E+02,
     & 93,276,   2.12230000E+02,      93,277,   2.18200000E+02,
     & 93,278,   2.26080000E+02,      93,279,   2.32350000E+02,
     & 93,280,   2.38880000E+02,      93,281,   2.44930000E+02,
     & 93,282,   2.51970000E+02,      93,283,   2.58120000E+02/
      data (niz(i),nia(i),bie(i),i=6961,6980)/
     & 93,284,   2.65490000E+02,      93,285,   2.71770000E+02,
     & 93,286,   2.79160000E+02,      93,287,   2.85700000E+02,
     & 93,288,   2.93270000E+02,      93,289,   3.00100000E+02,
     & 93,290,   3.08210000E+02,      93,291,   3.15010000E+02,
     & 93,292,   3.23520000E+02,      93,293,   3.30190000E+02,
     & 93,294,   3.37950000E+02,      93,295,   3.44940000E+02,
     & 93,296,   3.52880000E+02,      93,297,   3.60130000E+02,
     & 93,298,   3.68350000E+02,      93,299,   3.75830000E+02,
     & 93,300,   3.83510000E+02,      93,301,   3.90800000E+02,
     & 93,302,   3.99150000E+02,      93,303,   4.06650000E+02/
      data (niz(i),nia(i),bie(i),i=6981,7000)/
     & 93,304,   4.15450000E+02,      93,305,   4.25180000E+02,
     & 93,306,   4.32290000E+02,      93,307,   4.40340000E+02,
     & 93,308,   4.49620000E+02,      94,208,   6.24400000E+01,
     & 94,209,   5.50500000E+01,      94,210,   5.16500000E+01,
     & 94,211,   5.00900000E+01,      94,212,   4.69200000E+01,
     & 94,213,   4.56300000E+01,      94,214,   4.25000000E+01,
     & 94,215,   4.15500000E+01,      94,216,   3.91200000E+01,
     & 94,217,   3.83800000E+01,      94,218,   3.60400000E+01,
     & 94,219,   3.54600000E+01,      94,220,   3.37200000E+01,
     & 94,221,   3.50500000E+01,      94,222,   3.44500000E+01/
      data (niz(i),nia(i),bie(i),i=7001,7020)/
     & 94,223,   3.51500000E+01,      94,224,   3.44800000E+01,
     & 94,225,   3.55800000E+01,      94,226,   3.52200000E+01,
     & 94,227,   3.64900000E+01,      94,228,   3.60746020E+01,
     & 94,229,   3.73891710E+01,      94,230,   3.69296360E+01,
     & 94,231,   3.84320000E+01,      94,232,   3.83584000E+01,
     & 94,233,   4.00426570E+01,      94,234,   4.03380440E+01,
     & 94,235,   4.21794400E+01,      94,236,   4.28935120E+01,
     & 94,237,   4.50878180E+01,      94,238,   4.61586880E+01,
     & 94,239,   4.85834780E+01,      94,240,   5.01213190E+01,
     & 94,241,   5.29510390E+01,      94,242,   5.47130120E+01/
      data (niz(i),nia(i),bie(i),i=7021,7040)/
     & 94,243,   5.77498370E+01,      94,244,   5.97997170E+01,
     & 94,245,   6.30981430E+01,      94,246,   6.53894060E+01,
     & 94,247,   6.89960000E+01,      94,248,   7.21900000E+01,
     & 94,249,   7.64600000E+01,      94,250,   7.93900000E+01,
     & 94,251,   8.36800000E+01,      94,252,   8.65900000E+01,
     & 94,253,   9.09700000E+01,      94,254,   9.39400000E+01,
     & 94,255,   9.84400000E+01,      94,256,   1.01630000E+02,
     & 94,257,   1.06540000E+02,      94,258,   1.10270000E+02,
     & 94,259,   1.15460000E+02,      94,260,   1.19590000E+02,
     & 94,261,   1.24750000E+02,      94,262,   1.28480000E+02/
      data (niz(i),nia(i),bie(i),i=7041,7060)/
     & 94,263,   1.34080000E+02,      94,264,   1.38130000E+02,
     & 94,265,   1.43380000E+02,      94,266,   1.46740000E+02,
     & 94,267,   1.52980000E+02,      94,268,   1.57220000E+02,
     & 94,269,   1.62840000E+02,      94,270,   1.66830000E+02,
     & 94,271,   1.72760000E+02,      94,272,   1.77410000E+02,
     & 94,273,   1.83800000E+02,      94,274,   1.88660000E+02,
     & 94,275,   1.94900000E+02,      94,276,   2.00100000E+02,
     & 94,277,   2.06670000E+02,      94,278,   2.12320000E+02,
     & 94,279,   2.20130000E+02,      94,280,   2.26120000E+02,
     & 94,281,   2.33740000E+02,      94,282,   2.38440000E+02/
      data (niz(i),nia(i),bie(i),i=7061,7080)/
     & 94,283,   2.45400000E+02,      94,284,   2.51340000E+02,
     & 94,285,   2.58460000E+02,      94,286,   2.64530000E+02,
     & 94,287,   2.71930000E+02,      94,288,   2.78280000E+02,
     & 94,289,   2.86190000E+02,      94,290,   2.92540000E+02,
     & 94,291,   3.00270000E+02,      94,292,   3.07150000E+02,
     & 94,293,   3.14900000E+02,      94,294,   3.21430000E+02,
     & 94,295,   3.29120000E+02,      94,296,   3.35700000E+02,
     & 94,297,   3.43780000E+02,      94,298,   3.50550000E+02,
     & 94,299,   3.58930000E+02,      94,300,   3.65570000E+02,
     & 94,301,   3.73730000E+02,      94,302,   3.80720000E+02/
      data (niz(i),nia(i),bie(i),i=7081,7100)/
     & 94,303,   3.89070000E+02,      94,304,   3.96250000E+02,
     & 94,305,   4.05070000E+02,      94,306,   4.12700000E+02,
     & 94,307,   4.21540000E+02,      94,308,   4.29410000E+02,
     & 94,309,   4.38440000E+02,      94,310,   4.46280000E+02,
     & 94,311,   4.55370000E+02,      94,312,   4.63110000E+02,
     & 95,212,   5.94300000E+01,      95,213,   5.61600000E+01,
     & 95,214,   5.48300000E+01,      95,215,   5.17200000E+01,
     & 95,216,   5.04400000E+01,      95,217,   4.79400000E+01,
     & 95,218,   4.68600000E+01,      95,219,   4.45600000E+01,
     & 95,220,   4.37200000E+01,      95,221,   4.18100000E+01/
      data (niz(i),nia(i),bie(i),i=7101,7120)/
     & 95,222,   4.28900000E+01,      95,223,   4.20800000E+01,
     & 95,224,   4.36200000E+01,      95,225,   4.17000000E+01,
     & 95,226,   4.24500000E+01,      95,227,   4.17700000E+01,
     & 95,228,   4.23400000E+01,      95,229,   4.16700000E+01,
     & 95,230,   4.24900000E+01,      95,231,   4.24390000E+01,
     & 95,232,   4.33980000E+01,      95,233,   4.32890000E+01,
     & 95,234,   4.45200000E+01,      95,235,   4.47390000E+01,
     & 95,236,   4.61740000E+01,      95,237,   4.65474450E+01,
     & 95,238,   4.84170370E+01,      95,239,   4.93863890E+01,
     & 95,240,   5.15002710E+01,      95,241,   5.29302240E+01/
      data (niz(i),nia(i),bie(i),i=7121,7140)/
     & 95,242,   5.54639750E+01,      95,243,   5.71682800E+01,
     & 95,244,   5.98758940E+01,      95,245,   6.18934800E+01,
     & 95,246,   6.49888720E+01,      95,247,   6.71480000E+01,
     & 95,248,   7.05560000E+01,      95,249,   7.31040000E+01,
     & 95,250,   7.75000000E+01,      95,251,   8.04000000E+01,
     & 95,252,   8.43400000E+01,      95,253,   8.72300000E+01,
     & 95,254,   9.12400000E+01,      95,255,   9.42100000E+01,
     & 95,256,   9.84000000E+01,      95,257,   1.01580000E+02,
     & 95,258,   1.06160000E+02,      95,259,   1.09880000E+02,
     & 95,260,   1.14760000E+02,      95,261,   1.18920000E+02/
      data (niz(i),nia(i),bie(i),i=7141,7160)/
     & 95,262,   1.23710000E+02,      95,263,   1.27510000E+02,
     & 95,264,   1.32640000E+02,      95,265,   1.36950000E+02,
     & 95,266,   1.41880000E+02,      95,267,   1.45300000E+02,
     & 95,268,   1.51100000E+02,      95,269,   1.55430000E+02,
     & 95,270,   1.60720000E+02,      95,271,   1.64740000E+02,
     & 95,272,   1.70260000E+02,      95,273,   1.75020000E+02,
     & 95,274,   1.81150000E+02,      95,275,   1.86030000E+02,
     & 95,276,   1.92010000E+02,      95,277,   1.97220000E+02,
     & 95,278,   2.03510000E+02,      95,279,   2.09180000E+02,
     & 95,280,   2.16470000E+02,      95,281,   2.22430000E+02/
      data (niz(i),nia(i),bie(i),i=7161,7180)/
     & 95,282,   2.28500000E+02,      95,283,   2.34180000E+02,
     & 95,284,   2.40910000E+02,      95,285,   2.46720000E+02,
     & 95,286,   2.53580000E+02,      95,287,   2.60770000E+02,
     & 95,288,   2.66770000E+02,      95,289,   2.73270000E+02,
     & 95,290,   2.80520000E+02,      95,291,   2.87160000E+02,
     & 95,292,   2.94500000E+02,      95,293,   3.00810000E+02,
     & 95,294,   3.08240000E+02,      95,295,   3.14750000E+02,
     & 95,296,   3.22210000E+02,      95,297,   3.28710000E+02,
     & 95,298,   3.36520000E+02,      95,299,   3.43250000E+02,
     & 95,300,   3.51100000E+02,      95,301,   3.58070000E+02/
      data (niz(i),nia(i),bie(i),i=7181,7200)/
     & 95,302,   3.65990000E+02,      95,303,   3.72990000E+02,
     & 95,304,   3.81040000E+02,      95,305,   3.88230000E+02,
     & 95,306,   3.96750000E+02,      95,307,   4.04390000E+02,
     & 95,308,   4.12960000E+02,      95,309,   4.20770000E+02,
     & 95,310,   4.29410000E+02,      95,311,   4.37380000E+02,
     & 95,312,   4.45970000E+02,      95,313,   4.53730000E+02,
     & 95,314,   4.62590000E+02,      95,315,   4.70480000E+02,
     & 96,212,   7.75000000E+01,      96,213,   7.53500000E+01,
     & 96,214,   7.16300000E+01,      96,215,   6.23400000E+01,
     & 96,216,   5.91300000E+01,      96,217,   5.78000000E+01/
      data (niz(i),nia(i),bie(i),i=7201,7220)/
     & 96,218,   5.48700000E+01,      96,219,   5.37700000E+01,
     & 96,220,   5.10500000E+01,      96,221,   5.01000000E+01,
     & 96,222,   4.78800000E+01,      96,223,   4.88100000E+01,
     & 96,224,   4.74200000E+01,      96,225,   4.92200000E+01,
     & 96,226,   4.69100000E+01,      96,227,   4.77600000E+01,
     & 96,228,   4.66300000E+01,      96,229,   4.72000000E+01,
     & 96,230,   4.61300000E+01,      96,231,   4.69300000E+01,
     & 96,232,   4.61800000E+01,      96,233,   4.73200000E+01,
     & 96,234,   4.67980000E+01,      96,235,   4.80570000E+01,
     & 96,236,   4.78830000E+01,      96,237,   4.92680000E+01/
      data (niz(i),nia(i),bie(i),i=7221,7240)/
     & 96,238,   4.93843560E+01,      96,239,   5.11860000E+01,
     & 96,240,   5.17156510E+01,      96,241,   5.36975810E+01,
     & 96,242,   5.47991560E+01,      96,243,   5.71771890E+01,
     & 96,244,   5.84478390E+01,      96,245,   6.09994220E+01,
     & 96,246,   6.26127360E+01,      96,247,   6.55276220E+01,
     & 96,248,   6.73863590E+01,      96,249,   7.07442220E+01,
     & 96,250,   7.29831840E+01,      96,251,   7.66413330E+01,
     & 96,252,   7.90560000E+01,      96,253,   8.37500000E+01,
     & 96,254,   8.62500000E+01,      96,255,   9.02500000E+01,
     & 96,256,   9.28500000E+01,      96,257,   9.69900000E+01/
      data (niz(i),nia(i),bie(i),i=7241,7260)/
     & 96,258,   9.98200000E+01,      96,259,   1.04370000E+02,
     & 96,260,   1.07780000E+02,      96,261,   1.12650000E+02,
     & 96,262,   1.16260000E+02,      96,263,   1.21410000E+02,
     & 96,264,   1.24850000E+02,      96,265,   1.29740000E+02,
     & 96,266,   1.34020000E+02,      96,267,   1.38960000E+02,
     & 96,268,   1.42190000E+02,      96,269,   1.47820000E+02,
     & 96,270,   1.51820000E+02,      96,271,   1.57100000E+02,
     & 96,272,   1.60930000E+02,      96,273,   1.66430000E+02,
     & 96,274,   1.70870000E+02,      96,275,   1.76930000E+02,
     & 96,276,   1.81490000E+02,      96,277,   1.87470000E+02/
      data (niz(i),nia(i),bie(i),i=7261,7280)/
     & 96,278,   1.92360000E+02,      96,279,   1.98650000E+02,
     & 96,280,   2.03990000E+02,      96,281,   2.11330000E+02,
     & 96,282,   2.16910000E+02,      96,283,   2.24150000E+02,
     & 96,284,   2.29880000E+02,      96,285,   2.36410000E+02,
     & 96,286,   2.41710000E+02,      96,287,   2.48530000E+02,
     & 96,288,   2.54050000E+02,      96,289,   2.61060000E+02,
     & 96,290,   2.66770000E+02,      96,291,   2.73980000E+02,
     & 96,292,   2.79850000E+02,      96,293,   2.87150000E+02,
     & 96,294,   2.93150000E+02,      96,295,   3.00550000E+02,
     & 96,296,   3.06720000E+02,      96,297,   3.14250000E+02/
      data (niz(i),nia(i),bie(i),i=7281,7300)/
     & 96,298,   3.20560000E+02,      96,299,   3.28130000E+02,
     & 96,300,   3.34680000E+02,      96,301,   3.42540000E+02,
     & 96,302,   3.49220000E+02,      96,303,   3.57150000E+02,
     & 96,304,   3.63840000E+02,      96,305,   3.71880000E+02,
     & 96,306,   3.78780000E+02,      96,307,   3.87300000E+02,
     & 96,308,   3.94610000E+02,      96,309,   4.03170000E+02,
     & 96,310,   4.10670000E+02,      96,311,   4.19300000E+02,
     & 96,312,   4.26830000E+02,      96,313,   4.35490000E+02,
     & 96,314,   4.42940000E+02,      96,315,   4.51830000E+02,
     & 96,316,   4.59440000E+02,      96,317,   4.68460000E+02/
      data (niz(i),nia(i),bie(i),i=7301,7320)/
     & 96,318,   4.76480000E+02,      97,218,   6.73300000E+01,
     & 97,219,   6.43900000E+01,      97,220,   6.29000000E+01,
     & 97,221,   6.02100000E+01,      97,222,   5.90000000E+01,
     & 97,223,   5.66300000E+01,      97,224,   5.72700000E+01,
     & 97,225,   5.55500000E+01,      97,226,   5.70100000E+01,
     & 97,227,   5.49700000E+01,      97,228,   5.49200000E+01,
     & 97,229,   5.35400000E+01,      97,230,   5.38200000E+01,
     & 97,231,   5.27000000E+01,      97,232,   5.31300000E+01,
     & 97,233,   5.23600000E+01,      97,234,   5.30400000E+01,
     & 97,235,   5.27040000E+01,      97,236,   5.34030000E+01/
      data (niz(i),nia(i),bie(i),i=7321,7340)/
     & 97,237,   5.32140000E+01,      97,238,   5.42740000E+01,
     & 97,239,   5.43640000E+01,      97,240,   5.56560000E+01,
     & 97,241,   5.60980000E+01,      97,242,   5.77990000E+01,
     & 97,243,   5.86855760E+01,      97,244,   6.07034820E+01,
     & 97,245,   6.18096350E+01,      97,246,   6.39627360E+01,
     & 97,247,   6.54826520E+01,      97,248,   6.80740000E+01,
     & 97,249,   6.98433510E+01,      97,250,   7.29457770E+01,
     & 97,251,   7.52213330E+01,      97,252,   7.85280000E+01,
     & 97,253,   8.09290000E+01,      97,254,   8.43930000E+01,
     & 97,255,   8.76400000E+01,      97,256,   9.12900000E+01/
      data (niz(i),nia(i),bie(i),i=7341,7360)/
     & 97,257,   9.38800000E+01,      97,258,   9.76800000E+01,
     & 97,259,   1.00490000E+02,      97,260,   1.04700000E+02,
     & 97,261,   1.08080000E+02,      97,262,   1.12670000E+02,
     & 97,263,   1.16210000E+02,      97,264,   1.21170000E+02,
     & 97,265,   1.24630000E+02,      97,266,   1.29200000E+02,
     & 97,267,   1.33410000E+02,      97,268,   1.38230000E+02,
     & 97,269,   1.41510000E+02,      97,270,   1.46740000E+02,
     & 97,271,   1.50700000E+02,      97,272,   1.55710000E+02,
     & 97,273,   1.59600000E+02,      97,274,   1.64780000E+02,
     & 97,275,   1.69230000E+02,      97,276,   1.75040000E+02/
      data (niz(i),nia(i),bie(i),i=7361,7380)/
     & 97,277,   1.79590000E+02,      97,278,   1.85270000E+02,
     & 97,279,   1.90200000E+02,      97,280,   1.96210000E+02,
     & 97,281,   2.01560000E+02,      97,282,   2.08400000E+02,
     & 97,283,   2.13930000E+02,      97,284,   2.20760000E+02,
     & 97,285,   2.26050000E+02,      97,286,   2.32400000E+02,
     & 97,287,   2.37690000E+02,      97,288,   2.44190000E+02,
     & 97,289,   2.49700000E+02,      97,290,   2.56400000E+02,
     & 97,291,   2.62090000E+02,      97,292,   2.68960000E+02,
     & 97,293,   2.74810000E+02,      97,294,   2.81740000E+02,
     & 97,295,   2.87790000E+02,      97,296,   2.94790000E+02/
      data (niz(i),nia(i),bie(i),i=7381,7400)/
     & 97,297,   3.00890000E+02,      97,298,   3.08110000E+02,
     & 97,299,   3.14450000E+02,      97,300,   3.21690000E+02,
     & 97,301,   3.28220000E+02,      97,302,   3.35750000E+02,
     & 97,303,   3.42670000E+02,      97,304,   3.50360000E+02,
     & 97,305,   3.57020000E+02,      97,306,   3.64750000E+02,
     & 97,307,   3.71650000E+02,      97,308,   3.79690000E+02,
     & 97,309,   3.86970000E+02,      97,310,   3.95380000E+02,
     & 97,311,   4.02820000E+02,      97,312,   4.11210000E+02,
     & 97,313,   4.18720000E+02,      97,314,   4.27020000E+02,
     & 97,315,   4.34470000E+02,      97,316,   4.43110000E+02/
      data (niz(i),nia(i),bie(i),i=7401,7420)/
     & 97,317,   4.50730000E+02,      97,318,   4.59460000E+02,
     & 97,319,   4.67460000E+02,      97,320,   4.76410000E+02,
     & 97,321,   4.84610000E+02,      98,216,   9.34700000E+01,
     & 98,217,   9.10300000E+01,      98,218,   8.67100000E+01,
     & 98,219,   8.43500000E+01,      98,220,   8.01300000E+01,
     & 98,221,   7.04700000E+01,      98,222,   6.73600000E+01,
     & 98,223,   6.61100000E+01,      98,224,   6.33800000E+01,
     & 98,225,   6.38700000E+01,      98,226,   6.19200000E+01,
     & 98,227,   6.32600000E+01,      98,228,   6.09100000E+01,
     & 98,229,   6.08700000E+01,      98,230,   5.91700000E+01/
      data (niz(i),nia(i),bie(i),i=7421,7440)/
     & 98,231,   5.93800000E+01,      98,232,   5.79200000E+01,
     & 98,233,   5.83900000E+01,      98,234,   5.72100000E+01,
     & 98,235,   5.78500000E+01,      98,236,   5.69700000E+01,
     & 98,237,   5.78180000E+01,      98,238,   5.72030000E+01,
     & 98,239,   5.82920000E+01,      98,240,   5.80270000E+01,
     & 98,241,   5.93510000E+01,      98,242,   5.93256450E+01,
     & 98,243,   6.09390000E+01,      98,244,   6.14696430E+01,
     & 98,245,   6.33780000E+01,      98,246,   6.40856670E+01,
     & 98,247,   6.61286520E+01,      98,248,   6.72334390E+01,
     & 98,249,   6.97193510E+01,      98,250,   7.11660850E+01/
      data (niz(i),nia(i),bie(i),i=7441,7460)/
     & 98,251,   7.41283330E+01,      98,252,   7.60281390E+01,
     & 98,253,   7.92950830E+01,      98,254,   8.13345030E+01,
     & 98,255,   8.48030000E+01,      98,256,   8.70390000E+01,
     & 98,257,   9.12100000E+01,      98,258,   9.34200000E+01,
     & 98,259,   9.71900000E+01,      98,260,   9.96100000E+01,
     & 98,261,   1.03760000E+02,      98,262,   1.06840000E+02,
     & 98,263,   1.11440000E+02,      98,264,   1.14690000E+02,
     & 98,265,   1.19660000E+02,      98,266,   1.22720000E+02,
     & 98,267,   1.27370000E+02,      98,268,   1.31250000E+02,
     & 98,269,   1.36030000E+02,      98,270,   1.39160000E+02/
      data (niz(i),nia(i),bie(i),i=7461,7480)/
     & 98,271,   1.44200000E+02,      98,272,   1.47820000E+02,
     & 98,273,   1.52840000E+02,      98,274,   1.56510000E+02,
     & 98,275,   1.61680000E+02,      98,276,   1.65790000E+02,
     & 98,277,   1.71530000E+02,      98,278,   1.75780000E+02,
     & 98,279,   1.81460000E+02,      98,280,   1.86070000E+02,
     & 98,281,   1.92090000E+02,      98,282,   1.97130000E+02,
     & 98,283,   2.04000000E+02,      98,284,   2.09200000E+02,
     & 98,285,   2.15920000E+02,      98,286,   2.21020000E+02,
     & 98,287,   2.27350000E+02,      98,288,   2.32320000E+02,
     & 98,289,   2.38810000E+02,      98,290,   2.44010000E+02/
      data (niz(i),nia(i),bie(i),i=7481,7500)/
     & 98,291,   2.50670000E+02,      98,292,   2.56040000E+02,
     & 98,293,   2.62880000E+02,      98,294,   2.68420000E+02,
     & 98,295,   2.75400000E+02,      98,296,   2.81010000E+02,
     & 98,297,   2.88050000E+02,      98,298,   2.93800000E+02,
     & 98,299,   3.00960000E+02,      98,300,   3.06980000E+02,
     & 98,301,   3.14310000E+02,      98,302,   3.20570000E+02,
     & 98,303,   3.28030000E+02,      98,304,   3.34510000E+02,
     & 98,305,   3.42260000E+02,      98,306,   3.48900000E+02,
     & 98,307,   3.56530000E+02,      98,308,   3.63220000E+02,
     & 98,309,   3.71240000E+02,      98,310,   3.78230000E+02/
      data (niz(i),nia(i),bie(i),i=7501,7520)/
     & 98,311,   3.86600000E+02,      98,312,   3.93730000E+02,
     & 98,313,   4.02070000E+02,      98,314,   4.09300000E+02,
     & 98,315,   4.17510000E+02,      98,316,   4.24930000E+02,
     & 98,317,   4.33280000E+02,      98,318,   4.40550000E+02,
     & 98,319,   4.49260000E+02,      98,320,   4.57040000E+02,
     & 98,321,   4.65910000E+02,      98,322,   4.73830000E+02,
     & 98,323,   4.82940000E+02,      98,324,   4.94220000E+02,
     & 98,325,   5.02690000E+02,      99,224,   7.55800000E+01,
     & 99,225,   7.28500000E+01,      99,226,   7.29300000E+01,
     & 99,227,   7.07500000E+01,      99,228,   7.18000000E+01/
      data (niz(i),nia(i),bie(i),i=7521,7540)/
     & 99,229,   6.90200000E+01,      99,230,   6.86000000E+01,
     & 99,231,   6.68800000E+01,      99,232,   6.67200000E+01,
     & 99,233,   6.52900000E+01,      99,234,   6.53400000E+01,
     & 99,235,   6.41300000E+01,      99,236,   6.44200000E+01,
     & 99,237,   6.34400000E+01,      99,238,   6.39600000E+01,
     & 99,239,   6.32200000E+01,      99,240,   6.41990000E+01,
     & 99,241,   6.39590000E+01,      99,242,   6.49240000E+01,
     & 99,243,   6.48610000E+01,      99,244,   6.61070000E+01,
     & 99,245,   6.64320000E+01,      99,246,   6.79660000E+01,
     & 99,247,   6.86040000E+01,      99,248,   7.02890000E+01/
      data (niz(i),nia(i),bie(i),i=7541,7560)/
     & 99,249,   7.11700000E+01,      99,250,   7.32660000E+01,
     & 99,251,   7.45042250E+01,      99,252,   7.72881390E+01,
     & 99,253,   7.90074220E+01,      99,254,   8.19863880E+01,
     & 99,255,   8.40825840E+01,      99,256,   8.71800000E+01,
     & 99,257,   8.94030000E+01,      99,258,   9.30900000E+01,
     & 99,259,   9.52800000E+01,      99,260,   9.86600000E+01,
     & 99,261,   1.01060000E+02,      99,262,   1.04910000E+02,
     & 99,263,   1.07910000E+02,      99,264,   1.12210000E+02,
     & 99,265,   1.15420000E+02,      99,266,   1.20200000E+02,
     & 99,267,   1.23250000E+02,      99,268,   1.27590000E+02/
      data (niz(i),nia(i),bie(i),i=7561,7580)/
     & 99,269,   1.31330000E+02,      99,270,   1.35810000E+02,
     & 99,271,   1.39390000E+02,      99,272,   1.43860000E+02,
     & 99,273,   1.47480000E+02,      99,274,   1.52150000E+02,
     & 99,275,   1.56150000E+02,      99,276,   1.60790000E+02,
     & 99,277,   1.64890000E+02,      99,278,   1.70290000E+02,
     & 99,279,   1.74610000E+02,      99,280,   1.79980000E+02,
     & 99,281,   1.84650000E+02,      99,282,   1.90310000E+02,
     & 99,283,   1.95330000E+02,      99,284,   2.01660000E+02,
     & 99,285,   2.06900000E+02,      99,286,   2.13500000E+02,
     & 99,287,   2.18220000E+02,      99,288,   2.24240000E+02/
      data (niz(i),nia(i),bie(i),i=7581,7600)/
     & 99,289,   2.29200000E+02,      99,290,   2.35380000E+02,
     & 99,291,   2.40540000E+02,      99,292,   2.46880000E+02,
     & 99,293,   2.52240000E+02,      99,294,   2.58760000E+02,
     & 99,295,   2.64270000E+02,      99,296,   2.70850000E+02,
     & 99,297,   2.76510000E+02,      99,298,   2.83170000E+02,
     & 99,299,   2.88950000E+02,      99,300,   2.95760000E+02,
     & 99,301,   3.01760000E+02,      99,302,   3.08790000E+02,
     & 99,303,   3.15040000E+02,      99,304,   3.22340000E+02,
     & 99,305,   3.28800000E+02,      99,306,   3.36310000E+02,
     & 99,307,   3.42880000E+02,      99,308,   3.50300000E+02/
      data (niz(i),nia(i),bie(i),i=7601,7620)/
     & 99,309,   3.57020000E+02,      99,310,   3.64700000E+02,
     & 99,311,   3.71680000E+02,      99,312,   3.79620000E+02,
     & 99,313,   3.86590000E+02,      99,314,   3.94770000E+02,
     & 99,315,   4.01950000E+02,      99,316,   4.09890000E+02,
     & 99,317,   4.17330000E+02,      99,318,   4.25410000E+02,
     & 99,319,   4.32670000E+02,      99,320,   4.41070000E+02,
     & 99,321,   4.48810000E+02,      99,322,   4.57440000E+02,
     & 99,323,   4.65340000E+02,      99,324,   4.74140000E+02,
     & 99,325,   4.82190000E+02,      99,326,   4.93920000E+02,
     & 99,327,   5.00950000E+02,      99,328,   5.09650000E+02/
      data (niz(i),nia(i),bie(i),i=7621,7640)/
     &100,222,   1.01240000E+02,     100,223,   9.83100000E+01,
     &100,224,   9.38600000E+01,     100,225,   9.08700000E+01,
     &100,226,   8.02000000E+01,     100,227,   8.02200000E+01,
     &100,228,   7.78900000E+01,     100,229,   7.87100000E+01,
     &100,230,   7.57500000E+01,     100,231,   7.52800000E+01,
     &100,232,   7.32000000E+01,     100,233,   7.29700000E+01,
     &100,234,   7.11800000E+01,     100,235,   7.13100000E+01,
     &100,236,   6.97200000E+01,     100,237,   7.00100000E+01,
     &100,238,   6.86400000E+01,     100,239,   6.91400000E+01,
     &100,240,   6.81000000E+01,     100,241,   6.88800000E+01/
      data (niz(i),nia(i),bie(i),i=7641,7660)/
     &100,242,   6.84000000E+01,     100,243,   6.94060000E+01,
     &100,244,   6.90020000E+01,     100,245,   7.02120000E+01,
     &100,246,   7.01243800E+01,     100,247,   7.15560000E+01,
     &100,248,   7.18968050E+01,     100,249,   7.36110000E+01,
     &100,250,   7.40675100E+01,     100,251,   7.59786630E+01,
     &100,252,   7.68110500E+01,     100,253,   7.93411630E+01,
     &100,254,   8.08981880E+01,     100,255,   8.37929640E+01,
     &100,256,   8.54799520E+01,     100,257,   8.85837940E+01,
     &100,258,   9.04190000E+01,     100,259,   9.36970000E+01,
     &100,260,   9.56100000E+01,     100,261,   9.89800000E+01/
      data (niz(i),nia(i),bie(i),i=7661,7680)/
     &100,262,   1.01000000E+02,     100,263,   1.04790000E+02,
     &100,264,   1.07450000E+02,     100,265,   1.11780000E+02,
     &100,266,   1.14640000E+02,     100,267,   1.19420000E+02,
     &100,268,   1.22180000E+02,     100,269,   1.26490000E+02,
     &100,270,   1.29890000E+02,     100,271,   1.34380000E+02,
     &100,272,   1.37620000E+02,     100,273,   1.42040000E+02,
     &100,274,   1.45330000E+02,     100,275,   1.50000000E+02,
     &100,276,   1.53690000E+02,     100,277,   1.58420000E+02,
     &100,278,   1.62190000E+02,     100,279,   1.67520000E+02,
     &100,280,   1.71520000E+02,     100,281,   1.76880000E+02/
      data (niz(i),nia(i),bie(i),i=7681,7700)/
     &100,282,   1.81290000E+02,     100,283,   1.86940000E+02,
     &100,284,   1.91630000E+02,     100,285,   1.98010000E+02,
     &100,286,   2.03510000E+02,     100,287,   2.09320000E+02,
     &100,288,   2.14130000E+02,     100,289,   2.20140000E+02,
     &100,290,   2.24760000E+02,     100,291,   2.30910000E+02,
     &100,292,   2.35780000E+02,     100,293,   2.42100000E+02,
     &100,294,   2.47140000E+02,     100,295,   2.53630000E+02,
     &100,296,   2.58840000E+02,     100,297,   2.65380000E+02,
     &100,298,   2.70740000E+02,     100,299,   2.77360000E+02,
     &100,300,   2.82740000E+02,     100,301,   2.89570000E+02/
      data (niz(i),nia(i),bie(i),i=7701,7720)/
     &100,302,   2.95290000E+02,     100,303,   3.02230000E+02,
     &100,304,   3.08190000E+02,     100,305,   3.15760000E+02,
     &100,306,   3.21720000E+02,     100,307,   3.29400000E+02,
     &100,308,   3.35710000E+02,     100,309,   3.43130000E+02,
     &100,310,   3.49570000E+02,     100,311,   3.57230000E+02,
     &100,312,   3.63860000E+02,     100,313,   3.71980000E+02,
     &100,314,   3.78430000E+02,     100,315,   3.86570000E+02,
     &100,316,   3.93380000E+02,     100,317,   4.01600000E+02,
     &100,318,   4.08410000E+02,     100,319,   4.16440000E+02,
     &100,320,   4.23400000E+02,     100,321,   4.31780000E+02/
      data (niz(i),nia(i),bie(i),i=7721,7740)/
     &100,322,   4.39240000E+02,     100,323,   4.47820000E+02,
     &100,324,   4.55430000E+02,     100,325,   4.64220000E+02,
     &100,326,   4.71960000E+02,     100,327,   4.83600000E+02,
     &100,328,   4.90350000E+02,     100,329,   4.99070000E+02,
     &100,330,   5.06730000E+02,     100,331,   5.15870000E+02,
     &101,229,   8.74300000E+01,     101,230,   8.79200000E+01,
     &101,231,   8.49100000E+01,     101,232,   8.40100000E+01,
     &101,233,   8.18700000E+01,     101,234,   8.12600000E+01,
     &101,235,   7.93800000E+01,     101,236,   7.91600000E+01,
     &101,237,   7.76000000E+01,     101,238,   7.75500000E+01/
      data (niz(i),nia(i),bie(i),i=7741,7760)/
     &101,239,   7.62600000E+01,     101,240,   7.63800000E+01,
     &101,241,   7.52200000E+01,     101,242,   7.56200000E+01,
     &101,243,   7.47700000E+01,     101,244,   7.54300000E+01,
     &101,245,   7.54670000E+01,     101,246,   7.63200000E+01,
     &101,247,   7.62000000E+01,     101,248,   7.72290000E+01,
     &101,249,   7.73160000E+01,     101,250,   7.87000000E+01,
     &101,251,   7.91010000E+01,     101,252,   8.06950000E+01,
     &101,253,   8.13010000E+01,     101,254,   8.35780000E+01,
     &101,255,   8.48359860E+01,     101,256,   8.76095660E+01,
     &101,257,   8.89899330E+01,     101,258,   9.16825820E+01/
      data (niz(i),nia(i),bie(i),i=7761,7780)/
     &101,259,   9.36170000E+01,     101,260,   9.65450000E+01,
     &101,261,   9.82300000E+01,     101,262,   1.01230000E+02,
     &101,263,   1.03210000E+02,     101,264,   1.06650000E+02,
     &101,265,   1.09300000E+02,     101,266,   1.13300000E+02,
     &101,267,   1.16150000E+02,     101,268,   1.20350000E+02,
     &101,269,   1.23510000E+02,     101,270,   1.27510000E+02,
     &101,271,   1.30570000E+02,     101,272,   1.35120000E+02,
     &101,273,   1.38150000E+02,     101,274,   1.42440000E+02,
     &101,275,   1.45710000E+02,     101,276,   1.50070000E+02,
     &101,277,   1.53740000E+02,     101,278,   1.58260000E+02/
      data (niz(i),nia(i),bie(i),i=7781,7800)/
     &101,279,   1.62010000E+02,     101,280,   1.67060000E+02,
     &101,281,   1.71050000E+02,     101,282,   1.76130000E+02,
     &101,283,   1.80530000E+02,     101,284,   1.85860000E+02,
     &101,285,   1.90500000E+02,     101,286,   1.97200000E+02,
     &101,287,   2.01380000E+02,     101,288,   2.07420000E+02,
     &101,289,   2.12220000E+02,     101,290,   2.17920000E+02,
     &101,291,   2.22510000E+02,     101,292,   2.28350000E+02,
     &101,293,   2.33190000E+02,     101,294,   2.39210000E+02,
     &101,295,   2.44230000E+02,     101,296,   2.50410000E+02,
     &101,297,   2.55610000E+02,     101,298,   2.61850000E+02/
      data (niz(i),nia(i),bie(i),i=7801,7820)/
     &101,299,   2.67120000E+02,     101,300,   2.73450000E+02,
     &101,301,   2.78830000E+02,     101,302,   2.85330000E+02,
     &101,303,   2.91000000E+02,     101,304,   2.97750000E+02,
     &101,305,   3.03720000E+02,     101,306,   3.10980000E+02,
     &101,307,   3.17030000E+02,     101,308,   3.24220000E+02,
     &101,309,   3.30560000E+02,     101,310,   3.37890000E+02,
     &101,311,   3.44310000E+02,     101,312,   3.51660000E+02,
     &101,313,   3.58430000E+02,     101,314,   3.65890000E+02,
     &101,315,   3.72470000E+02,     101,316,   3.80200000E+02,
     &101,317,   3.87000000E+02,     101,318,   3.94600000E+02/
      data (niz(i),nia(i),bie(i),i=7821,7840)/
     &101,319,   4.01710000E+02,     101,320,   4.09420000E+02,
     &101,321,   4.16430000E+02,     101,322,   4.24470000E+02,
     &101,323,   4.31850000E+02,     101,324,   4.40170000E+02,
     &101,325,   4.47750000E+02,     101,326,   4.56290000E+02,
     &101,327,   4.64030000E+02,     101,328,   4.75540000E+02,
     &101,329,   4.82300000E+02,     101,330,   4.90730000E+02,
     &101,331,   4.98430000E+02,     101,332,   5.07280000E+02,
     &101,333,   5.15090000E+02,     101,334,   5.23880000E+02,
     &102,228,   1.07660000E+02,     102,229,   1.06050000E+02,
     &102,230,   1.02690000E+02,     102,231,   1.01020000E+02/
      data (niz(i),nia(i),bie(i),i=7841,7860)/
     &102,232,   9.30300000E+01,     102,233,   9.16300000E+01,
     &102,234,   8.91200000E+01,     102,235,   8.84700000E+01,
     &102,236,   8.62200000E+01,     102,237,   8.58900000E+01,
     &102,238,   8.39800000E+01,     102,239,   8.40300000E+01,
     &102,240,   8.22900000E+01,     102,241,   8.24300000E+01,
     &102,242,   8.09800000E+01,     102,243,   8.13700000E+01,
     &102,244,   8.01300000E+01,     102,245,   8.07600000E+01,
     &102,246,   7.99500000E+01,     102,247,   8.08600000E+01,
     &102,248,   8.00800000E+01,     102,249,   8.18070000E+01,
     &102,250,   8.14990000E+01,     102,251,   8.28660000E+01/
      data (niz(i),nia(i),bie(i),i=7861,7880)/
     &102,252,   8.28711980E+01,     102,253,   8.44390000E+01,
     &102,254,   8.47181980E+01,     102,255,   8.68454540E+01,
     &102,256,   8.78174020E+01,     102,257,   9.02177680E+01,
     &102,258,   9.14730000E+01,     102,259,   9.41030000E+01,
     &102,260,   9.56050000E+01,     102,261,   9.84990000E+01,
     &102,262,   1.00154000E+02,     102,263,   1.02450000E+02,
     &102,264,   1.04040000E+02,     102,265,   1.07450000E+02,
     &102,266,   1.09740000E+02,     102,267,   1.13740000E+02,
     &102,268,   1.16210000E+02,     102,269,   1.20350000E+02,
     &102,270,   1.23200000E+02,     102,271,   1.27180000E+02/
      data (niz(i),nia(i),bie(i),i=7881,7900)/
     &102,272,   1.29920000E+02,     102,273,   1.34410000E+02,
     &102,274,   1.37140000E+02,     102,275,   1.41390000E+02,
     &102,276,   1.44330000E+02,     102,277,   1.48660000E+02,
     &102,278,   1.52010000E+02,     102,279,   1.56660000E+02,
     &102,280,   1.60090000E+02,     102,281,   1.65020000E+02,
     &102,282,   1.68690000E+02,     102,283,   1.73810000E+02,
     &102,284,   1.77830000E+02,     102,285,   1.83220000E+02,
     &102,286,   1.87620000E+02,     102,287,   1.93550000E+02,
     &102,288,   1.98160000E+02,     102,289,   2.04220000E+02,
     &102,290,   2.10660000E+02,     102,291,   2.14690000E+02/
      data (niz(i),nia(i),bie(i),i=7901,7920)/
     &102,292,   2.18980000E+02,     102,293,   2.24810000E+02,
     &102,294,   2.29320000E+02,     102,295,   2.35320000E+02,
     &102,296,   2.40050000E+02,     102,297,   2.46220000E+02,
     &102,298,   2.51080000E+02,     102,299,   2.57290000E+02,
     &102,300,   2.62260000E+02,     102,301,   2.68560000E+02,
     &102,302,   2.73640000E+02,     102,303,   2.80110000E+02,
     &102,304,   2.85500000E+02,     102,305,   2.92280000E+02,
     &102,306,   2.97950000E+02,     102,307,   3.05180000E+02,
     &102,308,   3.11220000E+02,     102,309,   3.18430000E+02,
     &102,310,   3.24490000E+02,     102,311,   3.31830000E+02/
      data (niz(i),nia(i),bie(i),i=7921,7940)/
     &102,312,   3.37970000E+02,     102,313,   3.45360000E+02,
     &102,314,   3.51550000E+02,     102,315,   3.58990000E+02,
     &102,316,   3.65250000E+02,     102,317,   3.72930000E+02,
     &102,318,   3.79380000E+02,     102,319,   3.86990000E+02,
     &102,320,   3.93470000E+02,     102,321,   4.01440000E+02,
     &102,322,   4.07850000E+02,     102,323,   4.16100000E+02,
     &102,324,   4.23040000E+02,     102,325,   4.31380000E+02,
     &102,326,   4.38700000E+02,     102,327,   4.47150000E+02,
     &102,328,   4.54590000E+02,     102,329,   4.65940000E+02,
     &102,330,   4.72460000E+02,     102,331,   4.80940000E+02/
      data (niz(i),nia(i),bie(i),i=7941,7960)/
     &102,332,   4.88310000E+02,     102,333,   4.97200000E+02,
     &102,334,   5.04800000E+02,     102,335,   5.13560000E+02,
     &102,336,   5.21310000E+02,     102,337,   5.30110000E+02,
     &102,338,   5.37990000E+02,     103,235,   9.85700000E+01,
     &103,236,   9.75400000E+01,     103,237,   9.52400000E+01,
     &103,238,   9.45400000E+01,     103,239,   9.25500000E+01,
     &103,240,   9.21300000E+01,     103,241,   9.04800000E+01,
     &103,242,   9.03300000E+01,     103,243,   8.88700000E+01,
     &103,244,   8.88600000E+01,     103,245,   8.76200000E+01,
     &103,246,   8.78900000E+01,     103,247,   8.70100000E+01/
      data (niz(i),nia(i),bie(i),i=7961,7980)/
     &103,248,   8.75500000E+01,     103,249,   8.67400000E+01,
     &103,250,   8.74600000E+01,     103,251,   8.78960000E+01,
     &103,252,   8.87990000E+01,     103,253,   8.87320000E+01,
     &103,254,   8.99710000E+01,     103,255,   9.01400000E+01,
     &103,256,   9.19970000E+01,     103,257,   9.27820000E+01,
     &103,258,   9.49030000E+01,     103,259,   9.59350000E+01,
     &103,260,   9.83400000E+01,     103,261,   9.96150000E+01,
     &103,262,   1.02177000E+02,     103,263,   1.03762000E+02,
     &103,264,   1.05510000E+02,     103,265,   1.07040000E+02,
     &103,266,   1.10050000E+02,     103,267,   1.12320000E+02/
      data (niz(i),nia(i),bie(i),i=7981,8000)/
     &103,268,   1.15990000E+02,     103,269,   1.18500000E+02,
     &103,270,   1.22390000E+02,     103,271,   1.25240000E+02,
     &103,272,   1.28860000E+02,     103,273,   1.31540000E+02,
     &103,274,   1.35620000E+02,     103,275,   1.38380000E+02,
     &103,276,   1.42500000E+02,     103,277,   1.45430000E+02,
     &103,278,   1.49450000E+02,     103,279,   1.52790000E+02,
     &103,280,   1.57220000E+02,     103,281,   1.60620000E+02,
     &103,282,   1.65250000E+02,     103,283,   1.68920000E+02,
     &103,284,   1.73730000E+02,     103,285,   1.77760000E+02,
     &103,286,   1.82840000E+02,     103,287,   1.87130000E+02/
      data (niz(i),nia(i),bie(i),i=8001,8020)/
     &103,288,   1.92730000E+02,     103,289,   1.97310000E+02,
     &103,290,   2.04670000E+02,     103,291,   2.09630000E+02,
     &103,292,   2.13350000E+02,     103,293,   2.17600000E+02,
     &103,294,   2.23110000E+02,     103,295,   2.27620000E+02,
     &103,296,   2.33330000E+02,     103,297,   2.38050000E+02,
     &103,298,   2.43850000E+02,     103,299,   2.48690000E+02,
     &103,300,   2.54660000E+02,     103,301,   2.59500000E+02,
     &103,302,   2.65550000E+02,     103,303,   2.70530000E+02,
     &103,304,   2.76710000E+02,     103,305,   2.82000000E+02,
     &103,306,   2.88490000E+02,     103,307,   2.94230000E+02/
      data (niz(i),nia(i),bie(i),i=8021,8040)/
     &103,308,   3.01140000E+02,     103,309,   3.07030000E+02,
     &103,310,   3.14000000E+02,     103,311,   3.19990000E+02,
     &103,312,   3.27110000E+02,     103,313,   3.33160000E+02,
     &103,314,   3.40360000E+02,     103,315,   3.46620000E+02,
     &103,316,   3.53820000E+02,     103,317,   3.60040000E+02,
     &103,318,   3.67420000E+02,     103,319,   3.73820000E+02,
     &103,320,   3.81120000E+02,     103,321,   3.87580000E+02,
     &103,322,   3.94990000E+02,     103,323,   4.01680000E+02,
     &103,324,   4.09410000E+02,     103,325,   4.16540000E+02,
     &103,326,   4.24530000E+02,     103,327,   4.31850000E+02/
      data (niz(i),nia(i),bie(i),i=8041,8060)/
     &103,328,   4.40010000E+02,     103,329,   4.47450000E+02,
     &103,330,   4.58620000E+02,     103,331,   4.65160000E+02,
     &103,332,   4.73350000E+02,     103,333,   4.80740000E+02,
     &103,334,   4.89330000E+02,     103,335,   4.96950000E+02,
     &103,336,   5.05500000E+02,     103,337,   5.13130000E+02,
     &103,338,   5.21700000E+02,     103,339,   5.29590000E+02,
     &104,233,   1.21010000E+02,     104,234,   1.17320000E+02,
     &104,235,   1.15620000E+02,     104,236,   1.12070000E+02,
     &104,237,   1.10360000E+02,     104,238,   1.02930000E+02,
     &104,239,   1.02090000E+02,     104,240,   9.98500000E+01/
      data (niz(i),nia(i),bie(i),i=8061,8080)/
     &104,241,   9.94100000E+01,     104,242,   9.74700000E+01,
     &104,243,   9.73200000E+01,     104,244,   9.54600000E+01,
     &104,245,   9.54500000E+01,     104,246,   9.38300000E+01,
     &104,247,   9.40900000E+01,     104,248,   9.28100000E+01,
     &104,249,   9.33100000E+01,     104,250,   9.21200000E+01,
     &104,251,   9.28100000E+01,     104,252,   9.20500000E+01,
     &104,253,   9.37820000E+01,     104,254,   9.33040000E+01,
     &104,255,   9.45390000E+01,     104,256,   9.42481510E+01,
     &104,257,   9.60110000E+01,     104,258,   9.64730000E+01,
     &104,259,   9.83920000E+01,     104,260,   9.91420000E+01/
      data (niz(i),nia(i),bie(i),i=8081,8100)/
     &104,261,   1.01302000E+02,     104,262,   1.02388000E+02,
     &104,263,   1.04830000E+02,     104,264,   1.06170000E+02,
     &104,265,   1.07590000E+02,     104,266,   1.08680000E+02,
     &104,267,   1.11710000E+02,     104,268,   1.13620000E+02,
     &104,269,   1.17260000E+02,     104,270,   1.19450000E+02,
     &104,271,   1.23330000E+02,     104,272,   1.25860000E+02,
     &104,273,   1.29440000E+02,     104,274,   1.31810000E+02,
     &104,275,   1.35980000E+02,     104,276,   1.38330000E+02,
     &104,277,   1.42210000E+02,     104,278,   1.44780000E+02,
     &104,279,   1.48810000E+02,     104,280,   1.51810000E+02/
      data (niz(i),nia(i),bie(i),i=8101,8120)/
     &104,281,   1.56350000E+02,     104,282,   1.59410000E+02,
     &104,283,   1.63960000E+02,     104,284,   1.67400000E+02,
     &104,285,   1.72140000E+02,     104,286,   1.75800000E+02,
     &104,287,   1.80880000E+02,     104,288,   1.84930000E+02,
     &104,289,   1.90590000E+02,     104,290,   1.95490000E+02,
     &104,291,   2.02050000E+02,     104,292,   2.05130000E+02,
     &104,293,   2.11010000E+02,     104,294,   2.14920000E+02,
     &104,295,   2.20410000E+02,     104,296,   2.24610000E+02,
     &104,297,   2.30300000E+02,     104,298,   2.34650000E+02,
     &104,299,   2.40490000E+02,     104,300,   2.45010000E+02/
      data (niz(i),nia(i),bie(i),i=8121,8140)/
     &104,301,   2.50860000E+02,     104,302,   2.55490000E+02,
     &104,303,   2.61480000E+02,     104,304,   2.66140000E+02,
     &104,305,   2.72340000E+02,     104,306,   2.77330000E+02,
     &104,307,   2.83850000E+02,     104,308,   2.89290000E+02,
     &104,309,   2.96060000E+02,     104,310,   3.01660000E+02,
     &104,311,   3.08620000E+02,     104,312,   3.14350000E+02,
     &104,313,   3.21370000E+02,     104,314,   3.27180000E+02,
     &104,315,   3.34300000E+02,     104,316,   3.40260000E+02,
     &104,317,   3.47390000E+02,     104,318,   3.53530000E+02,
     &104,319,   3.60740000E+02,     104,320,   3.66960000E+02/
      data (niz(i),nia(i),bie(i),i=8141,8160)/
     &104,321,   3.74250000E+02,     104,322,   3.80420000E+02,
     &104,323,   3.87810000E+02,     104,324,   3.94190000E+02,
     &104,325,   4.01910000E+02,     104,326,   4.08720000E+02,
     &104,327,   4.16740000E+02,     104,328,   4.23760000E+02,
     &104,329,   4.31920000E+02,     104,330,   4.38980000E+02,
     &104,331,   4.49820000E+02,     104,332,   4.56050000E+02,
     &104,333,   4.64270000E+02,     104,334,   4.71410000E+02,
     &104,335,   4.80010000E+02,     104,336,   4.87400000E+02,
     &104,337,   4.95910000E+02,     104,338,   5.03400000E+02,
     &104,339,   5.11990000E+02,     105,241,   1.09270000E+02/
      data (niz(i),nia(i),bie(i),i=8161,8180)/
     &105,242,   1.08410000E+02,     105,243,   1.06450000E+02,
     &105,244,   1.05950000E+02,     105,245,   1.04080000E+02,
     &105,246,   1.03700000E+02,     105,247,   1.02060000E+02,
     &105,248,   1.01910000E+02,     105,249,   1.00600000E+02,
     &105,250,   1.00720000E+02,     105,251,   9.95000000E+01,
     &105,252,   9.98000000E+01,     105,253,   9.89400000E+01,
     &105,254,   9.95400000E+01,     105,255,   1.00041000E+02,
     &105,256,   1.00704000E+02,     105,257,   1.00469000E+02,
     &105,258,   1.01941000E+02,     105,259,   1.02205000E+02,
     &105,260,   1.03794000E+02,     105,261,   1.04426000E+02/
      data (niz(i),nia(i),bie(i),i=8181,8200)/
     &105,262,   1.06333000E+02,     105,263,   1.07194000E+02,
     &105,264,   1.09425000E+02,     105,265,   1.10530000E+02,
     &105,266,   1.11420000E+02,     105,267,   1.12420000E+02,
     &105,268,   1.15120000E+02,     105,269,   1.17040000E+02,
     &105,270,   1.20320000E+02,     105,271,   1.22530000E+02,
     &105,272,   1.26050000E+02,     105,273,   1.28680000E+02,
     &105,274,   1.31940000E+02,     105,275,   1.34260000E+02,
     &105,276,   1.37950000E+02,     105,277,   1.40460000E+02,
     &105,278,   1.44030000E+02,     105,279,   1.46570000E+02,
     &105,280,   1.50270000E+02,     105,281,   1.53260000E+02/
      data (niz(i),nia(i),bie(i),i=8201,8220)/
     &105,282,   1.57620000E+02,     105,283,   1.60680000E+02,
     &105,284,   1.64880000E+02,     105,285,   1.68170000E+02,
     &105,286,   1.72800000E+02,     105,287,   1.76460000E+02,
     &105,288,   1.81210000E+02,     105,289,   1.85230000E+02,
     &105,290,   1.91280000E+02,     105,291,   1.95510000E+02,
     &105,292,   2.00210000E+02,     105,293,   2.04690000E+02,
     &105,294,   2.10480000E+02,     105,295,   2.14370000E+02,
     &105,296,   2.19550000E+02,     105,297,   2.23720000E+02,
     &105,298,   2.29080000E+02,     105,299,   2.33430000E+02,
     &105,300,   2.38940000E+02,     105,301,   2.43410000E+02/
      data (niz(i),nia(i),bie(i),i=8221,8240)/
     &105,302,   2.48970000E+02,     105,303,   2.53530000E+02,
     &105,304,   2.59250000E+02,     105,305,   2.63910000E+02,
     &105,306,   2.69770000E+02,     105,307,   2.74820000E+02,
     &105,308,   2.81070000E+02,     105,309,   2.86380000E+02,
     &105,310,   2.92850000E+02,     105,311,   2.98470000E+02,
     &105,312,   3.05100000E+02,     105,313,   3.10760000E+02,
     &105,314,   3.17450000E+02,     105,315,   3.23200000E+02,
     &105,316,   3.29930000E+02,     105,317,   3.35910000E+02,
     &105,318,   3.42770000E+02,     105,319,   3.48710000E+02,
     &105,320,   3.55710000E+02,     105,321,   3.61770000E+02/
      data (niz(i),nia(i),bie(i),i=8241,8260)/
     &105,322,   3.68890000E+02,     105,323,   3.75300000E+02,
     &105,324,   3.82420000E+02,     105,325,   3.88770000E+02,
     &105,326,   3.96200000E+02,     105,327,   4.02980000E+02,
     &105,328,   4.10770000E+02,     105,329,   4.17670000E+02,
     &105,330,   4.25540000E+02,     105,331,   4.32660000E+02,
     &105,332,   4.43150000E+02,     105,333,   4.49460000E+02,
     &105,334,   4.57400000E+02,     105,335,   4.64560000E+02,
     &105,336,   4.72890000E+02,     105,337,   4.80300000E+02,
     &105,338,   4.88520000E+02,     105,339,   4.96020000E+02,
     &106,240,   1.27000000E+02,     106,241,   1.25160000E+02/
      data (niz(i),nia(i),bie(i),i=8261,8280)/
     &106,242,   1.21990000E+02,     106,243,   1.20430000E+02,
     &106,244,   1.13980000E+02,     106,245,   1.13660000E+02,
     &106,246,   1.11440000E+02,     106,247,   1.11010000E+02,
     &106,248,   1.09020000E+02,     106,249,   1.08870000E+02,
     &106,250,   1.07160000E+02,     106,251,   1.07260000E+02,
     &106,252,   1.05640000E+02,     106,253,   1.05890000E+02,
     &106,254,   1.04660000E+02,     106,255,   1.05120000E+02,
     &106,256,   1.04000000E+02,     106,257,   1.04790000E+02,
     &106,258,   1.05399000E+02,     106,259,   1.06798000E+02,
     &106,260,   1.06595916E+02,     106,261,   1.08238000E+02/
      data (niz(i),nia(i),bie(i),i=8281,8300)/
     &106,262,   1.08498000E+02,     106,263,   1.10208000E+02,
     &106,264,   1.10777000E+02,     106,265,   1.12772000E+02,
     &106,266,   1.13575000E+02,     106,267,   1.14350000E+02,
     &106,268,   1.15090000E+02,     106,269,   1.17740000E+02,
     &106,270,   1.19260000E+02,     106,271,   1.22540000E+02,
     &106,272,   1.24430000E+02,     106,273,   1.27950000E+02,
     &106,274,   1.30190000E+02,     106,275,   1.33430000E+02,
     &106,276,   1.35480000E+02,     106,277,   1.39300000E+02,
     &106,278,   1.41240000E+02,     106,279,   1.44620000E+02,
     &106,280,   1.46790000E+02,     106,281,   1.50420000E+02/
      data (niz(i),nia(i),bie(i),i=8301,8320)/
     &106,282,   1.53100000E+02,     106,283,   1.57460000E+02,
     &106,284,   1.60100000E+02,     106,285,   1.64270000E+02,
     &106,286,   1.67380000E+02,     106,287,   1.71800000E+02,
     &106,288,   1.75160000E+02,     106,289,   1.79890000E+02,
     &106,290,   1.83680000E+02,     106,291,   1.89660000E+02,
     &106,292,   1.93130000E+02,     106,293,   1.98590000E+02,
     &106,294,   2.02810000E+02,     106,295,   2.08300000E+02,
     &106,296,   2.12560000E+02,     106,297,   2.17780000E+02,
     &106,298,   2.21590000E+02,     106,299,   2.26940000E+02,
     &106,300,   2.30980000E+02,     106,301,   2.36450000E+02/
      data (niz(i),nia(i),bie(i),i=8321,8340)/
     &106,302,   2.40590000E+02,     106,303,   2.46150000E+02,
     &106,304,   2.50390000E+02,     106,305,   2.56050000E+02,
     &106,306,   2.60400000E+02,     106,307,   2.66300000E+02,
     &106,308,   2.70960000E+02,     106,309,   2.77220000E+02,
     &106,310,   2.82210000E+02,     106,311,   2.88700000E+02,
     &106,312,   2.93960000E+02,     106,313,   3.00550000E+02,
     &106,314,   3.05910000E+02,     106,315,   3.12520000E+02,
     &106,316,   3.17940000E+02,     106,317,   3.24670000E+02,
     &106,318,   3.30170000E+02,     106,319,   3.37080000E+02,
     &106,320,   3.42900000E+02,     106,321,   3.50050000E+02/
      data (niz(i),nia(i),bie(i),i=8341,8360)/
     &106,322,   3.55940000E+02,     106,323,   3.63310000E+02,
     &106,324,   3.68970000E+02,     106,325,   3.76010000E+02,
     &106,326,   3.82210000E+02,     106,327,   3.89640000E+02,
     &106,328,   3.96260000E+02,     106,329,   4.03860000E+02,
     &106,330,   4.10530000E+02,     106,331,   4.18390000E+02,
     &106,332,   4.27960000E+02,     106,333,   4.35120000E+02,
     &106,334,   4.41050000E+02,     106,335,   4.49060000E+02,
     &106,336,   4.55950000E+02,     106,337,   4.64210000E+02,
     &106,338,   4.71510000E+02,     106,339,   4.79820000E+02,
     &107,247,   1.20610000E+02,     107,248,   1.20060000E+02/
      data (niz(i),nia(i),bie(i),i=8361,8380)/
     &107,249,   1.18010000E+02,     107,250,   1.17500000E+02,
     &107,251,   1.15610000E+02,     107,252,   1.15320000E+02,
     &107,253,   1.13790000E+02,     107,254,   1.13690000E+02,
     &107,255,   1.12340000E+02,     107,256,   1.12510000E+02,
     &107,257,   1.11380000E+02,     107,258,   1.11770000E+02,
     &107,259,   1.11130000E+02,     107,260,   1.13459000E+02,
     &107,261,   1.13456000E+02,     107,262,   1.14582000E+02,
     &107,263,   1.14710000E+02,     107,264,   1.16186000E+02,
     &107,265,   1.16621000E+02,     107,266,   1.18308000E+02,
     &107,267,   1.18989000E+02,     107,268,   1.19040000E+02/
      data (niz(i),nia(i),bie(i),i=8381,8400)/
     &107,269,   1.19710000E+02,     107,270,   1.22030000E+02,
     &107,271,   1.23500000E+02,     107,272,   1.26430000E+02,
     &107,273,   1.28300000E+02,     107,274,   1.31450000E+02,
     &107,275,   1.33760000E+02,     107,276,   1.36680000E+02,
     &107,277,   1.38630000E+02,     107,278,   1.42200000E+02,
     &107,279,   1.44120000E+02,     107,280,   1.47170000E+02,
     &107,281,   1.49340000E+02,     107,282,   1.52630000E+02,
     &107,283,   1.55310000E+02,     107,284,   1.59150000E+02,
     &107,285,   1.62040000E+02,     107,286,   1.65850000E+02,
     &107,287,   1.68970000E+02,     107,288,   1.73060000E+02/
      data (niz(i),nia(i),bie(i),i=8401,8420)/
     &107,289,   1.76390000E+02,     107,290,   1.80820000E+02,
     &107,291,   1.84590000E+02,     107,292,   1.89790000E+02,
     &107,293,   1.93760000E+02,     107,294,   1.98930000E+02,
     &107,295,   2.03150000E+02,     107,296,   2.08350000E+02,
     &107,297,   2.12920000E+02,     107,298,   2.17760000E+02,
     &107,299,   2.21580000E+02,     107,300,   2.26610000E+02,
     &107,301,   2.30660000E+02,     107,302,   2.35800000E+02,
     &107,303,   2.39940000E+02,     107,304,   2.45180000E+02,
     &107,305,   2.49380000E+02,     107,306,   2.54750000E+02,
     &107,307,   2.59110000E+02,     107,308,   2.64670000E+02/
      data (niz(i),nia(i),bie(i),i=8421,8440)/
     &107,309,   2.69340000E+02,     107,310,   2.75310000E+02,
     &107,311,   2.80290000E+02,     107,312,   2.86450000E+02,
     &107,313,   2.91700000E+02,     107,314,   2.97950000E+02,
     &107,315,   3.03270000E+02,     107,316,   3.09560000E+02,
     &107,317,   3.14950000E+02,     107,318,   3.21300000E+02,
     &107,319,   3.26840000E+02,     107,320,   3.33450000E+02,
     &107,321,   3.39300000E+02,     107,322,   3.46240000E+02,
     &107,323,   3.52130000E+02,     107,324,   3.59210000E+02,
     &107,325,   3.65160000E+02,     107,326,   3.71710000E+02,
     &107,327,   3.77880000E+02,     107,328,   3.84990000E+02/
      data (niz(i),nia(i),bie(i),i=8441,8460)/
     &107,329,   3.91530000E+02,     107,330,   3.98870000E+02,
     &107,331,   4.05460000E+02,     107,332,   4.12990000E+02,
     &107,333,   4.22260000E+02,     107,334,   4.29140000E+02,
     &107,335,   4.35050000E+02,     107,336,   4.42800000E+02,
     &107,337,   4.49710000E+02,     107,338,   4.57710000E+02,
     &107,339,   4.65090000E+02,     108,240,   1.54570000E+02,
     &108,241,   1.51910000E+02,     108,242,   1.47920000E+02,
     &108,243,   1.45660000E+02,     108,244,   1.41980000E+02,
     &108,245,   1.39940000E+02,     108,246,   1.36570000E+02,
     &108,247,   1.34880000E+02,     108,248,   1.31910000E+02/
      data (niz(i),nia(i),bie(i),i=8461,8480)/
     &108,249,   1.30500000E+02,     108,250,   1.25820000E+02,
     &108,251,   1.25310000E+02,     108,252,   1.23160000E+02,
     &108,253,   1.22850000E+02,     108,254,   1.20830000E+02,
     &108,255,   1.20710000E+02,     108,256,   1.19030000E+02,
     &108,257,   1.19170000E+02,     108,258,   1.17670000E+02,
     &108,259,   1.18050000E+02,     108,260,   1.17070000E+02,
     &108,261,   1.18050000E+02,     108,262,   1.17570000E+02,
     &108,263,   1.19893000E+02,     108,264,   1.19611504E+02,
     &108,265,   1.21096000E+02,     108,266,   1.21133000E+02,
     &108,267,   1.22746000E+02,     108,268,   1.23102000E+02/
      data (niz(i),nia(i),bie(i),i=8481,8500)/
     &108,269,   1.24927000E+02,     108,270,   1.23360000E+02,
     &108,271,   1.25600000E+02,     108,272,   1.26720000E+02,
     &108,273,   1.29590000E+02,     108,274,   1.31150000E+02,
     &108,275,   1.34360000E+02,     108,276,   1.36180000E+02,
     &108,277,   1.39120000E+02,     108,278,   1.41140000E+02,
     &108,279,   1.43950000E+02,     108,280,   1.45470000E+02,
     &108,281,   1.48470000E+02,     108,282,   1.50340000E+02,
     &108,283,   1.53610000E+02,     108,284,   1.55900000E+02,
     &108,285,   1.59680000E+02,     108,286,   1.62270000E+02,
     &108,287,   1.65990000E+02,     108,288,   1.68740000E+02/
      data (niz(i),nia(i),bie(i),i=8501,8520)/
     &108,289,   1.72790000E+02,     108,290,   1.75890000E+02,
     &108,291,   1.80320000E+02,     108,292,   1.83790000E+02,
     &108,293,   1.89200000E+02,     108,294,   1.92910000E+02,
     &108,295,   1.98180000E+02,     108,296,   2.02130000E+02,
     &108,297,   2.07410000E+02,     108,298,   2.12970000E+02,
     &108,299,   2.16760000E+02,     108,300,   2.20320000E+02,
     &108,301,   2.25360000E+02,     108,302,   2.29040000E+02,
     &108,303,   2.34180000E+02,     108,304,   2.38010000E+02,
     &108,305,   2.43250000E+02,     108,306,   2.47170000E+02,
     &108,307,   2.52530000E+02,     108,308,   2.56610000E+02/
      data (niz(i),nia(i),bie(i),i=8521,8540)/
     &108,309,   2.62170000E+02,     108,310,   2.66550000E+02,
     &108,311,   2.72510000E+02,     108,312,   2.77200000E+02,
     &108,313,   2.83350000E+02,     108,314,   2.88300000E+02,
     &108,315,   2.94540000E+02,     108,316,   2.99560000E+02,
     &108,317,   3.05830000E+02,     108,318,   3.10900000E+02,
     &108,319,   3.17260000E+02,     108,320,   3.22510000E+02,
     &108,321,   3.29090000E+02,     108,322,   3.34680000E+02,
     &108,323,   3.41610000E+02,     108,324,   3.47460000E+02,
     &108,325,   3.54320000E+02,     108,326,   3.60050000E+02,
     &108,327,   3.66550000E+02,     108,328,   3.75460000E+02/
      data (niz(i),nia(i),bie(i),i=8541,8560)/
     &108,329,   3.82710000E+02,     108,330,   3.88520000E+02,
     &108,331,   3.95620000E+02,     108,332,   3.99430000E+02,
     &108,333,   4.09430000E+02,     108,334,   4.14970000E+02,
     &108,335,   4.21830000E+02,     108,336,   4.27460000E+02,
     &108,337,   4.35210000E+02,     108,338,   4.41880000E+02,
     &108,339,   4.49890000E+02,     109,253,   1.32660000E+02,
     &109,254,   1.31990000E+02,     109,255,   1.30050000E+02,
     &109,256,   1.29610000E+02,     109,257,   1.27750000E+02,
     &109,258,   1.27550000E+02,     109,259,   1.26010000E+02,
     &109,260,   1.26040000E+02,     109,261,   1.25020000E+02/
      data (niz(i),nia(i),bie(i),i=8561,8580)/
     &109,262,   1.25820000E+02,     109,263,   1.25230000E+02,
     &109,264,   1.26030000E+02,     109,265,   1.27211000E+02,
     &109,266,   1.28490000E+02,     109,267,   1.28105000E+02,
     &109,268,   1.29306000E+02,     109,269,   1.29576000E+02,
     &109,270,   1.31083000E+02,     109,271,   1.31554000E+02,
     &109,272,   1.30890000E+02,     109,273,   1.31960000E+02,
     &109,274,   1.34510000E+02,     109,275,   1.35990000E+02,
     &109,276,   1.38780000E+02,     109,277,   1.40570000E+02,
     &109,278,   1.43250000E+02,     109,279,   1.45120000E+02,
     &109,280,   1.47550000E+02,     109,281,   1.49140000E+02/
      data (niz(i),nia(i),bie(i),i=8581,8600)/
     &109,282,   1.51850000E+02,     109,283,   1.53630000E+02,
     &109,284,   1.56600000E+02,     109,285,   1.58940000E+02,
     &109,286,   1.62420000E+02,     109,287,   1.64850000E+02,
     &109,288,   1.68180000E+02,     109,289,   1.70950000E+02,
     &109,290,   1.74680000E+02,     109,291,   1.77760000E+02,
     &109,292,   1.81880000E+02,     109,293,   1.85340000E+02,
     &109,294,   1.90490000E+02,     109,295,   1.94190000E+02,
     &109,296,   1.99240000E+02,     109,297,   2.03210000E+02,
     &109,298,   2.09470000E+02,     109,299,   2.12270000E+02,
     &109,300,   2.17330000E+02,     109,301,   2.21100000E+02/
      data (niz(i),nia(i),bie(i),i=8601,8620)/
     &109,302,   2.25840000E+02,     109,303,   2.29520000E+02,
     &109,304,   2.34360000E+02,     109,305,   2.38200000E+02,
     &109,306,   2.43170000E+02,     109,307,   2.47080000E+02,
     &109,308,   2.52150000E+02,     109,309,   2.56280000E+02,
     &109,310,   2.61450000E+02,     109,311,   2.65950000E+02,
     &109,312,   2.71610000E+02,     109,313,   2.76300000E+02,
     &109,314,   2.82130000E+02,     109,315,   2.87050000E+02,
     &109,316,   2.92970000E+02,     109,317,   2.97970000E+02,
     &109,318,   3.03910000E+02,     109,319,   3.08970000E+02,
     &109,320,   3.15030000E+02,     109,321,   3.20270000E+02/
      data (niz(i),nia(i),bie(i),i=8621,8640)/
     &109,322,   3.26590000E+02,     109,323,   3.32190000E+02,
     &109,324,   3.38820000E+02,     109,325,   3.44470000E+02,
     &109,326,   3.51040000E+02,     109,327,   3.56800000E+02,
     &109,328,   3.65920000E+02,     109,329,   3.71830000E+02,
     &109,330,   3.78820000E+02,     109,331,   3.84620000E+02,
     &109,332,   3.91480000E+02,     109,333,   3.97420000E+02,
     &109,334,   4.04440000E+02,     109,335,   4.09920000E+02,
     &109,336,   4.16500000E+02,     109,337,   4.22110000E+02,
     &109,338,   4.29600000E+02,     109,339,   4.36290000E+02,
     &110,256,   1.37920000E+02,     110,257,   1.37460000E+02/
      data (niz(i),nia(i),bie(i),i=8641,8660)/
     &110,258,   1.35360000E+02,     110,259,   1.35080000E+02,
     &110,260,   1.33300000E+02,     110,261,   1.33340000E+02,
     &110,262,   1.31990000E+02,     110,263,   1.32570000E+02,
     &110,264,   1.31590000E+02,     110,265,   1.32370000E+02,
     &110,266,   1.31780000E+02,     110,267,   1.34094000E+02,
     &110,268,   1.33696000E+02,     110,269,   1.35200000E+02,
     &110,270,   1.34718000E+02,     110,271,   1.36070000E+02,
     &110,272,   1.36287000E+02,     110,273,   1.39021000E+02,
     &110,274,   1.36290000E+02,     110,275,   1.38760000E+02,
     &110,276,   1.39870000E+02,     110,277,   1.42710000E+02/
      data (niz(i),nia(i),bie(i),i=8661,8680)/
     &110,278,   1.43980000E+02,     110,279,   1.46470000E+02,
     &110,280,   1.47650000E+02,     110,281,   1.50090000E+02,
     &110,282,   1.51320000E+02,     110,283,   1.53990000E+02,
     &110,284,   1.55460000E+02,     110,285,   1.58400000E+02,
     &110,286,   1.60370000E+02,     110,287,   1.63870000E+02,
     &110,288,   1.65680000E+02,     110,289,   1.69050000E+02,
     &110,290,   1.71490000E+02,     110,291,   1.75210000E+02,
     &110,292,   1.77990000E+02,     110,293,   1.82110000E+02,
     &110,294,   1.85260000E+02,     110,295,   1.90540000E+02,
     &110,296,   1.93850000E+02,     110,297,   1.99170000E+02/
      data (niz(i),nia(i),bie(i),i=8681,8700)/
     &110,298,   2.03070000E+02,     110,299,   2.08040000E+02,
     &110,300,   2.12490000E+02,     110,301,   2.16970000E+02,
     &110,302,   2.20780000E+02,     110,303,   2.25280000E+02,
     &110,304,   2.28730000E+02,     110,305,   2.33580000E+02,
     &110,306,   2.37130000E+02,     110,307,   2.42070000E+02,
     &110,308,   2.45720000E+02,     110,309,   2.50750000E+02,
     &110,310,   2.54550000E+02,     110,311,   2.59810000E+02,
     &110,312,   2.64000000E+02,     110,313,   2.69650000E+02,
     &110,314,   2.74050000E+02,     110,315,   2.79890000E+02,
     &110,316,   2.84520000E+02,     110,317,   2.90460000E+02/
      data (niz(i),nia(i),bie(i),i=8701,8720)/
     &110,318,   2.95140000E+02,     110,319,   3.01110000E+02,
     &110,320,   3.05890000E+02,     110,321,   3.11950000E+02,
     &110,322,   3.16930000E+02,     110,323,   3.23240000E+02,
     &110,324,   3.28550000E+02,     110,325,   3.35180000E+02,
     &110,326,   3.40470000E+02,     110,327,   3.47140000E+02,
     &110,328,   3.54300000E+02,     110,329,   3.61180000E+02,
     &110,330,   3.66730000E+02,     110,331,   3.73400000E+02,
     &110,332,   3.78910000E+02,     110,333,   3.85790000E+02,
     &110,334,   3.91610000E+02,     110,335,   3.98290000E+02,
     &110,336,   4.03390000E+02,     110,337,   4.09960000E+02/
      data (niz(i),nia(i),bie(i),i=8721,8740)/
     &110,338,   4.15280000E+02,     110,339,   4.22790000E+02,
     &111,259,   1.44950000E+02,     111,260,   1.44390000E+02,
     &111,261,   1.42550000E+02,     111,262,   1.42230000E+02,
     &111,263,   1.40870000E+02,     111,264,   1.41110000E+02,
     &111,265,   1.40110000E+02,     111,266,   1.40510000E+02,
     &111,267,   1.39800000E+02,     111,268,   1.40340000E+02,
     &111,269,   1.39770000E+02,     111,270,   1.40420000E+02,
     &111,271,   1.40020000E+02,     111,272,   1.42963000E+02,
     &111,273,   1.40790000E+02,     111,274,   1.42140000E+02,
     &111,275,   1.42770000E+02,     111,276,   1.44840000E+02/
      data (niz(i),nia(i),bie(i),i=8741,8760)/
     &111,277,   1.45890000E+02,     111,278,   1.48320000E+02,
     &111,279,   1.49340000E+02,     111,280,   1.51340000E+02,
     &111,281,   1.52360000E+02,     111,282,   1.54460000E+02,
     &111,283,   1.55640000E+02,     111,284,   1.58000000E+02,
     &111,285,   1.59440000E+02,     111,286,   1.62050000E+02,
     &111,287,   1.63940000E+02,     111,288,   1.67060000E+02,
     &111,289,   1.68780000E+02,     111,290,   1.71870000E+02,
     &111,291,   1.74300000E+02,     111,292,   1.77730000E+02,
     &111,293,   1.80490000E+02,     111,294,   1.84340000E+02,
     &111,295,   1.87460000E+02,     111,296,   1.92390000E+02/
      data (niz(i),nia(i),bie(i),i=8761,8780)/
     &111,297,   1.95710000E+02,     111,298,   2.01000000E+02,
     &111,299,   2.04520000E+02,     111,300,   2.09950000E+02,
     &111,301,   2.13300000E+02,     111,302,   2.18240000E+02,
     &111,303,   2.22080000E+02,     111,304,   2.27070000E+02,
     &111,305,   2.29970000E+02,     111,306,   2.34550000E+02,
     &111,307,   2.38090000E+02,     111,308,   2.42720000E+02,
     &111,309,   2.46370000E+02,     111,310,   2.51160000E+02,
     &111,311,   2.54950000E+02,     111,312,   2.59950000E+02,
     &111,313,   2.64150000E+02,     111,314,   2.69520000E+02,
     &111,315,   2.73910000E+02,     111,316,   2.79460000E+02/
      data (niz(i),nia(i),bie(i),i=8781,8800)/
     &111,317,   2.84120000E+02,     111,318,   2.89770000E+02,
     &111,319,   2.94500000E+02,     111,320,   3.00230000E+02,
     &111,321,   3.05010000E+02,     111,322,   3.10830000E+02,
     &111,323,   3.15770000E+02,     111,324,   3.21850000E+02,
     &111,325,   3.27300000E+02,     111,326,   3.33510000E+02,
     &111,327,   3.38760000E+02,     111,328,   3.45420000E+02,
     &111,329,   3.51190000E+02,     111,330,   3.57800000E+02,
     &111,331,   3.63330000E+02,     111,332,   3.69900000E+02,
     &111,333,   3.75390000E+02,     111,334,   3.82110000E+02,
     &111,335,   3.87610000E+02,     111,336,   3.94090000E+02/
      data (niz(i),nia(i),bie(i),i=8801,8820)/
     &111,337,   3.99020000E+02,     111,338,   4.05300000E+02,
     &111,339,   4.10600000E+02,     112,262,   1.50530000E+02,
     &112,263,   1.50230000E+02,     112,264,   1.48550000E+02,
     &112,265,   1.48720000E+02,     112,266,   1.47390000E+02,
     &112,267,   1.47760000E+02,     112,268,   1.46700000E+02,
     &112,269,   1.47220000E+02,     112,270,   1.46300000E+02,
     &112,271,   1.46900000E+02,     112,272,   1.46130000E+02,
     &112,273,   1.47010000E+02,     112,274,   1.46500000E+02,
     &112,275,   1.47860000E+02,     112,276,   1.48090000E+02,
     &112,277,   1.50080000E+02,     112,278,   1.51010000E+02/
      data (niz(i),nia(i),bie(i),i=8821,8840)/
     &112,279,   1.53000000E+02,     112,280,   1.53420000E+02,
     &112,281,   1.55270000E+02,     112,282,   1.55820000E+02,
     &112,283,   1.57910000E+02,     112,284,   1.58770000E+02,
     &112,285,   1.61110000E+02,     112,286,   1.62230000E+02,
     &112,287,   1.64820000E+02,     112,288,   1.66230000E+02,
     &112,289,   1.69030000E+02,     112,290,   1.70440000E+02,
     &112,291,   1.73530000E+02,     112,292,   1.75610000E+02,
     &112,293,   1.78990000E+02,     112,294,   1.81440000E+02,
     &112,295,   1.85290000E+02,     112,296,   1.88110000E+02,
     &112,297,   1.92960000E+02,     112,298,   1.96030000E+02/
      data (niz(i),nia(i),bie(i),i=8841,8860)/
     &112,299,   2.01260000E+02,     112,300,   2.04600000E+02,
     &112,301,   2.09840000E+02,     112,302,   2.13370000E+02,
     &112,303,   2.18490000E+02,     112,304,   2.22070000E+02,
     &112,305,   2.27190000E+02,     112,306,   2.31380000E+02,
     &112,307,   2.34530000E+02,     112,308,   2.37730000E+02,
     &112,309,   2.42400000E+02,     112,310,   2.45790000E+02,
     &112,311,   2.50520000E+02,     112,312,   2.54020000E+02,
     &112,313,   2.58980000E+02,     112,314,   2.62830000E+02,
     &112,315,   2.68230000E+02,     112,316,   2.72500000E+02,
     &112,317,   2.78050000E+02,     112,318,   2.82410000E+02/
      data (niz(i),nia(i),bie(i),i=8861,8880)/
     &112,319,   2.88050000E+02,     112,320,   2.92490000E+02,
     &112,321,   2.98190000E+02,     112,322,   3.02710000E+02,
     &112,323,   3.08450000E+02,     112,324,   3.13740000E+02,
     &112,325,   3.19700000E+02,     112,326,   3.24390000E+02,
     &112,327,   3.30530000E+02,     112,328,   3.35520000E+02,
     &112,329,   3.41870000E+02,     112,330,   3.47100000E+02,
     &112,331,   3.53800000E+02,     112,332,   3.58970000E+02,
     &112,333,   3.65510000E+02,     112,334,   3.70700000E+02,
     &112,335,   3.77340000E+02,     112,336,   3.82320000E+02,
     &112,337,   3.88680000E+02,     112,338,   3.93270000E+02/
      data (niz(i),nia(i),bie(i),i=8881,8900)/
     &112,339,   3.99540000E+02,     113,266,   1.58260000E+02,
     &113,267,   1.56830000E+02,     113,268,   1.56800000E+02,
     &113,269,   1.55670000E+02,     113,270,   1.55830000E+02,
     &113,271,   1.54840000E+02,     113,272,   1.55110000E+02,
     &113,273,   1.54300000E+02,     113,274,   1.54820000E+02,
     &113,275,   1.54340000E+02,     113,276,   1.55250000E+02,
     &113,277,   1.55370000E+02,     113,278,   1.57120000E+02,
     &113,279,   1.57820000E+02,     113,280,   1.58730000E+02,
     &113,281,   1.59010000E+02,     113,282,   1.60520000E+02,
     &113,283,   1.61120000E+02,     113,284,   1.62910000E+02/
      data (niz(i),nia(i),bie(i),i=8901,8920)/
     &113,285,   1.63760000E+02,     113,286,   1.65790000E+02,
     &113,287,   1.66890000E+02,     113,288,   1.69180000E+02,
     &113,289,   1.70320000E+02,     113,290,   1.72920000E+02,
     &113,291,   1.74270000E+02,     113,292,   1.77070000E+02,
     &113,293,   1.79200000E+02,     113,294,   1.82330000E+02,
     &113,295,   1.84810000E+02,     113,296,   1.88350000E+02,
     &113,297,   1.91160000E+02,     113,298,   1.95880000E+02,
     &113,299,   1.98750000E+02,     113,300,   2.03720000E+02,
     &113,301,   2.06990000E+02,     113,302,   2.11920000E+02,
     &113,303,   2.15440000E+02,     113,304,   2.20330000E+02/
      data (niz(i),nia(i),bie(i),i=8921,8940)/
     &113,305,   2.23920000E+02,     113,306,   2.29200000E+02,
     &113,307,   2.32450000E+02,     113,308,   2.36010000E+02,
     &113,309,   2.39480000E+02,     113,310,   2.43870000E+02,
     &113,311,   2.47220000E+02,     113,312,   2.51680000E+02,
     &113,313,   2.55200000E+02,     113,314,   2.59910000E+02,
     &113,315,   2.63660000E+02,     113,316,   2.68850000E+02,
     &113,317,   2.73010000E+02,     113,318,   2.78440000E+02,
     &113,319,   2.82810000E+02,     113,320,   2.88170000E+02,
     &113,321,   2.92610000E+02,     113,322,   2.98060000E+02,
     &113,323,   3.02590000E+02,     113,324,   3.08020000E+02/
      data (niz(i),nia(i),bie(i),i=8941,8960)/
     &113,325,   3.13260000E+02,     113,326,   3.18960000E+02,
     &113,327,   3.23520000E+02,     113,328,   3.29290000E+02,
     &113,329,   3.34180000E+02,     113,330,   3.40340000E+02,
     &113,331,   3.45440000E+02,     113,332,   3.51690000E+02,
     &113,333,   3.56820000E+02,     113,334,   3.62930000E+02,
     &113,335,   3.68060000E+02,     113,336,   3.74190000E+02,
     &113,337,   3.79170000E+02,     113,338,   3.85190000E+02,
     &113,339,   3.89800000E+02,     114,269,   1.64740000E+02,
     &114,270,   1.63230000E+02,     114,271,   1.63380000E+02,
     &114,272,   1.62060000E+02,     114,273,   1.62340000E+02/
      data (niz(i),nia(i),bie(i),i=8961,8980)/
     &114,274,   1.61210000E+02,     114,275,   1.61780000E+02,
     &114,276,   1.60890000E+02,     114,277,   1.61760000E+02,
     &114,278,   1.61570000E+02,     114,279,   1.62330000E+02,
     &114,280,   1.62120000E+02,     114,281,   1.63440000E+02,
     &114,282,   1.63440000E+02,     114,283,   1.65000000E+02,
     &114,284,   1.65280000E+02,     114,285,   1.67040000E+02,
     &114,286,   1.67640000E+02,     114,287,   1.69640000E+02,
     &114,288,   1.70360000E+02,     114,289,   1.72400000E+02,
     &114,290,   1.73150000E+02,     114,291,   1.75690000E+02,
     &114,292,   1.76910000E+02,     114,293,   1.79700000E+02/
      data (niz(i),nia(i),bie(i),i=8981,9000)/
     &114,294,   1.81480000E+02,     114,295,   1.84590000E+02,
     &114,296,   1.86720000E+02,     114,297,   1.90280000E+02,
     &114,298,   1.92780000E+02,     114,299,   1.97500000E+02,
     &114,300,   2.00050000E+02,     114,301,   2.05020000E+02,
     &114,302,   2.07960000E+02,     114,303,   2.13000000E+02,
     &114,304,   2.16100000E+02,     114,305,   2.21210000E+02,
     &114,306,   2.24400000E+02,     114,307,   2.29580000E+02,
     &114,308,   2.32840000E+02,     114,309,   2.38090000E+02,
     &114,310,   2.41420000E+02,     114,311,   2.44120000E+02,
     &114,312,   2.47230000E+02,     114,313,   2.51750000E+02/
      data (niz(i),nia(i),bie(i),i=9001,9020)/
     &114,314,   2.54940000E+02,     114,315,   2.59650000E+02,
     &114,316,   2.63150000E+02,     114,317,   2.68250000E+02,
     &114,318,   2.72230000E+02,     114,319,   2.77550000E+02,
     &114,320,   2.81800000E+02,     114,321,   2.87180000E+02,
     &114,322,   2.91370000E+02,     114,323,   2.96830000E+02,
     &114,324,   3.01080000E+02,     114,325,   3.06470000E+02,
     &114,326,   3.11260000E+02,     114,327,   3.16940000E+02,
     &114,328,   3.21210000E+02,     114,329,   3.26980000E+02,
     &114,330,   3.31710000E+02,     114,331,   3.37790000E+02,
     &114,332,   3.42540000E+02,     114,333,   3.48760000E+02/
      data (niz(i),nia(i),bie(i),i=9021,9040)/
     &114,334,   3.53480000E+02,     114,335,   3.59620000E+02,
     &114,336,   3.64230000E+02,     114,337,   3.70210000E+02,
     &114,338,   3.74660000E+02,     114,339,   3.80640000E+02,
     &115,272,   1.72650000E+02,     115,273,   1.71290000E+02,
     &115,274,   1.71280000E+02,     115,275,   1.70110000E+02,
     &115,276,   1.70290000E+02,     115,277,   1.69370000E+02,
     &115,278,   1.69910000E+02,     115,279,   1.69040000E+02,
     &115,280,   1.69680000E+02,     115,281,   1.69370000E+02,
     &115,282,   1.70340000E+02,     115,283,   1.70320000E+02,
     &115,284,   1.71490000E+02,     115,285,   1.71750000E+02/
      data (niz(i),nia(i),bie(i),i=9041,9060)/
     &115,286,   1.73190000E+02,     115,287,   1.73790000E+02,
     &115,288,   1.75460000E+02,     115,289,   1.76210000E+02,
     &115,290,   1.78130000E+02,     115,291,   1.78970000E+02,
     &115,292,   1.81140000E+02,     115,293,   1.82220000E+02,
     &115,294,   1.84580000E+02,     115,295,   1.86340000E+02,
     &115,296,   1.89180000E+02,     115,297,   1.91360000E+02,
     &115,298,   1.94610000E+02,     115,299,   1.97100000E+02,
     &115,300,   2.01500000E+02,     115,301,   2.04030000E+02,
     &115,302,   2.08670000E+02,     115,303,   2.11600000E+02,
     &115,304,   2.16310000E+02,     115,305,   2.19400000E+02/
      data (niz(i),nia(i),bie(i),i=9061,9080)/
     &115,306,   2.24190000E+02,     115,307,   2.27370000E+02,
     &115,308,   2.32120000E+02,     115,309,   2.35430000E+02,
     &115,310,   2.38650000E+02,     115,311,   2.41950000E+02,
     &115,312,   2.46130000E+02,     115,313,   2.49270000E+02,
     &115,314,   2.53550000E+02,     115,315,   2.56790000E+02,
     &115,316,   2.61190000E+02,     115,317,   2.64690000E+02,
     &115,318,   2.69520000E+02,     115,319,   2.73470000E+02,
     &115,320,   2.78540000E+02,     115,321,   2.82790000E+02,
     &115,322,   2.87910000E+02,     115,323,   2.92280000E+02,
     &115,324,   2.97330000E+02,     115,325,   3.01610000E+02/
      data (niz(i),nia(i),bie(i),i=9081,9100)/
     &115,326,   3.06920000E+02,     115,327,   3.11190000E+02,
     &115,328,   3.16700000E+02,     115,329,   3.21030000E+02,
     &115,330,   3.26640000E+02,     115,331,   3.31110000E+02,
     &115,332,   3.36880000E+02,     115,333,   3.41620000E+02,
     &115,334,   3.47420000E+02,     115,335,   3.52110000E+02,
     &115,336,   3.57950000E+02,     115,337,   3.62530000E+02,
     &115,338,   3.68150000E+02,     115,339,   3.72790000E+02,
     &116,275,   1.79260000E+02,     116,276,   1.77770000E+02,
     &116,277,   1.77930000E+02,     116,278,   1.76670000E+02,
     &116,279,   1.77200000E+02,     116,280,   1.75740000E+02/
      data (niz(i),nia(i),bie(i),i=9101,9120)/
     &116,281,   1.76350000E+02,     116,282,   1.75650000E+02,
     &116,283,   1.76560000E+02,     116,284,   1.76150000E+02,
     &116,285,   1.77320000E+02,     116,286,   1.77280000E+02,
     &116,287,   1.78720000E+02,     116,288,   1.79020000E+02,
     &116,289,   1.80730000E+02,     116,290,   1.81180000E+02,
     &116,291,   1.83180000E+02,     116,292,   1.83610000E+02,
     &116,293,   1.85760000E+02,     116,294,   1.86550000E+02,
     &116,295,   1.88960000E+02,     116,296,   1.90440000E+02,
     &116,297,   1.93290000E+02,     116,298,   1.95130000E+02,
     &116,299,   1.98370000E+02,     116,300,   2.00550000E+02/
      data (niz(i),nia(i),bie(i),i=9121,9140)/
     &116,301,   2.04720000E+02,     116,302,   2.07150000E+02,
     &116,303,   2.11760000E+02,     116,304,   2.14390000E+02,
     &116,305,   2.19060000E+02,     116,306,   2.21840000E+02,
     &116,307,   2.26540000E+02,     116,308,   2.29540000E+02,
     &116,309,   2.34110000E+02,     116,310,   2.37230000E+02,
     &116,311,   2.40270000E+02,     116,312,   2.43070000E+02,
     &116,313,   2.47460000E+02,     116,314,   2.49950000E+02,
     &116,315,   2.54190000E+02,     116,316,   2.57190000E+02,
     &116,317,   2.61610000E+02,     116,318,   2.64800000E+02,
     &116,319,   2.69620000E+02,     116,320,   2.73280000E+02/
      data (niz(i),nia(i),bie(i),i=9141,9160)/
     &116,321,   2.78420000E+02,     116,322,   2.82300000E+02,
     &116,323,   2.87540000E+02,     116,324,   2.91480000E+02,
     &116,325,   2.96560000E+02,     116,326,   3.00580000E+02,
     &116,327,   3.05840000E+02,     116,328,   3.10100000E+02,
     &116,329,   3.15500000E+02,     116,330,   3.19610000E+02,
     &116,331,   3.25140000E+02,     116,332,   3.29510000E+02,
     &116,333,   3.35300000E+02,     116,334,   3.39560000E+02,
     &116,335,   3.45300000E+02,     116,336,   3.49710000E+02,
     &116,337,   3.55510000E+02,     116,338,   3.59950000E+02,
     &116,339,   3.65400000E+02,     117,278,   1.87180000E+02/
      data (niz(i),nia(i),bie(i),i=9161,9180)/
     &117,279,   1.85550000E+02,     117,280,   1.86170000E+02,
     &117,281,   1.84420000E+02,     117,282,   1.84650000E+02,
     &117,283,   1.83960000E+02,     117,284,   1.84510000E+02,
     &117,285,   1.84080000E+02,     117,286,   1.84940000E+02,
     &117,287,   1.84830000E+02,     117,288,   1.85930000E+02,
     &117,289,   1.86150000E+02,     117,290,   1.87510000E+02,
     &117,291,   1.87940000E+02,     117,292,   1.89590000E+02,
     &117,293,   1.90310000E+02,     117,294,   1.92230000E+02,
     &117,295,   1.92980000E+02,     117,296,   1.94930000E+02,
     &117,297,   1.96390000E+02,     117,298,   1.98940000E+02/
      data (niz(i),nia(i),bie(i),i=9181,9200)/
     &117,299,   2.00790000E+02,     117,300,   2.03740000E+02,
     &117,301,   2.05910000E+02,     117,302,   2.09770000E+02,
     &117,303,   2.12170000E+02,     117,304,   2.16450000E+02,
     &117,305,   2.19080000E+02,     117,306,   2.23470000E+02,
     &117,307,   2.26210000E+02,     117,308,   2.30520000E+02,
     &117,309,   2.31880000E+02,     117,310,   2.37980000E+02,
     &117,311,   2.40880000E+02,     117,312,   2.43450000E+02,
     &117,313,   2.46510000E+02,     117,314,   2.50860000E+02,
     &117,315,   2.52640000E+02,     117,316,   2.56670000E+02,
     &117,317,   2.59640000E+02,     117,318,   2.63830000E+02/
      data (niz(i),nia(i),bie(i),i=9201,9220)/
     &117,319,   2.66950000E+02,     117,320,   2.71550000E+02,
     &117,321,   2.75220000E+02,     117,322,   2.80070000E+02,
     &117,323,   2.83960000E+02,     117,324,   2.88920000E+02,
     &117,325,   2.92890000E+02,     117,326,   2.97740000E+02,
     &117,327,   3.01800000E+02,     117,328,   3.06800000E+02,
     &117,329,   3.10940000E+02,     117,330,   3.16090000E+02,
     &117,331,   3.20230000E+02,     117,332,   3.25460000E+02,
     &117,333,   3.29770000E+02,     117,334,   3.35090000E+02,
     &117,335,   3.39350000E+02,     117,336,   3.44800000E+02,
     &117,337,   3.49210000E+02,     117,338,   3.54690000E+02/
      data (niz(i),nia(i),bie(i),i=9221,9240)/
     &117,339,   3.59120000E+02,     118,281,   1.94150000E+02,
     &118,282,   1.92010000E+02,     118,283,   1.92330000E+02,
     &118,284,   1.91260000E+02,     118,285,   1.91840000E+02,
     &118,286,   1.91120000E+02,     118,287,   1.91860000E+02,
     &118,288,   1.91450000E+02,     118,289,   1.92500000E+02,
     &118,290,   1.92510000E+02,     118,291,   1.93700000E+02,
     &118,292,   1.93810000E+02,     118,293,   1.95430000E+02,
     &118,294,   1.95880000E+02,     118,295,   1.97790000E+02,
     &118,296,   1.98320000E+02,     118,297,   2.00290000E+02,
     &118,298,   2.01480000E+02,     118,299,   2.04020000E+02/
      data (niz(i),nia(i),bie(i),i=9241,9260)/
     &118,300,   2.05580000E+02,     118,301,   2.08540000E+02,
     &118,302,   2.10400000E+02,     118,303,   2.14430000E+02,
     &118,304,   2.16310000E+02,     118,305,   2.20590000E+02,
     &118,306,   2.22880000E+02,     118,307,   2.27140000E+02,
     &118,308,   2.29660000E+02,     118,309,   2.33860000E+02,
     &118,310,   2.36660000E+02,     118,311,   2.40600000E+02,
     &118,312,   2.43150000E+02,     118,313,   2.41270000E+02,
     &118,314,   2.43770000E+02,     118,315,   2.47650000E+02,
     &118,316,   2.53910000E+02,     118,317,   2.58050000E+02,
     &118,318,   2.60740000E+02,     118,319,   2.64900000E+02/
      data (niz(i),nia(i),bie(i),i=9261,9280)/
     &118,320,   2.67870000E+02,     118,321,   2.72330000E+02,
     &118,322,   2.75710000E+02,     118,323,   2.80560000E+02,
     &118,324,   2.84180000E+02,     118,325,   2.89120000E+02,
     &118,326,   2.92810000E+02,     118,327,   2.97790000E+02,
     &118,328,   3.01590000E+02,     118,329,   3.05240000E+02,
     &118,330,   3.09000000E+02,     118,331,   3.14230000E+02,
     &118,332,   3.19580000E+02,     118,333,   3.24840000E+02,
     &118,334,   3.28920000E+02,     118,335,   3.34200000E+02,
     &118,336,   3.38170000E+02,     118,337,   3.43600000E+02,
     &118,338,   3.47690000E+02,     118,339,   3.53150000E+02/
      data (niz(i),nia(i),bie(i),i=9281,9300)/
     &119,284,   2.01620000E+02,     119,285,   2.00640000E+02,
     &119,286,   2.00810000E+02,     119,287,   1.99830000E+02,
     &119,288,   2.00320000E+02,     119,289,   2.00050000E+02,
     &119,290,   2.00730000E+02,     119,291,   2.00460000E+02,
     &119,292,   2.01520000E+02,     119,293,   2.01460000E+02,
     &119,294,   2.02740000E+02,     119,295,   2.03250000E+02,
     &119,296,   2.05090000E+02,     119,297,   2.05480000E+02,
     &119,298,   2.07160000E+02,     119,299,   2.08200000E+02,
     &119,300,   2.10500000E+02,     119,301,   2.12080000E+02,
     &119,302,   2.14740000E+02,     119,303,   2.16590000E+02/
      data (niz(i),nia(i),bie(i),i=9301,9320)/
     &119,304,   2.20310000E+02,     119,305,   2.22180000E+02,
     &119,306,   2.26160000E+02,     119,307,   2.28410000E+02,
     &119,308,   2.32310000E+02,     119,309,   2.34820000E+02,
     &119,310,   2.38650000E+02,     119,311,   2.41120000E+02,
     &119,312,   2.45060000E+02,     119,313,   2.47560000E+02,
     &119,314,   2.45070000E+02,     119,315,   2.47430000E+02,
     &119,316,   2.51020000E+02,     119,317,   2.57080000E+02,
     &119,318,   2.61120000E+02,     119,319,   2.63810000E+02,
     &119,320,   2.67770000E+02,     119,321,   2.70770000E+02,
     &119,322,   2.74970000E+02,     119,323,   2.78360000E+02/
      data (niz(i),nia(i),bie(i),i=9321,9340)/
     &119,324,   2.82970000E+02,     119,325,   2.86580000E+02,
     &119,326,   2.91220000E+02,     119,327,   2.94940000E+02,
     &119,328,   2.99610000E+02,     119,329,   3.03390000E+02,
     &119,330,   3.06400000E+02,     119,331,   3.10250000E+02,
     &119,332,   3.15210000E+02,     119,333,   3.21180000E+02,
     &119,334,   3.26090000E+02,     119,335,   3.30080000E+02,
     &119,336,   3.35040000E+02,     119,337,   3.38960000E+02,
     &119,338,   3.44060000E+02,     119,339,   3.48140000E+02,
     &120,287,   2.08740000E+02,     120,288,   2.07610000E+02,
     &120,289,   2.08150000E+02,     120,290,   2.07320000E+02/
      data (niz(i),nia(i),bie(i),i=9341,9360)/
     &120,291,   2.08200000E+02,     120,292,   2.07760000E+02,
     &120,293,   2.08610000E+02,     120,294,   2.08230000E+02,
     &120,295,   2.09480000E+02,     120,296,   2.09920000E+02,
     &120,297,   2.11390000E+02,     120,298,   2.11660000E+02,
     &120,299,   2.13320000E+02,     120,300,   2.14140000E+02,
     &120,301,   2.16380000E+02,     120,302,   2.17620000E+02,
     &120,303,   2.20290000E+02,     120,304,   2.21830000E+02,
     &120,305,   2.25440000E+02,     120,306,   2.27090000E+02,
     &120,307,   2.31000000E+02,     120,308,   2.33040000E+02,
     &120,309,   2.36740000E+02,     120,310,   2.38940000E+02/
      data (niz(i),nia(i),bie(i),i=9361,9380)/
     &120,311,   2.42670000E+02,     120,312,   2.44760000E+02,
     &120,313,   2.48540000E+02,     120,314,   2.50670000E+02,
     &120,315,   2.47690000E+02,     120,316,   2.49740000E+02,
     &120,317,   2.53310000E+02,     120,318,   2.55710000E+02,
     &120,319,   2.63230000E+02,     120,320,   2.65720000E+02,
     &120,321,   2.69580000E+02,     120,322,   2.72280000E+02,
     &120,323,   2.76470000E+02,     120,324,   2.79610000E+02,
     &120,325,   2.84170000E+02,     120,326,   2.87480000E+02,
     &120,327,   2.92120000E+02,     120,328,   2.95530000E+02,
     &120,329,   3.00230000E+02,     120,330,   3.03830000E+02/
      data (niz(i),nia(i),bie(i),i=9381,9400)/
     &120,331,   3.08600000E+02,     120,332,   3.12250000E+02,
     &120,333,   3.15220000E+02,     120,334,   3.21240000E+02,
     &120,335,   3.26470000E+02,     120,336,   3.30020000E+02,
     &120,337,   3.35090000E+02,     120,338,   3.38730000E+02,
     &120,339,   3.43820000E+02,     121,290,   2.17460000E+02,
     &121,291,   2.16590000E+02,     121,292,   2.17070000E+02,
     &121,293,   2.16610000E+02,     121,294,   2.17310000E+02,
     &121,295,   2.17090000E+02,     121,296,   2.18040000E+02,
     &121,297,   2.18240000E+02,     121,298,   2.19510000E+02,
     &121,299,   2.19690000E+02,     121,300,   2.21010000E+02/
      data (niz(i),nia(i),bie(i),i=9401,9420)/
     &121,301,   2.21760000E+02,     121,302,   2.23760000E+02,
     &121,303,   2.25000000E+02,     121,304,   2.27370000E+02,
     &121,305,   2.28900000E+02,     121,306,   2.32470000E+02,
     &121,307,   2.33900000E+02,     121,308,   2.37400000E+02,
     &121,309,   2.39360000E+02,     121,310,   2.42610000E+02,
     &121,311,   2.44730000E+02,     121,312,   2.48040000E+02,
     &121,313,   2.50070000E+02,     121,314,   2.53480000E+02,
     &121,315,   2.55580000E+02,     121,316,   2.52060000E+02,
     &121,317,   2.54250000E+02,     121,318,   2.57400000E+02,
     &121,319,   2.59800000E+02,     121,320,   2.66970000E+02/
      data (niz(i),nia(i),bie(i),i=9421,9440)/
     &121,321,   2.69510000E+02,     121,322,   2.73170000E+02,
     &121,323,   2.75770000E+02,     121,324,   2.79800000E+02,
     &121,325,   2.82890000E+02,     121,326,   2.87250000E+02,
     &121,327,   2.90500000E+02,     121,328,   2.94890000E+02,
     &121,329,   2.98520000E+02,     121,330,   3.02730000E+02,
     &121,331,   3.06210000E+02,     121,332,   3.10790000E+02,
     &121,333,   3.14420000E+02,     121,334,   3.17180000E+02,
     &121,335,   3.23360000E+02,     121,336,   3.28120000E+02,
     &121,337,   3.32070000E+02,     121,338,   3.36780000E+02,
     &121,339,   3.40590000E+02,     122,294,   2.24380000E+02/
      data (niz(i),nia(i),bie(i),i=9441,9460)/
     &122,295,   2.25130000E+02,     122,296,   2.24690000E+02,
     &122,297,   2.25840000E+02,     122,298,   2.25570000E+02,
     &122,299,   2.26900000E+02,     122,300,   2.26330000E+02,
     &122,301,   2.27710000E+02,     122,302,   2.28130000E+02,
     &122,303,   2.30450000E+02,     122,304,   2.31380000E+02,
     &122,305,   2.33740000E+02,     122,306,   2.34970000E+02,
     &122,307,   2.38290000E+02,     122,308,   2.39700000E+02,
     &122,309,   2.42920000E+02,     122,310,   2.44620000E+02,
     &122,311,   2.47680000E+02,     122,312,   2.49400000E+02,
     &122,313,   2.52640000E+02,     122,314,   2.54300000E+02/
      data (niz(i),nia(i),bie(i),i=9461,9480)/
     &122,315,   2.57610000E+02,     122,316,   2.59370000E+02,
     &122,317,   2.55400000E+02,     122,318,   2.57140000E+02,
     &122,319,   2.60410000E+02,     122,320,   2.62520000E+02,
     &122,321,   2.65980000E+02,     122,322,   2.72030000E+02,
     &122,323,   2.75680000E+02,     122,324,   2.77980000E+02,
     &122,325,   2.81980000E+02,     122,326,   2.84780000E+02,
     &122,327,   2.89110000E+02,     122,328,   2.92110000E+02,
     &122,329,   2.96460000E+02,     122,330,   2.99590000E+02,
     &122,331,   3.04030000E+02,     122,332,   3.07220000E+02,
     &122,333,   3.11780000E+02,     122,334,   3.15150000E+02/
      data (niz(i),nia(i),bie(i),i=9481,9500)/
     &122,335,   3.20040000E+02,     122,336,   3.24050000E+02,
     &122,337,   3.28830000E+02,     122,338,   3.32330000E+02,
     &122,339,   3.37360000E+02,     123,297,   2.34010000E+02,
     &123,298,   2.35010000E+02,     123,299,   2.34650000E+02,
     &123,300,   2.35620000E+02,     123,301,   2.34930000E+02,
     &123,302,   2.35870000E+02,     123,303,   2.35790000E+02,
     &123,304,   2.38760000E+02,     123,305,   2.39660000E+02,
     &123,306,   2.41720000E+02,     123,307,   2.42970000E+02,
     &123,308,   2.45960000E+02,     123,309,   2.47310000E+02,
     &123,310,   2.50040000E+02,     123,311,   2.51600000E+02/
      data (niz(i),nia(i),bie(i),i=9501,9520)/
     &123,312,   2.54250000E+02,     123,313,   2.55900000E+02,
     &123,314,   2.58770000E+02,     123,315,   2.60380000E+02,
     &123,316,   2.63360000E+02,     123,317,   2.65080000E+02,
     &123,318,   2.60460000E+02,     123,319,   2.62330000E+02,
     &123,320,   2.65180000E+02,     123,321,   2.67260000E+02,
     &123,322,   2.70440000E+02,     123,323,   2.76470000E+02,
     &123,324,   2.79960000E+02,     123,325,   2.82230000E+02,
     &123,326,   2.85930000E+02,     123,327,   2.88730000E+02,
     &123,328,   2.92770000E+02,     123,329,   2.95750000E+02,
     &123,330,   2.99850000E+02,     123,331,   3.02970000E+02/
      data (niz(i),nia(i),bie(i),i=9521,9540)/
     &123,332,   3.07190000E+02,     123,333,   3.10380000E+02,
     &123,334,   3.14670000E+02,     123,335,   3.18000000E+02,
     &123,336,   3.22620000E+02,     123,337,   3.26670000E+02,
     &123,338,   3.31280000E+02,     123,339,   3.34760000E+02,
     &124,300,   2.42740000E+02,     124,301,   2.43530000E+02,
     &124,302,   2.41880000E+02,     124,303,   2.42780000E+02,
     &124,304,   2.42390000E+02,     124,305,   2.43570000E+02,
     &124,306,   2.46880000E+02,     124,307,   2.48930000E+02,
     &124,308,   2.49940000E+02,     124,309,   2.52650000E+02,
     &124,310,   2.53720000E+02,     124,311,   2.56220000E+02/
      data (niz(i),nia(i),bie(i),i=9541,9560)/
     &124,312,   2.57420000E+02,     124,313,   2.59990000E+02,
     &124,314,   2.61290000E+02,     124,315,   2.64090000E+02,
     &124,316,   2.65340000E+02,     124,317,   2.61910000E+02,
     &124,318,   2.61740000E+02,     124,319,   2.64490000E+02,
     &124,320,   2.65930000E+02,     124,321,   2.68870000E+02,
     &124,322,   2.70650000E+02,     124,323,   2.73800000E+02,
     &124,324,   2.75800000E+02,     124,325,   2.83210000E+02,
     &124,326,   2.85280000E+02,     124,327,   2.88880000E+02,
     &124,328,   2.91400000E+02,     124,329,   2.95400000E+02,
     &124,330,   2.98090000E+02,     124,331,   3.02130000E+02/
      data (niz(i),nia(i),bie(i),i=9561,9580)/
     &124,332,   3.04980000E+02,     124,333,   3.09170000E+02,
     &124,334,   3.12070000E+02,     124,335,   3.16350000E+02,
     &124,336,   3.19380000E+02,     124,337,   3.24000000E+02,
     &124,338,   3.26860000E+02,     124,339,   3.32590000E+02,
     &125,303,   2.50560000E+02,     125,304,   2.51220000E+02,
     &125,305,   2.50730000E+02,     125,306,   2.55510000E+02,
     &125,307,   2.56120000E+02,     125,308,   2.57950000E+02,
     &125,309,   2.58950000E+02,     125,310,   2.61210000E+02,
     &125,311,   2.62370000E+02,     125,312,   2.64230000E+02,
     &125,313,   2.65280000E+02,     125,314,   2.67490000E+02/
      data (niz(i),nia(i),bie(i),i=9581,9600)/
     &125,315,   2.68730000E+02,     125,316,   2.71110000E+02,
     &125,317,   2.72400000E+02,     125,318,   2.67900000E+02,
     &125,319,   2.67790000E+02,     125,320,   2.70260000E+02,
     &125,321,   2.71780000E+02,     125,322,   2.74300000E+02,
     &125,323,   2.76060000E+02,     125,324,   2.78920000E+02,
     &125,325,   2.80900000E+02,     125,326,   2.88190000E+02,
     &125,327,   2.86410000E+02,     125,328,   2.93540000E+02,
     &125,329,   2.96050000E+02,     125,330,   2.99760000E+02,
     &125,331,   3.02360000E+02,     125,332,   3.06200000E+02,
     &125,333,   3.08940000E+02,     125,334,   3.12950000E+02/
      data (niz(i),nia(i),bie(i),i=9601,9620)/
     &125,335,   3.15870000E+02,     125,336,   3.19890000E+02,
     &125,337,   3.22900000E+02,     125,338,   3.27210000E+02,
     &125,339,   3.30260000E+02,     126,306,   2.57990000E+02,
     &126,307,   2.58830000E+02,     126,308,   2.64130000E+02,
     &126,309,   2.65900000E+02,     126,310,   2.66310000E+02,
     &126,311,   2.68430000E+02,     126,312,   2.68890000E+02,
     &126,313,   2.71040000E+02,     126,314,   2.71830000E+02,
     &126,315,   2.73970000E+02,     126,316,   2.74880000E+02,
     &126,317,   2.77170000E+02,     126,318,   2.78170000E+02,
     &126,319,   2.72960000E+02,     126,320,   2.74400000E+02/
      data (niz(i),nia(i),bie(i),i=9621,9640)/
     &126,321,   2.74990000E+02,     126,322,   2.76080000E+02,
     &126,323,   2.78670000E+02,     126,324,   2.80110000E+02,
     &126,325,   2.82940000E+02,     126,326,   2.84630000E+02,
     &126,327,   2.92150000E+02,     126,328,   2.93920000E+02,
     &126,329,   2.97230000E+02,     126,330,   2.99420000E+02,
     &126,331,   3.03110000E+02,     126,332,   3.05470000E+02,
     &126,333,   3.09230000E+02,     126,334,   3.11830000E+02,
     &126,335,   3.15640000E+02,     126,336,   3.18260000E+02,
     &126,337,   3.22260000E+02,     126,338,   3.25000000E+02,
     &126,339,   3.29340000E+02,     127,310,   2.75640000E+02/
      data (niz(i),nia(i),bie(i),i=9641,9660)/
     &127,311,   2.75960000E+02,     127,312,   2.77610000E+02,
     &127,313,   2.77980000E+02,     127,314,   2.79790000E+02,
     &127,315,   2.80390000E+02,     127,316,   2.82320000E+02,
     &127,317,   2.83170000E+02,     127,318,   2.76140000E+02,
     &127,319,   2.77250000E+02,     127,320,   2.79700000E+02,
     &127,321,   2.81120000E+02,     127,322,   2.81460000E+02,
     &127,323,   2.82500000E+02,     127,324,   2.84810000E+02,
     &127,325,   2.86240000E+02,     127,326,   2.88800000E+02,
     &127,327,   2.90460000E+02,     127,328,   2.93350000E+02,
     &127,329,   2.95360000E+02,     127,330,   3.02600000E+02/
      data (niz(i),nia(i),bie(i),i=9661,9680)/
     &127,331,   3.04770000E+02,     127,332,   3.08170000E+02,
     &127,333,   3.10520000E+02,     127,334,   3.14020000E+02,
     &127,335,   3.16460000E+02,     127,336,   3.20050000E+02,
     &127,337,   3.22650000E+02,     127,338,   3.26430000E+02,
     &127,339,   3.29150000E+02,     128,313,   2.85380000E+02,
     &128,314,   2.85560000E+02,     128,315,   2.87190000E+02,
     &128,316,   2.87610000E+02,     128,317,   2.89350000E+02,
     &128,318,   2.89890000E+02,     128,319,   2.82370000E+02,
     &128,320,   2.83240000E+02,     128,321,   2.85610000E+02,
     &128,322,   2.86750000E+02,     128,323,   2.89490000E+02/
      data (niz(i),nia(i),bie(i),i=9681,9700)/
     &128,324,   2.87600000E+02,     128,325,   2.89890000E+02,
     &128,326,   2.90990000E+02,     128,327,   2.93480000E+02,
     &128,328,   2.94860000E+02,     128,329,   2.97730000E+02,
     &128,330,   2.99450000E+02,     128,331,   3.07100000E+02,
     &128,332,   3.08940000E+02,     128,333,   3.12250000E+02,
     &128,334,   3.14350000E+02,     128,335,   3.17760000E+02,
     &128,336,   3.19980000E+02,     128,337,   3.23590000E+02,
     &128,338,   3.25920000E+02,     128,339,   3.29490000E+02,
     &129,316,   2.96530000E+02,     129,317,   2.96780000E+02,
     &129,318,   2.88140000E+02,     129,319,   2.88560000E+02/
      data (niz(i),nia(i),bie(i),i=9701,9720)/
     &129,320,   2.90390000E+02,     129,321,   2.91230000E+02,
     &129,322,   2.93260000E+02,     129,323,   2.94350000E+02,
     &129,324,   2.96770000E+02,     129,325,   2.94700000E+02,
     &129,326,   2.96680000E+02,     129,327,   2.97770000E+02,
     &129,328,   2.99970000E+02,     129,329,   3.01320000E+02,
     &129,330,   3.03900000E+02,     129,331,   3.05610000E+02,
     &129,332,   3.13170000E+02,     129,333,   3.15000000E+02,
     &129,334,   3.18020000E+02,     129,335,   3.20100000E+02,
     &129,336,   3.23310000E+02,     129,337,   3.25600000E+02,
     &129,338,   3.29080000E+02,     129,339,   3.30860000E+02/
      data (niz(i),nia(i),bie(i),i=9721,9740)/
     &130,319,   3.05950000E+02,     130,320,   3.06120000E+02,
     &130,321,   2.97600000E+02,     130,322,   2.98050000E+02,
     &130,323,   3.00120000E+02,     130,324,   3.00840000E+02,
     &130,325,   2.99980000E+02,     130,326,   3.00520000E+02,
     &130,327,   3.02470000E+02,     130,328,   3.03270000E+02,
     &130,329,   3.05460000E+02,     130,330,   3.06520000E+02,
     &130,331,   3.14460000E+02,     130,332,   3.10490000E+02,
     &130,333,   3.18260000E+02,     130,334,   3.19800000E+02,
     &130,335,   3.22840000E+02,     130,336,   3.24610000E+02,
     &130,337,   3.27630000E+02,     130,338,   3.29540000E+02/
      data (niz(i),nia(i),bie(i),i=9741,9760)/
     &130,339,   3.33080000E+02,     131,323,   3.06670000E+02,
     &131,324,   3.08500000E+02,     131,325,   3.09250000E+02,
     &131,326,   3.07780000E+02,     131,327,   3.08310000E+02,
     &131,328,   3.09960000E+02,     131,329,   3.10720000E+02,
     &131,330,   3.12630000E+02,     131,331,   3.13650000E+02,
     &131,332,   3.15930000E+02,     131,333,   3.17310000E+02,
     &131,334,   3.25030000E+02,     131,335,   3.26640000E+02,
     &131,336,   3.29300000E+02,     131,337,   3.30620000E+02,
     &131,338,   3.33570000E+02,     131,339,   3.35520000E+02,
     &132,326,   3.16480000E+02,     132,327,   3.14590000E+02/
      data (niz(i),nia(i),bie(i),i=9761,9780)/
     &132,328,   3.14830000E+02,     132,329,   3.16450000E+02,
     &132,330,   3.16930000E+02,     132,331,   3.18810000E+02,
     &132,332,   3.19540000E+02,     132,333,   3.27640000E+02,
     &132,334,   3.28480000E+02,     132,335,   3.30770000E+02,
     &132,336,   3.32120000E+02,     132,337,   3.34810000E+02,
     &132,338,   3.36270000E+02,     132,339,   3.38590000E+02,
     &133,329,   3.23270000E+02,     133,330,   3.24610000E+02,
     &133,331,   3.25060000E+02,     133,332,   3.26650000E+02,
     &133,333,   3.32800000E+02,     133,334,   3.35400000E+02,
     &133,335,   3.36340000E+02,     133,336,   3.38200000E+02/
      data (niz(i),nia(i),bie(i),i=9781,9796)/
     &133,337,   3.39410000E+02,     133,338,   3.41930000E+02,
     &133,339,   3.42570000E+02,     134,332,   3.37210000E+02,
     &134,333,   3.39080000E+02,     134,334,   3.39570000E+02,
     &134,335,   3.42190000E+02,     134,336,   3.42650000E+02,
     &134,337,   3.44650000E+02,     134,338,   3.45520000E+02,
     &134,339,   3.47870000E+02,     135,336,   3.50580000E+02,
     &135,337,   3.51040000E+02,     135,338,   3.52670000E+02,
     &135,339,   3.53550000E+02,     136,339,   3.59660000E+02/

      end

************************************************************************
*                                                                      *
      block data bd01                                                   
C/////////////////////////////////////////////////////////////////////
C****************This routine is originally in LAHET code**************
C  BD01
c      DATA of paring energy, shell correction, and Julich level
c       density parameter
C=====================================================================
C <variables> 
c    sz  :  shell correction for each Z
c    sn  :  shell correction for each N
c    pz  :  paring energy for each Z
c    pn  :  paring energy for each N
C  amean :  Julich level density parameter
C/////////////////////////////////////////////////////////////////////

      implicit doubleprecision(a-h,o-z)                                 

      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0, dph=.
     1 5d0, dp5=5.d0, dp10=1.d1, dpth=dp1/dp3, dppi=3.1415926535898d0,  
     2 dp2th=dp2/dp3)                                                   

      logical isz, isn                                                  
      parameter (inn=150, izz=98)                                       
      common /cook/ sz(izz), sn(inn), con(2), amean(240), pz(izz),      
     1 pn(inn), isz(izz), isn(inn)                                      

c                                                                       
c     data tables of cook et. al.  aaec/tm392, supplimented by g+c.     
c                                                                       
      data sz /8*dp0,-.11d0,-.81d0,-2.91d0,-4.17d0,-5.72d0,-7.8d0,-8.97d
     1 0,-9.7d0,-10.1d0,-10.7d0,-11.38d0,-12.07d0,-12.55d0,-13.24d0,-13.
     2 93d0,-14.71d0,-15.53d0,-16.37d0,-17.36d0,-18.6d0,-18.7d0,-18.01d0
     3 ,-17.87d0,-17.08d0,-16.6d0,-16.75d0,-16.5d0,-16.35d0,-16.22d0,-16
     4 .41d0,-16.89d0,-16.43d0,-16.68d0,-16.73d0,-17.45d0,-17.29d0,-17.4
     5 4d0,-17.82d0,-18.62d0,-18.27d0,-19.39d0,-19.91d0,-19.14d0,-18.26d
     6 0,-17.4d0,-16.42d0,-15.77d0,-14.37d0,-13.91d0,-13.1d0,-13.11d0,-1
     7 1.43d0,-10.89d0,-10.75d0,-10.62d0,-10.41d0,-10.21d0,-9.85d0,-9.47
     8 d0,-9.03d0,-8.61d0,-8.13d0,-7.46d0,-7.48d0,-7.2d0,-7.13d0,-7.06d0
     9 ,-6.78d0,-6.64d0,-6.64d0,-7.68d0,-7.89d0,-8.41d0,-8.49d0,-7.88d0,
     $ -6.3d0,-5.47d0,-4.78d0,-4.37d0,-4.17d0,-4.13d0,-4.32d0,-4.55d0,-5
     $ .04d0,-5.28d0,-6.06d0,-6.28d0,-6.87d0,-7.20d0,-7.74d0/           
      data (sn(i),i=1,110) /8*dp0,10.3d0,5.66d0,6.8d0,7.53d0,7.55d0,7.21
     1 d0,7.44d0,8.07d0,8.94d0,9.81d0,10.6d0,11.39d0,12.54d0,13.68d0,14.
     2 34d0,14.19d0,13.83d0,13.5d0,13.d0,12.13d0,12.6d0,13.26d0,14.13d0,
     3 14.92d0,15.52d0,16.38d0,17.16d0,17.55d0,18.03d0,17.59d0,19.03d0,1
     4 8.71d0,18.8d0,18.99d0,18.46d0,18.25d0,17.76d0,17.38d0,16.72d0,15.
     5 62d0,14.38d0,12.88d0,13.23d0,13.81d0,14.9d0,14.86d0,15.76d0,16.2d
     6 0,17.62d0,17.73d0,18.16d0,18.67d0,19.69d0,19.51d0,20.17d0,19.48d0
     7 ,19.98d0,19.83d0,20.2d0,19.72d0,19.87d0,19.24d0,18.44d0,17.61d0,1
     8 7.1d0,16.16d0,15.9d0,15.33d0,14.76d0,13.54d0,12.63d0,10.65d0,10.1
     9 d0,8.89d0,10.25d0,9.79d0,11.39d0,11.72d0,12.43d0,12.96d0,13.43d0,
     $ 13.37d0,12.96d0,12.11d0,11.92d0,11.d0,10.8d0,10.42d0,10.39d0,9.69
     $ d0,9.27d0,8.93d0,8.57d0,8.02d0,7.59d0,7.33d0,7.23d0,7.05d0,7.42d0
     $ ,6.75d0,6.6d0,6.38d0/                                            
      data (sn(i),i=111,150) /6.36d0,6.49d0,6.25d0,5.85d0,5.48d0,4.53d0,
     1 4.3d0,3.39d0,2.35d0,1.66d0,.81d0,0.46d0,-.96d0,-1.69d0,-2.53d0,-3
     2 .16d0,-1.87d0,-.41d0,.71d0,1.66d0,2.62d0,3.22d0,3.76d0,4.1d0,4.46
     3 d0,4.83d0,5.09d0,5.18d0,5.17d0,5.1d0,5.01d0,4.97d0,5.09d0,5.03d0,
     4 4.93d0,5.28d0,5.49d0,5.50d0,5.37d0,5.30d0/                       
C     data pz /dp0,5.44d0,dp0,2.76d0,dp0,3.34d0,dp0,2.7d0,dp0,2.5d0,dp0,
      data pz /dp0,5.44d0,dp0,2.76d0,dp0,3.34d0,0.,2.7d0,dp0,1.90d0,dp0,
C   1 2.46d0,dp0,2.09d0,dp0,1.62d0,dp0,1.62d0,dp0,1.83d0,dp0,1.73d0,dp0,
     1 2.12d0,dp0,2.09d0,dp0,1.62d0,dp0,1.62d0,dp0,1.83d0,dp0,1.73d0,dp0
     2 ,1.35d0,dp0,1.54d0,dp0,1.28d0,0.26d0,0.88d0,0.19d0,1.35d0,-.05d0,
     3 1.52d0,-.09d0,1.17d0,.04d0,1.24d0,0.29d0,1.09d0,.26d0,1.17d0,.23d
     4 0,1.15d0,-.08d0,1.35d0,0.34d0,1.05d0,.28d0,1.27d0,dp0,1.05d0,dp0,
     5 1.d0,.09d0,1.2d0,.2d0,1.4d0,.93d0,1.d0,-.2d0,1.19d0,.09d0,.97d0  
     6 ,dp0,.92d0,.11d0,.68d0,.05d0,.68d0,-.22d0,.79d0,.09d0,.69d0,.01d0
     7 ,.72d0,dp0,.4d0,.16d0,.73d0,dp0,.46d0,.17d0,.89d0,dp0,.79d0,dp0,.
     8 89d0,dp0,.81d0,-.06d0,.69d0,-.2d0,.71d0,-.12d0,.72d0,dp0,.77d0/  
      data (pn(i),i=1,125) /dp0,5.98d0,dp0,2.77d0,dp0,3.16d0,dp0,3.01d0 
C    1 ,dp0,2.5d0,dp0,2.67d0,dp0,1.8d0,dp0,1.67d0,dp0,1.86d0,dp0,2.04d0 
     1 ,dp0,1.68d0,0.,1.73d0,0.,2.17d0,dp0,1.67d0,dp0,1.86d0,dp0,2.04d0 
     2 ,dp0,1.64d0,dp0,1.44d0,dp0,1.54d0,dp0,1.3d0,dp0,1.27d0,dp0,1.29d0
     3 ,.08d0,1.41d0,-.08d0,1.5d0,-.05d0,2.24d0,-.47d0,1.43d0,-.15d0,1.4
     4 4d0,.06d0,1.56d0,.25d0,1.57d0,-.16d0,1.46d0,dp0,.93d0,.01d0,.62d0
     5 ,-.5d0,1.42d0,.13d0,1.52d0,-.65d0,.8d0,-.08d0,1.29d0,-.47d0,1.25d
     6 0,-.44d0,.97d0,.08d0,1.65d0,-.11d0,1.26d0,-.46d0,1.06d0,0.22d0,1.
     7 55d0,-.07d0,1.37d0,0.1d0,1.2d0,-.27d0,.92d0,-.35d0,1.19d0,dp0,1.0
     8 5d0,-.25d0,1.61d0,-.21d0,.9d0,-.21d0,.74d0,-.38d0,.72d0,-.34d0,.9
     9 2d0,-.26d0,.94d0,.01d0,.65d0,-.36d0,.83d0,.11d0,.67d0,.05d0,1.d0,
     $ .51d0,1.04d0,.33d0,.68d0,-.27d0,.81d0,.09d0,.75d0,.17d0,.86d0,.14
     $ d0,1.1d0,-.22d0,.84d0,-.47d0,.48d0,.02d0,.88d0,.24d0,.52d0,.27d0,
     $ .41d0,-.05d0/
      data (pn(i),i=126,150) /0.38d0,.15d0,.67d0,dp0,.61d0,dp0,.78d0,dp0
     1 ,.67d0,dp0,.67d0,dp0,.79d0,dp0,.6d0,.04d0,.64d0,-.06d0,.45d0,.05d
     2 0,.26d0,-.22d0,.39d0,dp0,.39d0/                                  
c                                                                       
c Julich mean value level density parameters                            
c                                                                       
      data (amean(i),i=1,100) /.125d0,.25d0,.375d0,.5d0,.625d0,.75d0,.87
     1 5d0,1.d0,1.125d0,1.25d0,1.375d0,1.5d0,1.625d0,1.75d0,1.875d0,2.d0
     2 ,2.125d0,2.25d0,2.375d0,3.94d0,2.63d0,2.75d0,2.88d0,3.55d0,4.35d0
     3 ,3.25d0,3.38d0,3.96d0,3.63d0,3.75d0,3.88d0,4.82d0,4.44d0,4.43d0,4
     4 .43d0,4.42d0,4.63d0,5.66d0,5.81d0,5.95d0,5.49d0,6.18d0,7.11d0,6.9
     5 6d0,7.2d0,7.73d0,6.41d0,6.85d0,6.77d0,6.91d0,7.26d0,7.2d0,6.86d0,
     6 8.06d0,7.81d0,7.82d0,8.41d0,8.13d0,7.19d0,8.35d0,8.13d0,8.02d0,8.
     7 93d0,8.9d0,9.69d0,9.65d0,10.55d0,9.38d0,9.72d0,10.66d0,11.98d0,12
     8 .76d0,12.1d0,12.86d0,13.03d0,12.81d0,12.54d0,12.65d0,12.d0,12.69d
     9 0,14.05d0,13.33d0,13.28d0,13.23d0,13.17d0,8.66d0,11.09d0,10.4d0,1
     $ 3.47d0,10.17d0,12.22d0,11.62d0,12.95d0,13.15d0,13.57d0,12.87d0,16
     $ .16d0,14.71d0,15.69d0,14.09d0/                                   
      data (amean(i),i=101,200) /18.56d0,16.22d0,16.67d0,17.13d0,17.d0,1
     1 6.86d0,15.33d0,15.61d0,16.77d0,17.93d0,17.45d0,16.97d0,17.88d0,17
     2 .58d0,15.78d0,16.83d0,17.49d0,16.03d0,15.08d0,16.74d0,17.74d0,17.
     3 43d0,18.14d0,17.06d0,19.01d0,17.02d0,17.02d0,17.02d0,18.51d0,17.2
     4 d0,16.75d0,16.97d0,16.94d0,16.91d0,17.69d0,15.55d0,14.56d0,14.35d
     5 0,16.55d0,18.29d0,17.8d0,17.05d0,21.31d0,19.15d0,19.51d0,19.87d0,
     6 20.39d0,20.9d0,21.85d0,22.89d0,25.68d0,24.64d0,24.91d0,23.24d0,22
     7 .85d0,22.46d0,21.98d0,21.64d0,21.75d0,21.85d0,21.77d0,21.69d0,23.
     8 74d0,21.35d0,23.03d0,20.66d0,21.81d0,20.77d0,22.18d0,22.58d0,22.5
     9 5d0,21.45d0,21.16d0,21.02d0,20.87d0,22.09d0,22.d0,21.28d0,23.05d0
     $ ,21.70d0,21.45d0,22.28d0,23.d0,22.11d0,23.56d0,22.83d0,24.88d0,22
     $ .64d0,23.27d0,23.89d0,23.92d0,23.94d0,21.16d0,22.3d0,21.75d0,21.1
     $ 9d0,20.72d0,20.24d0,21.34d0,19.d0/                               
      data (amean(i),i=201,240) /17.93d0,17.85d0,15.7d0,13.54d0,11.78d0,
     1 10.02d0,10.98d0,10.28d0,11.72d0,13.81d0,14.46d0,15.3d0,16.15d0,16
     2 .99d0,17.84d0,18.68d0,19.53d0,20.37d0,21.22d0,22.06d0,22.91d0,23.
     3 75d0,24.6d0,25.44d0,26.29d0,27.13d0,27.98d0,28.82d0,29.67d0,30.71
     4 d0,30.53d0,31.45d0,29.63d0,30.15d0,30.65d0,30.27d0,29.52d0,30.08d
     5 0,29.8d0,29.87d0/
c                                                                       
c flags for deformed nuclei                                             
c                                                                       
      data isz /53*.false.,25*.true.,7*.false.,13*.true./               
      data isn /85*.false.,37*.true.,7*.false.,21*.true./               
      data con /.142d0,.12d0/                                           
c                                                                       
      end                                                               

************************************************************************
*                                                                      *
      block data bdejc
C/////////////////////////////////////////////////////////////////////
C  BDEJC
C    data of mass number, charge, spin of the ejectiles
C=====================================================================
C <Variables>
C   ifa    :   mass number of emittor                           (OUT)
C   ifz    :   charge of emittor                                (OUT)
C  omega   :   spin of emittor                                  (OUT)
C/////////////////////////////////////////////////////////////////////

      implicit doubleprecision(a-h,o-z)

      common /ejectl/ omega(70),ifa(70),ifz(70)

C***omega=spin
      data omega /.5d0,.5d0,1.d0,.5d0,.5d0,0.d0,0.d0,0.d0,
C                 n     p   d    t    He3  He4  He6  He8
     L     1.d0,1.5d0,2.d0,1.5d0,
C           Li6  Li7  Li8   Li9
     B     1.5d0,1.5d0,0.d0,.5d0,0.d0,2.d0,3.d0,1.5d0,1.d0,1.5d0,
C           Be7   Be9  Be10 Be11 Be12  B8   B10  B11   B12  B13
     C     0.d0,1.5d0,0d0,.5d0,0d0,.5d0,0.d0,
C          C10  C11  C12  C13  C14  C15, C16
     N     1.d0,.5d0,1.d0,.5d0,2.d0,.5d0,
C          N12  N13  N14  N15  N16  N17
     O     0.d0,.5d0,0.d0,2.5d0,0.d0,2.5d0,0.d0,
C          O14  O15  O16  O17   O18  O19   O20
     F     2.5d0,1.d0,.5d0,2.d0,2.5d0,
C          F17   F18  F19   F20  F21
     e     0.d0,.5d0,0.d0,1.5d0,0.d0,2.5d0,0.d0,
C          Ne18 Ne19  Ne20 Ne21 Ne22 Ne23 Ne24
     a     1.5d0,3.d0,1.5d0,4.d0,2.5d0,
C          Na21  Na22 Na23  Na24 Na24
     M     0.d0,1.5d0,0.d0,2.5d0,0.d0,.5d0,0.d0,
C          Mg22  Mg23 Mg24 Mg25  Mg26 Mg27 Mg28
     &     4*0.d0/
      data ifa /1,1,2,3,3,4,6,8,6,7,8,9,7,9,10,11,12,8,10,11,12,13,
     C     10,11,12,13,14,15,16,
     N     12,13,14,15,16,17,
     O     14,15,16,17,18,19,20,
     F     17,18,19,20,21,
     e     18,19,20,21,22,23,24,
     a     21,22,23,24,25,
     M     22,23,24,25,26,27,28,4*0/
      data ifz/0,3*1,4*2,4*3,5*4,5*5,
     &     7*6,6*7,7*8,5*9,7*10,5*11,7*12,4*0/
      end


************************************************************************
*                                                                      *
