!        csampGIntL:  sample photon interaction length.
       subroutine csampGIntL
       use modXsecMedia
!
!        pair, compton, photo-electric eff. photo-hadron
!
       implicit none
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zevhnv.h"
#include  "Zelemagp.h"

!

       real*8  t, tkgpm2, cxai, den, cvh2den, eg
       real*8  prob, u, cmPairMFP, mfp, xs
       real*8  tcomp, tphot, tpair, tgp, tcoh
       real*8 xprob(5), txray(5)
            
       real*4  xsec(5)  !  coh, incoh,  P%E  1/(g/cm2)  
       real*8 xaimin/0.1/
!////////////////
       integer,save::nzero=0
!/////////////
!     
       eg = TrackBefMove%p%fm%p(4)
       if(LpmEffect .and. eg .gt. LpmPairEmin) then
!          den = cthick2den(TrackBefMove.pos.depth)
          den = cvh2den(TrackBefMove%pos%height)  ! better
          call cpairLPMXsec(eg, den, prob)
          call rndc(u)
          t = -log(u) /prob
       elseif( eg .gt. 1.022d-3 ) then
          if(eg .le. Excom2 ) then
             call cXrayp(eg, 4, 5,  xprob, txray)
             prob= xprob(4)+xprob(5)  !  1/r%l
             if( prob > 0. ) then
                call rndc(u)
                t = -log(u)/prob !  r%l
             else
                call cpairPath(eg, t)
             endif
          else             
             call cpairPath(eg, t)
          endif
       else
          t = Infty
       endif
       call csetIntInf(t*X0, .false., 'pair')

       if(eg .le. Excom1 )  then
!           use Xcom data
          call cXrayp(eg,  1, 3,  xprob, txray)
          call csetIntInf(txray(2)*X0, .false., 'compt')
          call csetIntInf(txray(3)*X0, .false., 'photoe')
          call csetIntInf(txray(1)*X0, .false., 'cohs')
       else
          if( eg .lt. MaxComptonE ) then
             call ccomptPath(eg, prob, t) 
          else
             t = Infty
          endif
          call csetIntInf(t*X0, .false., 'compt')
          if( eg .lt. MaxPhotoE ) then
             call cphotoEEPath(eg, prob, t)
             call csetIntInf(t*X0, .false., 'photoe')
          endif
       endif
!           photo hadron prod.
       if( eg .gt. MinPhotoProdE .and. HowPhotoP > 0 ) then
          call cgetPhotoPxs(ActiveMdl2, TrackBefMove%p,
     *       media(1), xs, mfp)    ! xs in mb. mfp in kg/m2
          call rndc(u)
          tkgpm2 = -mfp*log(u)
!!!          call cghPath(eg,    tkgpm2)  ! old interface
          call csetIntInf(tkgpm2, .false., 'photop')
       endif

!           magnetic  pair
       if(MagPair .eq. 1 .and. eg .gt.  MagPairEmin) then
          Xai = cxai(TrackBefMove%p, Mag)
          if(Xai .gt. xaimin) then
             call rndc(u)
             t = -log(u) * cmPairMFP(eg, Xai)
             call csetIntInf(t, .true., 'mpair')
          endif
       endif
       end
