!           convert cosmos code once into kf code
!           and kf code is converted into target code
      integer  code, subcode, charge, kf, ccode
      character*3 inc, outc
      
      integer idtrafo
      write(0,*) '  cosmos code -> kf code -> target code'
      write(0,*) '  '
      write(0,*) 'Enter  target code by selecting from'
      write(0,*) " pdg  qgs  nxs  ghe sib cor"
      write(0,*) " here epos =nxs cor=Corsika=Geant3"
!.....'nxs' = epos
!.....'pdg' = PDG 1996
!.....'qgs' = QGSJet
!.....'ghe' = Gheisha
!.....'sib' = Sibyll
!.....'cor' = Corsika (GEANT)
      inc  = 'pdg' 
      read(*, *) outc
      write(0,*)'cos--> ', inc, "-->",outc
      do while (.true.)
         write(0,*) 'Enter code, subcode, charge'
         read(*,*,end=100) code, subcode, charge
         write(0,*) code, subcode, charge
         call ccos2kf(code, subcode, charge, kf)
         write(0,*) ' kf =',kf
         ccode=idtrafo(inc, outc, kf)
         write(0,*) ' target code =', ccode
         write(0,*)
      enddo
 100   continue
       end

!------------------------------------------------------------------------------
      integer function idtrafo(code1,code2,idi)
!------------------------------------------------------------------------------
!.....tranforms id of code1 (=idi) into id of code2 (=idtrafocx)
!.....supported codes:
!.....'nxs' = epos
!.....'pdg' = PDG 1996
!.....'qgs' = QGSJet
!.....'ghe' = Gheisha
!.....'sib' = Sibyll
!.....'cor' = Corsika (GEANT)

! --- ighenex(I)=EPOS CODE CORRESPONDING TO GHEISHA CODE I ---
      common /ighnx/ ighenex(35)
      data ighenex/
     $               10,   11,   -12,    12,   -14,    14,   120,   110,
     $             -120,  130,    20,   -20,  -130,  1120, -1120,  1220,
     $            -1220, 2130, -2130,  1130,  1230,  2230, -1130, -1230,
     $            -2230, 1330,  2330, -1330, -2330,    17,    18,    19,
     $            3331, -3331,  30/

! --- DATA STMTS. FOR GEANT/GHEISHA PARTICLE CODE CONVERSIONS ---
! --- KIPART(I)=GHEISHA CODE CORRESPONDING TO GEANT   CODE I ---
! --- IKPART(I)=GEANT   CODE CORRESPONDING TO GHEISHA CODE I ---
      DIMENSION        KIPART(48),IKPART(35)
      DATA KIPART/
     $               1,   3,   4,   2,   5,   6,   8,   7,
     $               9,  12,  10,  13,  16,  14,  15,  11,
     $              35,  18,  20,  21,  22,  26,  27,  33,
     $              17,  19,  23,  24,  25,  28,  29,  34,
     $              35,  35,  35,  35,  35,  35,  35,  35,
     $              35,  35,  35,  35,  30,  31,  32,  35/

      DATA IKPART/
     $               1,   4,   2,   3,   5,   6,   8,   7,
     $               9,  11,  16,  10,  12,  14,  15,  13,
     $              25,  18,  26,  19,  20,  21,  27,  28,
     $              29,  22,  23,  30,  31,  45,  46,  47,
     $              24,  32,  48/
!-------------------------------------------------------------------------------

      character*3 code1,code2
      parameter (ncode=5,nidt=334)
      integer idt(ncode,nidt)
      double precision drangen,dummy

      data ((idt(i,j),i=1,ncode),j= 1,18)/
     *          1,2,99,99,99             !u quark
     *     ,    2,1,99,99,99             !d
     *     ,    3,3,99,99,99             !s
     *     ,    4,4,99,99,99             !c
     *     ,    5,5,99,99,99             !b
     *     ,    6,6,99,99,99             !t
     *     ,   10,22,99,1,1              !gamma
     *     ,   9 ,21,99,99,99            !gluon
     *     ,   12,11,11,4,3              !e-
     *     ,  -12,-11,-11,3,2            !e+
     *     ,   11,12,99,2,15             !nu_e-
     *     ,  -11,-12,99,-2,16           !nu_e+
     *     ,   14,13,99,6,5              !mu-
     *     ,  -14,-13,99,5,4             !mu+
     *     ,   13,14,99,2,17             !nu_mu-
     *     ,  -13,-14,99,-2,18           !nu_mu+
     *     ,   16,15,99,99,19            !tau-
     *     ,   15,16,99,99,20 /          !nu_tau-
      data ((idt(i,j),i=1,ncode),j= 19,40)/
     *        110,111,0,8,6              !pi0
     *     ,  120,211,1,7,7              !pi+
     *     , -120,-211,-1,9,8            !pi-
     *     ,  220,221,10,99,23           !eta
     *     ,  130,321,4,10,9             !k+
     *     , -130,-321,-4,13,10          !k-
     *     ,  230,311,5,11,21            !k0
     *     , -230,-311,-5,12,22          !k0b
     *     ,   20,310,5,11,12            !kshort
     *     ,  -20,-310,-5,12,11          !klong
     *     ,  330,331,99,99,24           !etaprime
     *     ,  111,113,99,99,27           !rho0
     *     ,  121,213,99,99,25           !rho+
     *     , -121,-213,99,99,26          !rho-
     *     ,  221,223,99,99,32           !omega
     *     ,  131,323,99,99,28           !k*+
     *     , -131,-323,99,99,29          !k*-
     *     ,  231,313,99,99,30           !k*0
     *     , -231,-313,99,99,31          !k*0b
     *     ,  331,333,99,99,33           !phi
     $     , -140,421,8,99,99            !D0(1.864)
     $     ,  240,-411,7,99,99 /         !D(1.869)-
      data ((idt(i,j),i=1,ncode),j= 41,59)/
     *       1120,2212,2,14,13           !proton
     *     , 1220,2112,3,16,14           !neutron
     *     , 2130,3122,6,18,39           !lambda
     *     , 1130,3222,99,20,34          !sigma+
     *     , 1230,3212,99,21,35          !sigma0
     *     , 2230,3112,99,22,36          !sigma-
     *     , 1330,3322,99,26,37          !xi0
     *     , 2330,3312,99,27,38          !xi-
     *     , 1111,2224,99,99,40          !delta++
     *     , 1121,2214,99,99,41          !delta+
     *     , 1221,2114,99,99,42          !delta0
     *     , 2221,1114,99,99,43          !delta-
     *     , 1131,3224,99,99,44          !sigma*+
     *     , 1231,3214,99,99,45          !sigma*0
     *     , 2231,3114,99,99,46          !sigma*-
     *     , 1331, 3324,99,99,47         !xi*0
     *     , 2331, 3314,99,99,48         !xi*-
     *     , 3331, 3334,99,24,49         !omega-
     $     , 2140, 4122,9,99,99   /      !LambdaC(2.285)+
      data ((idt(i,j),i=1,ncode),j= 60,64)/
     $      17,99,99,30,1002             !  Deuteron
     $     ,18,99,99,31,1003             !  Triton
     $     ,19,99,99,32,1004             !  Alpha
     $     ,0,99,99,0,0                  !  Air
     *     ,99,99,99,99,99 /             !  unknown
      data ((idt(i,j),i=1,ncode),j= 65,79)/
     $       1112,32224,99,99,99         !  Delta(1600)++
     $     , 1112, 2222,99,99,99         !  Delta(1620)++
     $     , 1113,12224,99,99,99         !  Delta(1700)++
     $     , 1114,12222,99,99,99         !  Delta(1900)++
     $     , 1114, 2226,99,99,99         !  Delta(1905)++
     $     , 1114,22222,99,99,99         !  Delta(1910)++
     $     , 1114,22224,99,99,99         !  Delta(1920)++
     $     , 1114,12226,99,99,99         !  Delta(1930)++
     $     , 1114, 2228,99,99,99         !  Delta(1950)++
     $     , 2222,31114,99,99,99         !  Delta(1600)-
     $     , 2222, 1112,99,99,99         !  Delta(1620)-
     $     , 2223,11114,99,99,99         !  Delta(1700)-
     $     , 2224,11112,99,99,99         !  Delta(1900)-
     $     , 2224, 1116,99,99,99         !  Delta(1905)-
     $     , 2224,21112,99,99,99   /     !  Delta(1910)-
      data ((idt(i,j),i=1,ncode),j= 80,94)/
     $      2224,21114,99,99,99          !  Delta(1920)-
     $     ,2224,11116,99,99,99          !  Delta(1930)-
     $     ,2224, 1118,99,99,99          !  Delta(1950)-
     $     ,1122,12212,99,99,99          !  N(1440)+
     $     ,1123, 2124,99,99,99          !  N(1520)+
     $     ,1123,22212,99,99,99          !  N(1535)+
     $     ,1124,32214,99,99,99          !  Delta(1600)+
     $     ,1124, 2122,99,99,99          !  Delta(1620)+
     $     ,1125,32212,99,99,99          !  N(1650)+
     $     ,1125, 2216,99,99,99          !  N(1675)+
     $     ,1125,12216,99,99,99          !  N(1680)+
     $     ,1126,12214,99,99,99          !  Delta(1700)+
     $     ,1127,22124,99,99,99          !  N(1700)+
     $     ,1127,42212,99,99,99          !  N(1710)+
     $     ,1127,32124,99,99,99   /      !  N(1720)+
      data ((idt(i,j),i=1,ncode),j= 95,109)/
     $      1128,12122,99,99,99          !  Delta(1900)+
     $     ,1128, 2126,99,99,99          !  Delta(1905)+
     $     ,1128,22122,99,99,99          !  Delta(1910)+
     $     ,1128,22214,99,99,99          !  Delta(1920)+
     $     ,1128,12126,99,99,99          !  Delta(1930)+
     $     ,1128, 2218,99,99,99          !  Delta(1950)+
     $     ,1222,12112,99,99,99          !  N(1440)0
     $     ,1223, 1214,99,99,99          !  N(1520)0
     $     ,1223,22112,99,99,99          !  N(1535)0
     $     ,1224,32114,99,99,99          !  Delta(1600)0
     $     ,1224, 1212,99,99,99          !  Delta(1620)0
     $     ,1225,32112,99,99,99          !  N(1650)0
     $     ,1225, 2116,99,99,99          !  N(1675)0
     $     ,1225,12116,99,99,99          !  N(1680)0
     $     ,1226,12114,99,99,99   /      !  Delta(1700)0
      data ((idt(i,j),i=1,ncode),j= 110,124)/
     $      1227,21214,99,99,99          !  N(1700)0
     $     ,1227,42112,99,99,99          !  N(1710)0
     $     ,1227,31214,99,99,99          !  N(1720)0
     $     ,1228,11212,99,99,99          !  Delta(1900)0
     $     ,1228, 1216,99,99,99          !  Delta(1905)0
     $     ,1228,21212,99,99,99          !  Delta(1910)0
     $     ,1228,22114,99,99,99          !  Delta(1920)0
     $     ,1228,11216,99,99,99          !  Delta(1930)0
     $     ,1228, 2118,99,99,99          !  Delta(1950)0
     $     ,1233,13122,99,99,99          !  Lambda(1405)0
     $     ,1234, 3124,99,99,99          !  Lambda(1520)0
     $     ,1235,23122,99,99,99          !  Lambda(1600)0
     $     ,1235,33122,99,99,99          !  Lambda(1670)0
     $     ,1235,13124,99,99,99          !  Lambda(1690)0
     $     ,1236,13212,99,99,99  /       !  Sigma(1660)0
      data ((idt(i,j),i=1,ncode),j= 125,139)/
     $      1236,13214,99,99,99          !  Sigma(1670)0
     $     ,1237,23212,99,99,99          !  Sigma(1750)0
     $     ,1237, 3216,99,99,99          !  Sigma(1775)0
     $     ,1238,43122,99,99,99          !  Lambda(1800)0
     $     ,1238,53122,99,99,99          !  Lambda(1810)0
     $     ,1238, 3126,99,99,99          !  Lambda(1820)0
     $     ,1238,13126,99,99,99          !  Lambda(1830)0
     $     ,1238,23124,99,99,99          !  Lambda(1890)0
     $     ,1239,13216,99,99,99          !  Sigma(1915)0
     $     ,1239,23214,99,99,99          !  Sigma(1940)0
     $     ,1132,13222,99,99,99          !  Sigma(1660)+
     $     ,1132,13224,99,99,99          !  Sigma(1670)+
     $     ,1133,23222,99,99,99          !  Sigma(1750)+
     $     ,1133,3226,99,99,99           !  Sigma(1775)+
     $     ,1134,13226,99,99,99   /      !  Sigma(1915)+
      data ((idt(i,j),i=1,ncode),j= 140,146)/
     $      1134,23224,99,99,99          !  Sigma(1940)+
     $     ,2232,13112,99,99,99          !  Sigma(1660)-
     $     ,2232,13114,99,99,99          !  Sigma(1670)-
     $     ,2233,23112,99,99,99          !  Sigma(1750)-
     $     ,2233,3116,99,99,99           !  Sigma(1775)-
     $     ,2234,13116,99,99,99          !  Sigma(1915)-
     $     ,2234,23114,99,99,99  /       !  Sigma(1940)-
      data ((idt(i,j),i=1,ncode),j= 147,159)/
     $      5,7,99,99,99                 !  quark b'
     $     ,6,8,99,99,99                 !  quark t'
     $     ,16,17,99,99,99               !  lepton tau'
     $     ,15,18,99,99,99               !  lepton nu' tau
     $     ,90,23,99,99,99               !  Z0
     $     ,80,24,99,99,99               !  W+
     $     ,81,25,99,99,99               !  h0
     $     ,85,32,99,99,99               !  Z'0
     $     ,86,33,99,99,99               !  Z''0
     $     ,87,34,99,99,99               !  W'+
     $     ,82,35,99,99,99               !  H0
     $     ,83,36,99,99,99               !  A0
     $     ,84,37,99,99,99   /           !  H+
      data ((idt(i,j),i=1,ncode),j= 160,184)/
     $      1200,2101,99,99,99           !  diquark ud_0
     $     ,2300,3101,99,99,99           !  diquark sd_0
     $     ,1300,3201,99,99,99           !  diquark su_0
     $     ,2400,4101,99,99,99           !  diquark cd_0
     $     ,1400,4201,99,99,99           !  diquark cu_0
     $     ,3400,4301,99,99,99           !  diquark cs_0
     $     ,2500,5101,99,99,99           !  diquark bd_0
     $     ,1500,5201,99,99,99           !  diquark bu_0
     $     ,3500,5301,99,99,99           !  diquark bs_0
     $     ,4500,5401,99,99,99           !  diquark bc_0
     $     ,2200,1103,99,99,99           !  diquark dd_1
     $     ,1200,2103,99,99,99           !  diquark ud_1
     $     ,1100,2203,99,99,99           !  diquark uu_1
     $     ,2300,3103,99,99,99           !  diquark sd_1
     $     ,1300,3203,99,99,99           !  diquark su_1
     $     ,3300,3303,99,99,99           !  diquark ss_1
     $     ,2400,4103,99,99,99           !  diquark cd_1
     $     ,1400,4203,99,99,99           !  diquark cu_1
     $     ,3400,4303,99,99,99           !  diquark cs_1
     $     ,4400,4403,99,99,99           !  diquark cc_1
     $     ,2500,5103,99,99,99           !  diquark bd_1
     $     ,1500,5203,99,99,99           !  diquark bu_1
     $     ,3500,5303,99,99,99           !  diquark bs_1
     $     ,4500,5403,99,99,99           !  diquark bc_1
     $     ,5500,5503,99,99,99 /         !  diquark bb_1
      data ((idt(i,j),i=1,ncode),j= 185,188)/
     $      800000091,91,99,99,99      !  parton system in cluster fragmentation  (pythia)
     $     ,800000092,92,99,99,99      !  parton system in string fragmentation  (pythia)
     $     ,800000093,93,99,99,99      !  parton system in independent system  (pythia)
     $     ,800000094,94,99,99,99 /    !  CMshower (pythia)
      data ((idt(i,j),i=1,ncode),j= 189,208)/
     $      -340,431,99,99,99            !  Ds+
     $     ,340,-431,99,99,99            !  Ds-
     $     ,-241,413,99,99,99            !  D*+
     $     ,241,-413,99,99,99            !  D*-
     $     ,-141,423,99,99,99            !  D*0
     $     ,141,-423,99,99,99            !  D*0b
     $     ,-341,433,99,99,99            !  Ds*+
     $     ,341,-433,99,99,99            !  Ds*-
     $     ,250,511,99,99,99             !  B0
     $     ,150,521,99,99,99             !  B+
     $     ,350,531,99,99,99             !  B0s+
     $     ,450,541,99,99,99             !  Bc+
     $     ,251,513,99,99,99             !  B*0
     $     ,151,523,99,99,99             !  B*+
     $     ,351,533,99,99,99             !  B*0s+
     $     ,451,543,99,99,99             !  B*c+
     $     ,440,441,99,99,99             !  etac
     $     ,441,443,99,99,99             !  J/psi
     $     ,550,551,99,99,99             !  etab
     $     ,551,553,99,99,99   /         !  Upsilon
      data ((idt(i,j),i=1,ncode),j= 209,264)/
     $      2240,4112,99,99,99           !  sigmac0
     $     ,1240,4212,99,99,99           !  sigmac+
     $     ,1140,4222,99,99,99           !  sigmac++
     $     ,2241,4114,99,99,99           !  sigma*c0
     $     ,1241,4214,99,99,99           !  sigma*c+
     $     ,1141,4224,99,99,99           !  sigma*c++
     $     ,3240,4132,99,99,99           !  Xic0
     $     ,2340,4312,99,99,99           !  Xi'c0
     $     ,3140,4232,99,99,99           !  Xic+
     $     ,1340,4322,99,99,99           !  Xi'c+
     $     ,3340,4332,99,99,99           !  omegac0
     $     ,2341,4314,99,99,99           !  Xi*c0
     $     ,1341,4324,99,99,99           !  Xi*c+
     $     ,3341,4334,99,99,99           !  omega*c0
     $     ,2440,4412,99,99,99           !  dcc
     $     ,2441,4414,99,99,99           !  dcc*
     $     ,1440,4422,99,99,99           !  ucc
     $     ,1441,4424,99,99,99           !  ucc*
     $     ,3440,4432,99,99,99           !  scc
     $     ,3441,4434,99,99,99           !  scc*
     $     ,4441,4444,99,99,99           !  ccc*
     $     ,2250,5112,99,99,99           !  sigmab-
     $     ,2150,5122,99,99,99           !  lambdab0
     $     ,3250,5132,99,99,99           !  sdb
     $     ,4250,5142,99,99,99           !  cdb
     $     ,1250,5212,99,99,99           !  sigmab0
     $     ,1150,5222,99,99,99           !  sigmab+
     $     ,3150,5232,99,99,99           !  sub
     $     ,4150,5242,99,99,99           !  cub
     $     ,2350,5312,99,99,99           !  dsb
     $     ,1350,5322,99,99,99           !  usb
     $     ,3350,5332,99,99,99           !  ssb
     $     ,4350,5342,99,99,99           !  csb
     $     ,2450,5412,99,99,99           !  dcb
     $     ,1450,5422,99,99,99           !  ucb
     $     ,3450,5432,99,99,99           !  scb
     $     ,4450,5442,99,99,99           !  ccb
     $     ,2550,5512,99,99,99           !  dbb
     $     ,1550,5522,99,99,99           !  ubb
     $     ,3550,5532,99,99,99           !  sbb
     $     ,3550,5542,99,99,99           !  scb
     $     ,2251,5114,99,99,99           !  sigma*b-
     $     ,1251,5214,99,99,99           !  sigma*b0
     $     ,1151,5224,99,99,99           !  sigma*b+
     $     ,2351,5314,99,99,99           !  dsb*
     $     ,1351,5324,99,99,99           !  usb*
     $     ,3351,5334,99,99,99           !  ssb*
     $     ,2451,5414,99,99,99           !  dcb*
     $     ,1451,5424,99,99,99           !  ucb*
     $     ,3451,5434,99,99,99           !  scb*
     $     ,4451,5444,99,99,99           !  ccb*
     $     ,2551,5514,99,99,99           !  dbb*
     $     ,1551,5524,99,99,99           !  ubb*
     $     ,3551,5534,99,99,99           !  sbb*
     $     ,4551,5544,99,99,99           !  cbb*
     $     ,5551,5554,99,99,99  /        !  bbb*
      data ((idt(i,j),i=1,ncode),j= 265,295)/
     $      123,10213,99,99,99           !  b1
     $     ,122,10211,99,99,99           !  a0+
     $     ,233,10313,99,99,99           !  K0_1
     $     ,232,10311,99,99,99           !  K*0_1
     $     ,133,10323,99,99,99           !  K+_1
     $     ,132,10321,99,99,99           !  K*+_1
     $     ,143,10423,99,99,99           !  D0_1
     $     ,132,10421,99,99,99           !  D*0_1
     $     ,243,10413,99,99,99           !  D+_1
     $     ,242,10411,99,99,99           !  D*+_1
     $     ,343,10433,99,99,99           !  D+s_1
     $     ,342,10431,99,99,99           !  D*0s+_1
     $     ,223,10113,99,99,99           !  b_10
     $     ,222,10111,99,99,99           !  a_00
     $     ,113,10223,99,99,99           !  h_10
     $     ,112,10221,99,99,99           !  f_00
     $     ,333,10333,99,99,99           !  h'_10
     $     ,332,10331,99,99,99           !  f'_00
     $     ,443,10443,99,99,99           !  h_1c0
     $     ,442,10441,99,99,99           !  Xi_0c0
     $     ,444,10443,99,99,99           !  psi'
     $     ,253,10513,99,99,99           !  db_10
     $     ,252,10511,99,99,99           !  db*_00
     $     ,153,10523,99,99,99           !  ub_10
     $     ,152,10521,99,99,99           !  ub*_00
     $     ,353,10533,99,99,99           !  sb_10
     $     ,352,10531,99,99,99           !  sb*_00
     $     ,453,10543,99,99,99           !  cb_10
     $     ,452,10541,99,99,99           !  cb*_00
     $     ,553,10553,99,99,99           !  Upsilon'
     $     ,552,10551,99,99,99  /        !  Upsilon'*
      data ((idt(i,j),i=1,ncode),j= 296,325)/
     $      124,20213,99,99,99           !  a_1+
     $     ,125,215,99,99,99             !  a_2+
     $     ,234,20313,99,99,99           !  K*0_1
     $     ,235,315,99,99,99             !  K*0_2
     $     ,134,20323,99,99,99           !  K*+_1
     $     ,135,325,99,99,99             !  K*+_2
     $     ,144,20423,99,99,99           !  D*_10
     $     ,135,425,99,99,99             !  D*_20
     $     ,244,20413,99,99,99           !  D*_1+
     $     ,245,415,99,99,99             !  D*_2+
     $     ,344,20433,99,99,99           !  D*_1s+
     $     ,345,435,99,99,99             !  D*_2s+
     $     ,224,20113,99,99,99           !  a_10
     $     ,225,115,99,99,99             !  a_20
     $     ,114,20223,99,99,99           !  f_10
     $     ,115,225,99,99,99             !  f_20
     $     ,334,20333,99,99,99           !  f'_10
     $     ,335,335,99,99,99             !  f'_20
     $     ,444,20443,99,99,99           !  Xi_1c0
     $     ,445,445,99,99,99             !  Xi_2c0
     $     ,254,20513,99,99,99           !  db*_10
     $     ,255,515,99,99,99             !  db*_20
     $     ,154,20523,99,99,99           !  ub*_10
     $     ,155,525,99,99,99             !  ub*_20
     $     ,354,20533,99,99,99           !  sb*_10
     $     ,355,535,99,99,99             !  sb*_20
     $     ,454,20543,99,99,99           !  cb*_10
     $     ,455,545,99,99,99             !  cb*_20
     $     ,554,20553,99,99,99           !  bb*_10
     $     ,555,555,99,99,99    /        !  bb*_20
      data ((idt(i,j),i=1,ncode),j= 326,nidt)/
     $      11099,9900110,99,99,99       !  diff pi0 state
     $     ,12099,9900210,99,99,99       !  diff pi+ state
     $     ,22099,9900220,99,99,99       !  diff omega state
     $     ,33099,9900330,99,99,99       !  diff phi state
     $     ,44099,9900440,99,99,99       !  diff J/psi state
     $     ,112099,9902210,99,99,99      !  diff proton state
     $     ,122099,9902110,99,99,99      !  diff neutron state
     $     ,800000110,110,99,99,99       !  Reggeon
     $     ,800000990,990,99,99,99 /      !  Pomeron




      nidtmx=64
      id1=idi
      if(code1.eq.'nxs')then
        i=1
      elseif(code1.eq.'pdg')then
        i=2
      elseif(code1.eq.'qgs')then
        i=3
      elseif(code1.eq.'ghe')then
        id1=ighenex(id1)
        i=1
      elseif(code1.eq.'sib')then
        i=5
      elseif(code1.eq.'cor')then
        id1=kipart(id1)
        id1=ighenex(id1)
        i=1
      else
        stop "unknown code in idtrafo"
      endif
      if(code2.eq.'nxs')then
        j=1
        ji=j
        if(i.eq.5.and.id1.gt.1004)then               !nucleus from Sibyll
          idtrafo=(id1-1000)*100
          return
        elseif(id1.eq.130.and.i.eq.2)then
          idtrafo=-20
          return
        endif
        if(i.eq.2) nidtmx=nidt
      elseif(code2.eq.'pdg')then
        j=2
        ji=j
        if(id1.eq.-20.and.i.eq.1)then
          idtrafo=130
          return
        endif
        if(i.eq.1) nidtmx=nidt
      elseif(code2.eq.'qgs')then
        j=3
        ji=j
      elseif(code2.eq.'ghe')then
        j=4
        ji=j
      elseif(code2.eq.'sib')then
        j=5
        ji=j
      elseif(code2.eq.'cor')then
        j=4
        ji=6
      else
        stop "unknown code in idtrafo"
      endif
      iad1=abs(id1)
      isi=sign(1,id1)

      do n=1,nidtmx
        if(iad1.eq.abs(idt(i,n)))then
          m=1
          if(n+m.lt.nidt)then
            do while(abs(idt(i,n+m)).eq.iad1)
              m=m+1
            enddo
          endif
          mm=0
          if(m.gt.1)then
            if(m.eq.2.and.idt(i,n)*idt(i,n+1).lt.0)then
              if(id1.eq.idt(i,n+1))mm=1
              isi=1
            else
              mm=int(drangen(dummy)*dble(m))
            endif
          endif
          idtrafo=idt(j,n+mm)*isi
          if(abs(idtrafo).eq.99)call utstop('New particle not allowed ')
          if(idtrafo.lt.0.and.j.eq.4)then         !gheisha  id always >0
            iadtr=abs(idtrafo)
            if(iadtr.ge.20.and.iadtr.le.22)then
              idtrafo=iadtr+3
            elseif(iadtr.eq.26.or.iadtr.eq.27)then
              idtrafo=iadtr+2
            elseif(iadtr.ge.14)then
              idtrafo=iadtr+1
            else
              idtrafo=iadtr
            endif
          endif
          if(ji.eq.6)idtrafo=ikpart(idtrafo)
          return
        end if
      enddo

      !print *, 'idtrafo:',code1,'->', code2,id1,' not found.   '
      !stop'(2403200818)        '
      idtrafo=0

      end
      real*8 function drangen(u)
      real*8 u
      drangen= rndc(u)
      end
      subroutine utstop(msg)
      character*(*)  msg
      write(0,*) msg
      end

      
      
