!  this media is used as a bridge (workaround) to block all interaction
!  routines in Cosmos so that Epics needs not be modified even when
!  interaction routines are added or deleted etc  while Epics can 
!  inform the media info to the interacton routines
!
module modXsecMedia
  type element
     real(8)::A ! mass #
     real(8)::Z  ! charge
     real(8)::No  ! charge
     real(8)::nsigma ! NoxXsec
  end type element
  type xsmedia
     character(len=8):: name  ! media name
     integer:: noOfElem  !  # of elements composing a mdium
     real(8):: xs      ! sigma for this medium (mb)
     real(8)::mbtoPkgrm  !  mb to kg/m^2 conversion factor
!     real(8)::colA
!     real(8)::colZ
!     real(8)::colXs
     type(element),allocatable::elem(:)
  end type xsmedia
  type(xsmedia),allocatable:: media(:)
  integer,save:: mediumNo  ! currently treated medium #
                           ! collision will happen in this medium
                           ! For application in Cosmos, always 1
                           ! which is Air 
  integer,save:: colElemNo ! collision happened on this element # 
                      ! in the  medium with mediumNo
  integer,save:: TargetNucleonNo  ! collision element's A.
                   !  use this one  if integral value is better.
                   !  this is not neccesarily  =
                   !        media(mediumNo)%elem(colElem)%A
                   ! former colA
  integer,save:: TargetProtonNo  ! Z of the target. former colZ
                       !  = media(mediumNo)%elem(colElemNo)%Z
  real(8),save:: TargetXs       ! Xsection of the target. former
                                ! colXs  mb
  
  
contains

  subroutine cAllocXsMediaArray(NoOfMedia)
!       reserve specified # of media for xsection calculation
    implicit none
    integer,intent(in):: NoOfMedia
    allocate( media(NoOfMedia) )
  end subroutine cAllocXsMediaArray

  subroutine cAllocXsElemArray(n, nelem)
!     reserve specified # of elements area for the specified
!     medium 
    implicit none
    integer,intent(in)::n ! n-th medium
    integer,intent(in)::nelem ! # of element composing this mediuam
    allocate( media(n)%elem(nelem) )
  end subroutine cAllocXsElemArray
end module modXsecMedia

!program main
!  use modXsecMedia
!  implicit none
!  call cAllocXsMediaArray( 20 )
!  call callocXsElemArray(2, 3)
!  media(2)%elem(1)%A=10
!  media(2)%elem(2)%A=15
!  media(2)%elem(1)%Z=5
!  media(2)%elem(2)%Z=7
!  write(0,*) media(2)%elem(1:2)%A
!  write(0,*) media(2)%elem(1:2)%Z
!end program main




