#include "ZsaveStruc.h"
ccc            test ctransVectZx,  ciTransVectZx
c       implicit none
c       include 'Zcoord.h'
c       record /coord/ wa, wb, dir1, dir2
c       real*8 norm
c 
c 
c 
c       wa.r(1) = .50
c       wa.r(2) = 0.2
c       wa.r(3) = sqrt(1. - (wa.r(1)**2+wa.r(2)**2))
c
c       wb.r(1) = wa.r(2)
c       wb.r(2) = -wa.r(1)
c       wb.r(3) = 0.
c       norm = sqrt( wb.r(1)**2 + wb.r(2)**2 + wb.r(3)**2)
c       wb.r(1) = wb.r(1)/norm
c       wb.r(2) = wb.r(2)/norm
c       wb.r(3) = wb.r(3)/norm
c
c
c       dir1.r(1) = sqrt(2.)/3.
c       dir1.r(2) = dir1.r(1)*1.1
c       dir1.r(3) = sqrt(1. - dir1.r(1)**2 - dir1.r(2)**2)
c       write(*,*) dir1.r(1), dir1.r(2), dir1.r(3)
c       call ctransVectZx(1, wa, wb, dir1, dir2)
c       write(*,*) dir2.x, dir2.y, dir2.z
c       call ciTransVectZx(1, wa, wb, dir2, dir2)
c       write(*,*) dir2.x, dir2.y, dir2.z
c       call ctransVectZx(2, wa, wb, dir1, dir1)
c       write(*,*) dir1.r(1), dir1.r(2), dir1.r(3)
c       end
c-------------------------------------------------------------
       subroutine ctransVectZx(init, zax, xax, dir1, dir2)
c
c
c     /usage/ call ctransVectZx(init, zax, xax, dir1, dir2)
c         Directions cosines(dir1) are given in a system
c         (=R).
c         The z axis of  R has dircetion cos zax in B.
c         The x axis of  R has direction cos xax in B.
c
c         This subroutine transform the angles so that (dir1)
c         be the direction cosines in the B-system,
c         and put the result into dir2.
c         dir2 can be the same one as dir1, or zax.
c    init:  if zax and xax  are different from those from the 
c           previous call, give 1  else  give a diff. value.
c    zax:  /coord/
c    xax:  /coord/
c    dir1: /coord/
c    dir2; /coord/
c  *** Note *** If you are ok with an arbitrary x axis, use ctransVectZ.
c
       implicit none

#include  "Zcoord.h"
       record /coord/ xax, zax, dir1, dir2
       integer init
c
       record /coord/ yvec, temp
       real*8 norm

#ifdef USESAVE
       save yvec
#endif

       character*70 msg
c            y -axis unit vector
       if(init .eq. 1) then
          yvec.r(1) = zax.r(2) * xax.r(3) - zax.r(3) * xax.r(2)
          yvec.r(2) = zax.r(3) * xax.r(1) - zax.r(1) * xax.r(3)
          yvec.r(3) = zax.r(1) * xax.r(2) - zax.r(2) * xax.r(1)
c           need not  normalize; but check it
          norm = yvec.r(1)**2 + yvec.r(2)**2 + yvec.r(3)**2
          if(abs(norm-1.0) .gt. 1.e-4) then
             write(msg, *)
     *             'ctransVectZx: input dir. cos. are not orthogonal'
             call cerrorMsg(msg, 0)
          endif
       endif
c
       temp.r(1) = dir1.r(1) * xax.r(1) + dir1.r(2) *yvec.r(1) +
     *     dir1.r(3) *zax.r(1)
       temp.r(2) = dir1.r(1) * xax.r(2) + dir1.r(2) *yvec.r(2) + 
     *     dir1.r(3) *zax.r(2)
       temp.r(3) = dir1.r(1) * xax.r(3) + dir1.r(2) *yvec.r(3) + 
     *     dir1.r(3) *zax.r(3)
c
       dir2 = temp
       end
c      ===================================================
       subroutine ciTransVectZx(init, zax, xax, dir1, dir2)
c      ===================================================
c   This is the inverse of ctransVectZx
c
c     /usage/ call ciTransVectZx(init, zax, xax, dir1, dir2)
c   Suppose 2 system B and R.  
c         Directions cosines(dir1) are given in B
c
c         The z axis of  R has dircetion cos zax in B.
c         The x axis of  R has direction cos xax in B.
c
c         This subroutine transform the angles so that (dir1)
c         be the direction cosines in the R-system,
c         and put the result into dir2.
c         dir2 can be the same one as dir1, or zax.
c    init:  if zax and xax  are different from those from the preious call, give 1
c           else  give a diff. value.
c    zax:  /coord/
c    xax:  /coord/
c    dir1: /coord/
c    dir2; /coord/
c
       implicit none
#include  "Zcoord.h"
       record /coord/ xax, zax, dir1, dir2
       integer init
c
       record /coord/ yvec, temp
       real*8 norm
#ifdef USESAVE
       save yvec
#endif
       character*70 msg
c            y -axis unit vector
       if(init .eq. 1) then
          yvec.r(1) = zax.r(2) * xax.r(3) - zax.r(3) * xax.r(2)
          yvec.r(2) = zax.r(3) * xax.r(1) - zax.r(1) * xax.r(3)
          yvec.r(3) = zax.r(1) * xax.r(2) - zax.r(2) * xax.r(1)
c           need not  normalize; but check it
          norm = yvec.r(1)**2 + yvec.r(2)**2 + yvec.r(3)**2
          if(abs(norm-1.0) .gt. 1.e-4) then
             write(msg, *)
     *             'ctransVectZx: input dir. cos. are not orthogonal'
             call cerrorMsg(msg, 0)
          endif
       endif
c
       temp.r(1) = dir1.r(1) * xax.r(1) + dir1.r(2) *xax.r(2) +
     *  dir1.r(3)  *xax.r(3)
       temp.r(2) = dir1.r(1) * yvec.r(1)+ dir1.r(2) *yvec.r(2) + 
     *  dir1.r(3) *yvec.r(3)
       temp.r(3) = dir1.r(1) * zax.r(1) + dir1.r(2) *zax.r(2) +
     *    dir1.r(3)  *zax.r(3)
       dir2 = temp
       end

             
