c       ccompPathEnd
c       compute path end information. including multiple scattering and mag.
c       deflection
c
      subroutine ccompPathEnd
      implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
c
c
c         get endpoint coord. assuming no scat, no mag. effect. at first
c         MovedTrack has complete information at path end.
       MovedTrack = TrackBefMove   !   copy TrackBefMove into MovedTrack. 
       if(IntInfArray(ProcessNo).length .gt. 0.0 ) then
          call cmoveStreight(IntInfArray(ProcessNo).length, 
     *             TrackBefMove.vec.w)
c         If a chargde ptcl, compute energy loss by dE/dx  and  reset energy
c         in MovedTrack. If it is too large, path is truncated. Also compute
c         deflection.

          if(TrackBefMove.p.charge .ne. 0) then
c            if(.not. (mod(HowGeomag, 10) .eq. 1 .and.     this existed from uv4.92 to 5.13
c     *                Zfirst .eq. 0.)) then
             call cputEnergyLoss
c               endif
c                if "if" is omitted, segmentation violation
c                may take place occasionally
             if(MoveStat .ne. Dead) then
                call cputDeflection
             endif
          endif
       else
          EnergyLoss = 0.
       endif
       end
c     --------------------------------------------------------
       subroutine cmoveStreight(leng, dir)
c        move a track by leng m
c         after this is called,  MovedTrack has inf for moved pos.
c         MovedTrack.pos.where may not be correct. It must be
c         corrected by seeing if the track passes acrosss a
c         observation layer.
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zearth.h"

       real*8  leng, cnewcos
       record /coord/ dir        ! input.
c
c            new coord in xyz system.

       MovedTrack.pos.xyz.r(1) = TrackBefMove.pos.xyz.r(1)
c     *                      + TrackBefMove.vec.w.r(1) * leng
     *                      + dir.r(1) * leng
       MovedTrack.pos.xyz.r(2) = TrackBefMove.pos.xyz.r(2)
c     *                      + TrackBefMove.vec.w.r(2) * leng
     *                      + dir.r(2) * leng
       MovedTrack.pos.xyz.r(3) = TrackBefMove.pos.xyz.r(3)
c     *                      + TrackBefMove.vec.w.r(3) * leng
     *                      + dir.r(3) * leng
       call csetPos(MovedTrack.pos) ! set height, radial length, thickness
c            get new cos
       MovedTrack.vec.coszenith = cnewcos(MovedTrack.pos.radiallen,
     *  TrackBefMove.vec.coszenith, leng)
       if(TimeStructure ) then
          call cgetBeta(MovedTrack.p, Beta)  
c             note righthand is not MovedTrack.t
          if(Beta .gt. 0.) then
             MovedTrack.t = TrackBefMove.t + leng/Beta
          endif
       endif
       end
c      -----------------------------------
       subroutine cputEnergyLoss
c         observation layer.
       implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
 
c     
       real*8  rho, cvh2den, dedt, dedtF,  thick, leng, cupsilon
       save dedt, dedtF
       real*8  csyncTELoss
       integer jcut
       real*8  dedx, dedxF  ! output.  dedt, dedtF is put


       real*8  dedxmu, dedxmuF

c
c          first consider the synchrotron loss.
c
       if( TrackBefMove.p.fm.p(4) .gt. MagBremEmin) then
         if( MagBrem .eq. 1 .and. TrackBefMove.p.code .eq. kelec) then
	    Upsilon = cupsilon(TrackBefMove.p, Mag)
	    if(Upsilon .gt. UpsilonMin) then
c                 compute energy loss due to sychrotron rad.
                 EnergyLoss = csyncTELoss(Upsilon) * 
     *           IntInfArray(ProcessNo).length
                 if(Reverse .eq. 0) then
                    MovedTrack.p.fm.p(4) = 
     *                MovedTrack.p.fm.p(4) -  EnergyLoss
                 elseif(Reverse .eq. 2) then
                    MovedTrack.p.fm.p(4) = 
     *                MovedTrack.p.fm.p(4) +  EnergyLoss
                 endif
c                 don't  worry about death
	    endif
         endif
       endif 
c            
c           dE/dX
c
       rho = cvh2den(TrackBefMove.pos.height)
       call cdedxInAir(TrackBefMove.p, rho, dedt, dedtF )  ! dedt; GeV/(kg/m2)
       if(TrackBefMove.p.code .eq. kmuon ) then
c           dE/dx due to muon pair, brem, nuc.i
          call cmudEdx(MuNI, MuBr, MuPr, TrackBefMove.p.fm.p(4),
     *         dedxmu, dedxmuF)   ! dedxmu in GeV/(g/cm2)
          dedxmu = dedxmu /10.  !  GeV/(kg/m2)
          dedxmuF = dedxmuF /10.  !  GeV/(kg/m2)
          dedt = dedt + dedxmu
          dedtF = dedtF + dedxmuf
       endif

       EnergyLoss =  dedt * IntInfArray(ProcessNo).thickness
       if(Reverse .eq. 0) then
           MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) -  EnergyLoss          
c           see if <=mass
           if(MovedTrack.p.fm.p(4) .lt. MovedTrack.p.mass) then
              EnergyLoss =( TrackBefMove.p.fm.p(4) - MovedTrack.p.mass )
              if(dedt .gt. 0.) then
                 thick =EnergyLoss / dedt
              else
                 thick = 0.
              endif
              MovedTrack.p.fm.p(4) = MovedTrack.p.mass

c              call cthick2len(TrackBefMove.pos.height, 
c     *          TrackBefMove.vec.coszenith, thick, leng, thick, jcut)
c                   Mar.18
              call cthick2len(TrackBefMove, thick, leng, thick, jcut)
c               reset position information in MovedTrack
              call cmoveStreight(leng, TrackBefMove.vec.w)
              MoveStat = Truncated
           endif
c                reset 3 momenta px, py, pz 
c                 (but assume direction is unchanged)
           call ce2p(MovedTrack)
       elseif(Reverse .eq. 2) then
          MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) +  EnergyLoss
c                reset 3 momenta px, py, pz 
c                 (but assume direction is unchanged)
          call ce2p(MovedTrack)
c          MoveStat = Truncated
       else
c          MoveStat = Truncated
       endif 
       return
c      **************
       entry cqElossRate(dedx, dedxF)
c      **************
c         inquire the dedt; which may be used when particle cross 
c         an obs. level and recompute the energy
       dedx = dedt
       dedxF = dedtF
       end
c      --------------------------------------------------------------
       subroutine cputDeflection
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

c
       real*8 dt, dispx, dispy
       logical nodef
       if(Reverse .eq. 0) then
          nodef = OneDim .ne. 0  .or.
     *    (mod(HowGeomag, 10) .eq. 1 .and. Zfirst.pos.depth .eq. 0.)
       else
          nodef = .false.
       endif
       if(.not. nodef) then
c
c         compute   magnetic deflection first. independently of scattering.
c         system is xyz;  if Efield exists, together with it
          call cmagDef
       endif
       if(.not. nodef .and. Reverse .eq. 0) then
!                this is for multiple scattering
          call celecDef(dispx, dispy)  ! effect alrady put in
                    ! MovedTrack. dispx, y are dummy
       endif
       if(.not. nodef) then
          call csetPos(MovedTrack.pos)
          call cgetZenith(MovedTrack, MovedTrack.vec.coszenith)
c          reset momentum to be compatible with direction cos.
          call cresetMom(MovedTrack)
c
          if(TimeStructure .and. Reverse .eq. 0) then  ! only for mul. scat
c                compute excess path length to be added to streight path
             call cexcessLen(dispx, dispy, dt)
             if(Beta .gt. 0.) then
                MovedTrack.t = MovedTrack.t + dt/Beta
             endif
          endif
       endif
       end
c      *************************
#include "ZsubstRec.h"
       subroutine cmagDef
       use modEfield
       implicit none
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

c

c              by  Geomag  (dr and ddirec)
       record /coord/ dispmr, dispmd
       record /magfield/ tempmag
       real*8  leng
       real*8 temp1, temp2
ccc    *   ,norm
       integer i

       integer icon
       record /coord/  middle
       logical usemiddle, high, usecmiddle
       real*8 cheight
       data cheight/30.d3/  
       real*8 newmom(3), dE, E1, E2, p1sq, p2sq, newE, norm
       save cheight

       leng = IntInfArray(ProcessNo).length
       if( HowEfield >= 1 ) then
          call cdefByMagAndE(TrackBefMove,  leng,  dispmr, dispmd,
     *     newmom)
          p1sq =dot_product(TrackBefMove.p.fm.p(1:3),
     *           TrackBefMove.p.fm.p(1:3))
          E1 = sqrt( p1sq + TrackBefMove.p.mass**2)
          p2sq =dot_product(newmom(1:3),newmom(1:3))
          E2=sqrt(p2sq +  TrackBefMove.p.mass**2)
          dE=E2-E1  !  may be + or -  depending on Ef and charge
          ! dE/dx loss has been put in MovedTrack. adjust it again
          
          newE = MovedTrack.p.fm.p(4) + dE
          if( newE <  TrackBefMove.p.mass ) then
             newE =  TrackBefMove.p.mass
             newmom(:) = 0
          else
             ! keeping the direction,adjust new momentum to be
             ! consistent with newE
             if( p2sq <= 0. ) then
                write(0,*) ' p2sq = ',p2sq
                write(0,*)
     *          ' TrackBefMove.p=',TrackBefMove.p.fm.p(1:4)
                write(0,*) ' dE, newE=',dE, newE
                write(0,*) ' leng =', leng
                write(0,*) 'dispmr=',dispmr.r(:)
                write(0,*) 'dispmd=',dispmd.r(:)
                write(0,*)
     *            'code, chg=',TrackBefMove.p.code,
     *            TrackBefMove.p.charge

                newE = TrackBefMove.p.mass
                newmom(:) = 0
                dispmd.r(:) = (/0.,0.,1./)
             else
                norm = sqrt( (newE**2 - TrackBefMove.p.mass**2)/p2sq)
                newmom(:) = newmom(:) *norm
             endif
          endif
          MovedTrack.p.fm.p(4) = newE
!          note. dispmr is r(new)-r(old) vector and different
!          from other routines below. 
!           dispmd is new dir and set at 100
          MovedTrack.pos.xyz.r(:) =  TrackBefMove.pos.xyz.r(:) +
     *         dispmr.r(:) 
          MovedTrack.p.fm.p(1:3) = newmom(:)
          goto 100
       endif
c
c            UseRungeKutta         Height       
c                0                  any         Mag and cmagneticDef

c                1                 >cheight     middle Mag and cmagneticDef
c                1                 <            Mag and cmagneticDef

c                2                 >            middle Mag and cmagneticDef 
c                                               or cbDefByRK2        
c                2                 <            Mag and cmagneticDef 

c                3                 >            middle Mag and cmagneticDef 
c                                               or cbDefByRK        
c                3                 <            Mag and cmagneticDef 

c                4                 >            use Mag at curved middle point
c                                               and estimate end point by 
c                                               cmagneticDef or cbDefByRK2
c                4                 <            Mag and cmagneticDef   

c                5                 >            use Mag at curved middle point
c                                               and estimate end point by 
c                                               cmagneticDef or cbDefByRK
c                5                 <            Mag and cmagneticDef   

c                6                 >            cbDefByRK2
c                6                 <            Mag and cmagneticDef 

c                7                 >            cbDefByRK
c                7                 <            Mag and cmagneticDef 
c
c                8      at any height           cbDefUser ; interface is
c                                               same as cbDefByRK
c
       if(UseRungeKutta .eq. 8 ) then
          call cbDefUser(TrackBefMove,  leng,  dispmr, dispmd,
     *    MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC             
             MovedTrack.pos.xyz = dispmr ! this is not a dispalcement vector
#else 
             call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
          goto 100
       endif
       high = TrackBefMove.pos.height .gt. cheight
       usemiddle = ( UseRungeKutta .ge. 1 .and.
     *               UseRungeKutta .le. 3 .and.
     *               high )
       usecmiddle = ( UseRungeKutta .ge. 4 .and.
     *               UseRungeKutta .le. 5 .and.
     *               high )


       if(usemiddle) then
          do i = 1, 3
             middle.r(i) = TrackBefMove.pos.xyz.r(i)+ 
     *          leng/2 * TrackBefMove.vec.w.r(i)
          enddo
          middle.sys='xyz'

          call cgeomag(YearOfGeomag,  middle,
     *                tempmag, icon)
          call ctransMagTo('xyz', middle,
     *        tempmag, tempmag)
       elseif(usecmiddle) then
c            get curved middle point
          call cmagneticDef(TrackBefMove, Mag, leng/2.0d0,
     *     dispmr, dispmd)  
          do i = 1, 3
             middle.r(i) = TrackBefMove.pos.xyz.r(i) + dispmr.r(i)
          enddo
          middle.sys ='xyz'
          call cgeomag(YearOfGeomag,  middle,
     *                tempmag, icon)
          call ctransMagTo('xyz', middle,
     *        tempmag, tempmag)
       endif

       if(usemiddle .and. UseRungeKutta .eq. 1) then
          Mag = tempmag
       elseif( usemiddle .and.  UseRungeKutta .eq. 2 ) then
          temp1 = tempmag.x**2 + tempmag.y**2 + tempmag.z**2
          temp2 = Mag.x**2 + Mag.y**2 + Mag.z**2
c           if  dB/B~ dB^2/B^2/2 > 0.4 %, use RungeKutta.
          if( abs(temp1-temp2)/temp1/2.0 .gt. 4.0d-3) then
             call cbDefByRK2(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC             
             MovedTrack.pos.xyz = dispmr ! this is not a dispalcement vector
#else 
             call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
             goto 100
          else
             Mag = tempmag
          endif
       elseif(usemiddle .and. UseRungeKutta .eq. 3) then
          temp1 = tempmag.x**2 + tempmag.y**2 + tempmag.z**2
          temp2 = Mag.x**2 + Mag.y**2 + Mag.z**2
c           if  dB/B~ dB^2/B^2/2 > 0.45 %, use RungeKutta.
c                  next 4.5d-3 is very sensitive to cpu time
c                 if it was 4.0d-3, cpu time becomes twice.
          if( abs(temp1-temp2)/temp1/2.0 .gt. 4.5d-3) then
             call cbDefByRK(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC             
             MovedTrack.pos.xyz = dispmr ! this is not a dispalcement vector
#else 
             call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
             goto 100
          else
             Mag = tempmag
          endif
       elseif(usecmiddle .and. UseRungeKutta .eq. 4) then
          temp1 = tempmag.x**2 + tempmag.y**2 + tempmag.z**2
          temp2 = Mag.x**2 + Mag.y**2 + Mag.z**2
c           if  dB/B~ dB^2/B^2/2 > 0.1 %, use RungeKutta.
          if( abs(temp1-temp2)/temp1/2.0 .gt. 4.0d-3) then
             call cbDefByRK2(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC             
             MovedTrack.pos.xyz = dispmr ! this is not a dispalcement vector
#else 
             call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
             goto 100
          else
             Mag = tempmag
          endif
       elseif(usecmiddle .and. UseRungeKutta .eq. 5) then
          temp1 = tempmag.x**2 + tempmag.y**2 + tempmag.z**2
          temp2 = Mag.x**2 + Mag.y**2 + Mag.z**2
c           if  dB/B~ dB^2/B^2/2 > 0.45 %, use RungeKutta.
          if( abs(temp1-temp2)/temp1/2.0 .gt. 4.5d-3) then
             call cbDefByRK(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC             
             MovedTrack.pos.xyz = dispmr ! this is not a dispalcement vector
#else 
             call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
             goto 100
          else
             Mag = tempmag
          endif
       endif
!!!!!!   default comes here
       if(UseRungeKutta .le. 5 .or. .not. high ) then
          call cmagneticDef(TrackBefMove, Mag, leng,
     *     dispmr, dispmd)

          do i = 1,  3
             MovedTrack.pos.xyz.r(i) = TrackBefMove.pos.xyz.r(i) +
     *         dispmr.r(i)
          enddo
       elseif(UseRungeKutta .eq. 6) then
          call cbDefByRK2(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC
          MovedTrack.pos.xyz = dispmr  ! this is not a dispalcement vector
#else 
          call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
                                      !  but the vector itself.
       else
          call cbDefByRK(TrackBefMove,  leng, dispmr, dispmd,
     *         MovedTrack.p.fm.p(1:3))
#if defined SUBSTREC
          MovedTrack.pos.xyz = dispmr  ! this is not a dispalcement vector
                                      !  but the vector itself.
#else 
          call csubstcoord(dispmr, MovedTrack.pos.xyz)
#endif
       endif
 100   continue
#if defined SUBSTREC
       MovedTrack.vec.w = dispmd
#else
       call csubstcoord(dispmd, MovedTrack.vec.w)
#endif
       end
c        for IBM AIX
      subroutine csubstcoord(c1, c2)
      implicit none
#include "Zcoord.h"
      record /coord/ c1, c2   
      c2 = c1
      end

c      ==============================================================
       subroutine celecDef(dx, dy)
       implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

      real*8 dx, dy             ! output. scatttering displacement
c     
      record /coord/ dircos
c              by  Multiple Scattering
      record /coord/ dsa   ! dire ccos of scattering angle
      record /coord/ w
      real*8  sint, cs, sn, tmp, avx, avy, disp, dt, dl
      real*8 r, g1, g2, gf1, gf2, beta2, tetarms
      real*8 theta
      
      call cmulScat(theta)
      if(theta .lt. 0.01d0) then
c                 cos
         dsa.z = 1.-theta**2/2
         sint = theta
      else
         dsa.z = cos(theta)
         sint = sin(theta)
      endif
c        azimuthal angle
      call kcossn(cs, sn)
      dsa.x = sint * cs
      dsa.y = sint * sn
      dt = IntInfArray(ProcessNo).thickness/ X0 ! r.l
      dl = IntInfArray(ProcessNo).length !  m

      if(Moliere .ge. 0) then
c         sample displacement correlated to theta
c                 this is the same as P.D.B though look like
c                diff.
        tmp = dl/2.d0
        avx = tmp * dsa.x
        avy = tmp * dsa.y
c                dispersion
        gf1 = TrackBefMove.p.fm.p(4)/MovedTrack.p.mass
        gf2 = MovedTrack.p.fm.p(4)/MovedTrack.p.mass
        beta2 = 1.d0 - 1.d0/gf1/gf2
        if(beta2 .le. 0.) then
           disp = 0.d0
        else
           if(dt .gt. 1.d-3) then
              tetarms = Es/TrackBefMove.p.fm.p(4)*
     *            abs(MovedTrack.p.charge)*
     *            sqrt(dt)*(1.0 + 0.038*log(dt))
           else
              tetarms = Es/TrackBefMove.p.fm.p(4)*
     *                  abs(MovedTrack.p.charge)*
     *              sqrt(dt)
           endif
           disp=tetarms/sqrt(6.d0*beta2)*dl/2.d0
c               sample 2 independent gaussian variables
c             with mean 0 and var 1
        endif
        call kgauss2(0.d0, 1.0d0, g1, g2)
        dx = g1 * disp + avx
        dy = g2 * disp + avy
c                  displacement
        r=sqrt(dx*dx+dy*dy)     ! in m
c              direction cos of vector r in original sys.
        if(r .ne. 0.) then
           w.x = dx/r
           w.y = dy/r
           w.z = 0.
c                 transform wx,wy,wz to original sys.
c                    TrackBefMove is better
           call ctransVectZ(TrackBefMove.vec.w, w, w)
c               r is already in m.
c              add scattering effect.
c              r*w is displacement by scattering
           MovedTrack.pos.xyz.x = r*w.x + MovedTrack.pos.xyz.x
           MovedTrack.pos.xyz.y = r*w.y + MovedTrack.pos.xyz.y
           MovedTrack.pos.xyz.z = r*w.z + MovedTrack.pos.xyz.z
        endif
      else
         dx = 0.
         dy = 0.
      endif
c        convert scattering angle at end of path to
c        original system . MovedTrack is better since
c        mag. def is contained there already.
      call ctransVectZ(MovedTrack.vec.w, dsa,
     *      MovedTrack.vec.w)

      end

