      subroutine cGetXsec(model, pj, media, xs, mfp)
!         get hadronic interaction cross-section for
!    given interaction model,  projectile and medium.
!    The media information must have been set via
!    cXsecMedia.f90
!             xmedia=>media is to avoid name
!       collision of media  in modXsecMedia and
!       media argument in the subroutine def.
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
#include "Zevhnp.h"
      character(*),intent(in):: model
      record /ptcl/pj           ! input.   projectile 
      type(xsmedia),intent(inout):: media ! media 
      real(8),intent(out):: xs  ! collision xsection in mb
                    !    if xs==smallxs, no collision
                    !       xs==largexs, instant collision
      real(8),intent(out):: mfp ! mean free path in kg/m2

      if( pj.code == knuc ) then
         if( pj.subcode == antip .and. pj.fm.p(4) - pj.mass <= 0.) then
            xs = largexs
            media%xs = xs
            mfp = 0. 
            return  ! *******************
         endif
      elseif( pj.code == kneue .or. pj.code == kneumu ) then
         xs = smallxs
         media%xs = xs
         mfp  =0.
         return                 ! *******************
      endif
      select case(model)
        case( "phits" ) 
           call cxsPhits(pj, media)
        case( "dpmjet3" )
           call cxsDpmjet3(pj, media)
        case( "jam" ) 
           call cxsJam(pj, media)
        case( "qgsjet2" )
           call cxsQgsjet2(pj, media)
        case( "epos" )
           call cxsEPOS(pj, media)
        case( "sibyll" )
           call cxsSibyll(pj, media)
        case( "gheisha" ) 
           call cxsGheisha(pj, media)
        case("incdpm3")   
           call cxsIncdpm3(pj, media)
        case default
         call cxsOther( pj, media)
      end select
      if( media%xs /= smallxs .and. media%xs /= largexs) then
         mfp = 1.0d0/( media%mbtoPkgrm * media%xs)
      elseif( media%xs == smallxs ) then
         mfp = largexs
      else
         mfp = 0.
      endif
      xs = media%xs
      end subroutine cGetXsec


      subroutine cxsJam(pj,  media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Ztrackp.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output


      integer i
      real(8):: sumns,  xs

      sumns=0. 
      do i = 1, media%noOfElem
         if(pj.code >= kpion .and. pj.code <= knuc ) then
            if( JamXs == 1 ) then
               call ctotx(pj, media%elem(i)%A,  xs)
            elseif( JamXs == 0 ) then
               call cinelx(pj, media%elem(i)%A, media%elem(i)%Z, xs)
            else
               write(0,*)
     *          ' JamXs=',JamXs, ' not usable in cxsJam'
               stop
            endif
         else
            call cinelx(pj, media%elem(i)%A,  media%elem(i)%Z, xs)
         endif
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsJam

      subroutine cxsPhits(pj,  media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output


      integer i, icon
      real(8):: sumns,  xs, u, elaxs
      integer::ka, subc, ia, iz

      sumns=0. 
      ka = pj.code
      subc = pj.subcode
      do i =1, media%noOfElem
         ia = media%elem(i)%A + 0.5
         iz = media%elem(i)%Z
         if( ( ka == knuc .and. subc /= antip )
     *        .or. ka == kgnuc) then
            call cphitsXs(pj, ia, iz, elaxs,xs, icon)
cc             no need to add. xs is already total 2010.Nov.16
ccc            xs = xs + elaxs  ! phits elaxs for heavy is 0
         else
!            if( ka >= kpion .and. ka <= knuc ) then
!               if( (pj.fm.p(4)-pj.mass)  < 10.d0 )  then ! include elastic
!                  call ctotx(pj, media%elem(i)%A,  xs)
!               else
            call cinelx(pj, media%elem(i)%A, media%elem(i)%Z, xs)

!               endif
!            else
!               call cinelx(pj, media%elem(i)%A, media%elem(i)%Z, xs)
!            endif
         endif
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsPhits

      subroutine cxsDpmjet3(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output

      integer i
      real(8):: sumns,  xs

      sumns=0. 
      do i =1, media%noOfElem
         if( pj.code >= kpion .and. pj.code <= knuc ) then
            if( pj.fm.p(4) .lt.  4.1d0 ) then  ! Et is better than Ek
               call ctotx(pj, media%elem(i)%A,  xs)
c//////////////////
               if( pj.code == 6 .and. pj.charge == -1  .and.
     *              (pj.fm.p(4)- pj.mass) < 1d-3 ) then
                  write(0,*) '********* ', pj.fm.p(4)-pj.mass,
     *             xs
                  write(0,*) ' largexs=',largexs
               endif
c///////////////////
            else
               call cinelx(pj, media%elem(i)%A,  media%elem(i)%Z, xs)
            endif
         else
            call cinelx(pj, media%elem(i)%A, media%elem(i)%Z, xs)
         endif
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsDpmjet3


      subroutine cxsQgsjet2(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output


      integer i, ia
      real(8):: sumns,  xs, tga, u, tgz


      sumns=0. 
      do i =1, media%noOfElem
         tga = media%elem(i)%A
         tgz = media%elem(i)%Z
         ia =tga 
         call rndc(u)
         if(u .lt.  tga - ia ) then
            ia = min(ia + 1, 209)
         endif
         if( (pj.code >= kpion .and. pj.code <= knuc) .or. 
     *        pj.code == kgnuc ) then
            call cxsecQGS(pj, ia, xs)               
         else
            call cinelx(pj, tga, tgz, xs)
         endif

         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsQgsjet2

      subroutine cxsEPOS(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output

      integer i, ia, iz
      real(8):: sumns,  xs, tga, u, tgz

      record /ptcl/ tg

      sumns=0. 
      do i =1, media%noOfElem
         tga = media%elem(i)%A
         tgz = media%elem(i)%Z
         ia =tga 
         iz =tgz 
         call rndc(u)
         if(u .lt.  tga - ia ) then
            ia = min(ia + 1, 209)
         endif

         if(ia > 1 ) then
            call cmkptc(kgnuc, ia, iz, tg)
         else
            call cmkptc(knuc, ia, iz, tg)
         endif
         tg.fm.p(1:3) = 0.
         tg.fm.p(4) = tg.mass
         call ceposIniOneEvent(pj, tg, xs)
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end      subroutine cxsEPOS

      subroutine cxsSibyll(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output

      integer i, ia, iz
      real(8):: sumns,  xs, tga, u, tgz

      record /ptcl/ tg

      sumns=0. 
      do i =1, media%noOfElem
         tga = media%elem(i)%A
         tgz = media%elem(i)%Z
         ia =tga 
         iz =tgz 
         call rndc(u)
         if(u .lt.  tga - ia ) then
            ia = min(ia + 1, 209)
         endif

         if(ia > 1 ) then
            call cmkptc(kgnuc, ia, iz, tg)
         else
            call cmkptc(knuc, ia, iz, tg)
         endif
         tg.fm.p(1:3) = 0.
         tg.fm.p(4) = tg.mass
         if( media%name == "Air" ) then
            tg.subcode = 0  !sibyll can do for almost Air target only. 
         endif
         call csibyllXs(pj, tg, xs)
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsSibyll

      subroutine cxsGheisha(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/ pj  ! input ptcl
      type(xsmedia),intent(inout):: media    ! input/output

      integer i, ia
      real(8):: sumns,  xs, tga, tgz


      sumns=0. 
      do i =1, media%noOfElem
         tga = media%elem(i)%A
         tgz = media%elem(i)%Z
         if(pj.code  >= kpion .and. pj.code <= knuc ) then
            call cxsecGheisha(pj, tga,  tgz, xs)
         else
            call cinelx(pj, tga, tgz, xs)
         endif
         if( xs == smallxs .or. xs == largexs ) then 
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsGheisha

      subroutine cxsIncdpm3(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
          
      record /ptcl/ pj      ! input.  a particle (hadronic)
      type(xsmedia),intent(inout):: media    ! input/output

      real(8):: ek, crossint
      integer:: kinc

      ek = pj.fm.p(4)- pj.mass
      if( ek > 0.2d0 ) then
c            special for inclusive treatment.  target is always air   
c         *********************************                           
         call cccode2hcode(pj, kinc)
         media%xs = crossint(kinc, ek)
      else
         media%xs = smallxs
      endif
      end subroutine cxsIncdpm3

      subroutine cxsOther(pj, media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
          
      record /ptcl/ pj      ! input.  a particle (hadronic)
      type(xsmedia),intent(inout):: media    ! input/output

 
      integer i
      real(8):: sumns, xs

      sumns = 0.
        do i = 1, media%noOfElem
         call cinelx(pj, media%elem(i)%A, media%elem(i)%Z, xs)
c//////////////
c         write(0,*) 'in othert;  xs=',xs, i,  media%noOfElem
c////////////
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns
      end subroutine cxsOther

      subroutine cfixTarget(media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zevhnp.h"

c
c       Fix the target element, 
c  
      type(xsmedia),intent(inout):: media  ! input/output
                        !   xsmedia information.


      real*8 u, csigma
      integer  j, ia


      if(  media%xs == smallxs .or.  media%xs == largexs ) then
         j = 1
         media%elem(j)%nsigma = media%xs
      elseif( media%noOfElem .eq. 1 ) then
         j = 1
      else
         call rndc(u)
         u = u* media%xs
         csigma = 0.
         do j = 1, media%noOfElem
            csigma = csigma + media%elem(j)%nsigma
            if(u <= csigma)  goto 10
         enddo
         write(0,*) 'media name=', media%name
         write(0,*) 'media%xs=',media%xs
         write(0,*) 'media%noOfElem=', media%noOfElem
         write(0,*) 'media%elem(:)%nsigma=',
     *          media%elem(1:j)%nsigma
         write(0,*) ' u=',u, ' csigma=',csigma, ' j=',j
         call cerrorMsg('should not come here; cfixTarget',0)
      endif
 10   continue
      colElemNo = j
c          int value is taken.
cc      if(model .eq. "dpmjet3" ) then
      ia = media%elem(j)%A  + 0.5
cc      else
cc         call rndc(u)
cc         ia = media%elem(j).A
cc         if(u .lt. media%elem(j).A -ia ) then
cc            ia = ia + 1
cc         endif
cc      endif
         
!      media%colZ = media%elem(j)%Z
!      media%colA = ia
!      media%colXs = media%elem(j)%nsigma/media%elem(j)%No
      TargetProtonNo = media%elem(j)%Z
!      TargetNucleonNo = media%elem(j)%A
      TargetNucleonNo = ia
      TargetXs =  media%elem(j)%nsigma / media%elem(j)%No
!       Nxt needs not be called if !MacIFC  
!      (see chAcol.f and cheavyInt.f)
#if defined (MacIFC)      
      call  cworkaround(TargetNucleonNo, TargetProtonNo, TargetXs,
     *   colElemNo)
#endif
      end   subroutine cfixTarget

      subroutine cworkaround(A, Z, xs, nelem)
!     With MacIFC,
!     TargetNucleonNo, TargetProtonNo, TargetXs
!     colElemNo
!     cannot be recognized at link time
!     from chAcol.f cheavyInt.f so we trnasfer info.
!     thru common.  (VERY STRANGE; compiler problem)
      implicit none
      integer,intent(in):: A  ! TargetNucleonNo
      integer,intent(in):: Z  ! TargetProtonNo
      real(8),intent(in):: xs ! TargetXs
      integer,intent(in):: nelem ! element # of the target elemnt
                      ! in the mediumNo
#include "Zworkaround.h"

      TargetNucleonNo = A
      TargetProtonNo  = Z
      TargetXs   = xs
      colElemNo = nelem
      end      subroutine cworkaround

      
      subroutine cfixTargetMuNI(media)
!        fix target for muon nuclear interaction
!      In  the case of muon n.i,  x-section for each
!      element is not computed and elem(:)%nsigma is
!      not ready. So we roughly compute it and fix
!      the  target 
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zevhnp.h"

      type(xsmedia),intent(inout):: media  ! input/output
                        !   xsmedia information.


      real*8 u, csigma, s0
      integer  j, ia

      s0=media%xs/sum( media%elem(:)%No * media%elem(:)%A )
      media%elem(:)%nsigma =
     *     s0 *media%elem(:)%No * media%elem(:)%A
      call cfixTarget(media)
      end   subroutine cfixTargetMuNI

      subroutine cgetCaprate( media)
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
          
      type(xsmedia),intent(inout):: media    ! input
 
      integer i
      real(8):: sumns, capr

      sumns = 0.
      do i = 1, media%noOfElem
         call cmucap( int(media%elem(i)%A), int(media%elem(i)%Z), 
     *            capr)
         media%elem(i)%nsigma = capr*media%elem(i)%No
         sumns = sumns + media%elem(i)%nsigma
      enddo
      media%xs = sumns   ! this is not mb x-sec. but is used
                 ! to fix the target (with media%elem(i)%nsigma
      end subroutine cgetCaprate

      subroutine cgetPhotoPxs(model, pj, media, xs, mfp)
!        cgetxs for photo-hadron production
      use modXsecMedia, xmedia=>media
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
c   
      character*16 model    ! input. Active interaction model.
            ! for x-section calclation .  at present not used
      record /ptcl/ pj      ! input.  a photon
      type(xsmedia),intent(inout):: media  ! input
      real(8),intent(out):: xs   !  obtained cross-section for the
                            !  media% in mb
                    !    if xs==smallxs, no collision
                    !       xs==largexs, instant collision
      real(8),intent(out):: mfp  !  obtained  mean free path in kg/m2

      integer i
      real(8):: sumns

      sumns = 0.
      do i = 1, media%noOfElem
         call cgpXsec(media%elem(i)%A, pj.fm.p(4), xs)
         if( xs == smallxs .or. xs == largexs ) then
            sumns = xs
            exit
         else
            media%elem(i)%nsigma = xs*media%elem(i)%No
            sumns = sumns + media%elem(i)%nsigma
         endif
      enddo
      media%xs = sumns

      if(media%xs /= smallxs .and. media%xs /= largexs) then
         if( media%xs <= 0. ) then
            xs = smallxs
            mfp = largexs
         else
            xs = media%xs
            mfp =1.0d0/( media%mbtoPkgrm *media%xs)
         endif
      elseif( media%xs == smallxs ) then
         xs = smallxs
         mfp = largexs
      else
         xs = largexs
         mfp = smallxs
      endif
      end      subroutine cgetPhotoPxs
