c     test cbremErgLPM
c
c      real*8 ee, rho, eg
c      integer i
c      read(*,*) ee, rho
c      ee = ee/1.e9      ! GeV
c      rho = rho * 1.e3   ! kg/m3
c      do i = 1, 10000
c         call cbremErgLPM(ee, rho, eg)
c         write(*, *) sngl(eg/ee)
c      enddo
c      end
c      
c       sampling  Bremsstrahlung gamma ray energy.
c       when the LPM effect is considered.
c       this may be used for ee > 10^15 eV.
c

      subroutine cbremErgLPM(ee, rho, eg)
      implicit none
#include "Zmass.h"
      real*8 ee  !input.  electron energy in GeV
      real*8 rho !input.  air density in kg/m3
      real*8 eg  !output.  sampled gamma ray energy. GeV
c
      real*8  u, v, temp, s
      real*8 cmigdG, cmigdPsi, cmigdSforBrem, cmigdGzai

      common /cmigdc/ s1, logs1, vm, logvm, smpa1, smpa2, suma,
     *   a2prob, X0
      real*8 vm, logvm, smpa1, smpa2, suma, a2prob, X0
      real*8 s1  ! /1.1185e-4/  ! (Z^0.333/183)^2 ; Z=7.25
      real*8 logs1   !  /-9.0983/  ! ln(s1)

c      real*8 a1, a2, vm, logvm, suma, a2prob
c      parameter (vm = 1.d-4, logvm = -4*2.3025851, 
c     *           a1 = 0.5, a2 = -4.d0*logvm/3.,
c     *           suma = a1 + a2, a2prob = a2/suma)
c
      do while (.true.)
         call rndc(u)
         if(u .lt. a2prob) then
c             sampling by  1/v
            call rndc(u)
            v = exp(u * logvm)  ! fractional energy
c            rejection
            call rndc(u)
            if(u .lt. 1.-v) then
c                further check; get s
               s = cmigdSforBrem(ee, rho, v)
               if(u .lt. (1.-v) * cmigdGzai(s)*cmigdPsi(s)) then
c                  accepted
                  eg =min( v, 1.d0- masele/ee) * ee
                  goto 100
               endif
            endif
         else
c              sampling by 2vdv
            call rndc(u)
            call rndc(v)
            v = max(u, v)
c            rejection, get s
            s = cmigdSforBrem(ee, rho, v)
            temp = cmigdGzai(s) * (cmigdG(s) + 2* cmigdPsi(s))/3.
            call rndc(u)
            if(u .lt. temp) then
c               accepted
               eg = min(v, 1.d0-masele/ee) * ee
               goto 100
            endif
         endif
      enddo
 100  continue
      end
