!  Usage:  compile by make -f cgetXs.mk
!      verbose mode:  (may be target is simple)
!      ./a.out > result
!      file input mode:(may be target is complex)
!                  prepare a file like
!          4            /  1-> proton 2->pion 3->K  4->A
!          56 26        /  if 4, give A,Z of projectile else omit this line
!          14.0, 16.0, 40.0 /     A's for target. "/" is mandatory
!          78.1, 20.95, 0.94 /    portion of A's "/" is mandatory
!       and
!      ./a.out < thefile > result
!   **NOTE*** verbose mode and file input mode may be
!        used independently of the complexity of the target.
!
      module modgetXs
      implicit none
      integer,parameter::maxel=15   ! max # of elements
      integer::nel  !  actual @ of elements
!      real(8):: A(maxel)
      integer:: A(maxel)
      real(8):: portion(maxel)
      integer,save:: pjk
!      integer,parameter:: nel=3   ! # of elements
!      real(8):: A(nel)=(/14.0, 16.0, 40.0/)   ! mass # (integer value is used)
!      real(8):: portion(nel)=(/78.1, 20.95, 0.94/)    ! relative # of A's in unit volume

      real(8),parameter:: dE=0.1d0   ! 0.05 log 10 step
      integer,parameter:: nebin=100  ! # of  Energy bins (from  10^11 eV to 10^21 eV) log10
!                                     ! step 0.1
      real(8),parameter:: E1= 100.    ! from 100GeV

      contains
      subroutine computeXS(pj, xsa)
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
      record /ptcl/ pj  !  projectile . E is fixed here
      real(8),intent(out):: xsa(nebin)


      record /ptcl/ tg  !
      integer:: i, j
      real(8):: E, sum, xs 
      integer TA
      E = E1
      do i = 1, nebin
         pj.fm.p(4) = E
         sum = 0.
         do  j = 1, nel
            if( A(j) == 1 ) then
               call cmkptc(knuc, -1, 1, tg)
            elseif( A(j) == 0 ) then  ! air
               call cmkptc(kgnuc, A(j), max(A(j)/2,1), tg)
               tg.subcode = 0
               tg.charge = 7
            else
!                      charge is not used so rough
               call cmkptc(kgnuc, A(j), max(A(j)/2,1), tg)
            endif
            call cgetXsInterface(pj, tg, xs)
            sum = sum + xs*portion(j)
         enddo
         xsa(i) =  sum
         E = E*10.0d0**dE
      enddo
      end   subroutine computeXS
      end       module modgetXs


      program main
      use   modgetXs
      use   modsibyllXs
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
      record /ptcl/ pj

      integer:: i, j
      real(8):: xs( nebin)
      real(8):: E, temp
      integer:: nela(1)
      integer:: pjA, pjZ, kpj
      
      write(0,*) 'Enter projectile '
      write(0,*) ' p->1; pi->2; K->3; A->4; 0->stop'
      read(*,*)  kpj

      if( kpj >= 1 .and. kpj <= 4) then
         if(kpj ==  4) then
            write(0,*) ' Enter proj. A, Z (intger)'
            read(*,*)  pjA, pjZ
         endif
      elseif( kpj == 0) then
         stop
      else
         write(0,*) ' input=',kpj, ' invalid'
         stop
      endif
      write(0,*)
     * "Enter target A ( or A's for compound/mixture target) with",
     * "  / at last (<=15)"
      write(0,*) 
     *  ' 0/ will be Air (sibyll special)'
      A(:) = 0.
      read(*,*) A(:)
      nela = minloc(A(:))
      nel = nela(1) -1
      if( nel == 0 ) then
         nel = 1
      endif
      if( nel == 1 ) then
         portion(nel) = 1.
      else
         write(0,*) "Enter relative portion of A's"
         read(*,*) portion(1:nel)
      endif

      temp = sum(portion(1:nel))
      portion(:) = portion(:)/temp

      call cgetXsIni
      ! make proton
      if( kpj == 1 ) then
         call cmkptc(knuc, -1, 1, pj)
      elseif( kpj == 2 ) then
         call cmkptc(kpion, -1, 1, pj)
      elseif( kpj == 3 ) then
         call cmkptc(kkaon, -1, 1, pj)
      elseif( kpj == 4) then
         call cmkptc(kgnuc, pjA, pjZ, pj)
      else
         stop 'strage '
      endif

      call computeXS(pj, xs)
!         output
      E= E1
      write(*,'(a,i2,i4,i3)') '# pj=',pj.code, pj.subcode, pj.charge
      write(*,'(a, 15(i4,f6.3))') '# tg=',(A(i), portion(i), i=1,nel)
      write(*,'(a, l)') '# Sibyll XS was used=',sibyllXsUsed
      do i = 1, nebin
         write(*,'(1p, 4g13.4 )')  E, xs(i)
         E = E*10.d0** dE
      enddo
      
      end program main
