c          cxyz2prim:  xyz to primary system coord. conversion
c          cxyz2primD: xyz to primary system for Direction cos. 
c
      subroutine cxyz2prim(base, a, b)
      implicit none
c
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

c                                  origin of primary system is the
c                                  origin of this deepest detector
      record /coord/ base ! base detector coord. whose origin is the
                          ! origin of 1ry system.
      record /coord/ a   ! input.  coord. in 'xyz'
      record /coord/ b   ! output. transformed coord. in 'prim'

      real(8):: temp(3)
      temp(:) = a.r(:) - base.r(:)
      b.r(:) = matmul(Txyz2prim(:,:), temp)
      b.sys = 'prim'
c  old one (<= v7.637)
c      record /coord/ tempa
c       coord in "xyz"   from the origin of det.
c       tempa.r(1) = a.r(1) - base.r(1)
c       tempa.r(2) = a.r(2) - base.r(2)
c       tempa.r(3) = a.r(3) - base.r(3)
c       call cscalerProd(tempa, Xprimary, b.r(1))
c       call cscalerProd(tempa, Yprimary, b.r(2))
c       call cscalerProd(tempa, Zprimary, b.r(3))
c       b.sys = 'prim'
       end
c      -----------------------------------
       subroutine cxyz2primD(a, b)
      implicit none
c
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

       record /coord/a, b
       real(8):: temp(3)
       temp(:) = matmul(Txyz2prim(:,:), a.r(:))
       b.r(:) = temp(:)
       b.sys = 'prim'
c        old version (<= 7.637)
c       record /coord/temp
       
c          b can be a

c       call cscalerProd(a, Xprimary, temp.r(1))
c       call cscalerProd(a, Yprimary, temp.r(2))
c       call cscalerProd(a, Zprimary, temp.r(3))
c       b = temp
c       b.sys = 'prim'
       end

      subroutine cprim2xyz(base, a, b)
      implicit none
c           inverse of xyz2prim
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"


c                                  origin of base detector
      record /coord/ base ! base detector coord. whose origin is the
                          ! origin of 1ry system.
      record /coord/ a   ! input.  coord. in 'prim'
      record /coord/ b   ! output. transformed coord. in 'xyz'

      real(8):: temp(3)
      temp(:) = matmul(Tprim2xyz(:,:), a.r(:))
      b.r(:) = temp(:) + base.r(:)
      b.sys = 'xyz'
      end
c      -----------------------------------
       subroutine cprim2xyzD(a, b)
      implicit none
c
#include  "Zcoord.h"
#include  "Zobs.h"
#include  "Zpos.h"
#include  "Zmagfield.h"
#include  "Zobsv.h"

       record /coord/a, b
       real(8):: temp(3)
       temp(:) = matmul(Tprim2xyz(:,:), a.r(:))
       b.r(:) = temp(:)
       b.sys = 'xyz'
       end
