c    csetPos:  use only xyz.
c    csetPos2:  use input height and depth.
c
c       set position information for a given xyz
c       location: input/output.    coord part of location is input.
c     
      subroutine csetPos(location)
c
      implicit none
#include  "Zobs.h"
#include  "Zcoord.h"
#include  "Zpos.h"
#include  "Zearth.h"
c
      record /position/ location
      real*8 cvh2thick
      character*70 msg 
c
      if(location.xyz.sys .ne. 'xyz') then
         write(msg, *) ' error coord. sys to csetPos=', location.xyz.sys
         call cerrorMsg(msg, 0)
      endif
      location.radiallen = 
     *      sqrt(location.xyz.r(1)**2 + location.xyz.r(2)**2 +
     *      location.xyz.r(3)**2)      
      location.height = location.radiallen - Eradius
      location.depth = cvh2thick(location.height)
      end
c     --------------------------------------
      subroutine csetPos2(h, d, location)
c     --------------------------------------
c
      implicit none
c----      include 'Zobs.h'
#include  "Zobs.h"
c----      include 'Zcoord.h'
#include  "Zcoord.h"
#include  "Zpos.h"
c----      include './Atmosphere/Zearth.h'
#include  "Zearth.h"
c
      real*8 h, d
      record /position/ location
c
      location.height = h
      location.radiallen = h + Eradius
      location.depth = d
      end
