#include "ZsubstRec.h"
c            treat interaction of MovedTrack
c
      subroutine cinteraction
      use modXsecMedia
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zevhnv.h"
#include  "Zincidentv.h"
#include  "Zmass.h"


      integer i
      real*8 Ein1, Ein2, Eout, dEabs1, deabs2, dErel1, dErel2
      real*8  dErel, dEabs, Ein

c
c          used to judge if user hook should be called 
c          after MovedTrack interacted.
c
      integer neverNEP/0/,  neverE/0/,  neverG/0/
      save  neverNEP, neverE, neverG
      integer never
      integer stackpos
      save never
      integer icon
      integer,parameter::loopmax=100
      integer:: loopc



cc      record /ptcl/ fragA(maxHeavyMassN),  nonIntNucA(maxHeavyMassN)
cc      integer noOfFrag, noOfNonIntN
c
c      record /track/aTrack
c
c   **  ptcl stacking is done in each subroutine; should be changed
c           (except for hadronic interactions)
c       logic of employing events satisfying some conditions only 
c
c        generate 1 event ; data is in PWork(:)
c        call chookNEPInt(neverNEP)  ! the user may give 5 to neverNEP
c                                  ! to discard the current event
c        never = neverNEP
c        
c           
c

      loopc = 0
      do while (loopc < loopmax )
!          try until desired event is generated
!          (mainly for multiple production)
         loopc = loopc + 1
         Nproduced = 0

c
cc    assume MovedTrack is not changed in interaction routine
c     but may be added asflag by chookEing if it is elec.
c      (in the case of Job ='newskel' )
c     
c
         if(MovedTrack.p.code .eq. kelec) then
            call cinteElec
         elseif(MovedTrack.p.code .eq. kphoton) then
            call cintePhoton
         else
            call cinteNEP
            if(IntInfArray(ProcessNo).process .eq. 'coll') then
               MovedTrack.pos.colheight = MovedTrack.pos.height
            endif
         endif

         if(MovedTrack.p.code .eq. kelec) then
            if(neverE .ne. 1) then
               call chookEInt(neverE)
               never = neverE
            endif
         elseif(MovedTrack.p.code .eq. kphoton) then
            if(neverG  .ne. 1)  then
               call chookGInt(neverG)
               never = neverG
            endif
         else
            if(neverNEP .ne. 1) then
               call chookNEPInt(neverNEP)
               never = neverNEP
            endif
         endif
         if( never /= 5) exit
         never = 0
      enddo   ! end of while;   
      if(btest(Eabsorb(1), BitEconsv-1) ) then
         if(IntInfArray(ProcessNo).process .eq. 'coll' .or.
     *        IntInfArray(ProcessNo).process .eq. 'photop' .or.
     *        IntInfArray(ProcessNo).process .eq. 'munuci' ) then

c                                    last one not used yet
            call chookEabsorbC( MovedTrack, Nproduced,  Pwork, 0)
c               what is being done below is almost the same as
c               done above call.
            Ein1 = MovedTrack.p.fm.p(4)  
     *           + masn*(TargetNucleonNo-TargetProtonNo) +
     *           masp*TargetProtonNo
            Ein2 = MovedTrack.p.fm.p(4) + masp
            Eout = 0.
            do i = 1, Nproduced
               Eout = Eout + Pwork(i).fm.p(4)
            enddo

            dEabs1 = Eout- Ein1
            dErel1 = Eout/Ein1 -1.0
            dEabs2 = Eout- Ein2
            dErel2 = Eout/Ein2 -1.0
            if( abs(dErel1) .lt. abs(dErel2)) then
               dErel=dErel1
               dEabs =dEabs1
               Ein = Ein1
            else
               dErel=dErel2
               dEabs =dEabs2
               Ein = Ein2
c                 no mass case in Eout
               Ein1 = MovedTrack.p.fm.p(4)
               dEabs1 = Eout- Ein1
               dErel1 = Eout/Ein1 -1.0
               if(abs(dEabs1) .lt. abs(dEabs) ) then
                  dErel = dErel1
                  Ein = Ein1
                  dEabs = dEabs1
               endif
            endif
            if( abs(dErel) .gt.  0.1 .or.
     *           abs(dEabs) .gt.  1.e5 ) then
               write(0,*) " code=",MovedTrack.p.code
               write(0,*) " chg=",MovedTrack.p.charge
               write(0,*) ' Moved E=',MovedTrack.p.fm.p(4)
               write(0,*) ' Ein =', Ein, ' Eout=',Eout
               write(0,*) ' Rerr =', Eout/Ein -1.0
               write(0,*) ' dEabscol= ',dEabs
               write(0,*) 'ActiveModel=', ActiveMdl
            endif
         else
c              possible process; compton, mscat, bscat,
c              anihi, decay, photoe, brems, pair cohs
            Ein = MovedTrack.p.fm.p(4)
            if(IntInfArray(ProcessNo).process .ne. 'decay' .and.
     *           IntInfArray(ProcessNo).process .ne. 'brems' .and.
     *           IntInfArray(ProcessNo).process .ne. 'pair'  .and.
     *           IntInfArray(ProcessNo).process .ne. 'cohs' )  then
               Ein = Ein + masele
            endif
            if(Ein .gt. MovedTrack.p.mass) then
               Eout = 0.
               do i = 1, Nproduced
                  Eout = Eout + Pwork(i).fm.p(4)
               enddo
               dEabs = Eout- Ein
               dErel = Eout/Ein -1.0
               if( abs(dErel) .gt. 0.2 )  then
c            if( abs(dEabs) .gt. 1.e5) then
                  if( abs(dEabs) .gt. 1.e5 ) then
                     write(0,*) '****************************'
                  else
                     write(0,*) '----------------------------'
                  endif
                  write(0,*) 'proc=', IntInfArray(ProcessNo).process
                  write(0,*) 'code=',MovedTrack.p.code, ' charge=',
     *                 MovedTrack.p.charge, ' E=',Ein
                  write(0,*) 'dEabs= ', dEabs, dErel, Nproduced
                  do i = 1, Nproduced
                     write(0,*) i, Pwork(i).code, Pwork(i).fm.p(4)
                  enddo
               endif
            endif
         endif
      endif
c///////////////////////      

      if(OneDim .eq. 0) then
c            3 dimensional
c                 stack the leading ptcl  first (to save stack area)
         call cmovePtcl3(MovedTrack, Pwork, Nproduced, Nstacked)
      else
         MovedTrack.vec = IncidentCopy.vec
         call cmovePtcl1(MovedTrack, Pwork, Nproduced, Nstacked)
      endif


      if(never .eq. 0 .or. never .eq. 1 ) then
c          user may set never=3 
      elseif(never .eq. 3) then
c          don't follow this and  child; reset stackpos
         call cgetCurrentStackpos(stackpos)
         stackpos=stackpos-Nstacked
         call cresetStackpos(stackpos)
      elseif(never .eq. 4) then
c             discard this event generated by the current primary
c             clear stack
         call cinitStack
      else
         call cerrorMsg('return value from chookE,G,NEPInt wrong', 1)
         write(0,*)  ' never=', never
         stop
      endif

      end
c          following is remnant of never=2 and ad-hoc model
c          when chookNEPInt is called before push is called.
c      The reason that we put chookNEPInt interface after push
c      is to have easy interface for skeleton making
c        
c      elseif(never .eq. 2) then
c              save only fragments and non interacting nucleons
c         if(MovedTrack.p.code .eq. kgnuc ) then
cc               get fragment and non interacting nuc.
c            call cqHvyIntF(fragA, noOfFrag)
c            call cqHvyIntNIN(nonIntNucA, noOfNonIntN)
cc
c            if(OneDim .eq. 0) then
c                call cmovePtcl3(MovedTrack, fragA, noOfFrag)
c                call cmovePtcl3(MovedTrack, nonIntNucA, noOfNonIntN)
c             else
c                MovedTrack.vec = IncidentCopy.vec
c                call cmovePtcl1(MovedTrack, fragA, noOfFrag)
c                call cmovePtcl1(MovedTrack, nonIntNucA, noOfNonIntN)
c             endif
c          endif
c
c     ************************************
c          move partcles in a given array to stack
c          3 dimensional case.

      subroutine  cmovePtcl3(iTrack, pw, n, npush)
      implicit none
c                put n ptcls in pw into stack.
c          if ThinSampling, 
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /ptcl/ pw(n)
      integer npush   ! output. actual number of ptcls put in stack.
                   ! in case of ThinSampling, this may be <= Nproduced. 

      record /track/ aTrack  
      integer i
      integer loc1
      integer nact


      aTrack = iTrack
      npush = 0
      call cgetCurrentStackPos(loc1)  ! upto loc1 is already filled 

      do i =  n, 1, -1          ! move leading ptcl first
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif

c               reset direction cos and related stuffs
         call cresetDirec(aTrack)


#if LABELING == 1
c
c              whennever an interaction occur,  update labelcounter
c             if info>0, clear the timer and infor counters.
c
         if(aTrack.info .gt. 0) then
ccc               aTrack.info = 0
ccc               aTrack.t = 0.
         endif
         Labelcounter = Labelcounter + 1
         aTrack.label = Labelcounter
#elif LABELING == 2
c            the above simple counter may be replaced by the
c            next sophisticated one. 
c            the same one is in the 1dim mode move routine below.
c
         call ctrickycount(iTrack, aTrack, pw, i)
c
#endif
         npush = npush + 1
         call cpush(aTrack)
      enddo 
      if(ThinSampling .and. npush .ge. 2 ) then
c         if(ThinSampling .and. npush .ge. 2  .and.
c     *   IntInfArray(ProcessNo).process .ne. 'photop') then
         call cthinStack(loc1+1, npush, iTrack, nact)
c               among npush from loc1+1, nact is accepted
c               adjust npush
         npush = nact
      endif
      end
      subroutine cthinStack(stackloc, n, iTrack, nout)
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zstackv.h"
c 
      integer stackloc  ! first loc of stack where tracks of current int.
      integer n
      record /track/ iTrack  ! input. incident ptcl. of the interaction
      integer nout

      call cthinning(stack(stackloc), n, iTrack, nout)
      call cresetStackPos(stackloc-1+nout)
      end




#if LABELING == 2
c       ************************************
c             This routine updates label counters.
c          but for the survival particle form brems and knock-on
c          the label counter is not updated. 
c          For those ptcl with info > 0, timer and info counters
c          are cleared. 
      subroutine ctrickycount(iTrack, aTrack, pw, i)
      implicit none
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /track/ aTrack  ! input/output. i-th  secondary track 
      record /ptcl/ pw(*)    ! input.  secondary pool
      integer i              ! input.  i-th secondary (index)

      logical reset

      reset = .true.

      if( iTrack.pos.height .gt. 40.d3 ) then
         if(IntInfArray(ProcessNo).process .eq. 'brems' ) then
c             for brem, electron has the same label as the incident
            if( aTrack.p.fm.p(4) .lt. iTrack.p.fm.p(4)*0.8) then
               aTrack.label = iTrack.label
               reset = .false.
            endif
         elseif(IntInfArray(ProcessNo).process .eq. 'knock' .or.
     *        IntInfArray(ProcessNo).process .eq. 'mscat' .or.
     *         IntInfArray(ProcessNo).process .eq. 'bscat' ) then
c                for the knock-on, survival particle has the same
c                label.
            if(iTrack.p.code .ne. kelec  .or.
     *           iTrack.p.charge .ne. -1) then
c                     knockon by p,mu,pi..e+ (not by e-)
               if(aTrack.p.code .ne. kelec) then
c                       survival one has the same label
                  aTrack.label = iTrack.label
                  reset = .false.
               endif
            else
c                  electron; make the higher one has the same label
               if(pw(1).fm.p(4) .gt. pw(2).fm.p(4)) then
                  if(i .eq. 1) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               else
                  if(i .eq. 2) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               endif
            endif                     
         endif
      endif
      if(reset) then
         Labelcounter = Labelcounter +1
         aTrack.label = Labelcounter
cc         aTrack.t = 0.          ! timer reset
cc         aTrack.info = 0        ! cross counter reset
      endif
      end
#endif
c     ************************************
c          move partcles in a given array to stack
c          1 dimensional case.

      subroutine  cmovePtcl1(iTrack, pw, n, npush)
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"


      integer n
      record /track/ iTrack   ! input. incident track
      record /ptcl/ pw(n)
      integer  npush   !  output.  actuall number of ptcls put in stack.
      real*8 temp, p

      integer i
      
      record /track/ aTrack 
      integer loc1
      integer nact

      aTrack = iTrack

      call cgetCurrentStackPos(loc1)

      do i =  n, 1, -1          ! move leading ptcl last
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif
c            see if angle of particle is larger than a lmit
         call cscalerProd(aTrack.p.fm.p, DcAtObsXyz, temp)
         call cpxyzp(aTrack.p.fm, p)
         if(p .gt. 0.) then
            temp = temp/p
         else
            temp = 1.
         endif
         if(temp .gt. BackAngLimit)  then
c              only take some limitted angle particles
c            call cresetMom(aTrack)  which is
            aTrack.p.fm.p(1) = p * aTrack.vec.w.r(1)
            aTrack.p.fm.p(2) = p * aTrack.vec.w.r(2)
            aTrack.p.fm.p(3) = p * aTrack.vec.w.r(3)

            call cgetZenith(aTrack, aTrack.vec.coszenith)


#if LABELING == 1
c                  whennever secondary particles are generated,
c               each of them get an updated label cocunter
c               if the particle has crossed the highest level
c               (info > 0),  timer and info counter is cleared
c
            if( aTrack.info .gt. 0) then
ccc                  aTrack.info = 0
cc                  aTrack.t = 0.
            endif
            Labelcounter = Labelcounter + 1
            aTrack.label = Labelcounter
#elif LABELING == 2
c                   this may be used if a tricky count is needed
c               in stead of above  counting
            call ctrickycount(iTrack, aTrack, pw, i)
#endif
            npush = npush + 1  
            call cpush(aTrack)
         endif
      enddo
      if(ThinSampling .and. npush .gt. 0 ) then
         call cthinStack(loc1+1, npush, iTrack, nact)
         npush = nact
      endif
      end

c     ****************************************************************
      subroutine cqIntePtcl(ptclA, num)
      implicit none
c          inquire the particle information that made interactions
c        to produce secondary particles.
c        If "MovedTrack" is a heavy,  ptclA will get interacting nucleons
c        otherwise, ptclA will have MovedTrack.p itself.
c
c           
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"

      record /ptcl/ ptclA(*)   ! output. interacted particles. max size
                               ! should be maxHeavyMassN (= 56 =Fe)
      integer num              ! output. number of ptcls in ptclA
c
c
cc      if(MovedTrack.p.code .ge. kdeut .and. 
cc     *    MovedTrack.p.code .le. khvymax ) then
      if( MovedTrack.p.code .eq. kgnuc ) then
         call cqHvyIntIN(ptclA, num)
      else
         num = 1
#ifdef SUBSTREC
         ptclA(1) = MovedTrack.p
#else
         ptclA(1).fm.p = MovedTrack.p.fm.p
         ptclA(1).mass = MovedTrack.p.mass
         ptclA(1).code = MovedTrack.p.code
         ptclA(1).subcode = MovedTrack.p.subcode
         ptclA(1).charge = MovedTrack.p.charge
#endif
      endif
      end

