#!/bin/bash
SeeAtmosModel () {
 source setarch.sh
 NRL=`nm $COSMOSTOP/lib/$ARCH/libcosmos.a | grep  cnrlgendata | awk 'NR>1 {exit};{print $1}'`
 if [ -z $NRL ]; then
   return 0
 else
   return 1
 fi
}
ShowAtmosModel() {
    SeeAtmosModel
    if [ $? -eq 0 ]; then
	echo "Standard atmosphere model is now usable"
	return 0
    else
	echo "NRL atmosphere model is now usable"
	return 1
    fi
}


UsageStandAtmos () {
    cat <<EOF
   Narmally AtmosFile in $HPARAM of the param file should be blank
   and the current atmospheric model must be the standard as
   specified
   #define ATMOSPHERE  2
   in $COSMOSTOP/cosmos/Zcondc.h.   The data used in the 
   default standard atmosphere can be seen in
   $COSMOSTOP/Data/Atmos/tdatmos1.d
EOF
    SeeAtmosModel
    if [ $? -eq 0 ]; then
	echo "** The current atmoshere model is standard one ** "
    else
	echo "** However, the atmosphere is the NRL-model **"
    fi
    return
}

UsageNRLAtmos () {
    cat <<EOF
   To be able to use the NRL time/place dependent atmosphere
   model, the libray must be made after setting
   #define ATMOSPHERE  3
   in $COSMOS/cosmos/Zcondc.h
   If the library is ready, to use the NRL model, give
    1) NRL_period
   or
    2) AtmosFile
   in the  param file ($HPARAM) of your application.
   The format is
  
     NRL_period=day1, day1, hour1, hour2

   where day1, day2: 1~365 (1 is Jan.1 365 Dec.31).
   if day1 > day2, the period is straddling Dec. to Jan.

   hour1, hour2: 0~23 (0 is midnight 12 noon) 
   They specify  hours in each day. 
   If hour1 > hour2, the hours straddle the midnight.

   If AtmosFile is given, NRL_period is neglectd.
   It is nunderstood as the path  to a file where the NRL
   data is written. 
     $COSMOSTOP/Data/Atmos/NRLAtmosWholeYear.d
    and
     $COSMOSTOP/Data/Atmos/NRLAtmos.d
   are available.  The former is the  averge of the whole year.
   The latter is for night time in Jan to March.  Both for
   @ mdille part of Japan.
    
    The user can find some utilities in  $COSMSOS/Util/NRL 
    (Able to see the density, thickness, temperature for a
    some period, place  as a function  of height. 
    Also it is possible to make a  data file which can be 
    specified by AtmosFile.
    To make whole year average, 4~5 sec. may be needed.

    The location is spcified by LatitOfSite and LongitOfSite
    in the param file.
EOF
    SeeAtmosModel
    if [ $? -eq 0 ]; then
	echo "** However, the current atmoshere model is standard one ** "
    else
	echo "**The current  atmosphere is the NRL-model **"
    fi
    return
}

ToNRLAtmosModel (){
   awk '$1=="#define" && $2=="ATMOSPHERE" {$3=3};{print}' $COSMOSTOP/cosmos/Zcondc.h > temp$$
   mv  $COSMOSTOP/cosmos/Zcondc.h  $COSMOSTOP/cosmos/Zcondc.hSave 
   mv temp$$ $COSMOSTOP/cosmos/Zcondc.h 
  (cd $COSMOSTOP/; make clean; make )
  ShowAtmosModel
 }

ToSTDAtmosModel (){
   awk '$1=="#define" && $2=="ATMOSPHERE" {$3=2};{print}' $COSMOSTOP/cosmos/Zcondc.h > temp$$
   mv  $COSMOSTOP/cosmos/Zcondc.h  $COSMOSTOP/cosmos/Zcondc.hSave 
   mv temp$$ $COSMOSTOP/cosmos/Zcondc.h 
  (cd $COSMOSTOP/; make clean; make )
  ShowAtmosModel
}

ChangeAtmosModel() {
    ShowAtmosModel
    if [ $? -eq 0 ]; then
	echo "Do you want to use the NRL atmospheric model ?"
	echo "Enter y, if yes"
	read toNRL
	if [ -z $toNRL ]; then
	    exit
        fi
	if [ $toNRL == 'y' ]; then
	    ToNRLAtmosModel
        fi
    else
	echo "Do you want to use the standard atmospheric model ?"
	echo "Enter y, if yes"
	read toSTD
	if [ -z $toSTD ]; then
	    exit
        fi
	if [ $toSTD == 'y' ]; then
	    ToSTDAtmosModel
        fi
    fi
}


cat <<EOF
1) Show the usage of the standard atmosphere
2) Show the usage of the NRL time/place dependent atmosphere
3) See which atmospheric model is now usable
4) Change the atmospheric model

  Select the number  
EOF
read num
if [ -z $num ]; then
    exit
fi


if [ $num -eq 1 ]; then
  UsageStandAtmos
elif [ $num -eq 2 ]; then
  UsageNRLAtmos
elif [ $num -eq 3 ]; then
  ShowAtmosModel
elif [ $num -eq 4 ]; then
  ChangeAtmosModel
else
  echo your input $num invalid
fi
