c      ******************************
c        rho 0, +, - decay
       subroutine crhodc(vm, a, np)
c      ******************************
       implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
       record /ptcl/ vm, a(*)
       integer np,  icharge

       if(vm.charge .eq. 0) then
c               pi+ pi-
          call cmkptc(kpion, 0, 1, a(1))
          call cmkptc(kpion, 0, -1, a(2))
          call c2bdcy(vm, a(1), a(2))
          np = 2
       else
          call cmkptc(kpion, 0, 0, a(1))
	  icharge = vm.charge
          call cmkptc(kpion, 0, icharge, a(2))
          call c2bdcy(vm, a(1), a(2))
          np = 2
       endif
       end
c      ******************************
       subroutine comgdc(vm, a, np)
c      ******************************
       implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
       record /ptcl/ vm, a(*)
       integer np

       real*8 u
c         omega--->pi+ pi- pi0   : 88.8 %
c                  pi0 gamma:       8.5
c                  pi+ pi- :        2.7
          call rndc(u)
          if(u .lt. .888) then
              call c3pidc(vm, a, np)
          elseif(u .lt. .973) then
             call cmkptc(kpion, 0, 0, a(1))
             call cmkptc(kphoton, 0, 0, a(2))
             call c2bdcy(vm, a(1), a(2))
             np = 2
          else
c               pi+ pi-
             call cmkptc(kpion, 0, 1, a(1))
             call cmkptc(kpion, 0,-1, a(2))
             call c2bdcy(vm, a(1), a(2))
             np = 2 
          endif
        end

c    * ****************************      
        subroutine c3pidc(vm, a, np)
c    * ****************************      
        implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
        integer np
        integer icon, ntry
        record /ptcl/ vm, a(*)
        integer i
        real*8 w
        character*70  msg

        call cmkptc(kpion, 0, 1, a(1))
        call cmkptc(kpion, 0, 0, a(2))
        call cmkptc(kpion, 0, -1, a(3))
c             pi+ pi- pi0
        ntry = 0
        icon = 1
        do while( icon .ne. 0 .and. ntry < 200)
           call cnbdcy(3, vm.mass, a,  0, w, icon)
           ntry = ntry + 1
        enddo
        if(icon .ne. 0) then
           write(0, *) ' cnbdcy fails for omega 3 pi',
     *          'cms=',vm.mass, 'icon=',icon
           np=0
        else
           np=3
           do i = 1, np
              call cibst1(1, vm, a(i), a(i))
           enddo
c////////////
c           write(*,*) ' omega 3body '
c//////////////////
        endif
       end
       subroutine cphidc(vm, a, np)
        implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
        integer np

        record /ptcl/ vm, a(*)

        real*8  u
        integer ic, nx
        record /ptcl/pw 
        nx = 0
c            phai-->k+ k-      49.5 %
c                   k0l k0s 34.4
c                   rho pi      12.9 (rho+ pi-, rho- pi+, rho0 pi0)
c                   pi+ pi- pi0      1.9

          call rndc(u)
          if(u .lt. .495) then
             call cmkptc(kkaon, 0, 1, a(1))
             call cmkptc(kkaon, 0, -1, a(2))
             call c2bdcy(vm, a(1), a(2))
             np = 2
          elseif(u .lt. .839) then
             call cmkptc(kkaon, k0l, 0, a(1))
             call cmkptc(kkaon, k0s, 0, a(2))
             call c2bdcy(vm, a(1), a(2))
             np = 2
          elseif(u .lt. .968) then
             call rndc(u)
             ic=int(3.*u)-1
             call cmkptc(kpion, 0, ic, a(1))
             call cmkptc(krho, 0, -ic, a(2))
             call c2bdcy(vm, a(1), a(2))
c                  rho decay
             pw = a(2)
             call crhodc(pw, a(2), nx)
             np=nx+1
          else
             call c3pidc(vm, a, np)
          endif
        end
