c         single precision version
c         test kpolintpS, kpolintpSFE
c
c       implicit none
c       integer n
c       parameter (n = 20)
c       real(4):: xa(n), ya(n), x, y, error
c       integer i,  m
c 
c      do i = 1, n
c          xa(i) = i/3.d0
c          ya(i) = exp(xa(i))
c       enddo
c       m = 5   ! use m points around x.
c       do i =1, n
c          x = xa(i) - 0.2
c          call kpolintpSFE(xa, 1, ya, 1, n, m, x, y, error)
c          write(*, *) x, exp(x), y, error
c       enddo
c       end
      subroutine kpolintpSLogxyFE(xa, xstep, ya, ystep, nt, m,
     *  logxy,  x, y, error)
      implicit none
c        This is a front end for kpolintpS for which we must give
c     some few to several points around x. This manages such 
c     business automatically.  This version takes log of x and or y before
c     kpolintpS is called.  
c
      integer xstep ! input.   see below
      integer nt    ! input.   total number of points 
      integer m     ! input.   the number of points to be used
                    !          for interpolation. must be <=10.
      real(4):: xa(xstep, nt)  ! input. values of x-coordinate at xa(1, i)
                           !        (i=1, nt) are valid x data.
      integer ystep ! input.  see below
      real(4):: ya(ystep, nt)  ! input. values of y-coordinate at ya(1, i)
                           !       (i=1, nt) are valid y data.
      integer logxy   !   input.  1-->log(x) 2-->log(y) 3-->log(x),log(y)
      real(4):: x             ! input. x-value where an interpolated y
                           !        value is wanted
      real(4):: y             ! output. see above

      real(4):: error         ! output. estimated error
c -----------------------------------------------

      real(4):: logx(10), logy(10)      ! working array.
      real(4):: xx, yy

      integer  loc, k, i
      logical  kbitest
c          find location of  x  in xa
      call kwhereis(x, nt, xa, xstep,  loc)
      k = min(max(loc - (m-1)/2,1), nt+1-m) ! max of m points from k

      do  i = k, m+k-1
         if( kbitest(logxy,  1)) then
            if( xa(1, i) .gt. 0.) then
               logx(i-k+1) = log(xa(1,i))
               xx = log(x)
            else
c               if some of x is <= 0; we don't use log 
               call kpolintpSFE(xa, xstep, ya, ystep, nt, m,
     *           x, y, error)
               return           !  **************
            endif
         else
            logx(i-k+1) = xa(1,i)
            xx = x
         endif
         if( kbitest(logxy, 2)) then
            if( ya(1, i) .gt. 0.) then
               logy(i-k+1) = log(ya(1,i))
            else
c               if some of y is <= 0; we don't use log 
               call kpolintpSFE(xa, xstep, ya, ystep, nt, m,
     *           x, y, error)
               return           !  **************
            endif
         else
            logy(i-k+1) = ya(1,i)
         endif
      enddo
      call kpolintpS(logx, 1, logy, 1, m, xx, yy, error)
      if( kbitest(logxy, 2) ) then
         y = exp(yy)
      else
         y = yy
      endif
      end
      subroutine kpolintpSLogFE(xa, xstep, ya, ystep, nt, m,
     *     x, y, error)
      implicit none
c        This is a front end for kpolintpS for which we must give
c     some few to several points around x. This manages such 
c     business automatically.  This version takes log of y before
c     kpolintpS is called.  
c
      integer xstep ! input.   see below
      integer nt    ! input.   total number of points 
      integer m     ! input.   the number of points to be used
                    !          for interpolation. must be <=10.
      real(4):: xa(xstep, nt)  ! input. values of x-coordinate at xa(1, i)
                           !        (i=1, nt) are valid x data.
      integer ystep ! input.  see below
      real(4):: ya(ystep, nt)  ! input. values of y-coordinate at ya(1, i)
                           !       (i=1, nt) are valid y data.
      real(4):: x             ! input. x-value where an interpolated y
                           !        value is wanted
      real(4):: y             ! output. see above
      real(4):: error         ! output. estimated error
c -----------------------------------------------

      real(4):: logy(10)      ! working array.
      real(4):: yy

      integer  loc, k, i
c          find location of  x  in xa
      call kwhereis(x, nt, xa, xstep,  loc)
      k = min(max(loc - (m-1)/2,1), nt+1-m) ! max of m points from k

      do  i = k, m+k-1
         if(ya(1,i) .gt. 0.) then
            logy(i-k+1) = log(ya(1,i))
         else
c            if some of y is <= 0; we don't use log 
            call kpolintpSFE(xa, xstep, ya, ystep, nt, m,
     *           x, y, error)
            return   !  **************
         endif
      enddo
      call kpolintpS(xa(1, k), xstep, logy, 1, m, x, yy, error)
      y = exp(yy)
      end
      subroutine kpolintpSFE(xa, xstep, ya, ystep, nt, m,  x, y, error)
      implicit none
c        This is a front end for kpolintpS for which we must give
c     some few to several points around x. This manages such 
c     business automatically.
c
      integer xstep ! input.   see below
      integer nt    ! input.   total number of points 
      integer m     ! input.   the number of points to be used
                    !          for interpolation. must be <=10.
      real(4):: xa(xstep, nt)  ! input. values of x-coordinate at xa(1, i)
                           !        (i=1, nt) are valid x data.
      integer ystep ! input.  see below
      real(4):: ya(ystep, nt)  ! input. values of y-coordinate at ya(1, i)
                           !       (i=1, nt) are valid y data.
      real(4):: x             ! input. x-value where an interpolated y
                           !        value is wanted
      real(4):: y             ! output. see above
      real(4):: error         ! output. estimated error


      integer  loc, k
c          find location of  x  in xa
      call kwhereis(x, nt, xa, xstep,  loc)
      k = min(max(loc - (m-1)/2,1), nt+1-m) ! max of m points from k
      call kpolintpS(xa(1, k), xstep, ya(1, k), ystep, m, x, y, error)
      end


      subroutine kpolintpS(xa, xstep, ya, ystep, n,  x, y, error)
c   
c      integer   n. input. number of points.   
c      real(4)::   xa(xstep, n). input.
c      real(4)::   ya(ystep, n). input.  function values at xa.
c      real(4)::   x.  input.
c      real(4)::   y.  output.  interepolated functon value at x.
c      real(4)::  error. output. estiamted rough error.
c
      implicit none
      integer n, xstep, ystep
      real(4):: xa(xstep, n), ya(ystep, n), x, y, error

      integer i, maxm, j
      parameter (maxm = 10)
      real(4)::  c(maxm), d(maxm), diff, difft

      integer ns,  m
      real(4):: h0, hp, w, den

      if(n .gt. maxm) then
         write(*, *) ' kpolintpS: use lesser number of points'
         stop
      endif
      ns = 1      
      diff = abs(x - xa(1, 1))
      do i = 1, n
         difft= abs(x - xa(1, i))
         if(difft .le. diff) then
            ns = i
            diff = difft
         endif
         c(i) = ya(1, i)
         d(i) = ya(1, i)
      enddo
      y = ya(1, ns)
      ns = ns-1
      do m = 1, n-1
         do i=1, n-m
            h0 = xa(1,i) -x
            hp = xa(1, i+m) - x
            w = c(i+1) - d(i)
            den = h0- hp
            if(den .ne. 0.) then
               den = w/den
               d(i) = hp*den
               c(i) = h0*den
            else
               write(0,*)  ' error in kpolintpS'
               write(0,*) 'x=',x
               write(0,'(10G12.4)' ) ' xa=', (xa(j,1), j=1, n)
               write(0,'(10G12.4)' ) ' ya=', (ya(j,1), j=1, n)
               stop
            endif
         enddo
         if(2*ns .le. n-m) then
            error = c(ns+1)
         else
            error = d(ns)
            ns = ns-1
         endif
         y = y + error
      enddo
      end

      subroutine kpolintpSeqs(x0, dx, ya, ystep, n,  x, y, error)
c   
c      integer   n. input. number of points.   
c      real(4)::   x0. input. x0, x0+dx, x0+2dx, ...x0+(n-1)dx
c                          are given data points
c      real(4)::   ya(ystep,n)  input.  function values at x0,..
c      real(4)::   x.  input.
c      real(4)::   y.  output.  interepolated functon value at x.
c      real(4)::  error. output. estiamted rough error.
c
      implicit none
      integer n,  ystep
      real(4):: x0,  ya(ystep, n), x, y, error, dx

      integer i, maxm
      parameter (maxm = 10)
      real(4)::  c(maxm), d(maxm), diff, difft

      integer ns,  m
      real(4):: h0, hp, w, den
      integer p, q
      real(4):: xa
      xa(p, q) = (q-1)*dx + x0

      if(n .gt. maxm) then
         write(*, *)
     *    ' kpolintpSeqs: use lesser number of points'
         stop
      endif
      ns = 1      
      diff = abs(x - xa(1, 1))
      do i = 1, n
         difft= abs(x - xa(1, i))
         if(difft .le. diff) then
            ns = i
            diff = difft
         endif
         c(i) = ya(1, i)
         d(i) = ya(1, i)
      enddo
      y = ya(1, ns)
      ns = ns-1
      do m = 1, n-1
         do i=1, n-m
            h0 = xa(1,i) -x
            hp = xa(1, i+m) - x
            w = c(i+1) - d(i)
            den = h0- hp
            if(den .eq. 0.) then
               write(0,*) ' error in kpolintpSeqs'
               stop
            endif
            den = w/den
            d(i) = hp*den
            c(i) = h0*den
         enddo
         if(2*ns .le. n-m) then
            error = c(ns+1)
         else
            error = d(ns)
            ns = ns-1
         endif
         y = y + error
      enddo
      end
