      subroutine   csibyllXsAAir(IA, Epj, xs)
!       AAir cross-section by sibyll
      implicit none
      integer,intent(in):: IA ! projectile Mass # (2~56)
      real(8),intent(in):: Epj ! projectile total E (GeV)

      real(8),intent(out)::xs  ! x-section in mb for Air
!      since signuc_ini is not practical, we copy
!      data there  and compute xs each time without
!      making table 

!      NE=6 is log10 roots (/n) bins step 10^DA = 10.

!       56 is proj. mass # from 1 to 56.
      integer,parameter:: NE=6
      real(4):: SIGMA(NE,56), SIGQE(NE,56)
      real(4),parameter::AA(NE)=(/1.,2.,3.,4.,5.,6./)
      real(4),parameter:: AMIN=1., DA=1.

!      DATA AVOG /6.0221367E-04/
!      DATA ATARGET /14.514/               ! effective masss of air
C...Data on `inelastic-production' nucleus-air cross section
      integer:: J
      DATA (SIGMA(J, 2),J=1,6) /  392., 434., 507., 617., 739., 866./
      DATA (SIGMA(J, 3),J=1,6) /  459., 501., 579., 691., 819., 943./
      DATA (SIGMA(J, 4),J=1,6) /  493., 532., 608., 721., 853., 975./
      DATA (SIGMA(J, 5),J=1,6) /  589., 632., 716., 839., 986.,1122./
      DATA (SIGMA(J, 6),J=1,6) /  695., 746., 838., 974.,1125.,1275./
      DATA (SIGMA(J, 7),J=1,6) /  710., 759., 857., 986.,1141.,1292./
      DATA (SIGMA(J, 8),J=1,6) /  751., 808., 902.,1039.,1192.,1344./
      DATA (SIGMA(J, 9),J=1,6) /  794., 847., 944.,1082.,1241.,1395./
      DATA (SIGMA(J,10),J=1,6) /  808., 857., 958.,1095.,1248.,1411./
      DATA (SIGMA(J,11),J=1,6) /  808., 858., 958.,1094.,1255.,1409./
      DATA (SIGMA(J,12),J=1,6) /  856., 909.,1001.,1144.,1306.,1462./
      DATA (SIGMA(J,13),J=1,6) /  868., 916.,1016.,1166.,1324.,1486./
      DATA (SIGMA(J,14),J=1,6) /  913., 961.,1063.,1214.,1386.,1543./
      DATA (SIGMA(J,15),J=1,6) /  937., 995.,1101.,1240.,1411.,1573./
      DATA (SIGMA(J,16),J=1,6) /  998.,1037.,1157.,1304.,1474.,1644./
      DATA (SIGMA(J,17),J=1,6) /  991.,1044.,1154.,1310.,1472.,1647./
      DATA (SIGMA(J,18),J=1,6) / 1041.,1101.,1208.,1359.,1544.,1718./
      DATA (SIGMA(J,19),J=1,6) / 1094.,1151.,1255.,1431.,1614.,1785./
      DATA (SIGMA(J,20),J=1,6) / 1141.,1193.,1314.,1485.,1667.,1842./
      DATA (SIGMA(J,21),J=1,6) / 1165.,1222.,1341.,1498.,1694.,1880./
      DATA (SIGMA(J,22),J=1,6) / 1159.,1219.,1333.,1506.,1687.,1863./
      DATA (SIGMA(J,23),J=1,6) / 1211.,1265.,1381.,1553.,1738.,1918./
      DATA (SIGMA(J,24),J=1,6) / 1221.,1285.,1402.,1571.,1757.,1947./
      DATA (SIGMA(J,25),J=1,6) / 1245.,1314.,1429.,1595.,1792.,1993./
      DATA (SIGMA(J,26),J=1,6) / 1270.,1334.,1447.,1624.,1811.,2005./
      DATA (SIGMA(J,27),J=1,6) / 1251.,1314.,1431.,1603.,1790.,1984./
      DATA (SIGMA(J,28),J=1,6) / 1289.,1351.,1465.,1654.,1839.,2029./
      DATA (SIGMA(J,29),J=1,6) / 1412.,1482.,1617.,1796.,2003.,2204./
      DATA (SIGMA(J,30),J=1,6) / 1351.,1409.,1526.,1711.,1895.,2105./
      DATA (SIGMA(J,31),J=1,6) / 1361.,1422.,1548.,1734.,1932.,2132./
      DATA (SIGMA(J,32),J=1,6) / 1381.,1435.,1574.,1751.,1952.,2140./
      DATA (SIGMA(J,33),J=1,6) / 1400.,1466.,1593.,1767.,1971.,2173./
      DATA (SIGMA(J,34),J=1,6) / 1414.,1479.,1606.,1796.,1985.,2193./
      DATA (SIGMA(J,35),J=1,6) / 1425.,1503.,1621.,1800.,2008.,2203./
      DATA (SIGMA(J,36),J=1,6) / 1444.,1516.,1643.,1822.,2031.,2225./
      DATA (SIGMA(J,37),J=1,6) / 1460.,1529.,1655.,1844.,2042.,2246./
      DATA (SIGMA(J,38),J=1,6) / 1484.,1547.,1676.,1861.,2071.,2269./
      DATA (SIGMA(J,39),J=1,6) / 1494.,1557.,1700.,1886.,2085.,2291./
      DATA (SIGMA(J,40),J=1,6) / 1510.,1585.,1710.,1897.,2116.,2292./
      DATA (SIGMA(J,41),J=1,6) / 1532.,1594.,1724.,1922.,2116.,2317./
      DATA (SIGMA(J,42),J=1,6) / 1540.,1617.,1735.,1930.,2144.,2334./
      DATA (SIGMA(J,43),J=1,6) / 1559.,1627.,1764.,1944.,2158.,2363./
      DATA (SIGMA(J,44),J=1,6) / 1570.,1641.,1774.,1949.,2172.,2367./
      DATA (SIGMA(J,45),J=1,6) / 1587.,1651.,1784.,1983.,2187.,2396./
      DATA (SIGMA(J,46),J=1,6) / 1609.,1675.,1810.,1997.,2206.,2412./
      DATA (SIGMA(J,47),J=1,6) / 1611.,1688.,1814.,2011.,2236.,2436./
      DATA (SIGMA(J,48),J=1,6) / 1630.,1700.,1833.,2024.,2240.,2457./
      DATA (SIGMA(J,49),J=1,6) / 1645.,1717.,1843.,2047.,2251.,2474./
      DATA (SIGMA(J,50),J=1,6) / 1655.,1729.,1858.,2051.,2272.,2488./
      DATA (SIGMA(J,51),J=1,6) / 1668.,1742.,1875.,2076.,2288.,2504./
      DATA (SIGMA(J,52),J=1,6) / 1684.,1757.,1891.,2091.,2308.,2515./
      DATA (SIGMA(J,53),J=1,6) / 1697.,1773.,1908.,2103.,2328.,2544./
      DATA (SIGMA(J,54),J=1,6) / 1713.,1785.,1917.,2125.,2335.,2533./
      DATA (SIGMA(J,55),J=1,6) / 1726.,1803.,1939.,2131.,2355.,2570./
      DATA (SIGMA(J,56),J=1,6) / 1757.,1831.,1970.,2168.,2388.,2620./
C...Data on `quasi-elastic' nucleus-air cross section
      DATA (SIGQE(J, 2),J=1,6) /   41.,  39.,  54.,  99., 159., 229./
      DATA (SIGQE(J, 3),J=1,6) /   43.,  40.,  55., 101., 167., 238./
      DATA (SIGQE(J, 4),J=1,6) /   40.,  40.,  55., 102., 168., 243./
      DATA (SIGQE(J, 5),J=1,6) /   45.,  44.,  61., 113., 179., 262./
      DATA (SIGQE(J, 6),J=1,6) /   52.,  49.,  67., 121., 195., 278./
      DATA (SIGQE(J, 7),J=1,6) /   50.,  48.,  69., 121., 194., 276./
      DATA (SIGQE(J, 8),J=1,6) /   52.,  50.,  70., 125., 199., 282./
      DATA (SIGQE(J, 9),J=1,6) /   54.,  50.,  69., 126., 206., 289./
      DATA (SIGQE(J,10),J=1,6) /   53.,  50.,  70., 127., 204., 288./
      DATA (SIGQE(J,11),J=1,6) /   51.,  50.,  69., 125., 203., 285./
      DATA (SIGQE(J,12),J=1,6) /   52.,  51.,  70., 127., 210., 293./
      DATA (SIGQE(J,13),J=1,6) /   53.,  50.,  71., 129., 210., 293./
      DATA (SIGQE(J,14),J=1,6) /   52.,  53.,  72., 134., 212., 301./
      DATA (SIGQE(J,15),J=1,6) /   54.,  52.,  75., 135., 219., 306./
      DATA (SIGQE(J,16),J=1,6) /   57.,  56.,  76., 136., 222., 313./
      DATA (SIGQE(J,17),J=1,6) /   55.,  54.,  76., 137., 221., 311./
      DATA (SIGQE(J,18),J=1,6) /   59.,  55.,  79., 142., 223., 320./
      DATA (SIGQE(J,19),J=1,6) /   63.,  58.,  81., 143., 231., 323./
      DATA (SIGQE(J,20),J=1,6) /   63.,  60.,  82., 149., 237., 332./
      DATA (SIGQE(J,21),J=1,6) /   64.,  61.,  84., 150., 236., 333./
      DATA (SIGQE(J,22),J=1,6) /   62.,  61.,  84., 145., 237., 329./
      DATA (SIGQE(J,23),J=1,6) /   65.,  62.,  83., 149., 240., 341./
      DATA (SIGQE(J,24),J=1,6) /   64.,  61.,  84., 152., 244., 338./
      DATA (SIGQE(J,25),J=1,6) /   64.,  61.,  86., 153., 249., 343./
      DATA (SIGQE(J,26),J=1,6) /   66.,  64.,  88., 156., 251., 344./
      DATA (SIGQE(J,27),J=1,6) /   65.,  61.,  84., 155., 244., 345./
      DATA (SIGQE(J,28),J=1,6) /   65.,  63.,  87., 153., 249., 347./
      DATA (SIGQE(J,29),J=1,6) /   72.,  64.,  91., 161., 260., 362./
      DATA (SIGQE(J,30),J=1,6) /   67.,  63.,  90., 157., 252., 355./
      DATA (SIGQE(J,31),J=1,6) /   67.,  66.,  90., 161., 256., 353./
      DATA (SIGQE(J,32),J=1,6) /   68.,  65.,  89., 161., 256., 355./
      DATA (SIGQE(J,33),J=1,6) /   69.,  66.,  89., 161., 257., 360./
      DATA (SIGQE(J,34),J=1,6) /   69.,  63.,  89., 160., 262., 359./
      DATA (SIGQE(J,35),J=1,6) /   68.,  65.,  90., 166., 259., 360./
      DATA (SIGQE(J,36),J=1,6) /   68.,  66.,  92., 167., 257., 362./
      DATA (SIGQE(J,37),J=1,6) /   71.,  67.,  92., 166., 261., 365./
      DATA (SIGQE(J,38),J=1,6) /   70.,  67.,  92., 167., 265., 367./
      DATA (SIGQE(J,39),J=1,6) /   69.,  68.,  96., 163., 261., 370./
      DATA (SIGQE(J,40),J=1,6) /   71.,  67.,  92., 167., 266., 371./
      DATA (SIGQE(J,41),J=1,6) /   72.,  68.,  93., 167., 267., 373./
      DATA (SIGQE(J,42),J=1,6) /   71.,  69.,  96., 167., 271., 370./
      DATA (SIGQE(J,43),J=1,6) /   72.,  70.,  95., 168., 265., 369./
      DATA (SIGQE(J,44),J=1,6) /   70.,  68.,  98., 170., 270., 372./
      DATA (SIGQE(J,45),J=1,6) /   72.,  69.,  97., 167., 272., 379./
      DATA (SIGQE(J,46),J=1,6) /   75.,  69.,  98., 173., 272., 370./
      DATA (SIGQE(J,47),J=1,6) /   73.,  70.,  93., 170., 275., 377./
      DATA (SIGQE(J,48),J=1,6) /   73.,  71.,  96., 170., 275., 379./
      DATA (SIGQE(J,49),J=1,6) /   75.,  72.,  96., 171., 275., 379./
      DATA (SIGQE(J,50),J=1,6) /   74.,  73.,  97., 174., 275., 380./
      DATA (SIGQE(J,51),J=1,6) /   73.,  68.,  97., 173., 281., 388./
      DATA (SIGQE(J,52),J=1,6) /   75.,  71.,  99., 175., 275., 390./
      DATA (SIGQE(J,53),J=1,6) /   75.,  71.,  98., 180., 279., 383./
      DATA (SIGQE(J,54),J=1,6) /   74.,  71.,  99., 177., 280., 386./
      DATA (SIGQE(J,55),J=1,6) /   75.,  71., 100., 179., 278., 394./
      DATA (SIGQE(J,56),J=1,6) /   76.,  70., 101., 175., 284., 390./

!      ASQS = 0.5*LOG10(1.876E+03*E0)
      real(4):: ASQS,  E0, S1, S2 
      integer:: JE, JA
      external QUAD_INT
      real(4):: QUAD_INT

      E0 = Epj/IA
!       s = (E0+M)^2-p0^2 ~ 2 E0 M ~ 1.876E0
!    log10(root(s)) is 
      ASQS = 0.5*LOG10(1.876*E0)  ! E0 in GeV/n
!      max ASQS=6 so max E0 ~ 10^12/1.876 GeV  =6* 10^20 eV
!            
      JE = MIN(INT((ASQS-AMIN)/DA)+1,NE-2)
      JA = IA
      S1 = QUAD_INT(ASQS, AA(JE),AA(JE+1),AA(JE+2),
     +     SIGMA(JE,JA),SIGMA(JE+1,JA),SIGMA(JE+2,JA))
      S2 = QUAD_INT(ASQS, AA(JE),AA(JE+1),AA(JE+2),
     +     SIGQE(JE,JA),SIGQE(JE+1,JA),SIGQE(JE+2,JA))
      xs  = S1 + S2
      end  subroutine csibyllXsAAir
